<?php

namespace App\Repositories\Master\Imagesize;

use DB;
use Helper;

class EloquentImagesize implements ImagesizeRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all banners
        * @param        : Request data
        * @return       : return all banners
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `m76_image_size`');
    }

    /**
        * Method name   : Create
        * @description  : Used for inserting banner
        * @param        : Request data
        * @return       : return created banner
    */
    public function create(array $attributes)
    {
		//Helper::notify_data($attributes,1,"NEW BANNER INSERTED SUCCESSFULLY",$attributes['txt_banner_name'],0,'2');
        return DB::table('m76_image_size')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating banner
        * @param        : Request data
        * @return       : return updated banner
    */
    public function update($id, array $attributes)
    {
        return DB::table('m76_image_size')->where('m76_image_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting banner
        * @param        : Request data
        * @return       : return deleted banner
    */
    public function delete($id)
    {
        return DB::table('m76_image_size')->where('m76_image_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single banner with id
        * @param        : Request data with banner id
        * @return       : return single banner
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `m76_image_size` WHERE m76_image_id = "'.$id.'"');
    }
	

    public function active($id)
    {
        return DB::update('UPDATE m76_image_size SET m76_status = case m76_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE  m76_image_id = "'.$id.'"');
    }



        public function getByType()
    {   
        return DB::select('SELECT * FROM `m76_image_size` WHERE m76_status=1 ');
    }

	/**
        * Method name   : Get by type
        * @description  : Used for getting single banner with id
        * @param        : Request data with banner id
        * @return       : return single banner
    */
    
		
}