<?php

namespace App\Repositories\Master\Events;

use DB;
use Helper;

class EloquentEvents implements EventsRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all news
        * @param        : Request data
        * @return       : return all news
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `news`');
    }

    /**
        * Method name   : Create
        * @description  : Used for creating news
        * @param        : Request data
        * @return       : return with created news
    */
    public function create(array $attributes)
    {
		Helper::notify_data($attributes,1,"NEW EVENT INSERTED SUCCESSFULLY",$attributes['m24_news_title'],0,'2');
        return DB::table('m24_news')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating news
        * @param        : Request data with news id
        * @return       : return with updated news
    */
    public function update($id, array $attributes)
    {
        return DB::table('m24_news')->where('m24_news_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting news
        * @param        : Request data with news id
        * @return       : return with deleted news
    */
    public function delete($id)
    {
        return DB::table('m24_news')->where('m24_news_id', $id)->delete();
    }

    /**
        * Method name   : Get By Id
        * @description  : Used for getting single news
        * @param        : Request data with news id
        * @return       : return with single news
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `news` WHERE NewsId = "'.$id.'"');
    }

    /**
        * Method name   : Active
        * @description  : Used for updating news status
        * @param        : Request data with news id
        * @return       : return with active status
    */
    public function active($id)
    {
        return DB::update('UPDATE m24_news SET m24_news_status = case m24_news_status when "ACTIVE" then "2"
         when "INACTIVE" then "1" end WHERE m24_news_id = "'.$id.'"');
    }

/**
        * Method name   : Get By Aff Id
        * @description  : Used for getting news by affiliate id
        * @param        : Request data with affiliate id
        * @return       : return with single news with affiliate id
    */
    public function getByAffId($id)
    {   
        return DB::select('SELECT * FROM `news` WHERE AffID = "'.$id.'"');
    }


}

