<?php

namespace App\Repositories\Master\Content;

use DB;
use Helper;

class EloquentContent implements ContentRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all static content
        * @param        : Request data
        * @return       : return all static content
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `static_content`');
    }

    /**
        * Method name   : Create
        * @description  : Used for creating all static content
        * @param        : Request data
        * @return       : return created static content
    */
    public function create(array $attributes)
    {
		Helper::notify_data($attributes,1,"NEW STATIC CONTENT INSERTED SUCCESSFULLY",$attributes['m10_staticcnt_title'],0,'2');
        return DB::table('m10_static_content')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating single static content
        * @param        : Request data with static content id
        * @return       : return updated static content
    */
    public function update($id, array $attributes)
    {
        return DB::table('m10_static_content')->where('m10_staticcnt_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting single static content
        * @param        : Request data with static content id
        * @return       : return deleted static content
    */
    public function delete($id)
    {
        return DB::table('m10_static_content')->where('m10_staticcnt_id', $id)->delete();
    }

    /**
        * Method name   : Get By Id
        * @description  : Used for getting single static content
        * @param        : Request data with static content id
        * @return       : return single static content
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `static_content` WHERE STCNT_ID = "'.$id.'"');
    }



    public function getByVar($id)
    {   
        return DB::select('SELECT * FROM `static_content` WHERE STCNT_VAR = "'.$id.'" AND STCNT_STATUS = "Active" LIMIT 1');
    }


    /**
        * Method name   : Active
        * @description  : Used for updating static content status
        * @param        : Request data with static content id
        * @return       : return updated static content
    */
    public function active($id)
    {
        return DB::update('UPDATE m10_static_content SET m10_staticcnt_status = case m10_staticcnt_status when "Active" then "InActive"
         when "InActive" then "Active" end WHERE m10_staticcnt_id = "'.$id.'"');
    }

}



