<?php

namespace App\Repositories\Master\Configuration;

use DB;
use Helper;

class EloquentConfiguration implements ConfigurationRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Set config
        * @description  : Used for updating admin config details 
        * @param        : Request data  
        * @return       : return to view with updated config
    */
    public function setAdminLogin(array $attributes)
    {
        return DB::select('CALL setadmin_login(
                 :m00_login_id,
                 :m00_username,
                 :m00_password, 
                 :m00_pinpassword
             )',$attributes);
    }


    public function setAdminLogin_twofa(array $attributes)
    {
        return DB::select('CALL setadmin_login_twofa(
                 :m00_login_id,
                 :m00_otpenable
             )',$attributes);
    }



    /**
        * Method name   : Get all
        * @description  : Used for getting all config
        * @param        : Request data
        * @return       : return all config
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `set_config`');
    }

    /**
        * Method name   : Create
        * @description  : Used for creating config
        * @param        : Request data
        * @return       : return with created config
    */
    public function create(array $attributes)
    {
		Helper::notify_data($attributes,1,"NEW CONFIG ADDED SUCCESSFULLY",$attributes['m00_name'],0,'2');
        return DB::table('m00_setconfig')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating config
        * @param        : Request data with config id
        * @return       : return with updated config
    */
    public function update($id, array $attributes)
    {
        return DB::table('m00_setconfig')->where('m00_id', $id)->update($attributes);
    }

    /**
        * Method name   : Update By Name
        * @description  : Used for updating config
        * @param        : Request data with config id
        * @return       : return with updated config
    */
    public function updateByName($name, array $attributes)
    {
        return DB::table('m00_setconfig')->where('m00_name', $name)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting config
        * @param        : Request data with config id
        * @return       : return with deleted config
    */
    public function delete($id)
    {
        return DB::table('m00_setconfig')->where('m00_id', $id)->delete();
    }

    /**
        * Method name   : Get By Id
        * @description  : Used for getting single config 
        * @param        : Request data with config id
        * @return       : return with single config details
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `set_config` WHERE SC_ID = "'.$id.'"');
    }

}


