<?php

namespace App\Repositories\Master\Banner;

use DB;
use Helper;

class EloquentBanner implements BannerRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all banners
        * @param        : Request data
        * @return       : return all banners
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `banner`');
    }

    /**
        * Method name   : Create
        * @description  : Used for inserting banner
        * @param        : Request data
        * @return       : return created banner
    */
    public function create(array $attributes)
    {
		//Helper::notify_data($attributes,1,"NEW BANNER INSERTED SUCCESSFULLY",$attributes['txt_banner_name'],0,'2');
        return DB::table('m47_banner')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating banner
        * @param        : Request data
        * @return       : return updated banner
    */
    public function update($id, array $attributes)
    {
        return DB::table('m47_banner')->where('m47_banner_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting banner
        * @param        : Request data
        * @return       : return deleted banner
    */
    public function delete($id)
    {
        return DB::table('m47_banner')->where('m47_banner_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single banner with id
        * @param        : Request data with banner id
        * @return       : return single banner
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `banner` WHERE BANNER_ID = "'.$id.'"');
    }
	



    public function getByIdAndAffi($id,$aff)
    {   
        return DB::select("SELECT * FROM `banner` WHERE BANNER_STATUS=1 AND BANNER_TYPE = ".$id." AND  AFFILIATE = ".$aff);
    }



   public function getByAffi($aff)
    {   
        return DB::select('SELECT * FROM `banner` WHERE AFFILIATE = "'.$aff.'"');
    }
    /**
        * Method name   : Active
        * @description  : Used for updating banner status
        * @param        : Request data with banner id
        * @return       : return banner with staus updated
    */
    public function active($id)
    {
        return DB::update('UPDATE m47_banner SET m47_banner_status = case m47_banner_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m47_banner_id = "'.$id.'"');
    }

	/**
        * Method name   : Get by type
        * @description  : Used for getting single banner with id
        * @param        : Request data with banner id
        * @return       : return single banner
    */
    public function getByType($id)
    {   
        return DB::select('SELECT * FROM `banner` WHERE BANNER_STATUS=1 AND BANNER_TYPE = '.$id);
    }


    /**
        * Method name   : Get by type and category
        * @description  : Used for getting single banner with id
        * @param        : Request data with banner id
        * @return       : return single banner
    */
    public function getByTypeCat($id,$catid)
    {   
        return DB::select('SELECT * FROM `banner` WHERE BANNER_STATUS=1 AND BANNER_TYPE = '.$id.' AND CATEGORY='.$catid);
    }
	
		
}