<?php

namespace App\Repositories\Master\Bank;

use DB;
use Helper;

class EloquentBank implements BankRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all banks
        * @param        : Request data
        * @return       : return all banks
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `bank`');
    }

    /**
        * Method name   : Create
        * @description  : Used for creating bank
        * @param        : Request data
        * @return       : return with created bank
    */
    public function create(array $attributes)
    {
		//Helper::notify_data($attributes,1,"NEW BANK INSERTED SUCCESSFULLY",$attributes['txt_bank_name'],0,'2');
        return DB::table('m01_bank')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating bank
        * @param        : Request data with bank id
        * @return       : return with updated bank
    */
    public function update($id, array $attributes)
    {
        return DB::table('m01_bank')->where('m01_bank_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting bank
        * @param        : Request data with bank id
        * @return       : return with deleted bank
    */
    public function delete($id)
    {
        return DB::table('m01_bank')->where('m01_bank_id', $id)->delete();
    }

    /**
        * Method name   : Get By Id
        * @description  : Used for getting single bank 
        * @param        : Request data with bank id
        * @return       : return with single bank details
    */
    public function getById($id)
    {   
        return  DB::select('SELECT * FROM `bank` WHERE BANK_ID = "'.$id.'"');
    }

    /**
        * Method name   : Active
        * @description  : Used for updating bank status
        * @param        : Request data with bank id
        * @return       : return with updated bank status
    */
    public function active($id)
    {
        return DB::update('UPDATE m01_bank SET m01_bank_status = case m01_bank_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m01_bank_id = "'.$id.'"');
    }

}


