<?php

namespace App\Repositories\Master\Assignmenu;

use DB;
use Helper;

class EloquentAssignmenu implements AssignmenuRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all assign menu
        * @param        : Request data
        * @return       : return all assign menu
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM `assign_menu` ORDER BY ASMENU_ORDER ASC');
    }

	/**
        * Method name   : Get all
        * @description  : Used for getting all assign menu
        * @param        : Request data
        * @return       : return all assign menu
    */
    public function getUserMenus()
    {
		return DB::select('SELECT * FROM `assign_menu` WHERE ROLE_TYPE="18" OR ROLE_TYPE="1" ORDER BY ASMENU_ORDER ASC');
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all assign menu
        * @param        : Request data
        * @return       : return all assign menu
    */
    public function getEmpMenus()
    {
		return DB::select('SELECT * FROM `assign_menu` WHERE ROLE_TYPE="10"  OR ROLE_TYPE="18" ORDER BY ASMENU_ORDER ASC');
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all parent assign menu
        * @param        : Request data
        * @return       : return all parent assign menu
    */
    public function getAllParent()
    {
        return DB::select('SELECT * FROM `assign_menu` WHERE ASMENU_PARENTID = -1 ORDER BY ASMENU_ORDER ASC');
    }

    /**
        * Method name   : Create
        * @description  : Used for inserting assign menu
        * @param        : Request data
        * @return       : return created assign menu
    */
    public function create(array $attributes)
    {
		Helper::notify_data($attributes,1,"NEW MENU INSERT SUCCESSFULLY",$attributes['m49_menu_name'],0,'2');
        return DB::table('m49_assign_menu')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating assign menu
        * @param        : Request data
        * @return       : return updated assign menu
    */
    public function update($id, array $attributes)
    {
        return DB::table('m49_assign_menu')->where('m49_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting assign menu
        * @param        : Request data
        * @return       : return deleted assign menu
    */
    public function delete($id)
    {
        return DB::table('m49_assign_menu')->where('m49_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single assign menu with id
        * @param        : Request data with assign menu id
        * @return       : return single assign menu
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM `assign_menu` WHERE ASMENU_ID = "'.$id.'"');
    }

    /**
        * Method name   : Active
        * @description  : Used for updating assign menu status
        * @param        : Request data with assign menu id
        * @return       : return assign menu with staus updated
    */
    public function active($id)
    {
        return DB::update('UPDATE m49_assign_menu SET m49_status = case m49_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m49_id = "'.$id.'"');
    }

}
