<?php

namespace App\Repositories\Master\AdminBank;

use DB;
use Helper;

class EloquentAdminBank implements AdminBankRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all
        * @description  : Used for getting all banks
        * @param        : Request data
        * @return       : return all banks
    */
    public function getAll()
    {
        return DB::select('SELECT * FROM company_bank_account');
    }

    /**
        * Method name   : Create
        * @description  : Used for creating bank
        * @param        : Request data
        * @return       : return with created bank
    */
    public function create(array $attributes)
    {
		Helper::notify_data($attributes,1,"ADMIN BANK ACCOUNT INSERTED SUCCESSFULLY",$attributes['m27_adminbank_accountno'],0,'2');
        return DB::table('m27_admin_bank')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating bank
        * @param        : Request data with bank id
        * @return       : return with updated bank
    */
    public function update($id, array $attributes)
    {
        return DB::table('m27_admin_bank')->where('m27_adminbank_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting bank
        * @param        : Request data with bank id
        * @return       : return with deleted bank
    */
    public function delete($id)
    {
        return DB::table('m27_admin_bank')->where('m27_adminbank_id', $id)->delete();
    }

    /**
        * Method name   : Get By Id
        * @description  : Used for getting single bank 
        * @param        : Request data with bank id
        * @return       : return with single bank details
    */
    public function getById($id)
    {   
        return DB::select('SELECT * FROM company_bank_account WHERE ADMINBANK_ID='.$id);
    }

    /**
        * Method name   : Active
        * @description  : Used for updating bank status
        * @param        : Request data with bank id
        * @return       : return with updated bank status
    */
    public function active($id)
    {
        return DB::update('UPDATE m27_admin_bank SET m27_adminbank_status = case m27_adminbank_status when "1" then "0"
         when "0" then "1" end WHERE m27_adminbank_id = "'.$id.'"');
    }
/**
        * Method name   : Get By User Id
        * @description  : Used for getting single bank using user id 
        * @param        : Request data with user id
        * @return       : return with single bank details
    */
    public function getByUserId($id)
    {   
        return  DB::select('SELECT * FROM company_bank_account WHERE USER_ID='.$id);
    }


}


