<?php

namespace App\Repositories\LeadSource;

use DB;

class EloquentLeadSource implements LeadSourceRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all LeadSource
        * @description  : Used for getting all LeadSource data 
        * @param        : Request data  
        * @return       : return all LeadSource data
    */
    public function getAll()
    {
        return DB::select("SELECT * FROM `m53_lead_source`");
    }

    /**
        * Method name   : Create
        * @description  : Used for inserting LeadSource 
        * @param        : Request data  
        * @return       : return with inserting LeadSource
    */
    public function create(array $attributes)
    {
        return DB::table('m53_lead_source')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating LeadSource 
        * @param        : Request data  
        * @return       : return with updating LeadSource
    */
    public function update($id, array $attributes)
    {
        return DB::table('m53_lead_source')->where('m53_source_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting LeadSource 
        * @param        : Request data  
        * @return       : return with deleting LeadSource
    */
    public function delete($id)
    {
        return DB::table('m53_lead_source')->where('m53_source_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single LeadSource data 
        * @param        : Request data  
        * @return       : return with single LeadSource
    */
    public function getById($id)
    {   
        return DB::select("SELECT * FROM `m53_lead_source` WHERE m53_source_id = ".$id."");
    }


}




