<?php

namespace App\Repositories\Fund;

use DB;

class EloquentFund implements FundRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get All
        * @description  : Used for getting all fund request
        * @param        : Request data  
        * @return       : return with all fund request
    */
    public function getAll()
    {
        return DB::select("SELECT * FROM `fund_request` WHERE FUNDREQ_TO=1 ORDER BY FUNDREQ_ID DESC");
    }



    public function getByAdminId($id)
    {
        return DB::select("SELECT * FROM `fund_request` WHERE FUNDREQ_TO=1 AND REFERRAL_ID = ".$id." ORDER BY FUNDREQ_ID DESC");
    }


    /**
        * Method name   : Wallet Transfer
        * @description  : Used for updating fund request status
        * @param        : Request data  
        * @return       : return with updated fund request status
    */
    public function walletTransfer(array $attributes)
    {
        return DB::SELECT('CALL wallettransfer(
                        :proc, 
                        :to_user_id,
                        :from_user_id,
                        :amount, 
                        :collected_amount,
                        :requesttype,
                        :balfor,
						:transtype,
                        :timelimit,
                        :defaultstatus,
                        :remark,
                        :collected_remark,
                        @status_code,
                        @status_msg)'
                        ,$attributes);
    }

    /**
        * Method name   : Store Wallet Transfer
        * @description  : Used for updating fund request status
        * @param        : Request data  
        * @return       : return with updated fund request status
    */
    public function storeWalletTransfer(array $attributes)
    {
        return DB::SELECT('CALL store_wallettransfer(
                    :proc, 
                    :to_user_id,
                    :from_user_id,
                    :amount, 
                    :collected_amount,
                    :requesttype,
                    :balfor,:transtype,
                    :timelimit,
                    :defaultstatus,
                    :remark,
                    :collected_remark,
                    @status_code,
                    @status_msg)'
                    ,$attributes);
    }


    /**
        * Method name   : Ledger Report
        * @description  : Used for getting ledger report
        * @param        : Request data  
        * @return       : return ledger report
    */
    public function ledgerReport(array $attributes)
    {
        return DB::select('CALL ledger(             
                :proc,:account,
                :transid,:userid,
                :fromdate,:todate,
                :noofrecords,:ledegerstatus,
                :descrip,@msg)',$attributes);
    }

    /**
        * Method name   : Get fund request to admin
        * @description  : Used for getting all fund request to admin
        * @param        : Request data  
        * @return       : return with all fund request to admin
    */
    public function getFundRqToAdmin($membercode)
    {
        return DB::select("SELECT * FROM fund_request WHERE FUNDREQ_TOWALLET!=3 AND FUNDREQ_TO=1 AND MEMBER_CODE='".$membercode."'");
    }

    /**
        * Method name   : Get withdraw request to admin
        * @description  : Used for withdraw request to admin
        * @param        : Request data  
        * @return       : return with all withdraw request to admin
    */
    public function getWdRqToAdmin($contact)
    {
        return DB::select("SELECT * FROM withdraw_request WHERE FUNDREQ_FOR_INCOME=3 AND FUNDREQ_TO=1 AND MEMBER_CONTACT=".$contact);
    }


     /**
        * Method name   : withdraw request
        * @description  : Used for getting withdraw request
        * @param        : Request data  
        * @return       : return withdraw request
    */
    public function withdraw_request(array $attributes)
    {
        return DB::select('CALL withdraw_request(:proc,
            :m23_user_bnkid,
            :m11_user_id,
            :tr32_wr_forincome,
            :tr23_fr_towallet,
            :tr23_fr_mode,
            :tr23_fr_utrno,
            :tr23_fr_amount,
            :tr23_fr_transid,
            :tr23_fr_des,
            :tr23_fr_admin_res,
            :tr23_fr_status,
            :tr23_fr_toadmin,
            :m11_user_referral_code,
            :m22_affiliate_id,
            @status_code,
            @status_msg
		)',$attributes);
    }



    public function GetTransferById($id)
    {
        return DB::select("SELECT * FROM `fund_transfer` WHERE TRANSFER_BY = ".$id." ORDER BY CREATED_DATE DESC");
    }


    public function GetToById($id)
    {
        return DB::select("SELECT * FROM `fund_transfer` WHERE TRANSFER_TO = ".$id." ORDER BY CREATED_DATE DESC");
    }


}

