<?php

namespace App\Repositories\Franchisee;

use DB;

class EloquentFranchisee implements FranchiseeRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all products buyed 
        * @description  : Used for getting all products buyed 
        * @param        : Request data  
        * @return       : return all products buyed 
    */
    public function getAll()
    {
        return DB::table('m45_buy_product')->paginate(500);
    }

    /**
        * Method name   : Create
        * @description  : Used for adding products buyed 
        * @param        : Request data  
        * @return       : return with added products buyed 
    */
    public function create(array $attributes)
    {
        return DB::table('m45_buy_product')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for added products to buy
        * @param        : Request data  
        * @return       : return with updating products to buy
    */
    public function update($id, array $attributes)
    {
        return DB::table('m45_buy_product')->where('m02_loc_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting country 
        * @param        : Request data  
        * @return       : return with deleting country
    */
    public function delete($id)
    {
        return DB::table('m45_buy_product')->where('m02_loc_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single country data 
        * @param        : Request data  
        * @return       : return with deleting country
    */
    public function getById($id)
    {   
        return DB::table('m45_buy_product')->where('m02_loc_id', $id)->get();
    }

    /**
        * Method name   : Active
        * @description  : Used for updating city status
        * @param        : Request data with city id
        * @return       : return with updated city status
    */
    public function active($id)
    {
        return DB::update('UPDATE m45_buy_product SET m02_status = case m02_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m02_loc_id = "'.$id.'"');
    }

}




