<?php

namespace App\Repositories\Enroll;

use DB;

class EloquentEnroll implements EnrollRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
            * Method name   : Get All
            * @description  : Used for getting all user records
            * @param        : request data 
            * @return       : response user records
        */
    public function getAll()
    {
        return DB::table('m11_user')->get();
    }

    /**
            * Method name   : Create
            * @description  : Used for adding user
            * @param        : request data 
            * @return       : response user creation with response message
        */
    public function create(array $attributes)
    {

        $result =  DB::select('CALL add_user(
            :proc,
            :m11_user_id,
            :m11_user_code,
            :m22_affiliate_id,
            :m11_first_name,
            :m11_last_name,
            :m11_user_name,
            :m11_user_dob,
            :m11_user_gender,
            :m11_user_email,
            :m11_user_contactno,
            :m11_user_about_me,
            :m11_user_interested_in,
            :m16_gr_id,
            :m11_user_location,
			:m11_user_country,
			:m11_user_state,
			:m11_user_city,
            :m11_user_image,
            :m11_user_role,
            :m11_cancellation_policy,
            :m11_subcription,
            :m11_fb_id,
            :m11_gplus_id,
            :m11_user_status,
            :m11_user_callback,
            :m11_user_islogin,
            :m11_user_istraveling,
            :m11_user_notifications,
            :m11_user_emailalert,
            :m11_user_newsletter,
            :m11_user_language,
            :m11_user_activate_code,
            :m11_user_api_token,
            :m11_user_device_token,
            :m11_user_device_type,
            :m11_user_app_version,
            :m11_user_latitude,
            :m11_user_longitude,
            :m11_user_referral_code,
            :m11_user_parent_code,
            :m11_user_position,
            :m22_shop_company_name,
            :m22_shop_gstin,
            :m22_shop_gstin_copy,
            :m22_shop_bankproof_copy,
			:m19_uk_idproof_type,
			:m19_uk_id_img,
			:m19_uk_id_number,
            :tr04_login_pwd,
            :tr04_pin_pwd,
            @status_code,
            @status_msg,
            @u_id,
			@u_code
            )',$attributes);

            $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
            $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
			$ERRCODEs=DB::select('SELECT @u_id as ID');
			$u_code=DB::select('SELECT @u_code as CODE');
            $data = array(
                'err_msg' => $ERRMSG[0]->ERR_MSG,
                'err_code' => $ERRCODE[0]->ERR_CODE,
				'ID' => $ERRCODEs[0]->ID,
				'CODE' => $u_code[0]->CODE
              );
            return $data;
    }

    /**
            * Method name   : Update
            * @description  : Used for updating user details
            * @param        : request data with usercode and userid 
            * @return       : response user profile updation with response message
        */
    public function update($usercode, $userid, array $attributes)
    {
        return DB::table('m11_user')
        ->where('m11_user_id', $userid)
        ->where('m11_user_status','ACTIVE')
        ->update($attributes);
    }

    public function updates($userid, array $attributes)
    {
        return DB::table('m11_user')->where('m11_user_id', $userid)->where('m11_user_status','ACTIVE')->update($attributes);
    }


    /**
            * Method name   : Update user mobile
            * @description  : Used for updating user mobile no
            * @param        : request data with new_mobileno, old_mobileno and userid
            * @return       : response user mobile no  updation with response message
        */
    public function updateUserMobile($new_mobileno, $old_mobileno, $user)
    {
        return DB::update("UPDATE m11_user SET m11_user_contactno=".$new_mobileno." WHERE m11_user_contactno =".$old_mobileno." and m11_user_id=".$user." and m11_user_status='ACTIVE'");
    }


    /**
            * Method name   : Update user email
            * @description  : Used for updating user email
            * @param        : request data with new_email, old_email and userid
            * @return       : response user email  updation with response message
        */
    public function updateUserEmail($new_mobileno, $old_mobileno, $user)
    {
        return DB::update("UPDATE m11_user SET m11_user_email='".$new_mobileno."' WHERE m11_user_id=".$user." and m11_user_status='ACTIVE' ");
    }


    /**
            * Method name   : Update user trans
            * @description  : Used for updating user trans
            * @param        : request data with new_mobileno, old_mobileno and userid
            * @return       : response user trans updation with response message
        */
    public function updateUserTrans($new_cpassword, $password, $USER)
    {
        return DB::update("UPDATE tr04_login SET tr04_pin_pwd = '".$new_cpassword."' WHERE m11_user_id = ".$USER."");
    }

   /**
            * Method name   : Update user password
            * @description  : Used for updating user password
            * @param        : request data with new_cpassword, password and userid
            * @return       : response user password updation with response message
        */
    public function updateUserPassword($new_cpassword, $password, $USER)
    {
        return DB::update("UPDATE tr04_login SET tr04_login_pwd='".($new_cpassword)."' WHERE m11_user_id=".$USER."");
    }



    /**
        * Method name   : Delete
        * @description  : Used for deleting user details
        * @param        : request data with userid 
        * @return       : response user deleted with response message
    */
    public function delete($id)
    {
        return DB::table('m11_user')->where('m11_user_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting user details with userid
        * @param        : request data with userid 
        * @return       : response user details 
    */
    public function getById($id)
    {   
        return DB::table('m11_user')->where('m11_user_id', $id)->get();
    }

    public function getByIdE($id)
    {
        return DB::select("SELECT * FROM enroll WHERE RegId='".$id."'");
    }

    /**
        * Method name   : Active
        * @description  : Used for getting user details with userid
        * @param        : request data with userid 
        * @return       : response user details 
    */
    public function active($id)
    {
        return DB::update('UPDATE m11_user SET m11_user_status = case m11_user_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m11_user_id = "'.$id.'"');
    }

    /**
            * Method name   : Search
            * @description  : Used for searching user details
            * @param        : request data with query
            * @return       : response user details
        */
    public function search($query)
    {
        return DB::select('SELECT * FROM `enroll` WHERE '.$query);
    }

    /**
            * Method name   : Get active user by contact
            * @description  : Used for getting active user with contacts no
            * @param        : request data with user id
            * @return       : response user details
        */
    public function getActiveUserByContact($user)
    {
        return DB::select("SELECT * FROM `enroll` WHERE `MemberContactNo`='".$user."' AND MemberStatus='Active'");
    }

    /**
        * Method name   : Get active user by contact
        * @description  : Used for getting active user with contacts no
        * @param        : request data with user id
        * @return       : response user details
    */
    public function getActiveUserByRegCode($user)
    {
        return DB::select("SELECT * FROM `enroll` WHERE `RegCode`='".$user."' AND MemberStatus='Active'");
    }

    /**
            * Method name   : Get User By Proc
            * @description  : Used for getting users by calling different procedures
            * @param        : request data with attributes
            * @return       : response user details
        */
    public function getUserByProc(array $attributes)
    {
        return DB::select('CALL enrolluser(             
            :proc,
            :userid,
            @msg
            )',$attributes);
    }

    /**
            * Method name   : Get Autocomplete
            * @description  : Used for autocomplete user details
            * @param        : request data with term
            * @return       : response user details
        */
    public function getAutocomplete($term)
    {
        return DB::select("SELECT * FROM enroll WHERE RegCode LIKE '%".$term."%'");
    }

    /**
            * Method name   : Get Ac With Referral
            * @description  : Used for getting user details with refferral
            * @param        : request data with term and refcode
            * @return       : response user details
        */
    public function getAcWithReferral($term, $refcode)
    {
        return DB::select("SELECT * FROM enroll WHERE (RegCode LIKE '%".$term."%') AND ReferralCode=".$refcode."");
    }

    /**
            * Method name   : Get User By Contact
            * @description  : Used for getting user details with contact
            * @param        : request data with contact
            * @return       : response user details
        */
    public function getUserByContact($contactno)
    {
        return DB::select("SELECT * FROM enroll WHERE MemberContactNo=".$contactno."");
    }
/**
            * Method name   : Get User By User Code
            * @description  : Used for getting user details with contact
            * @param        : request data with contact
            * @return       : response user details
        */
    public function getUserByUserCode($usercode)
    {
        return DB::select("SELECT * FROM enroll WHERE RegCode='".$usercode."'");
    }
    /**
            * Method name   : User Login
            * @description  : Used for login
            * @param        : request data with login details
            * @return       : response user logged in
        */
    public function userLogin(array $login_data)
    {
        return DB::select('CALL login(:login_id, :user_pwd,:login_ip,:user_agent, :user_type, @status_code,@status_msg)',$login_data);
    }

    /**
            * Method name   : Get Active User
            * @description  : Used for getting active users
            * @param        : request data
            * @return       : response active users
        */
    public function getActiveUser()
    {
        return  DB::select("SELECT * FROM `enroll` WHERE MemberStatus='Active'");
    }

    /**
            * Method name   : User Status
            * @description  : Used for user status
            * @param        : request data
            * @return       : response user status
        */
    public function userStatus(array $attributes)
    {
        return DB::select('CALL status_user(
            :proc,
            :m11_user_id,
            :m11_user_status,
            @status_code,
            @status_msg )',$attributes);
    }

    /**
            * Method name   : Update User Team
            * @description  : Used for updating user c
            * @param        : request data
            * @return       : response with updated user Team
        */
    public function updateUserTeam($old_itroid, $user, array $attributes)
    {
        return DB::table('m11_user')
        ->where('m11_user_referral_code', $old_itroid)
        ->where('m11_user_id', $user)
        ->where('m11_user_status', 'ACTIVE')
        ->update($attributes);
    }

    /**
            * Method name   : Update User Parent
            * @description  : Used for updating user parent
            * @param        : request data
            * @return       : response with updated user parent
        */
    public function updateUserParent($old_itroid, $user, array $attributes)
    {
        return DB::table('m11_user')
        ->where('m11_user_parent_code', $old_itroid)
        ->where('m11_user_id', $user)
        ->where('m11_user_status', 'ACTIVE')
        ->update($attributes);
    }

    /**
            * Method name   : Update User Group
            * @description  : Used for updating user group
            * @param        : request data
            * @return       : response with updated user group
        */
    public function updateUserGroup($contact, $user, array $attributes)
    {
        return DB::table('m11_user')
        ->where('m11_user_code', $contact)
        ->where('m11_user_id', $user)
        ->where('m11_user_status', 'ACTIVE')
        ->update($attributes);
    }


    /**
            * Method name   : Update User Btc
            * @description  : Used for updating user btc address
            * @param        : request data
            * @return       : response with updated user btc address
        */
    public function updateUserBtc($usercode, $userid, array $attributes)
    {
        return DB::table('m11_user')
        ->where('m11_user_code', $usercode)
        ->where('m11_user_id', $userid)
        ->where('m11_user_status', 'ACTIVE')
        ->update($attributes);
    }

    /**
            * Method name   : Update User Btc
            * @description  : Used for updating user btc address
            * @param        : request data
            * @return       : response with updated user btc address
        */
    public function updateUserEth($usercode, $userid, array $attributes)
    {
        return DB::table('m11_user')
        ->where('m11_user_code', $usercode)
        ->where('m11_user_id', $userid)
        ->where('m11_user_status', 'ACTIVE')
        ->update($attributes);
    }

    /**
            * Method name   : Get Balby Income
            * @description  : Used for income
            * @param        : request data
            * @return       : response with income
        */
    public function getBalbyIncome($user_id, $type)
    {
        return DB::select("SELECT get_balby_income($user_id, $type) AS BAL");
    }

}