<?php

namespace App\Repositories\Employee;

interface EmployeeRepository
{
    public function getAll();

    public function getById($id);

    public function create(array $attributes);

    public function delete($id);

    public function active($id);

    public function search($query);

    public function update($usercode, $userid, array $attributes);

    public function updateBankByEmpId($empid, array $attributes);

    public function updateKycByUserId($empid, array $attributes);

    public function getEnrollEmployee(array $attributes);

    public function updateEmpTrans($new_mobileno, $old_mobileno, $user);

    public function updateEmpPassword($new_cpassword, $password, $USER);

	public function updateEmpMobile($new_mobile, $old_mobile, $USER);

    public function getActiveEmployee();

	public function getByRole($role);
	
	public function empStatus(array $attributes);
}
