<?php

namespace App\Repositories\Employee;

use DB;

class EloquentEmployee implements EmployeeRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    public function getAll()
    {
        return DB::table('m30_employee')->get();
    }

    public function create(array $attributes)
    {
        $result =  DB::select('CALL employee(
              :proc,
              :m30_employee_id,
              :m30_employee_code,
              :m22_affiliate_id,
              :m30_first_name,
              :m30_last_name,
              :m30_employee_name,
              :m30_employee_dob,
              :m30_employee_gender,
              :m30_employee_email,
              :m30_employee_contactno,
              :m30_employee_about_me,
              :m30_employee_interested_in,
              :m16_gr_id,
              :m30_employee_location,
			  :m30_employee_country,
			  :m30_employee_state,
			  :m30_employee_city,
              :m30_employee_image,
              :m30_employee_role,
              :m30_cancellation_policy,
              :m30_subcription,
              :m30_fb_id,
              :m30_gplus_id,
              :m30_employee_status,
              :m30_employee_callback,
              :m30_employee_islogin,
              :m30_employee_istraveling,
              :m30_employee_notifications,
              :m30_employee_emailalert,
              :m30_employee_newsletter,
              :m30_employee_language,
              :m30_employee_activate_code,
              :m30_employee_api_token,
              :m30_employee_device_token,
              :m30_employee_device_type,
              :m30_employee_app_version,
              :m30_employee_latitude,
              :m30_employee_longitude,
              :m30_employee_referral_code,
              :m30_employee_parent_code,
              :m30_employee_position,
              :m22_shop_company_name,
              :m22_shop_gstin,
              :m22_shop_gstin_copy,
              :m22_shop_bankproof_copy,
              :tr35_login_pwd,
              :tr35_pin_pwd,
              @status_code,
              @status_msg
            )',$attributes);
//dd($result);
            $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
            $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
            $data = array(
                'err_msg' => $ERRMSG[0]->ERR_MSG,
                'err_code' => $ERRCODE[0]->ERR_CODE
              );
            return $data;
    }

    public function delete($id)
    {
        return DB::table('m30_employee')->where('m30_employee_id', $id)->delete();
    }

    public function getById($id)
    {   
        return DB::table('m30_employee')->where('m30_employee_id', $id)->get();
    }

    public function active($id)
    {
        return DB::update('UPDATE m30_employee SET m30_employee_status = case m30_employee_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m30_employee_id = "'.$id.'"');
    }

    public function search($query)
    {
        return DB::select('SELECT * FROM `m30_employee` WHERE '.$query);
    }

    /**
            * Method name   : Update
            * @description  : Used for updating user details
            * @param        : request data with usercode and userid 
            * @return       : response user profile updation with response message
        */
    public function update($usercode, $userid, array $attributes)
    {
        return DB::table('m30_employee')
        ->where('m30_employee_code', $usercode)
        ->where('m30_employee_id', $userid)
        ->where('m30_employee_status','ACTIVE')
        ->update($attributes);
    }


    /**
            * Method name   : Update bank by emp id
            * @description  : Used for updating bank details by emp id
            * @param        : request data with emp id
            * @return       : response emp bank details updation with response message
        */
    public function updateBankByEmpId($empid, array $attributes)
    {
        return DB::table('m32_employee_bankdetails')->where('m30_employee_id', $empid)->update($attributes);
    }


    /**
            * Method name   : Update kyc by emp id
            * @description  : Used for kyc details by emp id
            * @param        : request data with emp id
            * @return       : response kyc details updation with response message
        */
    public function updateKycByUserId($empid, array $attributes)
    {
        return DB::table('m31_employee_kyc')->where('m30_employee_id', $empid)->update($attributes);
    }

    /**
            * Method name   : Get employee By proc
            * @description  : Used for getting employee by calling different procedures
            * @param        : request data with attributes
            * @return       : response employee details
        */
    public function getEnrollEmployee(array $attributes)
    {
        return DB::select('CALL enrollemployee(             
            :proc,
            :empid,
            @msg
            )',$attributes);
    }


    /**
            * Method name   : Update emp trans
            * @description  : Used for updating employee trans
            * @param        : request data with new_mobileno, old_mobileno and userid
            * @return       : response user trans updation with response message
        */
    public function updateEmpTrans($new_pass, $old_pass, $user)
    {
        return DB::update("UPDATE tr35_login SET tr35_pin_pwd = ".$new_pass." WHERE tr35_pin_pwd = ".$old_pass." AND m30_employee_id = ".$user."");
    }

    /**
            * Method name   : Update emp password
            * @description  : Used for updating employee password
            * @param        : request data with new_cpassword, password and userid
            * @return       : response user password updation with response message
        */
    public function updateEmpPassword($new_cpassword, $password, $USER)
    {
        return DB::update("UPDATE tr35_login SET tr35_login_pwd='".($new_cpassword)."' WHERE tr35_login_pwd ='".($password)."' and m30_employee_id=".$USER."");
    }

    /**
            * Method name   : Get Active User
            * @description  : Used for getting active users
            * @param        : request data
            * @return       : response active users
        */
    public function getActiveEmployee()
    {
        return  DB::select("SELECT * FROM `employee_enroll` WHERE MemberStatus='Active'");
    }


    /**
            * Method name   : Get By Role User
            * @description  : Used for getting active users
            * @param        : request data
            * @return       : response active users
        */
    public function getByRole($role)
    {
		return DB::table('employee_enroll')->where('MemberStatus', 'Active')->where('MemberRole', $role)->get();
    }

	 /**
            * Method name   : Emp Status
            * @description  : Used for employee status
            * @param        : request data
            * @return       : response employee status
        */
    public function empStatus(array $attributes)
    {
        return DB::select('CALL status_emp(
            :proc,
            :m30_employee_id,
            :m30_employee_status,
            @status_code,
            @status_msg )',$attributes);
    }

	 /**
            * Method name   : Update emp mobile 
            * @description  : Used for updating employee mobile
            * @param        : request data with new mobile, old mobile and userid
            * @return       : response user password updation with response message
        */
    public function updateEmpMobile($new_mobile, $old_mobile, $USER)
    {
        return DB::update("UPDATE m30_employee SET m30_employee_contactno='".($new_mobile)."' WHERE m30_employee_contactno ='".($old_mobile)."' and m30_employee_id=".$USER."");
    }
}