<?php

namespace App\Repositories\Dmt\Dmtprocess;

use DB;

class EloquentDmtprocess implements DmtprocessRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

	/**
		* Method name   : do Remmitance
		* @description  : Used for remmitance
		* @param        : request data 
		* @return       : response remmitance
	*/
    public function doRemmitance(array $attributes)
    {
        $result =  DB::select('CALL doremmitance(				
				:proc,
				:m11_user_id,
				:trans_id,
				:refre_id,
				:request_no,
				:mobile_no,
				:amount,
				:payment_id,
				:payment_status,
				:impsrefno,
				:message,
				:remarks,
				:account_number,
				:beneficiary_code,
				:beneficiary_name,
				:account_type,
				:ifsc,
				:bank_name,
				:branch_name,
				:address,
				:state,
				:city,
				:agentid,
				:payctransid,
				:topup_charge,
				:transfer_status,
				@msg,
				@msg2
				)',$attributes);
            $ERRMSG=DB::select('SELECT @msg as ERR_MSG');
            $ERRCODE=DB::select('SELECT @msg2 as ERR_CODE');
            $data = array(
                'err_msg' => $ERRMSG[0]->ERR_MSG,
                'err_code' => $ERRCODE[0]->ERR_CODE
              );
            return $data;
    }
	
    /**
        * Method name   : Dmr Status Update
        * @description  : Used for updating dmr status
        * @param        : Request data  
        * @return       : return with updated dmr status
    */
    public function dmrStatusUpdate(array $attributes)
    {
        return DB::select('CALL dmr_statusupdate(
		         :proc,
		         :userid,
		         :account, 
		         :transid,
		         :liveid,
		         :amt,
		         :recstatus,
		         :descrip,
		         @msg
		       )',$attributes);
    }



	
	/**
		* Method name   : Get All Remitter
		* @description  : Used for getting all user records
		* @param        : request data 
		* @return       : response user records
	*/
    public function getAll()
    {
        return DB::table('m57_remitter')->get();
    }

    /**
		* Method name   : Create Remitter
		* @description  : Used for adding user
		* @param        : request data 
		* @return       : response user creation with response message
	*/
    public function create(array $attributes)
    {
        $result =  DB::select('CALL add_remitter(
                    :proc,
                    :m57_remitter_id,
                    :m57_remitter_code,
                    :m22_affiliate_id,
                    :m57_first_name,
                    :m57_last_name,
                    :m57_remitter_name,
                    :m57_remitter_dob,
                    :m57_remitter_gender,
                    :m57_remitter_email,
                    :m57_remitter_contactno,
                    :m57_remitter_location,
                    :m57_remitter_state,
                    :m57_remitter_city,
                    :m57_remitter_postalcode,
                    :m57_remitter_status,
                    :m57_remitter_islogin,
                    :m57_remitter_referral_code,
                    @status_code,
                    @status_msg
                )',$attributes);
            $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
            $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
            $data = array(
                'err_msg' => $ERRMSG[0]->ERR_MSG,
                'err_code' => $ERRCODE[0]->ERR_CODE
              );
            return $data;
    }

}