<?php

namespace App\Repositories\Denomination;

use DB;

class EloquentDenomination implements DenominationRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all slab
        * @description  : Used for getting all slab data 
        * @param        : Request data  
        * @return       : return all slab data
    */
    public function getAll()
    {
        return DB::select("SELECT * FROM `m67_denomination`");

    }

    /**
        * Method name   : Create
        * @description  : Used for inserting slab 
        * @param        : Request data  
        * @return       : return with inserting slab
    */
    public function create(array $attributes)
    {
        return DB::table('m67_denomination')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating slab 
        * @param        : Request data  
        * @return       : return with updating slab
    */
    public function update($id, array $attributes)
    {
        return DB::table('m67_denomination')->where('m67_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting slab 
        * @param        : Request data  
        * @return       : return with deleting slab
    */
    public function delete($id)
    {
        return DB::table('m67_denomination')->where('m67_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single slab data 
        * @param        : Request data  
        * @return       : return with single slab
    */
    public function getById($id)
    {   
        return DB::select("SELECT * FROM `m67_denomination` WHERE m67_id = ".$id."");
    }


}




