<?php

namespace App\Repositories\Closing;

use DB;

class EloquentClosing implements ClosingRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Cb approv datewise
        * @description  : Used for generating cashback datewise
        * @param        : Request data  
        * @return       : return with generating cashback
    */
    public function cbApprovDatewise(array $attributes)
    {
        return DB::select('CALL cbapprov_datewise(                      
                    :fromdate,
                    :msg,
                    :msg2)',$attributes);
    }

    /**
        * Method name   : Get cashback dates
        * @description  : Used for getting cashback dates
        * @param        : Request data with attributes
        * @return       : return with cashback dates
    */
    public function getCashbackDates($attributes)
    {
        return DB::select("SELECT * FROM cashback_dates WHERE ".$attributes);
    }

    /**
        * Method name   : Match Payout
        * @description  : Used for matching payout
        * @param        : Request data with attributes
        * @return       : return with matching payout
    */
    public function matchPayout(array $attributes)
    {
        DB::select('CALL match_payout(                       
                        :closing_from_date,
                        :closing_to_date,
                        @status_msg)',$attributes);
        return  DB::select("SELECT @status_msg");
    }

    /**
        * Method name   : Payout Report
        * @description  : Used for payout report
        * @param        : Request data with attributes
        * @return       : return with payout report
    */
    public function payoutReport(array $attributes)
    {
        return DB::select('CALL payout_report(              
                        :queery)',$attributes);
    }

    /**
        * Method name   : Direct Details
        * @description  : Used for getting direct details
        * @param        : Request data with attributes
        * @return       : return with direct details
    */
    public function directDetails($attributes)
    {
        return DB::select("SELECT * FROM direct_details WHERE ".$attributes);
    }
  /**
        * Method name   : COin Details
        * @description  : Used for getting direct details
        * @param        : Request data with attributes
        * @return       : return with direct details
    */
    public function coinDetails($attributes)
    {
        return DB::select("SELECT * FROM coins_details WHERE ".$attributes);
    }

    /**
        * Method name   : Closing Is Publish
        * @description  : Used for getting closing publish details
        * @param        : Request data with attributes
        * @return       : return with closing publish details
    */
    public function closingIsPublish()
    {
        return DB::select("SELECT DISTINCT(tr26_to_closing_date)  AS tr26_to_closing_date FROM tr26_closing_detail WHERE tr26_closing_ispublish = 1");
    }

    /**
        * Method name   : Payment Report
        * @description  : Used for payment report
        * @param        : Request data with attributes
        * @return       : return with payment report
    */
    public function paymentReport(array $attributes)
    {
        return DB::select('CALL payment_report(:proc,:userid)',$attributes);
    }

    /**
        * Method name   : Get Avail Bal
        * @description  : Used for getting available balance
        * @param        : Request data with id and balance type
        * @return       : return with balance
    */
    public function getAvailBal($id, $baltype)
    {
        return DB::select("select get_available_bal($id, $baltype) AS BAL");
    }


}




