<?php

namespace App\Repositories\Category;

use DB;

class EloquentCategory implements CategoryRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all categories
        * @description  : Used for getting all categories data 
        * @param        : Request data  
        * @return       : return all categories data
    */
    public function getAllCategory()
    {
        return DB::table('m29_category')->where('m29_parent_id' , 0)->paginate(500);
    }

    /**
        * Method name   : Get all sub categories
        * @description  : Used for getting all sub categories data 
        * @param        : Request data  
        * @return       : return all sub categories data
    */
    public function getAllSubcategory()
    {
        return DB::table('m29_category')->where('m29_status' , 1)->paginate(500);
    }


    /**
        * Method name   : Create
        * @description  : Used for inserting category 
        * @param        : Request data  
        * @return       : return with inserting category
    */
    public function create(array $attributes)
    {
        return DB::table('m29_category')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating category 
        * @param        : Request data  
        * @return       : return with updating category
    */
    public function update($id, array $attributes)
    {
        return DB::table('m29_category')->where('m29_cat_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting category 
        * @param        : Request data  
        * @return       : return with deleting category
    */
    public function delete($id)
    {
        return DB::table('m29_category')->where('m29_cat_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single category data 
        * @param        : Request data  
        * @return       : return with deleting category
    */
    public function getById($id)
    {   
        return DB::table('m29_category')->where('m29_cat_id', $id)->get();
    }

    /**
        * Method name   : Active
        * @description  : Used for updating category status
        * @param        : Request data with category id
        * @return       : return with updated category status
    */
    public function active($id)
    {
        return DB::update('UPDATE m29_category SET m29_status = case m29_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m29_cat_id = "'.$id.'"');
    }

    /**
        * Method name   : Get by parent id
        * @description  : Used for getting single category data 
        * @param        : Request data  
        * @return       : return with deleting category
    */
    public function getByParentId($id)
    {   
        return DB::table('m29_category')
        ->where('m29_parent_id', $id)
        ->where('m29_status', 1)  
        ->get();
    }

}




