<?php

namespace App\Repositories\Campaign;

use DB;

class EloquentCampaign implements CampaignRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get email campaign
        * @description  : Used for getting all email campaigns
        * @param        : Request data  
        * @return       : return with all email campaigns
    */
    public function getCamp()
    {               
        return DB::table('email_campaign')->where('TYPE', 3)->get();
    }



    /**
        * Method name   : Get sms 
        * @description  : Used for getting all sms 
        * @param        : Request data  
        * @return       : return with all sms
    */
    public function getSMS()
    {               
        return DB::select('SELECT * from sms_campaign where 1 ORDER BY ID DESC');
    }

    public function getByTypeSMS($type)
    {               
        return DB::select("SELECT * from sms_campaign where TYPE_INT=".$type." ORDER BY ID DESC");
    }

    public function getByPhoneSMS($no)
    {               
        return DB::select("SELECT * FROM sms_campaign WHERE SEND_TO='".$no."' ORDER BY ID DESC");
    }

    public function getByTypePhoneSMS($no, $type)
    {               
        return DB::select("SELECT * FROM sms_campaign WHERE TYPE_INT=".$type." AND SEND_TO='".$no."' ORDER BY ID DESC");
    }



    /**
        * Method name   : Get All email
        * @description  : Used for getting all email
        * @param        : Request data  
        * @return       : return with all email
    */
    public function getEmail()
    {               
        return DB::select("SELECT * from email_campaign WHERE TYPE=2 ORDER BY ID DESC");
    }


    public function getByRolEmail($type)
    {               
          return DB::select("SELECT * from email_campaign WHERE TYPE=2 AND SEND_BY='".$type."' ORDER BY ID DESC");
        
    }


    public function getByUserEmail($id, $type)
    {        
        return DB::select("SELECT * from email_campaign WHERE TYPE=2 AND SEND_BY='".$type."' AND SEND_BY_ID=".$id." ORDER BY ID DESC");
    
    }


    /**
        * Method name   : Get All
        * @description  : Used for getting all email_campaigns
        * @param        : Request data  
        * @return       : return with all email_campaigns
    */
    public function getAll()
    {               
        return DB::table('email_campaign')->get();
    }

    /**
        * Method name   : Create
        * @description  : Used for creating email_campaign
        * @param        : Request data  
        * @return       : return with created email_campaign
    */
    public function create(array $attributes)
    {
        return DB::table('m52_email_campaign')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating email_campaign
        * @param        : Request data  
        * @return       : return with updated email_campaign
    */
    public function update($id, array $attributes)
    {
        return DB::table('m52_email_campaign')->where('m52_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting email_campaign
        * @param        : Request data  
        * @return       : return with deleted email_campaign
    */
    public function delete($id)
    {
        return DB::table('m52_email_campaign')->where('m52_id', $id)->delete();
    }

    /**
        * Method name   : Get By Id
        * @description  : Used for getting email_campaign by asssigned to id
        * @param        : Request data  
        * @return       : return with email_campaign
    */
    public function getById($id)
    {  
        return DB::table('email_campaign')->where('ID', $id)->first();
    }



}