<?php

namespace App\Repositories\Associate;

use DB;

class EloquentAssociate implements AssociateRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    public function getAll()
    {
        return DB::table('m54_vendor')->get();
    }

    public function create(array $attributes)
    {
        $result =  DB::select('CALL add_vendor(
              :proc,
              :m54_vendor_id,
              :m54_vendor_code,
              :m22_affiliate_id,
              :m54_first_name,
              :m54_last_name,
              :m54_vendor_name,
              :m54_vendor_dob,
              :m54_vendor_gender,
              :m54_vendor_email,
              :m54_vendor_contactno,
              :m54_vendor_about_me,
              :m54_vendor_interested_in,
              :m16_gr_id,
              :m54_vendor_location,
              :m54_vendor_image,
              :m54_vendor_role,
              :m54_cancellation_policy,
              :m54_subcription,
              :m54_fb_id,
              :m54_gplus_id,
              :m54_vendor_status,
              :m54_vendor_callback,
              :m54_vendor_islogin,
              :m54_vendor_istraveling,
              :m54_vendor_notifications,
              :m54_vendor_emailalert,
              :m54_vendor_newsletter,
              :m54_vendor_language,
              :m54_vendor_activate_code,
              :m54_vendor_api_token,
              :m54_vendor_device_token,
              :m54_vendor_device_type,
              :m54_vendor_app_version,
              :m54_vendor_latitude,
              :m54_vendor_longitude,
              :m54_vendor_referral_code,
              :m54_vendor_parent_code,
              :m54_vendor_position,
              :m22_shop_company_name,
              :m22_shop_gstin,
              :m22_shop_gstin_copy,
              :m22_shop_bankproof_copy,
              :tr36_login_pwd,
              :tr36_pin_pwd,
              @status_code,
              @status_msg
            )',$attributes);
//dd($result);
            $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
            $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
            $data = array(
                'err_msg' => $ERRMSG[0]->ERR_MSG,
                'err_code' => $ERRCODE[0]->ERR_CODE
              );
            return $data;
    }

    public function delete($id)
    {
        return DB::table('m54_vendor')->where('m54_vendor_id', $id)->delete();
    }

    public function getById($id)
    {   
        return DB::table('m54_vendor')->where('m54_vendor_id', $id)->get();
    }

    public function active($id)
    {
        return DB::update('UPDATE m54_vendor SET m54_vendor_status = case m54_vendor_status when "ACTIVE" then "INACTIVE"
         when "INACTIVE" then "ACTIVE" end WHERE m54_vendor_id = "'.$id.'"');
    }

    public function search($query)
    {
        return DB::select('SELECT * FROM `m54_vendor` WHERE '.$query);
    }

    /**
            * Method name   : Update
            * @description  : Used for updating user details
            * @param        : request data with usercode and userid 
            * @return       : response user profile updation with response message
        */
    public function update($usercode, $userid, array $attributes)
    {
        return DB::table('m54_vendor')
        ->where('m54_vendor_code', $usercode)
        ->where('m54_vendor_id', $userid)
        ->where('m54_vendor_status','ACTIVE')
        ->update($attributes);
    }


    /**
            * Method name   : Update bank by emp id
            * @description  : Used for updating bank details by emp id
            * @param        : request data with emp id
            * @return       : response emp bank details updation with response message
        */
    public function updateBankByEmpId($empid, array $attributes)
    {
        return DB::table('m32_employee_bankdetails')->where('m54_vendor_id', $empid)->update($attributes);
    }


    /**
            * Method name   : Update kyc by emp id
            * @description  : Used for kyc details by emp id
            * @param        : request data with emp id
            * @return       : response kyc details updation with response message
        */
    public function updateKycByUserId($empid, array $attributes)
    {
        return DB::table('m31_employee_kyc')->where('m54_vendor_id', $empid)->update($attributes);
    }

    /**
            * Method name   : Get employee By proc
            * @description  : Used for getting employee by calling different procedures
            * @param        : request data with attributes
            * @return       : response employee details
        */
    public function getEnrollEmployee(array $attributes)
    {
        return DB::select('CALL enrollemployee(             
            :proc,
            :empid,
            @msg
            )',$attributes);
    }


    /**
            * Method name   : Update emp trans
            * @description  : Used for updating employee trans
            * @param        : request data with new_mobileno, old_mobileno and userid
            * @return       : response user trans updation with response message
        */
    public function updateEmpTrans($new_mobileno, $old_mobileno, $user)
    {
        return DB::update("UPDATE tr36_login SET m54_vendor_contactno = ".$new_mobileno." WHERE m54_vendor_contactno = ".$old_mobileno." AND m54_vendor_id = ".$user."");
    }

    /**
            * Method name   : Update emp password
            * @description  : Used for updating employee password
            * @param        : request data with new_cpassword, password and userid
            * @return       : response user password updation with response message
        */
    public function updateEmpPassword($new_cpassword, $password, $USER)
    {
        return DB::update("UPDATE tr36_login SET tr36_login_pwd='".($new_cpassword)."' WHERE tr36_login_pwd ='".($password)."' and m54_vendor_id=".$USER."");
    }

    /**
            * Method name   : Get Active User
            * @description  : Used for getting active users
            * @param        : request data
            * @return       : response active users
        */
    public function getActiveEmployee()
    {
        return  DB::select("SELECT * FROM `employee_enroll` WHERE MemberStatus='Active'");
    }

}




