<?php

namespace App\Repositories\Api;

use DB;

class EloquentApi implements ApiRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all api
        * @description  : Used for getting all api data 
        * @param        : Request data  
        * @return       : return all api data
    */
    public function getAll()
    {
		//return DB::table('api')->select('API_ID', 'API_CREATED','RECHARGE_URL','BALANCE_URL','STATUS_URL','API_NAME ')->groupby('API_ID', 'API_CREATED','RECHARGE_URL','BALANCE_URL','STATUS_URL','API_NAME ')->get();
        return DB::select("SELECT `API_ID`,`API_NAME` ,API_ONADD,API_STATUS,RECHARGE_URL,BALANCE_URL,STATUS_URL,API_URL_PARAM,API_URL_BALPARAM,API_URL_STATUSPARAM,API_DATA_SENDVIA,API_URL_METHOD,
API_URL_FOR,API_URL_PRIORITY,API_URL_PRIORITY,API_URL_ALLOWQTY,API_URL_HLR,API_URL_STATUS,API_URL_METHOD,
MAX(IF(`API_RESP_OCCUR` = 'INSTANT', tbl.API_RESP_FORSTATUS,'')) AS INSTANT_STATUS,
MAX(IF(`API_RESP_OCCUR` = 'INSTANT', tbl.API_VALUEOF_SUCCESS,'')) AS INSTANT_VALUEOF_SUCCESS,
MAX(IF(`API_RESP_OCCUR` = 'INSTANT', tbl.API_VALUEOF_PENDING,'')) AS INSTANT_VALUEOF_PENDING,
MAX(IF(`API_RESP_OCCUR` = 'INSTANT', tbl.API_VALUEOF_FAILED,'')) AS INSTANT_VALUEOF_VALUEOF_FAILED,
MAX(IF(`API_RESP_OCCUR` = 'INSTANT', tbl.API_RESPFOR_LIVEID,'')) AS INSTANT_VALUEOF_LIVEID,
MAX(IF(`API_RESP_OCCUR` = 'INSTANT', tbl.API_RESPFOR_TXNID,'')) AS INSTANT_RESPFOR_TXNID,
MAX(IF(`API_RESP_OCCUR` = 'INSTANT', tbl.API_RESP_TYPE,'')) AS INSTANT_RESP_TYPE,
MAX(IF(`API_RESP_OCCUR` = 'CALLBACK', tbl.API_RESP_FORSTATUS,'')) AS CALLBACK_STATUS,
MAX(IF(`API_RESP_OCCUR` = 'CALLBACK', tbl.API_VALUEOF_SUCCESS,'')) AS CALLBACK_VALUEOF_SUCCESS,
MAX(IF(`API_RESP_OCCUR` = 'CALLBACK', tbl.API_VALUEOF_PENDING,'')) AS CALLBACK_VALUEOF_PENDING,
MAX(IF(`API_RESP_OCCUR` = 'CALLBACK', tbl.API_VALUEOF_FAILED,'')) AS CALLBACK_VALUEOF_FAILED,
MAX(IF(`API_RESP_OCCUR` = 'CALLBACK', tbl.API_RESPFOR_LIVEID,'')) AS CALLBACK_RESPFOR_LIVEID,
MAX(IF(`API_RESP_OCCUR` = 'CALLBACK', tbl.API_RESPFOR_TXNID,'')) AS CALLBACK_RESPFOR_TXNID,
MAX(IF(`API_RESP_OCCUR` = 'CALLBACK', tbl.API_RESP_TYPE,'')) AS CALLBACK_RESP_TYPE,
CONCAT('http://appworkspay.com/api/v1/recharge_callback/',API_ID) AS CALLBACK_URL
 FROM (SELECT
  `m12_api`.`m12_api_id`                     AS `API_ID`,
  `m12_api`.`m12_api_name`                   AS `API_NAME`,
`m12_api`.`m12_api_status`                    AS `API_STATUS`,
`m12_api`.`m12_api_onadd`     AS `API_ONADD`,
`m25_api_response`.`m25_resp_type`      AS `API_RESP_TYPE`,
  `m25_api_response`.`m25_apiresp_id`         AS `API_RESP_ID`,
  `m25_api_response`.`m25_resp_occur`        AS `API_RESP_OCCUR`,
  `m25_api_response`.`m25_respfor_status`    AS `API_RESP_FORSTATUS`,
  `m25_api_response`.`m25_valueof_success`   AS `API_VALUEOF_SUCCESS`,
  `m25_api_response`.`m25_valueof_pending`   AS `API_VALUEOF_PENDING`,
  `m25_api_response`.`m25_valueof_failed`    AS `API_VALUEOF_FAILED`,
  `m25_api_response`.`m25_respfor_liveid`    AS `API_RESPFOR_LIVEID`,
  `m25_api_response`.`m25_respfor_apitxnid`  AS `API_RESPFOR_TXNID`,
  `m14_api_url`.`m14_api_url_id`             AS `API_URL_ID`,
  `m14_api_url`.`m14_api_url_address`        AS `RECHARGE_URL`,  
`m14_api_url`.`m14_api_url_address_bal`    AS `BALANCE_URL`,
`m14_api_url`.`m14_api_url_address_status` AS `STATUS_URL`,
`m14_api_url`.`m14_api_url_prm`            AS `API_URL_PARAM`,
`m14_api_url`.`m14_api_url_balprm`         AS `API_URL_BALPARAM`,
`m14_api_url`.`m14_api_url_statusprm`      AS `API_URL_STATUSPARAM`,
`m14_api_url`.`m14_api_data_sendtype`      AS `API_DATA_SENDVIA`,
`m14_api_url`.`m14_api_url_method`         AS `API_URL_METHOD`,
`m14_api_url`.`m14_api_url_for`            AS `API_URL_FOR`,
`m14_api_url`.`m14_api_url_priority`       AS `API_URL_PRIORITY`,
`m14_api_url`.`m14_api_url_allowqty`       AS `API_URL_ALLOWQTY`,
`m14_api_url`.`m14_api_url_hlr`            AS `API_URL_HLR`,
`m14_api_url`.`m14_api_url_status`         AS `API_URL_STATUS`
FROM (`m12_api`
LEFT JOIN `m14_api_url`
      ON ((`m12_api`.`m12_api_id` = `m14_api_url`.`m12_api_id`))
   LEFT JOIN `m25_api_response`
     ON ((`m12_api`.`m12_api_id` = `m25_api_response`.`m12_api_id`)))
     WHERE 1 GROUP BY `m12_api`.`m12_api_id`,`m14_api_url_id`,`m25_apiresp_id`) tbl  WHERE 1 GROUP BY `API_ID`,API_URL_ID");	
    }

    /**
        * Method name   : Create
        * @description  : Used for inserting api 
        * @param        : Request data  
        * @return       : return with inserting api
    */
    public function create(array $attributes)
    {
       $result =  DB::select('CALL api(
            :proc,
            :api_method_type,
            :api_for,
            :api_datasend_via,
            :api_name,
            :api_for_transaction,
            :transaction_parameter,
            :api_for_status,
            :status_parameter,
            :api_for_bal,
            :bal_parameter,
            :api_allow_qty,
            :api_hlr,
            :api_status,
            :resp_occur,
            :resp_type,
            :respfor_status,
            :valueof_success,
            :valueof_pending,
            :valueof_failed,
            :respfor_liveid,
            :respfor_apitxnid,
            :apiresp_status,
            :cb_resp_type,
            :cb_respfor_status,
            :cb_valueof_success,
            :cb_valueof_pending,
            :cb_valueof_failed,
            :cb_respfor_liveid,
            :cb_respfor_apitxnid,
            :cb_apiresp_status,
			:user_role,
            :user_id, 
			:api_id,
            @msg
            )',$attributes);
		$ERRMSG=DB::select('SELECT @msg as ERR_MSG');
		//print_r($ERRMSG[0]);
        //dd();
        return $ERRMSG[0]->ERR_MSG;
    }

    /**
        * Method name   : Create api url
        * @description  : Used for inserting api url details
        * @param        : Request data  
        * @return       : return with inserting api url details
    */
    public function createApiUrl(array $attributes)
    {
        return DB::table('m14_api_url')->insert($attributes);
    }

    /**
        * Method name   : Create api response
        * @description  : Used for inserting api response
        * @param        : Request data  
        * @return       : return with inserting api response
    */
    public function createApiResponse(array $attributes)
    {
        return DB::table('m25_api_response')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating api 
        * @param        : Request data  
        * @return       : return with updating api
    */
    public function update($id, array $attributes)
    {
        return DB::table('m12_api')->where('m12_api_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting api 
        * @param        : Request data  
        * @return       : return with deleting api
    */
    public function delete($id)
    {
        return DB::table('m12_api')->where('m12_api_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single api data 
        * @param        : Request data  
        * @return       : return with single api
    */
    public function getById($id)
    {   
       // return DB::select('SELECT * FROM `api` WHERE API_ID = "'.$id.'"');
return DB::select("SELECT `API_ID`,`API_NAME` ,API_ONADD,API_STATUS,API_FOR,RECHARGE_URL,BALANCE_URL,STATUS_URL,API_URL_PARAM,API_URL_BALPARAM,API_URL_STATUSPARAM,API_DATA_SENDVIA,API_URL_METHOD,
API_URL_FOR,API_URL_PRIORITY,API_URL_PRIORITY,API_URL_ALLOWQTY,API_URL_HLR,API_URL_STATUS,
MAX(IF(`API_RESP_OCCUR` = 'INSTANT', tbl.API_RESP_FORSTATUS,'')) AS INSTANT_STATUS,
MAX(IF(`API_RESP_OCCUR` = 'INSTANT', tbl.API_VALUEOF_SUCCESS,'')) AS INSTANT_VALUEOF_SUCCESS,
MAX(IF(`API_RESP_OCCUR` = 'INSTANT', tbl.API_VALUEOF_PENDING,'')) AS INSTANT_VALUEOF_PENDING,
MAX(IF(`API_RESP_OCCUR` = 'INSTANT', tbl.API_VALUEOF_FAILED,'')) AS INSTANT_VALUEOF_VALUEOF_FAILED,
MAX(IF(`API_RESP_OCCUR` = 'INSTANT', tbl.API_RESPFOR_LIVEID,'')) AS INSTANT_VALUEOF_LIVEID,
MAX(IF(`API_RESP_OCCUR` = 'INSTANT', tbl.API_RESPFOR_TXNID,'')) AS INSTANT_RESPFOR_TXNID,
MAX(IF(`API_RESP_OCCUR` = 'INSTANT', tbl.API_RESP_TYPE,'')) AS INSTANT_RESP_TYPE,
MAX(IF(`API_RESP_OCCUR` = 'CALLBACK', tbl.API_RESP_FORSTATUS,'')) AS CALLBACK_STATUS,
MAX(IF(`API_RESP_OCCUR` = 'CALLBACK', tbl.API_VALUEOF_SUCCESS,'')) AS CALLBACK_VALUEOF_SUCCESS,
MAX(IF(`API_RESP_OCCUR` = 'CALLBACK', tbl.API_VALUEOF_PENDING,'')) AS CALLBACK_VALUEOF_PENDING,
MAX(IF(`API_RESP_OCCUR` = 'CALLBACK', tbl.API_VALUEOF_FAILED,'')) AS CALLBACK_VALUEOF_FAILED,
MAX(IF(`API_RESP_OCCUR` = 'CALLBACK', tbl.API_RESPFOR_LIVEID,'')) AS CALLBACK_RESPFOR_LIVEID,
MAX(IF(`API_RESP_OCCUR` = 'CALLBACK', tbl.API_RESPFOR_TXNID,'')) AS CALLBACK_RESPFOR_TXNID,
MAX(IF(`API_RESP_OCCUR` = 'CALLBACK', tbl.API_RESP_TYPE,'')) AS CALLBACK_RESP_TYPE,
CONCAT('http://appworkspay.com/api/v1/recharge_callback/',API_ID) AS CALLBACK_URL
  FROM (SELECT
  `m12_api`.`m12_api_id`                     AS `API_ID`,
  `m12_api`.`m12_api_name`                   AS `API_NAME`,
`m12_api`.`m12_api_status`                    AS `API_STATUS`,
`m12_api`.`m12_api_for`       AS `API_FOR`,
`m12_api`.`m12_api_onadd`     AS `API_ONADD`,

  `m25_api_response`.`m25_apiresp_id`         AS `API_RESP_ID`,
  `m25_api_response`.`m25_resp_occur`        AS `API_RESP_OCCUR`,
`m25_api_response`.`m25_resp_type`         AS `API_RESP_TYPE`,
  `m25_api_response`.`m25_respfor_status`    AS `API_RESP_FORSTATUS`,
  `m25_api_response`.`m25_valueof_success`   AS `API_VALUEOF_SUCCESS`,
  `m25_api_response`.`m25_valueof_pending`   AS `API_VALUEOF_PENDING`,
  `m25_api_response`.`m25_valueof_failed`    AS `API_VALUEOF_FAILED`,
  `m25_api_response`.`m25_respfor_liveid`    AS `API_RESPFOR_LIVEID`,
  `m25_api_response`.`m25_respfor_apitxnid`  AS `API_RESPFOR_TXNID`,
  `m14_api_url`.`m14_api_url_id`             AS `API_URL_ID`,
  `m14_api_url`.`m14_api_url_address`        AS `RECHARGE_URL`,  
`m14_api_url`.`m14_api_url_address_bal`    AS `BALANCE_URL`,
`m14_api_url`.`m14_api_url_address_status` AS `STATUS_URL`,
`m14_api_url`.`m14_api_url_prm`            AS `API_URL_PARAM`,
`m14_api_url`.`m14_api_url_balprm`         AS `API_URL_BALPARAM`,
`m14_api_url`.`m14_api_url_statusprm`      AS `API_URL_STATUSPARAM`,
`m14_api_url`.`m14_api_data_sendtype`      AS `API_DATA_SENDVIA`,
`m14_api_url`.`m14_api_url_method`         AS `API_URL_METHOD`,
`m14_api_url`.`m14_api_url_for`            AS `API_URL_FOR`,
`m14_api_url`.`m14_api_url_priority`       AS `API_URL_PRIORITY`,
`m14_api_url`.`m14_api_url_allowqty`       AS `API_URL_ALLOWQTY`,
`m14_api_url`.`m14_api_url_hlr`            AS `API_URL_HLR`,
`m14_api_url`.`m14_api_url_status`         AS `API_URL_STATUS`
FROM (`m12_api`
LEFT JOIN `m14_api_url`
      ON ((`m12_api`.`m12_api_id` = `m14_api_url`.`m12_api_id`))
   LEFT JOIN `m25_api_response`
     ON ((`m12_api`.`m12_api_id` = `m25_api_response`.`m12_api_id`)))
     WHERE `m12_api`.`m12_api_id` =".$id." GROUP BY `m12_api`.`m12_api_id`,`m14_api_url_id`,`m25_apiresp_id`) tbl  WHERE API_ID =".$id."  GROUP BY `API_ID`,API_URL_ID");	
    }

    /**
        * Method name   : Active
        * @description  : Used for updating api status
        * @param        : Request data with api id
        * @return       : return with updated api status
    */
    public function active($id)
    {
        return DB::update('UPDATE m12_api SET m12_api_status = case m12_api_status when "ACTIVE" then "DEACTIVE"
         when "DEACTIVE" then "ACTIVE" end WHERE m12_api_id = "'.$id.'"');
    }

	 /**
        * Method name   : Get all api
        * @description  : Used for getting all api data 
        * @param        : Request data  
        * @return       : return all api data
    */
    public function getByRoleandId($role,$id)
    {
        return DB::select('SELECT * FROM `api` WHERE CREATED_BY_ROLE = "'.$role.'" AND CREATED_BY_ID="'.$id.'"');
    }

}