<?php

namespace App\Repositories\Affiliate;

use DB;

class EloquentAffiliate implements AffiliateRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all stores
        * @description  : Used for getting all stores data 
        * @param        : Request data  
        * @return       : return all stores data
    */
    public function getAll()
    {
        return DB::table('affiliate')->get();
    }


    /**
        * Method name   : Create
        * @description  : Used for inserting store 
        * @param        : Request data  
        * @return       : return with inserting store
    */
    public function create(array $attributes)
    {
        return DB::table('m22_affiliate')->insert($attributes);
    }

    /**
        * Method name   : Update
        * @description  : Used for updating store 
        * @param        : Request data  
        * @return       : return with updating store
    */
    public function update($id, array $attributes)
    {
        return DB::table('m22_affiliate')->where('m22_affiliate_id', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting store 
        * @param        : Request data  
        * @return       : return with deleting store
    */
    public function delete($id)
    {
        return DB::table('m22_affiliate')->where('m22_affiliate_id', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single store data 
        * @param        : Request data  
        * @return       : return with deleting store
    */
    public function getById($id)
    {   
        return DB::table('m22_affiliate')->where('m22_affiliate_id', $id)->get();
    }



    /**
        * Method name   : Get by id
        * @description  : Used for getting single store data 
        * @param        : Request data  
        * @return       : return with deleting store
    */
    public function getByRegId($id)
    {   
        return DB::table('m22_affiliate')->where('m11_user_id', $id)->get();
    }


   /**
        * Method name   : Update
        * @description  : Used for updating store 
        * @param        : Request data  
        * @return       : return with updating store
    */
    public function updateByUId($id, array $attributes)
    {
        return DB::table('m22_affiliate')->where('m11_user_id', $id)->update($attributes);
    }



}


