<?php

namespace App\Repositories\AccRelService;

use DB;

class EloquentAccRelService implements AccRelServiceRepository
{
    private $model;

    public function __construct(DB $model)
    {
        $this->model = $model;
    }

    /**
        * Method name   : Get all slab
        * @description  : Used for getting all slab data 
        * @param        : Request data  
        * @return       : return all slab data
    */
    public function getAll()
    {
        $arr = DB::select("SELECT * FROM `m56_acc_rel_service`");
        return $arr;
    }

    /**
        * Method name   : Create
        * @description  : Used for inserting slab 
        * @param        : Request data  
        * @return       : return with inserting slab
    */
    public function create(array $attributes)
    {
        return DB::table('m56_acc_rel_service')->insertGetId($attributes);
    }



    /**
        * Method name   : Update
        * @description  : Used for updating slab 
        * @param        : Request data  
        * @return       : return with updating slab
    */
    public function update($id, array $attributes)
    {
        return DB::table('m56_acc_rel_service')->where('m56_acc_project', $id)->update($attributes);
    }

    /**
        * Method name   : Delete
        * @description  : Used for deleting slab 
        * @param        : Request data  
        * @return       : return with deleting slab
    */
    public function delete($id)
    {
        return DB::table('m56_acc_rel_service')->where('m56_acc_project', $id)->delete();
    }

    /**
        * Method name   : Get by id
        * @description  : Used for getting single slab data 
        * @param        : Request data  
        * @return       : return with single slab
    */
    public function getById($id)
    {   
        return DB::select("SELECT * FROM `m56_acc_rel_service` WHERE m56_acc_project = ".$id."");
    }


}




