<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Pagination\Paginator;

use App\Repositories\Associate\EloquentAssociate;
use App\Repositories\Associate\AssociateRepository;
use App\Repositories\Enroll\EloquentEnroll;
use App\Repositories\Enroll\EnrollRepository;
use App\Repositories\Employee\EloquentEmployee;
use App\Repositories\Employee\EmployeeRepository;
use App\Repositories\Ticket\EloquentTicket;
use App\Repositories\Ticket\TicketRepository;
use App\Repositories\Topup\EloquentTopup;
use App\Repositories\Topup\TopupRepository;
use App\Repositories\Team\EloquentTeam;
use App\Repositories\Team\TeamRepository;
use App\Repositories\Closing\EloquentClosing;
use App\Repositories\Closing\ClosingRepository;
use App\Repositories\Master\Bank\EloquentBank;
use App\Repositories\Master\Bank\BankRepository;
use App\Repositories\Master\Configuration\EloquentConfiguration;
use App\Repositories\Master\Configuration\ConfigurationRepository;
use App\Repositories\Master\Content\EloquentContent;
use App\Repositories\Master\Content\ContentRepository;
use App\Repositories\Master\Events\EloquentEvents;
use App\Repositories\Master\Events\EventsRepository;
use App\Repositories\Master\Location\EloquentLocation;
use App\Repositories\Master\Location\LocationRepository;
use App\Repositories\Master\Message\EloquentMessage;
use App\Repositories\Master\Message\MessageRepository;
use App\Repositories\Master\Operator\EloquentOperator;
use App\Repositories\Master\Operator\OperatorRepository;
use App\Repositories\Master\Package\EloquentPackage;
use App\Repositories\Master\Package\PackageRepository;
use App\Repositories\Master\Service\EloquentService;
use App\Repositories\Master\Service\ServiceRepository;
use App\Repositories\Master\AdminBank\EloquentAdminBank;
use App\Repositories\Master\AdminBank\AdminBankRepository;
use App\Repositories\Master\Banner\EloquentBanner;
use App\Repositories\Master\Banner\BannerRepository;
use App\Repositories\Master\Translation\EloquentTranslation;
use App\Repositories\Master\Translation\TranslationRepository;
use App\Repositories\Master\Assignmenu\EloquentAssignmenu;
use App\Repositories\Master\Assignmenu\AssignmenuRepository;
use App\Repositories\Master\Usermenu\EloquentUsermenu;
use App\Repositories\Master\Usermenu\UsermenuRepository;
use App\Repositories\ProductModule\Products\EloquentProducts;
use App\Repositories\ProductModule\Products\ProductsRepository;
use App\Repositories\ProductModule\Categories\EloquentCategories;
use App\Repositories\ProductModule\Categories\CategoriesRepository;
use App\Repositories\ProductModule\Brand\EloquentBrand;
use App\Repositories\ProductModule\Brand\BrandRepository;
use App\Repositories\ProductModule\Optiongroup\EloquentOptiongroup;
use App\Repositories\ProductModule\Optiongroup\OptiongroupRepository;
use App\Repositories\ProductModule\Unit\EloquentUnit;
use App\Repositories\ProductModule\Unit\UnitRepository;
use App\Repositories\Fund\EloquentFund;
use App\Repositories\Fund\FundRepository;
use App\Repositories\Profile\EloquentProfile;
use App\Repositories\Profile\ProfileRepository;
use App\Repositories\Log\EloquentLog;
use App\Repositories\Log\LogRepository;

use App\Repositories\Recharge\Rechargeprocess\EloquentRechargeprocess;
use App\Repositories\Recharge\Rechargeprocess\RechargeprocessRepository;
use App\Repositories\Recharge\Rechargereport\EloquentRechargereport;
use App\Repositories\Recharge\Rechargereport\RechargereportRepository;

use App\Repositories\Dmt\Dmtprocess\EloquentDmtprocess;
use App\Repositories\Dmt\Dmtprocess\DmtprocessRepository;
use App\Repositories\Dmt\Dmtreport\EloquentDmtreport;
use App\Repositories\Dmt\Dmtreport\DmtreportRepository;

use App\Repositories\AEPS\AEPSprocess\EloquentAEPSprocess;
use App\Repositories\AEPS\AEPSprocess\AEPSprocessRepository;
use App\Repositories\AEPS\AEPSreport\EloquentAEPSreport;
use App\Repositories\AEPS\AEPSreport\AEPSreportRepository;

use App\Repositories\BBPS\BBPSprocess\EloquentBBPSprocess;
use App\Repositories\BBPS\BBPSprocess\BBPSprocessRepository;
use App\Repositories\BBPS\BBPSreport\EloquentBBPSreport;
use App\Repositories\BBPS\BBPSreport\BBPSreportRepository;

use App\Repositories\Billpay\Billpayprocess\EloquentBillpayprocess;
use App\Repositories\Billpay\Billpayprocess\BillpayprocessRepository;
use App\Repositories\Billpay\Billpayreport\EloquentBillpayreport;
use App\Repositories\Billpay\Billpayreport\BillpayreportRepository;

use App\Repositories\Category\EloquentCategory;
use App\Repositories\Category\CategoryRepository;
use App\Repositories\Vendor\EloquentVendor;
use App\Repositories\Vendor\VendorRepository;
use App\Repositories\Product\EloquentProduct;
use App\Repositories\Product\ProductRepository;
use App\Repositories\Store\EloquentStore;
use App\Repositories\Store\StoreRepository;
use App\Repositories\Slab\EloquentSlab;
use App\Repositories\Slab\SlabRepository;
use App\Repositories\Api\EloquentApi;
use App\Repositories\Api\ApiRepository;
use App\Repositories\Notification\NotificationRepository;
use App\Repositories\Notification\NotificationEloquent;
use App\Repositories\Campaign\CampaignRepository;
use App\Repositories\Campaign\EloquentCampaign;
use App\Repositories\AccRelService\EloquentAccRelService;
use App\Repositories\AccRelService\AccRelServiceRepository;
use App\Repositories\Industry\EloquentIndustry;
use App\Repositories\Industry\IndustryRepository;
use App\Repositories\LeadSource\EloquentLeadSource;
use App\Repositories\LeadSource\LeadSourceRepository;
use App\Repositories\LeadStatus\EloquentLeadStatus;
use App\Repositories\LeadStatus\LeadStatusRepository;
use App\Repositories\LeadProduct\EloquentLeadProduct;
use App\Repositories\LeadProduct\LeadProductRepository;

use App\Repositories\App\EloquentApp;
use App\Repositories\App\AppRepository;
use App\Repositories\Master\Role\EloquentRole;
use App\Repositories\Master\Role\RoleRepository;

use App\Repositories\Affiliate\EloquentAffiliate;
use App\Repositories\Affiliate\AffiliateRepository;

use App\Repositories\Master\WlConfig\EloquentWlConfig;
use App\Repositories\Master\WlConfig\WlConfigRepository;

use App\Repositories\Shop\EloquentShop;
use App\Repositories\Shop\ShopRepository;

use App\Repositories\DenominationRange\EloquentDenominationRange;
use App\Repositories\DenominationRange\DenominationRangeRepository;
use App\Repositories\Denomination\EloquentDenomination;
use App\Repositories\Denomination\DenominationRepository;

use App\Repositories\Master\BalanceDeductionTypes\EloquentBalanceDeductionTypes;
use App\Repositories\Master\BalanceDeductionTypes\BalanceDeductionTypesRepository;

use App\Repositories\Master\LevelCommissionType\EloquentLevelCommissionTypes;
use App\Repositories\Master\LevelCommissionType\LevelCommissionTypesRepository;

use App\Repositories\ProductModule\Favorites\EloquentFavorites;
use App\Repositories\ProductModule\Favorites\FavoritesRepository;

use App\Repositories\ProductModule\ParentCategories\EloquentParentCategories;
use App\Repositories\ProductModule\ParentCategories\ParentCategoriesRepository;

use App\Repositories\ProductModule\UserOrders\EloquentUserOrders;
use App\Repositories\ProductModule\UserOrders\UserOrdersRepository;

use App\Repositories\ProductModule\Wishlist\EloquentWishlist;
use App\Repositories\ProductModule\Wishlist\WishlistRepository;

use App\Repositories\ProductModule\UserAddress\EloquentUserAddress;
use App\Repositories\ProductModule\UserAddress\UserAddressRepository;

use App\Repositories\ProductModule\OnlinePayment\EloquentOnlinePayment;
use App\Repositories\ProductModule\OnlinePayment\OnlinePaymentRepository;

use App\Repositories\ProductModule\ProductVariant\EloquentProductVariant;
use App\Repositories\ProductModule\ProductVariant\ProductVariantRepository;

use App\Repositories\ProductModule\OptionType\EloquentOptionType;
use App\Repositories\ProductModule\OptionType\OptionTypeRepository;

use App\Repositories\ProductModule\Market\EloquentMarket;
use App\Repositories\ProductModule\Market\MarketRepository;

use App\Repositories\Pantoken\EloquentPantoken;
use App\Repositories\Pantoken\PantokenRepository;

use App\Repositories\Master\Imagesize\EloquentImagesize;
use App\Repositories\Master\Imagesize\ImagesizeRepository;


use App\Repositories\ProductModule\OrdersSiping\EloquentOrdersSiping;
use App\Repositories\ProductModule\OrdersSiping\OrdersSipingRepository;

use DB;
use Session;


class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton(AssociateRepository::class,  EloquentAssociate::class);
        $this->app->singleton(EnrollRepository::class,  EloquentEnroll::class);
        $this->app->singleton(EmployeeRepository::class,  EloquentEmployee::class);
        $this->app->singleton(TicketRepository::class,  EloquentTicket::class);
        $this->app->singleton(TopupRepository::class,  EloquentTopup::class);
        $this->app->singleton(TeamRepository::class,  EloquentTeam::class);
        $this->app->singleton(ClosingRepository::class,  EloquentClosing::class);
        $this->app->singleton(BankRepository::class,  EloquentBank::class);
        $this->app->singleton(ConfigurationRepository::class,  EloquentConfiguration::class);
        $this->app->singleton(ContentRepository::class,  EloquentContent::class);
        $this->app->singleton(EventsRepository::class,  EloquentEvents::class);
        $this->app->singleton(LocationRepository::class,  EloquentLocation::class);
        $this->app->singleton(MessageRepository::class,  EloquentMessage::class);
        $this->app->singleton(OperatorRepository::class,  EloquentOperator::class);
        $this->app->singleton(PackageRepository::class,  EloquentPackage::class);
        $this->app->singleton(ServiceRepository::class,  EloquentService::class);
        $this->app->singleton(AdminBankRepository::class,  EloquentAdminBank::class);
        $this->app->singleton(BannerRepository::class,  EloquentBanner::class);
        $this->app->singleton(TranslationRepository::class,  EloquentTranslation::class);
        $this->app->singleton(FundRepository::class,  EloquentFund::class);
        $this->app->singleton(ProfileRepository::class,  EloquentProfile::class);
        $this->app->singleton(LogRepository::class,  EloquentLog::class);
        $this->app->singleton(CategoryRepository::class,  EloquentCategory::class);
        $this->app->singleton(VendorRepository::class,  EloquentVendor::class);
        $this->app->singleton(ProductRepository::class,  EloquentProduct::class);
        $this->app->singleton(StoreRepository::class,  EloquentStore::class);
        $this->app->singleton(SlabRepository::class,  EloquentSlab::class);
        $this->app->singleton(ApiRepository::class,  EloquentApi::class);
        $this->app->singleton(ProductsRepository::class,  EloquentProducts::class);
        $this->app->singleton(CategoriesRepository::class,  EloquentCategories::class);
        $this->app->singleton(BrandRepository::class,  EloquentBrand::class);
        $this->app->singleton(OptiongroupRepository::class,  EloquentOptiongroup::class);
        $this->app->singleton(UnitRepository::class,  EloquentUnit::class);
        $this->app->singleton(AssignmenuRepository::class,  EloquentAssignmenu::class);
        $this->app->singleton(UsermenuRepository::class,  EloquentUsermenu::class);
        $this->app->singleton(NotificationRepository::class, NotificationEloquent::class);
        $this->app->singleton(RechargeprocessRepository::class,  EloquentRechargeprocess::class);
        $this->app->singleton(RechargereportRepository::class,  EloquentRechargereport::class);
        $this->app->singleton(DmtprocessRepository::class,  EloquentDmtprocess::class);
        $this->app->singleton(DmtreportRepository::class,  EloquentDmtreport::class);
        $this->app->singleton(AEPSprocessRepository::class,  EloquentAEPSprocess::class);
        $this->app->singleton(AEPSreportRepository::class,  EloquentAEPSreport::class);
        $this->app->singleton(BBPSprocessRepository::class,  EloquentBBPSprocess::class);
        $this->app->singleton(BBPSreportRepository::class,  EloquentBBPSreport::class);
        $this->app->singleton(BillpayprocessRepository::class,  EloquentBillpayprocess::class);
        $this->app->singleton(BillpayreportRepository::class,  EloquentBillpayreport::class);
        $this->app->singleton(CampaignRepository::class, EloquentCampaign::class);
        $this->app->singleton(AccRelServiceRepository::class, EloquentAccRelService::class);
        $this->app->singleton(IndustryRepository::class, EloquentIndustry::class);
        $this->app->singleton(LeadSourceRepository::class, EloquentLeadSource::class);
        $this->app->singleton(LeadStatusRepository::class, EloquentLeadStatus::class);
        $this->app->singleton(LeadProductRepository::class, EloquentLeadProduct::class);
        $this->app->singleton(AppRepository::class, EloquentApp::class);
        $this->app->singleton(RoleRepository::class, EloquentRole::class);
        $this->app->singleton(AffiliateRepository::class,  EloquentAffiliate::class);
        $this->app->singleton(WlConfigRepository::class,  EloquentWlConfig::class);
        $this->app->singleton(ShopRepository::class,  EloquentShop::class);
        $this->app->singleton(DenominationRangeRepository::class, EloquentDenominationRange::class);
        $this->app->singleton(DenominationRepository::class, EloquentDenomination::class);
        $this->app->singleton(BalanceDeductionTypesRepository::class, EloquentBalanceDeductionTypes::class);

        $this->app->singleton(LevelCommissionTypesRepository::class, EloquentLevelCommissionTypes::class);

        $this->app->singleton(PantokenRepository::class, EloquentPantoken::class);


        $this->app->singleton(FavoritesRepository::class, EloquentFavorites::class);
        $this->app->singleton(ParentCategoriesRepository::class, EloquentParentCategories::class);
        $this->app->singleton(UserOrdersRepository::class, EloquentUserOrders::class);
        $this->app->singleton(EmpLogRepository::class, EloquentEmpLog::class);
        $this->app->singleton(WishlistRepository::class, EloquentWishlist::class);
        $this->app->singleton(UserAddressRepository::class, EloquentUserAddress::class);
        $this->app->singleton(MarketRepository::class, EloquentMarket::class);
        $this->app->singleton(OnlinePaymentRepository::class, EloquentOnlinePayment::class);
        $this->app->singleton(ProductVariantRepository::class, EloquentProductVariant::class);
        $this->app->singleton(OptionTypeRepository::class, EloquentOptionType::class);
        $this->app->singleton(OrdersSipingRepository::class, EloquentOrdersSiping::class);
        
        $this->app->singleton(ImagesizeRepository::class,  EloquentImagesize::class);
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
     public function boot()
    {
        $request = request();
        $host=$request->server('HTTP_HOST');
        $ip = $request->ip();
// dd($ip,$host);
// if($ip!="122.162.177.56")
// {

//     dd('We are working on that');
// }
        
		if($host=="127.0.0.1" || $host=="localhost" || $host=="etglive.com" || $host=="www.etglive.com")
		{

            $result= DB::select('SELECT m00_name,m00_value FROM m00_setconfig');
            foreach ($result as $key => $value)
            {
             $res[$value->m00_name] = $value->m00_value;

                if($value->m00_name == 'EMAIL_SEND_URL')
                {
                    $res['mail.mailers.smtp.host'] = $value->m00_value;
                } 
                if($value->m00_name == 'EMAIL_PORT')
                {
                    $res['mail.mailers.smtp.port'] = $value->m00_value;
                }
                if($value->m00_name == 'EMAIL_ENCRYPTION')
                {
                    $res['mail.mailers.smtp.encryption'] = $value->m00_value;
                }
                if($value->m00_name == 'EMAIL')
                {
                    $res['mail.mailers.smtp.username'] = $value->m00_value;
                }
                if($value->m00_name == 'EMAIL_PASSWORD')
                {
                    $res['mail.mailers.smtp.password'] = $value->m00_value;
                }
            }
			$res['AFFID'] = 1;
		}
		else
		{
		    
			$result0= DB::select("SELECT `m22_affiliate_id` AS affid FROM `m22_affiliate` WHERE  `m22_affiliate_web_url`='".$host."' OR `m22_affiliate_web_url2`='".$host."' LIMIT 1");

			if($result0){
			$AFFID=$result0[0]->affid;
			$result= DB::select('SELECT m00_name,m00_value FROM m00_setconfig_wl WHERE m00_affid='.$AFFID);
			foreach ($result as $key => $value) {
			 $res[$value->m00_name] = $value->m00_value;

                if($value->m00_name == 'EMAIL_SEND_URL')
                {
                    $res['mail.mailers.smtp.host'] = $value->m00_value;
                } 
                if($value->m00_name == 'EMAIL_PORT')
                {
                    $res['mail.mailers.smtp.port'] = $value->m00_value;
                }
                if($value->m00_name == 'EMAIL_ENCRYPTION')
                {
                    $res['mail.mailers.smtp.encryption'] = $value->m00_value;
                }
                if($value->m00_name == 'EMAIL')
                {
                    $res['mail.mailers.smtp.username'] = $value->m00_value;
                }
                if($value->m00_name == 'EMAIL_PASSWORD')
                {
                    $res['mail.mailers.smtp.password'] = $value->m00_value;
                }
			}
			$res['AFFID'] = $AFFID;
			}
			else
			{
			   return abort(404);
			}
		}
		//dd($res);
        config($res);

    }
}
