<?php
 
namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Storage;
use DB;

class SendMail extends Mailable
{

    use Queueable, SerializesModels;

    public $data;
    public $template_type;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data, $template_type)
    {
        $this->data = $data;
        $this->template_type = $template_type;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        if($this->template_type==1) 
        {
            $template_data = $this->data;
            if($template_data['pdf']!="")
            {
                
                return $this->from(config('EMAIL'), $template_data['MSG_SUBJECT'])
                ->subject($template_data['MSG_SUBJECT'])
				->view('Email.'.$template_data['template_name'])
				->with('data', $template_data)
                ->attach(storage_path('app/'.$template_data['pdf']), [
                     'as' => $template_data['pdf'],
                     'mime' => 'application/pdf',
                ]);
            }
            else {
						if(session()->get('USER_TYPE') == ''){ $rolID = $template_data['USER_TYPE']; }
						else{ $rolID = session()->get('USER_TYPE'); }
						if(session()->get('USER_ID') == ''){ $userID = $template_data['USER_ID']; }else{ $userID =  session()->get('USER_ID'); }
						if($rolID == '-1'){ $rolID =1; }
						elseif($rolID == ''){ $rolID =1;  }
						else{ $rolID = $rolID; }
						if($rolID == 10){ $rolID = 3; }

						DB::table('m52_email_campaign')->insert([
							'm52_send_by' => $rolID,
							'm52_send_by_id' => $userID,
							'm52_send_to' => $template_data['useremail'],
							'm52_send_cc' => '',
							'm52_send_bcc' =>'',
							'm52_subject' => $template_data['MSG_SUBJECT'],
							'm52_desc' => "'".$template_data['MSG_CONTENT']."'",
							'm52_type' => 2
						]);
                        
					return $this->from(config('EMAIL'), $template_data['MSG_SUBJECT'])
							->subject($template_data['MSG_SUBJECT'])
							->view('Email.'.$template_data['template_name'])
							->with('data', $template_data);

            }
        }
    }
}