<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\Category\CategoryRepository;
use App\Repositories\Vendor\VendorRepository;
use App\Repositories\Product\ProductRepository;
use App\Repositories\Enroll\EnrollRepository;
use App\Repositories\Master\Location\LocationRepository;
use App\Repositories\Store\StoreRepository;
use DB;
use Image;
use Session;
use Helper;

class VendorController extends Controller
{

	private $category_repo;
	private $vendor_repo;
	private $product_repo;
	private $enroll_repo;
	private $store_repo;

	public function __construct(CategoryRepository $category_repo, VendorRepository $vendor_repo,
		ProductRepository $product_repo, EnrollRepository $enroll_repo, LocationRepository $loc_repo,
		StoreRepository $store_repo)
    {
    	$this->category_repo = $category_repo;
    	$this->vendor_repo = $vendor_repo;
    	$this->product_repo = $product_repo;
    	$this->enroll_repo = $enroll_repo;
    	$this->loc_repo = $loc_repo;
    	$this->store_repo = $store_repo;
    }

    /**
        * Method name   : Category
        * @description  : Used for getting all categories
        * @param        : Request data  
        * @return       : return with all categories
    */
    public function category($id = '')
    {
        $singlecategory = '';
        $category = $this->category_repo->getAllCategory();
        if( $id != '' ){
            $singlecategory = $this->category_repo->getById($id);
        }
        return view('Vendor.category', compact('category', 'singlecategory'));
    }

    /**
        * Method name   : Add Category
        * @description  : Used for adding category
        * @param        : Request data  
        * @return       : return with added category
    */
    public function add_category(Request $request)
    {

        $this->validate($request, [
            'txt_name'=> 'required',
            'txt_desc'=> 'required',
        ],[
            'txt_name.required'=> 'Category Name is required',
            'txt_desc.required'=> 'Category Description is required',
        ]);
       
        $arr = array(
            'm02_cat_name' => $request->input('txt_name'),
            'm02_parent_id' => 0,
            'm02_cat_desc' => $request->input('txt_desc'),
            'm02_status' => 0,
        );

        $this->category_repo->create($arr);
        Session::flash('cat_msg','CATEGORY ADDED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/category');
    }

    /**
        * Method name   : Update Category
        * @description  : Used for updating category
        * @param        : Request data  
        * @return       : return with updated category
    */
    public function update_category(Request $request, $cat_id)
    {

        $this->validate($request, [
            'txt_name'=> 'required',
            'txt_desc'=> 'required',
        ],[
            'txt_name.required'=> 'Category Name is required',
            'txt_desc.required'=> 'Category Description is required',
        ]);
       
        $arr = array(
            'm02_cat_name' => $request->input('txt_name'),
            'm02_parent_id' => 0,
            'm02_cat_desc' => $request->input('txt_desc'),
            'm02_status' => 0,
        );

        $this->category_repo->update($cat_id, $arr);
        Session::flash('cat_msg','CATEGORY UPDATED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/category');
    }

    /**
        * Method name   : SubCategory
        * @description  : Used for getting all subcategory
        * @param        : Request data  
        * @return       : return with  all subcategory
    */
    public function subcategory($id = '')
    {
        $singlecategory = '';

        $category = $this->category_repo->getAllCategory();
        $subcategory = $this->category_repo->getAllSubcategory();

        if( $id != '' ){
            $singlecategory = $this->category_repo->getById($id);
        }
        return view('Vendor.subcategory', compact('category', 'singlecategory', 'subcategory'));
    }

    /**
        * Method name   : Add SubCategory
        * @description  : Used for adding subcategory
        * @param        : Request data  
        * @return       : return with added subcategory
    */
    public function add_subcategory(Request $request)
    {

        $this->validate($request, [
            'txt_name'=> 'required',
            'txt_desc'=> 'required',
        ],[
            'txt_name.required'=> 'Category Name is required',
            'txt_desc.required'=> 'Category Description is required',
        ]);
       
        $arr = array(
            'm02_cat_name' => $request->input('txt_name'),
            'm02_parent_id' => $request->input('ddcat'),
            'm02_cat_desc' => $request->input('txt_desc'),
            'm02_status' => 1,
        );

        $this->category_repo->create($arr);
        Session::flash('subcat_msg','SUBCATEGORY ADDED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/subcategory');
    }

    /**
        * Method name   : Update SubCategory
        * @description  : Used for updating subcategory
        * @param        : Request data  
        * @return       : return with updated subcategory
    */
    public function update_subcategory(Request $request, $subcat_id)
    {

        $this->validate($request, [
            'txt_name'=> 'required',
            'txt_desc'=> 'required',
        ],[
            'txt_name.required'=> 'Category Name is required',
            'txt_desc.required'=> 'Category Description is required',
        ]);
       
        $arr = array(
            'm02_cat_name' => $request->input('txt_name'),
            'm02_parent_id' => $request->input('ddcat'),
            'm02_cat_desc' => $request->input('txt_desc'),
            'm02_status' => 1,
        );

        $this->category_repo->update($subcat_id, $arr);
        Session::flash('subcat_msg','SUBCATEGORY UPDATED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/subcategory');
    }

    /**
        * Method name   : Get SubCategory
        * @description  : Used for getting subcategory
        * @param        : Request data  
        * @return       : return with all subcategory
    */
    public function get_subcat(Request $request)
    {
        $id = $request->id;    
        $data = $this->category_repo->getByParentId($id);;
        $output = '<option>Select Sub-Category Name</option>';
        foreach($data as $value)
        {
            $output .= '<option value="'.$value->m02_cat_id.'">'.$value->m02_cat_name.'</option>';
        }
        echo $output;
    }

    /**
        * Method name   : Vendor
        * @description  : Used for getting vendor
        * @param        : Request data  
        * @return       : return with all vendor
    */
    public function vendor($id='')
    {
        $single_vendor = '';
        $vendor = $this->vendor_repo->getAll();
        if($id!=''){
            $single_vendor = $this->vendor_repo->getById($id);
        }
        return view('Vendor.vendor', compact('vendor', 'single_vendor'));
    }

    /**
        * Method name   : Add Vendor
        * @description  : Used for adding vendor
        * @param        : Request data  
        * @return       : return with added vendor
    */
    public function add_vendor()
    {
        $request = request();

        $this->validate($request, [
            'txt_vendor'=> 'required',
            'txt_venderdesc'=> 'required',
        ],[
            'txt_vendor.required'=> 'Vendor Name is required',
            'txt_venderdesc.required'=> 'Vendor Description is required',
        ]);

        if( $request->file('vendor_icon') != ''){
            $image = $request->file('vendor_icon');
            $name1 = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/vendor/');
            $image->move($destinationPath, $name1);
        }else{
            $name1 = "";
        }

        $arr = array(
            'm40_vendor_name' => $request->input('txt_vendor'),
            'm40_vendor_url' => $request->input('txt_vendorurl'),
            'm40_vendor_desc' => $request->input('txt_venderdesc'),
            'm40_vendor_logo' => $name1,
            'm40_vendor_status' => 1,
            'm40_vendor_date' => date('Y-m-d H:i:s')
        );
        $this->vendor_repo->create($arr);
        Session::flash('vendor_msg','VENDOR ADDED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/vendor_entry');
    }

    /**
        * Method name   : Update Vendor
        * @description  : Used for updating vendor
        * @param        : Request data  
        * @return       : return with updated vendor
    */
    public function update_vendor($id)
    {
        $request = request();

        $this->validate($request, [
            'txt_vendor'=> 'required',
            'txt_venderdesc'=> 'required',
        ],[
            'txt_vendor.required'=> 'Vendor Name is required',
            'txt_venderdesc.required'=> 'Vendor Description is required',
        ]);

        if( $request->file('vendor_icon') != ''){
            $image = $request->file('vendor_icon');
            $name1 = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/vendor/');
            $image->move($destinationPath, $name1);
        }
        $arr = array(
            'm40_vendor_name' => $request->input('txt_vendor'),
            'm40_vendor_url' => $request->input('txt_vendorurl'),
            'm40_vendor_desc' => $request->input('txt_venderdesc')
        );
        $this->vendor_repo->update($id, $arr);
        Session::flash('vendor_msg','VENDOR UPDATED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/vendor_entry');
    }

    /**
        * Method name   : Product Detail
        * @description  : Used for all product details
        * @param        : Request data  
        * @return       : return with all product details
    */
    public function product_detail($id='')
    {
        $single_product = '';
        $category = $this->category_repo->getAllCategory();
        $subcategory =  $this->category_repo->getAllSubcategory();
        $vendor = $this->vendor_repo->getAll();
        $product = $this->product_repo->getAll();
        if($id!=''){
            $single_product = $this->product_repo->getById($id);
        }
        return view('Vendor.product', compact('category', 'subcategory', 'product', 'single_product', 'vendor'));
    }

    /**
        * Method name   : Add Product
        * @description  : Used for adding product
        * @param        : Request data  
        * @return       : return with added product
    */
    public function add_product(){
        $request = request();

        $this->validate($request, [
            'txt_prodname'=> 'required',
            'dd_subprodcat'=> 'required',
            'dd_vndr'=> 'required',
            'txt_prodwt'=> 'required',
            'txt_price'=> 'required',
            'txt_dprice'=> 'required',
            'txt_gst'=> 'required',
            'txt_sgst'=> 'required',
            'txt_probatch'=> 'required',
            'txt_expdate'=> 'required',
        ],[
            'txt_prodname.required'=> 'Product Name is required',
            'dd_subprodcat.required'=> 'Category is required',
            'dd_vndr.required'=> 'Vendor Name is required',
            'txt_prodwt.required'=> 'Product weight is required',
            'txt_price.required'=> 'Product price is required',
            'txt_dprice.required'=> 'Product discount price is required',
            'txt_gst.required'=> 'Product gst is required',
            'txt_sgst.required'=> 'Product sgst is required',
            'txt_probatch.required'=> 'Product batch is required',
            'txt_expdate.required'=> 'Expiry date is required',
        ]);

        $img = $request->file('prod_fimg');

        if(isset($img[0]) && ($img[0] != '')){
            $image1 = $img[0];
            $name1 = time().'.'.$image1->getClientOriginalExtension();
            $destinationPath = public_path('/images/vendor/');
            $image1->move($destinationPath, $name1);
        }else{
            $name1 = '';
        }

        if(isset($img[1]) && ($img[1] != '')){
            $image2 = $img[1];
            $name2 = time().'.'.$image2->getClientOriginalExtension();
            $destinationPath = public_path('/images/vendor/');
            $image2->move($destinationPath, $name2);
        }else{
            $name2 = '';
        }

        $arr = array(
            'm41_product_code' => '',
            'm41_product_name' => $request->input('txt_prodname'),
            'm41_product_category' => $request->input('dd_subprodcat'),
            'm41_product_vendor' => $request->input('dd_vndr'),
            'm41_product_weight' => $request->input('txt_prodwt'),
            'm41_product_price' => $request->input('txt_price'),
            'm41_product_dp' => $request->input('txt_dprice'),
            'm41_product_fimage' => $name1,
            'm41_product_image' => $name2,
            'm41_product_str_desc' => $request->input('txt_prodstrdesc'),
            'm41_product_desc' => $request->input('txt_proddesc'),
            'm41_product_store' => 0,
            'm41_product_bussn_volume' => $request->input('txt_prodbussvol'),
            'm41_product_status' => 1,
            'gst' => $request->input('txt_gst'),
            'sgst' => $request->input('txt_sgst'),
            'txt_sub_cat' => $request->input('dd_subprodcat'),
            'm41_haxcode' => $request->input('txt_haxcode'),
            'm41_product_date' => date('Y-m-d H:i:s'),
            'm41_product_batch' => $request->input('txt_probatch'),
            'm41_product_expiry' => $request->input('txt_expdate')
        );
        $this->product_repo->create($arr);
        Session::flash('product_msg','PRODUCT ADDED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/product_detail');
    }

    /**
        * Method name   : Update Product
        * @description  : Used for updating product
        * @param        : Request data  
        * @return       : return with updated product
    */
    public function update_product($id){
        $request = request();

        $img = $request->file('prod_fimg');

        if(isset($img[0]) && ($img[0] != '')){
            $image1 = $img[0];
            $name1 = time().'.'.$image1->getClientOriginalExtension();
            $destinationPath = public_path('/images/vendor/');
            $image1->move($destinationPath, $name1);
        }else{
            $name1 = '';
        }

        if(isset($img[1]) && ($img[1] != '')){
            $image2 = $img[1];
            $name2 = time().'.'.$image2->getClientOriginalExtension();
            $destinationPath = public_path('/images/vendor/');
            $image2->move($destinationPath, $name2);
        }else{
            $name2 = '';
        }

        $this->validate($request, [
            'txt_prodname'=> 'required',
            'dd_subprodcat'=> 'required',
            'dd_vndr'=> 'required',
            'txt_prodwt'=> 'required',
            'txt_price'=> 'required',
            'txt_dprice'=> 'required',
            'txt_gst'=> 'required',
            'txt_sgst'=> 'required',
            'txt_probatch'=> 'required',
            'txt_expdate'=> 'required',
        ],[
            'txt_prodname.required'=> 'Product Name is required',
            'dd_subprodcat.required'=> 'Category is required',
            'dd_vndr.required'=> 'Vendor Name is required',
            'txt_prodwt.required'=> 'Product weight is required',
            'txt_price.required'=> 'Product price is required',
            'txt_dprice.required'=> 'Product discount price is required',
            'txt_gst.required'=> 'Product gst is required',
            'txt_sgst.required'=> 'Product sgst is required',
            'txt_probatch.required'=> 'Product batch is required',
            'txt_expdate.required'=> 'Expiry date is required',
        ]);

        $arr = array(
            'm41_product_code' => '',
            'm41_product_name' => $request->input('txt_prodname'),
            'm41_product_category' => $request->input('dd_subprodcat'),
            'm41_product_vendor' => $request->input('dd_vndr'),
            'm41_product_weight' => $request->input('txt_prodwt'),
            'm41_product_price' => $request->input('txt_price'),
            'm41_product_dp' => $request->input('txt_dprice'),
            'm41_product_fimage' => $name1,
            'm41_product_image' => $name2,
            'm41_product_str_desc' => $request->input('txt_prodstrdesc'),
            'm41_product_desc' => $request->input('txt_proddesc'),
            'm41_product_store' => 0,
            'm41_product_bussn_volume' => $request->input('txt_prodbussvol'),
            'm41_product_status' => 1,
            'gst' => $request->input('txt_gst'),
            'sgst' => $request->input('txt_sgst'),
            'txt_sub_cat' => $request->input('dd_subprodcat'),
            'm41_haxcode' => $request->input('txt_haxcode'),
            'm41_product_date' => date('Y-m-d H:i:s'),
            'm41_product_batch' => $request->input('txt_probatch'),
            'm41_product_expiry' => $request->input('txt_expdate')
        );
        $this->product_repo->update($id, $arr);
        Session::flash('product_msg','PRODUCT UPDATED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/product_detail');
    }

    /**
        * Method name   : Delete Product
        * @description  : Used for deleting product
        * @param        : Request data  
        * @return       : return with deleted product
    */
    public function delete_product($id){
        $request = request();
        $this->product_repo->delete($id);
        return redirect('/product_detail');
    }

    /**
        * Method name   : Product Stock
        * @description  : Used for product stock
        * @param        : Request data  
        * @return       : return with product stock
    */
    public function product_stock($id=''){
        $single_stock = '';
        $product = $this->product_repo->getAll();
        $stock = $this->product_repo->getAllProdStock();
        if($id!=''){
            $single_stock = $this->product_repo->getStockByProdId($id);
        }
        return view('Vendor.prod_stock', compact('product', 'stock', 'single_stock'));
    }

    /**
        * Method name   : Add Stock
        * @description  : Used for adding product stock
        * @param        : Request data  
        * @return       : return with added product stock
    */
    public function add_stock(){
        $request = request();

        $arr = array(
            'm42_product_id' => $request->input('dd_prodid'),
            'm42_stock_qty_cr' => $request->input('txt_qtycr'),
            'm42_stock_qty_dr' => $request->input('txt_qtydr'),
            'm42_stock_date' => date('Y-m-d H:i:s'),
            'm42_stock_alert' => $request->input('txt_stockalert'),
            'm42_stock_unit' => $request->input('txt_stockunit'),
            'm42_stock_usertype' => $request->input('dd_user'),
            'm42_stock_uid' => $request->input('dd_user')
        );
        $this->product_repo->createStock($arr);
        Session::flash('message','PRODUCT STOCK ADDED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/product_stock');
    }

    /**
        * Method name   : Get user
        * @description  : Used for getting user data
        * @param        : Request data  
        * @return       : return with user data
    */
    public function get_user(){
        $request = request();
        $user_id = $request->userid;
        $single_user = $this->enroll_repo->getById($user_id);
        return response()->json($single_user);
    }

    /**
        * Method name   : Store
        * @description  : Used for getting all stores
        * @param        : Request data  
        * @return       : return with all stores
    */
    public function store($id=''){
        $single_store = '';
        $state = $this->loc_repo->getAllStates();
        $store = $this->store_repo->getAll();
        if($id!=''){
            $single_store = $this->store_repo->getById($id);
        }
        return view('Vendor.store', compact('state', 'store', 'single_store'));
    }

    /**
        * Method name   : Add Store
        * @description  : Used for adding store
        * @param        : Request data  
        * @return       : return with added stores
    */
    public function add_store(){
        $request = request();

        $this->validate($request, [
            'txt_storename'=> 'required',
            'txt_storeemail'=> 'required',
            'txt_userid'=> 'required',
            'txt_pass'=> 'required',
            'dd_state'=> 'required',
            'txt_storeadd'=> 'required',
            'txt_gst'=> 'required'
        ],[
            'txt_storename.required'=> 'Store Name is required',
            'txt_storeemail.required'=> 'Email is required',
            'txt_userid.required'=> 'Store User Id is required',
            'txt_pass.required'=> 'Password is required',
            'dd_state.required'=> 'State is required',
            'txt_storeadd.required'=> 'Address is required',
            'txt_gst.required'=> 'GST is required'
        ]);

        $no = rand(100000,999999);
        $code = 'MJ'.$no;

        if($request->input('txt_userid')){
            $store_code = $request->input('txt_userid');
        }
        else{
            $store_code = $code;
        }
        $arr = array(
            'm44_store_name' => $request->input('txt_storename'),
            'm44_store_email' => $request->input('txt_storeemail'),
            'm44_store_uid' => $no,
            'm44_store_userid' => $store_code,
            'm44_store_pass' => $request->input('txt_pass'),
            'm44_store_pinpass' => $request->input('txt_pass'),
            'm44_store_state' => $request->input('dd_state'),
            'm44_store_address' => $request->input('txt_storeadd'),
            'm44_store_gst' => $request->input('txt_gst'),
            'm44_store_licnace' => $request->input('txt_licno'),
            'm44_store_description' => $request->input('txt_storedesc'),
            'm44_store_status' => 1,
            'm44_store_date' => date('Y-m-d H:i:s')
        );
        $this->store_repo->create($arr);
        Session::flash('store_msg','STORE ADDED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/store');
    }

    /**
        * Method name   : Update Store
        * @description  : Used for updating store
        * @param        : Request data  
        * @return       : return with updated store
    */
    public function update_store($id){
        $request = request();

        $this->validate($request, [
            'txt_storename'=> 'required',
            'txt_storeemail'=> 'required',
            'txt_userid'=> 'required',
            'txt_pass'=> 'required',
            'dd_state'=> 'required',
            'txt_storeadd'=> 'required',
            'txt_gst'=> 'required'
        ],[
            'txt_storename.required'=> 'Store Name is required',
            'txt_storeemail.required'=> 'Email is required',
            'txt_userid.required'=> 'Store User Id is required',
            'txt_pass.required'=> 'Password is required',
            'dd_state.required'=> 'State is required',
            'txt_storeadd.required'=> 'Address is required',
            'txt_gst.required'=> 'GST is required'
        ]);

        $arr = array(
            'm44_store_name' => $request->input('txt_storename'),
            'm44_store_email' => $request->input('txt_storeemail'),
            'm44_store_uid' => $request->input('txt_uid'),
            'm44_store_userid' => $request->input('txt_userid'),
            'm44_store_pass' => $request->input('txt_pass'),
            'm44_store_pinpass' => $request->input('txt_pass'),
            'm44_store_state' => $request->input('dd_state'),
            'm44_store_address' => $request->input('txt_storeadd'),
            'm44_store_gst' => $request->input('txt_gst'),
            'm44_store_licnace' => $request->input('txt_licno'),
            'm44_store_description' => $request->input('txt_storedesc'),
            'm44_store_status' => 1
        );
        $this->store_repo->update($id, $arr);
        Session::flash('store_msg','STORE UPDATED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/store');
    }

    /**
        * Method name   : Prod req frm str
        * @description  : Used for product req. from store
        * @param        : Request data  
        * @return       : return with products req. from store
    */
    public function prod_reqfrmstr()
    {
        $prod_storereq = DB::select('select * from tr32_vendor_request inner join m41_product_details on 
            tr32_vendor_request.tr32_products_id = m41_product_details.m41_product_id inner join m44_store on
            m44_store.m44_store_id = tr32_vendor_request.tr32_store_id');
        return view('Vendor.prod_reqfrmstr', compact('prod_storereq'));
    }

    /**
        * Method name   : Prev req
        * @description  : Used for getting previous product request
        * @param        : Request data  
        * @return       : return with previous product request report
    */
    public function prev_req()
    {
        $prod_req = DB::select('select * from tr32_vendor_request inner join m41_product_details on 
            tr32_vendor_request.tr32_products_id = m41_product_details.m41_product_id');

        //dd($prod_req);
        return view('Vendor.prev_req', compact('prod_req'));
    }

    /**
        * Method name   : Req verify status
        * @description  : Used for verifying request status
        * @param        : Request data  
        * @return       : return for request status
    */
    public function req_verifystatus($id)
    {
        $arr = array(
            'tr32_status' => 1
        );
        DB::table('tr32_vendor_request')->where('tr32_id',$id)->update($arr);
        Session::flash('message','UPDATED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/prod_reqfrmstr');
    }

    /**
        * Method name   : Req reject status
        * @description  : Used for request reject status
        * @param        : Request data  
        * @return       : return for request reject status
    */
    public function req_rejectstatus($id)
    {
        $arr = array(
            'tr32_status' => 0
        );
        DB::table('tr32_vendor_request')->where('tr32_id',$id)->update($arr);
        Session::flash('message','UPDATED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/prod_reqfrmstr');
    }

}
