<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\Master\Location\LocationRepository;
use App\Repositories\Master\Package\PackageRepository;
use App\Repositories\Employee\EmployeeRepository;
use App\Repositories\Enroll\EnrollRepository;
use App\Repositories\Topup\TopupRepository;
use App\Repositories\Team\TeamRepository;
use App\Repositories\Profile\ProfileRepository;
use App\Repositories\Log\LogRepository;
use App\Repositories\Closing\ClosingRepository;
use App\Repositories\Fund\FundRepository;
use App\Repositories\Ticket\TicketRepository;
use App\Repositories\Master\Bank\BankRepository;
use App\Repositories\Recharge\Rechargeprocess\RechargeprocessRepository;
use App\Repositories\Recharge\Rechargereport\RechargereportRepository;
use App\Repositories\AEPS\AEPSprocess\AEPSprocessRepository;
use App\Repositories\AEPS\AEPSreport\AEPSreportRepository;
use App\Repositories\Dmt\Dmtprocess\DmtprocessRepository;
use App\Repositories\Dmt\Dmtreport\DmtreportRepository;

use App\Repositories\Master\WlConfig\WlConfigRepository;
use App\Repositories\Master\AdminBank\AdminBankRepository;
use App\Repositories\Master\Events\EventsRepository;
use App\Repositories\Master\Operator\OperatorRepository;
use App\Repositories\Slab\SlabRepository;
use App\Repositories\Master\Banner\BannerRepository;
use App\Repositories\Affiliate\AffiliateRepository;
use App\Repositories\Shop\ShopRepository;
use App\Repositories\Master\Service\ServiceRepository;
use App\Repositories\Pantoken\PantokenRepository;


use App\Repositories\ProductModule\Categories\CategoriesRepository;
use App\Repositories\ProductModule\ParentCategories\ParentCategoriesRepository;
use App\Repositories\ProductModule\Products\ProductsRepository;
use App\Repositories\ProductModule\UserOrders\UserOrdersRepository;
use App\Repositories\ProductModule\Favorites\FavoritesRepository;
use App\Repositories\ProductModule\Wishlist\WishlistRepository;
use App\Repositories\ProductModule\UserAddress\UserAddressRepository;
use App\Repositories\ProductModule\OnlinePayment\OnlinePaymentRepository;
use App\Repositories\ProductModule\ProductVariant\ProductVariantRepository;
use App\Repositories\ProductModule\OrdersSiping\OrdersSipingRepository;

use DB;
use Session;
use Helper;
use CoinPayment;
use Cookie;
use Image;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use MahagramDMT;
use Illuminate\Support\Str;
use Mtownsend\XmlToArray\XmlToArray;
use Hash;
use Carbon\Carbon;

class UserController extends Controller
{
    private $STATUS = "failed";
	private $ERRMSG = "Invalid Operation";
	private $ERRCODE = "error";
	private $isError = FALSE;
	private $record_per_page =10;
	private $userData = '';
	private $user="";
	private $news="";

	private $location_repo;
	private $package_repo;
	private $empreg_repo;
	private $enroll_repo;
	private $profile_repo;
	private $topup_repo;
	private $team_repo;
	private $log_repo;
	private $closing_repo;
	private $fund_repo;
	private $ticket_repo;
	private $bank_repo;
	private $rech_proc_repo;
	private $rech_reprt_repo;
	private $aeps_proc_repo;
	private $aeps_reprt_repo;
	private $dmt_proc_repo;
	private $dmt_reprt_repo;
	private $emp_repo;
	private $wlconfig_repo;
	private $admin_bank_repo;
	private $events_repo;
	private $slab_repo;
	private $operator_repo;
    private $banner_repo;
    private $Affiliate_repo;
    private $Shop_repo;
	private $service_repo;
	private $pantoken_repo;

	private $parent_catrepo;
    private $cat_repo;
    private $prod_repo;
    private $order_repo;
    private $fav_repo;
    private $wishlist_repo;
    private $address_repo;
    private $onlinepay_repo;
    private $prod_varnt;
    private $ordersiping_repo;

	public function __construct(LocationRepository $location_repo, PackageRepository $package_repo,
		EmployeeRepository $empreg_repo, EnrollRepository $enroll_repo, ProfileRepository $profile_repo,
		TopupRepository $topup_repo, TeamRepository $team_repo, LogRepository $log_repo,
		ClosingRepository $closing_repo, FundRepository $fund_repo, TicketRepository $ticket_repo, BankRepository $bank_repo,
        RechargeprocessRepository $rech_proc_repo, RechargereportRepository $rech_reprt_repo,
        AEPSprocessRepository $aeps_proc_repo, AEPSreportRepository $aeps_reprt_repo,
        DmtprocessRepository $dmt_proc_repo, DmtreportRepository $dmt_reprt_repo, EmployeeRepository $emp_repo, 
		WlConfigRepository $wlconfig_repo, AdminBankRepository $admin_bank_repo, EventsRepository $events_repo,
        SlabRepository $slab_repo, OperatorRepository $operator_repo, BannerRepository $banner_repo, AffiliateRepository $Affiliate_repo, ShopRepository $Shop_repo, ServiceRepository $service_repo,
		PantokenRepository $pantoken_repo,CategoriesRepository $cat_repo, ProductsRepository $prod_repo,
        ParentCategoriesRepository $parent_catrepo, UserOrdersRepository $order_repo, 
        FavoritesRepository $fav_repo, WishlistRepository $wishlist_repo, UserAddressRepository $address_repo, 
        OnlinePaymentRepository $onlinepay_repo, ProductVariantRepository $prod_varnt, OrdersSipingRepository $ordersiping_repo
    )
        {
        	$this->location_repo = $location_repo;
        	$this->package_repo = $package_repo;
        	$this->empreg_repo = $empreg_repo;
        	$this->enroll_repo = $enroll_repo;
        	$this->profile_repo = $profile_repo;
        	$this->topup_repo = $topup_repo;
        	$this->team_repo = $team_repo;
        	$this->log_repo = $log_repo;
        	$this->closing_repo = $closing_repo;
        	$this->fund_repo = $fund_repo;
        	$this->ticket_repo = $ticket_repo;
    		$this->bank_repo = $bank_repo;
    		$this->rech_proc_repo = $rech_proc_repo;
    		$this->rech_reprt_repo = $rech_reprt_repo;
    		$this->aeps_proc_repo = $aeps_proc_repo;
    		$this->aeps_reprt_repo = $aeps_reprt_repo;
    		$this->dmt_proc_repo = $dmt_proc_repo;
    		$this->dmt_reprt_repo = $dmt_reprt_repo;
    		$this->emp_repo = $emp_repo;
    		$this->wlconfig_repo = $wlconfig_repo;
    		$this->admin_bank_repo = $admin_bank_repo;
    		$this->events_repo = $events_repo;
    		$this->slab_repo = $slab_repo;
    		$this->operator_repo = $operator_repo;
            $this->banner_repo = $banner_repo;
    		$this->Affiliate_repo = $Affiliate_repo;
    		$this->Shop_repo = $Shop_repo;
        	$this->service_repo = $service_repo;
    		$this->pantoken_repo = $pantoken_repo;
    		$this->cat_repo = $cat_repo;
	        $this->prod_repo = $prod_repo;
	        $this->parent_catrepo = $parent_catrepo;
	        $this->order_repo = $order_repo;
	        $this->fav_repo = $fav_repo;
	        $this->wishlist_repo = $wishlist_repo;
	        $this->address_repo = $address_repo;
	        $this->onlinepay_repo = $onlinepay_repo;
	        $this->prod_varnt = $prod_varnt;
	        $this->ordersiping_repo = $ordersiping_repo;
        }

        function valid_phone_number($str)
		{
			$regex = "/^[0-9]+$/";
			if(preg_match($regex,$str))
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}
		}




	public function get_details()   
	{
		$request = request();
		$result=$this->enroll_repo->getUserByContact($request->input('txt_contactno'));
		$res=$this->scan_team($result[0]->RegId);
		if($res == "true")
		{
			return json_encode($result);
		}
		else
		{
			return 1;
		}
	}
	


	public function get_mem_details()   
	{
		$request = request();
		$result=$this->enroll_repo->getUserByUserCode($request->input('txt_contactno'));
		//$res=$this->scan_team($result[0]->RegId);
		$res = "true";
		if($result)
		{
			return json_encode($result);
		}
		else
		{
			return 1;
		}
	}


	/**
		* Method name	: match values
		* @description 	: Used for matching old and new inserted values
		* @param		: Request data  
		* @return		: return updated values with old values before updation
	*/
    public function match_values($old_values,$new_values)
	{
		$old_value=$old_values[0];
		$new_arr = array();
		foreach($old_value as $key=>$value){ $new_arr[$key] = $value; }
		$count=count($new_arr);
		$arr_key = array_keys($new_values);
		$arr_val = array_values($new_arr);
		$new_old_array = array();
		for($i=0;$i<$count;$i++){ $new_old_array[$arr_key[$i]] = $arr_val[$i]; }
		$result = array_diff($new_values, $new_old_array);
		$new_values1 = json_encode(array_intersect_key($new_values,$result));
		$old_values1 = json_encode(array_intersect_key($new_old_array,$result));

		return [$new_values1,$old_values1];
	}



	public function spin_data()
	{
		$part_size = number_format(config('SPINDIVIDE_VAL'),2);
		$min_limit = number_format(config('SPINMIN_VAL'),2);
		$max_limit = number_format(config('SPINMAX_VAL'),2);
		$divideval = ($max_limit/$part_size);
       	$a = $max_limit+$divideval;

		$color =   ['#ee1c24', '#3cb878','#f6989d','#00aef0','#f26522', '#e70697', '#fff200', '#f6989d', '#ee1c15', '#3cb878','#f26522', '#a186be','#fff200','#00aef0', '#ee1c04','#f6989d', '#f26522', '#3cb878', '#a186be', '#fff200', '#00aef0', '#ffffff', '#f26522', '#e70697', '#fff200', '#f6989d', '#ee1c15','#ee1c24', '#3cb878','#f6989d','#00aef0','#f26522', '#e70697', '#fff200', '#f6989d', '#ee1c15', '#3cb878','#f26522', '#a186be','#fff200','#00aef0', '#ee1c04','#f6989d', '#f26522', '#3cb878', '#a186be', '#fff200', '#00aef0', '#ffffff', '#f26522', '#e70697', '#fff200', '#f6989d', '#ee1c15'];

		$data = [];
		if($min_limit == '' || $min_limit == '' || config('SPIN') == 'NO')
		{
			$data = [['fillStyle'=> '#eae56f', 'text' => '']];
			$spin_data['segments'] = json_encode($data);
			$spin_data['numSegments'] = '0';
			return $spin_data;
		}
			$c = 0;
			for($i=$min_limit;$i<=$a;$i=$i+$divideval)
			{
				$j = number_format($i,2);
			 
			    array_push($data, ['fillStyle'=> $color[$c], 'text' => (string)$j.' %' ]);
			    ++$c;
			}

		if(count($data) > 0)
		{
			$spin_data['segments'] = json_encode($data);
			$spin_data['numSegments'] = count($data);
			return $spin_data;
		}
		else
		{
			$data = [['fillStyle'=> '#eae56f', 'text' => '']];
			$spin_data['segments'] = json_encode($data);
			$spin_data['numSegments'] = '0';
			return $spin_data;
		}
	}

	/**
        * Method name   : Index
        * @description  : Used for user dashboard
        * @param        : Request data  
        * @return       : return with user data with different incomes
    */
	public function index()
	{
		$queery ="";$queery1 ="";
		DB::select("SELECT GET_AVAILABLE_BAL(".Session::get('USER_ID').",4)");
		DB::select("SELECT GET_AVAILABLE_BAL(".Session::get('USER_ID').",5)");
		DB::select("SELECT GET_AVAILABLE_BAL(".Session::get('USER_ID').",6)");
		DB::select("SELECT GET_AVAILABLE_BAL(".Session::get('USER_ID').",8)");
		
		$this->update_directbusiness(Session::get('USER_ID'));
	    $user = Helper::get_userdetail(Session::get('USER_ID'));
		$news = Helper::get_news(Session::get('AFFILIATE_CODE'),'ACTIVE','MEMBER');
		$INVESTMENT = Helper::get_user_investment(Session::get('USER_ID'),1);
		
		$REINVESTMENT = Helper::get_user_investment(Session::get('USER_ID'),2);
		$FUND_REQUEST_PENDING = Helper::get_fund_request(Session::get('USER_ID'),1);
		$FUND_REQUEST_APPROVED = Helper::get_fund_request(Session::get('USER_ID'),2);
		
		$user_topup_list=DB::select("SELECT * FROM `user_topup` WHERE USER_ID = ".Session::get('USER_ID')." ORDER BY TOPUP_ID DESC");

		$Coupan_cnt=DB::select("SELECT IFNULL(COUNT(*),0) AS NO_O_COUPAN FROM `m55_coupon` WHERE m11_user_id=". Session::get('USER_ID'))[0];
		$coupan_list=DB::select("SELECT * FROM `m55_coupon` WHERE m11_user_id=". Session::get('USER_ID'));
		///dd($coupan_list);
		$directcount =DB::select("SELECT count(*) AS dc FROM m11_user WHERE `m11_user`.`m11_user_referral_code`=". Session::get('USER_ID'));
		$direct_income= Helper::get_ledgerwise_income(Session::get('USER_ID'),12);
		$level_income= Helper::get_ledgerwise_income(Session::get('USER_ID'),13);
		$gene_level_income= Helper::get_ledgerwise_income(Session::get('USER_ID'),31);
		$total_income=DB::select("SELECT SUM(`tr28_direct_amount`) as ttinc FROM`tr28_direct_detail` WHERE `m11_user_id`=".Session::get('USER_ID'));
	  DB::select("CALL get_intro_downline(".Session::get('USER_ID').")");
	  $teamcount = DB::select("SELECT count(member_id) as tc FROM tmp_downline");
	  $ACTIVE_teamcount = DB::select("SELECT COUNT(*) AS TC FROM (SELECT (m11_user_id) FROM `tr19_user_topup` WHERE `m11_user_id` IN(SELECT (member_id) FROM tmp_downline WHERE 1 ) ) AS tbl  ");
	  $team_business = DB::select("SELECT IFNULL(SUM(tr19_toppup_amount),0.00) AS TB FROM `tr19_user_topup` WHERE `m11_user_id` IN (SELECT member_id AS tc FROM tmp_downline)");
	  $self_business=DB::select("SELECT SUM(TB) AS SB FROM (SELECT IFNULL((tr19_toppup_amount),0.00) AS TB FROM `tr19_user_topup` WHERE `m11_user_referral_code`=".Session::get('USER_ID')." GROUP BY `m11_user_id`,`m11_user_referral_code`) AS TBL");
		
//SELECT COUNT(*) AS TC FROM `tr19_user_topup` WHERE `m11_user_id` IN (SELECT member_id AS tc FROM tmp_downline)
		
		$activedirect_count=DB::select("SELECT COUNT(TB) AS AD FROM (SELECT IFNULL(MIN(`m11_user_id`),0.00) AS TB FROM `tr19_user_topup` WHERE `m11_user_referral_code`=".Session::get('USER_ID')." GROUP BY `m11_user_id`,`m11_user_referral_code`) AS TBL");
	    $KYCSTATUS=Helper::get_userkyc(Session::get('USER_ID'));
		$CUURENT_PHASE = 0.000;
		$CUURENT_PHASE_AIRDROP =0.000;
		$REMAIN_TIME = 0.000;
		$userrec=array(
		'proc'=>7,
		'userid'=>'`m11_user`.`m11_user_referral_code`='. Session::get('USER_ID').'',
		);
		$user_rec= $this->enroll_repo->getUserByProc($userrec);
		

		$queery = $queery."`USER_ID` = ".Session::get('USER_ID') ." AND ";
		$queery = $queery." CASHBACK_STATUS=2 LIMIT 1000";
		$queery1 = $queery1."`USER_ID` = ".Session::get('USER_ID') ." AND CASHBACK_APPROVEDATE='".date('Y-m-d')."' AND";
		$queery1 = $queery1." CASHBACK_STATUS=2 LIMIT 1000";
		//dd($queery1);
		$salary_report =  DB::select("SELECT SUM(CASHBACK_AMOUNT) AS CASHBACK_AMOUNT FROM cashback_dates WHERE ".$queery);
		$salary_report_today =  DB::select("SELECT SUM(CASHBACK_AMOUNT) AS CASHBACK_AMOUNT FROM cashback_dates WHERE ".$queery1);
		$current_lvl_report =  DB::select("SELECT (CASE WHEN(COUNT(*)<FLOOR(SUM(`tr50_user_bybusiness`)/1000)) THEN COUNT(*) ELSE FLOOR(SUM(`tr50_user_bybusiness`)/1000) END) as open_lbl FROM `tr50_totallevel_income` WHERE `m11_user_id`=". Session::get('USER_ID')."");
		return view('User.user_dashboard',compact('gene_level_income','direct_income','level_income','self_business','team_business','CUURENT_PHASE','REMAIN_TIME','user','news','KYCSTATUS','directcount','activedirect_count','INVESTMENT','REINVESTMENT','FUND_REQUEST_PENDING','FUND_REQUEST_APPROVED','user_rec','salary_report','teamcount','ACTIVE_teamcount','total_income','current_lvl_report','Coupan_cnt','coupan_list','salary_report_today','user_topup_list'));
	}

	public function create_win_data(request $request)
	{
		$check = DB::select("SELECT * FROM `tr43_spin_pints` WHERE `m11_user_id`= ".Session::get('USER_ID')." AND `tr43_win_datetime` = DATE_FORMAT(NOW(), '%Y-%m-%d') LIMIT 1");

		if(count($check) == 0)
		{
			$data = DB::table('tr43_spin_pints')->insert(['tr43_win' => str_replace(' %','',$request->win_spin), 'm11_user_id' => Session::get('USER_ID'), 'tr43_win_datetime' => date('Y-m-d'), 'tr43_status' => 2]);
			if($data)
			{
				DB::select("call cb_afterspin(". Session::get('USER_ID').",".str_replace(' %','',$request->win_spin).",@msg,@msg2)");
			}
		}

		return $data;
	}

	/**
        * Method name   : Registration
        * @description  : Used for registration
        * @param        : Request data 
        * @return       : return with user registration
    */
	public function registration()
	{
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$state = $this->location_repo->getAllStates();
		$package = $this->package_repo->getAllPackage();
		$banks = $this->bank_repo->getAll();
		$data['country'] = $this->location_repo->getAllCountries();
		//$service = DB::select("SELECT * FROM `admin_service_charges` WHERE USER_ROLE_ID = 7 AND STATUS = 'ACTIVE'");
		$service =[];
		return view('User.user_registration', compact('state','user','package','banks','data','service'));
	}

	/**
        * Method name   : Registration
        * @description  : Used for registration
        * @param        : Request data 
        * @return       : return with user registration
    */
	public function add_user()
	{
		$request = request();

		$this->validate($request, [
            'txt_mobileno'=> 'required|numeric|digits:10|regex:/^[5-9]\d{9}$/|unique:enroll,MemberContactNo',
            'txt_email'=> 'required|email|unique:enroll,MemberEmail',
			'txt_addressproof' => 'nullable|mimes:jpeg,png,jpg|max:20240',
        ],[
            'txt_mobileno.required'=> 'Mobile Number is required',
            'txt_mobileno.numeric'=> 'Mobile Number must be numeric',
			'txt_mobileno.unique'=> 'Mobile Number already registered',
            'txt_mobileno.digits'=> 'Mobile Number must be in digits',
			'txt_mobileno.regex'=> 'Enter is valid Mobile Number',
			'txt_email.unique'=> 'E-mail ID already registered',
            'txt_email.required'=> 'E-mail ID is required',
            'txt_email.email'=> 'Enter Valid E-mail ID',
			'txt_addressproof.mimes'=> 'Image Type jpeg,png,jpg',
			'txt_addressproof.max'=> 'Image Max 2 MB'
        ]);

		if($request->method() == 'POST')
		{
			$txt_cancelchq ="";
			$txt_gstcrt ="";

            if($request->input('txt_password')=='')
            {
				$p = rand(100000,999999);
                $pass=$p; 
                $pinpass=$p;
			}
            else
            {
                $pass=$request->input('txt_password');
                $pinpass=$request->input('txt_password');
			}   
			if($request->input('txt_referralcode')=="")
            {
                $ERRMSG = "Member Code should be valid";
                $this->isError= TRUE;
                $ERRCODE="warning";
			}
			else if($request->input('dd_wallet')=="" || $request->input('dd_wallet')=="-1")
            {
                $ERRMSG = "Wallet Type should be valid";
                $this->isError= TRUE;
                $ERRCODE="warning";
			}
			$contactno=explode(' ',$request->input('txt_referralcode'));
			$user = Helper::get_userid($contactno[0]);
			if(empty($user))
			{
				$ERRMSG = "Member should be valid";
				$isError = TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
                $this->isError= FALSE;
                $ERRCODE="success";
			}
			if(request()->method() == 'POST' && $this->isError==FALSE)
			{
				$signup_data=Helper::reg_data($request,$pass,$pinpass,'','','',$txt_gstcrt,$txt_cancelchq);  
				
				$response= $this->enroll_repo->create($signup_data); 
			
			

				$signup_data1=Helper::notify_data($request,1,"NEW USER INSERT SUCCESSFULLY",$response['err_msg'],Session::get('USER_ID'),'2');

				$arrdata = array(
					'tr11_ar_tblnm' => 'm11_user',
					'tr11_ar_old_value' => '',
					'tr11_ar_new_value' => $response['CODE'], // json_encode($arr)
					'tr11_ar_uid' => $response['ID'],
					'tr11_ar_description' => 'NEW USER ADD SUCCESSFULLY',
					'tr11_updated_by' => 2,
					'tr11_updated_by_id' =>  Session::get('USER_ID')
					);
				//$mobileno_actionrecord=$this->log_repo->create($arrdata);

				if($response['err_code']=="success")
				{
					$template_type = 1;
					$data = array(
						'msg_title' => 'account_creation',
						'name' => $request->input('txt_username'),
						'useremail' => $request->input('txt_email'),
						'usercode' => $response['CODE'],
						'password' => $request->input('txt_password'),
						'link' => url('/home'),
						'trans_id' => url('/home'),
						'template_name' => 'registration'
					);

					$msg_config = DB::select('select * from m09_message_config where m09_msg_title = "'.$data['msg_title'].'"');
					$data['MSG_CONTENT'] = $msg_config[0]->m09_msg_content;
					$data['MSG_SUBJECT'] = $msg_config[0]->m09_msg_subject;
					$data['MSG_CONTENT'] = strtr($data['MSG_CONTENT'], array('{name}' => $data['name'],
					'{useremail}'=>$data['useremail'],'{password}'=>$data['password'],'{link}'=>$data['link'],'{trans_id}'=>$data['trans_id']));
					$data['pdf'] ='';
					$template_data = $data;

					//Mail::to($request->input('txt_email'))->send(new SendMail($template_data, $template_type));
					$msg="Welcome to ".config('SITE_NAME')." Please click on ".config('WEBSITE_NAME')." to activate your account User id :".$data['usercode']." Password : ". $data['password'] ;
					//$msg= $response['err_msg'];
						// SMS SEND OR INSERT
						$sms_data['MOBILE_NO'] = $request->input('txt_mobileno');
						$sms_data['SUBJECT'] = 'User REGISTRATION';
						$sms_data['MESSAGE'] = $msg;
						$sms_data['TYPE'] = 1;
						$sms_data['SEND_BY'] = 2;
						$sms_data['SEND_BY_ID'] = Session()->get('USER_ID');
						Helper::send_sms_or_log($sms_data);
						//SMS SEND END 

					Session::flash( 'message', $msg );
					Session::flash( 'type', $response['err_code'] );

				}
				else
				{
				Session::flash( 'message', $response['err_msg'] );
				Session::flash( 'type', $response['err_code'] );
				}
			}
				
			}
				$user = Helper::get_userdetail(Session::get('USER_ID'));
				return redirect('user_registration/'); 
	}

	/**
        * Method name   : View User Profile
        * @description  : Used for viewing user profile
        * @param        : Request data 
        * @return       : return with viewing user profile
    */
	public function view_userprofile()
	{
		$user = Helper::get_userdetail(Session::get('USER_ID')); 
		$emp = $this->empreg_repo->getById($user[0]->EmpId);
		$emp = $emp[0];
		
		$get_useralldetail = Helper::get_useralldetail(Session::get('USER_ID'));
		$shop = $this->Shop_repo->getByUsersId($user[0]->RegId);
		//dd($user,$emp,$get_useralldetail,$shop);
		return view('User.user_profile',compact('user','get_useralldetail','shop','emp'));
	}


	/**
        * Method name   : Edit User Profile
        * @description  : Used for editing user profile
        * @param        : Request data 
        * @return       : return with editing user profile
    */
	public function edit_userprofile()
	{
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$get_useralldetail = Helper::get_useralldetail(Session::get('USER_ID'));
		return view('User.user_update_profile',compact('user','get_useralldetail'));
	}

	/**
        * Method name   : Update User Profile
        * @description  : Used for update user profile
        * @param        : Request data 
        * @return       : return with update user profile
    */
	public function update_userprofile()
	{
	    $request = request();
		$get_useralldetail = Helper::get_useralldetail(Session::get('USER_ID'));

		$this->validate($request, [
            //'txt_mobileno'=> 'required|numeric|digits:10|regex:/^[5-9]\d{9}$/', 	//unique:enroll,MemberContactNo
            //'txt_email'=> 'required|email', // unique:enroll,MemberEmail,
            'txt_cbsacno'=> 'required',
        ],[
            //'txt_mobileno.required'=> 'Mobile Number is required',
            //'txt_mobileno.numeric'=> 'Enter is valid Mobile Number',
            //'txt_mobileno.digits'=> 'Enter is valid Mobile Number',
			//'txt_mobileno.regex'=> 'Enter is valid Mobile Number',
            //'txt_email.required'=> 'E-mail ID is required',
            //'txt_email.email'=> 'Enter Valid E-mail ID',
            'txt_cbsacno.required'=> 'Wallet Address is required',
        ]);


		if($request->method() == 'POST')
		{
			if($_FILES['txt_yourphoto']['name']!= '')
			{
				$image = $request->file('txt_yourphoto');
				$name = Session::get('USER_CODE').'_PHOTO_'.time().'.'.$image->getClientOriginalExtension();
				$destinationPath = public_path('images/USER_PHOTO');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
					$image->move($destinationPath,$name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=Session::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode($get_useralldetail);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
				$txt_yourphoto =  $name;
			}
			else
			{
				$txt_yourphoto = trim($request->input('txt_yourphotohd'));
			}
			if($request->input('txt_username')=='')
			{
				$ERRMSG = "Member user name should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			// else if($request->input('txt_mobileno')=='')
			// {
			// 	$ERRMSG = "Member contact number should be valid or not blank.";
			// 	$this->isError= TRUE;
			// 	$ERRCODE="warning";
			// }
			// else if($request->input('txt_email')=='')
			// {
			// 	$ERRMSG = "Member email address should be valid or not blank.";
			// 	$this->isError= TRUE;
			// 	$ERRCODE="warning";
			// }
			///else if($request->input('txt_dob')=='')
			//{
				//$ERRMSG = "Member Date of birth should be valid or not blank.";
				//$this->isError= TRUE;
				//$ERRCODE="warning";
			//}
			// else if($request->input('txt_address')=='')
			// {
			// 	$ERRMSG = "Member address should be valid or not blank.";
			// 	$this->isError= TRUE;
			// 	$ERRCODE="warning";
			// }
			// else if($request->input('txt_postalcode')=='')
			// {
			// 	$ERRMSG = "Member postal code should be valid or not blank.";
			// 	$this->isError= TRUE;
			// 	$ERRCODE="warning";
			// }
			// else if($txt_yourphoto=='')
			// {
			// 	$ERRMSG = "Member image should be valid or not blank.";
			// 	$this->isError= TRUE;
			// 	$ERRCODE="warning";
			// }
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				$name=explode(" " ,$request->input('txt_username'));
				$user_name=$request->input('txt_username');
				$USER=Session::get('USER_ID');
				
				if(isset($name[1]))
				{
					$l_name = $name[1];
				}
				else
				{
					$l_name = ''; 
				}
//'m11_user_dob' => date('Y-m-d',strtotime($request->input('txt_dob'))),
				//'m11_user_contactno' => $request->input('txt_mobileno'),
				$arr = array(
				'm11_first_name' => $name[0],
				'm11_last_name' => $l_name,
				'm11_user_name' => $request->input('txt_username'),
				
				'm11_user_location' => $request->input('txt_address'),
				'm11_user_postalcode' => $request->input('txt_postalcode'),
				
				'm11_user_email' => $request->input('txt_email'),
				'm11_bsc_address' => $request->input('txt_cbsacno'),
				'm11_user_image' => $txt_yourphoto
				);

				DB::table("tr04_login")->where("m11_user_id", Session::get('USER_ID'))->update(['m11_bsc_address' => $request->txt_cbsacno]);
				
				$old_values=DB::select("SELECT FirstName, LastName, MemberName, MemberLocation, MemberPostalCode,MemberEmail, MemberImage FROM enroll WHERE RegId=".Session::get('USER_ID')."");

				$user_profile = $this->enroll_repo->update(Session::get('USER_CODE'), Session::get('USER_ID'), $arr);

				$data=$this->match_values($old_values,$arr);
				$arr = array(
					'tr11_ar_tblnm' => 'm11_user',
					'tr11_ar_old_value' => $data[1],
					'tr11_ar_new_value' => $data[0],
					'tr11_ar_uid' => $USER,
					'tr11_ar_description' => 'USERS PROFILE HAS BEEN CHANGED SUCCESSFULLY!',
					'tr11_updated_by' => 2,
					'tr11_updated_by_id' =>  Session::get('USER_ID')
					);
				$mobileno_actionrecord=$this->log_repo->create($arr);
				$ERRMSG="USER'S PROFILE HAS BEEN CHANGED SUCCESSFULLY!";
				$ERRCODE='success';	
			}
		}
		Session::flash('type',$ERRCODE);
		Session::flash('message',$ERRMSG);
		return redirect('edit_userprofile'); 
	}

	/**
        * Method name   : Edit User Bank
        * @description  : Used for update user bank 
        * @param        : Request data 
        * @return       : return with update user bank 
    */
	public function edit_userbank()
	{
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$get_useralldetail = Helper::get_useralldetail(Session::get('USER_ID'));

		$banks = $this->bank_repo->getAll();
		return view('User.user_update_bankdetails',compact('user','get_useralldetail','banks'));
	}

	/**
        * Method name   : Update user bank details
        * @description  : Used for update user bank details
        * @param        : Request data 
        * @return       : return with update user bank details
    */
	public function update_userbankdetails()
	{
		$request = request();
		$get_useralldetail = Helper::get_useralldetail(Session::get('USER_ID'));

		if($request->method() == 'POST')
		{
			if($_FILES['txt_cancelchq']['name']!= '')
			{
				$image = $request->file('txt_cancelchq');
				$name = Session::get('USER_CODE').'_CANCELCHQ_'.time().'.'.$image->getClientOriginalExtension();
				$destinationPath = public_path('images/CANCEL_CHEQUE');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
						$image->move($destinationPath,$name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=Session::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode($get_useralldetail);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
				$txt_cancelchq =  $name;
			}
			else
			{
				$txt_cancelchq = trim($request->input('txt_cancelchqhd'));
			}
			if($request->input('txt_nameatbank')=='' )
			{
				$ERRMSG = "Member Name at Bank should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_bankname')=='')
			{
				$ERRMSG = "Member Bank Name should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_cbsacno')=='')
			{
				$ERRMSG = "Member Bank no Account should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_bankbranch')=='')
			{
				$ERRMSG = "Member Bank Branch should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_bankifsccode')=='')
			{
				$ERRMSG = "Member Bank IFSCode should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($txt_cancelchq=='')
			{
				$ERRMSG = "Cancel cheque should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				$ACCOUNTNO=$request->input('txt_cbsacno');
				$USER=Session::get('USER_ID');
				$arr = array(
				'm23_user_nameat_bank'=>$request->input('txt_nameatbank'),
				'm23_user_cbsacno' =>$request->input('txt_cbsacno'),
				'm01_bank_name'=>$request->input('txt_bankname'),
				'm23_user_branch'=>$request->input('txt_bankbranch'),
				'm23_user_ifscode' =>$request->input('txt_bankifsccode'),
				'm23_usercancelechq'=>$txt_cancelchq
				);

				$old_values=DB::select("SELECT NAMEatBANK, CBSACno, BANKNo, Branch, IFSCode, CancelCheque FROM user_details WHERE RegId=".Session::get('USER_ID')."");


  				$user = Helper::get_userdetail(Session::get('USER_ID'));



				$this->profile_repo->updateBankByUserId($USER, $arr);

				$data=$this->match_values($old_values,$arr);

				$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => $data[1],
						'tr11_ar_new_value' => $data[0],
						'tr11_ar_uid' => $USER,
						'tr11_ar_description' => 'USERS BANK DETAILS HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 2,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);

				$bank_actionrecord=$this->log_repo->create($arr);
				$ERRMSG="USER'S BANK HAS BEEN CHANGED SUCCESSFULLY!";
				$ERRCODE='success';	
			}
		}
		
		Session::flash('type',$ERRCODE);
		Session::flash('message',$ERRMSG );

		return redirect('edit_userbank'); 
	}

	/**
        * Method name   : Edit User Kyc
        * @description  : Used to edit user kyc
        * @param        : Request data 
        * @return       : return with user kyc details
    */
	public function edit_userkyc()
	{
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$get_useralldetail = Helper::get_useralldetail(Session::get('USER_ID'));
		return view('User.user_upload_kyc',compact('user','get_useralldetail'));
	}

	/**
        * Method name   : Update User Kyc
        * @description  : Used to update user kyc
        * @param        : Request data 
        * @return       : return with updated user kyc details
    */
	public function update_userkyc()
	{
		$request = request();

		$get_useralldetail = Helper::get_useralldetail(Session::get('USER_ID'));
		
		if($request->method() == 'POST')
		{
			if($_FILES['txt_yourphoto']['name']!= '')
				{
					$image = $request->file('txt_yourphoto');
					$name = Session::get('USER_CODE').'_PHOTO_'.time().'.'.$image->getClientOriginalExtension();
					$destinationPath = public_path('images/USER_PHOTO');
					$FileType = array('jpeg','png','jpg');
					if(in_array($image->getClientOriginalExtension(), $FileType)) {
						$image->move($destinationPath,$name);
					}
					else
					{
						$request_data=json_encode($request->all());
						$file_type=$image->getClientOriginalName();
						$user_id=Session::get('USER_ID');
						$server_info=json_encode(request()->server());
						$user_info=json_encode($get_useralldetail);
						$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
						return back()->with('error', 'File format not supported.'); 
					}
					$txt_yourphoto = $name;
				}
				else
				{
					$txt_yourphoto = trim($request->input('txt_yourphotohd'));
				}

				if($_FILES['txt_idproof']['name']!= '')
				{
					$image = $request->file('txt_idproof');
					$name = Session::get('USER_CODE').'_IDPROOF_'.time().'.'.$image->getClientOriginalExtension();
					$destinationPath = public_path('images/USER_IDPROOF');
					$FileType = array('jpeg','png','jpg');
					if(in_array($image->getClientOriginalExtension(), $FileType)) {
						$image->move($destinationPath, $name);
					}
					else
					{
						$request_data=json_encode($request->all());
						$file_type=$image->getClientOriginalName();
						$user_id=Session::get('USER_ID');
						$server_info=json_encode(request()->server());
						$user_info=json_encode($get_useralldetail);
						$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
						return back()->with('error', 'File format not supported.'); 
					}
					$txt_idproof = $name;
				}
				else
				{
					$txt_idproof = trim($request->input('txt_idproofhd'));
				}
				if($_FILES['txt_addressproof']['name']!= '')
				{
					$image = $request->file('txt_addressproof');
					$name = Session::get('USER_CODE').'_ADDRESSPROOF_'.time().'.'.$image->getClientOriginalExtension();
					$destinationPath = public_path('images/USER_ADDRESSPROOF');
					$FileType = array('jpeg','png','jpg');
					if(in_array($image->getClientOriginalExtension(), $FileType)) {
						$image->move($destinationPath, $name);
					}
					else{
						$request_data=json_encode($request->all());
						$file_type=$image->getClientOriginalName();
						$user_id=Session::get('USER_ID');
						$server_info=json_encode(request()->server());
						$user_info=json_encode($get_useralldetail);
						$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
						return back()->with('error', 'File format not supported.'); 
					}
					$txt_addressproof = $name;
				}
				else
				{
					$txt_addressproof = trim($request->input('txt_addressproofhd'));
				}

				if($_FILES['txt_aadharfront']['name']!= '')
				{
					$image = $request->file('txt_aadharfront');
					$name = Session::get('USER_CODE').'_AADHARFRONT_'.time().'.'.$image->getClientOriginalExtension();
					$destinationPath = public_path('images/USER_IDPROOF');
					$FileType = array('jpeg','png','jpg');
					if(in_array($image->getClientOriginalExtension(), $FileType)) {
						$image->move($destinationPath, $name);
					}
					else{
						$request_data=json_encode($request->all());
						$file_type=$image->getClientOriginalName();
						$user_id=Session::get('USER_ID');
						$server_info=json_encode(request()->server());
						$user_info=json_encode($get_useralldetail);
						$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
						return back()->with('error', 'File format not supported.'); 
					}
					$txt_aadharfront = $name;
				}
				else
				{
					$txt_aadharfront = trim($request->input('txt_aadharfronthd'));
				}

				if($_FILES['txt_aadharback']['name']!= '')
				{
					$image = $request->file('txt_aadharback');
					$name = Session::get('USER_CODE').'_AADHARBACK_'.time().'.'.$image->getClientOriginalExtension();
					$destinationPath = public_path('images/USER_IDPROOF');
					$FileType = array('jpeg','png','jpg');
					if(in_array($image->getClientOriginalExtension(), $FileType)) {
						$image->move($destinationPath, $name);
					}
					else{
						$request_data=json_encode($request->all());
						$file_type=$image->getClientOriginalName();
						$user_id=Session::get('USER_ID');
						$server_info=json_encode(request()->server());
						$user_info=json_encode($get_useralldetail);
						$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
						return back()->with('error', 'File format not supported.'); 
					}
					$txt_aadharback = $name;
				}
				else
				{
					$txt_aadharback = trim($request->input('txt_aadharbackhd'));
				}
				
				if($request->input('txt_pancard')=='')
				{
					$ERRMSG = "Member pancard should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_address')=='')
				{
					$ERRMSG = "Member address should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($txt_yourphoto=='')
				{
					$ERRMSG = "Member image should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($txt_idproof=='')
				{
					$ERRMSG = "Pancard Image should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($txt_addressproof=='')
				{
					$ERRMSG = "Address proof Image should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($txt_aadharfront=='')
				{
					$ERRMSG = "Aadhar front image should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($txt_aadharback=='')
				{
					$ERRMSG = "Aadhar front image should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('dd_idprooftype')=='' || $request->input('dd_idprooftype')=='-1')
				{
					$ERRMSG = "Id proof type should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_aadharcard')=='')
				{
					$ERRMSG = "Aadhar card number should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('ddaddproof')=='' || $request->input('ddaddproof')=='-1')
				{
					$ERRMSG = "Address proof type should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				$pancard=$request->input('txt_pancard');
				$USER=Session::get('USER_ID');
				$arr = array(
					'm19_uk_user_photo'=>$txt_yourphoto,
					'm19_uk_idproof_type'=>$request->input('dd_idprooftype'),
					'm19_uk_uniqueid_num'=>$request->input('txt_pancard'),
					'm19_uk_aadhar_num'=>$request->input('txt_aadharcard'),
					'm19_uk_aadhar_front'=>$txt_aadharfront,
					'm19_uk_aadhar_back'=>$txt_aadharback,
					'm19_uk_idproofdoc'=>$txt_idproof,
					'm19_uk_address'=>$request->input('txt_address'),
					'm19_uk_addressproof_type'=>$request->input('ddaddproof'),
					'm19_uk_addressproof'=>$txt_addressproof,
					'm19_uk_qualification'=>$request->input('dd_quali')
					);

				$old_values=DB::select("SELECT USER_PH, IDProofType1, Pancarno, AadharCard, AadharFront, AadharBack, IDProof,Address, AddProofType1, AddressProof, Qualification1 FROM user_details WHERE RegId=".Session::get('USER_ID')."");

				$this->profile_repo->updateKycByUserId($USER, $arr);
				$user_profile=DB::update("UPDATE m11_user SET m11_user_image='".$txt_yourphoto."' WHERE m11_user_contactno =".Session::get('CONTACTNO')." and m11_user_id=". Session::get('USER_ID')." AND m11_user_status='ACTIVE'");	
				$data=$this->match_values($old_values,$arr);
				$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => $data[1],
						'tr11_ar_new_value' => $data[0],
						'tr11_ar_uid' => $USER,
						'tr11_ar_description' => 'USER S KYC HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 2,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
				$kyc_actionrecord=$this->log_repo->create($arr);	
				$ERRMSG="USER'S KYC HAS BEEN CHANGED SUCCESSFULLY!";
				$ERRCODE='success';	
			}
			
		}
		Session::flash('type',$ERRCODE);
		Session::flash('message',$ERRMSG);
		return redirect('edit_userkyc'); 
	}

	/**
        * Method name   : Change Password
        * @description  : Used for changing user password
        * @param        : Request data 
        * @return       : return with user password
    */
	public function change_password()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'CHANGE PASSWORD';
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_change_login_pass',compact('page','form_name','user') );
	}

	/**
        * Method name   : Update Password
        * @description  : Used for updating user password
        * @param        : Request data 
        * @return       : return with updated user password
    */
	public function update_password()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'CHANGE PASSWORD';
		$request = request();
		
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		
		if($_SERVER['REQUEST_METHOD']=="POST")
		{		
		    if($request->input('txt_oldpassword')=='')
			{
				$ERRMSG = "Old Password should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if(!Hash::check($request->input('txt_oldpassword'), $user[0]->LoginPassword))
			{
				$ERRMSG = "Old Password should be not valid.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_newpassword')=='')
			{
				$ERRMSG = "New Password should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if(strlen($request->input('txt_newpassword'))<6)
			{
				$ERRMSG = "New password length would be greater then 6 or equal 6";
				$this->isError= TRUE;
				$ERRCODE="warning";
				
			}
			else if($request->input('txt_newcpassword')=='')
			{
				$ERRMSG = "Confirm New Password should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
				
			}
			else if(strlen($request->input('txt_newcpassword'))<6)
			{
				$ERRMSG = "New Confirm password length would be greater then 6 or equal 6";
				$this->isError= TRUE;
				$ERRCODE="warning";
				
			}
			else if($request->input('txt_newpassword')!=$request->input('txt_newcpassword'))
			{
				$ERRMSG = "Password does not match with confirm password.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST' && $this->isError==FALSE)
			{
				$password=$request->input('txt_oldpassword');
				$new_password=$request->input('txt_newpassword');
				$new_cpassword=$request->input('txt_newcpassword');
				$userid=Session::get('USER_ID');

				$user_logindetails=$this->enroll_repo->updateUserPassword(Hash::make($new_password), $password, $userid);
				if($user_logindetails==1)
				{
					$arr = array(
						'tr11_ar_tblnm' => 'tr04_login',
						'tr11_ar_old_value' => $password,
						'tr11_ar_new_value' => $new_password,
						'tr11_ar_uid' => $userid,
						'tr11_ar_description' => 'USER S LOGIN PASSWORD HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 2,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
					$mobileno_actionrecord=$this->log_repo->create($arr);
					$ERRMSG="USER'S PASSWORD HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
				}
				else
				{
					$ERRMSG="USER'S PASSWORD HAS NOT BEEN CHANGED!";
					$ERRCODE='warning';	
				}
			}
		}
		Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);
		return redirect('change_userpassword'); 
	}

	/**
        * Method name   : Change trans password
        * @description  : Used for changing trans password
        * @param        : Request data 
        * @return       : return with view
    */
	public function change_transpassword()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'CHANGE PASSWORD';
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_change_trans_pass',compact('page','form_name','user') );
	}

	/**
        * Method name   : Update trans password
        * @description  : Used for updating trans password
        * @param        : Request data 
        * @return       : return with updating trans password
    */
	public function update_transpassword()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'CHANGE PASSWORD';
		$request = request();
		
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		if($_SERVER['REQUEST_METHOD']=="POST")
		{		
		    if($request->input('txt_oldpassword')=='')
			{
				$ERRMSG = "Old Password should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if(!Hash::check($request->input('txt_oldpassword'), $user[0]->PinPassword))
			{
				$ERRMSG = "Old Password should be not valid.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_newpassword')=='')
			{
				$ERRMSG = "New Password should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if(strlen($request->input('txt_newpassword'))<6)
			{
				$ERRMSG = "New password length would be greater then 6 or equal 6";
				$this->isError= TRUE;
				$ERRCODE="warning";
				
			}
			else if($request->input('txt_newcpassword')=='')
			{
				$ERRMSG = "Confirm New Password should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
				
			}
			else if(strlen($request->input('txt_newcpassword'))<4)
			{
				$ERRMSG = "New Confirm password length would be greater then 4 or equal 4";
				$this->isError= TRUE;
				$ERRCODE="warning";
				
			}
			else if($request->input('txt_newpassword')!=$request->input('txt_newcpassword'))
			{
				$ERRMSG = "Password does not match with confirm password.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_newpassword')==$request->input('txt_oldpassword'))
			{
				$ERRMSG = "Old Password and  New Password  both are same.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST' && $this->isError==FALSE)
			{
				$password=$request->input('txt_oldpassword');
				$new_password=$request->input('txt_newpassword');
				$new_cpassword=$request->input('txt_newcpassword');
				$userid=Session::get('USER_ID');
				$user_logindetails=$this->enroll_repo->updateUserTrans(Hash::make($new_password), $password, $userid);
				if($user_logindetails==1)
				{
					$arr = array(
						'tr11_ar_tblnm' => 'tr04_login',
						'tr11_ar_old_value' => $password,
						'tr11_ar_new_value' => $new_password,
						'tr11_ar_uid' => $userid,
						'tr11_ar_description' => 'USER S PIN PASSWORD HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 2,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
					$mobileno_actionrecord=$this->log_repo->create($arr);
					$ERRMSG="USER'S PASSWORD HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
				}
				else
				{
					$ERRMSG="USER'S PASSWORD HAS NOT BEEN CHANGED!";
					$ERRCODE='warning';	
				}
			}
		}
		Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);
		return redirect('change_transpassword'); 
	}

	/**
        * Method name   : Welcome letter
        * @description  : Used for viewing welcome letter
        * @param        : Request data 
        * @return       : return with welcome letter view
    */
	public function welcome_letter()
	{	
		//$tree_details=Helper::get_treedetails(Session::get('USER_ID'));
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_welcome_letter',compact('user'));
	}




/**
        * Method name   : user add money in wallet
        * @description  : Used for add money in wallet
        * @param        : Request data 
        * @return       : return with user add money in wallet
    */


	public function user_add_money_wallet(request $request)
		{
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$paydata = DB::table('tr31_online_payment')->where('m11_user_id', Session::get('USER_ID'))->orderBy('tr31_op_id', 'desc')->get();
			return view('User.user_add_money_wallet',compact('user','paydata'));
		}


	public function user_add_money_wallets(request $request)
		{
			$user = Helper::get_userdetail(Session::get('USER_ID'));
				if(count($user) > 0)
				{
				$response =  Helper::razorpay($request, $user[0]);
				$form_data = $request->all();
				return view('PaymentGateway.user_addwallet',compact('response','form_data'));
				}
				else
				{
					Session::flash('message','User not fount');
					Session::flash('type','warning');
					return redirect('user-add-money-wallet'); 
				}

			return view('User.user_add_money_wallet',compact('user'));
		}




    public function AddMoneyWallet(Request $request)
    {        
				// Now verify the signature is correct . We create the private function for verify the signature
			    $signatureStatus = Helper::SignatureVerify(
			        $request->all()['rzp_signature'],
			        $request->all()['rzp_paymentid'],
			        $request->all()['rzp_orderid']
			    );


			$dataarray = [
								  'm11_user_id' => Session::get('USER_ID'),
								  'm11_user_code' => Session::get('USER_CODE'),
								  'tr31_op_amount' => $request->txt_amount,
								  'tr31_op_currency' => 2,
								  'tr31_op_txnid' => $request->receiptId,
								  'tr31_op_paymentid' => $request->rzp_paymentid,
								  'tr31_op_gatewaytxn_id' => $request->rzp_orderid,
								  'tr31_op_gateway_res' => $request->rzp_signature,
								  'tr31_op_status' => 1,
								];

			DB::table('tr31_online_payment')->insert($dataarray);


			    // If Signature status is true We will save the payment response in our database
			    // In this tutorial we send the response to Success page if payment successfully made
			    if($signatureStatus)
			    {
					$fundtransfer_data=array(
					'proc'=>8,
					'to_user_id'=>Session::get('USER_ID'),
					'from_user_id'=>0,
					'amount'=>floatval($request->txt_amount),
					'collected_amount'=>floatval($request->txt_amount),
					'requesttype'=>1,
					'balfor'=>1,
					'transtype'=>1,
					'timelimit'=>(config('FUND_INTERVAL')*60),
					'defaultstatus'=>1,
					'remark'=>"ONLINE PAYMENT",
					'collected_remark'=>"ONLINE PAYMENT"
					);

					$fundtransfer = DB::SELECT('CALL wallettransfer(
					:proc, 
					:to_user_id,
					:from_user_id,
					:amount, 
					:collected_amount,
					:requesttype,
					:balfor,:transtype,
					:timelimit,
					:defaultstatus,
					:remark,
					:collected_remark,
					@status_code,
					@status_msg)'
					,$fundtransfer_data);
					$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
					$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
					$ERRCODE=$ERRCODE[0]->ERR_CODE;
					$ERRMSG=$ERRMSG[0]->ERR_MSG;
					$msg =  ' Money Added Successfully';
					if($ERRCODE=="success")
					{
						Session::flash('message', $msg);
						Session::flash('type', $ERRCODE);
						return redirect('user-add-money-wallet'); 
					}else
					{
							Session::flash('message', $ERRMSG);
							Session::flash('type', $ERRCODE);
							return redirect('user-add-money-wallet'); 
					}
				}
				else
				{
					$ERRMSG="PAYMENT FAILED";
                    $this->isError=FALSE;
                    $ERRCODE="warning";
				}
			
			Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
			return redirect('user-add-money-wallet'); 
		}




/**
        * Method name   : user recharge panel
        * @description  : Used for getting user recharge
        * @param        : Request data 
        * @return       : return with user recharge
    */


	public function user_recharge_panel()
		{
			$request = request();
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$news = Helper::get_news(0,'ACTIVE','EMPLOYEE');
			$OPERATOR = Helper::get_operator(1,'ACTIVE');
			$REPORTOPERATOR = Helper::get_operator(-2,'ACTIVE');
			$descrip="";
			$start = date('Y-m-d',strtotime(NOW()));
			$end =date('Y-m-d',strtotime(NOW()));
			$txt_account = '';
			$txt_memberid = Session::get('USER_ID');
			$txt_transid = '';
			$txt_noofrecords = '10';
			$dd_status='-1';
			$cond="";
			$cond1="  `tr05_recharge_detail`.`m07_service_id`=1 AND 1";
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_from')));
				$end = date('Y-m-d',strtotime($request->input('txt_to')));
				
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
				{
					$txt_transid=$request->input('txt_transid');
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
				{
					$dd_status=$request->input('dd_status');
				}
				if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
				{
					$cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
				}
	
			}
			$cond=$cond.$cond1;
			$recereport=array
			(
			'proc'=>2,
			'account'=>$txt_account,
			'transid'=>$txt_transid,
			'userid'=>$txt_memberid,
			'fromdate'=>$start,
			'todate'=>$end,
			'noofrecords'=>$txt_noofrecords,
			'recstatus'=>$dd_status,
			'descrip'=>$cond
			);
			//dd($recereport);
			$rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
			//Check Service On Or not 
			$UserService = DB::select("SELECT * FROM `user_services` WHERE `USER_ID`=".Session()->get('USER_ID')." AND `MS_SERVICE_NAME`='RECHARGE' AND `MS_STATUS`='Active' ");
			if($UserService){ $UserService='ON'; }
			else{ $UserService='OFF';  }

			return view('User.user_rechargepanel',compact('user','news','REPORTOPERATOR','OPERATOR','rec_report','OPERATOR','UserService'));
		}



	/**
			* Method name	: Auto Switch
			* @description 	: Used to Status_check Prepaid,DTH,Datacard 
			* @param		: Request data  
			* @return		: Get status_check data array with response message
		*/
		public function auto_switch_api($user_id,$transid,$brand_id,$hit_count)
		{
				$auto_switch='true';
				$ip='';$apitoken="";$userid="";$url="";
				$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
				$format="json";$param1="";$param2="";
				$res_format="json";$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="remark";
				$res_status="";$res_opid="";$res_rbid="";$res_msg="";
				$status1="PENDING";$status2=2;$method='GET';$status3="";$next_api='';
			        $rechreq=array(
					'proc'=>'6',
					'user_id'=>$user_id,
					'mobile'=>$transid,
					'operator'=>$brand_id,
					'amount'=>10,
					'requesttype'=>$hit_count,
					'servicetype'=>1,
					'agentid'=>1,
					'format'=>1,
					'timelimit'=>900,
					'defaultstatus'=>2
					);	
					$rechreq_report=DB::select('CALL dorecharge(				
					:proc,
					:user_id,
					:mobile,
					:operator,
					:amount,
					:requesttype,
					:servicetype,
					:agentid,
					:format,
					:timelimit,
					:defaultstatus,
					@msg,
					@msg2
					)',$rechreq);
					
					$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
					//dd($rechreq,$rechreq_report,$DB_ERROR[0]->ERROR);
					if($DB_ERROR[0]->ERROR!="Error")
					{
						//$transid=$DB_ERRMSG[0]->ERR_MSG;
						foreach($rechreq_report as $row)
						{						
							break;
						}
						$next_api=$row->next_api;
						$user_id=$row->user_id;
						$url=$row->url_address;	
						$operatorcode=$row->oper_code;
						$apiid=$row->apiid;
						$mobileno=$row->account;
						$amount=$row->amount;
						$agentid=$row->agentid;
						$opcode_id = DB::select("SELECT IFNULL(`m04_tc_brand_id`,'') as BRAND_ID,IFNULL(`m03_sr_type_id`,'') as SERVICE_ID FROM `m04_telecom_brand` WHERE `m04_tc_brand_id`=".$brand_id." AND `m04_tc_brand_status`='Active' LIMIT 1");
						$service_id=$opcode_id[0]->SERVICE_ID;
						$param1=$service_id;
						$res_format=$row->RES_FORMAT;$status=$row->RES_PARAM;$opid=$row->LIVEID;$rbid=$row->APITXNID;
						$res_success=$row->SUCCESS_VALUE;$res_fail=$row->FAILED_VALUE;$res_pending=$row->PENDING_VALUE;
						if($apitoken!="")
						$url=str_replace('@apitoken',$apitoken,$url);
						if($userid!="")
						$url=str_replace('@userid',$userid,$url);
						if($password!="")
						$url=str_replace('@password',$password,$url);
						if($mobileno!="")
						$url=str_replace('@account',$mobileno,$url);
						if($amount!="")
						$url=str_replace('@amount',$amount,$url);
						if($operatorcode!="")
						$url=str_replace('@operatorcode',$operatorcode,$url);
						if($DB_ERROR[0]->ERROR!="Error")
						$url=str_replace('@refrence',$DB_ERRMSG[0]->ERR_MSG,$url);
						if($format!="")
						$url=str_replace('@format',$format,$url);
						if($param1!="")
						$url=str_replace('@param1',$param1,$url);
						if($param2!="")
						$url=str_replace('@param2',$param2,$url);
						//echo $url.'</br>';
						//PRINT_R($DB_ERRMSG[0]->ERR_MSG);
						$response=Helper::_curl_execute('GET',$url,'');
						$response=str_replace("\xEF\xBB\xBF",'',$response); 
						//echo $response;
						//echo $hit_count;	
						  $arr = array(
							'tr05_remarks' =>trim("HIT count-".$hit_count."-".$response)
						);
						DB::table('tr05_recharge_detail')->where('tr05_trans_id',$transid)->update($arr);
						$response=str_replace("\xEF\xBB\xBF",'',$response); 
						$outgoinghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				        VALUES ('','$transid','$ip','$url','$response',2)");
                        $res_rbid=$transid;
                        
						if($res_format=="JSON")
						{
							$json=json_decode($response,true);
							$error_exist=array_key_exists('error',$json);
							$status_exist=array_key_exists('status',$json);
							$res_error='false';
							if($status!="" && $error_exist)
							{
								if($status_exist)
								{
								    $res_status=$json[$status];
									//$res_status='success';
									if($res_status==$res_fail && $error_exist)
									{
										$res_error=$json['error'];
										$auto_switch='true';
									}
									if($opid!='' && $res_status==$res_success)
									{
										$res_opid=$json[$opid];
										//$res_opid='';
										$auto_switch='false';
									}
									if($rbid!='' && $res_status!=$res_fail)
									{
										$res_rbid=$json[$rbid];
										//$res_rbid='';
									}
								}
								else
								{
									$res_error=$json['error'];
									$res_status="FAILED";
								}
								if($res_error=='true')
								{
									$auto_switch='true';
								}
							}
							else
							{
									if($status!="")
									{
										$res_status=$json[$status];
									}
									if($res_status==$res_fail )
									{
										$auto_switch='true';
									}
									if($opid!='' && $res_status==$res_success)
									{
										$res_opid=$json[$opid];
										$auto_switch='false';
									}
									if($rbid!='' && $res_status!=$res_fail)
									{
										$res_rbid=$json[$rbid];
									}
							}
							
						}
						if($res_format=="xml" || $res_format=="XML" )
						{
							$array = XmlToArray::convert($response);
							$json = json_encode($array);
							$xmlarray = json_decode($json,TRUE);
							if($status!="")
							{
								$res_status=$xmlarray[$status];
							}
							if($opid!='' && $res_status=="SUCCESS" )
							{
								$res_opid=$xmlarray[$opid];
								$auto_switch='false';
							}
							if($rbid!='' && ($res_status!="FAILED" || $res_status!="REFUND")  )
							{
								$res_rbid=$xmlarray[$rbid];
								$auto_switch='false';
							}
							if($msg!='' && ($res_status=="FAILED" || $res_status=="REFUND") )
							{
								$auto_switch='true';
							}
						}
						 					
						if($hit_count==5)
						{
							$auto_switch='false';
						}
						if($auto_switch=='false' || $next_api==0 )
						{
							if($res_status == $res_success || $res_status=="SUCCESS" || $res_status=="Success" )
							{	
								$status1="SUCCESS";
								$status2=1;
							}
							if($res_status==$res_pending || $res_status=="PENDING" || $res_status=="Pending")
							{
								$status1="PENDING";
								$status2=2;
							}
							if($res_status==$res_fail || $res_status=="FAILED" || $res_status=="REFUND" || $res_status=="Failed" || $res_status=="LOGINFAILED" || $res_status=="Error")
							{
								$status1="FAILED";
								$status2=4;
							}
							$respreport=array(
							'proc'=>1,
							'userid'=>$user_id,
							'account'=>$mobileno,
							'transid'=>$transid,
							'liveid'=>$res_opid,
							'amt'=>$amount,
							'recstatus'=>$status2,
							'descrip'=>1							
							);
							$resquery = DB::select('CALL recharge_statusupdate(
							:proc,
							:userid,
							:account,
							:transid,
							:liveid,
							:amt,
							:recstatus,
							:descrip,
							@resmsg)',$respreport);
							$ERRMSG = "RECHARGE IS ".$status1."-".$hit_count;
							$this->isError= FALSE;
							$ERRCODE="success";
						     $response_inc=response()->json([
						'ERROR'=>$ERRCODE,
						'MSG' =>$ERRMSG ,
						'STATUS'=>trim($status1),
						'MOBILE'=>trim($mobileno),
						'AMOUNT'=>trim($amount),
						'AGENTID'=>trim($agentid),
						'OPID'=>trim($res_opid),
						'TID'=>trim($transid),
						'BAL'=>trim(floatval(0.00))
						]);
						return $response_inc;
						
						}
					
						if($hit_count<6)
                          return $status3;
					}
			
		}
		/**
			* Method name   : do recharge
			* @description  : Used for recharge
			* @param        : Request data 
			* @return       : return with recharge response
    	*/
		public function do_recharge()
		{
			$request = request();
			$apitoken="";$userid="";$url="";
			$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";$operatorcircle="";
			$format="json";$param1="";$param2="";$api_operatorcode="";
			$res_format="json";$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="remark";
			$res_status="";$res_opid="";$res_rbid="";$res_msg="";$xmlarray ="";$mbal=0.00;$auto_switch='false';$hit_count=1;$auto_status='1';$next_api='';
			$SUCCESS_VALUE='';$PENDING_VALUE='';$FAILED_VALUE='';
			$status1="PENDING";
			$status2=2;
			$ERRCODE="warning";

			// RETAILER FEE
			$Controller = new Controller();
			$CountryInfo = $Controller->RETAILER_FEE();

			if($request->method() == 'POST')
			{
				if($request->input('txt_mobileno')=='')
				{
					$ERRMSG = "Consumner number should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('dd_brand')=='')
				{
					$ERRMSG = "Telecom Operator should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))<0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be negative.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$account=$request->input('txt_mobileno');
					$operatorcode=$request->input('dd_brand');
					$operatorcircle=$request->input('txt_circleid');
					$amount=$request->input('txt_amount');
					$rechreq=array(
					'proc'=>'1',
					'user_id'=>Session::get('USER_ID'),
					'mobile'=>$account,
					'operator'=>$operatorcode,
					'amount'=>$amount,
					'requesttype'=>1,
					'servicetype'=>1,
					'agentid'=>'',
					'format'=>$operatorcircle,
					'timelimit'=>(config('INTERVAL_RECHARGE')*60),
					'defaultstatus'=>2
					);	

					$rechreq_report = $this->rech_proc_repo->doRecharge($rechreq);
					$ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$ERROR=DB::select('SELECT @msg2 as ERROR');
					if($ERROR[0]->ERROR!="Error")
					{
						$transid=$ERRMSG[0]->ERR_MSG;
						foreach($rechreq_report as $row)
						{						
							break;
						}
						$next_api=$row->next_api;
						$url=$row->url_address;	
						$api_operatorcode=$row->oper_code;
						$apiid=$row->apiid;
						$param1=1;
						$res_format=$row->RES_FORMAT;$status=$row->RES_PARAM;$opid=$row->LIVEID;$rbid=$row->APITXNID;
						$SUCCESS_VALUE=$row->SUCCESS_VALUE;$PENDING_VALUE=$row->PENDING_VALUE;$FAILED_VALUE=$row->FAILED_VALUE;
						if($apitoken!="")
						$url=str_replace('@apitoken',$apitoken,$url);
						if($userid!="")
						$url=str_replace('@userid',$userid,$url);
						if($password!="")
						$url=str_replace('@password',$password,$url);
						if($account!="")
						$url=str_replace('@account',$account,$url);
						if($amount!="")
						$url=str_replace('@amount',$amount,$url);
						if($operatorcode!="")
						$url=str_replace('@operatorcode',$api_operatorcode,$url);
						if($ERROR[0]->ERROR!="Error")
						$url=str_replace('@refrence',$ERRMSG[0]->ERR_MSG,$url);
						if($format!="")
						$url=str_replace('@format',$format,$url);
						if($param1!="")
						$url=str_replace('@param1',$param1,$url);
						if($param2!="")
						$url=str_replace('@param2',$param2,$url);
						//echo $url.'</br>';
						//PRINT_R($ERRMSG[0]->ERR_MSG);
						$response=Helper::_curl_execute('GET',$url,'');
						$response=str_replace("\xEF\xBB\xBF",'',$response); 
				$outgoinghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				VALUES ('','$transid','$operatorcode','$url','$response',2)");	
								if($res_format=="string")
								{
									$regex0 = '/[A-Z][^\\;]*(SUCCESS)[^\\;]*/';
									$regex1 = '/[A-Z][^\\;]*(Success)[^\\;]*/';
									$regexS1= '/[A-Z][^\\;]*(Succesful)[^\\;]*/';
									$regexS2= '/[A-Z][^\\;]*(SUCCESFUL)[^\\;]*/';
									$regex2 = '/[A-Z][^\\;]*(Failed)[^\\;]*/';
									$regex3 = '/[A-Z][^\\;]*(FAILED)[^\\;]*/';
									$regex4 = '/[A-Z][^\\;]*(FAIL)[^\\;]*/';
									$status1="PENDING";
									$status2=2;
									$ERRCODE="warning";
									if(preg_match_all($regex0, $response, $match) || preg_match_all($regex1, $response, $match)) 
									{
										$start1 = "TXID ";
										$end1 = " ";
										$operid=Helper::getBetween($response,$start1,$end1);
										$res_status="SUCCESS";
										$status2=1;
										$margin=$amt;
										$ERRCODE="success";
									}
									if (preg_match_all($regex2, $response, $match) || preg_match_all($regex3, $response, $match) || preg_match_all($regex4, $response, $match)) 
									{
										$res_status="FAILED";
										$status2=4;
										if(preg_match_all($regex2, $response, $match) || preg_match_all($regex3, $response, $match))
										{
											$start1 = "Failed";
											$end1 = "BAL";
											$operid=Helper::getBetween($response,$start1,$end1);
										}
										if(preg_match_all($regex2, $response, $match))
										{
											$start1 = "Reson=";
											$end1 = "Bal";
											$operid=Helper::getBetween($response,$start1,$end1);
										}
										$ERRCODE="danger";
									}
								}
						if($res_format=="JSON")
						{
							$json=json_decode($response,true);
							if($status!="")
							{
								if(!empty($json[$status]))
								$res_status=$json[$status];
								else
								{
								$is_error=$json['error'];
								if($is_error=='true')
								$res_status="FAILED";
								}
								if($res_status==$FAILED_VALUE || $res_status=="FAILED" || $res_status=="REFUND" || $res_status=="Failed" || $res_status=="LOGINFAILED" || $res_status=="Error")
        						$auto_switch='true';
							}
							if($opid!='')
							{
							    if(!empty($json[$opid]))
								$res_opid=$json[$opid];
							}
							if($rbid!='')
							{
							       if(!empty($json[$rbid]))
									$res_rbid=$json[$rbid];
							}
						}
						if($res_format=="xml" || $res_format=="XML" )
						{
							$array = XmlToArray::convert($response);
							$json = json_encode($array);
							$xmlarray = json_decode($json,TRUE);
							if($status!="")
							{
								 if(!empty($xmlarray[$status]))
								$res_status=$xmlarray[$status];
								
							}
							if($opid!='' && $res_status=="SUCCESS" )
							{
							    if(!empty($xmlarray[$opid]))
								$res_opid=$xmlarray[$opid];
							}
							if($rbid!='' && ($res_status!="FAILED" || $res_status!="REFUND") )
							{
							    if(!empty($xmlarray[$rbid]))
								$res_rbid=$xmlarray[$rbid];
						
							}
							if($msg!='' && ($res_status!="FAILED" || $res_status!="REFUND") )
							{
							    if(!empty($xmlarray[$msg]))
								$res_msg=$xmlarray[$msg];
								
							}
							if($res_status=="FAILED" || $res_status=="REFUND") 
							{
							    $auto_switch='true';
							}
						}

						 $arr = array(
						    'tr05_api_txnid'=>$res_rbid,
							'tr05_remarks' =>trim($response)
						);
						DB::table('tr05_recharge_detail')->where('tr05_trans_id',$transid)->update($arr);
						if($auto_switch=='true' && $next_api!=0)
						{
							do{ 
								$auto_response=$this->auto_switch_api(Session::get('USER_ID'),$transid,$operatorcode,$hit_count);
								if($auto_response=='')
								$hit_count=$hit_count+1;
								else
								break;
							}while (($status=='' || $hit_count<6));
							   
								
						}
						else
						{
						    $auto_switch='false';$auto_status='1';
						}
					
						if($auto_switch=='false' && $auto_status!='')
						{
        						if($res_status==$SUCCESS_VALUE || $res_status=="SUCCESS" || $res_status=="Success" )
        						{
        							$status1="SUCCESS";
        							$status2=1;
        						}
        						if($res_status==$PENDING_VALUE || $res_status=="PENDING" || $res_status=="Pending")
        						{
        							$status1="PENDING";
        							$status2=2;
        						}
        						if($res_status==$FAILED_VALUE || $res_status=="FAILED" || $res_status=="REFUND" || $res_status=="Failed" || $res_status=="LOGINFAILED" || $res_status=="Error")
        						{
        							$status1="FAILED";
        							$status2=4;
        						}
						$respreport=array(
						'proc'=>1,
						'userid'=>Session::get('USER_ID'),
						'account'=>$account,
						'transid'=>$transid,
						'liveid'=>$res_opid,
						'amt'=>$amount,
						'recstatus'=>$status2,
						'descrip'=>1							
						);
						$resquery = $this->rech_proc_repo->rechargeStatusUpdate($respreport);
						}
						$ERRCODE=$ERRCODE;
						$ERRMSG="RECHARGE HAS BEEN ".$status1." TRANSACTION ID- ".$ERRMSG[0]->ERR_MSG;

					}
					else
					{
						$ERRCODE='warning';
						$ERRMSG=$ERRMSG[0]->ERR_MSG;
					}
				}
			}

		Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);
		return redirect('user_recharge_panel'); 
				}


		/**
			* Method name   : user dth panel
			* @description  : Used for getting user dth
			* @param        : Request data 
			* @return       : return with user dth
		*/
		public function user_dth_panel()
		{
			$request = request();
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$news = Helper::get_news(0,'ACTIVE','EMPLOYEE');
			$DTH=Helper::get_operator(2,'ACTIVE');
			$descrip="";
			$start = date('Y-m-d',strtotime(NOW()));
			$end =date('Y-m-d',strtotime(NOW()));
			$txt_account = '';
			$txt_memberid = Session::get('USER_ID');
			$txt_transid = '';
			$txt_noofrecords = '10';
			$dd_status='-1';
			$cond="";
			$cond1="`tr05_recharge_detail`.`m07_service_id`=2 AND 1";
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_from')));
				$end = date('Y-m-d',strtotime($request->input('txt_to')));
				
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
				{
					$txt_transid=$request->input('txt_transid');
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
				{
					$dd_status=$request->input('dd_status');
				}
				if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
				{
					$cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
				}
				
				
			}
			$cond=$cond.$cond1;
			$recereport=array
			(
			'proc'=>2,
			'account'=>$txt_account,
			'transid'=>$txt_transid,
			'userid'=>$txt_memberid,
			'fromdate'=>$start,
			'todate'=>$end,
			'noofrecords'=>$txt_noofrecords,
			'recstatus'=>$dd_status,
			'descrip'=>$cond
			);
			//dd($recereport);
			$rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
			//Check Service On Or not 
			$UserService = DB::select("SELECT * FROM `user_services` WHERE `USER_ID`=".Session()->get('USER_ID')." AND `MS_SERVICE_NAME`='DTH' AND `MS_STATUS`='Active' ");
			if($UserService){ $UserService='ON'; }
			else{ $UserService='OFF';  }

			return view('User.user_dthpanel',compact('user','news','DTH','rec_report','UserService'));
		}

		/**
			* Method name   : do dth recharge
			* @description  : Used for dth recharge
			* @param        : Request data 
			* @return       : return with dth recharge response
    	*/
		public function do_dthrecharge()
		{
			$request = request();
			$apitoken="";$userid="";$url="";
			$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
			$format="json";$param1="";$param2="";
			$res_format="json";$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="remark";
			$res_status="";$res_opid="";$res_rbid="";$res_msg="";$xmlarray ="";$mbal=0.00;$auto_switch='false';$hit_count=1;$auto_status='1';$next_api='';
			$SUCCESS_VALUE='';$PENDING_VALUE='';$FAILED_VALUE='';
			$status1="PENDING";
			$status2=2;
			$ERRCODE="warning";

			// RETAILER FEE
			$Controller = new Controller();
			$CountryInfo = $Controller->RETAILER_FEE();
			if($request->method() == 'POST')
			{
				if($request->input('txt_cardno')=='')
				{
					$ERRMSG = "Consumner number should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('dd_dthbrand')=='')
				{
					$ERRMSG = "Telecom Operator should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_dthamount'))=='' || floatval($request->input('txt_dthamount'))==0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_dthamount'))<0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be negative.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$account=$request->input('txt_cardno');
					$operatorcode=$request->input('dd_dthbrand');
					$amount=$request->input('txt_dthamount');
					$rechreq=array(
					'proc'=>'1',
					'user_id'=>Session::get('USER_ID'),
					'mobile'=>$account,
					'operator'=>$operatorcode,
					'amount'=>$amount,
					'requesttype'=>1,
					'servicetype'=>2,
					'agentid'=>'',
					'format'=>1,
					'timelimit'=>(config('INTERVAL_RECHARGE')*60),
					'defaultstatus'=>2
					);	

					$rechreq_report = $this->rech_proc_repo->doRecharge($rechreq);
					$ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$ERROR=DB::select('SELECT @msg2 as ERROR');
				//	dd($ERRMSG[0]->ERR_MSG);
					if($ERROR[0]->ERROR!="Error")
					{
						$transid=$ERRMSG[0]->ERR_MSG;
						foreach($rechreq_report as $row)
						{						
							break;
						}
						$next_api=$row->next_api;
						$url=$row->url_address;	
						$operatorcode=$row->oper_code;
						$apiid=$row->apiid;
						$param1=2;
						$res_format=$row->RES_FORMAT;$status=$row->RES_PARAM;$opid=$row->LIVEID;$rbid=$row->APITXNID;
						$SUCCESS_VALUE=$row->SUCCESS_VALUE;$PENDING_VALUE=$row->PENDING_VALUE;$FAILED_VALUE=$row->FAILED_VALUE;
						if($apitoken!="")
						$url=str_replace('@apitoken',$apitoken,$url);
						if($userid!="")
						$url=str_replace('@userid',$userid,$url);
						if($password!="")
						$url=str_replace('@password',$password,$url);
						if($account!="")
						$url=str_replace('@account',$account,$url);
						if($amount!="")
						$url=str_replace('@amount',$amount,$url);
						if($operatorcode!="")
						$url=str_replace('@operatorcode',$operatorcode,$url);
						if($ERROR[0]->ERROR!="Error")
						$url=str_replace('@refrence',$ERRMSG[0]->ERR_MSG,$url);
						if($format!="")
						$url=str_replace('@format',$format,$url);
						if($param1!="")
						$url=str_replace('@param1',$param1,$url);
						if($param2!="")
						$url=str_replace('@param2',$param2,$url);
						//echo $url.'</br>';
						//PRINT_R($ERRMSG[0]->ERR_MSG);
						$response=Helper::_curl_execute('GET',$url,'');
						$response=str_replace("\xEF\xBB\xBF",'',$response); 
				$outgoinghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				VALUES ('','$transid','$operatorcode','$url','$response',2)");	
                      $res_rbid="2598223";
								if($res_format=="string")
								{
									$regex0 = '/[A-Z][^\\;]*(SUCCESS)[^\\;]*/';
									$regex1 = '/[A-Z][^\\;]*(Success)[^\\;]*/';
									$regexS1= '/[A-Z][^\\;]*(Succesful)[^\\;]*/';
									$regexS2= '/[A-Z][^\\;]*(SUCCESFUL)[^\\;]*/';
									$regex2 = '/[A-Z][^\\;]*(Failed)[^\\;]*/';
									$regex3 = '/[A-Z][^\\;]*(FAILED)[^\\;]*/';
									$regex4 = '/[A-Z][^\\;]*(FAIL)[^\\;]*/';
									$status1="PENDING";
									$status2=2;
									$ERRCODE="warning";
									if(preg_match_all($regex0, $response, $match) || preg_match_all($regex1, $response, $match)) 
									{
										$start1 = "TXID ";
										$end1 = " ";
										$operid=Helper::getBetween($response,$start1,$end1);
										$res_status="SUCCESS";
										$status2=1;
										$margin=$amt;
										$ERRCODE="success";
									}
									if (preg_match_all($regex2, $response, $match) || preg_match_all($regex3, $response, $match) || preg_match_all($regex4, $response, $match)) 
									{
										$res_status="FAILED";
										$status2=4;
										if(preg_match_all($regex2, $response, $match) || preg_match_all($regex3, $response, $match))
										{
											$start1 = "Failed";
											$end1 = "BAL";
											$operid=Helper::getBetween($response,$start1,$end1);
										}
										if(preg_match_all($regex2, $response, $match))
										{
											$start1 = "Reson=";
											$end1 = "Bal";
											$operid=Helper::getBetween($response,$start1,$end1);
										}
										$ERRCODE="danger";
									}
								}
						if($res_format=="JSON")
						{
							$json=json_decode($response,true);
							if($status!="")
							{
									if(!empty($json[$status]))
								$res_status=$json[$status];
								else
								{
								$is_error=$json['error'];
								if($is_error=='true')
								$res_status="FAILED";
								}
								if($res_status==$FAILED_VALUE || $res_status=="FAILED" || $res_status=="REFUND" || $res_status=="Failed" || $res_status=="LOGINFAILED" || $res_status=="Error")
        						$auto_switch='true';
							}
						if($opid!='')
							{
							    if(!empty($json[$opid]))
								$res_opid=$json[$opid];
							}
							if($rbid!='')
							{
							       if(!empty($json[$rbid]))
									$res_rbid=$json[$rbid];
							}
						}
						if($res_format=="xml" || $res_format=="XML" )
						{
							$array = XmlToArray::convert($response);
							$json = json_encode($array);
							$xmlarray = json_decode($json,TRUE);
							if($status!="")
							{
								 if(!empty($xmlarray[$status]))
								$res_status=$xmlarray[$status];
								
							}
							if($opid!='' && $res_status=="SUCCESS" )
							{
							    if(!empty($xmlarray[$opid]))
								$res_opid=$xmlarray[$opid];
							}
							if($rbid!='' && ($res_status!="FAILED" || $res_status!="REFUND") )
							{
							    if(!empty($xmlarray[$rbid]))
								$res_rbid=$xmlarray[$rbid];
						
							}
							if($msg!='' && ($res_status!="FAILED" || $res_status!="REFUND") )
							{
							    if(!empty($xmlarray[$msg]))
								$res_msg=$xmlarray[$msg];
								
							}
							if($res_status=="FAILED" || $res_status=="REFUND") 
							{
							    $auto_switch='true';
							}
						}

						 $arr = array(
						    'tr05_api_txnid'=>$res_rbid,
							'tr05_remarks' =>trim($response)
						);
						DB::table('tr05_recharge_detail')->where('tr05_trans_id',$transid)->update($arr);
						if($auto_switch=='true' && $next_api!=0)
						{
							do{ 
								$auto_response=$this->auto_switch_api(Session::get('USER_ID'),$transid,$operatorcode,$hit_count);
								if($auto_response=='')
								$hit_count=$hit_count+1;
								else
								break;
							}while (($status=='' || $hit_count<6));
							   
								
						}
						else
						{
						    $auto_switch='false';$auto_status='1';
						}
					
						if($auto_switch=='false' && $auto_status!='')
						{
        						if($res_status==$SUCCESS_VALUE || $res_status=="SUCCESS" || $res_status=="Success" )
        						{
        							$status1="SUCCESS";
        							$status2=1;
        						}
        						if($res_status==$PENDING_VALUE || $res_status=="PENDING" || $res_status=="Pending")
        						{
        							$status1="PENDING";
        							$status2=2;
        						}
        						if($res_status==$FAILED_VALUE || $res_status=="FAILED" || $res_status=="REFUND" || $res_status=="Failed" || $res_status=="LOGINFAILED" || $res_status=="Error")
        						{
        							$status1="FAILED";
        							$status2=4;
        						}
						$respreport=array(
						'proc'=>1,
						'userid'=>Session::get('USER_ID'),
						'account'=>$account,
						'transid'=>$transid,
						'liveid'=>$res_opid,
						'amt'=>$amount,
						'recstatus'=>$status2,
						'descrip'=>1							
						);
						$resquery = $this->rech_proc_repo->rechargeStatusUpdate($respreport);
								}
						$ERRCODE=$ERRCODE;
						$ERRMSG="RECHARGE HAS BEEN ".$status1." TRANSACTION ID- ".$ERRMSG[0]->ERR_MSG;
					}
					else
					{
						Session::flash('type','warning');
						Session::flash('message',$ERRMSG[0]->ERR_MSG );
					}
				}
			}
				Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);
		return redirect('user_dth_panel'); 		
		}


		/**
        * Method name   : user broadband panel
        * @description  : Used for getting user broadband
        * @param        : Request data 
        * @return       : return with user broadband
    */


	public function user_broadband_panel()
		{
			$request = request();
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$news = Helper::get_news(0,'ACTIVE','EMPLOYEE');
			$BOARDBAND=Helper::get_operator(6,'ACTIVE');
			$descrip="";
			$start = date('Y-m-d',strtotime(NOW()));
			$end =date('Y-m-d',strtotime(NOW()));
			$txt_account = '';
			$txt_memberid = Session::get('USER_ID');
			$txt_transid = '';
			$txt_noofrecords = '10';
			$dd_status='-1';
			$cond="";
			$cond1="1";
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_from')));
				$end = date('Y-m-d',strtotime($request->input('txt_to')));
				
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
				{
					$txt_transid=$request->input('txt_transid');
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
				{
					$dd_status=$request->input('dd_status');
				}
				if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
				{
					$cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
				}
				
				
			}
			$cond=$cond.$cond1;
			$recereport=array
			(
			'proc'=>2,
			'account'=>$txt_account,
			'transid'=>$txt_transid,
			'userid'=>$txt_memberid,
			'fromdate'=>$start,
			'todate'=>$end,
			'noofrecords'=>$txt_noofrecords,
			'recstatus'=>$dd_status,
			'descrip'=>$cond
			);
			//dd($recereport);
			$rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
			//Check Service On Or not 
			$UserService = DB::select("SELECT * FROM `user_services` WHERE `USER_ID`=".Session()->get('USER_ID')." AND `MS_SERVICE_NAME`='BROADBAND' AND `MS_STATUS`='Active' ");
			if($UserService){ $UserService='ON'; }
			else{ $UserService='OFF';  }

			return view('User.user_broadband',compact('user','news','BOARDBAND','rec_report','UserService'));
		}

		/**
        * Method name   : user landline panel
        * @description  : Used for getting user landline
        * @param        : Request data 
        * @return       : return with user landline
    */


	public function user_landline_panel()
		{
			$request = request();
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$news = Helper::get_news(0,'ACTIVE','EMPLOYEE');
			$LANDLINE=Helper::get_operator(5,'ACTIVE');
			$descrip="";
			$start = date('Y-m-d',strtotime(NOW()));
			$end =date('Y-m-d',strtotime(NOW()));
			$txt_account = '';
			$txt_memberid = Session::get('USER_ID');
			$txt_transid = '';
			$txt_noofrecords = '10';
			$dd_status='-1';
			$cond="";
			$cond1="1";
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_from')));
				$end = date('Y-m-d',strtotime($request->input('txt_to')));
				
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
				{
					$txt_transid=$request->input('txt_transid');
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
				{
					$dd_status=$request->input('dd_status');
				}
				if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
				{
					$cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
				}
				
				
			}
			$cond=$cond.$cond1;
			$recereport=array
			(
			'proc'=>2,
				 'mobile'=>'',
			'account'=>$txt_account,
			'transid'=>$txt_transid,
			'userid'=>$txt_memberid,
			'fromdate'=>$start,
			'todate'=>$end,
			'noofrecords'=>$txt_noofrecords,
			'recstatus'=>$dd_status,
			'descrip'=>$cond
			);
			//dd($recereport);
			$rec_report = $this->rech_reprt_repo->billpayReport($recereport);
			//Check Service On Or not 
			$UserService = DB::select("SELECT * FROM `user_services` WHERE `USER_ID`=".Session()->get('USER_ID')." AND `MS_SERVICE_NAME`='LANDLINE' AND `MS_STATUS`='Active' ");
			if($UserService){ $UserService='ON'; }
			else{ $UserService='OFF';  }

			return view('User.user_landline',compact('user','news','LANDLINE','rec_report','UserService'));
		}


		/**
        * Method name   : user electricity panel
        * @description  : Used for getting user electricity
        * @param        : Request data 
        * @return       : return with user electricity
    */
	public function user_electricity_panel()
		{
			$request = request();
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$news = Helper::get_news(0,'ACTIVE','EMPLOYEE');
			$ELECTRICITY=Helper::get_operator(3,'ACTIVE');
			$descrip="";
			$start = date('Y-m-d',strtotime(NOW()));
			$end =date('Y-m-d',strtotime(NOW()));
			$txt_account = '';
			$txt_memberid = Session::get('USER_ID');
			$txt_transid = '';
			$txt_noofrecords = '10';
			$dd_status='-1';
			$cond="";
			$cond1="1";
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_from')));
				$end = date('Y-m-d',strtotime($request->input('txt_to')));
				
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
				{
					$txt_transid=$request->input('txt_transid');
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
				{
					$dd_status=$request->input('dd_status');
				}
				if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
				{
					$cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
				}
				
				
			}
			$cond=$cond.$cond1;
			$recereport=array
			(
			'proc'=>2,
				 'mobile'=>'',
			'account'=>$txt_account,
			'transid'=>$txt_transid,
			'userid'=>$txt_memberid,
			'fromdate'=>$start,
			'todate'=>$end,
			'noofrecords'=>$txt_noofrecords,
			'recstatus'=>$dd_status,
			'descrip'=>$cond
			);
			//dd($recereport);
			$rec_report = $this->rech_reprt_repo->billpayReport($recereport);
			//Check Service On Or not 
			$UserService = DB::select("SELECT * FROM `user_services` WHERE `USER_ID`=".Session()->get('USER_ID')." AND `MS_SERVICE_NAME`='ELECTRICITY' AND `MS_STATUS`='Active' ");
			if($UserService){ $UserService='ON'; }
			else{ $UserService='OFF';  }

			return view('User.user_electricity',compact('user','news','ELECTRICITY','rec_report','UserService'));
		}

		/**
        * Method name   : user gasbill panel
        * @description  : Used for getting user gasbill
        * @param        : Request data 
        * @return       : return with user gasbill
    */
	public function user_gasbill_panel()
		{
			$request = request();
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$news = Helper::get_news(0,'ACTIVE','EMPLOYEE');
			$GAS=Helper::get_operator(7,'ACTIVE');
			$descrip="";
			$start = date('Y-m-d',strtotime(NOW()));
			$end =date('Y-m-d',strtotime(NOW()));
			$txt_account = '';
			$txt_memberid = Session::get('USER_ID');
			$txt_transid = '';
			$txt_noofrecords = '10';
			$dd_status='-1';
			$cond="";
			$cond1="1";
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_from')));
				$end = date('Y-m-d',strtotime($request->input('txt_to')));
				
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
				{
					$txt_transid=$request->input('txt_transid');
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
				{
					$dd_status=$request->input('dd_status');
				}
				if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
				{
					$cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
				}
				
				
			}
			$cond=$cond.$cond1;
			$recereport=array
			(
			'proc'=>2,
				 'mobile'=>'',
			'account'=>$txt_account,
			'transid'=>$txt_transid,
			'userid'=>$txt_memberid,
			'fromdate'=>$start,
			'todate'=>$end,
			'noofrecords'=>$txt_noofrecords,
			'recstatus'=>$dd_status,
			'descrip'=>$cond
			);
			//dd($recereport);
			$rec_report = $this->rech_reprt_repo->billpayReport($recereport);
			//Check Service On Or not 
			$UserService = DB::select("SELECT * FROM `user_services` WHERE `USER_ID`=".Session()->get('USER_ID')." AND `MS_SERVICE_NAME`='GAS' AND `MS_STATUS`='Active' ");
			if($UserService){ $UserService='ON'; }
			else{ $UserService='OFF';  }

			return view('User.user_gasbill',compact('user','news','GAS','rec_report','UserService'));
		}

		/**
        * Method name   : user waterbill panel
        * @description  : Used for getting user waterbill
        * @param        : Request data 
        * @return       : return with user waterbill
    */
	public function user_waterbill_panel()
		{
			$request = request();
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$news = Helper::get_news(0,'ACTIVE','EMPLOYEE');
			$WATER=Helper::get_operator(8,'ACTIVE');
			$descrip="";
			$start = date('Y-m-d',strtotime(NOW()));
			$end =date('Y-m-d',strtotime(NOW()));
			$txt_account = '';
			$txt_memberid = Session::get('USER_ID');
			$txt_transid = '';
			$txt_noofrecords = '10';
			$dd_status='-1';
			$cond="";
			$cond1="1";
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_from')));
				$end = date('Y-m-d',strtotime($request->input('txt_to')));
				
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
				{
					$txt_transid=$request->input('txt_transid');
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
				{
					$dd_status=$request->input('dd_status');
				}
				if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
				{
					$cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
				}
				
				
			}
			$cond=$cond.$cond1;
			$recereport=array
			(
			'proc'=>2,
				 'mobile'=>'',
			'account'=>$txt_account,
			'transid'=>$txt_transid,
			'userid'=>$txt_memberid,
			'fromdate'=>$start,
			'todate'=>$end,
			'noofrecords'=>$txt_noofrecords,
			'recstatus'=>$dd_status,
			'descrip'=>$cond
			);
			//dd($recereport);
			$rec_report = $this->rech_reprt_repo->billpayReport($recereport);
			//Check Service On Or not 
			$UserService = DB::select("SELECT * FROM `user_services` WHERE `USER_ID`=".Session()->get('USER_ID')." AND `MS_SERVICE_NAME`='GAS' AND `MS_STATUS`='Active' ");
			if($UserService){ $UserService='ON'; }
			else{ $UserService='OFF';  }
			return view('User.user_waterbill',compact('user','news','WATER','rec_report','UserService'));
		}


		/**
			* Method name   : DO UTILITY PAYMENT
			* @description  : Used for BILL PAY 
			* @param        : Request data 
			* @return       : return with recharge response
    	*/
		public function do_utilitypayment()
		{
			$request = request();
			$apitoken="";$userid="";$url="";
			$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
			$format="json";$param1="";$param2="";
			$res_format="json";$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="remark";
			$res_status="";$res_opid="";$res_rbid="";$res_msg="";$xmlarray ="";
			$SUCCESS_VALUE='';$PENDING_VALUE='';$FAILED_VALUE='';
			$status1="PENDING";$service_id="";
			$status2=2;
			$ERRCODE="warning";$param1='';$param2='';$param3='';

			// RETAILER FEE
			$Controller = new Controller();
			$CountryInfo = $Controller->RETAILER_FEE();

			$number=$request->input('txt_number');
			$amount  =$request->input('txt_amount');
			$opcode  =$request->input('dd_brand');

			if($request->method() == 'POST')
			{
				if($request->input('dd_brand')=='')
				{
					$ERRMSG = "Telecom Operator should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_number')=='')
				{
					$ERRMSG = "Number should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))<0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be negative.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					
					$opcode_id = DB::select("SELECT IFNULL(`m04_tc_brand_id`,'') as BRAND_ID,IFNULL(`m03_sr_type_id`,'') as SERVICE_ID FROM `m04_telecom_brand` WHERE `m04_tc_brand_code`='".$opcode."' AND `m04_tc_brand_status`=1 LIMIT 1");
					//dd($opcode_id);
					$brand_id=$opcode_id[0]->BRAND_ID;
					$service_id=$opcode_id[0]->SERVICE_ID;
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
				if(request()->method() == 'POST' && $this->isError==FALSE && $service_id!='')
				{
					$number=$request->input('txt_number');
				
					$operatorcode=$request->input('dd_brand');
					$amount=$request->input('txt_amount');
					$rechreq=array(
					'proc'=>'1',
					'user_id'=>Session::get('USER_ID'),
					'mobile'=>$number,
					'account'=>$account,
					'operator'=>$brand_id,
					'amount'=>$amount,
					'requesttype'=>1,
					'servicetype'=>$service_id,
					'agentid'=>'',
					'format'=>'json',
					'timelimit'=>(config('INTERVAL_RECHARGE')*60),
					'defaultstatus'=>2
					);	
				
					$rechreq_report = $this->rech_proc_repo->doBillpay($rechreq);
					$ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$ERROR=DB::select('SELECT @msg2 as ERROR');
					
					if($ERROR[0]->ERROR!="Error")
					{;
						$transid=$ERRMSG[0]->ERR_MSG;
						foreach($rechreq_report as $row)
						{						
							break;
						}
						
						$url=$row->url_address;	
						$operatorcode=$row->oper_code;
						$apiid=$row->apiid;
						$param1=Session::get('CONTACTNO');
					    $param2=$transid;
					    if($request->input('txt_account')!='')
					    $param3=$request->input('txt_account');
						$res_format=$row->RES_FORMAT;$status=$row->RES_PARAM;$opid=$row->LIVEID;$rbid=$row->APITXNID;
						$SUCCESS_VALUE=$row->SUCCESS_VALUE;$PENDING_VALUE=$row->PENDING_VALUE;$FAILED_VALUE=$row->FAILED_VALUE;
						if($apitoken!="")
						$url=str_replace('@apitoken',$apitoken,$url);
						if($userid!="")
						$url=str_replace('@userid',$userid,$url);
						if($password!="")
						$url=str_replace('@password',$password,$url);
						if($account!="")
						$url=str_replace('@account',$number,$url);
						if($amount!="")
						$url=str_replace('@amount',$amount,$url);
						if($operatorcode!="")
						$url=str_replace('@operatorcode',$operatorcode,$url);
						if($ERROR[0]->ERROR!="Error")
						$url=str_replace('@refrence',$ERRMSG[0]->ERR_MSG,$url);
						if($format!="")
						$url=str_replace('@format',$format,$url);
						if($param1!="")
						$url=str_replace('@param1',$param1,$url);
						if($param2!="")
						$url=str_replace('@param2',$param2,$url);
						$url=str_replace('@param3',$param3,$url);
						//echo $url.'</br>';
						//PRINT_R($ERRMSG[0]->ERR_MSG);
						$response=Helper::_curl_execute('GET',$url,'');
						$response=str_replace("\xEF\xBB\xBF",'',$response); 
						//echo $response;
						//dd();
				$outgoinghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				VALUES ('','','$operatorcode','$url','$response',2)");	
								if($res_format=="string")
								{
									$regex0 = '/[A-Z][^\\;]*(SUCCESS)[^\\;]*/';
									$regex1 = '/[A-Z][^\\;]*(Success)[^\\;]*/';
									$regexS1= '/[A-Z][^\\;]*(Succesful)[^\\;]*/';
									$regexS2= '/[A-Z][^\\;]*(SUCCESFUL)[^\\;]*/';
									$regex2 = '/[A-Z][^\\;]*(Failed)[^\\;]*/';
									$regex3 = '/[A-Z][^\\;]*(FAILED)[^\\;]*/';
									$regex4 = '/[A-Z][^\\;]*(FAIL)[^\\;]*/';
									$status1="PENDING";
									$status2=2;
									$ERRCODE="warning";
									if(preg_match_all($regex0, $response, $match) || preg_match_all($regex1, $response, $match)) 
									{
										$start1 = "TXID ";
										$end1 = " ";
										$operid=Helper::getBetween($response,$start1,$end1);
										$res_status="SUCCESS";
										$status2=1;
										$margin=$amt;
										$ERRCODE="success";
									}
									if (preg_match_all($regex2, $response, $match) || preg_match_all($regex3, $response, $match) || preg_match_all($regex4, $response, $match)) 
									{
										$res_status="FAILED";
										$status2=4;
										if(preg_match_all($regex2, $response, $match) || preg_match_all($regex3, $response, $match))
										{
											$start1 = "Failed";
											$end1 = "BAL";
											$operid=Helper::getBetween($response,$start1,$end1);
										}
										if(preg_match_all($regex2, $response, $match))
										{
											$start1 = "Reson=";
											$end1 = "Bal";
											$operid=Helper::getBetween($response,$start1,$end1);
										}
										$ERRCODE="danger";
									}
								}
						if($res_format=="JSON")
						{
							$json=json_decode($response,true);
							if($status!="")
							{
								$res_status=$json[$status];
							}
							if($opid!='')
							{
								$res_opid=$json[$opid];
							}
							if($rbid!='')
							{
									$res_rbid=$json[$rbid];
							}
						}
						if($res_format=="xml" || $res_format=="XML" )
						{
							$array = XmlToArray::convert($response);
							$json = json_encode($array);
							$xmlarray = json_decode($json,TRUE);
							$res_opid='';
							if($status!="")
							{
								 $res_status=$xmlarray[$status];
							}
							if($opid!='' && $res_status!="PENDING")
							{
								$res_opid=$xmlarray[$opid];
							}
							if($rbid!='')
							{
								 $res_rbid=$xmlarray[$rbid];
							}
							if($msg!='')
							{
								 $res_msg=$xmlarray[$msg];
							}
						}
		
						$rechres=array(
						'proc'=>'2',
						'user_id'=>Session::get('USER_ID'),
						'mobile'=>$transid,
						'account'=>$account,
						'operator'=>$response,
						'amount'=>$amount,
						'requesttype'=>1,
						'servicetype'=>1,
						'agentid'=>$res_rbid,
						'format'=>'json',
						'timelimit'=>(config('INTERVAL_RECHARGE')*60),
						'defaultstatus'=>'2'
						);	
						$rechres_report = $this->rech_proc_repo->doBillpay($rechres);
						if($res_status==$SUCCESS_VALUE || $res_status=="SUCCESS" || $res_status=="Success" )
						{
							$status1="SUCCESS";
							$status2=1;
							$ERRCODE="success";
						}
						if($res_status==$PENDING_VALUE || $res_status=="PENDING" || $res_status=="Pending")
						{
							$status1="PENDING";
							$status2=2;
							$ERRCODE="warning";
						}
						if($res_status==$FAILED_VALUE || $res_status=="FAILED" || $res_status=="Failed" || $res_status=="LOGINFAILED")
						{
							$status1="FAILED";
							$status2=4;
							$ERRCODE="error";
						}
						$respreport=array(
						'proc'=>1,
						'userid'=>Session::get('USER_ID'),
						'account'=>$account,
						'transid'=>$transid,
						'liveid'=>$res_opid,
						'amt'=>$amount,
						'recstatus'=>$status2,
						'descrip'=>1							
						);
						$resquery = $this->rech_proc_repo->rechargeStatusUpdate($respreport);
						$ERRCODE=$ERRCODE;
						$ERRMSG="RECHARGE HAS BEEN ".$status1." TRANSACTION ID- ".$ERRMSG[0]->ERR_MSG;

					}
					else
					{
						$ERRCODE='warning';
						$ERRMSG=$ERRMSG[0]->ERR_MSG;
					}
				}
			}
		
		$opcode_id = DB::select("SELECT IFNULL(`m04_tc_brand_id`,'') as BRAND_ID,IFNULL(`m03_sr_type_id`,'') as SERVICE_ID FROM `m04_telecom_brand` WHERE `m04_tc_brand_code`='".$opcode."' AND `m04_tc_brand_status`=1 LIMIT 1");
		
		$brand_id=$opcode_id[0]->BRAND_ID;
		$service_id=$opcode_id[0]->SERVICE_ID;
		Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);
		//dd($service_id);
		if($service_id==3)
		return redirect('user_electricity_panel'); 
		if($service_id==5)
		return redirect('user_landline_panel'); 
		if($service_id==6)
		return redirect('user_broadband_panel'); 
		if($service_id==7)
		return redirect('user_gasbill_panel'); 
		if($service_id==8)
		return redirect('user_waterbill_panel'); 
		}


/**
			* Method name	: Check Bill
			* @description 	: Used to Check Bill
			* @param		: Request data  
			* @return		: Get Check Bill array with response message
		*/
		public function check_bill(Request $request)
		{
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$apitoken="";$userid="";$url="";
				$password="";$number="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
				$format="json";$param1="";$param2="";
				
				$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="MESSAGE";
				$res_status="";$res_opid="";$res_rbid="";$res_msg="";
				$status1="PENDING";$status2=2;
				$customer_num1="";$account1="";$number1="";$amount1="";$opt1="";
		
				$account1=$request->has('txt_account')?'1':'0';
				$number1=$request->has('txt_number')?'1':'0';
				$amount1=$request->has('txt_amount')?'1':'0';
				$opt1=$request->has('dd_brand')?'1':'0';
				$agentid ='123456789';
				$format  ='json';
				$ip=$request->server('REMOTE_ADDR');
				$fullurl=$request->fullUrl();
				$incmghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				VALUES ('','$agentid','$ip','$fullurl','',1)");		
			
					if($this->isError== FALSE)
					{
					    
					 if($request->input('txt_number')=='')
						{
							$ERRMSG = "Number should be valid.";
							$this->isError= TRUE;
							$ERRCODE="success";
							$userData ='';
						}
						else if(trim($request->input('dd_brand')) == '')
						{
							$ERRMSG = "Operator Code should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else
						{
							$number=$request->input('txt_number');
							$account=$request->input('txt_account');
							$amount =$request->input('txt_amount');
						
							$opcode  =$request->input('dd_brand');
							$opcode_id = DB::select("SELECT IFNULL(`m04_tc_brand_id`,'') as BRAND_ID,IFNULL(`m03_sr_type_id`,'') as SERVICE_ID FROM `m04_telecom_brand` WHERE `m04_tc_brand_code`='".$opcode."' AND `m04_tc_brand_status`='Active' LIMIT 1");
							$brand_id=$opcode_id[0]->BRAND_ID;
							$service_id=$opcode_id[0]->SERVICE_ID;
							$ERRMSG = "D.";
							$this->isError= FALSE;
							$ERRCODE="success";
							$userData =$opcode_id[0]->BRAND_ID.'_'.$service_id;
						}
					}
					if($this->isError== FALSE)
					{
					
						if("Success"!="Error")
						{
							$cond="m07_service_id=".$service_id."  AND 1 ";
							$res_rbid="2598223";
							$url = 'https://www.mplan.in/api/electricinfo.php';
                    		$params = array(
                    			'apikey'=>'6360068463b3dc88cad9ef6ab942f889',
                    			'offer'=>'roffer',
                    			'tel'=>$number,
                    			'operator'=>$opcode
                    		);
                         	$response=Helper::_curl_execute('GET',$url,$params);
							$response=str_replace("\xEF\xBB\xBF",'',$response); 
                         	$json=json_decode($response,true);
                         	$details = DB::select("CALL billpay_report(2,'".$number."','','','','1970-01-01','1970-01-01',5,1,'$cond',@msg)");

                                if($json['records'][0]['status']==1)
                                {
                                     		return response()->json([
                                							'ERROR'=>'SUCCESS',
                                							'MSG' =>"BILL DATA" ,
                                							'STATUS'=>trim($json['records'][0]['status']),
                                							'ACCOUNT'=>trim($json['tel']),
                                							'NUMBER'=>trim($json['records'][0]['CustomerName']),
                                							'BILLNO'=>trim($json['records'][0]['BillNumber']),
                                							'BILL_AMOUNT'=>triM($json['records'][0]['Billamount']),
                                							'DUEDATE'=>trim($json['records'][0]['Duedate']),
															'LAST5TRANSACTION'=> $details,
                                							]);
                                }
                                else
                                {
                                    	return response()->json([
                                							'ERROR'=>'SUCCESS',
                                							'MSG' =>"BILL DATA" ,
                                							'STATUS'=>trim($json['records'][0]['status']),
                                							'ACCOUNT'=>trim($json['tel']),
                                							'DESC'=>trim($json['records'][0]['desc']),
															'LAST5TRANSACTION'=> $details,
                                							]);
                                    
                                }
						}
						else
						{	
							$ERRMSG = $DB_ERRMSG[0]->ERR_MSG;
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';	
							return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
						}
					}
					else
					{
					return response()->json([
							'ERROR'=>$ERRCODE,
							'MSG' =>$ERRMSG 
							]);
					}
				
			}
			else
			{
				$ERRMSG = "REQUEST IS NOT VALID";
				$ERRCODE="error";
				return response()->json([
				'ERROR'=>$ERRCODE,
				'MSG' =>$ERRMSG 
				]);

			}
			
		}


		/**
			* Method name   : user recharge report
			* @description  : Used for getting recharge report
			* @param        : Request data 
			* @return       : return with user recharge report
    	*/
		public function user_rechargereport()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'ALL RECHARGE REPORT HERE';
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$request = request();
			$descrip="";
			$start = date('Y-m-d',strtotime(NOW()));
			$end = date('Y-m-d',strtotime(NOW()));
			$txt_account = '';
			$txt_memberid = Session::get('USER_ID');
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="";
			$cond1="1";
			$dd_operator ='-1';

            if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
				$end = date('Y-m-d',strtotime($request->input('txt_todate')));
				$dd_operator = $request->input('dd_operator');
				$dd_status = $request->input('dd_status');
				
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
				{
					$txt_transid=$request->input('txt_transid');
				}
				if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
					$txt_memberid=$request->input('txt_memberid');
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
				{
					$dd_status=$request->input('dd_status');
				}
				if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
				{
					$cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
				}
				
			}
			$cond=$cond.$cond1;
			$recereport=array
			(
			'proc'=>2,
			'account'=>$txt_account,
			'transid'=>$txt_transid,
			'userid'=>$txt_memberid,
			'fromdate'=>$start,
			'todate'=>$end,
			'noofrecords'=>$txt_noofrecords,
			'recstatus'=>$dd_status,
			'descrip'=>$cond
			);

			$rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
  			$hit_data=array(
				'proc'=>3,
				'user_id'=>$txt_memberid,
				'rec_fromdate'=>$start,
				'rec_todate'=>$end
            );

		    $today_hit = $this->rech_reprt_repo->todayHitStatus($hit_data);
			$OPERATOR = Helper::get_operator(-2,'ACTIVE');
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			return view('User.recharge_report', compact('rec_report','user','OPERATOR','today_hit','user','start','end','dd_operator','txt_account','txt_transid','dd_status'));
		}

		/**
			* Method name   : user refund report
			* @description  : Used for getting refund report
			* @param        : Request data 
			* @return       : return with user refund report
    	*/
		public function user_refundereport()
		{
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$request = request();
			$descrip="";
			$start = date('Y-m-d',strtotime(NOW()));
			$end = date('Y-m-d',strtotime(NOW()));
			$txt_account = '';
			$txt_memberid = Session::get('CONTACTNO');
			$txt_memberids='';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='3';
			$dd_operator = '-1';
			$cond="1 ";
			$cond1=" ";
            if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
				$end = date('Y-m-d',strtotime($request->input('txt_todate')));
				$dd_operator = $request->input('dd_operator');
				$dd_status = $request->input('dd_status');
				$txt_memberids=$request->input('txt_memberid');
				
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
					$cond = $cond." AND ACCOUNT=".$txt_account;
				}
				if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
					$txt_memberid=$request->input('txt_memberid');
				}
				if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
				{
					$cond = $cond." AND REFUNDSTATUS=".$request->input('dd_status');
				}
				if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
				{
					$cond = $cond." AND OPERATORID=".$request->input('dd_operator');
				}
				$cond=$cond.$cond1;
			}
			$refund_report = DB::select("SELECT * FROM refund_report WHERE ".$cond." AND MEMBERID=".Session::get('CONTACTNO')." ORDER BY REFUND_ID DESC");
			$OPERATOR = Helper::get_operator(-2,'ACTIVE');
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			Session::flash('type','info' );
			Session::flash('message',"Recharge Report Fetch Succesfully");
			return view('User.refund_report', compact('refund_report','user','OPERATOR','start','end','dd_operator','txt_account','txt_transid','dd_status','txt_memberids','txt_noofrecords'));
		}


		/**
			* Method name   : user operator wise
			* @description  : Used for getting operator wise
			* @param        : Request data 
			* @return       : return with user operator wise
    	*/
		public function user_operatorwise()
		{
		
		    $request = request();
			$user = Helper::get_userdetail(Session::get('USER_ID'));
	        $descrip="";
	        $start = date('Y-m-d',strtotime(NOW()));
			$end = date('Y-m-d',strtotime(NOW()));
	        $txt_account = '';
	        $txt_memberid =  Session::get('USER_ID');
	        $txt_transid = '';
	        $txt_noofrecords = '100';
	        $dd_status='2';
			$dd_operator ='-1';
	        $cond="";
	        $cond1="`m07_service_id` IN(1,2) AND 1";
	        if($_SERVER['REQUEST_METHOD']=="POST")
	        {
	            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
	            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
				$dd_operator =  $request->input('dd_operator');
	            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
	            {
	              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
	            }
	            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
	            {
	              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
	            }
	          
	        }
	        $cond=$cond.$cond1;
	        $recereport=array
	        (
	         'proc'=>1,
	          'userid'=>$txt_memberid,
	          'fromdate'=>$start,
	          'todate'=>$end,
	          'descrip'=>$cond
	        );
           	$rec_report = $this->rech_reprt_repo->dailyOperatorSales($recereport);
			$ERRMSG=DB::select('SELECT @msg as ERR_MSG');
			$OPERATOR = Helper::get_operator(-2,'ACTIVE');
    	    return view('User.operator_wise', compact( 'user','rec_report','OPERATOR','start','end','dd_operator'));
		}

		/**
        * Method name   : Date wise
        * @description  : Used for date wise recharge report
        * @param        : Request data  
        * @return       : return date wise recharge report
		*/
		public function date_wise()
		{
			$request = request();
			$descrip="";
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$start = '1970-01-01';
			$end ='1970-01-01';
			$txt_account = '';
			$txt_memberid = Session::get('USER_ID');
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='2';
			$cond="";
			$cond1="`m07_service_id` IN(1,2,3) AND 1";
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
				$end = date('Y-m-d',strtotime($request->input('txt_todate')));
			}
			$recereport=array
			(
			  'proc'=>8,
			  'user_id'=>$txt_memberid,
			  'rec_fromdate'=>$start,
			  'rec_todate'=>$end
			);
			$rec_report = $this->rech_reprt_repo->apiWiseSales($recereport);
			return view('User.date_wise', compact('rec_report','user'));
		}

		/**
			* Method name   : user dmt report
			* @description  : Used for getting dmt report
			* @param        : Request data 
			* @return       : return with user dmt report
    	*/
		public function user_dmtreport()
		{
			$request = request();
			Session::flash('type','info' );
			Session::flash('message','ALL MONEY TRANSFER REPORT HERE' );
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			
			$descrip="";
			$start = date('Y-m-d',strtotime(NOW()));
			$end = date('Y-m-d',strtotime(NOW()));

			$txt_account = '';
			$txt_memberid = Session::get('USER_ID');
			$txt_memberids ='';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="";
			$cond1="1";

            if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
				$end = date('Y-m-d',strtotime($request->input('txt_todate')));
				$dd_status = $request->input('dd_status');
				$txt_memberids =$request->input('txt_memberid');
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
					$txt_memberid=$request->input('txt_memberid');
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
				{
					$dd_status=$request->input('dd_status');
				}
				
			}
			$cond=$cond.$cond1;
			$dmtreport=array
			(
			'proc'=>1,
			'account'=>$txt_account,
			'transid'=>$txt_transid,
			'userid'=>$txt_memberid,
			'fromdate'=>$start,
			'todate'=>$end,
			'noofrecords'=>$txt_noofrecords,
			'recstatus'=>$dd_status,
			'descrip'=>$cond
			);

			$dmt_report = $this->dmt_reprt_repo->dmrReport($dmtreport);
			//$dmt_report ="";
			$hit_dmtdata=array('proc'=>6,'user_id'=>$txt_memberid,'rec_fromdate'=>$start,'rec_todate'=>$end);
			$today_dmthit = $this->dmt_reprt_repo->dmrtodayHitStatus($hit_dmtdata);
			return view('User.dmt_report', compact('dmt_report','user','today_dmthit','start','end','txt_account','dd_status','txt_memberids','txt_noofrecords'));
		}

		/**
        * Method name   : Refund Money Transfer Report
        * @description  : Used for refund money transfer report 
        * @param        : Request data  
        * @return       : return refund money transfer report
		*/
		public function refund_mtransfer_report()
		{
			$request = request();
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$descrip="";
			$start = date('Y-m-d',strtotime(NOW()));
			$end = date('Y-m-d',strtotime(NOW()));
			$txt_account = '';
			$txt_memberids ='';
			$txt_memberid = Session::get('USER_ID');
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='2';
			$cond="";
			$cond1="`m07_service_id` IN(1,2,3) AND 1";
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
				$end = date('Y-m-d',strtotime($request->input('txt_todate')));
				$txt_memberids = $request->input('txt_memberid');

				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
				  $txt_account=$request->input('txt_account');
				}
				if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
				  $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
				  $txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
				{
				  $dd_status=$request->input('dd_status');
				}

			}
			$cond=$cond.$cond1;
			$recereport=array
			(
			 'proc'=>2,
			  'account'=>$txt_account,
			  'transid'=>$txt_transid,
			  'userid'=>$txt_memberid,
			  'fromdate'=>$start,
			  'todate'=>$end,
			  'noofrecords'=>$txt_noofrecords,
			  'recstatus'=>$dd_status,
			  'descrip'=>$cond
			);
			$rec_report = $this->dmt_reprt_repo->dmrReport($recereport);
			$OPERATOR = Helper::get_operator(-2,'ACTIVE');
			Session::flash('message',"Refund Recharge Report Fetch Succesfully");
			return view('User.refund_moneytransfer_report', compact('rec_report','OPERATOR','user','start','end','txt_account','dd_status','txt_memberids','txt_noofrecords'));
		}

		/**
        * Method name   : Date wise
        * @description  : Used for date wise money transfer report
        * @param        : Request data  
        * @return       : return date wise money transfer report
		*/
		public function date_wise_mtransfer()
		{
			$request = request();
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$descrip="";
			$start = date('Y-m-d',strtotime(NOW()));
			$end = date('Y-m-d',strtotime(NOW()));
			$txt_account = '';
			$txt_memberid = '';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='2';
			$cond="";
			$cond1="`m07_service_id` IN(1,2,3) AND 1";
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
				$end = date('Y-m-d',strtotime($request->input('txt_todate')));
			}
			$cond=$cond.$cond1;
			$recereport=array
			(
			 'proc'=>2,
			  'account'=>$txt_account,
			  'transid'=>$txt_transid,
			  'userid'=>$txt_memberid,
			  'fromdate'=>$start,
			  'todate'=>$end,
			  'noofrecords'=>$txt_noofrecords,
			  'recstatus'=>$dd_status,
			  'descrip'=>$cond
			);
			$rec_report = $this->dmt_reprt_repo->dmrReport($recereport);
			$OPERATOR = Helper::get_operator(-2,'ACTIVE');
			Session::flash('message',"Recharge Report Fetch Succesfully");
			return view('User.date_moneytransfer_wise', compact('rec_report','OPERATOR','user','start','end'));
		}

		/**
			* Method name   : user aeps report
			* @description  : Used for getting aeps report
			* @param        : Request data 
			* @return       : return with user aeps report
    	*/
		public function user_aepsreport()
		{
			$request = request();
			Session::flash('type','info' );
			Session::flash('message','ALL AEPS WITHDRWAN  REPORT HERE' );
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			
			$descrip="";
			$start = date('Y-m-d',strtotime(NOW()));
			$end = date('Y-m-d',strtotime(NOW()));
			$txt_account = '';
			$txt_memberid = Session::get('USER_ID');
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="";
			$cond1="1";
            if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_from')));
				$end = date('Y-m-d',strtotime($request->input('txt_to')));
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
					$txt_memberid=$request->input('txt_memberid');
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
				{
					$dd_status=$request->input('dd_status');
				}
			}
			$cond=$cond.$cond1;
			$aepsreport=array
			(
			'proc'=>1,
			'account'=>$txt_account,
			'transid'=>$txt_transid,
			'userid'=>$txt_memberid,
			'fromdate'=>$start,
			'todate'=>$end,
			'noofrecords'=>$txt_noofrecords,
			'recstatus'=>$dd_status,
			'descrip'=>$cond
			);
			
			$aeps_report = $this->aeps_reprt_repo->aepsReport($aepsreport);
//dd($aepsreport,$aeps_report);
			$hit_data=array(
				'proc'=>7,
				'user_id'=>-1,
				'rec_fromdate'=>$start,
				'rec_todate'=>$end
            );
			$today_hit = $this->rech_reprt_repo->todayHitStatus($hit_data);
			return view('User.aeps_report', compact('aeps_report','user','today_hit'));
		}

		/**
	        * Method name   : Refund AEPS Report
	        * @description  : Used for refund AEPS report 
	        * @param        : Request data  
	        * @return       : return refund AEPS report
	    */
	    public function refund_apestransfer_report()
	    {
	        $request = request();
	        $user = Helper::get_userdetail(Session::get('USER_ID'));
	        $descrip="";
	        $start = date('Y-m-d',strtotime(NOW()));
			$end = date('Y-m-d',strtotime(NOW()));
	        $txt_account = '';
	        $txt_memberid = Session::get('CONTACTNO');
	        $txt_transid = '';
	        $txt_noofrecords = '100';
	        $dd_status='2';
	        $cond="";
	        $cond1="`m07_service_id` IN(1,2,3) AND 1";
	        if($_SERVER['REQUEST_METHOD']=="POST")
	        {
	            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
	            $end = date('Y-m-d',strtotime($request->input('txt_todate')));

	            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
	            {
	              $txt_account=$request->input('txt_account');
	            }
	            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
	            {
	              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
	            }
	            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
	            {
	              $txt_noofrecords =$request->input('txt_noofrecords');
	            }
	            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
	            {
	              $dd_status=$request->input('dd_status');
	            }

	        }
	        $cond=$cond.$cond1;
	        $recereport=array
	        (
	         'proc'=>2,
	          'account'=>$txt_account,
	          'transid'=>$txt_transid,
	          'userid'=>$txt_memberid,
	          'fromdate'=>$start,
	          'todate'=>$end,
	          'noofrecords'=>$txt_noofrecords,
	          'recstatus'=>$dd_status,
	          'descrip'=>$cond
	        );
	        $rec_report = $this->aeps_reprt_repo->aepsReport($recereport);
	        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
	        Session::flash('message',"Refund Recharge Report Fetch Succesfully");
	        return view('User.refund_aeps_report', compact('rec_report','OPERATOR','user'));
	    }

		/**
	        * Method name   : Date wise
	        * @description  : Used for date wise money transfer report
	        * @param        : Request data  
	        * @return       : return date wise money transfer report
	    */
	    public function date_wise_apestransfer()
	    {
	        $request = request();
	        $user = Helper::get_userdetail(Session::get('USER_ID'));
	        $descrip="";
	        $start = date('Y-m-d',strtotime(NOW()));
			$end = date('Y-m-d',strtotime(NOW()));
	        $txt_account = '';
	        $txt_memberid = Session::get('CONTACTNO');
	        $txt_transid = '';
	        $txt_noofrecords = '100';
	        $dd_status='2';
	        $cond="";
	        $cond1="`m07_service_id` IN(1,2,3) AND 1";
	        if($_SERVER['REQUEST_METHOD']=="POST")
	        {
	            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
	            $end = date('Y-m-d',strtotime($request->input('txt_todate')));

	        }
	        $cond=$cond.$cond1;
	        $recereport=array
	        (
	         'proc'=>2,
	          'account'=>$txt_account,
	          'transid'=>$txt_transid,
	          'userid'=>$txt_memberid,
	          'fromdate'=>$start,
	          'todate'=>$end,
	          'noofrecords'=>$txt_noofrecords,
	          'recstatus'=>$dd_status,
	          'descrip'=>$cond
	        );
	        $rec_report = $this->aeps_reprt_repo->aepsReport($recereport);
	        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
	        Session::flash('message',"Recharge Report Fetch Succesfully");
	        return view('User.date_wise_aeps', compact('rec_report','OPERATOR','user'));
	    }

		/**
			* Method name   : user account statement
			* @description  : Used for getting account statement
			* @param        : Request data 
			* @return       : return with user account statement
    	*/
		public function user_account_statement()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'ACCOUNT STATEMENT';
			$request = request();
			Session::flash('type','info' );
			Session::flash('message','ALL ACCOUNT STATEMENT HERE' );
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$descrip="";
			$start = date('Y-m-d',strtotime(NOW()));
			$end = date('Y-m-d',strtotime(NOW()));
			$txt_account = '';
			$txt_memberid = Session::get('USER_ID');
			$txt_transid = '';
			$txt_memberids = '';
			$txt_noofrecords = '100';
			$dd_ledgertype='-1';
			$cond="";
			$cond1="1";
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
				$end = date('Y-m-d',strtotime($request->input('txt_todate')));
				$txt_memberids = $request->input('txt_memberid');
				$dd_ledgertype = $request->input('dd_ledgertype');
				
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
				{
					$txt_transid=$request->input('txt_transid');
				}
				if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
					$txt_memberid = Helper::get_userid($request->input('txt_memberid'));
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_ledgertype')!="" && $request->input('dd_ledgertype')!=-1)
				{
					$dd_ledgertype=$request->input('dd_ledgertype');
				}
				
			}
			$cond=$cond.$cond1;
			$ledgerreport=array(
			'proc'=>2,
			'account'=>"",
			'transid'=>$txt_transid,
			'userid'=>$txt_memberid,
			'fromdate'=>$start,
			'todate'=>$end,
			'noofrecords'=>$txt_noofrecords,
			'ledegerstatus'=>$dd_ledgertype,
			'descrip'=>$cond
            );
			$ledger_report = $this->fund_repo->ledgerReport($ledgerreport);
			return view('User.ledger', compact('ledger_report','page','user','form_name','start','end','txt_transid','dd_ledgertype','txt_memberids','txt_noofrecords'));
		}

		/**
			* Method name   : user credit statement
			* @description  : Used for getting credit statement
			* @param        : Request data 
			* @return       : return with user credit statement
    	*/
		public function user_credit_statement()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'ACCOUNT CREDIT STATEMENT';
			$request = request();
			Session::flash('type','info' );
			Session::flash('message','ALL ACCOUNT CREDIT STATEMENT HERE' );
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$descrip="";
			$start = date('Y-m-d',strtotime(NOW()));
			$end = date('Y-m-d',strtotime(NOW()));
			$txt_account = '';
			$txt_memberid = Session::get('USER_ID');
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_ledgertype='1';
			$cond="";
			$cond1="1";
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
				$end = date('Y-m-d',strtotime($request->input('txt_todate')));
				
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
				{
					$txt_transid=$request->input('txt_transid');
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_ledgertype')!="" && $request->input('dd_ledgertype')!=-1)
				{
					$dd_ledgertype=$request->input('dd_ledgertype');
				}
				
			}
			$cond=$cond.$cond1;
			$ledgerreport=array(
			'proc'=>2,
			'account'=>"",
			'transid'=>$txt_transid,
			'userid'=>$txt_memberid,
			'fromdate'=>$start,
			'todate'=>$end,
			'noofrecords'=>$txt_noofrecords,
			'ledegerstatus'=>$dd_ledgertype,
			'descrip'=>$cond
            );
            $ledger_report = $this->fund_repo->ledgerReport($ledgerreport);
			return view('User.payment_summary', compact('ledger_report','page', 'user','form_name','start','end','txt_transid','dd_ledgertype','txt_noofrecords'));
		}

		/**
			* Method name   : money transfer
			* @description  : Used for dmt login
			* @param        : Request data 
			* @return       : return with dmt login
    	*/
		public function money_transfer()
		{
			$request = request();
			Session::forget('MOBILENO');
			$get_useralldetail = "";
			$dmt_user = "";
			if($_SERVER['REQUEST_METHOD']=="GET")
			{
			$ERRCODE='info';
			$ERRMSG='FETCH USER DMR ACCOUNT DETAILS' ;
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$get_useralldetail = "";
			}
			Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
			//Check Service On Or not 
			$UserService = DB::select("SELECT * FROM `user_services` WHERE `USER_ID`=".Session()->get('USER_ID')." AND `MS_SERVICE_NAME`='DMT' AND `MS_STATUS`='Active' ");
			if($UserService){ $UserService='ON'; }
			else{ $UserService='OFF';  }
			return view('User.user_dmtlogin',compact('dmt_user','get_useralldetail','user','UserService'));
		}



		/**
			* Method name   : user dmt register
			* @description  : Used for user dmt register
			* @param        : Request data 
			* @return       : return with dmt register
    	*/
		public function user_dmtregister()
		{
			$request = request();
			$user = Helper::get_userdetail(Session::get('USER_ID'));
	    	
			$get_useralldetail = "";
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$this->validate($request, [
			'txt_mobileno'=> 'required|numeric|digits:10|regex:/^[5-9]\d{9}$/' 	
			],[
				'txt_mobileno.required'=> 'Mobile Number is required',
				'txt_mobileno.numeric'=> 'Enter a valid Mobile Number',
				'txt_mobileno.digits'=> 'Enter 10 digit Mobile Number',
				'txt_mobileno.regex'=> 'Mobile no start from 5-9'
			]);
				$pass=rand(100000,999999);
				$pinpass=rand(100000,999999);
				$signup_data=array(
					'proc'=>1,
					'm57_remitter_id'=>0,
					'm57_remitter_code'=>'',
					'm22_affiliate_id'=>Session::get('AFFILIATE_CODE'),
					'm57_first_name'=> $request->input('txt_firstname'),
					'm57_last_name'=> $request->input('txt_lastname'),
					'm57_remitter_name'=> $request->input('txt_firstname').' '.$request->input('txt_lastname'),
					'm57_remitter_dob'=>date('Y-m-d',strtotime($request->input('txt_memberdob'))),
					'm57_remitter_gender'=> 1,
					'm57_remitter_email'=>'',
					'm57_remitter_contactno'=> $request->input('txt_mobileno'),
					'm57_remitter_location'=> $request->input('txt_address').' PINCODE-'.$request->input('txt_pincode'),
					'm57_remitter_state'=> '',
					'm57_remitter_city'=> '',
					'm57_remitter_postalcode'=> '',
					'm57_remitter_status'=>1,
					'm57_remitter_islogin'=> 2,
					'm57_remitter_referral_code'=>Session::get('USER_ID')
				);
				
				$response= $this->dmt_proc_repo->create($signup_data); 

				if($response['err_code']=="success")
				{
	                $this->send_sms($request->input('txt_mobileno'),$response['err_msg']);
				}

				Session::flash( 'message', $response['err_msg'] );
				Session::flash( 'type', $response['err_code'] );

			}
			return view('User.user_dmtregister',compact('user','get_useralldetail'));
		}

		/**
			* Method name   : user dmt login
			* @description  : Used for user dmt login
			* @param        : Request data 
			* @return       : return with dmt login
    	*/
		public function user_dmtlogin()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'USER DMT LOGIN VIEW';
			$request = request();
			$get_useralldetail = "";$dmt_user = "";
			$ERRMSG = "SEARCH AND VIEW USER DMT DETAILS";
			$ERRCODE="info";
			if($request->method() == 'POST')
			{
			if($request->input('txt_memberid')=='')
			{
			$ERRMSG = "Member contact number should be valid or not blank.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else if(strlen($request->input('txt_memberid'))<10)
			{
			$ERRMSG = "Member contact number should be sequal to 10 digit.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else if(strlen($request->input('txt_memberid'))>10)
			{
			$ERRMSG = "Member contact number should be equal to 10 digit.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else
			{
			$ERRMSG = "";
			$this->isError=FALSE;
			$ERRCODE="success";
			}

				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
				 $userid = Helper::get_dmtuser_by_mobile($request->input('txt_memberid'));
            
					if($userid)
					{
					Session::put('MOBILENO',$request->input('txt_memberid'));
					$dmt_user = Helper::get_dmtuserdetail($userid);
					$get_useralldetail = Helper::get_user_bene_detail($userid);
					$ERRMSG = "USER DMT DETAILS";
					}
					else
					{
					$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no OR Register With us.";
					$this->isError=TRUE;
					$ERRCODE="warning";
					Session::flash('type',$ERRCODE);
					Session::flash('message',$ERRMSG);
					Session::flash('MOBILENO',$request->input('txt_memberid'));
					return redirect('user_dmtregister');
					}
						Session::flash('type',$ERRCODE );
						Session::flash('message',$ERRMSG);
						Session::flash('dmtdash_type',$ERRCODE );
						Session::flash('dmtdash_message',$ERRMSG );
						Session::flash('benelist_type',"info" );
						Session::flash('benelist_message',"BENEFICIARY LIST HERE" );
						Session::flash('addbene_type',"info" );
						Session::flash('addbene_message',"BENEFICIARY ADD HERE" );
						Session::flash('transtobene_type',"info" );
						Session::flash('transtobene_message',"TRANSFER TO BENEFICIARY DETAILS HERE" );
		     	}
				else
				{
				Session::flash('type',$ERRCODE);
				Session::flash('message',$ERRMSG);

				}
			}
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			return view('User.user_dmtlogin',compact('form_name','user','dmt_user','get_useralldetail'));
		}
		
		/**
			* Method name   : user dmt dashboard
			* @description  : Used for user dmt dashboard
			* @param        : Request data 
			* @return       : return with dmt dashboard
    	*/
		public function user_dmtdashboard()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'DMR ACCOUNT DETAILS';
			$request = request();
			$get_useralldetail = "";$dmt_user = "";
			if($_SERVER['REQUEST_METHOD']=="GET")
			{
			$ERRCODE='info';
			$ERRMSG='FETCH USRE DMR ACCOUNT DETAILS' ;
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$userid = Helper::get_userid(Session::get('MOBILENO'));
			if($userid!=FALSE)
			{
			$dmt_user = Helper::get_dmtuserdetail($userid);
			$get_useralldetail = Helper::get_user_bene_detail($userid);
			//$ERRMSG = "USER DMT DETAILS";
			}
			}
			$bank = DB::select('SELECT * FROM bank where BANK_STATUS=1');
			Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
			return view('User.user_dmtlogin',compact('form_name','user','dmt_user','bank','get_useralldetail'));
		}

				/**
			* Method name   : user dmt beneficiary list
			* @description  : Used for user dmt beneficiary list
			* @param        : Request data 
			* @return       : return with dmt beneficiary list
    	*/
		public function user_dmtbeneficiary_list()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'DMR ACCOUNT DETAILS';
			$request = request();
			$get_useralldetail = "";$dmt_user = "";
			if($_SERVER['REQUEST_METHOD']=="GET")
			{
			$ERRCODE='info';
			$ERRMSG='FETCH USRE DMR ACCOUNT DETAILS' ;

			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$userid = Helper::get_dmtuser_by_mobile(Session::get('MOBILENO'));
			if($userid!=FALSE)
			{
			$dmt_user = Helper::get_dmtuserdetail($userid);
			$get_useralldetail = Helper::get_user_bene_detail($userid);
			}
			}
	
			Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
			//dd($get_useralldetail);
			return view('User.user_dmtlogin',compact('form_name','user','dmt_user','get_useralldetail'));
		}


		/**
			* Method name   : user dmt dashboard
			* @description  : Used for user dmt dashboard
			* @param        : Request data 
			* @return       : return with dmt dashboard
    	*/
		public function user_dmtbeneficiary()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'DMR ACCOUNT DETAILS';
			$request = request();
			$get_useralldetail = "";$dmt_user = "";
			if($_SERVER['REQUEST_METHOD']=="GET")
			{
			$ERRCODE='info';
			$ERRMSG='FETCH USRE DMR ACCOUNT DETAILS' ;
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$userid = Helper::get_dmtuser_by_mobile(Session::get('MOBILENO'));
			if($userid!=FALSE)
			{
			$dmt_user = Helper::get_dmtuserdetail($userid);
			$get_useralldetail = Helper::get_user_bene_detail($userid);
			}
			}
			$banks = $this->bank_repo->getAll();
			Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
			//dd($get_useralldetail);
			return view('User.user_dmtbeneficiary',compact('form_name','user','dmt_user','banks','get_useralldetail'));
		}

		/**
			* Method name   : user add beneficiary
			* @description  : Used for user add beneficiary
			* @param        : Request data 
			* @return       : return with add beneficiary
    	*/
		public function user_add_beneficiary()
		{

			$page = 'PROFILE PANEL';
			$form_name = 'USER ADD BENEFICIARY HERE';
			$request = request();
			//dd($request);
			$USER=$request->input('txt_userid');
			//dd($USER);
			$dmt_user = Helper::get_userdetail($USER);
			$get_useralldetail = Helper::get_user_bene_detail($USER);
			if($request->method() == 'POST')
			{
			if($request->input('txt_nameatbank')=='' )
			{
			$ERRMSG = "Member Name at Bank should be valid or not blank.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else if($request->input('dd_bank')=='' && $request->input('dd_bank')=='-1')
			{
			$ERRMSG = "Member Bank Name should be valid or not blank.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else if($request->input('txt_cbsacno')=='')
			{
			$ERRMSG = "Member Bank no Account should be valid or not blank.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else if($request->input('txt_bankifsccode')=='')
			{
			$ERRMSG = "Member Bank IFSCode should be valid or not blank.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else
			{
			$ERRMSG = "";
			$this->isError=FALSE;
			$ERRCODE="success";
			}
			if(request()->method() == 'POST' && $this->isError==FALSE)
			{
			$ACCOUNTNO=$request->input('txt_cbsacno');
			$bank_name= DB::select("SELECT GET_BANK_NAME(".$request->input('dd_bank').") AS BANK");
			//dd($bank_name);
			$arr = array(
				'm57_remitter_id'=>$USER,
				'm28_bene_nameat_bank'=>$request->input('txt_nameatbank'),
				'm28_bene_contactno'=>$request->input('txt_benemobileno'),
				'm28_bene_cbsacno' =>$request->input('txt_cbsacno'),
				'm01_bank_name'=> $request->input('dd_bank'),
				'm28_bene_branch'=>$request->input('txt_bankbranch'),
				'm28_bene_ifscode' =>$request->input('txt_bankifsccode'),
				'm28_bene_aadhar'=>$request->input('txt_beneaadhar'),
				'm28_bene_address'=>$request->input('txt_beneaddress'),
				'm28_bene_status'=>1
			);
			DB::table('m28_b2cuser_beneficiary')->insert($arr);
			$bank_actionrecord=DB::select("INSERT INTO tr11_actionrecord (tr11_ar_tblnm,tr11_ar_old_value,tr11_ar_new_value,tr11_ar_uid,tr11_ar_description) VALUES ('m57_remitter','','$ACCOUNTNO','$USER','USER S BENEFICIARY HAS BEEN ADDED SUCCESSFULLY!')");
			$ERRMSG="USER'S BENEFICIARY HAS BEEN ADD SUCCESSFULLY!";
			$ERRCODE='success';
			$dmt_user = Helper::get_userdetail($USER);
			$get_useralldetail = Helper::get_user_bene_detail($USER);
			Session::flash('addbene_type',$ERRCODE);
			Session::flash('addbene_message',$ERRMSG);
			}
			else
			{
			Session::flash('addbene_type',$ERRCODE );
			Session::flash('addbene_message',$ERRMSG);
			}
			}
			//DD($ERRMSG);
			return redirect()->to('user_dmtbeneficiary');
			//return view('User.user_dmtbeneficiary',compact('form_name','user','dmt_user','bank','get_useralldetail'));
		}

		/**
			* Method name   : sent otp bene
			* @description  : Used for sending otp beneficiary
			* @param        : Request data 
			* @return       : return with otp
    	*/
		public function sent_otpbene($for_bene)
		{
			$request = request();
			if(request()->method() == 'POST')
			{
				if(trim($request->input('txt_contactno')) == '')
				{
					$ERRMSG = "Mobile no should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else if(!$this->valid_phone_number($request->input('txt_contactno')))
				{
					$ERRMSG = "Mobile no should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `dmt_userdetails` WHERE `REM_CONTACT`='".$request->input('txt_contactno')."' AND REM_STATUS='ACTIVE'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
						$this->isError= FALSE;
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						$this->isError= TRUE;
					}
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$message=rand(1000,9999);
					$msg="Please submit this code ".$message." to verify your account.";
					$bene_id=$request->input('bene_id');
					$user_logindetails=DB::update("UPDATE `m28_b2cuser_beneficiary` SET `m28_bene_trasnfer_otp` =".$message." WHERE `m28_bene_id`=".$bene_id." ");
					if($user_logindetails==1)
					{
						// SMS SEND OR INSERT
						$sms_data['MOBILE_NO'] = Session()->get('CONTACTNO');
						$sms_data['SUBJECT'] = 'beneficiary verify your account';
						$sms_data['MESSAGE'] = $msg;
						$sms_data['TYPE'] = 13;
						$sms_data['SEND_BY'] = 2;
						$sms_data['SEND_BY_ID'] = Session()->get('USER_ID');
						Helper::send_sms_or_log($sms_data);
						//SMS SEND END 

						$ERRMSG = "Please check your Mobile No to verify OTP.";
						$ERRCODE = "success";
						return $user_logindetails;
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
					}
				}
			}
			else
			{
				$ERRMSG = "Invalid Method , Please try again..";
				$ERRCODE="error";
			}

		}


		/**
			* Method name   : sent otp user and member to add beneficiary 
			* @description  : Used for sending otp beneficiary
			* @param        : Request data 
			* @return       : return with otp
    	*/
		public function send_dmt_otp(request $request)
		{

				if(trim($request->mobileno) == '')
				{
					$ERRMSG = "beneficiary mobile no should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else if(trim($request->user_phone) == '')
				{
					$ERRMSG = "member mobile no should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else if(!$this->valid_phone_number($request->mobileno))
				{
					$ERRMSG = "beneficiary Mobile no should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
				}
				else if(!$this->valid_phone_number($request->user_phone))
				{
					$ERRMSG = "member Mobile no should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `enroll` WHERE `RegId`=".Session()->get('USER_ID')."");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
						$this->isError= FALSE;
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						$this->isError= TRUE;
					}
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					//$message=rand(100000,999999);
					$message="123456";
					$msg="Please submit this code ".$message." to verify your account.";
					$bene_id=$request->input('bene_id');
					$user_logindetails=DB::update("UPDATE `tr04_login` SET `tr04_otp` =".$message." WHERE `m11_user_id`=".Session()->get('USER_ID')." ");

					if($user_logindetails==1)
					{
						
						// SMS SEND OR INSERT
						$sms_data['MOBILE_NO'] = $request->mobileno;
						$sms_data['SUBJECT'] = 'add beneficiary for user';
						$sms_data['MESSAGE'] = $msg;
						$sms_data['TYPE'] = 13;
						$sms_data['SEND_BY'] = 2;
						$sms_data['SEND_BY_ID'] = Session()->get('USER_ID');
						Helper::send_sms_or_log($sms_data);
						//SMS SEND END 

						// SMS SEND OR INSERT
						$sms_data['MOBILE_NO'] = $request->user_phone;
						$sms_data['SUBJECT'] = 'add beneficiary for member';
						$sms_data['MESSAGE'] = $msg;
						$sms_data['TYPE'] = 13;
						$sms_data['SEND_BY'] = 2;
						$sms_data['SEND_BY_ID'] = Session()->get('USER_ID');
						Helper::send_sms_or_log($sms_data);
						//SMS SEND END 

						$ERRMSG = "Please check your Mobile No to verify OTP.";
						$ERRCODE = "success";
						return "Please check your Mobile No to verify OTP.";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return "error";;
					}
				}
		}



		/**
			* Method name   : verification dmt otp add beneficiary
			* @description  : Used for verification otp beneficiary
			* @param        : Request data 
			* @return       : return with otp
    	*/
		public function verification_dmt_otp(request $request)
		{

				if(trim($request->otp) == '')
				{
					$ERRMSG = "otp should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `tr04_login` WHERE `m11_user_id`=".Session()->get('USER_ID')."");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
						$this->isError= FALSE;
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						$this->isError= TRUE;
					}
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{

					if($login_detail[0]->tr04_otp == $request->otp)
					{
						$ERRMSG = "Please check your Mobile No to verify OTP.";
						$ERRCODE="success";
						return "success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return "error";;
					}
				}
		}

		/**
			* Method name   : user verify otp add beneficiary
			* @description  : Used for otp verification
			* @param        : Request data 
			* @return       : return with otp verification
    	*/
		public function user_verifyotp_add_beneficiary()
		{
			  
			$request = request();
			if(request()->method() == 'POST')
			{
				if(trim($request->input('txt_contactno')) == '')
				{
					$ERRMSG = "Mobile no should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else if(!$this->valid_phone_number($request->input('txt_contactno')))
				{
					$ERRMSG = "Mobile no should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					
				}
				else if($request->input('txt_otp')=='')
				{
					$ERRMSG = "OTP should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `enroll` WHERE `MemberContactNo`='".$request->input('txt_contactno')."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
						$this->isError= FALSE;
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						$this->isError= TRUE;
					}
					
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$bene_id=$request->input('txt_beneid');
					 $otp_detail = DB::select("SELECT `m28_bene_add_otp` as Token FROM `m28_b2cuser_beneficiary` WHERE `m28_bene_id` ='".$bene_id."'");
					
					if($otp_detail)
					{
						if($request->input('txt_otp')==$otp_detail[0]->Token)
						{
							
							$msg="Your account password has been verified successfully. Please send money with MobileNo :".$request->input('txt_contactno')." .";
							$user_logindetails=DB::update("UPDATE `m28_b2cuser_beneficiary` SET `m28_bene_status` = 1 WHERE `m28_bene_id`=".$bene_id." ");
								$ERRMSG = "Beneficiary Verified Successfully .Please send money with MobileNo.";
								$ERRCODE = "success";
						
						}
						else
						{
							$ERRMSG = "OTP NOT VALID.";
							$ERRCODE="error";
							$this->isError= TRUE;
					
						}
					}
					else
					{
							$ERRMSG = "OTP HAS NOT BEEN GENERATES FOR THIS USER.PLEASE TRY AGAIN";
							$ERRCODE="error";
							$this->isError= TRUE;
			
					}
					
				}
				
			}
			else 
			{	
				$ERRMSG = "Invalid Method , Please try again.";
				$ERRCODE="error";
			}
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$userid = Helper::get_userid($request->input('txt_contactno'));
			if($userid!=FALSE)
			{
				$dmt_user = Helper::get_userdetail($userid);
				$get_useralldetail = Helper::get_user_bene_detail($userid);
			}
			Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
			return view('User.user_dmtlogin',compact('form_name','user','dmt_user','get_useralldetail'));
		}

		/**
			* Method name   : delete beneficiary
			* @description  : Used for deleting beneficiary
			* @param        : Request data 
			* @return       : return with deleting beneficiary
    	*/
		public function deletebeneficiary($bene_id)
		{
					$page = 'PROFILE PANEL';
					$form_name = 'USER DELETE BENEFICIARY HERE';
					$request = request();
						   $user = Helper::get_userdetail(Session::get('USER_ID'));
						   $userid = Helper::get_userid(Session::get('MOBILENO'));
							if($userid!=FALSE)
							{
							$dmt_user = Helper::get_userdetail($userid);
							$get_useralldetail = Helper::get_beneficiary_detail($bene_id);
							}
					return view('User.user_deletebeneficiary',compact('form_name','user','dmt_user','get_useralldetail'));
		}
		
		/**
			* Method name   : sent otp delete bene
			* @description  : Used for sending otp delete bene
			* @param        : Request data 
			* @return       : return with otp
    	*/
        public function sent_otpdelete_bene()
        {
			$request = request();
			if(request()->method() == 'POST')
			{
						if(trim($request->input('txt_contactno')) == '')
						{
							$ERRMSG = "Mobile no should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else if(!$this->valid_phone_number($request->input('txt_contactno')))
						{
							$ERRMSG = "Mobile no should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
						}
						else
						{
							$login_detail = DB::select("SELECT * FROM `enroll` WHERE `MemberContactNo`='".$request->input('txt_contactno')."' AND MemberStatus='Active'");
							if($login_detail)
							{
								$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
								$ERRCODE="success";
								$this->isError= FALSE;
							}
							else
							{
								$ERRMSG = "USER DETAILS NOT FIND.";
								$ERRCODE="error";
								$this->isError= TRUE;
							}
						}
						if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
						{
							$message=rand(1000,9999);
							$msg="Please submit this code ".$message." to transfer this account.";
							$bene_id=$request->input('bene_id');
							$user_logindetails=DB::update("UPDATE `m28_b2cuser_beneficiary` SET `m28_bene_delete_otp` =".$message." WHERE `m28_bene_id`=".$bene_id." ");
							

							if($user_logindetails==1)
							{

								// SMS SEND OR INSERT
								$sms_data['MOBILE_NO'] = $request->input('txt_contactno');
								$sms_data['SUBJECT'] = 'delete beneficiary account';
								$sms_data['MESSAGE'] = $msg;
								$sms_data['TYPE'] = 14;
								$sms_data['SEND_BY'] = 2;
								$sms_data['SEND_BY_ID'] = Session()->get('USER_ID');
								Helper::send_sms_or_log($sms_data);
								//SMS SEND END 

								$ERRMSG = "Please check your  Mobile No to verify OTP.";
								$ERRCODE = "success";
							}
							else
							{
								$ERRMSG = "USER DETAILS NOT FIND.";
								$ERRCODE="error";
							}
						}
			}
			else 
			{	
				$ERRMSG = "Invalid Method , Please try again..";
				$ERRCODE="error";
			}
		}
		
		/**
			* Method name   : user verify otp delete beneficiary
			* @description  : Used for otp verification
			* @param        : Request data 
			* @return       : return with otp verification
    	*/
        public function user_verifyotp_delete_beneficiary()
        {
			  
				$request = request();

				if(request()->method() == 'POST')
				{
					if(trim($request->input('txt_benemobileno1')) == '')
					{
						$ERRMSG = "Mobile no should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						$userData ='';
					}
					else if(!$this->valid_phone_number($request->input('txt_benemobileno1')))
					{
						$ERRMSG = "Mobile no should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
						
					}
					else if($request->input('txt_otp1')=='')
					{
						$ERRMSG = "MPIN should be valid.";
						$this->isError= TRUE;
						$ERRCODE="error";
					}
					else
					{
						$login_detail = DB::select("SELECT * FROM `enroll` WHERE `MemberContactNo`='".$request->input('txt_benemobileno1')."' AND MemberStatus='Active'");
						if($login_detail)
						{
							$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
							$ERRCODE="success";
							$this->isError= FALSE;
						}
						else
						{
							$ERRMSG = "USER DETAILS NOT FIND.";
							$ERRCODE="error";
							$this->isError= TRUE;
						}
						
					}
				
					if($_SERVER['REQUEST_METHOD']=='POST' && $this->isError==FALSE)
					{
						$bene_id=$request->input('txt_beneid1');

						$otp_detail = DB::select("SELECT `tr04_pin_pwd` FROM `tr04_login` WHERE `m11_user_id` = ".Session()->get('USER_ID')." LIMIT 1");

						if($otp_detail)
						{
							if($request->input('txt_otp1')==$otp_detail[0]->tr04_pin_pwd)
							{
								$msg="Your account has been deleted successfully. Please add beeficiary with MobileNo :".$request->input('txt_benemobileno1')." .";
									$user_logindetails=DB::update("UPDATE `m28_b2cuser_beneficiary` SET `m28_bene_status` =3 WHERE `m28_bene_id`=".$bene_id." ");
									$ERRMSG = "Beneficiary Delete Successfully .Please add new beneficary.";
									$ERRCODE = "success";
							
							}
							else
							{
								$ERRMSG = "MPIN NOT VALID.";
								$ERRCODE="error";
								$this->isError= TRUE;
						
							}
						}
						else
						{
								$ERRMSG = "MPIN HAS NOT BEEN GENERATES FOR THIS USER.PLEASE TRY AGAIN";
								$ERRCODE="error";
								$this->isError= TRUE;
						}
					}	
				}
				else 
				{	
					$ERRMSG = "Invalid Method , Please try again.";
					$ERRCODE="error";
				}
			Session::flash('transbene_type',$ERRCODE );
			Session::flash('transbene_message',$ERRMSG);
			return redirect('user_dmtbeneficiary_list'); 
		}
		
		
		/**
			* Method name   : transfer 2 beneficiary
			* @description  : Used for transfer 2 beneficiary
			* @param        : Request data 
			* @return       : return with transfer 2 beneficiary
    	*/
		public function transfer2beneficiary($bene_id)
		{
			$page = 'PROFILE PANEL';
			$form_name = 'USER TRANSFER BENEFICIARY HERE';
			$request = request();
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$userid = Helper::get_userid(Session::get('MOBILENO'));
			$dmt_user = '';
			$get_useralldetail = '';
			if($userid!=FALSE)
			{
				$dmt_user = Helper::get_userdetail($userid);
				$get_useralldetail = Helper::get_beneficiary_detail($bene_id);
			}
			return view('User.user_transfertobeneficiary',compact('form_name','user','dmt_user','get_useralldetail'));
		}

		/**
			* Method name   : sent otp t2 bank
			* @description  : Used for sending otp to bank
			* @param        : Request data 
			* @return       : return with sent otp t2 bank
    	*/
		public function sent_otpt2bank()
		{
			$request = request();
			if(request()->method() == 'POST')
			{
						if(trim($request->input('txt_contactno')) == '')
						{
							$ERRMSG = "Mobile no should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
							$userData ='';
						}
						else if(!$this->valid_phone_number($request->input('txt_contactno')))
						{
							$ERRMSG = "Mobile no should be valid.";
							$this->isError= TRUE;
							$ERRCODE="error";
						}
						else
						{
							$login_detail = DB::select("SELECT * FROM `enroll` WHERE `MemberContactNo`='".$request->input('txt_contactno')."' AND MemberStatus='Active'");
							if($login_detail)
							{
								$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
								$ERRCODE="success";
								$this->isError= FALSE;
							}
							else
							{
								$ERRMSG = "USER DETAILS NOT FIND.";
								$ERRCODE="error";
								$this->isError= TRUE;
							}
						}
						if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
						{
							$message=rand(1000,9999);
							$msg="Please submit this code ".$message." to transfer this account.";
							$bene_id=$request->input('bene_id');
							$user_logindetails=DB::update("UPDATE `m28_b2cuser_beneficiary` SET `m28_bene_trasnfer_otp` =".$message." WHERE `m28_bene_id`=".$bene_id." ");
							

							if($user_logindetails==1)
							{
							
								// SMS SEND OR INSERT
								$sms_data['MOBILE_NO'] = $request->input('txt_contactno');
								$sms_data['SUBJECT'] = 'sent otp to bank';
								$sms_data['MESSAGE'] = $msg;
								$sms_data['TYPE'] = 14;
								$sms_data['SEND_BY'] = 2;
								$sms_data['SEND_BY_ID'] = Session()->get('USER_ID');
								Helper::send_sms_or_log($sms_data);
								//SMS SEND END 


								$ERRMSG = "Please check your  Mobile No to verify OTP.";
								$ERRCODE = "success";
							}
							else
							{
								$ERRMSG = "USER DETAILS NOT FIND.";
								$ERRCODE="error";
							}
						}
			}
			else 
			{	
				$ERRMSG = "Invalid Method , Please try again..";
				$ERRCODE="error";
			}
		}

		public function user_transtobene_bank()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'USER DELETE BENEFICIARY HERE';
			$request = request();
			if($request->method() == 'POST')
			{
				if($request->input('txt_contactno')=='' )
				{
					$ERRMSG = "Member/User should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_beneid')=='')
				{
					$ERRMSG = "Beneficiary ID should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_nameatbank')=='')
				{
					$ERRMSG = "Beneficiary Name at Bank should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_beneaccountno')=='')
				{
					$ERRMSG = "Beneficiary Account should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_bankifsccode')=='')
				{
					$ERRMSG = "Beneficiary IFSCode should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('rb_auth_type')=='')
				{
					$ERRMSG = "Transfer Authentication should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{	
					$bene_id=$request->input('txt_beneid');

					if($request->input('rb_auth_type')=='OTP')
					{
						if($request->input('txt_otp')=='')
						{
							$ERRMSG = "Transfer OTP should be valid or not blank.";
							$this->isError= TRUE;
							$ERRCODE="warning";
						}
						else
						{

							$otp_detail = DB::select("SELECT `m28_bene_trasnfer_otp` as Token FROM `m28_b2cuser_beneficiary` WHERE `m28_bene_id` ='".$bene_id."'");
							if($otp_detail)
							{
								if($request->input('txt_otp')==$otp_detail[0]->Token)
								{
									$user_logindetails=DB::update("UPDATE `m28_b2cuser_beneficiary` SET `m28_bene_trasnfer_otp` ='' WHERE `m28_bene_id`=".$bene_id." ");
									$ERRMSG = "";
									$this->isError=FALSE;
									$ERRCODE="success";
								}
								else
								{
									$ERRMSG = "OTP not match .";
									$this->isError= TRUE;
									$ERRCODE="warning";
								}
							}
							else
							{
								$ERRMSG = "User details not found.";
								$this->isError= TRUE;
								$ERRCODE="warning";
							}

						}
						
					}
					if($request->input('rb_auth_type')=='MPIN')
					{
						if($request->input('txt_mpin')=='')
						{
							$ERRMSG = "Transfer MPIN should be valid or not blank.";
							$this->isError= TRUE;
							$ERRCODE="warning";
						}
						else
						{

							$otp_detail = DB::select("SELECT `tr04_pin_pwd` FROM `tr04_login` WHERE `m11_user_id` = ".Session()->get('USER_ID')." LIMIT 1");

							if($otp_detail)
							{
								if($request->input('txt_mpin')==$otp_detail[0]->tr04_pin_pwd)
								{
									$ERRMSG = "";
									$this->isError=FALSE;
									$ERRCODE="success";
								}
								else
								{
									$ERRMSG = "MPIN not match .";
									$this->isError= TRUE;
									$ERRCODE="warning";
								}
							}
							else
							{
								$ERRMSG = "User details not found.";
								$this->isError= TRUE;
								$ERRCODE="warning";
							}
						}
					}
					else
					{
						$ERRMSG = "Transfer Authentication Not Found.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
				}

				if(request()->method() == 'POST'&& $this->isError==FALSE)
				{
					$ACCOUNTNO=$request->input('txt_beneaccountno');
					$BENEID=$request->input('txt_tbene_id');
					$user = Helper::get_userdetail(Session::get('USER_ID'));
					
				
					$dmr_req=array(
					'proc'=>'1',
					'm11_user_id'=>Session::get('USER_ID'),
					'trans_id'=>'',
					'refre_id'=>$BENEID,
					'request_no'=>'',
					'mobile_no'=>$request->input('txt_contactno'),
					'amount'=>$request->input('txt_transferamount'),
					'payment_id'=>'',
					'payment_status'=>'',
					'impsrefno'=>'',
					'message'=>'',
					'remarks'=>'',
					'account_number'=>$request->input('txt_beneaccountno'),
					'beneficiary_code'=>'',
					'beneficiary_name'=>$request->input('txt_nameatbank'),
					'account_type'=>'',
					'ifsc'=>$request->input('txt_bankifsccode'),
					'bank_name'=>'',
					'branch_name'=>'',
					'address'=>'',
					'state'=>'',
					'city'=>'',
					'agentid'=>'',
					'payctransid'=>'',
					'topup_charge'=>'0.00',
					'transfer_status'=>'2'
					);	
					$dmrreq_response=DB::select('CALL doremmitance(				
					:proc,
					:m11_user_id,
					:trans_id,
					:refre_id,
					:request_no,
					:mobile_no,
					:amount,
					:payment_id,
					:payment_status,
					:impsrefno,
					:message,
					:remarks,
					:account_number,
					:beneficiary_code,
					:beneficiary_name,
					:account_type,
					:ifsc,
					:bank_name,
					:branch_name,
					:address,
					:state,
					:city,
					:agentid,
					:payctransid,
					:topup_charge,
					:transfer_status,
					@msg,
					@msg2
					)',$dmr_req);
	
					$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
					$ERROR=$DB_ERROR[0]->ERROR;
					$MSG =$DB_ERRMSG[0]->ERR_MSG;
					if($ERROR=="success")
					{
						$token="Um5RcnRNYzl1SWNtMm53clY5N1hBUzZNZE11eXU0604f3a7690f4e"; 
						$url="http://103.149.165.64/llold/public/"; 
						$url=$url."api/v1/apitransferto_bank";
						$data=json_encode(array(
							 'beneficiaryname'=>$request->input('txt_nameatbank'),
							 'contactno'=>Session::get('CONTACTNO'),
							 'amount'=>round(floatval($request->input('txt_transferamount'))),
							 'beneficiaryAccount'=>$request->input('txt_beneaccountno'),
							 'beneficiaryIFSC'=>$request->input('txt_bankifsccode'),
							 'purpose'=>'PAYOUT',
							 'callbackUrl'=>'',
							 'agentid'=>$MSG
							 ));

						$header_data=array(
										         	  "Content-Type:application/json",
											          "Authorization:".$token.""
													);

						$method="POST";
						if($method=="POST")
						{
								$curl = curl_init();
								curl_setopt_array($curl, array
								(
								CURLOPT_URL => $url,
								CURLOPT_RETURNTRANSFER => true,
								CURLOPT_ENCODING => "",
								CURLOPT_MAXREDIRS => 10,
								CURLOPT_TIMEOUT => 30,
								CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
								CURLOPT_CUSTOMREQUEST => "POST",
								CURLOPT_POSTFIELDS =>$data,
								CURLOPT_HTTPHEADER =>$header_data
								));
								$result = curl_exec($curl);
								if(!$result)
								{
									$result=trigger_error(curl_error($curl));
									curl_close($curl);
									//print_r($result);
								}
								else
								{	                
									curl_close($curl);
									//print_r($result);
								}
						}
								$json = json_encode($result);
								$status1="PENDING";
								$status2=2;
							    $json=json_decode($result,true);
					}
					Session::flash('transbene_type',$ERROR );
					Session::flash('transbene_message',$MSG);
				}
				else
				{
					Session::flash('transbene_type',$ERRCODE );
					Session::flash('transbene_message',$ERRMSG);
				}
			}
			return redirect('user_dmtbeneficiary_list'); 
		}
	/**
        * Method name   : Cashback Bonus
        * @description  : Used for getting user cashback bonus
        * @param        : Request data 
        * @return       : return with user cashback bonus
    */
	public function cashbackbonus()
	{
		$request = request();
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txtuserid = '';
		$queery="";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$queery = $queery."DATE_FORMAT(`CASHBACK_PAYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
		}
		$txtuserid =Session::get('USER_ID');

		$queery = $queery."`USER_ID` = $txtuserid  AND ";
		$queery = $queery." CASHBACK_STATUS=2 ORDER BY CASHBACK_PAYDATE DESC LIMIT 1000";

		$salary_report = $this->closing_repo->getCashbackDates($queery);
		return view('User.user_cashback_bonus',compact('user','salary_report'));
	}
/**
        * Method name   : Cashback Bonus
        * @description  : Used for getting user cashback bonus
        * @param        : Request data 
        * @return       : return with user cashback bonus
    */
	public function cashback_lvl()
	{
		$request = request();
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txtuserid = '';
		$queery="";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$queery = $queery."DATE_FORMAT(`DIRECT_ENTRYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
		}
		$txtuserid =Session::get('USER_ID');

		$queery = $queery."`USER_ID` = $txtuserid  AND ";
		$queery = $queery." DIRECT_DESCRIP!='Level Income' AND DIRECT_DESCRIP!='COIN' AND DIRECT_LEVEL <>0  AND DIRECT_ISPUBLISH=1 ORDER BY DIRECT_ID DESC LIMIT 1000";

		$direct_report = $this->closing_repo->coinDetails($queery);
		return view('User.cashback_lvlbonus',compact('user','direct_report'));
	}
	/**
        * Method name   : Refferal Bonus
        * @description  : Used for getting user referral bonus
        * @param        : Request data 
        * @return       : return with user referral bonus
    */
	public function refferalbonus()
	{
			$request = request();
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		//$start = '1970-01-01';
		//$end ='1970-01-01';
		$start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$queery="";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$start = date('Y-m-d',strtotime($request->input('txt_from')));
			$end = date('Y-m-d',strtotime($request->input('txt_to')));
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$queery = $queery."DATE_FORMAT(`DIRECT_ENTRYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
		}
		$txtuserid =Session::get('USER_ID');
		$queery = $queery."`USER_ID` = $txtuserid  AND ";
		$queery = $queery." DIRECT_LEVEL=1 AND DIRECT_DESCRIP='Direct Income' AND DIRECT_ISPUBLISH=1";

		$direct_report = $this->closing_repo->directDetails($queery);
		return view('User.user_refferal_bonus',compact('user','direct_report'));
	}
	
	/**
        * Method name   : Level Bonus
        * @description  : Used for getting user level bonus
        * @param        : Request data 
        * @return       : return with user level bonus
    */
	public function coinbonus()
	{
		$request = request();
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$queery="";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$start = date('Y-m-d',strtotime($request->input('txt_from')));
			$end = date('Y-m-d',strtotime($request->input('txt_to')));
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$queery = $queery."DATE_FORMAT(`DIRECT_ENTRYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
		}
		$txtuserid =Session::get('USER_ID');
		$queery = $queery."`USER_ID` = $txtuserid  AND ";
		$queery = $queery." DIRECT_DESCRIP!='Direct Income' AND DIRECT_ISPUBLISH=1 ORDER BY DIRECT_ENTRYDATE DESC";
		//dd($queery );
		$direct_report = $this->closing_repo->coinDetails($queery);
		return view('User.user_coin_bonus',compact('user','direct_report'));
	}
	/**
        * Method name   : Level Bonus
        * @description  : Used for getting user level bonus
        * @param        : Request data 
        * @return       : return with user level bonus
    */
	public function levelbonus()
	{
		$request = request();
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$queery="";$lvl = 1;
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$start = date('Y-m-d',strtotime($request->input('txt_from')));
			$end = date('Y-m-d',strtotime($request->input('txt_to')));
			$lvl = $request->input('dd_level');
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$queery = $queery."DATE_FORMAT(`DIRECT_ENTRYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
			if ($lvl>0)
			{
				$queery = $queery." DIRECT_LEVEL=".$lvl." AND ";
			}
		}
		$txtuserid =Session::get('USER_ID');
		$queery = $queery."`USER_ID` = $txtuserid  AND ";
		$queery = $queery." DIRECT_DESCRIP='Level Income' AND DIRECT_ISPUBLISH=1 ORDER BY DIRECT_ENTRYDATE DESC";
		$direct_report = $this->closing_repo->directDetails($queery);
		return view('User.user_level_bonus',compact('user','direct_report'));
	}
	/**
        * Method name   : Level Bonus
        * @description  : Used for getting user level bonus
        * @param        : Request data 
        * @return       : return with user level bonus
    */
	public function gen_levelbonus()
	{
		$request = request();
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$lvl = 1;
		$queery="";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$start = date('Y-m-d',strtotime($request->input('txt_from')));
			$end = date('Y-m-d',strtotime($request->input('txt_to')));
			$lvl = $request->input('dd_level');
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$queery = $queery."DATE_FORMAT(`DIRECT_ENTRYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND ";
			}
			if ($lvl>0)
			{
				$queery = $queery." DIRECT_LEVEL=".$lvl." AND ";
			}
		}
		$txtuserid =Session::get('USER_ID');
		$queery = $queery."`USER_ID` = $txtuserid  AND ";
		$queery = $queery." DIRECT_DESCRIP='Generation Level Income' AND DIRECT_ISPUBLISH=1 ORDER BY DIRECT_ENTRYDATE DESC";
		$direct_report = $this->closing_repo->directDetails($queery);
		return view('User.user_genlevel_bonus',compact('user','direct_report'));
	}
	/**
        * Method name   : Matching Bonus
        * @description  : Used for getting user matching bonus
        * @param        : Request data 
        * @return       : return with user matching bonus
    */
	public function matchingbonus()
	{
		$request = request();
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$descrip="";
		//$start = '1970-01-01';
		//$end ='1970-01-01';
		$start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
		$txt_account = '';
		$txt_memberid = Session::get('USER_ID');
		$txt_transid = '';
		$txt_noofrecords = '1000';
		$dd_ledgertype='5';
		$cond="";
		$txt_memberid =Session::get('USER_ID');
		$cond = $cond."`tr26_closing_detail`.`m11_user_id` = $txt_memberid  AND ";
		$cond1=" `tr26_closing_detail`.`tr26_closing_ispublish`=2 ";
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
		    $start = date('Y-m-d',strtotime($request->input('txt_payoutdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_payoutdate')));

			if($request->input('txt_payoutdate')!=-1 && $start != '' && $start != '1970-01-01' )
			{
				$cond = $cond."DATE_FORMAT(`tr26_to_closing_date`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
			$cond=$cond.$cond1;
		}
		if($_SERVER['REQUEST_METHOD']=="GET")
        {
		$cond=$cond.$cond1;
		}
		
		$payoutreport=array(
		'queery'=>$cond
        );
		$payout_report=$this->closing_repo->payoutReport($payoutreport);
		$generated_report = DB::select("SELECT DISTINCT(tr26_to_closing_date)  AS tr26_to_closing_date FROM tr26_closing_detail WHERE 1 ORDER BY tr26_to_closing_date DESC ");
		return view('User.user_matching_bonus',compact('user','payout_report','generated_report'));
	}

	/**
        * Method name   : User Account Statement
        * @description  : Used for getting user account statement
        * @param        : Request data 
        * @return       : return with user account statement
    */
	public function user_accountstatement()
	{
		
		$request = request();
		Session::flash('type','info' );
		Session::flash('message','ALL ACCOUNT STATEMENT HERE' );
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$descrip="";
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txt_account = '';
		$txt_memberid = Session::get('USER_ID');
		$txt_transid = '';
		$txt_noofrecords = '100';
		$dd_ledgertype='-1';
		$cond="";
		$cond1=" `tr03_manage_ledger`.`tr03_bal_type`=1 ";
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
		    $start = date('Y-m-d',strtotime($request->input('txtfromdate')));
			$end = date('Y-m-d',strtotime($request->input('txttodate')));
			$cond=$cond.$cond1;
		}
		if($_SERVER['REQUEST_METHOD']=="GET")
        {
		$cond=$cond.$cond1;
		}
		$ledgerreport=array(
		'proc'=>2,
		'account'=>"",
		'transid'=>$txt_transid,
		'userid'=>$txt_memberid,
		'fromdate'=>$start,
		'todate'=>$end,
		'noofrecords'=>$txt_noofrecords,
		'ledegerstatus'=>$dd_ledgertype,
		'descrip'=>$cond
        );
		$ledger_report=$this->fund_repo->ledgerReport($ledgerreport);
		return view('User.user_fund_wallet_ledger', compact('ledger_report','user'));
	}

	/**
        * Method name   : User Cashback Ledger
        * @description  : Used for getting user cashback legfger
        * @param        : Request data 
        * @return       : return with user cashback ledger
    */
	public function user_cashback_ledger()
	{
		$request = request();
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$descrip="";
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txt_account = '';
		$txt_memberid = Session::get('USER_ID');
		$txt_transid = '';
		$txt_noofrecords = '1000';
		$dd_ledgertype='-4';
		$cond="";
		$cond1=" 1 AND `tr03_bal_type` IN(2,3) ";
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
		    $start = date('Y-m-d',strtotime($request->input('txt_from')));
			$end = date('Y-m-d',strtotime($request->input('txt_to')));
			if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
			{
				$txt_memberid = Helper::get_userid($request->input('txt_memberid'));
				$res=$this->scan_team($txt_memberid);
				if($res!='true')
				{
					$txt_memberid =Session::get('USER_ID');
				}
			}
			$cond=$cond.$cond1;
		}

		if($_SERVER['REQUEST_METHOD']=="GET")
        {
		$cond=$cond.$cond1;
		}
		$ledgerreport=array(
		'proc'=>2,
		'account'=>"",
		'transid'=>"",
		'userid'=>$txt_memberid,
		'fromdate'=>$start,
		'todate'=>$end,
		'noofrecords'=>$txt_noofrecords,
		'ledegerstatus'=>$dd_ledgertype,
		'descrip'=>$cond
        );

		$ledger_report=$this->fund_repo->ledgerReport($ledgerreport);
		
		return view('User.user_cashback_wallet_ledger', compact('ledger_report','user'));
	}

	/**
        * Method name   : User Promotional Ledger
        * @description  : Used for getting user promotional legfger
        * @param        : Request data 
        * @return       : return with user promotional ledger
    */
	public function user_promotional_ledger()
	{
		$request = request();
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$descrip="";
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txt_account = '';
		$txt_memberid = Session::get('USER_ID');
		$txt_transid = '';
		$txt_noofrecords = '1000';
		$dd_ledgertype='-6';
		$cond="";
		$cond1=" 1 AND `tr03_bal_type` IN (2,3) ";
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
		    $start = date('Y-m-d',strtotime($request->input('txt_from')));
			$end = date('Y-m-d',strtotime($request->input('txt_to')));
			if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
			{
				$txt_memberid = Helper::get_userid($request->input('txt_memberid'));
				$res=$this->scan_team($txt_memberid);
				if($res!='true')
				{
					$txt_memberid =Session::get('USER_ID');
				}
			}
			$cond=$cond.$cond1;
		}

		if($_SERVER['REQUEST_METHOD']=="GET")
        {
		$cond=$cond.$cond1;
		}
		$ledgerreport=array(
		'proc'=>2,
		'account'=>"",
		'transid'=>"",
		'userid'=>$txt_memberid,
		'fromdate'=>$start,
		'todate'=>$end,
		'noofrecords'=>$txt_noofrecords,
		'ledegerstatus'=>$dd_ledgertype,
		'descrip'=>$cond
        );

		$ledger_report=$this->fund_repo->ledgerReport($ledgerreport);
		
		return view('User.user_promotional_ledger', compact('ledger_report','user'));
	}


	/**
        * Method name   : User Payout Ledger
        * @description  : Used for getting user payout legfger
        * @param        : Request data 
        * @return       : return with user payout ledger
    */
	public function user_payout_ledger()
	{
		$request = request();
		
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$descrip="";
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txt_account = '';
		$txt_memberid = Session::get('USER_ID');
		$txt_transid = '';
		$txt_noofrecords = '100';
		$dd_ledgertype='-3';
		$cond="";
		$cond1=" 1 AND `tr03_bal_type` IN(2,3) ";
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
		    $start = date('Y-m-d',strtotime($request->input('txtfromdate')));
			$end = date('Y-m-d',strtotime($request->input('txttodate')));
			
			if($request->input('txtuserid')!="" && $request->input('txtuserid')!="0")
			{
				$txt_memberid = Helper::get_userid($request->input('txtuserid'));
				$res=$this->scan_team($txt_memberid);
				if($res!='true')
				{
					$txt_memberid =Session::get('USER_ID');
				}
			}
			$cond=$cond.$cond1;
		}
		if($_SERVER['REQUEST_METHOD']=="GET")
        {
		$cond=$cond.$cond1;
		}
		
		$ledgerreport=array(
		'proc'=>2,
		'account'=>"",
		'transid'=>$txt_transid,
		'userid'=>$txt_memberid,
		'fromdate'=>$start,
		'todate'=>$end,
		'noofrecords'=>$txt_noofrecords,
		'ledegerstatus'=>$dd_ledgertype,
		'descrip'=>$cond
        );
		$ledger_report=$this->fund_repo->ledgerReport($ledgerreport);
		return view('User.user_payout_wallet_ledger', compact('ledger_report','user'));
	}
	
	
	/**
        * Method name   : User Coin Ledger
        * @description  : Used for getting user Coin legfger
        * @param        : Request data 
        * @return       : return with user Coin ledger
    */
	public function user_coin_ledger()
	{
		$request = request();
		
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$descrip="";
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txt_account = '';
		$txt_memberid = Session::get('USER_ID');
		$txt_transid = '';
		$txt_noofrecords = '100';
		$dd_ledgertype='-1';
		$cond="";
		$cond1=" 1 AND `tr03_bal_type`IN (3,4) ";
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
		    $start = date('Y-m-d',strtotime($request->input('txtfromdate')));
			$end = date('Y-m-d',strtotime($request->input('txttodate')));
			
			if($request->input('txtuserid')!="" && $request->input('txtuserid')!="0")
			{
				$txt_memberid = Helper::get_userid($request->input('txtuserid'));
				$res=$this->scan_team($txt_memberid);
				if($res!='true')
				{
					$txt_memberid =Session::get('USER_ID');
				}
			}
			$cond=$cond.$cond1;
		}
		if($_SERVER['REQUEST_METHOD']=="GET")
        {
		$cond=$cond.$cond1;
		}
		
		$ledgerreport=array(
		'proc'=>2,
		'account'=>"",
		'transid'=>$txt_transid,
		'userid'=>$txt_memberid,
		'fromdate'=>$start,
		'todate'=>$end,
		'noofrecords'=>$txt_noofrecords,
		'ledegerstatus'=>$dd_ledgertype,
		'descrip'=>$cond
        );
		$ledger_report=$this->fund_repo->ledgerReport($ledgerreport);
		return view('User.user_coin_wallet_ledger', compact('ledger_report','user'));
	}

	/*--------------Scan Team-----------------*/

	/**
        * Method name   : Scan Team
        * @description  : Used for getting team
        * @param        : Request data 
        * @return       : return with team
    */

	public function scan_team($id)
	{
		$s=Session::get('USER_ID');
        $mem1 = $this->enroll_repo->getById($id);
        foreach($mem1 as $row1)
        {
			
            $intdid1=$row1->m11_user_parent_code;
            if( $intdid1 == $s )
            {
                return 'true';
			}
            else
            {
                $y=$this->scan_team($intdid1);
                if($y=="true")
                {
                    return "true";
				}
                else
                {
                    return "false";
				}
			}
		}
		
	}

	/**
        * Method name   : Plan
        * @description  : Used for getting plan
        * @param        : Request data 
        * @return       : return with plan pdf
    */
	public function plan()
    {
        $pathToFile = public_path('/pdf/ppt1.pdf');
        return response()->file($pathToFile);
    }

    /**
        * Method name   : Ppt
        * @description  : Used for getting ppt
        * @param        : Request data 
        * @return       : return with business ppt pdf
    */
    public function ppt()
    {
        $pathToFile = public_path('/pdf/ppt2.pdf');
        return response()->file($pathToFile);
    }

    /**
        * Method name   : User Tree View
        * @description  : Used for getting user tree view
        * @param        : Request data 
        * @return       : return with user tree view
    */
    public function usertreeview($id = '0')
	{
		if($_SERVER['REQUEST_METHOD']=="GET")
        {
			if($id=='0')
			$id=Session::get('USER_ID');
			$pid = $id;
            if($id != '')
			{
				$res=$this->scan_team($id);
				if($res=='true')
				{
					$s=1;
					$call_procedure = $this->team_repo->getUserAtLevel($id);
					$tr = $this->team_repo->getByUserId();
				}
				else
				{
					$s=Session::get('USER_ID');
					$call_procedure = $this->team_repo->getUserAtLevel($s);
					$tr = $this->team_repo->getByUserId();
				}
			}
		}
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
			$request = request();
			$id=Helper::get_userid($request->input('search_id'));
			$pid = $id;
			if( $id=='0')
			$id=Session::get('USER_ID');
			$pid = $id;
            if($id != '')
			{
				$res=$this->scan_team($id);
				
				if($res=='true')
				{
					$s=1;
					$call_procedure = $this->team_repo->getUserAtLevel($id);
					$tr = $this->team_repo->getByUserId();
				}
				else
				{
					$s=Session::get('USER_ID');
					$call_procedure = $this->team_repo->getUserAtLevel($s);
					$tr = $this->team_repo->getByUserId();
				}
				
			}
			
		}
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		//dd($user,$tr,$s,$pid);
		
		return view('User.user_tree_view',compact('user','tr', 's','pid') );
	}

	/**
        * Method name   : User team downline
        * @description  : Used for user team downline
        * @param        : Request data 
        * @return       : return with user team downline
    */
	public function userteamdownline()
	{
		$request = request();
		$topupst="ALL";
		$start =  date('Y-m-d',strtotime('2021-01-01'));
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';$role='-1';$pos='-1';
		if($_SERVER['REQUEST_METHOD']=="GET")
		{
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$this->team_repo->getIntroDownline(Session::get('USER_ID'));
			$level= $this->team_repo->getTmpDownline();
			$userrec=array(
			'proc'=>7,
			'userid'=>'`m11_user`.`m11_user_id` IN (SELECT member_id FROM tmp_downline) GROUP BY `m11_user`.`m11_user_id`',
			);
			$user_rec= $this->enroll_repo->getUserByProc($userrec);

		}
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
			    $start = date('Y-m-d',strtotime($request->input('txtfromdate')));
				$end = date('Y-m-d',strtotime($request->input('txttodate')));
				
			    $user = Helper::get_userdetail(Session::get('USER_ID'));
				if($pos!=-1){
			    $this->team_repo->getDownline(Session::get('USER_ID'),$pos);
				$level= $this->team_repo->getTmpDownline1();
				}
				else
				{
					$this->team_repo->getIntroDownline(Session::get('USER_ID'));
					$level= $this->team_repo->getTmpDownline();
			    }

				$cond ='`m11_user`.`m11_user_id` IN (SELECT member_id FROM tmp_downline) AND ';
				$cond1='';
				
				if($pos != '' && $pos != '-1')
				{
					$cond = $cond."`m11_user`.`m11_user_position` = '".$pos."'  AND ";
				}
				if($role != '' && $role != '-1')
				{
					$cond = $cond."`m11_user`.`m11_user_role` = ".$role."  AND ";
				}
				if($request->input('rb_topupst')!= '' && $request->input('rb_topupst')!= '-1')
				{
					$topupst=$request->input('rb_topupst');
					if($topupst=="0")
					$topupst="ALL";
					if($topupst=="1")
					$topupst="NO";
					if($topupst=="2")
					$topupst="TOPUP";
				}
				if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
				{
					$cond = $cond."DATE_FORMAT(`m11_user`.`m11_user_onadd`,'%Y-%m-%d')>=
                     DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(`m11_user`.`m11_user_onadd`,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
				}
				$cond = $cond." 1  GROUP BY `m11_user`.`m11_user_id`";
				//print_r($level);
				
					$userrec=array(
			'proc'=>7,
			'userid'=>$cond,
			);
			$user_rec= $this->enroll_repo->getUserByProc($userrec);
			//dd($user_rec);
			}

		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_team_downline',compact('user','level','user_rec','topupst','start','end','pos','role'));
	}

	/**
        * Method name   : Direct referraL
        * @description  : Used for direct referral
        * @param        : Request data 
        * @return       : return with user direct referral
    */
	public function directreferral()
	{
		$start =  date('Y-m-d',strtotime('2021-01-01'));
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';$role='-1';$pos='-1';
			$cond="";$topupst="ALL";
			$request = request();
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
			    $start = date('Y-m-d',strtotime($request->input('txtfromdate')));
				$end = date('Y-m-d',strtotime($request->input('txttodate')));
				
				$pos=$request->input('dd_position');
			    $role=$request->input('dd_role');
				$cond ='';
				$cond1='';
				
				if($pos != '' && $pos != '-1')
				{
					$this->team_repo->getDownline(Session::get('USER_ID'),$pos);
				    $level= $this->team_repo->getTmpDownline1();
				    $cond ='`m11_user`.`m11_user_id` IN (SELECT member_id FROM tmp_downline) AND ';
					$cond1='';
				}
				if($role != '' && $role != '-1')
				{
					$cond = $cond."`m11_user`.`m11_user_role` = ".$role."  AND ";
				}
				if($request->input('rb_topupst')!= '' && $request->input('rb_topupst')!= '-1')
				{
					$topupst=$request->input('rb_topupst');
					if($topupst=="0")
					$topupst="ALL";
					if($topupst=="1")
					$topupst="NO";
					if($topupst=="2")
					$topupst="TOPUP";
				}
				if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
				{
					$cond = $cond."DATE_FORMAT(`m11_user`.`m11_user_onadd`,'%Y-%m-%d')>=
                     DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(`m11_user`.`m11_user_onadd`,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
				}
				
			}
			$cond = $cond." `m11_user`.`m11_user_referral_code`=".Session::get('USER_ID')." AND 1 ";
			$user=array(
			'proc'=>7,
			'userid'=>$cond
			);
			//print_r($cond);
			$user_rec= $this->enroll_repo->getUserByProc($user);
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_direct_referral', compact('user','user_rec','topupst','start','end','pos','role'));
	}

	/**
        * Method name   : View news
        * @description  : Used for viewing news
        * @param        : Request data 
        * @return       : return with viewing news
    */
	/*public function view_news()
    {
    	$user = Helper::get_userdetail(Session::get('USER_ID'));
    	$tickets = $this->ticket_repo->getByUserId($user[0]->RegId);
    	return view('User.view_news', compact('user', 'tickets'));
    }*/

    /**
        * Method name   : Generate btc address
        * @description  : Used for generate btc address
        * @param        : Request data 
        * @return       : return with generate btc address
    */
    public function generate_btcaddress()
	{
		$request = request();
		$result=Helper::coinpayments_api_call('get_callback_address','BTC');
		$this->BTCADDRESS =json_encode($result['result']['address']);
		$arr = array(
			'm11_user_send_btcaddress' => $this->BTCADDRESS
			);

		$user_profile = $this->enroll_repo->updateUserBtc(Session::get('USER_CODE'), Session::get('USER_ID'), $arr);
		$request = request();
		$fund_req_toadmin=$this->fund_repo->getFundRqToAdmin(Session::get('USER_CODE'));
		$bank_account = Helper::get_bankaccount(Session::get('AFFILIATE_CODE'),1);
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_fund_request',compact('user','form_name','bank_account','fund_req_toadmin'));
	}

	/**
        * Method name   : Generate eth address
        * @description  : Used for generate eth address
        * @param        : Request data 
        * @return       : return with generate eth address
    */
	public function generate_ethaddress()
	{
		$request = request();
		$result=Helper::coinpayments_api_call('get_callback_address','ETH');
		$this->ETHADDRESS =json_encode($result['result']['address']);
		$arr = array(
			'm11_user_send_ethaddress' => $this->ETHADDRES
			);
		$user_profile = $this->enroll_repo->updateUserEth(Session::get('USER_CODE'), Session::get('USER_ID'), $arr);
		$request = request();
		$fund_req_toadmin=$this->fund_repo->getFundRqToAdmin(Session::get('USER_CODE'));
		$bank_account = Helper::get_bankaccount(Session::get('AFFILIATE_CODE'),1);
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_fund_request',compact('user','form_name','bank_account','fund_req_toadmin'));
	}

	// MATCHING WITHDRW REQUEST HERE 
	/**
        * Method name   : Matching withdraw report
        * @description  : Used for matching withdraw report
        * @param        : Request data 
        * @return       : return with matching withdraw report
    */
	public function matchingwithdraw_report()
	{
		
		/*$request = request();
		$income="MATCHING WITHDRAW REPORT";
		$form_name = 'MATCHING WITHDRAW REPORT';
		$ERRMSG = "MATCHING WITHDRAW REPORT";
		$ERRCODE="info";
		$CB_AMT=0.000;
        $avail_bal=0.000;
		if($request->method() == 'POST')
		{
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{	
			}
		}
        $user_id=Session::get('USER_ID');
		$avail_bal=$this->enroll_repo->getBalbyIncome($user_id, 2);
		$CB_AMT=$avail_bal[0]->BAL;
		$withdraw_req_toadmin = $this->fund_repo->getWdRqToAdmin(Session::get('CONTACTNO'));
		Session::flash('type',$ERRCODE );
		Session::flash('message',$ERRMSG );
		
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_macthwithdrawreq_report',compact('user','form_name','withdraw_req_toadmin','CB_AMT','income'));*/


		$request = request();
			Session::flash('type','info' );
			Session::flash('message','ALL MONEY TRANSFER REPORT HERE' );
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			
			$descrip="";
			$start = date('Y-m-d', strtotime('-6 months'));
			// $start = date('Y-m-d',strtotime(NOW()));
			$end = date('Y-m-d',strtotime(NOW()));

			$txt_account = '';
			$txt_memberid = Session::get('USER_ID');
			$txt_memberids ='';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="";
			$cond1="`tr15_request_for` IN (1,2) AND 1";

            if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
				$end = date('Y-m-d',strtotime($request->input('txt_todate')));
				$dd_status = $request->input('dd_status');
				$txt_memberids =$request->input('txt_memberid');
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
					$txt_memberid=$request->input('txt_memberid');
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
				{
					$dd_status=$request->input('dd_status');
				}
				
			}
			$cond=$cond.$cond1;
			$dmtreport=array
			(
				'proc'=>1,
				'account'=>$txt_account,
				'transid'=>$txt_transid,
				'userid'=>$txt_memberid,
				'fromdate'=>$start,
				'todate'=>$end,
				'noofrecords'=>$txt_noofrecords,
				'recstatus'=>$dd_status,
				'descrip'=>$cond
			);

			$dmt_report = $this->dmt_reprt_repo->dmrReport($dmtreport);

			

			//$dmt_report ="";
			$hit_dmtdata=array('proc'=>6,'user_id'=>$txt_memberid,'rec_fromdate'=>$start,'rec_todate'=>$end);
			$today_dmthit = $this->dmt_reprt_repo->dmrtodayHitStatus($hit_dmtdata);
			return view('User.dmt_report_1', compact('dmt_report','user','today_dmthit','start','end','txt_account','dd_status','txt_memberids','txt_noofrecords'));

	}

// MATCHING WITHDRW REQUEST HERE 
	/**
        * Method name   : Matching withdraw report
        * @description  : Used for matching withdraw report
        * @param        : Request data 
        * @return       : return with matching withdraw report
    */
	public function trade_withdraw_report()
	{

		$request = request();
			Session::flash('type','info' );
			Session::flash('message','ALL MONEY TRANSFER REPORT HERE' );
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			
			$descrip="";
			// $start = date('Y-m-d',strtotime(NOW()));
			$start = date('Y-m-d', strtotime('-6 months'));
			$end = date('Y-m-d',strtotime(NOW()));

			$txt_account = '';
			$txt_memberid = Session::get('USER_ID');
			$txt_memberids ='';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="";
			$cond1="`tr15_request_for`= 4 AND 1";

            if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
				$end = date('Y-m-d',strtotime($request->input('txt_todate')));
				$dd_status = $request->input('dd_status');
				$txt_memberids =$request->input('txt_memberid');
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
					$txt_memberid=$request->input('txt_memberid');
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
				{
					$dd_status=$request->input('dd_status');
				}
				
			}
			
			$cond=$cond.$cond1;

			$dmtreport=array
			(
				'proc'=>1,
				'account'=>$txt_account,
				'transid'=>$txt_transid,
				'userid'=>$txt_memberid,
				'fromdate'=>$start,
				'todate'=>$end,
				'noofrecords'=>$txt_noofrecords,
				'recstatus'=>$dd_status,
				'descrip'=>$cond
			);

			$dmt_report = $this->dmt_reprt_repo->dmrReport($dmtreport);

			

			//$dmt_report ="";
			$hit_dmtdata=array('proc'=>6,'user_id'=>$txt_memberid,'rec_fromdate'=>$start,'rec_todate'=>$end);
			$today_dmthit = $this->dmt_reprt_repo->dmrtodayHitStatus($hit_dmtdata);
			return view('User.dmt_report_2', compact('dmt_report','user','today_dmthit','start','end','txt_account','dd_status','txt_memberids','txt_noofrecords'));

	}


	/**
        * Method name   : Matching withdraw req status
        * @description  : Used for matching withdraw req status
        * @param        : Request data 
        * @return       : return with matching withdraw req status
    */
	public function matchingwithdraw_req_status()
	{
		$page = 'PROFILE PANEL';
		$request = request();
		$income="MATCHING INCOME REPORT";
		$form_name = 'MATCHING WITHDRAW REQUEST STATUS';
		$ERRMSG = "MATCHING WITHDRAW REQUEST STATUS";
		$ERRCODE="info";
		$CB_AMT=0.000;
        $avail_bal=0.000;
		if($request->method() == 'POST')
		{
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				
			}
			
		}
        $user_id=Session::get('USER_ID');
		$avail_bal=$this->enroll_repo->getBalbyIncome($user_id, 2);
		$CB_AMT=$avail_bal[0]->BAL;

		$withdraw_req_toadmin=$this->fund_repo->getWdRqToAdmin(Session::get('CONTACTNO'));
		Session::flash('type',$ERRCODE );
		Session::flash('message',$ERRMSG );
		
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_macthwithdrawreq_status',compact('user','form_name','withdraw_req_toadmin','CB_AMT','income'));
	}

	/**
        * Method name   : Matching withdraw request
        * @description  : Used for matching withdraw request
        * @param        : Request data 
        * @return       : return with matching withdraw request
    */
	public function matchingwithdraw_request()
	{
		$income="MATCHING INCOME";
		$request = request();
		$ERRMSG = "";
		$ERRCODE="";
		$CB_AMT=0.000;
        $avail_bal=0.000;
        $txt_bankifsccode='';

	    $user_id=Session::get('USER_ID');
		$form_name = 'WITHDRAW REPORT';
		$get_useralldetail = Helper::get_useralldetail(Session::get('USER_ID'));
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$data = ["txt_amount" => 0];
//dd(1);
		if($request->method() == 'POST')
		{	
			if(session()->has('session_id')) {
				$session_id = Session::get('session_id');
				$session_data = DB::table("tr52_request_otp")->where(["tr52_session_id" => $session_id, "m11_user_id" => (int)Session()->get('USER_ID')])->orderBy('tr52_id','desc')->first();
				$data = ["txt_amount" => json_decode($session_data->tr52_form_data)->txt_amount];
			}


		    if($request->input('txt_cbsacno')=='')
			{
				$ERRMSG = "Bank Account or BSC Address should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			
			if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00 || floatval($request->input('txt_amount'))<10.00)
			{
				$ERRMSG = "Amount should be greater than $10 or not be blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			/*else if(floatval($request->input('txt_amount'))<10.00 && floatval($request->input('txt_amount')%1.00)!=0.00 )
            {
                    $ERRMSG = "Amount should be multiple of $1.00";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
            }*/
			else if(floatval($request->input('txt_amount')) < 10.00)
            {
                    $ERRMSG = "Amount should be multiple of $10.00";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
            }
			else if(floatval($request->input('txt_amount'))<0.00)
			{
				$ERRMSG = "Amount should be greater than $10 or not be negative.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if(floatval($request->input('txt_amount'))>10000000.00)
			{
				$ERRMSG = "Amount should be less than $10000000.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if(session()->has('session_id') && $request->input('txt_otp') == '')
			{
				$ERRMSG = "OTP should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST' && $this->isError==FALSE)
			{
				$userinfo = Helper::get_useralldetail(Session()->get('USER_ID'));
				
				if($request->input('txt_bankifsccode')!=''){
					$txt_bankifsccode=$request->input('txt_bankifsccode');
				}

				//otp code start
				if(!session()->has('session_id')) {
					$otp = '123456';
					$otp = rand(100000,999999);
					$form_id = time();
					$check = DB::table("tr52_request_otp")->insert([
						"tr52_session_id" => $form_id,
						"m11_user_id" => (int)Session()->get('USER_ID'),
						"tr52_form_data" => json_encode($request->all()),
						"tr52_otp" => $otp,
						"tr52_form_name" => 'WITHDRAW',
						"tr52_created_by" => 'USER',
						"tr52_created_id" =>  (int)Session()->get('USER_ID')
					]);
					$data = ["txt_amount" => $request->txt_amount];
					if($check) {
						Session::put('session_id', $form_id);
						if($request->form_id == 2) {
							Session()->put('form_id_2', $form_id);
						} else {
							Session()->put('form_id_1', $form_id);
						}
						

						try {

							$template_type = 1;

							$mailData = [
								'msg_title' => 'vcl_acount_verify',
								'name' => session()->get('NAME'),
								'useremail' => session()->get('EMAIL'),
								'usercode' => session()->get('USER_CODE'),
								'password' => $otp,
								'link' => url('/home'),
								'trans_id' => url('/home'),
								'template_name' => 'email'
							];

							DB::table("tr04_login")->where("m11_user_id", (int)Session()->get('USER_ID'))->update(["tr04_lb_otp" =>  $otp]);
							$msg_config = DB::table("m09_message_config")->where("m09_msg_title", $mailData['msg_title'])->first();
							$mailData['MSG_CONTENT'] = $msg_config->m09_msg_content;
							$mailData['MSG_SUBJECT'] = $msg_config->m09_msg_subject;
							$mailData['MSG_CONTENT'] = strtr($mailData['MSG_CONTENT'], array('{name}' => $mailData['name'],
							'{useremail}'=>$mailData['useremail'],'{password}'=>$mailData['password'],'{link}'=>$mailData['link'],'{trans_id}'=>$mailData['trans_id']));
							$mailData['pdf'] ='';
							$template_data = $mailData;
							Mail::to($mailData['useremail'])->send(new SendMail($template_data, $template_type));

							// Helper::sendOtp($otp, Session::get('CONTACTNO'));
						} catch (Exception $e) {
							
						}
						
						Session::flash('type',"success");
						Session::flash('message',"please enter otp!");
						return view('User.user_macthwithdrawrequest',compact('user','form_name','income','get_useralldetail','data'));
					} else {
						session()->forget('session_id');
						Session()->forget('form_id_1');
						Session()->forget('form_id_2');
						return redirect("withdraw_request");
					}

				} else {

					if($request->txt_otp != $session_data->tr52_otp)
					{
						Session::flash('type',"warning");
						Session::flash('message',"please enter valid otp!");
						return view('User.user_macthwithdrawrequest',compact('user','form_name','income','get_useralldetail','data'));
					}
				}
				//otp code end

				$dmr_req=array(
					'proc'=>'1',
					'm11_user_id'=>Session::get('USER_ID'),
					'trans_id'=>2,
					'refre_id'=>'',
					'request_no'=>'',
					'mobile_no'=>Session::get('CONTACTNO'),
					'amount'=>$request->input('txt_amount'),
					'payment_id'=>'',
					'payment_status'=>'',
					'impsrefno'=>'',
					'message'=>'',
					'remarks'=>'',
					'account_number'=>$request->input('txt_cbsacno'),
					'beneficiary_code'=> '',
					'beneficiary_name'=>'',
					'account_type'=>'',
					'ifsc'=>$txt_bankifsccode,
					'bank_name'=>'',
					'branch_name'=>'',
					'address'=>'',
					'state'=>'',
					'city'=>'',
					'agentid'=>'',
					'payctransid'=>'',
					'topup_charge'=>'0.00',
					'transfer_status'=>'2');

				$dmrreq_response=$this->dmt_proc_repo->doRemmitance($dmr_req);
				
				$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
				$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
				$ERRCODE=$DB_ERROR[0]->ERROR;
				$ERRMSG =$DB_ERRMSG[0]->ERR_MSG;
				
				Session::flash('type',$ERRCODE );
				Session::flash('message',$ERRMSG );
				return redirect("withdraw_request");
			}
			
		    Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
		} else {
			// for otp code
			session()->forget('session_id');
			Session()->forget('form_id_1');
			Session()->forget('form_id_2');
		}

		return view('User.user_macthwithdrawrequest',compact('user','form_name','income','get_useralldetail','data'));
	}
	
	
	/**
        * Method name   : TradeBonus  withdraw request
        * @description  : Used for matching withdraw request
        * @param        : Request data 
        * @return       : return with matching withdraw request
    */
	public function trade_withdraw_request()
	{
		$income="Trade Bonus INCOME";
		$request = request();
		$ERRMSG = "";
		$ERRCODE="";
		$CB_AMT=0.000;
        $avail_bal=0.000;
        $txt_bankifsccode='';

	    $user_id=Session::get('USER_ID');
		$form_name = 'WITHDRAW REPORT';
		$get_useralldetail = Helper::get_useralldetail(Session::get('USER_ID'));
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$data = ["txt_amount" => 0];

		if($request->method() == 'POST')
		{	
			if(session()->has('session_id')) 
			{
				$session_id = Session::get('session_id');
				$session_data = DB::table("tr52_request_otp")->where(["tr52_session_id" => $session_id, "m11_user_id" => (int)Session()->get('USER_ID')])->orderBy('tr52_id','desc')->first();
				$data = ["txt_amount" => json_decode($session_data->tr52_form_data)->txt_amount];
			}
		    if($request->input('txt_cbsacno')=='')
			{
				$ERRMSG = "Bank Account or BSC Address should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			
			if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00 || floatval($request->input('txt_amount'))<10.00)
			{
				$ERRMSG = "Amount should be greater than $10 or not be blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			/*else if(floatval($request->input('txt_amount'))<10.00 && floatval($request->input('txt_amount')%1.00)!=0.00 )
            {
                    $ERRMSG = "Amount should be multiple of $10.00";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
            }*/
			else if(floatval($request->input('txt_amount'))>9.00 && floatval($request->input('txt_amount')%10.00)!=0.00 )
            {
                    $ERRMSG = "Amount should be multiple of $10.00";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
            }
			else if(floatval($request->input('txt_amount'))<0.00)
			{
				$ERRMSG = "Amount should be greater than $10 or not be negative.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if(floatval($request->input('txt_amount'))>10000000.00)
			{
				$ERRMSG = "Amount should be less than $10000000.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if(session()->has('session_id') && $request->input('txt_otp') == '')
			{
				$ERRMSG = "OTP should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST' && $this->isError==FALSE)
			{
				$userinfo = Helper::get_useralldetail(Session()->get('USER_ID'));
				
				if($request->input('txt_bankifsccode')!=''){
					$txt_bankifsccode=$request->input('txt_bankifsccode');
				}

				//otp code start
				if(!session()->has('session_id')) {
					$otp = '123456';
					$otp = rand(100000,999999);
					$form_id = time();
					$check = DB::table("tr52_request_otp")->insert([
						"tr52_session_id" => $form_id,
						"m11_user_id" => (int)Session()->get('USER_ID'),
						"tr52_form_data" => json_encode($request->all()),
						"tr52_otp" => $otp,
						"tr52_form_name" => 'WITHDRAW',
						"tr52_created_by" => 'USER',
						"tr52_created_id" =>  (int)Session()->get('USER_ID')
					]);
					$data = ["txt_amount" => $request->txt_amount];
					if($check) {
						Session::put('session_id', $form_id);
						if($request->form_id == 2) {
							Session()->put('form_id_2', $form_id);
						} else {
							Session()->put('form_id_1', $form_id);
						}
						
						try {
							
							$template_type = 1;

							$mailData = [
								'msg_title' => 'vcl_acount_verify',
								'name' => session()->get('NAME'),
								'useremail' => session()->get('EMAIL'),
								'usercode' => session()->get('USER_CODE'),
								'password' => $otp,
								'link' => url('/home'),
								'trans_id' => url('/home'),
								'template_name' => 'email'
							];

							DB::table("tr04_login")->where("m11_user_id", (int)Session()->get('USER_ID'))->update(["tr04_lb_otp" =>  $otp]);
							$msg_config = DB::table("m09_message_config")->where("m09_msg_title", $mailData['msg_title'])->first();
							$mailData['MSG_CONTENT'] = $msg_config->m09_msg_content;
							$mailData['MSG_SUBJECT'] = $msg_config->m09_msg_subject;
							$mailData['MSG_CONTENT'] = strtr($mailData['MSG_CONTENT'], array('{name}' => $mailData['name'],
							'{useremail}'=>$mailData['useremail'],'{password}'=>$mailData['password'],'{link}'=>$mailData['link'],'{trans_id}'=>$mailData['trans_id']));
							$mailData['pdf'] ='';
							$template_data = $mailData;
							Mail::to($mailData['useremail'])->send(new SendMail($template_data, $template_type));

							// Helper::sendOtp($otp, Session::get('CONTACTNO'));
						} catch (Exception $e) {
							
						}
						
						Session::flash('type',"success");
						Session::flash('message',"please enter otp!");
						return view('User.user_tradebonuswithdrawrequest',compact('user','form_name','income','get_useralldetail','data'));
					} else {
						session()->forget('session_id');
						Session()->forget('form_id_1');
						Session()->forget('form_id_2');
						return redirect("trade_withdraw_request");
					}

				} else {

					if($request->txt_otp != $session_data->tr52_otp)
					{
						Session::flash('type',"warning");
						Session::flash('message',"please enter valid otp!");
						return view('User.user_tradebonuswithdrawrequest',compact('user','form_name','income','get_useralldetail','data'));
					}
				}
				//otp code end

				$dmr_req=array(
					'proc'=>'1',
					'm11_user_id'=>Session::get('USER_ID'),
					'trans_id'=>4,
					'refre_id'=>'',
					'request_no'=>'',
					'mobile_no'=>Session::get('CONTACTNO'),
					'amount'=>$request->input('txt_amount'),
					'payment_id'=>'',
					'payment_status'=>'',
					'impsrefno'=>'',
					'message'=>'',
					'remarks'=>'',
					'account_number'=>$request->input('txt_cbsacno'),
					'beneficiary_code'=> '',
					'beneficiary_name'=>'',
					'account_type'=>'',
					'ifsc'=>$txt_bankifsccode,
					'bank_name'=>'',
					'branch_name'=>'',
					'address'=>'',
					'state'=>'',
					'city'=>'',
					'agentid'=>'',
					'payctransid'=>'',
					'topup_charge'=>'0.00',
					'transfer_status'=>'2');

				$dmrreq_response=$this->dmt_proc_repo->doRemmitance($dmr_req);
				
				$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
				$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
				$ERRCODE=$DB_ERROR[0]->ERROR;
				$ERRMSG =$DB_ERRMSG[0]->ERR_MSG;
				
				Session::flash('type',$ERRCODE );
				Session::flash('message',$ERRMSG );
				return redirect("trade_withdraw_request");
			}
			
		    Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
		} else {
			// for otp code
			session()->forget('session_id');
			Session()->forget('form_id_1');
			Session()->forget('form_id_2');
		}

		return view('User.user_tradebonuswithdrawrequest',compact('user','form_name','income','get_useralldetail','data'));
	}

	// DIRECT WITHDRW REQUEST HERE 
	/**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function direct_withdraw_request()
	{
		$page = 'PROFILE PANEL';
		$income="DIRECT CASHBACK INCOME";
		$form_name = 'DIRECT CASH BACK WITHDRAW REQUEST TO ADMIN';
		$request = request();
		$ERRMSG = "DIRECT CASH BACK WITHDRAW REQUEST TO ADMIN HERE";
		$ERRCODE="info";
		$CB_AMT=0.000;
        $avail_bal=0.000;
		if($request->method() == 'POST')
		{
			if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
			{
				$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if(floatval($request->input('txt_amount'))<0.00)
			{
				$ERRMSG = "Amount should be greater than 0.00 or not be negative.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			//dd($ERRMSG);
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				$fundreq=array('proc'=>2,
				'm23_user_bnkid'=>'0',
				'm11_user_id'=>Session::get('USER_ID'),
				'tr32_wr_forincome'=>2,
				'tr23_fr_towallet'=>2,
				'tr23_fr_mode'=>1,
				'tr23_fr_utrno'=>'',
				'tr23_fr_amount'=>floatval($request->input('txt_amount')),
				'tr23_fr_transid'=>'',
				'tr23_fr_des'=>'',
				'tr23_fr_admin_res'=>'',
				'tr23_fr_status'=>1,
				'tr23_fr_toadmin'=>1,
				'm11_user_referral_code'=>0,
				'm22_affiliate_id'=>Session::get('AFFILIATE_CODE')
				);
				$fund_request=$this->fund_repo->withdraw_request($fundreq);
				$DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
				$DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
				$ERRMSG=$DB_ERRMSG[0]->ERR_MSG;
				$ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
				// dd($ERRMSG);
			}
			
		}
		$user_id=Session::get('USER_ID');
		$avail_bal=DB::select("SELECT get_balby_income($user_id,2) AS BAL");
		$CB_AMT=$avail_bal[0]->BAL;
		$withdraw_req_toadmin=$this->fund_repo->getWdRqToAdmin(Session::get('CONTACTNO'));
		Session::flash('type',$ERRCODE );
		Session::flash('message',$ERRMSG );
		
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_directwithdraw_request',compact('user','form_name','withdraw_req_toadmin','CB_AMT','income'));
	}

	/**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function direct_withdraw_req_status()
	{
		$page = 'PROFILE PANEL';
		$request = request();
		$income="DIRECT CASH BACK INCOME REPORT";
		$form_name = 'DIRECT CASH BACK WITHDRAW REQUEST STATUS';
		$ERRMSG = "DIRECT CASH BACK WITHDRAW REQUEST STATUS";
		$ERRCODE="info";
		$CB_AMT=0.000;
        $avail_bal=0.000;
		if($request->method() == 'POST')
		{
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				
			}
			
		}
        $user_id=Session::get('USER_ID');
		$avail_bal=DB::select("SELECT get_balby_income($user_id,2) AS BAL");
		$CB_AMT=$avail_bal[0]->BAL;
		$withdraw_req_toadmin=$this->fund_repo->getWdRqToAdmin(Session::get('CONTACTNO'));
		Session::flash('type',$ERRCODE );
		Session::flash('message',$ERRMSG );
		
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_directwithdrawreq_status',compact('user','form_name','withdraw_req_toadmin','CB_AMT','income'));
	}

	/**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function direct_withdraw_report()
	{
		$page = 'PROFILE PANEL';
		$request = request();
		$income="DIRECT CASH BACK WITHDRAW REPORT";
		$form_name = 'DIRECT CASH BACK WITHDRAW REPORT';
		$ERRMSG = "DIRECT CASH BACK WITHDRAW REPORT";
		$ERRCODE="info";
		$CB_AMT=0.000;
        $avail_bal=0.000;
		if($request->method() == 'POST')
		{
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				
			}
			
		}
        $user_id=Session::get('USER_ID');
		$avail_bal=DB::select("SELECT get_balby_income($user_id,2) AS BAL");
		$CB_AMT=$avail_bal[0]->BAL;
		$withdraw_req_toadmin=$this->fund_repo->getWdRqToAdmin(Session::get('CONTACTNO'));
		Session::flash('type',$ERRCODE );
		Session::flash('message',$ERRMSG );
		
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_directwithdraw_report',compact('user','form_name','withdraw_req_toadmin','CB_AMT','income'));
	}

	//CASHBACK WITHDRW REQUEST HERE 
	/**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function cbwithdraw_request()
	{
		$ERRMSG = "BONUS POINT WITHDRAW REQUEST STATUS";
		$ERRCODE="info";
		$request = request();
		$CB_AMT=0.000;
        $avail_bal=0.000;
		if($request->method() == 'POST')
		{
			if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
			{
				$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if(floatval($request->input('txt_amount'))<0.00)
			{
				$ERRMSG = "Amount should be greater than 0.00 or not be negative.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			//dd($ERRMSG);
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				$fundreq=array('proc'=>2,'m23_user_bnkid'=>'0','m11_user_id'=>Session::get('USER_ID'),'tr32_wr_forincome'=>1,'tr23_fr_towallet'=>2,'tr23_fr_mode'=>1,'tr23_fr_utrno'=>'','tr23_fr_amount'=>floatval($request->input('txt_amount')),'tr23_fr_transid'=>'','tr23_fr_des'=>'','tr23_fr_admin_res'=>'','tr23_fr_status'=>1,'tr23_fr_toadmin'=>1,'m11_user_referral_code'=>0,'m22_affiliate_id'=>Session::get('AFFILIATE_CODE')
				);
				$fund_request=DB::select('CALL withdraw_request(:proc,:m23_user_bnkid,:m11_user_id,:tr32_wr_forincome:tr23_fr_towallet,:tr23_fr_mode,:tr23_fr_utrno,:tr23_fr_amount,:tr23_fr_transid,:tr23_fr_des,:tr23_fr_admin_res,:tr23_fr_status,:tr23_fr_toadmin,:m11_user_referral_code,:m22_affiliate_id,@status_code,@status_msg
				)',$fundreq);
				$DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
				$DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
				$ERRMSG=$DB_ERRMSG[0]->ERR_MSG;
				$ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
				// dd($ERRMSG);
			}
			
		}
        $user_id=Session::get('USER_ID');
		$avail_bal=DB::select("SELECT get_balby_income($user_id,1) AS BAL");
		$CB_AMT=$avail_bal[0]->BAL;
		$withdraw_req_toadmin=DB::select("SELECT * FROM withdraw_request WHERE FUNDREQ_FOR_INCOME=1 AND FUNDREQ_TO=1 AND MEMBER_CONTACT=".Session::get('CONTACTNO'));
		Session::flash('type',$ERRCODE );
		Session::flash('message',$ERRMSG );
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_cbwithdraw_request',compact('user','withdraw_req_toadmin','CB_AMT','income'));
	}

	/**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function cbwithdraw_req_status()
	{
		$page = 'PROFILE PANEL';
		$request = request();
		$income="MATCHING INCOME REPORT";
		$form_name = 'MATCHING WITHDRAW REQUEST STATUS';
		$ERRMSG = "MATCHING WITHDRAW REQUEST STATUS";
		$ERRCODE="info";
		$CB_AMT=0.000;
        $avail_bal=0.000;
		if($request->method() == 'POST')
		{
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				
			}
			
		}
        $user_id=Session::get('USER_ID');
		$avail_bal=DB::select("SELECT get_balby_income($user_id,2) AS BAL");
		$CB_AMT=$avail_bal[0]->BAL;
		$withdraw_req_toadmin=DB::select("SELECT * FROM withdraw_request WHERE FUNDREQ_FOR_INCOME=1 AND FUNDREQ_TO=1 AND MEMBER_CONTACT=".Session::get('CONTACTNO'));
		Session::flash('type',$ERRCODE );
		Session::flash('message',$ERRMSG );
		
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_cbwithdraw_status',compact('user','form_name','withdraw_req_toadmin','CB_AMT','income'));
	}

	/**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function cbwithdraw_report()
	{
		$page = 'PROFILE PANEL';
		$request = request();
		$income="MATCHING WITHDRAW REPORT";
		$form_name = 'MATCHING WITHDRAW REPORT';
		$ERRMSG = "MATCHING WITHDRAW REPORT";
		$ERRCODE="info";
		$CB_AMT=0.000;
        $avail_bal=0.000;
		if($request->method() == 'POST')
		{
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				
			}
			
		}
        $user_id=Session::get('USER_ID');
		$avail_bal=DB::select("SELECT get_balby_income($user_id,2) AS BAL");
		$CB_AMT=$avail_bal[0]->BAL;
		$withdraw_req_toadmin=DB::select("SELECT * FROM withdraw_request WHERE FUNDREQ_FOR_INCOME=1 AND FUNDREQ_TO=1 AND MEMBER_CONTACT=".Session::get('CONTACTNO'));
		Session::flash('type',$ERRCODE );
		Session::flash('message',$ERRMSG );
		
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_cbwithdraw_report',compact('user','form_name','withdraw_req_toadmin','CB_AMT','income'));
	}

	

	/**
        * Method name   : user fund transfer to team view
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function user_fundtransferto_team_view()
	{
		return view('User.user_fundtransfer');
	}

	/**
        * Method name   : user fund transfer to team
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function user_fundtransferto_team()
	{
		$request = request();
		$ERRMSG='FUND TRANSFER HERE';
		$ERRCODE='info';
		$isError = FALSE;
		$transfer="";
		if(request()->method() == 'POST')
		{
			if($request->input('ladger')=="")
			{
				$ERRMSG = "Ledger should be valid.Please Select Ledger Type ";
				$isError = TRUE;
				$ERRCODE="warning";
			}	
			else if($request->input('baltype')=="")
			{
				$ERRMSG = "Balance type should be valid.Please Select Balance Type ";
				$isError = TRUE;
				$ERRCODE="warning";
			}	
			else if($request->input('txt_referralcode')=='')
			{
				$ERRMSG = "Member should be valid or not blank.";
				$isError = TRUE;
				$ERRCODE="warning";
			}
			/*else if(!_valid_phone_number($request->input('txt_mobileno')))
				{
				$ERRMSG = "";
				$isError = TRUE;
			}*/
			$contactno=$request->input('txt_referralcode');
			$user = Helper::get_userid($contactno);
			//$mobileno= Helper::get_usermobileno($contactno[0]);
			if(empty($user))
			{
				$ERRMSG = "Member should be valid";
				$isError = TRUE;
				$ERRCODE="warning";
			}
			else if(Session::get('USER_ID')==$user)
			{
				$ERRMSG = "Same account has not been transferable.";
				$isError = TRUE;
				$ERRCODE="warning";
			}
			else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
			{
				$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
				$isError = TRUE;
				$ERRCODE="warning";
			}
			else if(floatval($request->input('txt_amount'))<0.00)
			{
				$ERRMSG = "Amount should be greater than 0.00 or not be negative.";
				$isError = TRUE;
				$ERRCODE="warning";
			}
			if(request()->method() == 'POST'&& $isError==FALSE)
			{
				if($request->input('ladger')==3)
				$transfer="TRANSFER";
				$fundtransfer_data=array(
				'proc'=>$request->input('ladger'),
				'to_user_id'=>$user,
				'from_user_id'=>Session::get('USER_ID'),
				'amount'=>floatval($request->input('txt_amount')),
				'collected_amount'=>floatval($request->input('txt_amount')),
				'requesttype'=>1,
				'balfor'=>$request->input('baltype'),
				'transtype'=>1,
				'timelimit'=>(config('FUND_INTERVAL')*60),
				'defaultstatus'=>1,
				'remark'=>$request->input('txt_remark'),
				'collected_remark'=>$request->input('txt_remark')
				);

				$fundtransfer = $this->fund_repo->walletTransfer($fundtransfer_data);

				$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
				$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
				$ERRCODE=$ERRCODE[0]->ERR_CODE;
				if($ERRCODE=="success")
				{
					$ERRMSG="Amount ".floatval($request->input('txt_amount'))." ".$transfer. " to ".$contactno[0].", Transaction id-". $ERRMSG[0]->ERR_MSG ." .";
					$this->send_sms($mobileno,$ERRMSG);
				}
				else
				{
					$ERRMSG=$ERRMSG[0]->ERR_MSG;
				}
				
			}
		}
		Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_fundtransfer');
	}

	/**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function user_creditstatement()
	{
	
		$request = request();

		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$descrip="";
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txt_account = '';
		$txt_memberid = Session::get('USER_ID');
		$txt_transid = '';
		$txt_noofrecords = '100';
		$dd_ledgertype='1';
		$cond="";
		$cond1=" `tr03_manage_ledger`.`tr03_bal_type`=1 ";
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
		    $start = date('Y-m-d',strtotime($request->input('txt_from')));
			$end = date('Y-m-d',strtotime($request->input('txt_to')));
			$cond=$cond.$cond1;
		}
		if($_SERVER['REQUEST_METHOD']=="GET")
        {
		$cond=$cond.$cond1;
		}
		$ledgerreport=array(
		'proc'=>2,
		'account'=>"",
		'transid'=>$txt_transid,
		'userid'=>$txt_memberid,
		'fromdate'=>$start,
		'todate'=>$end,
		'noofrecords'=>$txt_noofrecords,
		'ledegerstatus'=>$dd_ledgertype,
		'descrip'=>$cond,
		'msg'=>@msg
        );
		$ledger_report = $this->fund_repo->ledgerReport($ledgerreport);

		return view('User.user_credit_statement', compact('ledger_report','user'));
	}

	/**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function fundrequeststatus()
	{
		$fund_req_toadmin=DB::select("SELECT * FROM fund_request WHERE FUNDREQ_TOWALLET!=3 AND FUNDREQ_TO=1 AND MEMBER_CODE='".Session::get('USER_CODE')."'");
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_fund_request_status',compact('user','fund_req_toadmin'));
	}

	/**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function fundrequestto_admin()
	{
		$request = request();
		$ERRMSG ="";
		$ERRCODE="";
		if($request->method() == 'POST')
		{
			if($request->input('dd_wallet')=='' || $request->input('dd_wallet')=='-1')
			{
				$ERRMSG = "Wallet type should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('dd_depositedbank')=='' || $request->input('dd_depositedbank')=='-1')
			{
				$ERRMSG = "Bank Account should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('dd_paymentmethod')=='' || $request->input('dd_paymentmethod')=='-1')
			{
				$ERRMSG = "Payment method should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
			{
				$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if(floatval($request->input('txt_amount'))<0.00)
			{
				$ERRMSG = "Amount should be greater than 0.00 or not be negative.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_bankutrn')=='')
			{
				$ERRMSG = "Refrence/Bank UTRNO should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				$fundreq=array(
				'proc'=>2,
				'm27_adminbank_id'=>$request->input('dd_depositedbank'),
				'm11_user_id'=>Session::get('USER_ID'),
				'tr01_fr_towallet'=>$request->input('dd_wallet'),
				'tr01_fr_mode'=>intval($request->input('dd_paymentmethod')),
				'tr01_fr_utrno'=>$request->input('txt_bankutrn'),
				'tr01_fr_amount'=>floatval($request->input('txt_amount')),
				'tr01_fr_transid'=>'',
				'tr01_fr_des'=>$request->input('txt_description'),
				'tr01_fr_admin_res'=>'',
				'tr01_fr_status'=>1,
				'tr01_fr_toadmin'=>1,
				'm11_user_referral_code'=>0,
				'm22_affiliate_id'=>Session::get('AFFILIATE_CODE')
				);
				$fund_request=DB::select('CALL fund_request(				
				:proc,
				:m27_adminbank_id,
				:m11_user_id,
				:tr01_fr_towallet,
				:tr01_fr_mode,
				:tr01_fr_utrno,
				:tr01_fr_amount,
				:tr01_fr_transid,
				:tr01_fr_des,
				:tr01_fr_admin_res,
				:tr01_fr_status,
				:tr01_fr_toadmin,
				:m11_user_referral_code,
				:m22_affiliate_id,
				@status_code,
				@status_msg
				)',$fundreq);
				$DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
				$DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
				$ERRMSG=$DB_ERRMSG[0]->ERR_MSG;
				$ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
			}
			echo $ERRCODE;
		}
		$fund_req_toadmin=DB::select("SELECT * FROM fund_request WHERE FUNDREQ_TOWALLET!=3 AND FUNDREQ_TO=1 AND MEMBER_CODE='".Session::get('USER_CODE')."'");
		Session::flash('type',$ERRCODE );
		Session::flash('message',$ERRMSG );
		return redirect('user_fundrequestto_admin'); 
	}

	/**
        * Method name   : user fund request to admin view
        * @description  : Used for fund request to admin view
        * @param        : Request data 
        * @return       : return with fund request to admin view
    */
	public function user_fundrequestto_admin_view()
	{
		$fund_req_toadmin=DB::select("SELECT * FROM fund_request WHERE FUNDREQ_TOWALLET!=3 AND FUNDREQ_TO=1 AND MEMBER_CONTACT=".Session::get('CONTACTNO'));
		
			$REF_USER = DB::table('m22_affiliate')->where('m22_affiliate_id', Session::get('AFFILIATE_CODE'))->first();
				if($REF_USER != null)
				{	$referral_user = $REF_USER->m11_user_id;
					
					if(Session::get('USER_ID') == $referral_user )
						{
							$bank_account = Helper::get_bankaccount(0,1);
						}
						else{
									$bank_account = Helper::get_bankaccount(Session::get('AFFILIATE_CODE'),1);
							}
				}
				else
				{ $bank_account = Helper::get_bankaccount(0,1); }


		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_fund_request',compact('user','bank_account','fund_req_toadmin'));
	}

	/**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function user_fundrequestto_admin()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'FUND REQUEST TO ADMIN';
		$request = request();
		$ERRMSG = "FUND REQUEST TO ADMIN HERE";
		$ERRCODE="info";
		if($request->method() == 'POST')
		{
			if($request->input('dd_wallet')=='' || $request->input('dd_wallet')=='-1')
			{
				$ERRMSG = "Wallet type should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('dd_depositedbank')=='' || $request->input('dd_depositedbank')=='-1')
			{
				$ERRMSG = "Bank Account should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('dd_paymentmethod')=='' || $request->input('dd_paymentmethod')=='-1')
			{
				$ERRMSG = "Payment method should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
			{
				$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
				$this->isError = TRUE;
				$ERRCODE="warning";
			}
			else if(floatval($request->input('txt_amount'))<0.00)
			{
				$ERRMSG = "Amount should be greater than 0.00 or not be negative.";
				$this->isError = TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_bankutrn')=='')
			{
				$ERRMSG = "Refrence/Bank UTRNO should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			//dd($ERRMSG);

			if(request()->method() == 'POST' && $this->isError==FALSE)
			{
			    if(Session::get('USER_ROLE')!='BRANCH' && Session::get('USER_ROLE')!='WHITE LABEL' && Session::get('USER_ROLE')!='API USER')
			    {
				$REF_USER = DB::table('m22_affiliate')->where('m22_affiliate_id', Session::get('AFFILIATE_CODE'))->first();
				if($REF_USER != null)
				{	$referral_user = $REF_USER->m11_user_id;
					if(Session::get('USER_ID') == $referral_user )
						{
							$referral_user = 0;
						}
				}
				else
				{ $referral_user = '0'; }
			    }
			    else
			    { $referral_user = '0'; }
			    
				$fundreq=array(
					'proc'=>2,
					'm27_adminbank_id'=>$request->input('dd_depositedbank'),
					'm11_user_id'=>Session::get('USER_ID'),
					'tr01_fr_towallet'=>$request->input('dd_wallet'),
					'tr01_fr_mode'=>intval($request->input('dd_paymentmethod')),
					'tr01_fr_utrno'=>$request->input('txt_bankutrn'),
					'tr01_fr_amount'=>floatval($request->input('txt_amount')),
					'tr01_fr_transid'=>'',
					'tr01_fr_des'=>$request->input('txt_description'),
					'tr01_fr_admin_res'=>'',
					'tr01_fr_status'=>1,
					'tr01_fr_toadmin'=>1,
					'm11_user_referral_code'=> $referral_user,
					'm22_affiliate_id'=>Session::get('AFFILIATE_CODE')
				);
				$fund_request=DB::select('CALL fund_request(				
				:proc,
				:m27_adminbank_id,
				:m11_user_id,
				:tr01_fr_towallet,
				:tr01_fr_mode,
				:tr01_fr_utrno,
				:tr01_fr_amount,
				:tr01_fr_transid,
				:tr01_fr_des,
				:tr01_fr_admin_res,
				:tr01_fr_status,
				:tr01_fr_toadmin,
				:m11_user_referral_code,
				:m22_affiliate_id,
				@status_code,
				@status_msg
				)',$fundreq);
			   $DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
               $DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
			   $ERRMSG=$DB_ERRMSG[0]->ERR_MSG;
               $ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
			  // dd($ERRMSG);
			}
			
		}
	
		Session::flash('type',$ERRCODE );
		Session::flash('message',$ERRMSG );

		return redirect('/user_fundrequestto_admin_view');
	}

	/**
        * Method name   : user fund request to upline view
        * @description  : Used for fund request to upline
        * @param        : Request data 
        * @return       : return with fund request
    */
	public function user_fundrequestto_upline_view()
	{
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$fund_req_toupline=DB::select("SELECT * FROM fund_request WHERE FUNDREQ_TO=2 AND MEMBER_CONTACT=".Session::get('CONTACTNO'));
		return view('User.user_fundrequest2upline',compact('user','fund_req_toupline'));
	}

	/**
        * Method name   : user fund request to upline
        * @description  : Used for fund request to upline
        * @param        : Request data 
        * @return       : return with fund request
    */
	public function user_fundrequestto_upline()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'FUND REQUEST TO UPLINE ';
		$request = request();
		$ERRMSG = "FUND REQUEST TO UPLINE HERE";
		$ERRCODE="info";
		$user = Helper::get_userdetail(Session::get('USER_ID'));
	
		if($request->method() == 'POST')
		{
			if($request->input('dd_wallet')=='' || $request->input('dd_wallet')=='-1')
			{
				$ERRMSG = "Wallet type should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			
			else if($request->input('dd_paymentmethod')=='' || $request->input('dd_paymentmethod')=='-1')
			{
				$ERRMSG = "Payment method should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_amount')=='')
			{
				$ERRMSG = "Amount should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_bankutrn')=='')
			{
				$ERRMSG = "Refrence/Bank UTRNO should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				$fundreq=array(
					'proc'=>2,
					'm27_adminbank_id'=>'0',
					'm11_user_id'=>Session::get('USER_ID'),
					'tr01_fr_towallet'=>$request->input('dd_wallet'),
					'tr01_fr_mode'=>intval($request->input('dd_paymentmethod')),
					'tr01_fr_utrno'=>$request->input('txt_bankutrn'),
					'tr01_fr_amount'=>floatval($request->input('txt_amount')),
					'tr01_fr_transid'=>'',
					'tr01_fr_des'=>$request->input('txt_description'),
					'tr01_fr_admin_res'=>'',
					'tr01_fr_status'=>1,
					'tr01_fr_toadmin'=>2,
					'm11_user_referral_code'=>$user[0]->ReferralCode,
					'm22_affiliate_id'=>Session::get('AFFILIATE_CODE')
				);
				$fund_request=DB::select('CALL fund_request(				
				:proc,
				:m27_adminbank_id,
				:m11_user_id,
				:tr01_fr_towallet,
				:tr01_fr_mode,
				:tr01_fr_utrno,
				:tr01_fr_amount,
				:tr01_fr_transid,
				:tr01_fr_des,
				:tr01_fr_admin_res,
				:tr01_fr_status,
				:tr01_fr_toadmin,
				:m11_user_referral_code,
				:m22_affiliate_id,
				@status_code,
				@status_msg
				)',$fundreq);
			   $DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
               $DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
			   $ERRMSG=$DB_ERRMSG[0]->ERR_MSG;
               $ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
			}
		}
		$fund_req_toupline=DB::select("SELECT * FROM fund_request WHERE FUNDREQ_TO=2 AND MEMBER_CONTACT=".Session::get('CONTACTNO'));
		Session::flash('type',$ERRCODE );
		Session::flash('message',$ERRMSG );
		
		return view('User.user_fundrequest2upline',compact('user','form_name','fund_req_toupline'));
	}

	
	/**
        * Method name   : user wallet to wallet
        * @description  : Used for transferring wallet to wallet
        * @param        : Request data 
        * @return       : return with transferring wallet to wallet
    */
	public function user_wallettowallet()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'WALLET TO WALLET TRANSFER';
		$request = request();
		$ERRMSG='';
		$ERRCODE='';
	
			if(request()->method() == 'POST')
			{
				if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
					$isError = TRUE;
					$ERRCODE="warning";
				} 
				else if($request->wallet_type=='' || $request->wallet_type==null || ($request->wallet_type!='payout' && $request->wallet_type!='coin'))
				{
					$ERRMSG = "please select wallet type.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))< config('MIN_FUN_TRANSFER'))
				{
					$ERRMSG = "Amount should be greater than ".config('MIN_FUN_TRANSFER')." or not be negative.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount')) > config('MAX_FUND_TRANSFER'))
				{
					$ERRMSG = "Amount should be less than ".config('MAX_FUND_TRANSFER')." or not be negative.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$isError = FALSE;
					$ERRCODE="success";
					 
				}

				if(request()->method() == 'POST'&& $isError==FALSE)
				{
						$from_user='';
						$to_user='';
					
						$from_user=Session()->get('USER_ID');
						$to_user=Session()->get('USER_ID');
						$transfer="TRANSFER";
						$type= 12;
						$se = 'Received';
					
					$fundtransfer_data=array(
					'proc'=> $request->wallet_type == 'coin'?17:16,
					'to_user_id'=>$to_user,
					'from_user_id'=>$from_user,
					'amount'=>floatval($request->input('txt_amount')),
					'collected_amount'=>floatval($request->input('txt_amount')),
					'requesttype'=>1,
					'balfor'=> $request->input('baltype'),
					'transtype'=>1,
					'timelimit'=> (config('FUND_INTERVAL')*60),
					'defaultstatus'=>1,
					'remark'=>$request->input('txt_remark'),
					'collected_remark'=>$request->input('txt_remark')
					);
					// dd($fundtransfer_data);
					//print_r($fundtransfer_data);
					$fundtransfer = $this->fund_repo->walletTransfer($fundtransfer_data);
					$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
					$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
				
					$ERRMSG="Amount ".floatval($request->input('txt_amount'))." transfer to income wallet to fund wallet, Transaction id-". $ERRMSG[0]->ERR_MSG ." .";
					$ERRCODE=$ERRCODE[0]->ERR_CODE;
				   

				}
					Session::flash('message',$ERRMSG);
					Session::flash('type',$ERRCODE);
			}
		
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_wallet2wlttransfer',compact('user','form_name'));
	}

	/**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function user_datewise_business()
	{
		$request = request();
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$descrip="";
		$txt_memberid = Session::get('USER_ID');
	
		$cond="";
		$cond1="";
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
		    $start = date('Y-m-d',strtotime($request->input('txt_from')));
			$end = date('Y-m-d',strtotime($request->input('txt_to')));
			
			if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
			{
				$txt_memberid = Helper::get_userid($request->input('txt_memberid'));
				$res=$this->scan_team($txt_memberid);
				if($res!='true')
				{
					$txt_memberid =Session::get('USER_ID');
				}
			}
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$cond1 = $cond1."DATE_FORMAT(`TOPUP_DATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			} 
			$cond=$cond.$cond1;   
		}
		
		if($_SERVER['REQUEST_METHOD']=="GET")
        {
		$cond=$cond.$cond1;
		}
		$txtuserid =Session::get('USER_ID');
		$cond=$cond." `REG_ID` = $txtuserid  ORDER BY TOPUP_DATE DESC" ;
		$business_report = DB::select("SELECT * FROM datewise_topupdata WHERE ".$cond);
		return view('User.user_topup_datewise', compact('business_report','user'));
	}

	/**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function usertopupdetail()
	{
		$request = request();

		if($_SERVER['REQUEST_METHOD']=="GET")
		{
			$ERRCODE='info';
			$ERRMSG='USER TOP REPORT TEAM ' ;
			$top=array(
			'proc'=>'1',
			'userid'=>Session::get('USER_ID'),
			'fromdate'=>date('Y-m-d',strtotime('2025-01-01')),
			'todate'=>date('Y-m-d',strtotime('2029-01-05')),
			'noofrecords'=>1000,
			'topstatus'=>-1,
			'descrip'=>'m27_pack_type=1 AND `m11_user`.m11_user_id='.Session::get('USER_ID').' AND 1'
			);
			$user_rec = $this->topup_repo->callTopupReport($top);
		}

		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			
			if($request->input('txt_memberid')!="")
			{
				$txtuserid = Helper::get_userid($request->input('txt_memberid'));
				$res=$this->scan_team($txtuserid);
				if($res!='true')
				{
					$txtuserid =Session::get('USER_ID');
				}
				$top=array(
				'proc'=>'1',
				'userid'=>$txtuserid,
				'fromdate'=>date('Y-m-d',strtotime($request->input('fromdate'))),
				'todate'=>date('Y-m-d',strtotime($request->input('todate'))),
				'noofrecords'=>100,
				'topstatus'=>-1,
				'descrip'=>'m27_pack_type=1 AND `m11_user`.m11_user_id='.Session::get('USER_ID').' AND 1'
				);
				
			}
			else
			{
				$txtuserid =Session::get('USER_ID');
				
				$top=array(
				'proc'=>'1',
				'userid'=>$txtuserid,
				'fromdate'=>date('Y-m-d',strtotime($request->input('fromdate'))),
				'todate'=>date('Y-m-d',strtotime($request->input('todate'))),
				'noofrecords'=>100,
				'topstatus'=>-1,
				'descrip'=>'m27_pack_type=1 AND `m11_user`.`m11_user_referral_code`='.$txtuserid.' AND 1'
				);
				$ERRCODE='warning';
				$ERRMSG = "Member should be valid or not blank";
			}
		}

		$user_rec = $this->topup_repo->callTopupReport($top);
		$ERRCODE='success';
		$ERRMSG='USER TOPUP REPORT';
		$package=DB::select("SELECT * FROM `package` WHERE PACKAGE_STATUS=1 AND PACKAGE_TYPE=1");
        $user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_topup_detail',compact('user','user_rec','package'));
	}






	public function transaction_history(Request $request)
	{
	    $from = $request->input('from_date') ?? Carbon::now()->startOfMonth()->toDateString();
	    $to   = $request->input('to_date') ?? Carbon::now()->toDateString();
	    $txnType = $request->input('dd_txn_type'); 
    	$txnId     = $request->input('txt_trans_id');
    	$txnHash     = $request->input('txt_trans_hash');

	    $query = DB::table('coin_buysell_detail');

	    if ($from && $to) {
	        $query->whereBetween('TXN_ONADD', [$from, $to]);
	    } elseif ($from) {
	        $query->whereDate('TXN_ONADD', $from);
	    }

	    if (!empty($txnStatus)) {
	        $query->where('SERVICE_ID', $txnType);
	    }

	    if (!empty($txnId)) {
	        $query->where('TRANS_ID', $txnId);
	    }

	    if (!empty($txnHash)) {
	        $query->where('API_TXNID', $txnId);
	    }

	    $data = $query->where('USER_ID', Session::get('USER_ID'))->get();

	    $total_buy_coin = DB::table('coin_buysell_detail')->where('USER_ID', Session::get('USER_ID'))->where('SERVICE_ID','BUY')->where('TXN_STATUS','SUCCESS')->sum('TXN_COIN_UNIT');
	    $total_sell_coin = DB::table('coin_buysell_detail')->where('USER_ID', Session::get('USER_ID'))->where('SERVICE_ID','SELL')->where('TXN_STATUS','SUCCESS')->sum('TXN_COIN_UNIT');
	    $total_coin = DB::table('coin_buysell_detail')->where('USER_ID', Session::get('USER_ID'))->sum('TXN_COIN_UNIT');

        $user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.transaction_history',compact('user','data','total_buy_coin','total_sell_coin','total_coin'));
	}




/**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function userftopupdetail()
	{
		$request = request();
		if($_SERVER['REQUEST_METHOD']=="GET")
		{
			$ERRCODE='info';
			$ERRMSG='USER TOP REPORT TEAM ' ;
			$top=array(
			'proc'=>'1',
			'userid'=>Session::get('USER_ID'),
			'fromdate'=>date('Y-m-d',strtotime('2020-01-01')),
			'todate'=>date('Y-m-d',strtotime('2029-01-05')),
			'noofrecords'=>1000,
			'topstatus'=>-1,
			'descrip'=>'m27_pack_type=3 AND `m11_user`.m11_user_id='.Session::get('USER_ID').' AND 1'
			);
			$user_rec = $this->topup_repo->callTopupReport($top);
		}

// dd($top);
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			
			if($request->input('txt_memberid')!="")
			{
				$txtuserid = Helper::get_userid($request->input('txt_memberid'));
				$res=$this->scan_team($txtuserid);
				if($res!='true')
				{
					$txtuserid =Session::get('USER_ID');
				}
				$top=array(
				'proc'=>'1',
				'userid'=>$txtuserid,
				'fromdate'=>date('Y-m-d',strtotime($request->input('fromdate'))),
				'todate'=>date('Y-m-d',strtotime($request->input('todate'))),
				'noofrecords'=>100,
				'topstatus'=>-1,
				'descrip'=>'m27_pack_type=3 AND `m11_user`.m11_user_id='.Session::get('USER_ID').' AND 1'
				);
				
			}
			else
			{
				$txtuserid =Session::get('USER_ID');
				
				$top=array(
				'proc'=>'1',
				'userid'=>$txtuserid,
				'fromdate'=>date('Y-m-d',strtotime($request->input('fromdate'))),
				'todate'=>date('Y-m-d',strtotime($request->input('todate'))),
				'noofrecords'=>100,
				'topstatus'=>-1,
				'descrip'=>'m27_pack_type=3 AND `m11_user`.`m11_user_referral_code`='.$txtuserid.' AND 1'
				);
				$ERRCODE='warning';
				$ERRMSG = "Member should be valid or not blank";
			}
		}

		$user_rec = $this->topup_repo->callTopupReport($top);
		$ERRCODE='success';
		$ERRMSG='USER TOPUP REPORT';
		$package=DB::select("SELECT * FROM `package` WHERE PACKAGE_STATUS=1 AND PACKAGE_TYPE=1");
        $user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_ftopup_detail',compact('user','user_rec','package'));
	}

	/**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function usertopup()
	{
		$package=DB::select("SELECT * FROM `package` WHERE PACKAGE_STATUS='ACTIVE'");
        $available_pu =DB::select("SELECT current_phase_availablepu() as `Avail_PU`");
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_topup',compact('user','package','available_pu'));
	}

	/**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function buy_subscription()
	{
		$request = request();
		$descrip="";
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txt_account = '';
		$txt_memberid = '';
		$txt_transid = '';
		$txt_noofrecords = '100';
		$dd_status='-1';
		$cond="";
		$cond1="1";

        if($_SERVER['REQUEST_METHOD']=="POST")
        {

		$package_fees=DB::select("SELECT * FROM `package` WHERE PACKAGE_STATUS=1 AND PACKAGE_TYPE=1");
			if($request->input('txt_referralcode')=="")
            {
                $ERRMSG = "Member Code should be valid";
                $this->isError= TRUE;
                $ERRCODE="warning";
			}
			else if($request->input('dd_wallet')=="" || $request->input('dd_wallet')=="-1")
            {
                $ERRMSG = "Wallet Type should be valid";
                $this->isError= TRUE;
                $ERRCODE="warning";
			}
			//$contactno=explode(' ',$request->input('txt_referralcode'));
			$contactno=$request->input('txt_referralcode');
			/*if(strlen($contactno[0])!=10)
				{
				$ERRMSG = "Member contact number should be equal to 10 digit.";
				$isError = TRUE;
				$ERRCODE="warning";
			}*/
			$user = Helper::get_userid($contactno);
			$wallet_type=$request->input('dd_wallet');
			$user_availbal = Helper::get_user_main_bal(Session::get('USER_CODE'),$wallet_type);
			if(empty($user))
			{
				$ERRMSG = "Member should be valid";
				$isError = TRUE;
				$ERRCODE="warning";
			}
			else if(floatval($user_availbal)=="" || floatval($user_availbal)==0.00 || floatval($user_availbal)< floatval($request->input('txt_packageamt')) )
            {
                $ERRMSG = "Available Balance not valid.Your available balance:-".$user_availbal;
                $this->isError= TRUE;
                $ERRCODE="warning";
			}
			else if($request->input('dd_user_forwallet')=="" || $request->input('dd_user_forwallet')=='-1' )
            {
                $ERRMSG = "Please select user for wallet deduction.";
                $this->isError= TRUE;
                $ERRCODE="warning";
			}
			/*else if((floatval($request->input('txt_balance'))=="" || (floatval($request->input('txt_balance'))<0.00) ) )
				{
                $ERRMSG = "Member balance should be valid";
                $this->isError= TRUE;
                $ERRCODE="warning";
			}*/
			else if($request->input('dd_package')=="" || $request->input('dd_package')==-1 )
                {
                    $ERRMSG = "Package should be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
				else if(floatval($request->input('txt_packageamt'))=="" || floatval($request->input('txt_packageamt'))==0.00 )
                {
                    $ERRMSG = "Package amount be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
				else if($request->input('dd_package')==1 && floatval($request->input('txt_packageamt'))<$package_fees[0]->PACKAGE_FEE)
                {
                    $ERRMSG = "Package amount should be valid or ".$package_fees[0]->PACKAGE_FEE;
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
				else if(floatval($request->input('txt_packageamt'))>$package_fees[0]->PACKAGE_FEE && floatval($request->input('txt_packageamt')%$package_fees[0]->PACKAGE_FEE)!=0.00 )
                {
                    $ERRMSG = "Package amount should be multiple of ".$package_fees[0]->PACKAGE_FEE;
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
	
				else if($request->input('txt_remark')=="")
                {
                    $ERRMSG = "Remark should be valid and not blank";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
			
		else
		{
		$ERRMSG = "";
                $this->isError= FALSE;
                $ERRCODE="success";
			}
		}
		if(request()->method() == 'POST' && $this->isError==FALSE)
                {
					$topup=array(
					  	'proc'=>1,
						'txt_userid'=>$request->input('txt_referralcode'),
						'dd_package'=>$request->input('dd_package'),
						'package_amt'=>$request->input('txt_packageamt'),
						'dd_user_forwallet'=>$request->input('dd_user_forwallet'),
						'dd_wallet'=>1,
						'txt_remark'=>$request->input('txt_remark'),
						'dd_mode'=>1
					);
                 
				  $topup_report = DB::select('CALL topup(:proc,:txt_userid,:dd_package,:package_amt,:dd_user_forwallet,:dd_wallet,:txt_remark,:dd_mode,@status_code,@status_msg)',$topup);
				  $DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
                  $DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
				  $ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
				  $ERRMSG=$DB_ERRMSG[0]->ERR_MSG;

				  $pack_amt = $request->input('txt_packageamt');

				  if( $DB_ERRCODE[0]->ERR_CODE=="success")
				  {
				  	$intro_id=Helper::get_introid(Session::get('USER_CODE'));

				  	$this->update_directbusiness($intro_id);
					$no = rand(100000,999999);
					$bill_no = 'INID'.$no;

					$arr = array(
						'm53_bill_no' => $bill_no,
						'm11_user_id' => $user,
						'm53_description' => 'Topup Amount Accepted',
						'm53_pack_id' => $request->input('dd_package'),
						'm53_pay_mode' => 1,
						'm53_sgst' => 0,
						'm53_cgst' => 0,
						'm53_igst' => 0,
						'm53_amt_before_tax' => 0,
						'm53_tax_amt' => 0,
						'm53_total_amt' => $pack_amt,
						'm53_bill_type' => 1,
						'm53_bill_status' => 1
					);
					DB::table('m53_bill_invoice')->insert($arr);

					//$this->send_sms($user_detail[0]->MemberContactNo,$DB_ERRMSG[0]->ERR_MSG);

				  }
			
			}
		Session::flash('type',$ERRCODE );
		Session::flash('message',$ERRMSG );
		return redirect('user_topup'); 
	}

	/**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function refferalcenter()
	{
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_refferal_center',compact('user'));
	}

	/**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
	public function payu_view()
	{
		$ERRMSG='SUCCESS';
		$ERRCODE='NW214626';
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_payu_payment',compact('user','ERRCODE','ERRMSG')); 
	}


	/**
        * Method name   : Create Ticket
        * @description  : Used for getting user queries
        * @param        : Request data 
        * @return       : return with user queries
    */
    public function get_user_submit_query()
    {
    	$user = Helper::get_userdetail(Session::get('USER_ID'));
    	$tickets = $this->ticket_repo->getByUserId($user[0]->RegId);
    	return view('User.create_submit_query', compact('user', 'tickets'));
    }




	public function view_help_desk($id, request $request)
	{
		$data['ticket'] = $this->ticket_repo->getById($id);
        $data['reply'] = $this->ticket_repo->GetByTicketId($id);
        $data['users'] = $this->enroll_repo->getByIdE($data['ticket'][0]->USER_ID);
        $data['single_emp']  = $this->emp_repo->getById($data['ticket'][0]->EMP_ID);
        $data['emp']  = $this->emp_repo->getActiveEmployee();
		$user = Helper::get_userdetail(Session::get('USER_ID'));
            // dd($data);
		return view('User.view-help-desk', compact('data','user'));
	}




	/**
        * Method name   : filter Ticket Reply
        * @description  : Used for ticket reply
        * @param        : Request data
        * @return       : return with ticket reply
    */
    public function filter_ticket_reply(request $request)
    {
        $users = $this->enroll_repo->getActiveUser();
		$urgency = '';
		$transid = '';
		$ticket_id = '';
		$ticket_type = '';
		$formdate = '';
		$todate = '';
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		if($request->dd_urgency != null)
		{
			$urgency = " AND URGENCY = ".$request->dd_urgency;
		}
		if($request->txt_transid != null)
		{	
			$user = $this->enroll_repo->getUserByUserCode($request->txt_transid);
			if(count($user) > 0)
			{
				$transid = " AND USER_ID = ".$user[0]->RegId;
			}
			else
			{
				$transid = '';
			}
		}
		if($request->txt_ticket != null)
		{
			$ticket_id = " AND TICKET_NO = '".$request->txt_ticket."' ";
		}
		if($request->dd_ticket != null)
		{
			$ticket_type = " AND TICKET_FOR = ".$request->dd_ticket;
		}
		if($request->txtfromdate != null && $request->txttodate != null)
		{
			$formdate = " AND CREATED_AT BETWEEN ".$request->txtfromdate." AND ".$request->txttodate;
		}
		if($request->txttodate != null && $request->txtfromdate == null)
		{
			$formdate =  " AND CREATED_AT = ".$request->txttodate;
		}
		if($request->txttodate == null && $request->txtfromdate != null)
		{
			$formdate =  " AND CREATED_AT = ".$request->txttodate;
		}

	   $tickets =  DB::select("SELECT * FROM `ticket` WHERE USER_ID = ".session()->get('USER_ID') . $urgency . $transid . $ticket_id . $formdate .  $todate . $ticket_type . "  AND STATUS =  '".$request->txt_status."' ");
        return view('User.submit_query', compact('user', 'tickets'));
    }





	/**
        * Method name   : Get Query
        * @description  : Used for getting user queries
        * @param        : Request data 
        * @return       : return with user queries
    */
    public function get_query()
    {
    	$user = Helper::get_userdetail(Session::get('USER_ID'));
    	$tickets = $this->ticket_repo->getByUserId($user[0]->RegId);
    	return view('User.submit_query', compact('user', 'tickets'));
    }



	/**
        * Method name   : Get Close Query
        * @description  : Used for getting user queries
        * @param        : Request data 
        * @return       : return with user queries
    */
    public function view_close_ticket()
    {
    	$user = Helper::get_userdetail(Session::get('USER_ID'));
    	$tickets = $this->ticket_repo->getByUserIdIn($user[0]->RegId);
    	return view('User.submit_query', compact('user', 'tickets'));
    }


    /**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
    public function submit_query()
    {
    	$request = request();
    	$user = Helper::get_userdetail(Session::get('USER_ID'));

	    $this->validate($request, [
        'file_image' => 'nullable|max:10240',
        'txt_title' => 'required|max:255',
        'txt_msg' => 'required',
        'txt_urgency' => 'required',
         ]); 

		if($request->hasFile('file_image'))
        {
            $image = $request->file('file_image');
            $image_name = Session::get('USER_CODE').'_TICKET_'.time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/ticket_file/');
			$FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $image_name);
			}
			else{
				$request_data=json_encode($request->all());
				$file_type=$image->getClientOriginalName();
				$user_id=Session::get('USER_ID');
				$server_info=json_encode(request()->server());
				$user_info=json_encode($user);
				$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);
				return back()->with('error', 'File format not supported.'); 
			}
        }
        else
        {
            $image_name = '';
        }

        $ref_no = 'SUPP'.rand(10000000,99999999);

    	$arr = array(
    		'm46_ref_no' =>  $ref_no,
    		'm11_user_id' => Session::get('USER_ID'),
    		'm46_ticket_for' => 1,
    		'm46_ticket_subject' => $request->input('txt_title'),
    		'm46_ticket_content' => $request->input('txt_msg'),
    		'M46_urgency' => $request->input('txt_urgency'),
    		'm46_status' => 1
    	);

 		$submit = $this->ticket_repo->create($arr); 

		if($submit){

    	$tik_no = DB::table('m46_ticket')->where('m46_ref_no',  $ref_no)->select('m46_ref_no','m46_ticket_id')->first();
    

    	$arr1 = array(
    		'tr34_tkt_id' =>  $tik_no->m46_ticket_id,
    		'tr34_description' => $request->input('txt_msg'),
    		'tr34_response_type' => 1,
    		'tr34_response_by' => Session::get('USER_ID'),
    		'tr34_userfile' => $image_name,
    		'tr34_status' => 1
    	);

    	$submit1 = $this->ticket_repo->create_reply($arr1); 

					$template_type = 1;
					if($image_name == '')
					{ 
						$data['MSG_CONTENT'] = 	$request->input('txt_msg'); 
					}
					else
					{
						$data['MSG_CONTENT'] = 	$request->input('txt_msg').'<br><a href="'.url('images/ticket_file/'.$image_name).'">Attachment File </a>';
					}
					$data['MSG_SUBJECT'] = $request->input('txt_title');
					$data['pdf']=''; 
					$data['template_name']='email';
					
					$emails = array($user[0]->MemberEmail , config('GMAIL_ID'));
					$data['useremail']=json_encode($emails);

					$template_data = $data;

					//Mail::to($emails)->send(new SendMail($template_data, $template_type));


    	if($submit1)
    	{
    		return redirect('/submit_query')->with('success','Ticket Create Successfully');
    	}
    	else
    	{
    		return back()->with('error', 'Message Not Sent'); 
    	}
       
    	}
    	else
    	{
    		return back()->with('error', 'Message Not Sent'); 
    	}
    }


   /**
        * Method name   : Submit Reply
        * @description  : Used for submit ticket reply
        * @param        : Request data
        * @return       : return with submit ticket reply
    */
    public function submit_reply()
    {
        $request = request();
        $user = Helper::get_userdetail($request->input('txt_id'));
		
		$this->validate($request, [
				'txt_ticket_id'=> 'required',
				'txt_content'=> 'required|max:1500|min:10',
				'file_image' => 'nullable|max:10240',
			],
			[
				'txt_ticket_id.required'=> 'Ticket ID is required',
				'txt_content.required'=> 'Comment is required',
				'txt_content.max'=> 'Comment Max 1500 characters',
				'txt_content.min'=> 'Comment Min 10  characters',
				'file_image.max'=> 'Image Max 2 MB',
			]);

       if($request->hasFile('file_image'))
        {
            $image = $request->file('file_image');
            $image_name = Session::get('USER_CODE').'_TICKETREPLY_'.time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/ticket_file/');
			$FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $image_name);
			}
			else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=$request->input('txt_id');
					$server_info=json_encode(request()->server());
					$user_info=json_encode($user);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
			}
        }
        else
        {
            $image_name = '';
        }


        $arr = array(
            'tr34_tkt_id' => $request->input('txt_ticket_id'),
            'tr34_description' =>  $request->input('txt_content'),
            'tr34_response_type' => 1,
            'tr34_response_by' => Session()->get('USER_ID'),
            'tr34_userfile' =>  $image_name,
            'tr34_status' => 1
        );
  
        $tickData = $this->ticket_repo->getById($request->input('txt_ticket_id'));

        $datas = $this->ticket_repo->create_reply($arr);

        if($datas)
        {
            $template_type = 1;
            if($image_name == '')
            { 
                $data['MSG_CONTENT'] =  $request->input('txt_content'); 
            }
            else
            {
                $data['MSG_CONTENT'] =  $request->input('txt_content').'<br><a href="'.url('images/ticket_file/'.$image_name).'">Attachment File </a>';
            }
            $data['MSG_SUBJECT'] = $tickData[0]->SUBJECT;
            $data['pdf']=''; 
            $data['template_name']='email';
            $emails = $user[0]->MemberEmail;
			$data['useremail']=json_encode($emails);
            $template_data = $data;

           // Mail::to($emails)->send(new SendMail($template_data, $template_type));

            return back()->with('success','Message Send Successfully');
        }
        else
        {
            return back()->with('error', 'Message Not Send'); 
        }
    }

	/**
        * Method name   : Fund Request
        * @description  : Used for getting all fund request
        * @param        : Request data  
        * @return       : return with all fund request
    */
	public function view_fund_request()
	{
		$page = "";
		$form_name = "";
		$user = Helper::get_userdetail(session()->get('USER_ID'));
		$fund_req_toadmin = $this->fund_repo->getByAdminId(session()->get('USER_ID'));
		return view('User.view-fund-request', compact('page', 'form_name','fund_req_toadmin', 'user'));
	}




	    /**
        * Method name   : Fund Request Update Status
        * @description  : Used for updating fund request status
        * @param        : Request data  
        * @return       : return with updated fund request status
    */
    public function user_fundrequest_updatestatus()
	{
    	$request = request();
	    $ERRMSG='FUND TRANSFER HERE';
		$ERRCODE='info';
		$isError = FALSE;
		$transfer="";


			if(request()->method() == 'POST')
			{
				if($request->input('txt_mobileno')=='')
				{
					$ERRMSG = "Member contact number should be valid or not blank.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				/*else if(!_valid_phone_number($request->input('txt_mobileno')))
				{
					$ERRMSG = "";
					$isError = TRUE;
				}*/
				$contactno=explode(' ',$request->input('txt_mobileno'));
				//dd($contactno[0]);
				if(strlen($contactno[0])!=10)
				{
					$ERRMSG = "Member contact number should be equal to 10 digit.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				$user = Helper::get_userid($request->input('txt_membercode'));

				$AFCODE = DB::table('m22_affiliate')->where('m22_affiliate_id', session()->get('AFFILIATE_CODE'))->first();
				if(empty($user))
				{
					$ERRMSG = "Member should be valid";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if(Session::get('USER_ID')==$user)
				{
					$ERRMSG = "Same account has not been transferable.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))<0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be negative.";
					$isError = TRUE;
					$ERRCODE="warning";
				}              
				else if($AFCODE ==  null)
				{
				    $ERRMSG = "Affiliate Not Found.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
			 else if($AFCODE->m11_user_id !=  session()->get('USER_ID'))
				{
				    $ERRMSG = "Affiliate Not Found..";
					$isError = TRUE;
					$ERRCODE="warning";
				}

				if(request()->method() == 'POST' && $isError==FALSE)
				{
					$fund_reqstatus=$request->input('txt_status');
					$transid="";

					if($fund_reqstatus=="APPROVED")
					{
						$fundtransfer_data=array(
						'proc'=>1,
						'to_user_id'=>$user,
						'from_user_id'=> $AFCODE->m11_user_id,
						'amount'=>floatval($request->input('txt_amount')),
						'collected_amount'=>floatval($request->input('txt_amount')),
						'requesttype'=>1,
						'balfor'=>$request->input('txt_baltype'),
						'transtype'=>1,
						'timelimit'=>(config('FUND_INTERVAL')*60),
						'defaultstatus'=>1,
						'remark'=>$request->input('txt_adminreply'),
						'collected_remark'=>$request->input('txt_adminreply')
						);
						$fundtransfer = $this->fund_repo->walletTransfer($fundtransfer_data);
						$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
						$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
						$transid=$ERRMSG[0]->ERR_MSG;
						$ERRMSGS="Fund Request Approved You Have Received Recharge Amount Of Rs ".floatval($request->input('txt_amount'))." From Sender  ".Session::get('NAME'). " With Txn ID , Transaction id-". $ERRMSG[0]->ERR_MSG ." ";
						$ERRMSG="Amount ".floatval($request->input('txt_amount'))." ".$transfer. " to ".$contactno[0].", Transaction id-". $ERRMSG[0]->ERR_MSG ." .";
						$ERRCODE=$ERRCODE[0]->ERR_CODE;
						$REQID=$request->input('txt_fundrequestid');
						if($ERRCODE == 'success')
						{
							$user_group=DB::select("UPDATE `tr01_fund_req` SET `tr01_fr_transid`= '".$transid."',`tr01_fr_status`= '".$request->input('txt_status')."',`tr01_fr_admin_res` ='".$request->input('txt_adminreply')."' WHERE `tr01_fr_id` ='".$request->input('txt_fundrequestid')."' AND `m11_user_id`=".$user."");
							
							// SMS SEND OR INSERT
							$sms_data['MOBILE_NO'] = $contactno[0];
							$sms_data['SUBJECT'] = 'Fund Approved';
							$sms_data['MESSAGE'] = $ERRMSGS;
							$sms_data['TYPE'] = 8;
							$sms_data['SEND_BY'] = 2;
							$sms_data['SEND_BY_ID'] = Session()->get('USER_ID');
							Helper::send_sms_or_log($sms_data);
							//SMS SEND END 
						}							
						else
						{
								$user_group=DB::select("UPDATE `tr01_fund_req` SET `tr01_fr_transid`= '".$transid."',`tr01_fr_admin_res` ='".$request->input('txt_adminreply')."' WHERE `tr01_fr_id` ='".$request->input('txt_fundrequestid')."' AND `m11_user_id`=".$user."");
						}

					}
					if($fund_reqstatus=="CANCELED")
					{
						$ERRCODE="success";
						$ERRMSG="USERS FUND REQUEST HAS BEEN ". $fund_reqstatus." SUCCESSFULLY!";
						$ERRMSGS="Fund Request Canceled ";
						$REQID=$request->input('txt_fundrequestid');
						if($ERRCODE == 'success')
							{
								$user_group=DB::select("UPDATE `tr01_fund_req` SET `tr01_fr_transid`= '".$transid."',`tr01_fr_status`= '".$request->input('txt_status')."',`tr01_fr_admin_res` ='".$request->input('txt_adminreply')."' WHERE `tr01_fr_id` ='".$request->input('txt_fundrequestid')."' AND `m11_user_id`=".$user."");
								// SMS SEND OR INSERT
								$sms_data['MOBILE_NO'] = $contactno[0];
								$sms_data['SUBJECT'] = 'Fund Request Canceled';
								$sms_data['MESSAGE'] = $ERRMSGS;
								$sms_data['TYPE'] = 15;
								$sms_data['SEND_BY'] = 2;
								$sms_data['SEND_BY_ID'] = Session()->get('USER_ID');
								Helper::send_sms_or_log($sms_data);
								//SMS SEND END 
							}
					}

					$group_actionrecord=DB::select("INSERT INTO tr11_actionrecord (tr11_ar_tblnm,tr11_ar_old_value,tr11_ar_new_value,tr11_ar_uid,tr11_ar_description) VALUES ('tr01_fund_req','PENDING-FUND REQUEEST ID $REQID','$fund_reqstatus-FUND REQUEEST ID $REQID','$user','USERS FUND REQUEST HAS BEEN $fund_reqstatus SUCCESSFULLY!')");
					
				}
			}
		Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);
		$fund_req_toadmin=DB::select("SELECT * FROM fund_request WHERE FUNDREQ_TO=1");
		$user = Helper::get_userdetail(session()->get('USER_ID'));
		return redirect('view-fund-request');
		//return view('Fund.fund_request', compact('fund_req_toadmin','user'));
	}




    /**
        * Method name   : Fund Transfer
        * @description  : Used for fund transfer
        * @param        : Request data  
        * @return       : return with fund transfer response
    */
    public function fund_transfer()
    {
		$page = "";
		$form_name = "";
		$request = request();
		$isError = FALSE;
		$transfer="";
			if(request()->method() == 'POST')
			{
				if($request->input('ladger')=="")
				{
					$ERRMSG = "Ledger should be valid.Please Select Ledger Type ";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('idstype')=="")
				{
					$ERRMSG = "ID  Type should be valid.Please Select ID  Type ";
					$isError = TRUE;
					$ERRCODE="warning";
				}		
				else if($request->input('baltype')=="")
				{
					$ERRMSG = "Balance type should be valid.Please Select Balance Type ";
					$isError = TRUE;
					$ERRCODE="warning";
				}	
				else if($request->input('idstype') == 2 && $request->input('txt_mobileno')=='')
				{
						$ERRMSG = "Member contact number should be valid or not blank.";
						$isError = TRUE;
						$ERRCODE="warning";
				}
				else if($request->input('idstype') == 2 && !Helper::_valid_phone_number($request->input('txt_mobileno')))
				{
						$ERRMSG = "";
						$isError = TRUE;
				}
				else if($request->input('idstype') == 2 && strlen($request->input('txt_mobileno'))!=10)
				{
					  $ERRMSG = "Member contact number should be equal to 10 digit.";
					  $isError = TRUE;
					  $ERRCODE="warning";
				}
				else if($request->input('idstype') == 1 && $request->input('txt_memberid')=='')
				{
								$ERRMSG = "Member id should be valid or not blank.";
								$isError = TRUE;
								$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))< config('MIN_FUN_TRANSFER'))
				{
					$ERRMSG = "Amount should be greater than ".config('MIN_FUN_TRANSFER')." or not be negative.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount')) > config('MAX_FUND_TRANSFER'))
				{
					$ERRMSG = "Amount should be less than ".config('MAX_FUND_TRANSFER')." or not be negative.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "XCDFF";
					$isError=FALSE;
					$ERRCODE="success";
					if($request->input('idstype') == 2)
					{
					$user = Helper::get_userid_by_mobile($request->input('txt_mobileno'));
					$user_data = Helper::get_userdetail($user);
					}
					if($request->input('idstype') == 1)
					{
					$user = Helper::get_userid($request->input('txt_memberid'));
					$user_data = Helper::get_userdetail($user);
					}
					 if(empty($user))
					{
						$ERRMSG = "Member should be valid";
						$isError = TRUE;
						$ERRCODE="warning";
						$res="false";
					}
					else
					{
						$isError=FALSE;
						//$res=$this->scan_team($user);
					}
					// if($res == "false")
					// {
					// 	$ERRMSG = "Not a member of your team.";
					// 	$isError = TRUE;
					// 	$ERRCODE="warning";
					// }
					if(Session::get('USER_ID')==$user)
					{
						$ERRMSG = "Same account has not been transferable.";
						$isError = TRUE;
						$ERRCODE="warning";
					}
				}

				if(request()->method() == 'POST'&& $isError==FALSE)
				{
						$from_user='';
						$to_user='';
					if($request->input('ladger')==1)
					{
						$from_user=Session()->get('USER_ID');
						$to_user=$user;
						$transfer="TRANSFER";
						$type= 6;
						$se = 'Received';
					}
					if($request->input('ladger')==6)
					{
						$from_user=$user;
						$to_user=Session()->get('USER_ID');
						$transfer="DEDUCT";
						$se = 'Deducted';
						$type= 7;
					}
					$fundtransfer_data=array(
					'proc'=>$request->input('ladger'),
					'to_user_id'=>$to_user,
					'from_user_id'=>$from_user,
					'amount'=>floatval($request->input('txt_amount')),
					'collected_amount'=>floatval($request->input('txt_cashcolledted')),
					'requesttype'=>1,
					'balfor'=>$request->input('baltype'),
					'transtype'=>1,
					'timelimit'=> (config('FUND_INTERVAL')*60),
					'defaultstatus'=>1,
					'remark'=>$request->input('txt_remark'),
					'collected_remark'=>$request->input('txt_remark')
					);
					$fundtransfer = $this->fund_repo->walletTransfer($fundtransfer_data);
					$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
					$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
					$ERRMSGS="Dear ".$user_data[0]->MemberName."  You Have ".$se." Recharge Amount Of Rs ".floatval($request->input('txt_amount'))." From Sender  ".Session::get('NAME'). " With Transaction id-". $ERRMSG[0]->ERR_MSG ." ";
					$ERRMSG="Amount ".floatval($request->input('txt_amount'))." ".$transfer. " to ".$user_data[0]->RegCode.", Transaction id-". $ERRMSG[0]->ERR_MSG ." .";
					$ERRCODE=$ERRCODE[0]->ERR_CODE;
				    $FT_data1=Helper::notify_data($request,1,"FUND".$transfer." BY ADMIN",$ERRMSG,0,'2');

					if($ERRCODE == 'success')
					{
						// SMS SEND OR INSERT
						$sms_data['MOBILE_NO'] = $user_data[0]->MemberContactNo;
						$sms_data['SUBJECT'] = 'Fund '.$transfer.' ';
						$sms_data['MESSAGE'] = $ERRMSGS;
						$sms_data['TYPE'] = $type;
						$sms_data['SEND_BY'] = 2;
						$sms_data['SEND_BY_ID'] = Session()->get('USER_ID');
						Helper::send_sms_or_log($sms_data);
						//SMS SEND END 
					}

				}
					Session::flash('message',$ERRMSG);
					Session::flash('type',$ERRCODE);
			}
				$user = Helper::get_userdetail(session()->get('USER_ID'));
				$fund_t	= $this->fund_repo->GetTransferById(session()->get('USER_ID')); 
    	return view('User.fund_transfer', compact('page', 'form_name', 'user','fund_t'));
    }

	/**
        * Method name   : user prepaid margin
        * @description  : Used for user prepaid margin
        * @param        : Request data 
        * @return       : return with user prepaid margin
    */
	public function user_prepaidmargin()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'PREPAID MARGIN';
		$request = request();
		$slabmargin=array(
		'proc'=>10,
		'userid'=>Session::get('GROUP_ID'),
		'telecombrandid'=>1,
		'desig'=>'',
		'apiid'=>'' 
		);
        $slab_margin=DB::select('CALL slab_margin(				
		:proc,
		:userid,
		:telecombrandid,
		:desig,
		:apiid,
		@msg
		)',$slabmargin);
		$ERRMSG=DB::select('SELECT @msg as ERR_MSG');
		//dd($slabmargin);
		Session::flash('message','PREPAID MARGIN' );
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_prepaidmargin',compact('user','slab_margin'));
	}

	/**
        * Method name   : user utility surcharge
        * @description  : Used for user utility surcharge
        * @param        : Request data 
        * @return       : return with user utility surcharge
    */
	public function user_utilitysurcharge()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'UTILITY SURCHARGE';
		$request = request();
		$slabmargin=array(
		'proc'=>14,
		'userid'=>Session::get('GROUP_ID'),
		'telecombrandid'=>-1,
		'desig'=>'',
		'apiid'=>'' 
		);
        $slab_margin=DB::select('CALL slab_margin(				
		:proc,
		:userid,
		:telecombrandid,
		:desig,
		:apiid,
		@msg
		)',$slabmargin);
		Session::flash('type','info' );
		Session::flash('message','UTILITY SURCHARGE' );
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_utilitysurcharge',compact('user','slab_margin'));
	}

	/**
        * Method name   : user dmr surcharge
        * @description  : Used for user dmr surcharge
        * @param        : Request data 
        * @return       : return with user dmr surcharge
    */
	public function user_dmrsurcharge()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'DMR SURCHARGE';
		$request = request();
		$slabmargin=array(
		'proc'=>9,
		'userid'=>Session::get('GROUP_ID'),
		'telecombrandid'=>1,
		'desig'=>'',
		'apiid'=>'' 
		);
        $slab_margin=DB::select('CALL slab_margin(				
		:proc,
		:userid,
		:telecombrandid,
		:desig,
		:apiid,
		@msg
		)',$slabmargin);
		Session::flash('type','info' );
		Session::flash('message','DMR SURCHARGE' );
		//dd($slab_margin);
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_dmrsurcharge',compact('user','slab_margin'));
	}


	/**
        * Method name   : user manage settings
        * @description  : Used for managing user settings
        * @param        : Request data
        * @return       : return with updated settings
    */
	public function user_manage_settings($id='')
	{
		$status = '';
		$config = $this->wlconfig_repo->getByAffid(Session::get('AFFILIATE_CODE'));
		$singleconfig = '';
		Session::flash('type','info' );
		Session::flash('message','MANAGE SITE CONFIGURATION' );
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		if( $id != '')
		{
			$singleconfig = $this->wlconfig_repo->getById($id, Session::get('AFFILIATE_CODE'));
			return view('User.user_config', compact('user','config','singleconfig'));
		}
		else
		{
			//dd($user,$config,$singleconfig);
			return view('User.user_config', compact('user','config','singleconfig'));
		}
	}

	/**
        * Method name   : update site config
        * @description  : Used for update site config
        * @param        : Request data
        * @return       : return with updated site config
    */
	public function update_siteconfig($id)
	{
		$request = request();
		$arr = array(
        	'm00_name' => $request->input('txt_name'),
        	'm00_value' => $request->input('txt_value'),
        	'm00_desc' => $request->input('txt_desc')
		);
		$this->wlconfig_repo->updateWithId($id, Session::get('AFFILIATE_CODE'), $arr);
		Session::flash( 'message', "Updated Succesfully" );
		return redirect('user_manage_settings/'. $id); 
	}

	/**
        * Method name   : update site image
        * @description  : Used for updating site image
        * @param        : Request data
        * @return       : return with updated site image
    */
	public function update_siteimage($name)
	{
		$request = request();
		$name1 = '';

		if( $_FILES['txt_value']['name'] != '' && isset($_POST['txt_site_logo'])){
			$image = $request->file('txt_value');
			$name1 = time().'.'.$image->getClientOriginalExtension();
			$destinationPath = public_path('/images/config/logo/');
			$image->move($destinationPath, $name1);
			$thumbnailpath = public_path('/images/config/logo/'.$name1);
			$FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$img = Image::make($thumbnailpath)->resize(150, 150, function($constraint) {
					$constraint->aspectRatio();
				});
				$img->save($thumbnailpath); 
			}
			else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=Session::get('AFFILIATE_CODE');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
		}
		if( $_FILES['txt_value']['name'] != '' &&  isset($_POST['txt_site_bg']) ){
			$image = $request->file('txt_value');  
			$name1 = time().'.'.$image->getClientOriginalExtension();
			$destinationPath = public_path('/images/config/bg/');
			$image->move($destinationPath, $name1);
			$thumbnailpath = public_path('/images/config/bg/'.$name1);
			$FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$img = Image::make($thumbnailpath)->resize(1440,800, function($constraint) {
					$constraint->aspectRatio();
				});
				$img->save($thumbnailpath); 
			}
			else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=Session::get('AFFILIATE_CODE');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
		}
		if( $request->file('txt_value') == '' &&  isset($_POST['txt_site_bg']) ){
			$name1 = $_POST['txt_bg_image'];
		}
		
		$arr_bg = array(
        'm00_value' => $name1
		);
		$arr_btn_color = array(
        'm00_value' => $request->input('txt_btn_color')
		);
		$arr_btn_bg = array(
        'm00_value' =>  $request->input('txt_btn_bg')
		);
		
		$this->wlconfig_repo->updateWithName($name, Session::get('AFFILIATE_CODE'), $arr_bg);

		if($request->input('btn_bg')!=null)
		{
			$this->wlconfig_repo->updateWithName('SITE_BTN_BG', Session::get('AFFILIATE_CODE'), $arr_btn_bg);
		}
		Session::flash('type','info' );
		Session::flash( 'message', "Updated Succesfully" );
		return redirect('user_manage_settings'); 
	}

	/**
        * Method name   : bank account
        * @description  : Used for getting bank account details
        * @param        : Request data
        * @return       : return with updated site image
    */
	public function bank_account($id='')
	{
        $singlebank = '';
        $SB_CA ="";
		Session::flash('message','MANAGE BANK ACCOUNT' );
		Session::flash('type','info' );
		$bank = $this->bank_repo->getAll();
        if( $id != '' ){
            $SB_CA = $this->admin_bank_repo->getById($id);
        }
        $company_bank_account = $this->admin_bank_repo->getByUserId(Session::get('AFFILIATE_CODE'));

		$user = Helper::get_userdetail(Session::get('USER_ID'));
		
        return view('User.view_bank_account', compact('bank','company_bank_account','user','SB_CA'));
    }
    
    /**
        * Method name   : add bank account
        * @description  : Used for adding bank account details
        * @param        : Request data
        * @return       : return with added bank account details
    */
	public function add_bank_account()
	{
		$singlebank = '';
        $page = 'MASTER PANEL';
        $form_name = 'MANAGE BANK ACCOUNT';
        $SB_CA = "";
		$request = request();


		if($_SERVER['REQUEST_METHOD']=="POST")
		{
           if( $_FILES['txt_banklogo']['name'] != ''){
                $image = $request->file('txt_banklogo');
                $name1 = Session::get('USER_CODE').'_BANK_'.time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/images/bank_logo/');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
					$image->move($destinationPath, $name1);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=Session::get('AFFILIATE_CODE');
					$server_info=json_encode(request()->server());
					$user_info=json_encode($user);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
                $txt_image=$name1;
            }
            else
            {
                $txt_image=$request->input('txt_banklogohd');
            }
		    $arr = array(
				'm01_bank_id'=>$request->input('dd_bank'),
				'm11_user_id'=> Session::get('AFFILIATE_CODE'),
				'm27_adminbank_displayname' => $request->input('txt_name_atbank_account'),
				'm27_adminbank_branch'=>$request->input('txt_bank_branch'),
				'm27_adminbank_accountno'=>$request->input('txt_bank_account_no'),
				'm27_adminbank_type'=>$request->input('dd_bank_account_type'),
                'm27_adminbank_ifscode'=>$request->input('txt_bank_ifsc'),
                'm27_adminbank_logo'=>$txt_image,
				'm27_adminbank_status'=>$request->input('dd_bank_account_status'),
				'm27_adminbank_createdat'=>date('Y-m-d H:i:s')
			);
			$this->admin_bank_repo->create($arr);
		}
		$bank = $this->bank_repo->getAll();
		$company_bank_account = $this->admin_bank_repo->getByUserId(Session::get('AFFILIATE_CODE'));
		Session::flash('message','ADD ADMIN BANK ACCOUNT' );
		Session::flash('type','info' );
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        $SB_CA = "";
        return view('User.view_bank_account', compact('page', 'form_name','bank','company_bank_account','SB_CA','user'));
	}

	/**
        * Method name   : update bank account
        * @description  : Used for updating bank account details
        * @param        : Request data
        * @return       : return with updated bank account details
    */
    public function update_bank_account($id){
	    $singlebank = '';
        $page = 'Master Panel';
        $form_name = 'MANAGE BANK ACCOUNT';
        $request = request();
        $SB_CA ="";

		if($_SERVER['REQUEST_METHOD']=="POST")
		{
            if( $_FILES['txt_banklogo']['name'] != ''){
                $image = $request->file('txt_banklogo');
                $name1 = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/images/bank_logo/');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
					 $image->move($destinationPath, $name1);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=Session::get('AFFILIATE_CODE');
					$server_info=json_encode(request()->server());
					$user_info=json_encode($user);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
                $txt_image=$name1;
            }
            else
            {
                $txt_image=$request->input('txt_banklogohd');
            }
			$arr = array(
				'm01_bank_id'=>$request->input('dd_bank'),
				'm11_user_id'=> Session::get('AFFILIATE_CODE'),
				'm27_adminbank_displayname' => $request->input('txt_name_atbank_account'),
				'm27_adminbank_branch'=>$request->input('txt_bank_branch'),
				'm27_adminbank_accountno'=>$request->input('txt_bank_account_no'),
				'm27_adminbank_type'=>$request->input('dd_bank_account_type'),
                'm27_adminbank_ifscode'=>$request->input('txt_bank_ifsc'),
                'm27_adminbank_logo'=>$txt_image,
				'm27_adminbank_status'=>$request->input('dd_bank_account_status')
			);

            $this->admin_bank_repo->update($id,$arr);
			Session::flash('message','BANK ACCOUNT UPDATED SUCCESSFULLY' );
			Session::flash('type','success' );
		}
        
       	if( $id != '' ){
            $SB_CA = $this->admin_bank_repo->getById($id);
        }
        $user = Helper::get_userdetail(Session::get('USER_ID'));
		$bank =  $this->bank_repo->getAll();
		$company_bank_account = $this->admin_bank_repo->getByUserId(Session::get('AFFILIATE_CODE'));
        return view('User.view_bank_account', compact('page', 'form_name','bank','company_bank_account','user'));
    }
	
	/**
        * Method name   : bank account status
        * @description  : Used for updating bank account status
        * @param        : Request data
        * @return       : return with updated bank account status
    */
	public function bank_account_status()
    {
        $page = 'MASTER PANEL';
        $form_name = 'CHANGE BANK ACCOUNT STATUS';
        $txtuserid = '';
		$status=1;
        $request = request();
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
                if($request->input('txt_admin_bank_id')=="")
                {
                    $ERRMSG = "Bank Account should be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }   
				else if($request->input('txt_admin_bank_id')=="")
				{
					$ERRMSG = "Bank Account status should be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
				}
				else
				{
					if($request->input('txt_admin_bank_status')=="ACTIVE")
						$status=2;
					else
						$status=1;
				}
                if(request()->method() == 'POST' && $this->isError==FALSE)
                {
					
                    $user_status=$this->admin_bank_repo->change_status($status, $request->input('txt_admin_bank_id'));

                    $ERRMSG="BANK ACCOUNT STATUS HAS BEEN UPDATE SUCCESSFULLY!";
                    $ERRCODE='success'; 
					//dd($user_status);
                }
                Session::flash('message',$ERRMSG);
                Session::flash('type',$ERRCODE);
        }
       return redirect('wl_bank_account');
    }

    // SETTINGS FOR WHITE LABAL AND ADMIN
    /**
        * Method name   : view news
        * @description  : Used for viewing news for white labal
        * @param        : Request data
        * @return       : return with news
    */
   	public function view_news($id='')
	{
        $singlenews = '';
		Session::flash('message','MANAGE NEWS HERE!' );
		Session::flash('type','info' );
        $user_news = $this->events_repo->getByAffId(Session::get('AFFILIATE_CODE'));
        if( $id != '' ){
            $singlenews = $this->events_repo->getById($id);
        }
      	$user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('User.view_news', compact('user','user_news','singlenews'));
        
    }

    /**
        * Method name   : updated news detail
        * @description  : Used for updating news detail
        * @param        : Request data
        * @return       : return with updated news
    */
    public function update_news_detail($id)
    {
        $singlenews = '';
        $request = request();
        $arr = array(
            'm24_news_title' => $request->input('txt_news'),
            'm24_news_des' => $request->input('txt_desc'),
            'm24_news_for' => $request->input('dd_news_for'),
            'm24_news_status' => $request->input('dd_status'),
            'm24_entrydate' => date('Y-m-d H:i:s'),
            'm24_updated_by' => 2,
            'm24_updated_by_id' => SESSION::get('USER_ID')
        );
        $this->events_repo->update($id, $arr);
        Session::flash('message','NEWS UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );
        if( $id != '' ){
            $singlenews = $this->events_repo->getById($id);

        }
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        $user_news = $this->events_repo->getByAffId(Session::get('AFFILIATE_CODE'));
        return view('User.view_news', compact('user_news','user','singlenews'));
    }

    /**
        * Method name   : add news
        * @description  : Used for adding news
        * @param        : Request data
        * @return       : return with adding news
    */
    public function add_news(Request $request)
	{
        $arr = array(
	        'm24_news_title' => $request->input('txt_news'),
	        'm24_news_des' => $request->input('txt_desc'),
	        'm24_news_for' => $request->input('dd_news_for'),
	        'm24_news_status' => $request->input('dd_status'),
	        'm24_affid' => Session::get('AFFILIATE_CODE'),
	        'm24_entrydate' => date('Y-m-d H:i:s'),
	        'm24_created_by' => 2,
	        'm24_created_by_id' => SESSION::get('USER_ID')
        );

        $this->events_repo->create($arr);
		Session::flash('message','NEWS ADDED SUCCESSFULLY HERE!' );
		Session::flash('type','success' );
        return redirect('view_wl_news');
    }

    /**
        * Method name   : news status
        * @description  : Used for updating news status
        * @param        : Request data
        * @return       : return with updated news status
    */
   	public function news_status()
    {
        $txtuserid = '';
        $request = request();
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
                if($request->input('txt_statusregid')=="")
                {
                    $ERRMSG = "Bank should be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }   
                if(request()->method() == 'POST'&& $this->isError==FALSE)
                {
                    $user_status=$this->events_repo->active($request->input('txt_statusregid'));
                    $ERRMSG="NEWS STATUS HAS BEEN UPDATE SUCCESSFULLY!";
                    $ERRCODE='success'; 
                }
                Session::flash('message',$ERRMSG);
                Session::flash('type',$ERRCODE);
        }
        return redirect('view_wl_news');
    }

    //////////// Action Ends Here //////////////////
	///////////CONFIGURATION Start Here ////////////

	/**
        * Method name   : user manage operator status
        * @description  : Used for user manage operator status
        * @param        : Request data
        * @return       : return with user manage operator status
    */
	public function user_manage_operatorstatus()
	{
		$request = request();
		Session::flash('type','info' );
		Session::flash('message','ALL TEAM VIEW HERE' );
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.user_comingsoon',compact('user'));
	}

	/**
        * Method name   : user manage prepaid margin
        * @description  : Used for user manage prepaid margin
        * @param        : Request data
        * @return       : return with user manage prepaid margin
    */
	public function user_manage_prepaidmargin()
	{
		$request = request();
		$grid=1;
		$opid=-1;
		$groupid=$request->input('dd_group');
        $opid = $request->input('dd_operator');
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			if($request->input('dd_group')!="" && $request->input('dd_group')!="0")
			{
				$groupid=$request->input('dd_group');
			}
		}

		$slabmargin=array(
		'proc'=>1,
		'userid'=>$groupid,
		'telecombrandid'=>$opid,
		'desig'=>'',
		'apiid'=>'' 
		);
		$slab_margin = $this->slab_repo->createSlabMargin($slabmargin);

		$ERRMSG=DB::select('SELECT @msg as ERR_MSG');
		Session::flash('message','PREPAID MARGIN' );
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		Session::flash('type','info' );
		Session::flash('message','SET PREPAID MARGIN HERE' );
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$GROUP = Helper::get_group(Session::get('AFFILIATE_CODE'),'ACTIVE');
		$slab = $this->slab_repo->getAll();
		$OPERATOR = Helper::get_operator(-2,'ALL');
		return view('User.user_manage_prepaidmargin',compact('slab_margin','GROUP','groupid','slab','OPERATOR','user','grid','opid'));
	}

	/**
        * Method name   : user update prepaid margin
        * @description  : Used for user update prepaid margin
        * @param        : Request data
        * @return       : return with user update prepaid margin
    */
	public function user_update_prepaidmargin($id)
    {
		$request = request();
	    $grid=-1;$opid=-1;
		$grid = $request->input('dd_group');
        $opid = $request->input('dd_operator');
		$type='info';
		$message='MANAGE PREPAID MARGIN HERE' ;
	    $ad_margin=$request->input('txt_admin_distr_margin_'.$id);
		$sd_margin=$request->input('txt_super_distr_margin_'.$id);
		$md_margin=$request->input('txt_master_distr_margin_'.$id);
		$d_margin=$request->input('txt_distr_margin_'.$id);
		$margin=$request->input('txt_retailer_margin_'.$id);
		
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			if(floatval($sd_margin) < 0.00)
			{
				$type='error';
				$message='DUE TO SUPER DISTRIBUTOR NEGATVE MARGIN:'.$sd_margin;
				$arr_margin = array(
					'tr06_grop_margin_ad'=> '0.0000'
					);	
				DB::table('tr07_group_margin')->where('tr07_grop_mid',$id)->update($arr_margin);
			}
			else if(floatval($md_margin)  < 0.00)
			{
				$type='error';
				$message='DUE TO MASTER DISTRIBUTOR NEGATVE MARGIN:'.$md_margin;
				$arr_margin = array(
					'tr06_grop_margin_sd'=> '0.0000'
					);	
				DB::table('tr07_group_margin')->where('tr07_grop_mid',$id)->update($arr_margin);
			}
			else if(floatval($d_margin)  < 0.00)
			{
				$type='error';
				$message='DUE TO DISTRIBUTOR NEGATVE MARGIN:'.$d_margin;
				$arr_margin = array(
					'tr06_grop_margin_md'=> '0.0000'
					);	
				DB::table('tr07_group_margin')->where('tr07_grop_mid',$id)->update($arr_margin);
			}
			else if(floatval($margin) < 0.00)
			{
				$type='error';
				$message='DUE TO RETAILOR NEGATVE MARGIN:'.$margin;
				$arr_margin = array(
					'tr06_grop_margin_d'=> '0.0000'
					);	
				DB::table('tr07_group_margin')->where('tr07_grop_mid',$id)->update($arr_margin);
			}
			else if(floatval($ad_margin) <= floatval($sd_margin))
			{
				$arr_margin = array(
					'tr06_grop_margin_ad'=> 0.0000,
					'tr06_grop_margin_sd'=> 0.0000,
					'tr06_grop_margin_md'=> 0.0000,
					'tr06_grop_margin_d'=> 0.0000
					);		
				$type='error';
				$message='DUE TO SUPER DISTRIBUTOR MARGIN:'.$ad_margin;
				DB::table('tr07_group_margin')->where('tr07_grop_mid',$id)->update($arr_margin);
			}
			else if(floatval($ad_margin) <= floatval($md_margin))
			{
				$arr_margin = array(
					'tr06_grop_margin_ad'=> 0.0000,
					'tr06_grop_margin_sd'=> 0.0000,
					'tr06_grop_margin_md'=> 0.0000,
					'tr06_grop_margin_d'=> 0.0000
					);		
				$type='error';
				$message='DUE TO MASTER DISTRIBUTOR MARGIN:'.$md_margin;
				DB::table('tr07_group_margin')->where('tr07_grop_mid',$id)->update($arr_margin);
			}
			else if(floatval($ad_margin) <= floatval($d_margin))
			{
				$arr_margin = array(
					'tr06_grop_margin_ad'=> 0.0000,
					'tr06_grop_margin_sd'=> 0.0000,
					'tr06_grop_margin_md'=> 0.0000,
					'tr06_grop_margin_d'=> 0.0000
					);		
				$type='error';
				$message='DUE TO DISTRIBUTOR MARGIN:'.$d_margin;
				DB::table('tr07_group_margin')->where('tr07_grop_mid',$id)->update($arr_margin);
			}
			else if(floatval($ad_margin) <= floatval($margin))
			{
				$arr_margin = array(
					'tr06_grop_margin_ad'=> 0.0000,
					'tr06_grop_margin_sd'=> 0.0000,
					'tr06_grop_margin_md'=> 0.0000,
					'tr06_grop_margin_d'=> 0.0000
					);		
				$type='error';
				$message='DUE TO RETAILOR MARGIN:'.$margin;
				DB::table('tr07_group_margin')->where('tr07_grop_mid',$id)->update($arr_margin);
			}
			/*else if(floatval($ad_margin) <= (floatval($sd_margin)+floatval($md_margin)+floatval($d_margin)+floatval($margin)))
			{
				$arr_margin = array(
					'tr06_grop_margin_ad'=> 0.0000,
					'tr06_grop_margin_sd'=> 0.0000,
					'tr06_grop_margin_md'=> 0.0000,
					'tr06_grop_margin_d'=> 0.0000
					);	
				$type='error';
				$message='DUE TO WRONG DISTRIBUTION OF  MARGIN';
				DB::table('tr07_group_margin')->where('tr07_grop_mid',$id)->update($arr_margin);
			}*/
			else
			{
				$arr_margin = array(
					'tr06_grop_margin_ad'      => $request->input('txt_admin_distr_margin_'.$id),
					'tr06_grop_margin_sd'      => $request->input('txt_super_distr_margin_'.$id),
					'tr06_grop_margin_md'      => $request->input('txt_master_distr_margin_'.$id),
					'tr06_grop_margin_d'       => $request->input('txt_distr_margin_'.$id),
					'tr06_grop_margin'     =>$request->input('txt_retailer_margin_'.$id)
					);	
				DB::table('tr07_group_margin')->where('tr07_grop_mid',$id)->update($arr_margin);	
				$type='success';
				$message='PREPAID MARGIN UPDATE SUCCESSFULLY' ;
			}
			
		}
		$slabmargin=array(
		'proc'=>1,
		'userid'=>$grid,
		'telecombrandid'=>$opid,
		'desig'=>'',
		'apiid'=>0 
		);
        $slab_margin=DB::select('CALL slab_margin(				
		:proc,
		:userid,
		:telecombrandid,
		:desig,
		:apiid,
		@msg
		)',$slabmargin);
		$ERRMSG=DB::select('SELECT @msg as ERR_MSG');
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		Session::flash('type',$type );
		Session::flash('group_msg',$message);
	    $GROUP = Helper::get_group(Session::get('AFFILIATE_CODE'),'ACTIVE');
	    $slab = $this->slab_repo->getAll();
	    $OPERATOR = Helper::get_operator(-2,'ALL');
		return view('User.user_manage_prepaidmargin',compact('user','slab_margin','GROUP','grid','opid','slab','OPERATOR'));
    }

	/**
        * Method name   : user manage utility surcharge
        * @description  : Used for user manage utility surcharge
        * @param        : Request data
        * @return       : return with user manage utility surcharge
    */
	public function user_manage_utilitysurcharge()
	{
		$request = request();
		Session::flash('type','info' );
		Session::flash('message','MANAGE UTILITY SURCHARGE HERE' );
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$groupid=Session::get('GROUP_ID');
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
				if($request->input('dd_group')!="" && $request->input('dd_group')!="0")
				{
					$groupid=$request->input('dd_group');
				}
		}
		$slabmargin=array(
		'proc'=>14,
		'userid'=>$groupid,
		'telecombrandid'=>-1,
		'desig'=>'',
		'apiid'=>'' 
		);
		$slab_margin = $this->slab_repo->createSlabMargin($slabmargin);

		$groupid=$request->input('dd_group');
	    $GROUP = Helper::get_group(Session::get('AFFILIATE_CODE'),'ACTIVE');
	    $slab = $this->slab_repo->getAll();
		return view('User.user_manage_utilitysurcharge',compact('slab_margin','GROUP','groupid','slab','user'));
	}

	/**
        * Method name   : user update utility surcharge
        * @description  : Used for user update utility surcharge
        * @param        : Request data
        * @return       : return with user update utility surcharge
    */
	public function user_update_utilitysurcharge($id)
	{
		$page = 'PROFILE PANEL';
		$form_name = 'UTILITY SURCHARGE';
		$request = request();
		$ad_margin=$request->input('txt_admin_distr_margin_'.$id);
		$sd_margin=$request->input('txt_super_distr_margin_'.$id);
		$md_margin=$request->input('txt_master_distr_margin_'.$id);
		$d_margin=$request->input('txt_distr_margin_'.$id);
		$margin=$request->input('txt_retailer_margin_'.$id);
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			if(floatval($sd_margin) < 0.00)
			{
				$type='error';
				$message='DUE TO SUPER DISTRIBUTOR NEGATVE MARGIN:'.$sd_margin;
				$arr_margin = array(
					'tr24_group_utlty_ad'=> '0.0000'
					);	
				DB::table('tr24_group_utility')->where('tr24_group_utltyid',$id)->update($arr_margin);

			}
			else if(floatval($md_margin)  < 0.00)
			{
				$type='error';
				$message='DUE TO MASTER DISTRIBUTOR NEGATVE MARGIN:'.$md_margin;
				$arr_margin = array(
					'tr24_group_utlty_sd'=> '0.0000'
					);	
				DB::table('tr24_group_utility')->where('tr24_group_utltyid',$id)->update($arr_margin);
			}
			else if(floatval($d_margin)  < 0.00)
			{
				$type='error';
				$message='DUE TO DISTRIBUTOR NEGATVE MARGIN:'.$d_margin;
				$arr_margin = array(
					'tr24_group_utlty_md'=> '0.0000'
					);	
			DB::table('tr24_group_utility')->where('tr24_group_utltyid',$id)->update($arr_margin);
			}
			else if(floatval($margin) < 0.00)
			{
				$type='error';
				$message='DUE TO RETAILOR NEGATVE MARGIN:'.$margin;
				$arr_margin = array(
					'tr24_group_utlty_d'=> '0.0000'
					);	
				DB::table('tr24_group_utility')->where('tr24_group_utltyid',$id)->update($arr_margin);
			}
			else if(floatval($ad_margin) <= floatval($sd_margin))
			{
				$arr_margin = array(
			'tr24_group_utlty_ad' => 0.0000,
			'tr24_group_utlty_md' => 0.0000,
			'tr24_group_utlty_sd' => 0.0000,
			'tr24_group_utlty_d' => 0.0000
			);
				$type='error';
				$message='DUE TO SUPER DISTRIBUTOR MARGIN:'.$ad_margin;
			DB::table('tr24_group_utility')->where('tr24_group_utltyid',$id)->update($arr_margin);
			}
			else if(floatval($ad_margin) <= floatval($md_margin))
			{
				$arr_margin = array(
			'tr24_group_utlty_ad' => 0.0000,
			'tr24_group_utlty_md' => 0.0000,
			'tr24_group_utlty_sd' => 0.0000,
			'tr24_group_utlty_d' => 0.0000
			);	
				$type='error';
				$message='DUE TO MASTER DISTRIBUTOR MARGIN:'.$md_margin;
				DB::table('tr24_group_utility')->where('tr24_group_utltyid',$id)->update($arr_margin);
			}
			else if(floatval($ad_margin) <= floatval($d_margin))
			{
				$arr_margin = array(
			'tr24_group_utlty_ad' => 0.0000,
			'tr24_group_utlty_md' => 0.0000,
			'tr24_group_utlty_sd' => 0.0000,
			'tr24_group_utlty_d' => 0.0000
			);
				$type='error';
				$message='DUE TO DISTRIBUTOR MARGIN:'.$d_margin;
				DB::table('tr24_group_utility')->where('tr24_group_utltyid',$id)->update($arr_margin);
			}
			else if(floatval($ad_margin) <= floatval($margin))
			{
				$arr_margin = array(
			'tr24_group_utlty_ad' => 0.0000,
			'tr24_group_utlty_md' => 0.0000,
			'tr24_group_utlty_sd' => 0.0000,
			'tr24_group_utlty_d' => 0.0000
			);
				$type='error';
				$message='DUE TO RETAILOR MARGIN:'.$margin;
				DB::table('tr24_group_utility')->where('tr24_group_utltyid',$id)->update($arr_margin);
			}
			/*else if(floatval($ad_margin) <= (floatval($sd_margin)+floatval($md_margin)+floatval($d_margin)+floatval($margin)))
			{
				$arr_margin = array(
			'tr24_group_utlty_ad' => 0.0000,
			'tr24_group_utlty_md' => 0.0000,
			'tr24_group_utlty_sd' => 0.0000,
			'tr24_group_utlty_d' => 0.0000
			);
			
				$type='error';
				$message='DUE TO WRONG DISTRIBUTION OF  MARGIN';
				DB::table('tr24_group_utility')->where('tr24_group_utltyid',$id)->update($arr_margin);
			}*/
			else
			{
				$arr_margin = array(
			'tr24_group_utlty_ad' => $request->input('txt_valuemd'.$id),
			'tr24_group_utlty_sd' => $request->input('txt_valuemd'.$id),
			'tr24_group_utlty_md' => $request->input('txt_valued'.$id),
			'tr24_group_utlty_d' => $request->input('txt_valuert'.$id)
			);
			DB::table('tr24_group_utility')->where('tr24_group_utltyid',$id)->update($arr_margin);
				$type='success';
				$message='UTILITY MARGIN/SURCAHRGE UPDATE SUCCESSFULLY' ;
			}
			
		}
		$groupid=$request->input('dd_group');
		$slabmargin=array(
		'proc'=>14,
		'userid'=>$groupid,
		'telecombrandid'=>1,
		'desig'=>'',
		'apiid'=>'' 
		);
        $slab_margin=DB::select('CALL slab_margin(				
		:proc,
		:userid,
		:telecombrandid,
		:desig,
		:apiid,
		@msg
		)',$slabmargin);
		$ERRMSG=DB::select('SELECT @msg as ERR_MSG');
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		Session::flash('type',$type );
		Session::flash('message',$message);
	    $groupid=$request->input('dd_group');
	    $GROUP = Helper::get_group(Session::get('AFFILIATE_CODE'),'ACTIVE');
	    $slab = $this->slab_repo->getAll();
		return view('User.user_manage_utilitysurcharge',compact('slab_margin','GROUP','groupid','slab','user'));
	}

	/**
        * Method name   : user manage dmr surcharge
        * @description  : Used for user manage dmr surcharge
        * @param        : Request data
        * @return       : return with user manage dmr surcharge
    */
	public function user_manage_dmrsurcharge()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'MANAGE DMR SURCHARGE HERE';
		$request = request();
		Session::flash('type','info' );
		Session::flash('message','MANAGE DMR SURCHARGE HERE' );
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$slabmargin=array(
		'proc'=>9,
		'userid'=>$request->input('dd_group'),
		'telecombrandid'=>1,
		'desig'=>'',
		'apiid'=>'' 
		);
        $slab_margin=DB::select('CALL slab_margin(				
		:proc,
		:userid,
		:telecombrandid,
		:desig,
		:apiid,
		@msg
		)',$slabmargin);
		$groupid=$request->input('dd_group');
        $GROUP = Helper::get_group(Session::get('AFFILIATE_CODE'),'ACTIVE');
        $slab = $this->slab_repo->getAll();
		return view('User.user_manage_dmrsurcharge',compact('user','slab_margin','form_name','GROUP','groupid','slab'));
	}

	/**
        * Method name   : user update dmr surcharge
        * @description  : Used for user update dmr surcharge
        * @param        : Request data
        * @return       : return with user update dmr surcharge
    */
	public function user_update_dmrsurcharge($id)
	{
		$request =request();
		$page ='SLAB PANEL';
	    $form_name='DMR SURCHARGE SLAB WISE';
		$groupid=$request->input('dd_group');
		$ad_margin=$request->input('txt_value'.$id);
		
		$sd_margin=$request->input('txt_valuesd'.$id);
		$md_margin=$request->input('txt_valuemd'.$id);
		$d_margin=$request->input('txt_valued'.$id);
		$margin=$request->input('txt_valuert'.$id);
		
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			if(floatval($sd_margin) < 0.00)
			{
				$type='error';
				$message='DUE TO SUPER DISTRIBUTOR NEGATVE MARGIN:'.$sd_margin;
				$arr_margin = array(
					'tr17_grop_dmr_ad'=> '0.0000'
					);	
				DB::table('tr17_group_dmr')->where('tr17_group_dmrid',$id)->update($arr_margin);
			}
			else if(floatval($md_margin)  < 0.00)
			{
				$type='error';
				$message='DUE TO MASTER DISTRIBUTOR NEGATVE MARGIN:'.$md_margin;
				$arr_margin = array(
					'tr17_grop_dmr_sd'=> '0.0000'
					);	
				DB::table('tr17_group_dmr')->where('tr17_group_dmrid',$id)->update($arr_margin);
			}
			else if(floatval($d_margin)  < 0.00)
			{
				$type='error';
				$message='DUE TO DISTRIBUTOR NEGATVE MARGIN:'.$d_margin;
				$arr_margin = array(
					'tr17_grop_dmr_md'=> '0.0000'
					);	
				DB::table('tr17_group_dmr')->where('tr17_group_dmrid',$id)->update($arr_margin);
			}
			else if(floatval($margin) < 0.00)
			{
				$type='error';
				$message='DUE TO RETAILOR NEGATVE MARGIN:'.$margin;
				$arr_margin = array(
					'tr17_grop_dmr_d'=> '0.0000'
					);	
				DB::table('tr17_group_dmr')->where('tr17_group_dmrid',$id)->update($arr_margin);
			}
			else if(floatval($ad_margin) <= floatval($sd_margin))
			{
				$arr_margin = array(
				'tr17_grop_dmr_ad'=> 0.0000,
					'tr17_grop_dmr_sd'=> 0.0000,
					'tr17_grop_dmr_md'=> 0.0000,
					'tr17_grop_dmr_d'=> 0.0000
					);		
				$type='error';
				$message='DUE TO SUPER DISTRIBUTOR MARGIN:'.$ad_margin;
				DB::table('tr17_group_dmr')->where('tr17_group_dmrid',$id)->update($arr_margin);
			}
			else if(floatval($ad_margin) <= floatval($md_margin))
			{
				$arr_margin = array(
				'tr17_grop_dmr_ad'=> 0.0000,
					'tr17_grop_dmr_sd'=> 0.0000,
					'tr17_grop_dmr_md'=> 0.0000,
					'tr17_grop_dmr_d'=> 0.0000
					);		
				$type='error';
				$message='DUE TO MASTER DISTRIBUTOR MARGIN:'.$md_margin;
				DB::table('tr17_group_dmr')->where('tr17_group_dmrid',$id)->update($arr_margin);
			}
			else if(floatval($ad_margin) <= floatval($d_margin))
			{
				$arr_margin = array(
					'tr17_grop_dmr_ad'=> 0.0000,
					'tr17_grop_dmr_sd'=> 0.0000,
					'tr17_grop_dmr_md'=> 0.0000,
					'tr17_grop_dmr_d'=> 0.0000
					);		
				$type='error';
				$message='DUE TO DISTRIBUTOR MARGIN:'.$d_margin;
				DB::table('tr17_group_dmr')->where('tr17_group_dmrid',$id)->update($arr_margin);
			}
			else if(floatval($ad_margin) <= floatval($margin))
			{
				$arr_margin = array(
				   'tr17_grop_dmr_ad'=> 0.0000,
					'tr17_grop_dmr_sd'=> 0.0000,
					'tr17_grop_dmr_md'=> 0.0000,
					'tr17_grop_dmr_d'=> 0.0000
					);		
				$type='error';
				$message='DUE TO RETAILOR MARGIN:'.$margin;
				DB::table('tr17_group_dmr')->where('tr17_group_dmrid',$id)->update($arr_margin);
			}
			/*else if(floatval($ad_margin) <= (floatval($sd_margin)+floatval($md_margin)+floatval($d_margin)+floatval($margin)))
			{
				$arr_margin = array(
					'tr17_grop_dmr_ad'=> 0.0000,
					'tr17_grop_dmr_sd'=> 0.0000,
					'tr17_grop_dmr_md'=> 0.0000,
					'tr17_grop_dmr_d'=> 0.0000
					);	
				$type='error';
				$message='DUE TO WRONG DISTRIBUTION OF  MARGIN';
				DB::table('tr17_group_dmr')->where('tr17_group_dmrid',$id)->update($arr_margin);
			}*/
			else
			{
				$arr_margin = array(
					'tr17_grop_dmr_ad' => $request->input('txt_valuesd'.$id),
			        'tr17_grop_dmr_sd' => $request->input('txt_valuesd'.$id),
			        'tr17_grop_dmr_md' => $request->input('txt_valued'.$id),
			        'tr17_grop_dmr_d' => $request->input('txt_valuert'.$id)
					);	
				DB::table('tr17_group_dmr')->where('tr17_group_dmrid',$id)->update($arr_margin);
				$type='success';
				$message='UTILITY MARGIN/SURCAHRGE UPDATE SUCCESSFULLY' ;
			}
			
		}
		$groupid=$request->input('dd_group');
		$slab=array(
				'proc'=>9,
				'userid'=>$groupid,
				'telecombrandid'=>1,
				'desig'=>1,
	            'apiid'=>1 ,
	            'msg'=>@msg
	        );
			$slab_margin=DB::select('CALL slab_margin(				
	            :proc,
	            :userid,
	            :telecombrandid,
	            :desig,
	            :apiid,
	            :msg
	            )',$slab);
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		Session::flash('type','success' );
	    Session::flash('message','UPDATE SUCCESSFULLY DMR MARGIN SLAB WISE');
		$GROUP = Helper::get_group(Session::get('AFFILIATE_CODE'),'ACTIVE');
		return view('User.user_manage_dmrsurcharge',compact('user','slab_margin','form_name','GROUP','groupid'));
    }

    /**
        * Method name   : user manage aepsmargin
        * @description  : Used for user manage aeps margin
        * @param        : Request data
        * @return       : return with user manage aeps margin
    */
    public function user_manage_aepsmargin()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'MANAGE AEPS MARGIN HERE';
		$request = request();
		Session::flash('type','info' );
		Session::flash('message','MANAGE AEPS MARGIN HERE' );
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$groupid=$request->input('dd_group');
		$slabmargin=array(
		'proc'=>12,
		'userid'=>$groupid,
		'telecombrandid'=>1,
		'desig'=>'',
		'apiid'=>'' 
		);
        $slab_margin=DB::select('CALL slab_margin(				
		:proc,
		:userid,
		:telecombrandid,
		:desig,
		:apiid,
		@msg
		)',$slabmargin);
		$GROUP = Helper::get_group(Session::get('AFFILIATE_CODE'),'ACTIVE');
		$slab = $this->slab_repo->getAll();
		return view('User.user_manage_aepsmargin',compact('user','slab_margin','form_name','GROUP','groupid','slab'));
	}

	/**
        * Method name   : user update aepsmargin
        * @description  : Used for user update aeps margin
        * @param        : Request data
        * @return       : return with user update aeps margin
    */
	public function user_update_aepsmargin($id)
	{
		$request =request();
		$page ='SLAB PANEL';
        $form_name='AEPS MARGIN/SURCAHRGESLAB WISE';
		$groupid=$request->input('dd_group');
		$ad_margin=$request->input('txt_value'.$id);
		$sd_margin=$request->input('txt_valuesd'.$id);
		$md_margin=$request->input('txt_valuemd'.$id);
		$d_margin=$request->input('txt_valued'.$id);
		$margin=$request->input('txt_valuert'.$id);
		
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			if(floatval($sd_margin) < 0.00)
			{
				$type='error';
				$message='DUE TO SUPER DISTRIBUTOR NEGATVE MARGIN:'.$sd_margin;
				$arr_margin = array(
					'tr22_grop_aeps_ad'=> '0.0000'
					);	
				DB::table('tr22_group_aeps')->where('tr22_group_aepsid',$id)->update($arr_margin);
			}
			else if(floatval($md_margin)  < 0.00)
			{
				$type='error';
				$message='DUE TO MASTER DISTRIBUTOR NEGATVE MARGIN:'.$md_margin;
				$arr_margin = array(
					'tr22_grop_aeps_sd'=> '0.0000'
					);	
				DB::table('tr22_group_aeps')->where('tr22_group_aepsid',$id)->update($arr_margin);
			}
			else if(floatval($d_margin)  < 0.00)
			{
				$type='error';
				$message='DUE TO DISTRIBUTOR NEGATVE MARGIN:'.$d_margin;
				$arr_margin = array(
					'tr22_grop_aeps_md'=> '0.0000'
					);	
				DB::table('tr17_group_dmr')->where('tr17_group_dmrid',$id)->update($arr_margin);
			}
			else if(floatval($margin) < 0.00)
			{
				$type='error';
				$message='DUE TO RETAILOR NEGATVE MARGIN:'.$margin;
				$arr_margin = array(
					'tr22_grop_aeps_d'=> '0.0000'
					);	
				DB::table('tr22_group_aeps')->where('tr22_group_aepsid',$id)->update($arr_margin);
			}
			else if(floatval($ad_margin) <= floatval($sd_margin))
			{
				$arr_margin = array(
					'tr22_grop_aeps_ad'=> 0.0000,
					'tr22_grop_aeps_sd'=> 0.0000,
					'tr22_grop_aeps_md'=> 0.0000,
					'tr22_grop_aeps_d'=> 0.0000
					);	
				$type='error';
				$message='DUE TO SUPER DISTRIBUTOR MARGIN:'.$ad_margin;
				DB::table('tr22_group_aeps')->where('tr22_group_aepsid',$id)->update($arr_margin);
			}
			else if(floatval($ad_margin) <= floatval($md_margin))
			{
				$arr_margin = array(
					'tr22_grop_aeps_ad'=> 0.0000,
					'tr22_grop_aeps_sd'=> 0.0000,
					'tr22_grop_aeps_md'=> 0.0000,
					'tr22_grop_aeps_d'=> 0.0000
					);	
				$type='error';
				$message='DUE TO MASTER DISTRIBUTOR MARGIN:'.$md_margin;
				DB::table('tr22_group_aeps')->where('tr22_group_aepsid',$id)->update($arr_margin);
			}
			else if(floatval($ad_margin) <= floatval($d_margin))
			{
				$arr_margin = array(
					'tr22_grop_aeps_ad'=> 0.0000,
					'tr22_grop_aeps_sd'=> 0.0000,
					'tr22_grop_aeps_md'=> 0.0000,
					'tr22_grop_aeps_d'=> 0.0000
					);		
				$type='error';
				$message='DUE TO DISTRIBUTOR MARGIN:'.$d_margin;
				DB::table('tr22_group_aeps')->where('tr22_group_aepsid',$id)->update($arr_margin);
			}
			else if(floatval($ad_margin) <= floatval($margin))
			{
				$arr_margin = array(
					'tr22_grop_aeps_ad'=> 0.0000,
					'tr22_grop_aeps_sd'=> 0.0000,
					'tr22_grop_aeps_md'=> 0.0000,
					'tr22_grop_aeps_d'=> 0.0000
					);	
				$type='error';
				$message='DUE TO RETAILOR MARGIN:'.$margin;
				DB::table('tr22_group_aeps')->where('tr22_group_aepsid',$id)->update($arr_margin);
			}
			/*else if(floatval($ad_margin) <= (floatval($sd_margin)+floatval($md_margin)+floatval($d_margin)+floatval($margin)))
			{
				$arr_margin = array(
					'tr22_grop_aeps_ad'=> 0.0000,
					'tr22_grop_aeps_sd'=> 0.0000,
					'tr22_grop_aeps_md'=> 0.0000,
					'tr22_grop_aeps_d'=> 0.0000
					);	
				$type='error';
				$message='DUE TO WRONG DISTRIBUTION OF  MARGIN';
				DB::table('tr22_group_aeps')->where('tr22_group_aepsid',$id)->update($arr_margin);
			}*/
			else
			{
				$arr_margin = array(
					'tr22_grop_aeps_ad' => $request->input('txt_valuemd'.$id),
		        	'tr22_grop_aeps_sd' => $request->input('txt_valuemd'.$id),
		         	'tr22_grop_aeps_md' => $request->input('txt_valued'.$id),
			        'tr22_grop_aeps_d' => $request->input('txt_valuert'.$id)
					);	
				DB::table('tr22_group_aeps')->where('tr22_group_aepsid',$id)->update($arr_margin);
				$type='success';
				$message='AEPS MARGIN/SURCAHRGE UPDATE SUCCESSFULLY' ;
			}
			
		}
		
		$slab=array(
			'proc'=>12,
			'userid'=>$groupid,
			'telecombrandid'=>1,
			'desig'=>1,
            'apiid'=>1 ,
            'msg'=>@msg
        );
		$slab_margin=DB::select('CALL slab_margin(				
            :proc,
            :userid,
            :telecombrandid,
            :desig,
            :apiid,
            :msg
        )',$slab);

		$GROUP = Helper::get_group(Session::get('AFFILIATE_CODE'),'ACTIVE');
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		Session::flash('type','success' );
        Session::flash('message','UPDATE SUCCESSFULLY AEPS MARGIN SLAB WISE');
        $GROUP = Helper::get_group(Session::get('AFFILIATE_CODE'),'ACTIVE');
    	return view('User.user_manage_aepsmargin',compact('user','slab_margin','form_name','GROUP','groupid'));
    }

    /**
        * Method name   : user api token
        * @description  : Used for user api token
        * @param        : Request data
        * @return       : return with user api token
    */
    public function user_api_token()
	{
		$request = request();
		$page = 'PROFILE PANEL';
		$form_name = 'VIEW USER API TOKEN';
		$form_name1 = 'VIEW USER SERVER IP';
		$form_name2 = 'VIEW USER CALLBACK URL';
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		//$operator_code=$this->operator_repo->OrderByServiceTypeId();
		$operator_code= DB::table('telecom_brand')->select('ServiceName','BrandName','BrandCode','ServiceTypeId')->orderby('ServiceTypeId', 'ASC')->paginate(10);
		return view('User.user_api_token',compact('user','page','form_name','form_name1','form_name2','operator_code'));
	}


	/**
        * Method name   : create token
        * @description  : Used for creating token
        * @param        : Request data
        * @return       : return with token
    */
	public function create_token()
	{
		$request = request();
	
		
		$this->apiToken = uniqid(base64_encode(Str::random(30)));
		$user_profile=DB::update("UPDATE m11_user SET m11_user_api_token='".$this->apiToken."' WHERE m11_user_contactno =".Session::get('CONTACTNO')." and m11_user_id=". Session::get('USER_ID')." AND m11_user_status='ACTIVE'");
		$user_profile1=DB::select("UPDATE `tr04_login` SET `tr04_ip`='".$request->input('txt_serverip')."', `tr04_doamin_name`='".$request->input('txt_weburl')."' WHERE m11_user_contactno='".Session::get('USER_CODE')."' and m11_user_id=". Session::get('USER_ID')."");
		Session::flash('type','success' );
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		Session::flash('message','TOKEN CREATED SUCCESSFULLY');
		$operator_code=DB::select("SELECT ServiceName,BrandName,BrandCode FROM `telecom_brand` WHERE 1 ORDER BY ServiceTypeId ASC");
		return redirect('/user_apitoken');
	}

	/**
        * Method name   : update server ip
        * @description  : Used for user server ip updation
        * @param        : Request data
        * @return       : return with server ip
    */
	public function update_serverip()
	{
		$request = request();
		$page = 'PROFILE PANEL';
		$form_name = 'VIEW USER API TOKEN';
		$form_name1 = 'VIEW USER SERVER IP';
		$form_name2 = 'VIEW USER CALLBACK URL';
		
		$server_ip=$request->input('txt_serverip');
		$user_profile=DB::select("UPDATE `tr04_login` SET `tr04_ip`='".$server_ip."' WHERE m11_user_contactno='".Session::get('USER_CODE')."' and m11_user_id=". Session::get('USER_ID')."");
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		Session::flash('type_ip','success');
		Session::flash('message_ip','SERVER IP ADDRESS UPDATED SUCCESSFULLY');
		$operator_code=DB::select("SELECT ServiceName,BrandName,BrandCode FROM `telecom_brand` WHERE 1 ORDER BY ServiceTypeId ASC");
		return redirect('/user_apitoken');
	}

	/**
        * Method name   : update callback url
        * @description  : Used for user api callback url
        * @param        : Request data
        * @return       : return with api callback url
    */
	public function update_callbackurl()
	{
		$request = request();
		$callback_url=$request->input('txt_callbackurl');
		$user_profile=DB::update("UPDATE m11_user SET m11_user_callback='".$callback_url."' WHERE m11_user_contactno =".Session::get('CONTACTNO')." and m11_user_id=". Session::get('USER_ID')." AND m11_user_status='ACTIVE'");
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		Session::flash('type_cb','success');
		Session::flash('message_cb','CALLBACK URL UPDATED SUCCESSFULLY');
		$operator_code=DB::select("SELECT ServiceName,BrandName,BrandCode FROM `telecom_brand` WHERE 1 ORDER BY ServiceTypeId ASC");
		return redirect('/user_apitoken');
	}



	/**
        * Method name   : update dmr callback url
        * @description  : Used for user api dmr callback url
        * @param        : Request data
        * @return       : return with api dmr callback url
    */
	public function update_dmrcallbackurl()
	{
		$request = request();
		$callback_url=$request->input('txt_dmrcallbackurl');
		$user_profile=DB::update("UPDATE m11_user SET m11_user_dmr_callback='".$callback_url."' WHERE m11_user_contactno =".Session::get('CONTACTNO')." and m11_user_id=". Session::get('USER_ID')." AND m11_user_status='ACTIVE'");
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		Session::flash('type_dcb','success');
		Session::flash('message_dcb','CALLBACK URL UPDATED SUCCESSFULLY');
		$operator_code=DB::select("SELECT ServiceName,BrandName,BrandCode FROM `telecom_brand` WHERE 1 ORDER BY ServiceTypeId ASC");
		return redirect('/user_apitoken');
	}


	/**
        * Method name   : update aeps callback url
        * @description  : Used for user api aeps callback url
        * @param        : Request data
        * @return       : return with api aeps callback url
    */
	public function update_aepscallbackurl()
	{
		$request = request();
		$callback_url=$request->input('txt_aepscallbackurl');
		$user_profile=DB::update("UPDATE m11_user SET m11_user_aeps_callback='".$callback_url."' WHERE m11_user_contactno =".Session::get('CONTACTNO')." and m11_user_id=". Session::get('USER_ID')." AND m11_user_status='ACTIVE'");
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		Session::flash('type_acb','success');
		Session::flash('message_acb','CALLBACK URL UPDATED SUCCESSFULLY');
		$operator_code=DB::select("SELECT ServiceName,BrandName,BrandCode FROM `telecom_brand` WHERE 1 ORDER BY ServiceTypeId ASC");
		return redirect('/user_apitoken');
	}



	/**
        * Method name   : update aeps status callback url
        * @description  : Used for user api aeps status callback url
        * @param        : Request data
        * @return       : return with api aeps status callback url
    */
	public function update_aepsstatuscallbackurl()
	{
		$request = request();
		$callback_url=$request->input('txt_status_check');
		$user_profile=DB::update("UPDATE m11_user SET m11_user_aeps_status_check='".$callback_url."' WHERE m11_user_contactno =".Session::get('CONTACTNO')." and m11_user_id=". Session::get('USER_ID')." AND m11_user_status='ACTIVE'");
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		Session::flash('type_acb','success');
		Session::flash('message_acb','CALLBACK URL UPDATED SUCCESSFULLY');
		$operator_code=DB::select("SELECT ServiceName,BrandName,BrandCode FROM `telecom_brand` WHERE 1 ORDER BY ServiceTypeId ASC");
		return redirect('/user_apitoken');
	}


	/**
        * Method name   : View Soft Login
        * @description  : Used for view soft login 
        * @param        : Request data  
        * @return       : return view
    */
	public function view_activity_log()
    {

		$user_action_log = DB::select("SELECT * FROM activity_log WHERE USER_ID=".SESSION::get('USER_ID')." AND ACT_UPDATED_BY='USER' AND ACT_UPDATED_BY_ID=".SESSION::get('USER_ID')."");
		$user = Helper::get_userdetail(Session::get('USER_ID'));
    	return view('User.view_activity_log', compact('user_action_log','user'));

    }

	/**
        * Method name   : View Soft Login
        * @description  : Used for view soft login 
        * @param        : Request data  
        * @return       : return view
    */
	public function view_login_log()
    {

        $admin_detail = Helper::get_admin_details();
        $admin_loginlog = Helper::get_login_log(Session::get('USER_ID'));
		$user = Helper::get_userdetail(Session::get('USER_ID'));
    	return view('User.view_login_log', compact('admin_detail', 'admin_loginlog','user'));

    }

   /**
        * Method name   : View banner
        * @description  : Used for getting banner 
        * @param        : Request data with banner id and all banners
        * @return       : return with single banner selected and all banners
    */
    public function view_banner($id = ""){

        $banners = $this->banner_repo->getByAffi(Session()->get('AFFILIATE_CODE'));
        $single_banner = '';
        if( $id!= ''){
            $single_banner = $this->banner_repo->getById($id);
        } 
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		//dd($single_banner, $banners, $affi);
        return view('User.banner_master', compact('single_banner', 'banners','user'));
    }

    /**
        * Method name   : Create banner
        * @description  : Used for creating banner 
        * @param        : Request data for creating banner 
        * @return       : return with created banner 
    */
    public function create_banner()
    {
        $request = request();
        $type = $request->input('dd_banner_type');
        $img = '';
		
        $bannerName = '';

       if($request->file('txt_banner_img')){
            $image = $request->file('txt_banner_img');
            $time = date("d-m-Y")."-".time() ;
            $image_name = $image->getClientOriginalName();
            $bannerName = $request->input('txt_banner_var').$time.'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('images/front');

			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {

				if($request->input('dd_banner_type') == 1){
					$img1 = Image::make($image->getRealPath())->resize(1170, 146);
					$img1->save($destinationPath.'\\'.$bannerName);                       
				}
				elseif($request->input('dd_banner_type') == 2){
					$img1 = Image::make($image->getRealPath())->resize(1920, 600);
					$img1->save($destinationPath.'/'.$bannerName);                 
				}
				elseif($request->input('dd_banner_type') == 3){
					$img1 = Image::make($image->getRealPath())->resize(1170, 146);
					$img1->save($destinationPath.'/'.$bannerName);                 
				}
				elseif($request->input('dd_banner_type') == 4){
					$img1 = Image::make($image->getRealPath())->resize(360, 230);
					$img1->save($destinationPath.'/'.$bannerName);                 
				}
				elseif($request->input('dd_banner_type') == 5){
					$img1 = Image::make($image->getRealPath())->resize(1170, 146);
					$img1->save($destinationPath.'/'.$bannerName);                 
				}
				elseif($request->input('dd_banner_type') == 6){
					$img1 = Image::make($image->getRealPath())->resize(500, 540);
					$img1->save($destinationPath.'/'.$bannerName);                 
				}
			}
			else{
				$request_data=json_encode($request->all());
				$file_type=$image->getClientOriginalName();
				$user_id=Session()->get('AFFILIATE_CODE');
				$server_info=json_encode(request()->server());
				$user_info=json_encode(SESSION()->all()['result'][0]);
				$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
				return back()->with('error', 'File format not supported.'); 
			}
            
        }
        else
        {
            $bannerName = '' ;
        }

        $arr = array(
            'm47_banner_name' => $request->input('txt_banner_name'),
            'm47_banner_var' => $request->input('txt_banner_var'),
            'm47_banner_desc' => $request->input('txt_banner_desc'),
            'm47_banner_meta' => $request->input('txt_banner_meta'),
            'm47_banner_img' => $bannerName,
            'm47_banner_type' => $request->input('dd_banner_type'),
            'm47_banner_status' => $request->input('dd_banner_status'),
            'm47_created_by' => 2,
			'm47_created_by_id' => 1,
            'm47_affiliate_id' => Session()->get('AFFILIATE_CODE')
        );

        $this->banner_repo->create($arr);
        Session::flash('banner_msg','BANNER IMAGE ADDED SUCCESSFULLY' );
        Session::flash('type','success' );
        return redirect('/user_banner');
    }

    /**
        * Method name   : Create banner
        * @description  : Used for creating banner 
        * @param        : Request data for creating banner 
        * @return       : return with created banner 
    */
    public function update_banner($id)
    {
        $request = request();
        $type = $request->input('dd_banner_type');
        $img = '';

        $bannerName = '';

       if($request->file('txt_banner_img')){
            $image = $request->file('txt_banner_img');
            $time = date("d-m-Y")."-".time() ;
            $image_name = $image->getClientOriginalName();
            $bannerName = $request->input('txt_banner_var').$time.'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('images/front');
			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {

				if($request->input('dd_banner_type') == 1){
					$img1 = Image::make($image->getRealPath())->resize(1170, 146);
					$img1->save($destinationPath.'/'.$bannerName);                       
				}
				elseif($request->input('dd_banner_type') == 2){
				  $img1 = Image::make($image->getRealPath())->resize(1920, 600);
				  $img1->save($destinationPath.'/'.$bannerName);   
				}
				elseif($request->input('dd_banner_type') == 3){
					$img1 = Image::make($image->getRealPath())->resize(1170, 146);
					 $img1->save($destinationPath.'/'.$bannerName);                 
				}
				elseif($request->input('dd_banner_type') == 4){
					$img1 = Image::make($image->getRealPath())->resize(360, 230);
					 $img1->save($destinationPath.'/'.$bannerName);                 
				}
				elseif($request->input('dd_banner_type') == 5){
					$img1 = Image::make($image->getRealPath())->resize(1170, 146);
				   echo $img1->save($destinationPath.'/'.$bannerName);                 
				}
				elseif($request->input('dd_banner_type') == 6){
					$img1 = Image::make($image->getRealPath())->resize(500, 540);
					 $img1->save($destinationPath.'/'.$bannerName);                 
				}
			}
			else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=Session()->get('AFFILIATE_CODE');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
			}
            
        }
        else
        {
            $bannerName = $request->input('txt_old_banner') ;
        }

        $arr = array(
            'm47_banner_name' => $request->input('txt_banner_name'),
            'm47_banner_var' => $request->input('txt_banner_var'),
            'm47_banner_desc' => $request->input('txt_banner_desc'),
            'm47_banner_meta' => $request->input('txt_banner_meta'),
            'm47_banner_img' => $bannerName,
            'm47_banner_type' => $request->input('dd_banner_type'),
            'm47_banner_status' => $request->input('dd_banner_status')
        );

        $this->banner_repo->update($id, $arr);
        Session::flash('banner_msg','BANNER IMAGE UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );
        return redirect('/user_banner');
    }
	
	/**
        * Method name   : View User certificate
        * @description  : Used for viewing user certificate
        * @param        : Request data 
        * @return       : return with viewing user certificate
    */
	public function view_certificates()
	{
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$data = "";
		if(Session::get('USER_ROLE') == 'WHITE LABEL' || Session::get('USER_ROLE') == 'BRANCH' || Session::get('USER_ROLE') == 'API USER' )
		{	
			$data = Helper::get_userdetail(Session::get('USER_ID')); 
			$Affid = $this->Affiliate_repo->getById($user[0]->Affid);
			$shop = $this->Shop_repo->getById($user[0]->RegId);
			return view('Certificate.trust_certificate',compact('user','data','Affid','shop'));
		}
		else
		{	
			$Affid = $this->Affiliate_repo->getById($user[0]->Affid);
			$data = Helper::get_userdetail($Affid[0]->m11_user_id); 
			return view('Certificate.ll-cerificate',compact('user','data'));
		}
	}

	/**
        * Method name   : user update shop details
        * @description  : Used for updating user shop details
        * @param        : Request data for updating user shop details
        * @return       : return with updated user shop details
    */
	public function user_update_shopdetails()
	{
		$request = request();
		if($request->method() == 'POST')
		{
			if($request->input('txt_username')=='')
			{
				$ERRMSG = "Member user name should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
}
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$user_shop_details = Helper::get_usershopdetail(Session::get('USER_ID'));
		$data['country'] = $this->location_repo->getAllCountries(); 
		$data['state'] = $this->location_repo->getAllStates();
		
		$shop_info=$this->Shop_repo->getByUserId(Session::get('USER_ID'));
		if(count($shop_info) > 0)
		{
			$data['city'] = $this->location_repo->getByPId($shop_info[0]->m22_shop_state);
		}
		else
		{
			$data['city'] = "";
		}

		return view('User.user_shop_details',compact('user','user_shop_details','data','shop_info'));
	}


	/**
        * Method name   : Update User Kyc
        * @description  : Used to update user kyc
        * @param        : Request data 
        * @return       : return with updated user kyc details
    */
	public function user_update_shop_details()
	{
		$request = request();

		$get_useralldetail = Helper::get_useralldetail(Session::get('USER_ID'));
		
		if($request->method() == 'POST')
		{
			     if($_FILES['txt_shop_image']['name']!= '')
				  {
					$image = $request->file('txt_shop_image');
					$name = time().'.'.$image->getClientOriginalExtension();
					$destinationPath = public_path('images/SHOP_IMAGE');
					$FileType = array('jpeg','png','jpg');
					if(in_array($image->getClientOriginalExtension(), $FileType)) {
						$image->move($destinationPath,$name);
					}
					else{
						$request_data=json_encode($request->all());
						$file_type=$image->getClientOriginalName();
						$user_id=Session::get('USER_ID');
						$server_info=json_encode(request()->server());
						$user_info=json_encode($get_useralldetail);
						$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
						return back()->with('error', 'File format not supported.'); 
					}
					$txt_shopphoto = $name;
				}
				else
				{
					$txt_shopphoto = trim($request->input('txt_shophd'));
				}
					if($_FILES['txt_gst_image']['name']!= '')
					{
						$image = $request->file('txt_gst_image');
						$name = time().'.'.$image->getClientOriginalExtension();
						$destinationPath = public_path('images/GST_CERTIFICATE');
						$FileType = array('jpeg','png','jpg');
						if(in_array($image->getClientOriginalExtension(), $FileType)) {
							$image->move($destinationPath, $name);
					}
					else
					{
						$request_data=json_encode($request->all());
						$file_type=$image->getClientOriginalName();
						$user_id=Session::get('USER_ID');
						$server_info=json_encode(request()->server());
						$user_info=json_encode($get_useralldetail);
						$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
						return back()->with('error', 'File format not supported.'); 
					}
					$txt_gstproof = $name;
				}
				else
				{
					$txt_gstproof = trim($request->input('txt_gsthd'));
				}
				
				if($request->input('txt_shop_name')=='')
				{
					$ERRMSG = "Shop name should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				/*else if($request->input('txt_shop_gst')=='')
				{
					$ERRMSG = "Shop gst should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($txt_gstproof=='')
				{
					$ERRMSG = "Gst proof should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}

				else if($txt_shopphoto=='')
				{
					$ERRMSG = "Shop front image should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}				*/
				else if($request->input('dd_shop_type')=='' || $request->input('dd_shop_type')=='-1')
				{
					$ERRMSG = "Shop type should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('dd_loc_type')=='' || $request->input('dd_loc_type')=='-1')
				{
					$ERRMSG = "Location type should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('dd_popl')=='' || $request->input('dd_popl')=='-1')
				{
					$ERRMSG = "Population should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('dd_country')=='' || $request->input('dd_country')=='-1')
				{
					$ERRMSG = "Country should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('dd_state')=='' || $request->input('dd_state')=='-1')
				{
					$ERRMSG = "State should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('dd_city')=='' || $request->input('dd_city')=='-1')
				{
					$ERRMSG = "City should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_block')=='')
				{
					$ERRMSG = "Block should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_mohhalla')=='')
				{
					$ERRMSG = "Mohalla should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_landmark')=='')
				{
					$ERRMSG = "Landmark should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_pincode')=='')
				{
					$ERRMSG = "Pincode should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_address')=='')
				{
					$ERRMSG = "Address should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST' && $this->isError==FALSE)
			{
				$USER=Session::get('USER_ID');
				$arr = array(
					'm22_shop_company_name'=>$request->input('txt_shop_name'),
					'm22_shop_image'=>$txt_shopphoto,
					'm22_shop_type'=>$request->input('dd_shop_type'),
					'm22_shop_location_type'=>$request->input('dd_loc_type'),
					'm22_shop_near_popullation'=>$request->input('dd_popl'),
					'm22_shop_country'=>$request->input('dd_country'),
					'm22_shop_state'=>$request->input('dd_state'),
					'm22_shop_city'=>$request->input('dd_city'),
					'm22_shop_address_block'=>$request->input('txt_block'),
					'm22_shop_address_mohhalla'=>$request->input('txt_mohhalla'),
					'm22_shop_address_landmark'=>$request->input('txt_landmark'),
					'm22_shop_pincode'=>$request->input('txt_pincode'),
					'm22_shop_shipping_address'=>$request->input('txt_address')
				);
			
				if($request->input('txt_shop_gst')!='' && ($txt_gstproof!='')){
					$arr['m22_shop_gstin'] = $request->input('txt_shop_gst');
					$arr['m22_shop_gstin_copy'] = $txt_gstproof;
					
					$old_values=DB::select("SELECT Shop_CompanyName, ShopIMAGE,ShopType, ShopLocationType1, ShopNearPollution1,
					ShopCountry, ShopState, ShopCity, ShopBlock, ShopMohhalla, ShopLandmark, ShopPincode, Shop_Address, ShopGST, Shop_Address FROM user_shopdetails WHERE RegId=".Session::get('USER_ID')."");
				}
				else
				{
					$old_values=DB::select("SELECT Shop_CompanyName, ShopIMAGE,ShopType, ShopLocationType1, ShopNearPollution1,
					ShopCountry, ShopState, ShopCity, ShopBlock, ShopMohhalla, ShopLandmark, ShopPincode, Shop_Address FROM user_shopdetails WHERE RegId=".Session::get('USER_ID')."");
				}

				$this->Shop_repo->update($request->input('txt_shop_id'), $arr);
				$data=$this->match_values($old_values,$arr);
				$arr = array(
						'tr11_ar_tblnm' => 'm22_shop_info',
						'tr11_ar_old_value' => $data[1],
						'tr11_ar_new_value' => $data[0],
						'tr11_ar_uid' => $USER,
						'tr11_ar_description' => 'USER S SHOP DETAILS HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 2,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
				$kyc_actionrecord=$this->log_repo->create($arr);	
				$ERRMSG="USER S SHOP DETAILS HAS BEEN CHANGED SUCCESSFULLY!";
				$ERRCODE='success';	
			}
			
		}
		Session::flash('type',$ERRCODE);
		Session::flash('message',$ERRMSG);
		return redirect('user_update_shopdetails'); 
	}




	/**
			* Method name	: check_roffer
			* @description 	: Used to Get Roffer on user number
			* @param		: Request data  
			* @return		: Get ROffer Details data array with response message
		*/
		public function check_mobile_roffer(Request $request)
		{
				$opcode=$request->input('opt');
				$opcode='';$circlecode='';
				$opcircle_id='';
				$mobileno=$request->input('mobile');

				if($this->isError== FALSE)
				{
					if($request->input('mobile')=='')
					{
						$ERRMSG = "Mobile no should be valid.";
						$this->isError= TRUE;
						$ERRCODE="success";
						$userData ='';
					}
					else
					{
						//$url = 'https://api.dingconnect.com/api/V1/GetProviders?countryIsos=IN&accountNumber=91'.$mobileno.'';CURLOPT_HTTPHEADER=>'$request_headers',
						$url='http://planapi.in/api/Mobile/OperatorFetchNew?ApiUserID=3889&ApiPassword=123456&Mobileno='.$mobileno.'';
						$host = '';    
						$request_headers = array("api_key:3945q8QDszn6bTGaMrOVj0");

						$options = array(
						CURLOPT_SSL_VERIFYHOST => 0,
						CURLOPT_SSL_VERIFYPEER => 0
						);
						$defaults = array(
						CURLOPT_URL => $url,
						CURLOPT_HEADER => 0,
						CURLOPT_RETURNTRANSFER => TRUE,
						CURLOPT_TIMEOUT =>60
						);

						$ch = curl_init();
						curl_setopt_array($ch, ($options + $defaults));
						$result = curl_exec($ch);
						$json=json_decode($result);
						if($json->Operator!=''){
						$opcode	=$json->OpCode;
						$circlecode=$json->CircleCode;
						}
						/*if(count($json->Items) > 0)
						{
							curl_close($ch);
							$name = explode(" ",$json->Items[0]->Name);
							if(count($name) > 0)
							{
							  $opcode	= $name[0];
							}
						}
						else
						{
							$opcode	='';
						}*/
                        $opcircle_id = DB::select("SELECT IFNULL(`CIRCLE_ID`,'') as CIRCLE_ID FROM `op_circle` WHERE `CIRCLE_CODE`=".$circlecode." LIMIT 1");
						$opcode_id = DB::select("SELECT IFNULL(`m04_tc_brand_id`,'') as BRAND_ID,IFNULL(`m07_service_id`,'') as SERVICE_ID FROM `m15_service_provider` WHERE `m15_sp_code`='".$opcode."' AND `m12_api_id`=7 LIMIT 1");
						$brand_id=$opcode_id[0]->BRAND_ID;
						$service_id=$opcode_id[0]->SERVICE_ID;
						$ERRMSG = "D.";
						$this->isError= FALSE;
						$ERRCODE="success";
						$userData =$opcode_id[0]->BRAND_ID.'_'.$service_id;
						$details = DB::select("CALL recharge_report(2,'".$mobileno."','','','1970-01-01','1970-01-01',5,1,'1',@msg)");
					}
				}
				if($this->isError=== FALSE)
				{
					$rechreq=array(
					'proc'=>'3',
					'user_id'=> Session()->get('USER_ID'),
					'mobile'=>$mobileno,
					'operator'=>$brand_id,
					'amount'=>0.000,
					'requesttype'=>1,
					'servicetype'=>1,
					'agentid'=>'123456789',
					'format'=>'json',
					'timelimit'=>'900',
					'defaultstatus'=>'2'
					);	
					$rechreq_report=DB::select('CALL dorecharge(				
					:proc,
					:user_id,
					:mobile,
					:operator,
					:amount,
					:requesttype,
					:servicetype,
					:agentid,
					:format,
					:timelimit,
					:defaultstatus,
					@msg,
					@msg2
					)',$rechreq);
					
					$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
					
					if($DB_ERROR[0]->ERROR!="Error")
					{
						$transid=$DB_ERRMSG[0]->ERR_MSG;
						foreach($rechreq_report as $row)
						{						
							break;
						}
						$url=$row->url_address;	
						$operatorcode=$row->oper_code;
						if($mobileno!="")
						$url=str_replace('@account',$mobileno,$url);
						if($operatorcode!="")
						$url=str_replace('@operatorcode',$operatorcode,$url);
						//echo $url.'</br>';
						//PRINT_R($DB_ERRMSG[0]->ERR_MSG);
						$result=Helper::_curl_execute('GET',$url,'');
						$result=str_replace("\xEF\xBB\xBF",'',$result); 
						$json=json_decode($result,true);

						if(isset($json['records']))
						{
							$userData =$json['records'];
						}
						else
						{
							$userData =array();
						}
					}
						return [ 'ROFFER'=>$userData, 'LAST5TRANSACTION'=>$details, 'brand_id' => $brand_id,'circle_id'=>$opcircle_id[0]->CIRCLE_ID,'circle_code'=>$circlecode ];							
				}
				return [ 'ROFFER'=>'', 'LAST5TRANSACTION'=>'', 'brand_id' => ''];
		}





		public function get_dth_roffer(Request $request)
		{

				$apitoken="0035e12b2628d608fe38f5c8456e8536";
				$mobileno1="";$amount1="";$opt1="";$opcode="";$cardnumber="";
				$mobileno1=$request->has('mobile')?'1':'0' ;
				$opt1=$request->has('opt')?'1':'0' ;
				$opcode=$request->input('opt');
				$cardnumber=$request->input('cardnumber');

				$opcode_id = DB::select("SELECT IFNULL(`m04_tc_brand_id`,'') as BRAND_ID,IFNULL(`m03_sr_type_id`,'') as SERVICE_ID FROM `m04_telecom_brand` WHERE `m04_tc_brand_id`='".$opcode."' AND `m04_tc_brand_status`='Active' LIMIT 1");
				$details = DB::select("CALL recharge_report(2,'".$cardnumber."','','','1970-01-01','1970-01-01',5,1,'1',@msg)");

				$brand_id=$opcode_id[0]->BRAND_ID;
				$service_id=$opcode_id[0]->SERVICE_ID;

				$userData =$opcode_id[0]->BRAND_ID.'_'.$service_id;
				if(count($opcode_id) > 0)
				{
					$rechreq=array(
					'proc'=>'5',
					'user_id'=>Session()->get('USER_ID'),
					'mobile'=>$cardnumber,
					'operator'=>$brand_id,
					'amount'=>0.000,
					'requesttype'=>1,
					'servicetype'=>$service_id,
					'agentid'=>'123456789',
					'format'=>'json',
					'timelimit'=>'900',
					'defaultstatus'=>'2'
					);	
					$rechreq_report=DB::select('CALL dorecharge(				
					:proc,
					:user_id,
					:mobile,
					:operator,
					:amount,
					:requesttype,
					:servicetype,
					:agentid,
					:format,
					:timelimit,
					:defaultstatus,
					@msg,
					@msg2
					)',$rechreq);
					
					$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
					//dd($DB_ERRMSG[0]->ERR_MSG);
					if($DB_ERROR[0]->ERROR!="Error")
					{
						$transid=$DB_ERRMSG[0]->ERR_MSG;
						foreach($rechreq_report as $row)
						{						
							break;
						}
						$url=$row->url_address;	
						$operatorcode=$row->oper_code;
						if($apitoken!="")
						$url=str_replace('@apitoken',$apitoken,$url);
						if($cardnumber!="")
						$url=str_replace('@account',$cardnumber,$url);
						if($operatorcode!="")
						$url=str_replace('@operatorcode',$operatorcode,$url);
						echo $url.'</br>';
						//PRINT_R($DB_ERRMSG[0]->ERR_MSG);
						$result=Helper::_curl_execute('GET',$url,'');
						$result=str_replace("\xEF\xBB\xBF",'',$result); 
                        dd($result);
						$json=json_decode($result,true);
						$userData =$json['records'];
						$ERRMSG = "DTH INFO FETCH SUCCESSFULLY";
						$this->isError= FALSE;
						$ERRCODE="success";
					}

						if(!array_key_exists('status',$userData))
						{
						return [
									'ERROR'=>$ERRCODE,
									'MSG' =>$ERRMSG,
									'DTHINFO'=>$userData,
									'LAST5TRANSACTION'=>$details
									];					
						}
						else
						{
										$ERRMSG = "CARD NUMBER IS NOT VALID";
										$ERRCODE="error";
										return [
										'ERROR'=>$ERRCODE,
										'MSG' =>$ERRMSG,
										'DTHINFO'=>'',
										'LAST5TRANSACTION'=>$details 
										];
						}
				}
				else
				{
					return ['error' =>'Data Not Found'];
				}
			
		}
		
		
	public function change_twoFa($st='')
	{
		if($st == 'NONE')
		{ 
			$user_profile = $this->enroll_repo->updates(Session::get('USER_ID'), ['m11_otpenable'=>'1']);
			Session::flash('type','error');
			Session::flash('message','OTP Change NONE');
			return back();
		}
		elseif($st == 'MAIL')
		{ 
			$user_profile = $this->enroll_repo->updates(Session::get('USER_ID'), ['m11_otpenable'=>'2']);
			Session::flash('type','error');
			Session::flash('message','OTP Change MAIL');
			return back();
		}
		elseif($st == 'SMS')
		{ 
			$user_profile = $this->enroll_repo->updates(Session::get('USER_ID'), ['m11_otpenable'=>'3']);
			Session::flash('type','error');
			Session::flash('message','OTP Change SMS');
			return back();
		}
		elseif($st == 'BOTH')
		{ 
			$user_profile = $this->enroll_repo->updates(Session::get('USER_ID'), ['m11_otpenable'=>'4']);
			Session::flash('type','error');
			Session::flash('message','OTP Change BOTH');
			return back();
		}
		else
		{
			Session::flash('type','error');
			Session::flash('message','Not Change ');
			return back();
		}
	}

	/**
        * Method name   : Bill Payment Report
        * @description  : Used for viewing recharge report
        * @param        : Request data 
        * @return       : return recharge report
    */
    public function billpay_report()
    {
        $request = request();
		$user = Helper::get_userdetail(Session::get('USER_ID'));
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = Session()->get('USER_ID');
		 $txt_memberids='';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='-1';
		$dd_operator = '-1';
		$dd_api	=	'-1';
        $cond="";
        $cond1="`m07_service_id` NOT IN(1,2) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$dd_operator = $request->input('dd_operator');
						$dd_api	=	$request->input('dd_api');
			$txt_memberids = $request->input('txt_memberid');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr36_bill_payment`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr36_bill_payment`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
         (
         'proc'=>2,
		  'mobile'=>'',
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
		//dd($recereport);
        $rec_report = $this->rech_reprt_repo->billpayReport($recereport);

		$hit_data=array(
				'proc'=>3,
				'user_id'=>-1,
				'rec_fromdate'=>$start,
				'rec_todate'=>$end
            );
		$today_hit = $this->rech_reprt_repo->todayHitStatus($hit_data);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');

        Session::flash('message',"Billpay Report Fetch Succesfully");
        return view('User.user_bill_payreport', compact('user','rec_report','OPERATOR','API','today_hit','start','end','txt_account','txt_transid','dd_status','dd_operator','txt_noofrecords','dd_api','txt_memberids'));
    }

	/**
			* Method name	: All Remitter
			* @description 	: Used for all remitter details
			* @param		: all remitter report 
			* @return		: return message to user
		*/   
	public function all_remitter()
	{
		if($_SERVER['REQUEST_METHOD']=="GET" || $_SERVER['REQUEST_METHOD']=="POST"  )
		{
			$userrec=array(
			'proc'=>9,
			'userid'=>'`m57_remitter`.`m57_remitter_referral_code`='.Session::get('USER_ID').''
			);
			$user_rec= $this->enroll_repo->getUserByProc($userrec);
		}
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('User.all_remitter',compact('user','user_rec'));
	}

    /**
			* Method name	: Send Sms
			* @description 	: Used for sending sms 
			* @param		: Phone number and sending message 
			* @return		: return message to user
		*/    
	public function send_sms($mob,$msg)
	{
		$url = Config('SMS_SEND_URL');
		$params = array(
        'user'=>Config('SMS_AUTH'),
        'password'=>Config('SMS_PWD'),
        'senderid'=>Config('SMS_SENDERID'),    
        'channel'=>Config('SMS_CHANNEL'),             
        'DCS'=>0,
		'flashsms'=>0,
        'number'=>$mob,
        'text'=>$msg,     
		'route'=>Config('SMS_ROUTE')
		);

		Helper::_curl_execute('GET',$url,$params);
	}
public function aeps_web_login()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'AEPS WEBlOGIN';
			$request = request();
			$get_useralldetail = "";$dmt_user = "";
	
		    $user = Helper::get_userdetail(Session::get('USER_ID'));

			//Check Service On Or not 
			$UserService = DB::select("SELECT * FROM `user_services` WHERE `USER_ID`=".Session()->get('USER_ID')." AND `MS_SERVICE_NAME`='AEPS' AND `MS_STATUS`='Active' ");
			if($UserService){ $UserService='ON'; }
			else{ $UserService='OFF';  }

				if($user[0]->AEPS_ID!='' && $UserService == 'ON'){
					$url="http://uat.dhansewa.com/AEPS/BCInitiate"; 
					
					$data=json_encode(array(
						'bc_id'=>$user[0]->AEPS_ID,
						'phone1'=>$user[0]->AEPS_CONTACT,
						'ip'=>'192.168.1.0',
						'userid'=>$user[0]->AEPS_CONTACT,
						'saltkey'=>'NH7610MALPOEDCTM091MKSYDSC34LAQPELXXCRT',
						'secretkey'=>'ADN990DMD89MK9SMS9S2MLPQAZXCBD45MKOQ'
						 ));
//print_r($data);
					$header_data=array(
										"Content-Type:application/json",
									  );
					$method="POST";
					if($method=="POST")
					{
						$curl = curl_init();
							curl_setopt_array($curl, array
							(
							CURLOPT_URL => $url,
							CURLOPT_RETURNTRANSFER => true,
							CURLOPT_ENCODING => "",
							CURLOPT_MAXREDIRS => 10,
							CURLOPT_TIMEOUT => 30,
							CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
							CURLOPT_CUSTOMREQUEST => "POST",
							CURLOPT_POSTFIELDS =>$data,
							CURLOPT_HTTPHEADER =>$header_data
							));
						$result = curl_exec($curl);
						if(!$result)
						{
							$result=trigger_error(curl_error($curl));
							curl_close($curl);
							//print_r($result);
						}
						else
						{	                
							curl_close($curl);
						    //print_r($result);
						}
					}
					$json = json_decode($result);
					$parameters=$json[0]->Result;

			$url="https://icici.bankmitra.org/Location.aspx?text=";                    //this is for testing
			$get_url=$url.$parameters;
            //echo $get_url;
		     echo "<script>window.open('".$get_url."', '_blank')</script>";
			 //return redirect('/user_dashboard');

}
else
{
	Session::flash('aeps_msg',"AEPS Not Active.");
	return redirect('/user_dashboard');
}
	return redirect('/user_dashboard');
		}		




		/**
			* Method name   : airtel money
			* @description  : Used for airtel money login
			* @param        : Request data 
			* @return       : return with airtel money
    	*/
		public function airtel_money()
		{
			$request = request();
			Session::forget('MOBILENO');
			$get_useralldetail = "";
			$dmt_user = "";
			if($_SERVER['REQUEST_METHOD']=="GET")
			{
			$ERRCODE='info';
			$ERRMSG='FETCH USER DMR ACCOUNT DETAILS' ;
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$get_useralldetail = "";
			}
			Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
			//Check Service On Or not 
			$UserService = DB::select("SELECT * FROM `user_services` WHERE `USER_ID`=".Session()->get('USER_ID')." AND `MS_SERVICE_NAME`='DMT' AND `MS_STATUS`='Active' ");
			if($UserService){ $UserService='ON'; }
			else{ $UserService='OFF';  }
			return view('User.user_airtel_money',compact('dmt_user','get_useralldetail','user','UserService'));
		}


/**
			* Method name   : user dmt register
			* @description  : Used for user dmt register
			* @param        : Request data 
			* @return       : return with dmt register
    	*/
		public function user_dmtregisterairtel_express()
		{
			$request = request();
			$user = Helper::get_userdetail(Session::get('USER_ID'));
	    	
			$get_useralldetail = "";
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$this->validate($request, [
			'txt_mobileno'=> 'required|numeric|digits:10|regex:/^[5-9]\d{9}$/' 	
			],[
				'txt_mobileno.required'=> 'Mobile Number is required',
				'txt_mobileno.numeric'=> 'Enter a valid Mobile Number',
				'txt_mobileno.digits'=> 'Enter 10 digit Mobile Number',
				'txt_mobileno.regex'=> 'Mobile no start from 5-9'
			]);
			

				$signup_data = MahagramDMT::register_remitter($user[0]->AEPS_ID,$request->input('txt_mobileno'),$request->input('txt_firstname'),$request->input('txt_lastname'),$request->input('txt_pincode'),date('d-m-Y',strtotime($request->input('txt_memberdob'))),$request->input('txt_pin'),$request->input('txt_address'),$request->input('dd_state'));
				$resp = json_decode($signup_data,true);
				if($resp[0]['StatusCode'] =="001")
				{
					Session::put('MOBILENO',$request->input('txt_mobileno'));
					return redirect('user_dmtairtel_dashboard');
				}
				else
				{
 
							$ERRMSG = $resp[0]['Message'];
							$ERRCODE="warning";
							Session::flash('type',$ERRCODE);
							Session::flash('message',$ERRMSG);
							//Session::flash('MOBILENO',$request->input('txt_memberid'));
							return redirect('user_dmtregisterairtel_express');//airtel_money
				}

				Session::flash( 'message', $response['err_msg'] );
				Session::flash( 'type', $response['err_code'] );

			}
			return view('User.user_dmtregisterairtel',compact('user','get_useralldetail'));
		}

		/**
			* Method name   : user dmt login
			* @description  : Used for user dmt login
			* @param        : Request data 
			* @return       : return with dmt login
    	*/
		public function user_dmtairtel_expresslogin()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'USER DMT LOGIN VIEW';
			$request = request();
			$get_useralldetail = "";$dmt_user = "";
			$ERRMSG = "SEARCH AND VIEW USER DMT DETAILS";
			$ERRCODE="info";
			if($request->method() == 'POST')
			{
			if($request->input('txt_memberid')=='')
			{
			$ERRMSG = "Member contact number should be valid or not blank.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else if(strlen($request->input('txt_memberid'))<10)
			{
			$ERRMSG = "Member contact number should be sequal to 10 digit.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else if(strlen($request->input('txt_memberid'))>10)
			{
			$ERRMSG = "Member contact number should be equal to 10 digit.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else
			{
			$ERRMSG = "";
			$this->isError=FALSE;
			$ERRCODE="success";
			}

				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
				 $user = Helper::get_userdetail(Session::get('USER_ID'));
				 $userids = MahagramDMT::mobile_verify($request->input('txt_memberid'),$user[0]->AEPS_ID);
				 $response = json_decode($userids,true);
				 Session::put('MOBILENO',$request->input('txt_memberid'));
					if($response['statuscode'] != "000" && $response['statuscode'] != "002")
					{
					$dmt_user = $response;
					$get_useralldetail = [];
					$ERRMSG = "USER DMT DETAILS";
					}
					else
					{
						$tramo=MahagramDMT::remitter_verifyotp($request->input('txt_memberid'),$user[0]->AEPS_ID);
						$resp = json_decode($tramo,true);
						if($resp[0]['StatusCode'] =="001")
						{
							$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no OR Register With us.";
							$this->isError=TRUE;
							$ERRCODE="warning";
							Session::flash('type',$ERRCODE);
							Session::flash('message',$ERRMSG);
							return redirect('user_dmtregisterairtel_express');
						}
						else
						{
							$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no OR Register With us.";
							$this->isError=TRUE;
							$ERRCODE="warning";
							Session::flash('type',$ERRCODE);
							Session::flash('message',$ERRMSG);
							return redirect('user_dmtregisterairtel_express');
						}
					}
						Session::flash('type',$ERRCODE );
						Session::flash('message',$ERRMSG);
						Session::flash('dmtdash_type',$ERRCODE );
						Session::flash('dmtdash_message',$ERRMSG );
						Session::flash('benelist_type',"info" );
						Session::flash('benelist_message',"BENEFICIARY LIST HERE" );
						Session::flash('addbene_type',"info" );
						Session::flash('addbene_message',"BENEFICIARY ADD HERE" );
						Session::flash('transtobene_type',"info" );
						Session::flash('transtobene_message',"TRANSFER TO BENEFICIARY DETAILS HERE" );
		     	}
				else
				{
				Session::flash('type',$ERRCODE);
				Session::flash('message',$ERRMSG);

				}
			}
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			return view('User.user_airtel_money',compact('form_name','user','dmt_user','get_useralldetail'));
		}
		
		/**
			* Method name   : user dmt dashboard
			* @description  : Used for user dmt dashboard
			* @param        : Request data 
			* @return       : return with dmt dashboard
    	*/
		public function user_dmtairtel_expressdashboard()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'DMR ACCOUNT DETAILS';
			$request = request();
			$get_useralldetail = "";$dmt_user = "";
			$ERRCODE='info';
			$ERRMSG='FETCH USRE DMR ACCOUNT DETAILS' ;
			$user = Helper::get_userdetail(Session::get('USER_ID'));
				 $userids = MahagramDMT::mobile_verify(Session::get('MOBILENO'),$user[0]->AEPS_ID);

				 $response = json_decode($userids,true);
			if($response['statuscode'] =="001" || $response['statuscode'] =="003")
			{
				$dmt_user = $response;
				$get_useralldetail = Helper::get_user_bene_detail(Session::get('USER_ID'));
				return view('User.user_airtel_money',compact('form_name','user','dmt_user','get_useralldetail'));
			}
			else
			{
				Session::flash('type',$ERRCODE );
				Session::flash('message',$ERRMSG );
				return redirect('airtel_money');
			}
		}

				/**
			* Method name   : user dmt beneficiary list
			* @description  : Used for user dmt beneficiary list
			* @param        : Request data 
			* @return       : return with dmt beneficiary list
    	*/
		public function user_dmtairtel_expressbeneficiary_list()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'DMR ACCOUNT DETAILS';
			$request = request();
			$get_useralldetail = "";$dmt_user = "";
			if($_SERVER['REQUEST_METHOD']=="GET")
			{
			$ERRCODE='info';
			$ERRMSG='FETCH USRE DMR ACCOUNT DETAILS' ;

			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$userid = Helper::get_dmtuser_by_mobile(Session::get('MOBILENO'));
			if($userid!=FALSE)
			{
			$dmt_user = Helper::get_dmtuserdetail($userid);
			$get_useralldetail = Helper::get_user_bene_detail($userid);
			}
			}
	
			Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
			//dd($get_useralldetail);
			return view('User.user_dmtlogin',compact('form_name','user','dmt_user','get_useralldetail'));
		}


		/**
			* Method name   : user airtel express dmt dashboard
			* @description  : Used for user dmt dashboard
			* @param        : Request data 
			* @return       : return with dmt dashboard
    	*/
		public function user_dmtairtel_expressbeneficiary()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'DMR ACCOUNT DETAILS';
			$request = request();
			$get_useralldetail = "";$dmt_user = "";
			if($_SERVER['REQUEST_METHOD']=="GET")
			{
			$ERRCODE='info';
			$ERRMSG='FETCH USRE DMR ACCOUNT DETAILS' ;
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$userids = MahagramDMT::mobile_verify(Session::get('MOBILENO'),$user[0]->AEPS_ID);
			$response = json_decode($userids,true);
			
			//dd($user[0]->AEPS_ID,$response);
    			if($response['statuscode'] =="001")
    			{
    				$dmt_user = $response;
    				$get_useralldetail = $response;
    			}
    			else if($response['statuscode'] =="003")
    			{
    				$dmt_user = $response;
    				$get_useralldetail = " No Beneficiary found";
    			}
    			else
    			{
    				//return redirect('airtel_money'); 
    			}
			}
			$url ="http://45.249.111.172/Airtel/DMT/BankList";
			$banks = Helper::_curl_execute("GET", $url, '');
			$banks=str_replace("\xEF\xBB\xBF",'',$banks); 
			$banks = json_decode($banks,true);
			Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
			//dd($get_useralldetail);
			return view('User.user_dmtairtelbeneficiary',compact('form_name','user','dmt_user','banks','get_useralldetail'));
		}

		/**
			* Method name   : user add beneficiary
			* @description  : Used for user add beneficiary
			* @param        : Request data 
			* @return       : return with add beneficiary
    	*/
		public function user_add_dmtairtel_express_beneficiary()
		{

			$page = 'PROFILE PANEL';
			$form_name = 'USER ADD BENEFICIARY HERE';
			$request = request();
			//dd($request);
			$USER=Session::get('USER_ID');
			//dd($USER);
			$user = Helper::get_userdetail($USER);
			$get_useralldetail = Helper::get_user_bene_detail($USER);
			if($request->method() == 'POST')
			{
			if($request->input('txt_nameatbank')=='' )
			{
			$ERRMSG = "Member Name at Bank should be valid or not blank.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else if($request->input('dd_bank')=='' && $request->input('dd_bank')=='-1')
			{
			$ERRMSG = "Member Bank Name should be valid or not blank.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else if($request->input('txt_benemobileno')=='')
			{
			$ERRMSG = "Beneficiary Mobile Number should be valid or not blank.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else if(strlen($request->input('txt_benemobileno')) != 10 )
			{
			$ERRMSG = "Beneficiary Mobile Number should be valid or not blank.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else if($request->input('txt_cbsacno')=='')
			{
			$ERRMSG = "Member Bank no Account should be valid or not blank.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else if($request->input('txt_cbsacno') != $request->input('txt_cbsacno_re'))
			{
			$ERRMSG = "Member Bank Account Re-enter Account Number not the same Account Number ";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else if($request->input('txt_bankifsccode')=='')
			{
			$ERRMSG = "Member Bank IFSCode should be valid or not blank.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else
			{
			$ERRMSG = "";
			$this->isError=FALSE;
			$ERRCODE="success";
			}

			if(request()->method() == 'POST' && $this->isError==FALSE)
			{
			$ACCOUNTNO=$request->input('txt_cbsacno');
			$bank_name= DB::select("SELECT GET_BANK_NAME(".$request->input('dd_bank').") AS BANK");

			$tramo=MahagramDMT::beneficiary_add($request->input('txt_userid'),$request->input('txt_cbsacno'),$request->input('txt_nameatbank'),$request->input('txt_benemobileno'),$request->input('txt_bankifsccode'),$request->input('dd_bank'));
			$response = json_decode($tramo,true);
		
			$bank_actionrecord=DB::select("INSERT INTO tr11_actionrecord (tr11_ar_tblnm,tr11_ar_old_value,tr11_ar_new_value,tr11_ar_uid,tr11_ar_description) VALUES ('m57_remitter','','$ACCOUNTNO','$USER','USER S BENEFICIARY HAS BEEN ADDED SUCCESSFULLY!')");
			if($response['statuscode']=="001")
			{
				$ERRMSG="USER'S BENEFICIARY HAS BEEN ADD SUCCESSFULLY!";
				$ERRCODE='success';
				Session::flash('addbene_type',$ERRCODE );
				Session::flash('addbene_message',$ERRMSG);
				return redirect('verify_dmtairtel_express_beneficiary/'.$response['Data'][0]['beneaccno'].'/'.$response['Data'][0]['benemobile'].'/'.$request->input('txt_userid'));
			}
			else
			{
				$ERRMSG="USER'S BENEFICIARY HAS BEEN NOT ADD !";
				$ERRCODE='success';
				Session::flash('addbene_type',$ERRCODE );
				Session::flash('addbene_message',$ERRMSG);
				return redirect()->to('user_dmtairtelbeneficiary');
			}
			}
			else
			{
			Session::flash('addbene_type',$ERRCODE );
			Session::flash('addbene_message',$ERRMSG);
			}
			}
			//DD($ERRMSG);
			return redirect()->to('user_dmtbeneficiary');
			//return view('User.user_dmtbeneficiary',compact('form_name','user','dmt_user','bank','get_useralldetail'));
		}





		/**
			* Method name   : user verify beneficiary
			* @description  : Used for user verify beneficiary
			* @param        : Request data 
			* @return       : return with verify beneficiary
    	*/
		public function verify_dmtairtel_express_beneficiary($ac,$bcno,$no)
		{

			$page = 'PROFILE PANEL';
			$form_name = 'USER ADD BENEFICIARY HERE';
			$USER=Session::get('USER_ID');
			//dd($USER);
			$request = request();
			$user = Helper::get_userdetail($USER);
			$get_useralldetail = Helper::get_user_bene_detail($USER);
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$userids = MahagramDMT::mobile_verify(Session::get('MOBILENO'),$user[0]->AEPS_ID);
			$response = json_decode($userids,true);
			$dmt_user = $response;

			$otpsend = MahagramDMT::remitter_verifyotp($no,$user[0]->AEPS_ID);
			$otpsend = json_decode($otpsend,true);
	
			if($request->method() == 'POST')
			{

			if($response['statuscode']!='001')
			{
			$ERRMSG = "Beneficiary Account Not Found .";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else if($request->input('txt_benemobileno')=='')
			{
			$ERRMSG = "Beneficiary Mobile Number should be valid or not blank.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else if(strlen($request->input('txt_benemobileno')) != 10 )
			{
			$ERRMSG = "Beneficiary Mobile Number should be valid or not blank.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else if($request->input('txt_cbsacno')=='')
			{
			$ERRMSG = "Member Bank no Account should be valid or not blank.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else if($request->input('txt_otp')=='')
			{
			$ERRMSG = "Member Bank no Account should be valid or not blank.";
			$this->isError= TRUE;
			$ERRCODE="warning";
			}
			else
			{
			$ERRMSG = "";
			$this->isError=FALSE;
			$ERRCODE="success";
			}

			if(request()->method() == 'POST' && $this->isError==FALSE)
			{
				$ACCOUNTNO=$request->input('txt_cbsacno');
				//$account_number,$benemobileno,$otp,$mobile_no)
				$tramo=MahagramDMT::beneficiary_add_confirm($request->input('txt_cbsacno'),$request->input('txt_benemobileno'),$request->input('txt_otp'),$request->input('txt_userid'));
				$response = json_decode($tramo,true);

			$bank_actionrecord=DB::select("INSERT INTO tr11_actionrecord (tr11_ar_tblnm,tr11_ar_old_value,tr11_ar_new_value,tr11_ar_uid,tr11_ar_description) VALUES ('m57_remitter','','$ACCOUNTNO','$USER','USER S BENEFICIARY HAS BEEN ADDED SUCCESSFULLY!')");
				if($response[0]['StatusCode']=="003")
				{
					$ERRMSG=$response[0]['Message'];
					$ERRCODE='warning ';
					return back();
				}
				else
				{
					$ERRMSG=$response[0]['Message'];
					$ERRCODE='success ';
					return redirect('user_dmtairtel_dashboard');
				}
			}
			else
			{
			Session::flash('addbene_type',$ERRCODE );
			Session::flash('addbene_message',$ERRMSG);
			}
			}

				if($otpsend[0]['StatusCode'] == '001')
				{
					Session::flash('addbene_type','success' );
					Session::flash('addbene_message',$otpsend[0]['Message']);
				}

			return view('User.user_dmtairtelbeneficiary_verify',compact('form_name','user','dmt_user','get_useralldetail','ac','bcno','no'));
		}





				/**
			* Method name   : user dmt beneficiary account validate bc
			* @description  : Used for user dmt beneficiary account validate bc
			* @param        : Request data 
			* @return       : return with dmt beneficiary account validate bc
    	*/
		public function account_validate_bc()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'DMR ACCOUNT DETAILS';
			$request = request();
			$user = Helper::get_userdetail(Session::get('USER_ID'));

				$transfer="DEDUCT";
				$fundtransfer_data=array(
				'proc'=>3,
				'to_user_id'=>Session::get('USER_ID'),
				'from_user_id'=>0,
				'amount'=>6,
				'collected_amount'=>6,
				'requesttype'=>1,
				'balfor'=>2,
				'transtype'=>19,
				'timelimit'=>(config('FUND_INTERVAL')*60),
				'defaultstatus'=>1,
				'remark'=>"Add Beneficiary Account verification charge 6 Rs",
				'collected_remark'=>"Add Beneficiary Account verification charge 6 Rs"
				);

				$fundtransfer = $this->fund_repo->walletTransfer($fundtransfer_data);

				$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
				$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
				$ERRCODE=$ERRCODE[0]->ERR_CODE;
				$ERRMSG=$ERRMSG[0]->ERR_MSG;

				if($ERRCODE=="success")
				{
						$userids = MahagramDMT::mobile_verify(Session::get('MOBILENO'),$user[0]->AEPS_ID);
						// $bcid,$mobile_no,$account_number,$benemobileno,$beneName,$ifsccode,$bankname,$transid)
						$tramo=MahagramDMT::beneficiary_verify($user[0]->AEPS_ID,$request->get('txt_userid'),$request->get('txt_cbsacno'),$request->get('txt_benemobileno'),$request->get('txt_nameatbank'),$request->get('txt_bankifsccode'),$request->get('dd_bank'),rand(1000000000,9999999999));
						$response = json_decode($tramo,true);
						if($response['statuscode'] == "001")
						{
							return $response;
						}
						else
						{
							return ['MSG' => 'Data Not Found', 'CODE' => 'warning'];
						}
				}
				else
				{
					return ['MSG' => $ERRMSG, 'CODE' => $ERRCODE];
				}
	
		}


		/**
			* Method name   : sent otp bene
			* @description  : Used for sending otp beneficiary
			* @param        : Request data 
			* @return       : return with otp
    	*/
		public function sent_otpbenedmtairtel_express($for_bene)
		{
			$request = request();
			if(request()->method() == 'POST')
			{
				if(trim($request->input('txt_contactno')) == '')
				{
					$ERRMSG = "Mobile no should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else if(!$this->valid_phone_number($request->input('txt_contactno')))
				{
					$ERRMSG = "Mobile no should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `dmt_userdetails` WHERE `REM_CONTACT`='".$request->input('txt_contactno')."' AND REM_STATUS='ACTIVE'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
						$this->isError= FALSE;
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						$this->isError= TRUE;
					}
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$message=rand(1000,9999);
					$msg="Please submit this code ".$message." to verify your account.";
					$bene_id=$request->input('bene_id');
					$user_logindetails=DB::update("UPDATE `m28_b2cuser_beneficiary` SET `m28_bene_trasnfer_otp` =".$message." WHERE `m28_bene_id`=".$bene_id." ");
					if($user_logindetails==1)
					{
						// SMS SEND OR INSERT
						$sms_data['MOBILE_NO'] = Session()->get('CONTACTNO');
						$sms_data['SUBJECT'] = 'beneficiary verify your account';
						$sms_data['MESSAGE'] = $msg;
						$sms_data['TYPE'] = 13;
						$sms_data['SEND_BY'] = 2;
						$sms_data['SEND_BY_ID'] = Session()->get('USER_ID');
						Helper::send_sms_or_log($sms_data);
						//SMS SEND END 

						$ERRMSG = "Please check your Mobile No to verify OTP.";
						$ERRCODE = "success";
						return $user_logindetails;
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
					}
				}
			}
			else
			{
				$ERRMSG = "Invalid Method , Please try again..";
				$ERRCODE="error";
			}

		}


		/**
			* Method name   : sent otp user and member to add beneficiary 
			* @description  : Used for sending otp beneficiary
			* @param        : Request data 
			* @return       : return with otp
    	*/
		public function send_dmt_otpdmtairtel_express(request $request)
		{

				if(trim($request->mobileno) == '')
				{
					$ERRMSG = "beneficiary mobile no should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else if(trim($request->user_phone) == '')
				{
					$ERRMSG = "member mobile no should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else if(!$this->valid_phone_number($request->mobileno))
				{
					$ERRMSG = "beneficiary Mobile no should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
				}
				else if(!$this->valid_phone_number($request->user_phone))
				{
					$ERRMSG = "member Mobile no should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `enroll` WHERE `RegId`=".Session()->get('USER_ID')."");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
						$this->isError= FALSE;
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						$this->isError= TRUE;
					}
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$message=rand(100000,999999);
					$msg="Please submit this code ".$message." to verify your account.";
					$bene_id=$request->input('bene_id');
					$user_logindetails=DB::update("UPDATE `tr04_login` SET `tr04_otp` =".$message." WHERE `m11_user_id`=".Session()->get('USER_ID')." ");

					if($user_logindetails==1)
					{
						
						// SMS SEND OR INSERT
						$sms_data['MOBILE_NO'] = $request->mobileno;
						$sms_data['SUBJECT'] = 'add beneficiary for user';
						$sms_data['MESSAGE'] = $msg;
						$sms_data['TYPE'] = 13;
						$sms_data['SEND_BY'] = 2;
						$sms_data['SEND_BY_ID'] = Session()->get('USER_ID');
						Helper::send_sms_or_log($sms_data);
						//SMS SEND END 

						// SMS SEND OR INSERT
						$sms_data['MOBILE_NO'] = $request->user_phone;
						$sms_data['SUBJECT'] = 'add beneficiary for member';
						$sms_data['MESSAGE'] = $msg;
						$sms_data['TYPE'] = 13;
						$sms_data['SEND_BY'] = 2;
						$sms_data['SEND_BY_ID'] = Session()->get('USER_ID');
						Helper::send_sms_or_log($sms_data);
						//SMS SEND END 

						$ERRMSG = "Please check your Mobile No to verify OTP.";
						$ERRCODE = "success";
						return "Please check your Mobile No to verify OTP.";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return "error";;
					}
				}
		}



		/**
			* Method name   : verification dmt otp add beneficiary
			* @description  : Used for verification otp beneficiary
			* @param        : Request data 
			* @return       : return with otp
    	*/
		public function verification_dmt_otpdmtairtel_express(request $request)
		{

				if(trim($request->otp) == '')
				{
					$ERRMSG = "otp should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `tr04_login` WHERE `m11_user_id`=".Session()->get('USER_ID')."");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
						$this->isError= FALSE;
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						$this->isError= TRUE;
					}
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{

					if($login_detail[0]->tr04_otp == $request->otp)
					{
						$ERRMSG = "Please check your Mobile No to verify OTP.";
						$ERRCODE="success";
						return "success";
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						return "error";;
					}
				}
		}

		/**
			* Method name   : user verify otp add beneficiary
			* @description  : Used for otp verification
			* @param        : Request data 
			* @return       : return with otp verification
    	*/
		public function user_verifyotp_add_beneficiarydmtairtel_express()
		{
			  
			$request = request();
			if(request()->method() == 'POST')
			{
				if(trim($request->input('txt_contactno')) == '')
				{
					$ERRMSG = "Mobile no should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else if(!$this->valid_phone_number($request->input('txt_contactno')))
				{
					$ERRMSG = "Mobile no should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					
				}
				else if($request->input('txt_otp')=='')
				{
					$ERRMSG = "OTP should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
				}
				else
				{
					$login_detail = DB::select("SELECT * FROM `enroll` WHERE `MemberContactNo`='".$request->input('txt_contactno')."' AND MemberStatus='Active'");
					if($login_detail)
					{
						$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
						$ERRCODE="success";
						$this->isError= FALSE;
					}
					else
					{
						$ERRMSG = "USER DETAILS NOT FIND.";
						$ERRCODE="error";
						$this->isError= TRUE;
					}
					
				}
				if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
				{
					$bene_id=$request->input('txt_beneid');
					 $otp_detail = DB::select("SELECT `m28_bene_add_otp` as Token FROM `m28_b2cuser_beneficiary` WHERE `m28_bene_id` ='".$bene_id."'");
					
					if($otp_detail)
					{
						if($request->input('txt_otp')==$otp_detail[0]->Token)
						{
							
							$msg="Your account password has been verified successfully. Please send money with MobileNo :".$request->input('txt_contactno')." .";
							$user_logindetails=DB::update("UPDATE `m28_b2cuser_beneficiary` SET `m28_bene_status` = 1 WHERE `m28_bene_id`=".$bene_id." ");
								$ERRMSG = "Beneficiary Verified Successfully .Please send money with MobileNo.";
								$ERRCODE = "success";
						
						}
						else
						{
							$ERRMSG = "OTP NOT VALID.";
							$ERRCODE="error";
							$this->isError= TRUE;
					
						}
					}
					else
					{
							$ERRMSG = "OTP HAS NOT BEEN GENERATES FOR THIS USER.PLEASE TRY AGAIN";
							$ERRCODE="error";
							$this->isError= TRUE;
					}
				}
				
			}
			else 
			{	
				$ERRMSG = "Invalid Method , Please try again.";
				$ERRCODE="error";
			}
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$userid = Helper::get_userid($request->input('txt_contactno'));
			if($userid!=FALSE)
			{
				$dmt_user = Helper::get_userdetail($userid);
				$get_useralldetail = Helper::get_user_bene_detail($userid);
			}
			Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
			return view('User.user_dmtlogin',compact('form_name','user','dmt_user','get_useralldetail'));
		}








		public function user_transtobene_airtel_bank()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'USER DELETE BENEFICIARY HERE';
			$request = request();
			if($request->method() == 'POST')
			{
				if($request->input('txt_contactno')=='' )
				{
					$ERRMSG = "Member/User should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_beneid')=='')
				{
					$ERRMSG = "Beneficiary ID should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_bccontactno')=='')
				{
					$ERRMSG = "Beneficiary Mobile no should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_banknameid')=='')
				{
					$ERRMSG = "Bank id should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}  
				else if($request->input('txt_nameatbank')=='')
				{
					$ERRMSG = "Beneficiary Name at Bank should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_beneaccountno')=='')
				{
					$ERRMSG = "Beneficiary Account should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_bankifsccode')=='')
				{
					$ERRMSG = "Beneficiary IFSCode should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('rb_auth_type')=='')
				{
					$ERRMSG = "Transfer Authentication should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{	
					$bene_id=$request->input('txt_beneid');

					if($request->input('rb_auth_type')=='OTP')
					{
						if($request->input('txt_otp')=='')
						{
							$ERRMSG = "Transfer OTP should be valid or not blank.";
							$this->isError= TRUE;
							$ERRCODE="warning";
						}
						else
						{

							$otp_detail = DB::select("SELECT `m28_bene_trasnfer_otp` as Token FROM `m28_b2cuser_beneficiary` WHERE `m28_bene_id` ='".$bene_id."'");
							if($otp_detail)
							{
								if($request->input('txt_otp')==$otp_detail[0]->Token)
								{
									$user_logindetails=DB::update("UPDATE `m28_b2cuser_beneficiary` SET `m28_bene_trasnfer_otp` ='' WHERE `m28_bene_id`=".$bene_id." ");
									$ERRMSG = "";
									$this->isError=FALSE;
									$ERRCODE="success";
								}
								else
								{
									$ERRMSG = "OTP not match .";
									$this->isError= TRUE;
									$ERRCODE="warning";
								}
							}
							else
							{
								$ERRMSG = "User details not found.";
								$this->isError= TRUE;
								$ERRCODE="warning";
							}

						}
						
					}
					if($request->input('rb_auth_type')=='MPIN')
					{
						if($request->input('txt_mpin')=='')
						{
							$ERRMSG = "Transfer MPIN should be valid or not blank.";
							$this->isError= TRUE;
							$ERRCODE="warning";
						}
						else
						{

							$otp_detail = DB::select("SELECT `tr04_pin_pwd` FROM `tr04_login` WHERE `m11_user_id` = ".Session()->get('USER_ID')." LIMIT 1");

							if($otp_detail)
							{
								if($request->input('txt_mpin')==$otp_detail[0]->tr04_pin_pwd)
								{
									$ERRMSG = "";
									$this->isError=FALSE;
									$ERRCODE="success";
								}
								else
								{
									$ERRMSG = "MPIN not match .";
									$this->isError= TRUE;
									$ERRCODE="warning";
								}
							}
							else
							{
								$ERRMSG = "User details not found.";
								$this->isError= TRUE;
								$ERRCODE="warning";
							}
						}
					}
					else
					{
						$ERRMSG = "Transfer Authentication Not Found.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
				}

				if(request()->method() == 'POST'&& $this->isError==FALSE)
				{
					$ACCOUNTNO=$request->input('txt_beneaccountno');
					$BENEID=$request->input('txt_tbene_id');
					$user = Helper::get_userdetail(Session::get('USER_ID'));
					
					$dmr_req=array(
					'proc'=>'1',
					'm11_user_id'=>Session::get('USER_ID'),
					'trans_id'=>'',
					'refre_id'=>$BENEID,
					'request_no'=>'',
					'mobile_no'=>$request->input('txt_contactno'),
					'amount'=>$request->input('txt_transferamount'),
					'payment_id'=>'',
					'payment_status'=>'',
					'impsrefno'=>'',
					'message'=>'',
					'remarks'=>'',
					'account_number'=>$request->input('txt_beneaccountno'),
					'beneficiary_code'=>'',
					'beneficiary_name'=>$request->input('txt_nameatbank'),
					'account_type'=>'',
					'ifsc'=>$request->input('txt_bankifsccode'),
					'bank_name'=>'',
					'branch_name'=>'',
					'address'=>'',
					'state'=>'',
					'city'=>'',
					'agentid'=>'',
					'payctransid'=>'',
					'topup_charge'=>'0.00',
					'transfer_status'=>'2'
					);	
					$dmrreq_response=DB::select('CALL doremmitance(				
					:proc,
					:m11_user_id,
					:trans_id,
					:refre_id,
					:request_no,
					:mobile_no,
					:amount,
					:payment_id,
					:payment_status,
					:impsrefno,
					:message,
					:remarks,
					:account_number,
					:beneficiary_code,
					:beneficiary_name,
					:account_type,
					:ifsc,
					:bank_name,
					:branch_name,
					:address,
					:state,
					:city,
					:agentid,
					:payctransid,
					:topup_charge,
					:transfer_status,
					@msg,
					@msg2
					)',$dmr_req);
	
					$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
					$ERROR=$DB_ERROR[0]->ERROR;
					$MSG =$DB_ERRMSG[0]->ERR_MSG;   

					if($ERROR=="success")
					{
						//$mobile_no,$account_number,$beneName,$benemobileno,$ifsccode,$bankname,$bcid,$transid,$amount
						$tramo=MahagramDMT::transaction($request->input('txt_contactno'),$request->input('txt_beneaccountno'),$request->input('txt_nameatbank'),$request->input('txt_bccontactno'),$request->input('txt_bankifsccode'), $request->input('txt_banknameid'),$user[0]->AEPS_ID,$MSG,round(floatval($request->input('txt_transferamount'))));

							    $json=json_decode($tramo,true);

								if($json['statuscode'] == "001")
								{
									$ERROR = "success";
									$MSG='money transfer Successfully transaction Id'.$json['Data'][0]['tranid'];
								}
								else
								{
									$ERROR = $json['message'];
									if(isset($json['Data'][0]['messagetext']))
									{
									$MSG=$json['Data'][0]['messagetext'];
									}
									else
									{ $MSG= 'error';
									}
								}
					}
					Session::flash('transbene_type',$ERROR );
					Session::flash('transbene_message',$MSG);
				}
				else
				{
					Session::flash('transbene_type',$ERRCODE );
					Session::flash('transbene_message',$ERRMSG);
				}
			}
			return redirect('user_dmtairtel_dashboard'); 
		}

		/**
        * Method name   : user pan request
        * @description  : Used for user pan request
        * @param        : Request data  
        * @return       : return with user pan request
    */
    public function user_pan_request()
    {
    	
    	$user = Helper::get_userdetail(Session::get('USER_ID'));
    	$pan_token = $this->pantoken_repo->getByUserId(Session::get('USER_ID'));
    	return view('User.pan_request', compact('user','pan_token'));
    }

    /**
        * Method name   : pan request
        * @description  : Used for adding user pan request
        * @param        : Request data  
        * @return       : return with user pan request
    */
    public function pan_request()
    {
    	$request = request();

    	$user = Helper::get_userdetail(Session::get('USER_ID'));

    	$this->validate($request, [
            'txt_pan_token'=> 'required',
            'txt_remark'=> 'required'
        ],[
            'txt_pan_token.required'=> 'Pan Token is required',
            'txt_remark.required'=> 'Remark is required'
        ]);

    	if($user[0]->PSA_LOGIN_ID != ''){
    		$trans_id=DB::select("select get_transaction_id() AS transid");
    		$arr = array(
	    		'm11_user_id' => Session::get('USER_ID'),
	    		'tr40_pan_transid'=> $trans_id[0]->transid,
	    		'tr40_pan_token' => $request->input('txt_pan_token'),
	    		'tr40_remark' => $request->input('txt_remark'),
	    		'tr40_pt_status' => 1,
	    		'm22_shop_psa_loginid' => $user[0]->PSA_LOGIN_ID
	    	);
	    	$this->pantoken_repo->create($arr);

	    	Session::flash('panup_msg','PAN REQUEST ADDED SUCCESSFULLY' );
        	Session::flash('type','success' );
    	}
    	else{
    		Session::flash('panup_msg','PSA LOGIN ID NOT EXISTS' );
        	Session::flash('type','success' );
    	}

    	return redirect('/user_pan_request');
    }


  /**
        * Method name   : get service name
        * @description  : Used for get service name request
        * @param        : Request data  
        * @return       : return with user get service name request
    */
    public function get_srv()
    {
    	$request = request();
		$service = DB::table("admin_service_charges")->where('SC_ID', $request->SERVICE_ID)->first();

		if($service->SERVICE_ID !='' ) 
		{
		$srvs =  DB::table('m03_service_type')->whereIn('m03_sr_type_id', explode(",",$service->SERVICE_ID))->get();
			return ['code' => 'success', 'data' => $srvs,  'rs' => $service->SC_AMOUNT ,  'srv' => explode(",",$service->SERVICE_ID)];
		}
		else
		{
			return ['code' => 'error', 'data' => ''];
		}
    }




	/**
        * Method name   : Update User Status
        * @description  : Used for update user Status
        * @param        : Request data 
        * @return       : return with update user Status
    */
	public function diactive_users()
	{
				$request = request();
				$get_useralldetail = Helper::get_useralldetail(Session::get('USER_ID'));
				$USER=Session::get('USER_ID');
				$old ='';
				
			if($request->txt_status =="INACTIVE" && $request->txt_id != ''){
				$old = 'ACTIVE';
			$data =	DB::table('m11_user')->where('m11_user_code', $request->txt_id)->update(['m11_user_status'=> '2']);
				Session::flash('type','success');
				Session::flash('message',"USER'S STATUS HAS BEEN CHANGED SUCCESSFULLY!");
			}
			elseif($request->txt_status =="ACTIVE" && $request->txt_id != ''){
					$old = 'INACTIVE';
			$data =	DB::table('m11_user')->where('m11_user_code', $request->txt_id)->update(['m11_user_status'=> '1']);
				Session::flash('type','success');
				Session::flash('message',"USER'S STATUS HAS BEEN CHANGED SUCCESSFULLY!");
			}
			else
			{
				Session::flash('type','error');
				Session::flash('message',"USER'S STATUS HAS BEEN NOT CHANGED!");
			}

				$arr = array(
					'tr11_ar_tblnm' => 'm11_user',
					'tr11_ar_old_value' => "m11_user_status = ".$old,
					'tr11_ar_new_value' => "m11_user_status = ".$request->txt_status, // json_encode($arr)
					'tr11_ar_uid' => $USER,
					'tr11_ar_description' => 'USERS STATUS HAS BEEN CHANGED SUCCESSFULLY!',
					'tr11_updated_by' => 2,
					'tr11_updated_by_id' =>  Session::get('USER_ID')
					);

				$mobileno_actionrecord=$this->log_repo->create($arr);

				return redirect('user_team_downline'); 
	}




   public function faileduser(Request $request)
    {        

				$dataarray = [
								  'm11_user_id' => Session::get('USER_ID'),
								  'm11_user_code' => Session::get('USER_CODE'),
								  'tr31_op_amount' => $request->txt_amount,
								  'tr31_op_currency' => 2,
								  'tr31_op_txnid' => $request->receiptId,
								  'tr31_op_paymentid' => $request->rzp_paymentid,
								  'tr31_op_gatewaytxn_id' => $request->rzp_orderid,
								  'tr31_op_gateway_res' => $request->rzp_signature,
								  'tr31_op_status' => 1,
								];

					DB::table('tr31_online_payment')->insert($dataarray);

					$ERRMSG="PAYMENT FAILED";
                    $ERRCODE="error";
					Session::flash('type',$ERRCODE );
					Session::flash('message',$ERRMSG );
					return redirect('user-add-money-wallet');
		}




	/**
			* Method name	: Level Wise Team 
			* @description 	: Used for Level Wise Team 
			* @param		: request data 
			* @return		: response user record
		*/
	public function level_userwise_team()
	{

		$start =  date('Y-m-d',strtotime('2021-01-01'));
		$end = date('Y-m-d',strtotime(NOW()));
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$txtuserid = Session::get('USER_ID'); $role='1';$pos='-1';
		$cond="";$topupst="ALL";$member_id="";
		$request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));

			if($request->input('txt_memberid')!='')
			$txtuserid = Helper::get_userid($request->input('txt_memberid'));

			$pos=$request->input('dd_pos');
		    $role=$request->input('dd_level');

			$cond ='';
			$cond1='';
        }
			if($role == '' && $role < 0)
			{
				$role = 1;
			}
			if($start != '' && $end != '')
			{
				$cond = "AND DATE_FORMAT(`enroll`.`CreatedDate`,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(`enroll`.`CreatedDate`,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d')";
			}
			else
			{
			  $cond = '';
			}
			if($txtuserid != '' && $txtuserid != 'false')
			{
					$refraldata = Session::get('USER_ID');

					for ($x = 1; $x <= $role; $x++) 
					{
						$data['user'] = DB::select("SELECT * FROM `enroll` WHERE `ReferralCode` IN (".$refraldata.") ".$cond);
						$data['level'] = $role;
						
						$refral=[];

							if(count($data['user']) > 0)
							{
								foreach($data['user'] as $key => $value){ array_push($refral, $value->RegId); }
								$refraldata =  implode(",",$refral);
							}
					}

			}


		$user_report = $data['user'];

		return view('User.level_wise_team', compact('user_report','topupst','start','end','pos','role','member_id','user'));
	}	

	public function aeps_settelment_report()
	{
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$data = DB::table('withdraw_request')->where('MEMBER_ID', Session::get('USER_ID'))->get();
		return view('User.user_aeps_settelmentreport',compact('user','data'));
	}


	public function aeps_settelment_reports(Request $request)
	{
		$user = Helper::get_userdetail(Session::get('USER_ID'));

				if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))<0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be negative.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$wr_mode=$request->input('baltypeto');
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
				//dd($ERRMSG, $ERRCODE, $this->isError);
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$fundreq=array('proc'=>2,'m23_user_bnkid'=>0,'m11_user_id'=>Session::get('USER_ID'),'tr26_wr_towallet'=>3,'tr26_wr_mode'=>$wr_mode,'tr26_wr_utrno'=>'','tr26_wr_amount'=>floatval($request->input('txt_amount')),'tr26_wr_transid'=>'','tr26_wr_des'=>'','tr26_wr_admin_res'=>'','tr26_wr_status'=>1,'tr26_wr_toadmin'=>1,'m11_user_referral_code'=>0,'m22_affiliate_id'=>Session::get('AFFILIATE_CODE'));
					$fund_request=DB::select('CALL withdraw_request(:proc,:m23_user_bnkid,:m11_user_id,:tr26_wr_towallet,:tr26_wr_mode,:tr26_wr_utrno,:tr26_wr_amount,:tr26_wr_transid,:tr26_wr_des,:tr26_wr_admin_res,:tr26_wr_status,:tr26_wr_toadmin,:m11_user_referral_code,:m22_affiliate_id,@status_code,@status_msg
					)',$fundreq);
				   $DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
                   $DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');

				   $ERRMSG=$DB_ERRMSG[0]->ERR_MSG;
                   $ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
				}
					Session::flash('type',$ERRCODE );
					Session::flash('message',$ERRMSG );
					return redirect('aeps_settelment_report');
	}




    /**
    * Method name   : orders
    * @description  : Used for viewing all user orders
    * @param        : Request data  
    * @return       : return view with all user orders
    */
    public function orders()
    {
        $request = request();
        $start = '2021-07-01';
        $end =  date('Y-m-d'); 
        $user_id = '';
        $order_id = '';
        $cond="";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
            $order_id = $request->input('txt_orderid');

            if($request->input('txt_memberid')!='')
            $user_id = Helper::get_userid($request->input('txt_memberid'));

            if($user_id != '' && $user_id != 'false')
            {
                $cond = $cond."`USER_ID` = $user_id  AND ";
            }
            if($order_id != '' && $order_id != 'false')
            {
                $cond = $cond."`ORDER_CODE` = '".$order_id."'  AND ";
            }
            if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
            {
                $cond = $cond."DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
            }
        }
        $cond = $cond." ORDER_STATUS != 'DELIVERED' AND CART_TYPE != 'WISHLIST' ";

        if(Session::get('USER_ROLE') == 'BRANCH')
        {
			$all_orders = DB::select('SELECT * FROM `user_orders` WHERE '.$cond.' ORDER BY ORDER_ID DESC');
        }
        else
        {
        	$all_orders = DB::select('SELECT * FROM `user_orders`
        	 WHERE USER_ID ='.Session::get('USER_ID').' AND '.$cond.' ORDER BY ORDER_ID DESC');
        }
    	
    	$user = Helper::get_userdetail(Session::get('USER_ID'));

    	return view('User.orders', compact('all_orders','user')); 
    }
    


    /**
    * Method name   : orders
    * @description  : Used for viewing all user orders
    * @param        : Request data  
    * @return       : return view with all user orders
    */
    public function delivered_orders()
    {
        $request = request();
        $start = '2021-07-01';
        $end =  date('Y-m-d'); 
        $user_id = '';
        $order_id = '';
        $cond="";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
            $order_id = $request->input('txt_orderid');

            if($request->input('txt_memberid')!='')
            $user_id = Helper::get_userid($request->input('txt_memberid'));

            if($user_id != '' && $user_id != 'false')
            {
                $cond = $cond."`USER_ID` = $user_id  AND ";
            }
            if($order_id != '' && $order_id != 'false')
            {
                $cond = $cond."`ORDER_CODE` = '".$order_id."'  AND ";
            }
            if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
            {
                $cond = $cond."DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
            }
        }
        $cond = $cond."ORDER_STATUS = 'DELIVERED' AND CART_TYPE != 'WISHLIST' ";
                
        if(Session::get('USER_ROLE') == 'BRANCH')
        {
			$all_orders = DB::select('SELECT * FROM `user_orders` WHERE '.$cond);
        }
        else
        {
        	$all_orders = DB::select('SELECT * FROM `user_orders`
        	 WHERE USER_ID ='.Session::get('USER_ID').' AND '.$cond);
        }
        
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('User.delivered-orders', compact('all_orders','user')); 
    }
    

    /**
            * Method name   : view orders
            * @description  : Used for viewing single order
            * @param        : request user id 
            * @return       : return view single order
        */
    public function view_order()
    {
        $request = request();
        $single_order = "";
         //dd('dfg');
        if($request->method() == 'POST')
        {
               if($request->input('txt_orderid')=='')
                {
                    $ERRMSG = "Order id should be valid or not blank.";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
                else
                {
                    $ERRMSG = "";
                    $this->isError=FALSE;
                    $ERRCODE="success";
                }
                
                if(request()->method() == 'POST' && $this->isError==FALSE)
                {
                    $single_order = $this->order_repo->getByOrderCode($request->input('txt_orderid'));
                    
                    if($single_order!=null)
                    {
                    $ERRMSG = "Order details fetch successfully.";
                    $ERRCODE="success";
                    }
                    else
                    {
                    $ERRMSG = "Order not found.";
                    $this->isError=TRUE;
                    $ERRCODE="warning";
                    }
                }
        }

        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('User.view_order',compact('single_order','user'));
     
    }


    /**
            * Method name   : view orders
            * @description  : Used for viewing single order
            * @param        : request user id 
            * @return       : return view single order
        */
    public function edit_order()
    {
        $request = request();
        $single_order = "";
        if(Session::get('USER_ROLE') != 'BRANCH')
        {
        	return back();
        }
        
        if($request->method() == 'POST')
        {
               if($request->input('txt_orderid')=='')
                {
                    $ERRMSG = "Order id should be valid or not blank.";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
                else
                {
                    $ERRMSG = "";
                    $this->isError=FALSE;
                    $ERRCODE="success";
                }
                
                if(request()->method() == 'POST' && $this->isError==FALSE)
                {
                    $single_order = $this->order_repo->getByOrderCode($request->input('txt_orderid'));
                    
                    if($single_order!=null)
                    {
                    $ERRMSG = "Order details fetch successfully.";
                    $ERRCODE="success";
                    }
                    else
                    {
                    $ERRMSG = "Order not found.";
                    $this->isError=TRUE;
                    $ERRCODE="warning";
                    }
                }

            	Session::flash('type',$ERRCODE );
				Session::flash('message',$ERRMSG );
        }
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('User.edit_order',compact('single_order','user'));
    }



    public function user_cancel_order()
    {
        $request = request();

        if($request->method() == 'POST')
        {
            if($request->input('txt_orderid')=='')
            {
                $ERRMSG = "Order id should be valid or not blank.";
                $this->isError= TRUE;
                $ERRCODE="warning";
            }
            else
            {
                $ERRMSG = "";
                $this->isError=FALSE;
                $ERRCODE="success";
            }
            if(request()->method() == 'POST'&& $this->isError==FALSE)
            {
                $id = $request->input('txt_orderid');
                $single_order = $this->order_repo->getByOrderCode($id);
				
                $ship = $this->ordersiping_repo->getByCartId($single_order[0]->ORDER_ID);

                if(count($ship) > 0)
                {
                	Session::flash('type','error' );
					Session::flash('message','your order has already been shipped' );
					return redirect('/user_orders');
                }

                $arrlog = array(
                    'tr11_ar_tblnm' => 'user_order',
                    'tr11_ar_old_value' => "ORDER_STATUS = ".$single_order[0]->ORDER_STATUS." PAYMENT_STATUS  =".$single_order[0]->PAYMENT_STATUS,
                    'tr11_ar_new_value' => "ORDER_STATUS = ".$request->dd_orstatus." PAYMENT_STATUS =".$request->dd_paystatus,
                    'tr11_ar_uid' => 1,
                    'tr11_ar_description' => 'USER ORDER CANCELLED SUCCESSFULLY!',
                    'tr11_updated_by' =>2,
                    'tr11_updated_by_id' =>  Session::get('USER_ID')
                    );
                

                $mobileno_actionrecord=$this->log_repo->create($arrlog);


                if($request->input('dd_orstatus') == 3 && count($ship) == 0)
                {	

                	if($single_order[0]->PAYMENT_STATUS == 'SUCCESS' && $single_order[0]->ORDER_STATUS != 'CANCELLED' && $single_order[0]->ORDER_STATUS != 'DELIVERED' && $single_order[0]->LEDGER_ID != '')
                	{

                	           $shoppingwallet=array(
						                'proc'=>10,
						                'to_user_id'=>Session::get('USER_ID'),
						                'from_user_id'=>0,
						                'amount'=>floatval(0.00),
						                'collected_amount'=>floatval(0.00),
						                'requesttype'=>1,
						                'balfor'=>1,
						                'transtype'=>1,
						                'timelimit'=>300,
						                'defaultstatus'=>1,
						                'remark'=>$single_order[0]->LEDGER_ID,
						                'collected_remark'=>"Shoping Payment"
						            );

						            $shopping_wallet = DB::SELECT('CALL wallettransfer(
						                :proc, 
						                :to_user_id,
						                :from_user_id,
						                :amount, 
						                :collected_amount,
						                :requesttype,
						                :balfor,
						                :transtype,
						                :timelimit,
						                :defaultstatus,
						                :remark,
						                :collected_remark,
						                @status_code,
						                @status_msg)'
						            ,$shoppingwallet);

						            $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
						            $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');

						if($ERRCODE[0]->ERR_CODE == 'success')
        				{
        					$this->order_repo->update($single_order[0]->ORDER_ID,['tr36_order_status' => 3]);
        				}
					}
                }
                else
                {
                	$this->order_repo->update($single_order[0]->ORDER_ID, ['tr36_order_status' => 3]);
                }


            	$ERRCODE = 'success';
            	$ERRMSG  = 'ORDER CANCELLED SUCCESSFULLY';

            }
            Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
        }
        return redirect('/user_orders');
    }





    public function update_order()
    {
        $request = request();
        if($request->method() == 'POST')
        {
            if($request->input('dd_orstatus')=='')
            {
                $ERRMSG = "Order status should be valid or not blank.";
                $this->isError= TRUE;
                $ERRCODE="warning";
            }
            else if($request->input('dd_paystatus')=='')
            {
                $ERRMSG = "Payment status should be valid or not blank.";
                $this->isError= TRUE;
                $ERRCODE="warning";
            }
            else
            {
                $ERRMSG = "";
                $this->isError=FALSE;
                $ERRCODE="success";
            }
            if(request()->method() == 'POST'&& $this->isError==FALSE)
            {
                $id = $request->input('txt_order_id');
                $single_order = $this->order_repo->getById($id);
                
                $arr = array(
                    'tr36_order_status' => $request->input('dd_orstatus'),
                    'tr36_payment_status' => $request->input('dd_paystatus')
                );


                $arrlog = array(
                    'tr11_ar_tblnm' => 'user_order',
                    'tr11_ar_old_value' => "ORDER_STATUS = ".$single_order[0]->ORDER_STATUS." PAYMENT_STATUS  =".$single_order[0]->PAYMENT_STATUS,
                    'tr11_ar_new_value' => "ORDER_STATUS = ".$request->dd_orstatus." PAYMENT_STATUS =".$request->dd_paystatus,
                    'tr11_ar_uid' => 1,
                    'tr11_ar_description' => 'ORDER STATUS HAS BEEN CHANGED SUCCESSFULLY!',
                    'tr11_updated_by' =>2,
                    'tr11_updated_by_id' =>  Session::get('USER_ID')
                    );
                

                $mobileno_actionrecord=$this->log_repo->create($arrlog);


                if($request->input('dd_orstatus') == 3)
                {	
                	if($single_order[0]->ORDER_STATUS != 'CANCELLED' && $single_order[0]->LEDGER_ID != '')
                	{

                	           $shoppingwallet=array(
						                'proc'=>10,
						                'to_user_id'=>Session::get('USER_ID'),
						                'from_user_id'=>0,
						                'amount'=>floatval(0.00),
						                'collected_amount'=>floatval(0.00),
						                'requesttype'=>1,
						                'balfor'=>1,
						                'transtype'=>1,
						                'timelimit'=>300,
						                'defaultstatus'=>1,
						                'remark'=>$single_order[0]->LEDGER_ID,
						                'collected_remark'=>"Shoping Payment"
						            );

						            $shopping_wallet = DB::SELECT('CALL wallettransfer(
						                :proc, 
						                :to_user_id,
						                :from_user_id,
						                :amount, 
						                :collected_amount,
						                :requesttype,
						                :balfor,
						                :transtype,
						                :timelimit,
						                :defaultstatus,
						                :remark,
						                :collected_remark,
						                @status_code,
						                @status_msg)'
						            ,$shoppingwallet);

						            $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
						            $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');

						if($ERRCODE[0]->ERR_CODE == 'success')
        				{
        					$this->order_repo->update($id,$arr);
        				}
        			
					}
                }
                else
                {
                	$this->order_repo->update($id,$arr);
                }

            }
            Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
        }
        return redirect('/user_orders');
    }


    public function update_revised_qty(request $request)
    {
          
            $single_order = $this->order_repo->getById($request->order_id);
            if(count($single_order) > 0)
            {

                $user_cart = json_decode($single_order[0]->PRODUCT_DETAILS);

                $prod_id_list = array_column($user_cart, 'prod_id');
                $varnt_id_list = array_column($user_cart, 'varnt_id');
                $is_variant_list = array_column($user_cart, 'is_variant');
                $count = count($user_cart);

                if(in_array($request->prod_id, $prod_id_list) && in_array($request->provar_id, $varnt_id_list) && in_array($request->proisvar, $is_variant_list))
                { 
                    for($i=0;$i<$count;$i++)
                    {
                        if(($user_cart[$i]->prod_id == $request->prod_id) && ($user_cart[$i]->varnt_id == $request->provar_id) && ($user_cart[$i]->is_variant == $request->proisvar))
                        {  
                            $index = $i;
                            $oldqty= $user_cart[$index]->new_quantity;
                            $user_cart[$index]->new_quantity = (int)($request->quantity);
                            $total = 0;
                            foreach ($user_cart as $value) {
                               $total += $value->new_quantity*$value->disc_price;
                            }
                              
                            $array = ['tr36_product_details' => json_encode($user_cart),
                                      'tr36_final_amount' => $total];

                            $data = $this->order_repo->update($request->order_id, $array);
                            if($data)
                            {

                                $arrlog = array(
                                    'tr11_ar_tblnm' => 'user_order',
                                    'tr11_ar_old_value' => "PRODUCT_DETAILS = ".$oldqty,
                                    'tr11_ar_new_value' => "PRODUCT_DETAILS = ".$user_cart[$index]->new_quantity,
                                    'tr11_ar_uid' => 1,
                                    'tr11_ar_description' => 'ORDER QTY HAS BEEN CHANGED SUCCESSFULLY!',
                                    'tr11_updated_by' => 2,
                                    'tr11_updated_by_id' =>  Session::get('USER_ID')
                                );

                                $mobileno_actionrecord=$this->log_repo->create($arrlog);

                                return 1;
                            }
                            else
                            {
                                return 2;
                            }
                        }
                    }
                }
            }
            else
            {
                return 2;
            }
    }



    /**
    * Method name   : game results
    * @description  : Used for viewing all user game results
    * @param        : Request data  
    * @return       : return view with all user game results
    */
    public function game_results()
    {
        $request = request();
        $start = '2021-07-01';
        $end =  date('Y-m-d'); 
        $user_id = '';
        $lottery_number = '';
        $cond="";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
            $lottery_number = $request->input('txt_lottery_number');
            $game_id = $request->input('dd_game');

            if($request->input('txt_memberid')!='')
            $user_id = Helper::get_userid($request->input('txt_memberid'));

            if($user_id != '' && $user_id != 'false')
            {
                $cond = $cond." AND `USER_ID` = $user_id";
            }
            if($lottery_number != '')
            {
                $cond = $cond." AND `LOTTERY_NUMBER` = '".$lottery_number."'";
            }
            if($game_id != '')
            {
                $cond = $cond." AND `GAME_ID` = '".$game_id."'";
            }
            if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
            {
                $cond = $cond." AND DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d')";
            }
        }

        $cond = $cond." ORDER BY ID DESC";
                
        $all_orders = DB::select('SELECT * FROM `user_game_bet` WHERE USER_ID ='.Session::get('USER_ID').' '.$cond);

        
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('User.game-results', compact('all_orders','user')); 
    }
    

    public function add_fund_wallet (Request $request)
    {
    	$user = Helper::get_userdetail(Session::get('USER_ID'));
    	$tron_recharge = DB::select('SELECT * FROM tron_recharge WHERE USER_ID='.Session::get('USER_ID').' ORDER BY TR_ID DESC');
        $qr_code = Session::get('QR_CODE');
        $transaction_data = json_decode(Session::get('TRANSACTION_DATA'));
    	return view('User.add_fund_wallet_trc', compact('user','qr_code','transaction_data','tron_recharge')); 
    }



    public function do_tronrecharge_back()
    {
    	 Session::forget('QR_CODE');
    	 Session::forget('TRANSACTION_DATA');
    	 return  back();
    }


	public function do_tronrecharge(Request $request){
	
		$user = Helper::get_userdetail(Session::get('USER_ID'));

		if($request->input('txt_amount')=='')
		{
			$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
			$this->isError=TRUE;
			$ERRCODE="warning";
		}
		else if(floatval($request->input('txt_amount'))<10)
		{
			$ERRMSG = "Amount should be greater than 10.";
			$this->isError= TRUE;
			$ERRCODE="warning";
		}
		else
		{
			$ERRMSG = "";
            $this->isError= FALSE;
            $ERRCODE="success";
		}
        if(request()->method() == 'POST' && $this->isError==FALSE)
        {
			Session::forget('QR_CODE');
			$result = CoinPayment::coinpayments_transactions('create_transaction',$request->input('txt_amount'), ['email' => Session::get('EMAIL')]);
	
			if($result['error'] != 'ok') {
				Session::flash('type','warning');
				Session::flash('message',$result['error']);
				return back();
			}

			$trans_id = $result['result']['txn_id'];
			$qr_code = $result['result']['qrcode_url'];
			$result1 = json_encode($result);
	

			 if($trans_id){
			 	$arr1 = array(
			 		'm11_user_id' => Session::get('USER_ID'),
			 		'tr40_amt' =>$request->input('txt_amount'),
					'tr40_invoice_id' => 1,
			 		'tr40_status' => 1
			 	);
			 	$last_id = DB::table('tr40_tron_recharge')->insertGetId($arr1);

			 	$arr = array(
			 		'tr40_id' => $last_id,
			 		'm11_user_id' => Session::get('USER_ID'),
			 		'tr43_trans_id' => $trans_id,
					'tr43_response' => $result1,
			 		'tr43_qrcode' => $qr_code
			 	);
			 	DB::table('tr43_tron_pay_response')->insert($arr);
			 }

			Session::put('QR_CODE', $qr_code);
			Session::put('TRANSACTION_DATA', json_encode($result['result']));
		}

		if($ERRMSG != '') 
		{
			Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );			
		}

		return redirect('/add-fund-wallet');
    }






    public function add_fund_wallet_vcl (Request $request)
    {
    	$user = Helper::get_userdetail(Session::get('USER_ID'));
    	$tron_recharge = DB::select('SELECT * FROM vcl_pay_response WHERE USER_ID='.Session::get('USER_ID').' ORDER BY ID DESC');
        $vcl_email = Cookie::get('VCL_EMAIL');
        $vclamount = Cookie::get('VCL_AMOUNT');
        $vclcode = Cookie::get('VCL_CODE');
        $vclemail = '';
        if($vcl_email != '')
        {
        	$vemail = explode("@", $vcl_email);

        	if(count($vemail) > 1)
        	{	
        		$lenth = strlen($vemail[0]);
        		if($lenth > 3)
        		{
        			$number = $lenth-3;	
        			$replace = '';
        			
        			for ($i=0; $i < $number; $i++) { 
        				$replace = $replace.'*';
        			}

        			$femail = substr($vemail[0], 0, - $number).$replace;
        			$vclemail = $femail.$vemail[1];
        		}
        	}
        }

    	return view('User.add_fund_wallet_vcl', compact('user','vclemail','vclamount','vcl_email','vclcode','tron_recharge')); 
    }


	public function add_fundwallet_vcl(Request $request){
	
		$user = Helper::get_userdetail(Session::get('USER_ID'));

		if($request->input('txt_amount')=='')
		{
			$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
			$this->isError=TRUE;
			$ERRCODE="warning";
		}
		else if($request->input('txt_vcrrlive')=='')
		{
			$ERRMSG = "Vcrrlive (VCL) Id should be valid or not blank.";
			$this->isError=TRUE;
			$ERRCODE="warning";
		}
		else if(floatval($request->input('txt_amount'))<10)
		{
			$ERRMSG = "Amount should be greater than 10.";
			$this->isError= TRUE;
			$ERRCODE="warning";
		}
		else
		{
			$ERRMSG = "";
            $this->isError= FALSE;
            $ERRCODE="success";
		}
        if(request()->method() == 'POST' && $this->isError==FALSE)
        {

        	if($user[0]->VCLEmail == '')
        	{
	        	$url = "https://vcrrlive.com/ApiVivek.aspx?Id=".$request->txt_vcrrlive; 
	        	$response=Helper::_curl_execute('GET',$url,'');
				$response=json_decode($response); 
				if(!isset($response->mail))
				{
					Session::flash('type','warning');
					Session::flash('message','Invalid vcl id');
					return back();
				} 

				$otp = rand(000000,999999);

				$template_type = 1;
				$data = array(
					'msg_title' => 'vcl_acount_verify',
					'name' => session()->get('NAME'),
					'useremail' => session()->get('EMAIL'),
					'usercode' => session()->get('USER_CODE'),
					'password' => $otp,
					'link' => url('/home'),
					'trans_id' => url('/home'),
					'template_name' => 'email'
				);


				DB::table("tr04_login")->where("m11_user_id", $user[0]->RegId)->update(["tr04_lb_otp" =>  $otp]);

				$msg_config = DB::select('select * from m09_message_config where m09_msg_title = "'.$data['msg_title'].'"');
				$data['MSG_CONTENT'] = $msg_config[0]->m09_msg_content;
				$data['MSG_SUBJECT'] = $msg_config[0]->m09_msg_subject;
				$data['MSG_CONTENT'] = strtr($data['MSG_CONTENT'], array('{name}' => $data['name'],
				'{useremail}'=>$data['useremail'],'{password}'=>$data['password'],'{link}'=>$data['link'],'{trans_id}'=>$data['trans_id']));
				$data['pdf'] ='';
				$template_data = $data;
				//Mail::to($response->mail)->send(new SendMail($template_data, $template_type));
				$cookie1 = Cookie::make('VCL_AMOUNT', $request->txt_amount, 60);
				$cookie2 = Cookie::make('VCL_EMAIL', $response->mail, 60);
				$cookie3 = Cookie::make('VCL_CODE', $request->txt_vcrrlive, 60);
			 	Session::flash('type','warning');
				Session::flash('message','Please verify Your Acount vcl email id received verification code');
				return back()->withCookie($cookie1)->withCookie($cookie2)->withCookie($cookie3);
   		
        	}
        	else
        	{

		    	$trans_id = DB::select("SELECT get_transaction_id() AS  TRANS_ID");
        		if(count($trans_id) == 0) { return back(); }
        		$tid = $trans_id[0]->TRANS_ID;
        		$amt = $request->input('txt_amount');
        		$url = "https://vcrrlive.com/APIVivekReturns.aspx?user_code=".$user[0]->RegCode."&trans_id=".$tid."&vrcr_code=".$user[0]->VCLCode."&Amount=".$amt;
	        	$response = Helper::_curl_execute('GET',$url,'');
				$responses = json_decode($response);
		
	        	$returnid = DB::table("tr49_vcl_pay_response")->insertGetId([
        													"m11_user_id" =>  $user[0]->RegId,
        													"tr03_trans_id" =>  $tid,
        													"tr49_amount" =>  $amt,
        													"tr49_response" =>  $response,
        													"tr49_status" =>  $responses->Status,
        													]);

	        	if($responses->Status == "success")
	        	{

					$fundtransfer_data=array(
						'proc'=>12,
						'to_user_id'=>$user[0]->RegId,
						'from_user_id'=>$returnid,
						'amount'=>floatval($amt),
						'collected_amount'=>floatval($amt),
						'requesttype'=>1,
						'balfor'=>1,
						'transtype'=>1,
						'timelimit'=>(config('FUND_INTERVAL')*60),
						'defaultstatus'=>1,
						'remark'=> $tid,
						'collected_remark'=>$amt.' RS Add Money Wallet Successfully Via Vcrrlive',
						);

						$fundtransfer = DB::SELECT('CALL wallettransfer(
						:proc, 
						:to_user_id,
						:from_user_id,
						:amount, 
						:collected_amount,
						:requesttype,
						:balfor,
						:transtype,
						:timelimit,
						:defaultstatus,
						:remark,
						:collected_remark,
						@status_code,
						@status_msg)'
						,$fundtransfer_data);
						$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
						$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
						$ERRCODE=$ERRCODE[0]->ERR_CODE;
						$ERRMSG=$ERRMSG[0]->ERR_MSG;

						$msg =  $amt.' RS Add Money Wallet Successfully Via Vcrrlive';

						if($ERRCODE=="success")
						{
							Session::flash('message', $msg);
							Session::flash('type', 'success');
							return redirect('/add-fund-wallet-vcl');
						}
						else
						{
								Session::flash('message', $ERRMSG);
								Session::flash('type', 'warning');
								return redirect('/add-fund-wallet-vcl');
						}

	        	}
	        	else
	        	{
					Session::flash('message', $responses->Msg);
					Session::flash('type', 'warning');
					return redirect('/add-fund-wallet-vcl');
	        	}

        	}
		}

		if($ERRMSG != '') 
		{
			Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );			
		}

		return redirect('/add-fund-wallet-vcl');
    }



	public function add_fundwallet_vcl_verify(Request $request){
	
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		

		if($request->input('txt_amount')=='')
		{
			$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
			$this->isError=TRUE;
			$ERRCODE="warning";
		}
		else if(count($user) == 0)
		{
			$ERRMSG = "user code should be valid or not blank.";
			$this->isError=TRUE;
			$ERRCODE="warning";
		}
		else if($request->input('txt_vcrrlive')=='')
		{
			$ERRMSG = "Vcrrlive (VCL) Id should be valid or not blank.";
			$this->isError=TRUE;
			$ERRCODE="warning";
		}	
		else if($request->input('txt_email')=='')
		{
			$ERRMSG = "email should be valid or not blank.";
			$this->isError=TRUE;
			$ERRCODE="warning";
		}	
		else if($request->input('txt_vcl_otp')=='')
		{
			$ERRMSG = "Otp should be valid or not blank.";
			$this->isError=TRUE;
			$ERRCODE="warning";
		}
		else if(floatval($request->input('txt_amount'))<10)
		{
			$ERRMSG = "Amount should be greater than 10.";
			$this->isError= TRUE;
			$ERRCODE="warning";
		}
		else
		{
			$ERRMSG = "";
            $this->isError= FALSE;
            $ERRCODE="success";
		}
        if(request()->method() == 'POST' && $this->isError==FALSE)
        {
        	$user_otp = DB::select("SELECT tr04_lb_otp AS USER_OTP FROM tr04_login WHERE m11_user_id = ".$user[0]->RegId."");

        	if(count($user_otp) > 0)
        	{
        		if($user_otp[0]->USER_OTP == $request->txt_vcl_otp)
        		{
        			$check = DB::table("m11_user")->where("m11_user_id", $user[0]->RegId)->update([
        													"m11_vcl_email_id" =>  $request->txt_email,
        													"m11_vcl_code" =>  $request->txt_vcrrlive,
        													]);

        			if($check)
        			{
        				Cookie::queue(Cookie::forget('VCL_EMAIL'));
				    	Cookie::queue(Cookie::forget('VCL_AMOUNT'));
				    	Cookie::queue(Cookie::forget('VCL_CODE'));


				    	$trans_id = DB::select("SELECT get_transaction_id() AS  TRANS_ID");
		        		if(count($trans_id) == 0) { return back(); }
		        		$tid = $trans_id[0]->TRANS_ID;
		        		$amt = $request->input('txt_amount');
		        		$url = "https://vcrrlive.com/APIVivekReturns.aspx?user_code=".$user[0]->RegCode."&trans_id=".$tid."&vrcr_code=".$request->txt_vcrrlive."&Amount=".$amt;
			        	$response = Helper::_curl_execute('GET',$url,'');
						$responses = json_decode($response);
				
			        	$returnid = DB::table("tr49_vcl_pay_response")->insertGetId([
		        													"m11_user_id" =>  $user[0]->RegId,
		        													"tr03_trans_id" =>  $tid,
		        													"tr49_amount" =>  $amt,
		        													"tr49_response" =>  $response,
		        													"tr49_status" =>  $responses->Status,
		        													]);

			        	if($responses->Status == "success")
			        	{

							$fundtransfer_data=array(
								'proc'=>12,
								'to_user_id'=>$user[0]->RegId,
								'from_user_id'=>$returnid,
								'amount'=>floatval($amt),
								'collected_amount'=>floatval($amt),
								'requesttype'=>1,
								'balfor'=>1,
								'transtype'=>1,
								'timelimit'=>(config('FUND_INTERVAL')*60),
								'defaultstatus'=>1,
								'remark'=> $tid,
								'collected_remark'=>$amt.' RS Add Money Wallet Successfully Via Vcrrlive',
								);

								$fundtransfer = DB::SELECT('CALL wallettransfer(
								:proc, 
								:to_user_id,
								:from_user_id,
								:amount, 
								:collected_amount,
								:requesttype,
								:balfor,
								:transtype,
								:timelimit,
								:defaultstatus,
								:remark,
								:collected_remark,
								@status_code,
								@status_msg)'
								,$fundtransfer_data);
								$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
								$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
								$ERRCODE=$ERRCODE[0]->ERR_CODE;
								$ERRMSG=$ERRMSG[0]->ERR_MSG;

								$msg =  $amt.' RS Add Money Wallet Successfully Via Vcrrlive';

								if($ERRCODE=="success")
								{
									Session::flash('message', $msg);
									Session::flash('type', 'success');
									return redirect('/add-fund-wallet-vcl');
								}
								else
								{
										Session::flash('message', $ERRMSG);
										Session::flash('type', 'warning');
										return redirect('/add-fund-wallet-vcl');
								}

			        	}
			        	else
			        	{
							Session::flash('message', $responses->Msg);
							Session::flash('type', 'warning');
							return redirect('/add-fund-wallet-vcl');
			        	}
        			}
        		} 
        		else
        		{
    				Session::flash('type','warning');
					Session::flash('message','Invalid OTP.');
					return back();
        		}
        	}
		}

		if($ERRMSG != '') 
		{
			Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );			
		}

		return redirect('/add-fund-wallet-vcl');
    }


    public function cancelled_fundwallet_vcl(Request $request)
    {
    	Cookie::queue(Cookie::forget('VCL_EMAIL'));
    	Cookie::queue(Cookie::forget('VCL_AMOUNT'));
    	Cookie::queue(Cookie::forget('VCL_CODE'));
    	return redirect('/add-fund-wallet-vcl');
    }







	public function status_check()
    {
    	if(session()->has('QR_CODE')) {
    		Session::forget('QR_CODE');
    		Session::forget('TRANSACTION_DATA');
    	}


    	$transaction = DB::select("SELECT * FROM tron_recharge WHERE STATUS='PENDING' ORDER BY TR_ID DESC");
    	foreach($transaction as $values){
    		$result = CoinPayment::coinpayments_transaction_status('get_tx_info',$values->TRANS_ID);
			if(isset($result['result']['status']))
			{
					$status = $result['result']['status'];
					$status_text = $result['result']['status_text'];

					$arr = array(
						'tr43_status' => (string)$status,
						'tr43_status_text' => (string)$status_text
					);

					DB::table('tr43_tron_pay_response')->where('tr43_tron_pay_id',$values->PAY_ID)->update($arr);

					if($status=='100' && $status_text=='Complete' && ($values->TR_ID == $values->TRNEW_ID)) {
						$arr1 = array(
							'tr40_status' => 2
						);
						DB::table('tr40_tron_recharge')->where('tr40_id',$values->TR_ID)->update($arr1);

						$recharge=array(
							'proc'=>1,
							'txt_userid'=>$values->USER_ID,
							'txt_amt'=>$values->AMOUNT
						);
						$tron_recharge = DB::select('CALL tron_recharge(:proc,:txt_userid,:txt_amt,@status_code,@status_msg)',$recharge);

						$DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
						$DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
						$ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
						$ERRMSG=$DB_ERRMSG[0]->ERR_MSG;
					} else if($status=='-1' && ($values->TR_ID == $values->TRNEW_ID)) {
						$arr1 = array(
							'tr40_status' => 3
						);
						DB::table('tr40_tron_recharge')->where('tr40_id',$values->TR_ID)->update($arr1);
					}
			}
    	}

    	return redirect('/add-fund-wallet');

    }




	public function status_check_cron()
    {

    	$transaction = DB::select("SELECT * FROM tron_recharge WHERE STATUS='PENDING' ORDER BY TR_ID DESC");
    	foreach($transaction as $values){
    		$result = CoinPayment::coinpayments_transaction_status('get_tx_info',$values->TRANS_ID);
			if(isset($result['result']['status']))
			{
					$status = $result['result']['status'];
					$status_text = $result['result']['status_text'];

					$arr = array(
						'tr43_status' => (string)$status,
						'tr43_status_text' => (string)$status_text
					);

					DB::table('tr43_tron_pay_response')->where('tr43_tron_pay_id',$values->PAY_ID)->update($arr);

					if($status=='100' && $status_text=='Complete' && ($values->TR_ID == $values->TRNEW_ID)) {
						$arr1 = array(
							'tr40_status' => 2
						);
						DB::table('tr40_tron_recharge')->where('tr40_id',$values->TR_ID)->update($arr1);

						$recharge=array(
							'proc'=>1,
							'txt_userid'=>$values->USER_ID,
							'txt_amt'=>$values->AMOUNT
						);
						$tron_recharge = DB::select('CALL tron_recharge(:proc,:txt_userid,:txt_amt,@status_code,@status_msg)',$recharge);

						$DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
						$DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
						$ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
						$ERRMSG=$DB_ERRMSG[0]->ERR_MSG;
						//dd($ERRCODE, $ERRMSG, $recharge);
					} else if($status=='-1' && ($values->TR_ID == $values->TRNEW_ID)) {
						$arr1 = array(
							'tr40_status' => 3
						);
						DB::table('tr40_tron_recharge')->where('tr40_id',$values->TR_ID)->update($arr1);
					}
			}
    	}

    	return 1;

    }


	public function status_url()
    {
    	$transaction = DB::select("SELECT * FROM tr43_tron_pay_response WHERE m11_user_id=".Session::get('USER_ID')." AND tr43_status=0 ORDER BY tr43_tron_pay_id DESC");
    	foreach($transaction as $values){
    		$result = CoinPayment::coinpayments_transaction_status('get_tx_info',$values->tr43_trans_id);
			$status = $result['result']['status'];
			$status_text = $result['result']['status_text'];
    		$arr = array(
				'tr43_status' => $status,
				'tr43_status_text' => $status_text
			);
			DB::table('tr43_tron_pay_response')->where('tr43_tron_pay_id',$values->tr43_tron_pay_id)->update($arr);
    	}

    	return 1;
    }


    // public function update_directbusiness($user_id)
    // {
    // 	$ct1=0;$lvl_status=1;
    // 	DB::select("CALL get_intro_downline(".$user_id.")");
    // 	$diect_id=DB::select("SELECT `m11_user_id`,`tr19_toppup_amount` FROM `tr19_user_topup` WHERE `m11_user_id` IN (SELECT member_id FROM tmp_downline WHERE level_id=1) GROUP BY `m11_user_id`");
    // 	foreach($diect_id  as $key => $values)
    // 	{
    // 	$ct1=$key+1;
    // 	DB::select("CALL get_intro_downline(".$values->m11_user_id.")");
	// 	$TB=DB::select("SELECT IFNULL(SUM(tr19_toppup_amount),0.00) AS TB FROM `tr19_user_topup` WHERE `m11_user_id` IN (SELECT member_id AS tc FROM tmp_downline)");
	// 	$count=DB::select("SELECT IFNULL(COUNT(*),0) AS CT FROM `tr50_totallevel_income` WHERE m11_user_id =".$user_id." AND tr50_user_atlevel =".$values->m11_user_id);
	// 			echo $count[0]->CT;
	// 			echo $values->m11_user_id;

	// 			if($count[0]->CT==0)
	// 			{
	// 				if(($TB[0]->TB+$values->tr19_toppup_amount)>999)
	// 				{
	// 					$lvl_status=2;
	// 				}
	// 				if (($TB[0]->TB+$values->tr19_toppup_amount)>0)
	// 				{
	// 				DB::table('tr50_totallevel_income')->insert(['m11_user_id'=>$user_id,'tr50_user_atlevel'=>$values->m11_user_id,'tr50_user_level'=>$ct1,'tr50_user_bybusiness' => ($TB[0]->TB+$values->tr19_toppup_amount), 'tr50_level_status' => $lvl_status]);
	// 				}
	// 				//echo("INSERT-".$user_id."". $ct1."/n");
	// 			}
	// 			else
	// 			{
	// 				if(($TB[0]->TB+$values->tr19_toppup_amount)>999)
	// 				{
	// 					$lvl_status=2;
	// 				}
	// 				if(($TB[0]->TB+$values->tr19_toppup_amount)>0)
	// 				{
	// 		DB::table('tr50_totallevel_income')->where("m11_user_id", $user_id)->where("tr50_user_atlevel", $values->m11_user_id)->where("tr50_user_level",$ct1)->update(['tr50_user_bybusiness'=>($TB[0]->TB+$values->tr19_toppup_amount),'tr50_level_status' => $lvl_status]);
	// 		//echo("Update-".$user_id."". $ct1."/n");
	// 				}
			
	// 			}
	
	// 	}
	// 		//dd();
    // }

 public function update_business()
    {
    	$ct1=0;$lvl_status=1;
    	$data=DB::select("SELECT `m11_user_id` FROM `m11_user` WHERE 1 ORDER BY m11_user_id");
    	
    	foreach($data as $values0)
    	{
    		$ct1=0;
    		$user_id=$values0->m11_user_id;

    		DB::select("CALL get_intro_downline(".$user_id.")");
    		$diect_id=DB::select("SELECT `m11_user_id`,`tr19_toppup_amount` FROM `tr19_user_topup` WHERE `m11_user_id` IN (SELECT member_id FROM tmp_downline WHERE level_id=1) GROUP BY `m11_user_id`");
    		foreach($diect_id  as $key => $values)
    	    {
	    	$ct1=$key+1;$lvl_status=1;
	    	DB::select("CALL get_intro_downline(".$values->m11_user_id.")");
			$TB=DB::select("SELECT IFNULL(SUM(tr19_toppup_amount),0.00) AS TB FROM `tr19_user_topup` WHERE `m11_user_id` IN (SELECT member_id AS tc FROM tmp_downline)");
		//	dd($TB,$values->m11_user_id);
			$count=DB::select("SELECT IFNULL(COUNT(*),0) AS CT FROM `tr50_totallevel_income` WHERE m11_user_id =".$user_id." AND tr50_user_atlevel =".$values->m11_user_id);
				if($count[0]->CT==0)
				{
					if(($TB[0]->TB+$values->tr19_toppup_amount)>999)
					{
						$lvl_status=2;
					}
					if (($TB[0]->TB+$values->tr19_toppup_amount)>0)
					{
				DB::table('tr50_totallevel_income')->insert(['m11_user_id'=>$user_id,'tr50_user_atlevel'=>$values->m11_user_id,'tr50_user_level'=>$ct1,'tr50_user_bybusiness' => ($TB[0]->TB+$values->tr19_toppup_amount), 'tr50_level_status' => $lvl_status]);
			}
				}
				else
				{
					if(($TB[0]->TB+$values->tr19_toppup_amount)>999)
					{
						$lvl_status=2;
					}
					if(($TB[0]->TB+$values->tr19_toppup_amount)>0)
					{
			DB::table('tr50_totallevel_income')->where("m11_user_id", $user_id)->where("tr50_user_atlevel", $values->m11_user_id)->where("tr50_user_level",$ct1)->update(['tr50_user_bybusiness'=>($TB[0]->TB+$values->tr19_toppup_amount),'tr50_level_status' => $lvl_status]);
		///	echo("Update-".$user_id."". $ct1."/n");
					}
			
				}
		
			}
			
		}
    }
/*
public function update_directbusiness($user_id)
{
	$ct1=0;
    		
            $diect_id=DB::select("SELECT DISTINCT(`m11_user_id`) FROM `tr19_user_topup` WHERE `m11_user_referral_code`=".$user_id."");
    		foreach($diect_id  as $key => $values)
    	    {
	    	$ct1=$key+1;$lvl_status=1;
			$TB=DB::select("SELECT MIN(`tr19_user_tpid`),IFNULL((tr19_toppup_amount),0.00)  AS TB FROM `tr19_user_topup` WHERE `m11_user_id`=".$values->m11_user_id."");
		//	dd($TB,$values->m11_user_id);
			$count=DB::select("SELECT IFNULL(COUNT(*),0) AS CT FROM `tr50_totallevel_income` WHERE m11_user_id =".$user_id." AND tr50_user_atlevel =".$values->m11_user_id);
				if($count[0]->CT==0)
				{
				DB::table('tr50_totallevel_income')->insert(['m11_user_id'=>$user_id,'tr50_user_atlevel'=>$values->m11_user_id,'tr50_user_level'=>$ct1,'tr50_user_bybusiness' => ($TB[0]->TB), 'tr50_level_status' => $lvl_status]);
			    
			    }
		
			}
}*/

public function update_directbusiness($user_id)
{
	$ct1=0;
            $diect_id=DB::select("SELECT IFNULL(`m11_user_id`,0) as m11_user_id ,SUM(`tr19_toppup_amount`) AS tr19_toppup_amount FROM `tr19_user_topup` WHERE `m11_user_referral_code`=".$user_id." GROUP BY `m11_user_id`");
            //dd( $diect_id);
         if( count($diect_id)>0)
         {
    		foreach($diect_id  as $key => $values)
    	    {
	    	$ct1=$key+1;$lvl_status=1;
	    	DB::select("CALL get_intro_downline(".$values->m11_user_id.")");
			$TB=DB::select("SELECT IFNULL(SUM(tr19_toppup_amount),0.00) AS TB FROM `tr19_user_topup` WHERE `m11_user_id` IN (SELECT member_id AS tc FROM tmp_downline)");
			$count=DB::select("SELECT IFNULL(COUNT(*),0) AS CT FROM `tr50_totallevel_income` WHERE m11_user_id =".$user_id." AND tr50_user_atlevel =".$values->m11_user_id);
				if($count[0]->CT==0)
				{
					if(($TB[0]->TB+$values->tr19_toppup_amount)>999)
					{
						$lvl_status=2;
					}
					if (($TB[0]->TB+$values->tr19_toppup_amount)>0)
					{
				DB::table('tr50_totallevel_income')->insert(['m11_user_id'=>$user_id,'tr50_user_atlevel'=>$values->m11_user_id,'tr50_user_level'=>$ct1,'tr50_user_bybusiness' => ($values->tr19_toppup_amount),'tr50_user_teambusiness'=> ($TB[0]->TB+$values->tr19_toppup_amount), 'tr50_level_status' => $lvl_status]);
			}
				}
				else
				{
					if(($TB[0]->TB+$values->tr19_toppup_amount)>999)
					{
						$lvl_status=2;
					}
					if(($TB[0]->TB+$values->tr19_toppup_amount)>0)
					{
			DB::table('tr50_totallevel_income')->where("m11_user_id", $user_id)->where("tr50_user_atlevel", $values->m11_user_id)->where("tr50_user_level",$ct1)->update(['tr50_user_bybusiness' => ($values->tr19_toppup_amount),'tr50_user_teambusiness'=> ($TB[0]->TB+$values->tr19_toppup_amount), 'tr50_level_status' => $lvl_status]);
		//echo("Update-".$user_id."". $ct1."/n");
					}
			
				}
		
			}
		}
}
 public function update_business1()
    {
    	$ct1=0;$lvl_status=1;
    	$data=DB::select("SELECT `m11_user_id` FROM `m11_user` WHERE 1 ORDER BY m11_user_id");
    	
    	foreach($data as $values0)
    	{
    		$ct1=0;
    		$user_id=$values0->m11_user_id;
            $diect_id=DB::select("SELECT DISTINCT(`m11_user_id`) FROM `tr19_user_topup` WHERE `m11_user_referral_code`=".$user_id."");
    		foreach($diect_id  as $key => $values)
    	    {
	    	$ct1=$key+1;$lvl_status=1;
			$TB=DB::select("SELECT MIN(`tr19_user_tpid`),IFNULL((tr19_toppup_amount),0.00)  AS TB FROM `tr19_user_topup` WHERE `m11_user_id`=".$values->m11_user_id."");
		//	dd($TB,$values->m11_user_id);
			$count=DB::select("SELECT IFNULL(COUNT(*),0) AS CT FROM `tr50_totallevel_income` WHERE m11_user_id =".$user_id." AND tr50_user_atlevel =".$values->m11_user_id);
				if($count[0]->CT==0)
				{
				DB::table('tr50_totallevel_income')->insert(['m11_user_id'=>$user_id,'tr50_user_atlevel'=>$values->m11_user_id,'tr50_user_level'=>$ct1,'tr50_user_bybusiness' => ($TB[0]->TB), 'tr50_level_status' => $lvl_status]);
			    
			    }
		
			}
			
		}
    }




  public function user_rank_reward(Request $request)
    {
    	$user_id = (int)Session::get('USER_ID');
    	$user = Helper::get_userdetail(Session::get('USER_ID'));
       	$current_lvl_reportPL = DB::select("SELECT * FROM `totallevel_income` WHERE `USER_ID`=". Session::get('USER_ID')." ORDER BY USER_BYBUSINESS DESC LIMIT 1");
       	$current_reward = DB::select("SELECT IFNULL(`m47_reward_id`,0) as `m47_reward_id`, COUNT(*) as ct FROM `tr40_user_reward` WHERE m11_user_id=". Session::get('USER_ID')." AND `tr40_status`= 4 LIMIT 1");
       	$current_reward=$current_reward[0];
       	 	
	    $current_lvl_report = [];
	    if(count($current_lvl_reportPL) > 0)
	    {
	    	$current_lvl_report = DB::select("SELECT * FROM `totallevel_income` WHERE `USER_ID`=". Session::get('USER_ID')." AND TOTLEVEL_INCOMEID !=  ".$current_lvl_reportPL[0]->TOTLEVEL_INCOMEID." GROUP BY USER_ATLEVEL ORDER BY USER_BYBUSINESS DESC  LIMIT 2");
	    }


    $business_volume_report =  DB::select("SELECT USER_ID, USER_BYBUSINESS AS FIRST_LEG, (SELECT SUM(USER_BYBUSINESS) FROM totallevel_income WHERE USER_ID = $user_id)-USER_BYBUSINESS AS OTHER_LEG FROM totallevel_income WHERE USER_ID = $user_id ORDER BY USER_BYBUSINESS DESC LIMIT 1");
dd($current_lvl_report);
    	return view('User.bonanza_status', compact('user','current_lvl_report','business_volume_report','current_reward')); 
    
    }

    public function update_reward(Request $request)
    {
    	
    	$user_id = (int)$request->user_id;
    	$reward_id = (int)$request->reward_id;
    	$user = Helper::get_userdetail(Session::get('USER_ID'));
    	
       	  $last_reward_id=DB::select("SELECT COUNT(*) AS reward_count FROM `tr40_user_reward` WHERE `m47_reward_id`=$reward_id AND `m11_user_id`=".$user_id." LIMIT 1");
       	  
       	  if($last_reward_id[0]->reward_count==0)
       	  {
       	  	DB::table('tr40_user_reward')->insert(['m11_user_id'=>$user_id,'m47_reward_id'=>$reward_id,'tr40_status'=>4,'tr40_remark' => 'START']);
       	  }
       	  return($last_reward_id[0]->reward_count);
       	 
    
    }
    

}?>