<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\Ticket\TicketRepository;
use App\Repositories\Enroll\EnrollRepository;
use App\Repositories\Employee\EmployeeRepository;
use DB;
use Image;
use Session;
use Helper; 
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;

class TicketController extends Controller
{

    private $ticket_repo;
    private $enroll_repo;
	private $emp_repo;

    public function __construct(TicketRepository $ticket_repo, EmployeeRepository $emp_repo, EnrollRepository $enroll_repo)
    {
        $this->ticket_repo = $ticket_repo;
        $this->enroll_repo = $enroll_repo;
		$this->emp_repo = $emp_repo;
    }

	/**
        * Method name   : Get Query
        * @description  : Used for getting user queries
        * @param        : Request data 
        * @return       : return with user queries
    */
    public function get_query()
    {
    	$user = Helper::get_userdetail(Session::get('USER_ID'));
    	$tickets = $this->ticket_repo->getByUserId($user[0]->RegId);
    	return view('User.submit_query', compact('user', 'tickets'));
    }





	/**
        * Method name   : filter Ticket Reply
        * @description  : Used for ticket reply
        * @param        : Request data
        * @return       : return with ticket reply
    */
    public function filter_ticket_reply(request $request)
    {
        $users = $this->enroll_repo->getActiveUser();
		$emp = $this->emp_repo->getActiveEmployee();

		$urgency = '';
		$ticket_id = '';
		$ticket_type = '';
		$formdate = '';
		$todate = '';
		$client = ''; 
		$employee = '';
		$ticket_status = '';

		$user = Helper::get_userdetail(Session::get('USER_ID'));

		if($request->dd_urgency != null)
		{
			$urgency = " AND URGENCY = ".$request->dd_urgency;
		}
		if($request->txt_ticket != null)
		{
			$ticket_id = " AND TICKET_NO = '".$request->txt_ticket."' ";
		}
		if($request->dd_ticket != null)
		{
			$ticket_type = " AND TICKET_FOR = ".$request->dd_ticket;
		}
		if($request->dd_client != null)
		{
			$client = " AND USER_ID = ".$request->dd_client;
		}
		if($request->dd_employee != null)
		{
			$employee = " AND EMP_ID = ".$request->dd_employee;
		}
		if($request->txtfromdate != null && $request->txttodate != null)
		{
			$formdate = " AND CREATED_AT BETWEEN ".$request->txtfromdate." AND ".$request->txttodate;
		}
		if($request->txttodate != null && $request->txtfromdate == null)
		{
			$formdate =  " AND CREATED_AT = ".$request->txttodate;
		}
		if($request->txttodate == null && $request->txtfromdate != null)
		{
			$formdate =  " AND CREATED_AT = ".$request->txttodate;
		}
		if($request->dd_status != null)
		{
			$ticket_status = " AND STATUS = ".$request->dd_status;
		}

	   $tickets =  DB::select("SELECT * FROM `ticket` WHERE TICKET_NO IS NOT NULL " . $urgency . $ticket_id . $formdate .  $todate . $ticket_type . $employee . $client .  $ticket_status);
		
		return view('Ticket.ticket_reply', compact('users', 'tickets','emp'));
    }







	/**
        * Method name   : filter Ticket Reply
        * @description  : Used for ticket reply
        * @param        : Request data
        * @return       : return with ticket reply
    */
    public function filter_ticket_assign(request $request)
    {
        $users = $this->enroll_repo->getActiveUser();
		$emp = $this->emp_repo->getActiveEmployee();

		$urgency = '';
		$ticket_id = '';
		$ticket_type = '';
		$formdate = '';
		$todate = '';
		$client = ''; 
		$employee = '';
		$ticket_status = '';

		$user = Helper::get_userdetail(Session::get('USER_ID'));

		if($request->dd_urgency != null)
		{
			$urgency = " AND URGENCY = ".$request->dd_urgency;
		}
		if($request->txt_ticket != null)
		{
			$ticket_id = " AND TICKET_NO = '".$request->txt_ticket."' ";
		}
		if($request->dd_ticket != null)
		{
			$ticket_type = " AND TICKET_FOR = ".$request->dd_ticket;
		}
		if($request->dd_client != null)
		{
			$client = " AND USER_ID = ".$request->dd_client;
		}
		if($request->dd_employee != null)
		{
			$employee = " AND EMP_ID = ".$request->dd_employee;
		}
		if($request->txtfromdate != null && $request->txttodate != null)
		{
			$formdate = " AND CREATED_AT BETWEEN ".$request->txtfromdate." AND ".$request->txttodate;
		}
		if($request->txttodate != null && $request->txtfromdate == null)
		{
			$formdate =  " AND CREATED_AT = ".$request->txttodate;
		}
		if($request->txttodate == null && $request->txtfromdate != null)
		{
			$formdate =  " AND CREATED_AT = ".$request->txttodate;
		}
		if($request->dd_status != null)
		{
			$ticket_status = " AND STATUS = ".$request->dd_status;
		}

	   $tickets =  DB::select("SELECT * FROM `ticket` WHERE TICKET_NO IS NOT NULL " . $urgency . $ticket_id . $formdate .  $todate . $ticket_type . $employee . $client .  $ticket_status);
		
		return view('Ticket.ticket_re_ass', compact('users', 'tickets','emp'));
    }





    /**
        * Method name   : Submit query
        * @description  : Used for adding query
        * @param        : Request data 
        * @return       : return with adding query
    */
    public function submit_query()
    {
    	$request = request();
    	$user = Helper::get_userdetail(Session::get('USER_ID'));
    	$arr = array(
    		'm11_user_id' => $user[0]->RegId,
    		'm46_ticket_subject' => $request->input('txt_title'),
    		'm46_ticket_content' => $request->input('txt_msg'),
    		'm46_assigned_by' => 0,
    		'm46_assigned_to' => 0,
    		'm46_status' => 1
    	);
        $this->ticket_repo->create($arr);

    	return redirect('/submit_query');
    }
    
    /**
        * Method name   : Ticket Reply
        * @description  : Used for ticket reply
        * @param        : Request data
        * @return       : return with ticket reply
    */
    public function ticket_reply()
    {
        $users = $this->enroll_repo->getActiveUser();
        $tickets = $this->ticket_repo->getAll();
		$emp = $this->emp_repo->getActiveEmployee();
        return view('Ticket.ticket_reply', compact('users', 'tickets', 'emp'));
    }


    /**
        * Method name   : Ticket Reply
        * @description  : Used for ticket reply
        * @param        : Request data
        * @return       : return with ticket reply
    */
    public function ticket_assigned()
    {
        $users = $this->enroll_repo->getActiveUser();
        $tickets = $this->ticket_repo->getAll();
		$emp = $this->emp_repo->getActiveEmployee();
        return view('Ticket.ticket_re_ass', compact('users', 'tickets', 'emp'));
    }

    /**
        * Method name   : Submit Reply
        * @description  : Used for submit ticket reply
        * @param        : Request data
        * @return       : return with submit ticket reply
    */
    public function submit_reply()
    {
        $request = request();
        $user = Helper::get_userdetail($request->input('txt_id'));
		
		
		$this->validate($request, [
			'txt_ticket_id'=> 'required',
			'txt_content'=> 'required|max:1500|min:10',
			'file_image' => 'nullable|max:10240',
		],
		[
			'txt_ticket_id.required'=> 'Ticket ID is required',
			'txt_content.required'=> 'Comment is required',
			'txt_content.max'=> 'Comment Max 1500 characters',
			'txt_content.min'=> 'Comment Min 10  characters',
			'file_image.max'=> 'Image Max 2 MB',
		]);

        if($request->hasFile('file_image'))
        {
            $image = $request->file('file_image');
            $image_name = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/ticket_file/');

			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $image_name);
			}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=Session::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
        }
        else
        {
            $image_name = '';
        }


        $arr = array(
            'tr34_tkt_id' => $request->input('txt_ticket_id'),
            'tr34_description' =>  $request->input('txt_content'),
            'tr34_response_type' => 2,
            'tr34_response_by' => Session()->get('USER_ID'),
            'tr34_userfile' =>  $image_name,
            'tr34_status' => 1
        );
    
        $tickData = $this->ticket_repo->getById($request->input('txt_ticket_id'));

        $datas = $this->ticket_repo->create_reply($arr);

        if($datas)
        {
            $template_type = 1;
            if($image_name == '')
            { 
                $data['MSG_CONTENT'] =  $request->input('txt_content'); 
            }
            else
            {
                $data['MSG_CONTENT'] =  $request->input('txt_content').'<br><a href="'.url('images/ticket_file/'.$image_name).'">Attachment File </a>';
            }
            $data['MSG_SUBJECT'] = $tickData[0]->SUBJECT;
            $data['pdf']=''; 
            $data['template_name']='email';
            $emails = $user[0]->MemberEmail;
			$data['useremail']=json_encode($emails);
            $template_data = $data;

            Mail::to($emails)->send(new SendMail($template_data, $template_type));

            return back()->with('success','Message Send Successfully');
        }
        else
        {
            return back()->with('error', 'Message Not Send'); 
        }
    }


    public function assigned_ticket(request $request)
    {
		$data =	$this->ticket_repo->update($request->tick_id, [
                                                'm46_assigned_to' => $request->empid,
												'm46_assigned_by' => session()->get('USER_ID'),
												'm30_emp_id' => $request->empid,
												'm46_assign_date' => date('Y-m-d h:m:s')
                                                            ]); 

		if($data){ Session::flash('success', 'Ticket Assigned Successfully');  return 1; }
		else{ Session::flash('error', 'Ticket Not Assigned'); return 2; }
    }




    public function reassigned_ticket(request $request)
    {

		$data =	$this->ticket_repo->update($request->tick_id, [
												'm46_assigned_by' => session()->get('USER_ID'),
												'm30_emp_id' => $request->empid,
												'm46_assign_date' => date('Y-m-d h:m:s')
                                                            ]); 
		if($data){ Session::flash('success', 'Ticket Assigned Successfully');  return 1; }
		else{ Session::flash('error', 'Ticket Not Assigned'); return 2; }
    }




	public function view_help_desk($id, request $request)
	{
		$data['ticket'] = $this->ticket_repo->getById($id);
        $data['reply'] = $this->ticket_repo->GetByTicketId($id);
        $data['users'] = $this->enroll_repo->getByIdE($data['ticket'][0]->USER_ID);
        $data['single_emp']  = $this->emp_repo->getById($data['ticket'][0]->EMP_ID);
        $data['emp']  = $this->emp_repo->getActiveEmployee();
		return view('Ticket.view-help-desk', compact('data'));
	}



    
    public function ticket_close($id)
    {
        
        $data = $this->ticket_repo->update($id, ['m46_status' => 2]);
        if(session()->get('USER_ID') != '-1')
        {
            if($data)
            {
                return redirect('employee_ticket_reply')->with('success','Ticket Close Successfully');
            }
            else
            {
                return redirect('employee_ticket_reply')->with('error','Ticket Not Close');
            }
        }
        else
        {
            if($data)
            {
                return redirect('ticket_reply')->with('success','Ticket Close Successfully');
            }
            else
            {
                return redirect('ticket_reply')->with('error','Ticket Not Close');
            }

        }
    }



}