<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\Master\Operator\OperatorRepository;
use App\Repositories\Api\ApiRepository;
use App\Repositories\Recharge\Rechargeprocess\RechargeprocessRepository;
use App\Repositories\Recharge\Rechargereport\RechargereportRepository;
use App\Repositories\Dmt\Dmtprocess\DmtprocessRepository;
use App\Repositories\Dmt\Dmtreport\DmtreportRepository;
use App\Repositories\AEPS\AEPSprocess\AEPSprocessRepository;
use App\Repositories\AEPS\AEPSreport\AEPSreportRepository;
use App\Repositories\Fund\FundRepository;
use DB;
use Image;
use Session;
use Helper;

class TestingController extends Controller
{
	private $operator_repo;
	private $api_repo;
    private $fund_repo;
    private $rech_proc_repo;
    private $rech_reprt_repo;
    private $dmt_proc_repo;
    private $dmt_reprt_repo;
    private $aeps_proc_repo;
    private $aeps_reprt_repo;

	public function __construct(OperatorRepository $operator_repo, ApiRepository $api_repo,
        RechargeProcessRepository $rech_proc_repo, RechargereportRepository $rech_reprt_repo, 
        FundRepository $fund_repo, DmtprocessRepository $dmt_proc_repo, DmtreportRepository $dmt_reprt_repo,
        AEPSprocessRepository $aeps_proc_repo, AEPSreportRepository $aeps_reprt_repo)
	{
		$this->operator_repo = $operator_repo;
		$this->api_repo = $api_repo;
        $this->fund_repo = $fund_repo;
        $this->rech_proc_repo = $rech_proc_repo;
        $this->rech_reprt_repo = $rech_reprt_repo;
        $this->dmt_proc_repo = $dmt_proc_repo;
        $this->dmt_reprt_repo = $dmt_reprt_repo;
        $this->aeps_proc_repo = $aeps_proc_repo;
        $this->aeps_reprt_repo = $aeps_reprt_repo;
	}



	/**
        * Method name   : Recharge Report mobile filter 
        * @description  : Used for viewing recharge report
        * @param        : Request data 
        * @return       : return recharge report
    */
    public function recharge_report_mobile()
    {
			$page = 'REPORT PANEL';
			$form_name = 'FIND RECHARGE DETAILS';
			$request = request();
			$descrip="";
			$start ='1970-01-01';
		    $end ='1970-01-01';
			$txt_account = '';
			$txt_memberid = '';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="";
			$cond1="1";
            if($_SERVER['REQUEST_METHOD']=="POST")
            {
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				$cond=$cond.$cond1;
			}
		
			$recereport=array
				 (
				   'proc'=>2,
					'account'=>$txt_account,
					'transid'=>$txt_transid,
					'userid'=>$txt_memberid,
					'fromdate'=>$start,
					'todate'=>$end,
					'noofrecords'=>$txt_noofrecords,
					'recstatus'=>$dd_status,
					'descrip'=>$cond,
					'msg'=>@msg
				);
			//print_r($recereport);
             $rec_report = DB::select('CALL recharge_report(
                 :proc,
                 :account,
                 :transid, 
                 :userid,
                 :fromdate,
                 :todate,
                 :noofrecords,
                 :recstatus,
                 :descrip,
                 :msg
             )',$recereport);
        Session::flash('message',"Recharge Details Fetch Succesfully");

        return view('Report.view_recharge_report', compact('rec_report'));
    }


	/**
        * Method name   : find moneytransfer
        * @description  : view  find moneytransfer
        * @param        : Request data 
        * @return       : return money transfer report
    */

 public function find_moneytransfer()
    {
			$page = 'REPORT PANEL';
			$form_name = 'MOENY TRANSFER REPORT';
			$request = request();
			$descrip="";
			$start ='1970-01-01';
		    $end ='1970-01-01';
			$txt_account = '';
			$txt_memberid = '';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="";
			$cond1="1";
            if($_SERVER['REQUEST_METHOD']=="POST")
            {
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				 $cond=$cond.$cond1;
			}

			$dmtreport=array
				 (
				    'proc'=>1,
					'account'=>$txt_account,
					'transid'=>$txt_transid,
					'userid'=>$txt_memberid,
					'fromdate'=>$start,
					'todate'=>$end,
					'noofrecords'=>$txt_noofrecords,
					'recstatus'=>$dd_status,
					'descrip'=>$cond,
					'msg'=>@msg
				);

             $mtransfer_report = DB::select('CALL dmr_report(
                 :proc,
                 :account,
                 :transid, 
                 :userid,
                 :fromdate,
                 :todate,
                 :noofrecords,
                 :recstatus,
                 :descrip,
                 :msg
             )',$dmtreport);
//dd($mtransfer_report);
        Session::flash('message',"Recharge Report Fetch Succesfully");
    	return view('Report.view_money_transfer_report', compact('mtransfer_report','page', 'form_name'));
    }



    public function testing_pay(request $request)
    {
    	return view('indexs');
	}

    public function fun_test(request $request)
    {

        $level_one = DB::select("SELECT m11_user_id AS U_ID FROM `m11_user` WHERE `m11_user_parent_code` = 2");
dd($request, $level_one);
        //ENTER THE RELEVANT INFO BELOW
        $mysqlHostName      = env('DB_HOST');
        $mysqlUserName      = env('DB_USERNAME');
        $mysqlPassword      = env('DB_PASSWORD');
        $DbName             = env('DB_DATABASE');
        $backup_name        = "mybackup.sql";

/*        $queryTables = \DB::select(\DB::raw('SHOW TABLES'));
        foreach ( $queryTables as $table )
        {
            foreach ( $table as $tName)
            {
                $tables[]= $tName ;
            }
        }
       */
        $tables = array("m00_admin_login","m00_setconfig","m00_setconfig_wl","m01_bank"); //here your tables...

        $connect = new \PDO("mysql:host=smartbatua.com;dbname=smartbat_b2capp;charset=utf8", "smartbat_ipsb2c", "@+QE%))B@v5#",array(\PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES 'utf8'"));

        $get_all_table_query = "SHOW TABLES";
        $statement = $connect->prepare($get_all_table_query);
        $statement->execute();
        $result = $statement->fetchAll();


        $output = '';
        foreach($tables as $table)
        {
         $show_table_query = "SHOW CREATE TABLE " . $table . "";
         $statement = $connect->prepare($show_table_query);
         $statement->execute();
         $show_table_result = $statement->fetchAll();

         foreach($show_table_result as $show_table_row)
         {
          $output .= "\n\n" . $show_table_row["Create Table"] . ";\n\n";
         }

         $select_query = "SELECT * FROM " . $table . "";
         $statement = $connect->prepare($select_query);
         $statement->execute();
         $total_row = $statement->rowCount();

      
         for($count=0; $count<$total_row; $count++)
         {
          $single_result = $statement->fetch(\PDO::FETCH_ASSOC);
          $table_column_array = array_keys($single_result);
          $table_value_array = array_values($single_result);
          $output .= "\nINSERT INTO $table (";
          $output .= "" . implode(", ", $table_column_array) . ") VALUES (";
          $output .= "'" . implode("','", $table_value_array) . "');\n";
         }
        }  

        $file_name = 'database_backup_on_' . date('y-m-d') . '.sql';
        $file_handle = fopen($file_name, 'w+');
        fwrite($file_handle, $output);
        fclose($file_handle);
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename=' . basename($file_name));
        header('Content-Transfer-Encoding: binary');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
           header('Pragma: public');
           header('Content-Length: ' . filesize($file_name));
           ob_clean();
           flush();
           readfile($file_name);
           unlink($file_name);


    }



	/**
        * Method name   : Recharge Report
        * @description  : Used for viewing recharge report
        * @param        : Request data 
        * @return       : return recharge report
    */
    public function recharge_report()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='-1';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
		$txt_memberids = $txt_memberid;
		$dd_api='-1';
		$dd_operator='-1';
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$txt_memberids = $request->input('txt_memberid');
			$dd_api=$request->input('dd_api');
			$dd_operator=$request->input('dd_operator');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }
			
        }
        $cond=$cond.$cond1;
        $recereport=array
         (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
		$hit_data=array(
				'proc'=>3,
				'user_id'=>-1,
				'rec_fromdate'=>$start,
				'rec_todate'=>$end
            );
		
		$today_hit = $this->rech_reprt_repo->todayHitStatus($hit_data);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');

        Session::flash('message',"Recharge Report Fetch Succesfully");
        return view('Report.recharge_report', compact('rec_report','OPERATOR','API','today_hit','start','end','txt_memberids','txt_account','txt_transid','dd_status','txt_noofrecords','dd_api','dd_operator'));
    }

    /**
        * Method name   : Pending Recharge report
        * @description  : Used for view pending recharge report
        * @param        : Request data  
        * @return       : return pending recharge report
    */
    public function pendingrecharge_report()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime('2021-01-01'));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
		$txt_memberids = $txt_memberid;
		$dd_api='-1';
		$dd_operator='-1';

        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txtfromdate')));
            $end = date('Y-m-d',strtotime($request->input('txttodate')));
			$txt_memberids = $request->input('txt_memberid');
			$dd_api=$request->input('dd_api');
			$dd_operator=$request->input('dd_operator');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            /*if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }*/
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);

        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Pending Recharge Report Fetch Succesfully");
        return view('Report.pendingrecharge_report', compact('rec_report','OPERATOR','API','start','end','txt_memberids','txt_account','txt_transid','dd_status','dd_api','dd_operator'));
    }

    /**
        * Method name   : Refund report
        * @description  : Used for refund report 
        * @param        : Request data  
        * @return       : return refund report
    */
    public function refund_report()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
		$txt_memberids = $txt_memberid;
		$dd_api='-1';
		$dd_operator='-1';

        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$txt_memberids = $request->input('txt_memberid');
			$dd_api=$request->input('dd_api');
			$dd_operator=$request->input('dd_operator');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Refund Recharge Report Fetch Succesfully");
        return view('Report.refund_report', compact('rec_report','OPERATOR','API','start','end','txt_memberids','txt_account','txt_transid','dd_status','dd_api','dd_operator','txt_noofrecords'));
    }

    /**
        * Method name   : Ledger
        * @description  : Used for ledger report
        * @param        : Request data  
        * @return       : return ledger report
    */
    public function ledger()
    {
        $request = request();
        $descrip="";
        $start = '1970-01-01';
        $end ='1970-01-01';
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '10000';
        $dd_ledgertype='-1';
        $cond="";
        $cond1=" 1 AND `tr03_bal_type` IN (1)";
            if($_SERVER['REQUEST_METHOD']=="POST")
            {
                $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
                $end = date('Y-m-d',strtotime($request->input('txt_todate')));
                
                if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
                {
                    $txt_account=$request->input('txt_account');
                }
                if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
                {
                    $txt_transid=$request->input('txt_transid');
                }
                if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
                {
                    $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
                }
                if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
                {
                    $txt_noofrecords =$request->input('txt_noofrecords');
                }
                if($request->input('dd_ledgertype')!="" && $request->input('dd_ledgertype')!=-1)
                {
                    $dd_ledgertype=$request->input('dd_ledgertype');
                }
                
            }
            $cond=$cond.$cond1;
            $ledgerreport=array(
                'proc'=>2,
                'account'=>"0",
                'transid'=>$txt_transid,'userid'=>$txt_memberid,'fromdate'=>$start,
                'todate'=>$end,'noofrecords'=>$txt_noofrecords,'ledegerstatus'=>$dd_ledgertype,'descrip'=>$cond
            );
            $ledger_report = $this->fund_repo->ledgerReport($ledgerreport);
        return view('Report.ledger', compact('ledger_report'));
    }

    /**
        * Method name   : Recharge payment summary
        * @description  : Used for view recharge payment summary
        * @param        : Request data  
        * @return       : return recharge payment summary
    */
    public function rechargepayment_summary()
    {
        $request = request();
        $descrip="";
        $start = '1970-01-01';
        $end ='1970-01-01';
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '10000';
        $dd_ledgertype='-1';
        $cond="";
        $cond1=" 1 AND `tr03_bal_type` IN (1)";
            if($_SERVER['REQUEST_METHOD']=="POST")
            {
                $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
                $end = date('Y-m-d',strtotime($request->input('txt_todate')));
                
                if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
                {
                    $txt_account=$request->input('txt_account');
                }
                if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
                {
                    $txt_transid=$request->input('txt_transid');
                }
                if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
                {
                    $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
                }
                if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
                {
                    $txt_noofrecords =$request->input('txt_noofrecords');
                }
                if($request->input('dd_ledgertype')!="" && $request->input('dd_ledgertype')!=-1)
                {
                    $dd_ledgertype=$request->input('dd_ledgertype');
                }
                
            }
            $cond=$cond.$cond1;
            $ledgerreport=array(
                'proc'=>2,
                'account'=>"0",
                'transid'=>$txt_transid,'userid'=>$txt_memberid,'fromdate'=>$start,
                'todate'=>$end,'noofrecords'=>$txt_noofrecords,'ledegerstatus'=>$dd_ledgertype,'descrip'=>$cond
            );
            $ledger_report = $this->fund_repo->ledgerReport($ledgerreport);
        return view('Report.payment_summary', compact('ledger_report'));
    }

    /**
        * Method name   : Operator wise
        * @description  : Used for operator wise recharge report 
        * @param        : Request data  
        * @return       : return operator wise recharge report
    */
    public function operator_wise()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '-1';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
		$dd_api='-1';
		$dd_operator='-1';
	
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$dd_api=$request->input('dd_api');
			$dd_operator=$request->input('dd_operator');

            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>1,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->dailyOperatorSales($recereport);

        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Operator Wise Recharge Report Fetch Succesfully");
    	return view('Report.operator_wise', compact('rec_report','OPERATOR','API','start','end','dd_api','dd_operator'));
    }

    /**
        * Method name   : User wise
        * @description  : Used for user wise recharge report 
        * @param        : Request data  
        * @return       : return user wise recharge report 
    */
    public function user_wise()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
		$dd_api='-1';
		$dd_operator='-1';
        $txt_memberid = -1;
		$txt_memberids = '';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$dd_api=$request->input('dd_api');
			$dd_operator=$request->input('dd_operator');
			$txt_memberids = $request->input('txt_memberid');
            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
          'proc'=>4,
          'user_id'=>$txt_memberid,
          'rec_fromdate'=>$start,
          'rec_todate'=>$end
        );
        $rec_report = $this->rech_reprt_repo->userWiseSales($recereport);

        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Recharge Report Fetch Succesfully");
    	return view('Report.user_wise', compact('rec_report','OPERATOR','API','start','end','dd_api','dd_operator','txt_memberids'));
    }

    /**
        * Method name   : Api wise
        * @description  : Used for api wise recharge report
        * @param        : Request data  
        * @return       : return api wise recharge report
    */
    public function api_wise()
    {
        $request = request();
        $descrip="";
		$start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';$txt_memberid = -1;$txt_transid = ''; $txt_noofrecords = '100';
		$dd_api='-1';
        $dd_status='2';$cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$dd_api=$request->input('dd_api');
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }
        }
        $cond=$cond.$cond1;
       $recereport=array
        (
          'proc'=>5,
          'user_id'=>$txt_memberid,
          'rec_fromdate'=>$start,
          'rec_todate'=>$end
        );
        $rec_report = $this->rech_reprt_repo->apiWiseSales($recereport);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Recharge Report Fetch Succesfully");
    	return view('Report.api_wise', compact('rec_report','OPERATOR','API','dd_api','start','end'));
    }

    /**
        * Method name   : Date wise
        * @description  : Used for date wise recharge report
        * @param        : Request data  
        * @return       : return date wise recharge report
    */
    public function date_wise()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = -1;
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
        }
        $recereport=array
        (
          'proc'=>8,
          'user_id'=>$txt_memberid,
          'rec_fromdate'=>$start,
          'rec_todate'=>$end
        );
        $rec_report = $this->rech_reprt_repo->apiWiseSales($recereport);
        return view('Report.date_wise', compact('rec_report','start','end'));
    }
	
	
	
	/******** MONEY TRANSFER REPORT *****************************/
	
	/**
        * Method name   : Money Transfer Report
        * @description  : Used for viewing money transfer report
        * @param        : Request data 
        * @return       : return money transfer report
    */
    public function mtransfer_report()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
		$txt_memberids = '';
        $txt_transid = '';
        $txt_noofrecords = '1000';
        $dd_status='-1';
        $cond="1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
          $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
           $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$txt_memberids = $request->input('txt_memberid');
			$dd_status=$request->input('dd_status');
			$txt_noofrecords = $request->input('txt_noofrecords');
			$txt_transid = $request->input('txt_transid');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
        }
       // $cond=$cond.$cond1;
        $mtransferreport=array
         (
         'proc'=>1,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $mtransfer_report = $this->dmt_reprt_repo->dmrReport($mtransferreport);
		$hit_data=array(
				'proc'=>6,
				'user_id'=>-1,
				'rec_fromdate'=>$start,
				'rec_todate'=>$end
            );
		$today_hit = $this->rech_reprt_repo->todayHitStatus($hit_data);
		//dd($mtransfer_report);
        return view('Report.money_transfer_report', compact('mtransfer_report','today_hit','start','end','txt_memberids','txt_account','txt_transid','dd_status','txt_noofrecords'));
    }

    /**
        * Method name   : Pending Money Transfer Report
        * @description  : Used for view pending money transfer report
        * @param        : Request data  
        * @return       : return pending money transfer report
    */
    public function pendingmtransfer_report()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
		$txt_memberids = '';
        $txt_noofrecords = '1000';
        $dd_status='2';
        $cond="1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
          $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
           $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$txt_memberids = $request->input('txt_memberid');
			$dd_status=$request->input('dd_status');
			$txt_noofrecords = $request->input('txt_noofrecords');
			$txt_transid = $request->input('txt_transid');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
        }
       // $cond=$cond.$cond1;
        $mtransferreport=array
         (
         'proc'=>1,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $mtransfer_report = $this->dmt_reprt_repo->dmrReport($mtransferreport);
        return view('Report.pending_moneytransfer_report', compact('mtransfer_report','start','end','txt_memberids','txt_account','txt_transid','dd_status','txt_noofrecords'));
    }

    /**
        * Method name   : Refund Money Transfer Report
        * @description  : Used for refund money transfer report 
        * @param        : Request data  
        * @return       : return refund money transfer report
    */
    public function refund_mtransfer_report()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_memberids = '';
        $txt_transid = '';
		$dd_api='-1';
		$dd_operator='-1';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$txt_memberids = $request->input('txt_memberid');
			$dd_status=$request->input('dd_status');
			$txt_noofrecords = $request->input('txt_noofrecords');
			$txt_transid = $request->input('txt_transid');
			$dd_api=$request->input('dd_api');
			$dd_operator=$request->input('dd_operator');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Refund Recharge Report Fetch Succesfully");
        return view('Report.refund_moneytransfer_report', compact('rec_report','OPERATOR','API','start','end','txt_memberids','txt_account','txt_transid','dd_status','dd_api','dd_operator','txt_noofrecords'));
    }

    
    /**
        * Method name   : User wise Money Transfer
        * @description  : Used for user wise money transfer report 
        * @param        : Request data  
        * @return       : return user wise money transfer report 
    */
    public function user_wise_mtransfer()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
		$txt_memberids =''; 
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
		$dd_operator = '-1';
		$dd_api='-1';

        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$txt_memberids = $request->input('txt_memberid');
			$dd_api=$request->input('dd_api');
			$dd_operator=$request->input('dd_operator');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);

        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Recharge Report Fetch Succesfully");
    	return view('Report.user_wise_moneytransfer', compact('rec_report','OPERATOR','API','start','end','dd_api','dd_operator','txt_memberids'));
    }

    /**
        * Method name   : Api Wise Money Transfer
        * @description  : Used for api wise money transfer report
        * @param        : Request data  
        * @return       : return api wise money transfer report
    */
    public function api_wise_mtransfer()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
		$dd_operator = '-1';
		$dd_api='-1';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$dd_api=$request->input('dd_api');
			$dd_operator=$request->input('dd_operator');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Recharge Report Fetch Succesfully");
    	return view('Report.api_wise_moneytransfer', compact('rec_report','OPERATOR','API','start','end','dd_api','dd_operator'));
    }

    /**
        * Method name   : Date wise
        * @description  : Used for date wise money transfer report
        * @param        : Request data  
        * @return       : return date wise money transfer report
    */
    public function date_wise_mtransfer()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
		$dd_operator = '-1';
		$dd_api='-1';
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$dd_api=$request->input('dd_api');
			$dd_operator=$request->input('dd_operator');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Recharge Report Fetch Succesfully");
        return view('Report.date_moneytransfer_wise', compact('rec_report','OPERATOR','API','start','end','dd_api','dd_operator'));
    }

    /******** AEPS TRANSFER REPORT *****************************/
    
    /**
        * Method name   : AEPS Transfer Report
        * @description  : Used for viewing aeps transfer report
        * @param        : Request data 
        * @return       : return aeps transfer report
    */
    public function apestransfer_report()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='-1';
		$txt_memberids = '';
        $cond="1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$dd_status=$request->input('dd_status');
			$txt_noofrecords = $request->input('txt_noofrecords');
			$txt_transid = $request->input('txt_transid');
			$txt_memberids = $request->input('txt_memberid');


            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
          

        }
     
        $aepsreport=array
         (
         'proc'=>1,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $aeps_report = $this->aeps_reprt_repo->aepsReport($aepsreport);
		$hit_data=array(
				'proc'=>7,
				'user_id'=>-1,
				'rec_fromdate'=>$start,
				'rec_todate'=>$end
            );
		$today_hit = $this->rech_reprt_repo->todayHitStatus($hit_data);
        return view('Report.aeps_report', compact('aeps_report','today_hit','start','end','txt_memberids','txt_account','txt_transid','dd_status','txt_noofrecords'));
    }

    /**
        * Method name   : Pending AEPS Report
        * @description  : Used for view pending aeps report
        * @param        : Request data  
        * @return       : return pending aeps report
    */
    public function pendingapestransfer_report()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
		$txt_memberids = '';
        $cond="1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));			
			$dd_status=$request->input('dd_status');
			$txt_noofrecords = $request->input('txt_noofrecords');
			$txt_transid = $request->input('txt_transid');
			$txt_memberids = $request->input('txt_memberid');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
          

        }
     
        $aepsreport=array
         (
         'proc'=>1,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $aeps_report = $this->aeps_reprt_repo->aepsReport($aepsreport);
        return view('Report.pending_aeps_report', compact('aeps_report','start','end','txt_memberids','txt_account','txt_transid','dd_status','txt_noofrecords'));
    }

    /**
        * Method name   : Refund AEPS Report
        * @description  : Used for refund AEPS report 
        * @param        : Request data  
        * @return       : return refund AEPS report
    */
    public function refund_apestransfer_report()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
		$dd_operator = '-1';
		$dd_api='-1';
		$txt_memberids = '';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$dd_status=$request->input('dd_status');
			$txt_noofrecords = $request->input('txt_noofrecords');
			$txt_transid = $request->input('txt_transid');
			$txt_memberids = $request->input('txt_memberid');
			$dd_api=$request->input('dd_api');
			$dd_operator=$request->input('dd_operator');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Refund Recharge Report Fetch Succesfully");
        return view('Report.refund_aeps_report', compact('rec_report','OPERATOR','API','start','end','txt_memberids','txt_account','txt_transid','dd_status','dd_api','dd_operator','txt_noofrecords'));
    }

    
    /**
        * Method name   : User wise Money Transfer
        * @description  : Used for user wise money transfer report 
        * @param        : Request data  
        * @return       : return user wise money transfer report 
    */
    public function user_wise_apestransfer()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
		$dd_operator = '-1';
		$dd_api='-1';
		$txt_memberids = '';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$txt_memberids = $request->input('txt_memberid');
			$dd_api=$request->input('dd_api');
			$dd_operator=$request->input('dd_operator');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);

        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Recharge Report Fetch Succesfully");
        return view('Report.user_wise_aeps', compact('rec_report','OPERATOR','API','start','end','txt_memberids','dd_api','dd_operator'));
    }

    /**
        * Method name   : Api Wise Money Transfer
        * @description  : Used for api wise money transfer report
        * @param        : Request data  
        * @return       : return api wise money transfer report
    */
    public function api_wise_apestransfer()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
		$dd_operator = '-1';
		$dd_api='-1';
		$txt_memberids = '';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));			
			$txt_memberids = $request->input('txt_memberid');
			$dd_api=$request->input('dd_api');
			$dd_operator=$request->input('dd_operator');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Recharge Report Fetch Succesfully");
        return view('Report.api_wise_aeps', compact('rec_report','OPERATOR','API','start','end','txt_memberids','dd_api','dd_operator'));
    }

    /**
        * Method name   : Date wise
        * @description  : Used for date wise money transfer report
        * @param        : Request data  
        * @return       : return date wise money transfer report
    */
    public function date_wise_apestransfer()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
		$dd_operator = '-1';
		$dd_api='-1';
		$txt_memberids = '';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));			
			$txt_memberids = $request->input('txt_memberid');
			$dd_api=$request->input('dd_api');
			$dd_operator=$request->input('dd_operator');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Recharge Report Fetch Succesfully");
        return view('Report.date_wise_aeps', compact('rec_report','OPERATOR','API','start','end','txt_memberids','dd_api','dd_operator'));
    }

/* */

	/**
        * Method name   : Bill Payment Report
        * @description  : Used for viewing recharge report
        * @param        : Request data 
        * @return       : return recharge report
    */
    public function billpay_report()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
		$txt_memberids = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='-1';
        $cond="";
		$dd_operator = '-1';
		$dd_api='-1';
		
        $cond1="`m07_service_id` NOT IN(1,2) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$txt_memberids = $request->input('txt_memberid');
			$dd_operator =$request->input('dd_operator');
			$dd_api=$request->input('dd_api');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr36_bill_payment`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr36_bill_payment`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
         (
         'proc'=>2,
		  'mobile'=>'',
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );

        $rec_report = $this->rech_reprt_repo->billpayReport($recereport);
		//print_r( $recereport);
		//dd( $rec_report);
		$hit_data=array(
				'proc'=>3,
				'user_id'=>-1,
				'rec_fromdate'=>$start,
				'rec_todate'=>$end
            );
		$today_hit = $this->rech_reprt_repo->todayHitStatus($hit_data);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');

        Session::flash('message',"Billpay Report Fetch Succesfully");
        return view('Report.billpay_report', compact('rec_report','OPERATOR','API','today_hit','start','end','txt_memberids','txt_account','txt_transid','dd_status','dd_api','dd_operator','txt_noofrecords'));
    }

    /**
        * Method name   : Pending Bill pay report
        * @description  : Used for view pending recharge report
        * @param        : Request data  
        * @return       : return pending recharge report
    */
    public function pendingbillpay_report()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
		$txt_memberids = '';
        $txt_transid = '';
		$dd_operator='-1';
		$dd_api='-1';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_from')));
            $end = date('Y-m-d',strtotime($request->input('txt_to')));
			$dd_operator=$request->input('dd_operator');
			$dd_api=$request->input('dd_api');
			$txt_account = $request->input('txt_account');
			$txt_memberids = $request->input('txt_memberid');
			$dd_status = $request->input('dd_status');
			$txt_transid = $request->input('txt_transid');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            /*if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }*/
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr36_bill_payment`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr36_bill_payment`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
       $recereport=array
         (
         'proc'=>2,
		  'mobile'=>'',
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->billpayReport($recereport);

        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Pending Billpay Report Fetch Succesfully");
        return view('Report.pendingbill_report', compact('rec_report','OPERATOR','API','start','end','txt_account','txt_memberids','txt_transid','dd_status','dd_api','dd_operator'));
    }

    /**
        * Method name   : Refund Bill Pay report
        * @description  : Used for refund report 
        * @param        : Request data  
        * @return       : return refund report
    */
    public function refundbillpay_report()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
		$txt_memberids = '';
		$dd_operator='-1';
		$dd_api='-1';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$dd_operator=$request->input('dd_operator');
			$dd_api=$request->input('dd_api');
			$txt_account = $request->input('txt_account');
			$txt_memberids = $request->input('txt_memberid');
			$dd_status = $request->input('dd_status');
			$txt_transid = $request->input('txt_transid');
			$txt_noofrecords = $request->input('txt_noofrecords');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Refund Recharge Report Fetch Succesfully");
        return view('Report.refundbill_report', compact('rec_report','OPERATOR','API','start','end','txt_account','txt_memberids','txt_transid','dd_status','dd_api','dd_operator','txt_noofrecords'));
    }
/* */

//////////Api inocoming and outgoing


 public function request_of_user()
    {
        $page = 'REPORT PANEL';
        $form_name = 'API USER WISE INCOMING HIT REQUEST';
        $request = request();
        $descrip="";
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txt_memberid = '-1';
		$cond="";
		$cond1="1";
		$incoming_hitrequest = DB::select("SELECT * FROM apihit_reqres WHERE RequestType=1 LIMIT 0,1000;");
    	return view('TraceUrl.requestby_userwise', compact('page', 'form_name','incoming_hitrequest'));
    }
 public function response_to_user()
    {
        $page = 'REPORT PANEL';
        $form_name = 'API USER WISE CALLBACK OUTGOING RESPONSE';
        $request = request();
        $descrip="";
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txt_memberid = '-1';
		$cond="";
		$cond1="1";
		$outgoing_hitresponse= DB::select("SELECT * FROM apihit_reqres WHERE RequestType=4 LIMIT 0,1000;");
       return view('TraceUrl.responseto_userwise', compact('page', 'form_name','outgoing_hitresponse'));
    }

//// To Vendor
 public function request_to_vendor()
    {
        $page = 'REPORT PANEL';
        $form_name = 'API WISE OUTGOING HIT REPORT';
        $request = request();
        $descrip="";
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txt_memberid = '-1';
		$cond="";
		$cond1="1";
		$outgoing_hitrequest= DB::select("SELECT * FROM apihit_reqres WHERE RequestType=2 LIMIT 0,1000;");
    	return view('TraceUrl.requestto_vendorwise', compact('page', 'form_name','outgoing_hitrequest'));
    }

 public function response_by_vendor()
    {
        $page = 'REPORT PANEL';
        $form_name = 'API WISE';
        $request = request();
        $descrip="";
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txt_memberid = '-1';
		$cond="";
		$cond1="1";
		$incoming_hitresponse= DB::select("SELECT * FROM apihit_reqres WHERE RequestType=3 LIMIT 0,1000;");
        return view('TraceUrl.responseby_vendorwise', compact('page', 'form_name','incoming_hitresponse'));
    }


	
}
?>