<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\Slab\SlabRepository;
use App\Repositories\Api\ApiRepository;
use App\Repositories\Master\Service\ServiceRepository;
use DB;
use Image;
use Session;
use Helper;

class SlabController extends Controller
{
    private $slab_repo;
    private $api_repo;
    private $service_repo;

	public function __construct(SlabRepository $slab_repo,
        ApiRepository $api_repo, ServiceRepository $service_repo)
	{
		$this->slab_repo = $slab_repo;
        $this->api_repo = $api_repo;
        $this->service_repo = $service_repo;
	}

	/**
        * Method name   : Create slab
        * @description  : Used for creating slab
        * @param        : Request data 
        * @return       : return created slab
    */
    public function create_slab($id = "")
    {
    	$single_slab = "";
  		$slab = $this->slab_repo->getAll();
  		if($id != ""){
  			$single_slab = $this->slab_repo->getById($id);
  		}
    	return view('Slab.create_slab', compact('slab', 'single_slab'));
    }

    /**
        * Method name   : Create slab
        * @description  : Used for creating slab
        * @param        : Request data 
        * @return       : return created slab
    */
    public function add_slab()
    {
    	$request = request();

    	$this->validate($request, [
            'txt_group_name'=> 'required',
            'dd_type' => 'required'
        ],[
            'txt_group_name.required'=> 'Group name is required',
            'dd_type.required' => 'Group type is required'     
        ]);

    	$arr = array(
    		'm22_affiliate_id' => 0,
    		'm16_gr_name' => $request->input('txt_group_name'),
    		'm16_gr_type' => $request->input('dd_type'),
    		'm16_gr_status' => 1
    		);

    	$group_id = $this->slab_repo->create($arr);

    	$arr1 = array(
			'proc'=> 8,
			'userid' => $group_id,
			'telecombrandid' => 0,
			'desig' => '',
			'apiid' => 0
		);

    	$this->slab_repo->createSlabMargin($arr1);
    	return redirect('/create_slab');
    }

    /**
        * Method name   : Update slab
        * @description  : Used for updating slab
        * @param        : Request data 
        * @return       : return updated slab
    */
    public function update_slab($id)
    {
    	$request = request();

    	$this->validate($request, [
            'txt_group_name'=> 'required'
        ],[
            'txt_group_name.required'=> 'Group name is required'  
        ]);

    	$arr = array(
    		'm16_gr_name' => $request->input('txt_group_name')
    		);

    	$this->slab_repo->update($id, $arr);
    	return redirect('/create_slab');
    }

    /**
        * Method name   : Slab status
        * @description  : Used for updating slab status
        * @param        : Request data 
        * @return       : return updated slab status
    */
    public function slab_status()
    {
    	$request = request();
    	$id = $request->input('txt_slab_id');
    	$this->slab_repo->active($id);
    	return redirect('/create_slab');
    }

    /**
        * Method name   : Prepaid margin
        * @description  : Used for prepaid margin
        * @param        : Request data 
        * @return       : return prepaid margin
    */
    public function prepaid_margin()
    {
    	$request = request();
    	$slab = $this->slab_repo->getAll();
    	$OPERATOR = Helper::get_operator(-2,'ALL');
		$grid=-1;
		$opid=-1;
    	if($request->method() == 'POST')
        {
        	$grid = $request->input('dd_group');
        	$opid = $request->input('dd_operator');
        	$arr1 = array(
				'proc'=>1,
				'userid' => $grid,
				'telecombrandid' => $opid,
				'desig' => '',
				'apiid' => 0
			);
       	} 	
       	else{
       		$arr1 = array(
				'proc'=>1,
				'userid' => $grid,
				'telecombrandid' => $opid,
				'desig' => '',
				'apiid' => 0
			);
       	}
		$margin = $this->slab_repo->createSlabMargin($arr1);
    	return view('Slab.prepaid_margin', compact('slab', 'OPERATOR', 'margin','grid','opid'));
    }

    /**
        * Method name   : Update all margin
        * @description  : Used for updating multiple prepaid margin
        * @param        : Request data 
        * @return       : return prepaid margin
    */
    public function update_all_margin()
    {
        $request = request();
        $id = $request->ids;
        $value = $request->values;
        $value1 = $request->values1;
        $value2 = $request->values2;
        $value3 = $request->values3;
        $value4 = $request->values4;
        $method = $request->methods;
        $type = $request->types;
        $count = count($id);

        for($i=0; $i<$count ; $i++){
                            $arr = array(
                                'tr06_grop_margin'    => $value[$i],
                                'tr06_grop_margin_d'  => $value1[$i],
                                'tr06_grop_margin_md' => $value2[$i],
                                'tr06_grop_margin_sd' => $value3[$i],
                                'tr06_grop_margin_ad' => $value4[$i],
                                'tr06_group_margin_distri' => $method[$i],
                                'tr06_group_margin_type' => $type[$i]
                            );
                           $data= $this->slab_repo->updatePrepaidMarginSW($id[$i], $arr);
        }
        
     if($data)
        {
            return 1;
        }
        else
        {
            return 2;
        }
    }


    /**
        * Method name   : Update margin
        * @description  : Used for updating prepaid margin
        * @param        : Request data 
        * @return       : return prepaid margin
    */
    public function update_margin($id)
    {
        $request = request(); 
		$grid=-1;$opid=-1;
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            if($request->input('txt_distr_margin_'.$id) >= $request->input('txt_retailer_margin_'.$id)){
                if($request->input('txt_master_distr_margin_'.$id) >= $request->input('txt_distr_margin_'.$id)){
                    if($request->input('txt_super_distr_margin_'.$id) >= $request->input('txt_master_distr_margin_'.$id)){
                        if($request->input('txt_admin_distr_margin_'.$id) >= $request->input('txt_super_distr_margin_'.$id)){
                            $arr = array(
                                'tr06_grop_margin' => $request->input('txt_retailer_margin_'.$id),
                                'tr06_grop_margin_d' => $request->input('txt_distr_margin_'.$id),
                                'tr06_grop_margin_md' => $request->input('txt_master_distr_margin_'.$id),
                                'tr06_grop_margin_sd' => $request->input('txt_super_distr_margin_'.$id),
                                'tr06_grop_margin_ad' => $request->input('txt_admin_distr_margin_'.$id),
                                'tr06_group_margin_distri' => $request->input('dd_distribution'.$id),
                                'tr06_group_margin_type' => $request->input('dd_margintype'.$id),
                            );
                            $this->slab_repo->updatePrepaidMarginSW($id, $arr);
                        }
                    }
                }
            }
             $grid = $request->input('dd_group');
        	$opid = $request->input('dd_operator');

            $arr1 = array(
                'proc'=>1,
                'userid' => $grid,
                'telecombrandid' => $opid,
                'desig' => '',
                'apiid' => 0
            );
        }
			 else{
            $grid = 1;
            $opid = 0;

            $arr1 = array(
                'proc'=>1,
                'userid' => $grid,
                'telecombrandid' => $opid,
                'desig' => '',
                'apiid' => 0
            );
        }
		 $margin = $this->slab_repo->createSlabMargin($arr1);
         $slab = $this->slab_repo->getAll();
         $OPERATOR = Helper::get_operator(-2,'ALL');
        return view('Slab.prepaid_margin', compact('slab', 'OPERATOR', 'margin','grid','opid'));
    }


    /**
        * Method name   : Utility surcharge
        * @description  : Used for utility surcharge report
        * @param        : Request data 
        * @return       : return utility surcharge report
    */
    public function utility_surcharge()
    {
        $request = request();

        $slab = $this->slab_repo->getAll();
        $OPERATOR = Helper::get_operator(-1,'ALL');
        $SERVICE = $this->service_repo->getAll();
		$grid=-1;
		$opid =-1;
        if($request->method() == 'POST')
        {
            $grid = $request->input('dd_group');
            $opid = $request->input('dd_service');

            $arr1 = array(
                'proc'=>14,
                'userid' => $grid,
                'telecombrandid' => $opid,
                'desig' => '',
                'apiid' => 0
            );
        }   
        else{

            $grid = -1;
            $opid = -1;

            $arr1 = array(
                'proc'=>14,
                'userid' => $grid,
                'telecombrandid' => $opid,
                'desig' => '',
                'apiid' => 0
            );
        }
        //print_r($arr1);
        $margin = $this->slab_repo->createSlabMargin($arr1);
        //dd($margin);
    	return view('Slab.utility_surcharge', compact('slab', 'OPERATOR', 'margin', 'SERVICE','grid','opid'));
    }


    /**
        * Method name   : update all utility surcharge
        * @description  : Used for update utility surcharge
        * @param        : Request data 
        * @return       : return update utility surcharge
    */
    public function update_all_utility_surcharge()
    {
        $request = request();
        $id = $request->ids;      
        $value = $request->values;
        $value1 = $request->values1;
        $value2 = $request->values2;
        $value3 = $request->values3;
        $value4 = $request->values4;
        $method = $request->methods;
        $type = $request->types;
        $count = count($id);


        for($i=0; $i<$count ; $i++){
            $arr = array(
                'tr24_group_utlty' => $value[$i],
                'tr24_group_utlty_d' => $value1[$i],
                'tr24_group_utlty_md' => $value2[$i],
                'tr24_group_utlty_sd' => $value3[$i],
                'tr24_group_utlty_ad' => $value4[$i],
                'tr24_group_utlty_distri' => $method[$i],
                'tr24_group_utlty_margin_type' => $type[$i]
            );
            $data=$this->slab_repo->updateUtilityMarginSW($id[$i], $arr);
        }
          if($data)
        {
            return 1;
        }
        else
        {
            return 2;
        }
    }


    /**
        * Method name   : update utility surcharge
        * @description  : Used for update utility surcharge
        * @param        : Request data 
        * @return       : return update utility surcharge
    */
    public function update_utility_surcharge($id)
    {
        $request = request();

        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            //dd($request);
            $arr = array(
                'tr24_group_utlty' => $request->input('txt_retailer_margin_'.$id),
                'tr24_group_utlty_d' => $request->input('txt_distr_margin_'.$id),
                'tr24_group_utlty_md' => $request->input('txt_master_distr_margin_'.$id),
                'tr24_group_utlty_sd' => $request->input('txt_super_distr_margin_'.$id),
                'tr24_group_utlty_ad' => $request->input('txt_admin_distr_margin_'.$id),
                'tr24_group_utlty_distri' => $request->input('dd_distribution'.$id),
                'tr24_group_utlty_margin_type' => $request->input('dd_margintype'.$id)
            );
            $this->slab_repo->updateUtilityMarginSW($id, $arr);
        }
        
        return redirect('/utility_surcharge');
    }


    /**
        * Method name   : dmr surcharge
        * @description  : Used for dmr surcharge report
        * @param        : Request data 
        * @return       : return dmr surcharge report
    */
    public function dmr_surcharge()
    {
        $request = request();

        $slab = $this->slab_repo->getAll();
        $OPERATOR = Helper::get_operator(-1,'ALL');
		     $grid = -1;
            $opid = -1;
        if($request->method() == 'POST')
        {
            $grid = $request->input('dd_group');
            $opid = $request->input('dd_operator');

            $arr1 = array(
                'proc'=>7,
                'userid' => $grid,
                'telecombrandid' => $opid,
                'desig' => '',
                'apiid' => 0
            );
        }   
        else{
          $arr1 = array(
                'proc'=>7,
                'userid' => $grid,
                'telecombrandid' => $opid,
                'desig' => '',
                'apiid' => 0
            );
        }
            
        $margin = $this->slab_repo->createSlabMargin($arr1);
    	return view('Slab.dmr_surcharge', compact('slab', 'OPERATOR', 'margin','grid','opid'));
    }


    /**
        * Method name   : update all dmr surcharge
        * @description  : Used for update multiple dmr surcharge
        * @param        : Request data 
        * @return       : return update multiple dmr surcharge
    */
    public function update_all_dmr_surchage()
    {
        $request = request();
        $id = $request->ids;      
		$surcharge = $request->surcharges;
        $value = $request->values;
        $value1 = $request->values1;
        $value2 = $request->values2;
        $value3 = $request->values3;
        $value4 = $request->values4;
        $method = $request->methods;
        $type = $request->types;
        $count = count($id);


        for($i=0; $i<$count ; $i++){
            $arr = array(
				'tr17_grop_dmr_surcharge' =>$surcharge[$i],
                'tr17_grop_dmr' => $value[$i],
                'tr17_grop_dmr_d' => $value1[$i],
                'tr17_grop_dmr_md' => $value2[$i],
                'tr17_grop_dmr_sd' => $value3[$i],
                'tr17_grop_dmr_ad' => $value4[$i],
                'tr17_group_margin_distri' => $method[$i],
                'tr17_group_margin_type' => $type[$i]
            );
           $data = $this->slab_repo->updateDmrSurcharge($id[$i], $arr);
        }
		if($data)
        {
            return 1;
        }
        else
        {
            return 2;
        }
    }


    /**
        * Method name   : update dmr surcharge
        * @description  : Used for update dmr surcharge
        * @param        : Request data 
        * @return       : return update dmr surcharge
    */
    public function update_dmr_surchage($id)
    {
        $request = request();

        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            //dd($request);
            $arr = array(
			    'tr17_grop_dmr_surcharge' => $request->input('txt_surcharge_'.$id),
                'tr17_grop_dmr' => $request->input('txt_retailer_margin_'.$id),
                'tr17_grop_dmr_d' => $request->input('txt_distr_margin_'.$id),
                'tr17_grop_dmr_md' => $request->input('txt_master_distr_margin_'.$id),
                'tr17_grop_dmr_sd' => $request->input('txt_super_distr_margin_'.$id),
                'tr17_grop_dmr_ad' => $request->input('txt_admin_distr_margin_'.$id),
                'tr17_group_margin_distri' => $request->input('dd_distribution'.$id),
                'tr17_group_margin_type' => $request->input('dd_margintype'.$id)
            );
            //dd($arr);
            $this->slab_repo->updateDmrSurcharge($id, $arr);
        }
        
        return redirect('/dmr_surcharge');
    }

    /**
        * Method name   : Prepaid api sequence
        * @description  : Used for prepaid api sequence
        * @param        : Request data 
        * @return       : return prepaid api sequence
    */
    public function prepaidapi_sequences()
    {
        $request = request();

        $api = $this->api_repo->getAll();
        $slab = $this->slab_repo->getAll();
        $OPERATOR = Helper::get_operator(-1,'ALL');
		  $grid = -1;
            $opid = -1;
        if($request->method() == 'POST')
        {
            $grid = $request->input('dd_group');
            $opid = $request->input('dd_operator');

            $arr1 = array(
                'proc'=>2,
                'userid' => $grid,
                'telecombrandid' => $opid,
                'desig' => '',
                'apiid' => 0
            );
        }   
        else{
            $arr1 = array(
                'proc'=>2,
                'userid' => $grid,
                'telecombrandid' => $opid,
                'desig' => '',
                'apiid' => 0
            );
        }
            
        $margin = $this->slab_repo->createSlabMargin($arr1);
    	return view('Slab.prepaidapi_sequences', compact('api', 'slab', 'OPERATOR', 'margin','grid','opid'));
    }


    /**
        * Method name   : update all prepaidapi sequences
        * @description  : Used for update prepaidapi sequences
        * @param        : Request data 
        * @return       : return update prepaidapi sequences
    */
    public function update_all_prepaidapi_sequences()
    {
		
        $request = request();
        $id = $request->ids;      
		$op = $request->ops;
		$opsq = $request->opsq;
        $value = $request->values;
        $value9 = $request->value9;
        $type = $request->types;
        $count = count($id);
        $api = $this->api_repo->getAll();



        for($i=0; $i<$count ; $i++){

            $apiarray = array();
            foreach ($value9[$i][1] as $key => $value) {
            foreach ($api as $keys => $values) {
                if($value == $keys)
                {
                     array_push($apiarray, $values);
                }
            }
            }

            if(isset($apiarray[0]))
            {
                $arr = array(
                    'm12_api_id' => $apiarray[0]->API_ID,
                    'm15_sp_code'=> Helper::get_apicode($apiarray[0]->API_ID ,$op[$i]),
                    'm12_api_id_1' => 0,
                    'm15_sp_code_1'=> 0,
                    'm12_api_id_2' => 0,
                    'm15_sp_code_2'=> 0,
                    'm12_api_id_3' => 0,
                    'm15_sp_code_3'=> 0,
                    'm12_api_id_4' => 0,
                    'm15_sp_code_4'=> 0,
                    'm12_api_id_5' => 0,
                    'm15_sp_code_5'=> 0,
                    'tr06_grop_status' => $type[$i]
                );

                $data = $this->slab_repo->updatePrepaidApiSequence($opsq[$i], $arr);
            } 


            if(isset($apiarray[1]))
            {
                $arr1 = array(
                    'm12_api_id_1' => $apiarray[1]->API_ID,
                    'm15_sp_code_1'=> Helper::get_apicode($apiarray[1]->API_ID ,$op[$i]),
                    'm12_api_id_2' => 0,
                    'm15_sp_code_2'=> 0,
                    'm12_api_id_3' => 0,
                    'm15_sp_code_3'=> 0,
                    'm12_api_id_4' => 0,
                    'm15_sp_code_4'=> 0,
                    'm12_api_id_5' => 0,
                    'm15_sp_code_5'=> 0,
                    'tr06_grop_status' => $type[$i]
                );
                $data = $this->slab_repo->updatePrepaidApiSequence($opsq[$i], $arr1);
            }

            if(isset($apiarray[2]))
            {
                $arr2 = array(
                    'm12_api_id_2' => $apiarray[2]->API_ID,
                    'm15_sp_code_2'=> Helper::get_apicode($apiarray[2]->API_ID ,$op[$i]),
                    'm12_api_id_3' => 0,
                    'm15_sp_code_3'=> 0,
                    'm12_api_id_4' => 0,
                    'm15_sp_code_4'=> 0,
                    'm12_api_id_5' => 0,
                    'm15_sp_code_5'=> 0,
                    'tr06_grop_status' => $type[$i]
                );
                $data = $this->slab_repo->updatePrepaidApiSequence($opsq[$i], $arr2);
            }

            if(isset($apiarray[3]))
            {
                $arr3 = array(
                    'm12_api_id_3' => $apiarray[3]->API_ID,
                    'm15_sp_code_3'=> Helper::get_apicode($apiarray[3]->API_ID ,$op[$i]),
                    'm12_api_id_4' => 0,
                    'm15_sp_code_4'=> 0,
                    'm12_api_id_5' => 0,
                    'm15_sp_code_5'=> 0,
                    'tr06_grop_status' => $type[$i]
                );

                $data = $this->slab_repo->updatePrepaidApiSequence($opsq[$i], $arr3);
            }

            if(isset($apiarray[4]))
            {
                $arr4 = array(
                    'm12_api_id_4' => $apiarray[4]->API_ID,
                    'm15_sp_code_4'=> Helper::get_apicode($apiarray[4]->API_ID ,$op[$i]),
                    'm12_api_id_5' => 0,
                    'm15_sp_code_5'=> 0,
                    'tr06_grop_status' => $type[$i]
                );
                $data = $this->slab_repo->updatePrepaidApiSequence($opsq[$i], $arr4);
            }

            if(isset($apiarray[5]))
            {
                $arr5 = array(
                    'm12_api_id_5' => $apiarray[5]->API_ID,
                    'm15_sp_code_5'=> Helper::get_apicode($apiarray[5]->API_ID ,$op[$i]),
                    'tr06_grop_status' => $type[$i]
                );
                $data = $this->slab_repo->updatePrepaidApiSequence($opsq[$i], $arr5);
            }

        }

        if($data)
        {
            return 1;
        }
        else
        {
            return 2;
        }

    }


    /**
        * Method name   : update prepaidapi sequences
        * @description  : Used for update prepaidapi sequences
        * @param        : Request data 
        * @return       : return update prepaidapi sequences
    */
    public function update_prepaidapi_sequences($id)
    {
        $request = request();
        $apiarray = array();
        $api = $this->api_repo->getAll();
        foreach ($request->dd_api1 as $key => $value) {
        foreach ($api as $keys => $values) {
           
            if($value == $keys)
            {
                 array_push($apiarray, $values);
            }
        }
        }

        if(isset($apiarray[0]))
        {
            $arr = array(
                'm12_api_id' => $apiarray[0]->API_ID,
                'm15_sp_code'=>Helper::get_apicode($apiarray[0]->API_ID ,$request->input('txt_operator')),
                'm12_api_id_1' => 0,
                'm15_sp_code_1'=> 0,
                'm12_api_id_2' => 0,
                'm15_sp_code_2'=> 0,
                'm12_api_id_3' => 0,
                'm15_sp_code_3'=> 0,
                'm12_api_id_4' => 0,
                'm15_sp_code_4'=> 0,
                'm12_api_id_5' => 0,
                'm15_sp_code_5'=> 0,
                'tr06_grop_status' => $request->dd_status
            );
           $data = $this->slab_repo->updatePrepaidApiSequence($id, $arr);
        }        
        if(isset($apiarray[1]))
        {
            $arr1 = array(
                'm12_api_id_1' => $apiarray[1]->API_ID,
                'm15_sp_code_1'=>Helper::get_apicode($apiarray[1]->API_ID,$request->input('txt_operator')),
                'm12_api_id_2' => 0,
                'm15_sp_code_2'=> 0,
                'm12_api_id_3' => 0,
                'm15_sp_code_3'=> 0,
                'm12_api_id_4' => 0,
                'm15_sp_code_4'=> 0,
                'm12_api_id_5' => 0,
                'm15_sp_code_5'=> 0,
                'tr06_grop_status' => $request->dd_status
            );
           $data = $this->slab_repo->updatePrepaidApiSequence($id, $arr1);
        }        
        if(isset($apiarray[2]))
        {
            $arr2 = array(
                'm12_api_id_2' => $apiarray[2]->API_ID,
                'm15_sp_code_2'=>Helper::get_apicode($apiarray[2]->API_ID,$request->input('txt_operator')),
                'm12_api_id_3' => 0,
                'm15_sp_code_3'=> 0,
                'tr06_grop_status' => $request->dd_status
            );
          $data =  $this->slab_repo->updatePrepaidApiSequence($id, $arr2);
        }        
        if(isset($apiarray[3]))
        {
            $arr3 = array(
                 'm12_api_id_3' => $apiarray[3]->API_ID,
                'm15_sp_code_3'=>Helper::get_apicode($apiarray[3]->API_ID,$request->input('txt_operator')),
                'm12_api_id_4' => 0,
                'm15_sp_code_4'=> 0,
                'm12_api_id_5' => 0,
                'm15_sp_code_5'=> 0,
                'tr06_grop_status' => $request->dd_status
            );
          $data = $this->slab_repo->updatePrepaidApiSequence($id, $arr3);
        }
        if(isset($apiarray[4]))
        {
            $arr4 = array(
                'm12_api_id_4' => $apiarray[4]->API_ID,
                'm15_sp_code_4'=>Helper::get_apicode($apiarray[4]->API_ID,$request->input('txt_operator')),
                'm12_api_id_5' => 0,
                'm15_sp_code_5'=> 0,
                'tr06_grop_status' => $request->dd_status
            );
           $data = $this->slab_repo->updatePrepaidApiSequence($id, $arr4);
        }
        if(isset($apiarray[5]))
        {
            $arr5 = array(   
                'm12_api_id_5' => $apiarray[5]->API_ID,
                'm15_sp_code_5'=>Helper::get_apicode($apiarray[5]->API_ID,$request->input('txt_operator')),
                'tr06_grop_status' => $request->dd_status
            );
          $data =  $this->slab_repo->updatePrepaidApiSequence($id, $arr5);
        }

        if($data)
        {
            return 1;
        }
        else
        {
            return 2;
        }
    }




    /**
        * Method name   : denomination range sequence
        * @description  : Used for denomination range  sequence
        * @param        : Request data 
        * @return       : return denomination range  sequence
    */
    public function denomination_range_sequences()
    {
        $request = request();

        $api = $this->api_repo->getAll();
        $slab = $this->slab_repo->getAll();
		$deno = DB::table('denomination_range')->get();
        $OPERATOR = Helper::get_operator(-1,'ALL');
		  $grid = -1;
            $opid = -1;
        if($request->method() == 'POST')
        {
            $grid = $request->input('dd_group');
            $opid = $request->input('dd_operator');

            $arr1 = array(
                'proc'=>16,
                'userid' => $grid,
                'telecombrandid' => $opid,
                'desig' => '',
                'apiid' => 0
            );
        }   
        else{
            $arr1 = array(
                'proc'=>16,
                'userid' => $grid,
                'telecombrandid' => $opid,
                'desig' => '',
                'apiid' => 0
            );
        }
        $margin = $this->slab_repo->createSlabMargin($arr1);
    	return view('Slab.denomination_range_sequences', compact('api', 'slab', 'OPERATOR', 'margin','grid','opid','deno'));
    }




    /**
        * Method name   : update all denomination range  sequences
        * @description  : Used for update denomination range  sequences
        * @param        : Request data 
        * @return       : return update denomination range  sequences
    */
    public function update_all_denomination_range_sequences()
    {
		
        $request = request();
        $id = $request->ids;      
        $value = $request->values;
		$op = $request->ops;
		$opsq = $request->opsq;
        $api = $request->api;
        $deno = $request->deno;


        $count = count($id);
        for($i=0; $i<$count ; $i++)
		{
            $arr1 = array(
                'm68_denomin_range_id' => $deno[$i],
                'tr01_denomin_range_api' => $api[$i]
            );
           $data =  $this->slab_repo->updatePrepaidApiSequence($opsq[$i], $arr1);
        }
       if($data){ return 1; }else{ return 2; }
    }





    /**
        * Method name   : Utility api sequence
        * @description  : Used for utility api sequence
        * @param        : Request data 
        * @return       : return utility api sequence
    */
    public function utilityapi_sequences()
    {
        $request = request();

        $api = $this->api_repo->getAll();
        $slab = $this->slab_repo->getAll();
        $OPERATOR = Helper::get_operator(-1,'ALL');
        $SERVICE = $this->service_repo->getAll();
        $grid = -1;
        $opid = -1;

        if($request->method() == 'POST')
        {    
            $grid = $request->input('dd_group');
            $opid = $request->input('dd_service');
            
        }
        $arr1 = array(
            'proc'=>5,
            'userid' => $grid,
            'telecombrandid' => $opid,
            'desig' => '',
            'apiid' => 0
        );

            
        $margin = $this->slab_repo->createSlabMargin($arr1);
    	return view('Slab.utilityapi_sequences', compact('api', 'slab', 'OPERATOR', 'margin', 'SERVICE','grid','opid'));
    }


    /**
        * Method name   : update all utilityapi sequences
        * @description  : Used for update utilityapi sequences
        * @param        : Request data 
        * @return       : return update utilityapi sequences
    */
    public function update_all_utilityapi_sequences()
    {
        $request = request();
        $id = $request->ids;      
        $value = $request->values;
        $value9 = $request->value9;
        $type = $request->types;
        $count = count($id);
        $api = $this->api_repo->getAll();


        for($i=0; $i<$count ; $i++){

            $apiarray = array();
            foreach ($value9[$i][1] as $key => $value) {
            foreach ($api as $keys => $values) {
                if($value == $keys)
                {
                     array_push($apiarray, $values);
                }
            }
            }

            if(isset($apiarray[0]))
            {
                $arr = array(
                    'm12_api_id' => $apiarray[0]->API_ID,
                    'm12_api_id_1' => 0,
                    'm12_api_id_2' => 0,
                    'm12_api_id_3' => 0,
                    'm12_api_id_4' => 0,
                    'm12_api_id_5' => 0,
                    'tr06_grop_status' => $type[$i]
                );

               $data = $this->slab_repo->updateUtilityApiSequence($id[$i], $arr);
            } 
            if(isset($apiarray[1]))
            {
                $arr = array(
                    'm12_api_id_1' => $apiarray[1]->API_ID,
                    'm12_api_id_2' => 0,
                    'm12_api_id_3' => 0,
                    'm12_api_id_4' => 0,
                    'm12_api_id_5' => 0,
                    'tr06_grop_status' => $type[$i]
                );
               $data = $this->slab_repo->updateUtilityApiSequence($id[$i], $arr);
            } 
            if(isset($apiarray[2]))
            {
                $arr = array(
                    'm12_api_id_2' => $apiarray[2]->API_ID,
                    'm12_api_id_3' => 0,
                    'm12_api_id_4' => 0,
                    'm12_api_id_5' => 0,
                    'tr06_grop_status' => $type[$i]
                );
               $data = $this->slab_repo->updateUtilityApiSequence($id[$i], $arr);
            }  
            if(isset($apiarray[3]))
            {
                $arr = array(
                    'm12_api_id_3' => $apiarray[3]->API_ID,
                    'm12_api_id_4' => 0,
                    'm12_api_id_5' => 0,
                    'tr06_grop_status' => $type[$i]
                );
               $data = $this->slab_repo->updateUtilityApiSequence($id[$i], $arr);
            }   
            if(isset($apiarray[4]))
            {
                $arr = array(
                    'm12_api_id_4' => $apiarray[4]->API_ID,
                    'm12_api_id_5' => 0,
                    'tr06_grop_status' => $type[$i]
                );
               $data = $this->slab_repo->updateUtilityApiSequence($id[$i], $arr);
            }   
            if(isset($apiarray[5]))
            {
                $arr = array(
                    'm12_api_id_5' => $apiarray[5]->API_ID,
                    'tr06_grop_status' => $type[$i]
                );
               $data = $this->slab_repo->updateUtilityApiSequence($id[$i], $arr);
            }
        }

        if($data)
        {
            return 1;
        }
        else
        {
            return 2;
        }
    }

    /**
        * Method name   : update utilityapi sequences
        * @description  : Used for update utilityapi sequences
        * @param        : Request data 
        * @return       : return update utilityapi sequences
    */
    public function update_utilityapi_sequences($id)
    {
        $request = request();

        $apiarray = array();
        $api = $this->api_repo->getAll();
        foreach ($request->dd_api1 as $key => $value) {
        foreach ($api as $keys => $values) {
           
            if($value == $keys)
            {
                 array_push($apiarray, $values);
            }
        }
        }


        if(isset($apiarray[0]))
        {
            $arr = array(
                'm12_api_id' => $apiarray[0]->API_ID,
                'm12_api_id_1' => 0,
                'm12_api_id_2' => 0,
                'm12_api_id_3' => 0,
                'm12_api_id_4' => 0,
                'm12_api_id_5' => 0,
                'tr06_grop_status' => $request->dd_status
            );

           $data = $this->slab_repo->updateUtilityApiSequence($id, $arr);
        } 
        if(isset($apiarray[1]))
        {
            $arr = array(
                'm12_api_id_1' => $apiarray[1]->API_ID,
                'm12_api_id_2' => 0,
                'm12_api_id_3' => 0,
                'm12_api_id_4' => 0,
                'm12_api_id_5' => 0,
                'tr06_grop_status' => $request->dd_status
            );
           $data = $this->slab_repo->updateUtilityApiSequence($id, $arr);
        } 
        if(isset($apiarray[2]))
        {
            $arr = array(
                'm12_api_id_2' => $apiarray[2]->API_ID,
                'm12_api_id_3' => 0,
                'm12_api_id_4' => 0,
                'm12_api_id_5' => 0,
                'tr06_grop_status' => $request->dd_status
            );
           $data = $this->slab_repo->updateUtilityApiSequence($id, $arr);
        }  
        if(isset($apiarray[3]))
        {
            $arr = array(
                'm12_api_id_3' => $apiarray[3]->API_ID,
                'm12_api_id_4' => 0,
                'm12_api_id_5' => 0,
                'tr06_grop_status' => $request->dd_status
            );
           $data = $this->slab_repo->updateUtilityApiSequence($id, $arr);
        }   
        if(isset($apiarray[4]))
        {
            $arr = array(
                'm12_api_id_4' => $apiarray[4]->API_ID,
                'm12_api_id_5' => 0,
                'tr06_grop_status' => $request->dd_status
            );
           $data = $this->slab_repo->updateUtilityApiSequence($id, $arr);
        }   
        if(isset($apiarray[5]))
        {
            $arr = array(
                'm12_api_id_5' => $apiarray[5]->API_ID,
                'tr06_grop_status' => $request->dd_status
            );
           $data = $this->slab_repo->updateUtilityApiSequence($id, $arr);
        } 

        if($data)
        {
            return 1;
        }
        else
        {
            return 2;
        }
    }

    /**
        * Method name   : Prepaid api limit
        * @description  : Used for prepaid api limit
        * @param        : Request data 
        * @return       : return prepaid api limit
    */
    public function prepaidapi_limit()
    {
        $page = 'SLAB PANEL';
        $form_name = 'PREPAID API LIMIT SLAB WISE';
        $request = request();
          $grid = -1;
        $opid = -1;
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
                if($request->input('dd_group')!="" && $request->input('dd_group')!="0")
                {
                    $grid=$request->input('dd_group');
                }
				 $opid = $request->input('dd_operator');
        }
        $slab=array(
                'proc'=>2,
                'userid'=>$grid,
                'telecombrandid'=> $opid,
                'desig'=>1,
                'apiid'=>1 ,
                'msg'=>@msg
            );
        $slab_report=DB::select('CALL slab_margin(              
                :proc,
                :userid,
                :telecombrandid,
                :desig,
                :apiid,
                :msg
                )',$slab);
       
        $GROUP = Helper::get_group(-1,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        $OPERATOR = Helper::get_operator(-1,'ALL');
        return view('Slab.prepaidapi_limit', compact('OPERATOR','slab_report','GROUP','API','grid','opid'));
    }

    public function update_prepaidapi_limit($id)
    {
        $page = 'SLAB PANEL';
        $form_name = 'PREPAID API LIMIT SLAB WISE';
        $request = request();
        $groupid=1;
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
                if($request->input('dd_group')!="" && $request->input('dd_group')!="0")
                {
                    $groupid=$request->input('dd_group');
                }
                $api_sequences = array(
                        'm15_max_quantity' =>$request->input('txt_limitvalue'.$id)
                        );
        DB::table('tr06_group_op')->where('tr06_grop_id',$id)->update($api_sequences);
        }
        $slab=array(
                'proc'=>2,
                'userid'=>$groupid,
                'telecombrandid'=>1,
                'desig'=>1,
                'apiid'=>1 ,
                'msg'=>@msg
            );
        $slab_report=DB::select('CALL slab_margin(              
                :proc,
                :userid,
                :telecombrandid,
                :desig,
                :apiid,
                :msg
                )',$slab);
        Session::flash('message','UPDATE SUCCESSFULLY PREPAID API LIMIT SLAB WISE');
        Session::flash('type','success' );
        $GROUP = Helper::get_group(-1,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        $SERVICE = $this->service_repo->getAll();
        return view('Slab.prepaidapi_limit', compact('SERVICE','slab_report','GROUP','API'));
    }
    
    public function update_prepaidapilimitto_all()
    {
        $request = request();

        $id = $request->ids;      
        $value = $request->values;
        $type = $request->types;
        $count = count($id);

        for($i=0; $i<$count ; $i++){
            $api_sequences = array(
                'm15_max_quantity' => $value[$i]
            );
             $data=DB::table('tr06_group_op')->where('tr06_grop_id',$id[$i])->update($api_sequences);
        }


        if($data)
        {
            return 1;
        }
        else
        {
            return 2;
        }
        
    }
    public function utilityapi_limit()
    {
        $page = 'SLAB PANEL';
        $form_name = 'UTILITY API LIMIT SLAB WISE';
        $request = request();
        $groupid=1;
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
                if($request->input('dd_group')!="" && $request->input('dd_group')!="0")
                {
                    $groupid=$request->input('dd_group');
                }
        }
        $slab=array(
                'proc'=>5,
                'userid'=>$groupid,
                'telecombrandid'=>1,
                'desig'=>1,
                'apiid'=>1 ,
                'msg'=>@msg
            );
        $slab_report=DB::select('CALL slab_margin(              
                :proc,
                :userid,
                :telecombrandid,
                :desig,
                :apiid,
                :msg
                )',$slab);

        Session::flash('message','UTILITY API SEQUENCE SLAB WISE');
        Session::flash('type','info' );
        $GROUP = Helper::get_group(-1,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        $SERVICE = $this->service_repo->getAll();
        return view('Slab.utilityapi_limit', compact('SERVICE','slab_report','GROUP','API'));
    }

    public function update_utilityapi_limit($id)
    {
        $page = 'SLAB PANEL';
        $form_name = 'UTILITY API LIMIT SLAB WISE';
        $request = request();
        $groupid=1;
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
                if($request->input('dd_group')!="" && $request->input('dd_group')!="0")
                {
                    $groupid=$request->input('dd_group');
                }
                $api_sequences = array(
                        'm15_max_quantity' =>$request->input('txt_limitvalue'.$id)
                        );
            DB::table('tr06_group_op')->where('tr06_grop_id',$id)->update($api_sequences);
        }
        $slab=array(
                'proc'=>5,
                'userid'=>$groupid,
                'telecombrandid'=>1,
                'desig'=>1,
                'apiid'=>1 ,
                'msg'=>@msg
            );
        $slab_report=DB::select('CALL slab_margin(              
                :proc,
                :userid,
                :telecombrandid,
                :desig,
                :apiid,
                :msg
                )',$slab);

        Session::flash('message','UPDATE SUCCESSFULLY PREPAID API LIMIT SLAB WISE');
        Session::flash('type','success' );
        $GROUP = Helper::get_group(-1,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        return view('Slab.utilityapi_limit', compact('page', 'form_name','slab_report','GROUP','API'));
    }

    public function update_utilityapilimitto_all()
    {
       
        $request = request();

        $id = $request->ids;      
        $value = $request->values;
        $type = $request->types;
        $count = count($id);

        for($i=0; $i<$count ; $i++){
            $api_sequences = array(
                'm15_max_quantity' =>$request->input('txt_limitvalue'.$id)
            );
            DB::table('tr06_group_op')->where('tr06_grop_id',$id)->update($api_sequences);
        }


        return 1;
    }
    
    
     public function aeps_margin()
    {
		$request = request();
		$groupid=$request->input('dd_group');
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
				if($request->input('dd_group')!="" && $request->input('dd_group')!="0")
				{
					$groupid=$request->input('dd_group');
				}
	    }
		$slab=array(
				'proc'=>12,
				'userid'=>$groupid,
				'telecombrandid'=>1,
				'desig'=>1,
                'apiid'=>1 ,
                'msg'=>@msg
            );
        $slab_margin=DB::select('CALL slab_margin(				
                :proc,
                :userid,
                :telecombrandid,
                :desig,
                :apiid,
                :msg
                )',$slab);
                //dd($slab_margin);
		$GROUP = Helper::get_group(-1,'ACTIVE');
        Session::flash('message','AEPS SURCHARGE SLAB WISE');
		Session::flash('type','info' );
    	return view('Slab.aeps_margin', compact('GROUP','slab_margin','groupid'));
    }

    public function update_aepsmargin($id)
    {
		$request =request();
		$groupid=$request->input('dd_group');
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
			if($request->input('dd_group')!="" && $request->input('dd_group')!="0")
			{
				$groupid=$request->input('dd_group');
			}
				$arr_margin = array(
				'tr22_grop_aeps_ad'=> $request->input('txt_admin_distr_margin_'.$id),
				'tr22_grop_aeps_sd'=> $request->input('txt_super_distr_margin_'.$id),
				'tr22_grop_aeps_md'=>  $request->input('txt_master_distr_margin_'.$id),
				'tr22_grop_aeps_d'=> $request->input('txt_distr_margin_'.$id),
				'tr22_grop_aeps'=>$request->input('txt_retailer_margin_'.$id),
				 'tr22_group_margin_distri' =>$request->input('dd_distribution'.$id),
                'tr22_group_margin_type' =>$request->input('dd_margintype'.$id)
				);
				DB::table('tr22_group_aeps')->where('tr22_group_aepsid',$id)->update($arr_margin);
	    }
		$slab=array(
				'proc'=>12,
				'userid'=>$groupid,
				'telecombrandid'=>1,
				'desig'=>1,
                'apiid'=>1 ,
                'msg'=>@msg
            );
        $slab_margin=DB::select('CALL slab_margin(				
                :proc,
                :userid,
                :telecombrandid,
                :desig,
                :apiid,
                :msg
                )',$slab);
		$GROUP = Helper::get_group(-1,'ACTIVE');
		Session::flash('type','success' );
        Session::flash('message','UPDATE SUCCESSFULLY AEPS SLAB WISE');
    	return redirect('aeps_margin');
    }
    
    
    public function update_aepsmarginto_all()
    {
 
         $request = request();
        $id = $request->ids;      
        $value = $request->values;
        $value1 = $request->values1;
        $value2 = $request->values2;
        $value3 = $request->values3;
        $value4 = $request->values4;
        $method = $request->methods;
        $type = $request->types;
        $count = count($id);


        for($i=0; $i<$count ; $i++){
            $arr = array(
                'tr22_grop_aeps' => $value[$i],
                'tr22_grop_aeps_d' => $value1[$i],
                'tr22_grop_aeps_md' => $value2[$i],
                'tr22_grop_aeps_sd' => $value3[$i],
                'tr22_grop_aeps_ad' => $value4[$i],
                'tr22_group_margin_distri' => $method[$i],
                'tr22_group_margin_type' => $type[$i]
            );
               DB::table('tr22_group_aeps')->where('tr22_group_aepsid',$id[$i])->update($arr);
           // $this->slab_repo->updateDmrSurcharge($id[$i], $arr);
        }
        
        return 1;
    }

	 public function pan_margin()
    {
        $page = 'SLAB PANEL';
        $form_name = 'AEPS SURCHARGE SLAB WISE';
        $request = request();
        $groupid=$request->input('dd_group');
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            if($request->input('dd_group')!="" && $request->input('dd_group')!="0")
            {
                $groupid=$request->input('dd_group');
            }
        }
        $slab=array(
                'proc'=>13,
                'userid'=>$groupid,
                'telecombrandid'=>1,
                'desig'=>1,
                'apiid'=>1 ,
                'msg'=>@msg
            );
        $slab_margin=DB::select('CALL slab_margin(              
                :proc,
                :userid,
                :telecombrandid,
                :desig,
                :apiid,
                :msg
                )',$slab);
        $GROUP = Helper::get_group(-1,'ACTIVE');
        Session::flash('message','PAN SURCHARGE SLAB WISE');
        Session::flash('type','info' );
        return view('Slab.pan_margin', compact('GROUP','slab_margin','groupid'));
    }

 public function update_pantoken_margin($id)
    {
		$request =request();
		$groupid=$request->input('dd_group');
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
			if($request->input('dd_group')!="" && $request->input('dd_group')!="0")
			{
				$groupid=$request->input('dd_group');
			}
				$arr_margin = array(
				'tr37_grop_pantoken_ad'=> $request->input('txt_admin_distr_margin_'.$id),
				'tr37_grop_pantoken_sd'=> $request->input('txt_super_distr_margin_'.$id),
				'tr37_grop_pantoken_md'=>  $request->input('txt_master_distr_margin_'.$id),
				'tr37_grop_pantoken_d'=> $request->input('txt_distr_margin_'.$id),
				'tr37_grop_pantoken'=>$request->input('txt_retailer_margin_'.$id),
				 'tr37_group_margin_distri' =>$request->input('dd_distribution'.$id),
                'tr37_group_margin_type' =>$request->input('dd_margintype'.$id)
				);
				DB::table('tr37_group_pan')->where('tr37_group_panid',$id)->update($arr_margin);
	    }
		 $slab=array(
                'proc'=>13,
                'userid'=>$groupid,
                'telecombrandid'=>1,
                'desig'=>1,
                'apiid'=>1 ,
                'msg'=>@msg
            );
        $slab_margin=DB::select('CALL slab_margin(              
                :proc,
                :userid,
                :telecombrandid,
                :desig,
                :apiid,
                :msg
                )',$slab);
        $GROUP = Helper::get_group(-1,'ACTIVE');
        Session::flash('message','PAN SURCHARGE SLAB WISE');
        Session::flash('type','info' );
	
        return redirect('pan_margin');
    }
    public function update_pantokento_all()
    {
       
         $request = request();
        $id = $request->ids;      
        $value = $request->values;
        $value1 = $request->values1;
        $value2 = $request->values2;
        $value3 = $request->values3;
        $value4 = $request->values4;
        $method = $request->methods;
        $type = $request->types;
        $count = count($id);


        for($i=0; $i<$count ; $i++){
            $arr = array(
                'tr37_grop_pantoken' => $value[$i],
                'tr37_grop_pantoken_d' => $value1[$i],
                'tr37_grop_pantoken_md' => $value2[$i],
                'tr37_grop_pantoken_sd' => $value3[$i],
                'tr37_grop_pantoken_ad' => $value4[$i],
                'tr37_group_margin_distri' => $method[$i],
                'tr37_group_margin_type' => $type[$i]
            );
               DB::table('tr37_group_pan')->where('tr37_group_panid',$id[$i])->update($arr);
           // $this->slab_repo->updateDmrSurcharge($id[$i], $arr);
        }
        
        return 1;
    }


	/**
        * Method name   : circle range sequence
        * @description  : Used for circle range  sequence
        * @param        : Request data 
        * @return       : return circle range  sequence
    */
    public function circle_range_sequences()
    {
        $request = request();

        $api = $this->api_repo->getAll();
        $slab = $this->slab_repo->getAll();
        $circle = DB::table('op_circle')->get();
        $OPERATOR = Helper::get_operator(-1,'ALL');
          $grid = -1;
            $opid = -1;
        if($request->method() == 'POST')
        {
            $grid = $request->input('dd_group');
            $opid = $request->input('dd_operator');

            $arr1 = array(
                'proc'=>17,
                'userid' => $grid,
                'telecombrandid' => $opid,
                'desig' => '',
                'apiid' => 0
            );
        }   
        else{
            $arr1 = array(
                'proc'=>17,
                'userid' => $grid,
                'telecombrandid' => $opid,
                'desig' => '',
                'apiid' => 0
            );
        }
        $margin = $this->slab_repo->createSlabMargin($arr1);
        return view('Slab.circle_range_sequences', compact('api', 'slab', 'OPERATOR', 'margin','grid','opid','circle'));
    }




    /**
        * Method name   : update all circle range  sequences
        * @description  : Used for update circle range  sequences
        * @param        : Request data 
        * @return       : return update circle range  sequences
    */
    public function update_all_circle_range_sequences()
    {
       $request = request();
        $id = $request->ids;      
		$op = $request->ops;
		$opsq = $request->opsq;
        $value6 = $request->values;
        $value9 = $request->value9;
        $type = $request->types;
        $count = count($id);
        $api = $this->api_repo->getAll();
		$circle = DB::table('op_circle')->get();

        for($i=0; $i<$count ; $i++){
            $apiarray = array();
		if(isset($value9[$i][1]))
		{
            foreach ($value9[$i][1] as $key => $value) {
            foreach ($circle as $keys => $values) {
                if($value == $keys)
                {
                     array_push($apiarray, $values->CIRCLE_ID);
                }
            }
            }
		}
		else
		{
			array_push($apiarray, '0');
		}

                   $arr = array(
                            'm13_circle_id' =>implode(",",$apiarray),
                            'tr06_circle_api'=>$value6[$i]
                        );

                       $data = $this->slab_repo->updatePrepaidApiSequence($opsq[$i], $arr);
}

			/* for($i=0; $i<$count ; $i++){
             foreach ($value9[$i][1] as $key => $value) {
                    $arr = array(
                            'm13_circle_id' =>$value,
                            'tr06_circle_api'=>$value6[$i]
                        );
                        $data = $this->slab_repo->updatePrepaidApiSequence($opsq[$i], $arr);
                }
        }
 */
        if($data)
        {
            return 1;
        }
        else
        {
            return 2;
        }
    }
}