<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Repositories\Master\Location\LocationRepository;
use App\Repositories\Master\Package\PackageRepository;
use App\Repositories\Employee\EmployeeRepository;
use App\Repositories\Enroll\EnrollRepository;
use App\Repositories\Fund\FundRepository;
use App\Repositories\Associate\AssociateRepository;
use App\Repositories\Topup\TopupRepository;
use App\Repositories\Team\TeamRepository;
use App\Repositories\Profile\ProfileRepository;
use App\Repositories\Log\LogRepository;
use App\Repositories\Master\Bank\BankRepository;
use App\Repositories\Affiliate\AffiliateRepository;
use App\Repositories\Slab\SlabRepository;
use App\Repositories\Shop\ShopRepository;
use App\Repositories\Pantoken\PantokenRepository;
use DB;
use Image;
use Session;
use Helper;
use Hash;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use MahagramPantoken;
use Carbon\Carbon;

class ProfileController extends Controller
{
    var $message = "Invalid Operation";
    private $userDisbled = 0;
	private $STATUS = "failed";
	private $ERRMSG = "Invalid Operation";
	private $ERRCODE = "error";
	private $isError = FALSE;
	private $record_per_page =10;
	private $location_repo;
	private $package_repo;
	private $emp_repo;
	private $fund_repo;
	private $enroll_repo;
	private $profile_repo;
	private $topup_repo;
	private $team_repo;
	private $log_repo;
	private $bank_repo;
	private $associate_repo;
	private $Affiliate_repo;
	private $slab_repo;
	private $Shop_repo;
	private $pantoken_repo;

	public function __construct(LocationRepository $location_repo, PackageRepository $package_repo,
		EmployeeRepository $emp_repo, EnrollRepository $enroll_repo, ProfileRepository $profile_repo,
		TopupRepository $topup_repo, TeamRepository $team_repo, LogRepository $log_repo,
		BankRepository $bank_repo, AssociateRepository $associate_repo,  AffiliateRepository $Affiliate_repo, 
     SlabRepository $slab_repo, ShopRepository $Shop_repo, PantokenRepository $pantoken_repo, FundRepository $fund_repo)
    {
    	$this->location_repo = $location_repo;
    	$this->package_repo = $package_repo;
    	$this->emp_repo = $emp_repo;
    	$this->fund_repo = $fund_repo;
    	$this->enroll_repo = $enroll_repo;
    	$this->profile_repo = $profile_repo;
    	$this->topup_repo = $topup_repo;
    	$this->team_repo = $team_repo;
    	$this->log_repo = $log_repo;
    	$this->bank_repo = $bank_repo;
    	$this->associate_repo = $associate_repo;
		$this->Affiliate_repo = $Affiliate_repo;
		$this->slab_repo = $slab_repo;
		$this->Shop_repo = $Shop_repo;
		$this->pantoken_repo = $pantoken_repo;
    }



	/**
		* Method name	: match values
		* @description 	: Used for matching old and new inserted values
		* @param		: Request data  
		* @return		: return updated values with old values before updation
	*/
    public function match_values($old_values,$new_values)
	{
		$old_value=$old_values[0];
		$new_arr = array();
		foreach($old_value as $key=>$value){ $new_arr[$key] = $value; }
		$count=count($new_arr);
		$arr_key = array_keys($new_values);
		$arr_val = array_values($new_arr);
		$new_old_array = array();
		for($i=0;$i<$count;$i++){ $new_old_array[$arr_key[$i]] = $arr_val[$i]; }
		$result = array_diff($new_values, $new_old_array);
		$new_values1 = json_encode(array_intersect_key($new_values,$result));
		$old_values1 = json_encode(array_intersect_key($new_old_array,$result));

		return [$new_values1,$old_values1];
	}



    /**
			* Method name	: Index
			* @description 	: Used for verifying otp 
			* @param		: Request data  
			* @return		: return to login from if otp validated
		*/
	public function index()
	{
    	return view('Profile.all_user');
    }

    /**
			* Method name	: Registration
			* @description 	: Used for user registration 
			* @param		: no param  
			* @return		: return view
		*/
    public function registration()
    {
		$state = $this->location_repo->getAllStates();
		$package = $this->package_repo->getAllPackage();
		$banks = $this->bank_repo->getAll();
		$data['country'] = $this->location_repo->getAllCountries();
		$service =[];
		//$service = DB::select("SELECT * FROM admin_service_charges WHERE USER_ROLE_ID = 7 AND STATUS = 'ACTIVE'");
    	return view('Profile.registration', compact('state','package', 'banks','data','service'));
    }

    /**
        * Method name   : associate registration
        * @description  : Used for associate registration
        * @param        : Request data 
        * @return       : return with associate registration view
    */
	public function associate_registration()
	{
		$state = $this->location_repo->getAllStates();
		$package = $this->package_repo->getAllPackage();
		$banks = $this->bank_repo->getAll();
		return view('Profile.associate_registration', compact('state','package', 'banks'));
	}

    /**
		* Method name	: Employee Signup
		* @description 	: Used for employee signup 
		* @param		: request data  
		* @return		: return to employee login form
	*/
    public function add_associate()
  	{
    $request = request();
    if($request->method() == 'POST')
    {
      
            $this->validate($request, [
		      'txt_referralcode'=> 'required',
		      'position'=> 'required',
		      'txt_username'=> 'required',
		      'txt_email'=> 'required|email',
		      'txt_mobileno'=> 'required',
		      'txt_password'=> 'required|min:3'
            ],
            [
		      'txt_referralcode.required' => 'Referral code is required!',
		      'position.required' => 'Position is required!',
		      'txt_username.required' => 'Username is required!',
		      'txt_email.required' => 'Email is required!',
		      'txt_mobileno.required' => 'Mobile No. is required!',
		      'txt_password.min' => 'Password must be at least 6 characters!'
            ]);
      
            $txt_cancelchq="";
            $txt_gstcrt ="";
            if($request->input('txt_password')=='')
            {
                $pass=rand(100000,999999); 
                $pinpass=rand(100000,999999);
      		}
            else
            {
                $pass=$request->input('txt_password');
                $pinpass=$request->input('txt_password');
      		}   
            $signup_data=Helper::reg_vendor($request,$pass,$pinpass,'','','',$txt_gstcrt,$txt_cancelchq);
			
			$response= $this->associate_repo->create($signup_data);
			$signup_data1=Helper::notify_data($request,1,"NEW ASSOCIATE INSERT SUCCESSFULLY",$response['err_msg'],0,'2');
		    //echo $response['err_code'];
			//echo $response['err_msg'];
			if($response['err_code']=="success")
			{
               // ////Helper::send_sms($request->input('txt_mobileno'),$ERRMSG[0]->ERR_MSG);
			}
			Session::flash( 'message', $response['err_msg'] );
			Session::flash( 'type', $response['err_code'] );
		    return redirect()->to('/associate_reg');  
		}
  	}

    /**
			* Method name	: Employee Registration
			* @description 	: Used for employee registration 
			* @param		: no param  
			* @return		: return view
		*/
    public function employee_reg()
    {
		$state = $this->location_repo->getAllStates();
		$package = $this->package_repo->getAllPackage();
		$banks = $this->bank_repo->getAll();
		$data['country'] = $this->location_repo->getAllCountries();
    	return view('Profile.employee_reg', compact('state','package', 'banks','data'));
    }

    /**
			* Method name	: Employee Signup
			* @description 	: Used for employee signup 
			* @param		: request data  
			* @return		: return to employee login form
		*/
    public function employee_signup()
  	{
    $request = request();
    if($request->method() == 'POST')
    {
      
            $this->validate($request, [
		      'txt_referralcode'=> 'required',
		      'position'=> 'required',
		      'txt_username'=> 'required',
		      'txt_email'=> 'required|email',
		      'txt_mobileno'=> 'required',
		      'txt_password'=> 'required|min:3'
            ],
            [
		      'txt_referralcode.required' => 'Referral code is required!',
		      'position.required' => 'Position is required!',
		      'txt_username.required' => 'Username is required!',
		      'txt_email.required' => 'Email is required!',
		      'txt_mobileno.required' => 'Mobile No. is required!',
		      'txt_password.min' => 'Password must be at least 6 characters!'
            ]);
      
            $txt_cancelchq="";
            $txt_gstcrt ="";
            if($request->input('txt_password')=='')
            {
                $pass=rand(100000,999999);
                $pinpass=rand(100000,999999);
      		}
            else
            {
                $pass=$request->input('txt_password');
                $pinpass=$request->input('txt_password');
      		}   
            $signup_data=Helper::reg_employee($request,$pass,$pinpass,'','','',$txt_gstcrt,$txt_cancelchq); 
            $response= $this->empreg_repo->create($signup_data); 
			$signup_data1=Helper::notify_data($request,1,"NEW EMPLOYEE INSERT SUCCESSFULLY",$response['err_msg'],0,'2');
			if($response['err_code']=="success")
			{
                ////////Helper::send_sms($request->input('txt_mobileno'),$ERRMSG[0]->ERR_MSG);
			}
			Session::flash( 'message', $response['err_msg'] );
			Session::flash( 'type', $response['err_code'] );
		    return redirect()->to('/employee_login');  
		}
  	}

  	

	/**
			* Method name	: Add User
			* @description 	: Used for user registration from admin panel
			* @param		: request data 
			* @return		: response message
		*/
	public function add_user()
    {
        $page = 'PROFILE PANEL';
        $form_name = 'NEW REGISTRATION';
        $request = request();

		$this->validate($request, [
            'txt_mobileno'=> 'required|numeric|digits:10|regex:/^[5-9]\d{9}$/|unique:enroll,MemberContactNo',
            'txt_email'=> 'required|email|unique:enroll,MemberEmail',
			'txt_addressproof' => 'nullable|mimes:jpeg,png,jpg|max:20240',
        ],[
            'txt_mobileno.required'=> 'Mobile Number is required',
            'txt_mobileno.numeric'=> 'Enter is valid Mobile Number',
            'txt_mobileno.digits'=> 'Enter is valid Mobile Number',
			'txt_mobileno.regex'=> 'Enter is valid Mobile Number',
            'txt_email.required'=> 'E-mail ID is required',
            'txt_email.email'=> 'Enter Valid E-mail ID',
			'txt_addressproof.mimes'=> 'Image Type jpeg,png,jpg',
			'txt_addressproof.max'=> 'Image Max 2 MB',
        ]);
	

        if($request->method() == 'POST')
        {
            
            $bankproof ="";
            $gstno ="";
		
			if($request->input('txt_password')=='')
            {
				$p = rand(100000,999999);
                $pass=$p; 
                $pinpass=$p;
      		}
            else
            {
                $pass=$request->input('txt_password');
                $pinpass=$request->input('txt_password');
      		}    

            $signup_data=Helper::reg_data($request,$pass,$pinpass,'','','',$gstno,$bankproof);   
            $response= $this->enroll_repo->create($signup_data); 

			
				$arrdata = array(
					'tr11_ar_tblnm' => 'm11_user',
					'tr11_ar_old_value' => '',
					'tr11_ar_new_value' => $response['CODE'], // json_encode($arr)
					'tr11_ar_uid' => $response['ID'],
					'tr11_ar_description' => 'NEW USER ADD SUCCESSFULLY',
					'tr11_updated_by' => 1,
					'tr11_updated_by_id' =>  Session::get('USER_ID')
					);
				$mobileno_actionrecord=$this->log_repo->create($arrdata);

			$signup_data1=Helper::notify_data($request,1,"NEW USER INSERT SUCCESSFULLY",$response['err_msg'],0,'2');

			if($response['err_code']=="success")
			{
					$template_type = 1;
					$data = array(
						'msg_title' => 'account_creation',
						'name' => $request->input('txt_username'),
						'useremail' => $request->input('txt_email'),
						'usercode' => $response['CODE'],
						'password' => $request->input('txt_password'),
						'link' => url('/home'),
						'trans_id' => url('/home'),
						'template_name' => 'registration'
					);

				/*	$msg_config = DB::select('select * from m09_message_config where m09_msg_title = "'.$data['msg_title'].'"');
					$data['MSG_CONTENT'] = $msg_config[0]->m09_msg_content;
					$data['MSG_SUBJECT'] = $msg_config[0]->m09_msg_subject;
					$data['MSG_CONTENT'] = strtr($data['MSG_CONTENT'], array('{name}' => $data['name'],
					'{useremail}'=>$data['useremail'],'{password}'=>$data['password'],'{link}'=>$data['link'],'{trans_id}'=>$data['trans_id']));
					$data['pdf'] ='';
					$template_data = $data;

					Mail::to($request->input('txt_email'))->send(new SendMail($template_data, $template_type));*/
					$msg="Welcome to ".config('SITE_NAME')." Please click on ".config('WEBSITE_NAME')." to activate your account User id :".$data['usercode']." Password : ".$pass;
					
								// SMS SEND OR INSERT
								$sms_data['MOBILE_NO'] = $request->input('txt_mobileno');
								$sms_data['SUBJECT'] = 'USER REGISTRATION';
								$sms_data['MESSAGE'] = $msg;
								$sms_data['TYPE'] = 1;
								$sms_data['SEND_BY'] = 1;
								$sms_data['SEND_BY_ID'] = Session()->get('USER_ID');
								//////Helper::send_sms_or_log($sms_data);
								//SMS SEND END 

				$user_massage  = $request->input('txt_username')." has been registered successfully. Email Id- ".$request->input('txt_email').". Id-".$data['usercode']." and Login Password-".$pass." and MPIN-".$pass." Website-".config('WEBSITE_NAME')."";
				Session::flash( 'message', $user_massage);
				Session::flash( 'type', $response['err_code']);
			}
			else
			{
				Session::flash( 'message', $response['err_msg'] );
				Session::flash( 'type', $response['err_code'] );
			}
		}
    	$state = $this->location_repo->getAllStates();
		$package = $this->package_repo->getAllPackage();
		$banks = $this->bank_repo->getAll();
		$data['country'] = $this->location_repo->getAllCountries();
		$service =[];
		//$service = DB::select("SELECT * FROM admin_service_charges WHERE USER_ROLE_ID = 7 AND STATUS = 'ACTIVE'");
    	return view('Profile.registration', compact('state','package', 'banks','data','service'));
    }

    

	/**
			* Method name	: Edit User
			* @description 	: Used for editing user data
			* @param		: request user id 
			* @return		: response user data
		*/
	public function edit_user()
    {
        $request = request();
		$user = "";
		$USERID="";
		$get_useralldetail = "";
		if($request->method() == 'POST')
		{
			   if($request->input('txt_memberid')=='')
				{
					$ERRMSG = "Member id should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
				
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$userid = Helper::get_userid($request->input('txt_memberid'));
					
					if($userid!=FALSE)
					{
					$user = Helper::get_userdetail($userid);
					$get_useralldetail = Helper::get_useralldetail($userid);
					$ERRMSG = "Member details fetch successfully.";
					$ERRCODE="success";
					}
					else
					{
					$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
					$this->isError=TRUE;
					$ERRCODE="warning";
					}
				}
		}
		$USERID=$request->input('txt_memberid');
		$banks = $this->bank_repo->getAll();
		return view('Profile.edit_userprofile',compact('user','get_useralldetail','USERID','banks'));
     
    }

    /**
			* Method name	: Update User Profile
			* @description 	: Used for updating user profile
			* @param		: request user id 
			* @return		: response updated profile with message
		*/
	public function update_userprofile()
	{
		$request = request();
		$USERID='';

		$this->validate($request, [
            //'txt_mobileno'=> 'required|numeric|digits:10|regex:/^[5-9]\d{9}$/', 	//unique:enroll,MemberContactNo
            //'txt_email'=> 'required|email', // unique:enroll,MemberEmail,
            'txt_cbsacno'=> 'required',
        ],[
            //'txt_mobileno.required'=> 'Mobile Number is required',
            //'txt_mobileno.numeric'=> 'Enter is valid Mobile Number',
            //'txt_mobileno.digits'=> 'Enter is valid Mobile Number',
			//'txt_mobileno.regex'=> 'Enter is valid Mobile Number',
            //'txt_email.required'=> 'E-mail ID is required',
            //'txt_email.email'=> 'Enter Valid E-mail ID',
            'txt_cbsacno.required'=> 'Wallet Address is required',
        ]);

		if($request->method() == 'POST')
		{
			$txt_yourphoto = '';
			// if($_FILES['txt_yourphoto']['name']!= '')
			// {
			// 	$image = $request->file('txt_yourphoto');
			// 	$name = $request->input('txt_membercode').'_PHOTO_'.time().'.'.$image->getClientOriginalExtension();
			// 	$destinationPath = public_path('images/USER_PHOTO');
			// 	$FileType = array('jpeg','png','jpg');
			// 	if(in_array($image->getClientOriginalExtension(), $FileType)) {
			// 		$image->move($destinationPath,$name);
			// 	}
			// 	else{
			// 		$request_data=json_encode($request->all());
			// 		$file_type=$image->getClientOriginalName();
			// 		$user_id=SESSION::get('USER_ID');
			// 		$server_info=json_encode(request()->server());
			// 		$user_info=json_encode(SESSION()->all()['result'][0]);
			// 		$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
			// 		return back()->with('error', 'File format not supported.'); 
			// 	}
			// 	$txt_yourphoto =  $name;
			// }
			// else
			// {
			// 	$txt_yourphoto = trim($request->input('txt_yourphotohd'));
			// }
			 if($request->input('txt_username')=='')
			{
				$ERRMSG = "Member user name should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			// else if($request->input('txt_mobileno')=='')
			// {
			// 	$ERRMSG = "Member contact number should be valid or not blank.";
			// 	$this->isError= TRUE;
			// 	$ERRCODE="warning";
			// }
			else if($request->input('txt_email')=='')
			{
				$ERRMSG = "Member email address should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			// else if($request->input('txt_dob')=='')
			// {
			// 	$ERRMSG = "Member Date of birth should be valid or not blank.";
			// 	$this->isError= TRUE;
			// 	$ERRCODE="warning";
			// }
			else if($request->input('txt_cbsacno')=='')
			{
				$ERRMSG = "Member address should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			// else if($request->input('txt_postalcode')=='')
			// {
			// 	$ERRMSG = "Postal code should be valid or not blank.";
			// 	$this->isError= TRUE;
			// 	$ERRCODE="warning";
			// }
			// else if($txt_yourphoto=='')
			// {
			// 	$ERRMSG = "Member image should be valid or not blank.";
			// 	$this->isError= TRUE;
			// 	$ERRCODE="warning";
			// }
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				$name=explode(" " ,$request->input('txt_username'));
				$user_name=$request->input('txt_username');
				$USER=$request->input('txt_userid');
				
				if(isset($name[1]))
				{
					$l_name = $name[1];
				}
				else
				{
					$l_name = ''; 
				}

				$arr = array(
					'm11_first_name' => $name[0],
					'm11_last_name' => $l_name,
					'm11_user_name' => $request->input('txt_username'),
					//'m11_user_dob' => date('Y-m-d',strtotime($request->input('txt_dob'))),
					//'m11_user_location' => $request->input('txt_address'),
					//'m11_user_postalcode' => $request->input('txt_postalcode'),
					//'m11_user_contactno' => $request->input('txt_mobileno'),
					'm11_user_email' => $request->input('txt_email'),
					'm11_bsc_address' => $request->input('txt_cbsacno'),
					'm11_user_image' => $txt_yourphoto
					);
				
				$old_values=DB::select("SELECT FirstName, LastName, MemberName,MemberEmail,BSCAddress, MemberImage FROM enroll WHERE RegId=".$request->input('txt_userid')."");

				$user_profile = $this->enroll_repo->update($request->input('txt_membercode'), $request->input('txt_userid'), $arr);

				$data=$this->match_values($old_values,$arr);

					$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => $data[1],
						'tr11_ar_new_value' => $data[0],
						'tr11_ar_uid' => $request->input('txt_userid'),
						'tr11_ar_description' => 'USER PERSONAL DETAILS HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);

				$mobileno_actionrecord=$this->log_repo->create($arr);

				$arr = array(
					'm23_user_cbsacno' =>$request->input('txt_accno'),
					'm01_bank_name'=>$request->input('dd_bank'),
					'm23_user_branch'=>$request->input('txt_branchname'),
					'm23_user_ifscode' =>$request->input('txt_ifsccode')
				);

				$old_values=DB::select("SELECT CBSACno, BANKNo, Branch, IFSCode FROM user_details WHERE RegId=".$request->input('txt_userid')."");

				$this->profile_repo->updateBankByUserId($request->input('txt_userid'), $arr);

				$data=$this->match_values($old_values,$arr);
					$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => $data[1],
						'tr11_ar_new_value' => $data[0],
						'tr11_ar_uid' => $request->input('txt_userid'),
						'tr11_ar_description' => 'USER PERSONAL DETAILS HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);

				$mobileno_actionrecord=$this->log_repo->create($arr);


				$arr = array(
					'm19_uk_user_photo'=>$txt_yourphoto,
					'm19_uk_uniqueid_num'=>$request->input('txt_panno'),
					'm19_uk_aadhar_num'=>$request->input('txt_aadhar'),
					'm19_uk_address'=>$request->input('txt_address')
				);
				
				$old_values=DB::select("SELECT USER_PH, Pancarno, AadharCard, Address FROM user_details WHERE RegId=".$request->input('txt_userid')."");

				$this->profile_repo->updateKycByUserId($request->input('txt_userid'), $arr);

				$data=$this->match_values($old_values,$arr);
					$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => $data[1],
						'tr11_ar_new_value' => $data[0],
						'tr11_ar_uid' => $request->input('txt_userid'),
						'tr11_ar_description' => 'USER PERSONAL DETAILS HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);

				$mobileno_actionrecord=$this->log_repo->create($arr);


				$ERRMSG="USER PERSONAL DETAILS HAS BEEN CHANGED SUCCESSFULLY!";
				$ERRCODE='success';	
			}
		}
		$USERID=$request->input('txt_membercode');
		$userid = Helper::get_userid($request->input('txt_membercode'));
				
				if($userid!=FALSE)
				{
				$user = Helper::get_userdetail($userid);
				$get_useralldetail = Helper::get_useralldetail($userid);
				}
				else
				{
				$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
				$this->isError=TRUE;
				$ERRCODE="warning";
				}
		Session::flash('type',$ERRCODE);
		Session::flash('message',$ERRMSG);
		$banks = $this->bank_repo->getAll();
		return view('Profile.edit_userprofile',compact('user','get_useralldetail','USERID','banks'));
	}

	 /**
			* Method name	: Edit User Bank Details
			* @description 	: Used for editing user bank details
			* @param		: request user id 
			* @return		: response bank details of user
		*/
	public function edit_userbankdetails()
    {
        $request = request();
		$user = "";
		$USERID="";
		$get_useralldetail = "";
		if($request->method() == 'POST')
		{
			   if($request->input('txt_memberid')=='')
				{
					$ERRMSG = "Member id should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
				
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$userid = Helper::get_userid($request->input('txt_memberid'));
					if($userid!=FALSE)
					{
					$user = Helper::get_userdetail($userid);
					$get_useralldetail = Helper::get_useralldetail($userid);
					$ERRMSG = "Member details fetch successfully.";
					$ERRCODE="success";
					}
					else
					{
					$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
					$this->isError=TRUE;
					$ERRCODE="warning";
					}
				}
		}
		$USERID=$request->input('txt_memberid');
		$banks = $this->bank_repo->getAll();
	    return view('Profile.edit_userbankdetails',compact('user','get_useralldetail','USERID','banks'));
    }

    /**
			* Method name	: Update User Bank Details
			* @description 	: Used for editing user bank details
			* @param		: request user id 
			* @return		: response bank details of user
		*/
    public function update_userbankdetails()
		{
			$request = request();
			$USERID="";

			if($request->method() == 'POST')
			{
				if($_FILES['txt_cancelchq']['name']!= '')
				{
					$image = $request->file('txt_cancelchq');
					$name = $request->input('txt_membercode').'CANCELCHQ'.time().'.'.$image->getClientOriginalExtension();
					$destinationPath = public_path('images/CANCEL_CHEQUE');
					$FileType = array('jpeg','png','jpg');
					if(in_array($image->getClientOriginalExtension(), $FileType)) {
						$image->move($destinationPath,$name);
					}
					else{
						$request_data=json_encode($request->all());
						$file_type=$image->getClientOriginalName();
						$user_id=SESSION::get('USER_ID');
						$server_info=json_encode(request()->server());
						$user_info=json_encode(SESSION()->all()['result'][0]);
						$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
						return back()->with('error', 'File format not supported.'); 
					}
					$txt_cancelchq =  $name;
				}
				else
				{
					$txt_cancelchq = trim($request->input('txt_cancelchqhd'));
				}
				if($request->input('txt_nameatbank')=='' )
				{
					$ERRMSG = "Member Name at Bank should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('dd_bank')=='')
				{
					$ERRMSG = "Member Bank Name should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_cbsacno')=='')
				{
					$ERRMSG = "Member Bank no Account should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_bankbranch')=='')
				{
					$ERRMSG = "Member Bank Branch should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_bankifsccode')=='')
				{
					$ERRMSG = "Member Bank IFSCode should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($txt_cancelchq=='')
				{
					$ERRMSG = "Cancel cheque should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
				if(request()->method() == 'POST'&& $this->isError==FALSE)
				{
					$ACCOUNTNO=$request->input('txt_cbsacno');
					$USER=$request->input('txt_userid');
					$arr = array(
					'm23_user_nameat_bank'=>$request->input('txt_nameatbank'),
					'm23_user_cbsacno' =>$request->input('txt_cbsacno'),
					'm01_bank_name'=>$request->input('dd_bank'),
					'm23_user_branch'=>$request->input('txt_bankbranch'),
					'm23_user_ifscode' =>$request->input('txt_bankifsccode'),
					'm23_usercancelechq'=>$txt_cancelchq
					);
					$this->profile_repo->updateBankByUserId($request->input('txt_userid'), $arr);
					$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => '',
						'tr11_ar_new_value' => $ACCOUNTNO,
						'tr11_ar_uid' => $USER,
						'tr11_ar_description' => 'USERS BANK DETAILS HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
					$bank_actionrecord=$this->log_repo->create($arr);
					$ERRMSG="USER'S BANK HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
				}
			}
					$USERID=$request->input('txt_membercode');
					$userid = Helper::get_userid($request->input('txt_membercode'));
					if($userid!=FALSE)
					{
					$user = Helper::get_userdetail($userid);
					$get_useralldetail = Helper::get_useralldetail($userid);
					}
					else
					{
					$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
					$this->isError=TRUE;
					$ERRCODE="warning";
					}
			Session::flash('type',$ERRCODE);
			Session::flash('message',$ERRMSG);
			$banks = $this->bank_repo->getAll();
			return view('Profile.edit_userbankdetails',compact('user','get_useralldetail','USERID','banks'));
		}

	/**
			* Method name	: Update User Bank Details
			* @description 	: Used for editing user bank details
			* @param		: request user id 
			* @return		: response bank details of user
		*/
	public function edit_userkycdetails()
    {
        $request = request();
		$user = "";
		$USERID="";
		$get_useralldetail = "";
		if($request->method() == 'POST')
		{
			   if($request->input('txt_memberid')=='')
				{
					$ERRMSG = "Member id should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
				
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$userid = Helper::get_userid($request->input('txt_memberid'));
					if($userid!=FALSE)
					{
					$user = Helper::get_userdetail($userid);
					$get_useralldetail = Helper::get_useralldetail($userid);
					$ERRMSG = "Member details fetch successfully.";
					$ERRCODE="success";
					}
					else
					{
					$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
					$this->isError=TRUE;
					$ERRCODE="warning";
					}
				}
		}
		   $USERID=$request->input('txt_memberid');
		   return view('Profile.edit_userkycdetails',compact('get_useralldetail','USERID'));
    }

    /**
			* Method name	: Update User Bank Details
			* @description 	: Used for editing user bank details
			* @param		: request user id 
			* @return		: response bank details of user
		*/
    public function update_userkyc()
		{
			$request = request();
			$USERID="";

			if($request->method() == 'POST')
			{
				if($_FILES['txt_yourphoto']['name']!= '')
				{
					$image = $request->file('txt_yourphoto');
					$name = $request->input('txt_membercode').'_PHOTO_'.time().'.'.$image->getClientOriginalExtension();
					$destinationPath = public_path('images/USER_PHOTO');
					$FileType = array('jpeg','png','jpg');
					if(in_array($image->getClientOriginalExtension(), $FileType)) {
						$image->move($destinationPath,$name);
					}
					else{
						$request_data=json_encode($request->all());
						$file_type=$image->getClientOriginalName();
						$user_id=SESSION::get('USER_ID');
						$server_info=json_encode(request()->server());
						$user_info=json_encode(SESSION()->all()['result'][0]);
						$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
						return back()->with('error', 'File format not supported.'); 
					}
					$txt_yourphoto = $name;
				}
				else
				{
					$txt_yourphoto = trim($request->input('txt_yourphotohd'));
				}
				if($_FILES['txt_idproof']['name']!= '')
				{
					$image = $request->file('txt_idproof');
					$name = $request->input('txt_membercode').'_IDPROOF_'.time().'.'.$image->getClientOriginalExtension();
					$destinationPath = public_path('images/USER_IDPROOF');
					$FileType = array('jpeg','png','jpg');
					if(in_array($image->getClientOriginalExtension(), $FileType)) {
						$image->move($destinationPath, $name);
					}
					else{
						$request_data=json_encode($request->all());
						$file_type=$image->getClientOriginalName();
						$user_id=SESSION::get('USER_ID');
						$server_info=json_encode(request()->server());
						$user_info=json_encode(SESSION()->all()['result'][0]);
						$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
						return back()->with('error', 'File format not supported.'); 
					}
					$txt_idproof = $name;
				}
				else
				{
					$txt_idproof = trim($request->input('txt_idproofhd'));
				}
				if($_FILES['txt_addressproof']['name']!= '')
				{
					$image = $request->file('txt_addressproof');
					$name = $request->input('txt_membercode').'_ADDRESSPROOF_'.time().'.'.$image->getClientOriginalExtension();
					$destinationPath = public_path('images/USER_ADDRESSPROOF');
					$FileType = array('jpeg','png','jpg');
					if(in_array($image->getClientOriginalExtension(), $FileType)) {
						$image->move($destinationPath, $name);
					}
					else{
						$request_data=json_encode($request->all());
						$file_type=$image->getClientOriginalName();
						$user_id=SESSION::get('USER_ID');
						$server_info=json_encode(request()->server());
						$user_info=json_encode(SESSION()->all()['result'][0]);
						$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
						return back()->with('error', 'File format not supported.'); 
					}
					$txt_addressproof = $name;
				}
				else
				{
					$txt_addressproof = trim($request->input('txt_addressproofhd'));
				}

				if($_FILES['txt_aadharfront']['name']!= '')
				{
					$image = $request->file('txt_aadharfront');
					$name = $request->input('txt_membercode').'_AADHARFRONT_'.time().'.'.$image->getClientOriginalExtension();
					$destinationPath = public_path('images/USER_IDPROOF');
					$FileType = array('jpeg','png','jpg');
					if(in_array($image->getClientOriginalExtension(), $FileType)) {	
						$image->move($destinationPath, $name);
					}
					else{
						$request_data=json_encode($request->all());
						$file_type=$image->getClientOriginalName();
						$user_id=SESSION::get('USER_ID');
						$server_info=json_encode(request()->server());
						$user_info=json_encode(SESSION()->all()['result'][0]);
						$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
						return back()->with('error', 'File format not supported.'); 
					}
					$txt_aadharfront = $name;
				}
				else
				{
					$txt_aadharfront = trim($request->input('txt_aadharfronthd'));
				}

				if($_FILES['txt_aadharback']['name']!= '')
				{
					$image = $request->file('txt_aadharback');
					$name = $request->input('txt_membercode').'_ADDHARBACK_'.time().'.'.$image->getClientOriginalExtension();
					$destinationPath = public_path('images/USER_IDPROOF');
					$FileType = array('jpeg','png','jpg');
					if(in_array($image->getClientOriginalExtension(), $FileType)) {
						$image->move($destinationPath, $name);
					}
					else{
						$request_data=json_encode($request->all());
						$file_type=$image->getClientOriginalName();
						$user_id=SESSION::get('USER_ID');
						$server_info=json_encode(request()->server());
						$user_info=json_encode(SESSION()->all()['result'][0]);
						$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
						return back()->with('error', 'File format not supported.'); 
					}
					$txt_aadharback = $name;
				}
				else
				{
					$txt_aadharback = trim($request->input('txt_aadharbackhd'));
				}
				
				if($request->input('txt_pancard')=='')
				{
					$ERRMSG = "Member pancard should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_address')=='')
				{
					$ERRMSG = "Member address should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($txt_yourphoto=='')
				{
					$ERRMSG = "Member image should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($txt_idproof=='')
				{
					$ERRMSG = "Id proof should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($txt_addressproof=='')
				{
					$ERRMSG = "Address proof should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($txt_aadharfront=='')
				{
					$ERRMSG = "Aadhar front image should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($txt_aadharback=='')
				{
					$ERRMSG = "Aadhar front image should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('dd_idprooftype')=='' || $request->input('dd_idprooftype')=='-1')
				{
					$ERRMSG = "Id proof type should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_aadharcard')=='')
				{
					$ERRMSG = "Aadhar card number should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('ddaddproof')=='' || $request->input('ddaddproof')=='-1')
				{
					$ERRMSG = "Address proof type should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('dd_quali')=='' || $request->input('dd_quali')=='-1')
				{
					$ERRMSG = "Qualification type should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
				if(request()->method() == 'POST'&& $this->isError==FALSE)
				{
					$pancard=$request->input('txt_pancard');
					$USER=$request->input('txt_userid');
					$arr = array(
					'm19_uk_user_photo'=>$txt_yourphoto,
					'm19_uk_idproof_type'=>$request->input('dd_idprooftype'),
					'm19_uk_uniqueid_num'=>$request->input('txt_pancard'),
					'm19_uk_aadhar_num'=>$request->input('txt_aadharcard'),
					'm19_uk_aadhar_front'=>$txt_aadharfront,
					'm19_uk_aadhar_back'=>$txt_aadharback,
					'm19_uk_idproofdoc'=>$txt_idproof,
					'm19_uk_address'=>$request->input('txt_address'),
					'm19_uk_addressproof_type'=>$request->input('ddaddproof'),
					'm19_uk_addressproof'=>$txt_addressproof,
					'm19_uk_qualification'=>$request->input('dd_quali')
					);
					$this->profile_repo->updateKycByUserId($USER, $arr);
					//DB::table('m19_user_kyc')->where('m11_user_id', $USER)->update($arr);
					$user_profile=DB::select("UPDATE m11_user SET m11_user_location='".$request->input('txt_address')."', m11_user_image='".$txt_yourphoto."' WHERE m11_user_code ='".$request->input('txt_membercode')."' and m11_user_id=". $request->input('txt_userid')." AND m11_user_status='ACTIVE'");
					$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => '',
						'tr11_ar_new_value' => $pancard,
						'tr11_ar_uid' => $USER,
						'tr11_ar_description' => 'USERS KYC HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
					$kyc_actionrecord=$this->log_repo->create($arr);	
					$ERRMSG="USER'S KYC HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
				}
				
			}
          		    $USERID=$request->input('txt_membercode');
					$userid = Helper::get_userid($request->input('txt_membercode'));
					if($userid!=FALSE)
					{
					$user = Helper::get_userdetail($userid);
					$get_useralldetail = Helper::get_useralldetail($userid);
					}
					else
					{
					$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
					$this->isError=TRUE;
					$ERRCODE="warning";
					}
			Session::flash('type',$ERRCODE);
			Session::flash('message',$ERRMSG);
		   return view('Profile.edit_userkycdetails',compact('get_useralldetail','USERID'));
		}


		/**
		* Method name	: Update User Shop Details
		* @description 	: Used for editing user shop details
		* @param		: request user id 
		* @return		: response shop details of user
	*/
	public function edit_shopdetails()
    {
        $request = request();
		$user = "";
		$USERID="";
		$user_shop_details = "";
		$shop_info ="";

		if($request->method() == 'POST')
		{
			   if($request->input('txt_memberid')=='')
				{
					$ERRMSG = "Member id should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
				
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$userid = Helper::get_userid($request->input('txt_memberid'));
					if($userid!=FALSE)
					{

					$user = Helper::get_userdetail($userid);
					$user_shop_details = Helper::get_usershopdetail($userid);
					$shop_info=$this->Shop_repo->getByUserId($userid);

					$ERRMSG = "Member details fetch successfully.";
					$ERRCODE="success";
					}
					else
					{
					$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
					$this->isError=TRUE;
					$ERRCODE="warning";
					}
				}
		}
		$data['country'] = $this->location_repo->getAllCountries();
		$state = $this->location_repo->getAllStates();
		$city = $this->location_repo->getAllCities();
	   	$USERID=$request->input('txt_memberid');
	   return view('Profile.edit_shopdetails',compact('user','user_shop_details','data','shop_info','state','city','USERID'));
    }

    /**
		* Method name	: Update User Shop Details
		* @description 	: Used for editing user shop details
		* @param		: request user id 
		* @return		: response shop details of user
	*/
    public function update_shop()
		{
			$request = request();
			$USERID="";

			$USERID=$request->input('txt_membercode');
			$userid = Helper::get_userid($request->input('txt_membercode'));
			$get_useralldetail = Helper::get_useralldetail($userid);
		
				if($request->method() == 'POST')
				{
					if($_FILES['txt_shop_image']['name']!= '')
						{
							$image = $request->file('txt_shop_image');
							$name = $request->input('txt_membercode').'_SHOP_'.time().'.'.$image->getClientOriginalExtension();
							$destinationPath = public_path('images/SHOP_IMAGE');
							$FileType = array('jpeg','png','jpg');
							if(in_array($image->getClientOriginalExtension(), $FileType)) {
								$image->move($destinationPath,$name);
							}
							else{
								$request_data=json_encode($request->all());
								$file_type=$image->getClientOriginalName();
								$user_id=Session::get('USER_ID');
								$server_info=json_encode(request()->server());
								$user_info=json_encode($get_useralldetail);
								$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
								return back()->with('error', 'File format not supported.'); 
							}
							$txt_shopphoto = $name;
						}
						else
						{
							$txt_shopphoto = trim($request->input('txt_shophd'));
						}
						if($_FILES['txt_gst_image']['name']!= '')
						{
							$image = $request->file('txt_gst_image');
							$name = $request->input('txt_membercode').'_GST_'.time().'.'.$image->getClientOriginalExtension();
							$destinationPath = public_path('images/GST_CERTIFICATE');
							$FileType = array('jpeg','png','jpg');
							if(in_array($image->getClientOriginalExtension(), $FileType)) {
								$image->move($destinationPath, $name);
							}
							else{
								$request_data=json_encode($request->all());
								$file_type=$image->getClientOriginalName();
								$user_id=Session::get('USER_ID');
								$server_info=json_encode(request()->server());
								$user_info=json_encode($get_useralldetail);
								$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
								return back()->with('error', 'File format not supported.'); 
							}
							$txt_gstproof = $name;
						}
						else
						{
							$txt_gstproof = trim($request->input('txt_gsthd'));
						}

					if($request->input('txt_shop_name')=='')
					{
						$ERRMSG = "Shop name should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($txt_shopphoto=='')
					{
						$ERRMSG = "Shop front image should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					// else if($request->input('txt_shop_gst')=='')
					// {
					// 	$ERRMSG = "Shop gst should be valid or not blank.";
					// 	$this->isError= TRUE;
					// 	$ERRCODE="warning";
					// }
					// else if($txt_gstproof=='')
					// {
					// 	$ERRMSG = "Shop gst proof be valid or not blank.";
					// 	$this->isError= TRUE;
					// 	$ERRCODE="warning";
					// }
					else if($request->input('dd_shop_type')=='' || $request->input('dd_shop_type')=='-1')
					{
						$ERRMSG = "Shop type should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('dd_loc_type')=='' || $request->input('dd_loc_type')=='-1')
					{
						$ERRMSG = "Location type should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('dd_popl')=='' || $request->input('dd_popl')=='-1')
					{
						$ERRMSG = "Population type should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('dd_country')=='' || $request->input('dd_country')=='-1')
					{
						$ERRMSG = "Country should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('dd_state')=='' || $request->input('dd_state')=='-1')
					{
						$ERRMSG = "State should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('dd_city')=='' || $request->input('dd_city')=='-1')
					{
						$ERRMSG = "City should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_block')=='')
					{
						$ERRMSG = "Block should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_mohhalla')=='')
					{
						$ERRMSG = "Mohhalla should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_landmark')=='')
					{
						$ERRMSG = "Landmark should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_pincode')=='')
					{
						$ERRMSG = "Pincode should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if($request->input('txt_address')=='')
					{
						$ERRMSG = "Address should be valid or not blank.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else
					{
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
					if(request()->method() == 'POST'&& $this->isError==FALSE)
					{
						$USER=$request->input('txt_userid');

						$arr = array(
							'm22_shop_company_name'=>$request->input('txt_shop_name'),
							'm22_shop_image'=>$txt_shopphoto,
							'm22_shop_type'=>$request->input('dd_shop_type'),
							'm22_shop_location_type'=>$request->input('dd_loc_type'),
							'm22_shop_near_popullation'=>$request->input('dd_popl'),
							'm22_shop_country'=>$request->input('dd_country'),
							'm22_shop_state'=>$request->input('dd_state'),
							'm22_shop_city'=>$request->input('dd_city'),
							'm22_shop_address_block'=>$request->input('txt_block'),
							'm22_shop_address_mohhalla'=>$request->input('txt_mohhalla'),
							'm22_shop_address_landmark'=>$request->input('txt_landmark'),
							'm22_shop_pincode'=>$request->input('txt_pincode'),
							'm22_shop_shipping_address'=>$request->input('txt_address')
						);

						if($request->input('txt_shop_gst')!='' && ($txt_gstproof!='')){
							$arr['m22_shop_gstin'] = $request->input('txt_shop_gst');
							$arr['m22_shop_gstin_copy'] = $txt_gstproof;
						}	

						$this->Shop_repo->update($request->input('txt_shop_id'), $arr);

						$arr = array(
							'tr11_ar_tblnm' => 'm22_shop_info',
							'tr11_ar_old_value' => '',
							'tr11_ar_new_value' => $request->input('txt_shop_name'),
							'tr11_ar_uid' => $USER,
							'tr11_ar_description' => 'USER S SHOP DETAILS HAS BEEN CHANGED SUCCESSFULLY!',
							'tr11_updated_by' => 1,
							'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
						$kyc_actionrecord=$this->log_repo->create($arr);	
						$ERRMSG="USER S SHOP DETAILS HAS BEEN CHANGED SUCCESSFULLY!";
						$ERRCODE='success';	
					}
					
				}
		
					if($userid!=FALSE)
					{
					$user = Helper::get_userdetail($userid);
					$get_useralldetail = Helper::get_useralldetail($userid);
					}
					else
					{
					$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
					$this->isError=TRUE;
					$ERRCODE="warning";
					}
			Session::flash('type',$ERRCODE);
			Session::flash('message',$ERRMSG);
		   return redirect('edit_shopdetails');
		}

		/**
			* Method name	: View User
			* @description 	: Used for viewing user data
			* @param		: request user id 
			* @return		: response user data
		*/
    public function view_user()
	{
		$request = request();
		$user = "";
		$USERID="";
		$get_useralldetail = "";
		if($request->method() == 'POST')
		{
			if($request->input('txt_memberid')=='')
			{
				$ERRMSG = "Member id should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			
			if(request()->method() == 'POST' && $this->isError==FALSE)
			{
				$userid = Helper::get_userid($request->input('txt_memberid'));
				
				if($userid!=FALSE)
				{
					$user = Helper::get_userdetail($userid);
					$get_useralldetail = Helper::get_useralldetail($userid);
					$ERRMSG = "Member details fetch successfully.";
					$ERRCODE="success";
				}
				else
				{
					$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
					$this->isError=TRUE;
					$ERRCODE="warning";
				}
				}
		}
		$USERID=$request->input('txt_memberid');
		return view('Profile.view_profile',compact('user','get_useralldetail','USERID'));
		
	}


	 /**
			* Method name	: All User
			* @description 	: Used for getting all user data
			* @param		: request data 
			* @return		: response user data
		*/
    public function all_user()
	{
		$start = '2021-01-01';
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';$role='-1';$pos='-1';
		$cond="";$topupst="ALL";$member_id="";
		$group="-1";
		$userP = "0";
		
		$request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));

			if($request->input('txt_memberid')!='')
			$txtuserid = Helper::get_userid($request->input('txt_memberid'));

			$pos=$request->input('dd_pos');
		    $role=$request->input('dd_role');
			$group=$request->input('dd_group');
			$userP=$request->input('tram');
			$cond ='';
			$cond1='';
        }
			if($txtuserid != '' && $txtuserid != 'false')
			{
			    $member_id=$request->input('txt_memberid');
				$cond = $cond."m11_user.m11_user_id = ".$txtuserid."  AND ";
			}
			if($pos != '' && $pos != '-1')
			{
				$cond = $cond."m11_user.m11_user_position = '".$pos."'  AND ";
			}
			if($role != '' && $role != '-1')
			{
				$cond = $cond."m11_user.m11_user_role = ".$role."  AND ";
			}
			if($group != '' && $group != '-1')
			{
				$cond = $cond."m11_user.m16_gr_id = ".$group."  AND ";
			}
			if($request->input('rb_topupst')!= '' && $request->input('rb_topupst')!= '-1')
			{
				$topupst=$request->input('rb_topupst');
				if($topupst=="0")
				$topupst="ALL";
				if($topupst=="1")
				$topupst="NO";
				if($topupst=="2")
				$topupst="TOPUP";
			}
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$cond = $cond."DATE_FORMAT(m11_user.m11_user_onadd,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(m11_user.m11_user_onadd,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
		$cond = $cond."  m11_user.m11_user_referral_code =  ".$userP;
		
		$user=array(
		'proc'=>7,
		'userid'=> $cond,
		);
		$group = $this->slab_repo->getAll();
		$user_report = $this->enroll_repo->getUserByProc($user);
		//dd($user,	$user_report);
		return view('Profile.all_user', compact('user_report','topupst','start','end','pos','role','member_id','group','userP'));
	}




	 /**
			* Method name	: All User
			* @description 	: Used for getting all user data
			* @param		: request data 
			* @return		: response user data
		*/
    public function AllWhiteLabel()
	{
		$start = '2021-01-01';
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$group_id=-1;
		$role='2';
		$pos='-1';
		$cond="";$topupst="ALL";$member_id="";
		$request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));

			if($request->input('txt_memberid')!='')
			$txtuserid = Helper::get_userid($request->input('txt_memberid'));
			$group_id=$request->input('dd_group');
			$pos=$request->input('dd_pos');
		    $role='2';
			$cond ='';
			$cond1='';
        }
			if($txtuserid != '' && $txtuserid != 'false')
			{
			    $member_id=$request->input('txt_memberid');
				$cond = $cond."m11_user.m11_user_id = ".$txtuserid."  AND ";
			}
			if($pos != '' && $pos != '-1')
			{
				$cond = $cond."m11_user.m11_user_position = '".$pos."'  AND ";
			}
			if($role != '' && $role != '-1')
			{
				$cond = $cond."m11_user.m11_user_role = ".$role."  AND ";
			}
			if($group_id != '' && $group_id != '-1')
			{
				$cond = $cond."m11_user.m16_gr_id = ".$group_id."  AND ";
			}
			if($request->input('rb_topupst')!= '' && $request->input('rb_topupst')!= '-1')
			{
				$topupst=$request->input('rb_topupst');
				if($topupst=="0")
				$topupst="ALL";
				if($topupst=="1")
				$topupst="NO";
				if($topupst=="2")
				$topupst="TOPUP";
			}
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$cond = $cond."DATE_FORMAT(m11_user.m11_user_onadd,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(m11_user.m11_user_onadd,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
		$cond = $cond." 1 ";
		
		$user=array(
		'proc'=>7,
		'userid'=> $cond,
		);
		$user_report = $this->enroll_repo->getUserByProc($user);
		$slab = $this->slab_repo->getAll();
		return view('Profile.AllWhiteLabel', compact('user_report','topupst','start','end','pos','role','slab','member_id'));
	}





	 /**
			* Method name	: All User
			* @description 	: Used for getting all user data
			* @param		: request data 
			* @return		: response user data
		*/
    public function AllApiUser()
	{
		$start = '2021-01-01';
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$group_id=-1;
		$role='3';
		$pos='-1';
		$cond="";$topupst="ALL";$member_id="";
		$request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));

			if($request->input('txt_memberid')!='')
			$txtuserid = Helper::get_userid($request->input('txt_memberid'));
			$group_id=$request->input('dd_group');
			$pos=$request->input('dd_pos');
		    $role='3';
			$cond ='';
			$cond1='';
        }
			if($txtuserid != '' && $txtuserid != 'false')
			{
			    $member_id=$request->input('txt_memberid');
				$cond = $cond."m11_user.m11_user_id = ".$txtuserid."  AND ";
			}
			if($pos != '' && $pos != '-1')
			{
				$cond = $cond."m11_user.m11_user_position = '".$pos."'  AND ";
			}
			if($role != '' && $role != '-1')
			{
				$cond = $cond."m11_user.m11_user_role = ".$role."  AND ";
			}
			if($group_id != '' && $group_id != '-1')
			{
				$cond = $cond."m11_user.m16_gr_id = ".$group_id."  AND ";
			}
			if($request->input('rb_topupst')!= '' && $request->input('rb_topupst')!= '-1')
			{
				$topupst=$request->input('rb_topupst');
				if($topupst=="0")
				$topupst="ALL";
				if($topupst=="1")
				$topupst="NO";
				if($topupst=="2")
				$topupst="TOPUP";
			}
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$cond = $cond."DATE_FORMAT(m11_user.m11_user_onadd,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(m11_user.m11_user_onadd,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
		$cond = $cond." 1 ";
		
		$user=array(
		'proc'=>7,
		'userid'=> $cond,
		);
		$user_report = $this->enroll_repo->getUserByProc($user);
		$slab = $this->slab_repo->getAll();
		return view('Profile.AllApiUser', compact('user_report','topupst','start','end','pos','role','slab','member_id'));
	}




	/**
			* Method name	: Kyc
			* @description 	: Used for getting all user kyc details
			* @param		: request data 
			* @return		: response user kyc data
		*/
	public function kyc()
    {
        $page = 'PROFILE PANEL';
        $form_name = 'KYC REPORT';
		$start = '2021-01-01';
		$end = date('Y-m-d',strtotime(NOW()));

		$txtuserid = '';
		$member_id = '';
		$cond="";$kycst="ALL";
        $request = request();
		$role="-1";
		$pos="-1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
				$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
				$end = date('Y-m-d',strtotime($request->input('txt_todate')));
				$member_id = $request->input('txt_memberid');
				$txtuserid = Helper::get_userid($request->input('txt_memberid'));
				$pos=$request->input('dd_pos');
				$role=$request->input('dd_role');
				$cond ='';
				$cond1='';
				if($txtuserid != '' && $txtuserid != 'false')
				{
					$cond = $cond."m11_user.m11_user_id = ".$txtuserid."  AND ";
				}
				if($pos != '' && $pos != '-1')
				{
					$cond = $cond."m11_user.m11_user_position = '".$pos."'  AND ";
				}
				if($role != '' && $role != '-1')
				{
					$cond = $cond."m11_user.m11_user_role = ".$role."  AND ";
				}
				if($request->input('rb_kycst')!= '' && $request->input('rb_kycst')!= '-1')
				{
					$kycst=$request->input('rb_kycst');
                    if($kycst<>"0")
                    $cond = $cond."m19_user_kyc.m19_uk_status = ".$kycst."  AND ";
					if($kycst=="0")
					$kycst="ALL";
					if($kycst=="2")
					$kycst="PENDING";
					if($kycst=="1")
					$kycst="APPROVED";
                   
				}
				if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
				{
					$cond = $cond."
                    DATE_FORMAT(m19_user_kyc.m19_uk_onupdate ,'%Y-%m-%d') >= DATE_FORMAT('".$start."','%Y-%m-%d') AND 
                    DATE_FORMAT(m19_user_kyc.m19_uk_onupdate ,'%Y-%m-%d') <= DATE_FORMAT('".$end."','%Y-%m-%d') AND ";
				}
				$cond = $cond." m19_user_kyc.m19_uk_idproofdoc<>'' AND m19_user_kyc.m19_uk_uniqueid_num <>'' AND m19_user_kyc.m19_uk_addressproof<> '' ORDER BY  m11_user.m11_user_id DESC";
        }
		else{
			$cond = $cond." m19_user_kyc.m19_uk_status = '".$kycst."' AND m19_user_kyc.m19_uk_idproofdoc<>'' AND m19_user_kyc.m19_uk_uniqueid_num <>'' AND m19_user_kyc.m19_uk_addressproof<> '' ORDER BY  m11_user.m11_user_id DESC";
		}

	    $user_kyc=array(
				'proc'=>4,
                'userid'=>$cond,
            );

		$userkyc_report = $this->enroll_repo->getUserByProc($user_kyc);
//echo $cond;
    	return view('Profile.kyc', compact('userkyc_report','kycst', 'member_id','role','start','end','pos'));
    }

    /**
			* Method name	: Shop details
			* @description 	: Used for getting user shop details
			* @param		: request data 
			* @return		: response user shop data
		*/
    public function shop_details()
    {
        $page = 'PROFILE PANEL';
        $form_name = 'SHOP DETAILS';
		$start = '2021-01-01';
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$cond="";
		$role="-1";
		$memberid = '';
        $request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
			    $start = date('Y-m-d',strtotime($request->input('txt_from')));
				$end = date('Y-m-d',strtotime($request->input('txt_to')));
				$memberid = $request->input('txt_memberid');
				if($request->input('txt_memberid')!='')
				$txtuserid = Helper::get_userid($request->input('txt_memberid'));
				$role=$request->input('dd_role');
				$group=$request->input('dd_group');
				$noofrecords=$request->input('txt_noofrecords');
				$cond ='';
				$cond1='';
				if($txtuserid != '' && $txtuserid != 'false')
				{
					$cond = $cond."m11_user.m11_user_id = $txtuserid  AND ";
				}
				if($role != '' && $role != '-1')
				{
					$cond = $cond."m11_user.m11_user_role = $role  AND ";
				}
				if($group != '' && $group != '-1')
				{
					$cond = $cond."m11_user.m16_gr_id  = $group  AND ";
				}
				if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
				{
					$cond = $cond."DATE_FORMAT(m11_user.m11_user_onadd,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
				}
				
        }
		$cond = $cond." 1 ORDER BY m11_user.m11_user_id DESC";

        $usershop=array(
                'proc'=>6,
                'userid'=> $cond
            );
        $usershop_report = $this->enroll_repo->getUserByProc($usershop);
		$GROUP = Helper::get_group(-1,'ACTIVE');	
    	return view('Profile.shop_details', compact('page','GROUP','form_name','usershop_report','role','start','end','memberid'));
    }

    /**
			* Method name	: Buy Subscription
			* @description 	: Used for buy subscription and topup
			* @param		: request data 
			* @return		: response subscription done message
		*/
    public function buy_subscription()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'TOPUP OR BUY SUBSCRIPTIONS';
			$request = request();
			$descrip="";
			$ERRMSG = "";
            $ERRCODE="";
			$start = '2021-01-01';
			$end = date('Y-m-d',strtotime(NOW()));
			$txt_account = '';
			$txt_memberid = '';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="";
			$cond1="1";
            if($_SERVER['REQUEST_METHOD']=="POST")
            {
				if($request->input('txt_referralcode')=="")
                {
                    $ERRMSG = "Member id should be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
				$contactno=explode(' ',$request->input('txt_referralcode'));
				$user = Helper::get_userid($contactno[0]);
				$user_detail = Helper::get_userdetail($user);
				$wallet_type=$request->input('dd_wallet');
				$user_availbal = 0.000;
				if(empty($user))
				{
					$ERRMSG = "Member should be valid";
					$isError = TRUE;
					$ERRCODE="warning";
				}
		   
				else if($request->input('dd_package')=="" || $request->input('dd_package')==-1 )
                {
                    $ERRMSG = "Package should be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
				else if(floatval($request->input('txt_packageamt'))=="" || floatval($request->input('txt_packageamt'))==0.00 )
                {
                    $ERRMSG = "Package amount be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
				else if($request->input('dd_package')==1 && floatval($request->input('txt_packageamt'))<10.00)
                {
                    $ERRMSG = "Package amount should be valid or greater than $10.00";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
				else if($request->input('txt_remark')=="")
                {
                    $ERRMSG = "Remark should be valid and not blank";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
				/*else if($request->input('dd_mode')=="" || $request->input('dd_mode')==-1 )
                {
                    $ERRMSG = "Payment Mode should be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }*/
				else
				{
					$ERRMSG = "";
                    $this->isError= FALSE;
                    $ERRCODE="success";
				}
		    }
		   
                if(request()->method() == 'POST' && $this->isError==FALSE)
                {
					$topup=array(
					  	'proc'=>1,
						'txt_userid'=>$request->input('txt_referralcode'),
						'dd_package'=>$request->input('dd_package'),
						'package_amt'=>$request->input('txt_packageamt'),
						'dd_user_forwallet'=>1,
						'dd_wallet'=>1,
						'txt_remark'=>$request->input('txt_remark'),
						'dd_mode'=>1
					);
                 
				  $topup_report = DB::select('CALL topup(:proc,:txt_userid,:dd_package,:package_amt,:dd_user_forwallet,:dd_wallet,:txt_remark,:dd_mode,@status_code,@status_msg)',$topup);
				  $DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
                         $DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
				  $ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
				  $ERRMSG=$DB_ERRMSG[0]->ERR_MSG;

				  $pack_amt = $request->input('txt_packageamt');

				  if( $DB_ERRCODE[0]->ERR_CODE=="success")
				  {

					$no = rand(100000,999999);
					$bill_no = 'INID'.$no;

					$arr = array(
						'm53_bill_no' => $bill_no,
						'm11_user_id' => $user,
						'm53_description' => 'Topup Amount Accepted',
						'm53_pack_id' => $request->input('dd_package'),
						'm53_pay_mode' => 1,
						'm53_sgst' => 0,
						'm53_cgst' => 0,
						'm53_igst' => 0,
						'm53_amt_before_tax' => 0,
						'm53_tax_amt' => 0,
						'm53_total_amt' => $pack_amt,
						'm53_bill_type' => 1,
						'm53_bill_status' => 1
					);
					DB::table('m53_bill_invoice')->insert($arr);
						
					//$this->send_sms($user_detail[0]->MemberContactNo,$DB_ERRMSG[0]->ERR_MSG);

				  }
				  if($request->input('txt_packageamt')=='1111.0000')
						{
							$no = rand(100000,999999);
								$coupon_no = 'RCLDC'.$no;

								$arr = array(
								'tr19_user_tpid'=>$topup_id[0]->TPID,
								'm55_coupon_number' => $coupon_no,
								'm55_amount' => $pack_amt[0]->PACKAGE_FEE,
								'm11_user_id' => $user,
								'm55_status' => 2
							);
							//DB::table('m55_coupon')->insert($arr);
						}
			
			}
			Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
			 if($_SERVER['REQUEST_METHOD']=="GET")
            {
				$ERRCODE='info';
				$ERRMSG='TOPUP OR BUY SUBSCRIPTIONS' ;
			}
			
		$package=DB::select("SELECT * FROM package WHERE PACKAGE_STATUS='ACTIVE'");
       	return view('Profile.by_subscription',compact('form_name','package'));
    }

    /**
			* Method name	: Topup Report
			* @description 	: Used for topup
			* @param		: request data 
			* @return		: response user topup report 
		*/
    public function topup_report()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'USER TOP REPORT VIEW';
			$start = '2021-01-01';
			$end = date('Y-m-d',strtotime(NOW()));
			$txtuserid = '';
			$cond="";$topupst="ALL";
			$request = request();
			$cond ='';
		    $cond1='';
			if($_SERVER['REQUEST_METHOD']=="GET")
			{
				$ERRCODE='info';
				$ERRMSG='USER TOP REPORT TEAM ' ;
				$top=array(
					'proc'=>'1',
					'userid'=>'',
					'fromdate'=>date('Y-m-d',strtotime('2020-01-01')),
					'todate'=>date('Y-m-d',strtotime('2026-01-05')),
					'noofrecords'=>1000,
					'topstatus'=>-1,
					'descrip'=>" 1 "
					);

				$user_rec = $this->topup_repo->callTopupReport($top);
				//dd($user_rec);
			}
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
				$end = date('Y-m-d',strtotime($request->input('txt_todate')));
				if($request->input('txt_userid')!='')
				$txtuserid = Helper::get_userid($request->input('txt_userid'));
				$pos=$request->input('dd_pos');
			
			    if($txtuserid != '' && $txtuserid != 'false')
				{
					$txtuserid = Helper::get_userid($request->input('txt_userid'));
					$cond = $cond."m11_user.m11_user_id = $txtuserid  AND ";
				}
				if($pos != '' && $pos != '-1')
				{
					$cond = $cond."m11_user.m11_user_position = '".$pos."'  AND ";
				}
				$cond = $cond." 1  ";
		
				//echo $cond;

				//dd();
                  $top=array(
					'proc'=>'1',
					'userid'=>$txtuserid,
					'fromdate'=>date('Y-m-d',strtotime($start)),
					'todate'=>date('Y-m-d',strtotime($end )),
					'noofrecords'=>100,
					'topstatus'=>-1,
					'descrip'=>$cond
					);
					$user_rec = $this->topup_repo->callTopupReport($top);
						$ERRCODE='success';
						$ERRMSG='USER TOPUP REPORT' ;;
			
				Session::flash('type',$ERRCODE );
				Session::flash('message',$ERRMSG );
			}
			
			return view('Profile.topup_report',compact('form_name','user_rec') );
		}
		 /**
			* Method name	: Next Topup Report
			* @description 	: Used for topup
			* @param		: request data 
			* @return		: response user topup report 
		*/
    public function next_topup_report()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'USER NEXT TOP REPORT VIEW';
			$start = '2021-01-01';
			$end = date('Y-m-d',strtotime(NOW()));
			$txtuserid = '';
			$cond="";$topupst="ALL";
			$request = request();
			$cond ='';
		    $cond1='';
			if($_SERVER['REQUEST_METHOD']=="GET")
			{
				$ERRCODE='info';
				$ERRMSG='USER TOP REPORT TEAM ' ;
				$top=array(
					'proc'=>'3',
					'userid'=>'',
					'fromdate'=>date('Y-m-d',strtotime('2020-01-01')),
					'todate'=>date('Y-m-d',strtotime('2026-01-05')),
					'noofrecords'=>1000,
					'topstatus'=>-1,
					'descrip'=>1
					);

				$user_rec = $this->topup_repo->callTopupReport($top);
				//dd($user_rec);
			}
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
				$end = date('Y-m-d',strtotime($request->input('txt_todate')));
				if($request->input('txt_userid')!='')
				$txtuserid = Helper::get_userid($request->input('txt_userid'));
				$pos=$request->input('dd_pos');
			
			    if($txtuserid != '' && $txtuserid != 'false')
				{
					$txtuserid = Helper::get_userid($request->input('txt_userid'));
					$cond = $cond."m11_user.m11_user_id = $txtuserid  AND ";
				}
				if($pos != '' && $pos != '-1')
				{
					$cond = $cond."m11_user.m11_user_position = '".$pos."'  AND ";
				}
				$cond = $cond." 1 ";
		
				//echo $cond;
                  $top=array(
					'proc'=>'3',
					'userid'=>$txtuserid,
					'fromdate'=>date('Y-m-d',strtotime($start)),
					'todate'=>date('Y-m-d',strtotime($end )),
					'noofrecords'=>100,
					'topstatus'=>-1,
					'descrip'=>$cond
					);
					$user_rec = $this->topup_repo->callTopupReport($top);
						$ERRCODE='success';
						$ERRMSG='USER TOPUP REPORT' ;;
			
				Session::flash('type',$ERRCODE );
				Session::flash('message',$ERRMSG );
			}
			
			return view('Profile.next_topup_report',compact('form_name','user_rec') );
		}

		/**
			* Method name	: Topup Report
			* @description 	: Used for topup
			* @param		: request data 
			* @return		: response user topup report 
		*/
    public function datewise_business_detail()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'USER TOP REPORT VIEW';
			$start = '2021-01-01';
			$end = date('Y-m-d',strtotime(NOW()));
			$txtuserid = '';
			$cond="";$topupst="ALL";
			$request = request();
			$cond ='';
		    $cond1='';
			if($_SERVER['REQUEST_METHOD']=="GET")
			{
				$ERRCODE='info';
				$ERRMSG='USER TOP REPORT TEAM ' ;
				$top=array(
					'proc'=>'2',
					'userid'=>'',
					'fromdate'=>date('Y-m-d',strtotime('2020-01-01')),
					'todate'=>date('Y-m-d',strtotime('2026-01-05')),
					'noofrecords'=>1000,
					'topstatus'=>-1,
					'descrip'=>1
					);

				$user_rec = $this->topup_repo->callTopupReport($top);
				//dd($user_rec);
			}
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
				$end = date('Y-m-d',strtotime($request->input('txt_todate')));
				if($request->input('txt_userid')!='')
				$txtuserid = Helper::get_userid($request->input('txt_userid'));
				$pos=$request->input('dd_pos');
			
			    if($txtuserid != '' && $txtuserid != 'false')
				{
					$txtuserid = Helper::get_userid($request->input('txt_userid'));
					$cond = $cond."m11_user.m11_user_id = $txtuserid  AND ";
				}
				if($pos != '' && $pos != '-1')
				{
					$cond = $cond."m11_user.m11_user_position = '".$pos."'  AND ";
				}
				$cond = $cond." 1 ";
		
				//echo $cond;
                  $top=array(
					'proc'=>'2',
					'userid'=>$txtuserid,
					'fromdate'=>date('Y-m-d',strtotime($start)),
					'todate'=>date('Y-m-d',strtotime($end )),
					'noofrecords'=>100,
					'topstatus'=>-1,
					'descrip'=>$cond
					);
					$user_rec = $this->topup_repo->callTopupReport($top);
						$ERRCODE='success';
						$ERRMSG='USER TOPUP REPORT' ;;
			
				Session::flash('type',$ERRCODE );
				Session::flash('message',$ERRMSG );
			}
			
			return view('Profile.business_report',compact('form_name','user_rec') );
		}


	/**
		* Method name	: Datewise Business Report
		* @description 	: Used for user datewise business report 
		* @param		: request data 
		* @return		: response user datewise business report 
	*/
    public function datewise_business_detail1()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'USER TOP REPORT VIEW';
		$start = '2021-01-01';
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$cond="";$topupst="ALL";
		$request = request();
		$cond ='';
	    $cond1='';
		if($_SERVER['REQUEST_METHOD']=="GET")
		{

			$cond = $cond." 1 ";
			$ERRCODE='info';
			$ERRMSG='USER TOP REPORT TEAM ' ;
			
		}
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));
			if($request->input('txt_userid')!='')
			$txtuserid = Helper::get_userid($request->input('txt_userid'));
		
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
            {
                $cond = $cond."DATE_FORMAT(TOPUP_DATE,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
            }

		    if($txtuserid != '' && $txtuserid != 'false')
			{
				$txtuserid = Helper::get_userid($request->input('txt_userid'));
				$cond = $cond."REG_ID = $txtuserid  AND ";
			}

			$cond = $cond." 1 ";
		
		}
		$user_rec = DB::select('SELECT * FROM datewise_topupdata WHERE '.$cond);
		
		return view('Profile.datewise_business',compact('form_name','user_rec') );
	}

	/**
			* Method name	: Tree
			* @description 	: Used for getting tree view
			* @param		: request data 
			* @return		: response user tree view
		*/
	public function tree($id = '')
	{
		if($_SERVER['REQUEST_METHOD']=="GET")
        {
			$pid = $id;
            $s=1;
            $call_procedure =  $this->team_repo->getUserAtLevel($id);
            $tr = $this->team_repo->getByUserId();
		}
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
			$request = request();
			$id=Helper::get_userid($request->input('search_id'));
			$pid = $id;
			$s=1;
            $call_procedure =  $this->team_repo->getUserAtLevel($id);
            $tr = $this->team_repo->getByUserId();
		}
		return view('Profile.tree',compact('tr', 's','pid'));
	}



/**
			* Method name	: Level Wise Team 
			* @description 	: Used for Level Wise Team 
			* @param		: request data 
			* @return		: response user record
		*/
	public function level_wise_team()
	{

		$start =  date('Y-m-d',strtotime('2021-01-01'));
		$end = date('Y-m-d',strtotime(NOW()));

		$txtuserid = '1';$role='1';$pos='-1';
		$cond="";$topupst="ALL";$member_id="";
		$request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));

			if($request->input('txt_memberid')!='')
			$txtuserid = Helper::get_userid($request->input('txt_memberid'));

			$pos=$request->input('dd_pos');
		    $role=$request->input('dd_level');

			$cond ='';
			$cond1='';
        }
			if($role == '' && $role < 0)
			{
				$role = 1;
			}
			if($start != '' && $end != '')
			{
				$cond = "AND DATE_FORMAT(enroll.CreatedDate,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(enroll.CreatedDate,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d')";
			}
			else
			{
			  $cond = '';
			}
			if($txtuserid != '' && $txtuserid != 'false')
			{
					$refraldata = $txtuserid;

					for ($x = 1; $x <= $role; $x++) 
					{
						$data['user'] = DB::select("SELECT * FROM enroll WHERE ReferralCode IN (".$refraldata.") ".$cond);
						$data['level'] = $role;
						
						$refral=[];

							if(count($data['user']) > 0)
							{
								foreach($data['user'] as $key => $value){ array_push($refral, $value->RegId); }
								$refraldata =  implode(",",$refral);
							}
					}

			}
			else
		    {
					$refraldata = 1;

					for ($x = 1; $x <= $role; $x++) 
					{
						$data['user'] = DB::select("SELECT * FROM enroll WHERE ReferralCode IN (".$refraldata.") ".$cond);
						$data['level'] = $role;
						
						$refral=[];

							if(count($data['user']) > 0)
							{
								foreach($data['user'] as $key => $value){ array_push($refral, $value->RegId); }
								$refraldata =  implode(",",$refral);
							}
					}
			}

		$user_report = $data['user'];
		$topupst=$request->input('rb_topupst');
		return view('Profile.level_wise_team', compact('user_report','topupst','start','end','pos','role','member_id'));
	}	


	/**
			* Method name	: User Downline
			* @description 	: Used for downline
			* @param		: request data 
			* @return		: response user record
		*/
	public function user_downline()
	{

		$start =  date('Y-m-d',strtotime('2021-01-01'));
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';$role='-1';$pos='-1';
		$cond="";$topupst="ALL";$member_id="";
		$request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));

			if($request->input('txt_memberid')!='')
			$txtuserid = Helper::get_userid($request->input('txt_memberid'));

			$pos=$request->input('dd_position');
		    $role=$request->input('dd_role');
			$cond ='';
			$cond1='';
        }
			if($txtuserid != '' && $txtuserid != 'false')
			{
			    $member_id=$request->input('txt_memberid');
				if($pos!=-1 && $pos!=''){
					
						 $this->team_repo->getDownline($txtuserid,$pos);
					}
					else
					{
						
				    $this->team_repo->getIntroDownline($txtuserid);
					}
			    $level= $this->team_repo->getTmpDownline1();
			}
			else
		    {
				if($pos!=-1 && $pos!='')
				$this->team_repo->getDownline(1,$pos);
				else
				$this->team_repo->getIntroDownline(1);
			    $level= $this->team_repo->getTmpDownline1();
			}
		
			$cond ='m11_user.m11_user_id IN (SELECT member_id FROM tmp_downline) AND ';
			$cond1='';
		
			$level= DB::select("SELECT member_id,level_id FROM tmp_downline");
			/*if($pos != '' && $pos != '-1')
			{
				$cond = $cond."m11_user.m11_user_position = '".$pos."'  AND ";
			}*/
			if($role != '' && $role != '-1')
			{
				$cond = $cond."m11_user.m11_user_role = ".$role."  AND ";
			}
			if($request->input('rb_topupst')!= '' && $request->input('rb_topupst')!= '-1')
			{
				$topupst=$request->input('rb_topupst');
				if($topupst=="0")
				$topupst="ALL";
				if($topupst=="1")
				$topupst="NO";
				if($topupst=="2")
				$topupst="TOPUP";
			}
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$cond = $cond." DATE_FORMAT(m11_user.m11_user_onadd,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(m11_user.m11_user_onadd,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
		$cond = $cond." 1";
		//print_r($cond);
		$user=array(
		'proc'=>7,
		'userid'=> $cond,
		);
		$user_report = $this->enroll_repo->getUserByProc($user);
		return view('Profile.downline', compact('user_report','level','topupst','start','end','pos','role','member_id'));
	}	

	/**
			* Method name	: Direct Referral
			* @description 	: Used for direct referral
			* @param		: request data 
			* @return		: response user record
		*/
	public function direct_referal()
		{
		$start =  date('Y-m-d',strtotime('2021-01-01'));
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';$role='-1';$pos='-1';
		$cond="";$topupst="ALL";$member_id="";
		$request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));

			if($request->input('txt_memberid')!='')
			$txtuserid = Helper::get_userid($request->input('txt_memberid'));

			$pos=$request->input('dd_pos');
		    $role=$request->input('dd_role');
			$cond ='';
			$cond1='';
        }
			if($txtuserid != '' && $txtuserid != 'false')
			{
			    $member_id=$request->input('txt_memberid');
			   
			    $cond = $cond."m11_user.m11_user_referral_code= $txtuserid  AND ";
			}
			else
			{
			    $cond = $cond."m11_user.m11_user_referral_code=1  AND ";
			}
			if($pos != '' && $pos != '-1')
			{
				if($txtuserid != '' && $txtuserid != 'false')
				{
				    $this->team_repo->getDownline($txtuserid,$pos);
			    $level= $this->team_repo->getTmpDownline1();
			    $cond =$cond.'m11_user.m11_user_id IN (SELECT member_id FROM tmp_downline) AND ';
				}
				else
				{
				   $this->team_repo->getDownline(1,$pos);
			    $level= $this->team_repo->getTmpDownline1();
			    $cond =$cond.'m11_user.m11_user_id IN (SELECT member_id FROM tmp_downline) AND ';
				}
				
				//$cond = $cond."m11_user.m11_user_position = '".$pos."'  AND ";
			}
			if($role != '' && $role != '-1')
			{
				$cond = $cond."m11_user.m11_user_role = ".$role."  AND ";
			}
			if($request->input('rb_topupst')!= '' && $request->input('rb_topupst')!= '-1')
			{
				$topupst=$request->input('rb_topupst');
				if($topupst=="0")
				$topupst="ALL";
				if($topupst=="1")
				$topupst="NO";
				if($topupst=="2")
				$topupst="TOPUP";
			}
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$cond = $cond."DATE_FORMAT(m11_user.m11_user_onadd,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(m11_user.m11_user_onadd,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
		$cond = $cond." 1 ";
		$user=array(
		'proc'=>7,
		'userid'=> $cond,
		);
		$user_report = $this->enroll_repo->getUserByProc($user);
		return view('Profile.direct_referral', compact('user_report','topupst','start','end','pos','role','member_id'));
		}

    /**
			* Method name	: Change Mobile no
			* @description 	: Used for change user mobile number
			* @param		: request data 
			* @return		: response change user mobile number
		*/
    public function change_mobileno()
	{
		$request = request();
		$user = "";
		$USERID="";
		$get_useralldetail = "";
		if($request->method() == 'POST')
		{
				$USERID=$request->input('txt_memberid');
				$userid = Helper::get_userid($request->input('txt_memberid'));
				if($userid!=FALSE)
				{
					$user = Helper::get_userdetail($userid);
					$get_useralldetail = Helper::get_useralldetail($userid);
					$ERRMSG = "Member details fetch successfully.";
					$ERRCODE="success";
				}
				else
				{
					$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
					$this->isError=TRUE;
					$ERRCODE="warning";
				}
		}
		return view('Profile.change_mobileno', compact('USERID','get_useralldetail'));
	}

	/**
			* Method name	: Update Mobile no
			* @description 	: Used for change user mobile number
			* @param		: request data 
			* @return		: response change user mobile number
		*/
	public function update_usermobileno()
    {
        $page = 'PROFILE PANEL';
        $form_name = 'CHANGE USER MOBILE NO';
		$groupid = '';
		$get_useralldetail = '';
        $request = request();
        $USERID = $request->txt_membercode;
		if($_SERVER['REQUEST_METHOD']=="POST")
		{		
				if($request->input('txt_usermobileno')=='')
				{
					$ERRMSG = "Member contact number should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				$contactno=explode(' ',$request->input('txt_usermobileno'));
				if(strlen($contactno[0])<10 || strlen($contactno[0])>10)
				{
					$ERRMSG = "Member contact number should be equal to 10 digit.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_newmobileno')=='')
				{
					$ERRMSG = "Member new contact number should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(strlen($request->input('txt_newmobileno'))<10)
				{
					$ERRMSG = "Member new contact number should be sequal to 10 digit.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(strlen($request->input('txt_newmobileno'))>10)
				{
					$ERRMSG = "Member new contact number should be equal to 10 digit.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				if($this->isError==FALSE)
				{
					$user = Helper::get_userid($request->input('txt_membercode'));
					$user1 = Helper::get_userid($request->input('txt_newmobileno'));
					$user2 = $request->input('txt_membercode');
					//dd($user, $user2);
					if(empty($user))
					{
						$ERRMSG = "Member should be valid or active.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(Session::get('USER_ID')==$user)
					{
						$ERRMSG = "Same account has not been accessable.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(!empty($user1))
					{
						$ERRMSG  = "Member new contact number already exists with us.Please try different mobile no.";
						$this->isError= TRUE;
						$ERRCODE = "warning";
					}
					else
					{
						$new_mobileno=$request->input('txt_newmobileno');
						$old_mobileno=$contactno[0];
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
					//dd($ERRMSG);
				}
				
			//	dd($this->isError);
				if(request()->method() == 'POST' && $this->isError===FALSE)
				{
					$user_mobileno=$this->enroll_repo->updateUserMobile($new_mobileno, $old_mobileno, $user);
					//$user_logindetails=$this->enroll_repo->updateUserTrans($new_mobileno, $old_mobileno, $user);

					//change member id
					$userinfo = Helper::get_userdetail($user);
					$oldmemberId = $userinfo[0]->RegCode;
					$newmemberId = substr($userinfo[0]->RegCode, 0, -10).$request->input('txt_newmobileno');
					// DB::select("UPDATE m11_user SET m11_user_code = '".$newmemberId."' , m11_user_contactno = '".$request->input('txt_newmobileno')."' WHERE m11_user_id = ".$user);
					// DB::select("UPDATE tr04_login SET m11_user_contactno = '".$newmemberId."' WHERE m11_user_id = ".$user);
					// $USERID = $newmemberId;

					DB::table("m11_user")->where("m11_user_id", $user)->update(["m11_user_contactno" => $request->txt_newmobileno]);
					$USERID = $oldmemberId;

					$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => $old_mobileno.' MEMBER ID = '.$oldmemberId,
						'tr11_ar_new_value' => $new_mobileno.' MEMBER ID = '.$newmemberId,
						'tr11_ar_uid' => $user,
						'tr11_ar_description' => 'USERS MOBILE NO AND MEMBERID HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
					$mobileno_actionrecord=$this->log_repo->create($arr);
					$ERRMSG="USER'S MOBILE NO HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
				}
		}
		Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);
		return view('Profile.change_mobileno', compact('USERID','get_useralldetail'));
	}




    /**
			* Method name	: Change email
			* @description 	: Used for change user email
			* @param		: request data 
			* @return		: response change user email
		*/
    public function change_email()
	{
		$request = request();
		$user = "";
		$USERID="";
		$get_useralldetail = "";
		if($request->method() == 'POST')
		{
				$USERID=$request->input('txt_memberid');
				$userid = Helper::get_userid($request->input('txt_memberid'));
				if($userid!=FALSE)
				{
					$user = Helper::get_userdetail($userid);
					$get_useralldetail = Helper::get_useralldetail($userid);
					$ERRMSG = "Member details fetch successfully.";
					$ERRCODE="success";
				}
				else
				{
					$ERRMSG = "Member Id is not registered with us.Please check Member Id.";
					$this->isError=TRUE;
					$ERRCODE="warning";
				}
		}
		return view('Profile.change_email', compact('USERID','get_useralldetail'));
	}

	/**
			* Method name	: Update email
			* @description 	: Used for change user email
			* @param		: request data 
			* @return		: response change user email
		*/
	public function update_email()
    {
        $page = 'PROFILE PANEL';
        $form_name = 'CHANGE USER MOBILE NO';
		$groupid = '';
		$get_useralldetail = '';
        $request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{		
				if($request->input('txt_usermobileno')=='')
				{
					$ERRMSG = "Member email should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_newmobileno')=='')
				{
					$ERRMSG = "Member new email should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				if($this->isError==FALSE)
				{
					$user = Helper::get_userid($request->input('txt_membercode'));
					$user1 = DB::SELECT("SELECT MemberEmail FROM enroll WHERE MemberEmail = '".$request->input('txt_newmobileno')."' LIMIT 1");
					$user2 = $request->input('txt_membercode');
					
					if(empty($user))
					{
						$ERRMSG = "Member should be valid or active.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(Session::get('USER_ID')==$user)
					{
						$ERRMSG = "Same account has not been accessable.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(!empty($user1))
					{
						$ERRMSG  = "Member new email already exists with us.Please try different email.";
						$this->isError= TRUE;
						$ERRCODE = "warning";
					}
					else
					{
						$new_mobileno=$request->input('txt_newmobileno');
						$old_mobileno=$request->input('txt_usermobileno');
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
					//dd($ERRMSG);
				}
				
				if(request()->method() == 'POST' && $this->isError===FALSE)
				{
					$USERID = $user2;
					$user_mobileno=$this->enroll_repo->updateUserEmail($new_mobileno, $old_mobileno, $user);
					$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => $old_mobileno,
						'tr11_ar_new_value' => $new_mobileno,
						'tr11_ar_uid' => $user,
						'tr11_ar_description' => 'USERS EMAIL HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
					$mobileno_actionrecord=$this->log_repo->create($arr);
					$ERRMSG="USER'S EMAIL HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
				}
		}
		Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);
		return view('Profile.change_email', compact('USERID','get_useralldetail'));
	}





	/**
			* Method name	: Change Gmae Win Number
			* @description 	: Used for Change Gmae Win Number
			* @param		: request data 
			* @return		: response Change Gmae Win Number
		*/
	public function change_gmae_win_number(Request $request )
	{
		$data = DB::table("tr47_live_runing_games")
					->where("tr47_status", "Running")
					->leftJoin('m81_game_data', 'tr47_live_runing_games.m81_game_id', '=', 'm81_game_data.m81_id')
					->get();
		return view('Profile.change_game_winning_number', compact('data'));
	}

	public function update_game_winning_number(Request $request)
	{
		$this->validate($request, [
		    'txt_live_gmae_id_1' => 'required|exists:tr47_live_runing_games,tr47_id',
		    'txt_live_gmae_id_2' => 'required|exists:tr47_live_runing_games,tr47_id',
		    'txt_live_gmae_id_3' => 'required|exists:tr47_live_runing_games,tr47_id',
		    'txt_game_number_1' => 'nullable|numeric|between:0,9',
		    'txt_game_number_2' => 'nullable|numeric|between:0,49',
		    'txt_game_number_3' => 'nullable|numeric|between:0,99',
		]);

		$game_one = DB::select("SELECT * FROM tr47_live_runing_games WHERE tr47_id = '$request->txt_live_gmae_id_1' AND tr47_status = 'Running'");
		$game_two = DB::select("SELECT * FROM tr47_live_runing_games WHERE tr47_id = '$request->txt_live_gmae_id_2' AND tr47_status = 'Running'");
		$game_three = DB::select("SELECT * FROM tr47_live_runing_games WHERE tr47_id = '$request->txt_live_gmae_id_3' AND tr47_status = 'Running'");

		if(count($game_one) == 0) 
		{
			Session::flash('type','warning');
			Session::flash('message','This game is end.');

			return back()->withInpute();
		}


			Session::flash('type','warning');
			Session::flash('message','warning number not change.');

		if(count($game_one) > 0 && $request->txt_game_number_1)
		{
				DB::table("tr47_live_runing_games")
						->where("tr47_id", $request->txt_live_gmae_id_1)
						->where("tr47_status", "Running")
						->update(['tr47_win_lottery_number' => $request->txt_game_number_1]);

			Session::flash('type','success');
			Session::flash('message','warning number change successfully.');
		}

		if(count($game_two) > 0 && $request->txt_game_number_2)
		{
				DB::table("tr47_live_runing_games")
						->where("tr47_id", $request->txt_live_gmae_id_2)
						->where("tr47_status", "Running")
						->update(['tr47_win_lottery_number' => $request->txt_game_number_2]);

			Session::flash('type','success');
			Session::flash('message','warning number change successfully.');
		}

		if(count($game_three) > 0 && $request->txt_game_number_3)
		{
				DB::table("tr47_live_runing_games")
						->where("tr47_id", $request->txt_live_gmae_id_3)
						->where("tr47_status", "Running")
						->update(['tr47_win_lottery_number' => $request->txt_game_number_3]);

			Session::flash('type','success');
			Session::flash('message','warning number change successfully.');
		}

		
		return redirect('update_game_winning_number');
	}




	/**
			* Method name	: Change Password
			* @description 	: Used for changing user password
			* @param		: request data 
			* @return		: response change user password
		*/
	public function change_password()
		{
			$request = request();
			$user = "";
			$USERID="";
			$get_useralldetail = "";
			if($request->method() == 'POST')
			{
				$userid = Helper::get_userid($request->input('txt_memberid'));
					if($userid!=FALSE)
					{
						$user = Helper::get_userdetail($userid);
						$get_useralldetail = Helper::get_useralldetail($userid);
						$ERRMSG = "Member details fetch successfully.";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
						$this->isError=TRUE;
						$ERRCODE="warning";
					}
			}
			$USERID=$request->input('txt_memberid');
			return view('Profile.change_password', compact('USERID','get_useralldetail'));
		}





		/**
			* Method name	: Update User Password
			* @description 	: Used for updating user password
			* @param		: request data 
			* @return		: response updating user password
		*/
		public function update_userpassword()
		{
			$request = request();
			$USERID="";
			if($_SERVER['REQUEST_METHOD']=="POST")
			{		
				if($request->input('txt_newpassword')=='')
				{
					$ERRMSG = "New Password should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(strlen($request->input('txt_newpassword'))<6)
				{
					$ERRMSG = "New password length would be greater then 6 or equal 6";
					$this->isError= TRUE;
					$ERRCODE="warning";
					
				}
				else if($request->input('txt_newcpassword')=='')
				{
					$ERRMSG = "Confirm New Password should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
					
				}
				else if(strlen($request->input('txt_newcpassword'))<6)
				{
					$ERRMSG = "New Confirm password length would be greater then 6 or equal 6";
					$this->isError= TRUE;
					$ERRCODE="warning";
					
				}
				else if($request->input('txt_newpassword')!=$request->input('txt_newcpassword'))
				{
					$ERRMSG = "Password does not match with confirm password.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$password='';
					$new_password=$request->input('txt_newpassword');
					$new_cpassword=$request->input('txt_newcpassword');
					$USER=$request->input('txt_userid');
					$user_logindetails=$this->enroll_repo->updateUserPassword(Hash::make($new_password), $password, $USER);

					if($user_logindetails==1)
					{
						$arr = array(
						'tr11_ar_tblnm' => 'tr04_login',
						'tr11_ar_old_value' => $password,
						'tr11_ar_new_value' => $new_password,
						'tr11_ar_uid' => $USER,
						'tr11_ar_description' => 'USERS PIN PASSWORD HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
						$mobileno_actionrecord=$this->log_repo->create($arr);
						$ERRMSG="USER'S PASSWORD HAS BEEN CHANGED SUCCESSFULLY!";
						$ERRCODE='success';	
					}
					else
					{
						$ERRMSG="USER'S PASSWORD HAS NOT BEEN CHANGED!";
						$ERRCODE='warning';	
					}
				}
			}
			$USERID=$request->input('txt_membercode');
			$userid = Helper::get_userid($request->input('txt_membercode'));
			if($userid!=FALSE)
			{
				$user = Helper::get_userdetail($userid);
				$get_useralldetail = Helper::get_useralldetail($userid);
			}
			else
			{
				$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
				$this->isError=TRUE;
				$ERRCODE="warning";
			}
			Session::flash('type',$ERRCODE);
			Session::flash('message',$ERRMSG);
			return view('Profile.change_password', compact('USERID','get_useralldetail'));
		}	


	/**
			* Method name	: Change Trans Password
			* @description 	: Used for changing user trans password
			* @param		: request data 
			* @return		: response change user trans password
		*/
	public function change_trans_password()
		{
			$request = request();
			$user = "";
			$USERID="";
			$get_useralldetail = "";
			if($request->method() == 'POST')
			{
				$userid = Helper::get_userid($request->input('txt_memberid'));
					if($userid!=FALSE)
					{
						$user = Helper::get_userdetail($userid);
						$get_useralldetail = Helper::get_useralldetail($userid);
						$ERRMSG = "Member details fetch successfully.";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
						$this->isError=TRUE;
						$ERRCODE="warning";
					}
			}
			$USERID=$request->input('txt_memberid');
			return view('Profile.change_trans_pass', compact('USERID','get_useralldetail'));
		}

		/**
			* Method name	: Update User Trans Password
			* @description 	: Used for updating user trans password
			* @param		: request data 
			* @return		: response updating user trans password
		*/
		public function update_trans_password()
		{
			$request = request();
			$USERID="";
			if($_SERVER['REQUEST_METHOD']=="POST")
			{	

				if($request->input('txt_newpassword')=='')
				{
					$ERRMSG = "New Password should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(strlen($request->input('txt_newpassword'))<6)
				{
					$ERRMSG = "New password length would be greater then 6 or equal 6";
					$this->isError= TRUE;
					$ERRCODE="warning";
					
				}
				else if($request->input('txt_newcpassword')=='')
				{
					$ERRMSG = "Confirm New Password should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
					
				}
				else if(strlen($request->input('txt_newcpassword'))<6)
				{
					$ERRMSG = "New Confirm password length would be greater then 6 or equal 6";
					$this->isError= TRUE;
					$ERRCODE="warning";
					
				}
				else if($request->input('txt_newpassword')!=$request->input('txt_newcpassword'))
				{
					$ERRMSG = "Password does not match with confirm password.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$password='';
					$new_password=$request->input('txt_newpassword');
					$new_cpassword=$request->input('txt_newcpassword');
					$USER=$request->input('txt_userid');
					$user_logindetails=$this->enroll_repo->updateUserTrans(Hash::make($new_password),$password, $USER);

					if($user_logindetails==1)
					{
						$arr = array(
						'tr11_ar_tblnm' => 'tr04_login',
						'tr11_ar_old_value' => $password,
						'tr11_ar_new_value' => $new_password,
						'tr11_ar_uid' => $USER,
						'tr11_ar_description' => 'USERS PIN PASSWORD HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
						$mobileno_actionrecord=$this->log_repo->create($arr);
						$ERRMSG="USER'S PASSWORD HAS BEEN CHANGED SUCCESSFULLY!";
						$ERRCODE='success';	
					}
					else
					{
						$ERRMSG="USER'S PASSWORD HAS NOT BEEN CHANGED!";
						$ERRCODE='warning';	
					}
				}
			}
			$USERID=$request->input('txt_membercode');
			$userid = Helper::get_userid($request->input('txt_membercode'));
			if($userid!=FALSE)
			{
				$user = Helper::get_userdetail($userid);
				$get_useralldetail = Helper::get_useralldetail($userid);
			}
			else
			{
				$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
				$this->isError=TRUE;
				$ERRCODE="warning";
			}
			Session::flash('type',$ERRCODE);
			Session::flash('message',$ERRMSG);
			return view('Profile.change_trans_pass', compact('USERID','get_useralldetail'));
		}	
    
		public function change_mobile()
		{
			return view('Profile.change_mobile');
		}

		public function change_trans_pass1()
		{
			return view('Profile.change_trans_pass1');
		}
     /*--------------Scan Team-----------------*/
     /**
			* Method name	: Scan Team
			* @description 	: Used for scan team
			* @param		: request data 
			* @return		: response scan team
		*/
     public function scan_team($id)
    {
        
            $mem1 = $this->enroll_repo->getById($id);
            foreach($mem1 as $row1)
            {
                $intdid1=$row1->m11_user_parent_code;
                if( $intdid1 == $id )
                {
                    return 'true';
                }
                else
                {
                    $y=$this->scan_team($intdid1);
                    if($y=="true")
                    {
                        return "true";
                    }
                    else
                    {
                        return "false";
                    }
                }
            }
        
    }


    /**
			* Method name	: User Level View
			* @description 	: Used for user level view
			* @param		: request data 
			* @return		: response user level view
		*/
    public function user_level_view()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'LEVEL VIEW';
		$request = request();
		if($_SERVER['REQUEST_METHOD']=="GET")
		{
			$ERRCODE='info';
			$ERRMSG='USER LEVEL VIEW' ;
			$user = Helper::get_userdetail(1);
		}
		Session::flash('type',$ERRCODE );
		Session::flash('message',$ERRMSG );
		
		return view('Profile.levelview',compact('form_name','user'));
	}


	/**
			* Method name	: Renew subscription
			* @description 	: Used for renew subscription
			* @param		: request data 
			* @return		: response with renew subscription
		*/
	public function renew_subscription()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'RE TOPUP OR RE BUY SUBSCRIPTIONS';
		$request = request();
			$descrip="";
			$start = '2021-01-01';
			$end = date('Y-m-d',strtotime(NOW()));
			$txt_account = '';
			$txt_memberid = '';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="";
			$cond1="1";
            if($_SERVER['REQUEST_METHOD']=="POST")
            {
				if($request->input('txt_referralcode')=="")
                {
                    $ERRMSG = "Member id should be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
	         else if($request->input('dd_user_forwallet')=="" || $request->input('dd_user_forwallet')=='-1' )
                {
                    $ERRMSG = "Please select user for wallet deduction.";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
		else if($request->input('dd_package')=="" || $request->input('dd_package')==-1 )
                {
                    $ERRMSG = "Package should be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
				else if(floatval($request->input('txt_packageamt'))=="" || floatval($request->input('txt_packageamt'))==0.00 )
                {
                    $ERRMSG = "Package amount be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
				
				else
				{
					$ERRMSG = "";
                    $this->isError= FALSE;
                    $ERRCODE="success";
				}
		    }
                if(request()->method() == 'POST' && $this->isError==FALSE)
                {
					$topup=array(
					    'proc'=>1,
						'txt_userid'=>$request->input('txt_referralcode'),
						'dd_package'=>$request->input('dd_package'),
						'dd_user_forwallet'=>$request->input('dd_user_forwallet'),
						'dd_wallet'=>1
					);
				  $topup_report = $this->topup_repo->callRetopup($topup);
				  $DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
                  $DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
				  $ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
				  $ERRMSG=$DB_ERRMSG[0]->ERR_MSG;
			//dd($ERRCODE);
			if( $DB_ERRCODE[0]->ERR_CODE=="success")
			{
				////////Helper::send_sms($request->input('txt_mobileno'),$DB_ERRMSG[0]->ERR_MSG);
			}
			Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
			}
			 if($_SERVER['REQUEST_METHOD']=="GET")
            {
				$ERRCODE='info';
				$ERRMSG='TOPUP OR BUY SUBSCRIPTIONS' ;
			}
		Session::flash('type',$ERRCODE );
		Session::flash('message',$ERRMSG );
		$package=DB::select("SELECT * FROM package WHERE PACKAGE_TYPE=2 AND 1");
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('Profile.retopup_subscription',compact('form_name','user','package'));
	}	

	/**
			* Method name	: Change slab
			* @description 	: Used for changing slab
			* @param		: request data 
			* @return		: response with changing slab
		*/
    public function change_slab()
    {
        $page = 'PROFILE PANEL';
        $form_name = 'CHANGE SLAB';
		$request = request();
		$user_details = "";
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
			$user_details = Helper::getuserdetail_ByCode($request->input('txt_memberid'));	
		}
		$GROUP = Helper::get_group(-1,'ACTIVE');
    	return view('Profile.change_slab', compact('page', 'form_name','GROUP','user_details'));
    }

    /**
			* Method name	: Change team
			* @description 	: Used for changing team
			* @param		: request data 
			* @return		: response with changing team
		*/
    public function change_team()
    {
		$page = 'PROFILE PANEL';
		$form_name = 'CHANGE TEAM';
		$request = request();
		$user_details = "";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		$user_details=Helper::getuserdetail_ByCode($request->input('txt_memberid'));	
		}
		return view('Profile.change_team', compact('page', 'form_name','user_details'));
    }




    /**
			* Method name	: Change role
			* @description 	: Used for changing role
			* @param		: request data 
			* @return		: response with changing role
		*/
    public function change_role(request $request)
    {
		$user_details = "";
		$ReferralUser_details= "";
		$role = "";
		$data ="";
		$USERID ="";

		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$USERID = $request->input('txt_memberid');
			$user_details=Helper::getuserdetail_ByCode($request->input('txt_memberid'));	
			if(count($user_details) > 0)
			{
				 $user_details = $user_details[0];
				 if($user_details->ReferralCode > 0)
				 {
					$ReferralUser_details=Helper::get_userdetail($user_details->ReferralCode);
					if(count($ReferralUser_details) > 0)
					{
						$ReferralUser_details = $ReferralUser_details[0];
						$role = $ReferralUser_details->MemberRole;
					}
					else
					{
						$ReferralUser_details= "";
					}
				 }
				else
				{
					$ReferralUser_details =[];
					$role = 'SUPER ADMIN';
				}
			
				$rechargedata = DB::select("SELECT * FROM tr05_recharge_detail WHERE m11_user_id = ".$user_details->RegId. " limit 1");

				if(count($rechargedata) <= 0)
				{
						if($ReferralUser_details !="")
						{
								$data = '<option value="8" {{ old("dd_role") == 8? "selected":""}}>B2CUSER</option>';
								if($role == 'SUPER ADMIN')
								{
										$data = '<option value="1" {{ old("dd_role") == 1? "selected":""}}>BRANCH</option>
													 <option value="2" {{ old("dd_role") == 2? "selected":""}}>WHITE LABEL</option>
													 <option value="3" {{ old("dd_role") == 3? "selected":""}}>API USER</option>
													 <option value="4" {{ old("dd_role") == 4? "selected":""}}>SUPER DISTRIBUTOR</option>
													 <option value="5" {{ old("dd_role") == 5? "selected":""}}>DISTRIBUTOR</option>
													 <option value="6" {{ old("dd_role") == 6? "selected":""}}>FOS</option>
													 <option value="7" {{ old("dd_role") == 7? "selected":""}}>AGENT</option>
													 <option value="8" {{ old("dd_role") == 8? "selected":""}}>B2CUSER</option>';
								}
								if($role == 'BRANCH')
								{
										$data = '<option value="4" {{ old("dd_role") == 4? "selected":""}}>SUPER DISTRIBUTOR</option>
													 <option value="5" {{ old("dd_role") == 5? "selected":""}}>DISTRIBUTOR</option>
													 <option value="6" {{ old("dd_role") == 6? "selected":""}}>FOS</option>
													 <option value="7" {{ old("dd_role") == 7? "selected":""}}>AGENT</option>
													 <option value="8" {{ old("dd_role") == 8? "selected":""}}>B2CUSER</option>';
								}
								if($role == 'WHITE LABEL' )
								{
										$data = '<option value="4" {{ old("dd_role") == 4? "selected":""}}>SUPER DISTRIBUTOR</option>
													 <option value="5" {{ old("dd_role") == 5? "selected":""}}>DISTRIBUTOR</option>
													 <option value="6" {{ old("dd_role") == 6? "selected":""}}>FOS</option>
													 <option value="7" {{ old("dd_role") == 7? "selected":""}}>AGENT</option>
													 <option value="8" {{ old("dd_role") == 8? "selected":""}}>B2CUSER</option>';
								}
								if($role == 'API USER' )
								{
										$data = '';
								}
								if($role == 'SUPER DISTRIBUTOR')
								{
										$data = '<option value="5" {{ old("dd_role") == 5? "selected":""}}>DISTRIBUTOR</option>
													 <option value="6" {{ old("dd_role") == 6? "selected":""}}>FOS</option>
													 <option value="7" {{ old("dd_role") == 7? "selected":""}}>AGENT</option>
													 <option value="8" {{ old("dd_role") == 8? "selected":""}}>B2CUSER</option>';
								}
								if($role == 'DISTRIBUTOR')
								{
										$data = '<option value="6" {{ old("dd_role") == 6? "selected":""}}>FOS</option>
													 <option value="7" {{ old("dd_role") == 7? "selected":""}}>AGENT</option>
													 <option value="8" {{ old("dd_role") == 8? "selected":""}}>B2CUSER</option>';
								}
								if($role == 'FOS') 
								{
										$data = '<option value="7" {{ old("dd_role") == 7? "selected":""}}>AGENT</option>
													 <option value="8" {{ old("dd_role") == 8? "selected":""}}>B2CUSER</option>';
								}
								if($role == 'B2CUSER') 
								{
										$data = '<option value="8" {{ old("dd_role") == 8? "selected":""}}>B2CUSER</option>';
								}
						}
						else
						{
							$data = '<option value="-1" {{ old("dd_role") == -1? "selected":""}}>SELECT ROLE</option>';
						}

				}
				else
				{
					Session::flash('type','warning' );
					Session::flash('message','This User Roloe Not Change');
					return redirect('change_role');
				}


			}
			else
			{
				$user_details = "";
			}

	
		}
//dd($user_details);
		return view('Profile.change_role', compact('ReferralUser_details','data','user_details','USERID'));
    }



	public function update_user_role(request $request)
    { 
		
		$new_role = DB::table('roles')->where('PARENT_ROLE_ID', 1)->where('USER_ROLE_ID', $request->input('dd_role'))->first(); 

		if( $request->input('txt_id') == '')	
		{
					Session::flash('type','warning' );
					Session::flash('message','User Not Found');
					return redirect('change_role');
		}
		elseif( $request->input('oldrole') == '')	
		{
					Session::flash('type','warning' );
					Session::flash('message','OLD Required');
					return redirect('change_role');
		}
		elseif( $request->input('dd_role') == '')	
		{
					Session::flash('type','warning' );
					Session::flash('message','New Role Required');
					return redirect('change_role');
		}
		elseif($new_role == null)	
		{
					Session::flash('type','warning' );
					Session::flash('message','Role Not Found');
					return redirect('change_role');
		}
		else
		{
				//change member id
					$userinfo = Helper::get_userdetail($request->input('txt_id'));
					$oldmemberId = $userinfo[0]->RegCode;
					$newmemberId = substr($userinfo[0]->RegCode, -10, 13).$request->input('txt_newmobileno');
		

					 if($request->input('dd_role')  == 1) { $newmemberId='APB'.$newmemberId; }
					 if($request->input('dd_role') == 2) { $newmemberId='APW'.$newmemberId; }
					 if($request->input('dd_role') == 3) { $newmemberId='APA'.$newmemberId; }
					 if($request->input('dd_role') == 4) { $newmemberId='APS'.$newmemberId; }
					 if($request->input('dd_role') == 5) { $newmemberId='APD'.$newmemberId; }
					 if($request->input('dd_role') == 6) { $newmemberId='APF'.$newmemberId; }
					 if($request->input('dd_role') == 7) { $newmemberId='APR'.$newmemberId; }
					 if($request->input('dd_role') == 8) { $newmemberId='APC'.$newmemberId; }

					DB::select("UPDATE m11_user SET m11_user_code = '".$newmemberId."' , m11_user_role = '".$request->input('dd_role')."' WHERE m11_user_id = ".$request->input('txt_id'));
					DB::select("UPDATE tr04_login SET m11_user_contactno = '".$newmemberId."' WHERE m11_user_id = ".$request->input('txt_id'));
					$USERID = $newmemberId;

					$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => ' MEMBER ROLE = '.$request->input('oldrole') .' MEMBER ID = '.$oldmemberId,
						'tr11_ar_new_value' => ' MEMBER ROLE = '.$new_role->ROLE_NAME.' MEMBER ID = '.$newmemberId,
						'tr11_ar_uid' => $request->input('txt_id'),
						'tr11_ar_description' => 'USERS ROLE AND MEMBERID HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
					$mobileno_actionrecord=$this->log_repo->create($arr);

		}
					Session::flash('type','success' );
					Session::flash('message','USERS ROLE AND MEMBERID HAS BEEN CHANGED SUCCESSFULLY');
					return redirect('change_role');
	}



    /**
			* Method name	: Change parent
			* @description 	: Used for changing parent
			* @param		: request data 
			* @return		: response with changing parent
		*/
	public function change_parent()
    {
		$page = 'PROFILE PANEL';
		$form_name = 'CHANGE PARENT';
		$request = request();
		$user_details = "";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		$user_details=Helper::getuserdetail_ByCode($request->input('txt_memberid'));	
		}
		return view('Profile.change_parent', compact('page', 'form_name','user_details'));
    }


	
    /**
			* Method name	: Change status
			* @description 	: Used for changing status
			* @param		: request data 
			* @return		: response with changing status
		*/
    public function change_status()
    {
		$start = '2021-01-01';
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';$role='-1';$pos='-1';
		$cond="";$topupst="ALL";$member_id="";
		$request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));

			if($request->input('txt_memberid')!='')
			$txtuserid = Helper::get_userid($request->input('txt_memberid'));

			$pos=$request->input('dd_pos');
		    $role=$request->input('dd_role');
			$cond ='';
			$cond1='';
        }
			if($txtuserid != '' && $txtuserid != 'false')
			{
			    $member_id=$request->input('txt_memberid');
				$cond = $cond."m11_user.m11_user_id = ".$txtuserid."  AND ";
			}
			if($pos != '' && $pos != '-1')
			{
				$cond = $cond."m11_user.m11_user_position = '".$pos."'  AND ";
			}
			if($role != '' && $role != '-1')
			{
				$cond = $cond."m11_user.m11_user_role = ".$role."  AND ";
			}
			if($request->input('rb_topupst')!= '' && $request->input('rb_topupst')!= '-1')
			{
				$topupst=$request->input('rb_topupst');
				if($topupst=="0")
				$topupst="ALL";
				if($topupst=="1")
				$topupst="NO";
				if($topupst=="2")
				$topupst="TOPUP";
			}
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$cond = $cond."DATE_FORMAT(m11_user.m11_user_onadd,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(m11_user.m11_user_onadd,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
		$cond = $cond." 1 ";
                $user=array(
                        'proc'=>7,
                        'userid'=> $cond
                    );
        $user_report = $this->enroll_repo->getUserByProc($user);
    	return view('Profile.change_status', compact('user_report','start','topupst','end','pos','member_id','role'));
    }
	
	/**
			* Method name	: Deactive users
			* @description 	: Used for deactivating users
			* @param		: request data 
			* @return		: response with deactivating users
		*/
  	public function deactive_users()
    {
        $page = 'PROFILE PANEL';
        $form_name = 'ALL INACTIVE USER REPORT';
		//$start = '1970-01-01';
		//$end ='1970-01-01';
		$start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$cond="";
		$status=2;
		$cond1='m11_user.m11_user_status =2 AND';
        $request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
			    $start = date('Y-m-d',strtotime($request->input('txt_from')));
				$end = date('Y-m-d',strtotime($request->input('txt_to')));
				if($request->input('txt_memberid')!='')
				$txtuserid = Helper::get_userid($request->input('txt_memberid'));
				$role=$request->input('dd_role');
				$group=$request->input('dd_group');
				
				$noofrecords=$request->input('txt_noofrecords');
				$cond ='';
				$cond1='';
				if($txtuserid != '' && $txtuserid != 'false')
				{
					$cond = $cond."m11_user.m11_user_id = $txtuserid  AND ";
				}
				if($status != '' && $status != '-1')
				{
					$cond = $cond."m11_user.m11_user_status  = $status  AND ";
				}
				if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
				{
					$cond = $cond."DATE_FORMAT(m11_user.m11_user_onadd,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
				}
				$cond1=$cond;
        }
		$cond = $cond1." 1 ORDER BY  m11_user.m11_user_id DESC";
                $user=array(
                        'proc'=>1,
                        'userid'=> $cond
                    );
        $user_report = $this->enroll_repo->getUserByProc($user);
	    $GROUP = Helper::get_group(-1,'ACTIVE');
    	return view('Profile.change_status', compact('user_report','page', 'GROUP','form_name','status'));
    }

    /**
			* Method name	: Active users
			* @description 	: Used for activating users
			* @param		: request data 
			* @return		: response with activating users
		*/
	public function active_users()
    {
        $page = 'PROFILE PANEL';
        $form_name = 'ALL ACTIVE USER REPORT';
		$start = '2021-01-01';
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$cond ='';
		$status=1;
		$cond1='m11_user.m11_user_status =1 AND';
        $request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
			    $start = date('Y-m-d',strtotime($request->input('txt_from')));
				$end = date('Y-m-d',strtotime($request->input('txt_to')));
				if($request->input('txt_memberid')!='')
				$txtuserid = Helper::get_userid($request->input('txt_memberid'));
				$role=$request->input('dd_role');
				$group=$request->input('dd_group');
				$noofrecords=$request->input('txt_noofrecords');
				$cond ='';
				$cond1='';
				if($txtuserid != '' && $txtuserid != 'false')
				{
					$cond = $cond."m11_user.m11_user_id = $txtuserid  AND ";
				}
				if($status != '' && $status != '-1')
				{
					$cond = $cond."m11_user.m11_user_status  = $status  AND ";
				}
				if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
				{
					$cond = $cond."DATE_FORMAT(m11_user.m11_user_onadd,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
				}
				$cond1=$cond;
        }
		$cond = $cond1." 1 ORDER BY m11_user.m11_user_id DESC";
                $user=array(
                        'proc'=>1,
                        'userid'=> $cond
                    );

        $user_report = $this->enroll_repo->getUserByProc($user);
	    $GROUP = Helper::get_group(-1,'ACTIVE');
    	return view('Profile.change_status', compact('user_report','page', 'GROUP','form_name','status'));
    }

    /**
			* Method name	: Update status
			* @description 	: Used for updating status
			* @param		: request data 
			* @return		: response with updating status
		*/
	public function update_status()
    {
		$page = 'PROFILE PANEL';
        $form_name = 'ALL USER STATUS CHANGE';
		$txtuserid = '';
        $request = request();
		$txtuserid = $request->input('regid');
		$status = $request->input('status');
        foreach($txtuserid as $val){
            $regid = $val;
            $data =  array(
            'proc' => 1,
			'm11_user_id'=> $regid,
			'm11_user_status'=> $status
        ); 
        $result = $this->enroll_repo->userStatus($data);
        } 
		//dd($result);
		Session::flash('message','Member Update Successfully!!');
		Session::flash('type','success');
		return 1;
		//return redirect()->to('change_status');
	}

	/**
			* Method name	: Stop all user
			* @description 	: Used for stopping all users
			* @param		: request data 
			* @return		: response with stopping all users
		*/
	public function stop_all_user()
    {
		$page = 'PROFILE PANEL';
        $form_name = 'ALL USER STATUS INACTIVE HERE';
		$txtuserid = '';
        $request = request();
		$txtuserid = $request->input('regid');
		$status = $request->input('status');
            $data =  array(
            'proc' => 2,
			'm11_user_id'=> $txtuserid,
			'm11_user_status'=> $status
        ); 
        $result = $this->enroll_repo->userStatus($data);
		Session::flash('message','Member Update Successfully!!');
		Session::flash('type','success');
		return 1;
		//return redirect()->to('change_status');
	}

	/**
			* Method name	: Active all user
			* @description 	: Used for activating all users
			* @param		: request data 
			* @return		: response with activating all users
		*/
	public function active_all_user()
    {
		$page = 'PROFILE PANEL';
        $form_name = 'ALL USER STATUS INACTIVE HERE';
		$txtuserid = '';
        $request = request();
		$txtuserid = $request->input('regid');
		$status = $request->input('status');
            $data =  array(
            'proc' => 3,
			'm11_user_id'=> $txtuserid,
			'm11_user_status'=> $status
        ); 
        $result = $this->enroll_repo->userStatus($data);
		Session::flash('message','Member Update Successfully!!');
		Session::flash('type','success');
		return 1;
	}

	    /**
			* Method name	: Emp Change status
			* @description 	: Used for changing emp status
			* @param		: request data 
			* @return		: response with changing emp status
		*/
    public function emp_changestatus()
    {
		$start = '2021-01-01';
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$cond="";
        $status= '';
        $request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
			    $start = date('Y-m-d',strtotime($request->input('txtfromdate')));
				$end = date('Y-m-d',strtotime($request->input('txttodate')));
				if($request->input('txtuserid')!='')
				$txtuserid = Helper::get_userid($request->input('txtuserid'));
				$role=$request->input('dd_role');
				$group=$request->input('dd_group');
				$status=$request->input('dd_status');
				$noofrecords=$request->input('txt_noofrecords');
				$cond ='';
				$cond1='';
				if($txtuserid != '' && $txtuserid != 'false')
				{
					$cond = $cond."m30_employee.m30_employee_id = $txtuserid  AND ";
				}
				if($status != '' && $status != '-1')
				{
					$cond = $cond."m30_employee.m30_employee_status  = $status  AND ";
				}
				if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
				{
					$cond = $cond."DATE_FORMAT(m30_employee.m30_employee_onadd,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
				}
				
        }
		$cond = $cond." 1 ";
                $user=array(
                        'proc'=>1,
                        'empid'=> $cond
                    );
        $user_report = $this->emp_repo->getEnrollEmployee($user);
//dd($user_report);
    	return view('Profile.emp_changestatus', compact('user_report','status'));
    }
	
	/**
			* Method name	: Deactive emps
			* @description 	: Used for deactivating emps
			* @param		: request data 
			* @return		: response with deactivating emps
		*/
  	public function deactive_emps()
    {
        $page = 'PROFILE PANEL';
        $form_name = 'ALL INACTIVE USER REPORT';
		$start = '2021-01-01';
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$cond="";
		$status=2;
		$cond1='m11_user.m11_user_status =2 AND';
        $request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
			    $start = date('Y-m-d',strtotime($request->input('txt_from')));
				$end = date('Y-m-d',strtotime($request->input('txt_to')));
				if($request->input('txt_memberid')!='')
				$txtuserid = Helper::get_userid($request->input('txt_memberid'));
				$role=$request->input('dd_role');
				$group=$request->input('dd_group');
				
				$noofrecords=$request->input('txt_noofrecords');
				$cond ='';
				$cond1='';
				if($txtuserid != '' && $txtuserid != 'false')
				{
					$cond = $cond."m11_user.m11_user_id = $txtuserid  AND ";
				}
				if($status != '' && $status != '-1')
				{
					$cond = $cond."m11_user.m11_user_status  = $status  AND ";
				}
				if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
				{
					$cond = $cond."DATE_FORMAT(m11_user.m11_user_onadd,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
				}
				$cond1=$cond;
        }
		$cond = $cond1." 1 ORDER BY  m11_user.m11_user_id DESC";
                $user=array(
                        'proc'=>1,
                        'userid'=> $cond
                    );
        $user_report = $this->enroll_repo->getUserByProc($user);
	    $GROUP = Helper::get_group(-1,'ACTIVE');
    	return view('Profile.emp_changestatus', compact('user_report','page', 'GROUP','form_name','status'));
    }

    /**
			* Method name	: Active emps
			* @description 	: Used for activating emps
			* @param		: request data 
			* @return		: response with activating emps
		*/
	public function active_emps()
    {
        $page = 'PROFILE PANEL';
        $form_name = 'ALL ACTIVE USER REPORT';
		$start = '2021-01-01';
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$cond ='';
		$status=1;
		$cond1='m11_user.m11_user_status =1 AND';
        $request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
			    $start = date('Y-m-d',strtotime($request->input('txt_from')));
				$end = date('Y-m-d',strtotime($request->input('txt_to')));
				if($request->input('txt_memberid')!='')
				$txtuserid = Helper::get_userid($request->input('txt_memberid'));
				$role=$request->input('dd_role');
				$group=$request->input('dd_group');
				$noofrecords=$request->input('txt_noofrecords');
				$cond ='';
				$cond1='';
				if($txtuserid != '' && $txtuserid != 'false')
				{
					$cond = $cond."m11_user.m11_user_id = $txtuserid  AND ";
				}
				if($status != '' && $status != '-1')
				{
					$cond = $cond."m11_user.m11_user_status  = $status  AND ";
				}
				if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
				{
					$cond = $cond."DATE_FORMAT(m11_user.m11_user_onadd,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
				}
				$cond1=$cond;
        }
		$cond = $cond1." 1 ORDER BY m11_user.m11_user_id DESC";
                $user=array(
                        'proc'=>1,
                        'userid'=> $cond
                    );

        $user_report = $this->enroll_repo->getUserByProc($user);
	    $GROUP = Helper::get_group(-1,'ACTIVE');
    	return view('Profile.emp_changestatus', compact('user_report','page', 'GROUP','form_name','status'));
    }

    /**
			* Method name	: Emp Update status
			* @description 	: Used for updating emp status
			* @param		: request data 
			* @return		: response with updating emp status
		*/
	public function emp_updatestatus()
    {
		$page = 'PROFILE PANEL';
        $form_name = 'ALL USER STATUS CHANGE';
		$txtuserid = '';
        $request = request();
		$txtuserid = $request->input('regid');
		$status = $request->input('status');
        foreach($txtuserid as $val){
            $regid = $val;
            $data =  array(
            'proc' => 1,
			'm30_employee_id'=> $regid,
			'm30_employee_status'=> $status
        ); 
        $result = $this->emp_repo->empStatus($data);
        } 
		//dd($result);
		Session::flash('message','Employee Update Successfully!!');
		Session::flash('type','success');
		return 1;
		//return redirect()->to('emp_changestatus');
	}

	/**
			* Method name	: Stop all emp
			* @description 	: Used for stopping all emps
			* @param		: request data 
			* @return		: response with stopping all emps
		*/
	public function stop_all_emp()
    {
		$page = 'PROFILE PANEL';
        $form_name = 'ALL USER STATUS INACTIVE HERE';
		$txtuserid = '';
        $request = request();
		$txtuserid = $request->input('regid');
		$status = $request->input('status');
            $data =  array(
            'proc' => 2,
			'm30_employee_id'=> $txtuserid,
			'm30_employee_status'=> $status
        ); 
        $result = $this->emp_repo->empStatus($data);
		Session::flash('message','Employee Update Successfully!!');
		Session::flash('type','success');
		return 1;
		//return redirect()->to('emp_changestatus');
	}

	/**
			* Method name	: Active all emp
			* @description 	: Used for activating all emps
			* @param		: request data 
			* @return		: response with activating all emps
		*/
	public function active_all_emp()
    {
		$page = 'PROFILE PANEL';
        $form_name = 'ALL USER STATUS INACTIVE HERE';
		$txtuserid = '';
        $request = request();
		$txtuserid = $request->input('regid');
		$status = $request->input('status');
            $data =  array(
            'proc' => 3,
			'm30_employee_id'=> $txtuserid,
			'm30_employee_status'=> $status
        ); 
        $result = $this->emp_repo->empStatus($data);
		Session::flash('message','Employee Update Successfully!!');
		Session::flash('type','success');
		return 1;
	}

	/**
			* Method name	: Update kyc status
			* @description 	: Used for updating kyc status
			* @param		: request data 
			* @return		: response with updating kyc status
		*/
    public function update_kyc_status()
    {
		$page = 'PROFILE PANEL';
        $form_name = 'ALL USER KYC STATUS CHANGE';
		$txtuserid = '';
        $request = request();
		$txtuserid = $request->input('txt_statusregid');
		//$status = $request->input('status');

            $data =  array(
            'proc' => 4,
			'm11_user_id'=> $txtuserid,
			'm11_user_status'=> 1
        ); 
        $result = $this->enroll_repo->userStatus($data);
		Session::flash('message','Member Kyc Status Update Successfully!!');
		return redirect()->to('kyc');
	}

	/**
		* Method name	: Update kyc status
		* @description 	: Used for updating kyc status
		* @param		: request data 
		* @return		: response with updating kyc status
	*/
	public function update_kyc_resubmit()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'ALL USER KYC STATUS CHANGE';
		$txtuserid = '';
		$request = request();
		$txtuserid = $request->input('txt_statusregid1');
		//$status = $request->input('status');

			$data =  array(
			'proc' => 6,
			'm11_user_id'=> $txtuserid,
			'm11_user_status'=> 1
		); 
		//dd($data);
		$result = $this->enroll_repo->userStatus($data);
		Session::flash('message','Member Kyc Status Update Successfully!!');
		return redirect()->to('kyc');
	}

	/**
			* Method name	: Update shop status
			* @description 	: Used for updating shop status
			* @param		: request data 
			* @return		: response with updating shop status
		*/
	public function update_shop_status()
    {
		$page = 'PROFILE PANEL';
        $form_name = 'ALL USER SHOP STATUS CHANGE';
		$txtuserid = '';
        $request = request();
		$txtuserid = $request->input('txt_statusregid');
		//$status = $request->input('status');
      
            $data =  array(
            'proc' => 5,
			'm11_user_id'=> $txtuserid,
			'm11_user_status'=> 1
        ); 
		//print_r($data);
        $result = $this->enroll_repo->userStatus($data);
  
		Session::flash('message','Member Shop Status Update Successfully!!');
		$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
        $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
				// echo($ERRCODE[0]->ERR_CODE);
				// echo($ERRMSG[0]->ERR_MSG);
                   Session::flash( 'message', $ERRMSG[0]->ERR_MSG );
	return redirect()->to('shop_details');
	//return $ERRCODE[0]->ERR_CODE;
	}

	/**
			* Method name	: Update user team
			* @description 	: Used for updating user team
			* @param		: request data 
			* @return		: response with updating user team
		*/
	public function update_userteam()
    {
        $page = 'PROFILE PANEL';
        $form_name = 'CHANGE USER TEAM';
		$groupid = '';
        $request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{		
				if($request->input('txt_referralcode')=='')
				{
					$ERRMSG = "Member Code should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_newintro')=='')
				{
					$ERRMSG = "Member new introducer code should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				if($this->isError==FALSE)
				{
					$user = Helper::get_userid($request->input('txt_referralcode'));
					$user1 = Helper::get_userid($request->input('txt_newintro'));
					if(empty($user))
					{
						$ERRMSG = "Member should be valid or active.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(Session::get('USER_ID')==$user)
					{
						$ERRMSG = "Same account has not been accessable.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(empty($user1))
					{
						$ERRMSG ="Member new introducer code not exists with us.Please try different mobile no.";
						$this->isError= TRUE;
						$ERRCODE = "warning";
					}
					else
					{
						$new_intro=$request->input('txt_newintro');
						$old_intro=$request->input('txt_referralcode');
						$old_itroid=$request->input('txt_oldintro');
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
				}
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$arr = array(
						'm11_user_referral_code' => $user1,
						'm11_user_parent_code' => $user1
						);

					$user_team = $this->enroll_repo->updateUserTeam($old_itroid, $user, $arr);
					$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => $old_itroid,
						'tr11_ar_new_value' => $user1,
						'tr11_ar_uid' => $user,
						'tr11_ar_description' => 'USER S TEAM HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
					$team_actionrecord=$this->log_repo->create($arr);
					$ERRMSG="USER'S TEAM HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
				}
		}
		Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);
		return redirect()->to('change_team');
	}

	/**
			* Method name	: Update user parent
			* @description 	: Used for updating user parent
			* @param		: request data 
			* @return		: response with updating user parent
		*/
	public function update_userparent()
    {
        $page = 'PROFILE PANEL';
        $form_name = 'CHANGE USER TEAM';
		$groupid = '';
        $request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{		
				if($request->input('txt_intromobileno')=='')
				{
					$ERRMSG = "Member contact number should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				$contactno=explode(' ',$request->input('txt_intromobileno'));
				if(strlen($contactno[0])<10 || strlen($contactno[0])>10)
				{
					$ERRMSG = "Member contact number should be equal to 10 digit.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_newintro')=='')
				{
					$ERRMSG = "Member new parent contact number should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(strlen($request->input('txt_newintro'))<10)
				{
					$ERRMSG = "Member new parent contact number should be sequal to 10 digit.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(strlen($request->input('txt_newintro'))>10)
				{
					$ERRMSG = "Member new parent contact number should be equal to 10 digit.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				if($this->isError==FALSE)
				{
					$user = Helper::get_userid($contactno[0]);
					$user1 = Helper::get_userid($request->input('txt_newintro'));
					
					if(empty($user))
					{
						$ERRMSG = "Member should be valid or active.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(Session::get('USER_ID')==$user)
					{
						$ERRMSG = "Same account has not been accessable.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(empty($user1))
					{
						$ERRMSG ="Member new parent contact number not exists with us.Please try different mobile no.";
						$this->isError= TRUE;
						$ERRCODE = "warning";
					}
					else
					{
						$new_intro=$request->input('txt_newintro');
						$old_intro=$contactno[0];
						$old_itroid=$request->input('txt_oldintro');
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
					//dd($ERRMSG);
				}
				
				//dd($this->isError);
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$arr = array(
						'm11_user_parent_code' => $user1
						);
					$user_team = $this->enroll_repo->updateUserParent($old_itroid, $user, $arr);
					$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => $old_itroid,
						'tr11_ar_new_value' => $user1,
						'tr11_ar_uid' => $user,
						'tr11_ar_description' => 'USER S PARENT HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
					$team_actionrecord=$this->log_repo->create($arr);
					$ERRMSG="USER'S PARENT HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
				}
		}
		Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);
		return redirect()->to('all_user');
	}

	/**
			* Method name	: Update user status
			* @description 	: Used for updating user status
			* @param		: request data 
			* @return		: response with updating user status
		*/
	public function user_status()
    {
        $page = 'PROFILE PANEL';
        $form_name = 'CHANGE USER STATUS';
		$txtuserid = '';
        $request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
				if($request->input('txt_statusregid')=="")
				{
					$ERRMSG = "Member should be valid";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}	
				if(request()->method() == 'POST'&& $this->isError==FALSE)
				{

					$user_status=$this->enroll_repo->active($request->input('txt_statusregid'));
					$ERRMSG="USER STATUS HAS BEEN UPDATE SUCCESSFULLY!";
					$ERRCODE='success';	
				}
				Session::flash('message',$ERRMSG);
				Session::flash('type',$ERRCODE);
		}
		return redirect()->to('change_status');
	}
	/**
			* Method name	: Update user group
			* @description 	: Used for updating user group
			* @param		: request data 
			* @return		: response with updating user group
		*/
	public function update_usergroup()
    {
        $page = 'PROFILE PANEL';
        $form_name = 'CHANGE USER GROUP';
		$groupid = '';
        $request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{		
				if($request->input('txt_membercode')=='')
				{
					$ERRMSG = "Member code be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				$user = Helper::get_userid($request->input('txt_membercode'));
				if(empty($user))
				{
					$ERRMSG = "Member should be valid or active.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(Session::get('USER_ID')==$user)
				{
					$ERRMSG = "Same account has not been accessable.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('dd_group')=='' && $request->input('dd_group')==0 && $request->input('dd_group')==-1)
				{
					$ERRMSG = "New Group should be valid.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_currentgrouphd')=='')
				{
					$ERRMSG = "Old Group should be valid.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$groupid=$request->input('dd_group');
					$old_groupid=$request->input('txt_currentgrouphd');
					$ERRMSG = "";
					$this->isError= FALSE;
					$ERRCODE="success";
				}
				if(request()->method() == 'POST'&& $this->isError==FALSE)
				{   
					$arr = array(
						'm16_gr_id' => $groupid
						);
					$user_group = $this->enroll_repo->updateUserGroup($request->input('txt_membercode'), $user, $arr);

					$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => $old_groupid,
						'tr11_ar_new_value' => $groupid,
						'tr11_ar_uid' => $user,
						'tr11_ar_description' => 'USERS MARGIN GROUP HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
					$group_actionrecord=$this->log_repo->create($arr);
					$ERRMSG="USER'S MARGIN GROUP HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
				}
		}
		Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);

		return redirect()->to('change_slab');
	}



	/**
			* Method name	: Edit Employee
			* @description 	: Used for editing employee data
			* @param		: request employee id 
			* @return		: response employee data
		*/
	public function edit_employee()
    {
        $request = request();
		$emp = "";
		$EMPID ="";
		$get_empalldetail = "";
		if($request->method() == 'POST')
		{
			   if($request->input('txt_empid')=='')
				{
					$ERRMSG = "Employee id should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
				
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$empid = Helper::get_empid($request->input('txt_empid'));
					
					if($empid!=FALSE)
					{
					$emp = Helper::get_empdetail($empid);
					$get_empalldetail = Helper::get_empalldetail($empid);
					$ERRMSG = "Employee details fetch successfully.";
					$ERRCODE="success";
					}
					else
					{
					$ERRMSG = "Employee Id or Mobile is not registered with us.Please check mobile no.";
					$this->isError=TRUE;
					$ERRCODE="warning";
					}
				}
		}
		$EMPID=$request->input('txt_empid');
		$banks = $this->bank_repo->getAll();
		return view('Profile.edit_empprofile',compact('emp','get_empalldetail','EMPID','banks'));
     
    }


    /**
			* Method name	: Update Emp Profile
			* @description 	: Used for updating employee profile
			* @param		: request user id 
			* @return		: response updated employee profile with message
		*/
	public function update_empprofile()
	{

		$request = request();

		$EMPID='';
		if($request->method() == 'POST')
		{
			if($_FILES['txt_yourphoto']['name']!= '')
			{
				$image = $request->file('txt_yourphoto');
				$name = $request->input('txt_membercode').'_PHOTO_'.time().'.'.$image->getClientOriginalExtension();
				$destinationPath = public_path('images/USER_PHOTO');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
					$image->move($destinationPath,$name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
				$txt_yourphoto =  $name;
			}
			else
			{
				$txt_yourphoto = trim($request->input('txt_yourphotohd'));
			}
			 if($request->input('txt_username')=='')
			{
				$ERRMSG = "Member user name should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_dob')=='')
			{
				$ERRMSG = "Member Date of birth should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_address')=='')
			{
				$ERRMSG = "Member address should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_postalcode')=='')
			{
				$ERRMSG = "Postal code should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_mobileno')=='')
			{
				$ERRMSG = "Member contact number should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_email')=='')
			{
				$ERRMSG = "Member email address should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($txt_yourphoto=='')
			{
				$ERRMSG = "Employee image should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('dd_role')=='' || $request->input('dd_role')=='-1')
			{
				$ERRMSG = "Employee role should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('position')=='')
			{
				$ERRMSG = "Employee position should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				$name=explode(" " ,$request->input('txt_username'));
				$user_name=$request->input('txt_username');
				$USER=$request->input('txt_empid');
				$arr = array(
					'm30_first_name' => $name[0],
					'm30_last_name' => $name[1],
					'm30_employee_name' => $request->input('txt_username'),
					'm30_employee_dob' => date('Y-m-d',strtotime($request->input('txt_dob'))),
					'm30_employee_location' => $request->input('txt_address'),
					'm30_employee_postalcode' => $request->input('txt_postalcode'),
					'm30_employee_contactno' => $request->input('txt_mobileno'),
					'm30_employee_email' => $request->input('txt_email'),
					'm30_employee_image' => $txt_yourphoto,
					'm30_employee_role' => $request->input('dd_role'),
					'm30_employee_position' => $request->input('position')
					);
				$user_profile = $this->emp_repo->update($request->input('txt_membercode'), $request->input('txt_empid'), $arr);

				$arr = array(
					'm32_employee_cbsacno' =>$request->input('txt_accno'),
					'm01_bank_name'=>$request->input('dd_bank'),
					'm32_employee_branch'=>$request->input('txt_branchname'),
					'm32_employee_ifscode' =>$request->input('txt_ifsccode')
				);
				$this->emp_repo->updateBankByEmpId($request->input('txt_empid'), $arr);

				$arr = array(
					'm31_ek_user_photo'=>$txt_yourphoto,
					'm31_ek_uniqueid_num'=>$request->input('txt_panno'),
					'm31_ek_aadhar_num'=>$request->input('txt_aadhar'),
					'm31_ek_address'=>$request->input('txt_address')
				);
				$this->emp_repo->updateKycByUserId($request->input('txt_empid'), $arr);

				$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => '',
						'tr11_ar_new_value' => $user_name,
						'tr11_ar_uid' => $USER,
						'tr11_ar_description' => 'EMPLOYEE PERSONAL DETAILS HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
				$mobileno_actionrecord=$this->log_repo->create($arr);
				$ERRMSG="EMPLOYEE PERSONAL DETAILS HAS BEEN CHANGED SUCCESSFULLY!";
				$ERRCODE='success';	
			}
		}
		$EMPID=$request->input('txt_membercode');
		$userid = Helper::get_empid($request->input('txt_membercode'));
				
				if($userid!=FALSE)
				{
				$user = Helper::get_empdetail($userid);
				$get_empalldetail = Helper::get_empalldetail($userid);
				}
				else
				{
				$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
				$this->isError=TRUE;
				$ERRCODE="warning";
				}
		Session::flash('type',$ERRCODE);
		Session::flash('message',$ERRMSG);
		$banks = $this->bank_repo->getAll();
		return view('Profile.edit_empprofile',compact('user','get_empalldetail','EMPID','banks'));
	}

	/**
			* Method name	: Edit Employee Bank Details
			* @description 	: Used for editing employee bank details
			* @param		: request employee id 
			* @return		: response bank details of employee
		*/
	public function edit_empbankdetails()
    {
        $request = request();
		$user = "";
		$USERID="";
		$get_useralldetail = "";
		if($request->method() == 'POST')
		{
			   if($request->input('txt_memberid')=='')
				{
					$ERRMSG = "Employee id should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
				
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$userid = Helper::get_empid($request->input('txt_memberid'));
					if($userid!=FALSE)
					{
					$user = Helper::get_empdetail($userid);
					$get_useralldetail = Helper::get_empalldetail($userid);
					$ERRMSG = "Employee details fetch successfully.";
					$ERRCODE="success";
					}
					else
					{
					$ERRMSG = "Employee Id or Mobile is not registered with us.Please check mobile no.";
					$this->isError=TRUE;
					$ERRCODE="warning";
					}
				}
		}
		$USERID=$request->input('txt_memberid');
		$banks = $this->bank_repo->getAll();
	    return view('Profile.edit_emplbankdetails',compact('user','get_useralldetail','USERID','banks'));
    }

    /**
			* Method name	: Update emp Bank Details
			* @description 	: Used for editing employee bank details
			* @param		: request employee id 
			* @return		: response employee details of employee
		*/
    public function update_empbankdetails()
	{
		$request = request();

		$USERID="";
		if($request->method() == 'POST')
		{
			if($_FILES['txt_cancelchq']['name']!= '')
			{
				$image = $request->file('txt_cancelchq');
				$name = time().'.'.$image->getClientOriginalExtension();
				$destinationPath = public_path('images/CANCEL_CHEQUE');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
					$image->move($destinationPath,$name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
				$txt_cancelchq =  $name;
			}
			else
			{
				$txt_cancelchq = trim($request->input('txt_cancelchqhd'));
			}
			if($request->input('txt_nameatbank')=='' )
			{
				$ERRMSG = "Member Name at Bank should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_cbsacno')=='')
			{
				$ERRMSG = "Member Bank no Account should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('dd_bank')=='')
			{
				$ERRMSG = "Member Bank Name should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_bankbranch')=='')
			{
				$ERRMSG = "Member Bank Branch should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_bankifsccode')=='')
			{
				$ERRMSG = "Member Bank IFSCode should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($txt_cancelchq=='')
			{
				$ERRMSG = "Cancel cheque should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				$ACCOUNTNO=$request->input('txt_cbsacno');
				$USER=$request->input('txt_userid');
				$arr = array(
				'm32_employee_nameat_bank'=>$request->input('txt_nameatbank'),
				'm32_employee_cbsacno' =>$request->input('txt_cbsacno'),
				'm01_bank_name'=>$request->input('dd_bank'),
				'm32_employee_branch'=>$request->input('txt_bankbranch'),
				'm32_employee_ifscode' =>$request->input('txt_bankifsccode'),
				'm32_employeecancelechq'=>$txt_cancelchq
				);
				$this->emp_repo->updateBankByEmpId($request->input('txt_userid'), $arr);
				$arr = array(
					'tr11_ar_tblnm' => 'm11_user',
					'tr11_ar_old_value' => '',
					'tr11_ar_new_value' => $ACCOUNTNO,
					'tr11_ar_uid' => $USER,
					'tr11_ar_description' => 'EMPLOYEE BANK DETAILS HAS BEEN CHANGED SUCCESSFULLY!',
					'tr11_updated_by' => 1,
					'tr11_updated_by_id' =>  Session::get('USER_ID')
					);
				$bank_actionrecord=$this->log_repo->create($arr);
				$ERRMSG="EMPLOYEE BANK HAS BEEN CHANGED SUCCESSFULLY!";
				$ERRCODE='success';	
			}
		}
				$USERID=$request->input('txt_membercode');
				$userid = Helper::get_empid($request->input('txt_membercode'));
				if($userid!=FALSE)
				{
				$user = Helper::get_empdetail($userid);
				$get_useralldetail = Helper::get_empalldetail($userid);
				}
				else
				{
				$ERRMSG = "Employee Id or Mobile is not registered with us.Please check mobile no.";
				$this->isError=TRUE;
				$ERRCODE="warning";
				}
		Session::flash('type',$ERRCODE);
		Session::flash('message',$ERRMSG);
		$banks = $this->bank_repo->getAll();
		return view('Profile.edit_emplbankdetails',compact('user','get_useralldetail','USERID','banks'));
	}

	/**
			* Method name	: Update User Bank Details
			* @description 	: Used for editing user bank details
			* @param		: request user id 
			* @return		: response bank details of user
		*/
	public function edit_empkycdetails()
    {
        $request = request();
		$user = "";
		$USERID="";
		$get_useralldetail = "";
		if($request->method() == 'POST')
		{
			   if($request->input('txt_memberid')=='')
				{
					$ERRMSG = "Member id should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
				
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$userid = Helper::get_empid($request->input('txt_memberid'));
					if($userid!=FALSE)
					{
					$user = Helper::get_empdetail($userid);
					$get_useralldetail = Helper::get_empalldetail($userid);
					$ERRMSG = "Member details fetch successfully.";
					$ERRCODE="success";
					}
					else
					{
					$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
					$this->isError=TRUE;
					$ERRCODE="warning";
					}
				}
		}
		   $USERID=$request->input('txt_memberid');
		   return view('Profile.edit_emplkycdetails',compact('get_useralldetail','USERID'));
    }

    /**
			* Method name	: Update User Bank Details
			* @description 	: Used for editing user bank details
			* @param		: request user id 
			* @return		: response bank details of user
		*/
    public function update_empkyc()
	{
		$request = request();
		$USERID="";

		if($request->method() == 'POST')
		{
			if($_FILES['txt_yourphoto']['name']!= '')
			{
				$image = $request->file('txt_yourphoto');
				$name = $request->input('txt_membercode').'_PHOTO_'.time().'.'.$image->getClientOriginalExtension();
				$destinationPath = public_path('images/USER_PHOTO');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
					$image->move($destinationPath,$name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
				$txt_yourphoto = $name;
			}
			else
			{
				$txt_yourphoto = trim($request->input('txt_yourphotohd'));
			}
			if($_FILES['txt_idproof']['name']!= '')
			{
				$image = $request->file('txt_idproof');
				$name = $request->input('txt_membercode').'_IDPROOF_'.time().'.'.$image->getClientOriginalExtension();
				$destinationPath = public_path('images/USER_IDPROOF');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
					$image->move($destinationPath, $name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
				$txt_idproof = $name;
			}
			else
			{
				$txt_idproof = trim($request->input('txt_idproofhd'));
			}
			if($_FILES['txt_addressproof']['name']!= '')
			{
				$image = $request->file('txt_addressproof');
				$name = $request->input('txt_membercode').'_ADDRESSPROOF_'.time().'.'.$image->getClientOriginalExtension();
				$destinationPath = public_path('images/USER_ADDRESSPROOF');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
					$image->move($destinationPath, $name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
				$txt_addressproof = $name;
			}
			else
			{
				$txt_addressproof = trim($request->input('txt_addressproofhd'));
			}

			if($_FILES['txt_aadharfront']['name']!= '')
			{
				$image = $request->file('txt_aadharfront');
				$name = $request->input('txt_membercode').'_AADHARFRONT_'.time().'.'.$image->getClientOriginalExtension();
				$destinationPath = public_path('images/USER_IDPROOF');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
					$image->move($destinationPath, $name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
				$txt_aadharfront = $name;
			}
			else
			{
				$txt_aadharfront = trim($request->input('txt_aadharfronthd'));
			}

			if($_FILES['txt_aadharback']['name']!= '')
			{
				$image = $request->file('txt_aadharback');
				$name = $request->input('txt_membercode').'_AADHARBACK_'.time().'.'.$image->getClientOriginalExtension();
				$destinationPath = public_path('images/USER_IDPROOF');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
					$image->move($destinationPath, $name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
				$txt_aadharback = $name;
			}
			else
			{
				$txt_aadharback = trim($request->input('txt_aadharbackhd'));
			}
			
			if($txt_yourphoto=='')
			{
				$ERRMSG = "Member image should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('dd_idprooftype')=='' || $request->input('dd_idprooftype')=='-1')
			{
				$ERRMSG = "Id proof type should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			if($request->input('txt_pancard')=='')
			{
				$ERRMSG = "Member pancard should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_aadharcard')=='')
			{
				$ERRMSG = "Aadhar card number should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($txt_aadharfront=='')
			{
				$ERRMSG = "Aadhar front image should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($txt_aadharback=='')
			{
				$ERRMSG = "Aadhar front image should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($txt_idproof=='')
			{
				$ERRMSG = "Id proof should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_address')=='')
			{
				$ERRMSG = "Member address should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($txt_addressproof=='')
			{
				$ERRMSG = "Address proof should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('dd_quali')=='' || $request->input('dd_quali')=='-1')
			{
				$ERRMSG = "Qualification type should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				$pancard=$request->input('txt_pancard');
				$USER=$request->input('txt_userid');
				$arr = array(
				'm31_ek_user_photo'=>$txt_yourphoto,
				'm31_ek_idproof_type'=>$request->input('dd_idprooftype'),
				'm31_ek_uniqueid_num'=>$request->input('txt_pancard'),
				'm31_ek_aadhar_num'=>$request->input('txt_aadharcard'),
				'm31_ek_aadhar_front'=>$txt_aadharfront,
				'm31_ek_aadhar_back'=>$txt_aadharback,
				'm31_ek_idproofdoc'=>$txt_idproof,
				'm31_ek_address'=>$request->input('txt_address'),
				'm31_ek_addressproof'=>$txt_addressproof,
				'm31_ek_qualification'=>$request->input('dd_quali')
				);
				$this->emp_repo->updateKycByUserId($USER, $arr);
				//DB::table('m19_user_kyc')->where('m11_user_id', $USER)->update($arr);
				$user_profile=DB::select("UPDATE m11_user SET m11_user_location='".$request->input('txt_address')."', m11_user_image='".$txt_yourphoto."' WHERE m11_user_code ='".$request->input('txt_membercode')."' and m11_user_id=". $request->input('txt_userid')." AND m11_user_status='ACTIVE'");
				$arr = array(
					'tr11_ar_tblnm' => 'm11_user',
					'tr11_ar_old_value' => '',
					'tr11_ar_new_value' => $pancard,
					'tr11_ar_uid' => $USER,
					'tr11_ar_description' => 'EMPLOYEE KYC HAS BEEN CHANGED SUCCESSFULLY!',
					'tr11_updated_by' => 1,
					'tr11_updated_by_id' =>  Session::get('USER_ID')
					);
				$kyc_actionrecord=$this->log_repo->create($arr);	
				$ERRMSG="EMPLOYEE KYC HAS BEEN CHANGED SUCCESSFULLY!";
				$ERRCODE='success';	
			}
			
		}
      		    $USERID=$request->input('txt_membercode');
				$userid = Helper::get_empid($request->input('txt_membercode'));
				if($userid!=FALSE)
				{
					$user = Helper::get_empdetail($userid);
					$get_useralldetail = Helper::get_empalldetail($userid);
				}
				else
				{
				$ERRMSG = "Employee Id or Mobile is not registered with us.Please check mobile no.";
				$this->isError=TRUE;
				$ERRCODE="warning";
				}
		Session::flash('type',$ERRCODE);
		Session::flash('message',$ERRMSG);
//dd($get_useralldetail);
	   return view('Profile.edit_emplkycdetails',compact('get_useralldetail','USERID'));
	}

	/**
		* Method name	: View employee
		* @description 	: Used for viewing employee data
		* @param		: request employee id 
		* @return		: response employee data
	*/
    public function view_employee()
	{
		$request = request();
		$user = "";
		$USERID="";
		$get_useralldetail = "";
		if($request->method() == 'POST')
		{
			if($request->input('txt_memberid')=='')
			{
				$ERRMSG = "Employee id should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			
			if(request()->method() == 'POST' && $this->isError==FALSE)
			{
				$userid = Helper::get_empid($request->input('txt_memberid'));
				
				if($userid!=FALSE)
				{
					$user = Helper::get_empdetail($userid);
					$get_useralldetail = Helper::get_empalldetail($userid);
					$ERRMSG = "Employee details fetch successfully.";
					$ERRCODE="success";
				}
				else
				{
					$ERRMSG = "Employee Id or Mobile is not registered with us.Please check mobile no.";
					$this->isError=TRUE;
					$ERRCODE="warning";
				}
				}
		}
		$USERID=$request->input('txt_memberid');
		return view('Profile.view_empprofile',compact('user','get_useralldetail','USERID'));
		
	}

	 /**
			* Method name	: All Employee
			* @description 	: Used for getting all employee data
			* @param		: request data 
			* @return		: response employee data
		*/
    public function all_employee()
	{
		$start = '2021-01-01';
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$cond="";
		$topupst="";
		$request = request();
		$role="";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));
			if($request->input('txt_empid')!=''){
				$txtuserid = Helper::get_empid($request->input('txt_empid'));
			}
			$role=$request->input('dd_role');
		
			$cond ='';
			$cond1='';
		    if($txtuserid != '' && $txtuserid != 'false')
			{
				$cond = $cond."m30_employee.m30_employee_id = $txtuserid  AND ";
			}
			if($role != '' && $role != '-1')
			{
				$cond = $cond."m30_employee.m30_employee_role = '".$role."'  AND ";

			}
			if($request->input('rb_topupst')!= '' && $request->input('rb_topupst')!= '-1')
			{
				$topupst=$request->input('rb_topupst');
				if($topupst=="0")
				$topupst="ALL";
				if($topupst=="1")
				$topupst="NO";
				if($topupst=="2")
				$topupst="TOPUP";
			}
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$cond = $cond."DATE_FORMAT(m30_employee.m30_employee_onadd,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(m30_employee.m30_employee_onadd,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
			
		}
		$cond = $cond." 1 ";
		$user=array(
		'proc'=>1,
		'empid'=> $cond
		);
		$user_report = $this->emp_repo->getEnrollEmployee($user);
		return view('Profile.all_emp', compact('user_report','topupst'));
	}

	/**
			* Method name	: Kyc
			* @description 	: Used for getting all user kyc details
			* @param		: request data 
			* @return		: response user kyc data
		*/
	public function employee_kyc()
    {
        $page = 'PROFILE PANEL';
        $form_name = 'KYC REPORT';
		$start = '2021-01-01';
		$end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$cond="";$kycst="PENDING";
        $request = request();
        $dd_role = "";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
				$start = date('Y-m-d',strtotime($request->input('txt_from')));
				$end = date('Y-m-d',strtotime($request->input('txt_to')));
				$txtuserid = Helper::get_empid($request->input('txt_userid'));

				$dd_role=$request->input('dd_role');
				$cond ='';
				$cond1='';
				
				if($txtuserid != '' && $txtuserid != 'false')
				{
					$cond = $cond."m30_employee.m30_employee_id = $txtuserid  AND ";
				}
				if($dd_role != '' && $dd_role != '-1')
				{
					$cond = $cond."m30_employee.m30_employee_role = '".$dd_role."'  AND ";
				}
				if($request->input('rb_kycst')!= '' && $request->input('rb_kycst')!= '-1')
				{
					$kycst=$request->input('rb_kycst');
                    if($kycst<>"0")
                    $cond = $cond."m31_employee_kyc.m31_ek_status = $kycst  AND ";
					if($kycst=="0")
					$kycst="ALL";
					if($kycst=="2")
					$kycst="PENDING";
					if($kycst=="1")
					$kycst="APPROVED";
				}
				if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
				{
					$cond = $cond."
                    DATE_FORMAT(m31_employee_kyc.m31_ek_onupdate ,'%Y-%m-%d') >= DATE_FORMAT('".$start."','%Y-%m-%d') AND 
                    DATE_FORMAT(m31_employee_kyc.m31_ek_onupdate ,'%Y-%m-%d') <= DATE_FORMAT('".$end."','%Y-%m-%d') AND ";
				}
        }
		$cond = $cond."1 ORDER BY  m30_employee.m30_employee_id DESC";
	    $user_kyc=array(
				'proc'=>2,
                'empid'=>$cond
            );

		$userkyc_report = $this->emp_repo->getEnrollEmployee($user_kyc);
    	return view('Profile.emp_kyc', compact('userkyc_report','kycst'));
    }

	/**
			* Method name	: Emp Change Mobile no
			* @description 	: Used for change employee mobile number
			* @param		: request data 
			* @return		: response change employee mobile number
		*/
    public function emp_changemobileno()
	{
		$request = request();
		$user = "";
		$USERID="";
		$get_useralldetail = "";
		if($request->method() == 'POST')
		{
			$userid = Helper::get_empid($request->input('txt_memberid'));
//dd($userid);
				if($userid!=FALSE)
				{
					$user = Helper::get_empdetail($userid);
					$get_useralldetail = Helper::get_empalldetail($userid);
					$ERRMSG = "Member details fetch successfully.";
					$ERRCODE="success";
				}
				else
				{
					$ERRMSG = "Employee Id or Mobile is not registered with us.Please check mobile no.";
					$this->isError=TRUE;
					$ERRCODE="warning";
				}
		}
		$USERID=$request->input('txt_memberid');
		return view('Profile.emp_changemobileno', compact('USERID','get_useralldetail'));
	}

	/**
			* Method name	: Update Emp Mobile no
			* @description 	: Used for change employee mobile number
			* @param		: request data 
			* @return		: response change employee mobile number
		*/
	public function update_empmobileno()
    {
        $page = 'PROFILE PANEL';
        $form_name = 'CHANGE USER MOBILE NO';
		$groupid = '';
		$get_useralldetail = '';$USERID = '';
        $request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{		
				if($request->input('txt_usermobileno')=='')
				{
					$ERRMSG = "Employee contact number should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				$contactno=explode(' ',$request->input('txt_usermobileno'));
				if(strlen($contactno[0])<10 || strlen($contactno[0])>10)
				{
					$ERRMSG = "Employee contact number should be equal to 10 digit.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_newmobileno')=='')
				{
					$ERRMSG = "Employee new contact number should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(strlen($request->input('txt_newmobileno'))<10)
				{
					$ERRMSG = "Employee new contact number should be sequal to 10 digit.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(strlen($request->input('txt_newmobileno'))>10)
				{
					$ERRMSG = "Employee new contact number should be equal to 10 digit.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				if($this->isError==FALSE)
				{
					$user = Helper::get_empid($request->input('txt_membercode'));
					$user1 = Helper::get_empid($request->input('txt_newmobileno'));
					$user2 = $request->input('txt_membercode');
					
					if(empty($user))
					{
						$ERRMSG = "Employee should be valid or active.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(Session::get('USER_ID')==$user)
					{
						$ERRMSG = "Same account has not been accessable.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(!empty($user1))
					{
						$ERRMSG  = "Employee new contact number already exists with us.Please try different mobile no.";
						$this->isError= TRUE;
						$ERRCODE = "warning";
					}
					else
					{
						$new_mobileno=$request->input('txt_newmobileno');
						$old_mobileno=$contactno[0];
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
					//dd($ERRMSG);
				}
				
				//dd($ERRMSG);
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$USERID = $user2;
					$user_mobileno=$this->emp_repo->updateEmpMobile($new_mobileno, $old_mobileno, $user);
					$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => $old_mobileno,
						'tr11_ar_new_value' => $new_mobileno,
						'tr11_ar_uid' => $user,
						'tr11_ar_description' => 'EMPLOYEE S MOBILE NO HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
					$mobileno_actionrecord=$this->log_repo->create($arr);
					$ERRMSG="EMPLOYEE'S MOBILE NO HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
				}
		}

		Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);
		return view('Profile.emp_changemobileno', compact('USERID','get_useralldetail'));
	}

	/**
			* Method name	: Emp Show Password
			* @description 	: Used for changing employee password
			* @param		: request data 
			* @return		: response change employee password
		*/
	public function emp_showpassword()
		{
			$request = request();
			$user = "";
			$USERID="";
			$get_useralldetail = "";
			if($request->method() == 'POST')
			{
				$userid = Helper::get_empid($request->input('txt_memberid'));
					if($userid!=FALSE)
					{
						$user = Helper::get_empdetail($userid);
						$get_useralldetail = Helper::get_empalldetail($userid);
						$ERRMSG = "Member details fetch successfully.";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "Employee Id or Mobile is not registered with us.Please check mobile no.";
						$this->isError=TRUE;
						$ERRCODE="warning";
					}
			}
			$USERID=$request->input('txt_memberid');
			return view('Profile.emp_showpassword', compact('USERID','get_useralldetail'));
		}

		/**
			* Method name	: Update Emp Password
			* @description 	: Used for updating employee password
			* @param		: request data 
			* @return		: response updating employee password
		*/
		public function update_emppassword()
		{
			$request = request();
			$USERID="";
			if($_SERVER['REQUEST_METHOD']=="POST")
			{		
			    if($request->input('txt_oldpassword')=='')
				{
					$ERRMSG = "Old Password should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_newpassword')=='')
				{
					$ERRMSG = "New Password should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(strlen($request->input('txt_newpassword'))<6)
				{
					$ERRMSG = "New password length would be greater then 6 or equal 6";
					$this->isError= TRUE;
					$ERRCODE="warning";
					
				}
				else if($request->input('txt_newcpassword')=='')
				{
					$ERRMSG = "Confirm New Password should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
					
				}
				else if(strlen($request->input('txt_newcpassword'))<6)
				{
					$ERRMSG = "New Confirm password length would be greater then 6 or equal 6";
					$this->isError= TRUE;
					$ERRCODE="warning";
					
				}
				else if($request->input('txt_newpassword')!=$request->input('txt_newcpassword'))
				{
					$ERRMSG = "Password does not match with confirm password.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$password=$request->input('txt_oldpassword');
					$new_password=$request->input('txt_newpassword');
					$new_cpassword=$request->input('txt_newcpassword');
					$USER=$request->input('txt_userid');
					$user_logindetails=$this->emp_repo->updateEmpPassword($new_password, $password, $USER);
					if($user_logindetails==1)
					{
						$arr = array(
						'tr11_ar_tblnm' => 'tr04_login',
						'tr11_ar_old_value' => $password,
						'tr11_ar_new_value' => $new_password,
						'tr11_ar_uid' => $USER,
						'tr11_ar_description' => 'EMPLOYEES PIN PASSWORD HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
						$mobileno_actionrecord=$this->log_repo->create($arr);
						$ERRMSG="EMPLOYEE'S PASSWORD HAS BEEN CHANGED SUCCESSFULLY!";
						$ERRCODE='success';	
					}
					else
					{
						$ERRMSG="EMPLOYEE'S PASSWORD HAS NOT BEEN CHANGED!";
						$ERRCODE='warning';	
					}
				}
			}
			$USERID=$request->input('txt_membercode');
			$userid = Helper::get_empid($request->input('txt_membercode'));
			if($userid!=FALSE)
			{
				$user = Helper::get_empdetail($userid);
				$get_useralldetail = Helper::get_empalldetail($userid);
			}
			else
			{
				$ERRMSG = "Employee Id or Mobile is not registered with us.Please check mobile no.";
				$this->isError=TRUE;
				$ERRCODE="warning";
			}
			Session::flash('type',$ERRCODE);
			Session::flash('message',$ERRMSG);
			return view('Profile.emp_showpassword', compact('USERID','get_useralldetail'));
		}	

		/**
			* Method name	: Change Emp Trans Password
			* @description 	: Used for changing employee trans password
			* @param		: request data 
			* @return		: response change employee trans password
		*/
	public function change_emptrans_password()
		{
			$request = request();
			$user = "";
			$USERID="";
			$get_useralldetail = "";
			if($request->method() == 'POST')
			{
				$userid = Helper::get_empid($request->input('txt_memberid'));
//dd($userid);
					if($userid!=FALSE)
					{
						$user = Helper::get_empdetail($userid);
						$get_useralldetail = Helper::get_empalldetail($userid);
						$ERRMSG = "Employee details fetch successfully.";
						$ERRCODE="success";
					}
					else
					{
						$ERRMSG = "Employee Id or Mobile is not registered with us.Please check mobile no.";
						$this->isError=TRUE;
						$ERRCODE="warning";
					}
			}
			$USERID=$request->input('txt_memberid');
			return view('Profile.change_emptrans_pass', compact('USERID','get_useralldetail'));
		}

		/**
			* Method name	: Update Emp Trans Password
			* @description 	: Used for updating employee trans password
			* @param		: request data 
			* @return		: response updating employee trans password
		*/
		public function update_emptrans_password()
		{
			$request = request();
			$USERID="";
			if($_SERVER['REQUEST_METHOD']=="POST")
			{		
			    if($request->input('txt_oldpassword')=='')
				{
					$ERRMSG = "Old Password should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_newpassword')=='')
				{
					$ERRMSG = "New Password should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(strlen($request->input('txt_newpassword'))<6)
				{
					$ERRMSG = "New password length would be greater then 6 or equal 6";
					$this->isError= TRUE;
					$ERRCODE="warning";
					
				}
				else if($request->input('txt_newcpassword')=='')
				{
					$ERRMSG = "Confirm New Password should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
					
				}
				else if(strlen($request->input('txt_newcpassword'))<6)
				{
					$ERRMSG = "New Confirm password length would be greater then 6 or equal 6";
					$this->isError= TRUE;
					$ERRCODE="warning";
					
				}
				else if($request->input('txt_newpassword')!=$request->input('txt_newcpassword'))
				{
					$ERRMSG = "Password does not match with confirm password.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$password=$request->input('txt_oldpassword');
					$new_password=$request->input('txt_newpassword');
					$new_cpassword=$request->input('txt_newcpassword');
					$USER=$request->input('txt_userid');
					$user_logindetails=$this->emp_repo->updateEmpTrans($new_password, $password, $USER);
					if($user_logindetails==1)
					{
						$arr = array(
						'tr11_ar_tblnm' => 'tr04_login',
						'tr11_ar_old_value' => $password,
						'tr11_ar_new_value' => $new_password,
						'tr11_ar_uid' => $USER,
						'tr11_ar_description' => 'EMPLOYEES PIN PASSWORD HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
						$mobileno_actionrecord=$this->log_repo->create($arr);
						$ERRMSG="EMPLOYEE'S PASSWORD HAS BEEN CHANGED SUCCESSFULLY!";
						$ERRCODE='success';	
					}
					else
					{
						$ERRMSG="EMPLOYEE'S PASSWORD HAS NOT BEEN CHANGED!";
						$ERRCODE='warning';	
					}
				}
			}
			$USERID=$request->input('txt_membercode');
			$userid = Helper::get_empid($request->input('txt_membercode'));
			if($userid!=FALSE)
			{
				$user = Helper::get_empdetail($userid);
				$get_useralldetail = Helper::get_empalldetail($userid);
			}
			else
			{
				$ERRMSG = "Employee Id or Mobile is not registered with us.Please check mobile no.";
				$this->isError=TRUE;
				$ERRCODE="warning";
			}
			Session::flash('type',$ERRCODE);
			Session::flash('message',$ERRMSG);
			return view('Profile.change_emptrans_pass', compact('USERID','get_useralldetail'));
		}

		/**
			* Method name	: Get Affi
			* @description 	: affiliate get
			* @param		: request data 
			* @return		: response with affiliate
		*/
		public function Get_Affiliate_Data(request $request)
		{
			$id = $request->id;
			if($id != null)
			{
				return $this->Affiliate_repo->getByRegId($id);
			}
			else
			{
				return '';
			}
		}


		/**
			* Method name	: Update affiliate
			* @description 	: Used for updatingaffiliate
			* @param		: request data 
			* @return		: response updating affiliate
		*/
		public function update_affiliate(request $request )
		{
				$id = $request->affiliate_id;
				$arr = array(
				'm22_affiliate_name' => $request->affiliate_name,
				'm22_affiliate_address' =>  $request->affiliate_address,
				'm22_affiliate_web_url' =>  $request->affiliate_web_url,
				'm22_affiliate_web_url2' =>  $request->affiliate_web_url2,
 
				);

			return $this->Affiliate_repo->updateByUId($id, $arr);

		}


    /**
			* Method name	: Send Sms
			* @description 	: Used for sending sms 
			* @param		: Phone number and sending message 
			* @return		: return message to user
		*/    
	public function send_sms($mob,$msg)
	{
		$url = Config('SMS_SEND_URL');
		$params = array(
        'user'=>Config('SMS_AUTH'),
        'password'=>Config('SMS_PWD'),
        'msisdn'=>$mob,
        'sid'=>Config('SMS_SENDERID'),
        'msg'=>$msg,         
        'fl'=>0,             
        'gwid'=>2    
		);
		Helper::_curl_execute('GET',$url,$params);
	}
		

		/**
			* Method name	: Get api
			* @description 	: api get
			* @param		: request data 
			* @return		: response with api
		*/
		public function Get_User_Data(request $request)
		{
			$id = $request->id;
			if($id != null)
			{	
					$user[0] = DB::table('m11_user')->where('m11_user_id', $id)->select('m11_user_callback','m11_user_dmr_callback','m11_user_aeps_callback','m11_user_aeps_status_check','m11_user_api_token','m11_user_code','m11_user_id')->first();
					$user[1] = DB::table('tr04_login')->where('m11_user_id', $id)->select('tr04_ip')->first();
					return $user;
			}
			else
			{
				return '';
			}
		}

		/**
			* Method name	: Update api
			* @description 	: Used for api
			* @param		: request data 
			* @return		: response updating api
		*/
		public function update_api_user_data(request $request )
		{
						$id = $request->id;
						$arr = array(
						'm11_user_api_token' => $request->api_token,
						'm11_user_aeps_callback' =>  $request->aeps_callback,
						'm11_user_aeps_status_check' =>  $request->aeps_status_check,
						'm11_user_callback' =>  $request->callback,
						'm11_user_dmr_callback' =>  $request->dmr_callback,
						);
					
				$arrs = array(
						'tr04_ip' => $request->ip
						);

					$datas = DB::table('tr04_login')->where('m11_user_id', $id)->update($arrs);

					$data = $this->enroll_repo->updates($id, $arr);

				if($datas || $data)
				{
					return 1;
				}
				else
				{
					return 0;
				}

		}


		/**
			* Method name	: reassigned employee
			* @description 	: Used for editing user data
			* @param		: request user id 
			* @return		: response user data
		*/
	public function reassigned_employee()
    {
        $request = request();
		$user = "";
		$USERID="";
		$get_useralldetail = "";
		if($request->method() == 'POST')
		{
			   if($request->input('txt_memberid')=='')
				{
					$ERRMSG = "Member id should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}
				
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$userid = Helper::get_userid($request->input('txt_memberid'));
					
					if($userid!=FALSE)
					{
					$user = Helper::get_userdetail($userid);
					$get_useralldetail = Helper::get_userdetail($userid);
					$ERRMSG = "Member details fetch successfully.";
					$ERRCODE="success";
					}
					else
					{
					$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
					$this->isError=TRUE;
					$ERRCODE="warning";
					}
				}
		}
		$USERID=$request->input('txt_memberid');
		$emp = $this->emp_repo->getByRole(3);
		return view('Profile.reassigned_employee',compact('user','get_useralldetail','USERID','emp'));
     
    }



        /**
			* Method name	: Update User Profile
			* @description 	: Used for updating user profile
			* @param		: request user id 
			* @return		: response updated profile with message
		*/
	public function update_reassigned_employee()
	{
		$request = request();
		$USERID='';

		if($request->method() == 'POST')
		{
	
			 if($request->input('dd_employee')=='')
			{
				$ERRMSG = "Member user name should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{

				$USER=$request->input('txt_userid');


				$arr = array(
					'm30_employee_id' => $request->input('dd_employee'),
					);

				$user_profile = $this->enroll_repo->update($request->input('txt_membercode'), $request->input('txt_userid'), $arr);
	
		
				$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => '',
						'tr11_ar_new_value' => $request->input('dd_employee'),
						'tr11_ar_uid' => $USER,
						'tr11_ar_description' => 'USER REASSIGNED EMPLOYEE SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);

				$mobileno_actionrecord=$this->log_repo->create($arr);
				$ERRMSG="USER  REASSIGNED EMPLOYEE SUCCESSFULLY!";
				$ERRCODE='success';	
			}
		}

		$USERID=$request->input('txt_membercode');
		$userid = Helper::get_userid($request->input('txt_membercode'));
				
				if($userid!=FALSE)
				{
				$user = Helper::get_userdetail($userid);
				$get_useralldetail = Helper::get_userdetail($userid);
				}
				else
				{
				$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
				$this->isError=TRUE;
				$ERRCODE="warning";
				}
		Session::flash('type',$ERRCODE);
		Session::flash('message',$ERRMSG);
		$emp = $this->emp_repo->getByRole(3);
		return view('Profile.reassigned_employee',compact('user','get_useralldetail','USERID','emp'));
	}

	/**
        * Method name   : user pan token
        * @description  : Used for user pan token
        * @param        : Request data  
        * @return       : return with user pan token
    */
    public function user_pan_token()
    {
    	$request = request();
		$start = '2021-01-01';
		$end = date('Y-m-d',strtotime(NOW()));
    	$user_id = '';
    	$status = '';
		$txt_memberid = '';
    	$cond = '';
    	if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$status = $request->input('dd_status');
			$txt_memberid = $request->input('txt_memberid');

			if($request->input('txt_memberid')!='')
			
			$user_id = Helper::get_userid($request->input('txt_memberid'));

			if($user_id != '' && $user_id != 'false')
			{
				$cond = $cond."USER_ID = $user_id  AND ";
			}
			if($status != '' && $status != 'false')
			{
				$cond = $cond."STATUS = '".$status."'  AND ";
			}
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$cond = $cond."DATE_FORMAT(CREATED_AT,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(CREATED_AT,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
		}
		$cond = $cond." 1";
    	$pan_token = DB::select('SELECT * FROM pan_token WHERE '.$cond);
    	return view('Profile.user_pan_token', compact('pan_token','start','end','status','txt_memberid'));
    }


    /**
        * Method name   : pantoken status
        * @description  : Used for adding user pan token status
        * @param        : Request data  
        * @return       : return with user pan token status
    */
    public function pantoken_status()
    {
    	$request = request();

		$pantoken_details = $this->pantoken_repo->getById($request->input('txt_tokenid'));
		if($pantoken_details[0]->STATUS == 'PENDING'){

			if($request->input('dd_status') == '2'){

				$pantokenwallet=array(
					'proc'=>3,
					'transid'=>$pantoken_details[0]->TRANS_ID,
					'to_user_id'=>$pantoken_details[0]->USER_ID,
					'from_user_id'=>0,
					'amount'=>floatval($pantoken_details[0]->PAN_TOKEN*107),
					'collected_amount'=>floatval($pantoken_details[0]->PAN_TOKEN*107),
					'requesttype'=>1,
					'balfor'=>1,
					'transtype'=>1,
					'timelimit'=>900,
					'defaultstatus'=>1,
					'remark'=>"PAN TOKEN APPROVAL DEDUCTION",
					'collected_remark'=>"PAN TOKEN APPROVAL DEDUCTION",
				);

				$pantoken_wallet = DB::SELECT('CALL pantoken_deduction(
					:proc, 
					:transid,
					:to_user_id,
					:from_user_id,
					:amount, 
					:collected_amount,
					:requesttype,
					:balfor,
					:transtype,
					:timelimit,
					:defaultstatus,
					:remark,
					:collected_remark,
					@status_code,
					@status_msg)'
				,$pantokenwallet);

				$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
				$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');

				if($ERRCODE[0]->ERR_CODE == 'success'){

					$result = MahagramPantoken::transaction($pantoken_details[0]->PSA_LOGIN_ID,$pantoken_details[0]->PAN_TOKEN,'Maha321');
					$json_data = json_decode($result);

					$arr = array(
						'tr40_pt_admin_res' => $request->input('txt_adminreply'),
						'tr40_pt_status' => $request->input('dd_status'),
						'tr40_mahagram_response' => $result,
						'tr40_mahagram_requestid' => $json_data[0]->RequestId,
						'tr40_mahagram_request_status' => $json_data[0]->status
					);
					$this->pantoken_repo->update($request->input('txt_tokenid'), $arr);

					if($json_data[0]->status == 'Pending'){
						$result1 = MahagramPantoken::transaction_status($json_data[0]->RequestId);
						$json_data1 = json_decode($result1);
						$arr1 = array(
							'tr40_mahagram_request_status' => $json_data1[0]->status,
							'tr40_mahagram_status_response' => $result1
						);
						$this->pantoken_repo->update($request->input('txt_tokenid'), $arr1);
					}

					Session::flash('panrq_msg','PAN REQUEST UPDATED SUCCESSFULLY');
					Session::flash('type','success' );
				}
				else{
					Session::flash('panrq_msg',$ERRMSG[0]->ERR_MSG);
					Session::flash('type',$ERRCODE[0]->ERR_CODE);	
				}

				
			}else{
				$arr = array(
					'tr40_pt_admin_res' => $request->input('txt_adminreply'),
					'tr40_pt_status' => $request->input('dd_status')
				);
				$this->pantoken_repo->update($request->input('txt_tokenid'), $arr);
				
				Session::flash('panrq_msg','PAN REQUEST UPDATED SUCCESSFULLY');
				Session::flash('type','success' );
			}
			Session::flash('panrq_msg','PAN REQUEST ALREADY APPROVED');
			Session::flash('type','success' );
		}

    	return redirect('/user_pan_token');
    }


	public function change_reqstatus($id)
	{
		$pantoken_details = $this->pantoken_repo->getById($id);
		
		if($pantoken_details[0]->MG_REQUEST_STATUS == 'Pending'){

			$result1 = MahagramPantoken::transaction_status($pantoken_details[0]->MG_REQUESTID);
			$json_data1 = json_decode($result1);

			$arr1 = array(
				'tr40_mahagram_request_status' => $json_data1[0]->status,
				'tr40_mahagram_status_response' => $result1
			);
			$this->pantoken_repo->update($id, $arr1);

			
				$panstatusupdate = array(
					'proc'=>1,
					'userid'=>$pantoken_details[0]->USER_ID,
					'tokenid'=>$pantoken_details[0]->TOKEN_ID,
					'transid'=>$pantoken_details[0]->TRANS_ID,
					'amt'=>floatval($pantoken_details[0]->PAN_TOKEN*107),
					'recstatus'=>1
				);
				$pan_statusupdate = DB::SELECT('CALL pan_statusupdate1(
					:proc, 
					:userid,
					:tokenid, 
					:transid, 
					:amt,
					:recstatus,
					@msg)'
				,$panstatusupdate);
			

			if($json_data1[0]->status == 'Rejected'){
				
				$panstatusupdate = array(
					'proc'=>1,
					'tokenid'=>$pantoken_details[0]->TOKEN_ID,
					'userid'=>$pantoken_details[0]->USER_ID,
					'amt'=>floatval($pantoken_details[0]->PAN_TOKEN*107),
				);
				$pan_statusupdate = DB::SELECT('CALL pan_statusupdate(
					:proc, 
					:tokenid,
					:userid,
					:amt, 
					@status_code,
					@status_msg)'
				,$panstatusupdate);

				$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
				$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
			}

		}

		Session::flash('panrq_msg','MAHAGRAM STATUS UPDATED SUCCESSFULLY');
    	Session::flash('type','success' );

		return redirect('/user_pan_token');
	}






    /**
    * Method name   : game results
    * @description  : Used for viewing all user game results
    * @param        : Request data  
    * @return       : return view with all user game results
    */
    public function all_game_results()
    {
        $request = request();
        $start = '2021-07-01';
        $end =  date('Y-m-d'); 
        $user_id = '';
        $lottery_number = '';
        $cond="";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
            $lottery_number = $request->input('txt_lottery_number');
            $game_id = $request->input('dd_game');

            if($request->input('txt_memberid')!='')
            $user_id = Helper::get_userid($request->input('txt_memberid'));

            if($user_id != '' && $user_id != 'false')
            {
                $cond = $cond." AND USER_ID = $user_id";
            }
            if($lottery_number != '')
            {
                $cond = $cond." AND LOTTERY_NUMBER = '".$lottery_number."'";
            }
            if($game_id != '')
            {
                $cond = $cond." AND GAME_ID = '".$game_id."'";
            }
            if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
            {
                $cond = $cond." AND DATE_FORMAT(CREATED_AT,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(CREATED_AT,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d')";
            }
        }

        $cond = $cond." ORDER BY ID DESC";
                
        $all_orders = DB::select('SELECT * FROM user_game_bet WHERE 1 '.$cond);

        
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('Profile.game-results', compact('all_orders','user')); 
    }
    




	public function live_game_reports(Request $request)
	{
        $start = '2021-07-01';
        $end =  date('Y-m-d'); 
        $user_id = '';
        $lottery_number = '';
        $cond="";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
            $lottery_number = $request->input('txt_lottery_number');
            $game_id = $request->input('dd_game');

            if($lottery_number != '')
            {
                $cond = $cond." AND CODE = '".$lottery_number."'";
            }
            if($game_id != '')
            {
                $cond = $cond." AND GAME_ID = '".$game_id."'";
            }
            if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
            {
                $cond = $cond." AND DATE_FORMAT(CREATED_AT,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(CREATED_AT,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d')";
            }
        }

        $cond = $cond." ORDER BY ID DESC";
                
        $all_orders = DB::select('SELECT * FROM live_runing_games WHERE 1 '.$cond);

        
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('Profile.live-game-reports', compact('all_orders','user')); 
	}



	public function all_lotteries(Request $request)
	{
        $start = '2021-07-01';
        $end =  date('Y-m-d'); 
        $user_id = '';
        $lottery_number = '';
        $cond="";
        // if($_SERVER['REQUEST_METHOD']=="POST")
        // {
        //     $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
        //     $end = date('Y-m-d',strtotime($request->input('txt_todate')));
        //     $lottery_number = $request->input('txt_lottery_number');
        //     $game_id = $request->input('dd_game');

        //     if($request->input('txt_memberid')!='')
        //     $user_id = Helper::get_userid($request->input('txt_memberid'));

        //     if($user_id != '' && $user_id != 'false')
        //     {
        //         $cond = $cond." AND USER_ID = $user_id";
        //     }
        //     if($lottery_number != '')
        //     {
        //         $cond = $cond." AND LOTTERY_NUMBER = '".$lottery_number."'";
        //     }
        //     if($game_id != '')
        //     {
        //         $cond = $cond." AND GAME_ID = '".$game_id."'";
        //     }
        //     if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
        //     {
        //         $cond = $cond." AND DATE_FORMAT(CREATED_AT,'%Y-%m-%d')>=
        //          DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(CREATED_AT,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d')";
        //     }
        // }

        $cond = $cond." ORDER BY ID DESC";
                
        $all_orders = DB::select('SELECT * FROM game_data WHERE 1 '.$cond);

        
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('Profile.all-lotteries', compact('all_orders','user')); 
	}

public function coupon()
	{
		$request = request();
        $start = '1970-01-01';
		$end ='1970-01-01';
		$user_id = '';
		$coupon_no = '';
		$cond="";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$coupon_no = $request->input('txt_coupon_no');

			if($request->input('txt_user_id')!='')
			$user_id = Helper::get_userid($request->input('txt_user_id'));
			if($user_id != '' && $user_id != 'false')
			{
				$cond = $cond."`USER_ID` = $user_id  AND ";
			}
			if($coupon_no != '' && $coupon_no != 'false')
			{
				$cond = $cond."`CP_NUMBER` = $coupon_no  AND ";
			}
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$cond = $cond."DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
		}
		$cond = $cond." 1";
    	$coupon = DB::select('SELECT * FROM coupon WHERE '.$cond);
		return view('Profile.coupon',compact('coupon'));
	}

	public function add_coupon()
	{
		return view('Profile.add_coupon');
	}

	public function add_tocoupon()
	{
		$request = request();

		$this->validate($request, [
            'txt_amount' => 'required',
            'txt_user_id' => 'required',
        ],
        [
            'txt_amount.required' => 'Amount is required!',
            'txt_user_id.required' => 'User id is required!'
        ]);

		//$already_exists = DB::select("SELECT * FROM coupon WHERE USER_ID=".$request->input('txt_user_id')."");
			//if(count($already_exists) == 0){
				$no = rand(100000,999999);
				$coupon_no = 'LDC'.$no;

				$arr = array(
				'm55_coupon_number' => $coupon_no,
				'm55_amount' => $request->input('txt_amount'),
				'm11_user_id' => $request->input('txt_user_id'),
				'm55_status' => 2
			);
			//DB::table('m55_coupon')->insert($arr);
			Session::flash('cpadd_msg','COUPON ADDED SUCCESSFULLY!');
	        Session::flash('type','success');
		/*}else{
			Session::flash('cpadd_msg','COUPON ALRAEDY EXISTS FOR THIS USER');
	        Session::flash('type','warning');
		}*/

		return redirect('/coupon');
	}

	public function edit_coupon($id)
	{
		$single_coupon = DB::select("SELECT * FROM coupon WHERE CP_ID=".$id."");
		return view('Profile.edit_coupon',compact('single_coupon'));
	}

	public function update_coupon($id)
	{
		$request = request();
		$this->validate($request, [
            'txt_cp_number' => 'required'
        ],
        [
            'txt_cp_number.required' => 'Name is required!'
        ]);

		$arr = array(
			'm55_coupon_number' => $request->input('txt_cp_number'),
			'm55_status' => $request->input('dd_status')
		);
		DB::table('m55_coupon')->where('m55_coupon_id',$id)->update($arr);
		Session::flash('cpadd_msg','COUPON UPDATED SUCCESSFULLY');
        Session::flash('type','success');
		return redirect('/coupon');
	}

	public function view_coupon($id)
	{
		$single_bill = DB::select("SELECT * FROM coupon WHERE CP_ID=".$id."");
		return view('Profile.view_coupon',compact('single_bill'));
	}


	public function reward_history()
			{
				$user_reward = DB::select("SELECT * FROM user_reward where STATUS <>'PENDING'");
				return view('Profile.reward_history',compact('user_reward'));
			}	

	public function change_reward_status()
	{
		$request = request();
		$id = $request->txt_reward_id;
		$reward = DB::select("SELECT * FROM user_reward WHERE RWD_ID=".$id."");

		$arr = array(
			'tr40_status' => $request->txt_status,
			'tr40_remark'=> $request->txt_reward_remarks
			);
		DB::table('tr40_user_reward')->where('tr40_user_reward_id', $id)->update($arr);


		Session::flash('rwacc_msg','REWARD ACCEPTED SUCCESSFULLY' );
        Session::flash('type','success' );

		return redirect('/reward_history');
	}



	public function transaction_history(Request $request)
	{
	    $from = $request->input('from_date') ?? Carbon::now()->startOfMonth()->toDateString();
	    $to   = $request->input('to_date') ?? Carbon::now()->toDateString();
	    $txnType = $request->input('dd_txn_type'); 
    	$txnId     = $request->input('txt_trans_id');
    	$txnHash     = $request->input('txt_trans_hash');
    	$memberCode     = $request->input('txt_membercode');

    	$memberInfo = Helper::get_userid($memberCode??'0');

	    $query = DB::table('coin_buysell_detail');

	    if ($from && $to) {
	        $query->whereBetween('TXN_ONADD', [$from, $to]);
	    } elseif ($from) {
	        $query->whereDate('TXN_ONADD', $from);
	    }

	    if (!empty($txnStatus)) {
	        $query->where('SERVICE_ID', $txnType);
	    }

	    if (!empty($txnId)) {
	        $query->where('TRANS_ID', $txnId);
	    }

	    if (!empty($txnHash)) {
	        $query->where('API_TXNID', $txnId);
	    }

	    if (!empty($txnHash)) {
	        $query->where('API_TXNID', $txnId);
	    }

	    if($memberInfo != false) {
	    	$query->where('USER_ID', $memberInfo);
	    	$total_buy_coin = DB::table('coin_buysell_detail')->where('USER_ID', $memberInfo)->where('SERVICE_ID','BUY')->where('TXN_STATUS','SUCCESS')->sum('TXN_COIN_UNIT');
		    $total_sell_coin = DB::table('coin_buysell_detail')->where('USER_ID', $memberInfo)->where('SERVICE_ID','SELL')->where('TXN_STATUS','SUCCESS')->sum('TXN_COIN_UNIT');
		    $total_coin = DB::table('coin_buysell_detail')->where('USER_ID', $memberInfo)->sum('TXN_COIN_UNIT');
		} else {
			$total_buy_coin = DB::table('coin_buysell_detail')->where('SERVICE_ID','BUY')->where('TXN_STATUS','SUCCESS')->sum('TXN_COIN_UNIT');
		    $total_sell_coin = DB::table('coin_buysell_detail')->where('SERVICE_ID','SELL')->where('TXN_STATUS','SUCCESS')->sum('TXN_COIN_UNIT');
		    $total_coin = DB::table('coin_buysell_detail')->sum('TXN_COIN_UNIT');
		}

	    $data = $query->get();



        $user = Helper::get_userdetail(Session::get('USER_ID'));
		return view('Profile.transaction_history',compact('user','data','total_buy_coin','total_sell_coin','total_coin'));
	}

	
	public function chnage_status_coin_transaction(Request $request)
	{
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$data = DB::table('coin_buysell_detail')->where('COIN_BUYSELL_ID', $request->txt_requestid)->where('TXN_STATUS','PENDING')->first();


		if($data && $request->txt_status == "APPROVED") {

			DB::table('tr53_coin_buysell_detail')->where('tr53_coin_buysell_id', $request->txt_requestid)->update([
				"tr53_txn_status" => "SUCCESS",
				"tr53_txn_number" => $request->txt_txn_hash,
				"tr53_api_txnid" => $request->txt_txn_hash,
				"tr53_remarks" => $request->txt_adminreply
			]);
			Session::flash('message','Transaction verify successfully' );
        	Session::flash('type','success' );
        	return redirect('/transaction_history_list');
		} else if($data && $request->txt_status == "CANCELED") {
			DB::table('tr53_coin_buysell_detail')->where('tr53_coin_buysell_id', $request->txt_requestid)->update([
				"tr53_txn_status" => "REJECT",
				"tr53_txn_number" => $request->txt_txn_hash,
				"tr53_api_txnid" => $request->txt_txn_hash,
				"tr53_remarks" => $request->txt_adminreply
			]);
			Session::flash('message','Transaction is canceled' );
        	Session::flash('type','error' );
        	return redirect('/transaction_history_list');
		} else {
			Session::flash('message','Transaction already verified.' );
        	Session::flash('type','error' );
        	return redirect('/transaction_history_list');
		}

	}



}