<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\ProductModule\Categories\CategoriesRepository;
use App\Repositories\ProductModule\Brand\BrandRepository;
use App\Repositories\ProductModule\Products\ProductsRepository;
use App\Repositories\ProductModule\Optiongroup\OptiongroupRepository;
use App\Repositories\ProductModule\Unit\UnitRepository;
use App\Repositories\Affiliate\AffiliateRepository;
use App\Repositories\ProductModule\ParentCategories\ParentCategoriesRepository;
use App\Repositories\ProductModule\ProductVariant\ProductVariantRepository;
use App\Repositories\ProductModule\Market\MarketRepository;
use App\Repositories\ProductModule\OptionType\OptionTypeRepository;
use DB;
use Image;
use Session;
use Helper;

class ProductController extends Controller
{
	private $cat_repo;
	private $brand_repo;
	private $prod_repo;
	private $optgrp_repo;
    private $unit_repo;
	private $Affiliate_repo;
	private $market_repo;
    private $parentcat_repo;
	private $prod_varnt;
    private $optype_repo;

	public function __construct(CategoriesRepository $cat_repo, BrandRepository $brand_repo,
		ProductsRepository $prod_repo, OptiongroupRepository $optgrp_repo, 
        UnitRepository $unit_repo, AffiliateRepository $Affiliate_repo, MarketRepository $market_repo,
        ParentCategoriesRepository $parentcat_repo, ProductVariantRepository $prod_varnt,
         OptionTypeRepository $optype_repo)
	{
		$this->cat_repo = $cat_repo;
		$this->brand_repo = $brand_repo;
		$this->prod_repo = $prod_repo;
		$this->optgrp_repo = $optgrp_repo;
        $this->unit_repo = $unit_repo;
		$this->Affiliate_repo = $Affiliate_repo;
		$this->market_repo = $market_repo;
        $this->parentcat_repo = $parentcat_repo;
		$this->prod_varnt = $prod_varnt;
        $this->optype_repo = $optype_repo;
	}
    
	 /**
        * Method name   : parent cat
        * @description  : Used for viewing all parent categories
        * @param        : Request data  
        * @return       : return view with all parent categories
    */
	public function parent_cat($id="")
    {
        $single_parentcat = "";
        $all_parentcat = $this->parentcat_repo->getAll();
        if($id!="")
        {
            $single_parentcat = $this->parentcat_repo->getById($id);
        }
        return view('Product.parent_cat',compact('all_parentcat','single_parentcat'));
    }

    /**
        * Method name   : add parent cat
        * @description  : Used for creating parent category
        * @param        : Request data  
        * @return       : return view with created parent category
    */
    public function add_parentcat()
    {
        $request = request();

        if( $request->hasFile('txt_image')){
            $image = $request->file('txt_image');
            $name1 = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/parentcat_logo/');
            $FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)) {
                $image->move($destinationPath, $name1);
            }
            else{
                $request_data=json_encode($request->all());
                $file_type=$image->getClientOriginalName();
                $user_id=Session::get('USER_ID');
                $server_info=json_encode(request()->server());
                $user_info=json_encode(SESSION()->all()['result'][0]);
                $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
				Session::flash('pcat_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
				Session::flash('type','danger' );
                return back(); 
            }
            $txt_image=$name1;
        }
        else
        {
            $txt_image = "";
        }

        $arr = array(
            'm39_name' => $request->input('txt_catname'),
            'm39_desc' => $request->input('txt_desc'),
            'm39_image' => $txt_image,
            'm39_status' => $request->input('dd_status'),
            'm39_created_by' => 1,
            'm39_created_by_id' => Session::get('USER_ID')
        );
        $this->parentcat_repo->create($arr);

		Session::flash('pcat_msg','PARENT CATEGORY CREATED SUCCESSFULLY' );
        Session::flash('type','success' );

        return redirect('/parent_cat');
    }

    /**
        * Method name   : Update parent cat
        * @description  : Used for updating parent category
        * @param        : Request data  
        * @return       : return view with updated parent category
    */
    public function update_parentcat($id)
    {
        $request = request();

        if( $request->hasFile('txt_image')){
            $image = $request->file('txt_image');
            $name1 = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/parentcat_logo/');
            $FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)) {
                $image->move($destinationPath, $name1);
            }
            else{
                $request_data=json_encode($request->all());
                $file_type=$image->getClientOriginalName();
                $user_id=Session::get('USER_ID');
                $server_info=json_encode(request()->server());
                $user_info=json_encode(SESSION()->all()['result'][0]);
                $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
                Session::flash('pcat_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
				Session::flash('type','danger' );
                return back(); 
            }
            $txt_image=$name1;
        }
        else
        {
            $txt_image = $request->input('txt_oldimage');
        }

        $arr = array(
            'm39_name' => $request->input('txt_catname'),
            'm39_desc' => $request->input('txt_desc'),
            'm39_image' => $txt_image,
            'm39_status' => $request->input('dd_status')
        );

        $this->parentcat_repo->update($id, $arr);

		Session::flash('pcat_msg','PARENT CATEGORY UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );

        return redirect('/parent_cat');
    }

     /**
        * Method name   : View category
        * @description  : Used for viewing all categories
        * @param        : Request data  
        * @return       : return view with all categories
    */
	public function view_category($id = "")
    {
    	$single_cat = "";
        $categories = $this->cat_repo->getAllCategory();
    	$all_parentcat = $this->parentcat_repo->getAll();
    	if($id != ""){
    		$single_cat = $this->cat_repo->getById($id);
    	}
		return view('Product.category', compact('categories', 'single_cat', 'all_parentcat'));
	}

	/**
        * Method name   : Create category
        * @description  : Used for creating category
        * @param        : Request data  
        * @return       : return view with created category
    */
	public function create_category()
    {
    	$request = request();

    	if( $request->hasFile('txt_image')){
            $image = $request->file('txt_image');
            $name1 = time().'1.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/cat_logo/');
			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name1);
			}
			else{
				$request_data=json_encode($request->all());
				$file_type=$image->getClientOriginalName();
				$user_id=Session::get('USER_ID');
				$server_info=json_encode(request()->server());
				$user_info=json_encode(SESSION()->all()['result'][0]);
				$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
				Session::flash('cat_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
				Session::flash('type','danger' );
				return back(); 
			}
            $txt_image=$name1;
        }
        else
        {
            $txt_image = "";
        }



        if( $request->hasFile('txt_image_app')){
            $image = $request->file('txt_image_app');
            $name2 = time().'2.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/cat_logo/');
            $FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)) {
                $image->move($destinationPath, $name2);
            }
            else{
                $request_data=json_encode($request->all());
                $file_type=$image->getClientOriginalName();
                $user_id=Session::get('USER_ID');
                $server_info=json_encode(request()->server());
                $user_info=json_encode(SESSION()->all()['result'][0]);
                $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
                Session::flash('cat_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
                Session::flash('type','danger' );
                return back(); 
            }
            $txt_image2=$name2;
        }
        else
        {
            $txt_image2 = "";
        }

    	$arr = array(
    		'm36_shopping_for' => $request->input('dd_shopfor'),
    		'm36_cat_name' => $request->input('txt_catname'),
    		'm36_parent_id' => 0,
    		'm36_cat_desc' => $request->input('txt_desc'),
    		'm36_cat_image' => $txt_image,
            'm36_cat_image_app' => $txt_image2,
    		'm36_status' => $request->input('dd_status'),
    		'm36_created_by' => 2,
    		'm36_created_by_id' => Session::get('USER_ID')
    		);
    	$this->cat_repo->create($arr);

		Session::flash('cat_msg','CATEGORY CREATED SUCCESSFULLY' );
        Session::flash('type','success' );

    	return redirect('/categories');
	}

	/**
        * Method name   : Update category
        * @description  : Used for updating category
        * @param        : Request data  
        * @return       : return view with updated category
    */
	public function update_category($id)
    {
    	$request = request();

    	if( $request->hasFile('txt_image')){
            $image = $request->file('txt_image');
            $name1 = time().'1.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/cat_logo/');
			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name1);
			}
			else{
				$request_data=json_encode($request->all());
				$file_type=$image->getClientOriginalName();
				$user_id=Session::get('USER_ID');
				$server_info=json_encode(request()->server());
				$user_info=json_encode(SESSION()->all()['result'][0]);
				$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
				Session::flash('cat_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
				Session::flash('type','danger' );
				return back(); 
			}
            $txt_image=$name1;
        }
        else
        {
            $txt_image = $request->input('txt_oldimage');
        }


        if( $request->hasFile('txt_image_app')){
            $image = $request->file('txt_image_app');
            $name2 = time().'2.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/cat_logo/');
            $FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)) {
                $image->move($destinationPath, $name2);
            }
            else{
                $request_data=json_encode($request->all());
                $file_type=$image->getClientOriginalName();
                $user_id=Session::get('USER_ID');
                $server_info=json_encode(request()->server());
                $user_info=json_encode(SESSION()->all()['result'][0]);
                $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
                Session::flash('cat_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
                Session::flash('type','danger' );
                return back(); 
            }
            $txt_image2=$name2;
        }
        else
        {
            $txt_image2 = $request->input('txt_oldimage_app');
        }

    	$arr = array(
    		'm36_shopping_for' => $request->input('dd_shopfor'),
    		'm36_cat_name' => $request->input('txt_catname'),
    		'm36_parent_id' => 0,
    		'm36_cat_desc' => $request->input('txt_desc'),
    		'm36_cat_image' => $txt_image,
            'm36_cat_image_app' => $txt_image2,
    		'm36_status' => $request->input('dd_status')
    		);

    	$this->cat_repo->update($id, $arr);

		Session::flash('cat_msg','CATEGORY UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );

    	return redirect('/categories');
	}

	/**
        * Method name   : Category status
        * @description  : Used for changing category status
        * @param        : Request data  
        * @return       : return view with changed category status
    */
	public function category_status()
    {
    	$request = request();
    	$id = $request->input('txt_catid');
    	$this->cat_repo->active($id);
    	return redirect('/categories');
	}

         /**
        * Method name   : View subcategory
        * @description  : Used for viewing all sub categories
        * @param        : Request data  
        * @return       : return view with all sub categories
    */
    public function view_subcategory($id = "")
    {
        $single_cat = "";
        $categories = $this->cat_repo->getAllCategory();
        $sub_categories = $this->cat_repo->getAllSubCategory();
        if($id != ""){
            $single_cat = $this->cat_repo->getById($id);
        }
        return view('Product.subcategory', compact('categories', 'sub_categories', 'single_cat'));
    }

    /**
        * Method name   : Create sub category
        * @description  : Used for creating sub category
        * @param        : Request data  
        * @return       : return view with created sub category
    */
    public function create_subcategory()
    {
        $request = request();

        if( $request->hasFile('txt_image')){
            $image = $request->file('txt_image');
            $name1 = time().'1.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/cat_logo/');
			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name1);
			}
			else{
				$request_data=json_encode($request->all());
				$file_type=$image->getClientOriginalName();
				$user_id=Session::get('USER_ID');
				$server_info=json_encode(request()->server());
				$user_info=json_encode(SESSION()->all()['result'][0]);
				$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
				Session::flash('scat_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
				Session::flash('type','danger' );
				return back(); 
			}
            $txt_image=$name1;
        }
        else
        {
            $txt_image = "";
        }



        if( $request->hasFile('txt_image_app')){
            $image = $request->file('txt_image_app');
            $name2 = time().'2.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/cat_logo/');
            $FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)) {
                $image->move($destinationPath, $name2);
            }
            else{
                $request_data=json_encode($request->all());
                $file_type=$image->getClientOriginalName();
                $user_id=Session::get('USER_ID');
                $server_info=json_encode(request()->server());
                $user_info=json_encode(SESSION()->all()['result'][0]);
                $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
                Session::flash('cat_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
                Session::flash('type','danger' );
                return back(); 
            }
            $txt_image2=$name2;
        }
        else
        {
            $txt_image2 = "";
        }


        $arr = array(
			'm36_shopping_for' => 0,
            'm36_cat_name' => $request->input('txt_catname'),
            'm36_parent_id' => $request->input('dd_cat'),
            'm36_cat_desc' => $request->input('txt_desc'),
            'm36_cat_image' => $txt_image,
            'm36_cat_image_app' => $txt_image2,
            'm36_status' => $request->input('dd_status'),
            'm36_created_by' => 2,
            'm36_created_by_id' => Session::get('USER_ID')
            );
        $this->cat_repo->create($arr);

		Session::flash('scat_msg','SUB CATEGORY ADDED SUCCESSFULLY' );
        Session::flash('type','success' );
		
        return redirect('/sub_categories');
    }

    /**
        * Method name   : Update sub category
        * @description  : Used for updating sub category
        * @param        : Request data  
        * @return       : return view with updated sub category
    */
    public function update_subcategory($id)
    {
        $request = request();

        if( $request->hasFile('txt_image')){
            $image = $request->file('txt_image');
            $name1 = time().'1.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/cat_logo/');
			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name1);
			}
			else{
				$request_data=json_encode($request->all());
				$file_type=$image->getClientOriginalName();
				$user_id=Session::get('USER_ID');
				$server_info=json_encode(request()->server());
				$user_info=json_encode(SESSION()->all()['result'][0]);
				$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
				Session::flash('scat_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
				Session::flash('type','danger' );
				return back(); 
			}
            $txt_image=$name1;
        }
        else 
        {
            $txt_image = $request->input('txt_oldimage');
        }



        if( $request->hasFile('txt_image_app')){
            $image = $request->file('txt_image_app');
            $name2 = time().'2.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/cat_logo/');
            $FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)) {
                $image->move($destinationPath, $name2);
            }
            else{
                $request_data=json_encode($request->all());
                $file_type=$image->getClientOriginalName();
                $user_id=Session::get('USER_ID');
                $server_info=json_encode(request()->server());
                $user_info=json_encode(SESSION()->all()['result'][0]);
                $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
                Session::flash('cat_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
                Session::flash('type','danger' );
                return back(); 
            }
            $txt_image2=$name2;
        }
        else
        {
            $txt_image2 = $request->input('txt_oldimage_app');
        }


        $arr = array(
			'm36_shopping_for' => 0,
            'm36_cat_name' => $request->input('txt_catname'),
            'm36_parent_id' => $request->input('dd_cat'),
            'm36_cat_desc' => $request->input('txt_desc'),
            'm36_cat_image' => $txt_image,
            'm36_cat_image_app' => $txt_image2,
            'm36_status' => $request->input('dd_status')
            );
        $this->cat_repo->update($id, $arr);

		Session::flash('scat_msg','SUB CATEGORY UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );

        return redirect('/sub_categories');
    }

    /**
        * Method name   : Sub category status
        * @description  : Used for changing sub category status
        * @param        : Request data  
        * @return       : return view with changed sub category status
    */
    public function subcategory_status()
    {
        $request = request();
        $id = $request->input('txt_catid');
        $this->cat_repo->active($id);
        return redirect('/sub_categories');
    }


    /**
        * Method name   : View brand
        * @description  : Used for viewing all sub brand
        * @param        : Request data  
        * @return       : return view with all brands
    */
    public function view_brand($id = "")
    {
        $single_brand = "";
        $brands = $this->brand_repo->getAll();
        if($id != ""){
            $single_brand = $this->brand_repo->getById($id);
        }
        return view('Product.brand', compact('brands','single_brand'));
    }

    /**
        * Method name   : Create brand
        * @description  : Used for creating brand
        * @param        : Request data  
        * @return       : return view with created brand
    */
    public function create_brand()
    {
        $request = request();

        if( $request->hasFile('txt_image')){
            $image = $request->file('txt_image');
            $name1 = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/brand_logo/');
			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name1);
			}
			else{
				$request_data=json_encode($request->all());
				$file_type=$image->getClientOriginalName();
				$user_id=Session::get('USER_ID');
				$server_info=json_encode(request()->server());
				$user_info=json_encode(SESSION()->all()['result'][0]);
				$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
				Session::flash('brand_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
				Session::flash('type','danger' );
				return back(); 
			}
            $txt_image=$name1;
        }
        else
        {
            $txt_image = "";
        }

        $arr = array(
            'm34_brand_name' => $request->input('txt_name'),
            'm34_brand_desc' => $request->input('txt_desc'),
            'm34_brand_image' => $txt_image,
            'm34_brand_status' => $request->input('dd_status'),
            'm34_created_by' => 2,
            'm34_created_by_id' => Session::get('USER_ID')
        );
        $this->brand_repo->create($arr);

		Session::flash('brand_msg','BRAND CREATED SUCCESSFULLY' );
        Session::flash('type','success' );

        return redirect('/brand');
    }

    /**
        * Method name   : Update brand
        * @description  : Used for updating brand
        * @param        : Request data  
        * @return       : return view with updated brand
    */
    public function update_brand($id)
    {
        $request = request();

        if( $request->hasFile('txt_image')){
            $image = $request->file('txt_image');
            $name1 = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/brand_logo/');
			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name1);
			}
			else{
				$request_data=json_encode($request->all());
				$file_type=$image->getClientOriginalName();
				$user_id=Session::get('USER_ID');
				$server_info=json_encode(request()->server());
				$user_info=json_encode(SESSION()->all()['result'][0]);
				$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info); 
				Session::flash('brand_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
				Session::flash('type','danger' );
				return back(); 
			}
            $txt_image=$name1;
        }
        else
        {
            $txt_image = $request->input('txt_oldimage');
        }

        $arr = array(
            'm34_brand_name' => $request->input('txt_name'),
            'm34_brand_desc' => $request->input('txt_desc'),
            'm34_brand_image' => $txt_image,
            'm34_brand_status' => $request->input('dd_status')
        );
        $this->brand_repo->update($id, $arr);

		Session::flash('brand_msg','BRAND UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );

        return redirect('/brand');
    }

    /**
        * Method name   : Brand status
        * @description  : Used for changing sub category status
        * @param        : Request data  
        * @return       : return view with changed sub category status
    */
    public function brand_status()
    {
        $request = request();
        $id = $request->input('txt_brandid');
        $this->brand_repo->active($id);
        return redirect('/brand');
    }

    /**
        * Method name   : View option
        * @description  : Used for viewing all options
        * @param        : Request data  
        * @return       : return view with all options
    */
    public function view_option($id = "")
    {
        $single_option = "";
        $options = $this->optgrp_repo->getAll();
        if($id != ""){
            $single_option = $this->optgrp_repo->getById($id);
        }
        return view('Product.option', compact('options','single_option'));
    }

    /**
        * Method name   : Create option
        * @description  : Used for creating option
        * @param        : Request data  
        * @return       : return view with created option
    */
    public function create_option()
    {
        $request = request();

        $arr = array(
            'm35_group_name' => $request->input('txt_grname'),
            'm35_status' => 1,
            'm35_created_by' => 2,
            'm35_created_by_id' => Session::get('USER_ID')
        );
        $this->optgrp_repo->create($arr);

		Session::flash('grp_msg','GROUP ADDED SUCCESSFULLY' );
        Session::flash('type','success' );

        return redirect('/option');
    }

    /**
        * Method name   : Update option
        * @description  : Used for updating option
        * @param        : Request data  
        * @return       : return view with updated option
    */
    public function update_option($id)
    {
        $request = request();

        $arr = array(
            'm35_group_name' => $request->input('txt_grname'),
            'm35_status' => 1
        );
        $this->optgrp_repo->update($id, $arr);

		Session::flash('grp_msg','GROUP UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );

        return redirect('/option');
    }

    /**
        * Method name   : Option status
        * @description  : Used for changing option status
        * @param        : Request data  
        * @return       : return view with changed option status
    */
    public function option_status()
    {
        $request = request();
        $id = $request->input('txt_optid');
        $this->optgrp_repo->active($id);
        return redirect('/option');
    }

    /**
        * Method name   : View option type
        * @description  : Used for view option types
        * @param        : Request data  
        * @return       : return view with all option types
    */
    public function view_option_type($id = "")
    {
        $single_option_name = "";
        $options = $this->optgrp_repo->getAll();
        $option_name = $this->optype_repo->getAll();
        if($id != ""){
            $single_option_name = $this->optype_repo->getById($id);
        }
        return view('Product.group_name', compact('options','option_name','single_option_name'));
    }

    /**
        * Method name   : Create option
        * @description  : Used for creating option
        * @param        : Request data  
        * @return       : return view with created option
    */
    public function create_option_type()
    {
        $request = request();

        $this->validate($request, [
            'dd_option'=> 'required',
            'txt_grname' => 'required',
            'dd_status' => 'required'
        ],[
            'dd_option.required'=> 'Option is required',
            'txt_grname.string'=> 'Group Name is required',
            'dd_status.required'=> 'Status is required'
        ]);

        $arr = array(
            'm35_group_id' => $request->input('dd_option'),
            'm75_ot_name' => $request->input('txt_grname'),
            'm75_created_by' => 1,
            'm75_created_by_id' => Session::get('USER_ID'),
            'm75_status' => $request->input('dd_status')
        );
        $this->optype_repo->create($arr);

        Session::flash('grpname_msg','GROUP NAME ADDED SUCCESSFULLY' );
        Session::flash('type','success' );

        return redirect('/option_type');
    }

    /**
        * Method name   : Update option
        * @description  : Used for updating option
        * @param        : Request data  
        * @return       : return view with updated option
    */
    public function update_option_type($id)
    {
        $request = request();

        $this->validate($request, [
            'dd_option'=> 'required',
            'txt_grname' => 'required',
            'dd_status' => 'required'
        ],[
            'dd_option.required'=> 'Option is required',
            'txt_grname.string'=> 'Group Name is required',
            'dd_status.required'=> 'Status is required'
        ]);

        $arr = array(
            'm35_group_id' => $request->input('dd_option'),
            'm75_ot_name' => $request->input('txt_grname'),
            'm75_status' => $request->input('dd_status')
        );
        $this->optype_repo->update($id, $arr);

        Session::flash('grpname_msg','GROUP NAME UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );


        return redirect('/option_type');
    }


    /**
        * Method name   : View unit
        * @description  : Used for viewing all units
        * @param        : Request data  
        * @return       : return view with all units
    */
    public function view_unit($id = "")
    {
        $single_unit = "";
        $units = $this->unit_repo->getAll();
        if($id != ""){
            $single_unit = $this->unit_repo->getById($id);
        }
        return view('Product.unit', compact('units','single_unit'));
    }

    /**
        * Method name   : Create unit
        * @description  : Used for creating unit
        * @param        : Request data  
        * @return       : return view with created unit
    */
    public function create_unit()
    {
        $request = request();

        $arr = array(
            'm37_unit_name' => $request->input('txt_name'),
            'm37_unit_value' => $request->input('txt_val'),
            'm37_unit_desc' => $request->input('txt_desc'),
            'm37_status' => $request->input('dd_status'),
            'm37_created_by' => 2,
            'm37_created_by_id' => Session::get('USER_ID')
        );
        $this->unit_repo->create($arr);

		Session::flash('unit_msg','UNIT ADDED SUCCESSFULLY' );
        Session::flash('type','success' );

        return redirect('/unit');
    }

    /**
        * Method name   : Update unit
        * @description  : Used for updating unit
        * @param        : Request data  
        * @return       : return view with updated unit
    */
    public function update_unit($id)
    {
        $request = request();

        $arr = array(
            'm37_unit_name' => $request->input('txt_name'),
            'm37_unit_value' => $request->input('txt_val'),
            'm37_unit_desc' => $request->input('txt_desc'),
            'm37_status' => $request->input('dd_status')
        );
        $this->unit_repo->update($id, $arr);

		Session::flash('unit_msg','UNIT UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );

        return redirect('/unit');
    }

    /**
        * Method name   : Unit status
        * @description  : Used for changing unit status
        * @param        : Request data  
        * @return       : return view with changed unit status
    */
    public function unit_status()
    {
        $request = request();
        $id = $request->input('txt_unitid');
        $this->unit_repo->active($id);
        return redirect('/unit');
    }

   /**
        * Method name   : View unit
        * @description  : Used for viewing all units
        * @param        : Request data  
        * @return       : return view with all units
    */
    public function view_product()
    {
        $categories = $this->cat_repo->getAllCategory();
        $brands = $this->brand_repo->getAll();
        $products = $this->prod_repo->getAll();
        $units = $this->unit_repo->getAll();
        $option = $this->optgrp_repo->getAll();
        return view('Product.product_listing', compact('categories', 'brands', 'units', 'option', 'products'));
    }

   /**
        * Method name   : View unit
        * @description  : Used for viewing all units
        * @param        : Request data  
        * @return       : return view with all units
    */
    public function create_prod()
    {
        $affiliates = $this->Affiliate_repo->getAll();
        $all_parentcat = $this->parentcat_repo->getAll();
        $categories = $this->cat_repo->getAllCategory();
        $brands = $this->brand_repo->getAll();
        $products = $this->prod_repo->getAll();
        $units = $this->unit_repo->getAll();
        $option = $this->optgrp_repo->getAll();
		$markets = $this->market_repo->getAll();
        return view('Product.product', compact('all_parentcat','affiliates','categories', 'brands', 'units', 'option', 'products','markets'));
    }

    /**
        * Method name   : View unit
        * @description  : Used for viewing all units
        * @param        : Request data  
        * @return       : return view with all units
    */
    public function edit_product($id = "")
    {
        $affiliates = $this->Affiliate_repo->getAll();
        $all_parentcat = $this->parentcat_repo->getAll();
        $categories = $this->cat_repo->getAllCategory();
        $brands = $this->brand_repo->getAll();
        $units = $this->unit_repo->getAll();
        $option = $this->optgrp_repo->getAll();
        $single_product = $this->prod_repo->getById($id);
        $sub_category = $this->cat_repo->getById($single_product[0]->PROD_CATID);
        $cat = $this->cat_repo->getById($sub_category[0]->CAT_PARENTID);
        $parent_cat = $this->parentcat_repo->getById($cat[0]->SHOPPING_FOR);
        $sub_cat = $this->cat_repo->getSubCategoryByParent($sub_category[0]->CAT_PARENTID);
        $markets = $this->market_repo->getAll();
        $option_name = $this->optype_repo->getAll();
        $images = explode(',', $single_product[0]->PROD_IMAGE);
        return view('Product.edit_product', compact('affiliates','all_parentcat','categories', 'brands', 'units', 'option','single_product','sub_category','cat','parent_cat','markets','sub_cat','option_name','images'));
    }

    /**
        * Method name   : Create unit
        * @description  : Used for creating unit
        * @param        : Request data  
        * @return       : return view with created unit
    */
    public function create_product()
    {
        $request = request();


       if($request->hasFile('txt_img')){
            $files = $request->file('txt_img');
            $img_arr = array();
            $FileType = array('jpeg','png','jpg');
            foreach($files as $key => $image){
                $name1 = time().$key.'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/images/prod_logo/');
                $img_arr[] = $name1;
                if(in_array($image->getClientOriginalExtension(), $FileType)) {
                    $image->move($destinationPath, $name1);
                }
                else{
                    $request_data=json_encode($request->all());
                    $file_type=$image->getClientOriginalName();
                    $user_id=Session::get('USER_ID');
                    $server_info=json_encode(request()->server());
                    $user_info=json_encode(SESSION()->all()['result'][0]);
                    $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
                    Session::flash('uproduct_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
                    Session::flash('type','danger' );
                    return back();
                }

            }
            $txt_image=implode(',', $img_arr);
        }
        else
        {
            $txt_image = '';
        }

        $this->validate($request, [
            'txt_prodname'=> 'required|string|max:255|unique:m33_products,m33_name',
            'txt_skuid'=> 'required|string|max:100|unique:m33_products,m33_sku_id',
            'txt_prodmeta' => 'required|string|max:255',
            'dd_cat' => 'required',
            'dd_subcat'=> 'required',
            'dd_brand' => 'required',
            'txt_cgst' => 'required|numeric',
            'txt_sgst' => 'required|numeric',
            'txt_igst' => 'required|numeric',
            'txt_price' => 'required|numeric',
            'txt_discprice'=> 'required|numeric',
			'txt_delivery_fee'=> 'required|numeric',
            'txt_desc' => 'nullable|string|max:500',
            'dd_option1' => 'numeric|nullable',
            'dd_optype1' => 'numeric|nullable',
            'dd_option2' => 'numeric|nullable',
            'dd_optype2' => 'numeric|nullable',
            'txt_capacity'=> 'required',
            'dd_unit' => 'required',
            'txt_stock' => 'required',
            'dd_market'=> 'required',
            'rb_featured' => 'numeric|nullable',
            'rb_deliverable' => 'numeric|nullable',
            'dd_status' => 'required',
			'dd_affiliate' => 'required'
        ],[
            'txt_prodname.required'=> 'Product name is required',
            'txt_prodname.string'=> 'Product name should contains string only',
            'txt_prodname.unique'=> 'Product name should be unique',
            'txt_skuid.required'=> 'Product sku id is required',
            'txt_skuid.alpha_num'=> 'Product sku id should contains alpha numeric only',
            'txt_skuid.unique'=> 'Product sku id should be unique',
            'txt_prodmeta.required'=> 'Product meta is required',
            'txt_prodmeta.string'=> 'Product meta should contains string only',
            'dd_cat.required'=> 'Category is required',
            'dd_subcat.required'=> 'Sub-Category is required',
            'dd_brand.required'=> 'Brand is required',
            'txt_cgst.required'=> 'GST amount is required',
            'txt_cgst.numeric'=> 'GST amount should be numeric',
            'txt_sgst.required'=> 'SGST amount is required',
            'txt_sgst.numeric'=> 'SGST amount should be numeric',
            'txt_igst.required'=> 'IGST amount is required',
            'txt_igst.numeric'=> 'IGST amount should be numeric',
            'txt_price.required'=> 'Price is required',
            'txt_price.numeric'=> 'Price should be numeric',
            'txt_discprice.required'=> 'Discount Price is required',
            'txt_discprice.required'=> 'Discount Price should be numeric',
			'txt_delivery_fee.required'=> 'Discount Price is required',
            'txt_delivery_fee.required'=> 'Discount Price should be numeric',
            'txt_desc.string'=> 'Description should contains string only',
            'dd_option1.numeric'=> 'Option is required',
            'dd_optype1.numeric'=> 'Option Type is required',
            'dd_option2.numeric'=> 'Option is required',
            'dd_optype2.numeric'=> 'Option Type is required',
            'txt_capacity.required'=> 'Capacity is required',
            'dd_unit.required'=> 'Unit is required',
            'txt_stock.required'=> 'Stock is required',
            'dd_market.required'=> 'Market is required',
            'rb_featured.numeric'=> 'Featured is required',
            'rb_deliverable.numeric'=> 'Deliverable is required',
            'dd_status.required'=> 'Status is required',
			'dd_affiliate.required'=> 'Status is required'
        ]);

        if($request->input('rb_featured') != null){
            $rb_featured = 1;
        }else{
            $rb_featured = 2;
        }

        if($request->input('rb_deliverable') != null){
            $rb_deliverable = 1;
        }else{
            $rb_deliverable = 2;
        }

        if($request->input('is_variation') != null){
            $is_variation = 1;
        }else{
            $is_variation = 2;
        }

        $prod_code = 'PC'.rand(0000,9999);

        $arr = array(
            'm22_affiliate_id' => $request->input('dd_affiliate'),
            'm33_name' => $request->input('txt_prodname'),
            'm33_sku_id' => $request->input('txt_skuid'),
            'm33_product_code' => $prod_code,
            'm34_brand_id' => $request->input('dd_brand'),
            'm33_image' => $txt_image,
            'm33_prod_meta' => $request->input('txt_prodmeta'),
            'm33_prod_cgst' => $request->input('txt_cgst'),
            'm33_prod_sgst' => $request->input('txt_sgst'),
            'm33_prod_igst' => $request->input('txt_igst'),
            'm33_price' => $request->input('txt_price'),
            'm33_disc_price' => $request->input('txt_discprice'),
			'm33_delivery_fee' => $request->input('txt_delivery_fee'),
            'm33_desc' => $request->input('txt_desc'),
            'm35_group_id' => $request->input('dd_option1'),
            'm75_option_type_id' => $request->input('dd_optype1'),
            'm35_group_id2' => $request->input('dd_option2'),
            'm75_option_type_id2' => $request->input('dd_optype2'),
            'm33_capacity' => $request->input('txt_capacity'),
            'm37_unit_id' => $request->input('dd_unit'),
            'm33_stock' => $request->input('txt_stock'),
            'm46_market_id' => $request->input('dd_market'),
            'm36_cat_id' =>  $request->input('dd_subcat'),
            'm33_featured' => $rb_featured,
            'm33_deliverable' => $rb_deliverable,
            'm33_is_variation' => $is_variation,
            'm33_created_by' => 2,
            'm33_created_by_id' => Session::get('USER_ID'),
            'm33_status' => $request->input('dd_status')
        );
        $inserted_id = $this->prod_repo->create($arr);
 
        // $qr_image = \QrCode::format('png')
        //     ->size(500)
        //     ->generate('http://localhost/LatestLetsLaunch/public/view_prod/'.$inserted_id, public_path('qrcodes\\'.str_slug(base64_encode($request->input('txt_prodname'))).'.png'));

    
        // $arr1 = array(
        //     'm33_qr_code' => str_slug(base64_encode($request->input('txt_prodname'))).'.png'
        // );

        // $this->prod_repo->update($inserted_id, $arr1);

        Session::flash('product_msg','PRODUCT ADDED SUCCESSFULLY' );
        Session::flash('type','success' );

        return redirect('/create_prod');
    }

    /**
        * Method name   : Update unit
        * @description  : Used for updating unit
        * @param        : Request data  
        * @return       : return view with updated unit
    */
    public function update_product($id)
    {
        $request = request();
        $FileType = array('jpeg','png','jpg');

        $img_arr = array();
//dd($request);
        if( $request->hasFile('txt_img0')){
            $image = $request->file('txt_img0');
            $name1 = time().'0.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/prod_logo/');
            $FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)){
                $image->move($destinationPath, $name1);
            }
            else{
                $request_data=json_encode($request->all());
                $file_type=$image->getClientOriginalName();
                $user_id=Session::get('USER_ID');
                $server_info=json_encode(request()->server());
                $user_info=json_encode(SESSION()->all()['result'][0]);
                $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
                Session::flash('market_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
                Session::flash('type','danger' );
                return back(); 
            }
            $img_arr[] = $name1;
        }
        else
        {
            $img_arr[] = $request->input('txt_old_img0');
        }

        if( $request->hasFile('txt_img1')){
            $image = $request->file('txt_img1');
            $name1 = time().'1.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/prod_logo/');
            $FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)){
                $image->move($destinationPath, $name1);
            }
            else{
                $request_data=json_encode($request->all());
                $file_type=$image->getClientOriginalName();
                $user_id=Session::get('USER_ID');
                $server_info=json_encode(request()->server());
                $user_info=json_encode(SESSION()->all()['result'][0]);
                $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
                Session::flash('market_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
                Session::flash('type','danger' );
                return back(); 
            }
            $img_arr[] = $name1;
        }
        else
        {
            $img_arr[] = $request->input('txt_old_img1');
        }

        if( $request->hasFile('txt_img2')){
            $image = $request->file('txt_img2');
            $name1 = time().'2.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/prod_logo/');
            $FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)){
                $image->move($destinationPath, $name1);
            }
            else{
                $request_data=json_encode($request->all());
                $file_type=$image->getClientOriginalName();
                $user_id=Session::get('USER_ID');
                $server_info=json_encode(request()->server());
                $user_info=json_encode(SESSION()->all()['result'][0]);
                $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
                Session::flash('market_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
                Session::flash('type','danger' );
                return back(); 
            }
            $img_arr[] = $name1;
        }
        else
        {
            $img_arr[] = $request->input('txt_old_img2');
        }

        if( $request->hasFile('txt_img3')){
            $image = $request->file('txt_img3');
            $name1 = time().'3.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/prod_logo/');
            $FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)){
                $image->move($destinationPath, $name1);
            }
            else{
                $request_data=json_encode($request->all());
                $file_type=$image->getClientOriginalName();
                $user_id=Session::get('USER_ID');
                $server_info=json_encode(request()->server());
                $user_info=json_encode(SESSION()->all()['result'][0]);
                $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
                Session::flash('market_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
                Session::flash('type','danger' );
                return back(); 
            }
            $img_arr[] = $name1;
        }
        else
        {
            $img_arr[] = $request->input('txt_old_img3');
        }

        if( $request->hasFile('txt_img4')){
            $image = $request->file('txt_img4');
            $name1 = time().'4.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/prod_logo/');
            $FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)){
                $image->move($destinationPath, $name1);
            }
            else{
                $request_data=json_encode($request->all());
                $file_type=$image->getClientOriginalName();
                $user_id=Session::get('USER_ID');
                $server_info=json_encode(request()->server());
                $user_info=json_encode(SESSION()->all()['result'][0]);
                $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
                Session::flash('market_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
                Session::flash('type','danger' );
                return back(); 
            }
            $img_arr[] = $name1;
        }
        else
        {
            $img_arr[] = $request->input('txt_old_img4');
        }


        $txt_image=implode(',', $img_arr);

          $this->validate($request, [
            'txt_prodname'=> 'required|string|max:255',
            'txt_prodmeta' => 'required|string|max:255',
            'dd_cat' => 'required',
            'dd_subcat'=> 'required',
            'dd_brand' => 'required',
            'txt_cgst' => 'required|numeric',
            'txt_sgst' => 'required|numeric',
            'txt_igst' => 'required|numeric',
            'txt_price' => 'required|numeric',
            'txt_discprice'=> 'required|numeric',
            'txt_delivery_fee'=> 'required|numeric',
            'txt_desc' => 'nullable|string|max:500',
            'dd_option1' => 'numeric|nullable',
            'dd_optype1' => 'numeric|nullable',
            'dd_option2' => 'numeric|nullable',
            'dd_optype2' => 'numeric|nullable',
            'txt_capacity'=> 'required',
            'dd_unit' => 'required',
            'txt_stock' => 'required',
            'dd_market'=> 'required',
            'rb_featured' => 'numeric|nullable',
            'rb_deliverable' => 'numeric|nullable',
            'dd_status' => 'required'
        ],[
            'txt_prodname.required'=> 'Product name is required',
            'txt_prodname.string'=> 'Product name should contains string only',
            'txt_prodmeta.required'=> 'Product meta is required',
            'txt_prodmeta.string'=> 'Product meta should contains string only',
            'dd_cat.required'=> 'Category is required',
            'dd_subcat.required'=> 'Sub-Category is required',
            'dd_brand.required'=> 'Brand is required',
            'txt_cgst.required'=> 'GST amount is required',
            'txt_cgst.numeric'=> 'GST amount should be numeric',
            'txt_sgst.required'=> 'SGST amount is required',
            'txt_sgst.numeric'=> 'SGST amount should be numeric',
            'txt_igst.required'=> 'IGST amount is required',
            'txt_igst.numeric'=> 'IGST amount should be numeric',
            'txt_price.required'=> 'Price is required',
            'txt_price.numeric'=> 'Price should be numeric',
            'txt_discprice.required'=> 'Discount Price is required',
            'txt_discprice.required'=> 'Discount Price should be numeric',
            'txt_delivery_fee.required'=> 'Discount Price is required',
            'txt_delivery_fee.required'=> 'Discount Price should be numeric',
            'txt_desc.string'=> 'Description should contains string only',
            'dd_option1.numeric'=> 'Option is required',
            'dd_optype1.numeric'=> 'Option Type is required',
            'dd_option2.numeric'=> 'Option is required',
            'dd_optype2.numeric'=> 'Option Type is required',
            'txt_capacity.required'=> 'Capacity is required',
            'dd_unit.required'=> 'Unit is required',
            'txt_stock.required'=> 'Stock is required',
            'dd_market.required'=> 'Market is required',
            'rb_featured.numeric'=> 'Featured is required',
            'rb_deliverable.numeric'=> 'Deliverable is required',
            'dd_status.required'=> 'Status is required'
        ]);

        if($request->input('rb_featured') != null){
            $rb_featured = 1;
        }else{
            $rb_featured = 2;
        }

        if($request->input('rb_deliverable') != null){
            $rb_deliverable = 1;
        }else{
            $rb_deliverable = 2;
        }


        if($request->input('is_variation') != null){
            $is_variation = 1;
        }else{
            $is_variation = 2;
        }


        $arr = array(
            'm22_affiliate_id' => $request->input('dd_affiliate'),
            'm33_name' => $request->input('txt_prodname'),
            'm34_brand_id' => $request->input('dd_brand'),
            'm33_image' => $txt_image,
            'm33_prod_meta' => $request->input('txt_prodmeta'),
            'm33_prod_cgst' => $request->input('txt_cgst'),
            'm33_prod_sgst' => $request->input('txt_sgst'),
            'm33_prod_igst' => $request->input('txt_igst'),
            'm33_price' => $request->input('txt_price'),
            'm33_disc_price' => $request->input('txt_discprice'),
            'm33_delivery_fee' => $request->input('txt_delivery_fee'),
            'm33_desc' => $request->input('txt_desc'),
            'm35_group_id' => $request->input('dd_option1'),
            'm75_option_type_id' => $request->input('dd_optype1'),
            'm35_group_id2' => $request->input('dd_option2'),
            'm75_option_type_id2' => $request->input('dd_optype2'),
            'm33_capacity' => $request->input('txt_capacity'),
            'm37_unit_id' => $request->input('dd_unit'),
            'm33_stock' => $request->input('txt_stock'),
            'm46_market_id' => $request->input('dd_market'),
            'm36_cat_id' =>  $request->input('dd_subcat'),
            'm33_featured' => $rb_featured,
            'm33_deliverable' => $rb_deliverable,
            'm33_is_variation' => $is_variation,
            'm33_status' => $request->input('dd_status')
        );
        $this->prod_repo->update($id, $arr);

        Session::flash('uproduct_msg','PRODUCT UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );

        return redirect('/view_prod/'.$id);
    }

    /**
        * Method name   : Unit status
        * @description  : Used for changing unit status
        * @param        : Request data  
        * @return       : return view with changed unit status
    */
    public function product_status()
    {
        $request = request();
        $id = $request->input('txt_prodid');
        $this->prod_repo->active($id);
        return redirect('/products');
    }

	/**
        * Method name   : market listing
        * @description  : Used for getting all market
        * @param        : Request data  
        * @return       : return view with getting all market
    */
	public function market_listing()
    {
        $markets = $this->market_repo->getAll();
        return view('Product.view_market',compact('markets'));
    }


    public function create_market()
    {
        return view('Product.create_market');
    }

    /**
        * Method name   : View unit
        * @description  : Used for viewing all units
        * @param        : Request data  
        * @return       : return view with all units
    */
    public function edit_market($id)
    {
        $markets = $this->market_repo->getById($id);
        //dd($markets);
        return view('Product.edit_market',compact('markets'));
    }

    public function add_market()
    {
        $request = request();
        if( $request->hasFile('txt_image')){
            $image = $request->file('txt_image');
            $name1 = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/market_logo/');
            $FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)){
                $image->move($destinationPath, $name1);
            }
            else{
                $request_data=json_encode($request->all());
                $file_type=$image->getClientOriginalName();
                $user_id=Session::get('USER_ID');
                $server_info=json_encode(request()->server());
                $user_info=json_encode(SESSION()->all()['result'][0]);
                $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
				Session::flash('market_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
				Session::flash('type','danger' );
                return back(); 
            }
            $txt_image=$name1;
        }
        else
        {
            $txt_image = '';
        }

        $this->validate($request, [
            'txt_mkname'=> 'required|string|max:255',
            'txt_mobile' => 'required',
            'txt_address' => 'required',
            'txt_lat'=> 'required',
            'txt_long' => 'required',
            'rb_mktclosed' => 'required',
            'rb_deliverable'=> 'required',
            'txt_desc' => 'nullable|string|max:255',
            'dd_status' => 'required',
        ],[
            'txt_mkname.required'=> 'Market name is required',
            'txt_mobile.string'=> 'Mobile number is required',
            'txt_address.required'=> 'Address is required',
            'txt_lat.string'=> 'Latitude is required',
            'txt_long.required'=> 'Longitude is required',
            'rb_mktclosed.required'=> 'Isclosed is required',
            'rb_deliverable.required'=> 'Deliverable is required',
            'txt_desc.required'=> 'Description is required',
            'dd_status.numeric'=> 'Status is required',
        ]);

        $arr = array(
            'm38_markets_name' => $request->input('txt_mkname'),
            'm38_phone' => $request->input('txt_mobile'),
            'm38_address' => $request->input('txt_address'),
            'm38_latitude' => $request->input('txt_lat'),
            'm38_longitude' => $request->input('txt_long'),
            'm02_loc_id' => 1,
            'm38_mktclosed' => $request->input('rb_mktclosed'),
            'm38_avldelivery' => $request->input('rb_deliverable'),
            'm38_image' => $txt_image,
            'm38_description' => $request->input('txt_desc'),
            'm38_market_status' => $request->input('dd_status'),
            'm38_created_by' => 1,
            'm38_created_by_id' => Session::get('USER_ID')
        );
        $inserted_id = $this->market_repo->create($arr);

		Session::flash('market_msg','MARKET ADDED SUCCESSFULLY' );
        Session::flash('type','success' );

        return redirect('/create_market');
    }

    public function update_market($id)
    {
        $request = request();

        if( $request->hasFile('txt_image')){
            $image = $request->file('txt_image');
            $name1 = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/market_logo/');
            $FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)){
                $image->move($destinationPath, $name1);
            }
            else{
                $request_data=json_encode($request->all());
                $file_type=$image->getClientOriginalName();
                $user_id=Session::get('USER_ID');
                $server_info=json_encode(request()->server());
                $user_info=json_encode(SESSION()->all()['result'][0]);
                $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
				Session::flash('umarket_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
				Session::flash('type','danger' );
                return back(); 
            }
            $txt_image=$name1;
        }
        else
        {
            $txt_image = $request->input('txt_oldimage');
        }

        $this->validate($request, [
            'txt_mkname'=> 'required|string|max:255',
            'txt_mobile' => 'required',
            'txt_address' => 'required',
            'txt_lat'=> 'required',
            'txt_long' => 'required',
            'rb_mktclosed' => 'required',
            'rb_deliverable'=> 'required',
            'txt_desc' => 'nullable|string|max:255',
            'dd_status' => 'required',
        ],[
            'txt_mkname.required'=> 'Market name is required',
            'txt_mobile.string'=> 'Mobile number is required',
            'txt_address.required'=> 'Address is required',
            'txt_lat.string'=> 'Latitude is required',
            'txt_long.required'=> 'Longitude is required',
            'rb_mktclosed.required'=> 'Isclosed is required',
            'rb_deliverable.required'=> 'Deliverable is required',
            'txt_desc.required'=> 'Description is required',
            'dd_status.numeric'=> 'Status is required',
        ]);

        $arr = array(
            'm38_markets_name' => $request->input('txt_mkname'),
            'm38_phone' => $request->input('txt_mobile'),
            'm38_address' => $request->input('txt_address'),
            'm38_latitude' => $request->input('txt_lat'),
            'm38_longitude' => $request->input('txt_long'),
            'm02_loc_id' => 1,
            'm38_mktclosed' => $request->input('rb_mktclosed'),
            'm38_avldelivery' => $request->input('rb_deliverable'),
            'm38_image' => $txt_image,
            'm38_description' => $request->input('txt_desc'),
            'm38_market_status' => $request->input('dd_status')
        );

        $this->market_repo->update($id, $arr);

		Session::flash('umarket_msg','MARKET UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );

        return redirect('/edit_market/'.$id);
    }

	/**
        * Method name   : product variant
        * @description  : Used for viewing all product variant
        * @param        : Request data  
        * @return       : return view with all product variant
    */
    public function product_variant($id="")
    {
        $product_variants = $this->prod_varnt->getAll();
        return view('Product.product_variant', compact('product_variants'));
    }

    /**
        * Method name   : create_variant
        * @description  : Used for create variant
        * @param        : Request data  
        * @return       : return view with created variant
    */
    public function create_variant()
    {
        $products = $this->prod_repo->getAll();
        $units = $this->unit_repo->getAll();
        $option = $this->optgrp_repo->getAll();
        $all_parentcat = $this->parentcat_repo->getAll();
        return view('Product.create_variant', compact('products','units', 'option', 'all_parentcat'));
    }

    /**
        * Method name   : edit_variant
        * @description  : Used for edit variant
        * @param        : Request data  
        * @return       : return view with edited variant
    */
    public function edit_variant($id)
    {
        $products = $this->prod_repo->getAll();
        $units = $this->unit_repo->getAll();
        $option = $this->optgrp_repo->getAll();
        $single_variant = $this->prod_varnt->getById($id);
        $option_name = $this->optype_repo->getAll();
        $images = explode(',', $single_variant[0]->VARNT_IMAGE);
        $all_parentcat = $this->parentcat_repo->getAll();
        $categories = $this->cat_repo->getAllCategory();
        $single_product = $this->prod_repo->getById($single_variant[0]->PROD_ID);
        $sub_category = $this->cat_repo->getById($single_product[0]->PROD_CATID);
        $cat = $this->cat_repo->getById($sub_category[0]->CAT_PARENTID);
        $parent_cat = $this->parentcat_repo->getById($cat[0]->SHOPPING_FOR);
        $sub_cat = $this->cat_repo->getSubCategoryByParent($sub_category[0]->CAT_PARENTID);
        $images = explode(',', $single_variant[0]->VARNT_IMAGE);

        return view('Product.edit_variant', compact('products','units', 'option', 'single_variant', 'option_name','images', 'sub_category', 'cat', 'parent_cat', 'sub_cat', 'single_product', 'all_parentcat' ,'categories'));
    }

    public function add_variant()
    {
        $request = request();

        if($request->hasFile('txt_img')){
            $files = $request->file('txt_img');
            $img_arr = array();
            $FileType = array('jpeg','png','jpg');
            foreach($files as $key => $image){
                $name1 = time().$key.'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/images/prod_logo/');
                $img_arr[] = $name1;
                if(in_array($image->getClientOriginalExtension(), $FileType)) {
                    $image->move($destinationPath, $name1);
                }
                else{
                    $request_data=json_encode($request->all());
                    $file_type=$image->getClientOriginalName();
                    $user_id=Session::get('USER_ID');
                    $server_info=json_encode(request()->server());
                    $user_info=json_encode(SESSION()->all()['result'][0]);
                    $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
                    Session::flash('uproduct_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
                    Session::flash('type','danger' );
                    return back();
                }

            }
            $txt_image=implode(',', $img_arr);
        }
        else
        {
            $txt_image = '';
        }

        $this->validate($request, [
            'dd_product'=> 'required',
            'txt_skuid'=> 'required|alpha_num|max:100',
            'txt_cgst' => 'required|numeric',
            'txt_sgst' => 'required|numeric',
            'txt_igst' => 'required|numeric',
            'txt_price' => 'required',
            'txt_discprice'=> 'required',
            'dd_option1' => 'numeric|nullable',
            'dd_optype1' => 'numeric|nullable',
            'dd_option2' => 'numeric|nullable',
            'dd_optype2' => 'numeric|nullable',
            'dd_unit' => 'required',
            'txt_stock' => 'required',
            'dd_status' => 'required'
        ],[
            'dd_product.required'=> 'Product is required',
            'txt_skuid.string'=> 'Name is required',
            'txt_cgst.required'=> 'GST amount is required',
            'txt_cgst.numeric'=> 'GST amount should be numeric',
            'txt_sgst.required'=> 'SGST amount is required',
            'txt_sgst.numeric'=> 'SGST amount should be numeric',
            'txt_igst.required'=> 'IGST amount is required',
            'txt_igst.numeric'=> 'IGST amount should be numeric',
            'txt_price.required'=> 'Price is required',
            'txt_discprice.string'=> 'Discount price is required',
            'dd_option1.numeric'=> 'Option is required',
            'dd_optype1.numeric'=> 'Option Type is required',
            'dd_option2.numeric'=> 'Option is required',
            'dd_optype2.numeric'=> 'Option Type is required',
            'dd_unit.required'=> 'Unit is required',
            'txt_stock.required'=> 'Stock is required',
            'dd_status.required'=> 'Status is required'
        ]);

        $arr = array(
            'm74_sku_id' => $request->input('txt_skuid'),
            'm33_product_id' => $request->input('dd_product'),
            'm35_group_id' => $request->input('dd_option1'),
            'm75_option_type_id' => $request->input('dd_optype1'),
            'm35_group_id2' => $request->input('dd_option2'),
            'm75_option_type_id2' => $request->input('dd_optype2'),
            'm37_unit_id' => $request->input('dd_unit'),
            'm74_prod_cgst' => $request->input('txt_cgst'),
            'm74_prod_sgst' => $request->input('txt_sgst'),
            'm74_prod_igst' => $request->input('txt_igst'),
            'm74_price' => $request->input('txt_price'),
            'm74_disc_price' => $request->input('txt_discprice'),
            'm74_stock' => $request->input('txt_stock'),
            'm74_image' => $txt_image,
            'm74_status' => $request->input('dd_status'),
            'm74_created_by' => 1,
            'm74_created_by_id' => Session::get('USER_ID')
        );
        $this->prod_varnt->create($arr);

        Session::flash('vrnt_msg','PRODUCT VARIANT ADDED SUCCESSFULLY' );
        Session::flash('type','success' );

        return redirect('/create_variant');
    }

    public function update_variant($id)
    {
        $request = request();
        if( $request->hasFile('txt_img0')){
            $image = $request->file('txt_img0');
            $name1 = time().'0.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/prod_logo/');
            $FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)){
                $image->move($destinationPath, $name1);
            }
            else{
                $request_data=json_encode($request->all());
                $file_type=$image->getClientOriginalName();
                $user_id=Session::get('USER_ID');
                $server_info=json_encode(request()->server());
                $user_info=json_encode(SESSION()->all()['result'][0]);
                $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
                Session::flash('market_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
                Session::flash('type','danger' );
                return back(); 
            }
            $img_arr[] = $name1;
        }
        else
        {
            $img_arr[] = $request->file('txt_old_img0');
        }

        if( $request->hasFile('txt_img1')){
            $image = $request->file('txt_img1');
            $name1 = time().'1.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/prod_logo/');
            $FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)){
                $image->move($destinationPath, $name1);
            }
            else{
                $request_data=json_encode($request->all());
                $file_type=$image->getClientOriginalName();
                $user_id=Session::get('USER_ID');
                $server_info=json_encode(request()->server());
                $user_info=json_encode(SESSION()->all()['result'][0]);
                $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
                Session::flash('market_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
                Session::flash('type','danger' );
                return back(); 
            }
            $img_arr[] = $name1;
        }
        else
        {
            $img_arr[] = $request->file('txt_old_img1');
        }

        if( $request->hasFile('txt_img2')){
            $image = $request->file('txt_img2');
            $name1 = time().'2.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/prod_logo/');
            $FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)){
                $image->move($destinationPath, $name1);
            }
            else{
                $request_data=json_encode($request->all());
                $file_type=$image->getClientOriginalName();
                $user_id=Session::get('USER_ID');
                $server_info=json_encode(request()->server());
                $user_info=json_encode(SESSION()->all()['result'][0]);
                $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
                Session::flash('market_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
                Session::flash('type','danger' );
                return back(); 
            }
            $img_arr[] = $name1;
        }
        else
        {
            $img_arr[] = $request->file('txt_old_img2');
        }

        if( $request->hasFile('txt_img3')){
            $image = $request->file('txt_img3');
            $name1 = time().'3.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/prod_logo/');
            $FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)){
                $image->move($destinationPath, $name1);
            }
            else{
                $request_data=json_encode($request->all());
                $file_type=$image->getClientOriginalName();
                $user_id=Session::get('USER_ID');
                $server_info=json_encode(request()->server());
                $user_info=json_encode(SESSION()->all()['result'][0]);
                $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
                Session::flash('market_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
                Session::flash('type','danger' );
                return back(); 
            }
            $img_arr[] = $name1;
        }
        else
        {
            $img_arr[] = $request->file('txt_old_img3');
        }

        if( $request->hasFile('txt_img4')){
            $image = $request->file('txt_img4');
            $name1 = time().'4.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/prod_logo/');
            $FileType = array('jpeg','png','jpg');
            if(in_array($image->getClientOriginalExtension(), $FileType)){
                $image->move($destinationPath, $name1);
            }
            else{
                $request_data=json_encode($request->all());
                $file_type=$image->getClientOriginalName();
                $user_id=Session::get('USER_ID');
                $server_info=json_encode(request()->server());
                $user_info=json_encode(SESSION()->all()['result'][0]);
                $signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
                Session::flash('market_msg','IMAGE TYPE NOT SUPPORTED (use only png or jpg).' );
                Session::flash('type','danger' );
                return back(); 
            }
            $img_arr[] = $name1;
        }
        else
        {
            $img_arr[] = $request->file('txt_old_img4');
        }


        $txt_image=implode(',', $img_arr);

        $this->validate($request, [
            'dd_product'=> 'required',
            'txt_cgst' => 'required|numeric',
            'txt_sgst' => 'required|numeric',
            'txt_igst' => 'required|numeric',
            'txt_price' => 'required',
            'txt_discprice'=> 'required',
            'dd_option1' => 'numeric|nullable',
            'dd_optype1' => 'numeric|nullable',
            'dd_option2' => 'numeric|nullable',
            'dd_optype2' => 'numeric|nullable',
            'dd_unit' => 'required',
            'txt_stock' => 'required',
            'dd_status' => 'required'
        ],[
            'dd_product.required'=> 'Product is required',
            'txt_cgst.required'=> 'GST amount is required',
            'txt_cgst.numeric'=> 'GST amount should be numeric',
            'txt_sgst.required'=> 'SGST amount is required',
            'txt_sgst.numeric'=> 'SGST amount should be numeric',
            'txt_igst.required'=> 'IGST amount is required',
            'txt_igst.numeric'=> 'IGST amount should be numeric',
            'txt_price.required'=> 'Price is required',
            'txt_discprice.string'=> 'Discount price is required',
            'dd_option1.numeric'=> 'Option is required',
            'dd_optype1.numeric'=> 'Option Type is required',
            'dd_option2.numeric'=> 'Option is required',
            'dd_optype2.numeric'=> 'Option Type is required',
            'dd_unit.required'=> 'Unit is required',
            'txt_stock.required'=> 'Stock is required',
            'dd_status.required'=> 'Status is required'
        ]);

        $arr = array(
            'm33_product_id' => $request->input('dd_product'),
            'm35_group_id' => $request->input('dd_option1'),
            'm75_option_type_id' => $request->input('dd_optype1'),
            'm35_group_id2' => $request->input('dd_option2'),
            'm75_option_type_id2' => $request->input('dd_optype2'),
            'm37_unit_id' => $request->input('dd_unit'),
            'm74_prod_cgst' => $request->input('txt_cgst'),
            'm74_prod_sgst' => $request->input('txt_sgst'),
            'm74_prod_igst' => $request->input('txt_igst'),
            'm74_price' => $request->input('txt_price'),
            'm74_disc_price' => $request->input('txt_discprice'),
            'm74_stock' => $request->input('txt_stock'),
            'm74_image' => $txt_image,
            'm74_status' => $request->input('dd_status')
        );
        $this->prod_varnt->update($id, $arr);

        Session::flash('uvrnt_msg','PRODUCT VARIANT UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );

        return redirect('/view_variant/'.$id);
    }
}