<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request; 
use App\Http\Requests;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use DB;
use Helper;
use App;
use Razorpay\Api\Api;
use Illuminate\Support\Str;
use App\Repositories\Master\Banner\BannerRepository;
use App\Repositories\Master\Operator\OperatorRepository;
use App\Repositories\ProductModule\Categories\CategoriesRepository;
use App\Repositories\ProductModule\Brand\BrandRepository;
use App\Repositories\ProductModule\Products\ProductsRepository;
use App\Repositories\ProductModule\Optiongroup\OptiongroupRepository;
use App\Repositories\ProductModule\Unit\UnitRepository;
use App\Repositories\Affiliate\AffiliateRepository;
use App\Repositories\ProductModule\ParentCategories\ParentCategoriesRepository;
use App\Repositories\ProductModule\ProductVariant\ProductVariantRepository;
use App\Repositories\ProductModule\Market\MarketRepository;
use App\Repositories\ProductModule\OptionType\OptionTypeRepository;
use App\Repositories\ProductModule\UserOrders\UserOrdersRepository;
use App\Repositories\ProductModule\Wishlist\WishlistRepository;
use App\Repositories\ProductModule\UserAddress\UserAddressRepository;

class PaymentGatewayController extends Controller
{

    private $banner_repo;   
    private $cat_repo;
    private $brand_repo;
    private $prod_repo;
    private $optgrp_repo;
    private $unit_repo;
    private $Affiliate_repo;
    private $market_repo;
    private $parentcat_repo;
    private $prod_varnt;
    private $optype_repo;
    private $telecom_brand_repo;
    private $address_repo;
    private $wishlist_repo;
    private $orders_repo;


    public function __construct(BannerRepository $banner_repo, CategoriesRepository $cat_repo, BrandRepository $brand_repo,
        ProductsRepository $prod_repo, OptiongroupRepository $optgrp_repo, 
        UnitRepository $unit_repo, AffiliateRepository $Affiliate_repo, MarketRepository $market_repo,
        ParentCategoriesRepository $parentcat_repo, ProductVariantRepository $prod_varnt,
         OptionTypeRepository $optype_repo, OperatorRepository $telecom_brand_repo, UserAddressRepository $address_repo, WishlistRepository $wishlist_repo, UserOrdersRepository $orders_repo)
    {
        $this->banner_repo = $banner_repo;
        $this->cat_repo = $cat_repo;
        $this->brand_repo = $brand_repo;
        $this->prod_repo = $prod_repo;
        $this->optgrp_repo = $optgrp_repo;
        $this->unit_repo = $unit_repo;
        $this->Affiliate_repo = $Affiliate_repo;
        $this->market_repo = $market_repo;
        $this->parentcat_repo = $parentcat_repo;
        $this->prod_varnt = $prod_varnt;
        $this->optype_repo = $optype_repo;
        $this->telecom_brand_repo = $telecom_brand_repo;        
        $this->address_repo = $address_repo;
        $this->wishlist_repo = $wishlist_repo;
        $this->orders_repo = $orders_repo;
    }



    public function b2crazorpay(Request $request)
    {        
			$user = Helper::get_userdetail(Session()->get('B2C_USER_ID'));
			$data[1] =  Helper::razorpay($request, $user[0]);
			$data[2] = $request->all();
			return $data;
	}


    public function razorpay(Request $request)
    {        
			$user = Helper::get_userdetail(Session()->get('USER_ID'));
			$data[1] =  Helper::razorpay($request, $user[0]);
			$data[2] = $request->all();
			return $data;
	}

	public function cashfree_payment(Request $request)
	{
		$Production = 'https://api.cashfree.com/';
		$Test	= 'https://test.cashfree.com/';

		$user = Helper::get_userdetail(Session()->get('USER_ID'));

		if(count($user) > 0 && $request->txt_amount > 0)
		{		
				$amt = (float)$request->txt_amount;
				$curl = curl_init();
				$orderId = 'MAD-'.$user[0]->RegId.time().rand(00,99).$amt;

				$orders = array(
						'appId' => config('APP_ID'),
	                  	'secretKey' => config('SECRETKEY'), 
	                  	'orderId' => $orderId,
	                  	'orderAmount' => $amt,
	                  	'orderCurrency' => 'INR',
	                  	'orderNote' => 'Add Money In Wallet',
	                  	'customerEmail' => $user[0]->MemberEmail,
	                  	'customerName' => $user[0]->MemberName,
	                  	'customerPhone' => $user[0]->MemberContactNo,
	                  	'returnUrl' => 'https://martatdoor.in/api/v1/payment_info',
	                  	'notifyUrl' => 'https://martatdoor.in/api/v1/payment_info'
					    );


				curl_setopt_array($curl, array(
				  CURLOPT_URL => $Production.'api/v1/order/create',
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => '',
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 0,
				  CURLOPT_FOLLOWLOCATION => true,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => 'POST',
				  CURLOPT_POSTFIELDS => $orders,
				));

				$response = curl_exec($curl);
				curl_close($curl);

				DB::table('tr31_online_payment_request')->insert(['request_rzp' =>json_encode($orders),
                                                            'request_form' =>json_encode($request->all()),
                                                            'response' =>$response
                                                                        ]);
       			$responseData = [  
                            'm11_user_id' =>$user[0]->RegId,
                            'm11_user_code' =>$user[0]->RegCode,
                            'tr31_op_amount' =>$amt,
                            'tr31_op_currency' => 2,
                            'tr31_op_txnid' =>$orderId
                ];

        		DB::table('tr31_online_payment')->insert($responseData);
				return json_decode($response);
		}
		else
		{
			return ['status' => 'ERROR', 'reason' => 'User Info Not Found'];
		}
	}






    public function get_coupan_amounts($user_id)
    {   
        $USERCOUPAN = 0;
        if($user_id)
        {   
            $user = Helper::get_userdetail($user_id);
            $topup = DB::select("SELECT * FROM tr19_user_topup WHERE m11_user_id =".$user_id." ORDER BY tr19_user_tpid LIMIT 1");

            if(count($topup) > 0 && count($user) > 0)
            {
                $coupanamt = DB::table('m27_package')->where('m27_pack_id', $topup[0]->m27_pack_id)->first();
                
                if($coupanamt != '')
                {

                    $topupusethisamt=(float)$coupanamt->m27_coupan_amt/(float)config('TOPUP_DIVIDE_INMONTH');

                    $to = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', $topup[0]->tr19_topup_createdat);
                    $from = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', date('Y-m-d h:i:s'));
                    $diff_in_months = $to->diffInMonths($from);

                    if(config('TOPUP_AMO_DED') == 'YES')
                    {
                        $diff_in_months = 1;
                        if($diff_in_months > $topup[0]->tr19_coupan_noofuse)
                        {
                            $dedamt = ($diff_in_months-$topup[0]->tr19_coupan_noofuse)*$topupusethisamt;
                            $useamt = $topup[0]->tr19_coupan_useamt+$dedamt;
                            $noofuse = $topup[0]->tr19_coupan_noofuse+($diff_in_months-$topup[0]->tr19_coupan_noofuse);

                            DB::update("UPDATE `tr19_user_topup` SET `tr19_coupan_useamt` = ".$useamt.", `tr19_coupan_noofuse` = ".$noofuse." WHERE `tr19_user_tpid` = ".$topup[0]->tr19_user_tpid);
                        }
                    }

                    if(config('TOPUP_AMO_USER_INDAY') >=  date('d'))
                    {   

                        $user = Helper::get_userdetail($user_id);
                        $usercoupanamt = DB::select("SELECT COALESCE(SUM(tr03_dramount),0) AS AMT FROM `tr03_manage_ledger` WHERE m11_user_id = ".$user_id." AND tr03_bal_type = 'COUPAN' AND tr03_ledger_type = 'COUPAN REDEEM' AND DATE_FORMAT(tr03_trans_onadd,'%Y-%m') = DATE_FORMAT(NOW(),'%Y-%m')"); 

                        $total_usercoupanamt = DB::select("SELECT COALESCE(SUM(tr03_dramount),0) AS AMT FROM `tr03_manage_ledger` WHERE m11_user_id = ".$user_id." AND tr03_bal_type = 'COUPAN' AND tr03_ledger_type = 'COUPAN REDEEM'"); 

 
                        if((float)$total_usercoupanamt[0]->AMT > (float)$coupanamt->m27_coupan_amt)
                        {
                            $USERCOUPAN = 0;
                        }
                        else 
                        {
                            $USERCOUPAN = $topupusethisamt-(float)$usercoupanamt[0]->AMT;
                        }
                    }
                    else
                    {
                        $USERCOUPAN = 0;
                    } 
                }
            }
        }
        return $USERCOUPAN;
    }





	public function cashfree_payments(Request $request)
	{
		$Production = 'https://api.cashfree.com/';
		$Test	= 'https://test.cashfree.com/';

		$user = Helper::get_userdetail(Session()->get('USER_ID'));
		$cart = $this->orders_repo->getById($request->cart_id);
		
		if(count($cart) == 0)
		{
			return ['status' => 'ERROR', 'reason' => 'Cart Info Not Found'];
		}

        	$carddata = json_decode($cart[0]->PRODUCT_DETAILS);

           	$del = (float)$cart[0]->DELIVERY_FEE;
            $coupan = $this->get_coupan_amounts(Session()->get('USER_ID'));
            $total =0;
            $coupans = 0;
            foreach($carddata as $value)
            {
                $total += $value->disc_price*$value->new_quantity;
            }
              
            if($coupan >= $del+$total)
            {
                $coupans = $del+$total;
                $toamt = 0.00;
            }
            else
            {
              $coupans = $coupan;
              $toamt = ($del+$total)-$coupan;  
            }


		if(count($user) > 0 && $request->cart_id > 0 && $request->address > 0 && $toamt > 0)
		{		
				$amt = $toamt;//((float)$cart[0]->FINAL_AMOUNT+(float)$cart[0]->DELIVERY_FEE);
				
				$curl = curl_init();
				$orderId = 'MAD-'.date('ymd').$user[0]->RegId.time().rand(000,999);


				$orders = array(
						'appId' => config('APP_ID'),
	                  	'secretKey' => config('SECRETKEY'), 
	                  	'orderId' => $orderId,
	                  	'orderAmount' => $amt,
	                  	'orderCurrency' => 'INR',
	                  	'orderNote' => 'Add Money In Wallet',
	                  	'customerEmail' => $user[0]->MemberEmail,
	                  	'customerName' => $user[0]->MemberName,
	                  	'customerPhone' => $user[0]->MemberContactNo,
	                  	'returnUrl' => 'https://martatdoor.in/api/v1/cart_payment_info/'.base64_encode($request->cart_id).'/'.base64_encode($request->address),
	                  	'notifyUrl' => 'https://martatdoor.in/api/v1/cart_payment_info/'.base64_encode($request->cart_id).'/'.base64_encode($request->address)
					    );


				curl_setopt_array($curl, array(
				  CURLOPT_URL => $Production.'api/v1/order/create',
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => '',
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 0,
				  CURLOPT_FOLLOWLOCATION => true,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => 'POST',
				  CURLOPT_POSTFIELDS => $orders,
				));

				$response = curl_exec($curl);
				curl_close($curl);

				DB::table('tr31_online_payment_request')->insert(['request_rzp' =>json_encode($orders),
                                                            'request_form' =>json_encode($request->all()),
                                                            'response' =>$response
                                                                        ]);
       			$responseData = [  
                            'm11_user_id' =>$user[0]->RegId,
                            'm11_user_code' =>$user[0]->RegCode,
                            'tr31_op_amount' =>$amt,
                            'tr31_op_currency' => 2,
                            'tr31_op_txnid' =>$orderId
                ];

        		DB::table('tr31_online_payment')->insert($responseData);
				return json_decode($response);
		}
		else
		{
			return ['status' => 'ERROR', 'reason' => 'User Info Not Found'];
		}
	}




}