<?php

namespace App\Http\Controllers;

use App\Repositories\ProductModule\Categories\CategoriesRepository;
use App\Repositories\ProductModule\ParentCategories\ParentCategoriesRepository;
use App\Repositories\ProductModule\Products\ProductsRepository;
use App\Repositories\ProductModule\UserOrders\UserOrdersRepository;
use App\Repositories\ProductModule\Favorites\FavoritesRepository;
use App\Repositories\ProductModule\Wishlist\WishlistRepository;
use App\Repositories\ProductModule\UserAddress\UserAddressRepository;
use App\Repositories\ProductModule\OnlinePayment\OnlinePaymentRepository;
use App\Repositories\ProductModule\ProductVariant\ProductVariantRepository;
use App\Repositories\ProductModule\OrdersSiping\OrdersSipingRepository;
use App\Repositories\Log\LogRepository;
use Illuminate\Http\Request; 
use App\Http\Requests;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use DB;
use Config;
use Helper;
use Session;
use Cookie;
use App;
use File;
use ShipRocket;

class OrderController extends Controller
{
    private $parent_catrepo;
    private $cat_repo;
    private $prod_repo;
    private $order_repo;
    private $fav_repo;
    private $wishlist_repo;
    private $address_repo;
    private $onlinepay_repo;
    private $prod_varnt;
    private $log_repo;
    private $ordersiping_repo;

    private $isError = FALSE;

    public function __construct(CategoriesRepository $cat_repo, ProductsRepository $prod_repo,
        ParentCategoriesRepository $parent_catrepo, UserOrdersRepository $order_repo, 
        FavoritesRepository $fav_repo, WishlistRepository $wishlist_repo, UserAddressRepository $address_repo, 
        OnlinePaymentRepository $onlinepay_repo, ProductVariantRepository $prod_varnt, LogRepository $log_repo, OrdersSipingRepository $ordersiping_repo)
    {
        $this->cat_repo = $cat_repo;
        $this->prod_repo = $prod_repo;
        $this->parent_catrepo = $parent_catrepo;
        $this->order_repo = $order_repo;
        $this->fav_repo = $fav_repo;
        $this->wishlist_repo = $wishlist_repo;
        $this->address_repo = $address_repo;
        $this->onlinepay_repo = $onlinepay_repo;
        $this->prod_varnt = $prod_varnt;
        $this->log_repo = $log_repo;
        $this->ordersiping_repo = $ordersiping_repo;
    }

    /**
    * Method name   : orders
    * @description  : Used for viewing all user orders
    * @param        : Request data  
    * @return       : return view with all user orders
    */
    public function orders()
    {
        $request = request();
        $start = '2021-07-01';
        $end =  date('Y-m-d'); 
        $user_id = '';
        $order_id = '';
        $cond="";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
            $order_id = $request->input('txt_orderid');

            if($request->input('txt_memberid')!='')
            $user_id = Helper::get_userid($request->input('txt_memberid'));

            if($user_id != '' && $user_id != 'false')
            {
                $cond = $cond."`USER_ID` = $user_id  AND ";
            }
            if($order_id != '' && $order_id != 'false')
            {
                $cond = $cond."`ORDER_CODE` = '".$order_id."'  AND ";
            }
            if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
            {
                $cond = $cond."DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
            }
        }
        $cond = $cond."ORDER_STATUS != 'DELIVERED' AND CART_TYPE != 'WISHLIST' ";
    	$all_orders = DB::select('SELECT * FROM `user_orders` WHERE '.$cond.' ORDER BY ORDER_ID DESC' );
    	return view('Product.orders', compact('all_orders')); 
    }






    /**
    * Method name   : send orders
    * @description  : Used for request to siping
    * @param        : Request data  
    * @return       : return view with all user orders
    */
    public function send_orders()
    {
        $request = request();
        $start = '2021-07-01';
        $end =  date('Y-m-d'); 
        $user_id = '';
        $order_id = '';
        $cond="";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
            $order_id = $request->input('txt_orderid');

            if($request->input('txt_memberid')!='')
            $user_id = Helper::get_userid($request->input('txt_memberid'));

            if($user_id != '' && $user_id != 'false')
            {
                $cond = $cond."`USER_ID` = $user_id  AND ";
            }
            if($order_id != '' && $order_id != 'false')
            {
                $cond = $cond."`ORDER_CODE` = '".$order_id."'  AND ";
            }
            if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
            {
                $cond = $cond."DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
            }
        }
        $cond = $cond."ORDER_STATUS = 'ACCEPTED' AND CART_TYPE != 'WISHLIST' ";
        $all_orders = DB::select('SELECT * FROM `user_orders` WHERE '.$cond.' ORDER BY ORDER_ID DESC' );


        return view('Product.send_orders', compact('all_orders')); 
    }




    public function view_send_order($orderid)
    {
        if($orderid)
        {
             $single_order = $this->order_repo->getByOrderCode($orderid);
             $couriers = DB::table('m80_courier_company')->where('m80_status', 'ACTIVE')->get();
             if(count($single_order) > 0)
             {
                $ship = $this->ordersiping_repo->getByCartId($single_order[0]->ORDER_ID);
                return view('Product.send_order_view',compact('single_order','orderid','couriers','ship'));
             }
            
            Session::flash('type','warning');
            Session::flash('message','Order Not Found!');
            return back();
        }

        Session::flash('type','warning');
        Session::flash('message','Order Id Not Found!');
        return back(); 
        
    }


    public function send_order(request  $request)
    {
        $token =  ShipRocket::getToken();

        if($token && $request->txt_orderid)
        {           
            $single_order = $this->order_repo->getByOrderCode($request->txt_orderid);
            if(count($single_order) > 0)
            {
                $all_pro = [];
                $product_details=json_decode($single_order[0]->PRODUCT_DETAILS,true);

                foreach ($product_details as $key => $value) 
                {
                    if(!isset($value['sku']))
                    {
                        return ['type' => 'warning', 'message'=>'sku Id Not Found!']; 
                    }
                    if($value['sku'] == '')
                    {
                        return ['type' => 'warning', 'message'=>'sku Id !'];
                    }

                   $new_all_pro = array (
                                          'name' => $value['name'],
                                          'sku' =>  $value['sku'],
                                          'units' => $value['new_quantity'],
                                          'selling_price' => $value['disc_price'],
                                          'discount' => '',
                                          'tax' => '',
                                        );
                   array_push($all_pro, $new_all_pro);
                }


                $data=array(
                      "order_id"=>$single_order[0]->ORDER_CODE,
                      "order_date"=>$single_order[0]->CREATED_AT,
                      "pickup_location"=>'Primary',
                      "channel_id"=>"83536",
                      "comment"=>"Reseller: M/s SPIDERSILK PVT LTD",
                      "billing_customer_name"=>$single_order[0]->FIRST_NAME,
                      "billing_last_name"=>$single_order[0]->LAST_NAME,
                      "billing_address"=>$single_order[0]->FLAT,
                      "billing_address_2"=>$single_order[0]->LANDMARK ,
                      "billing_city"=>$single_order[0]->CITY,
                      "billing_pincode"=>$single_order[0]->PINCODE,
                      "billing_state"=>$single_order[0]->STATE,
                      "billing_country"=>$single_order[0]->COUNTRY,
                      "billing_email"=>$single_order[0]->USER_EMAIL,
                      "billing_phone"=>$single_order[0]->USER_CONTACT,
                      "shipping_is_billing"=>true,
                      "shipping_customer_name"=>"",
                      "shipping_last_name"=>"",
                      "shipping_address"=>"",
                      "shipping_address_2"=>"",
                      "shipping_city"=>"",
                      "shipping_pincode"=>"",
                      "shipping_country"=>"",
                      "shipping_state"=>"",
                      "shipping_email"=>"",
                      "shipping_phone"=>"",
                      "order_items" => $all_pro,
                      "payment_method"=> "Prepaid", //COD 
                      "shipping_charges"=> $single_order[0]->FINAL_AMOUNT,
                      "giftwrap_charges"=> 0,
                      "transaction_charges"=> 0,
                      "total_discount"=> 0,
                      "sub_total"=> $single_order[0]->FINAL_AMOUNT,
                      "length"=> 10,
                      "breadth"=> 15,
                      "height"=> 20,
                      "weight"=> 2.5
                    );


                $response = ShipRocket::OrderCreate($data,$token);

                DB::table('tr46_shipment_api_request')->insert(['tr46_cart_id' =>$request->txt_orderid, 'tr46_request' =>json_encode($data), 'tr46_response'=> json_encode($response),'tr46_type'=>1]);

                if(isset($response->shipment_id))
                {
                    $ship = $this->ordersiping_repo->getBySipmentId($response->shipment_id);
                    if(count($ship) == 0)
                    {
                        $this->ordersiping_repo->create([
                                                    'tr36_cart_id' => $single_order[0]->ORDER_ID,
                                                    'tr61_order_id' => $response->order_id,
                                                    'tr45_shipment_id' => $response->shipment_id,
                                                ]);
                    }
                }

                if(isset($response->errors->order_date[0]))
                {
                    $msg = $response->errors->order_date[0];
                }
                elseif (isset($response->message)) 
                {
                     $msg = $response->message;
                }
                else
                {
                     $msg = 'Order Send successfully';
                }
                
                return ['type' => $response->status, 'message' => $msg];
            }
            else
            {
                   return ['type' => 'warning',  'message' => 'Order Not Found!'];
            }
        }
        else
        {
             return ['type' => 'warning',  'message' => 'Shiprocket authentication failed!'];
        }
    }





    public function assign_awb(request  $request)
    {
        $token =  ShipRocket::getToken();
        
        if($token && $request->txt_orderid)
        {           
            $ship = $this->ordersiping_repo->getBySipmentId($request->shipment_id);

            if(count($ship) > 0)
            {
                $data=array(
                      "shipment_id"=> $request->shipment_id,
                    );

                if($request->dd_couriers != '')
                {
                    $data['channel_id'] = $request->dd_couriers;
                }


                $response = ShipRocket::CourierAssign($data,$token);

                DB::table('tr46_shipment_api_request')->insert(['tr46_cart_id' =>$request->txt_orderid, 'tr46_request' =>json_encode($data), 'tr46_response'=> json_encode($response),'tr46_type'=>2]);

                if(isset($response->awb_assign_status))
                {
                    if($response->awb_assign_status == 1)
                    {
                        $this->ordersiping_repo->updateByShipment($request->shipment_id, [
                                                                    "tr45_courier_company_id" => $response->response->data->courier_company_id,
                                                                    "tr45_awb_code" =>$response->response->data->awb_code
                                                                ]);

                        return ['type' => $response->status,  'message' => 'AWB Genrate successfully'];
                    }
                }

          
                if(isset($response->errors->order_date[0]))
                {
                    $msg = $response->errors->order_date[0];
                }
                elseif (isset($response->message)) 
                {
                     $msg = $response->message;
                }
                else
                {
                     $msg = 'Order Send successfully';
                }
  
                return ['type' => $response->status,  'message' => $msg];
            }
            else
            {
                return ['type' => 'warning',  'message' => 'Order Not Found!'];
            }
        }
        else
        {
            return ['type' => 'warning',  'message' => 'Shiprocket authentication failed!'];
        }
    }




    public function shipmentpickuprequest(request  $request)
    {
        $token =  ShipRocket::getToken();
     
        if($token && $request->shipment_id && $request->txt_orderid)
        {           
            $ship = $this->ordersiping_repo->getBySipmentId($request->shipment_id);

            if(count($ship) > 0)
            {
                $data=array(
                      "shipment_id"=> array($request->shipment_id),
                    );

                $response = ShipRocket::RequestforShipmentPickup($data,$token);

                DB::table('tr46_shipment_api_request')->insert(['tr46_cart_id' =>$request->txt_orderid, 'tr46_request' =>json_encode($data), 'tr46_response'=> json_encode($response),'tr46_type'=>3]);
                
                if(isset($response->pickup_status))
                {
                    if($response->pickup_status == 1)
                    {
                        $res = [
                                "tr45_pickup_scheduled_date" => $response->response->pickup_scheduled_date,
                                "tr45_pickup_generated_date" => $response->response->pickup_generated_date->date,
                                "tr45_pickup_data" => $response->response->data,
                               
                            ];

                        if(isset($response->response->pickup_token_number))
                        {
                            $res["tr45_pickup_token_number"] = $response->response->pickup_token_number;
                        }

                        $this->ordersiping_repo->updateByShipment($request->txt_orderid, $res);

                        return ['type' => $response->status,  'message' => $msg];
                    }
                }

          
                if(isset($response->errors->order_date[0]))
                {
                    $msg = $response->errors->order_date[0];
                }
                elseif (isset($response->message)) 
                {
                     $msg = $response->message;
                }
                else
                {
                     $msg = 'Order Send successfully';
                }
  
                return ['type' => $response->status,  'message' => $msg];
            }
            else
            {
                return ['type' => 'warning',  'message' => 'Order Not Found!'];
            }
        }
        else
        {
            return ['type' => 'warning',  'message' => 'Shiprocket authentication failed!'];
        }
    }




    public function generateinvoice(request $request)
    {
        $token =  ShipRocket::getToken();
      
        if($token && $request->txt_orderid && $request->shipment_id)
        {           
            $ship = $this->ordersiping_repo->getBySipmentId($request->shipment_id);

            if(count($ship) > 0)
            {

                $data=array(
                  "shipment_id"=> array($request->shipment_id),
                    );

                $response = ShipRocket::GenerateManifest($data,$token);

                DB::table('tr46_shipment_api_request')->insert(['tr46_cart_id' =>$request->txt_orderid, 'tr46_request' =>json_encode($data), 'tr46_response'=> json_encode($response),'tr46_type'=>4]);


                if(isset($response->status))
                {
                    if($response->status == 1)
                    {
                        $this->ordersiping_repo->updateByShipment($request->shipment_id, ["tr45_manifest_url" => $response->manifest_url]);
                    }
                }


                $data=array(
                  "shipment_id"=> array($request->shipment_id),
                );

                $response = ShipRocket::GenerateLabel($data,$token);

                DB::table('tr46_shipment_api_request')->insert(['tr46_cart_id' =>$request->txt_orderid, 'tr46_request' =>json_encode($data), 'tr46_response'=> json_encode($response),'tr46_type'=>5]);
               
               if(isset($response->label_created))
                {
                    if($response->label_created == 1)
                    {
                        $this->ordersiping_repo->updateByShipment($request->shipment_id, ["tr45_label_url" => $response->label_url]);
                    }
                }

                $data=array(
                  "ids"=> array($ship[0]->ORDER_ID),
                );

                $response = ShipRocket::GenerateInvoice($data,$token);

                DB::table('tr46_shipment_api_request')->insert(['tr46_cart_id' =>$request->txt_orderid, 'tr46_request' =>json_encode($data), 'tr46_response'=> json_encode($response),'tr46_type'=>6]);

                if(isset($response->is_invoice_created))
                {
                    if($response->is_invoice_created == true)
                    {
                        $this->ordersiping_repo->updateByShipment($request->shipment_id, ["tr45_invoice_url" => $response->invoice_url]);
                    }
                }
    
                $msg = 'Generate Invoice successfully';
                
                return ['type' => 'success',  'message' => $msg];
            }
            else
            {
                 return ['type' => 'warning',  'message' => 'Order Not Found!'];
            }
        }
        else
        {
             return ['type' => 'warning',  'message' => 'Shiprocket authentication failed!'];
        }
    }





    public function ordercancel(request $request)
    {
        $token =  ShipRocket::getToken();
      
        if($token && $request->txt_orderid && $request->shipment_id)
        {           
            $ship = $this->ordersiping_repo->getBySipmentId($request->shipment_id);

            if(count($ship) > 0)
            {

                $data=array(
                  "ids"=> array($ship[0]->ORDER_ID),
                );

                $response = ShipRocket::OrderCancel($data,$token);

                DB::table('tr46_shipment_api_request')->insert(['tr46_cart_id' =>$request->txt_orderid, 'tr46_request' =>json_encode($data), 'tr46_response'=> json_encode($response),'tr46_type'=>7]);

                if(isset($response->status))
                {
                    if($response->status == '200')
                    {
                        $this->ordersiping_repo->updateByShipment($request->shipment_id, ["tr_45_order_return" => 1, 'tr_45_order_return_msg' => $response->message]);
                    }
                }
    
                $msg = 'Order Cancel successfully';
                
                return ['type' => 'success',  'message' => $msg];
            }
            else
            {
                 return ['type' => 'warning',  'message' => 'Order Not Found!'];
            }
        }
        else
        {
             return ['type' => 'warning',  'message' => 'Shiprocket authentication failed!'];
        }
    }




    /**
    * Method name   : orders
    * @description  : Used for viewing all user orders
    * @param        : Request data  
    * @return       : return view with all user orders
    */
    public function delivered_orders()
    {
        $request = request();
        $start = '2021-07-01';
        $end =  date('Y-m-d'); 
        $user_id = '';
        $order_id = '';
        $cond="";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
            $order_id = $request->input('txt_orderid');

            if($request->input('txt_memberid')!='')
            $user_id = Helper::get_userid($request->input('txt_memberid'));

            if($user_id != '' && $user_id != 'false')
            {
                $cond = $cond."`USER_ID` = $user_id  AND ";
            }
            if($order_id != '' && $order_id != 'false')
            {
                $cond = $cond."`ORDER_CODE` = '".$order_id."'  AND ";
            }
            if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
            {
                $cond = $cond."DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
            }
        }
        $cond = $cond."ORDER_STATUS = 'DELIVERED' AND CART_TYPE != 'WISHLIST' ";
        $all_orders = DB::select('SELECT * FROM `user_orders` WHERE '.$cond);
        return view('Product.delivered-orders', compact('all_orders')); 
    }
    
    
    /**
            * Method name   : view orders
            * @description  : Used for viewing single order
            * @param        : request user id 
            * @return       : return view single order
        */
    public function view_order()
    {
        $request = request();
        $single_order = "";
        if($request->method() == 'POST')
        {
               if($request->input('txt_orderid')=='')
                {
                    $ERRMSG = "Order id should be valid or not blank.";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
                else
                {
                    $ERRMSG = "";
                    $this->isError=FALSE;
                    $ERRCODE="success";
                }
                
                if(request()->method() == 'POST' && $this->isError==FALSE)
                {
                    $single_order = $this->order_repo->getByOrderCode($request->input('txt_orderid'));
                    
                    if($single_order!=null)
                    {
                    $ERRMSG = "Order details fetch successfully.";
                    $ERRCODE="success";
                    }
                    else
                    {
                    $ERRMSG = "Order not found.";
                    $this->isError=TRUE;
                    $ERRCODE="warning";
                    }
                }
        }
        return view('Product.view_order',compact('single_order'));
     
    }



    /**
            * Method name   : view orders
            * @description  : Used for viewing single order
            * @param        : request user id 
            * @return       : return view single order
        */
    public function edit_order()
    {
        $request = request();
        $single_order = "";
        if($request->method() == 'POST')
        {
               if($request->input('txt_orderid')=='')
                {
                    $ERRMSG = "Order id should be valid or not blank.";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
                else
                {
                    $ERRMSG = "";
                    $this->isError=FALSE;
                    $ERRCODE="success";
                }
                
                if(request()->method() == 'POST' && $this->isError==FALSE)
                {
                    $single_order = $this->order_repo->getByOrderCode($request->input('txt_orderid'));
                    
                    if($single_order!=null)
                    {
                    $ERRMSG = "Order details fetch successfully.";
                    $ERRCODE="success";
                    }
                    else
                    {
                    $ERRMSG = "Order not found.";
                    $this->isError=TRUE;
                    $ERRCODE="warning";
                    }
                }
        }
        return view('Product.edit_order',compact('single_order'));
    }



    public function update_order()
    {
        $request = request();
       
        if($request->method() == 'POST')
        {
            if($request->input('dd_orstatus')=='')
            {
                $ERRMSG = "Order status should be valid or not blank.";
                $this->isError= TRUE;
                $ERRCODE="warning";
            }
            else if($request->input('dd_paystatus')=='')
            {
                $ERRMSG = "Payment status should be valid or not blank.";
                $this->isError= TRUE;
                $ERRCODE="warning";
            }
            else
            {
                $ERRMSG = "";
                $this->isError=FALSE;
                $ERRCODE="success";
            }
            if(request()->method() == 'POST'&& $this->isError==FALSE)
            {
                $id = $request->input('txt_order_id');
                $single_order = $this->order_repo->getById($id);

                $arr = array(
                    'tr36_order_status' => $request->input('dd_orstatus'),
                    'tr36_payment_status' => $request->input('dd_paystatus')
                );

                $arrlog = array(
                    'tr11_ar_tblnm' => 'user_order',
                    'tr11_ar_old_value' => "ORDER_STATUS = ".$single_order[0]->ORDER_STATUS." PAYMENT_STATUS  =".$single_order[0]->PAYMENT_STATUS,
                    'tr11_ar_new_value' => "ORDER_STATUS = ".$request->dd_orstatus." PAYMENT_STATUS =".$request->dd_paystatus,
                    'tr11_ar_uid' => 1,
                    'tr11_ar_description' => 'ORDER STATUS HAS BEEN CHANGED SUCCESSFULLY!',
                    'tr11_updated_by' => 1,
                    'tr11_updated_by_id' =>  Session::get('USER_ID')
                    );
                

                if($request->input('dd_orstatus') == 3)
                {   
            
                    if($single_order[0]->ORDER_STATUS != 'CANCELLED' && $single_order[0]->LEDGER_ID != '')
                    {
                               $shoppingwallet=array(
                                        'proc'=>10,
                                        'to_user_id'=>Session::get('USER_ID'),
                                        'from_user_id'=>0,
                                        'amount'=>floatval(0.00),
                                        'collected_amount'=>floatval(0.00),
                                        'requesttype'=>1,
                                        'balfor'=>1,
                                        'transtype'=>1,
                                        'timelimit'=>300,
                                        'defaultstatus'=>1,
                                        'remark'=>$single_order[0]->LEDGER_ID,
                                        'collected_remark'=>"Shoping Payment"
                                    );

                                    $shopping_wallet = DB::SELECT('CALL wallettransfer(
                                        :proc, 
                                        :to_user_id,
                                        :from_user_id,
                                        :amount, 
                                        :collected_amount,
                                        :requesttype,
                                        :balfor,
                                        :transtype,
                                        :timelimit,
                                        :defaultstatus,
                                        :remark,
                                        :collected_remark,
                                        @status_code,
                                        @status_msg)'
                                    ,$shoppingwallet);
                                    $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
                                    $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');

                        if($ERRCODE[0]->ERR_CODE == 'success')
                        {
                            $this->order_repo->update($id,$arr);
                        }
                    }
                }
                else
                {
                    $this->order_repo->update($id,$arr);
                }
                
                $mobileno_actionrecord=$this->log_repo->create($arrlog);
            }
        }
        return redirect('/orders');
    }

    public function update_revised_qty(request $request)
    {
          
            $single_order = $this->order_repo->getById($request->order_id);
            if(count($single_order) > 0)
            {

                $user_cart = json_decode($single_order[0]->PRODUCT_DETAILS);

                $prod_id_list = array_column($user_cart, 'prod_id');
                $varnt_id_list = array_column($user_cart, 'varnt_id');
                $is_variant_list = array_column($user_cart, 'is_variant');
                $count = count($user_cart);

                if(in_array($request->prod_id, $prod_id_list) && in_array($request->provar_id, $varnt_id_list) && in_array($request->proisvar, $is_variant_list))
                { 
                    for($i=0;$i<$count;$i++)
                    {
                        if(($user_cart[$i]->prod_id == $request->prod_id) && ($user_cart[$i]->varnt_id == $request->provar_id) && ($user_cart[$i]->is_variant == $request->proisvar))
                        {  
                            $index = $i;
                            $oldqty= $user_cart[$index]->new_quantity;
                            $user_cart[$index]->new_quantity = (int)($request->quantity);
                            $total = 0;
                            foreach ($user_cart as $value) {
                               $total += $value->new_quantity*$value->disc_price;
                            }
                              
                            $array = ['tr36_product_details' => json_encode($user_cart),
                                      'tr36_final_amount' => $total];

                            $data = $this->order_repo->update($request->order_id, $array);
                            if($data)
                            {

                                $arrlog = array(
                                    'tr11_ar_tblnm' => 'user_order',
                                    'tr11_ar_old_value' => "PRODUCT_DETAILS = ".$oldqty,
                                    'tr11_ar_new_value' => "PRODUCT_DETAILS = ".$user_cart[$index]->new_quantity,
                                    'tr11_ar_uid' => 1,
                                    'tr11_ar_description' => 'ORDER QTY HAS BEEN CHANGED SUCCESSFULLY!',
                                    'tr11_updated_by' => 1,
                                    'tr11_updated_by_id' =>  Session::get('USER_ID')
                                );

                                $mobileno_actionrecord=$this->log_repo->create($arrlog);

                                return 1;
                            }
                            else
                            {
                                return 2;
                            }
                        }
                    }
                }
            }
            else
            {
                return 2;
            }
    }








}
