<?php

namespace App\Http\Controllers;
use App\Repositories\Notification\NotificationRepository;
use Illuminate\Http\Request;
use Session;
use DB;

date_default_timezone_set('Asia/Kolkata');

class NotificationController extends Controller
{
 
    private $NotificationRepo;


    public function __construct(NotificationRepository $NotificationRepo)
    {
        $this->NotificationRepo = $NotificationRepo;
    }


    /**
        * Method name   : Get notification
        * @description  : get all unread  notifications  
        * @param        : Request
        * @return       : return view ajax function Getinotification()
    */   
    public function get_notification()
    {   
       $notify = $this->NotificationRepo->GetAll(); 

        $datanotify  = '';

        foreach($notify as $value)
                        {
                $datanotify .= "<li>";
                $datanotify .= "<a class='media' href='#' onclick='ReadNotificat(this.id)' id='".$value->NID."'>";

                $datanotify .= "<div class='media-left'>
                                    <i class='demo-pli-file-edit icon-1x'></i>
                                </div>";

                $datanotify .=  "<div class='media-body'>
                                    <p class='mar-no text-nowrap text-main text-semibold'> ".$value->TYPE."</p> <small>".$value->NOTIFIABLE." ". $value->DATA." ".$value->DATE."</small>
                                </div>
                            </a>
                        </li>";
                    }

       return $datanotify;

    }




    /**
        * Method name   : Update Get Notificat
        * @description  : hidden single notification  
        * @param        : Request
        * @return       : return view ajax function ReadNotificat(id)
    */  

    public function UpdateGetNotificat(request $request)
    {
        $id = $request->get_id;

        $dataarray = array(
            'm51_read_at' => date('Y-m-d H:i:s')
        );
        $this->NotificationRepo->UpdateData($id, $dataarray);
    }    


 
    /**
        * Method name   : Update Get Notificats
        * @description  : hidden All notification  
        * @param        : Request
        * @return       : return view ajax function ReadAllNotificat()
    */  
    public function UpdateGetNotificats(request $request)
    {
            $dataarray = array(
            'm55_read_at' => date('Y-m-d H:i:s')
                );
            
            $this->NotificationRepo->UpdateAllData($dataarray);
    }









    public function ViewNotification()
    {
        $data = $this->NotificationRepo->GetAllUser();
        return view('Master.view-notification-master',compact('data'));
    }


    /**
        * Method name   : Create Notification
        * @description  : insert notification for users 
        * @param        : Request
        * @return       : return view notification master page
    */   
    public function create_notification(request $request)
    {  

        $this->validate($request, [
            'txt_title_name'=> 'required|max:50|min:5',
            'txt_desc'=> 'required|max:120|min:5',
            'dd_show'=> 'required',
        ],
        [
            'txt_title_name.required'=> 'Title is required',
            'txt_title_name.max'=> 'Title maximum 50 characters allowed',
            'txt_title_name.min'=> 'Title minimum 5 characters allowed',
            'txt_desc.required'=> 'Description is required',
            'txt_desc.max'=> 'Description maximum 120 characters allowed',
            'txt_desc.min'=> 'Description minimum 5 characters allowed',
            'dd_show.required'=> 'Show For is required',

        ]);
       
        $dataarray = array(
            'm55_type' => $request->input('txt_title_name'),
            'm55_data' => $request->input('txt_desc'),
            'm55_show' => $request->input('dd_show')
        );


        $data = $this->NotificationRepo->InsertData($dataarray);


        if($data)
        {
        return redirect ('view_notification')->with('message','Notification add successfully');
        }
        else
        {
        return redirect ('view_notification')->with('error','Notification not add');
        }

    }









 public function update_notification($id)
    { 
        $singledata = $this->NotificationRepo->GetByIdUser($id);
        $data = $this->NotificationRepo->GetAllUser();
        return view('Master.edit-notification-master',compact('data','singledata'));
    }






    /**
        * Method name   : Create Notification
        * @description  : insert notification for users 
        * @param        : Request
        * @return       : return view notification master page
    */   
    public function edit_notification(request $request, $id)
    {  

        $this->validate($request, [
            'txt_title_name'=> 'required|max:50|min:5',
            'txt_desc'=> 'required|max:120|min:5',
            'dd_show'=> 'required',
        ],
        [
            'txt_title_name.required'=> 'Title is required',
            'txt_title_name.max'=> 'Title maximum 50 characters allowed',
            'txt_title_name.min'=> 'Title minimum 5 characters allowed',
            'txt_desc.required'=> 'Description is required',
            'txt_desc.max'=> 'Description maximum 120 characters allowed',
            'txt_desc.min'=> 'Description minimum 5 characters allowed',
            'dd_show.required'=> 'Show For is required',

        ]);
       
        $dataarray = array(
            'm55_type' => $request->input('txt_title_name'),
            'm55_data' => $request->input('txt_desc'),
            'm55_show' => $request->input('dd_show')
        );


        $data = $this->NotificationRepo->UpdateData($id, $dataarray);


        if($data)
        {
        return redirect ('view_notification')->with('message','Notification update successfully');
        }
        else
        {
        return redirect ('view_notification')->with('error','Notification not update');
        }

    }




    /**
        * Method name   : Get user notification
        * @description  : get all unread  notifications  
        * @param        : Request
        * @return       : return view ajax function Getuserinotification()
    */   
    public function getuser_notification()
    {   
       $notify = $this->NotificationRepo->GetAllUser(); 

        $datanotify  = '';

        foreach($notify as $value)
            {

            $str = $value->NOTIFIABLE;

            $usearray = explode(',',$str);
            foreach ($usearray as $users) {
            if ($users == 'Amit Kumar') {
                    $nusers = $users;
            }
            }
            echo $nusers;
            if (empty($nusers))
               {
                    echo "string";

                $datanotify .= "<li>";
                $datanotify .= "<a class='media' href='#' onclick='ReadUserNotificat(this.id,name)' id='".$value->NID."'>";
                $datanotify .= "<div class='media-left'>
                                    <i class='demo-pli-file-edit icon-1x'></i>
                                </div>";
                $datanotify .=  "<div class='media-body'>
                                    <p class='mar-no text-nowrap text-main text-semibold'> ".$value->TYPE."</p> <small>". $value->DATA." ".$value->DATE."</small>
                                </div>
                            </a>
                        </li>";
                  }
                }

       return $datanotify;

    }






    /**
        * Method name   : Update Get Notificat
        * @description  : hidden single notification  
        * @param        : Request
        * @return       : return view ajax function ReadNotificat(id)
    */  

    public function UpdateUserGetNotificat(request $request)
    {
        $id = $request->get_id;
        $usern = $request->usern;
        $notify = $this->NotificationRepo->GetAllUser(); 
        $alldata = DB::table('notifications')->where('NID', $id)->first();
        $indata = $alldata->NOTIFIABLE.", ".$usern;

        $dataarray = array(
            'm55_notifiable' => $indata
        );

        $this->NotificationRepo->UpdateData($id, $dataarray);
    }    









		

}