<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\Master\Configuration\ConfigurationRepository;
use App\Repositories\Master\Location\LocationRepository;
use App\Repositories\Master\Events\EventsRepository;
use App\Repositories\Master\Bank\BankRepository;
use App\Repositories\Master\Service\ServiceRepository;
use App\Repositories\Master\Operator\OperatorRepository;
use App\Repositories\Master\Message\MessageRepository;
use App\Repositories\Master\Content\ContentRepository;
use App\Repositories\Master\Package\PackageRepository;
use App\Repositories\Master\AdminBank\AdminBankRepository;
use App\Repositories\Master\Banner\BannerRepository;
use App\Repositories\Master\Assignmenu\AssignmenuRepository;
use App\Repositories\Master\Usermenu\UsermenuRepository;
use App\Repositories\Ticket\TicketRepository;
use App\Repositories\Enroll\EnrollRepository;
use App\Repositories\Employee\EmployeeRepository;
use App\Repositories\Log\LogRepository;
use App\Repositories\Master\Role\RoleRepository;
use App\Repositories\Affiliate\AffiliateRepository;
use App\Repositories\DenominationRange\DenominationRangeRepository;
use App\Repositories\Denomination\DenominationRepository;
use App\Repositories\Master\BalanceDeductionTypes\BalanceDeductionTypesRepository;
use App\Repositories\Master\LevelCommissionType\LevelCommissionTypesRepository;
use App\Repositories\Master\Imagesize\ImagesizeRepository;
use App\Repositories\ProductModule\Categories\CategoriesRepository;
use DB;
use Image;
use Session;
use Helper;
use Hash;

class MasterController extends Controller
{
    private $STATUS = "failed";
	private $ERRMSG = "Invalid Operation";
	private $ERRCODE = 0;
	private $isError = FALSE;
	private $record_per_page =10;
    private $userDisbled = 0;

    private $config_repo;
    private $loc_repo;
    private $events_repo;
	private $bank_repo;
	private $service_repo;
	private $operator_repo;
	private $message_repo;
	private $content_repo;
	private $package_repo;
	private $adminbank_repo;
    private $banner_repo;
    private $ticket_repo;
    private $enroll_repo;
    private $assignmenu_repo;
    private $usernmenu_repo;
    private $emp_repo;
	private $log_repo;
    private $Role_repo;
    private $Affiliate_repo;
    private $DenominationRange_repo;
    private $Denomination_repo;
    private $BalanceDeductionTypes_repo;
	private $LevelCommissionTypes_repo;
    private $imagesize_repo;
    private $cat_repo;

	public function __construct(ConfigurationRepository $config_repo, LocationRepository $loc_repo,
		EventsRepository $events_repo, BankRepository $bank_repo, ServiceRepository $service_repo,
		OperatorRepository $operator_repo, MessageRepository $message_repo, 
		ContentRepository $content_repo, PackageRepository $package_repo, AdminBankRepository $adminbank_repo,
        RoleRepository $Role_repo, TicketRepository $ticket_repo, EnrollRepository $enroll_repo, BannerRepository $banner_repo,
        AssignmenuRepository $assignmenu_repo, UsermenuRepository $usernmenu_repo, EmployeeRepository $emp_repo,
        LogRepository $log_repo, AffiliateRepository $Affiliate_repo, 
        DenominationRangeRepository $DenominationRange_repo, DenominationRepository $Denomination_repo, BalanceDeductionTypesRepository $BalanceDeductionTypes_repo, LevelCommissionTypesRepository $LevelCommissionTypes_repo,
        ImagesizeRepository $imagesize_repo, CategoriesRepository $cat_repo)
    {
    	$this->config_repo = $config_repo;
    	$this->loc_repo = $loc_repo;
    	$this->events_repo = $events_repo;
    	$this->bank_repo = $bank_repo;
    	$this->service_repo = $service_repo;
    	$this->operator_repo = $operator_repo;
    	$this->message_repo = $message_repo;
    	$this->content_repo = $content_repo;
    	$this->package_repo = $package_repo;
    	$this->adminbank_repo = $adminbank_repo;
        $this->ticket_repo = $ticket_repo;
        $this->enroll_repo = $enroll_repo;
        $this->banner_repo = $banner_repo;
        $this->assignmenu_repo = $assignmenu_repo;
        $this->usernmenu_repo = $usernmenu_repo;
        $this->emp_repo = $emp_repo;
		$this->log_repo = $log_repo;
        $this->Role_repo = $Role_repo;
		$this->Affiliate_repo = $Affiliate_repo;
        $this->DenominationRange_repo = $DenominationRange_repo;
        $this->Denomination_repo = $Denomination_repo;
        $this->BalanceDeductionTypes_repo = $BalanceDeductionTypes_repo;
		$this->LevelCommissionTypes_repo = $LevelCommissionTypes_repo;
        $this->imagesize_repo = $imagesize_repo;
        $this->cat_repo = $cat_repo;
    }

    /**
        * Method name   : Index
        * @description  : Used for view soft login 
        * @param        : Request data  
        * @return       : return view
    */
	public function index()
    {
		return view('Master.view_soft_login');
	}

	/**
        * Method name   : View Soft Login
        * @description  : Used for view soft login 
        * @param        : Request data  
        * @return       : return view
    */
	public function view_soft_login()
    {

        $admin_detail = Helper::get_admin_details();
        $admin_loginlog = Helper::get_login_log(0);
    	return view('Master.view_soft_login', compact('admin_detail', 'admin_loginlog'));

    }

    /**
        * Method name   : Update Soft Login
        * @description  : Used for updating admin login details
        * @param        : Request data  
        * @return       : return to view with updated admin login details
    */
    public function update_soft_login($id){
        $request = request();
        $mcf=array(
        'm00_login_id'=>$id,
        'm00_otpenable'=>$request->input('rb_otpenable')
        );
  		
        $result = $this->config_repo->setAdminLogin_twofa($mcf);
        $admin_detail = Helper::get_admin_details();
        Session::flash('admin_msg','ADMIN LOGIN UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );
		$admin_loginlog = Helper::get_login_log(0);
    	return view('Master.view_soft_login', compact('admin_detail', 'admin_loginlog'));
    }




    /**
        * Method name   : Update Soft Login
        * @description  : Used for updating admin login details
        * @param        : Request data  
        * @return       : return to view with updated admin login details
    */
    public function update_soft_logins($id){
        $request = request();

        $this->validate($request, [
            'txtusername'=> 'required',
            'txtuserpass'=> 'required',
            'txtuserpinpass'=> 'required',
        ],[
            'txtusername.required'=> 'User Name is required',
            'txtuserpass.required'=> 'User Password is required',
            'txtuserpinpass.required'=> 'User Pin Password is required',
        ]);

        $mcf=array(
        'm00_login_id'=>$id,
        'm00_username'=>$request->input('txtusername'),
        'm00_password'=>Hash::make($request->input('txtuserpass')),
        'm00_pinpassword'=>Hash::make($request->input('txtuserpinpass'))
        );

        $result = $this->config_repo->setAdminLogin($mcf);
        $admin_detail = Helper::get_admin_details();
        Session::flash('admin_msg','ADMIN LOGIN UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );
		$admin_loginlog = Helper::get_login_log(0);
    	return view('Master.view_soft_login', compact('admin_detail', 'admin_loginlog'));
    }


    /**
        * Method name   : Country 
        * @description  : Used for viewing all countries and single country 
        * @param        : Request data with country id  
        * @return       : return to view with country data
    */
    public function country($id = '')
    {
        $singlecountry = '';
        $country = $this->loc_repo->getAllCountries();
        if( $id != '' ){
            $singlecountry = $this->loc_repo->getById($id);
        }
        return view('Master.country', compact('country', 'singlecountry'));
    }

    /**
        * Method name   : Add Country 
        * @description  : Used for adding country 
        * @param        : Request data 
        * @return       : return to route
    */
    public function add_country(Request $request){

        $this->validate($request, [
            'txtcountryname'=> 'required',
        ],[
            'txtcountryname.required'=> 'Country Name is required',
        ]);
       
        $arr = array(
            'm02_loc_name' => $request->input('txtcountryname'),
            'm02_parent_id' => -1,
            'm02_status' => 1,
            'm02_created_by' => 2,
            'm02_created_by_id' => 1
        );

        $this->loc_repo->create($arr);
        Session::flash('country_msg','COUNTRY ADDED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/country');
    }

    /**
        * Method name   : Update Country 
        * @description  : Used for updating country details
        * @param        : Request data 
        * @return       : return to route
    */
    public function update_country(Request $request, $country_id){
        $this->validate($request, [
            'txtcountryname'=> 'required',
        ],[
            'txtcountryname.required'=> 'Country Name is required',
        ]);
       
        $arr = array(
            'm02_loc_name' => $request->input('txtcountryname'),
            'm02_parent_id' => -1,
            'm02_status' => 1
        );
       
        $this->loc_repo->update($country_id, $arr);
        Session::flash('country_msg','COUNTRY UPDATED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/country');
    }

    /**
        * Method name   : Country status
        * @description  : Used for updating country status
        * @param        : Request data 
        * @return       : return to route
    */
    public function country_status(Request $request){
        $request = request();
        $country_id = $request->input('txt_country_id');

        $this->loc_repo->active($country_id);

        Session::flash('country_msg','COUNTRY STATUS UPDATED SUCCESSFULLY!' );
        Session::flash('type','success' );
        return redirect('/country');
    }

    /**
        * Method name   : State
        * @description  : Used for view all states 
        * @param        : Request data with state id 
        * @return       : return view with all states or single states
    */
    public function state($id = '')
    {
        $singlestate = '';
        $state = $this->loc_repo->getAllStates();
        $country = $this->loc_repo->getAllCountries();

        if( $id != '' ){
            $singlestate =  $this->loc_repo->getById($id);
        }
        return view('Master.state', compact('country', 'state', 'singlestate'));
    }

    /**
        * Method name   : Add State
        * @description  : Used for adding state
        * @param        : Request data  
        * @return       : return with added state
    */
    public function add_state(Request $request){
        $this->validate($request, [
            'txt_statename'=> 'required',
            'txt_parent' => 'required',
        ],[
            'txt_statename.required'=> 'State Name is required',
            'txt_parent.required' => 'Country is required',
        ]);
       
        $arr = array(
            'm02_loc_name' => $request->input('txt_statename'),
            'm02_parent_id' => $request->input('txt_parent'),
            'm02_status' => 1,
            'm02_created_by' => 2,
            'm02_created_by_id' => 1
        );

        $this->loc_repo->create($arr);
        Session::flash('state_msg','STATE ADDED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/state');
    }

    /**
        * Method name   : Update State
        * @description  : Used for updating state 
        * @param        : Request data with state id 
        * @return       : return with updated state
    */
    public function update_state(Request $request, $state_id){

        $this->validate($request, [
            'txt_statename'=> 'required',
            'txt_parent' => 'required',
        ],[
            'txt_statename.required'=> 'State Name is required',
            'txt_parent.required' => 'Country is required',
        ]);
       
        $arr = array(
            'm02_loc_name' => $request->input('txt_statename'),
            'm02_parent_id' => $request->input('txt_parent'),
            'm02_status' => 1
        );
       
        $this->loc_repo->update($state_id, $arr);
        Session::flash('state_msg','STATE UPDATED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/state');
    }

    /**
        * Method name   : State status
        * @description  : Used for updating state status
        * @param        : Request data 
        * @return       : return to route
    */
    public function state_status(Request $request){
        $request = request();
        $state_id = $request->input('txt_state_id');

        $this->loc_repo->active($state_id);

        Session::flash('state_msg','STATE STATUS UPDATED SUCCESSFULLY!' );
        Session::flash('type','success' );
        return redirect('/state');
    }

    /**
        * Method name   : City
        * @description  : Used for getting all cities or single city
        * @param        : Request data with city id 
        * @return       : return view city data
    */
    public function city($id = '')
    {
        $singlecity = '';

        $city = $this->loc_repo->getAllCities();
        $state = $this->loc_repo->getAllStates();

        if( $id != '' ){
            $singlecity =  $this->loc_repo->getById($id);
        }
        return view('Master.city', compact('state', 'city', 'singlecity'));
    }

    /**
        * Method name   : Add city
        * @description  : Used for adding city
        * @param        : Request data  
        * @return       : return with added city
    */
    public function add_city(Request $request){

        $this->validate($request, [
            'txt_cityname'=> 'required',
            'txt_parent' => 'required',
        ],[
            'txt_cityname.required'=> 'City Name is required',
            'txt_parent.required' => 'State is required',
        ]);
       
        $arr = array(
            'm02_loc_name' => $request->input('txt_cityname'),
            'm02_parent_id' => $request->input('txt_parent'),
            'm02_status' => 1,
            'm02_created_by' => 2,
            'm02_created_by_id' => 1
        );

        $this->loc_repo->create($arr);
        Session::flash('city_msg','CITY ADDED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/city');
    }

    /**
        * Method name   : Update City
        * @description  : Used for updating city
        * @param        : Request data with city id 
        * @return       : return with updated city
    */
    public function update_city(Request $request, $city_id){

        $this->validate($request, [
            'txt_cityname'=> 'required',
            'txt_parent' => 'required',
        ],[
            'txt_cityname.required'=> 'City Name is required',
            'txt_parent.required' => 'State is required',
        ]);
       
        $arr = array(
            'm02_loc_name' => $request->input('txt_cityname'),
            'm02_parent_id' => $request->input('txt_parent'),
            'm02_status' => 1,
        );

       	$this->loc_repo->update($city_id, $arr);
        Session::flash('city_msg','CITY UPDATED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/city');
    }

    /**
        * Method name   : City status
        * @description  : Used for updating city status
        * @param        : Request data 
        * @return       : return to route
    */
    public function city_status(Request $request){
        $request = request();
        $city_id = $request->input('txt_city_id');

        $this->loc_repo->active($city_id);

        Session::flash('city_msg','CITY STATUS UPDATED SUCCESSFULLY!' );
        Session::flash('type','success' );
        return redirect('/city');
    }

    /**
        * Method name   : View News
        * @description  : Used for getting all news or single news
        * @param        : Request data  
        * @return       : return with all news
    */
    public function view_news($id='')
	{
        $singlenews = '';

        $user_news =  $this->events_repo->getAll();
        if( $id != '' ){
            $singlenews =  $this->events_repo->getById($id);
        }
        return view('Master.view_news', compact('user_news','singlenews'));   
    }



    /**
        * Method name   : View event
        * @description  : Used for getting all news or single event
        * @param        : Request data  
        * @return       : return with all event
    */
    public function view_event($id='')
	{
        $singlenews = '';

        $user_news =  $this->events_repo->getAll();
        if( $id != '' ){
            $singlenews =  $this->events_repo->getById($id);
        }
        return view('Master.event', compact('user_news','singlenews'));   
    }

    /**
        * Method name   : Add News
        * @description  : Used for adding news
        * @param        : Request data  
        * @return       : return with adding news
    */
    public function add_news(Request $request)
	{
        $this->validate($request, [
            'dd_status'=> 'required',
            'dd_status' => 'required',
        ],[
            'txt_title.required'=> 'News is required',
            'dd_status.required' => 'Status is required',
        ]);

        $arr = array(
        'm24_news_title' => $request->input('txt_title'),
        'm24_news_des' => $request->input('txt_desc'),
        'm24_news_for' => $request->input('dd_news_for'),
        'm24_news_status' => $request->input('dd_status'),
        'm24_affid' => 1,
        'm24_entrydate' => date('Y-m-d H:i:s'),
        'm24_created_by' => 1,
        'm24_created_by_id' => 1
        );
        $this->events_repo->create($arr);
		Session::flash('message_msg','NEWS ADDED SUCCESSFULLY HERE!' );
		Session::flash('type','success' );
        return redirect('/view_news');
    }

    /**
        * Method name   : Update news detail
        * @description  : Used for updating news detail
        * @param        : Request data with news id
        * @return       : return with updated news
    */
    public function update_news_detail($id)
    {
        $request = request();

        $this->validate($request, [
            'dd_status'=> 'required',
            'dd_status' => 'required',
        ],[
            'txt_title.required'=> 'News is required',
            'dd_status.required' => 'Status is required',
        ]);

        $arr = array(
        'm24_news_title' => $request->input('txt_title'),
        'm24_news_des' => $request->input('txt_desc'),
        'm24_news_for' => $request->input('dd_news_for'),
        'm24_news_status' => $request->input('dd_status'),
        'm24_entrydate' => date('Y-m-d H:i:s'),
        'm24_updated_by' => 1,
        'm24_updated_by_id' => 1
        );
        $this->events_repo->update($id, $arr);
        Session::flash('message_msg','NEWS UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );
        return redirect('/view_news');
    }

    /**
        * Method name   : News status
        * @description  : Used for updating news status 
        * @param        : Request data with news id  
        * @return       : return with updated news
    */
    public function news_status()
    {
        $txtuserid = '';
        $request = request();
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
                if($request->input('txt_statusregid')=="")
                {
                    $ERRMSG = "Bank should be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }   
                if(request()->method() == 'POST'&& $this->isError==FALSE)
                {	
                    $user_status=$this->events_repo->active($request->input('txt_statusregid'));
                    $ERRMSG="NEWS STATUS HAS BEEN UPDATE SUCCESSFULLY!";
                    $ERRCODE='success'; 
                }
                Session::flash('message_msg',$ERRMSG);
                Session::flash('type',$ERRCODE);
        }
        return redirect()->to('view_news');
    }

    /**
        * Method name   : Bank account
        * @description  : Used for getting bank accountview_config
        * @param        : Request data with bank id  
        * @return       : return with updated bank
    */
    public function bank_account( $id='' )
	{
		$SB_CA = '';
        $singlebank = '';

		$bank =  DB::select('SELECT * FROM `bank`');
		if( $id != '' ){
            $SB_CA = $this->adminbank_repo->getById($id);
        }
		$company_bank_account =  DB::select('SELECT * FROM `company_bank_account`');
        return view('Master.view_bank_account', compact('bank','company_bank_account','SB_CA'));
    }

    /**
        * Method name   : Add Bank Account
        * @description  : Used for adding bank account
        * @param        : Request data  
        * @return       : return with added bank account
    */
    public function add_bank_account()
	{
		$singlebank = '';
		$request = request();
        $this->validate($request, [
            'dd_bank'=> 'required',
            'txt_name_atbank_account' => 'required',
            'txt_bank_branch' => 'required',
            'txt_bank_account_no' => 'required',
            'dd_bank_account_type' => 'required',
            'txt_bank_ifsc' => 'required',
            'dd_bank_account_status' => 'required',
        ],[
            'dd_bank.required'=> 'Bank is required',
            'txt_name_atbank_account.required' => 'Name at bank is required',
            'txt_bank_branch.required'=> 'Bank branch is required',
            'txt_bank_account_no.required' => 'Account no. is required',
            'dd_bank_account_type.required'=> 'Account type is required',
            'txt_bank_ifsc.required' => 'Bank IFSC is required',
            'dd_bank_account_status.required'=> 'Account status is required',
        ]);

		if($_SERVER['REQUEST_METHOD']=="POST")
		{
           if($request->file('txt_banklogo') != ''){
                $image = $request->file('txt_banklogo');
                $name1 = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/images/bank_logo/');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
					$image->move($destinationPath, $name1);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
                $txt_image=$name1;
            }
            else
            {
                $txt_image=$request->input('txt_banklogohd');
            }
		    $arr = array(
				'm01_bank_id'=>$request->input('dd_bank'),
				'm11_user_id'=> 1,
				'm27_adminbank_displayname' => $request->input('txt_name_atbank_account'),
				'm27_adminbank_branch'=>$request->input('txt_bank_branch'),
				'm27_adminbank_accountno'=>$request->input('txt_bank_account_no'),
				'm27_adminbank_type'=>$request->input('dd_bank_account_type'),
                'm27_adminbank_ifscode'=>$request->input('txt_bank_ifsc'),
                'm27_adminbank_logo'=>$txt_image,
				'm27_adminbank_status'=>$request->input('dd_bank_account_status'),
				'm27_adminbank_createdat'=>date('Y-m-d H:i:s')
			);
			$this->adminbank_repo->create($arr);
		}
		$bank =  DB::select('SELECT * FROM bank');
		$company_bank_account =  DB::select('SELECT * FROM company_bank_account');
		Session::flash('adminbk_msg','ADMIN BANK ACCOUNT ADDED SUCCESSFULLY!' );
		Session::flash('type','info' );
        return view('Master.view_bank_account', compact('bank','company_bank_account'));
	}

	/**
        * Method name   : Updated bank account
        * @description  : Used for updating bank account
        * @param        : Request data with bank id 
        * @return       : return with updated bank account
    */
	public function update_bank_account($id){
	    $singlebank = '';
        $request = request();
        $this->validate($request, [
            'dd_bank'=> 'required',
            'txt_name_atbank_account' => 'required',
            'txt_bank_branch' => 'required',
            'txt_bank_account_no' => 'required',
            'dd_bank_account_type' => 'required',
            'txt_bank_ifsc' => 'required',
            'dd_bank_account_status' => 'required',
        ],[
            'dd_bank.required'=> 'Bank is required',
            'txt_name_atbank_account.required' => 'Name at bank is required',
            'txt_bank_branch.required'=> 'Bank branch is required',
            'txt_bank_account_no.required' => 'Account no. is required',
            'dd_bank_account_type.required'=> 'Account type is required',
            'txt_bank_ifsc.required' => 'Bank IFSC is required',
            'dd_bank_account_status.required'=> 'Account status is required',
        ]);

		if($_SERVER['REQUEST_METHOD']=="POST")
		{
            if( $_FILES['txt_banklogo']['name'] != ''){
                $image = $request->file('txt_banklogo');
                $name1 = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/images/bank_logo/');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
					$image->move($destinationPath, $name1);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
                $txt_image=$name1;
            }
            else
            {
                $txt_image=$request->input('txt_banklogohd');
            }
			$arr = array(
				'm01_bank_id'=>$request->input('dd_bank'),
				'm11_user_id'=> 1,
				'm27_adminbank_displayname' => $request->input('txt_name_atbank_account'),
				'm27_adminbank_branch'=>$request->input('txt_bank_branch'),
				'm27_adminbank_accountno'=>$request->input('txt_bank_account_no'),
				'm27_adminbank_type'=>$request->input('dd_bank_account_type'),
                'm27_adminbank_ifscode'=>$request->input('txt_bank_ifsc'),
                'm27_adminbank_logo'=>$txt_image,
				'm27_adminbank_status'=>$request->input('dd_bank_account_status')
			);
			$this->adminbank_repo->update($id, $arr);
			Session::flash('adminbk_msg','BANK ACCOUNT UPDATED SUCCESSFULLY' );
			Session::flash('type','success' );
		}
			if( $id != '' ){
            $SB_CA =  $this->adminbank_repo->getById($id);
        }
		$bank =  DB::select('SELECT * FROM bank');
		$company_bank_account =  DB::select('SELECT * FROM company_bank_account');
        return view('Master.view_bank_account', compact('bank','company_bank_account','SB_CA'));
    }

    /**
        * Method name   : Bank account status
        * @description  : Used for updating bank account status
        * @param        : Request data with bank id
        * @return       : return with updated bank account status
    */
    public function bank_account_status()
    {
        $txtuserid = '';
		$status=1;
        $request = request();
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
                if($request->input('txt_admin_bank_id')=="")
                {
                    $ERRMSG = "Bank Account should be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }   
				else if($request->input('txt_admin_bank_id')=="")
				{
					$ERRMSG = "Bank Account status should be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
				}
				else
				{
					if($request->input('txt_admin_bank_status')=="ACTIVE")
						$status=2;
					else
						$status=1;
				}
                if(request()->method() == 'POST' && $this->isError==FALSE)
                {
					
                    $user_status=DB::select("Update m27_admin_bank SET m27_adminbank_status =".$status." WHERE m27_adminbank_id =".$request->input('txt_admin_bank_id')."");
                    $ERRMSG="BANK ACCOUNT STATUS HAS BEEN UPDATE SUCCESSFULLY!";
                    $ERRCODE='success'; 
					//dd($user_status);
                }
                Session::flash('adminbk_msg',$ERRMSG);
                Session::flash('type',$ERRCODE);
        }
       return redirect()->to('bank_account');
    }

    /**
        * Method name   : View Bank
        * @description  : Used for viewing bank details
        * @param        : Request data  
        * @return       : return bank details
    */
    public function view_bank( $id='' ){
        $singlebank = '';
        $bank = $this->bank_repo->getAll();
        if( $id != '' ){
            $singlebank = $this->bank_repo->getById($id);
        }
        return view('Master.view_bank_master', compact('bank','singlebank'));
    }

    /**
        * Method name   : Add bank
        * @description  : Used for inserting bank 
        * @param        : Request data  
        * @return       : return route with success
    */
    public function add_bank(){
	    $singlebank = '';
        $request = request();

        $this->validate($request, [
            'txt_bank_name' => 'required',
            'txt_ifsc_code' => 'required',
            'rb_status' => 'required'
        ],[
            'txt_bank_name.required'=> 'Bank name is required',
            'txt_ifsc_code.required' => 'required',
            'rb_status.required' => 'Bank status is required'         
        ]);

        $arr = array(
            'm01_bank_name' => $request->input('txt_bank_name'),
            'm01_bank_ifsc' => $request->input('txt_ifsc_code'),
            'm01_bank_status' => $request->input('rb_status'),
            'm01_created_by' => 2,
            'm01_created_by_id' => 1
        );
        $this->bank_repo->create($arr);
	    Session::flash('bank_msg','BANK ADDED SUCCESSFULLY' );
		Session::flash('type','success' );
        return redirect('/view_bank');
    }

    /**
        * Method name   : Update Bank
        * @description  : Used for updating bank details
        * @param        : Request data with bank id
        * @return       : return view
    */
    public function update_bank_detail($id){
	    $singlebank = '';
        $request = request();

        $this->validate($request, [
            'txt_bank_name' => 'required',
            'txt_ifsc_code' => 'required',
            'rb_status' => 'required'
        ],[
            'txt_bank_name.required'=> 'Bank name is required',
            'txt_ifsc_code.required' => 'required',
            'rb_status.required' => 'Bank status is required'         
        ]);

        $arr = array(
            'm01_bank_name' => $request->input('txt_bank_name'),
            'm01_bank_ifsc' => $request->input('txt_ifsc_code'),
            'm01_bank_status' => $request->input('rb_status')
        );
        $this->bank_repo->update($id, $arr);
	    Session::flash('bank_msg','BANK UPDATED SUCCESSFULLY' );
		Session::flash('type','success' );
		return redirect('/view_bank');
    }

    /**
        * Method name   : Bank Status
        * @description  : Used for updating bank status
        * @param        : Request data with bank id
        * @return       : return view
    */
    public function bank_status()
    {
        $txtuserid = '';
        $request = request();
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
                if($request->input('txt_statusregid')=="")
                {
                    $ERRMSG = "Bank should be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }   
                if(request()->method() == 'POST'&& $this->isError==FALSE)
                {
                    $user_status=$this->bank_repo->active($request->input('txt_statusregid'));
                    $ERRMSG="BANK STATUS HAS BEEN UPDATE SUCCESSFULLY!";
                    $ERRCODE='success'; 
                }
                Session::flash('bank_msg',$ERRMSG);
                Session::flash('type',$ERRCODE);
        }
        return redirect()->to('view_bank');
    }

    /**
        * Method name   : Service
        * @description  : Used for getting all services
        * @param        : Request data with service id
        * @return       : return view
    */
    public function service($id = '')
    {
        $services = $this->service_repo->getAll();
        $single_services = "";
        if($id!=''){
            $single_services = $this->service_repo->getById($id);
        }
        return view('Master.view_service', compact('services', 'single_services'));
    }

    /**
        * Method name   : Create Service
        * @description  : Used for adding new service
        * @param        : Request data
        * @return       : return with service created
    */
    public function create_service()
    {
        $request = request();

        $this->validate($request, [
            'txt_servicename'=> 'required',
            'txt_desc' => 'required',
            'txt_service_surcharge' => 'required',
            'dd_status' => 'required',
			'dd_servicetype' => 'required',
			'dd_bal_type' => 'required',
			'txt_url' => 'required',
        ],[
            'txt_servicename.required'=> 'Service name is required',
            'txt_desc.required' => 'Service description is required',
            'txt_service_surcharge.required'=> 'Service surcharge is required',
            'dd_status.required' => 'Status is required',
            'dd_servicetype.required' => 'Service Type is required',
            'dd_bal_type.required' => 'Balance Type is required',
            'txt_url.required' => 'URL is required',
        ]);

        if( $request->file('txt_service_image') != ''){
            $image = $request->file('txt_service_image');
            $name1 = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/service_image/');
			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name1);
			}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=Session::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
            $txt_image=$name1;
        }
        else
        {
            $txt_image='';
        }

        $arr = array(
            'm03_service_type' => $request->input('dd_servicetype'),
            'm03_service_name' => $request->input('txt_servicename'),
            'm03_bal_type' => $request->input('dd_bal_type'),
            'm03_url' => $request->input('txt_url'),
            'm03_sr_desc' => $request->input('txt_desc'),
            'm03_service_img' => $txt_image,
            'm03_service_surcharge' => $request->input('txt_service_surcharge'),
            'm03_service_surcharge_isvalue' => '0',
            'm03_service_ischargeable' => '0',
            'm03_sr_type_status' => $request->input('dd_status'),
            'm03_created_by' => 2,
            'm03_created_by_id' => 1
            );

        $this->service_repo->create($arr);
        Session::flash('service_msg','SERVICE CREATED SUCCESSFULLY' );
        Session::flash('type','success' );
        return redirect('/service');
    }

    /**
        * Method name   : Update Service
        * @description  : Used for updating service
        * @param        : Request data
        * @return       : return updated service
    */
    public function update_service($id)
    {
        $request = request();

        $this->validate($request, [
            'txt_servicename'=> 'required',
            'txt_desc' => 'required',
            'txt_service_surcharge' => 'required',
            'dd_status' => 'required',
			'dd_servicetype' => 'required',
			'dd_bal_type' => 'required',
			'txt_url' => 'required',
		
        ],[
            'txt_servicename.required'=> 'Service name is required',
            'txt_desc.required' => 'Service description is required',
            'txt_service_surcharge.required'=> 'Service surcharge is required',
            'dd_status.required' => 'Status is required',
            'dd_servicetype.required' => 'Service Type is required',
            'dd_bal_type.required' => 'Balance Type is required',
            'txt_url.required' => 'URL is required',

        ]);

        if( $request->file('txt_service_image') != ''){
            $image = $request->file('txt_service_image');
            $name1 = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/service_image/');
			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name1);
			}
			else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=Session::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
            $txt_image=$name1;
        }
        else
        {
            $txt_image=$request->input('txt_sr_oldimage');
        }

        $arr = array(
            'm03_service_type' => $request->input('dd_servicetype'),
            'm03_service_name' => $request->input('txt_servicename'),
            'm03_sr_desc' => $request->input('txt_desc'),
            'm03_bal_type' => $request->input('dd_bal_type'),
            'm03_url' => $request->input('txt_url'),
            'm03_service_img' => $txt_image,
            'm03_service_surcharge' => $request->input('txt_service_surcharge'),
            'm03_service_surcharge_isvalue' => '0',
            'm03_service_ischargeable' => '0',
            'm03_sr_type_status' => $request->input('dd_status')
            );
        $this->service_repo->update($id, $arr);
        Session::flash('service_msg','SERVICE UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );
        return redirect('/service');
    }


    /**
        * Method name   : Operator
        * @description  : Used for all operators
        * @param        : Request data
        * @return       : return all operators or single operator
    */
    public function operator($id = '')
    {
        $singleopt = '';
        $services = $this->service_repo->getAll();
        $OPERATOR = Helper::get_operator(-1,'ALL');
        if( $id != '' ){
            $singleopt = $this->operator_repo->getById($id);
        }
        return view('Master.operator', compact('OPERATOR','singleopt', 'services'));
    }

    /**
        * Method name   : Add Operator
        * @description  : Used for inserting operator
        * @param        : Request data
        * @return       : return with inserting operator
    */
	public function add_operator(Request $request)
    {
		if($request->txt_account != null)
		{
			$acs =   1; 
			$acd =   'required'; 
		}
		else
		{	
			$acs =  0; 
			$acd =  ''; 
		}

     $dd=   $this->validate($request, [
            'dd_service'=> 'required',
            'txt_brand_name' => 'required',
            'txt_brand_code' => 'required',
            'txt_brand_minamount' => 'required',
            'txt_brand_repeatrecharge' => 'required',
            'status' => 'required',
			'txt_ac_desc' => $acd,
        ],[
            'dd_service.required'=> 'Operator type is required',
            'txt_brand_name.required' => 'Operator name is required',
            'txt_brand_code.required'=> 'Operator code is required',
            'txt_brand_minamount.required' => 'Operator min. amount is required', 
            'txt_brand_repeatrecharge.required' => 'Operator repeat recharge is required',
            'status.required' => 'Status is required',
        ]);

        if( $request->file('brand_image') != ''){
            $image = $request->file('brand_image');
            $name1 = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/brand_image/');
			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name1);
			}
			else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=Session::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
            $txt_image=$name1;
        }
        else
        {
            $txt_image='';
        }

        $arr = array(
        'm03_sr_type_id' => $request->input('dd_service'),
        'm04_tc_brand_name' => $request->input('txt_brand_name'),
        'm04_tc_brand_code' => $request->input('txt_brand_code'),
        'm04_tc_brand_minamount' => $request->input('txt_brand_minamount'),
        'm04_tc_brand_maxamount' => $request->input('txt_brand_maxamount'),
        'm04_tc_brand_repeatrecharge' => $request->input('txt_brand_repeatrecharge'),
		'm04_account' => $acs,
		'm04_account_desc' => $request->input('txt_ac_desc'),
        'm04_tc_brand_image' => $txt_image,
        'm04_tc_brand_status' => $request->input('status'),
        'm04_tc_brand_onadd' => date('Y-m-d H:i:s'),
        'm04_tc_created_by' => 2,
        'm04_tc_created_by_id' => 1
        );

    $OperatorId = $this->operator_repo->create($arr);

	$GROUP = '';
	$SP = DB::select("SELECT COUNT(`m12_api_id`), `m12_api_id` FROM `m15_service_provider` WHERE `m07_service_id`= ".$request->dd_service." GROUP BY `m12_api_id`");
	$GM = DB::select("SELECT COUNT(`m16_gr_id`), `m16_gr_id` FROM `tr07_group_margin` WHERE `m07_service_id`=".$request->dd_service." GROUP BY `m16_gr_id`");
	$GOP = DB::select("SELECT COUNT(`m16_gr_id`), `m16_gr_id` FROM `tr06_group_op` WHERE `m07_service_id`=".$request->dd_service." GROUP BY `m16_gr_id`");

	foreach($SP as $spvalue)
	{
        $ServiceProvider = array(
        'm12_api_id' => $spvalue->m12_api_id,
        'm07_service_id' => $request->input('dd_service'),
        'm04_tc_brand_id' => $OperatorId,
        'm15_sp_code' => $request->input('txt_brand_code'),
        'm15_sp_created_by' => 1,
        'm15_sp_created_by_id' => Session()->get('USER_ID'),
        );
	DB::table('m15_service_provider')->insert($ServiceProvider);
	}

	foreach($GM as $gmvalue)
	{
		$GROUP = DB::select("SELECT * FROM `m16_group` WHERE `m16_gr_id` = ".$gmvalue->m16_gr_id);
        $GroupMargin = array(
        'm16_gr_id' => $gmvalue->m16_gr_id,
        'm16_gr_parent_id' => $GROUP[0]->m16_gr_parent_id ,
        'm11_user_id' => $GROUP[0]->m16_gr_user_id ,
        'm07_service_id' => $request->input('dd_service'),
		'm04_tc_brand_id' => $OperatorId,
		'm12_api_id' => 1,
        );
	DB::table('tr07_group_margin')->insert($GroupMargin);
	}

	foreach($GOP as $gopvalue)
	{
		$GROUP = DB::select("SELECT * FROM `m16_group` WHERE `m16_gr_id` = ".$gopvalue->m16_gr_id);
        $GroupOp = array(
        'm16_gr_id' => $gopvalue->m16_gr_id,
        'm16_gr_parent_id' => $GROUP[0]->m16_gr_parent_id ,
        'm11_user_id' => $GROUP[0]->m16_gr_user_id ,
        'm07_service_id' => $request->input('dd_service'),
		'm15_sp_code' => $OperatorId,
		'm15_sp_code_1' => $OperatorId,
		'm15_sp_code_2' => $OperatorId,
		'm15_sp_code_3' => $OperatorId,
		'm15_sp_code_4' => $OperatorId,
		'm15_sp_code_5' => $OperatorId,
		'm15_sp_code_afterfail' => $OperatorId,
		'm04_tc_brand_id' => $OperatorId,
		'm12_api_id' => 1,
        );

	DB::table('tr06_group_op')->insert($GroupOp);
	}


        Session::flash('operator_msg','OPERATOR ADDED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/operator');
    }

    /**
        * Method name   : Update Operator
        * @description  : Used for updating operator
        * @param        : Request data
        * @return       : return with updating operator
    */
	public function update_operator($id)
    {
        $request = request();
		if($request->txt_ac_desc != null)
		{
			$acs =   1; 
			$acd =   $request->txt_ac_desc; 
		}
		else
		{	
			$acs =  0; 
			$acd =  ''; 
		}

        $singleopt = '';
        $page = 'Master Panel';
        $form_name = 'Manage Operator';

        $this->validate($request, [
            'dd_service'=> 'required',
            'txt_brand_name' => 'required',
            'txt_brand_code' => 'required',
            'txt_brand_minamount' => 'required',
            'txt_brand_repeatrecharge' => 'required',
            'status' => 'required',
        ],[
            'dd_service.required'=> 'Operator type is required',
            'txt_brand_name.required' => 'Operator name is required',
            'txt_brand_code.required'=> 'Operator code is required',
            'txt_brand_minamount.required' => 'Operator min. amount is required', 
            'txt_brand_repeatrecharge.required' => 'Operator repeat recharge is required',
            'status.required' => 'Status is required',
        ]);

      if( $request->file('brand_image') != ''){
            $image = $request->file('brand_image');
            $name1 = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/brand_image/');
			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name1);
			}
			else{
				$request_data=json_encode($request->all());
				$file_type=$image->getClientOriginalName();
				$user_id=Session::get('USER_ID');
				$server_info=json_encode(request()->server());
				$user_info=json_encode(SESSION()->all()['result'][0]);
				$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
				return back()->with('error', 'File format not supported.'); 
			}
            $txt_image=$name1;
        }
        else
        {
            $txt_image=$request->input('txt_brand_imagehd');
        }

        $arr = array(
            'm03_sr_type_id' => $request->input('dd_service'),
            'm04_tc_brand_name' => $request->input('txt_brand_name'),
            'm04_tc_brand_code' => $request->input('txt_brand_code'),
            'm04_tc_brand_minamount' => $request->input('txt_brand_minamount'),
            'm04_tc_brand_maxamount' => $request->input('txt_brand_minamount'),
            'm04_tc_brand_repeatrecharge' => $request->input('txt_brand_repeatrecharge'),
			'm04_account' => $acs,
			'm04_account_desc' => $acd,
			'm04_tc_brand_image'=>$txt_image,
            'm04_tc_brand_status' => $request->input('status'),
            'm04_tc_brand_onupdate' => date('Y-m-d H:i:s')
        );
        $this->operator_repo->update($id, $arr);
        Session::flash('operator_msg','OPERATOR UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );
        if( $id != '' ){
            $singleopt =  DB::table('m04_telecom_brand')->where('m04_tc_brand_id' , $id)->get();
        }
        $OPERATOR = Helper::get_operator(-1,'ALL');
        return redirect()->to('/operator');
    }


    /**
        * Method name   : Operator Status
        * @description  : Used for updating operator status
        * @param        : Request data
        * @return       : return with updating operator status
    */
	public function operator_status()
    {
        $txtuserid = '';
        $request = request();
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
                if($request->input('txt_statusregid')=="")
                {
                    $ERRMSG = "operator should be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }   
                if(request()->method() == 'POST'&& $this->isError==FALSE)
                {
                    // $user_status=DB::select("Update m04_telecom_brand set m04_tc_brand_status = (case when(m04_tc_brand_status = 'Active') then 'InActive' else 'Active' end) WHERE m04_tc_brand_id =".$request->input('txt_statusregid')."");
                    $user_status=$this->operator_repo->active($request->input('txt_statusregid'));
                    $ERRMSG="OPERATOR STATUS HAS BEEN UPDATE SUCCESSFULLY!";
                    $ERRCODE='success'; 
                }
                Session::flash('operator_msg',$ERRMSG);
                Session::flash('type',$ERRCODE);
        }
        return redirect()->to('/operator');
    }

    /**
        * Method name   : Message
        * @description  : Used for getting all message config
        * @param        : Request data
        * @return       : return with all message config
    */
    public function message($id = '')
    {
        $singlemsg = '';
        $user_msg = $this->message_repo->getAll();
        if( $id != '' ){
            $singlemsg = $this->message_repo->getById($id);
        }
        return view('Master.message', compact('user_msg','singlemsg'));
    }

    /**
        * Method name   : Add Message
        * @description  : Used for adding message config
        * @param        : Request data
        * @return       : return with adding message config
    */
    public function add_message(Request $request)
    {

        $this->validate($request, [
            'txt_msg_title'=> 'required',
            'txt_msg_subject' => 'required',
            'txt_msg_variable' => 'required',
            'txt_msg_content' => 'required',
            'msg_sent_from' => 'required',
			 'messages_category' => 'required',
			 'messages_type' => 'required',
            'status' => 'required',
        ],[
            'txt_msg_title.required'=> 'Message title is required',
            'txt_msg_subject.required' => 'Message subject is required',
            'txt_msg_variable.required'=> 'Message variable is required',
            'txt_msg_content.required' => 'Message content is required', 
            'msg_sent_from.required' => 'Message sent from is required',
			 'messages_category' => 'Message Type is required',
			 'messages_type' => 'Message Category is required',
            'status.required' => 'Status is required'        
        ]);

        $arr = array(
        'm09_msg_title' => $request->input('txt_msg_title'),
        'm09_msg_subject' => $request->input('txt_msg_subject'),
        'm09_msg_variable' => $request->input('txt_msg_variable'),
        'm09_msg_content' => $request->input('txt_msg_content'),
        'm09_msg_sent_from' => $request->input('msg_sent_from'),
        'm09_msg_status' => $request->input('status'),
        'm09_msg_onadd' => date('Y-m-d H:i:s'),
        'm09_created_by' => 2,
        'm09_created_by_id' => 1,
		'm09_msg_type' => $request->input('messages_type')
        );

        $this->message_repo->create($arr);
        Session::flash('msg_msg','MESSAGE ADDED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('message');
    }

    /**
        * Method name   : Update Message
        * @description  : Used for updating message config
        * @param        : Request data
        * @return       : return with updating message config
    */
    public function update_message($id)
    {
        $singlemsg = '';
        $request = request();

        $this->validate($request, [
            'txt_msg_title'=> 'required',
            'txt_msg_subject' => 'required',
            'txt_msg_variable' => 'required',
            'txt_msg_content' => 'required',
            'msg_sent_from' => 'required',
			 'messages_category' => 'required',
			 'messages_type' => 'required',
            'status' => 'required',
        ],[
            'txt_msg_title.required'=> 'Message title is required',
            'txt_msg_subject.required' => 'Message subject is required',
            'txt_msg_variable.required'=> 'Message variable is required',
            'txt_msg_content.required' => 'Message content is required', 
            'msg_sent_from.required' => 'Message sent from is required',
			 'messages_category' => 'Message Type is required',
			 'messages_type' => 'Message Category is required',
            'status.required' => 'Status is required'        
        ]);

        $arr = array(
            'm09_msg_title' => $request->input('txt_msg_title'),
            'm09_msg_subject' => $request->input('txt_msg_subject'),
            'm09_msg_variable' => $request->input('txt_msg_variable'),
            'm09_msg_content' => $request->input('txt_msg_content'),
            'm09_msg_sent_from' => $request->input('msg_sent_from'),
            'm09_msg_status' => $request->input('status'),
            'm09_msg_onupdate' => date('Y-m-d H:i:s'),
			'm09_msg_category' => $request->input('messages_category'),
			'm09_msg_type' => $request->input('messages_type')
        );

        $this->message_repo->update($id, $arr);
        Session::flash('msg_msg','MESSAGE UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );
        return redirect('/message');
    }

    /**
        * Method name   : Message Status
        * @description  : Used for updating message config status
        * @param        : Request data
        * @return       : return with updating message config status
    */
	public function message_status()
    {
        $txtuserid = '';
        $request = request();
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
                if($request->input('txt_statusregid')=="")
                {
                    $ERRMSG = "Bank should be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }   
                if(request()->method() == 'POST'&& $this->isError==FALSE)
                {

                    $user_status=$this->message_repo->active($request->input('txt_statusregid'));
                    $ERRMSG="MESSAGE STATUS HAS BEEN UPDATE SUCCESSFULLY!";
                    $ERRCODE='success'; 
                }
                Session::flash('msg_msg',$ERRMSG);
                Session::flash('type',$ERRCODE);
        }
        return redirect('/message');
    }

    /**
        * Method name   : Static Content
        * @description  : Used for getting all static content
        * @param        : Request data with static content id
        * @return       : return with all static content or single static content
    */
    public function static_cnt($id = '')
    {
        $singlecnt = '';
        $static_cont =  $this->content_repo->getAll();
        if( $id != '' ){
            $singlecnt =  $this->content_repo->getById($id);
        }
        return view('Master.static_cnt', compact('static_cont','singlecnt'));
    }

    /**
        * Method name   : Add Static Content
        * @description  : Used for adding static content
        * @param        : Request data
        * @return       : return adding static content
    */
    public function add_static_cnt(Request $request)
    {
        $this->validate($request, [
            'txt_m10_staticcnt_title'=> 'required',
            'txt_m10_staticcnt_variable' => 'required',
            'txt_m10_staticcnt_content' => 'required',
            'status' => 'required',
        ],[
            'txt_m10_staticcnt_title.required'=> 'Title is required',
            'txt_m10_staticcnt_variable.required' => 'Variable is required',
            'txt_m10_staticcnt_content.required'=> 'Content is required',
            'status.required' => 'Status is required'        
        ]);

        $m10_affilate_id = Session::get('AFFILIATE_CODE');
        $arr = array(
        'm10_staticcnt_title' => $request->input('txt_m10_staticcnt_title'),
        'm10_staticcnt_variable' => $request->input('txt_m10_staticcnt_variable'),
        'm10_staticcnt_content' => $request->input('txt_m10_staticcnt_content'),
        'm10_staticcnt_content' => $request->input('txt_m10_staticcnt_content'),
        'm10_staticcnt_status' => $request->input('status'),
        'm10_affilate_id' => 1,
        'm10_staticcnt_onadd' => date('Y-m-d H:i:s'),
        'm10_created_by' => 2,
        'm10_created_by_id' => 1
        );
        $this->content_repo->create($arr);
        Session::flash('staticcnt_msg','STATIC CONTENT ADDED SUCCESSFULLY HERE!' );
        Session::flash('type','success' );
        return redirect('/static_cnt');
    }

    /**
        * Method name   : Update Static Content
        * @description  : Used for updating static content
        * @param        : Request data
        * @return       : return with updating static content
    */
    public function update_static_cnt($id)
    {
        $singlecnt = '';
        $page = 'Master Panel';
        $form_name = 'Manage Static Content';
        $request = request();

        $this->validate($request, [
            'txt_m10_staticcnt_title'=> 'required',
            'txt_m10_staticcnt_variable' => 'required',
            'txt_m10_staticcnt_content' => 'required',
            'status' => 'required',
        ],[
            'txt_m10_staticcnt_title.required'=> 'Title is required',
            'txt_m10_staticcnt_variable.required' => 'Variable is required',
            'txt_m10_staticcnt_content.required'=> 'Content is required',
            'status.required' => 'Status is required'        
        ]);

        $m10_affilate_id = Session::get('AFFILIATE_CODE');
        $arr = array(
        'm10_staticcnt_title' => $request->input('txt_m10_staticcnt_title'),
        'm10_staticcnt_variable' => $request->input('txt_m10_staticcnt_variable'),
        'm10_staticcnt_content' => $request->input('txt_m10_staticcnt_content'),
        'm10_staticcnt_content' => $request->input('txt_m10_staticcnt_content'),
        'm10_staticcnt_status' => $request->input('status'),
        'm10_affilate_id' => 1,
        'm10_staticcnt_onupdate' => date('Y-m-d H:i:s')
        );
        $this->content_repo->update($id, $arr);
        Session::flash('staticcnt_msg','STATIC CONTENT UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );
        if( $id != '' ){
            $singlecnt =  $this->content_repo->getById($id);
        }
        $static_cont =  DB::table('m10_static_content')->paginate(500);
        return redirect('/static_cnt');
    }
	
	/**
        * Method name   : Static content status
        * @description  : Used for updating static content status
        * @param        : Request data
        * @return       : return with updating static content status
    */
	public function static_cnt_status()
    {
        $txtuserid = '';
        $request = request();
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
                if($request->input('txt_statusregid')=="")
                {
                    $ERRMSG = "Bank should be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }   
                if(request()->method() == 'POST'&& $this->isError==FALSE)
                {
                    $user_status=$this->content_repo->active($request->input('txt_statusregid'));
                    // $user_status=DB::select("Update m10_static_content set m10_staticcnt_status = (case when(m10_staticcnt_status = 'Active') then 'InActive' else 'Active' end) WHERE m10_staticcnt_id =".$request->input('txt_statusregid')."");
                    $ERRMSG="STATIC CONTENT STATUS HAS BEEN UPDATE SUCCESSFULLY!";
                    $ERRCODE='success'; 
                }
                Session::flash('staticcnt_msg',$ERRMSG);
                Session::flash('type',$ERRCODE);
        }
       return redirect('/static_cnt');
    }

    /**
        * Method name   : View package
        * @description  : Used for getting all packages
        * @param        : Request data
        * @return       : return all packages
    */
    public function view_package($id = '')
    {
        $singlepack = '';
        $package = $this->package_repo->getAllforAdmin();
        if( $id != '' ){
            $singlepack = $this->package_repo->getById($id);
            //dd($singlepack);
        }

        return view('Master.add_package', compact('package','singlepack'));
    }

    /**
        * Method name   : Add package
        * @description  : Used for adding package
        * @param        : Request data
        * @return       : return with adding package
    */
    public function add_package(Request $request){
        $form_name = 'Add Package';

        $this->validate($request, [
            'pack_name'=> 'required',
            'pack_fee'=> 'required',
            'pack_direct_amt'=> 'required',
            'pack_point'=> 'required',
            'pack_growth_amt'=> 'required',
            'pack_capp'=> 'required',
            'pack_roi_income'=> 'required',
            'pack_roi_booster'=> 'required',
            'pack_roi_days'=> 'required',
            'pack_description'=> 'required'
        ],[
            'pack_name.required'=> 'Pack Name is required',
            'pack_fee.required'=> 'Pack Fee is required',
            'pack_direct_amt.required'=> 'Pack Direct Amount is required',
            'pack_point.required'=> 'Pack Point is required',
            'pack_growth_amt.required'=> 'Pack Growth is required',
            'pack_roi_income.required'=> 'ROI is required',
            'pack_roi_booster.required'=> 'ROI Booster is required',
            'pack_roi_days.required'=> 'ROI Days is required',
            'pack_description.required'=> 'Description is required'
        ]);
       
        $arr = array(
            'm27_pack_name' => $request->input('pack_name'),
            'm27_pack_fee' => $request->input('pack_fee'),
            'm27_pack_direct_amt' => $request->input('pack_direct_amt'),
            'm27_pack_point' => $request->input('pack_point'),
            'm27_pack_growth_amt' => $request->input('pack_growth_amt'),
            'm27_pack_capp' => $request->input('pack_capp'),
            'm27_pack_roi_income' => $request->input('pack_roi_income'),
            'm27_pack_roi_booster' => $request->input('pack_roi_booster'),
            'm27_pack_roi_days' => $request->input('pack_roi_days'), 
            'm27_pack_description' => $request->input('pack_description'), 
            'm27_pack_status' => 1,
            'm27_created_by' => 2,
            'm27_created_by_id' => 1
        );
        $this->package_repo->create($arr);
		Session::flash('package_msg','PACKAGE ADDED SUCCESSFULLY HERE!' );
		Session::flash('type','success' );
        return redirect()->to('package');

    }

    /**
        * Method name   : Update package
        * @description  : Used for updating package
        * @param        : Request data with package id
        * @return       : return with updated package
    */
    public function update_package($id)
     {
        $singlepack = '';
        $request = request();

        $this->validate($request, [
            'pack_name'=> 'required',
            'pack_fee'=> 'required',
            'pack_direct_amt'=> 'required',
            'pack_point'=> 'required',
            'pack_growth_amt'=> 'required',
            'pack_capp'=> 'required',
            'pack_roi_income'=> 'required',
            'pack_roi_booster'=> 'required',
            'pack_roi_days'=> 'required',
            'pack_description'=> 'required'
        ],[
            'pack_name.required'=> 'Pack Name is required',
            'pack_fee.required'=> 'Pack Fee is required',
            'pack_direct_amt.required'=> 'Pack Direct Amount is required',
            'pack_point.required'=> 'Pack Point is required',
            'pack_growth_amt.required'=> 'Pack Growth is required',
            'pack_roi_income.required'=> 'ROI is required',
            'pack_roi_booster.required'=> 'ROI Booster is required',
            'pack_roi_days.required'=> 'ROI Days is required',
            'pack_description.required'=> 'Description is required'
        ]);

        $arr = array(
			'm27_pack_name' => $request->input('pack_name'),
            'm27_pack_fee' => $request->input('pack_fee'),
            'm27_pack_direct_amt' => $request->input('pack_direct_amt'),
            'm27_pack_point' => $request->input('pack_point'),
            'm27_pack_growth_amt' => $request->input('pack_growth_amt'),
            'm27_pack_capp' => $request->input('pack_capp'),
            'm27_pack_roi_income' => $request->input('pack_roi_income'),
            'm27_pack_roi_booster' => $request->input('pack_roi_booster'),
            'm27_pack_roi_days' => $request->input('pack_roi_days'), 
            'm27_pack_description' => $request->input('pack_description'), 
            'm27_pack_status' => 1,  
            );
        $this->package_repo->update($id, $arr);
        Session::flash('package_msg','PACKAGE UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );
        return redirect()->to('package');
    }

    /**
        * Method name   : Package status
        * @description  : Used for updating package status
        * @param        : Request data with package id
        * @return       : return with updated package status
    */
    public function package_status()
    {
        $txtuserid = '';
        $request = request();
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
                if($request->input('txt_statusregid')=="")
                {
                    $ERRMSG = "Package should be valid";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }   
                if(request()->method() == 'POST' && $this->isError==FALSE)
                {

                    $user_status=$this->package_repo->active($request->input('txt_statusregid'));
                    $ERRMSG="PACKAGE STATUS HAS BEEN UPDATE SUCCESSFULLY!";
                    $ERRCODE='success'; 
                }
                Session::flash('package_msg',$ERRMSG);
                Session::flash('type',$ERRCODE);
        }
        return redirect()->to('package');
    }

    /**
        * Method name   : View Config
        * @description  : Used for getting config 
        * @param        : Request data with config id
        * @return       : return with single config
    */
    public function view_config( $id='' ){
        $status = '';
        $config = $this->config_repo->getAll();
        $singleconfig = '';
        if( $id!= ''){
            $singleconfig = $this->config_repo->getById($id);
            //dd($singleconfig);
            return view('Master.view_config', compact('config', 'singleconfig'));
        }else{
               return view('Master.view_config', compact('config', 'singleconfig'));
        }
    }

    /**
        * Method name   : Add mainconfig
        * @description  : Used for adding mainconfig 
        * @param        : Request data
        * @return       : return with added mainconfig 
    */
    public function add_mainconfig(){
        $request = request();
        $this->validate($request, [
            'txt_name'=> 'required',
            'txt_value' => 'required',
            'txt_desc' => 'required'
        ],[
            'txt_name.required'=> 'Name is required',
            'txt_value.required' => 'Value is required',
            'txt_desc.required'=> 'Description is required'      
        ]);

        $arr = array(
            'm00_name' => $request->input('txt_name'),
            'm00_value' => $request->input('txt_value'),
            'm00_desc' => $request->input('txt_desc'),
            'm00_created_by' => 2,
            'm00_created_by_id' => 1
        );
        $this->config_repo->create($arr);
		Session::flash('config_msg','MAIN CONFIG ADDED SUCCESSFULLY' );
		Session::flash('type','success' );
        return redirect('/view_config'); 
    }

    /**
        * Method name   : Update siteconfig
        * @description  : Used for updating siteconfig 
        * @param        : Request data with config id
        * @return       : return with updated siteconfig 
    */
    public function update_siteconfig($id){
        $request = request();

        $this->validate($request, [
            'txt_name'=> 'required',
            'txt_value' => 'required'
        ],[
            'txt_name.required'=> 'Name is required',
            'txt_value.required' => 'Value is required'     
        ]);

        $arr = array(
            'm00_name' => $request->input('txt_name'),
            'm00_value' => $request->input('txt_value'),
            'm00_desc' => $request->input('txt_desc')
        );
        $this->config_repo->update($id, $arr);
		Session::flash('config_msg','MAIN CONFIG UPDATED SUCCESSFULLY' );
		Session::flash('type','success' );
        return redirect('/view_config/'. $id); 
    }

    /**
        * Method name   : Update mainconfig
        * @description  : Used for updating mainconfig 
        * @param        : Request data with config id
        * @return       : return with updated mainconfig 
    */
    public function update_mainconfig($id){
        $request = request();

        $this->validate($request, [
            'txtusername'=> 'required',
            'txtuserpass' => 'required',
            'txtuserpinpass' => 'required'
        ],[
            'txtusername.required'=> 'User name is required',
            'txtuserpass.required' => 'User password is required',
            'txtuserpinpass.required'=> 'User pin password is required'      
        ]);

        $mcf=array(
        'm00_login_id'=>$id,
        'm00_username'=>$request->input('txtusername'),
        'm00_password'=>$request->input('txtuserpass'),
        'm00_pinpassword'=>$request->input('txtuserpinpass'),
        'm00_admin_type'=>$request->input('txtusertype'),
        'm00_admin_status'=>$request->input('txtuserstatus')
        );
       
        $result = $this->config_repo->setConfig($mcf);
		Session::flash('config_msg','MAIN CONFIG UPDATED SUCCESSFULLY' );
		Session::flash('type','success' );
        $singleconfig = $this->config_repo->getById($id);
        return redirect('/view_config');
    }

    /**
        * Method name   : Update siteimage
        * @description  : Used for updating siteimage 
        * @param        : Request data with config id
        * @return       : return with updated siteimage 
    */
    public function update_siteimage($name){
        $request = request();
        $image = "";
        $name1 = "";

        if($request->hasFile('txt_value') && $request->input('txt_site_logo')){
            $image = $request->file('txt_value');
            $name1 = time().'.'.$image->getClientOriginalExtension();
            //dd($name1);
            $destinationPath = public_path('/images/config/logo/');
            $FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name1);
				$thumbnailpath = public_path('/images/config/logo/'.$name1);
				$img = Image::make($thumbnailpath)->resize(220, 66, function($constraint) {
					$constraint->aspectRatio();
				});
				$img->save($thumbnailpath); 
			}
			else{
				$request_data=json_encode($request->all());
				$file_type=$image->getClientOriginalName();
				$user_id=Session::get('USER_ID');
				$server_info=json_encode(request()->server());
				$user_info=json_encode(SESSION()->all()['result'][0]);
				$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
				return back()->with('error', 'File format not supported.'); 
			} 
        }
        elseif($request->hasFile('txt_value') && $request->input('txt_bg_image')){
            $image = $request->file('txt_value');  
            $name1 = time().'.'.$image->getClientOriginalExtension();
            //dd($name1);
            $destinationPath = public_path('/images/config/bg/');
            $FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name1);
				$thumbnailpath = public_path('/images/config/bg/'.$name1);
				$img = Image::make($thumbnailpath)->resize(1440,800, function($constraint) {
					$constraint->aspectRatio();
				});
				$img->save($thumbnailpath); 
			}
			else
            {
				$request_data=json_encode($request->all());
				$file_type=$image->getClientOriginalName();
				$user_id=Session::get('USER_ID');
				$server_info=json_encode(request()->server());
				$user_info=json_encode(SESSION()->all()['result'][0]);
				$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
				return back()->with('error', 'File format not supported.'); 
			} 
        }  

        $arr_bg = array(
            'm00_value' => $name1
        );

        $this->config_repo->updateByName($name, $arr_bg);
        
        Session::flash('config_msg','SITE IMAGE UPDATED SUCCESSFULLY' );
		Session::flash('type','success' );
        return redirect('/view_config'); 
    }

    /**
        * Method name   : View banner
        * @description  : Used for getting banner 
        * @param        : Request data with banner id and all banners
        * @return       : return with single banner selected and all banners
    */
    public function view_banner($id = ""){
        $banners = $this->banner_repo->getAll();
		$affi = $this->Affiliate_repo->getAll();
        $single_banner = '';
        if( $id!= ''){
            $single_banner = $this->banner_repo->getById($id);
        } 
		
		//dd($single_banner, $banners, $affi);
        return view('Master.banner_master', compact('single_banner', 'banners','affi'));
    }

    /**
        * Method name   : Create banner
        * @description  : Used for creating banner 
        * @param        : Request data for creating banner 
        * @return       : return with created banner 
    */
    public function create_banner()
    {
        $request = request();
        $type = $request->input('dd_banner_type');

        $img = '';
		if($request->input('dd_affiliate') == '')
		{
			Session::flash('banner_msg','Affiliate Name Required' );
			Session::flash('type','warning' );
			return redirect('/banner');
		}

        $bannerName = '';

        if($request->file('txt_banner_img')){
            $image = $request->file('txt_banner_img');
            $time = date("d-m-Y")."-".time() ;
            $image_name = $image->getClientOriginalName();
            $bannerName = $request->input('txt_banner_var').$time.'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('images/front');

			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {

					if($request->input('dd_banner_type') == 1){
						$img1 = Image::make($image->getRealPath())->resize(600, 350);
						$img1->save($destinationPath.'\\'.$bannerName);                       
					}
					elseif($request->input('dd_banner_type') == 2){
						$img1 = Image::make($image->getRealPath())->resize(1200, 300);
						$img1->save($destinationPath.'/'.$bannerName);                 
					}
					elseif($request->input('dd_banner_type') == 3){
						$img1 = Image::make($image->getRealPath())->resize(1170, 146);
						$img1->save($destinationPath.'/'.$bannerName);                 
					}
					elseif($request->input('dd_banner_type') == 4){
						$img1 = Image::make($image->getRealPath())->resize(800, 250);
						$img1->save($destinationPath.'/'.$bannerName);                 
					}
					elseif($request->input('dd_banner_type') == 5){
						$img1 = Image::make($image->getRealPath())->resize(1170, 146);
						$img1->save($destinationPath.'/'.$bannerName);                 
					}
					elseif($request->input('dd_banner_type') == 6){
						$img1 = Image::make($image->getRealPath())->resize(1920, 500);
						$img1->save($destinationPath.'/'.$bannerName);                 
					}
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=Session::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}

            
        }
        else
        {
            $bannerName = '' ;
        }

        $arr = array(
            'm47_banner_name' => $request->input('txt_banner_name'),
            'm47_banner_var' => $request->input('txt_banner_var'),
            'm47_banner_desc' => $request->input('txt_banner_desc'),
            'm47_banner_meta' => $request->input('txt_banner_meta'),
            'm47_banner_img' => $bannerName,
            'm47_banner_type' => $request->input('dd_banner_type'),
            'm47_banner_status' => $request->input('dd_banner_status'),
            'm47_created_by' => 2,
			'm47_created_by_id' => 1,
            'm47_affiliate_id' => $request->input('dd_affiliate')
        );

        $this->banner_repo->create($arr);
        Session::flash('banner_msg','BANNER IMAGE ADDED SUCCESSFULLY' );
        Session::flash('type','success' );
        return redirect('/banner');
    }

    /**
        * Method name   : Create banner
        * @description  : Used for creating banner 
        * @param        : Request data for creating banner 
        * @return       : return with created banner 
    */
    public function update_banner($id)
    {
        $request = request();
        $type = $request->input('dd_banner_type');
        $img = '';

        $bannerName = '';

        if($request->file('txt_banner_img')){
            $image = $request->file('txt_banner_img');
            $time = date("d-m-Y")."-".time() ;
            $image_name = $image->getClientOriginalName();
            $bannerName = $request->input('txt_banner_var').$time.'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('images/front');

			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {

					if($request->input('dd_banner_type') == 1){
						$img1 = Image::make($image->getRealPath())->resize(600, 350);
						$img1->save($destinationPath.'/'.$bannerName);                       
					}
					elseif($request->input('dd_banner_type') == 2){
					  $img1 = Image::make($image->getRealPath())->resize(1200, 300);
					  $img1->save($destinationPath.'/'.$bannerName);   
					}
					elseif($request->input('dd_banner_type') == 3){
						$img1 = Image::make($image->getRealPath())->resize(1170, 146);
						 $img1->save($destinationPath.'/'.$bannerName);                 
					}
					elseif($request->input('dd_banner_type') == 4){
						$img1 = Image::make($image->getRealPath())->resize(800, 250);
						$img1->save($destinationPath.'/'.$bannerName);                 
					}
					elseif($request->input('dd_banner_type') == 5){
						$img1 = Image::make($image->getRealPath())->resize(1170, 146);
					   echo $img1->save($destinationPath.'/'.$bannerName);                 
					}
					elseif($request->input('dd_banner_type') == 6){
						$img1 = Image::make($image->getRealPath())->resize(1920, 500);
						 $img1->save($destinationPath.'/'.$bannerName);                 
					}
                }
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=Session::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}

            
        }
        else
        {
            $bannerName = $request->input('txt_old_banner') ;
        }

        $arr = array(
            'm47_banner_name' => $request->input('txt_banner_name'),
            'm47_banner_var' => $request->input('txt_banner_var'),
            'm47_banner_desc' => $request->input('txt_banner_desc'),
            'm47_banner_meta' => $request->input('txt_banner_meta'),
            'm47_banner_img' => $bannerName,
            'm47_banner_type' => $request->input('dd_banner_type'),
            'm47_banner_status' => $request->input('dd_banner_status')
        );

        $this->banner_repo->update($id, $arr);
        Session::flash('banner_msg','BANNER IMAGE UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );
        return redirect('/banner');
    }
    
    /**
        * Method name   : Assign menu
        * @description  : Used for creating menu 
        * @param        : Request data for creating menu 
        * @return       : return with created menu 
    */
    public function assign_menu($id = '')
    {
        $single_menu = '';
        $menus = $this->assignmenu_repo->getAll();
        $parent_menus = $this->assignmenu_repo->getAllParent();
        if($id != ''){
            $single_menu = $this->assignmenu_repo->getById($id);
        }
        $role = $this->Role_repo->getByPId(0);

        if(isset($single_menu[0]->ROLE_TYPE))
        {		
            $ProleID = DB::select("SELECT * FROM `roles` WHERE ROLE_ID IN (".$single_menu[0]->ROLE_ID.")");
        }
        else
        {
           $ProleID =  $this->Role_repo->getByPId(-1);
        }
		   $AllRole =  $this->Role_repo->getAll();
        return view('Master.assign_menu', compact('single_menu', 'menus', 'parent_menus','role','ProleID','AllRole'));
    }

    /**
        * Method name   : Add menu
        * @description  : Used for creating menu 
        * @param        : Request data for creating menu 
        * @return       : return with created menu 
    */
    public function add_menu()
    {
        $request = request();

    	$this->validate($request, [
            'dd_role'=> 'required',
            'dd_role_id'=> 'required',
        ]);

        if($request->input('dd_menu') != -1){
            $menu = $request->input('dd_menu');
        }else{
            $menu = -1;
        }

        $rols = implode(',', $request->dd_role_id);
        $data = DB::select('SELECT * FROM `roles` WHERE ROLE_ID IN ('.$rols.')');
        $prefix = $fruitList = '';
        foreach ($data as $value)
        {
          if($value->PARENT_ROLE_ID == 1)
          {
            $fruitList .= $prefix . 'U_'.$value->USER_ROLE_ID;
            $prefix = ',';
          }
         if($value->PARENT_ROLE_ID == 10)
          {
            $fruitList .= $prefix . 'E_'.$value->USER_ROLE_ID;
            $prefix = ',';
          }
        }
		
		if($request->input('dd_role') == 1)
		{
			$r = 2;
		}
		if($request->input('dd_role') == 10)
		{
			$r = 3;
		}
		if($request->input('dd_role') == 18)
		{
			$r = 4;
		}

        $arr = array(
            'm49_menu_name' => $request->input('txt_menu_name'),
            'm49_menu_var' => $request->input('txt_menu_var'),
            'm49_user_role' => $r,
            'm49_menu_parent_id' => $menu,
            'm49_menu_url' => $request->input('txt_menu_url'),
            'm49_menu_icon' => $request->input('txt_menu_icon'),
            'm49_menu_order' => $request->input('txt_menu_order'),
            'm49_is_link' => $request->input('dd_islink'),
            'm49_status' => 1, 

            'm49_user_type' => $request->input('dd_role'),
            'm65_user_role_id' => $rols,  // role table id 
            'm11_m30_user_role_id' => $fruitList, //user role enum value 
  
        );

        $this->assignmenu_repo->create($arr);
        return redirect('/assign_menu');
    }

    /**
        * Method name   : Update menu
        * @description  : Used for updating menu 
        * @param        : Request data for updating menu 
        * @return       : return with updated menu 
    */
    public function update_menu($id)
    {
        $request = request();

    	$this->validate($request, [
            'dd_role'=> 'required',
            'dd_role_id'=> 'required',
        ]);


        if($request->input('dd_menu') != -1){
            $menu = $request->input('dd_menu');
        }else{
            $menu = -1;
        }

        $rols = implode(',', $request->dd_role_id);
        $data = DB::select('SELECT * FROM `roles` WHERE ROLE_ID IN ('.$rols.')');
        $prefix = $fruitList = '';
        foreach ($data as $value)
        {
          if($value->PARENT_ROLE_ID == 1)
          {
            $fruitList .= $prefix . 'U_'.$value->USER_ROLE_ID;
            $prefix = ',';
          }
         if($value->PARENT_ROLE_ID == 10)
          {
            $fruitList .= $prefix . 'E_'.$value->USER_ROLE_ID;
            $prefix = ',';
          }
        }
		$route = DB::select('SELECT * FROM `assign_menu` WHERE ASMENU_ID = '.$id);

		if($route[0]->ROUTE_FOR == 'USER'){
		$user_type = 1;
		}
		if($route[0]->ROUTE_FOR == 'EMPLOYEE'){
		$user_type = 10;
		}
		//dd($request->input('dd_role'), $user_type);
		if($request->input('dd_role') == $user_type){

			$arr = array(
				'm49_menu_name' => $request->input('txt_menu_name'),
				'm49_menu_var' => $request->input('txt_menu_var'),

				'm49_user_type' => $request->input('dd_role'),
				'm65_user_role_id' => $rols,  // role table id 
				'm11_m30_user_role_id' => $fruitList, //user role enum value 
				'm49_is_default' => $request->input('dd_isdefault'),

				'm49_menu_url' => $request->input('txt_menu_url'),
				'm49_menu_icon' => $request->input('txt_menu_icon'),
				'm49_menu_order' => $request->input('txt_menu_order'),
				'm49_is_link' => $request->input('dd_islink'),
				'm49_status' => 1 
			);
			$this->assignmenu_repo->update($id, $arr);
			}
		else
		{
				Session::flash('menu_msg','THIS ROUTE CANNOT BE UPDATED' );
				Session::flash('type','success' );
				return redirect('/assign_menu');
		}
        return redirect('/assign_menu');
    }



    /**
        * Method name   : Menu status
        * @description  : Used for updating menu status
        * @param        : Request data for updating menu status
        * @return       : return with updated menu status
    */
    public function menu_status()
    {
        $request = request();
        $id = $request->input('txt_menuid');
        $this->assignmenu_repo->active($id);
        return redirect('/assign_menu');
    }


    /**
        * Method name   : User menu
        * @description  : Used for creating user menu 
        * @param        : Request data for creating user menu 
        * @return       : return with created user menu 
    */
    public function user_menu($id = '')
    {
        $single_usermenu = '';
        $menus = $this->assignmenu_repo->getAll();
        $users = $this->enroll_repo->getActiveUser();
        $employees = $this->emp_repo->getActiveEmployee();
        $user_menu = $this->usernmenu_repo->getAll();
        if($id != ''){
            $single_usermenu = $this->usernmenu_repo->getById($id);
        }
        return view('Master.assign_menu_user', compact('users','employees','user_menu','single_usermenu', 'menus'));
    }

    /**
        * Method name   : Add user menu
        * @description  : Used for creating user menu 
        * @param        : Request data for creating user menu 
        * @return       : return with created user menu 
    */
    public function add_usermenu()
    {
        $request = request();

        $arr = array(
            'm11_user_id' => $request->input('dd_user'),
            'm30_employee_id' => $request->input('dd_emp'),
            'm49_id' => $request->input('dd_menu'),
            'm50_user_type' => $request->input('dd_assigned_for'),
            'm50_assign_by' => $request->input('dd_assigned_by'),
            'm50_assign_by_id' => 0,
            'm50_status' => $request->input('dd_status')
        );
        $this->usernmenu_repo->create($arr);
        return redirect('/user_menu');
    }

    /**
        * Method name   : Update user menu
        * @description  : Used for updating user menu 
        * @param        : Request data for updating user menu 
        * @return       : return with updated user menu 
    */
    public function update_usermenu($id)
    {
        $request = request();

        $arr = array(
            'm11_user_id' => $request->input('dd_user'),
            'm30_employee_id' => $request->input('dd_emp'),
            'm49_id' => $request->input('dd_menu'),
            'm50_user_type' => $request->input('dd_assigned_for'),
            'm50_status' => $request->input('dd_status')
        );
        $this->usernmenu_repo->update($id, $arr);
        return redirect('/user_menu');
    }

    /**
        * Method name   : User menu status
        * @description  : Used for updating user menu status
        * @param        : Request data for updating user menu status
        * @return       : return with updated user menu status
    */
    public function usermenu_status()
    {
        $request = request();
        $id = $request->input('txt_menuid');
        $this->usernmenu_repo->active($id);
        return redirect('/user_menu');
    }

	/**
        * Method name   : User Assign menu
        * @description  : Used for assigning user menu 
        * @param        : Request data for assigning user menu 
        * @return       : return with assigned menu 
    */
    public function user_assign_menu()
    {
        $request = request();
        $user = "";
        $USERID="";
        $get_useralldetail = "";
		$user_menus = "";
		$selected_menus = "";
        if($request->method() == 'POST')
        {
               if($request->input('txt_memberid')=='')
                {
                    $ERRMSG = "Member id should be valid or not blank.";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
                else
                {
                    $ERRMSG = "";
                    $this->isError=FALSE;
                    $ERRCODE="success";
                }
 
                if(request()->method() == 'POST' && $this->isError==FALSE)
                {
                    $userid = Helper::get_userid($request->input('txt_memberid'));
               
                    if($userid!=FALSE)
                    {
                    $user = Helper::get_userdetail($userid);

                    $get_useralldetail = Helper::get_useralldetail($userid);

     //dd($userid, $user, $get_useralldetail, $request->input('txt_memberid'));

					$user_menus = DB::select('SELECT USRMN_MENUID FROM user_assign_menu WHERE USRMN_USERID = "'.$userid.'" AND USRMN_STATUS = "ACTIVE"');
					if(isset($user_menus[0]->USRMN_MENUID)){
					$selected_menus = explode(',',$user_menus[0]->USRMN_MENUID);
					}
					else{
					$selected_menus = "";
					}
                    $ERRMSG = "Member details fetch successfully.";
                    $ERRCODE="success";
                    }
                    else
                    {
                    $ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
                    $this->isError=TRUE;
                    $ERRCODE="warning";
                    }
                }
        }
        $USERID=$request->input('txt_memberid');
        $menus = $this->assignmenu_repo->getUserMenus();

        return view('Master.user_assign_menu',compact('menus','user','get_useralldetail','USERID','user_menus','selected_menus'));
    }

	/**
        * Method name   : add user assign menu
        * @description  : Used for assigning user menu 
        * @param        : Request data for assigning user menu 
        * @return       : return with assigned menu 
    */
    public function add_user_assign_menu()
    {
        $request = request();
        $userid = $request->input('txt_userid');
        $menu_ids = implode(",",$request->input('ckb_usermenu'));
        $already_exists = DB::select('SELECT USRMN_MENUID FROM user_assign_menu WHERE USRMN_USERID = "'.$userid.'" AND USRMN_STATUS = "ACTIVE"');
        if(count($already_exists) == 0){    
            $arr = array(
                'm11_user_id' => $request->input('txt_userid'),
                'm30_employee_id' => -1,
                'm49_id' => $menu_ids,
                'm50_user_type' => 1,
                'm50_assign_by' => 1,
                'm50_assign_by_id' => 0,
                'm50_status' => 1
            );
            $this->usernmenu_repo->create($arr);
        }
        else{
            $menu_ids = implode(",",$request->input('ckb_usermenu'));
            $arr = array(
                'm49_id' => $menu_ids,
                'm50_user_type' => 1,
                'm50_assign_by' => 1,
                'm50_assign_by_id' => 0,
                'm50_status' => 1
            );
             DB::table('m50_user_assign_menu')->where('m11_user_id',$request->input('txt_userid'))->update($arr);
        }

		Session::flash('umenu_msg','USER MENU UPDATED SUCCESSFULLY' );
		Session::flash('type','success' );
        return redirect('/user_assign_menu');
    }


     /**
        * Method name   : emp assign menu
        * @description  : Used for creating menu 
        * @param        : Request data for creating menu 
        * @return       : return with created menu 
    */
    public function emp_assign_menu()
    {
        $banks = $this->bank_repo->getAll();
        $request = request();
        $user = "";
        $USERID="";
        $get_useralldetail = "";
		$user_menus = "";
		$selected_menus = "";
        if($request->method() == 'POST')
        {
               if($request->input('txt_memberid')=='')
                {
                    $ERRMSG = "Member id should be valid or not blank.";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
                else
                {
                    $ERRMSG = "";
                    $this->isError=FALSE;
                    $ERRCODE="success";
                }
                
                if(request()->method() == 'POST' && $this->isError==FALSE)
                {
                    $userid = Helper::get_empid($request->input('txt_memberid'));
                    
                    if($userid!=FALSE)
                    {
                    $user = Helper::get_empdetail($userid);
					$user_menus = DB::select('SELECT USRMN_MENUID FROM user_assign_menu WHERE USRMN_EMPID = "'.$userid.'" AND USRMN_STATUS = "ACTIVE"');
					if(isset($user_menus[0]->USRMN_MENUID)){
					$selected_menus = explode(',',$user_menus[0]->USRMN_MENUID);
					}
					else{
					$selected_menus = "";
					}
                    $get_useralldetail = Helper::get_empalldetail($userid);
                    $ERRMSG = "Member details fetch successfully.";
                    $ERRCODE="success";
                    }
                    else
                    {
                    $ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
                    $this->isError=TRUE;
                    $ERRCODE="warning";
                    }
                }
        }
        $USERID=$request->input('txt_memberid');
        $menus = $this->assignmenu_repo->getEmpMenus();
        return view('Master.emp_assign_menu',compact('menus','user','get_useralldetail','USERID','selected_menus'));
    }

   /**
        * Method name   : add emp assign menu
        * @description  : Used for creating menu 
        * @param        : Request data for creating menu 
        * @return       : return with created menu 
    */
	public function add_emp_assign_menu()
    {
        $request = request();
		$userid = $request->input('txt_userid');
        $menu_ids = implode(",",$request->input('ckb_usermenu'));
        $already_exists = DB::select('SELECT USRMN_MENUID FROM user_assign_menu WHERE USRMN_EMPID = "'.$userid.'" AND USRMN_STATUS = "ACTIVE"');
//dd($already_exists);
        if(count($already_exists) == 0){    
            $arr = array(
                'm11_user_id' => -1,
                'm30_employee_id' => $request->input('txt_userid'),
                'm49_id' => $menu_ids,
                'm50_user_type' => 2,
                'm50_assign_by' => 1,
                'm50_assign_by_id' => 0,
                'm50_status' => 1
            );
            $this->usernmenu_repo->create($arr);
        }
        else{
            $menu_ids = implode(",",$request->input('ckb_usermenu'));
            $arr = array(
                'm49_id' => $menu_ids,
                'm50_user_type' => 2,
                'm50_assign_by' => 1,
                'm50_assign_by_id' => 0,
                'm50_status' => 1
            );
             DB::table('m50_user_assign_menu')->where('m30_employee_id',$request->input('txt_userid'))->update($arr);
        }
        Session::flash('emenu_msg','EMPLOYEE MENU UPDATED SUCCESSFULLY' );
		Session::flash('type','success' );
        return redirect('/emp_assign_menu');
    }
	
	/**
        * Method name   : Assign menu
        * @description  : Used for creating menu 
        * @param        : Request data for creating menu 
        * @return       : return with created menu 
    */
    public function user_assign_services()
    {
        $banks = $this->bank_repo->getAll();
        $request = request();
        $user = "";
        $USERID="";
        $get_useralldetail = "";
        $selected_services = "";
        if($request->method() == 'POST')
        {
               if($request->input('txt_memberid')=='')
                {
                    $ERRMSG = "Member id should be valid or not blank.";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
                else
                {
                    $ERRMSG = "";
                    $this->isError=FALSE;
                    $ERRCODE="success";
                }
                
                if(request()->method() == 'POST' && $this->isError==FALSE)
                {
                    $userid = Helper::get_userid($request->input('txt_memberid'));
                    
                    if($userid!=FALSE)
                    {
                    $user = Helper::get_userdetail($userid);
                    $get_useralldetail = Helper::get_useralldetail($userid);
                    $selected_services = DB::select('SELECT MS_SERVICE_ID FROM `user_services` WHERE USER_ID='.$userid.' AND MS_STATUS="Active"');
                    $ERRMSG = "Member details fetch successfully.";
                    $ERRCODE="success";
                    }
                    else
                    {
                    $ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
                    $this->isError=TRUE;
                    $ERRCODE="warning";
                    }
                }
        }
        $USERID=$request->input('txt_memberid');
        $services = $this->service_repo->getAll();
        return view('Master.user_assign_services',compact('services','get_useralldetail','USERID','selected_services'));
    }

	public function add_user_assign_services()
    {
        $request = request();
        $user_code = $request->input('txt_membercode');
        $userid = $request->input('txt_userid');
        $sr_ids = $request->input('ckb_user_service');
        $arr1 = array(
            'tr02_ms_status' => 2
        );
        DB::table('tr02_merchant_service')->where('m11_user_id',$userid)->update($arr1);
        
        if($sr_ids){
            foreach($sr_ids as $ss){
                $added_services = DB::select('SELECT * FROM `user_services` WHERE USER_ID='.$userid.' AND MS_SERVICE_ID='.$ss.'');
                $selected_services = DB::select('SELECT * FROM `services` WHERE SR_TYPEID ='.$ss.'');
                
                if(isset($added_services[0]->MS_ID))
                {
                    $arr = array(
                        'm03_sr_type_id' => $added_services[0]->MS_SERVICE_ID,
                        'tr02_ms_price' => $added_services[0]->MS_PRICE,
                        'tr02_ms_duration' => 1,
                        'tr02_ms_buffer' => 1,
                        'tr02_ms_status' => 1,
                        'tr02_service_expiry_notify' => 1,
                        'tr02_service_en_bb' => 1,
                        'tr02_service_low_bal_notify' => 1,
                        'tr02_service_lbn_bb' => 1
                    );
                    DB::table('tr02_merchant_service')->where('tr02_ms_id',$added_services[0]->MS_ID)->update($arr);

                }
                else{
                    $arr = array(
                        'm11_user_id' => $request->input('txt_userid'),
                        'm03_sr_type_id' => $selected_services[0]->SR_TYPEID,
                        'tr02_ms_price' => $selected_services[0]->SR_SURCHARGE,
                        'tr02_ms_duration' => 1,
                        'tr02_ms_buffer' => 1,
                        'tr02_ms_status' => 1,
                        'tr02_service_expiry_notify' => 1,
                        'tr02_service_en_bb' => 1,
                        'tr02_service_low_bal_notify' => 1,
                        'tr02_service_lbn_bb' => 1
                    );
                    DB::table('tr02_merchant_service')->insert($arr);

                }
            } 
        }
        $arr = array(
            'tr11_ar_tblnm' => 'tr02_merchant_service',
            'tr11_ar_old_value' => '',
            'tr11_ar_new_value' => $user_code,
            'tr11_ar_uid' => $userid,
            'tr11_ar_description' => 'SERVICE UPDATED TO USER SUCCESSFULLY!',
			'tr11_updated_by' => 1,
			'tr11_updated_by_id' =>  Session::get('USER_ID')
        );
        $mobileno_actionrecord=$this->log_repo->create($arr);
		Session::flash('service_msg','USER SERVICES UPDATED SUCCESSFULLY' );
		Session::flash('type','success' );
        return redirect('/user_assign_services');
    }



    /**
        * Method name   : get rale 
        * @description  : get raole master page assing menu
        * @param        : Request data for creating user menu 
        * @return       : return with created user menu 
    */
    public function get_role_type(request $request)
    {
        $id = $request->id;
        if($id == 18)
        {
            //$data = $this->Role_repo->getByPId(['1','10']);
            $data = DB::select('SELECT * FROM `roles` WHERE PARENT_ROLE_ID IN (1 ,10)');

             if(count($data) > 0)
             {
                return $data;
             }
             else
             {
                return '';
             } 
        }
        if($id == 19)
        {
            return 'USER WISE';
        }
        else
        {
            $data = $this->Role_repo->getByPId($id);

             if(count($data) > 0)
             {
                return $data;
             }
             else
             {
                return '';
             }  
        }

    }







    public function create_denomination()
    {
        $data = $this->Denomination_repo->getAll();
       return view('Denomination.add-denomination-page',compact('data'));
    }

    public function add_denomination(request $request)
    {
        
            $validation = $this->validate($request, [
                'txt_denominat' => 'required|numeric|between:0,99.99'
            ]);

            $array = [
                        'm67_denominat' => $request->input('txt_denominat'), 
                        'm67_desc' => $request->input('txt_desc'),
                        'm67_created_by' => 1,
                        'm67_created_by_id' => Session()->get('USER_ID'),
                    ];
 
            $data = $this->Denomination_repo->create($array);

            if($data)
            {
                Session::flash('massage','Create Successfully');
                Session::flash('type','success' );
                return back();
            }
            else
            {
                Session::flash('massage','Create Successfully');
                Session::flash('type','warning');
                return back();
            }
    }


    public function edit_denomination($id)
    {
        $data = $this->Denomination_repo->getAll();
        $SingleData = $this->Denomination_repo->getById($id);
       return view('Denomination.edit-denomination-page',compact('data','SingleData'));
    }


    public function update_denomination(request $request, $id)
    {
        
            $validation = $this->validate($request, [
                'txt_denominat' => 'required|numeric|between:0,99.99'
            ]);

            $array = [
                        'm67_denominat' => $request->input('txt_denominat'), 
                        'm67_desc' => $request->input('txt_desc'),
                        'm67_updated_by' => 1,
                        'm67_updated_by_id' => Session()->get('USER_ID'),
                    ];
 
            $data = $this->Denomination_repo->update($id, $array);

            if($data)
            {
                Session::flash('massage','Update Successfully');
                Session::flash('type','success' );
                return redirect('create-denomination-range');
            }
            else
            {
                Session::flash('massage','Not Update Successfully');
                Session::flash('type','warning');
                return redirect('create-denomination-range');
            }
    }



    public function create_denomination_range()
    {
        $data = $this->DenominationRange_repo->getAll();
       return view('Denomination.add-denomination-range-page',compact('data'));
    }

    public function add_denomination_range(request $request)
    {
        
            $validation = $this->validate($request, [
                'txt_denominat_max' => 'required|numeric|gt:txt_denominat_min|between:0,99999.99',
                'txt_denominat_min' => 'required|numeric|between:0,9999.99'
            ]);

            $array = [
                        'm68_min_range' => $request->input('txt_denominat_min'), 
                        'm68_max_range' => $request->input('txt_denominat_max'), 
                        'm68_desc' => $request->input('txt_desc'),
                        'm68_created_by' => 1,
                        'm68_created_by_id' => Session()->get('USER_ID'),
                    ];
 
            $data = $this->DenominationRange_repo->create($array);

            if($data)
            {
                Session::flash('massage','Create Successfully');
                Session::flash('type','success' );
                return back();
            }
            else
            {
                Session::flash('massage','Create Successfully');
                Session::flash('type','warning');
                return back();
            }
    }


    public function edit_denomination_range($id)
    {
        $data = $this->DenominationRange_repo->getAll();
        $SingleData = $this->DenominationRange_repo->getById($id);
       return view('Denomination.edit-denomination-range-page',compact('data','SingleData'));
    }


    public function update_denomination_range(request $request, $id)
    {
        
            $validation = $this->validate($request, [
                'txt_denominat_min' => 'required|numeric|between:0,9999.99',
                'txt_denominat_max' => 'required|numeric|gt:txt_denominat_min|between:0,99999.99'
            ]);

            $array = [
                        'm68_min_range' => $request->input('txt_denominat_min'), 
                        'm68_max_range' => $request->input('txt_denominat_max'), 
                        'm68_desc' => $request->input('txt_desc'),
                        'm68_updated_by' => 1,
                        'm68_updated_by_id' => Session()->get('USER_ID'),
                    ];
 
            $data = $this->DenominationRange_repo->update($id, $array);

            if($data)
            {
                Session::flash('massage','Update Successfully');
                Session::flash('type','success' );
                return redirect('create-denomination-range');
            }
            else
            {
                Session::flash('massage','Not Update Successfully');
                Session::flash('type','warning');
                return redirect('create-denomination-range');
            }
    }
       




       

    public function admin_services($id='')
    {
        $all_adminsr = DB::select('SELECT * FROM admin_service_charges');
		$bdtype = $this->BalanceDeductionTypes_repo->getAll();
		$affil =	$this->Affiliate_repo->getAll();
        $admin_roles = $this->Role_repo->getByPId(1);
        $single_adminsr = '';
        if($id!='')
        {
            $single_adminsr = DB::select('SELECT * FROM admin_service_charges WHERE SC_ID='.$id);
        }
		$service = DB::select("SELECT * FROM `m03_service_type` WHERE m03_sr_type_status = 'Active'");
        return view('Master.service_charges',compact('all_adminsr','single_adminsr','admin_roles','bdtype','affil','service'));
    }

    public function add_admin_services()
    {
        $request = request();

            $validation = $this->validate($request, [
                'dd_role' => 'required|numeric',
				'dd_feetype' => 'required|numeric',
				'dd_affiliate' => 'required|numeric',
				'txt_amount' => 'required|numeric',
                'txt_dist_ratio' => 'required|numeric|between:0,100',
				'dd_balance_type' => 'required',
            ]);
		
		if($request->input('dd_service') == '')
		{ $serv = '';  }
		else{ $serv = implode(",",$request->input('dd_service')); }
		
        $arr = array(
            'm65_id' => $request->input('dd_role'),
			'm70_ledger_id'=>$request->input('dd_feetype'),
            'm22_affiliate_id'=>$request->input('dd_affiliate'),
            'm69_deduction_amount' => $request->input('txt_amount'),
            'm69_distribution_ratio' => $request->input('txt_dist_ratio'),
            'm69_description' => $request->input('txt_desc'),
            'tr03_bal_type' => $request->input('dd_balance_type'),
			'm03_services' => $serv,
            'm69_created_by' => 1,
            'm69_created_by_id' => SESSION::get('USER_ID')
        );
		$check = DB::table('m69_service_charges')->where('m65_id', $request->input('dd_role'))->where('m70_ledger_id', $request->input('dd_feetype'))->where('m22_affiliate_id', $request->input('dd_affiliate'))->first();

		if($check)
		{
			Session::flash('message','Duplicate entry');
			Session::flash('type','error');
			return redirect('/admin_services');
		}
		else
		{
			Session::flash('message','Insert Successfully');
			Session::flash('type','success');
			DB::table('m69_service_charges')->insert($arr);
		}
        return redirect('/admin_services');
    }


    public function update_admin_services($id)
    {
        $request = request();
        $old_value = DB::select('SELECT * FROM admin_service_charges WHERE SC_ID='.$id);

		if($request->input('dd_service') == '')
		{ $serv = '';  }
		else{ $serv = implode(",",$request->input('dd_service')); }

        $arr = array(
            'm65_id' => $request->input('dd_role'),
			'm70_ledger_id'=>$request->input('dd_feetype'),
            'm22_affiliate_id'=>$request->input('dd_affiliate'),
            'm69_deduction_amount' => $request->input('txt_amount'),
            'm69_distribution_ratio' => $request->input('txt_dist_ratio'),
            'tr03_bal_type' => $request->input('dd_balance_type'),
			'm03_services' => $serv,
            'm69_description' => $request->input('txt_desc'),
            'm69_updated_by' => 1,
            'm69_updated_by_id' => SESSION::get('USER_ID')
        );

        $result = DB::table('m69_service_charges')->where('m69_sc_id',$id)->update($arr);

        if($result==1){
            $arr = array(
                'tr11_ar_tblnm' => 'm69_service_charges',
                'tr11_ar_old_value' => $old_value[0]->SC_AMOUNT,
                'tr11_ar_new_value' => $request->input('txt_amount'),
                'tr11_ar_uid' => -1,
                'tr11_ar_description' => $request->input('txt_desc').' SERVICE CHARGE HAS BEEN UPDATED SUCCESSFULLY!',
						'tr11_updated_by' => 1,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
            );

            $kyc_actionrecord=$this->log_repo->create($arr); 
			Session::flash('message','Update Successfully');
			Session::flash('type','success');
        }
        return redirect('/admin_services');
    }



		public function status_admin_services($id, $st)
		{
		if($st == 'ACTIVE' && $id != '')
		{
			DB::table('m69_service_charges')->where('m69_sc_id', $id)->update(['m69_status' => 2]);
					Session::flash('message','Status Change Successfully');
					Session::flash('type','success');
					return redirect('/admin_services');
		}
		elseif($st == 'INACTIVE' && $id != '')
		{
			DB::table('m69_service_charges')->where('m69_sc_id', $id)->update(['m69_status' => 1]);
					Session::flash('message','Status Change Successfully');
					Session::flash('type','success');
					return redirect('/admin_services');
		}
		else
		{
					Session::flash('message','Status Not Change Successfully');
					Session::flash('type','warning');
					return redirect('/admin_services');
		}
		}




    public function view_balance_deduction_types()
    {
		$affiliate_id = 1;
		$role_id = 7;
		$service_type_id = 1;
		//$BD_AMO = Helper::service_charges($affiliate_id, $role_id, $service_type_id);

        $data['all'] = $this->BalanceDeductionTypes_repo->getAll();
		$data['single'] = '';
        return view('Master.balance-deduction-types-page',compact('data'));
    }

    public function create_balance_deduction_types(request $request)
    {

            $validation = $this->validate($request, [
                'txt_name' => 'required|unique:m70_balance_deduction_types,m70_bdt_name',
				'dd_deduction_type' => 'required',
				'dd_ledger_type' => 'required',
				'txt_ledger_type' => 'required',
            ], 
			[ 'txt_name.required' =>'Name field is required',
			  'txt_name.unique' =>'Name already exists',
			  'dd_deduction_type.required' =>'Deduction Types field is required',
			  'dd_ledger_type.required' =>'Ledger Type field is required',
			  'txt_ledger_type.required' =>'Ledger Type Order Number field is required',
				]);

        $arr = array(
            'm70_bdt_name' => $request->input('txt_name'),
			'm70_deduction_types'=>$request->input('dd_deduction_type'),
			'm70_manage_ledger_types'=>$request->input('dd_ledger_type'),
			'tr03_m_ledger_type'=>$request->input('txt_ledger_type'),
            'm70_bdt_desc'=>$request->input('txt_desc'),
            'm70_created_by' => 1,
            'm70_created_by_id' => SESSION::get('USER_ID')
        );

		$data = $this->BalanceDeductionTypes_repo->create($arr);

            if($data)
            {
                Session::flash('message','Create Successfully');
                Session::flash('type','success' );
                return redirect('/view-balance-deduction-types');
            }
            else
            {
                Session::flash('message','Not Create Successfully');
                Session::flash('type','warning');
                return redirect('/view-balance-deduction-types');
            }
    }


    public function edit_balance_deduction_types($id)
    {
        $data['all'] = $this->BalanceDeductionTypes_repo->getAll();
		$data['single'] = $this->BalanceDeductionTypes_repo->getById($id);
        return view('Master.balance-deduction-types-page',compact('data'));
    }


    public function update_balance_deduction_types(request $request, $id)
    {			
				$validation = $this->validate($request, [
					'txt_name' => 'required',
					'dd_deduction_type' => 'required',
					'dd_ledger_type' => 'required',
					'txt_ledger_type' => 'required',
				], 
				[ 
				  'txt_name.required' =>'Name field is required',
				  'dd_deduction_type.required' =>'Name field is required',
				  'dd_ledger_type.required' =>'Name field is required',
				 'txt_ledger_type.required' =>'Ledger Type Order Number field is required',
					]);

			$arr = array(
				'm70_bdt_name' => $request->input('txt_name'),
				'm70_deduction_types'=>$request->input('dd_deduction_type'),
				'm70_manage_ledger_types'=>$request->input('dd_ledger_type'),
				'tr03_m_ledger_type'=>$request->input('txt_ledger_type'),
				'm70_bdt_desc'=>$request->input('txt_desc'),
				'm70_updated_by' => 1,
				'm70_updated_bY_id' => SESSION::get('USER_ID')
			);

			$data = $this->BalanceDeductionTypes_repo->update($id, $arr);

				if($data)
				{
					Session::flash('message','Update Successfully');
					Session::flash('type','success' );
					return redirect('/view-balance-deduction-types');
				}
				else
				{
					Session::flash('message','Not Update Successfully');
					Session::flash('type','warning');
					return redirect('/view-balance-deduction-types');
				}
    }








    public function view_level_commission()
    {
        $affiliate_id = 1;
        $role_id = 8;
        $service_type_id = 1;

        $data['all'] = $this->LevelCommissionTypes_repo->getAll();

        $affil =    $this->Affiliate_repo->getAll();
        $admin_roles = $this->Role_repo->getByPId(1);
        $single_adminsr = '';
        $data['single'] = [];

        $service = DB::select("SELECT * FROM `m03_service_type` WHERE m03_sr_type_status = 'Active'");
        $toupdata = DB::select("SELECT * FROM `m27_package` WHERE m27_pack_status = 'Active'");
        
        return view('Master.level-commission-types-page',compact('data','admin_roles','affil','service','toupdata'));
    }




   public function edit_level_commission($id, $type)
    {
        $affiliate_id = 1;
        $role_id = 8;
        $service_type_id = 1;
       

        $data['all'] = $this->LevelCommissionTypes_repo->getAll();

        $affil =    $this->Affiliate_repo->getAll();
        $admin_roles = $this->Role_repo->getByPId(1);

        $single_adminsr = '';
        $data['single'] = [];


        if($type =='TOPUP')
        {
            $data['single'] = $this->LevelCommissionTypes_repo->getByTopupId($id);
        
        }
        elseif($type =='SERVICE')
        {
            $data['single'] = $this->LevelCommissionTypes_repo->getByServicId($id);
        
        }

        $service = DB::select("SELECT * FROM `m03_service_type` WHERE m03_sr_type_status = 'Active'");
        $toupdata = DB::select("SELECT * FROM `m27_package` WHERE m27_pack_status = 'Active'");
        
        return view('Master.level-commission-types-page',compact('data','admin_roles','affil','service','toupdata'));
    }





    public function create_level_commission()
    {
        $request = request();

            $validation = $this->validate($request, [
                'dd_affiliate' => 'required|numeric',
                'txt_amount' => 'required',
                'dd_balance_type' => 'required',
                'dd_commission_type' => 'required',
            ],[
            'dd_affiliate.required'=> 'Affiliate is required',
            'dd_affiliate.numeric'=> 'Affiliate is required',
            'txt_amount.required' => 'level commission is required',
            'dd_balance_type.required' => 'balance type is required',
            'dd_commission_type.required' => 'Commission For is required',
        ]);
    
    $data = 0;

        if($request->input('dd_commission_type') == 1)
        {
            foreach($request->input('dd_service') as $key => $value)
            {
                $sno = 1;
                foreach($request->input('txt_amount') as $keys => $values)
                {

                     $check = DB::table('m78_levelw_commission')->where('m78_level', $sno)->where('m03_services', $value)->where('m78_level_comfor', 'SERVICE')->first();

                        if(!$check)
                        {
                            $arr = array(
                                'm65_id' => 9,
                                'm78_level'=>$sno,
                                'm22_affiliate_id'=>$request->input('dd_affiliate'),
                                'm78_deduction_amount' => $values,
                                'm78_level_comfor' => $request->input('dd_commission_type'),
                                'm78_description' => $request->input('txt_desc'),
                                'tr03_bal_type' => $request->input('dd_balance_type'),
                                'm27_topup_id' => -1,
                                'm03_services' => $value,
                                'tr03_m_ledger_type' => 1
                            );

                           $data = $this->LevelCommissionTypes_repo->create($arr);
                        }
                    
                    ++$sno;
                }
            }

            if($data)
            {
                Session::flash('message','Insert Successfully');
                Session::flash('type','success');
            }
            else
            {
                Session::flash('message','Not Insert Successfully');
                Session::flash('type','warning');
            }

            return redirect('/view-level-commission');

        }
        elseif($request->input('dd_commission_type') == 2)
        {
            foreach($request->input('dd_topup') as $key => $value)
            {
                $sno = 1;
                foreach($request->input('txt_amount') as $keys => $values)
                {
                     $check = DB::table('m78_levelw_commission')->where('m78_level', $sno)->where('m27_topup_id', $value)->where('m78_level_comfor', 'TOPUP')->first();

                        if(!$check)
                        {
                            $arr = array(
                                'm65_id' => 9,
                                'm78_level'=>$sno,
                                'm22_affiliate_id'=>$request->input('dd_affiliate'),
                                'm78_deduction_amount' => $values,
                                'm78_level_comfor' => $request->input('dd_commission_type'),
                                'm78_description' => $request->input('txt_desc'),
                                'tr03_bal_type' => $request->input('dd_balance_type'),
                                'm27_topup_id' => $value,
                                'm03_services' => -1,
                                'tr03_m_ledger_type' => 1
                            );

                       // $data = $this->LevelCommissionTypes_repo->create($arr);
                        }
                    
                    ++$sno;
                }
            }

            if($data)
            {
                Session::flash('message','Insert Successfully');
                Session::flash('type','success');
            }
            else
            {
                Session::flash('message','Not Insert Successfully');
                Session::flash('type','warning');
            }

            return redirect('/view-level-commission');    
        }
        else
        {
            Session::flash('message','Incorrect Commission For');
            Session::flash('type','warning');
            return redirect('/view-level-commission');
        }

    }


    public function update_level_commission($id)
    {
        $request = request();


            $validation = $this->validate($request, [
                'dd_affiliate' => 'required|numeric',
                'txt_amount' => 'required',
                'dd_balance_type' => 'required',
                'dd_commission_types' => 'required',
            ],[
            'dd_affiliate.required'=> 'Affiliate is required',
            'dd_affiliate.numeric'=> 'Affiliate is required',
            'txt_amount.required' => 'level commission is required',
            'dd_balance_type.required' => 'balance type is required',
            'dd_commission_types.required' => 'Commission For is required',
        ]);


        if($request->input('dd_commission_types') == 'SERVICE')
        {

            $sno = 1;
            foreach($request->input('txt_amount') as $keys => $values)
            {
                        $arr = array(
                            'm78_level'=>$sno,
                            'm22_affiliate_id'=>$request->input('dd_affiliate'),
                            'm78_deduction_amount' => $values,
                            'm78_description' => $request->input('txt_desc'),
                            'tr03_bal_type' => $request->input('dd_balance_type'),
                        );

                        $data = $this->LevelCommissionTypes_repo->updateservice($sno, $id, $arr);

                ++$sno;
            }

            Session::flash('message','Update Successfully');
            Session::flash('type','success');

            return redirect('/view-level-commission');

        }
        elseif ($request->input('dd_commission_types') == 'TOPUP') 
        {
           
            $sno = 1;
            foreach($request->input('txt_amount') as $keys => $values)
            {
                        $arr = array(
                            'm78_level'=>$sno,
                            'm22_affiliate_id'=>$request->input('dd_affiliate'),
                            'm78_deduction_amount' => $values,
                            'm78_description' => $request->input('txt_desc'),
                            'tr03_bal_type' => $request->input('dd_balance_type'),
                        );

                        $data = $this->LevelCommissionTypes_repo->updatetopup($sno, $id, $arr);

                ++$sno;
            }

            Session::flash('message','Update Successfully');
            Session::flash('type','success');

            return redirect('/view-level-commission');
        }
        else
        {
            Session::flash('message','Incorrect Commission For');
            Session::flash('type','warning');
            return redirect('/view-level-commission');
        }

    }





		public function status_level_commission($id, $st)
		{

		if($st == 'ACTIVE' && $id != '')
		{
			DB::table('m78_levelw_commission')->where('m78_lvl_id', $id)->update(['m78_status' => 2]);
					Session::flash('message','Status Change Successfully');
					Session::flash('type','success');
					 return redirect('/view-level-commission');
		}
		elseif($st == 'INACTIVE' && $id != '')
		{
			DB::table('m78_levelw_commission')->where('m78_lvl_id', $id)->update(['m78_status' => 1]);
					Session::flash('message','Status Change Successfully');
					Session::flash('type','success');
					 return redirect('/view-level-commission');
		}
		else
		{
					Session::flash('message','Status Not Change Successfully');
					Session::flash('type','warning');
					 return redirect('/view-level-commission');
		}
		}







    public function view_custom_message()
    {
        $data['all'] = DB::SELECT("SELECT * FROM custom_message");
		$data['single'] = '';
        return view('Master.custom_message_page',compact('data'));
    }

    public function create_custom_message(request $request)
    {
			$em = '';
			$sm = '';
			if($request->input('dd_sms_type') == 1)
			{
					$em = 'required';
					$sm = '';
			}
			if($request->input('dd_sms_type') == 2)
			{
					$em = '';
					$sm = 'required';
			}
			if($request->input('dd_sms_type') == 3)
			{
					$em = 'required';
					$sm = 'required';
			}

            $validation = $this->validate($request, [
                'txt_name' => 'required|unique:m71_custom_message,m71_route_url',
				 'dd_template' => $em,
				 'dd_templates' => $sm 
            ], 
			[ 'txt_name.required' =>'Name field is required',
			 'dd_template.required' =>'Email Template field is required',
			 'dd_templates.required' =>'SMS Template field is required',
			  'txt_name.unique' =>'Name already exists'
			]);

        $arr = array(
            'm71_route_url' => $request->input('txt_name'),
			 'm71_sms_type' => $request->input('dd_sms_type'),
			 'm71_template_emil_id' => $request->input('dd_template'),
			 'm71_template_sms_id' => $request->input('dd_templates'),
            'm71_desc'=>$request->input('txt_desc'),
            'm71_created_by' => 1,
            'm71_created_by_id' => SESSION::get('USER_ID')
        );

		$data = DB::table('m71_custom_message')->insert($arr);

            if($data)
            {
                Session::flash('message','Create Successfully');
                Session::flash('type','success' );
                return redirect('/view-custom-message');
            }
            else
            {
                Session::flash('message','Not Create Successfully');
                Session::flash('type','warning');
                return redirect('/view-custom-message');
            }
    }


    public function edit_custom_message($id)
    {
        $data['all'] = DB::SELECT("SELECT * FROM custom_message");
		$data['single'] = DB::SELECT("SELECT * FROM custom_message WHERE ID = ".$id);
		$data['1'] = DB::SELECT("SELECT * FROM config_msg WHERE MSG_TYPE = 'NON CAMPAIGAN' AND MSG_SENT_FROM = 1");	
		$data['2'] = DB::SELECT("SELECT * FROM config_msg WHERE MSG_TYPE = 'NON CAMPAIGAN' AND MSG_SENT_FROM = 2");	
        return view('Master.custom_message_page',compact('data'));
    }


    public function update_custom_message(request $request, $id)
    {			
			$em = '';
			$sm = '';
			if($request->input('dd_sms_type') == 1)
			{
					$em = 'required';
					$sm = '';
			}
			if($request->input('dd_sms_type') == 2)
			{
					$em = '';
					$sm = 'required';
			}
			if($request->input('dd_sms_type') == 3)
			{
					$em = 'required';
					$sm = 'required';
			}

            $validation = $this->validate($request, [
                'txt_name' => 'required',
				 'dd_template' => $em,
				 'dd_templates' => $sm 
            ], 
			[ 'txt_name.required' =>'Name field is required',
			 'dd_template.required' =>'Email Template field is required',
			 'dd_templates.required' =>'SMS Template field is required',
			  'txt_name.unique' =>'Name already exists'
			]);

        $arr = array(
            'm71_route_url' => $request->input('txt_name'),
			 'm71_sms_type' => $request->input('dd_sms_type'),
			 'm71_template_emil_id' => $request->input('dd_template'),
			 'm71_template_sms_id' => $request->input('dd_templates'),
            'm71_desc'=>$request->input('txt_desc'),
            'm71_updated_by' => 1,
            'm71_updated_by_id' => SESSION::get('USER_ID')
        );

		$data = DB::table('m71_custom_message')->where('m71_id', $id)->update($arr);

            if($data)
            {
                Session::flash('message','Create Successfully');
                Session::flash('type','success' );
                return redirect('/view-custom-message');
            }
            else
            {
                Session::flash('message','Not Create Successfully');
                Session::flash('type','warning');
                return redirect('/view-custom-message');
            }
    }




    public function status_custom_message($id , $st)
    {			

		if($st == 'INACTIVE')
		{
			$data = DB::table('m71_custom_message')->where('m71_id', $id)->update(['m71_status' => 1, 'm71_updated_by' => 1, 'm71_updated_by_id' => SESSION::get('USER_ID')]);
		}
		elseif($st == 'ACTIVE')
		{
			$data = DB::table('m71_custom_message')->where('m71_id', $id)->update(['m71_status' => 2, 'm71_updated_by' => 1, 'm71_updated_by_id' => SESSION::get('USER_ID')]);
		}
		else
		{
                Session::flash('message','Not Change Successfully');
                Session::flash('type','warning');
                return redirect('/view-custom-message');
		}
            if($data)
            {
                Session::flash('message','Change Successfully');
                Session::flash('type','success' );
                return redirect('/view-custom-message');
            }
            else
            {
                Session::flash('message','Not Change Successfully');
                Session::flash('type','warning');
                return redirect('/view-custom-message');
            }
    }



    public function get_template_types(request $request)
    {
		$data['1'] = '';
		$data['2'] = '';
		if($request->type == 1 && $request->type != 3)
		{
			$data['1'] = DB::SELECT("SELECT * FROM config_msg WHERE MSG_TYPE = 'NON CAMPAIGAN' AND MSG_SENT_FROM =". $request->type);	
			return $data;
		}
		if($request->type == 2 && $request->type != 3)
		{
			$data['2'] = DB::SELECT("SELECT * FROM config_msg WHERE MSG_TYPE = 'NON CAMPAIGAN' AND MSG_SENT_FROM =". $request->type);	
			return $data;
		}
		elseif($request->type == 3)
		{
			$data['1'] = DB::SELECT("SELECT * FROM config_msg WHERE MSG_TYPE = 'NON CAMPAIGAN' AND MSG_SENT_FROM = 1");	
			$data['2'] = DB::SELECT("SELECT * FROM config_msg WHERE MSG_TYPE = 'NON CAMPAIGAN' AND MSG_SENT_FROM = 2");	
			return $data;
		}
		else
		{
			return $data;
		}
    }


    /**
        * Method name   : View Settings
        * @description  : change panel settings  
        * @param        : get config data
        * @return       : return with view config value
    */

    public function setting()
    {
        return view('Master.setting-page');
    }



    /**
        * Method name   : update Settings
        * @description  : update panel settings  
        * @param        : update config data
        * @return       : return with view config value
    */

    public function update_setting(request $request)
    {
        $this->config_repo->updateByName('FUND_INTERVAL',["m00_value" => $request->input('txtfundinterval')]);

        $this->config_repo->updateByName('MIN_FUN_TRANSFER',["m00_value" => $request->input('txtminfundtransfer')]);

        $this->config_repo->updateByName('ADMIN_PASS_EXPIRY',["m00_value" => $request->input('txtadminpwdexpiry')]);
        
        $this->config_repo->updateByName('WRONG_LOGIN_ATTEMPT',["m00_value" => $request->input('txtwrongloginattempt')]);
        
        $this->config_repo->updateByName('INTERVAL_RECHARGE',["m00_value" => $request->input('txtintervalrecharge')]);
        
        $this->config_repo->updateByName('MAX_FUND_TRANSFER',["m00_value" => $request->input('txtmaxfundtransfer')]);
        
        $this->config_repo->updateByName('USER_PASS_EXPIRY',["m00_value" => $request->input('txtuserpwdexpiry')]);
        
        $this->config_repo->updateByName('APP_V',["m00_value" => $request->input('txtappversion')]);
        
        $this->config_repo->updateByName('BALANCE_ALERT_INVERVAL',["m00_value" => $request->input('txtbalalertinterval')]);
        
        if($request->input('isLookupfromapi'))
        {
            $this->config_repo->updateByName('ISLOOKUP_FROMAPI',["m00_value" => 'YES']);
        }
        else
        {
            $this->config_repo->updateByName('ISLOOKUP_FROMAPI',["m00_value" => 'NO']);
        }        

        if($request->input('signupverification'))
        {
             $this->config_repo->updateByName('SIGNUP_VERIFICATION',["m00_value" => 'YES']);
        }
        else
        {
            $this->config_repo->updateByName('SIGNUP_VERIFICATION',["m00_value" => 'NO']);
        }
        
        
        $this->config_repo->updateByName('MIN_BAL_ALERT',["m00_value" => $request->input('txtminbalalert')]);
        Session::flash('message','Successfully update');
        Session::flash('type','success' );
        return back();
    }


    /**
        * Method name   : update shoping Settings
        * @description  : update panel shoping settings  
        * @param        : update config data
        * @return       : return with view config value
    */

    public function update_shoping_setting(request $request)
    {

        $this->config_repo->updateByName('SHOPING_MIN_AMO',["m00_value" => $request->input('txtminfundtransfer')]);

        $this->config_repo->updateByName('SHOPING_MAX_AMO',["m00_value" => $request->input('txtmaxfundtransfer')]);

        $this->config_repo->updateByName('TOPUP_DIVIDE_INMONTH',["m00_value" => $request->input('txtwrongloginattempt')]);

        $this->config_repo->updateByName('TOPUP_AMO_USER_INDAY',["m00_value" => $request->input('txtadminpwdexpiry')]);
        
        $this->config_repo->updateByName('TOPUP_AMO_DED_INDAY',["m00_value" => $request->input('txtuserpwdexpiry')]);
        
        Session::flash('message','Successfully update');
        Session::flash('type','success' );
        return back();
    }

	

	public function bannerimages()
    {
		$banners = $this->banner_repo->getAll();
		$affi = $this->Affiliate_repo->getAll();
        $single_banner = '';
        return view('Master.banner_images',compact('single_banner', 'banners','affi'));
    }

    public function coupons()
    {
		$user_news ='';
        return view('Master.coupons',compact('user_news'));
    }

    public function subscription()
    {
		$user_news ='';
        return view('Master.subscription',compact('user_news'));
    }
    public function faq()
    {
		$user_news ='';
        return view('Master.faq',compact('user_news'));
    }
    public function productreview()
    {
		$user_news ='';
        return view('Master.productreview',compact('user_news'));
    }
    public function socialauth()
    {
		$user_news ='';
        return view('Master.socialauth',compact('user_news'));
    }
    public function paymentsetting()
    {
		$user_news ='';
        return view('Master.paymentsetting',compact('user_news'));
    }



    public function ecom_image_size()
    {
        $results=$this->imagesize_repo->getAll();
        $single_image='';
      
        return view('Master.image_size',compact('results','single_image'));
    }


    public function imagesize_status($id)
    {
        $results=$this->imagesize_repo->active($id);
      
        return redirect('images_size');
    }

     public function imagesize_edit($id)
    {
        
         $results=$this->imagesize_repo->getAll();
         $single_image=$this->imagesize_repo->getById($id);
         return view('Master.image_size',compact('results','single_image'));

    }




    public function ecom_image_size_save(Request $request)
    {
         
         $request->validate([
            'txt_name'=>'required',
            'txt_image_width'=>'required|numeric',
            'txt_image_height'=>'required|numeric',
              ]);
         $data=[
            'm76_name'=>$request->input('txt_name'),
            'm76_width'=>$request->input('txt_image_width'),
            'm76_height'=>$request->input('txt_image_height'),
            'm76_status'=>$request->input('dd_image_status')
         ];
        
         $this->imagesize_repo->create($data);
     
          return redirect('images_size');
    }


    

    public function ecom_image_size_update(Request $request,$id)
    {
         

         $request->validate([
            'txt_name'=>'required',
            'txt_image_width'=>'required',
            'txt_image_height'=>'required',
            'dd_image_status'=>'required',
         ]);


         
         $data=[
            'm76_name'=>$request->input('txt_name'),
            'm76_width'=>$request->input('txt_image_width'),
            'm76_height'=>$request->input('txt_image_height'),
            'm76_status'=>$request->input('dd_image_status'),
            
              ];

          $imagesize_update = $this->imagesize_repo->update($id,$data);
          $request->session()->flash('image_msg','Updation successfull.');
          return redirect('images_size');
    }




    
    public function ajax_check_img_height_width(Request $request)
    {  
        $name=$request->img_name;
        $width=$request->img_width;
        $height=$request->img_height;
        $getname=DB::select("SELECT m76_name FROM m76_image_size WHERE m76_name='{$name}'");
        $getdata=DB::select("SELECT m76_width,m76_height FROM m76_image_size WHERE m76_width='{$width}' and m76_height='{$height}'");
        if ($getdata!=[]) {
            return 'false';
        }if($getname!=[]){
            return 'true';
        }
        
    }



    public function ecom_bannerimages()
    {
        $banners = $this->banner_repo->getAll();
        $affi = $this->Affiliate_repo->getAll();
        $categories = $this->cat_repo->getAllCategory();
        $imagesize=$this->imagesize_repo->getByType();
        $single_banner = '';
        return view('Master.banner_images',compact('single_banner', 'banners','affi','imagesize','categories'));
    }


 
    public function user_add_banner(Request $request)
    {
           

        $request->validate([
            'txt_banner_name'=>'required',
            'dd_banner_type'=>'required',
            'dd_banner_category'=>'required',
            'txt_banner_desc'=>'required',
            'txt_banner_meta'=>'required',
            'file_banner_img'=>'required|mimes:jpg,png,jpeg',
            'dd_banner_status'=>'required'
        ]); 

         if($request->hasFile('file_banner_img')){
              
           
                $data = getimagesize($request->file_banner_img);


                      if ($request->input('dd_banner_size') and $request->input('dd_banner_size')!='') 
                      {
                         $size=$request->input('dd_banner_size');
                         $res=$this->imagesize_repo->getById($size);

                              $width=$res[0]->m76_width;
                              $height=$res[0]->m76_height;



                        if ($data[0]>=$width and $data[1]>=$height) 
                             {
                             
                                    $image = $request->file('file_banner_img');
                                    $time = date("d-m-Y")."-".time() ;
                                    $image_name = $image->getClientOriginalName();
                                    $imageName = $time.'.'.$image->getClientOriginalExtension();
                                    $destinationPath = public_path('/images/front/');
                                    $img1 = \Image::make($image->getRealPath())->resize($width, $height);
                                    $img1->save($destinationPath.'/'.$imageName); 

                                    $destinationPath = public_path('/images/front/original');  
                                    $image->move($destinationPath, $imageName);  
                                               
        
                            }else{
                               return redirect('banner_images')->with('error','Please Upload a Valid Image which width and height must be equal or greater then Banner size');
                             }
                      }else{

                         $image = $request->file('file_banner_img');
                         $time = date("d-m-Y")."-".time() ;
                         $image_name = $image->getClientOriginalName();
                         $imageName = $time.'.'.$image->getClientOriginalExtension();
                         $destinationPath = public_path('/images/front/');
                         $image->move($destinationPath, $imageName);
 
                      }
                

            }


          $data=[
            'm47_banner_name'=>$request->input('txt_banner_name'),
            'm47_banner_var'=>"1", 
            'm36_category'=>$request->input('dd_banner_category'),
            'm47_banner_for'=>$request->input('dd_banner_for'),
            'm47_banner_desc'=>$request->input('txt_banner_desc'),
            'm47_banner_meta'=>$request->input('txt_banner_meta'),
            'm47_banner_img'=> $imageName,
            'm47_banner_status'=>$request->input('dd_banner_status'),
              ];
           $this->banner_repo->create($data);
            $request->session()->flash('banner_msg','Data Iserted successfully.');
            $request->session()->flash('type','success');
        return redirect('banner_images');
    }




    public function user_edit_banner($id)
    {
        $banners = $this->banner_repo->getAll();
        $affi = $this->Affiliate_repo->getById($id);
        $imagesize=$this->imagesize_repo->getAll();
        $categories = $this->cat_repo->getAllCategory();
        $single_banner = $this->banner_repo->getById($id);
        return view('Master.banner_images',compact('single_banner', 'banners','affi','imagesize','categories'));
    }


    public function user_update_banner(Request $request,$id)
    {
       $old_image=$request->input('txt_old_banner');

       if ( $request->input('file_banner_img')=='') {
                 $newimg=$request->input('file_banner_img');
                 $old_img=$old_image;

                 $res=$newimg=$old_img;

       }
        
           $request->validate([
            'txt_banner_name'=>'required',
            'dd_banner_type'=>'required',
            'dd_banner_category'=>'required',
            'txt_banner_desc'=>'required',
            'txt_banner_meta'=>'required',
            'file_banner_img'=>'mimes:jpg,png,jpeg',
            'dd_banner_status'=>'required'
        ]);




        if($request->hasFile('file_banner_img'))
         {

            /*  Unlink from the main Folder */

                  if (\File::exists(public_path("images/front/{$old_image}") ) )
                   {
                        \File::delete(public_path("images/front/{$old_image}"));
                  }else{
                       echo ('No File Does not exist Here');
                       }

           /*  Unlink from the Original Folder */
                
                 if (\File::exists(public_path("/images/front/original/{$old_image}") ) )
                  {

                     \File::delete(public_path("/images/front/original/{$old_image}"));
              
                  }else{
                         echo ('No File Does not exist Here');
                        }

           
                $data = getimagesize($request->file_banner_img);

                      if ($request->input('dd_banner_size') and $request->input('dd_banner_size')!='') 
                      {
                         $size=$request->input('dd_banner_size');
                         $res=$this->imagesize_repo->getById($size);

                              $width=$res[0]->m76_width;
                              $height=$res[0]->m76_height;

                        if ($data[0]>=$width and $data[1]>=$height) 
                             {
                              
                                    $image = $request->file('file_banner_img');
                                    $time = date("d-m-Y")."-".time() ;
                                    $image_name = $image->getClientOriginalName();
                                    $imageName = $time.'.'.$image->getClientOriginalExtension();
                                    $destinationPath = public_path('/images/front/');
                                    $img1 = \Image::make($image->getRealPath())->resize($width, $height);
                                    $img1->save($destinationPath.'/'.$imageName); 

                                    $destinationPath = public_path('/images/front/original');  
                                    $image->move($destinationPath, $imageName);  
                                               
        
                            }else{
                               return redirect('banner_images')->with('error','Please Upload a Valid Image which width and height must be equal or greater then Banner size');
                             }
                      }else{

                         $image = $request->file('file_banner_img');
                         $time = date("d-m-Y")."-".time() ;
                         $image_name = $image->getClientOriginalName();
                         $imageName = $time.'.'.$image->getClientOriginalExtension();
                         $destinationPath = public_path('/images/front/');
                         $image->move($destinationPath, $imageName);
 
                      }
                

        }else{
            $imageName = $res;
             }


           $data=[
            'm47_banner_name'=>$request->input('txt_banner_name'),
            'm47_banner_var'=>"1",
            'm47_banner_type'=>$request->input('dd_banner_type'),
            'm36_category'=>$request->input('dd_banner_category'),
            'm47_banner_for'=>$request->input('dd_banner_for'),
            'm47_banner_desc'=>$request->input('txt_banner_desc'),
            'm47_banner_meta'=>$request->input('txt_banner_meta'),
            'm47_banner_img'=> $imageName,
            'm47_banner_status'=>$request->input('dd_banner_status'),
              ];

            $banner_update = $this->banner_repo->update($id,$data);



            $request->session()->flash('banner_msg','Updation successfull.');
            $request->session()->flash('type','success');

            return redirect('banner_images');
    }



       public function banner_status_change($id)
    {
         $single_banner =$this->banner_repo->active($id);
         return redirect('banner_images');
    }




}