<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\Campaign\CampaignRepository;
use App\Repositories\Enroll\EnrollRepository;
use App\Repositories\Employee\EmployeeRepository;
use DB;
use Session;
use Helper;
use Image;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;

class LogController extends Controller
{

	private $Campaign_repo;
	private $Enroll_repo;
	private $Employee_repo;

	public function __construct(CampaignRepository $Campaign_repo, EnrollRepository $Enroll_repo, EmployeeRepository $Employee_repo)
    {
    	$this->Campaign_repo = $Campaign_repo;
    	$this->Enroll_repo = $Enroll_repo;
    	$this->Employee_repo = $Employee_repo;
    }


    /**
        * Method name   : View Soft Login
        * @description  : Used for view soft login 
        * @param        : Request data  
        * @return       : return view
    */
	public function view_user_login_log(request $request)
    {
    	if($request->txt_memberid==''){ $uid = -1; }
    	else{ 
    			$user = Helper::get_userid($request->txt_memberid); 
    			if($user==false)
    			{
    				Session::flash('admin_msg','Member Id Not Found' );
					Session::flash('type','worning' );
    				return redirect('login_users_log');
    			}
    			else
    			{
    				$uid = $user;
    			}
    			 
    		} 
    		

        $admin_loginlog = Helper::get_login_log($uid);
    	return view('Log.view_user_login_log', compact('admin_loginlog'));
    }



        /**
        * Method name   : View Soft Login
        * @description  : Used for view soft login 
        * @param        : Request data  
        * @return       : return view
    */
	public function view_user_activity_log(request $request)
    {
    	if($request->txt_memberid=='')
    		{ 
    			$admin_loginlog = DB::select('SELECT * FROM activity_log WHERE USER_ID!=-1  ORDER BY ACT_ID DESC');
    		}
    	else
    	{ 
    		$admin_loginlog = DB::select("SELECT * FROM activity_log WHERE USER_CODE=".$request->txt_memberid." ORDER BY ACT_ID DESC");
    		 
    	} 
    		
    	return view('Log.view_user_activity_log', compact('admin_loginlog'));
    }


        /**
        * Method name   : View Active employee log
        * @description  : Used for view employee login 
        * @param        : Request data  
        * @return       : return view
    */
	public function view_employee_activity_log(request $request)
    {
    	if($request->txt_memberid=='')
    		{ 
    			$admin_loginlog = DB::select('SELECT * FROM activity_log WHERE USER_ID!=-1 ORDER BY ACT_ID DESC');
    		}
    	else
    	{ 
    		$admin_loginlog = DB::select("SELECT * FROM activity_log WHERE USER_CODE=".$request->txt_memberid." ORDER BY ACT_ID DESC");
    		 
    	} 
    		
    	return view('Log.view_user_activity_log', compact('admin_loginlog'));
    }



        
    /**
        * Method name   : View admin activity log
        * @description  : Used  admin activity log
        * @param        : Request data  
        * @return       : return view
    */
	public function activity_log(request $request)
    {
        $admin_loginlog = DB::select('SELECT * FROM activity_log WHERE USER_ID=-1 ORDER BY ACT_ID DESC');
    	return view('Log.view_activity_log', compact('admin_loginlog'));
    }



    /**
        * Method name   : View Soft Login
        * @description  : Used for view soft login 
        * @param        : Request data  
        * @return       : return view
    */
	public function view_sms_log(request $request)
    {
    	$uid = '';

    	if($request->txt_mobileno=='' && $request->txt_type =='')
    	{ 
    		$admin_loginlog = $this->Campaign_repo->getSMS();
    	}
    	elseif($request->txt_mobileno=='' && $request->txt_type !='')
    	{ 
    		$admin_loginlog = $this->Campaign_repo->getByTypeSMS($request->txt_type);
    	}
    	elseif($request->txt_mobileno !='' && $request->txt_type =='')
    	{ 
			$admin_loginlog = $this->Campaign_repo->getByPhoneSMS($request->txt_mobileno);
    	}
    	elseif($request->txt_mobileno !='' && $request->txt_type !='')
    	{ 
			$admin_loginlog = $this->Campaign_repo->getByTypePhoneSMS($request->txt_mobileno, $request->txt_type);
    	}
    	else
    	{ 	
    			Session::flash('admin_msg','Data Not Found' );
				Session::flash('type','worning' );
    			return redirect('view-sms-log'); 
    	} 

    	$users = $this->Enroll_repo->getAll();
		$emp = $this->Employee_repo->getAll();

    	return view('Log.view_sms_log', compact('admin_loginlog','users','emp'));
    }



    /**
        * Method name   : View email Login
        * @description  : Used for view email login 
        * @param        : Request data  
        * @return       : return view
    */
	public function view_email_log(request $request)
    {
    	$uid = '';

    	if($request->txt_memberid=='' && $request->txt_type =='')
    	{ 
    		$admin_loginlog = $this->Campaign_repo->getEmail();
    	}
    	elseif($request->txt_memberid=='' && $request->txt_type !='')
    	{ 
    		$admin_loginlog = $this->Campaign_repo->getByRolEmail($request->txt_type);
    	}
    	elseif($request->txt_memberid !='' && $request->txt_type =='')
    	{ 
    		    Session::flash('admin_msg','Member Id Not Found' );
				Session::flash('type','worning' );
    			return redirect('view-email-log');
    	}
    	else
    	{ 
    			if($request->txt_type == 'ADMIN' )
    			{
    		    	$user = -1; 
    			}
    			if($request->txt_type == 'USER' )
    			{
    		    	$user = Helper::get_userid($request->txt_memberid); 
    			}
    			elseif($request->txt_type == 'EMPLOYEE' )
    			{
    				$user = Helper::get_empid($request->txt_memberid); 
    			}
    			else
    			{
    				$user = false; 
    			}

    			if($user==false)
    			{
    				Session::flash('admin_msg','Member Id Not Found' );
					Session::flash('type','worning' );
    				return redirect('view-email-log');
    			}
    			else
    			{
    				$uid = $user;
    			}
    		$admin_loginlog = $this->Campaign_repo->getByUserEmail($uid, $request->txt_type); 	 
    	} 

    	$users = $this->Enroll_repo->getAll();
		$emp = $this->Employee_repo->getAll();
    		
    	return view('Log.view_email_log', compact('admin_loginlog','users','emp'));
    }




}