<?php

namespace App\Http\Controllers;

use App\Repositories\Master\Translation\TranslationRepository;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use App;
use Session;
use Helper;

class LocaleController extends Controller
{
    private $translation;

    public function __construct(TranslationRepository $translation)
    {
        $this->translation = $translation;
    }

	public function translation_en()
    {
        $locale = 'en';
        App::setLocale($locale);
        //storing the locale in session to get it back in the middleware
        session()->put('locale', $locale);
        $tr_auth = $this->translation->getByType($locale, 'auth');
        $tr_error = $this->translation->getByType($locale, 'error');
        $tr_front = $this->translation->getByType($locale, 'front');
        $tr_lang = $this->translation->getByType($locale, 'lang');
        $tr_menu = $this->translation->getByType($locale, 'menu');
        $tr_valid = $this->translation->getByType($locale, 'valid');
        return view('Translation.language_en', compact('tr_auth', 'tr_error', 'tr_front', 'tr_lang', 'tr_menu', 'tr_valid'));
    }

    public function translation_gu()
    {
        $locale = 'gu';
        App::setLocale($locale);
        //storing the locale in session to get it back in the middleware
        session()->put('locale', $locale);
        $tr_auth = $this->translation->getByType($locale, 'auth');
        $tr_error = $this->translation->getByType($locale, 'error');
        $tr_front = $this->translation->getByType($locale, 'front');
        $tr_lang = $this->translation->getByType($locale, 'lang');
        $tr_menu = $this->translation->getByType($locale, 'menu');
        $tr_valid = $this->translation->getByType($locale, 'valid');
        return view('Translation.language_gu', compact('tr_auth', 'tr_error', 'tr_front', 'tr_lang', 'tr_menu', 'tr_valid'));
    }

    public function translation_hi()
    {
        $locale = 'hi';
        App::setLocale($locale);
        //storing the locale in session to get it back in the middleware
        session()->put('locale', $locale);
        $tr_auth = $this->translation->getByType($locale, 'auth');
        $tr_error = $this->translation->getByType($locale, 'error');
        $tr_front = $this->translation->getByType($locale, 'front');
        $tr_lang = $this->translation->getByType($locale, 'lang');
        $tr_menu = $this->translation->getByType($locale, 'menu');
        $tr_valid = $this->translation->getByType($locale, 'valid');
        return view('Translation.language_hi', compact('tr_auth', 'tr_error', 'tr_front', 'tr_lang', 'tr_menu', 'tr_valid'));
    }

    public function translation_mr()
    {
        $locale = 'mr';
        App::setLocale($locale);
        //storing the locale in session to get it back in the middleware
        session()->put('locale', $locale);
        $tr_auth = $this->translation->getByType($locale, 'auth');
        $tr_error = $this->translation->getByType($locale, 'error');
        $tr_front = $this->translation->getByType($locale, 'front');
        $tr_lang = $this->translation->getByType($locale, 'lang');
        $tr_menu = $this->translation->getByType($locale, 'menu');
        $tr_valid = $this->translation->getByType($locale, 'valid');
        return view('Translation.language_mr', compact('tr_auth', 'tr_error', 'tr_front', 'tr_lang', 'tr_menu', 'tr_valid'));
    }

    public function translation_pu()
    {
        $locale = 'pu';
        App::setLocale($locale);
        //storing the locale in session to get it back in the middleware
        session()->put('locale', $locale);
        $tr_auth = $this->translation->getByType($locale, 'auth');
        $tr_error = $this->translation->getByType($locale, 'error');
        $tr_front = $this->translation->getByType($locale, 'front');
        $tr_lang = $this->translation->getByType($locale, 'lang');
        $tr_menu = $this->translation->getByType($locale, 'menu');
        $tr_valid = $this->translation->getByType($locale, 'valid');
        return view('Translation.language_pu', compact('tr_auth', 'tr_error', 'tr_front', 'tr_lang', 'tr_menu', 'tr_valid'));
    }

    public function translation_bg()
    {
        $locale = 'bg';
        App::setLocale($locale);
        //storing the locale in session to get it back in the middleware
        session()->put('locale', $locale);
        $tr_auth = $this->translation->getByType($locale, 'auth');
        $tr_error = $this->translation->getByType($locale, 'error');
        $tr_front = $this->translation->getByType($locale, 'front');
        $tr_lang = $this->translation->getByType($locale, 'lang');
        $tr_menu = $this->translation->getByType($locale, 'menu');
        $tr_valid = $this->translation->getByType($locale, 'valid');
        return view('Translation.language_bg', compact('tr_auth', 'tr_error', 'tr_front', 'tr_lang', 'tr_menu', 'tr_valid'));
    }

    public function add_translation()
    {
        $request = request();
        $already_entered =  $this->translation->getByName($request->input('txt_for'));

        if(count($already_entered) == 0){
            $arr = array(
                'm48_translated_lang' => $request->input('_current_lang'),
                'm48_translated_for' => $request->input('txt_for'),
                'm48_translated_text' => utf8_encode($request->input('txt_text')),
                'm48_translated_type' => $request->input('txt_type'),
                'm48_created_at' => date('Y-m-d H:i:s'),
                'm48_updated_at' => date('Y-m-d H:i:s')
            );
            $this->translation->create($arr);
            $del_val = $request->input('_current_lang');
            $locales = array("en", "gu", "hi", "mr", "pu", "tm", "bg");
            if (($key = array_search($del_val, $locales)) !== false) {
                unset($locales[$key]);
            }
            foreach($locales as $lc){
                $arr2 = array(
                    'm48_translated_lang' => $lc,
                    'm48_translated_for' => $request->input('txt_for'),
                    'm48_translated_text' => '',
                    'm48_translated_type' => $request->input('txt_type'),
                    'm48_created_at' => date('Y-m-d H:i:s'),
                    'm48_updated_at' => date('Y-m-d H:i:s')
                );
                $this->translation->create($arr2);
            }  
        }   
        return redirect('translation_en');
    }

    public function edit_translation()
    {
        $request = request();
        //dd($request);
        $txt_id = $request->id;
        $trans_value = $this->translation->getById($txt_id);  
        return $trans_value;
    }

    public function update_translation()
    {
        $request = request();
        //dd($request);
        $txt_id = $request->id;
        $txt = $request->txt_val;
        $text_for = $request->text_for;
        $single_trans = $this->translation->getById($txt_id); 
        $arr = array(
            'm48_translated_for' => $text_for
        );
        $this->translation->update_transfor($single_trans[0]->TRANS_FOR, $arr); 
        if($txt){
            $arr1 = array(
                'm48_translated_text' => $txt
            ); 
            $this->translation->update($txt_id, $arr1);  
        }
        return redirect('translation_en');
    }
}
