<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\Fund\FundRepository;
use DB;
use Image;
use Session;
use Helper;

class FundController extends Controller
{
	private $fund_repo;

	public function __construct(FundRepository $fund_repo)
	{
		$this->fund_repo = $fund_repo;
	}

	/**
        * Method name   : Fund Request
        * @description  : Used for getting all fund request
        * @param        : Request data  
        * @return       : return with all fund request
    */
    public function fund_request()
    {
		$page = "";
		$form_name = "";
		$fund_req_toadmin = $this->fund_repo->getByAdminId(0);
    	return view('Fund.fund_request', compact('page', 'form_name','fund_req_toadmin'));
    }





    /**
        * Method name   : cash collocation
        * @description  : Used for cash collocation
        * @param        : Request data  
        * @return       : return with fund transfer response
    */
    public function cash_collocation()
    {
		$page = "";
		$form_name = "";
		$request = request();
		$ERRMSG = "";
		$isError = FALSE;
		$ERRCODE="warning";
		$transfer="";
			if(request()->method() == 'POST')
			{
				$user = Helper::get_userid($request->input('txt_mobileno'));

			/*	if($request->input('ladger')=="")
				{
					$ERRMSG = "Ledger should be valid.Please Select Ledger Type ";
					$isError = TRUE;
					$ERRCODE="warning";
				} */
				if($request->input('idstype')=="")
				{
					$ERRMSG = "ID  Type should be valid.Please Select ID  Type ";
					$isError = TRUE;
					$ERRCODE="warning";
				}		
				else if($request->input('baltype')=="")
				{
					$ERRMSG = "Balance type should be valid.Please Select Balance Type ";
					$isError = TRUE;
					$ERRCODE="warning";
				}	
				else if($request->input('idstype') == 2 && $request->input('txt_mobileno')=='')
				{
						$ERRMSG = "Member contact number should be valid or not blank.";
						$isError = TRUE;
						$ERRCODE="warning";
				}
				else if($request->input('idstype') == 2 && !Helper::_valid_phone_number($request->input('txt_mobileno')))
				{
						$ERRMSG = "";
						$isError = TRUE;
				}
			   else if($request->input('idstype') == 2 && strlen($request->input('txt_mobileno'))!=10)
			   {
					  $ERRMSG = "Member contact number should be equal to 10 digit.";
					  $isError = TRUE;
					  $ERRCODE="warning";
				}
				else if($request->input('idstype') == 1 && $request->input('txt_memberid')=='')
				{
								$ERRMSG = "Member id should be valid or not blank.";
								$isError = TRUE;
								$ERRCODE="warning";
				}
				
				else if(floatval($request->input('txt_cashcolledted'))=='' || floatval($request->input('txt_cashcolledted'))==0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
					$isError = TRUE;
					$ERRCODE="warning";
				}				
				else if(floatval($request->input('txt_cashcolledted'))< config('MIN_FUN_TRANSFER'))
				{
					$ERRMSG = "Amount should be greater than ".config('MIN_FUN_TRANSFER')." or not be negative.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_cashcolledted')) > config('MAX_FUND_TRANSFER'))
				{
					$ERRMSG = "Amount should be less than ".config('MAX_FUND_TRANSFER')." or not be negative.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "XCDFF";
					$isError=FALSE;
					$ERRCODE="success";
					if($request->input('idstype') == 2)
					{
						$user = Helper::get_userid_by_mobile($request->input('txt_mobileno'));
						$user_data = Helper::get_userdetail($user);
					}
					if($request->input('idstype') == 1)
					{
						$user = Helper::get_userid($request->input('txt_memberid'));
						$user_data = Helper::get_userdetail($user);
					}
					 if(empty($user))
					{
						$ERRMSG = "Member should be valid";
						$isError = TRUE;
						$ERRCODE="warning";
					}
					else if(Session::get('USER_ID')==$user)
					{
						$ERRMSG = "Same account has not been transferable.";
						$isError = TRUE;
						$ERRCODE="warning";
					}
				}

				if(request()->method() == 'POST' && $isError==FALSE)
				{
					$transfer="TRANSFER";
					$type= 6;
					if($request->input('ladger')==2)
					{
					$transfer="TRANSFER";
					$type= 6;
					$se = 'Received';
					}
					if($request->input('ladger')==4)
					{
					$transfer="DEDUCT";
					$se = 'Deduct';
					$type= 7;
					}

					$trid = date('dmYhhiss').rand(100,999);
					$DataArray = [
											"tr41_cc_uid" => $user,
											"tr41_cc_transfer_id" => 0,
											"tr41_cc_transaid" => $trid,
											"tr41_cc_credit_amt" => $request->input('txt_cashcolledted'),
											"tr41_collected_remrk" => $request->input('txt_ccremark'),
											"tr41_wall_type" => $request->input('baltype')
										];
			
					DB::table('tr41_cash_collection')->insert($DataArray);		
				
					$ERRMSGS="Amount Of Rs ".floatval($request->input('txt_cashcolledted'))." Cash Collected Successfully With Txn ID, Transaction id-". $trid ;
					$ERRMSG="Amount Of Rs ".floatval($request->input('txt_cashcolledted'))." Cash Collected Successfully With Txn ID, Transaction id-". $trid ;
					//$ERRMSG="Amount ".floatval($request->input('txt_amount'))." ".$transfer. " to ".$request->input('txt_mobileno').", Transaction id-". $ERRMSG[0]->ERR_MSG ." .";
					$ERRCODE='success';
				    $FT_data1=Helper::notify_data($request,1,"FUND".$transfer." BY ADMIN",$ERRMSGS,0,'2');

					if($ERRCODE == 'success')
					{
						// SMS SEND OR INSERT
						$sms_data['MOBILE_NO'] = $user_data[0]->MemberContactNo;
						$sms_data['SUBJECT'] = 'Fund '.$transfer.' ';
						$sms_data['MESSAGE'] = $ERRMSGS;
						$sms_data['TYPE'] = $type;
						$sms_data['SEND_BY'] = 1;
						$sms_data['SEND_BY_ID'] = Session()->get('USER_ID');
						Helper::send_sms_or_log($sms_data);
						//SMS SEND END 

						Session::flash('message',$ERRMSG);
						Session::flash('type',$ERRCODE);
						return redirect('cash_collection');
					}

				}
					Session::flash('message',$ERRMSG);
					Session::flash('type',$ERRCODE);
			}
			$fund_t	= DB::table('cash_collection')->get();	
    	return view('Fund.cash_collocation', compact('page', 'form_name','fund_t'));
    }



    /**
        * Method name   : Fund Transfer
        * @description  : Used for fund transfer
        * @param        : Request data  
        * @return       : return with fund transfer response
    */
    public function fund_transfer()
    {
		$page = "";
		$form_name = "";
		$request = request();
		$ERRMSG = "";
		$isError = FALSE;
		$ERRCODE="warning";
		$transfer="";
			if(request()->method() == 'POST')
			{
				$user = Helper::get_userid($request->input('txt_mobileno'));

				if($request->input('ladger')=="")
				{
					$ERRMSG = "Ledger should be valid.Please Select Ledger Type ";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('idstype')=="")
				{
					$ERRMSG = "ID  Type should be valid.Please Select ID  Type ";
					$isError = TRUE;
					$ERRCODE="warning";
				}		
				else if($request->input('baltype')=="")
				{
					$ERRMSG = "Balance type should be valid.Please Select Balance Type ";
					$isError = TRUE;
					$ERRCODE="warning";
				}	
				else if($request->input('idstype') == 2 && $request->input('txt_mobileno')=='')
				{
						$ERRMSG = "Member contact number should be valid or not blank.";
						$isError = TRUE;
						$ERRCODE="warning";
				}
				else if($request->input('idstype') == 2 && !Helper::_valid_phone_number($request->input('txt_mobileno')))
				{
						$ERRMSG = "";
						$isError = TRUE;
				}
			   else if($request->input('idstype') == 2 && strlen($request->input('txt_mobileno'))!=10)
			   {
					  $ERRMSG = "Member contact number should be equal to 10 digit.";
					  $isError = TRUE;
					  $ERRCODE="warning";
				}
				else if($request->input('idstype') == 1 && $request->input('txt_memberid')=='')
				{
								$ERRMSG = "Member id should be valid or not blank.";
								$isError = TRUE;
								$ERRCODE="warning";
				}
				
				else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
					$isError = TRUE;
					$ERRCODE="warning";
				}				
				else if(floatval($request->input('txt_amount'))< config('MIN_FUN_TRANSFER'))
				{
					$ERRMSG = "Amount should be greater than ".config('MIN_FUN_TRANSFER')." or not be negative.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount')) > config('MAX_FUND_TRANSFER'))
				{
					$ERRMSG = "Amount should be less than ".config('MAX_FUND_TRANSFER')." or not be negative.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "XCDFF";
					$isError=FALSE;
					$ERRCODE="success";
					if($request->input('idstype') == 2)
					{
						$user = Helper::get_userid_by_mobile($request->input('txt_mobileno'));
						$user_data = Helper::get_userdetail($user);
					}
					if($request->input('idstype') == 1)
					{
						$user = Helper::get_userid($request->input('txt_memberid'));
						$user_data = Helper::get_userdetail($user);
					}
					 if(empty($user))
					{
						$ERRMSG = "Member should be valid";
						$isError = TRUE;
						$ERRCODE="warning";
					}
					else if(Session::get('USER_ID')==$user)
					{
						$ERRMSG = "Same account has not been transferable.";
						$isError = TRUE;
						$ERRCODE="warning";
					}
				}
				if(request()->method() == 'POST' && $isError==FALSE)
				{
					if($request->input('ladger')==2)
					{
					$transfer="TRANSFER";
					$type= 6;
					$se = 'Received';
					}
					if($request->input('ladger')==4)
					{
					$transfer="DEDUCT";
					$se = 'Deduct';
					$type= 7;
					}

					$fundtransfer_data=array(
					'proc'=>$request->input('ladger'),
					'to_user_id'=>$user,
					'from_user_id'=>0,
					'amount'=>floatval($request->input('txt_amount')),
					'collected_amount'=>floatval($request->input('txt_cashcolledted')),
					'requesttype'=>1,
					'balfor'=>$request->input('baltype'),
					'transtype'=>1,
					'timelimit'=>(config('FUND_INTERVAL')*60),
					'defaultstatus'=>1,
					'remark'=>$request->input('txt_remark'),
					'collected_remark'=>$request->input('txt_ccremark')
					);

					
					$fundtransfer = $this->fund_repo->walletTransfer($fundtransfer_data);
					$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
					$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
					$ERRMSGS="Dear ".$user_data[0]->MemberName."  You Have ".$se." Amount Of Rs ".floatval($request->input('txt_amount'))." From Sender  ".Session::get('NAME'). " With Txn ID , Transaction id-". $ERRMSG[0]->ERR_MSG ." ";
					$ERRMSG="Amount ".floatval($request->input('txt_amount'))." ".$transfer. " to ".$request->input('txt_mobileno').", Transaction id-". $ERRMSG[0]->ERR_MSG ." .";
					$ERRCODE=$ERRCODE[0]->ERR_CODE;
				   // $FT_data1=Helper::notify_data($request,1,"FUND".$transfer." BY ADMIN",$ERRMSG,0,'2');

					if($ERRCODE == 'success')
					{
						// SMS SEND OR INSERT
						$sms_data['MOBILE_NO'] = $user_data[0]->MemberContactNo;
						$sms_data['SUBJECT'] = 'Fund '.$transfer.' ';
						$sms_data['MESSAGE'] = $ERRMSGS;
						$sms_data['TYPE'] = $type;
						$sms_data['SEND_BY'] = 1;
						$sms_data['SEND_BY_ID'] = Session()->get('USER_ID');
						//Helper::send_sms_or_log($sms_data);
						//SMS SEND END 
					}

				}
					Session::flash('message',$ERRMSG);
					Session::flash('type',$ERRCODE);
			}
			$fund_t	= $this->fund_repo->GetTransferById(0); 
    	return view('Fund.fund_transfer', compact('page', 'form_name','fund_t'));
    }

    /**
        * Method name   : Fund Transfer to store
        * @description  : Used for fund transfer to store
        * @param        : Request data  
        * @return       : return with fund transfer response
    */
    public function fund_transfer_store()
    {
		$page = "";
		$form_name = "";
		$request = request();
		$isError = FALSE;
		$transfer="";
			if(request()->method() == 'POST')
			{
				if($request->input('ladger')=="")
				{
					$ERRMSG = "Ledger should be valid.Please Select Ledger Type ";
					$isError = TRUE;
					$ERRCODE="warning";
				}	
				else if($request->input('baltype')=="")
				{
					$ERRMSG = "Balance type should be valid.Please Select Balance Type ";
					$isError = TRUE;
					$ERRCODE="warning";
				}	
				else if($request->input('txt_referralcode')=='')
				{
					$ERRMSG = "Member contact number should be valid or not blank.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				/*else if(!_valid_phone_number($request->input('txt_mobileno')))
				{
					$ERRMSG = "";
					$isError = TRUE;
				}*/
				$contactno=$request->input('txt_referralcode');
				//dd($contactno[0]);
				
				$store_id = Helper::get_storeid($contactno);
				if(empty($store_id))
				{
					$ERRMSG = "Member should be valid";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if(Session::get('USER_ID')==$store_id)
				{
					$ERRMSG = "Same account has not been transferable.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))<0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be negative.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				if(request()->method() == 'POST'&& $isError==FALSE)
				{
					if($request->input('ladger')==2)
					$transfer="TRANSFER";
					if($request->input('ladger')==4)
					$transfer="DEDUCT";
					$fundtransfer_data=array(
					'proc'=>2,
					'to_user_id'=>$store_id,
					'from_user_id'=>0,
					'amount'=>floatval($request->input('txt_amount')),
					'collected_amount'=>floatval($request->input('txt_amount')),
					'requesttype'=>1,
					'balfor'=>1,
					'transtype'=>1,
					'timelimit'=>(config('FUND_INTERVAL')*60),
					'defaultstatus'=>1,
					'remark'=>$request->input('txt_remark'),
					'collected_remark'=>$request->input('txt_remark')
					);
					$fundtransfer = $this->fund_repo->storeWalletTransfer($fundtransfer_data);
					$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
					$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
					$ERRMSG="Amount ".floatval($request->input('txt_amount'))." ".$transfer. " to ".$contactno[0].", Transaction id-". $ERRMSG[0]->ERR_MSG ." .";
					$ERRCODE=$ERRCODE[0]->ERR_CODE;
				}
					Session::flash('message',$ERRMSG);
					Session::flash('type',$ERRCODE);
			}
	
    	return view('Fund.fund_transfer_store', compact('page', 'form_name'));
    }

    /**
        * Method name   : Main Ledger
        * @description  : Used for main ledger report
        * @param        : Request data  
        * @return       : return with main ledger report
    */
    public function main_ledger()
    {
        $page = "";
		$form_name = "";
		$request = request();
		$descrip="";
		$start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
		$txt_account = '';
		$txt_memberid = '';
		$txt_transid = '';
		$txt_noofrecords = '10000';
		$dd_ledgertype='-2';
		$cond="";
		$cond1=" 1 ";
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_datefrom')));
				$end = date('Y-m-d',strtotime($request->input('txt_dateto')));
				
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
				{
					$txt_transid=$request->input('txt_transid');
				}
				if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
					$txt_memberid = Helper::get_userid($request->input('txt_memberid'));
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_ledgertype')!="" && $request->input('dd_ledgertype')!=-1)
				{
					$dd_ledgertype=$request->input('dd_ledgertype');
				}
				
			}
			$cond=$cond.$cond1;
			$ledgerreport=array(
				'proc'=>2,
				'account'=>"0",
				'transid'=>$txt_transid,'userid'=>$txt_memberid,'fromdate'=>$start,
				'todate'=>$end,'noofrecords'=>$txt_noofrecords,'ledegerstatus'=>$dd_ledgertype,'descrip'=>$cond
            );
			$ledger_report = $this->fund_repo->ledgerReport($ledgerreport);
    	return view('Fund.main_ledger', compact('ledger_report','page', 'form_name'));
    }

    /**
        * Method name   : Fund Ledger
        * @description  : Used for fund ledger
        * @param        : Request data  
        * @return       : return with fund ledger report
    */
    public function fund_ledger()
    {
		$page = "";
		$form_name = "";
		$request = request();
		$descrip="";
		$start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
		$txt_account = '';$txt_memberid = '';$txt_transid = '';
		$txt_noofrecords = '100';$dd_ledgertype='-1';
		$cond="";
		$cond1="1 ";
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_from')));
				$end = date('Y-m-d',strtotime($request->input('txt_to')));
				
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
				{
					$txt_transid=$request->input('txt_transid');
				}
				if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
					$txt_memberid = Helper::get_userid($request->input('txt_memberid'));
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_ledgertype')!="" && $request->input('dd_ledgertype')!=-1)
				{
					$dd_ledgertype=$request->input('dd_ledgertype');
				}
			}
			$cond=$cond.$cond1;
			$ledgerreport=array(
				'proc'=>2,
				'account'=>"",
				'transid'=>$txt_transid,'userid'=>$txt_memberid,'fromdate'=>$start,'todate'=>$end,'noofrecords'=>$txt_noofrecords,'ledegerstatus'=>$dd_ledgertype,'descrip'=>$cond
            );
				$ledger_report=$this->fund_repo->ledgerReport($ledgerreport);
				return view('Fund.fund_ledger', compact('ledger_report','page', 'form_name'));
    }

    /**
        * Method name   : Payment Summary
        * @description  : Used for getting payment summary
        * @param        : Request data  
        * @return       : return with payment summary
    */
    public function payment_summary()
    {
		$page = "";
		$form_name = "";
        $request = request();
        $descrip="";
		$start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
		$txt_account = '';
		$txt_memberid = '';
		$txt_transid = '';
		$txt_noofrecords = '100';
		$dd_ledgertype='1';
		$cond="";
		$cond1="1";
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_from')));
				$end = date('Y-m-d',strtotime($request->input('txt_to')));
				
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
				{
					$txt_transid=$request->input('txt_transid');
				}
				if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
					$txt_memberid = Helper::get_userid($request->input('txt_memberid'));
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_ledgertype')!="" && $request->input('dd_ledgertype')!=-1)
				{
					$dd_ledgertype=$request->input('dd_ledgertype');
				}
				 
			}
			$cond=$cond.$cond1;
			$ledgerreport=array(
				'proc'=>2,'account'=>"",'transid'=>$txt_transid,'userid'=>$txt_memberid,'fromdate'=>$start,
				'todate'=>$end,'noofrecords'=>$txt_noofrecords,'ledegerstatus'=>$dd_ledgertype,'descrip'=>$cond
            );

            $ledger_report=$this->fund_repo->ledgerReport($ledgerreport);
    	return view('Fund.payment_summary', compact('ledger_report','page', 'form_name'));
    }


    public function payout_ledger()
    {
			$page = "";
			$form_name = "";
			$request = request();
			$descrip="";
			$start = '1970-01-01';$end ='1970-01-01';
			$txt_account = '';$txt_memberid = '';
			$txt_transid = '';$txt_noofrecords = '100';
			$dd_ledgertype='-3';$cond="";
			$cond1="1 AND `tr03_bal_type`=2 ";
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_from')));
				$end = date('Y-m-d',strtotime($request->input('txt_to')));
				
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
				{
					$txt_transid=$request->input('txt_transid');
				}
				if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
					$txt_memberid = Helper::get_userid($request->input('txt_memberid'));
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_ledgertype')!="" && $request->input('dd_ledgertype')!=-1)
				{
					$dd_ledgertype=$request->input('dd_ledgertype');
				}
				 
			}
			$cond=$cond.$cond1;
			$ledgerreport=array(
				'proc'=>2,'account'=>"",'transid'=>$txt_transid,'userid'=>$txt_memberid,'fromdate'=>$start,'todate'=>$end,'noofrecords'=>$txt_noofrecords,'ledegerstatus'=>$dd_ledgertype,'descrip'=>$cond
            );
			$ledger_report=$this->fund_repo->ledgerReport($ledgerreport);
    	return view('Fund.payout_ledger', compact('ledger_report','page', 'form_name'));
    }

    /**
        * Method name   : Fund Request Update Status
        * @description  : Used for updating fund request status
        * @param        : Request data  
        * @return       : return with updated fund request status
    */
    public function fundrequest_updatestatus()
	{
    	$request = request();
	    $ERRMSG='FUND TRANSFER HERE';
		$ERRCODE='info';
		$isError = FALSE;
		$transfer="";
			if(request()->method() == 'POST')
			{
				if($request->input('txt_mobileno')=='')
				{
					$ERRMSG = "Member contact number should be valid or not blank.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				/*else if(!_valid_phone_number($request->input('txt_mobileno')))
				{
					$ERRMSG = "";
					$isError = TRUE;
				}*/
				$contactno=explode(' ',$request->input('txt_mobileno'));
				//dd($contactno[0]);
				if(strlen($contactno[0])!=10)
				{
					$ERRMSG = "Member contact number should be equal to 10 digit.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				$user = Helper::get_userid($request->input('txt_membercode'));
				if(empty($user))
				{
					$ERRMSG = "Member should be valid";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if(Session::get('USER_ID')==$user)
				{
					$ERRMSG = "Same account has not been transferable.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))<0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be negative.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				if(request()->method() == 'POST'&& $isError==FALSE)
				{
					$fund_reqstatus=$request->input('txt_status');
					$transid="";
					if($fund_reqstatus=="APPROVED")
					{
						$fundtransfer_data=array(
						'proc'=>2,
						'to_user_id'=>$user,
						'from_user_id'=>0,
						'amount'=>floatval($request->input('txt_amount')),
						'collected_amount'=>floatval($request->input('txt_amount')),
						'requesttype'=>1,
						'balfor'=>$request->input('txt_baltype'),
						'transtype'=>1,
						'timelimit'=>(config('FUND_INTERVAL')*60),
						'defaultstatus'=>1,
						'remark'=>$request->input('txt_adminreply'),
						'collected_remark'=>$request->input('txt_adminreply')
						);
						$fundtransfer = $this->fund_repo->walletTransfer($fundtransfer_data);
						$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
						$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
						$transid=$ERRMSG[0]->ERR_MSG;
						$ERRMSGS="Fund Request Approved You Have Received Recharge Amount Of Rs ".floatval($request->input('txt_amount'))." From Sender  ".Session::get('NAME'). " With Txn ID , Transaction id-". $ERRMSG[0]->ERR_MSG ." ";
						$ERRMSG="Amount ".floatval($request->input('txt_amount'))." ".$transfer. " to ".$contactno[0].", Transaction id-". $ERRMSG[0]->ERR_MSG ." .";
						$ERRCODE=$ERRCODE[0]->ERR_CODE;

						if($ERRCODE == 'success')
						{
							// SMS SEND OR INSERT
							$sms_data['MOBILE_NO'] = $contactno[0];
							$sms_data['SUBJECT'] = 'Admin Fund Approved';
							$sms_data['MESSAGE'] = $ERRMSGS;
							$sms_data['TYPE'] = 8;
							$sms_data['SEND_BY'] = 1;
							$sms_data['SEND_BY_ID'] = Session()->get('USER_ID');
							Helper::send_sms_or_log($sms_data);
							//SMS SEND END 
						}

					}
					if($fund_reqstatus=="CANCELED")
					{
						$ERRCODE="success";
						$ERRMSG="USERS FUND REQUEST HAS BEEN ". $fund_reqstatus." SUCCESSFULLY!";
						$ERRMSGS="Fund Request Canceled ";

						if($ERRCODE == 'success')
							{
								// SMS SEND OR INSERT
								$sms_data['MOBILE_NO'] = $contactno[0];
								$sms_data['SUBJECT'] = 'Admin Fund Request Canceled';
								$sms_data['MESSAGE'] = $ERRMSGS;
								$sms_data['TYPE'] = 15;
								$sms_data['SEND_BY'] = 1;
								$sms_data['SEND_BY_ID'] = Session()->get('USER_ID');
								Helper::send_sms_or_log($sms_data);
								//SMS SEND END 
							}

					}
					$REQID=$request->input('txt_fundrequestid');
					$user_group=DB::select("UPDATE `tr01_fund_req` SET `tr01_fr_transid`= '".$transid."',`tr01_fr_status`= '".$request->input('txt_status')."',`tr01_fr_admin_res` ='".$request->input('txt_adminreply')."' WHERE `tr01_fr_id` ='".$request->input('txt_fundrequestid')."' AND `m11_user_id`=".$user."");
					
					$group_actionrecord=DB::select("INSERT INTO tr11_actionrecord (tr11_ar_tblnm,tr11_ar_old_value,tr11_ar_new_value,tr11_ar_uid,tr11_ar_description) VALUES ('tr01_fund_req','PENDING-FUND REQUEEST ID $REQID','$fund_reqstatus-FUND REQUEEST ID $REQID','$user','USERS FUND REQUEST HAS BEEN $fund_reqstatus SUCCESSFULLY!')");
					
				}
			}
		Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);
		$fund_req_toadmin=$this->fund_repo->getByAdminId(0);
		return view('Fund.fund_request', compact('fund_req_toadmin'));
	}




    /**
        * Method name   : Payment geteway
        * @description  : Used for getting payment geteway
        * @param        : Request data  
        * @return       : return with payment geteway
    */
    public function gateway_request()
    {
        $request = request();
        $descrip="";
		$start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
		$txt_account = '';
		$txt_memberid = '';
		$txt_transid = '';
		$txt_noofrecords = '100';
		$dd_ledgertype='1';
		$trans="";
		$mem="";
      	$cond="";
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_from')));
				$end = date('Y-m-d',strtotime($request->input('txt_to')));
				
				if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
				{
					$txt_transid = $request->input('txt_transid');
					$trans  = " AND op_txnid = '".$request->input('txt_transid'). "'" ;
				}
				if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
					$mem  = " AND user_code = '".$request->input('txt_memberid'). "'";
					$txt_memberid= $request->input('txt_memberid');
				}
			}
				$cond=$mem.$trans." ORDER BY op_id DESC ";
			$payrecord = DB::select("SELECT * FROM `online_payment` WHERE (DATE_FORMAT(`op_createdat`,'%Y-%m-%d' ) BETWEEN '".$start ."' AND '".$end ."')". $cond) ;

    	return view('Fund.geteway_summary', compact('start','end', 'txt_memberid', 'txt_transid','payrecord'));
    }



	public function wdrequest_updatestatus()
	{
	$request = request();
	$page = 'FUND PANEL';
    $form_name = 'FUND REQUEST';
    Session::flash('message','FUND REQUEST HERE');
	Session::flash('type','info' );
	$ERRMSG='FUND TRANSFER HERE';
		$ERRCODE='info';
		$isError = FALSE;
		$transfer="";
		$queery ="";

			if(request()->method() == 'POST')
			{
			
				if($request->input('txt_regcode')=='')
				{
					$ERRMSG = "Member code should be valid or not blank.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_mobileno')=='')
				{
					$ERRMSG = "Member contact number should be valid or not blank.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				/*else if(!_valid_phone_number($request->input('txt_mobileno')))
				{
					$ERRMSG = "";
					$isError = TRUE;
				}*/
				//$contactno=explode(' ',$request->input('txt_mobileno'));
				//dd($contactno[0]);
				if(strlen($request->input('txt_mobileno'))!=10)
				{
					$ERRMSG = "Member contact number should be equal to 10 digit.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				$user = Helper::get_userid($request->input('txt_regcode'));
				if(empty($user))
				{
					$ERRMSG = "Member should be valid";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if(Session::get('USER_ID')==$user)
				{
					$ERRMSG = "Same account has not been transferable.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))<0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be negative.";
					$isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
				    $ERRMSG = "";
					$isError = FALSE;
					$ERRCODE="success";
				}
				if(request()->method() == 'POST' && $isError==FALSE)
				{
					$fund_reqstatus=$request->input('txt_status');
					$transid="";
					if($fund_reqstatus=="CANCELED")
					{
						$fundtransfer_data=array(
						'proc'=>2,
						'to_user_id'=>$user,
						'from_user_id'=>0,
						'amount'=>floatval($request->input('txt_amount')),
						'collected_amount'=>floatval($request->input('txt_amount')),
						'requesttype'=>1,
						'balfor'=>3,
						'transtype'=>1,
						'timelimit'=>900,
						'defaultstatus'=>1,
						'remark'=>$request->input('txt_adminreply'),
						'collected_remark'=>$request->input('txt_adminreply')
						);
						$fundtransfer = DB::SELECT('CALL wallettransfer(
						:proc, 
						:to_user_id,
						:from_user_id,
						:amount, 
						:collected_amount,
						:requesttype,
						:balfor,:transtype,
						:timelimit,
						:defaultstatus,
						:remark,
						:collected_remark,
						@status_code,
						@status_msg)'
						,$fundtransfer_data);
						$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
						$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
					    $transid=$ERRMSG[0]->ERR_MSG;
					    //dd($transid);
						$ERRMSG="Amount ".floatval($request->input('txt_amount'))." ".$transfer. " to ".$request->input('txt_regcode').", Transaction id-". $ERRMSG[0]->ERR_MSG ." .";
						$ERRCODE=$ERRCODE[0]->ERR_CODE;
					}
					if($fund_reqstatus=="APPROVED")
					{
						$ERRCODE="success";
						$ERRMSG="USERS FUND REQUEST HAS BEEN ". $fund_reqstatus." SUCCESSFULLY!";
						if($request->input('txt_mode')==2 || $request->input('txt_mode')==3)
						{
							$balfor=1;
							if ($request->input('txt_mode')==2)
							{
							$balfor=1;
							}
							if ($request->input('txt_mode')==3)
							{
							$balfor=2;
							}
						$fundtransfer_data=array(
						'proc'=>2,
						'to_user_id'=>$user,
						'from_user_id'=>0,
						'amount'=>floatval($request->input('txt_amount')),
						'collected_amount'=>floatval($request->input('txt_amount')),
						'requesttype'=>1,
						'balfor'=>$balfor,
						'transtype'=>1,
						'timelimit'=>900,
						'defaultstatus'=>1,
						'remark'=>$request->input('txt_adminreply'),
						'collected_remark'=>$request->input('txt_adminreply')
						);
						//dd($fundtransfer_data);
						$fundtransfer = DB::SELECT('CALL wallettransfer(
						:proc, 
						:to_user_id,
						:from_user_id,
						:amount, 
						:collected_amount,
						:requesttype,
						:balfor,:transtype,
						:timelimit,
						:defaultstatus,
						:remark,
						:collected_remark,
						@status_code,
						@status_msg)'
						,$fundtransfer_data);
						$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
						$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
						$transid=$ERRMSG[0]->ERR_MSG;
						//dd($transid);
						$ERRMSG="Amount ".floatval($request->input('txt_amount'))." ".$transfer. " to ".$request->input('txt_regcode').", Transaction id-". $ERRMSG[0]->ERR_MSG ." .";
						$ERRCODE=$ERRCODE[0]->ERR_CODE;
						}
					}
					$REQID=$request->input('txt_fundrequestid');
					$user_group=DB::select("UPDATE `tr23_withdraw_req` SET `tr23_wr_transid`= '".$transid."',`tr23_wr_status`= '".$request->input('txt_status')."',`tr23_wr_admin_res` ='".$request->input('txt_adminreply')."' WHERE `tr23_wr_id` ='".$request->input('txt_fundrequestid')."' AND `m11_user_id`=".$user."");
					
					$group_actionrecord=DB::select("INSERT INTO tr11_actionrecord (tr11_ar_tblnm,tr11_ar_old_value,tr11_ar_new_value,tr11_ar_uid,tr11_ar_description) VALUES ('tr01_fund_req','PENDING-FUND REQUEEST ID $REQID','$fund_reqstatus-FUND REQUEEST ID $REQID','$user','USERS FUND REQUEST HAS BEEN $fund_reqstatus SUCCESSFULLY!')");
					
				}
				
			}
		//	dd("HELLO",$ERRMSG);
		Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);
		$queery = $queery." FUNDREQ_TO=1 ORDER BY FUNDREQ_ID DESC LIMIT 20";
		$withdraw_req_toadmin=DB::select("SELECT * FROM withdraw_request WHERE ".$queery);
		
    	return redirect('aeps_settelmentreport');
	}


}