<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use App\Repositories\Master\Banner\BannerRepository;
use App\Repositories\Master\Operator\OperatorRepository;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use App\Repositories\ProductModule\Categories\CategoriesRepository;
use App\Repositories\ProductModule\Brand\BrandRepository;
use App\Repositories\ProductModule\Products\ProductsRepository;
use App\Repositories\ProductModule\Optiongroup\OptiongroupRepository;
use App\Repositories\ProductModule\Unit\UnitRepository;
use App\Repositories\Affiliate\AffiliateRepository;
use App\Repositories\ProductModule\ParentCategories\ParentCategoriesRepository;
use App\Repositories\ProductModule\ProductVariant\ProductVariantRepository;
use App\Repositories\ProductModule\Market\MarketRepository;
use App\Repositories\ProductModule\OptionType\OptionTypeRepository;
use App\Repositories\ProductModule\UserOrders\UserOrdersRepository;
use App\Repositories\ProductModule\Wishlist\WishlistRepository;
use App\Repositories\ProductModule\UserAddress\UserAddressRepository;
use App\Repositories\Master\Content\ContentRepository;
use App\Repositories\Fund\FundRepository;
use ShipRocket;
use Cookie;
use Session;
use DB;
use Helper;
use Storage;

class FrontController extends Controller
{

	private $banner_repo;	
	private $cat_repo;
	private $brand_repo;
	private $prod_repo;
	private $optgrp_repo;
    private $unit_repo;
	private $Affiliate_repo;
	private $market_repo;
    private $parentcat_repo;
	private $prod_varnt;
    private $optype_repo;
    private $telecom_brand_repo;
	private $content_repo;
	private $address_repo;
	private $wishlist_repo;
	private $orders_repo;
	private $fund_repo;
	

	public function __construct(BannerRepository $banner_repo, CategoriesRepository $cat_repo, BrandRepository $brand_repo,
		ProductsRepository $prod_repo, OptiongroupRepository $optgrp_repo, 
        UnitRepository $unit_repo, AffiliateRepository $Affiliate_repo, MarketRepository $market_repo,
        ParentCategoriesRepository $parentcat_repo, ProductVariantRepository $prod_varnt,
         OptionTypeRepository $optype_repo, OperatorRepository $telecom_brand_repo, 
		ContentRepository $content_repo, UserAddressRepository $address_repo, WishlistRepository $wishlist_repo, UserOrdersRepository $orders_repo, FundRepository $fund_repo)
    {
        $this->banner_repo = $banner_repo;
        $this->cat_repo = $cat_repo;
		$this->brand_repo = $brand_repo;
		$this->prod_repo = $prod_repo;
		$this->optgrp_repo = $optgrp_repo;
        $this->unit_repo = $unit_repo;
		$this->Affiliate_repo = $Affiliate_repo;
		$this->market_repo = $market_repo;
        $this->parentcat_repo = $parentcat_repo;
		$this->prod_varnt = $prod_varnt;
        $this->optype_repo = $optype_repo;
        $this->telecom_brand_repo = $telecom_brand_repo;
    	$this->content_repo = $content_repo;
    	$this->address_repo = $address_repo;
		$this->wishlist_repo = $wishlist_repo;
		$this->orders_repo = $orders_repo;
		$this->fund_repo = $fund_repo;
    }
 
	public function show($command, $param)
    {
        $artisan = \Artisan::call($command.":".$param);
        $output = \Artisan::output();
        return $output;
    }


    

    public function get_coupan_amount()
    {	
    	$USERCOUPAN = 0;
    	if(Session::get('USER_ID'))
		{	
			$user = Helper::get_userdetail(Session::get('USER_ID'));

			$topup = DB::select("SELECT * FROM tr19_user_topup WHERE m11_user_id =".Session::get('USER_ID')." ORDER BY tr19_user_tpid LIMIT 1");

			if(count($topup) > 0 && count($user) > 0)
			{
				$coupanamt = DB::table('m27_package')->where('m27_pack_id', $topup[0]->m27_pack_id)->first();
				
				if($coupanamt != '')
				{

					$topupusethisamt=(float)$coupanamt->m27_coupan_amt/(float)config('TOPUP_DIVIDE_INMONTH');

					$to = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', $topup[0]->tr19_topup_createdat);
					$from = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', date('Y-m-d h:i:s'));
					$diff_in_months = $to->diffInMonths($from);

					if(config('TOPUP_AMO_DED') == 'YES')
					{
						$diff_in_months = 1;
						if($diff_in_months > $topup[0]->tr19_coupan_noofuse)
						{
							$dedamt = ($diff_in_months-$topup[0]->tr19_coupan_noofuse)*$topupusethisamt;
							$useamt = $topup[0]->tr19_coupan_useamt+$dedamt;
							$noofuse = $topup[0]->tr19_coupan_noofuse+($diff_in_months-$topup[0]->tr19_coupan_noofuse);

							//DB::update("UPDATE `tr19_user_topup` SET `tr19_coupan_useamt` = ".$useamt.", `tr19_coupan_noofuse` = ".$noofuse." WHERE `tr19_user_tpid` = ".$topup[0]->tr19_user_tpid);
						}
					}

					if(config('TOPUP_AMO_USER_INDAY') >=  date('d'))
					{	

						$user = Helper::get_userdetail(Session::get('USER_ID'));

		/*				$usercoupanamt = DB::select("SELECT COALESCE(SUM(tr03_dramount),0) AS AMT FROM `tr03_manage_ledger` WHERE m11_user_id = ".Session::get('USER_ID')." AND tr03_bal_type = 'COUPAN' AND tr03_ledger_type = 'COUPAN REDEEM' AND DATE_FORMAT(tr03_trans_onadd,'%Y-%m') = DATE_FORMAT(NOW(),'%Y-%m')"); */

						$usercoupanamt = DB::select("SELECT COALESCE(SUM(tr03_cramount)-SUM(tr03_dramount),0) AS AMT FROM `tr03_manage_ledger` WHERE m11_user_id = ".Session::get('USER_ID')." AND tr03_bal_type = 'COUPAN' AND tr03_ledger_type IN(25,23) AND DATE_FORMAT(tr03_trans_onadd,'%Y-%m') = DATE_FORMAT(NOW(),'%Y-%m')"); 

                        $total_usercoupanamt = DB::select("SELECT COALESCE(SUM(tr03_cramount)-SUM(tr03_dramount),0) AS AMT FROM `tr03_manage_ledger` WHERE m11_user_id = ".Session::get('USER_ID')." AND tr03_bal_type = 'COUPAN' AND tr03_ledger_type IN(25,23)"); 


                       	if((float)$total_usercoupanamt[0]->AMT > (float)$coupanamt->m27_coupan_amt)
                        {
                            $USERCOUPAN = 0;
                        }
                        else 
                        {
                            $USERCOUPAN = $topupusethisamt-(float)$usercoupanamt[0]->AMT;
                        }


						$USERCOUPAN = $topupusethisamt-(float)$usercoupanamt[0]->AMT;
					}
					else
					{
						$USERCOUPAN = 0;
					} 
				}
			}
		}

		return $USERCOUPAN;
    }

    public function index()
    {
		$user =''; 
		$banners = [];//$this->banner_repo->getByType(2);
		$offerbanner=  [];//$this->banner_repo->getByType(8);
		$catbanner=  [];//$this->banner_repo->getByType(1);
		$popup=  [];//$this->banner_repo->getByType(6);
		$parentcat =  [];//$this->parentcat_repo->getAllActive(); // parent category
		$categories =  [];//$this->cat_repo->getAllCategoryActive(); //category
		$subcategories =  [];//$this->cat_repo->getAllSubCategoryActive(); //sub category
		//$randcat  = $this->cat_repo->getAllCategoryActiveRand();//Random 3 category
		$operator =  [];//$this->telecom_brand_repo->getByServiceId(1);
		$products = [];// $this->prod_repo->getEightActive();
	
	/*	if(!empty($randcat[0])){ $product[0] = $this->prod_repo->getByCatParentId($randcat[0]->CAT_ID); }
		else {  $product[0] = []; }
		if(!empty($randcat[1])){  $product[1] = $this->prod_repo->getByCatParentId($randcat[1]->CAT_ID); }
		else {$product[1] = [];}
		if(!empty($randcat[2])){   $product[2] = $this->prod_repo->getByCatParentId($randcat[2]->CAT_ID); }
		else {$product[2] = [];}
	*/

		$OPERATOR =  [];//Helper::get_operator(1,'ACTIVE');

		if(Session::get('USER_ID'))
		{	
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}


		$live_games = DB::select("SELECT * FROM live_runing_games WHERE STATUS = 'Running' ORDER BY ID DESC");

    	$games_data = DB::select("SELECT * FROM game_data WHERE STATUS = 'Active' LIMIT 3");

    	$old_game_one = [];//DB::select("SELECT *, get_total_game_amount(GAME_ID,ID) AS TOTAL_AMOUNT FROM live_runing_games WHERE STATUS = 'Closed' AND GAME_ID = 1 ORDER BY ID DESC LIMIT 10");
		$old_game_two = [];//DB::select("SELECT *, get_total_game_amount(GAME_ID,ID) AS TOTAL_AMOUNT FROM live_runing_games WHERE STATUS = 'Closed' AND GAME_ID = 2 ORDER BY ID DESC LIMIT 10");
		$old_game_three = [];//DB::select("SELECT *, get_total_game_amount(GAME_ID,ID) AS TOTAL_AMOUNT FROM live_runing_games WHERE STATUS = 'Closed' AND GAME_ID = 3 ORDER BY ID DESC LIMIT 10");


    	$day_game_one = [];//DB::select("SELECT *, GROUP_CONCAT(WIN_LOTTERY_NO) As WIN_LOTTERY_NO, GROUP_CONCAT(DATE_FORMAT(CREATED_AT, '%h %p') ORDER BY ID ASC) AS GAME_TIME, get_total_game_amount(GAME_ID,ID) AS TOTAL_AMOUNT FROM live_runing_games WHERE STATUS = 'Closed' AND GAME_ID = 1 GROUP BY DATE_FORMAT(CREATED_AT, '%Y%m%d') ORDER BY ID DESC LIMIT 1");
		$day_game_two = [];//DB::select("SELECT *, GROUP_CONCAT(WIN_LOTTERY_NO) As WIN_LOTTERY_NO, GROUP_CONCAT(DATE_FORMAT(CREATED_AT, '%h %p') ORDER BY ID ASC) AS GAME_TIME, get_total_game_amount(GAME_ID,ID) AS TOTAL_AMOUNT FROM live_runing_games WHERE STATUS = 'Closed' AND GAME_ID = 2 GROUP BY DATE_FORMAT(CREATED_AT, '%Y%m%d') ORDER BY ID DESC LIMIT 1");
		$day_game_three = [];//DB::select("SELECT *, GROUP_CONCAT(WIN_LOTTERY_NO) As WIN_LOTTERY_NO, GROUP_CONCAT(DATE_FORMAT(CREATED_AT, '%h %p') ORDER BY ID ASC) AS GAME_TIME, get_total_game_amount(GAME_ID,ID) AS TOTAL_AMOUNT FROM live_runing_games WHERE STATUS = 'Closed' AND GAME_ID = 3 GROUP BY DATE_FORMAT(CREATED_AT, '%Y%m%d') ORDER BY ID DESC LIMIT 1");

		return view('Front/FRONT11/index',compact('banners','OPERATOR','user','parentcat','categories','subcategories','operator','catbanner','popup','products','offerbanner','live_games','games_data','old_game_one','old_game_two','old_game_three','day_game_one','day_game_two','day_game_three'));
		//return view('Front/index',compact('banners','OPERATOR','user','parentcat','categories','subcategories','operator','catbanner','popup','products','offerbanner'));
    }



    public function how_to_play(Request $request)
    {
    	$user = []; 

    	if(Session::get('USER_ID'))
		{	
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}

    	return view('Front/FRONT11/howtoplay',compact('user'));
    }


    public function live_purchase_lottery_data(Request $request)
    {
    	$user = []; 

    	if(Session::get('USER_ID'))
		{	
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}

    	$user_bet_data = DB::select("SELECT GAME_NAME,GAME_IMAGE,USER_NAME,GAME_CODE,LOTTERY_NUMBER FROM user_game_bet WHERE STATUS = 'Pending'");

		return [
			"status" => "success",
			"user_data" => $user,
			"user_bet_data" => $user_bet_data
		];
    }

    public function latest_winner(Request $request)
    {
    	$user = []; 
    	$formdate = $request->txt_from_date;
		$todate = $request->txt_to_date;
    	$form_date = $request->txt_fromdate;
		$to_date = $request->txt_todate;
		$form_type = $request->txt_form_type;

		if($form_type == ''){ $form_type = 1;}

		if($formdate == '') { $formdate = date('Y-m-d', strtotime("-7 day")); }
		if($todate == '') { $todate =  date('Y-m-d');; }
		if($form_date == '') { $form_date = date('Y-m-d', strtotime("-3 day")); }
		if($to_date == '') { $to_date =  date('Y-m-d'); }	


		$dt_game_one = DB::select("SELECT *, get_total_game_amount(GAME_ID,ID) AS TOTAL_AMOUNT FROM live_runing_games WHERE STATUS = 'Closed' AND GAME_STATUS = 'Active' AND GAME_ID = 1 AND DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d') between DATE_FORMAT('$form_date','%Y-%m-%d') AND  DATE_FORMAT('$to_date','%Y-%m-%d') ORDER BY ID DESC");
		$dt_game_two = DB::select("SELECT *, get_total_game_amount(GAME_ID,ID) AS TOTAL_AMOUNT FROM live_runing_games WHERE STATUS = 'Closed' AND GAME_STATUS = 'Active' AND GAME_ID = 2 AND DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d') between DATE_FORMAT('$form_date','%Y-%m-%d') AND  DATE_FORMAT('$to_date','%Y-%m-%d') ORDER BY ID DESC");
		$dt_game_three = DB::select("SELECT *, get_total_game_amount(GAME_ID,ID) AS TOTAL_AMOUNT FROM live_runing_games WHERE STATUS = 'Closed' AND GAME_STATUS = 'Active' AND GAME_ID = 3 AND DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d') between DATE_FORMAT('$form_date','%Y-%m-%d') AND  DATE_FORMAT('$to_date','%Y-%m-%d') ORDER BY ID DESC");



		$day_game_one = DB::select("SELECT *, GROUP_CONCAT(WIN_LOTTERY_NO) As WIN_LOTTERY_NO, GROUP_CONCAT(DATE_FORMAT(CREATED_AT, '%h %p') ORDER BY ID ASC) AS GAME_TIME, SUM(get_total_game_amount(GAME_ID,ID)) AS TOTAL_AMOUNT FROM live_runing_games WHERE STATUS = 'Closed' AND GAME_STATUS = 'Active' AND GAME_ID = 1 AND DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d') between DATE_FORMAT('$formdate','%Y-%m-%d') AND  DATE_FORMAT('$todate','%Y-%m-%d') GROUP BY DATE_FORMAT(CREATED_AT, '%Y%m%d') ORDER BY ID DESC");
		$day_game_two = DB::select("SELECT *, GROUP_CONCAT(WIN_LOTTERY_NO) As WIN_LOTTERY_NO, GROUP_CONCAT(DATE_FORMAT(CREATED_AT, '%h %p') ORDER BY ID ASC) AS GAME_TIME, SUM(get_total_game_amount(GAME_ID,ID)) AS TOTAL_AMOUNT FROM live_runing_games WHERE STATUS = 'Closed' AND GAME_STATUS = 'Active' AND GAME_ID = 2 AND DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d') between DATE_FORMAT('$formdate','%Y-%m-%d') AND  DATE_FORMAT('$todate','%Y-%m-%d') GROUP BY DATE_FORMAT(CREATED_AT, '%Y%m%d') ORDER BY ID DESC");
		$day_game_three = DB::select("SELECT *, GROUP_CONCAT(WIN_LOTTERY_NO) As WIN_LOTTERY_NO, GROUP_CONCAT(DATE_FORMAT(CREATED_AT, '%h %p') ORDER BY ID ASC) AS GAME_TIME, SUM(get_total_game_amount(GAME_ID,ID)) AS TOTAL_AMOUNT FROM live_runing_games WHERE STATUS = 'Closed' AND GAME_STATUS = 'Active' AND GAME_ID = 3 AND DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d') between DATE_FORMAT('$formdate','%Y-%m-%d') AND  DATE_FORMAT('$todate','%Y-%m-%d') GROUP BY DATE_FORMAT(CREATED_AT, '%Y%m%d') ORDER BY ID DESC");


    	if(Session::get('USER_ID'))
		{	
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}

    	return view('Front/FRONT11/latest-winner',compact('user','formdate','todate','form_date','to_date','day_game_one','day_game_two','day_game_three','dt_game_one','dt_game_two','dt_game_three','form_type'));
    }

    public function your_referral(Request $request)
    {
    	$user = []; 

    	if(Session::get('USER_ID'))
		{	
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}

    	return view('Front/FRONT11/referral',compact('user'));
    }


    public function games(Request $request)
    {
    	$user = []; 
    	$games_data = []; 

		$live_games = DB::select("SELECT * FROM live_runing_games WHERE STATUS = 'Running' ORDER BY ID DESC");
    	$games_data = DB::select("SELECT * FROM game_data WHERE STATUS = 'Active' LIMIT 3");
    	$spin_games_data = DB::select("SELECT * FROM spin_game_data WHERE STATUS = 'Active'");

    	if(Session::get('USER_ID'))
		{	
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}

    	return view('Front/FRONT11/all-games',compact('live_games','games_data','user','spin_games_data'));
    }


    public function playspingames($game_id)
    {
    	$user = []; 
    	$spin_game_data = []; 
    	$id = base64_decode($game_id);

    	$spin_game_data = DB::select("SELECT * FROM spin_game_data WHERE STATUS = 'Active' AND ID = $id LIMIT 1");

    	if(count($spin_game_data) == 0)
    	{
    		return back();
    	}

    	$spin_game_data = $spin_game_data[0];
    	$start_number = (int)$spin_game_data->START_NUMBER;
    	$end_number = (int)$spin_game_data->END_NUMBER;
    	$loose_number_add = (int)$spin_game_data->LOOSE_NUMBER_ADD;
    	$spin_data = [];

    	$color_code = ['#6c1ae6','#bd19e6','#e619e6','#e619bd','#e61994','#e6196b','#e61942','#e61919','#e6431b','#ee1c24','#e66b19','#e69419','#e6bd19','#e6e619','#bde619','#98e722','#6be619','#42e619','#1ae61a','#19e642','#19e694','#19e6bd','#19e6e6','#19bde6','#1a94e6','#196be6','#1942e6','#1919e6','#4219e6','#6b19e6','#6b19e6','#6c1ae6','#bd19e6','#e619e6','#e619bd','#e61994','#e6196b','#e61942','#e61919','#e6431b','#ee1c24','#e66b19','#e69419','#e6bd19','#e6e619','#bde619','#98e722','#6be619','#42e619','#1ae61a','#19e642','#19e694','#19e6bd','#19e6e6','#19bde6','#1a94e6','#196be6','#1942e6','#1919e6','#4219e6','#6b19e6','#6b19e6','#6c1ae6','#bd19e6','#e619e6','#e619bd','#e61994','#e6196b','#e61942','#e61919','#e6431b','#ee1c24','#e66b19','#e69419','#e6bd19','#e6e619','#bde619','#98e722','#6be619','#42e619','#1ae61a','#19e642','#19e694','#19e6bd','#19e6e6','#19bde6','#1a94e6','#196be6','#1942e6','#1919e6','#4219e6','#6b19e6','#6b19e6','#6c1ae6','#bd19e6','#e619e6','#e619bd','#e61994','#e6196b','#e61942','#e61919','#e6431b','#ee1c24','#e66b19','#e69419','#e6bd19','#e6e619','#bde619','#98e722','#6be619','#42e619','#1ae61a','#19e642','#19e694','#19e6bd','#19e6e6','#19bde6','#1a94e6','#196be6','#1942e6','#1919e6','#4219e6','#6b19e6','#6b19e6'];

    	$number_color_count = 1; 
    	for($i = $start_number; $i<=$end_number; $i++) 
    	{	
    		if(($i%$loose_number_add) == 0){
    			array_push($spin_data,['fillStyle' => $color_code[$number_color_count], 'text' => 'LOOSE']);
    			++$number_color_count;
    		}

    		array_push($spin_data,['fillStyle' => $color_code[$number_color_count], 'text' => (string)$i]);
    		++$number_color_count;
		}

		$all_spin_data = json_encode($spin_data);
		$spin_count = count($spin_data);

    	if(Session::get('USER_ID'))
		{	
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}

    	return view('Front/FRONT11/spin-game-page',compact('spin_game_data','user','id','all_spin_data','spin_count'));
    }




    public function playgames($game_id)
    {
    	$user = []; 
    	$games_data = []; 
    	$id = base64_decode($game_id);

    	if($id == "") { 
    		$gamesdata = DB::select("SELECT * FROM game_data WHERE STATUS = 'Active'");
    		if (count($gamesdata) > 0) {
    			$id = $gamesdata[0]->ID;
    		}
    	}


    	$live_games = DB::select("SELECT * FROM live_runing_games WHERE STATUS = 'Running' AND GAME_ID = $id ORDER BY ID DESC LIMIT 1");

    	if(count($live_games) == 0)
    	{
    		$live_games = DB::select("SELECT * FROM live_runing_games WHERE GAME_ID = $id ORDER BY ID DESC LIMIT 1");
    	}

    	if(count($live_games) > 0)
    	{
    		$games_data = DB::select("SELECT * FROM game_data WHERE ID = $id");

    		if($id != $live_games[0]->GAME_ID) {
    			return back(); 
    		}

    	}

    	if(Session::get('USER_ID'))
		{	
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}

    	return view('Front/FRONT11/game-page',compact('live_games','games_data','user','id'));
    }





    public function get_index_data(Request $request)
    {

    	$user_bet_data = [];

			$live_games = DB::select("SELECT * FROM live_runing_games WHERE STATUS = 'Running'");
			$old_game_one = DB::select("SELECT * FROM live_runing_games WHERE STATUS = 'Closed' AND GAME_ID = 1 ORDER BY ID DESC");
			$old_game_two = DB::select("SELECT * FROM live_runing_games WHERE STATUS = 'Closed' AND GAME_ID = 2 ORDER BY ID DESC");
			$old_game_three = DB::select("SELECT * FROM live_runing_games WHERE STATUS = 'Closed' AND GAME_ID = 3 ORDER BY ID DESC");

    		if(session()->get('USER_ID') != "")
	    	{
	    		$user_bet_data = DB::select("SELECT * FROM user_game_bet WHERE STATUS = 'Pending' AND USER_ID = ".session()->get('USER_ID')."");
	    	}
    	
    	return [
				"status" => "success",
				"live_games" => $live_games,
				"old_game_one" => $old_game_one,
				"old_game_two" => $old_game_two,
				"old_game_three" => $old_game_three,
				"user_bet_data" => $user_bet_data,
				];
  
    }



    public function get_all_game_data(Request $request)
    {

    	$games_data = "";
    	$live_games = "";
    	$user_bet_data = [];
    	$user = [];

    	if(Session::get('USER_ID'))
		{	
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}

    	if(isset($request->game_id) && $request->game_id != '')
    	{
    		$id = $request->game_id;
    		$live_games = DB::select("SELECT * FROM live_runing_games WHERE STATUS = 'Running' AND GAME_ID = $id ORDER BY ID DESC LIMIT 1");

    		if(count($live_games) == 0)
	    	{
	    		$live_games = DB::select("SELECT * FROM live_runing_games WHERE GAME_ID = $id ORDER BY ID DESC LIMIT 1");
	    	}

	    	if(count($live_games) > 0)
	    	{
	    		$games_data = DB::select("SELECT * FROM game_data WHERE ID = $id");

	    		if(session()->get('USER_ID') != "")
		    	{
		    		$user_bet_data = DB::select("SELECT * FROM user_game_bet WHERE STATUS = 'Pending' AND GAME_STATUS = 'Active' AND USER_ID = ".session()->get('USER_ID')."");
		    	}

	    	}
    	} 
    	
    	if(count($games_data) > 0 && count($live_games) > 0 ) 
    	{
    		return [
    				"status" => "success",
    				"games_data" => $games_data[0],
    				"live_games" => $live_games[0],
    				"user_bet_data" => $user_bet_data,
    				"user_data" => $user
    				];
    	}
    	else
    	{
	    return [
				"status" => "error",
				"games_data" => "",
				"live_games" => "",
				"user_bet_data" => "",
				"user_data" => "",
				];	
    	}
  
    }


    public function buy_lottery_ticket(Request $request)
    {	
    	$live_games = DB::select("SELECT * FROM live_runing_games WHERE STATUS = 'Running' AND GAME_ID = $request->txt_game_id ORDER BY ID DESC LIMIT 1");
    	$games_data = DB::select("SELECT * FROM game_data WHERE ID = ".$request->txt_game_id);

    	if($request->txt_lottery_number == '') {
    		return ["status" => "error", "msg" => "Please select lottery Number !"];	
    	} else if (session()->get('USER_ID') == '') {
    		return ["status" => "error", "msg" => "Please Login Your Acount !"];
    	}  else if ($request->txt_lottery_qty == '') {
    		return ["status" => "error", "msg" => "Please Enter lottery Quantity !"];
    	}   else if ($request->txt_refferal_bal == '') {
    		return ["status" => "error", "msg" => "refferal value is required!"];
    	} else if ($request->txt_lottery_amount == '') {
    		return ["status" => "error", "msg" => "Please Enter Bet Amount !"];
    	} else if ($request->txt_game_id == '') {
    		return ["status" => "error", "msg" => "Game Not Found !"];
    	} else if (count($live_games) == 0) {
    		return ["status" => "error", "msg" => "Game Not Found !"];
    	} else if (count($games_data) == 0) {
    		return ["status" => "error", "msg" => "Lottery Not Found !"];
    	}
    	else {

    		$user = Helper::get_userdetail(Session::get('USER_ID'));
			if(count($user) == 0) {
				return ["status" => "error", "msg" => "User Info Not Found!"];
			}

    		$total_amount = (int)$request->txt_lottery_qty * (float)$request->txt_lottery_amount;
    		$refferal_balance_use = (float)config("REFFERAL_BALANCE_USE");
    		$total_amount_reff = 0;

    		if($request->txt_refferal_bal == "YES" && $refferal_balance_use < $total_amount) {

    			$total_amount = (float)$total_amount-(float)$refferal_balance_use;
    			$total_amount_reff = $refferal_balance_use;

    			if((float)$user[0]->RECHARGE_BAL < (float)$total_amount) {
					return ["status" => "error", "msg" => "Main Balance is not Sufficient for this Request.Please Add Fund on Your Account."];
				}

				if((float)$user[0]->UTILITY_BAL < (float)$total_amount_reff) {
					return ["status" => "error", "msg" => "Refferal Balance is not Sufficient for this Request.Please Add Fund on Your Account."];
				}

    		} else {
	  			if((float)$user[0]->RECHARGE_BAL < (float)$total_amount) {
					return ["status" => "error", "msg" => "Main Balance is not Sufficient for this Request.Please Add Fund on Your Account."];
				}
    		}


	    	$user_bet_data = DB::select("SELECT * FROM user_game_bet WHERE LIVE_GAME_ID = ".$live_games[0]->ID." AND GAME_ID = ".$request->txt_game_id." AND LOTTERY_NUMBER = ".$request->txt_lottery_number."  AND USER_ID = ".session()->get('USER_ID')."");
		    
		    if(count($user_bet_data) > 0) {
		    	return ["status" => "error", "msg" => "This Lottery Number Already Purchased!"];	
		    }	


			// DEDUCT MAIN 
			$fundtransfer_data=array(
			'proc'=>7,
			'to_user_id'=>session()->get('USER_ID'),
			'from_user_id'=>0,
			'amount'=>$total_amount,
			'collected_amount'=>$total_amount, 
			'requesttype'=>1,
			'balfor'=>1,
			'transtype'=>28,
			'timelimit'=>100,
			'defaultstatus'=>1,
			'remark'=>"purchase ".$games_data[0]->NAME." lottery ",
			'collected_remark'=>"purchase ".$games_data[0]->NAME." lottery " 
			);

			$fundtransfer = $this->fund_repo->walletTransfer($fundtransfer_data);

			$DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
			$DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
			$ERRMSG=$DB_ERRMSG[0]->ERR_MSG;
			$ERRCODE=$DB_ERRCODE[0]->ERR_CODE;


			if($request->txt_refferal_bal == "YES" && $total_amount_reff > 0) 
			{
				// DEDUCT REFFRAL 
				$fundtransfer_datas=array(
				'proc'=>7,
				'to_user_id'=>session()->get('USER_ID'),
				'from_user_id'=>0,
				'amount'=>$total_amount_reff,
				'collected_amount'=>$total_amount_reff, 
				'requesttype'=>1,
				'balfor'=>2,
				'transtype'=>28,
				'timelimit'=>100,
				'defaultstatus'=>1,
				'remark'=>"purchase ".$games_data[0]->NAME." lottery ",
				'collected_remark'=>"purchase ".$games_data[0]->NAME." lottery " 
				);

				$fundtransfer = $this->fund_repo->walletTransfer($fundtransfer_datas);

				$DB_ERRMSGS=DB::select('SELECT @status_msg as ERR_MSG');
				$DB_ERRCODES=DB::select('SELECT @status_code as ERR_CODE');
				$ERRMSGS=$DB_ERRMSGS[0]->ERR_MSG;
				$ERRCODES=$DB_ERRCODES[0]->ERR_CODE;

				if($ERRCODES != "success" ) {
					return ["status" => "error", "msg" => "Refferal Balance is low!"];
				}
			}


			if($ERRCODE != "success" ) {
				return ["status" => "error", "msg" => $ERRMSG];
			}

			

    		$check = DB::table("tr48_user_game_bet")->insert([
    													"m81_game_id" => $request->txt_game_id,
    													"m11_user_id" => session()->get('USER_ID'),
    													"tr47_live_game_id" => $live_games[0]->ID,
    													"tr48_lottery_number" => $request->txt_lottery_number,
    													"tr48_lottery_quantity" => $request->txt_lottery_qty,
    													"tr48_lottery_amount" => $request->txt_lottery_amount,
    													"tr48_total_amount" => (int)$request->txt_lottery_qty * (float)$request->txt_lottery_amount,
    												]);

    		if($check) {
    				return ["status" => "success", "msg" => "Buy Lottery Successfully."];
    		} else {
    				return ["status" => "error", "msg" => "Lottery Not Buy."];
    		}

    	}
    }





    public function create_live_game(Request $request)
    {
    	date_default_timezone_set("Asia/Calcutta");

    	$data =  DB::table("game_data")->Where("STATUS", "Active")->get();

    			
    	if(count($data) > 0) {

    		$running_game = DB::table("tr47_live_runing_games")->where("tr47_status", "Running")->get();

    		if(count($running_game) > 0) {
    			foreach ($running_game as $key => $value) {
    				DB::table("tr47_live_runing_games")->where("tr47_id", $value->tr47_id)->update(["tr47_status" => "Closed"]);
    			}
    		}

    		//if(date("H") > 9 && date("H") < 20) {

    			foreach ($data as $key => $game_value) {
	    			DB::table("tr47_live_runing_games")->insert([
										"m81_code" => "CL".$game_value->ID.date("dmY").time(),
										"m81_game_id" => $game_value->ID,
										"m81_start_number" => $game_value->START_NUMBER,
										"m81_end_number" => $game_value->END_NUMBER,
										"tr47_game_start_time" => date("Y-m-d H:i:s"),
										"tr47_game_end_time" => date("Y-m-d H:i:s", strtotime("+1 hours")),
									]);
    			}

    			//self::dummy_game_play();
    		//}


    		//if(date("H") > 10 && date("H") < 21) {

	    		if(count($running_game) > 0) {

	    			$win_lottery_number = '';

	    			foreach ($running_game as $key => $value) {

	    					$usergamebet = DB::select("SELECT *, SUM(LOTTERY_QUANTITY) AS LOTTERY_QUANTITYS ,SUM(TOTAL_AMOUNT) AS TOTAL_AMOUNTS FROM user_game_bet WHERE GAME_ID = $value->m81_game_id AND LIVE_GAME_ID = $value->tr47_id GROUP BY LOTTERY_NUMBER ORDER BY LOTTERY_QUANTITYS ASC");

	    					if(count($usergamebet) > 0) {

	    						$bet_lottery_number = array_column($usergamebet, 'LOTTERY_NUMBER');
	    						$all_lottery_number = range($usergamebet[0]->START_NUMBER,$usergamebet[0]->END_NUMBER);

	    						$not_selected_lottery_number = array_diff(range($usergamebet[0]->START_NUMBER,$usergamebet[0]->END_NUMBER),$bet_lottery_number);

	    						if(count($not_selected_lottery_number) == 1) {

			    					$win_lottery_number = min($all_lottery_number,$bet_lottery_number);

	    						} else if(count($not_selected_lottery_number) > 1) {

	    							$old_running_game = DB::table("tr47_live_runing_games")->where("tr47_status", "Closed")->where("m81_game_id", $value->m81_game_id)->orderBy("tr47_id","desc")->skip(1)->first();
	    						
			    					if($old_running_game) {

			    						$win_lottery_number = min(array_diff(array_diff($all_lottery_number,$bet_lottery_number), [$old_running_game->tr47_win_lottery_number]));

			    					} else {

			    						$win_lottery_number = min(array_diff($all_lottery_number,$bet_lottery_number));

			    					}

	    						} else {


	    							// $usergamebets = DB::select("SELECT *, SUM(LOTTERY_QUANTITY) AS LOTTERY_QUANTITYS ,SUM(TOTAL_AMOUNT) AS TOTAL_AMOUNTS FROM user_game_bet WHERE GAME_ID = $value->m81_game_id AND LIVE_GAME_ID = $value->tr47_id GROUP BY LOTTERY_NUMBER ORDER BY TOTAL_AMOUNTS ASC");
	    							// $bet_lottery_numbers = array_column($usergamebets, 'LOTTERY_NUMBER');

	    							$win_lottery_number = $bet_lottery_number[0];

	    						}
	    					} else {

	    						$all_lottery_number = range($value->m81_start_number,$value->m81_end_number);

	    						$old_running_game = DB::table("tr47_live_runing_games")->where("tr47_status", "Closed")->where("m81_game_id", $value->m81_game_id)->orderBy("tr47_id","desc")->skip(1)->first();

		    					if($old_running_game) {

		    						$new_array = array_diff($all_lottery_number, [$old_running_game->tr47_win_lottery_number]);

		    						$win_lottery_number = $new_array[array_rand($new_array, 1)];  //new
		    						//$win_lottery_number = min(array_diff($all_lottery_number, [$old_running_game->tr47_win_lottery_number])); //old

		    					} else {

		    						$win_lottery_number = $all_lottery_number[array_rand($all_lottery_number, 1)]; //new
		    						//$win_lottery_number = min($all_lottery_number); //old

		    					}

	    					}

	    					if($value->tr47_win_lottery_number != '') {  $win_lottery_number = $value->tr47_win_lottery_number; }

	    					DB::table("tr47_live_runing_games")->where('tr47_id', $value->tr47_id)->update(["tr47_win_lottery_number" => $win_lottery_number]);

	    					DB::table("tr48_user_game_bet")->where('tr47_live_game_id', $value->tr47_id)->where('tr48_lottery_number', $win_lottery_number)->update(["tr48_status" => 'Win']);

	    					DB::table("tr48_user_game_bet")->where('tr47_live_game_id', $value->tr47_id)->where('tr48_lottery_number', '!=', $win_lottery_number)->update(["tr48_status" => 'Lost']);

	    					if(count($usergamebet) > 0) {
	    						DB::select("CALL update_game_income(".$value->tr47_id.")");
	    					}



	    			}
	    		}
    		//}


    	}
    
    	return 1;
    }




    public function dummy_game_play()
    {

    	date_default_timezone_set("Asia/Calcutta");
    	$users = DB::select("SELECT * FROM `m11_user` LIMIT 1,15");
    	$data =  DB::table("game_data")->Where("STATUS", "Active")->get();
    	$max = 30;
		$min = 10;
		$all_lottery_quantity = [1,2,3,4];

    			
    	if(count($data) > 0 && count($users) > 0 ) {

    		$running_game = DB::table("tr47_live_runing_games")->where("tr47_status", "Running")->get();

    		if(count($running_game) > 0 && date("H") > 9 && date("H") < 20) {
    			
    			foreach ($running_game as $key => $live_game_value) {

    				foreach ($users as $keys => $user_value) { 

	    				$all_lottery_number = range($live_game_value->m81_start_number,$live_game_value->m81_end_number);
						$lottery_number = $all_lottery_number[array_rand($all_lottery_number, 1)];

						
						$lottery_quantity = $all_lottery_quantity[array_rand($all_lottery_quantity, 1)];


						$range = $max - $min;
					    $num = $min + $range * (mt_rand() / mt_getrandmax());    
					    $amount = round($num, 2);
					    $total_amount = (int)$lottery_quantity * (float)$amount;



							// 	$shoppingwallet=array(
					  //               'proc'=>11,
					  //               'to_user_id'=>$userData[0]->referral_id,
					  //               'from_user_id'=>$userData[0]->user_id,
					  //               'amount'=>floatval($rf_amount),
					  //               'collected_amount'=>floatval($rf_amount),
					  //               'requesttype'=>1,
					  //               'balfor'=>2,
					  //               'transtype'=>30,
					  //               'timelimit'=>300,
					  //               'defaultstatus'=>1,
					  //               'remark'=>"referral bonus received $".$rf_amount,
					  //               'collected_remark'=>"referral bonus received $".$rf_amount
					  //           );

					  //        $shopping_wallet = DB::SELECT('CALL wallettransfer(
					  //               :proc, 
					  //               :to_user_id,
					  //               :from_user_id,
					  //               :amount, 
					  //               :collected_amount,
					  //               :requesttype,
					  //               :balfor,
					  //               :transtype,
					  //               :timelimit,
					  //               :defaultstatus,
					  //               :remark,
					  //               :collected_remark,
					  //               @status_code,
					  //               @status_msg)'
					  //           ,$shoppingwallet);
							// }

					 //    $transfer="DEDUCT";
						// $fundtransfer_data=array(
						// 'proc'=>7,
						// 'to_user_id'=> $user_value->m11_user_id,
						// 'from_user_id'=>0,
						// 'amount'=>$total_amount,
						// 'collected_amount'=>$total_amount, 
						// 'requesttype'=>1,
						// 'balfor'=>1,
						// 'transtype'=>28,
						// 'timelimit'=>100,
						// 'defaultstatus'=>1,
						// 'remark'=>"Auto purchase ".$games_data[0]->NAME." lottery ",
						// 'collected_remark'=>"Auto purchase ".$games_data[0]->NAME." lottery " 
						// );

						// $fundtransfer = $this->fund_repo->walletTransfer($fundtransfer_data);

						// $DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
						// $DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
						// $ERRMSG=$DB_ERRMSG[0]->ERR_MSG;
						// $ERRCODE=$DB_ERRCODE[0]->ERR_CODE;

						// if($ERRCODE == "success") {


						// }


    					DB::table("tr48_user_game_bet")->insert([
							"m81_game_id" => $live_game_value->m81_game_id,
							"m11_user_id" => $user_value->m11_user_id,
							"tr47_live_game_id" => $live_game_value->tr47_id,
							"tr48_lottery_number" => $lottery_number,
							"tr48_lottery_quantity" => $lottery_quantity,
							"tr48_lottery_amount" => $amount,
							"tr48_total_amount" => $total_amount,
						]);
    				}
    			}
    		}
    	}

    	return 1;
    }


	public function product_info($name,$id)
	{	
		$user =''; 
		$banners = $this->banner_repo->getByType(2);

		$categories = $this->cat_repo->getAllCategoryActive(); //category
		$subcategories = $this->cat_repo->getAllSubCategoryActive(); //sub category
		$products = $this->prod_repo->getAllActive();
		$productn = $this->prod_repo->getByName(str_replace('_', ' ', $name));
		$producti = $this->prod_repo->getById($id);

		if(Session::get('USER_ID'))
		{
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}
		if(count($producti) > 0)
		{
			$product = $producti[0];
			$product_varnt = $this->prod_varnt->getByProductId($product->PROD_ID);
		}
		elseif(count($productn) > 0)
		{
			$product = $productn[0];
			$product_varnt = $this->prod_varnt->getByProductId($product->PROD_ID);
		}
		else
		{
			return back();
		}
		
		return view('Front/product-single',compact('banners','user','categories','subcategories','product','products','product_varnt'));
	}


	public function product_variant_info($name,$id,$vid)
	{	
		$user ='';
		$banners = $this->banner_repo->getByType(2);
		$categories = $this->cat_repo->getAllCategoryActive(); //category
		$subcategories = $this->cat_repo->getAllSubCategoryActive(); //sub category
		$products = $this->prod_repo->getAllActive();
		$productn = $this->prod_repo->getByName(str_replace('_', ' ', $name));
		$producti = $this->prod_repo->getById($id);
		$product_variant = $this->prod_varnt->getById($vid);

		if(Session::get('USER_ID'))
		{
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}

		if(count($producti) > 0 && count($product_variant) > 0)
		{
			$product = $producti[0];
			$product_variant = $product_variant[0];
			if($product->PROD_ID != $product_variant->PROD_ID)
			{
				return back();
			}
			$product_varnt = $this->prod_varnt->getByProductId($product->PROD_ID);
		}
		elseif(count($productn) > 0  && count($product_variant) > 0)
		{
			$product = $productn[0];
			$product_variant = $product_variant[0];
			if($product->PROD_ID != $product_variant->PROD_ID)
			{
				return back();
			}
			$product_varnt = $this->prod_varnt->getByProductId($product->PROD_ID);

		}
		else
		{
			return back();
		}
		
		return view('Front/product-variant-single',compact('banners','user','categories','subcategories','product','products','product_varnt','product_variant'));
	}



	public function cat_product_info($name,$id, request $request)
	{	
		$user ='';
		$banners = $this->banner_repo->getByType(2);
		$catbanner = $this->banner_repo->getByTypeCat(7,$id);
		$catbanner_bottom = $this->banner_repo->getByTypeCat(11,$id);
		$categories = $this->cat_repo->getAllCategoryActive(); //category

		if($name != '')
		{
			$subcategories = $this->cat_repo->getSubCatByName(str_replace('_', ' ', $name)); //sub category
		}
		if(!count($subcategories) > 0)
		{
			$subcategories = $this->cat_repo->getSubCatById($id); //sub category
		}
	
		if($request->page == null)
		{
			$request->merge(['page'=>1]);
		}
		if($request->sort == null)
		{
			$request->merge(['sort'=>'relevance']);
		}
		if(count($subcategories) > 0)
		{
			$products = $this->prod_repo->getByCatParentIdPage($subcategories[0]->CAT_PARENTID, $request->sort, 12);
		}
		else
		{
			return back();
		}

		if(Session::get('USER_ID'))
		{
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}
		
		return view('Front/product-list',compact('banners','catbanner','catbanner_bottom','user','categories','subcategories','products','name'));
	}


	public function static_content_page($name)
	{
		$user = '';
		$static_content = $this->content_repo->getByVar($name);
		$categories = $this->cat_repo->getAllCategoryActive(); //category
		
		if(count($static_content) > 0)
		{
			$static_content = $static_content[0];
		}
		else
		{
			return back();
		}
		if(Session::get('USER_ID'))
		{
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}


		return view('Front/static-content',compact('static_content','user','categories'));
	}



	public function cat_product_allinfo($name,$id, request $request)
	{	
		$user ='';
		$banners = $this->banner_repo->getByType(2);
		$catbanner = $this->banner_repo->getByTypeCat(7,$id);
		$categories = $this->cat_repo->getAllCategoryActive(); //category
		$catbanner_bottom = $this->banner_repo->getByTypeCat(11,$id);
		if($name != '')
		{
			$categorie = $this->cat_repo->getByName(str_replace('_', ' ', $name)); //sub category
		}
		if(!count($categorie) > 0)
		{
			$categorie = $this->cat_repo->getById($id); //sub category
		}

		if(count($categorie) > 0)
		{
			$subcategories = $this->cat_repo->getSubCatById($categorie[0]->CAT_PARENTID); //sub category
		}
		else
		{
			return back();
		}

		if($request->page == null)
		{
			$request->merge(['page'=>1]);
		}
		if($request->sort == null)
		{
			$request->merge(['sort'=>'relevance']);
		}

		if(count($subcategories) > 0)
		{
			$products = $this->prod_repo->getByCatIdPage($categorie[0]->CAT_ID, $request->sort, 12);
		}
		else
		{
			return back();
		}

		if(Session::get('USER_ID'))
		{
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}
		
		return view('Front/product-list',compact('banners','catbanner','catbanner_bottom','user','categories','subcategories','products','name'));
	}


    public function checkout()
    {	
    	$user ='';
    	$coupan = $this->get_coupan_amount();
    	
    	$address=[];
    	$getdbcart =[];
		$banners = $this->banner_repo->getByType(2);
		$categories = $this->cat_repo->getAllCategoryActive(); //category
		if(Session::get('USER_ID'))
		{
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$address = $this->address_repo->getByUserId(Session::get('USER_ID'));
			$getdbcart = $this->orders_repo->getByOrderCodeWish(Session::get('USER_ID'), 'WISHLIST');
		}
		else
		{	
			return redirect('login');
		}

       return view('Front/checkout',compact('banners','user','categories','address','getdbcart','coupan'));
    }


    public function add_user_address(Request $request)
    {	
    	$user ='';
    
		if(Session::get('USER_ID'))
		{
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$array = [
				'm11_user_id' => Session::get('USER_ID'),
				'm73_flat' => $request->txt_full_address,
				'm73_area' => $request->txt_locality,
				'm73_landmark' => $request->txt_street,
				'm73_pincode' => $request->txt_pincode,
				'm73_address_type' => $request->txt_address
			];
			
			$address = $this->address_repo->create($array);
			if($address)
			{
				return back()->with('add_success', 'Address Add Successfully.');
			}
			else
			{
				return back()->with('add_warning', 'Address Not Add!');
			}
		}
		else
		{	
			return redirect('sign-in');
		}

       return view('Front/checkout',compact('banners','user','categories','address','getdbcart'));
    }


    public function update_user_address(Request $request)
    {	
    	$user ='';
 
		if(Session::get('USER_ID'))
		{
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$array = [
				'm73_flat' => $request->txt_full_address,
				'm73_area' => $request->txt_locality,
				'm73_landmark' => $request->txt_street,
				'm73_pincode' => $request->txt_pincode,
				'm73_address_type' => $request->txt_address
			];
			
			$address = $this->address_repo->update($request->id,$array);
			if($address)
			{
				return back()->with('add_success', 'Address Add Successfully.');
			}
			else
			{
				return back()->with('add_warning', 'Address Not Add!');
			}
		}
		else
		{	
			return redirect('sign-in');
		}

       return view('Front/checkout',compact('banners','user','categories','address','getdbcart'));
    }


    public function view_invoice($number)
    {
    	$cart = $this->orders_repo->getByOrderCode($number, Session::get('USER_ID'));
    	$user = Helper::get_userdetail(Session::get('USER_ID'));
    	$address = $this->address_repo->getById($cart[0]->ADDRESS_ID);
		//dd($address);
    	return view('User.view_bill',compact('cart','address','user'));
    }



    public function view_invoices($number)
    {
    	$cart = $this->orders_repo->getByOrderCode($number);
    	if(count($cart) > 0)
    	{
	    	$user = Helper::get_userdetail($cart[0]->USER_ID);
	    	$address = $this->address_repo->getById($cart[0]->ADDRESS_ID);
	    	return view('User.view_bill_app',compact('cart','address','user'));
    	}
    }



	public function my_orders()
	{
		$user ='';
		$categories = $this->cat_repo->getAllCategoryActive(); //category
		if(Session::get('USER_ID'))
		{
			$user = Helper::get_userdetail(Session::get('USER_ID'));
			$address = $this->address_repo->getByUserId(Session::get('USER_ID'));
			$user_cart = DB::select('SELECT * FROM `user_orders`
        	 WHERE USER_ID ='.Session::get('USER_ID').' AND CART_TYPE = "FINALCART" ORDER BY ORDER_ID DESC');
			return view('Front.my-account',compact('categories','user','address','user_cart'));
		}
		else
		{
			return back();
		}

	}

    public function dth()
    {
	$banners = $this->banner_repo->getByType(2);
	$popup= $this->banner_repo->getByType(6);
	$OPERATOR = Helper::get_operator(2,'ACTIVE');
	$user =''; 
	if(Session::get('USER_ID'))
	{
		$user = Helper::get_userdetail(Session::get('USER_ID'));
	}
	return view('Front/FRONT10/recharge-bill-dth',compact('banners','popup','OPERATOR','user'));
    }

    public function broadband()
    {
	$banners = $this->banner_repo->getByType(2);
	$popup= $this->banner_repo->getByType(6);
	$OPERATOR = Helper::get_operator(6,'ACTIVE');
	$user =''; 
	if(Session::get('USER_ID'))
	{
		$user = Helper::get_userdetail(Session::get('USER_ID'));
	}
	return view('Front/FRONT10/recharge-bill-broadband',compact('banners','popup','OPERATOR','user'));
    }

    public function landline()
    {
	$banners = $this->banner_repo->getByType(2);
	$popup= $this->banner_repo->getByType(6);
	$OPERATOR = Helper::get_operator(5,'ACTIVE');
	$user =''; 
	if(Session::get('USER_ID'))
	{
		$user = Helper::get_userdetail(Session::get('USER_ID'));
	}
	return view('Front/FRONT10/recharge-bill-landline',compact('banners','popup','OPERATOR','user'));
    }

    public function electricity()
    {
	$banners = $this->banner_repo->getByType(2);
	$popup= $this->banner_repo->getByType(6);
	$OPERATOR = Helper::get_operator(3,'ACTIVE');
	$user =''; 
	if(Session::get('USER_ID'))
	{
		$user = Helper::get_userdetail(Session::get('USER_ID'));
	}
	return view('Front/FRONT10/recharge-bill-electricity',compact('banners','popup','OPERATOR','user'));
    }

   public function gas()
    {
	$banners = $this->banner_repo->getByType(2);
	$popup= $this->banner_repo->getByType(6);
	$OPERATOR = Helper::get_operator(7,'ACTIVE');
	$user =''; 
	if(Session::get('USER_ID'))
	{
		$user = Helper::get_userdetail(Session::get('USER_ID'));
	}
	return view('Front/FRONT10/recharge-bill-gas',compact('banners','popup','OPERATOR','user'));
    }

    public function water()
    {
	$banners = $this->banner_repo->getByType(2);
	$popup= $this->banner_repo->getByType(6);
	$OPERATOR = Helper::get_operator(8,'ACTIVE');
	$user =''; 
	if(Session::get('USER_ID'))
	{
		$user = Helper::get_userdetail(Session::get('USER_ID'));
	}
	return view('Front/FRONT10/recharge-bill-water',compact('banners','popup','OPERATOR','user'));
    }

	public function contact_us()
    {
		$user =''; 
		if(Session::get('USER_ID'))
		{
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}

    	return view('Front/FRONT11.contact-page',compact('user'));
    	//return view('Front/FRONT10.contact-page',compact('user'));
    }

	public function frequently_asked_questions()
    {
		$user =''; 
		if(Session::get('USER_ID'))
		{
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}

    	return view('Front/FRONT11.faq',compact('user'));
    }

    public function about_us()
    {
    	
		$user =''; 
		if(Session::get('USER_ID'))
		{
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}
		$data = DB::select("SELECT STCNT_TITLE,STCNT_VAR, STCNT_CONTENT,STCNT_AFFID,STCNT_STATUS FROM static_content WHERE STCNT_STATUS = 'Active' AND STCNT_VAR = 'about_us'");
		if(count($data) > 0)
		{	
			$data = $data[0]; 
		}
		else
		{
			$data = '';
		}
    	return view('Front/FRONT10/about-page',compact('data','user'));
    }


	public function privacy_policy()
    {

		$user =''; 
		if(Session::get('USER_ID'))
		{
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}
		$data = DB::select("SELECT STCNT_TITLE,STCNT_VAR, STCNT_CONTENT,STCNT_AFFID,STCNT_STATUS FROM static_content WHERE STCNT_STATUS = 'Active' AND STCNT_VAR = 'privacy_policy'");
		if(count($data) > 0)
		{	
			$data = $data[0]; 
		}
		else
		{
			$data = '';
		}
    	return view('Front/FRONT10/privacy_policy',compact('data','user'));
    }


	public function T_C()
    {	

		$user =''; 
		if(Session::get('USER_ID'))
		{
			$user = Helper::get_userdetail(Session::get('USER_ID'));
		}
		$data = DB::select("SELECT STCNT_TITLE,STCNT_VAR, STCNT_CONTENT,STCNT_AFFID,STCNT_STATUS FROM static_content WHERE STCNT_STATUS = 'Active' AND STCNT_VAR = 'T&C'");
		if(count($data) > 0)
		{	
			$data = $data[0]; 
		}
		else
		{
			$data = '';
		}

    	return view('Front/FRONT10/t&c',compact('data','user'));
    }





/*
    public function index()
    {
	$banners = $this->banner_repo->getByType(2);
	$popup= $this->banner_repo->getByType(6);
	return view('Front/FRONT9/index',compact('banners','popup'));
    }
    public function about_us()
    {
    	return view('Front/FRONT9/aboutus');
    }
	public function services()
	{
           return view('Front/FRONT9/service');
    }
	public function contact_us()
    {
    	return view('Front/FRONT9.contactus');
    }
	public function recharge()
    {
    	return view('Front/FRONT9.recharge');
    }
	public function microatm()
    {
    	return view('Front/FRONT9.microatm');
    }
	public function pancard()
    {
    	return view('Front/FRONT7.pancard');
    }
	public function moneytransfer()
    {
    	return view('Front/FRONT9.moneytransfer');
    }
	
	public function aeps()
    {
    	return view('Front/FRONT9.aeps');
    }

	public function billpayment()
    {
    	return view('Front/FRONT9.billpayment');
    }

*/

    public function whatis()
    {
    	$category = DB::select(DB::raw('select * from m29_category where m02_parent_id = 0'));
    	$electronic = DB::select(DB::raw('select * from m33_products where m02_cat_id = 1 limit 3'));

    	return view('Front.whatis', compact('category', 'electronic'));

    }

    public function make_money()
    {
    	$category = DB::select(DB::raw('select * from m29_category where m02_parent_id = 0'));
    	$electronic = DB::select(DB::raw('select * from m33_products where m02_cat_id = 1 limit 3'));
    	return view('Front.make-money', compact('category', 'electronic'));

    }

    public function electronic_record()
    {
    	$category = DB::select(DB::raw('select * from m29_category where m02_parent_id = 0'));
    	$electronic = DB::select(DB::raw('select * from m33_products where m02_cat_id = 1 limit 3'));
    	return view('Front.electronic-record', compact('category', 'electronic'));
    }

   

    public function product($id)
    {
    	$category = DB::select(DB::raw('select * from m29_category where m02_parent_id = 0'));
    	$singleproduct = DB::select(DB::raw('select * from m33_products where m33_product_id = "'.$id.'"'));
    	$relatedproduct = DB::select(DB::raw('select * from m33_products where m02_cat_id = "'.$singleproduct[0]->m02_cat_id.'" and m33_product_id != "'.$singleproduct[0]->m33_product_id.'" limit 4'));

    	return view('Front.product', compact('category', 'singleproduct', 'relatedproduct'));

    }

    public function category($id)
    {
    	$category = DB::select(DB::raw('select * from m29_category where m02_parent_id = 0'));
    	$singlecat = DB::select(DB::raw('select * from m33_products where m02_cat_id = "'.$id.'"'));
        //$singlecat = DB::select(DB::raw('select * from m33_products as p join m34_product_images as i on p.m33_product_id = i.m33_product_id where p.m02_cat_id = "'.$id.'" limit 1'));
        //dd($singlecat);
        $images = DB::select(DB::raw('select * from m34_product_images'));
        $count = count($singlecat);

    	return view('Front.category', compact('category', 'singlecat', 'count', 'images'));

    }
	
	public function getMemberName( Request $request)
		{
			$id="";
			$id=$request->input('txtintuserid');
			$query['name']= Helper::get_user_name1($id);	// Get Details From Admin_Helper
			$query['id']= Helper::get_userid1($id);
		    //$query['bal']=Helper::get_bal(Helper::get_userid($id),1);
			$query['bscaddress']=Helper::get_userbscaddress1($id);
			$query['bal']=0.00;
			$json=json_encode($query);
			echo $json; 
		}

    public function getEmployeeName( Request $request)
    {
        $id="";
        $id=$request->input('txtintuserid');
        $query['name']= Helper::get_employee_name($id); // Get Details From Admin_Helper
        $query['id']= Helper::get_empid($id);
        $json=json_encode($query);
        echo $json; 
    }

		public function getStoreName( Request $request)
        {
            $id="";
            $id=$request->input('txtintuserid');   
            $query=DB::select("SELECT * FROM `m44_store` WHERE `m44_store_userid` = '".$id."'");
            $json=json_encode($query);
            echo $json; 
        }

		public function getPackageAmount(Request $request)
		{
			$pid = $request->input('pkg_id');
			$pacakge='';
			$package =DB::select("SELECT * FROM `package` WHERE PACKAGE_ID=".$pid."");
			return $package[0]->PACKAGE_FEE;
		}
		public function get_city(){
        $request = request();
        $state_id = $request->input('state_id');
        $state = DB::table('m02_location')->where('m02_parent_id',  $state_id)->where('m02_status' , 1)->get(); 
        return json_encode($state);
		}
		
		
     public function getIFSCode()
        {
        $request = request();
        $bank_id = $request->input('bank_id');
        $bank = DB::table('m01_bank')->where('m01_bank_id',$bank_id)->where('m01_bank_status',1)->get(); 
        return json_encode($bank);
		}
        
        
        public function getPDMRcharge(Request $request)
		{
			$groupid = $request->input('groupid');
			$userid =  $request->input('userid');
			$amount = $request->input('txt_transferamount');
			$surcharge='';
			$surcharge =DB::select(" SELECT `tr17_grop_dmr_surcharge` AS sramount  FROM `tr17_group_dmr` WHERE  `m16_gr_id`=".$groupid." AND ".$amount." BETWEEN `tr17_grop_dmr_startamt` AND `tr17_grop_dmr_endamt`");
			return $surcharge[0]->sramount;
		}

		 public function get_BTCADDRESS()
    {
    	$result=Helper::coinpayments_api_call('get_callback_address','BTC');
			
		print_r( json_encode($result['result']['address']));
    }


		public function update_token(Request $request)
		{
			
			$user =DB::select("SELECT * FROM `m11_user` WHERE 1 LIMIT 193,5");
			foreach($user as $u)
			{
			$token ="";
			$token = uniqid(base64_encode(str_random(30)));
			$user_profile=DB::update("UPDATE m11_user SET m11_user_api_token='".$token."' WHERE m11_user_id=". $u->m11_user_id." ");
			}
		}




	/**
			* Method name	: check_roffer
			* @description 	: Used to Get Roffer on user number
			* @param		: Request data  
			* @return		: Get ROffer Details data array with response message
		*/
		public function check_mobile_roffer(Request $request)
		{		
				$this->isError=FALSE;
				$opcode=$request->input('opt');
				$opcode='';$circlecode='';
				$opcircle_id='';
				$mobileno=$request->input('mobile');

				if($this->isError== FALSE)
				{
					if($request->input('mobile')=='')
					{
						$ERRMSG = "Mobile no should be valid.";
						$this->isError= TRUE;
						$ERRCODE="success";
						$userData ='';
					}
					else
					{
						//$url = 'https://api.dingconnect.com/api/V1/GetProviders?countryIsos=IN&accountNumber=91'.$mobileno.'';CURLOPT_HTTPHEADER=>'$request_headers',
						$url='http://planapi.in/api/Mobile/OperatorFetchNew?ApiUserID=3889&ApiPassword=123456&Mobileno='.$mobileno.'';
						$host = '';    
						$request_headers = array("api_key:3945q8QDszn6bTGaMrOVj0");

						$options = array(
						CURLOPT_SSL_VERIFYHOST => 0,
						CURLOPT_SSL_VERIFYPEER => 0
						);
						$defaults = array(
						CURLOPT_URL => $url,
						CURLOPT_HEADER => 0,
						CURLOPT_RETURNTRANSFER => TRUE,
						CURLOPT_TIMEOUT =>60
						);

						$ch = curl_init();
						curl_setopt_array($ch, ($options + $defaults));
						$result = curl_exec($ch);
						$json=json_decode($result);
						if($json->Operator!=''){
						$opcode	=$json->OpCode;
						$circlecode=$json->CircleCode;
						}
						/*if(count($json->Items) > 0)
						{
							curl_close($ch);
							$name = explode(" ",$json->Items[0]->Name);
							if(count($name) > 0)
							{
							  $opcode	= $name[0];
							}
						}
						else
						{
							$opcode	='';
						}*/
                        $opcircle_id = DB::select("SELECT IFNULL(`CIRCLE_ID`,'') as CIRCLE_ID FROM `op_circle` WHERE `CIRCLE_CODE`=".$circlecode." LIMIT 1");
						$opcode_id = DB::select("SELECT IFNULL(`m04_tc_brand_id`,'') as BRAND_ID,IFNULL(`m07_service_id`,'') as SERVICE_ID FROM `m15_service_provider` WHERE `m15_sp_code`='".$opcode."' AND `m12_api_id`=7 LIMIT 1");
						$brand_id=$opcode_id[0]->BRAND_ID;
						$service_id=$opcode_id[0]->SERVICE_ID;
						$ERRMSG = "D.";
						$this->isError= FALSE;
						$ERRCODE="success";
						$userData =$opcode_id[0]->BRAND_ID.'_'.$service_id;

						$details = DB::select("CALL recharge_report(2,'".$mobileno."','','','1970-01-01','1970-01-01',5,1,'1',@msg)");
					}
				}
				if($this->isError=== FALSE)
				{
					$rechreq=array(
					'proc'=>'3',
					'user_id'=> Session()->get('USER_ID'),
					'mobile'=>$mobileno,
					'operator'=>$brand_id,
					'amount'=>0.000,
					'requesttype'=>1,
					'servicetype'=>1,
					'agentid'=>'123456789',
					'format'=>'json',
					'timelimit'=>'900',
					'defaultstatus'=>'2'
					);	
					$rechreq_report=DB::select('CALL dorecharge(				
					:proc,
					:user_id,
					:mobile,
					:operator,
					:amount,
					:requesttype,
					:servicetype,
					:agentid,
					:format,
					:timelimit,
					:defaultstatus,
					@msg,
					@msg2
					)',$rechreq);
					
					$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
					
					if($DB_ERROR[0]->ERROR!="Error")
					{
						$transid=$DB_ERRMSG[0]->ERR_MSG;
						foreach($rechreq_report as $row)
						{						
							break;
						}
						$url=$row->url_address;	
						$operatorcode=$row->oper_code;
						if($mobileno!="")
						$url=str_replace('@account',$mobileno,$url);
						if($operatorcode!="")
						$url=str_replace('@operatorcode',$operatorcode,$url);
						//echo $url.'</br>';
						//PRINT_R($DB_ERRMSG[0]->ERR_MSG);
						$result=Helper::_curl_execute('GET',$url,'');
						$json=json_decode($result,true);

						if(isset($json['records']))
						{
							$userData =$json['records'];
						}
						else
						{
							$userData =array();
						}
					}
						return [ 'ROFFER'=>$userData, 'LAST5TRANSACTION'=>$details, 'brand_id' => $brand_id,'circle_id'=>$opcircle_id[0]->CIRCLE_ID,'circle_code'=>$circlecode ];							
				}
				return [ 'ROFFER'=>'', 'LAST5TRANSACTION'=>'', 'brand_id' => ''];
		}






		public function get_dth_roffer(Request $request)
		{
				$apitoken="0035e12b2628d608fe38f5c8456e8536";
				$mobileno1="";$amount1="";$opt1="";$opcode="";$cardnumber="";
				$mobileno1=$request->has('mobile')?'1':'0' ;
				$opt1=$request->has('opt')?'1':'0' ;
				$opcode=$request->input('opt');
				$cardnumber=$request->input('cardnumber');

				$opcode_id = DB::select("SELECT IFNULL(`m04_tc_brand_id`,'') as BRAND_ID,IFNULL(`m03_sr_type_id`,'') as SERVICE_ID FROM `m04_telecom_brand` WHERE `m04_tc_brand_id`='".$opcode."' AND `m04_tc_brand_status`='Active' LIMIT 1");

				$brand_id=$opcode_id[0]->BRAND_ID;
				$service_id=$opcode_id[0]->SERVICE_ID;

				$userData =$opcode_id[0]->BRAND_ID.'_'.$service_id;


				if(count($opcode_id) > 0)
				{
					$rechreq=array(
					'proc'=>'5',
					'user_id'=>Session()->get('USER_ID'),
					'mobile'=>$cardnumber,
					'operator'=>$brand_id,
					'amount'=>0.000,
					'requesttype'=>1,
					'servicetype'=>$service_id,
					'agentid'=>'123456789',
					'format'=>'json',
					'timelimit'=>'900',
					'defaultstatus'=>'2'
					);	
					$rechreq_report=DB::select('CALL dorecharge(				
					:proc,
					:user_id,
					:mobile,
					:operator,
					:amount,
					:requesttype,
					:servicetype,
					:agentid,
					:format,
					:timelimit,
					:defaultstatus,
					@msg,
					@msg2
					)',$rechreq);
					

					$DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$DB_ERROR=DB::select('SELECT @msg2 as ERROR');
					//dd($DB_ERROR[0]->ERROR);
					if($DB_ERROR[0]->ERROR!="Error")
					{
						$transid=$DB_ERRMSG[0]->ERR_MSG;
						foreach($rechreq_report as $row)
						{						
							break;
						}
						$url=$row->url_address;	
						$operatorcode=$row->oper_code;
						if($apitoken!="")
						$url=str_replace('@apitoken',$apitoken,$url);
						if($cardnumber!="")
						$url=str_replace('@account',$cardnumber,$url);
						if($operatorcode!="")
						$url=str_replace('@operatorcode',$operatorcode,$url);
						//echo $url.'</br>';
						//PRINT_R($DB_ERRMSG[0]->ERR_MSG);
						$result=Helper::_curl_execute('GET',$url,'');
						$json=json_decode($result,true);
						$userData =$json['records'];
						$ERRMSG = "DTH INFO FETCH SUCCESSFULLY";
						$this->isError= FALSE;
						$ERRCODE="success";
					}

						if(!array_key_exists('status',$userData))
						{
						return [
									'ERROR'=>$ERRCODE,
									'MSG' =>$ERRMSG,
									'DTHINFO'=>$userData,
									];					
						}
						else
						{
										$ERRMSG = "CARD NUMBER IS NOT VALID";
										$ERRCODE="error";
										return [
										'ERROR'=>$ERRCODE,
										'MSG' =>$ERRMSG,
										'DTHINFO'=>'',
										];
						}
				}
				else
				{
					return ['error' =>'Data Not Found'];
				}
		}



		
		public function send_mail()
		{
//dd(config());



			$template_type = 1;
					$data = array(
						'msg_title' => 'account_creation',
						'name' => 'txt_username',
						'useremail' => 'txt_email',
						'usercode' => '100000',
						'password' => 'txt_password',
						'link' => url('/home'),
						'trans_id' => url('/home'),
						'template_name' => 'registration',
						'USER_TYPE' => 1,
						'USER_ID' => 1,
					);

					$msg_config = DB::select('select * from m09_message_config where m09_msg_title = "'.$data['msg_title'].'"');
					$data['MSG_CONTENT'] = $msg_config[0]->m09_msg_content;
					$data['MSG_SUBJECT'] = $msg_config[0]->m09_msg_subject;
					$data['MSG_CONTENT'] = strtr($data['MSG_CONTENT'], array('{name}' => $data['name'],
					'{useremail}'=>$data['useremail'],'{password}'=>$data['password'],'{link}'=>$data['link'],'{trans_id}'=>$data['trans_id']));
					$data['pdf'] ='';
					$template_data = $data;

					$ehck = Mail::to('durgeshappworks@gmail.com')->send(new SendMail($template_data, $template_type));
dd($ehck,config('mail.mailers'), 'test');

return $ehck;


						$template_type = 1;
						$smsdata = array(
							'msg_title' => 'backup_data',
							'name' => 'Admin',
							'useremail' => 'durgeshvrm010@gmail.com',
							'link' => url('/verification'),
							'template_name' => 'email',
						);
						$msg_config = DB::select('select * from config_msg where MSG_TITLE = "'.$smsdata['msg_title'].'"');
						$smsdata['MSG_CONTENT'] = 'testing';
						$smsdata['MSG_SUBJECT'] = $msg_config[0]->MSG_SUB;
						$smsdata['USER_TYPE'] = 1;
						$smsdata['USER_ID'] = 1;
						$smsdata['MSG_CONTENT'] = strtr($smsdata['MSG_CONTENT'], array('{name}' => $smsdata['name'],
						'{useremail}'=>$smsdata['useremail'],'{link}'=>$smsdata['link']));
						$smsdata['pdf'] ='';
						$template_data = $smsdata;

						if(Mail::to('durgeshappworks@gmail.com')->send(new SendMail($template_data, $template_type)))
{
						//Mail::to('test@hostnetindia.com')->send(new SendMail($template_data, $template_type));
						echo 'email send';
}

		}


        public function invite($info)
        {
			$infoData = base64_decode($info);
			$infoData = explode(",",$infoData);
			$data = DB::table('m76_app_refral')->where('m76_device_id', $infoData[1])->first();

			$Userdata = Helper::get_userid($infoData[0]);
		
			if($Userdata != 'false')
			{
				if($data){ }else{
					DB::table('m76_app_refral')->insert(['m11_user_id'=> $infoData[0], 'm76_device_id'=> $infoData[1], 'm76_device_type'=> $infoData[2]]);
				}
				return redirect('https://play.google.com/store/apps/details?id=com.appworkpayrch.appworkspay');
			}

		}



		public function get_cat(Request $request)
        {
            $id = $request->txt_catid;
            if($id!='-1'){
                $sub_cat = $this->cat_repo->getAllByShoppingFor($id);
                if($sub_cat){
                    return $sub_cat;
                }
                else{
                    return 0;
                }
            }
        }

		public function get_sub_cat(Request $request)
        {
            $id = $request->txt_catid;
            if($id!='-1'){
                $sub_cat = $this->cat_repo->getSubCatById($id);
                if($sub_cat){
                    return $sub_cat;
                }
                else{
                    return 0;
                }
            }
        }

        public function get_optype(Request $request)
        {
            $id = $request->txt_grid;
            if($id!='-1'){
                $op_type = $this->optype_repo->getByOptionId($id);
                if($op_type){
                    return $op_type;
                }
                else{
                    return 0;
                }
            }
        }

		public function get_prods(Request $request)
        {
            $id = $request->txt_scat_id;
            if($id!='-1'){
                $prods = $this->prod_repo->getByCatId($id);
                if($prods){
                    return $prods;
                }
                else{
                    return 0;
                }
            }
        }


        public function find_city_by_pincode(Request $request)
        {	

        	   	$client = new \GuzzleHttp\Client();
			    $request = $client->get('https://api.postalpincode.in/pincode/'.$request->pincode);
			    $response = $request->getBody();
				$response = json_decode($response);
				$data['State'] = '';
				$data['Country'] = '';
				$data['District'] = '';
				$data['State_id'] = '';
				$data['Country_id'] = '';
				$data['District_id'] = '';
				$data['Pincode'] = '';
				if(isset($response[0]->Status))
				{
					if($response[0]->Status == 'Success')
					{
						if(isset($response[0]->PostOffice[0]->State))
						{	
							$Country = strtoupper($response[0]->PostOffice[0]->Country);
							$State = strtoupper($response[0]->PostOffice[0]->State);
							$District = strtoupper($response[0]->PostOffice[0]->District);

							if($Country !='')
							{
								$CountryData = DB::select("SELECT LOC_ID, UCASE(LOC_NAME) AS LOC_NAME FROM `location` WHERE LOC_NAME = '".$Country."'");
							
								if(count($CountryData) > 0)
								{
									$data['Country_id'] = $CountryData[0]->LOC_ID;
								}
							}

							if($State !='')
							{
								$StateData = DB::select("SELECT LOC_ID, UCASE(LOC_NAME) AS LOC_NAME FROM `location` WHERE LOC_NAME = '".$State."'");
								if(count($StateData) > 0)
								{
									$data['State_id'] = $StateData[0]->LOC_ID;
								}
							}

							if($District !='')
							{
								$DistrictData = DB::select("SELECT LOC_ID, UCASE(LOC_NAME) AS LOC_NAME FROM `location` WHERE LOC_NAME = '".$District."'");
								if(count($DistrictData) > 0)
								{
									$data['District_id'] = $DistrictData[0]->LOC_ID;
								}
							}

							$data['Country'] = $Country;
							$data['State'] 	= $State;
							$data['District'] = $District;
							$data['Pincode'] = $response[0]->PostOffice[0]->Pincode;
						}

						return $data;
					}
					else
					{
						return $data;
					}
				}
				else
				{
					return $data;
				}
        }
		
		
		
		
		public function testing()
		{

			$token =  ShipRocket::getToken();
		
			$single_order = $this->orders_repo->getByOrderCode('MARTAD1632242785');

			$product_details=json_decode($single_order[0]->PRODUCT_DETAILS,true);

			 $i=0;
			 $order_details=array();
					/*foreach ($product_details as $value) 
					{
						 $order_details1=array(
							  "name"=>$value->name,
							  "sku"=>$value->sku,
							  "units"=>$value->new_quantity,
							  "selling_price"=> $value->price,
							  "discount"=> $value->disc_price,,
							  "tax"=> $value->cget+$value->sgst,
							  "hsn"=> $value->hsncode
							);
					array_push($order_details1, $order_details);
					}*/
					
 // array_push($order_details, $order_details);
                    $order_details=array(
									  "order_id"=>$single_order[0]->ORDER_CODE,
									  "order_date"=>$single_order[0]->CREATED_AT,
									  "pickup_location"=>'LUCKNOW',
									  "channel_id"=>"83536",
									  "comment"=>"Reseller: M/s SPIDERSILK PVT LTD",
									  "billing_customer_name"=>$single_order[0]->FIRST_NAME,
									  "billing_last_name"=>$single_order[0]->LAST_NAME,
									  "billing_address"=>$single_order[0]->FLAT,
									  "billing_address_2"=>$single_order[0]->LANDMARK ,
									  "billing_city"=>$single_order[0]->CITY,
									  "billing_pincode"=>$single_order[0]->PINCODE,
									  "billing_state"=>$single_order[0]->STATE,
									  "billing_country"=>$single_order[0]->COUNTRY,
									  "billing_email"=>$single_order[0]->USER_EMAIL,
									  "billing_phone"=>$single_order[0]->USER_CONTACT,
									  "shipping_is_billing"=>true,
									  "shipping_customer_name"=>"",
									  "shipping_last_name"=>"",
									  "shipping_address"=>"",
									  "shipping_address_2"=>"",
									  "shipping_city"=>"",
									  "shipping_pincode"=>"",
									  "shipping_country"=>"",
									  "shipping_state"=>"",
									  "shipping_email"=>"",
									  "shipping_phone"=>"",
									  "order_items"=>array(
									      
									      "name"=>$product_details[0],
									      "sku"=>"chakra123",
									      "units"=>10,
									      "selling_price"=> 900,
									      "discount"=> "",
									      "tax"=> "",
									      "hsn"=> 441122
									  ),
									  "payment_method"=> "Prepaid", //COD 
									  "shipping_charges"=> $single_order[0]->FINAL_AMOUNT,
									  "giftwrap_charges"=> 0,
									  "transaction_charges"=> 0,
									  "total_discount"=> 0,
									  "sub_total"=> $single_order[0]->FINAL_AMOUNT,
									  "length"=> 10,
									  "breadth"=> 15,
									  "height"=> 20,
									  "weight"=> 2.5
									);


  /* +"id": 33307
        +"pickup_location": "Primary"
        +"address": "FF-18A, Goel Palace"
        +"address_2": "Faizabad Road , Indira Nagar"
        +"city": "Lucknow"
        +"email": "sourabhsvt@gmail.com"
        +"phone": "7275002233"
        +"seller_name": "sourabh srivastava"
        +"state": "Uttar Pradesh"
        +"country": "India"
        +"status": 2
        +"pin_code": "226016"*/

        
                    if($single_order!=null && $token != null)
                    {

                    	        $data= array (
								  'order_id' => '224-447',
								  'order_date' => '2021-10-13 11:11',
								  'pickup_location' => 'Primary',
								  'channel_id' => '83536',
								  'comment' => 'Reseller: M/s Goku',
								  'billing_customer_name' => 'Naruto',
								  'billing_last_name' => 'Uzumaki',
								  'billing_address' => 'House 221B, Leaf Village',
								  'billing_address_2' => 'Near Hokage House',
								  'billing_city' => 'New Delhi',
								  'billing_pincode' => 110002,
								  'billing_state' => 'Delhi',
								  'billing_country' => 'India',
								  'billing_email' => 'naruto@uzumaki.com',
								  'billing_phone' => '9876543210',
								  'shipping_is_billing' => true,
								  'shipping_customer_name' => 'Jane',
								  'shipping_last_name' => '',
								  'shipping_address' => 'New Delhi',
								  'shipping_address_2' => '',
								  'shipping_city' => 'New Delhi',
								  'shipping_pincode' => 110002,
								  'shipping_country' => 'India',
								  'shipping_state' => 'Delhi',
								  'shipping_email' => 'naruto@uzumaki.com',
								  'shipping_phone' => '9876543210',
								  'order_items' => array (
								    0 => 
								    array (
								      'name' => 'Kunai',
								      'sku' => 'chakra123',
								      'units' => 10,
								      'selling_price' => 900,
								      'discount' => '',
								      'tax' => '',
								      'hsn' => 441122,
								    ),
								  ),
								  'payment_method' => 'Prepaid',
								  'shipping_charges' => 0,
								  'giftwrap_charges' => 0,
								  'transaction_charges' => 0,
								  'total_discount' => 0,
								  'sub_total' => 9000,
								  'length' => 10,
								  'breadth' => 15,
								  'height' => 20,
								  'weight' => 2.5,
								);




                    dd($response);
                    $ERRMSG = "Order details fetch successfully.";
                    $ERRCODE="success";
                    }
                    else
                    {
                    $ERRMSG = "Order not found.";
                    $this->isError=TRUE;
                    $ERRCODE="warning";
                    }
			dd($single_order, ($order_details));
		}




		public function metamask_login(Request $request)
		{
			return view('Auth.metamask-login-page');
		}
        
		
}?>