<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\Employee\EmployeeRepository;
use App\Repositories\Master\Location\LocationRepository;
use App\Repositories\Master\Package\PackageRepository;
use App\Repositories\Enroll\EnrollRepository;
use App\Repositories\Topup\TopupRepository;
use App\Repositories\Team\TeamRepository;
use App\Repositories\Profile\ProfileRepository;
use App\Repositories\Log\LogRepository;
use App\Repositories\Ticket\TicketRepository;
use App\Repositories\Fund\FundRepository;
use App\Repositories\Closing\ClosingRepository;
use App\Repositories\Recharge\Rechargeprocess\RechargeprocessRepository;
use App\Repositories\Recharge\Rechargereport\RechargereportRepository;
use App\Repositories\Master\Bank\BankRepository;
use App\Repositories\Slab\SlabRepository;
use App\Repositories\Api\ApiRepository;
use App\Repositories\Dmt\Dmtprocess\DmtprocessRepository;
use App\Repositories\Dmt\Dmtreport\DmtreportRepository;
use App\Repositories\AEPS\AEPSprocess\AEPSprocessRepository;
use App\Repositories\AEPS\AEPSreport\AEPSreportRepository;
use App\Repositories\Master\Banner\BannerRepository;
use App\Repositories\Affiliate\AffiliateRepository;
use App\Repositories\Master\WlConfig\WlConfigRepository;

use App\Repositories\ProductModule\Categories\CategoriesRepository;
use App\Repositories\ProductModule\ParentCategories\ParentCategoriesRepository;
use App\Repositories\ProductModule\Products\ProductsRepository;
use App\Repositories\ProductModule\UserOrders\UserOrdersRepository;
use App\Repositories\ProductModule\Favorites\FavoritesRepository;
use App\Repositories\ProductModule\Wishlist\WishlistRepository;
use App\Repositories\ProductModule\UserAddress\UserAddressRepository;
use App\Repositories\ProductModule\OnlinePayment\OnlinePaymentRepository;
use App\Repositories\ProductModule\ProductVariant\ProductVariantRepository;
use DB;
use Helper;
use Session;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;

class EmployeeController extends Controller
{

	var $message = "Invalid Operation";
    private $userDisbled = 0;
	private $STATUS = "failed";
	private $ERRMSG = "Invalid Operation";
	private $ERRCODE = "error";
	private $isError = FALSE;
	private $record_per_page =10;


	private $location_repo;
	private $package_repo;
	private $emp_repo;
	private $enroll_repo;
	private $profile_repo;
	private $topup_repo;
	private $team_repo;
	private $log_repo;
	private $ticket_repo;
	private $fund_repo;
	private $closing_repo;
	private $rech_proc_repo;
	private $rech_reprt_repo;
	private $bank_repo;
	private $slab_repo;
	private $dmt_reprt_repo;
  private $api_repo;
	private $aeps_reprt_repo;
  private $banner_repo;
  private $Affiliate_repo;
	private $wlconfig_repo;

	private $parent_catrepo;
  private $cat_repo;
  private $prod_repo;
  private $order_repo;
  private $fav_repo;
  private $wishlist_repo;
  private $address_repo;
  private $onlinepay_repo;
  private $prod_varnt;


	public function __construct(LocationRepository $location_repo, PackageRepository $package_repo,
		EmployeeRepository $emp_repo, EnrollRepository $enroll_repo, ProfileRepository $profile_repo,
		TopupRepository $topup_repo, TeamRepository $team_repo, LogRepository $log_repo,
		TicketRepository $ticket_repo, FundRepository $fund_repo, ClosingRepository $closing_repo,
		 RechargeprocessRepository $rech_proc_repo, RechargereportRepository $rech_reprt_repo, BankRepository $bank_repo, SlabRepository $slab_repo,
        ApiRepository $api_repo, DmtreportRepository $dmt_reprt_repo, AEPSreportRepository $aeps_reprt_repo, BannerRepository $banner_repo, 
		AffiliateRepository $Affiliate_repo, WlConfigRepository $wlconfig_repo,CategoriesRepository $cat_repo, ProductsRepository $prod_repo,
        ParentCategoriesRepository $parent_catrepo, UserOrdersRepository $order_repo, 
        FavoritesRepository $fav_repo, WishlistRepository $wishlist_repo, UserAddressRepository $address_repo, 
        OnlinePaymentRepository $onlinepay_repo, ProductVariantRepository $prod_varnt)
    {
    	$this->location_repo = $location_repo;
    	$this->package_repo = $package_repo;
    	$this->emp_repo = $emp_repo;
    	$this->enroll_repo = $enroll_repo;
    	$this->profile_repo = $profile_repo;
    	$this->topup_repo = $topup_repo;
    	$this->team_repo = $team_repo;
    	$this->log_repo = $log_repo;
    	$this->ticket_repo = $ticket_repo;
    	$this->fund_repo = $fund_repo;
    	$this->closing_repo = $closing_repo;
			$this->rech_proc_repo = $rech_proc_repo;
			$this->rech_reprt_repo = $rech_reprt_repo;
    	$this->dmt_reprt_repo = $dmt_reprt_repo;
    	$this->bank_repo = $bank_repo;
    	$this->slab_repo = $slab_repo;
      $this->api_repo = $api_repo;
			$this->aeps_reprt_repo = $aeps_reprt_repo;
      $this->banner_repo = $banner_repo;
			$this->Affiliate_repo = $Affiliate_repo;
			$this->wlconfig_repo = $wlconfig_repo;

	    $this->cat_repo = $cat_repo;
      $this->prod_repo = $prod_repo;
      $this->parent_catrepo = $parent_catrepo;
      $this->order_repo = $order_repo;
      $this->fav_repo = $fav_repo;
      $this->wishlist_repo = $wishlist_repo;
      $this->address_repo = $address_repo;
      $this->onlinepay_repo = $onlinepay_repo;
      $this->prod_varnt = $prod_varnt;

    }


	/**
		* Method name	: match values
		* @description 	: Used for matching old and new inserted values
		* @param		: Request data  
		* @return		: return updated values with old values before updation
	*/
    public function match_values($old_values,$new_values)
	{
		$old_value=$old_values[0];
		$new_arr = array();
		foreach($old_value as $key=>$value){ $new_arr[$key] = $value; }
		$count=count($new_arr);
		$arr_key = array_keys($new_values);
		$arr_val = array_values($new_arr);
		$new_old_array = array();
		for($i=0;$i<$count;$i++){ $new_old_array[$arr_key[$i]] = $arr_val[$i]; }
		$result = array_diff($new_values, $new_old_array);
		$new_values1 = json_encode(array_intersect_key($new_values,$result));
		$old_values1 = json_encode(array_intersect_key($new_old_array,$result));

		return [$new_values1,$old_values1];
	}



    public function employee_reg()
    {
    	$state = $this->location_repo->getAllStates();
		$package = $this->package_repo->getAllPackage();
		$banks = $this->bank_repo->getAll();
    	return view('Employee.employee_reg', compact('state','package', 'banks'));
    }

    public function signin()
	{
		Session::flash('type','info' );
		Session::flash('message','LOGIN HERE!');

		$request = request();
		if(request()->method() == 'POST')
		{
			
			$this->validate($request, [
            'txt_username'=> 'required',
            'txt_password'=> 'required|min:3'
			],
			[
            'txt_password.required' => 'User name is required',
            'txt_password.required' => 'Password is required',
            'txt_password.min' => 'Password must be at least 6 characters'
			]);
			
			$login_data = array(
			'login_id'=>$request->input('txt_username'),
			'user_pwd'=>$request->input('txt_password'),
			'login_ip'=>$request->server('REMOTE_ADDR'),
			'user_agent'=>$request->server('HTTP_USER_AGENT'),
			'user_type'=>$request->input('ddtype')
			);
		
			$login_id=$request->input('txt_username');
			$user_pwd=$request->input('txt_password');
			$user_type=$request->input('ddtype');
			
			$result = DB::select('CALL employee_login(:login_id, :user_pwd,:login_ip,:user_agent, :user_type, @status_code,@status_msg)',$login_data);
			
			$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
			$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
			$count = count($result);
		
			if($count == 1)
			{
				foreach($result as $row)
				{
					break;
				}
				$sessiondata=array(
				'USER_ID'         =>    $row->USER_ID,
				'EMAIL'           =>    $row->EMAIL,
				'NAME'            =>    $row->FIRST_NAME.$row->LAST_NAME,
				'USER_ROLE'       =>    $row->USER_ROLE,
				'USER_ROLE_ID'    =>    $row->USER_ROLE_ID,
				'USER_TYPE'    =>    $result[0]->USER_TYPE,	
				'CONTACTNO'       =>    $row->CONTACTNO,
				'USER_IMG'        =>    $row->USER_IMG,
				'AFFILIATE_CODE'  =>    $row->AFFILIATE_CODE,
				'IS_LOGIN'        =>    $row->IS_LOGIN,
				'USER_CODE'		    =>    $row->USER_CODE
				);
				Session::put($sessiondata);
				Session::flash('type','success' );
				Session::flash('message',$ERRMSG[0]->ERR_MSG );
				Session::put('dash_url', 'employee_dashboard');
				return redirect('/employee_dashboard');

			}
			else 
			{
				Session::flash('type','warning' );
				Session::flash( 'message', $ERRMSG[0]->ERR_MSG);
				if($request->input('ddtype') == 1){
					return redirect()->to('/admin_login');
				}
				else if($request->input('ddtype') == 2){
					return redirect()->to('/employee_login');
				}
				else{
					return redirect()->to('/login');   
				}
				
			}
		}
		else 
		{
			Session::flash('type','warning');
			Session::flash ('message', "Invalid Method , Please try again.");
			return redirect()->to('/');
		}
	}

	public function signup()
  	{
      $request = request();
//dd($request);
      if($request->method() == 'POST')
      {
        
          $this->validate($request, [
              'txt_referralcode'=> 'required',
              'position'=> 'required',
              'txt_username'=> 'required',
              'txt_email'=> 'required|email',
              'txt_mobileno'=> 'required',
              'txt_password'=> 'required|min:3'
          ],
          [
              'txt_referralcode.required' => 'Referral code is required!',
              'position.required' => 'Position is required!',
              'txt_username.required' => 'Username is required!',
              'txt_email.required' => 'Email is required!',
              'txt_mobileno.required' => 'Mobile No. is required!',
              'txt_password.min' => 'Password must be at least 6 characters!'
          ]);
    
          $txt_cancelchq="";
          $txt_gstcrt ="";
          if($request->input('txt_password')=='')
          {
              $pass=rand(100000,999999);
              $pinpass=rand(100000,999999);
          }
          else
          {
              $pass=$request->input('txt_password');
              $pinpass=$request->input('txt_password');
          }   
          $signup_data=Helper::reg_employee($request,$pass,$pinpass,'','','',$txt_gstcrt,$txt_cancelchq);  
          $response= $this->emp_repo->create($signup_data); 
		  $signup_data1=Helper::notify_data($request,1,"NEW EMPLOYEE INSERT SUCCESSFULLY",$response['err_msg'],0,'1');	
		  if($response['err_code']=="success")
		  {
            //$this->send_sms($request->input('txt_mobileno'),$ERRMSG[0]->ERR_MSG);
		  }
		  Session::flash( 'message', $response['err_msg'] );
		  Session::flash( 'type', $response['err_code'] );
		  return redirect('/employee_reg');
      }
  	}

  	public function index()
	{
		$queery ="";//echo Session::get('USER_ID');dd();
	  	$user = Helper::get_userdetail(Session::get('USER_ID'));
		$news = Helper::get_news(0,'ACTIVE','EMPLOYEE');
		if(Session::get('USER_ROLE') == 'EMPLOYEE') 
		{
			return view('Employee.employee_dashboard',compact('user','news'));                   
		}
        else if(Session::get('USER_ROLE') == 'SALES') 
        {
          return view('Employee.Sales.salesemp_dashboard',compact('user','news'));  
        }
        else if(Session::get('USER_ROLE') == 'SUPPORT') 
        {
          return view('Employee.Support.supportemp_dashboard',compact('user','news'));                                 
        }
        else if(Session::get('USER_ROLE') == 'ACCOUNT') 
        {
          return view('Employee.Accounts.accountsemp_dashboard',compact('user','news'));                                 
        }
        else if(Session::get('USER_ROLE') == 'TECHNICAL') 
        {
          return view('Employee.Technical.technicalemp_dashboard',compact('user','news'));                                  
        }
        else if(Session::get('USER_ROLE') == 'BACKOFFICE' ) 
        {
          return view('Employee.Backoffice.backofficeemp_dashboard',compact('user','news'));
        }
	    else
		{
			return view('Employee.employee_dashboard',compact('user','news'));                   
		}
	}

    /**
        * Method name   : Registration
        * @description  : Used for joining user
        * @param        : Request data
        * @return       : return with join user view
    */
    public function registration()
	{
		$state = $this->location_repo->getAllStates();
		$package = $this->package_repo->getAllPackage();
		$banks = $this->bank_repo->getAll();
		return view('Employee.registration', compact('state','package', 'banks'));
	}

	/**
        * Method name   : Add User
        * @description  : Used for joining user
        * @param        : Request data
        * @return       : return with addding user
    */
	public function add_user()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'NEW REGISTRATION';
		$request = request();

		$this->validate($request, [
            'txt_mobileno'=> 'required|numeric|digits:10|regex:/^[5-9]\d{9}$/|unique:enroll,MemberContactNo',
            'txt_email'=> 'required|email|unique:enroll,MemberEmail',
			'txt_addressproof' => 'nullable|mimes:jpeg,png,jpg|max:20240',
        ],[
            'txt_mobileno.required'=> 'Mobile Number is required',
            'txt_mobileno.numeric'=> 'Enter is valid Mobile Number',
            'txt_mobileno.digits'=> 'Enter is valid Mobile Number',
			'txt_mobileno.regex'=> 'Enter is valid Mobile Number',
            'txt_email.required'=> 'E-mail ID is required',
            'txt_email.email'=> 'Enter Valid E-mail ID',
			'txt_addressproof.mimes'=> 'Image Type jpeg,png,jpg',
			'txt_addressproof.max'=> 'Image Max 2 MB'
        ]);

		if($request->method() == 'POST')
		{
		  
		  $bankproof ="";
		  $gstno ="";

		      if($request->input('txt_password')=='')
		      {
		          $pass=rand(100000,999999);
		          $pinpass=rand(100000,999999);
		      }
		      else
		      {
		          $pass=$request->input('txt_password');
		          $pinpass=$request->input('txt_password');
		      }   
		      $signup_data=Helper::reg_data($request,$pass,$pinpass,'','','',$gstno,$bankproof);  
		      $response= $this->enroll_repo->create($signup_data); 

				if($response['err_code']=="success")
				{
	                //$this->send_sms($request->input('txt_mobileno'),$ERRMSG[0]->ERR_MSG);
				}
				Session::flash( 'message', $response['err_msg'] );
				Session::flash( 'type', $response['err_code'] );
		         
			return redirect('/emp_registration');
		}
	}

	/**
        * Method name   : View User
        * @description  : Used for viewing user details
        * @param        : Request data
        * @return       : return with viewing user details
    */
	public function view_user()
	{
		$request = request();
		$user = "";
		$USERID="";
		$get_useralldetail = "";
		if($request->method() == 'POST')
		{
		  if($request->input('txt_memberid')=='')
		  {
		      $ERRMSG = "Member id should be valid or not blank.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  else
		  {
		      $ERRMSG = "";
		      $this->isError=FALSE;
		      $ERRCODE="success";
		  }
		  
		  if(request()->method() == 'POST' && $this->isError==FALSE)
		  {
		      $userid = Helper::get_userid($request->input('txt_memberid'));
		      
		      if($userid!=FALSE)
		      {
		          $user = Helper::get_userdetail($userid);
		          $get_useralldetail = Helper::get_useralldetail($userid);
		          $ERRMSG = "Member details fetch successfully.";
		          $ERRCODE="success";
		      }
		      else
		      {
		          $ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
		          $this->isError=TRUE;
		          $ERRCODE="warning";
		      }
		  }
		}
		$USERID=$request->input('txt_memberid');
		return view('Employee.view_profile',compact('user','get_useralldetail','USERID'));

	}

	/**
        * Method name   : Edit User
        * @description  : Used for editing user details
        * @param        : Request data
        * @return       : return with editing user details
    */
	public function edit_user()
	{
		$request = request();
		$user = "";
		$USERID="";
		$get_useralldetail = "";
		if($request->method() == 'POST')
		{
		  if($request->input('txt_memberid')=='')
		  {
		      $ERRMSG = "Member id should be valid or not blank.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  else
		  {
		      $ERRMSG = "";
		      $this->isError=FALSE;
		      $ERRCODE="success";
		  }
		
		  if(request()->method() == 'POST' && $this->isError==FALSE)
		  {
		      $userid = Helper::get_userid($request->input('txt_memberid'));
		      if($userid!=FALSE)
		      {
		      $user = Helper::get_userdetail($userid);
		      $get_useralldetail = Helper::get_useralldetail($userid);
		      $ERRMSG = "Member details fetch successfully.";
		      $ERRCODE="success";
		      }
		      else
		      {
		      $ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
		      $this->isError=TRUE;
		      $ERRCODE="warning";
		      }
		  }
		}
		$USERID=$request->input('txt_memberid');
		return view('Employee.edit_userprofile',compact('user','get_useralldetail','USERID'));

	}

	/**
        * Method name   : Update User Profile
        * @description  : Used for updating user profile
        * @param        : Request data
        * @return       : return with updating user profile
    */
	public function update_userprofile()
	{
		$request = request();
		$USERID='';

		if($request->method() == 'POST')
		{
		 if($_FILES['txt_yourphoto']['name']!= '')
		  {
		      $image = $request->file('txt_yourphoto');
		      $name = $request->input('txt_membercode').'_PHOTO_'.time().'.'.$image->getClientOriginalExtension();
		      $destinationPath = public_path('images/USER_PHOTO');
			  $FileType = array('jpeg','png','jpg');
			  if(in_array($image->getClientOriginalExtension(), $FileType)) {
					$image->move($destinationPath,$name);
			  }
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
		      $txt_yourphoto =  $name;
		  }
		  else
		  {
		      $txt_yourphoto = trim($request->input('txt_yourphotohd'));
		  }
		   if($request->input('txt_username')=='')
		  {
		      $ERRMSG = "Member user name should be valid or not blank.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  else if($request->input('txt_mobileno')=='')
		  {
		      $ERRMSG = "Member contact number should be valid or not blank.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  else if($request->input('txt_email')=='')
		  {
		      $ERRMSG = "Member email address should be valid or not blank.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  else if($request->input('txt_dob')=='')
		  {
		      $ERRMSG = "Member Date of birth should be valid or not blank.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  else if($request->input('txt_address')=='')
		  {
		      $ERRMSG = "Member address should be valid or not blank.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  else if($request->input('txt_postalcode')=='')
		  {
		      $ERRMSG = "Member postal code should be valid or not blank.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  else if($txt_yourphoto=='')
		  {
		      $ERRMSG = "Member image should be valid or not blank.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  else
		  {
		      $ERRMSG = "";
		      $this->isError=FALSE;
		      $ERRCODE="success";
		  }
		  if(request()->method() == 'POST'&& $this->isError==FALSE)
		  {
		      $name=explode(" " ,$request->input('txt_username'));
		      $user_name=$request->input('txt_username');
		      $USER=$request->input('txt_userid');
		      $arr = array(
					'm11_first_name' => $name[0],
					'm11_last_name' => $name[1],
					'm11_user_name' => $request->input('txt_username'),
					'm11_user_dob' => date('Y-m-d',strtotime($request->input('txt_dob'))),
					'm11_user_location' => $request->input('txt_address'),
					'm11_user_postalcode' => $request->input('txt_postalcode'),
					'm11_user_contactno' => $request->input('txt_mobileno'),
					'm11_user_email' => $request->input('txt_email'),
					'm11_user_image' => $txt_yourphoto
					);

			  $old_values=DB::select("SELECT FirstName,LastName,MemberName,MemberDOB,MemberLocation,MemberPostalCode,MemberContactNo,MemberEmail,MemberImage FROM user_details WHERE RegId=".$request->input('txt_userid')."");

			  $user_profile = $this->enroll_repo->update($request->input('txt_membercode'), $request->input('txt_userid'), $arr);

			 $data=$this->match_values($old_values,$arr);
		      $arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => $data[1],
						'tr11_ar_new_value' => $data[0],
						'tr11_ar_uid' => $USER,
						'tr11_ar_description' => 'USER PERSONAL DETAILS HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 3,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
				$mobileno_actionrecord=$this->log_repo->create($arr);
		      $ERRMSG="USER PERSONAL DETAILS HAS BEEN CHANGED SUCCESSFULLY!";
		      $ERRCODE='success'; 
		  }
		}
		$USERID=$request->input('txt_membercode');
		$userid = Helper::get_userid($request->input('txt_membercode'));
		      
		      if($userid!=FALSE)
		      {
		      $user = Helper::get_userdetail($userid);
		      $get_useralldetail = Helper::get_useralldetail($userid);
		      }
		      else
		      {
		      $ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
		      $this->isError=TRUE;
		      $ERRCODE="warning";
		      }
		Session::flash('type',$ERRCODE);
		Session::flash('message',$ERRMSG);
		return view('Employee.edit_userprofile',compact('user','get_useralldetail','USERID'));
	}

	/**
        * Method name   : Edit User Bank Deatails
        * @description  : Used for getting user bank details
        * @param        : Request data
        * @return       : return with user bank details
    */
	public function edit_userbankdetails()
	{
		$request = request();
		$user = "";
		$USERID="";
		$get_useralldetail = "";
		if($request->method() == 'POST')
		{
		     if($request->input('txt_memberid')=='')
		      {
		          $ERRMSG = "Member id should be valid or not blank.";
		          $this->isError= TRUE;
		          $ERRCODE="warning";
		      }
		      else
		      {
		          $ERRMSG = "";
		          $this->isError=FALSE;
		          $ERRCODE="success";
		      }
		      
		      if(request()->method() == 'POST' && $this->isError==FALSE)
		      {
		          $userid = Helper::get_userid($request->input('txt_memberid'));
		          if($userid!=FALSE)
		          {
		          $user = Helper::get_userdetail($userid);
		          $get_useralldetail = Helper::get_useralldetail($userid);
		          $ERRMSG = "Member details fetch successfully.";
		          $ERRCODE="success";
		          }
		          else
		          {
		          $ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
		          $this->isError=TRUE;
		          $ERRCODE="warning";
		          }
		      }
		}
		$USERID=$request->input('txt_memberid');
		return view('Employee.edit_userbankdetails',compact('user','get_useralldetail','USERID'));
	}

	/**
        * Method name   : Update user bank details
        * @description  : Used for updating user bank details
        * @param        : Request data
        * @return       : return with updated user bank details
    */
	public function update_userbankdetails()
	{
		$request = request();
		$USERID="";

		if($request->method() == 'POST')
		{
		  if($_FILES['txt_cancelchq']['name']!= '')
		  {
		      $image = $request->file('txt_cancelchq');
		      $name = $request->input('txt_membercode').'_CANCELCHEQUE_'.time().'.'.$image->getClientOriginalExtension();
		      $destinationPath = public_path('images/CANCEL_CHEQUE');
			  $FileType = array('jpeg','png','jpg');
			  if(in_array($image->getClientOriginalExtension(), $FileType)) {
					$image->move($destinationPath,$name);
			  }
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
		      $txt_cancelchq =  $name;
		  }
		  else
		  {
		      $txt_cancelchq = trim($request->input('txt_cancelchqhd'));
		  }
		  if($request->input('txt_nameatbank')=='' )
		  {
		      $ERRMSG = "Member Name at Bank should be valid or not blank.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  else if($request->input('txt_bankname')=='')
		  {
		      $ERRMSG = "Member Bank Name should be valid or not blank.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  else if($request->input('txt_cbsacno')=='')
		  {
		      $ERRMSG = "Member Bank no Account should be valid or not blank.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  else if($request->input('txt_bankbranch')=='')
		  {
		      $ERRMSG = "Member Bank Branch should be valid or not blank.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  else if($request->input('txt_bankifsccode')=='')
		  {
		      $ERRMSG = "Member Bank IFSCode should be valid or not blank.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		   else if($txt_cancelchq=='')
		  {
		      $ERRMSG = "Cancel cheque should be valid or not blank.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  else
		  {
		      $ERRMSG = "";
		      $this->isError=FALSE;
		      $ERRCODE="success";
		  }
		  if(request()->method() == 'POST'&& $this->isError==FALSE)
		  {
		      $ACCOUNTNO=$request->input('txt_cbsacno');
		      $USER=$request->input('txt_userid');
		      $arr = array(
					'm23_user_nameat_bank'=>$request->input('txt_nameatbank'),
					'm23_user_cbsacno' =>$request->input('txt_cbsacno'),
					'm01_bank_name'=>$request->input('txt_bankname'),
					'm23_user_branch'=>$request->input('txt_bankbranch'),
					'm23_user_ifscode' =>$request->input('txt_bankifsccode'),
					'm23_usercancelechq'=>$txt_cancelchq
					);
			  $old_values=DB::select("SELECT NAMEatBANK,CBSACno,BANKNo,Branch,IFSCode,CancelCheque FROM user_details WHERE RegId=".$USER."");

			  $this->profile_repo->updateBankByUserId($request->input('txt_userid'), $arr);
				$data=$this->match_values($old_values,$arr);
		      	$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => $data[1],
						'tr11_ar_new_value' => $data[0],
						'tr11_ar_uid' => $USER,
						'tr11_ar_description' => 'USER S BANK DETAILS HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 3,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
				$bank_actionrecord=$this->log_repo->create($arr);       
		      $ERRMSG="USER'S BANK HAS BEEN CHANGED SUCCESSFULLY!";
		      $ERRCODE='success'; 
		  }
		}
		      $USERID=$request->input('txt_membercode');
		      $userid = Helper::get_userid($request->input('txt_membercode'));
		      if($userid!=FALSE)
		      {
		      $user = Helper::get_userdetail($userid);
		      $get_useralldetail = Helper::get_useralldetail($userid);
		      }
		      else
		      {
		      $ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
		      $this->isError=TRUE;
		      $ERRCODE="warning";
		      }
		Session::flash('type',$ERRCODE);
		Session::flash('message',$ERRMSG);
		return view('Employee.edit_userbankdetails',compact('user','get_useralldetail','USERID'));
	}

	/**
        * Method name   : Edit user kyc details
        * @description  : Used for editing user kyc details
        * @param        : Request data
        * @return       : return with user kyc details
    */
	public function edit_userkycdetails()
	{
		$request = request();
		$user = "";
		$USERID="";
		$get_useralldetail = "";
		if($request->method() == 'POST')
		{
		     if($request->input('txt_memberid')=='')
		      {
		          $ERRMSG = "Member id should be valid or not blank.";
		          $this->isError= TRUE;
		          $ERRCODE="warning";
		      }
		      else
		      {
		          $ERRMSG = "";
		          $this->isError=FALSE;
		          $ERRCODE="success";
		      }
		      
		      if(request()->method() == 'POST' && $this->isError==FALSE)
		      {
		          $userid = Helper::get_userid($request->input('txt_memberid'));
		          if($userid!=FALSE)
		          {
		          $user = Helper::get_userdetail($userid);
		          $get_useralldetail = Helper::get_useralldetail($userid);
		          $ERRMSG = "Member details fetch successfully.";
		          $ERRCODE="success";
		          }
		          else
		          {
		          $ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
		          $this->isError=TRUE;
		          $ERRCODE="warning";
		          }
		      }
		}
		 $USERID=$request->input('txt_memberid');
		 return view('Employee.edit_userkycdetails',compact('get_useralldetail','USERID'));
	}

	/**
        * Method name   : Update user kyc
        * @description  : Used for updating user kyc details
        * @param        : Request data
        * @return       : return with updated user kyc details
    */
	public function update_userkyc()
	{
		$request = request();
		$USERID="";

		if($request->method() == 'POST')
		{
		  if($_FILES['txt_yourphoto']['name']!= '')
		  {
		      $image = $request->file('txt_yourphoto');
		      $name = $request->input('txt_membercode').'_PHOTO_'.time().'.'.$image->getClientOriginalExtension();
		      $destinationPath = public_path('images/USER_PHOTO');
			  $FileType = array('jpeg','png','jpg');
			  if(in_array($image->getClientOriginalExtension(), $FileType)) {
		      $image->move($destinationPath,$name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
		      $txt_yourphoto =  $name;
		  }
		  else
		  {
		      $txt_yourphoto = trim($request->input('txt_yourphotohd'));
		  }
		  if($_FILES['txt_idproof']['name']!= '')
		  {
		      $image = $request->file('txt_idproof');
		      $name = $request->input('txt_membercode').'_IDPROOF_'.time().'.'.$image->getClientOriginalExtension();
		      $destinationPath = public_path('images/USER_IDPROOF');
			  $FileType = array('jpeg','png','jpg');
			  if(in_array($image->getClientOriginalExtension(), $FileType)) {
		      $image->move($destinationPath, $name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
		      $txt_idproof =  $name;
		  }
		  else
		  {
		      $txt_idproof = trim($request->input('txt_idproofhd'));
		  }
		  if($_FILES['txt_addressproof']['name']!= '')
		  {
		      $image = $request->file('txt_addressproof');
		      $name = $request->input('txt_membercode').'_ADDRESSPROOF_'.time().'.'.$image->getClientOriginalExtension();
		      $destinationPath = public_path('images/USER_ADDRESSPROOF');
			$FileType = array('jpeg','png','jpg');
			  if(in_array($image->getClientOriginalExtension(), $FileType)) {
		      $image->move($destinationPath, $name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
		      $txt_addressproof =  $name;
		  }
		  else
		  {
		      $txt_addressproof = trim($request->input('txt_addressproofhd'));
		  }
		  
		if($_FILES['txt_aadharfront']['name']!= '')
		{
			$image = $request->file('txt_aadharfront');
			$name = $request->input('txt_membercode')._AADHARFRONT_.time().'.'.$image->getClientOriginalExtension();
			$destinationPath = public_path('images/USER_IDPROOF');
			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
			$image->move($destinationPath, $name);
			}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
			$txt_aadharfront = $name;
		}
		else
		{
			$txt_aadharfront = trim($request->input('txt_aadharfronthd'));
		}

		if($_FILES['txt_aadharback']['name']!= '')
		{
			$image = $request->file('txt_aadharback');
			$name = $request->input('txt_membercode').'_AADHARBACK_'.time().'.'.$image->getClientOriginalExtension();
			$destinationPath = public_path('images/USER_IDPROOF');
			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name);
			}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
			$txt_aadharback = $name;
		}
		else
		{
			$txt_aadharback = trim($request->input('txt_aadharbackhd'));
		}

		 if($txt_yourphoto=='')
			{
				$ERRMSG = "Member image should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('dd_idprooftype')=='' || $request->input('dd_idprooftype')=='-1')
			{
				$ERRMSG = "Id proof type should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			if($request->input('txt_pancard')=='')
			{
				$ERRMSG = "Member pancard should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_aadharcard')=='')
			{
				$ERRMSG = "Aadhar card number should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($txt_aadharfront=='')
			{
				$ERRMSG = "Aadhar front image should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($txt_aadharback=='')
			{
				$ERRMSG = "Aadhar front image should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($txt_idproof=='')
			{
				$ERRMSG = "Id proof should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_address')=='')
			{
				$ERRMSG = "Member address should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('ddaddproof')=='' || $request->input('ddaddproof')=='-1')
			{
				$ERRMSG = "Address proof type should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($txt_addressproof=='')
			{
				$ERRMSG = "Address proof should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('dd_quali')=='' || $request->input('dd_quali')=='-1')
			{
				$ERRMSG = "Qualification type should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
		  else
		  {
		      $ERRMSG = "";
		      $this->isError=FALSE;
		      $ERRCODE="success";
		  }
		  if(request()->method() == 'POST'&& $this->isError==FALSE)
		  {
		      $pancard=$request->input('txt_pancard');
		      $USER=$request->input('txt_userid');
		      $arr = array(
					'm19_uk_user_photo'=>$txt_yourphoto,
					'm19_uk_idproof_type'=>$request->input('dd_idprooftype'),
					'm19_uk_uniqueid_num'=>$request->input('txt_pancard'),
					'm19_uk_aadhar_num'=>$request->input('txt_aadharcard'),
					'm19_uk_aadhar_front'=>$txt_aadharfront,
					'm19_uk_aadhar_back'=>$txt_aadharback,
					'm19_uk_idproofdoc'=>$txt_idproof,
					'm19_uk_address'=>$request->input('txt_address'),
					'm19_uk_addressproof_type'=>$request->input('ddaddproof'),
					'm19_uk_addressproof'=>$txt_addressproof,
					'm19_uk_qualification'=>$request->input('dd_quali')
					);
				$old_values=DB::select("SELECT USER_PH,IDProofType,Pancarno,AadharCard,AadharFront,AadharBack,IDProof,Address,AddProofType1,AddressProof,Qualification FROM user_details WHERE RegId=".$USER."");

				$this->profile_repo->updateKycByUserId($USER, $arr);
		      $user_profile=DB::select("UPDATE m11_user SET m11_user_location='".$request->input('txt_address')."', m11_user_image='".$txt_yourphoto."' WHERE m11_user_code ='".$request->input('txt_membercode')."' and m11_user_id=". $request->input('txt_userid')." AND m11_user_status='ACTIVE'");
		      	$data=$this->match_values($old_values,$arr);
			   $arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => $data[1],
						'tr11_ar_new_value' => $data[0],
						'tr11_ar_uid' => $USER,
						'tr11_ar_description' => 'USER S KYC HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 3,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
				$kyc_actionrecord=$this->log_repo->create($arr);      
		      $ERRMSG="USER'S KYC HAS BEEN CHANGED SUCCESSFULLY!";
		      $ERRCODE='success'; 
		  }
		}
		$USERID=$request->input('txt_membercode');
		$userid = Helper::get_userid($request->input('txt_membercode'));
		if($userid!=FALSE)
		{
		$user = Helper::get_userdetail($userid);
		$get_useralldetail = Helper::get_useralldetail($userid);
		}
		else
		{
		$ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
		$this->isError=TRUE;
		$ERRCODE="warning";
		}
		Session::flash('type',$ERRCODE);
		Session::flash('message',$ERRMSG);
		return view('Employee.edit_userkycdetails',compact('get_useralldetail','USERID'));
	}

	/**
        * Method name   : All User
        * @description  : Used for getting all user details
        * @param        : Request data
        * @return       : return with all user details
    */
	public function all_user()
	{
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$txt_memberids='';
		$cond="";$topupst="ALL";
		$request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		  $start = date('Y-m-d',strtotime($request->input('txt_from')));
		  $end = date('Y-m-d',strtotime($request->input('txt_to')));
		  if($request->input('txt_memberid')!='')
			{
		  $txtuserid = Helper::get_userid($request->input('txt_memberid'));
		  $txt_memberids= $request->input('txt_memberid'); }
		
		  $pos=$request->input('dd_pos');

		  $cond ='';
		  $cond1='';
		      if($txtuserid != '' && $txtuserid != 'false')
		  {
		      $cond = $cond."`m11_user`.`m11_user_id` = $txtuserid  AND ";
		  }
		  if($pos != '' && $pos != '-1')
		  {
		      $cond = $cond."`m11_user`.`m11_user_position` = '".$pos."'  AND ";
		  }
		  if($request->input('rb_topupst')!= '' && $request->input('rb_topupst')!= '-1')
		  {
		      $topupst=$request->input('rb_topupst');
		      if($topupst=="0")
		      $topupst="ALL";
		      if($topupst=="1")
		      $topupst="NO";
		      if($topupst=="2")
		      $topupst="TOPUP";
		  }
		  if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
		  {
		      $cond = $cond."DATE_FORMAT(`m11_user`.`m11_user_onadd`,'%Y-%m-%d')>=
		       DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(`m11_user`.`m11_user_onadd`,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
		  }
		  
		}
		$cond = $cond." 1 ";
		$user=array(
		'proc'=>7,
		'userid'=> $cond,
		);
		$user_report=$this->enroll_repo->getUserByProc($user);
		return view('Employee.all_user', compact('user_report','topupst','start','end','txt_memberids'));
	}

	/**
        * Method name   : Kyc
        * @description  : Used for getting all user kyc details
        * @param        : Request data
        * @return       : return with all user kyc details
    */
	public function kyc()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'KYC REPORT';
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$txt_memberids="";
		$pos="";
		$cond="";$kycst="PENDING";
		$request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		      $start = date('Y-m-d',strtotime($request->input('txt_from')));
		      $end = date('Y-m-d',strtotime($request->input('txt_to')));
		      $txtuserid = Helper::get_userid($request->input('txt_userid'));
			  $txt_memberids=$request->input('txt_userid');
		      $pos=$request->input('dd_pos');
		      $cond ='';
		      $cond1='';
		      if($txtuserid != '' && $txtuserid != 'false')
		      {
		          $cond = $cond."`m11_user`.`m11_user_id` = $txtuserid  AND ";
		      }
		      if($pos != '' && $pos != '-1')
		      {
		          $cond = $cond."`m11_user`.`m11_user_position` = '".$pos."'  AND ";
		      }
		      if($request->input('rb_kycst')!= '' && $request->input('rb_kycst')!= '-1')
		      {
		          $kycst=$request->input('rb_kycst');
		          if($kycst<>"0")
		          $cond = $cond."`m19_user_kyc`.`m19_uk_status` = $kycst  AND ";
		          if($kycst=="0")
		          $kycst="ALL";
		          if($kycst=="2")
		          $kycst="PENDING";
		          if($kycst=="1")
		          $kycst="APPROVED";
		      }
		      if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
		      {
		          $cond = $cond."
		          DATE_FORMAT(`m19_user_kyc`.`m19_uk_onupdate` ,'%Y-%m-%d') >= DATE_FORMAT('".$start."','%Y-%m-%d') AND 
		          DATE_FORMAT(`m19_user_kyc`.`m19_uk_onupdate` ,'%Y-%m-%d') <= DATE_FORMAT('".$end."','%Y-%m-%d') AND ";
		      }
		}
		$cond = $cond."1 AND `m19_user_kyc`.`m19_uk_idproofdoc`<>'' AND `m19_user_kyc`.`m19_uk_uniqueid_num` <>'' AND `m19_user_kyc`.`m19_uk_addressproof`<> '' ORDER BY  `m11_user`.`m11_user_id` DESC";
		$user_kyc=array(
		      'proc'=>4,
		      'userid'=>$cond
		      
		  );
		$userkyc_report=$this->enroll_repo->getUserByProc($user_kyc);
		return view('Employee.kyc', compact('userkyc_report','kycst','start','end','pos','txt_memberids'));
	}

	/**
        * Method name   : Change Password
        * @description  : Used for getting user password
        * @param        : Request data
        * @return       : return user password
    */
	public function change_password()
	{
		$request = request();
		$user = "";
		$USERID="";
		$get_useralldetail = "";
		if($request->method() == 'POST')
		{
		  $userid = Helper::get_userid($request->input('txt_memberid'));
		      if($userid!=FALSE)
		      {
		          $user = Helper::get_userdetail($userid);
		          $get_useralldetail = Helper::get_useralldetail($userid);
		          $ERRMSG = "Member details fetch successfully.";
		          $ERRCODE="success";
		      }
		      else
		      {
		          $ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
		          $this->isError=TRUE;
		          $ERRCODE="warning";
		      }
		}
		$USERID=$request->input('txt_memberid');
		return view('Employee.change_password', compact('USERID','get_useralldetail'));
	}

	/**
        * Method name   : Update User Password
        * @description  : Used for updating user password
        * @param        : Request data
        * @return       : return with updated user password
    */
	public function update_userpassword()
	{
		$request = request();
		$USERID="";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{       
		  if($request->input('txt_oldpassword')=='')
		  {
		      $ERRMSG = "Old Password should be valid or not blank.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  else if($request->input('txt_newpassword')=='')
		  {
		      $ERRMSG = "New Password should be valid or not blank.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  else if(strlen($request->input('txt_newpassword'))<6)
		  {
		      $ERRMSG = "New password length would be greater then 6 or equal 6";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		      
		  }
		  else if($request->input('txt_newcpassword')=='')
		  {
		      $ERRMSG = "Confirm New Password should be valid or not blank.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		      
		  }
		  else if(strlen($request->input('txt_newcpassword'))<6)
		  {
		      $ERRMSG = "New Confirm password length would be greater then 6 or equal 6";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		      
		  }
		  else if($request->input('txt_newpassword')!=$request->input('txt_newcpassword'))
		  {
		      $ERRMSG = "Password does not match with confirm password.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  else
		  {
		      $ERRMSG = "";
		      $this->isError=FALSE;
		      $ERRCODE="success";
		  }
		  if(request()->method() == 'POST' && $this->isError==FALSE)
		  {
		      $password=$request->input('txt_oldpassword');
		      $new_password=$request->input('txt_newpassword');
		      $new_cpassword=$request->input('txt_newcpassword');
		      $USER=$request->input('txt_userid');
		      $user_logindetails=$this->enroll_repo->updateUserPassword($new_password, $password, $USER);
		      if($user_logindetails==1)
		      {
		      	  $arr = array(
						'tr11_ar_tblnm' => 'tr04_login',
						'tr11_ar_old_value' => $password,
						'tr11_ar_new_value' => $new_password,
						'tr11_ar_uid' => $USER,
						'tr11_ar_description' => 'USER S PIN PASSWORD HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 3,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
		      	  $mobileno_actionrecord=$this->log_repo->create($arr);

		          $ERRMSG="USER'S PASSWORD HAS BEEN CHANGED SUCCESSFULLY!";
		          $ERRCODE='success'; 
		      }
		      else
		      {
		          $ERRMSG="USER'S PASSWORD HAS NOT BEEN CHANGED!";
		          $ERRCODE='warning'; 
		      }
		  }
		}
		$USERID=$request->input('txt_membercode');
		$userid = Helper::get_userid($request->input('txt_membercode'));
		if($userid!=FALSE)
		{
		  $user = Helper::get_userdetail($userid);
		  $get_useralldetail = Helper::get_useralldetail($userid);
		}
		else
		{
		  $ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
		  $this->isError=TRUE;
		  $ERRCODE="warning";
		}
		Session::flash('type',$ERRCODE);
		Session::flash('message',$ERRMSG);
		return view('Support.change_password', compact('USERID','get_useralldetail'));
	}

	// FUND REQUEST HERE
	/**
        * Method name   : Fund request
        * @description  : Used for fund request
        * @param        : Request data
        * @return       : return with fund request
    */
	public function fund_request()
	{
		$page = "";
		$form_name = "";
		$fund_req_toadmin=$this->fund_repo->getAll();
		return view('Employee.fund_request', compact('page', 'form_name','fund_req_toadmin'));
	}

	/**
        * Method name   : Fund request update status
        * @description  : Used for fund request update status
        * @param        : Request data
        * @return       : return with fund request update status
    */
	public function fundrequest_updatestatus()
	{
		$request = request();
		$ERRMSG='FUND TRANSFER HERE';
		$ERRCODE='info';
		$isError = FALSE;
		$transfer="";
		  if(request()->method() == 'POST')
		  {
		      if($request->input('txt_mobileno')=='')
		      {
		          $ERRMSG = "Member contact number should be valid or not blank.";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }
		      /*else if(!_valid_phone_number($request->input('txt_mobileno')))
		      {
		          $ERRMSG = "";
		          $isError = TRUE;
		      }*/
		      $contactno=explode(' ',$request->input('txt_mobileno'));
		      //dd($contactno[0]);
		      if(strlen($contactno[0])!=10)
		      {
		          $ERRMSG = "Member contact number should be equal to 10 digit.";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }
		      $user = Helper::get_userid($contactno[0]);
		      if(empty($user))
		      {
		          $ERRMSG = "Member should be valid";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }
		      else if(Session::get('USER_ID')==$user)
		      {
		          $ERRMSG = "Same account has not been transferable.";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }
		      else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
		      {
		          $ERRMSG = "Amount should be greater than 0.00 or not be blank.";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }
		      else if(floatval($request->input('txt_amount'))<0.00)
		      {
		          $ERRMSG = "Amount should be greater than 0.00 or not be negative.";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }
		      if(request()->method() == 'POST'&& $isError==FALSE)
		      {
		          $fund_reqstatus=$request->input('txt_status');
		          $transid="";
		          if($fund_reqstatus=="APPROVED")
		          {
		              $fundtransfer_data=array(
		              'proc'=>2,
		              'to_user_id'=>$user,
		              'from_user_id'=>0,
		              'amount'=>floatval($request->input('txt_amount')),
		              'collected_amount'=>floatval($request->input('txt_amount')),
		              'requesttype'=>1,
		              'balfor'=>1,
		              'transtype'=>1,
		              'timelimit'=>900,
		              'defaultstatus'=>1,
		              'remark'=>$request->input('txt_adminreply'),
		              'collected_remark'=>$request->input('txt_adminreply')
		              );
		              $fundtransfer = $this->fund_repo->walletTransfer($fundtransfer_data);
		              $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
		              $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
		              $transid=$ERRMSG[0]->ERR_MSG;
		              $ERRMSG="Amount ".floatval($request->input('txt_amount'))." ".$transfer. " to ".$contactno[0].", Transaction id-". $ERRMSG[0]->ERR_MSG ." .";
		              $ERRCODE=$ERRCODE[0]->ERR_CODE;
		          }
		          if($fund_reqstatus=="CANCELED")
		          {
		              $ERRCODE="success";
		              $ERRMSG="USERS FUND REQUEST HAS BEEN ". $fund_reqstatus." SUCCESSFULLY!";
		          }
		          $REQID=$request->input('txt_fundrequestid');
		          $user_group=DB::select("UPDATE `tr01_fund_req` SET `tr01_fr_transid`= '".$transid."',`tr01_fr_status`= '".$request->input('txt_status')."',`tr01_fr_admin_res` ='".$request->input('txt_adminreply')."' WHERE `tr01_fr_id` ='".$request->input('txt_fundrequestid')."' AND `m11_user_id`=".$user."");
		          
		          $group_actionrecord=DB::select("INSERT INTO tr11_actionrecord (tr11_ar_tblnm,tr11_ar_old_value,tr11_ar_new_value,tr11_ar_uid,tr11_ar_description) VALUES ('tr01_fund_req','PENDING-FUND REQUEEST ID $REQID','$fund_reqstatus-FUND REQUEEST ID $REQID','$user','USERS FUND REQUEST HAS BEEN $fund_reqstatus SUCCESSFULLY!')");
		          
		      }
		  }
		Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);
		$fund_req_toadmin=DB::select("SELECT * FROM fund_request WHERE FUNDREQ_TO=1");
		return view('Employee.fund_request', compact('fund_req_toadmin'));
	}

	/**
        * Method name   : Fund transfer
        * @description  : Used for fund transfer
        * @param        : Request data
        * @return       : return with fund transfer
    */
	public function fund_transfer()
	{
		$page = "";
		$form_name = "";
		$request = request();
		$isError = FALSE;
		$transfer="";
		  if(request()->method() == 'POST')
		  {
		      if($request->input('ladger')=="")
		      {
		          $ERRMSG = "Ledger should be valid.Please Select Ledger Type ";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }   
		      else if($request->input('baltype')=="")
		      {
		          $ERRMSG = "Balance type should be valid.Please Select Balance Type ";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }   
		      else if($request->input('txt_referralcode')=='')
		      {
		          $ERRMSG = "Member contact number should be valid or not blank.";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }
		      /*else if(!_valid_phone_number($request->input('txt_mobileno')))
		      {
		          $ERRMSG = "";
		          $isError = TRUE;
		      }*/
		      $contactno=$request->input('txt_referralcode');
		      //dd($contactno[0]);
		      
		      $user = Helper::get_userid($contactno);
		      if(empty($user))
		      {
		          $ERRMSG = "Member should be valid";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }
		      else if(Session::get('USER_ID')==$user)
		      {
		          $ERRMSG = "Same account has not been transferable.";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }
		      else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
		      {
		          $ERRMSG = "Amount should be greater than 0.00 or not be blank.";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }
		      else if(floatval($request->input('txt_amount'))<0.00)
		      {
		          $ERRMSG = "Amount should be greater than 0.00 or not be negative.";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }
		      if(request()->method() == 'POST'&& $isError==FALSE)
		      {
		          if($request->input('ladger')==2)
		          $transfer="TRANSFER";
		          if($request->input('ladger')==4)
		          $transfer="DEDUCT";
		          $fundtransfer_data=array(
		          'proc'=>2,
		          'to_user_id'=>$user,
		          'from_user_id'=>0,
		          'amount'=>floatval($request->input('txt_amount')),
		          'collected_amount'=>floatval($request->input('txt_amount')),
		          'requesttype'=>1,
		          'balfor'=>1,
		          'transtype'=>1,
		          'timelimit'=>900,
		          'defaultstatus'=>1,
		          'remark'=>$request->input('txt_remark'),
		          'collected_remark'=>$request->input('txt_remark')
		          );
		          $fundtransfer = $this->fund_repo->walletTransfer($fundtransfer_data);
		          $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
		          $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
		          $ERRMSG="Amount ".floatval($request->input('txt_amount'))." ".$transfer. " to ".$contactno[0].", Transaction id-". $ERRMSG[0]->ERR_MSG ." .";
		          $ERRCODE=$ERRCODE[0]->ERR_CODE;
		      }
		          Session::flash('message',$ERRMSG);
		          Session::flash('type',$ERRCODE);
		  }

		return view('Employee.fund_transfer', compact('page', 'form_name'));
	}

	/**
        * Method name   : Fund transfer store
        * @description  : Used for fund transfer to store
        * @param        : Request data
        * @return       : return with fund transfer to store
    */
	public function fund_transfer_store()
	{
		$page = "";
		$form_name = "";
		$request = request();
		$isError = FALSE;
		$transfer="";
		  if(request()->method() == 'POST')
		  {
		      if($request->input('ladger')=="")
		      {
		          $ERRMSG = "Ledger should be valid.Please Select Ledger Type ";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }   
		      else if($request->input('baltype')=="")
		      {
		          $ERRMSG = "Balance type should be valid.Please Select Balance Type ";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }   
		      else if($request->input('txt_referralcode')=='')
		      {
		          $ERRMSG = "Member contact number should be valid or not blank.";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }
		      /*else if(!_valid_phone_number($request->input('txt_mobileno')))
		      {
		          $ERRMSG = "";
		          $isError = TRUE;
		      }*/
		      $contactno=$request->input('txt_referralcode');
		      //dd($contactno[0]);
		      
		      $store_id = Helper::get_storeid($contactno);
		      if(empty($store_id))
		      {
		          $ERRMSG = "Member should be valid";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }
		      else if(Session::get('USER_ID')==$store_id)
		      {
		          $ERRMSG = "Same account has not been transferable.";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }
		      else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
		      {
		          $ERRMSG = "Amount should be greater than 0.00 or not be blank.";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }
		      else if(floatval($request->input('txt_amount'))<0.00)
		      {
		          $ERRMSG = "Amount should be greater than 0.00 or not be negative.";
		          $isError = TRUE;
		          $ERRCODE="warning";
		      }
		      if(request()->method() == 'POST'&& $isError==FALSE)
		      {
		          if($request->input('ladger')==2)
		          $transfer="TRANSFER";
		          if($request->input('ladger')==4)
		          $transfer="DEDUCT";
		          $fundtransfer_data=array(
		          'proc'=>2,
		          'to_user_id'=>$store_id,
		          'from_user_id'=>0,
		          'amount'=>floatval($request->input('txt_amount')),
		          'collected_amount'=>floatval($request->input('txt_amount')),
		          'requesttype'=>1,
		          'balfor'=>1,
		          'transtype'=>1,
		          'timelimit'=>900,
		          'defaultstatus'=>1,
		          'remark'=>$request->input('txt_remark'),
		          'collected_remark'=>$request->input('txt_remark')
		          );
		          $fundtransfer = $this->fund_repo->storeWalletTransfer($fundtransfer_data);
		          $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
		          $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
		          $ERRMSG="Amount ".floatval($request->input('txt_amount'))." ".$transfer. " to ".$contactno[0].", Transaction id-". $ERRMSG[0]->ERR_MSG ." .";
		          $ERRCODE=$ERRCODE[0]->ERR_CODE;
		      }
		          Session::flash('message',$ERRMSG);
		          Session::flash('type',$ERRCODE);
		  }

		return view('Employee.fund_transfer_store', compact('page', 'form_name'));
	}

	/**
        * Method name   : Main ledger
        * @description  : Used for main ledger report
        * @param        : Request data
        * @return       : return with main ledger report
    */
	public function main_ledger()
	{
		$page = "";
		$form_name = "";
		$request = request();
		$descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
		$txt_account = '';
		$txt_memberid = '';
		$dd_ledgertype='';
		$txt_transid = '';
		$txt_noofrecords = '10000';
		$dd_ledgertype='-1';
		$cond="";
		$cond1=" 1 AND `tr03_bal_type` IN (1)";
		  if($_SERVER['REQUEST_METHOD']=="POST")
		  {
		      $start = date('Y-m-d',strtotime($request->input('txt_datefrom')));
		      $end = date('Y-m-d',strtotime($request->input('txt_dateto')));
		      
		      if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
		      {
		          $txt_account=$request->input('txt_account');
		      }
		      if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
		      {
		          $txt_transid=$request->input('txt_transid');
		      }
		      if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
		      {
		          $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
		      }
		      if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
		      {
		          $txt_noofrecords =$request->input('txt_noofrecords');
		      }
		      if($request->input('dd_ledgertype')!="" && $request->input('dd_ledgertype')!=-1)
		      {
		          $dd_ledgertype=$request->input('dd_ledgertype');
		      }
		      
		  }
		  $cond=$cond.$cond1;
		  $ledgerreport=array(
		      'proc'=>2,
		      'account'=>"0",
		      'transid'=>$txt_transid,'userid'=>$txt_memberid,'fromdate'=>$start,
		      'todate'=>$end,'noofrecords'=>$txt_noofrecords,'ledegerstatus'=>$dd_ledgertype,'descrip'=>$cond
		  );
		  $ledger_report=$this->fund_repo->ledgerReport($ledgerreport);
		return view('Employee.main_ledger', compact('ledger_report','page', 'form_name','start','end','txt_transid','dd_ledgertype','txt_noofrecords'));
	}

	/**
        * Method name   : Fund ledger
        * @description  : Used for fund ledger report
        * @param        : Request data
        * @return       : return with fund ledger report
    */
	public function fund_ledger()
	{
		$page = "";
		$form_name = "";
		$request = request();
		$descrip="";
		$start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
		$txt_account = '';$txt_memberid = '';$txt_transid = '';
		$txt_noofrecords = '100';$dd_ledgertype='-2';
		$cond="";
		$cond1="1 AND `tr03_bal_type`=1 ";
		  if($_SERVER['REQUEST_METHOD']=="POST")
		  {
		      $start = date('Y-m-d',strtotime($request->input('txt_from')));
		      $end = date('Y-m-d',strtotime($request->input('txt_to')));
		      
		      if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
		      {
		          $txt_account=$request->input('txt_account');
		      }
		      if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
		      {
		          $txt_transid=$request->input('txt_transid');
		      }
		      if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
		      {
		          $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
		      }
		      if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
		      {
		          $txt_noofrecords =$request->input('txt_noofrecords');
		      }
		      if($request->input('dd_ledgertype')!="" && $request->input('dd_ledgertype')!=-1)
		      {
		          $dd_ledgertype=$request->input('dd_ledgertype');
		      }
		  }
		  $cond=$cond.$cond1;
		  $ledgerreport=array(
		      'proc'=>2,
		      'account'=>"",
		      'transid'=>$txt_transid,'userid'=>$txt_memberid,'fromdate'=>$start,'todate'=>$end,'noofrecords'=>$txt_noofrecords,'ledegerstatus'=>$dd_ledgertype,'descrip'=>$cond
		  );
		      $ledger_report=$this->fund_repo->ledgerReport($ledgerreport);
		      return view('Employee.fund_ledger', compact('ledger_report','page', 'form_name','start','end','txt_transid','dd_ledgertype','txt_noofrecords'));
	}

	/**
        * Method name   : Payout ledger
        * @description  : Used for payout ledger report
        * @param        : Request data
        * @return       : return with payout ledger report
    */
	public function payout_ledger()
	{
		$page = "";
		$form_name = "";
		$request = request();
		$descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
		$txt_account = '';$txt_memberid = '';
		$txt_transid = '';$txt_noofrecords = '100';
		$dd_ledgertype='-3';$cond="";
		$cond1="1 AND `tr03_bal_type`=2 ";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		  $start = date('Y-m-d',strtotime($request->input('txt_from')));
		  $end = date('Y-m-d',strtotime($request->input('txt_to')));
		  
		  if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
		  {
		      $txt_account=$request->input('txt_account');
		  }
		  if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
		  {
		      $txt_transid=$request->input('txt_transid');
		  }
		  if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
		  {
		      $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
		  }
		  if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
		  {
		      $txt_noofrecords =$request->input('txt_noofrecords');
		  }
		  if($request->input('dd_ledgertype')!="" && $request->input('dd_ledgertype')!=-1)
		  {
		      $dd_ledgertype=$request->input('dd_ledgertype');
		  }
		   
		}
		$cond=$cond.$cond1;
		$ledgerreport=array(
		  'proc'=>2,'account'=>"",'transid'=>$txt_transid,'userid'=>$txt_memberid,'fromdate'=>$start,'todate'=>$end,'noofrecords'=>$txt_noofrecords,'ledegerstatus'=>$dd_ledgertype,'descrip'=>$cond
		);
		$ledger_report=$this->fund_repo->ledgerReport($ledgerreport);
		return view('Employee.payout_ledger', compact('ledger_report','page', 'form_name','start','end','txt_transid','dd_ledgertype','txt_noofrecords'));
	}

	/**
        * Method name   : Payment summary
        * @description  : Used for payment summary
        * @param        : Request data
        * @return       : return with payment summary
    */
	public function payment_summary()
	{
		$page = "";
		$form_name = "";
		$request = request();
		$descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
		$txt_account = '';
		$txt_memberid = '';
		$txt_transid = '';
		$txt_noofrecords = '100';
		$dd_ledgertype='1';
		$cond="";
		$cond1="`tr03_manage_ledger`.`tr03_bal_type`=1";
		  if($_SERVER['REQUEST_METHOD']=="POST")
		  {
		      $start = date('Y-m-d',strtotime($request->input('txt_from')));
		      $end = date('Y-m-d',strtotime($request->input('txt_to')));
		      
		      if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
		      {
		          $txt_account=$request->input('txt_account');
		      }
		      if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
		      {
		          $txt_transid=$request->input('txt_transid');
		      }
		      if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
		      {
		          $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
		      }
		      if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
		      {
		          $txt_noofrecords =$request->input('txt_noofrecords');
		      }
		      if($request->input('dd_ledgertype')!="" && $request->input('dd_ledgertype')!=-1)
		      {
		          $dd_ledgertype=$request->input('dd_ledgertype');
		      }
		       
		  }
		  $cond=$cond.$cond1;
		  $ledgerreport=array(
		      'proc'=>2,'account'=>"",'transid'=>$txt_transid,'userid'=>$txt_memberid,'fromdate'=>$start,
		      'todate'=>$end,'noofrecords'=>$txt_noofrecords,'ledegerstatus'=>$dd_ledgertype,'descrip'=>$cond
		  );
		  $ledger_report=$this->fund_repo->ledgerReport($ledgerreport);
		return view('Employee.payment_summary', compact('ledger_report','page', 'form_name','start','end','txt_transid','dd_ledgertype','txt_noofrecords'));
	}

	// TOPUP REPORT HERE
	/**
        * Method name   : Topup report
        * @description  : Used for topup report
        * @param        : Request data
        * @return       : return with topup report
    */
	public function topup_report()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'USER TOP REPORT VIEW';
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$maemberid = '';
		$pos='';
		$cond="";$topupst="ALL";
		$request = request();
		$cond ='';
		$cond1='';
		if($_SERVER['REQUEST_METHOD']=="GET")
		{
		  $ERRCODE='info';
		  $ERRMSG='USER TOP REPORT TEAM ' ;
		  $top=array(
		      'proc'=>'1',
		      'userid'=>'',
		      'fromdate'=>date('Y-m-d',strtotime('2020-01-01')),
		      'todate'=>date('Y-m-d',strtotime('2022-01-05')),
		      'noofrecords'=>1000,
		      'topstatus'=>-1,
		      'descrip'=>1
		      );
		      $user_rec=$this->topup_repo->callTopupReport($top);
		}
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		  $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
		  $end = date('Y-m-d',strtotime($request->input('txt_todate')));
		  if($request->input('txt_userid')!='')
		  $txtuserid = Helper::get_userid($request->input('txt_userid'));
		 $maemberid = $request->input('txt_userid');
		  $pos=$request->input('dd_pos');

		  if($txtuserid != '' && $txtuserid != 'false')
		  {
		      $txtuserid = Helper::get_userid($request->input('txt_userid'));
		      $cond = $cond."`m11_user`.`m11_user_id` = $txtuserid  AND ";
		  }
		  if($pos != '' && $pos != '-1')
		  {
		      $cond = $cond."`m11_user`.`m11_user_position` = '".$pos."'  AND ";
		  }
		  $cond = $cond." 1 ";

		  //echo $cond;
		    $top=array(
		      'proc'=>'1',
		      'userid'=>$txtuserid,
		      'fromdate'=>date('Y-m-d',strtotime($start)),
		      'todate'=>date('Y-m-d',strtotime($end )),
		      'noofrecords'=>100,
		      'topstatus'=>-1,
		      'descrip'=>$cond
		      );
		      $user_rec=$this->topup_repo->callTopupReport($top);
	          $ERRCODE='success';
	          $ERRMSG='USER TOPUP REPORT' ;

		  Session::flash('type',$ERRCODE );
		  Session::flash('message',$ERRMSG );
		}

		return view('Employee.topup_report',compact('form_name','user_rec','start','end','maemberid','pos') );
	}

	/**
        * Method name   : Buy subscription
        * @description  : Used for buying subscription
        * @param        : Request data
        * @return       : return with buying subscription
    */
	public function buy_subscription()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'TOPUP OR BUY SUBSCRIPTIONS';
		$request = request();
		$descrip="";
		$start = '2021-01-01';
        $end = date('Y-m-d',strtotime(NOW()));
		$txt_account = '';
		$txt_memberid = '';
		$txt_transid = '';
		$txt_noofrecords = '100';
		$dd_status='-1';
		$cond="";
		$cond1="1";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		  if($request->input('txt_referralcode')=="")
		  {
		      $ERRMSG = "Member id should be valid";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  /*$contactno=$request->input('txt_referralcode');

		  $user = Helper::get_userid($contactno);
		  if(empty($user))
		  {
		      $ERRMSG = "Member should be valid";
		      $isError = TRUE;
		      $ERRCODE="warning";
		  }*/
		  else if($request->input('dd_user_forwallet')=="" || $request->input('dd_user_forwallet')=='-1' )
		  {
		      $ERRMSG = "Please select user for wallet deduction.";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  /*else if((floatval($request->input('txt_balance'))=="" || (floatval($request->input('txt_balance'))<0.00) && $request->input('dd_user_forwallet')==0) )
		  {
		      $ERRMSG = "Member balance should be valid";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }*/
		  else if($request->input('dd_package')=="" || $request->input('dd_package')==-1 )
		  {
		      $ERRMSG = "Package should be valid";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  else if(floatval($request->input('txt_packageamt'))=="" || floatval($request->input('txt_packageamt'))==0.00 )
		  {
		      $ERRMSG = "Package amount be valid";
		      $this->isError= TRUE;
		      $ERRCODE="warning";
		  }
		  
		  else
		  {
		      $ERRMSG = "";
		      $this->isError= FALSE;
		      $ERRCODE="success";
		  }
		}
		  if(request()->method() == 'POST' && $this->isError==FALSE)
		  {
		      $topup=array(
		          'proc'=>1,
		          'txt_userid'=>$request->input('txt_referralcode'),
		          'dd_package'=>$request->input('dd_package'),
		          'dd_user_forwallet'=>$request->input('dd_user_forwallet'),
		          'dd_wallet'=>1
		      );
		    $topup_report = $this->topup_repo->callTopup($topup);
		    $DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
		    $DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
		    $ERRCODE=$DB_ERRCODE[0]->ERR_CODE;
		    $ERRMSG=$DB_ERRMSG[0]->ERR_MSG;
		//dd($ERRCODE);
		if( $DB_ERRCODE[0]->ERR_CODE=="success")
		{
		  //$this->send_sms($request->input('txt_mobileno'),$DB_ERRMSG[0]->ERR_MSG);
		}
		Session::flash('type',$ERRCODE );
		Session::flash('message',$ERRMSG );
		}
		if($_SERVER['REQUEST_METHOD']=="GET")
		{
		  $ERRCODE='info';
		  $ERRMSG='TOPUP OR BUY SUBSCRIPTIONS' ;
		}
		$package=DB::select("SELECT * FROM `package` WHERE 1");
		return view('Employee.by_subscription',compact('form_name','package'));
	}

	/**
		* Method name	: Datewise Business Report
		* @description 	: Used for user datewise business report 
		* @param		: request data 
		* @return		: response user datewise business report 
	*/
    public function datewise_business_detail()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'USER TOP REPORT VIEW';
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$cond="";$topupst="ALL";
		$request = request();
		$memberid = '';
		$cond ='';
	    $cond1='';
		if($_SERVER['REQUEST_METHOD']=="GET")
		{

			$cond = $cond." 1 ";
			$ERRCODE='info';
			$ERRMSG='USER TOP REPORT TEAM ' ;
			
		}
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));
			if($request->input('txt_userid')!='')
			$txtuserid = Helper::get_userid($request->input('txt_userid'));
		
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
            {
                $cond = $cond."DATE_FORMAT(`TOPUP_DATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
            }

		    if($txtuserid != '' && $txtuserid != 'false')
			{
				$txtuserid = Helper::get_userid($request->input('txt_userid'));
				
				$cond = $cond."`REG_ID` = $txtuserid  AND ";
			}
			$memberid = $request->input('txt_userid');
			$cond = $cond." 1 ";
		
		}
		$user_rec = DB::select('SELECT * FROM datewise_topupdata WHERE '.$cond);
		
		return view('Employee.datewise_business',compact('form_name','user_rec','start','end','memberid') );
	}

	/**
        * Method name   : User downline
        * @description  : Used for user downline
        * @param        : Request data
        * @return       : return with user downline
    */
	public function user_downline()
	{
		$request = request();
		$cond="";
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
		$memberid ='';
		$pos='';
		if($_SERVER['REQUEST_METHOD']=="GET")
		{
		  $ERRCODE='info';
		  $ERRMSG='USER DOWNLINE VIEW' ;
		  $this->team_repo->getIntroDownlineZero();
		  $level= $this->team_repo->getTmpDownline();
		  $userrec=array(
		          'proc'=>7,
		          'userid'=>'`m11_user`.`m11_user_id` IN (SELECT member_id FROM tmp_downline) AND 1 ORDER BY  `m11_user`.`m11_user_id` DESC',
		      );
		  $user_rec= $this->enroll_repo->getUserByProc($userrec);
		}

		if($_SERVER['REQUEST_METHOD']=="POST")
		{

			$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));

			$pos=$request->input('dd_pos');

			if(($start != '' && $end != '') &&  ($start != '1970-01-01'  &&  $end != '1970-01-01'))
			{

				$cond = $cond."DATE_FORMAT(`CASHBACK_PAYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$start."','%Y-%m-%d') AND";
			}
			if($pos != '' && $pos != '-1')
			{
			  	$cond = $cond."`m11_user`.`m11_user_position` = '".$pos."'  AND ";
			}
			if($request->input('txt_memberid')!="")
			{
			  	$txtuserid = Helper::get_userid($request->input('txt_memberid'));
				$memberid=$request->input('txt_memberid');
				if($txtuserid==false)
				{
					return back();
				}
			  	$this->team_repo->getIntroDownline($txtuserid);
			  	$level= $this->team_repo->getTmpDownline();
			  	$cond = $cond."`m11_user`.`m11_user_id` IN (SELECT member_id FROM tmp_downline) AND 1 ORDER BY  `m11_user`.`m11_user_id` DESC";

			}

		$userrec=array(
			  'proc'=>7,
			  'userid'=>$cond
			);

	      	$user_rec= $this->enroll_repo->getUserByProc($userrec);
	      	if($user_rec){
	      		$ERRCODE='success';
	        	$ERRMSG='USER DOWNLINE' ;	
	      	}
	      	else
		  	{
		  		$ERRCODE='warning';
		  		$ERRMSG = "Member should be valid or not blank";
		  	}
	      	
		  }
		  
		//print_r($user_rec);
		Session::flash('type',$ERRCODE );
		Session::flash('message',$ERRMSG );
		return view('Employee.downline',compact('user_rec','level','start','end','memberid','pos'));
	}

	/**
        * Method name   : Direct referal
        * @description  : Used for direct refferal
        * @param        : Request data
        * @return       : return with direct refferal
    */
	public function direct_referal()
	{
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$pos='';
		$txt_memberids='';
		$cond="";$topupst="ALL";
		$request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		  $start = date('Y-m-d',strtotime($request->input('txtfromdate')));
		  $end = date('Y-m-d',strtotime($request->input('txttodate')));
		  if($request->input('txt_memberid')!='')
		  $txtuserid = Helper::get_userid($request->input('txt_memberid'));
		  $txt_memberids=$request->input('txt_memberid');
		  $pos=$request->input('dd_position');

		  $cond ='';
		  $cond1='';
		  if($txtuserid != '' && $txtuserid != 'false')
		  {
		      $cond = $cond."`m11_user`.`m11_user_referral_code`= $txtuserid  AND ";
		  }
		  if($pos != '' && $pos != '-1')
		  {
		      $cond = $cond."`m11_user`.`m11_user_position` = '".$pos."'  AND ";
		  }
		  if($request->input('rb_topupst')!= '' && $request->input('rb_topupst')!= '-1')
		  {
		      $topupst=$request->input('rb_topupst');
		      if($topupst=="0")
		      $topupst="ALL";
		      if($topupst=="1")
		      $topupst="NO";
		      if($topupst=="2")
		      $topupst="TOPUP";
		  }
		  if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
		  {
		      $cond = $cond."DATE_FORMAT(`m11_user`.`m11_user_onadd`,'%Y-%m-%d')>=
		       DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(`m11_user`.`m11_user_onadd`,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
		  }
		  
		}
		$cond = $cond." 1 ORDER BY  `m11_user`.`m11_user_id` DESC";
		$user=array(
		'proc'=>7,
		'userid'=> $cond,
		);
		$user_rec=$this->enroll_repo->getUserByProc($user);
		return view('Employee.direct_referral',compact('user_rec','topupst','start','end','txt_memberids','pos'));
	}

	/**
			* Method name	: Tree
			* @description 	: Used for getting tree view
			* @param		: request data 
			* @return		: response user tree view
		*/
	public function tree($id = '')
	{
		if($_SERVER['REQUEST_METHOD']=="GET")
		{
		  $pid = $id;
		  $s=1;
		  $call_procedure =  $this->team_repo->getUserAtLevel($id);
		  $tr = $this->team_repo->getByUserId();
		}
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		  $request = request();
		  $id=Helper::get_userid($request->input('search_id'));
		  $pid = $id;
		  $s=1;
		  $call_procedure = $this->team_repo->getUserAtLevel($id);
		  $tr = $this->team_repo->getByUserId();
		}
		return view('Employee.tree',compact('tr', 's','pid'));
	}

	/**
			* Method name	: Cashback bonus
			* @description 	: Used for getting cashback bonus
			* @param		: request data 
			* @return		: response with cashback bonus
		*/
	public function cashbackbonus()
	{
		$request = request();
		$user = Helper::get_userdetail(Session::get('USER_ID'));
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
		$txt_memberids='';
		$txtuserid = '';
		$queery="";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		  $start = date('Y-m-d',strtotime($request->input('txt_from')));
		  $end = date('Y-m-d',strtotime($request->input('txt_to')));
		  if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
		  {
		      $queery = $queery."DATE_FORMAT(`CASHBACK_PAYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
		  }
		}
		//$txtuserid =Session::get('USER_ID');
		//$queery = $queery."`USER_ID` = $txtuserid  AND ";
		$queery = $queery." CASHBACK_STATUS=2 LIMIT 1000";
		$salary_report = $this->closing_repo->getCashbackDates($queery);
		return view('Employee.cashback_bonus',compact('user','salary_report','start','end'));
	}

	/**
			* Method name	: Refferal bonus
			* @description 	: Used for getting refferal bonus
			* @param		: request data 
			* @return		: response with refferal bonus
		*/
	public function refferal_bonus()
	{
		$request = request();
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
		$txtuserid = '';
		$queery="";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		  $start = date('Y-m-d',strtotime($request->input('txt_from')));
		  $end = date('Y-m-d',strtotime($request->input('txt_to')));
		  if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
		  {
		      $queery = $queery."DATE_FORMAT(`DIRECT_ENTRYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
		  }
		}
		$queery = $queery." DIRECT_ISPUBLISH=1 ORDER BY DIRECT_ID DESC";
		$direct_report = $this->closing_repo->directDetails($queery);
		return view('Employee.refferal_bonus',compact('direct_report','start','end'));
	}

	/**
			* Method name	: Binary closing report
			* @description 	: Used for getting binary closing report
			* @param		: request data 
			* @return		: response with binary closing report
		*/
	public function binary_closing_report()
	{

		$request = request();
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
		$txt_account = '';
		$txt_memberid = Session::get('USER_ID');
		$txt_transid = '';
		$txt_noofrecords = '1000';
		$dd_ledgertype='5';
		$cond="";


		$cond1=" 1 ";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		  $start = date('Y-m-d',strtotime($request->input('txtfromdate')));
		  $end = date('Y-m-d',strtotime($request->input('txttodate')));

		  if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
		  {
		      $cond = $cond."DATE_FORMAT(`tr26_to_closing_date`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
		  }
		  $cond=$cond.$cond1;
		}
		if($_SERVER['REQUEST_METHOD']=="GET")
		{
		$cond=$cond.$cond1;
		}

		$payoutreport=array(
		'queery'=>$cond
		);
		$payout_report=$this->closing_repo->payoutReport($payoutreport);
		return view('Employee.matching_bonus', compact('payout_report','start','end'));

	}

	/**
        * Method name   : Binary Closing reverse 
        * @description  : Used for binary closing reverse
        * @param        : Request data  
        * @return       : return with binary closing reverse
    */
	public function binary_closing_reverse()
	{
		$request = request();       
		$generated_report = $this->closing_repo->closingIsPublish();
		return view('Employee.binary_closingreverse', compact('generated_report'));
	}

	/**
        * Method name   : Binary Closing publish 
        * @description  : Used for binary closing publish
        * @param        : Request data  
        * @return       : return with binary closing publish
    */
	public function binary_closing_publish()
	{
		$request = request();       
		$generated_report = $this->closing_repo->closingIsPublish();
		return view('Employee.binary_closingpublish', compact('generated_report'));
	}

	/**
        * Method name   : Binary Closing Userwise 
        * @description  : Used for binary closing userwise report
        * @param        : Request data  
        * @return       : return with binary closing userwise report
    */
	public function binary_closing_userwise()
	{
		$request = request();
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$descrip="";
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txt_account = '';
		$txt_memberid = Session::get('USER_ID');
		$txt_transid = '';
		$txt_noofrecords = '1000';
		$dd_ledgertype='5';
		$cond="";


		$cond1=" 1 ";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		  $start = date('Y-m-d',strtotime($request->input('txtfromdate')));
		  $end = date('Y-m-d',strtotime($request->input('txttodate')));

		  if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
		  {
		      $cond = $cond."DATE_FORMAT(`tr26_to_closing_date`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
		  }
		  if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
		  {
		          $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
		          $cond = $cond."`tr26_closing_detail`.`m11_user_id` = $txt_memberid  AND ";
		  }
		  $cond=$cond.$cond1;
		}
		if($_SERVER['REQUEST_METHOD']=="GET")
		{
		$cond=$cond.$cond1;
		}

		$payoutreport=array(
		'queery'=>$cond
		);
		$payout_report = $this->closing_repo->payoutReport($payoutreport);

		return view('Employee.binary_closinguserwise', compact('payout_report'));

	}

	// PAYMENT module here

    /**
        * Method name   : Payment Report 
        * @description  : Used for payment report
        * @param        : Request data  
        * @return       : return with payment report
    */
	public function payment_report()
	{
		$request = request();

		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		      if($request->input('txt_userid')!="" && $request->input('txt_userid')!="0")
		      {
		          $txt_memberid = Helper::get_userid($request->input('txt_userid'));
		      }   
		      $paymentreport=array(
		      'proc'=>2,
		      'userid'=> $txt_memberid
		      );
		}
		else{
		  $paymentreport=array(
		  'proc'=>1,
		  'userid'=>-1
		  );
		}           

		  
		$payment_release = $this->closing_repo->paymentReport($paymentreport);
		return view('Employee.all_payreport', compact('payment_release'));
	}

	/**
        * Method name   : Payment Release 
        * @description  : Used for payment release
        * @param        : Request data  
        * @return       : return with payment release report
    */
	public function payment_release()
	{
		$request = request();
		$txt_memberid=-1;       
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		      if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
		      {
		          $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
		          
		          $paymentreport=array(
		          'proc'=>2,
		          'userid'=> $txt_memberid
		          );
		      }
		      else
		      {
		              $paymentreport=array(
		              'proc'=>1,
		              'userid'=>$txt_memberid
		              );
		      }

		}
		else
		{
		  $paymentreport=array(
		  'proc'=>1,
		  'userid'=>$txt_memberid
		  );
		}
		$payment_release = $this->closing_repo->paymentReport($paymentreport);
		return view('Employee.payment_release',compact('payment_release'));
	}

	/**
        * Method name   : Pay Payment
        * @description  : Used for paying payment
        * @param        : Request data  
        * @return       : return with paying payment
    */
	public function pay_payment( Request $request )
	{
		$res = $curr_bal = $bal = 0;
		$lid = $request->input('txt_payregid');
		$bal =$request->input('txt_payamt');
		$curr_bal_res = DB::select("select get_available_bal($lid,2) AS BAL");
		$curr_bal_res1 = DB::select("select get_available_bal($lid,1) AS BAL");
		$curr_bal_res3 = DB::select("select get_available_bal($lid,3) AS BAL");
		if(!empty($curr_bal_res)){
		  $curr_bal = $curr_bal_res[0]->BAL;
		  $res = $curr_bal-$bal;
		}
		$transid_arr = DB::select("select get_transaction_id() AS transid");
		if(!empty($transid_arr)){
		  $transid = $transid_arr[0]->transid;
		}
		if($bal != 0){
		  $insert_data = array(
		  'm11_user_id'=>$lid,
		  'tr03_trans_id'=>$transid,
		  'tr03_refrence_id'=>0,
		  'tr03_cramount'=>0,
		  'tr03_dramount'=>$bal,
		  'tr03_deduction'=>$bal,
		  'tr03_ledger_type'=>15,
		  'tr03_bal_type'=>2,
		  'tr03_current_balance'=>$curr_bal_res1[0]->BAL,
		  'tr03_utility_bal'=>$res,
		  'tr03_remit_bal'=>$curr_bal_res3[0]->BAL,
		  'tr03_trans_from'=>$request->input('dd_paymode'),
		  'tr03_description'=>$request->input('txt_remark'),
		  'tr03_trans_onadd'=>date('Y-m-d H:i:s'),
		  'tr03_trans_onupadte'=>date('Y-m-d H:i:s')
		  ); 
		  //print_r($insert_data);
		  $bol  =  DB::table('tr03_manage_ledger')->insert( $insert_data );
		  Session::flash( 'type', 'success' );
		  Session::flash( 'message', 'Payment Done Successfully' );
		} 

		return redirect()->to('payment_release');
	}

	/**
        * Method name   : Payment Release Report
        * @description  : Used for payment release report
        * @param        : Request data  
        * @return       : return with payment release report
    */
	public function payment_release_report()
	{
		$request = request();
		$descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
		$txt_account = '';
		$txt_memberid = "";
		$txt_memberids = "";
		$txt_transid = '';
		$txt_noofrecords = '100';
		$dd_ledgertype='-5';
		$cond="";
		$cond1="1 AND `tr03_bal_type`=2 ";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		  $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
		  $end = date('Y-m-d',strtotime($request->input('txt_todate')));
		  
		 $txt_memberids = $request->input('txt_memberid');

		  if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
		  {
		      $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
		  }
		  if($request->input('dd_ledgertype')!="" && $request->input('dd_ledgertype')!=-1)
		  {
		      $dd_ledgertype=$request->input('dd_ledgertype');
		  }
		  
		}
		$cond=$cond.$cond1;
		$ledgerreport=array(
		'proc'=>2,
		'account'=>"", 
		'transid'=>$txt_transid,
		'userid'=>$txt_memberid,
		'fromdate'=>$start,
		'todate'=>$end,
		'noofrecords'=>$txt_noofrecords,
		'ledegerstatus'=>$dd_ledgertype,
		'descrip'=>$cond

		);
		$ledger_report=$this->fund_repo->ledgerReport($ledgerreport);
		return view('Employee.payrelease_report', compact('ledger_report','start','end','txt_memberids'));

	}	

	/**
			* Method name	: Change Status
			* @description 	: Used for change user status
			* @param		: request data 
			* @return		: response change user status
		*/
	public function change_status()
	{
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txtuserid = '';
		$cond="";
		$status=-1;
		$request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
		      $start = date('Y-m-d',strtotime($request->input('txtfromdate')));
		      $end = date('Y-m-d',strtotime($request->input('txttodate')));
		      if($request->input('txtuserid')!='')
		      $txtuserid = Helper::get_userid($request->input('txtuserid'));
		      $role=$request->input('dd_role');
		      $group=$request->input('dd_group');
		      $status=$request->input('dd_status');
		      $noofrecords=$request->input('txt_noofrecords');
		      $cond ='';
		      $cond1='';
		      if($txtuserid != '' && $txtuserid != 'false')
		      {
		          $cond = $cond."`m11_user`.`m11_user_id` = $txtuserid  AND ";
		      }
		      if($role != '' && $role != '-1')
		      {
		          $cond = $cond."`m11_user`.`m11_user_role` = $role  AND ";
		      }
		      if($group != '' && $group != '-1')
		      {
		          $cond = $cond."`m11_user`.`m16_gr_id`  = $group  AND ";
		      }
		      if($status != '' && $status != '-1')
		      {
		          $cond = $cond."`m11_user`.`m11_user_status`  = $status  AND ";
		      }
		      if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
		      {
		          $cond = $cond."DATE_FORMAT(`m11_user`.`m11_user_onadd`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
		      }
		      
		}
		$cond = $cond." 1 ";
		      $user=array(
		              'proc'=>8,
		              'userid'=> $cond
		          );
		$user_report=$this->enroll_repo->getUserByProc($user);
		return view('Employee.change_status', compact('user_report','status'));
	}

	/**
			* Method name	: Change Mobile no
			* @description 	: Used for change user mobile number
			* @param		: request data 
			* @return		: response change user mobile number
		*/
	public function change_mobileno()
	{
		$request = request();
		$user = "";
		$USERID="";
		$get_useralldetail = "";
		if($request->method() == 'POST')
		{
		  $userid = Helper::get_userid($request->input('txt_memberid'));
		      if($userid!=FALSE)
		      {
		          $user = Helper::get_userdetail($userid);
		          $get_useralldetail = Helper::get_useralldetail($userid);
		          $ERRMSG = "Member details fetch successfully.";
		          $ERRCODE="success";
		      }
		      else
		      {
		          $ERRMSG = "Member Id or Mobile is not registered with us.Please check mobile no.";
		          $this->isError=TRUE;
		          $ERRCODE="warning";
		      }
		}
		$USERID=$request->input('txt_memberid');
		return view('Employee.change_mobileno', compact('USERID','get_useralldetail'));
	}

	/**
			* Method name	: Update Mobile no
			* @description 	: Used for change user mobile number
			* @param		: request data 
			* @return		: response change user mobile number
		*/
	public function update_usermobileno()
    {
        $page = 'PROFILE PANEL';
        $form_name = 'CHANGE USER MOBILE NO';
		$groupid = '';
		$user = "";
		$USERID="";
		$get_useralldetail = "";
        $request = request();
		if($_SERVER['REQUEST_METHOD']=="POST")
		{		
				if($request->input('txt_usermobileno')=='')
				{
					$ERRMSG = "Member contact number should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				$contactno=explode(' ',$request->input('txt_usermobileno'));
				if(strlen($contactno[0])<10 || strlen($contactno[0])>10)
				{
					$ERRMSG = "Member contact number should be equal to 10 digit.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_newmobileno')=='')
				{
					$ERRMSG = "Member new contact number should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(strlen($request->input('txt_newmobileno'))<10)
				{
					$ERRMSG = "Member new contact number should be sequal to 10 digit.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(strlen($request->input('txt_newmobileno'))>10)
				{
					$ERRMSG = "Member new contact number should be equal to 10 digit.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				if($this->isError==FALSE)
				{
					$user = Helper::getuserdetail_ByMobileNo($contactno[0]);
					$user1 = Helper::getuserdetail_ByMobileNo($request->input('txt_newmobileno'));
					
					if(empty($user))
					{
						$ERRMSG = "Member should be valid or active.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(Session::get('USER_ID')==$user)
					{
						$ERRMSG = "Same account has not been accessable.";
						$this->isError= TRUE;
						$ERRCODE="warning";
					}
					else if(!empty($user1))
					{
						$ERRMSG  = "Member new contact number already exists with us.Please try different mobile no.";
						$this->isError= TRUE;
						$ERRCODE = "warning";
					}
					else
					{
						$new_mobileno=$request->input('txt_newmobileno');
						$old_mobileno=$contactno[0];
						$ERRMSG = "";
						$this->isError=FALSE;
						$ERRCODE="success";
					}
					//dd($ERRMSG);
				}
				
				//dd($this->isError);
				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$user_mobileno=$this->enroll_repo->updateUserMobile($new_mobileno, $old_mobileno, $user[0]->RegId);
					$user_logindetails=$this->enroll_repo->updateUserTrans($new_mobileno, $old_mobileno, $user[0]->RegId);
					$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => $old_mobileno,
						'tr11_ar_new_value' => $new_mobileno,
						'tr11_ar_uid' =>  $user[0]->RegId,
						'tr11_ar_description' => 'USERS MOBILE NO HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 3,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
					$mobileno_actionrecord=$this->log_repo->create($arr);
					$ERRMSG="USER'S MOBILE NO HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
				}

		}
		
		
		Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);
		return redirect('/emp_change_mobileno');
	}

	/**
			* Method name	: Pending recharge report
			* @description 	: Used for pending recharge report
			* @param		: request data 
			* @return		: response with pending recharge report
		*/
	public function pending_recharge_report ()
	{
		$page = 'PENDING REPORT PANEL';
		$form_name = 'RECHARGE REPORT';
		$request = request();
		$descrip="";
		$start = date('Y-m-d',strtotime('2021-01-01'));
        $end = date('Y-m-d',strtotime(NOW()));
		$txt_account = '';
		$txt_memberid = '';
		$txt_transid = '';
		$txt_noofrecords = '100';
		$dd_status='2';
		$cond="";
		$cond1="`m07_service_id` IN(1,2,3) AND 1";
		    if($_SERVER['REQUEST_METHOD']=="POST")
		    {
		  $start = date('Y-m-d',strtotime($request->input('txt_from')));
		$end = date('Y-m-d',strtotime($request->input('txt_to')));

		if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
		{
		  $txt_account=$request->input('txt_account');
		}
		if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
		{
		  $txt_transid=$request->input('txt_transid');
		}
		if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
		{
		  $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
		}
		if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
		{
		  $txt_noofrecords =$request->input('txt_noofrecords');
		}
		/*if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
		{
		  $dd_status=$request->input('dd_status');
		}*/
		if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
		{
		  $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
		}
		if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
		{
		  $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
		}

		}
		$cond=$cond.$cond1;
		$recereport=array
		(
		 'proc'=>2,
		  'account'=>$txt_account,
		  'transid'=>$txt_transid,
		  'userid'=>$txt_memberid,
		  'fromdate'=>$start,
		  'todate'=>$end,
		  'noofrecords'=>$txt_noofrecords,
		  'recstatus'=>$dd_status,
		  'descrip'=>$cond
		);
		//dd($recereport);
		$rec_report =$this->rech_reprt_repo->rechargeReport($recereport);
		//dd($recereport);
		//dd($rec_report);
		$OPERATOR = Helper::get_operator(-2,'ACTIVE');
		$API = Helper::get_api(1,'ACTIVE');
		Session::flash('message',"Recharge Report Fetch Succesfully");
		return view('Employee.pending_recharge_report', compact('rec_report','page', 'form_name','OPERATOR','API'));
	}

	///// MONEY TRANSFER REPORT//////////////////

	/**
			* Method name	: Money transfer report
			* @description 	: Used for money transfer report
			* @param		: request data 
			* @return		: response with money transfer report
		*/
	public function moneytransfer_report ()
	{
		$page = 'REPORT PANEL';
		$form_name = 'MOENY TRANSFER REPORT';
		$request = request();
		$descrip="";
		$start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
		$txt_account = '';
		$txt_memberid = '';
		$txt_transid = '';
		$txt_noofrecords = '100';
		$dd_status='-1';
		$cond="";
		$cond1="1";
		  if($_SERVER['REQUEST_METHOD']=="POST")
		  {
		$start = date('Y-m-d',strtotime($request->input('txt_from')));
		$end = date('Y-m-d',strtotime($request->input('txt_to')));

		if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
		{
		$txt_account=$request->input('txt_account');
		}
		if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
		{
		$txt_transid=$request->input('txt_transid');
		}
		if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
		{
		$txt_memberid = Helper::get_userid($request->input('txt_memberid'));
		}
		if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
		{
		$txt_noofrecords =$request->input('txt_noofrecords');
		}
		if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
		{
		$dd_status=$request->input('dd_status');
		}


		}
		$cond=$cond.$cond1;
		$dmtreport=array
		(
		  'proc'=>1,
		'account'=>$txt_account,
		'transid'=>$txt_transid,
		'userid'=>$txt_memberid,
		'fromdate'=>$start,
		'todate'=>$end,
		'noofrecords'=>$txt_noofrecords,
		'recstatus'=>$dd_status,
		'descrip'=>$cond
		);

		$dmt_report = $this->dmt_reprt_repo->dmrReport($dmtreport);

		Session::flash('message',"Recharge Report Fetch Succesfully");
		return view('Employee.dmt_report', compact('dmt_report','page', 'form_name'));
	}

	/**
			* Method name	: Pending money transfer report
			* @description 	: Used for pending money transfer report
			* @param		: request data 
			* @return		: response with pending money transfer report
		*/
	public function pending_moneytransfer_report ()
	{
		$page = 'REPORT PANEL';
		$form_name = 'PENDING MONEY TRANSFER REPORT';
		$request = request();
		$descrip="";
		$start = date('Y-m-d',strtotime('2021-01-01'));
        $end = date('Y-m-d',strtotime(NOW()));
		$txt_account = '';
		$txt_memberid = '';
		$txt_transid = '';
		$txt_noofrecords = '100';
		$dd_status='2';
		$cond="";
		$cond1="1";
		    if($_SERVER['REQUEST_METHOD']=="POST")
		    {
		  $start = date('Y-m-d',strtotime($request->input('txt_from')));
		$end = date('Y-m-d',strtotime($request->input('txt_to')));

		if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
		{
		  $txt_account=$request->input('txt_account');
		}
		if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
		{
		  $txt_transid=$request->input('txt_transid');
		}
		if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
		{
		  $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
		}
		if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
		{
		  $txt_noofrecords =$request->input('txt_noofrecords');
		}
		if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
		{
		  $dd_status=$request->input('dd_status');
		}

		 
		}
		$cond=$cond.$cond1;
		$dmtreport=array
		 (
		    'proc'=>1,
		  'account'=>$txt_account,
		  'transid'=>$txt_transid,
		  'userid'=>$txt_memberid,
		  'fromdate'=>$start,
		  'todate'=>$end,
		  'noofrecords'=>$txt_noofrecords,
		  'recstatus'=>$dd_status,
		  'descrip'=>$cond
		);
		$dmt_report = $this->dmt_reprt_repo->dmrReport($dmtreport);
		Session::flash('message',"Pending Money Transfer Report Fetch Succesfully");
		return view('Employee.pendingdmt_report', compact('dmt_report','page', 'form_name'));
	}

	/**
			* Method name	: Refund recharge
			* @description 	: Used for refund recharge
			* @param		: request data 
			* @return		: response with refund recharge
		*/
	public function refund_recharge()
	{
		$page = 'REPORT PANEL';
		$form_name = 'RECHARGE REFUND ID UPDATE HERE';
		$request = request();
		$descrip="";
			$start = date('Y-m-d',strtotime('2021-01-01'));
        $end = date('Y-m-d',strtotime(NOW()));
		$txt_account = '';
		$txt_memberid = '';
		$txt_transid = '';
		$txt_noofrecords = '100';
		$dd_status='-1';
		$cond="1";
		$cond1="1";


		    if($_SERVER['REQUEST_METHOD']=="POST")
		    {     

		if($request->input('txt_pendingtxnid')=="")
		{
		  $ERRMSG = "Recharge transaction id  should be valid or not blank.";
		  $this->isError = TRUE;
		  $ERRCODE="warning";
		}
		else if($request->input('txt_pendingoperaterid')=="")
		{
		  $ERRMSG = "Live Id should be valid or not blank.";
		  $this->isError = TRUE;
		  $ERRCODE="warning";
		}
		else
		{
		  $ERRMSG = "";
		  $this->isError = FALSE;
		  $ERRCODE="";
		}
		  if($this->isError==FALSE)
		  {
		    $TRANSID=$request->input('txt_pendingtxnid');
		    
		    $txt_status=$request->input('txt_pendingstatus');
		    
		    
		      $recereport=array
		         (
		         'proc'=>2,
		          'account'=>$txt_account,
		          'transid'=>$TRANSID,
		          'userid'=>$txt_memberid,
		          'fromdate'=>$start,
		          'todate'=>$end,
		          'noofrecords'=>$txt_noofrecords,
		          'recstatus'=>-1,
		          'descrip'=>$cond,
		          'msg'=>@msg
		        );
		       $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);

		       $m=$rec_report[0]->MemberID;
		       $id=$rec_report[0]->UserID;
		       $rqd=$rec_report[0]->Transactionid;
		       $account=$rec_report[0]->Account;
		       $op=$rec_report[0]->ServiceProvider;
		       $mode=$rec_report[0]->Mode;
		       $amt=$rec_report[0]->Amount;
		       $agentid=$rec_report[0]->APITransactionid;
		       $operid=$request->input('txt_pendingoperaterid');
		      if($txt_status=="SUCCESS")
		      {
		        $status1="SUCCESS";
		        $status2=1;
		      }
		      if($txt_status=="PENDING")
		      {
		        $status1="PENDING";
		        $status2=2;
		      }
		      if($txt_status=="FOR REFUND")
		      {
		        $status1="FOR REFUND";
		        $status2=3;
		      }
		      if($txt_status=="FAILURE")
		      {
		        $status1="FAILED";
		        $status2=4;
		      }
		      if($txt_status=="REFUNDED")
		      {
		        $status1="REFUNDED";
		        $status2=5;
		      }
		      if($txt_status=="REJECT")
		      {
		        $status1="REJECT";
		        $status2=6;
		      }
		      if($txt_status=="RSUCCESS")
		      {
		        $status1="RSUCCESS";
		        $status2=7;
		      }
		      $respreport=array(
		            'proc'=>1,
		            'userid'=>$id,
		            'account'=>$account,
		            'transid'=>$rqd,
		            'liveid'=>$operid,
		            'amt'=>$amt,
		            'recstatus'=>$status2,
		            'descrip'=>'1'
		          );
		      $resp_report = $this->rech_reprt_repo->rechargeStatusUpdate($respreport);
		       
		       $ERRMSG=DB::select('SELECT @msg as ERR_MSG');
		       //dd($ERRMSG);
		       //Return($resp_report);
		  }
		}
		return 1;
	}

	/**
			* Method name	: Refund dmt
			* @description 	: Used for refund dmt
			* @param		: request data 
			* @return		: response with refund dmt
		*/
	public function refund_dmt()
	{
		$page = 'REPORT PANEL';
		$form_name = 'MONEY TARNSFER REFUND UPDATE HERE';
		$request = request();
		$descrip="";
		$start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
		$txt_account = '';
		$txt_memberid = '';
		$txt_transid = '';
		$txt_noofrecords = '100';
		$dd_status='-1';
		$cond="1";
		$cond1="1";

		    if($_SERVER['REQUEST_METHOD']=="POST")
		    {     
		if($request->input('txt_transid')=="")
		{
		  $ERRMSG = "Money Trasnfer transaction id  should be valid or not blank.";
		  $this->isError = TRUE;
		  $ERRCODE="warning";
		}
		else if($request->input('txt_impsrefno')=="")
		{
		  $ERRMSG = "IMPS RefNo should be valid or not blank.";
		  $this->isError = TRUE;
		  $ERRCODE="warning";
		}
		else
		{
		  $ERRMSG = "";
		  $this->isError = FALSE;
		  $ERRCODE="";
		}
		if($this->isError==FALSE)
		{
		  $TRANSID=$request->input('txt_transid');
		  $txt_status=$request->input('txt_status');
		  $recereport=array
		  (
		            'proc'=>1,
		          'account'=>$txt_account,
		          'transid'=>$TRANSID,
		          'userid'=>$txt_memberid,
		          'fromdate'=>$start,
		          'todate'=>$end,
		          'noofrecords'=>$txt_noofrecords,
		          'recstatus'=>-1,
		          'descrip'=>$cond,
		          'msg'=>@msg
		        );
		       $rec_report = $this->rech_reprt_repo->dmrReport($recereport);

		       $m=$rec_report[0]->MemberContactNo;
		       $id=$rec_report[0]->Memberid;
		       $rqd=$rec_report[0]->Transactionid;
		       $account=$rec_report[0]->Account_number;
		       $amt=$rec_report[0]->Amount;
		      //echo $amt;
		      
		       $operid=$request->input('txt_impsrefno');
		      if($txt_status=="SUCCESS")
		      {
		        $status1="SUCCESS";
		        $status2=1;
		      }
		      if($txt_status=="PENDING")
		      {
		        $status1="PENDING";
		        $status2=2;
		      }
		      if($txt_status=="FOR REFUND")
		      {
		        $status1="FOR REFUND";
		        $status2=3;
		      }
		      if($txt_status=="FAILURE")
		      {
		        $status1="FAILED";
		        $status2=4;
		      }
		      if($txt_status=="REFUNDED")
		      {
		        $status1="REFUNDED";
		        $status2=5;
		      }
		      if($txt_status=="RSUCCESS")
		      {
		        $status1="RSUCCESS";
		        $status2=7;
		      }
		      $respreport=array(
		            'proc'=>2,
		            'userid'=>$id,
		            'account'=>$account,
		            'transid'=>$rqd,
		            'liveid'=>$operid,
		            'amt'=>$amt,
		            'recstatus'=>$status2,
		            'descrip'=>'1'
		          );
		      $resp_report = $this->rech_reprt_repo->dmrStatusUpdate($respreport);
		       
		       $ERRMSG=DB::select('SELECT @msg as ERR_MSG');
		      // dd($ERRMSG);
		       //return($resp_report);
		  }
		}
		return 1;
	}


	/////////////////////// MONEY TRANSFER /////////////////////////////

	/**
			* Method name	: Update dmttid
			* @description 	: Used for update dmttid
			* @param		: request data 
			* @return		: response with update dmttid
		*/
  	public function update_dmttid()
	{
		$page = 'REPORT PANEL';
		$form_name = 'MONEY TARNSFER IMPS REFNO UPDATE HERE';
		$request = request();
		$descrip="";
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txt_account = '';
		$txt_memberid = '';
		$txt_transid = '';
		$txt_noofrecords = '100';
		$dd_status='-1';
		$cond="1";
		$cond1="1";


		    if($_SERVER['REQUEST_METHOD']=="POST")
		    {     
		if($request->input('txt_transid')=="")
		{
		  $ERRMSG = "Money Trasnfer transaction id  should be valid or not blank.";
		  $this->isError = TRUE;
		  $ERRCODE="warning";
		}
		else if($request->input('txt_dmtid')=="")
		{
		  $ERRMSG = "Money Trasnfer id  should be valid or not blank.";
		  $this->isError = TRUE;
		  $ERRCODE="warning";
		}
		else if($request->input('txt_impsrefno')=="")
		{
		  $ERRMSG = "IMPS RefNo should be valid or not blank.";
		  $this->isError = TRUE;
		  $ERRCODE="warning";
		}
		else
		{
		  $ERRMSG = "";
		  $this->isError = FALSE;
		  $ERRCODE="";
		}
		  if($this->isError==FALSE)
		  {
		    $TRANSID=$request->input('txt_transid');
		    $txt_status=-1;
		      $recereport=array
		         (
		            'proc'=>1,
		          'account'=>$txt_account,
		          'transid'=>$TRANSID,
		          'userid'=>$txt_memberid,
		          'fromdate'=>$start,
		          'todate'=>$end,
		          'noofrecords'=>$txt_noofrecords,
		          'recstatus'=>$txt_status,
		          'descrip'=>$cond,
		          'msg'=>@msg
		        );
		       $rec_report = $this->rech_reprt_repo->dmrReport($recereport);
		      
		       $m=$rec_report[0]->MemberContactNo;
		       $id=$rec_report[0]->Memberid;
		       $rqd=$rec_report[0]->Transactionid;
		       $account=$rec_report[0]->Account_number;
		       $amt=$rec_report[0]->Amount;
		       $operid=$request->input('txt_impsrefno');
		       $status1="SUCCESS";
		       $status2=1;
		      $respreport=array(
		            'proc'=>2,
		            'userid'=>$id,
		            'account'=>$account,
		            'transid'=>$rqd,
		            'liveid'=>$operid,
		            'amt'=>$amt,
		            'recstatus'=>$status2,
		            'descrip'=>'1'
		          );
		      $resp_report = $this->rech_reprt_repo->dmrStatusUpdate($respreport);
		       $ERRMSG=DB::select('SELECT @msg as ERR_MSG');
		       //dd($ERRMSG);
		       //return($resp_report);
		  }
		}
		return 1;
	}

	/**
			* Method name	: Search recharge
			* @description 	: Used for search recharge
			* @param		: request data 
			* @return		: response with search recharge
		*/
	public function search_recharge()
	{
		$page = 'REPORT PANEL';
		$form_name = 'RECHARGE REPORT';
		$request = request();
		$descrip="";
		$start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
		$txt_account = '';
		$txt_memberid = '';
		$txt_transid = '';
		$txt_noofrecords = '100';
		$dd_status='-1';
		$cond="";
		$cond1="`m07_service_id` IN(1,2,3) AND 1";
		    if($_SERVER['REQUEST_METHOD']=="POST")
		    {
		  $start = date('Y-m-d',strtotime($request->input('txt_from')));
		$end = date('Y-m-d',strtotime($request->input('txt_to')));

		if($request->input('txt_contactno')!="" && $request->input('txt_contactno')!="0")
		{
		  $txt_account=$request->input('txt_contactno');
		}
		if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
		{
		  $txt_transid=$request->input('txt_transid');
		}
		if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
		{
		  $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
		}
		if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
		{
		  $txt_noofrecords =$request->input('txt_noofrecords');
		}
		if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
		{
		  $dd_status=$request->input('dd_status');
		}
		if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
		{
		  $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
		}
		if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
		{
		  $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
		}

		}
		$cond=$cond.$cond1;
		$recereport=array
		 (
		 'proc'=>2,
		  'account'=>$txt_account,
		  'transid'=>$txt_transid,
		  'userid'=>$txt_memberid,
		  'fromdate'=>$start,
		  'todate'=>$end,
		  'noofrecords'=>$txt_noofrecords,
		  'recstatus'=>$dd_status,
		  'descrip'=>$cond
		);
		//dd($recereport);
		$rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
		//dd($recereport);
		//dd($rec_report);
		$OPERATOR = Helper::get_operator(-2,'ACTIVE');
		$API = Helper::get_api(1,'ACTIVE');
		Session::flash('message',"Recharge Report Fetch Succesfully");
		return view('Employee.search_recharge', compact('rec_report','page', 'form_name','OPERATOR','API'));
	}

	/**
			* Method name	: Search dmt
			* @description 	: Used for search dmt
			* @param		: request data 
			* @return		: response with search dmt
		*/
	public function search_dmt ()
	{
		$page = 'REPORT PANEL';
		$form_name = 'MOENY TRANSFER REPORT';
		$request = request();
		$descrip="";
		$start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));;
		$end ='1970-01-01';
		$txt_account = '';
		$txt_memberid = '';
		$txt_transid = '';
		$txt_noofrecords = '100';
		$dd_status='-1';
		$cond="";
		$cond1="1";
		    if($_SERVER['REQUEST_METHOD']=="POST")
		    {
		  $start = date('Y-m-d',strtotime($request->input('txt_from')));
		$end = date('Y-m-d',strtotime($request->input('txt_to')));

		if($request->input('txt_contactno')!="" && $request->input('txt_contactno')!="0")
		{
		  $txt_account=$request->input('txt_contactno');
		}
		if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
		{
		  $txt_transid=$request->input('txt_transid');
		}
		if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
		{
		  $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
		}
		if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
		{
		  $txt_noofrecords =$request->input('txt_noofrecords');
		}
		if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
		{
		  $dd_status=$request->input('dd_status');
		}


		}
		$cond=$cond.$cond1;
		$dmtreport=array
		 (
		    'proc'=>1,
		  'account'=>$txt_account,
		  'transid'=>$txt_transid,
		  'userid'=>$txt_memberid,
		  'fromdate'=>$start,
		  'todate'=>$end,
		  'noofrecords'=>$txt_noofrecords,
		  'recstatus'=>$dd_status,
		  'descrip'=>$cond
		);

	    $dmt_report = $this->rech_reprt_repo->dmrReport($dmtreport);


		Session::flash('message',"Recharge Report Fetch Succesfully");
		return view('Employee.search_dmt', compact('dmt_report','page', 'form_name'));
	}


	// EMPLOYEE SLAB CONTROLLER HERE
	/**
        * Method name   : Create slab
        * @description  : Used for creating slab
        * @param        : Request data 
        * @return       : return created slab
    */
    public function create_slab($id = "")
    {
    	$single_slab = "";
  		$slab = $this->slab_repo->getAll();
  		if($id != ""){
  			$single_slab = $this->slab_repo->getById($id);
  		}
    	return view('Employee.create_slab', compact('slab', 'single_slab'));
    }

    /**
        * Method name   : Create slab
        * @description  : Used for creating slab
        * @param        : Request data 
        * @return       : return created slab
    */
    public function add_slab()
    {
    	$request = request();

    	$this->validate($request, [
            'txt_group_name'=> 'required',
            'dd_type' => 'required'
        ],[
            'txt_group_name.required'=> 'Group name is required',
            'dd_type.required' => 'Group type is required'     
        ]);

    	$arr = array(
    		'm22_affiliate_id' => 0,
    		'm16_gr_name' => $request->input('txt_group_name'),
    		'm16_gr_type' => $request->input('dd_type'),
    		'm16_gr_status' => 1
    		);

    	$group_id = $this->slab_repo->create($arr);

    	$arr1 = array(
			'proc'=> 8,
			'userid' => $group_id,
			'telecombrandid' => 0,
			'desig' => '',
			'apiid' => 0
		);

    	$this->slab_repo->createSlabMargin($arr1);
    	return redirect('/emp_create_slab');
    }

    /**
        * Method name   : Update slab
        * @description  : Used for updating slab
        * @param        : Request data 
        * @return       : return updated slab
    */
    public function update_slab($id)
    {
    	$request = request();

    	$this->validate($request, [
            'txt_group_name'=> 'required'
        ],[
            'txt_group_name.required'=> 'Group name is required'  
        ]);

    	$arr = array(
    		'm16_gr_name' => $request->input('txt_group_name')
    		);

    	$this->slab_repo->update($id, $arr);
    	return redirect('/emp_create_slab');
    }

    /**
        * Method name   : Slab status
        * @description  : Used for updating slab status
        * @param        : Request data 
        * @return       : return updated slab status
    */
    public function slab_status()
    {
    	$request = request();
    	$id = $request->input('txt_slab_id');
    	$this->slab_repo->active($id);
    	return redirect('/emp_create_slab');
    }

    /**
        * Method name   : Prepaid margin
        * @description  : Used for prepaid margin
        * @param        : Request data 
        * @return       : return prepaid margin
    */
    public function prepaid_margin()
    {
    	$request = request();

    	$slab = $this->slab_repo->getAll();
    	$OPERATOR = Helper::get_operator(-1,'ALL');

    	if($request->method() == 'POST')
        {
        	$grid = $request->input('dd_group');
        	$opid = $request->input('dd_operator');

        	$arr1 = array(
				'proc'=>1,
				'userid' => $grid,
				'telecombrandid' => $opid,
				'desig' => '',
				'apiid' => 0
			);
       	} 	
       	else{

       		$grid = 1;
        	$opid = 0;

       		$arr1 = array(
				'proc'=>1,
				'userid' => $grid,
				'telecombrandid' => $opid,
				'desig' => '',
				'apiid' => 0
			);
       	}
	    	

		$margin = $this->slab_repo->createSlabMargin($arr1);
		//dd($margin);
    	return view('Employee.prepaid_margin', compact('slab', 'OPERATOR', 'margin'));
    }

    /**
        * Method name   : Prepaid margin
        * @description  : Used for prepaid margin
        * @param        : Request data 
        * @return       : return prepaid margin
    */
    public function update_margin()
    {
        $request = request();
        $id = $request->ids;      
        $value = $request->values;
        $method = $request->methods;
        $type = $request->types;
        $count = count($id);

        for($i=0; $i<$count ; $i++){
            $arr = array(
                'tr06_grop_margin' => $value[$i],
                'tr06_group_margin_distri' => $method[$i],
                'tr06_group_margin_type' => $type[$i]
            );
            $this->slab_repo->updatePrepaidMarginSW($id[$i], $arr);
        }
        
    	return 1;
    }


    /**
        * Method name   : Utility surcharge
        * @description  : Used for utility surcharge report
        * @param        : Request data 
        * @return       : return utility surcharge report
    */
    public function utility_surcharge()
    {
        $request = request();

        $slab = $this->slab_repo->getAll();
        $OPERATOR = Helper::get_operator(-1,'ALL');

        if($request->method() == 'POST')
        {
            $grid = $request->input('dd_group');
            $opid = $request->input('dd_operator');

            $arr1 = array(
                'proc'=>6,
                'userid' => $grid,
                'telecombrandid' => $opid,
                'desig' => '',
                'apiid' => 0
            );
        }   
        else{

            $grid = 1;
            $opid = 0;

            $arr1 = array(
                'proc'=>6,
                'userid' => $grid,
                'telecombrandid' => $opid,
                'desig' => '',
                'apiid' => 0
            );
        }
            
        $margin = $this->slab_repo->createSlabMargin($arr1);
    	return view('Employee.utility_surcharge', compact('slab', 'OPERATOR', 'margin'));
    }

    /**
        * Method name   : Dmr surcharge
        * @description  : Used for dmr surcharge report
        * @param        : Request data 
        * @return       : return dmr surcharge report
    */
    public function dmr_surcharge()
    {
        $request = request();

        $slab = $this->slab_repo->getAll();
        $OPERATOR = Helper::get_operator(-1,'ALL');

        if($request->method() == 'POST')
        {
            $grid = $request->input('dd_group');
            $opid = $request->input('dd_operator');

            $arr1 = array(
                'proc'=>7,
                'userid' => $grid,
                'telecombrandid' => $opid,
                'desig' => '',
                'apiid' => 0
            );
        }   
        else{

            $grid = 1;
            $opid = 0;

            $arr1 = array(
                'proc'=>7,
                'userid' => $grid,
                'telecombrandid' => $opid,
                'desig' => '',
                'apiid' => 0
            );
        }
            
        $margin = $this->slab_repo->createSlabMargin($arr1);
    	return view('Employee.dmr_surcharge', compact('slab', 'OPERATOR', 'margin'));
    }

    /**
        * Method name   : Prepaid api sequence
        * @description  : Used for prepaid api sequence
        * @param        : Request data 
        * @return       : return prepaid api sequence
    */
    public function prepaidapi_sequences()
    {
        $request = request();

        $api = $this->api_repo->getAll();
        $slab = $this->slab_repo->getAll();
        $OPERATOR = Helper::get_operator(-1,'ALL');

        if($request->method() == 'POST')
        {
            $grid = $request->input('dd_group');
            $opid = $request->input('dd_operator');

            $arr1 = array(
                'proc'=>2,
                'userid' => $grid,
                'telecombrandid' => $opid,
                'desig' => '',
                'apiid' => 0
            );
        }   
        else{

            $grid = 1;
            $opid = 0;

            $arr1 = array(
                'proc'=>2,
                'userid' => $grid,
                'telecombrandid' => $opid,
                'desig' => '',
                'apiid' => 0
            );
        }
            
        $margin = $this->slab_repo->createSlabMargin($arr1);
    	return view('Employee.prepaidapi_sequences', compact('api', 'slab', 'OPERATOR', 'margin'));
    }

    /**
        * Method name   : Utility api sequence
        * @description  : Used for utility api sequence
        * @param        : Request data 
        * @return       : return utility api sequence
    */
    public function utilityapi_sequences()
    {
        $request = request();

        $api = $this->api_repo->getAll();
        $slab = $this->slab_repo->getAll();
        $OPERATOR = Helper::get_operator(-1,'ALL');

        $grid = 1;
        $opid = 0;

        if($request->method() == 'POST')
        {    
            if(($request->input('dd_group') == -1) && ($request->input('dd_group') != "")){
                $grid = $request->input('dd_group');
            }
            
        }   

        $arr1 = array(
            'proc'=>5,
            'userid' => $grid,
            'telecombrandid' => $opid,
            'desig' => '',
            'apiid' => 0
        );

            
        $margin = $this->slab_repo->createSlabMargin($arr1);
    	return view('Employee.utilityapi_sequences', compact('api', 'slab', 'OPERATOR', 'margin'));
    }

    /**
        * Method name   : Prepaid api limit
        * @description  : Used for prepaid api limit
        * @param        : Request data 
        * @return       : return prepaid api limit
    */
    public function prepaidapi_limit()
    {
    	return view('Employee.prepaidapi_limit');
    }

    /**
        * Method name   : Utility api limit
        * @description  : Used for utility api limit
        * @param        : Request data 
        * @return       : return utility api limit
    */
    public function utilityapi_limit()
    {
    	 return view('Employee.utilityapi_limit');
    }

    // API CONTROLLER HERE
    /**
        * Method name   : Add Api
        * @description  : Used for adding api
        * @param        : Request data 
        * @return       : return view for adding api
    */
	public function add_api()
	{
		$api = $this->api_repo->getByRoleandId('EMPLOYEE',SESSION::get('USER_ID'));
		return view('Employee.add_api', compact('api'));
	}

	/**
        * Method name   : Create Api
        * @description  : Used for adding api
        * @param        : Request data 
        * @return       : return with adding api
    */
	public function create_api()
	{

		$request = request();

        // $this->validate($request, [
        //     'rb_api_method'=> 'required',
        //     'rb_api_type' => 'required',
        //     'rb_data_send' => 'required',
        //     'txt_api_name' => 'required',
        //     'txt_trans_url'=> 'required',
        //     'txt_trans_param' => 'required',
        //     'txt_bal_url' => 'required',
        //     'txt_bal_param' => 'required',
        //     'txt_status_url'=> 'required',
        //     'txt_status_param' => 'required',
        //     'txt_allow_qty' => 'required',
        //     'txt_allow_hlr' => 'required',
        //     'dd_status' => 'required',
        //     'dd_response' => 'required',
        //     'dd_type'=> 'required',
        //     'txt_status_name' => 'required',
        //     'txt_res_opr_idname' => 'required',
        //     'txt_success_st' => 'required',
        //     'txt_pending_st' => 'required',
        //     'txt_failed_st' => 'required',
        //     'txt_res_api_idname' => 'required'
        // ],[
        //     'rb_api_method.required'=> 'Service name is required',
        //     'rb_api_type.required' => 'Service description is required',
        //     'rb_data_send.required'=> 'Service surcharge is required',
        //     'txt_api_name.required' => 'Status is required', 
        //     'txt_trans_url.required'=> 'Service name is required',
        //     'txt_trans_param.required' => 'Service description is required',
        //     'txt_bal_url.required'=> 'Service surcharge is required',
        //     'txt_bal_param.required' => 'Status is required',     
        //     'txt_status_url.required'=> 'Service name is required',
        //     'txt_status_param.required' => 'Service description is required',
        //     'txt_allow_qty.required'=> 'Service surcharge is required',
        //     'txt_allow_hlr.required' => 'Status is required',
        //     'dd_status.required' => 'Status is required',     
        //     'dd_response.required'=> 'Service name is required',
        //     'dd_type.required' => 'Service description is required',
        //     'txt_status_name.required'=> 'Service surcharge is required',
        //     'txt_res_opr_idname.required' => 'Status is required',
        //     'txt_success_st.required' => 'Status is required',
        //     'txt_pending_st.required' => 'Status is required',     
        //     'txt_failed_st.required'=> 'Service name is required',
        //     'txt_res_api_idname.required' => 'Service description is required'
        // ]);

  //       $arr = array(
		// 	'proc'=>1,
		// 	'api_method_type' => $request->input('txt_api_name'),
		// 	'm12_api_url' => $request->input('txt_trans_url'),
		// 	'm12_api_for' => $request->input('rb_api_type'),
		// 	'm12_api_status' => $request->input('dd_status'),
		// 	'm12_api_id' => $api_id,
		// 	'm14_api_url_name' => 'Recharge',m14_api_url_address_status
		// 	'm14_api_url_address' => $request->input('txt_trans_url'),
		// 	'm14_api_url_address_bal' => $request->input('txt_bal_url'),
		// 	'm14_api_url_address_status' => $request->input('txt_status_url'),
		// 	'm14_api_url_prm' => $request->input('txt_trans_param'),
		// 	'm14_api_url_balprm' => $request->input('txt_bal_param'),
		// 	'm14_api_url_statusprm' => $request->input('txt_status_param'),
		// 	'm14_api_url_method' => $request->input('rb_api_method'),
		// 	'm14_api_url_for' => $request->input('rb_api_type'),
		// 	'm14_api_url_priority' => 1,
		// 	'm14_api_url_allowqty' => $request->input('txt_allow_qty'),
		// 	'm14_api_url_hlr' => $request->input('txt_allow_hlr'),
		// 	'm14_api_url_status' => $request->input('dd_status'),
		// 	'm25_resp_occur' => $request->input('dd_response'),
		// 	'm25_resp_type' => $request->input('dd_type'),
		// 	'm25_respfor_status' => $request->input('txt_status_name'),
		// 	'm25_valueof_success' => $request->input('txt_success_st'),
		// 	'm25_valueof_pending' => $request->input('txt_pending_st'),
		// 	'm25_valueof_failed' => $request->input('txt_failed_st'),
		// 	'm25_respfor_liveid' => 'OPID',
		// 	'm25_respfor_apitxnid' => $request->input('txt_res_api_idname'),
		// 	'm25_apiresp_status' => $request->input('dd_status')
		// );

		$arr = array(
			'proc'=>1,
			'api_method_type' => $request->input('rb_api_method'),
			'api_for' => $request->input('rb_api_type'),
			'api_datasend_via' => $request->input('rb_data_send'),
			'api_name' => $request->input('txt_api_name'),
			'api_for_transaction' => $request->input('txt_trans_url'),
			'transaction_parameter' => $request->input('txt_bal_param'),
			'api_for_status' => $request->input('txt_status_url'),
			'status_parameter' => $request->input('txt_status_param'),
			'api_for_bal' => $request->input('txt_bal_url'),
			'bal_parameter' => $request->input('txt_bal_param'),
			'api_allow_qty' => $request->input('txt_allow_qty'),
			'api_hlr' => $request->input('txt_allow_hlr'),
			'api_status' => $request->input('dd_status'),
			'resp_occur' => $request->input('dd_response'),
			'resp_type' => $request->input('dd_type'),
			'respfor_status' => $request->input('txt_status_name'),
			'valueof_success' => $request->input('txt_success_st'),
			'valueof_pending' => $request->input('txt_pending_st'),
			'valueof_failed' => $request->input('txt_failed_st'),
			'respfor_liveid' => $request->input('txt_res_opr_idname'),
			'respfor_apitxnid' => $request->input('txt_res_api_idname'),
			'apiresp_status' => $request->input('dd_status'),
			'user_role' =>'3',
			'user_id' => SESSION::get('USER_ID'),
			'api_id' => 0,
		);

		$this->api_repo->create($arr);
		Session::flash('api_msg','API ADDED SUCCESSFULLY' );
        Session::flash('type','success' );
		return redirect('/emp_add_api');
		
	}


	/**
        * Method name   : View Api
        * @description  : Used for viewing api
        * @param        : Request data 
        * @return       : return view for viewing api
    */
	public function view_api($id)
	{
		$api = $this->api_repo->getById($id);
		return view('Employee.edit_api', compact('api'));
	}


	/**
        * Method name   : Update Api
        * @description  : Used for updating api
        * @param        : Request data 
        * @return       : return with updating api
    */
	public function update_api($id)
	{

		$request = request();

		$arr = array(
			'proc'=>2,
			'api_method_type' => $request->input('rb_api_method'),
			'api_for' => $request->input('rb_api_type'),
			'api_datasend_via' => $request->input('rb_data_send'),
			'api_name' => $request->input('txt_api_name'),
			'api_for_transaction' => $request->input('txt_trans_url'),
			'transaction_parameter' => $request->input('txt_bal_param'),
			'api_for_status' => $request->input('txt_status_url'),
			'status_parameter' => $request->input('txt_status_param'),
			'api_for_bal' => $request->input('txt_bal_url'),
			'bal_parameter' => $request->input('txt_bal_param'),
			'api_allow_qty' => $request->input('txt_allow_qty'),
			'api_hlr' => $request->input('txt_allow_hlr'),
			'api_status' => $request->input('dd_status'),
			'resp_occur' => $request->input('dd_response'),
			'resp_type' => $request->input('dd_type'),
			'respfor_status' => $request->input('txt_status_name'),
			'valueof_success' => $request->input('txt_success_st'),
			'valueof_pending' => $request->input('txt_pending_st'),
			'valueof_failed' => $request->input('txt_failed_st'),
			'respfor_liveid' => $request->input('txt_res_opr_idname'),
			'respfor_apitxnid' => $request->input('txt_res_api_idname'),
			'apiresp_status' => $request->input('dd_status'),
			'user_role' => '1',
			'user_id' => SESSION::get('USER_ID'),
			'api_id' => $id
		);
//dd($arr);

		$this->api_repo->create($arr);
		Session::flash('api_msg','API UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );
		return redirect('/emp_add_api');
		
	}

	/**
        * Method name   : Api operator
        * @description  : Used for getting api operator
        * @param        : Request data 
        * @return       : return api operator
    */
	public function api_operator()
	{

		return view('Employee.api_operator');
	}

	//TICKET CONTROLLER ROUTES
	/**
        * Method name   : Ticket Reply
        * @description  : Used for ticket reply
        * @param        : Request data
        * @return       : return with ticket reply
    */
    public function ticket_reply()
    {
        $users = $this->enroll_repo->getActiveUser();
        $tickets = $this->ticket_repo->getByAssTo(session()->get('USER_ID'));
        return view('Employee.ticket_reply', compact('users', 'tickets'));
    }



	/**
        * Method name   : Ticket Reply
        * @description  : Used for ticket reply
        * @param        : Request data
        * @return       : return with ticket reply
    */
    public function ticket_reply_close()
    {
        $users = $this->enroll_repo->getActiveUser();
        $tickets = $this->ticket_repo->getByAssToClose(session()->get('USER_ID'));
        return view('Employee.ticket_reply', compact('users', 'tickets'));
    }



	/**
        * Method name   : filter Ticket Reply
        * @description  : Used for ticket reply
        * @param        : Request data
        * @return       : return with ticket reply
    */
    public function filter_ticket_reply(request $request)
    {
        $users = $this->enroll_repo->getActiveUser();
		$urgency = '';
		$transid = '';
		$ticket_id = '';
		$ticket_type = '';
		$formdate = '';
		$todate = '';

		if($request->dd_urgency != null)
		{
			$urgency = " AND URGENCY = ".$request->dd_urgency;
		}
		if($request->txt_transid != null)
		{	
			$user = $this->enroll_repo->getUserByUserCode($request->txt_transid);
			if(count($user) > 0)
			{
				$transid = " AND USER_ID = ".$user[0]->RegId;
			}
			else
			{
				$transid = '';
			}
		}
		if($request->txt_ticket != null)
		{
			$ticket_id = " AND TICKET_NO = '".$request->txt_ticket."' ";
		}
		if($request->dd_ticket != null)
		{
			$ticket_type = " AND TICKET_FOR = ".$request->dd_ticket;
		}
		if($request->txtfromdate != null && $request->txttodate != null)
		{
			$formdate = " AND CREATED_AT BETWEEN ".$request->txtfromdate." AND ".$request->txttodate;
		}
		if($request->txttodate != null && $request->txtfromdate == null)
		{
			$formdate =  " AND CREATED_AT = ".$request->txttodate;
		}
		if($request->txttodate == null && $request->txtfromdate != null)
		{
			$formdate =  " AND CREATED_AT = ".$request->txttodate;
		}

	   $tickets =  DB::select("SELECT * FROM `ticket` WHERE EMP_ID = ".session()->get('USER_ID') . $urgency . $transid . $ticket_id . $formdate .  $todate . $ticket_type . "  AND STATUS =  '".$request->txt_status."' ");
	
        return view('Employee.ticket_reply', compact('users', 'tickets'));
    }



	public function view_help_desk($id, request $request)
	{

		$data['ticket'] = $this->ticket_repo->getById($id);
		if($data['ticket'][0]->EMP_ID == SESSION()->GET('USER_ID'))
		{
			$data['reply'] = $this->ticket_repo->GetByTicketId($id);
	        $data['users'] = $this->enroll_repo->getByIdE($data['ticket'][0]->USER_ID);
	        $data['emp']  = $this->emp_repo->getActiveEmployee();
			return view('Employee.view-help-desk', compact('data'));

		}
		else
		{
			return back()->with('error','you dont have permission');
		}

	}



    /**
        * Method name   : Submit Reply
        * @description  : Used for submit ticket reply
        * @param        : Request data
        * @return       : return with submit ticket reply
    */
    public function submit_reply()
    {
        $request = request();
        $user = Helper::get_userdetail($request->input('txt_id'));
		
		$this->validate($request, [
				'txt_ticket_id'=> 'required',
				'txt_content'=> 'required|max:1500|min:10',
				'file_image' => 'nullable|max:10240',
			],
			[
				'txt_ticket_id.required'=> 'Ticket ID is required',
				'txt_content.required'=> 'Comment is required',
				'txt_content.max'=> 'Comment Max 1500 characters',
				'txt_content.min'=> 'Comment Min 10  characters',
				'file_image.max'=> 'Image Max 2 MB',
			]);

        if($request->hasFile('file_image'))
        {
            $image = $request->file('file_image');
            $image_name = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/images/ticket_file/');
			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $image_name);
			}
			else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=Session()->get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
        }
        else
        {
            $image_name = '';
        }

        $arr = array(
            'tr34_tkt_id' => $request->input('txt_ticket_id'),
            'tr34_description' =>  $request->input('txt_content'),
            'tr34_response_type' => 2,
            'tr34_response_by' => Session()->get('USER_ID'),
            'tr34_userfile' =>  $image_name,
            'tr34_status' => 1
        );

		$tickData = $this->ticket_repo->getById($request->input('txt_ticket_id'));
        $datas = $this->ticket_repo->create_reply($arr);

        if($datas)
        {
            $template_type = 1;
            if($image_name == '')
            { 
                $data['MSG_CONTENT'] =  $request->input('txt_content'); 
            }
            else
            {
                $data['MSG_CONTENT'] =  $request->input('txt_content').'<br><a href="'.url('images/ticket_file/'.$image_name).'">Attachment File </a>';
            }
            $data['MSG_SUBJECT'] = $tickData[0]->SUBJECT;
            $data['pdf']=''; 
            $data['template_name']='email';
            $emails = $user[0]->MemberEmail;
			$data['useremail']=json_encode($emails);
			$data['USER_TYPE'] = 3;
            $template_data = $data;
            Mail::to($emails)->send(new SendMail($template_data, $template_type));


            return back()->with('success','Message Send Successfully');
        }
        else
        {
            return back()->with('error', 'Message Not Send'); 
        }
    }


	//EMPLOYEE PROFILE UPDATION ROUTES

    /**
        * Method name   : View emp profile
        * @description  : Used for viewing employee profile
        * @param        : Request data 
        * @return       : return with viewing employee profile
    */
	public function view_empprofile()
	{
		$user = Helper::get_empdetail(Session::get('USER_ID'));
		$get_useralldetail = Helper::get_empalldetail(Session::get('USER_ID'));
		return view('Employee.emp_profile',compact('user','get_useralldetail'));
	}

	/**
        * Method name   : Edit emp profile
        * @description  : Used for editing employee profile
        * @param        : Request data 
        * @return       : return with editing employee profile
    */
	public function edit_employeeprofile()
	{
		$user = Helper::get_empdetail(Session::get('USER_ID'));
		$get_useralldetail = Helper::get_empalldetail(Session::get('USER_ID'));
		return view('Employee.emp_update_profile',compact('user','get_useralldetail'));
	}

	/**
        * Method name   : Update employee profile
        * @description  : Used for update employee profile
        * @param        : Request data 
        * @return       : return with update employee profile
    */
	public function update_employeeprofile()
	{
	    $request = request();

		if($request->method() == 'POST')
		{
			if($_FILES['txt_yourphoto']['name']!= '')
			{
				$image = $request->file('txt_yourphoto');
				$name = time().'.'.$image->getClientOriginalExtension();
				$destinationPath = public_path('images/USER_PHOTO');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath,$name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
				$txt_yourphoto =  $name;
			}
			else
			{
				$txt_yourphoto = trim($request->input('txt_yourphotohd'));
			}
			if($request->input('txt_username')=='')
			{
				$ERRMSG = "Member user name should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_mobileno')=='')
			{
				$ERRMSG = "Member contact number should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_email')=='')
			{
				$ERRMSG = "Member email address should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_dob')=='')
			{
				$ERRMSG = "Member Date of birth should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_address')=='')
			{
				$ERRMSG = "Member address should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_postalcode')=='')
			{
				$ERRMSG = "Member postal code should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($txt_yourphoto=='')
			{
				$ERRMSG = "Member image should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				$name=explode(" " ,$request->input('txt_username'));
				$user_name=$request->input('txt_username');
				$USER=Session::get('USER_ID');

				$arr = array(
				'm30_first_name' => $name[0],
				'm30_last_name' => $name[1],
				'm30_employee_name' => $request->input('txt_username'),
				'm30_employee_dob' => date('Y-m-d',strtotime($request->input('txt_dob'))),
				'm30_employee_location' => $request->input('txt_address'),
				'm30_employee_postalcode' => $request->input('txt_postalcode'),
				'm30_employee_contactno' => $request->input('txt_mobileno'),
				'm30_employee_email' => $request->input('txt_email'),
				'm30_employee_image' => $txt_yourphoto
				);
				$old_values=DB::select("SELECT FirstName,LastName,MemberName,MemberDOB,MemberLocation,MemberPostalCode,MemberContactNo,MemberEmail,MemberImage FROM employee_details WHERE RegId=".Session::get('USER_ID')."");
				$user_profile = $this->emp_repo->update(Session::get('USER_CODE'), Session::get('USER_ID'), $arr);
				$data=$this->match_values($old_values,$arr);
				$arr = array(
					'tr11_ar_tblnm' => 'm11_user',
					'tr11_ar_old_value' => $data[1],
					'tr11_ar_new_value' => $data[0],
					'tr11_ar_uid' => $USER,
					'tr11_ar_by'=>2,
					'tr11_ar_description' => 'EMPLOYEE S PROFILE HAS BEEN CHANGED SUCCESSFULLY!',
					'tr11_updated_by' => 3,
					'tr11_updated_by_id' =>  Session::get('USER_ID')
					);
				$mobileno_actionrecord=$this->log_repo->create($arr);
				$ERRMSG="EMPLOYEE S PROFILE HAS BEEN CHANGED SUCCESSFULLY!";
				$ERRCODE='success';	
			}
		}
		Session::flash('type',$ERRCODE);
		Session::flash('message',$ERRMSG);
		return redirect('emp_edit_profile'); 
	}

	/**
        * Method name   : Edit employee bank
        * @description  : Used for update employee bank 
        * @param        : Request data 
        * @return       : return with update employee bank 
    */
	public function edit_empbank()
	{
		$user = Helper::get_empdetail(Session::get('USER_ID'));
		$get_useralldetail = Helper::get_empalldetail(Session::get('USER_ID'));
		return view('Employee.emp_update_bankdetails',compact('user','get_useralldetail'));
	}

	/**
        * Method name   : Update employee bank details
        * @description  : Used for update employee bank details
        * @param        : Request data 
        * @return       : return with update employee bank details
    */
	public function update_employeebank()
	{
		$request = request();

		if($request->method() == 'POST')
		{
			if($_FILES['txt_cancelchq']['name']!= '')
			{
				$image = $request->file('txt_cancelchq');
				$name = time().'.'.$image->getClientOriginalExtension();
				$destinationPath = public_path('images/CANCEL_CHEQUE');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
					$image->move($destinationPath,$name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
				$txt_cancelchq =  $name;
			}
			else
			{
				$txt_cancelchq = trim($request->input('txt_cancelchqhd'));
			}
			if($request->input('txt_nameatbank')=='' )
			{
				$ERRMSG = "Member Name at Bank should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_bankname')=='')
			{
				$ERRMSG = "Member Bank Name should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_cbsacno')=='')
			{
				$ERRMSG = "Member Bank no Account should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_bankbranch')=='')
			{
				$ERRMSG = "Member Bank Branch should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_bankifsccode')=='')
			{
				$ERRMSG = "Member Bank IFSCode should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($txt_cancelchq=='')
			{
				$ERRMSG = "Cancel cheque should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				$ACCOUNTNO=$request->input('txt_cbsacno');
				$USER=Session::get('USER_ID');
				$arr = array(
				'm32_employee_nameat_bank'=>$request->input('txt_nameatbank'),
				'm32_employee_cbsacno' =>$request->input('txt_cbsacno'),
				'm01_bank_name'=>$request->input('txt_bankname'),
				'm32_employee_branch'=>$request->input('txt_bankbranch'),
				'm32_employee_ifscode' =>$request->input('txt_bankifsccode'),
				'm32_employeecancelechq'=>$txt_cancelchq
				);
				$old_values=DB::select("SELECT NAMEatBANK,CBSACno,BANKNo,Branch,IFSCode,CancelCheque FROM employee_details WHERE RegId=".$USER."");
				$this->profile_repo->updateBankByEmpId($USER, $arr);
				$data=$this->match_values($old_values,$arr);
				$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => $data[1],
						'tr11_ar_new_value' => $data[0],
						'tr11_ar_uid' => $USER,
						'tr11_ar_by'=>2,
						'tr11_ar_description' => 'EMPLOYEES BANK DETAILS HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 3,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
				$bank_actionrecord=$this->log_repo->create($arr);
				$ERRMSG="EMPLOYEE'S BANK HAS BEEN CHANGED SUCCESSFULLY!";
				$ERRCODE='success';	
			}
		}
		
		Session::flash('type',$ERRCODE);
		Session::flash('message',$ERRMSG );
		return redirect('emp_edit_bank'); 
	}

	/**
        * Method name   : Edit emp kyc
        * @description  : Used to edit employee kyc
        * @param        : Request data 
        * @return       : return with employee kyc details
    */
	public function edit_empkyc()
	{
		$user = Helper::get_empdetail(Session::get('USER_ID'));
		$get_useralldetail = Helper::get_empalldetail(Session::get('USER_ID'));
		return view('Employee.emp_upload_kyc',compact('user','get_useralldetail'));
	}

	/**
        * Method name   : Update emp kyc
        * @description  : Used to update employee kyc
        * @param        : Request data 
        * @return       : return with updated employee kyc details
    */
	public function update_employeekyc()
	{
		$request = request();
		
		if($request->method() == 'POST')
		{
			if($_FILES['txt_yourphoto']['name']!= '')
			{
				$image = $request->file('txt_yourphoto');
				$name = time().'.'.$image->getClientOriginalExtension();
				$destinationPath = public_path('images/USER_PHOTO');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
					$image->move($destinationPath,$name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
				$txt_yourphoto =  $name;
			}
			else
			{
				$txt_yourphoto = trim($request->input('txt_yourphotohd'));
			}
			if($_FILES['txt_idproof']['name']!= '')
			{
				$image = $request->file('txt_idproof');
				$name = time().'.'.$image->getClientOriginalExtension();
				$destinationPath = public_path('images/USER_IDPROOF');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
				$txt_idproof =  $name;
			}
			else
			{
				$txt_idproof = trim($request->input('txt_idproofhd'));
			}
			if($_FILES['txt_addressproof']['name']!= '')
			{
				$image = $request->file('txt_addressproof');
				$name = time().'.'.$image->getClientOriginalExtension();
				$destinationPath = public_path('images/USER_ADDRESSPROOF');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
				$txt_addressproof =  $name;
			}
			else
			{
				$txt_addressproof = trim($request->input('txt_addressproofhd'));
			}

			if($_FILES['txt_aadharfront']['name']!= '')
			{
				$image = $request->file('txt_aadharfront');
				$name = time().'.'.$image->getClientOriginalExtension();
				$destinationPath = public_path('images/USER_IDPROOF');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
				$txt_aadharfront = $name;
			}
			else
			{
				$txt_aadharfront = trim($request->input('txt_aadharfronthd'));
			}

			if($_FILES['txt_aadharback']['name']!= '')
			{
				$image = $request->file('txt_aadharback');
				$name = time().'.'.$image->getClientOriginalExtension();
				$destinationPath = public_path('images/USER_IDPROOF');
				$FileType = array('jpeg','png','jpg');
				if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name);
				}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=SESSION::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
				$txt_aadharback = $name;
			}
			else
			{
				$txt_aadharback = trim($request->input('txt_aadharbackhd'));
			}
			
			if($txt_yourphoto=='')
			{
				$ERRMSG = "Member image should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('dd_idprooftype')=='' || $request->input('dd_idprooftype')=='-1')
			{
				$ERRMSG = "Id proof type should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			if($request->input('txt_pancard')=='')
			{
				$ERRMSG = "Member pancard should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_aadharcard')=='')
			{
				$ERRMSG = "Aadhar card number should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($txt_aadharfront=='')
			{
				$ERRMSG = "Aadhar front image should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($txt_aadharback=='')
			{
				$ERRMSG = "Aadhar front image should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($txt_idproof=='')
			{
				$ERRMSG = "Id proof should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_address')=='')
			{
				$ERRMSG = "Member address should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($txt_addressproof=='')
			{
				$ERRMSG = "Address proof should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('dd_quali')=='' || $request->input('dd_quali')=='-1')
			{
				$ERRMSG = "Qualification type should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_address')=='')
			{
				$ERRMSG = "Member address should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST'&& $this->isError==FALSE)
			{
				$pancard=$request->input('txt_pancard');
				$USER=Session::get('USER_ID');
				$arr = array(
					'm31_ek_user_photo'=>$txt_yourphoto,
					'm31_ek_idproof_type'=>$request->input('dd_idprooftype'),
					'm31_ek_uniqueid_num'=>$request->input('txt_pancard'),
					'm31_ek_aadhar_num'=>$request->input('txt_aadharcard'),
					'm31_ek_aadhar_front'=>$txt_aadharfront,
					'm31_ek_aadhar_back'=>$txt_aadharback,
					'm31_ek_idproofdoc'=>$txt_idproof,
					'm31_ek_address'=>$request->input('txt_address'),
					'm31_ek_addressproof'=>$txt_addressproof,
					'm31_ek_qualification'=>$request->input('dd_quali')
					);
				$this->profile_repo->updateKycByEmpId($USER, $arr);
				$user_profile=DB::update("UPDATE m11_user SET m11_user_image='".$txt_yourphoto."' WHERE m11_user_contactno =".Session::get('CONTACTNO')." and m11_user_id=". Session::get('USER_ID')." AND m11_user_status='ACTIVE'");	
				$arr = array(
						'tr11_ar_tblnm' => 'm11_user',
						'tr11_ar_old_value' => '',
						'tr11_ar_new_value' => $pancard,
						'tr11_ar_uid' => $USER,
						'tr11_ar_description' => 'EMPLOYEES KYC HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 3,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
				$kyc_actionrecord=$this->log_repo->create($arr);	
				$ERRMSG="EMPLOYEE'S KYC HAS BEEN CHANGED SUCCESSFULLY!";
				$ERRCODE='success';	
			}
			
		}
		Session::flash('type',$ERRCODE);
		Session::flash('message',$ERRMSG);
		return redirect('emp_edit_kyc'); 
	}

	/**
        * Method name   : Change emp password
        * @description  : Used for changing employee password
        * @param        : Request data 
        * @return       : return with employee password
    */
	public function change_emppassword()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'CHANGE PASSWORD';
		$user = Helper::get_empdetail(Session::get('USER_ID'));
		return view('Employee.emp_change_login_pass',compact('page','form_name','user') );
	}

	/**
        * Method name   : Update emp password
        * @description  : Used for updating employee password
        * @param        : Request data 
        * @return       : return with updated employee password
    */
	public function update_emppassword()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'CHANGE PASSWORD';
		$request = request();
		
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		
		if($_SERVER['REQUEST_METHOD']=="POST")
		{		
		    if($request->input('txt_oldpassword')=='')
			{
				$ERRMSG = "Old Password should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_newpassword')=='')
			{
				$ERRMSG = "New Password should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if(strlen($request->input('txt_newpassword'))<6)
			{
				$ERRMSG = "New password length would be greater then 6 or equal 6";
				$this->isError= TRUE;
				$ERRCODE="warning";
				
			}
			else if($request->input('txt_newcpassword')=='')
			{
				$ERRMSG = "Confirm New Password should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
				
			}
			else if(strlen($request->input('txt_newcpassword'))<6)
			{
				$ERRMSG = "New Confirm password length would be greater then 6 or equal 6";
				$this->isError= TRUE;
				$ERRCODE="warning";
				
			}
			else if($request->input('txt_newpassword')!=$request->input('txt_newcpassword'))
			{
				$ERRMSG = "Password does not match with confirm password.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST' && $this->isError==FALSE)
			{
				$password=$request->input('txt_oldpassword');
				$new_password=$request->input('txt_newpassword');
				$new_cpassword=$request->input('txt_newcpassword');
				$userid=Session::get('USER_ID');

				$user_logindetails=$this->emp_repo->updateEmpPassword($new_password, $password, $userid);
				if($user_logindetails==1)
				{
					$arr = array(
						'tr11_ar_tblnm' => 'tr04_login',
						'tr11_ar_old_value' => $password,
						'tr11_ar_new_value' => $new_password,
						'tr11_ar_uid' => $userid,
						'tr11_ar_description' => 'EMPLOYEE S LOGIN PASSWORD HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 3,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
					$mobileno_actionrecord=$this->log_repo->create($arr);
					$ERRMSG="EMPLOYEE'S PASSWORD HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
				}
				else
				{
					$ERRMSG="EMPLOYEE'S PASSWORD HAS NOT BEEN CHANGED!";
					$ERRCODE='warning';	
				}
			}
		}
		Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);
		return redirect('emp_change_password'); 
	}


	/**
        * Method name   : Change emp trans password
        * @description  : Used for changing employee trans password
        * @param        : Request data 
        * @return       : return with employee trans password
    */
	public function change_emptranspassword()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'CHANGE PASSWORD';
		$user = Helper::get_empdetail(Session::get('USER_ID'));
		return view('Employee.emp_change_trans_pass',compact('page','form_name','user') );
	}

	/**
        * Method name   : Update emp trans password
        * @description  : Used for updating employee trans password
        * @param        : Request data 
        * @return       : return with updating employee trans password
    */
	public function update_emptranspassword()
	{
		$page = 'PROFILE PANEL';
		$form_name = 'CHANGE PASSWORD';
		$request = request();
		
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		
		if($_SERVER['REQUEST_METHOD']=="POST")
		{		
		    if($request->input('txt_oldpassword')=='')
			{
				$ERRMSG = "Old Password should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_newpassword')=='')
			{
				$ERRMSG = "New Password should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if(strlen($request->input('txt_newpassword'))<6)
			{
				$ERRMSG = "New password length would be greater then 6 or equal 6";
				$this->isError= TRUE;
				$ERRCODE="warning";
				
			}
			else if($request->input('txt_newcpassword')=='')
			{
				$ERRMSG = "Confirm New Password should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
				
			}
			else if(strlen($request->input('txt_newcpassword'))<6)
			{
				$ERRMSG = "New Confirm password length would be greater then 6 or equal 6";
				$this->isError= TRUE;
				$ERRCODE="warning";
				
			}
			else if($request->input('txt_newpassword')!=$request->input('txt_newcpassword'))
			{
				$ERRMSG = "Password does not match with confirm password.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}
			if(request()->method() == 'POST' && $this->isError==FALSE)
			{
				$password=$request->input('txt_oldpassword');
				$new_password=$request->input('txt_newpassword');
				$new_cpassword=$request->input('txt_newcpassword');
				$userid=Session::get('USER_ID');
                DB::enableQueryLog();
				$user_logindetails=$this->emp_repo->updateEmpTrans($new_password, $password, $userid);
				if($user_logindetails==1)
				{
					$arr = array(
						'tr11_ar_tblnm' => 'tr04_login',
						'tr11_ar_old_value' => $password,
						'tr11_ar_new_value' => $new_password,
						'tr11_ar_uid' => $userid,
						'tr11_ar_description' => 'EMPLOYEE S PIN PASSWORD HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 3,
						'tr11_updated_by_id' =>  Session::get('USER_ID')
						);
					$mobileno_actionrecord=$this->log_repo->create($arr);
					$ERRMSG="EMPLOYEE'S PASSWORD HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
				}
				else
				{
					$ERRMSG="EMPLOYEE'S PASSWORD HAS NOT BEEN CHANGED!";
					$ERRCODE='warning';	
				}
			}
		}
		Session::flash('message',$ERRMSG);
		Session::flash('type',$ERRCODE);
		return redirect('emp_change_transpassword'); 
	}

	/******** USER RECHARGE REPORT *****************************/

    /**
        * Method name   : Recharge Report
        * @description  : Used for viewing recharge report
        * @param        : Request data 
        * @return       : return recharge report
    */
    public function recharge_report()
    {
        $request = request();
        $descrip="";
       $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='-1';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
         (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
		$hit_data=array(
				'proc'=>3,
				'user_id'=>-1,
				'rec_fromdate'=>$start,
				'rec_todate'=>$end
            );
		$today_hit = $this->rech_reprt_repo->todayHitStatus($hit_data);

        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        Session::flash('message',"Recharge Report Fetch Succesfully");
        return view('Employee.recharge_report', compact('rec_report','OPERATOR','API','today_hit','user'));
    }

    /**
        * Method name   : Pending Recharge report
        * @description  : Used for view pending recharge report
        * @param        : Request data  
        * @return       : return pending recharge report
    */
    public function pendingrecharge_report()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime('2021-01-01'));
        $end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_from')));
            $end = date('Y-m-d',strtotime($request->input('txt_to')));

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            /*if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }*/
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);

        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Pending Recharge Report Fetch Succesfully");
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('Employee.pendingrecharge_report', compact('rec_report','OPERATOR','API','user'));
    }

    /**
        * Method name   : Refund report
        * @description  : Used for refund report 
        * @param        : Request data  
        * @return       : return refund report
    */
    public function refund_report()
    {
       $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
		$end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='3';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
		$txt_memberids = $txt_memberid;
		$dd_api='-1';
		$dd_operator='-1';

        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$txt_memberids = $request->input('txt_memberid');
			$dd_api=$request->input('dd_api');
			$dd_operator=$request->input('dd_operator');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>3,
          'recharge_id'=>0,
          'descrip'=>$cond,
          'defaultstatus'=>$dd_status
        );
        $rec_report = $this->rech_reprt_repo->refundReport($recereport);
		
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Refund Recharge Report Fetch Succesfully");
        return view('Employee.refund_report', compact('rec_report','OPERATOR','API','start','end','txt_memberids','txt_account','txt_transid','dd_status','dd_api','dd_operator','txt_noofrecords'));
    }

    /**
        * Method name   : Operator wise
        * @description  : Used for operator wise recharge report 
        * @param        : Request data  
        * @return       : return operator wise recharge report
    */
    public function operator_wise()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );

        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);

        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Operator Wise Recharge Report Fetch Succesfully");
        $user = Helper::get_userdetail(Session::get('USER_ID'));
    	return view('Employee.operator_wise', compact('rec_report','OPERATOR','API','user'));
    }

    /**
        * Method name   : User wise
        * @description  : Used for user wise recharge report 
        * @param        : Request data  
        * @return       : return user wise recharge report 
    */
    public function user_wise()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);

        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Recharge Report Fetch Succesfully");
        $user = Helper::get_userdetail(Session::get('USER_ID'));
    	return view('Employee.user_wise', compact('rec_report','OPERATOR','API','user'));
    }

	/**
        * Method name   : Api wise
        * @description  : Used for api wise recharge report
        * @param        : Request data  
        * @return       : return api wise recharge report
    */
    public function api_wise()
    {
        $request = request();
        $descrip=""; 	$start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';$txt_memberid = -1;$txt_transid = ''; $txt_noofrecords = '100';
        $dd_status='2';$cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }
        }
        $cond=$cond.$cond1;
       	$recereport=array
        (
          'proc'=>5,
          'user_id'=>$txt_memberid,
          'rec_fromdate'=>$start,
          'rec_todate'=>$end
        );
        $rec_report = $this->rech_reprt_repo->apiWiseSales($recereport);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Recharge Report Fetch Succesfully");
    	return view('Employee.api_wise', compact('rec_report','OPERATOR','API'));
    }

    /**
        * Method name   : Date wise
        * @description  : Used for date wise recharge report
        * @param        : Request data  
        * @return       : return date wise recharge report
    */
    public function date_wise()
    {
        $request = request();
        $descrip="";
       	$start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Recharge Report Fetch Succesfully");
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('Employee.date_wise', compact('rec_report','OPERATOR','API','user'));
    }

    /******** MONEY TRANSFER REPORT *****************************/
	
	/**
        * Method name   : Money Transfer Report
        * @description  : Used for viewing money transfer report
        * @param        : Request data 
        * @return       : return money transfer report
    */
    public function mtransfer_report()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
		$txt_memberids = '';
        $txt_transid = '';
        $txt_noofrecords = '1000';
        $dd_status='-1';
        $cond="1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
          $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
           $end = date('Y-m-d',strtotime($request->input('txt_todate')));
            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
				$txt_memberids = $request->input('txt_memberid');
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
        }
       // $cond=$cond.$cond1;
        $mtransferreport=array
         (
         'proc'=>1,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $mtransfer_report = $this->dmt_reprt_repo->dmrReport($mtransferreport);
		$hit_data=array(
				'proc'=>6,
				'user_id'=>-1,
				'rec_fromdate'=>$start,
				'rec_todate'=>$end
            );
		$today_hit = $this->rech_reprt_repo->todayHitStatus($hit_data);
		//dd($mtransfer_report);
		$user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('Employee.money_transfer_report', compact('mtransfer_report','today_hit','user','start','end','txt_account','txt_transid','txt_memberids','dd_status','txt_noofrecords'));
    }

     /**
        * Method name   : Pending Money Transfer Report
        * @description  : Used for view pending money transfer report
        * @param        : Request data  
        * @return       : return pending money transfer report
    */
    public function pendingmtransfer_report()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
		$txt_memberids = '';
        $txt_transid = '';
        $txt_noofrecords = '1000';
        $dd_status='2';
        $cond="1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
          $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
           $end = date('Y-m-d',strtotime($request->input('txt_todate')));
            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
			  $txt_memberids = $request->input('txt_memberid');
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
        }
       // $cond=$cond.$cond1;
        $mtransferreport=array
         (
         'proc'=>1,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $mtransfer_report = $this->dmt_reprt_repo->dmrReport($mtransferreport);
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('Employee.pending_moneytransfer_report', compact('mtransfer_report','user','start','end','txt_account','txt_transid','txt_memberids','dd_status','txt_noofrecords'));
    }

    /**
        * Method name   : Refund Money Transfer Report
        * @description  : Used for refund money transfer report 
        * @param        : Request data  
        * @return       : return refund money transfer report
    */
    public function refund_mtransfer_report()
    {
        $request = request();
        $descrip="";
        $start = '1970-01-01';
        $end ='1970-01-01';
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Refund Recharge Report Fetch Succesfully");
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('Employee.refund_moneytransfer_report', compact('rec_report','OPERATOR','API','user'));
    }

    /**
        * Method name   : User wise Money Transfer
        * @description  : Used for user wise money transfer report 
        * @param        : Request data  
        * @return       : return user wise money transfer report 
    */
    public function user_wise_mtransfer()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);

        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        Session::flash('message',"Recharge Report Fetch Succesfully");
    	return view('Employee.user_wise_moneytransfer', compact('rec_report','OPERATOR','API','user'));
    }

	/**
        * Method name   : Api Wise Money Transfer
        * @description  : Used for api wise money transfer report
        * @param        : Request data  
        * @return       : return api wise money transfer report
    */
    public function api_wise_mtransfer()
    {
        $request = request();
        $descrip="";
       	$start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Recharge Report Fetch Succesfully");
    	return view('Employee.api_wise_moneytransfer', compact('rec_report','OPERATOR','API'));
    }

    /**
        * Method name   : Date wise
        * @description  : Used for date wise money transfer report
        * @param        : Request data  
        * @return       : return date wise money transfer report
    */
    public function date_wise_mtransfer()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        Session::flash('message',"Recharge Report Fetch Succesfully");
        return view('Employee.date_moneytransfer_wise', compact('rec_report','OPERATOR','API','user'));
    }


    /******** AEPS TRANSFER REPORT *****************************/
    
    /**
        * Method name   : AEPS Transfer Report
        * @description  : Used for viewing aeps transfer report
        * @param        : Request data 
        * @return       : return aeps transfer report
    */
    public function apestransfer_report()
    {
        $request = request();
        $descrip="";
       	$start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='-1';
        $cond="1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
          

        }
     
        $aepsreport=array
         (
         'proc'=>1,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $aeps_report = $this->aeps_reprt_repo->aepsReport($aepsreport);
		$hit_data=array(
				'proc'=>7,
				'user_id'=>-1,
				'rec_fromdate'=>$start,
				'rec_todate'=>$end
            );
		$today_hit = $this->rech_reprt_repo->todayHitStatus($hit_data);
		$user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('Employee.aeps_report', compact('aeps_report','today_hit','user'));
    }

    /**
        * Method name   : Pending AEPS Report
        * @description  : Used for view pending aeps report
        * @param        : Request data  
        * @return       : return pending aeps report
    */
    public function pendingapestransfer_report()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
          

        }
     
        $aepsreport=array
         (
         'proc'=>1,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $aeps_report = $this->aeps_reprt_repo->aepsReport($aepsreport);
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('Employee.pending_aeps_report', compact('aeps_report','user'));
    }

    /**
        * Method name   : Refund AEPS Report
        * @description  : Used for refund AEPS report 
        * @param        : Request data  
        * @return       : return refund AEPS report
    */
    public function refund_apestransfer_report()
    {
        $request = request();
        $descrip="";
        $start = '1970-01-01';
        $end ='1970-01-01';
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        Session::flash('message',"Refund Recharge Report Fetch Succesfully");
        return view('Employee.refund_aeps_report', compact('rec_report','OPERATOR','API','user'));
    }

    
    /**
        * Method name   : User wise Money Transfer
        * @description  : Used for user wise money transfer report 
        * @param        : Request data  
        * @return       : return user wise money transfer report 
    */
    public function user_wise_apestransfer()
    {
        $request = request();
        $descrip="";
        $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);

        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        Session::flash('message',"Recharge Report Fetch Succesfully");
        return view('Employee.user_wise_aeps', compact('rec_report','OPERATOR','API','user'));
    }


	/**
        * Method name   : Api Wise Money Transfer
        * @description  : Used for api wise money transfer report
        * @param        : Request data  
        * @return       : return api wise money transfer report
    */
    public function api_wise_apestransfer()
    {
        $request = request();
        $descrip="";
  	    $start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        Session::flash('message',"Recharge Report Fetch Succesfully");
        return view('Employee.api_wise_aeps', compact('rec_report','OPERATOR','API'));
    }

    /**
        * Method name   : Date wise
        * @description  : Used for date wise money transfer report
        * @param        : Request data  
        * @return       : return date wise money transfer report
    */
    public function date_wise_apestransfer()
    {
        $request = request();
        $descrip="";
       	$start = date('Y-m-d',strtotime(NOW()));
        $end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = '';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='2';
        $cond="";
        $cond1="`m07_service_id` IN(1,2,3) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr05_recharge_detail`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
        (
         'proc'=>2,
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        Session::flash('message',"Recharge Report Fetch Succesfully");
        return view('Employee.date_wise_aeps', compact('rec_report','OPERATOR','API','user'));
    }







   /**
        * Method name   : View banner
        * @description  : Used for getting banner 
        * @param        : Request data with banner id and all banners
        * @return       : return with single banner selected and all banners
    */
    public function view_banner($id = ""){
        $banners = $this->banner_repo->getAll();
		$affi = $this->Affiliate_repo->getAll();
        $single_banner = '';
        if( $id!= ''){
            $single_banner = $this->banner_repo->getById($id);
        } 
		
		//dd($single_banner, $banners, $affi);
        return view('Employee.banner_master', compact('single_banner', 'banners','affi'));
    }

    /**
        * Method name   : Create banner
        * @description  : Used for creating banner 
        * @param        : Request data for creating banner 
        * @return       : return with created banner 
    */
    public function create_banner()
    {
        $request = request();
        $type = $request->input('dd_banner_type');
        $img = '';

		if($request->input('dd_affiliate') == '')
		{
			Session::flash('banner_msg','Affiliate Name Required' );
			Session::flash('type','warning' );
			return redirect('/employee_banner');
		}

        $bannerName = '';

        if($request->file('txt_banner_img')){
            $image = $request->file('txt_banner_img');
            $time = date("d-m-Y")."-".time() ;
            $image_name = $image->getClientOriginalName();
            $bannerName = $request->input('txt_banner_var').$time.'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('images/front');

			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
				if($request->input('dd_banner_type') == 1){
					$img1 = Image::make($image->getRealPath())->resize(1170, 146);
					$img1->save($destinationPath.'\\'.$bannerName);                       
				}
				elseif($request->input('dd_banner_type') == 2){
					$img1 = Image::make($image->getRealPath())->resize(1920, 600);
					$img1->save($destinationPath.'/'.$bannerName);                 
				}
				elseif($request->input('dd_banner_type') == 3){
					$img1 = Image::make($image->getRealPath())->resize(1170, 146);
					$img1->save($destinationPath.'/'.$bannerName);                 
				}
				elseif($request->input('dd_banner_type') == 4){
					$img1 = Image::make($image->getRealPath())->resize(360, 230);
					$img1->save($destinationPath.'/'.$bannerName);                 
				}
				elseif($request->input('dd_banner_type') == 5){
					$img1 = Image::make($image->getRealPath())->resize(1170, 146);
					$img1->save($destinationPath.'/'.$bannerName);                 
				}
				elseif($request->input('dd_banner_type') == 6){
					$img1 = Image::make($image->getRealPath())->resize(500, 540);
					$img1->save($destinationPath.'/'.$bannerName);                 
				}
			}
			else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=Session::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
            
        }
        else
        {
            $bannerName = '' ;
        }

        $arr = array(
            'm47_banner_name' => $request->input('txt_banner_name'),
            'm47_banner_var' => $request->input('txt_banner_var'),
            'm47_banner_desc' => $request->input('txt_banner_desc'),
            'm47_banner_meta' => $request->input('txt_banner_meta'),
            'm47_banner_img' => $bannerName,
            'm47_banner_type' => $request->input('dd_banner_type'),
            'm47_banner_status' => $request->input('dd_banner_status'),
            'm47_created_by' => 2,
			'm47_created_by_id' => 1,
            'm47_affiliate_id' => $request->input('dd_affiliate')
        );

        $this->banner_repo->create($arr);
        Session::flash('banner_msg','BANNER IMAGE ADDED SUCCESSFULLY' );
        Session::flash('type','success' );
        return redirect('/employee_banner');
    }

    /**
        * Method name   : Create banner
        * @description  : Used for creating banner 
        * @param        : Request data for creating banner 
        * @return       : return with created banner 
    */
    public function update_banner($id)
    {
        $request = request();
        $type = $request->input('dd_banner_type');
        $img = '';

        $bannerName = '';

        if($request->file('txt_banner_img')){
            $image = $request->file('txt_banner_img');
            $time = date("d-m-Y")."-".time() ;
            $image_name = $image->getClientOriginalName();
            $bannerName = $request->input('txt_banner_var').$time.'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('images/front');

			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {

					if($request->input('dd_banner_type') == 1){
						$img1 = Image::make($image->getRealPath())->resize(1170, 146);
						$img1->save($destinationPath.'/'.$bannerName);                       
					}
					elseif($request->input('dd_banner_type') == 2){
					  $img1 = Image::make($image->getRealPath())->resize(1920, 600);
					  $img1->save($destinationPath.'/'.$bannerName);   
					}
					elseif($request->input('dd_banner_type') == 3){
						$img1 = Image::make($image->getRealPath())->resize(1170, 146);
						 $img1->save($destinationPath.'/'.$bannerName);                 
					}
					elseif($request->input('dd_banner_type') == 4){
						$img1 = Image::make($image->getRealPath())->resize(360, 230);
						 $img1->save($destinationPath.'/'.$bannerName);                 
					}
					elseif($request->input('dd_banner_type') == 5){
						$img1 = Image::make($image->getRealPath())->resize(1170, 146);
					   echo $img1->save($destinationPath.'/'.$bannerName);                 
					}
					elseif($request->input('dd_banner_type') == 6){
						$img1 = Image::make($image->getRealPath())->resize(500, 540);
						 $img1->save($destinationPath.'/'.$bannerName);                 
					}

			}
			else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=Session::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}

            
        }
        else
        {
            $bannerName = $request->input('txt_old_banner') ;
        }

        $arr = array(
            'm47_banner_name' => $request->input('txt_banner_name'),
            'm47_banner_var' => $request->input('txt_banner_var'),
            'm47_banner_desc' => $request->input('txt_banner_desc'),
            'm47_banner_meta' => $request->input('txt_banner_meta'),
            'm47_banner_img' => $bannerName,
            'm47_banner_type' => $request->input('dd_banner_type'),
            'm47_banner_status' => $request->input('dd_banner_status')
        );

        $this->banner_repo->update($id, $arr);
        Session::flash('banner_msg','BANNER IMAGE UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );
        return redirect('/employee_banner');
    }







    /**
        * Method name   : View Config
        * @description  : Used for getting config 
        * @param        : Request data with config id
        * @return       : return with single config
    */
    public function view_config( $id='' ){
        $status = '';
        $config = $this->wlconfig_repo->getAll();
		$affi = $this->Affiliate_repo->getAll();
		//dd($affi,$config);
        $singleconfig = '';
        if( $id!= ''){
            $singleconfig = $this->wlconfig_repo->getByIds($id);
            //dd($singleconfig);
            return view('Employee.view_config_home', compact('config', 'singleconfig','affi'));
        }else{
               return view('Employee.view_config_home', compact('config', 'singleconfig','affi'));
        }
    }

    /**
        * Method name   : Add mainconfig
        * @description  : Used for adding mainconfig 
        * @param        : Request data
        * @return       : return with added mainconfig 
    */
    public function add_mainconfig(){
        $request = request();
	
        $this->validate($request, [
            'txt_name'=> 'required',
            'txt_value' => 'required',
            'txt_desc' => 'required',
			'dd_affiliate' => 'required',
        ],[
            'txt_name.required'=> 'Name is required',
            'txt_value.required' => 'Value is required',
            'txt_desc.required'=> 'Description is required',
            'dd_affiliate.required'=> 'Affiliate is required'            
        ]);

        $arr = array(
            'm00_name' => $request->input('txt_name'),
            'm00_value' => $request->input('txt_value'),
            'm00_desc' => $request->input('txt_desc'),
            'm00_affid' => $request->input('dd_affiliate'),
            'm00_created_by' => 2,
            'm00_created_by_id' => Session()->get('USER_ID')
        );

        $this->wlconfig_repo->create($arr);
		Session::flash('config_msg','MAIN CONFIG ADDED SUCCESSFULLY' );
		Session::flash('type','success' );
        return redirect('/view_config_employee'); 
    }

    /**
        * Method name   : Update siteconfig
        * @description  : Used for updating siteconfig 
        * @param        : Request data with config id
        * @return       : return with updated siteconfig 
    */
    public function update_siteconfig($id){
        $request = request();

        $this->validate($request, [
            'txt_name'=> 'required',
            'txt_value' => 'required'
        ],[
            'txt_name.required'=> 'Name is required',
            'txt_value.required' => 'Value is required'     
        ]);

        $arr = array(
            'm00_name' => $request->input('txt_name'),
            'm00_value' => $request->input('txt_value'),
            'm00_desc' => $request->input('txt_desc'),
        );
        $this->wlconfig_repo->update($id, $arr);
		Session::flash('config_msg','MAIN CONFIG UPDATED SUCCESSFULLY' );
		Session::flash('type','success' );
        return redirect('/view_config_employee/'. $id); 
    }

    /**
        * Method name   : Update mainconfig
        * @description  : Used for updating mainconfig 
        * @param        : Request data with config id
        * @return       : return with updated mainconfig 
    */

    public function update_mainconfig($id){
        $request = request();

        $this->validate($request, [
            'txtusername'=> 'required',
            'txtuserpass' => 'required',
            'txtuserpinpass' => 'required'
        ],[
            'txtusername.required'=> 'User name is required',
            'txtuserpass.required' => 'User password is required',
            'txtuserpinpass.required'=> 'User pin password is required'      
        ]);

        $mcf=array(
        'm00_login_id'=>$id,
        'm00_username'=>$request->input('txtusername'),
        'm00_password'=>$request->input('txtuserpass'),
        'm00_pinpassword'=>$request->input('txtuserpinpass'),
        'm00_admin_type'=>$request->input('txtusertype'),
        'm00_admin_status'=>$request->input('txtuserstatus')
        );
       
        $result = $this->config_repo->setConfig($mcf);
		Session::flash('config_msg','MAIN CONFIG UPDATED SUCCESSFULLY' );
		Session::flash('type','success' );
        $singleconfig = $this->config_repo->getById($id);
        return redirect('/view_config_employee');
    }

    /**
        * Method name   : Update siteimage
        * @description  : Used for updating siteimage 
        * @param        : Request data with config id
        * @return       : return with updated siteimage 
    */
    public function update_siteimage($name, $id){
        $request = request();

        $image = "";
        $name1 = "";
        if($request->hasFile('txt_value') && $request->input('txt_site_logo')){
            $image = $request->file('txt_value');
            $name1 = time().'.'.$image->getClientOriginalExtension();
            //dd($name1);
            $destinationPath = public_path('/images/config/logo/');
			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name1);
				$thumbnailpath = public_path('/images/config/logo/'.$name1);
				$img = Image::make($thumbnailpath)->resize(150, 150, function($constraint) {
					$constraint->aspectRatio();
				});
				$img->save($thumbnailpath); 
			}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=Session::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
           
        }
        elseif($request->hasFile('txt_value') && $request->input('txt_bg_image')){
            $image = $request->file('txt_value');  
            $name1 = time().'.'.$image->getClientOriginalExtension();
            //dd($name1);
            $destinationPath = public_path('/images/config/bg/');
			$FileType = array('jpeg','png','jpg');
			if(in_array($image->getClientOriginalExtension(), $FileType)) {
				$image->move($destinationPath, $name1);
				$thumbnailpath = public_path('/images/config/bg/'.$name1);
				$img = Image::make($thumbnailpath)->resize(1440,800, function($constraint) {
					$constraint->aspectRatio();
				});
				$img->save($thumbnailpath); 
			}
				else{
					$request_data=json_encode($request->all());
					$file_type=$image->getClientOriginalName();
					$user_id=Session::get('USER_ID');
					$server_info=json_encode(request()->server());
					$user_info=json_encode(SESSION()->all()['result'][0]);
					$signup_data=Helper::unwanted_activity($request_data,$file_type,$user_id,$server_info,$user_info);  
					return back()->with('error', 'File format not supported.'); 
				}
        }  
		
		if($name1 == "")
		{
				Session::flash('config_msg','IMAGE NOT UPDATE' );
				Session::flash('type','worning' );
				return redirect('/view_config_employee'); 
		}

        $arr_bg = array(
            'm00_value' => $name1
        );

        $this->config_repo->update($id, $arr_bg);
        
        Session::flash('config_msg','SITE IMAGE UPDATED SUCCESSFULLY' );
		Session::flash('type','success' );
        return redirect('/view_config_employee'); 
    }





    /**
    * Method name   : orders
    * @description  : Used for viewing all user orders
    * @param        : Request data  
    * @return       : return view with all user orders
    */
    public function orders()
    {
        $request = request();
        $start = '2021-07-01';
        $end =  date('Y-m-d'); 
        $user_id = '';
        $order_id = '';
        $cond="";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
            $order_id = $request->input('txt_orderid');

            if($request->input('txt_memberid')!='')
            $user_id = Helper::get_userid($request->input('txt_memberid'));

            if($user_id != '' && $user_id != 'false')
            {
                $cond = $cond."`USER_ID` = $user_id  AND ";
            }
            if($order_id != '' && $order_id != 'false')
            {
                $cond = $cond."`ORDER_CODE` = '".$order_id."'  AND ";
            }
            if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
            {
                $cond = $cond."DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
            }
        }
        $cond = $cond." ORDER_STATUS != 'DELIVERED'  AND CART_TYPE != 'WISHLIST' ";
    	$all_orders = DB::select('SELECT * FROM `user_orders` WHERE '.$cond);

    	return view('Employee.orders', compact('all_orders')); 
    }
    


    /**
    * Method name   : orders
    * @description  : Used for viewing all user orders
    * @param        : Request data  
    * @return       : return view with all user orders
    */
    public function delivered_orders()
    {
        $request = request();
        $start = '2021-07-01';
        $end =  date('Y-m-d'); 
        $user_id = '';
        $order_id = '';
        $cond="";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
            $order_id = $request->input('txt_orderid');

            if($request->input('txt_memberid')!='')
            $user_id = Helper::get_userid($request->input('txt_memberid'));

            if($user_id != '' && $user_id != 'false')
            {
                $cond = $cond."`USER_ID` = $user_id  AND ";
            }
            if($order_id != '' && $order_id != 'false')
            {
                $cond = $cond."`ORDER_CODE` = '".$order_id."'  AND ";
            }
            if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
            {
                $cond = $cond."DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d')>=
                 DATE_FORMAT('".$start."','%Y-%m-%d') AND  DATE_FORMAT(`CREATED_AT`,'%Y-%m-%d')<=DATE_FORMAT('".$end."','%Y-%m-%d') AND";
            }
        }
        $cond = $cond."ORDER_STATUS = 'DELIVERED'  AND CART_TYPE != 'WISHLIST' ";
        $all_orders = DB::select('SELECT * FROM `user_orders` WHERE '.$cond);
        return view('Employee.delivered-orders', compact('all_orders')); 
    }
    
    

    /**
            * Method name   : view orders
            * @description  : Used for viewing single order
            * @param        : request user id 
            * @return       : return view single order
        */
    public function view_order()
    {
        $request = request();
        $single_order = "";
         //dd('dfg');
        if($request->method() == 'POST')
        {
               if($request->input('txt_orderid')=='')
                {
                    $ERRMSG = "Order id should be valid or not blank.";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
                else
                {
                    $ERRMSG = "";
                    $this->isError=FALSE;
                    $ERRCODE="success";
                }
                
                if(request()->method() == 'POST' && $this->isError==FALSE)
                {
                    $single_order = $this->order_repo->getByOrderCode($request->input('txt_orderid'));
                    
                    if($single_order!=null)
                    {
                    $ERRMSG = "Order details fetch successfully.";
                    $ERRCODE="success";
                    }
                    else
                    {
                    $ERRMSG = "Order not found.";
                    $this->isError=TRUE;
                    $ERRCODE="warning";
                    }
                }
        }

        return view('Employee.view_order',compact('single_order'));
     
    }

    /**
            * Method name   : view orders
            * @description  : Used for viewing single order
            * @param        : request user id 
            * @return       : return view single order
        */
    public function edit_order()
    {
        $request = request();
        $single_order = "";
        if($request->method() == 'POST')
        {
               if($request->input('txt_orderid')=='')
                {
                    $ERRMSG = "Order id should be valid or not blank.";
                    $this->isError= TRUE;
                    $ERRCODE="warning";
                }
                else
                {
                    $ERRMSG = "";
                    $this->isError=FALSE;
                    $ERRCODE="success";
                }
                
                if(request()->method() == 'POST' && $this->isError==FALSE)
                {
                    $single_order = $this->order_repo->getByOrderCode($request->input('txt_orderid'));
                    
                    if($single_order!=null)
                    {
                    $ERRMSG = "Order details fetch successfully.";
                    $ERRCODE="success";
                    }
                    else
                    {
                    $ERRMSG = "Order not found.";
                    $this->isError=TRUE;
                    $ERRCODE="warning";
                    }
                }
        }
        return view('Employee.edit_order',compact('single_order'));
     
    }

    public function update_order()
    {
        $request = request();
        if($request->method() == 'POST')
        {
            if($request->input('dd_orstatus')=='')
            {
                $ERRMSG = "Order status should be valid or not blank.";
                $this->isError= TRUE;
                $ERRCODE="warning";
            }
            else if($request->input('dd_paystatus')=='')
            {
                $ERRMSG = "Payment status should be valid or not blank.";
                $this->isError= TRUE;
                $ERRCODE="warning";
            }
            else
            {
                $ERRMSG = "";
                $this->isError=FALSE;
                $ERRCODE="success";
            }
            if(request()->method() == 'POST'&& $this->isError==FALSE)
            {
                $id = $request->input('txt_order_id');
                $single_order = $this->order_repo->getById($id);
                $arr = array(
                    'tr36_order_status' => $request->input('dd_orstatus'),
                    'tr36_payment_status' => $request->input('dd_paystatus')
                );

                $arrlog = array(
                    'tr11_ar_tblnm' => 'user_order',
                    'tr11_ar_old_value' => "ORDER_STATUS = ".$single_order[0]->ORDER_STATUS." PAYMENT_STATUS  =".$single_order[0]->PAYMENT_STATUS,
                    'tr11_ar_new_value' => "ORDER_STATUS = ".$request->dd_orstatus." PAYMENT_STATUS =".$request->dd_paystatus,
                    'tr11_ar_uid' => 1,
                    'tr11_ar_description' => 'ORDER STATUS HAS BEEN CHANGED SUCCESSFULLY!',
                    'tr11_updated_by' =>3,
                    'tr11_updated_by_id' =>  Session::get('USER_ID')
                    );
                

                $mobileno_actionrecord=$this->log_repo->create($arrlog);

                $this->order_repo->update($id,$arr);
            }
        }
        return redirect('/emp_orders');
    }



    public function update_revised_qty(request $request)
    {
          
            $single_order = $this->order_repo->getById($request->order_id);
            if(count($single_order) > 0)
            {

                $user_cart = json_decode($single_order[0]->PRODUCT_DETAILS);

                $prod_id_list = array_column($user_cart, 'prod_id');
                $varnt_id_list = array_column($user_cart, 'varnt_id');
                $is_variant_list = array_column($user_cart, 'is_variant');
                $count = count($user_cart);

                if(in_array($request->prod_id, $prod_id_list) && in_array($request->provar_id, $varnt_id_list) && in_array($request->proisvar, $is_variant_list))
                { 
                    for($i=0;$i<$count;$i++)
                    {
                        if(($user_cart[$i]->prod_id == $request->prod_id) && ($user_cart[$i]->varnt_id == $request->provar_id) && ($user_cart[$i]->is_variant == $request->proisvar))
                        {  
                            $index = $i;
                            $oldqty= $user_cart[$index]->new_quantity;
                            $user_cart[$index]->new_quantity = (int)($request->quantity);
                            $total = 0;
                            foreach ($user_cart as $value) {
                               $total += $value->new_quantity*$value->disc_price;
                            }
                              
                            $array = ['tr36_product_details' => json_encode($user_cart),
                                      'tr36_final_amount' => $total];

                            $data = $this->order_repo->update($request->order_id, $array);
                            if($data)
                            {

                                $arrlog = array(
                                    'tr11_ar_tblnm' => 'user_order',
                                    'tr11_ar_old_value' => "PRODUCT_DETAILS = ".$oldqty,
                                    'tr11_ar_new_value' => "PRODUCT_DETAILS = ".$user_cart[$index]->new_quantity,
                                    'tr11_ar_uid' => 1,
                                    'tr11_ar_description' => 'ORDER QTY HAS BEEN CHANGED SUCCESSFULLY!',
                                    'tr11_updated_by' => 3,
                                    'tr11_updated_by_id' =>  Session::get('USER_ID')
                                );

                                $mobileno_actionrecord=$this->log_repo->create($arrlog);

                                return 1;
                            }
                            else
                            {
                                return 2;
                            }
                        }
                    }
                }
            }
            else
            {
                return 2;
            }
    }



}