<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\Closing\ClosingRepository;
use App\Repositories\Fund\FundRepository;
use DB;
use Image;
use Session;
use Helper;

class ClosingController extends Controller
{

	private $closing_repo;
	private $fund_repo;

	public function __construct(ClosingRepository $closing_repo, FundRepository $fund_repo)
    {
    	$this->closing_repo = $closing_repo;
    	$this->fund_repo = $fund_repo;
    }

    /**
        * Method name   : Gen cashback
        * @description  : Used for generating cashback 
        * @param        : Request data  
        * @return       : return with generating cashback
    */
    public function gen_cashback()
	{
		$request = request();
		$start = '1970-01-01';
		$txtuserid = '';
		$queery="  ";
		$cashback_bonus="";
		$salary_report="";
		$queery="";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_to')));
			$txtuserid=$request->input('txt_userid');
			if($start != '' && $start != '1970-01-01')
			{
				$cashbackbonus=array(
					'fromdate'=>$start,
					'msg'=>@msg,
					'msg2'=>@msg2
		            );
					$cashback_bonus = $this->closing_repo->cbApprovDatewise($cashbackbonus);

					$queery = $queery."DATE_FORMAT(`CASHBACK_PAYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$start."','%Y-%m-%d') AND";

					$queery = $queery." CASHBACK_STATUS=2 LIMIT 1000";
					$salary_report = $this->closing_repo->getCashbackDates($queery);
			}
		}
		return view('Closing.gen_cashback_bonus',compact('cashback_bonus', 'salary_report'));
	}

	 /**
        * Method name   : Binary closing 
        * @description  : Used for generating binary closing 
        * @param        : Request data  
        * @return       : return with generating binary closing 
    */
	public function binary_closing()
    {
    	$request = request();
			$start = '1970-01-01';
			$end = '1970-01-01';
			$txtuserid = '';
			$queery="";
		   $payout_report= "";
			if($_SERVER['REQUEST_METHOD']=="POST")
			{
				$start = date('Y-m-d',strtotime($request->input('txt_payoutdate')));
				$end = date('Y-m-d',strtotime($request->input('txt_payoutdate')));
				
				if($request->input('txt_payoutdate')!=-1 && $start != '' && $start != '1970-01-01' )
		    	{
		    			$matchingbonus=array(
						'closing_from_date'=>$start,
						'closing_to_date'=>$end
			            );
						$matching_bonus=$this->closing_repo->matchPayout($matchingbonus);
						//dd($matching_bonus);
						DB::select("INSERT INTO `tr27_closing_date` (`tr27_closing_date`,`t27_closing_status`) VALUES ('".$start."',1)");
						$payoutreport=array(
						'queery'=>"1 "
						);
						$payout_report=$this->closing_repo->payoutReport($payoutreport);
				}
			}
			
		$generated_report = DB::select("SELECT DISTINCT(DATE_FORMAT(`tr19_topup_createdat`,'%Y-%m-%d') )  as tr26_to_closing_date from `tr19_user_topup` WHERE DATE_FORMAT(`tr19_topup_createdat`,'%Y-%m-%d') NOT IN( SELECT DISTINCT(DATE_FORMAT(`tr27_closing_date`,'%Y-%m-%d')) FROM tr27_closing_date WHERE t27_closing_status IN (1,2))");
    	$start = date('Y-m-d',strtotime($request->input('txt_payoutdate')));
    	return view('Closing.gen_binary', compact('payout_report'),compact('payout_report','generated_report','start'));

    }

    /**
        * Method name   : Cashback Bonus 
        * @description  : Used for cashback bonus report
        * @param        : Request data  
        * @return       : return with cashback bonus report
    */
    public function cashbackbonus()
		{
			$request = request();
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txt_memberid = '';
		$queery="";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$queery = $queery."DATE_FORMAT(`CASHBACK_PAYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
			if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
					$txt_memberid = Helper::get_userid($request->input('txt_memberid'));
					$queery = $queery."`USER_ID` = $txt_memberid  AND ";
				}
				//dd($queery);
		}
		//$queery = $queery."`USER_ID` = $txtuserid  AND ";
		$queery = $queery." CASHBACK_STATUS=2 ORDER BY CASHBACK_PAYDATE DESC LIMIT 1000";
		//dd($queery);
		$direct_report = $this->closing_repo->getCashbackDates($queery);
			return view('Closing.cashback_bonus',compact('direct_report'));
		}


/**
        * Method name   : Cashback LEVEL Bonus 
        * @description  : Used for cashback bonus report
        * @param        : Request data  
        * @return       : return with cashback bonus report
    */
    public function cashback_lvlbonus()
		{
		
		$request = request();
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txtuserid = '';
		$queery="";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$start = date('Y-m-d',strtotime($request->input('txt_from')));
			$end = date('Y-m-d',strtotime($request->input('txt_to')));
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$queery = $queery."DATE_FORMAT(`DIRECT_ENTRYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
		}
		$queery = $queery." DIRECT_DESCRIP='Level Income' AND DIRECT_LEVEL <>0  AND DIRECT_ISPUBLISH=1 ORDER BY DIRECT_ID DESC";
		$direct_report = $this->closing_repo->directDetails($queery);
			return view('Closing.cashback_lvlbonus',compact('direct_report'));
		}
	/**
        * Method name   : Cashback Bonus 
        * @description  : Used for cashback bonus report
        * @param        : Request data  
        * @return       : return with cashback bonus report
    */
	public function refferal_bonus()
	{
		$request = request();
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txtuserid = '';
		$queery="";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$queery = $queery."DATE_FORMAT(`DIRECT_ENTRYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND ";
			}
			if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
			{
					$txt_memberid =$request->input('txt_memberid');
					$queery = $queery."`USER_CODE` = $txt_memberid  AND ";
			}
		}
		$queery = $queery."DIRECT_LEVEL=1 AND DIRECT_DESCRIP='Direct Income' AND DIRECT_ISPUBLISH=1 ORDER BY DIRECT_ID DESC";
		$direct_report = $this->closing_repo->directDetails($queery);
		return view('Closing.refferal_bonus',compact('direct_report'));
	}
	/**
        * Method name   : Cashback Bonus 
        * @description  : Used for cashback bonus report
        * @param        : Request data  
        * @return       : return with cashback bonus report
    */
	public function level_bonus()
	{
		$request = request();
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txtuserid = '';
		$queery="";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$queery = $queery."DATE_FORMAT(`DIRECT_ENTRYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND ";
			}
			if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
			{
					$txt_memberid =$request->input('txt_memberid');;
					$queery = $queery."`USER_CODE` = $txt_memberid  AND ";
			}
		}
		$queery = $queery."DIRECT_LEVEL>1 AND  DIRECT_DESCRIP='Level Income' AND DIRECT_ISPUBLISH=1 ORDER BY DIRECT_ID DESC";
		$direct_report = $this->closing_repo->directDetails($queery);
		return view('Closing.level_bonus',compact('direct_report'));
	}
	/**
        * Method name   : Cashback Bonus 
        * @description  : Used for cashback bonus report
        * @param        : Request data  
        * @return       : return with cashback bonus report
    */
	public function roi_level_bonus()
	{
		$request = request();
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txtuserid = '';
		$queery="";
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
			$start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_todate')));
			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$queery = $queery."DATE_FORMAT(`DIRECT_ENTRYDATE`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND ";
			}
			if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
			{
					$txt_memberid =$request->input('txt_memberid');;
					$queery = $queery."`USER_CODE` = $txt_memberid  AND ";
			}
		}
		$queery = $queery."DIRECT_LEVEL>=1 AND  DIRECT_DESCRIP='Generation Level Income' AND DIRECT_ISPUBLISH=1 ORDER BY DIRECT_ID DESC";
		$direct_report = $this->closing_repo->directDetails($queery);
		return view('Closing.cb_level_bonus',compact('direct_report'));
	}
	/**
        * Method name   : Binary Closing report 
        * @description  : Used for binary closing report
        * @param        : Request data  
        * @return       : return with binary closing report
    */
	public function binary_closing_report()
    {

		$request = request();
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$descrip="";
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txt_account = '';
		$txt_memberid = Session::get('USER_ID');
		$txt_transid = '';
		$txt_noofrecords = '1000';
		$dd_ledgertype='5';
		$cond="";
	
		
		$cond1=" 1 ";
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
		    $start = date('Y-m-d',strtotime($request->input('txt_payoutdate')));
			$end = date('Y-m-d',strtotime($request->input('txt_payoutdate')));

			if($request->input('txt_payoutdate')!=-1 && $start != '' && $start != '1970-01-01' )
			{
				$cond = $cond."DATE_FORMAT(`tr26_to_closing_date`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
			if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
					$txt_memberid = Helper::get_userid($request->input('txt_memberid'));
					$cond = $cond."`tr26_closing_detail`.`m11_user_id`  = ".$txt_memberid." AND ";
				}
			$cond=$cond.$cond1;
		}
		if($_SERVER['REQUEST_METHOD']=="GET")
        {
		$cond=$cond.$cond1;
		}
		//echo $cond;
		$payoutreport=array(
		'queery'=>$cond
        );
		$payout_report=$this->closing_repo->payoutReport($payoutreport);
		$start = date('Y-m-d',strtotime($request->input('txt_payoutdate')));
		$generated_report = DB::select("SELECT DISTINCT(tr26_to_closing_date)  AS tr26_to_closing_date FROM tr26_closing_detail WHERE 1 ORDER BY tr26_to_closing_date DESC ");
    	return view('Closing.matching_bonus', compact('payout_report','generated_report','start'));

    }

    /**
        * Method name   : Binary Closing reverse 
        * @description  : Used for binary closing reverse
        * @param        : Request data  
        * @return       : return with binary closing reverse
    */
    public function binary_closing_reverse()
    {
    	$request = request();		
    	$generated_report = $this->closing_repo->closingIsPublish();
    	return view('Closing.binary_closingreverse', compact('generated_report'));

    }

    /**
        * Method name   : Binary Closing publish 
        * @description  : Used for binary closing publish
        * @param        : Request data  
        * @return       : return with binary closing publish
    */
    public function binary_closing_publish()
    {
   		$request = request();	
		if($_SERVER['REQUEST_METHOD']=="POST")
		{
				$start = date('Y-m-d',strtotime($request->input('txt_payoutdate')));
				if($request->input('txt_payoutdate') != -1 &&  $start != '1970-01-01' ){
					
					$payoutreport=array(
					'pay_date'=>$start
					);
					$payout_report=DB::select('CALL matchpayout_release(:pay_date,@status_code,@status_msg)',$payoutreport);
				}
		}
    	$generated_report = $this->closing_repo->closingIsPublish();
    	return view('Closing.binary_closingpublish', compact('generated_report'));

    }

    /**
        * Method name   : Binary Closing Userwise 
        * @description  : Used for binary closing userwise report
        * @param        : Request data  
        * @return       : return with binary closing userwise report
    */
    public function binary_closing_userwise()
    {
    	$request = request();
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$descrip="";
		$start = '1970-01-01';
		$end ='1970-01-01';
		$txt_account = '';
		$txt_memberid = Session::get('USER_ID');
		$txt_transid = '';
		$txt_noofrecords = '1000';
		$dd_ledgertype='5';
		$cond="";
	
		
		$cond1=" 1 ";
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
		    $start = date('Y-m-d',strtotime($request->input('txtfromdate')));
			$end = date('Y-m-d',strtotime($request->input('txttodate')));

			if($start != '' && $end != '' && $start != '1970-01-01' && $end != '1970-01-01')
			{
				$cond = $cond."DATE_FORMAT(`tr26_to_closing_date`,'%Y-%m-%d') between DATE_FORMAT('".$start."','%Y-%m-%d') and  DATE_FORMAT('".$end."','%Y-%m-%d') AND";
			}
			if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
			{
					$txt_memberid = Helper::get_userid($request->input('txt_memberid'));
					$cond = $cond."`tr26_closing_detail`.`m11_user_id` = $txt_memberid  AND ";
			}
			$cond=$cond.$cond1;
		}
		if($_SERVER['REQUEST_METHOD']=="GET")
        {
		$cond=$cond.$cond1;
		}
		
		$payoutreport=array(
		'queery'=>$cond
        );
		$payout_report=$this->closing_repo->payoutReport($payoutreport);

    	return view('Closing.binary_closinguserwise', compact('payout_report'));

    }


    // PAYMENT module here

    /**
        * Method name   : Payment Report 
        * @description  : Used for payment report
        * @param        : Request data  
        * @return       : return with payment report
    */
	public function payment_report()
    {
    	$request = request();

    	if($_SERVER['REQUEST_METHOD']=="POST")
		{
		    	if($request->input('txt_userid')!="" && $request->input('txt_userid')!="0")
				{
					$txt_memberid = Helper::get_userid($request->input('txt_userid'));
				}	
				$paymentreport=array(
				'proc'=>2,
				'userid'=> $txt_memberid
	            );
		}
		else{
			$paymentreport=array(
			'proc'=>1,
			'userid'=>-1
            );
		}			

    		
    	$payment_release = $this->closing_repo->paymentReport($paymentreport);
    	return view('Closing.all_payreport', compact('payment_release'));
    }

    /**
        * Method name   : Payment Release 
        * @description  : Used for payment release
        * @param        : Request data  
        * @return       : return with payment release report
    */
    public function payment_release()
    {
		$request = request();
		$txt_memberid=-1;		
    	if($_SERVER['REQUEST_METHOD']=="POST")
		{
		    	if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
					$txt_memberid = Helper::get_userid($request->input('txt_memberid'));
					
					$paymentreport=array(
					'proc'=>2,
					'userid'=> $txt_memberid
		            );
				}
				else
				{
						$paymentreport=array(
						'proc'=>1,
						'userid'=>$txt_memberid
			            );
				}

		}
		else
		{
			$paymentreport=array(
			'proc'=>1,
			'userid'=>$txt_memberid
            );
		}
    	$payment_release = $this->closing_repo->paymentReport($paymentreport);
    	return view('Closing.payment_release',compact('payment_release'));
    }

    /**
        * Method name   : Payment Release Report
        * @description  : Used for payment release report
        * @param        : Request data  
        * @return       : return with payment release report
    */
     public function payment_release_report()
    {
		$request = request();
			$descrip="";
			$start = '1970-01-01';
			$end ='1970-01-01';
			$txt_account = '';
			$txt_memberid = "";
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_ledgertype='-5';
			$cond="";
			$cond1="1 AND `tr03_bal_type`=2 ";
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
				$end = date('Y-m-d',strtotime($request->input('txt_todate')));
				
			
				if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
					$txt_memberid = Helper::get_userid($request->input('txt_memberid'));
				}
				if($request->input('dd_ledgertype')!="" && $request->input('dd_ledgertype')!=-1)
				{
					$dd_ledgertype=$request->input('dd_ledgertype');
				}
				
			}
			$cond=$cond.$cond1;
			$ledgerreport=array(
			'proc'=>2,
			'account'=>"",
			'transid'=>$txt_transid,
			'userid'=>$txt_memberid,
			'fromdate'=>$start,
			'todate'=>$end,
			'noofrecords'=>$txt_noofrecords,
			'ledegerstatus'=>$dd_ledgertype,
			'descrip'=>$cond
			
            );
			$ledger_report=$this->fund_repo->ledgerReport($ledgerreport);
    	return view('Closing.payrelease_report', compact('ledger_report'));

    }

    /**
        * Method name   : Pay Payment
        * @description  : Used for paying payment
        * @param        : Request data  
        * @return       : return with paying payment
    */
    public function pay_payment( Request $request )
		{
			$res = $curr_bal = $bal = 0;
			$lid = $request->input('txt_payregid');
			$bal =$request->input('txt_payamt');
			$curr_bal_res = $this->closing_repo->paymentReport($lid, 2);
			$curr_bal_res1 = $this->closing_repo->paymentReport($lid, 1);
			$curr_bal_res3 = $this->closing_repo->paymentReport($lid, 3);
			if(!empty($curr_bal_res)){
				$curr_bal = $curr_bal_res[0]->BAL;
				$res = $curr_bal-$bal;
			}
			$transid_arr = DB::select("select get_transaction_id() AS transid");
			if(!empty($transid_arr)){
				$transid = $transid_arr[0]->transid;
			}
			if($bal != 0){
				$insert_data = array(
				'm11_user_id'=>$lid,
				'tr03_trans_id'=>$transid,
				'tr03_refrence_id'=>0,
				'tr03_cramount'=>0,
				'tr03_dramount'=>$bal,
				'tr03_deduction'=>$bal,
				'tr03_ledger_type'=>15,
				'tr03_bal_type'=>2,
				'tr03_current_balance'=>$curr_bal_res1[0]->BAL,
				'tr03_utility_bal'=>$res,
				'tr03_remit_bal'=>$curr_bal_res3[0]->BAL,
				'tr03_trans_from'=>$request->input('dd_paymode'),
				'tr03_description'=>$request->input('txt_remark'),
				'tr03_trans_onadd'=>date('Y-m-d H:i:s'),
				'tr03_trans_onupadte'=>date('Y-m-d H:i:s')
				); 
				//print_r($insert_data);
				$bol  =  DB::table('tr03_manage_ledger')->insert( $insert_data );
				Session::flash( 'type', 'success' );
				Session::flash( 'message', 'Payment Done Successfully' );
			} 
			
			return redirect()->to('payment_release');
		}
}
