<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use App\Repositories\Master\Banner\BannerRepository;
use App\Repositories\Master\Operator\OperatorRepository;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use App\Repositories\ProductModule\Categories\CategoriesRepository;
use App\Repositories\ProductModule\Brand\BrandRepository;
use App\Repositories\ProductModule\Products\ProductsRepository;
use App\Repositories\ProductModule\Optiongroup\OptiongroupRepository;
use App\Repositories\ProductModule\Unit\UnitRepository;
use App\Repositories\Affiliate\AffiliateRepository;
use App\Repositories\ProductModule\ParentCategories\ParentCategoriesRepository;
use App\Repositories\ProductModule\ProductVariant\ProductVariantRepository;
use App\Repositories\ProductModule\Market\MarketRepository;
use App\Repositories\ProductModule\OptionType\OptionTypeRepository;
use App\Repositories\ProductModule\UserOrders\UserOrdersRepository;
use App\Repositories\ProductModule\Wishlist\WishlistRepository;
use App\Repositories\ProductModule\UserAddress\UserAddressRepository;
use Cookie;
use Cache;
use Session;
use DB;
use Helper;
use Storage;
use Carbon\Carbon;

class CartController extends Controller
{
    private $banner_repo;   
    private $cat_repo;
    private $brand_repo;
    private $prod_repo;
    private $optgrp_repo;
    private $unit_repo;
    private $Affiliate_repo;
    private $market_repo;
    private $parentcat_repo;
    private $prod_varnt;
    private $optype_repo;
    private $telecom_brand_repo;
    private $address_repo;
    private $wishlist_repo;
    private $orders_repo;


    public function __construct(BannerRepository $banner_repo, CategoriesRepository $cat_repo, BrandRepository $brand_repo,
        ProductsRepository $prod_repo, OptiongroupRepository $optgrp_repo, 
        UnitRepository $unit_repo, AffiliateRepository $Affiliate_repo, MarketRepository $market_repo,
        ParentCategoriesRepository $parentcat_repo, ProductVariantRepository $prod_varnt,
         OptionTypeRepository $optype_repo, OperatorRepository $telecom_brand_repo, UserAddressRepository $address_repo, WishlistRepository $wishlist_repo, UserOrdersRepository $orders_repo)
    {
        $this->banner_repo = $banner_repo;
        $this->cat_repo = $cat_repo;
        $this->brand_repo = $brand_repo;
        $this->prod_repo = $prod_repo;
        $this->optgrp_repo = $optgrp_repo;
        $this->unit_repo = $unit_repo;
        $this->Affiliate_repo = $Affiliate_repo;
        $this->market_repo = $market_repo;
        $this->parentcat_repo = $parentcat_repo;
        $this->prod_varnt = $prod_varnt;
        $this->optype_repo = $optype_repo;
        $this->telecom_brand_repo = $telecom_brand_repo;        
        $this->address_repo = $address_repo;
        $this->wishlist_repo = $wishlist_repo;
        $this->orders_repo = $orders_repo;
    }

     
    public function addtocart(Request $request)
    {
            $user_cart = json_decode(Cookie::get('cart'));

            if($request->isvariant == "NO")
            {
                $product = $this->prod_repo->getById($request->proid);
                if(count($product) > 0){
                $varnt_id   =   '0';
                $unitname   =   $product[0]->UNIT_NAME;
                $unitid     =   $product[0]->PROD_UNIT;
                $capacity   =   $product[0]->PROD_CAPACITY;
                $price      =   $product[0]->PROD_PRICE;
                $discprice  =   $product[0]->PROD_DISCPRICE;
                $cget       =   $product[0]->PROD_CGST;
                $sgst       =   $product[0]->PROD_SGST;
                $igst       =   $product[0]->PROD_IGST;
                $sku        =    $product[0]->PROD_SKU;
                $hsncode    =    $product[0]->HSN_CODE;
                $isvariant  =   "NO";
                $groupname  =   $product[0]->GROUP_NAME;
                $optionname =   $product[0]->OPT_NAME;
                $groupname1 =   $product[0]->GROUP_NAME1;
                $optionname1=   $product[0]->OPT_NAME1;}

            }
            if($request->isvariant == "YES")
            {
                $product_varnt =  $this->prod_varnt->getById($request->proid); 
                $product = $this->prod_repo->getById($product_varnt[0]->PROD_ID);

                if(count($product) > 0){
                $varnt_id   =   $product_varnt[0]->VARNT_ID;
                $unitname   =   $product_varnt[0]->UNIT_NAME;
                $unitid     =   $product_varnt[0]->UNIT_ID;
                $capacity   =   $product_varnt[0]->VARNT_CAPACITY;
                $price      =   $product_varnt[0]->VARNT_PRICE;
                $discprice  =   $product_varnt[0]->VARNT_DISCPRICE;
                $cget       =   $product_varnt[0]->VARNT_CGST;
                $sgst       =   $product_varnt[0]->VARNT_SGST;
                $igst       =   $product_varnt[0]->VARNT_IGST;
                $sku       =    $product_varnt[0]->VARNT_SKU;
                $hsncode       =    $product_varnt[0]->VARNT_HSN_CODE;
                $isvariant  =   "YES";
                $groupname  =   $product_varnt[0]->GROUP_NAME;
                $optionname =   $product_varnt[0]->OPT_NAME;
                $groupname1 =   $product_varnt[0]->GROUP_NAME1;
                $optionname1=   $product_varnt[0]->OPT_NAME1;}
            }


            if(empty($user_cart))
            {
                $user_cartdata1 = [];
                $quant = 1;
            
                $user_cartdata=
                [
                    'prod_id'       =>      $product[0]->PROD_ID,
                    'is_variant'    =>      $isvariant,
                    'varnt_id'      =>      $varnt_id,
                    'name'          =>      $product[0]->PROD_NAME,
                    'market_id'     =>      $product[0]->MARKET_ID,
                    'market_name'   =>      $product[0]->MARKET_NAME,
                    'brand_name'    =>      $product[0]->BRAND_NAME,
                    'image'         =>      $product[0]->PROD_IMAGE,
                    'quantity'      =>      $quant,
                    'new_quantity'  =>      $quant,
                    'unit_id'       =>      $unitid,
                    'unit_name'     =>      $unitname,
                    'capacity'      =>      $capacity,
                    'group_name'    =>      $groupname,
                    'option_name'   =>      $optionname,
                    'group_name1'   =>      $groupname1,
                    'option_name1'  =>      $optionname1,
                    'price'         =>      $price,
                    'disc_price'    =>      $discprice,
                    'cget'          =>      $cget,
                    'sgst'          =>      $sgst,
                    'igst'          =>      $igst,
                    'hsncode'       =>      $hsncode,
                    'sku'           =>      $sku,
                ];

                array_push($user_cartdata1, $user_cartdata);        
                Cookie::queue('cart', json_encode($user_cartdata1), 100);

            }
            else
            {
                $prod_id_list = array_column($user_cart, 'prod_id');
                $varnt_id_list = array_column($user_cart, 'varnt_id');
                $is_variant_list = array_column($user_cart, 'is_variant');
                $count = count($user_cart);

                    if(in_array($product[0]->PROD_ID, $prod_id_list) && in_array($varnt_id, $varnt_id_list) && in_array($isvariant, $is_variant_list))
                    {
                        $key = array_search($product[0]->PROD_ID, $prod_id_list);
                        $user_cart[$key]->quantity++;
                        $user_cart[$key]->new_quantity++;
                        Cookie::queue('cart', json_encode($user_cart), 100);
                    }
                    else
                    {
                        $quant = 1;
                        $user_cartdata=
                            [
                                'prod_id'       =>      $product[0]->PROD_ID,
                                'is_variant'    =>      $isvariant,
                                'varnt_id'      =>      $varnt_id,
                                'name'          =>      $product[0]->PROD_NAME,
                                'market_id'     =>      $product[0]->MARKET_ID,
                                'market_name'   =>      $product[0]->MARKET_NAME,
                                'brand_name'    =>      $product[0]->BRAND_NAME,
                                'image'         =>      $product[0]->PROD_IMAGE,
                                'quantity'      =>      $quant,
                                'new_quantity'  =>      $quant,
                                'unit_id'       =>      $unitid,
                                'unit_name'     =>      $unitname,
                                'capacity'      =>      $capacity,
                                'group_name'    =>      $groupname,
                                'option_name'   =>      $optionname,
                                'group_name1'   =>      $groupname1,
                                'option_name1'  =>      $optionname1,
                                'price'         =>      $price,
                                'disc_price'    =>      $discprice,
                                'cget'          =>      $cget,
                                'sgst'          =>      $sgst,
                                'igst'          =>      $igst
                            ];

                        array_push($user_cart, $user_cartdata);
                        Cookie::queue('cart', json_encode($user_cart), 100);
                    }
            }

            return 1;
    }




    public function get_cart_data()
    {
        $user_cart = json_decode(Cookie::get('cart'));

        if(empty($user_cart) && Session::get('USER_ID'))
        {        
            $getdbcart = $this->orders_repo->getByOrderCodeWish(Session::get('USER_ID'), 'WISHLIST');

            if(count($getdbcart) > 0)
            {   
                if(count(json_decode($getdbcart[0]->PRODUCT_DETAILS)) > 0)
                {   
                    $user_cart = json_decode($getdbcart[0]->PRODUCT_DETAILS);
                    Cookie::queue('cart', $getdbcart[0]->PRODUCT_DETAILS, 100);
                }
                else
                {
                    $this->orders_repo->delete($getdbcart[0]->ORDER_ID);
                }   
            }
        }

        $total =0;
        $ditotal =0;
        $totalquantity = 0;
        
        foreach ($user_cart as $value) 
        {
            $total = (float)($total) + (float)($value->disc_price * $value->quantity);
            $ditotal = (float)($ditotal) + (float)($value->price * $value->quantity);
            $totalquantity = $totalquantity + (int)($value->quantity);
        }

        if($total <= config('DELIVERY_PRICE'))
        {
            $deliveryprice = (float)(config('DELIVERY_CHARGE'));
        }
        else
        {
            $deliveryprice = 0;
        }


        if(Session::get('USER_ID'))
        {   
            $data = $this->orders_repo->getByUserId(Session::get('USER_ID'));
            if(count($data) > 0)
            {
                $user_typen = 1;
            }
            else
            {
                $user_typen = 2;
            }

            $cartinfocheck = $this->orders_repo->getByOrderCodeWish(Session::get('USER_ID'), 'WISHLIST');

            if(count($cartinfocheck) > 0)
            {   
                $usercartdata = json_encode($user_cart);

                if(count($user_cart) > 0)
                {
                   $this->orders_repo->update($cartinfocheck[0]->ORDER_ID, ['tr36_product_details' => $usercartdata, 'tr36_delivery_fee' => $deliveryprice, 'tr36_final_amount' => $total]);
                }
            }
            else
            {
                $usercartdata = json_encode($user_cart);
                $array = [
                    'tr36_order_id'         =>  'MARTAD'.time(),
                    'm11_user_id'           =>  Session::get('USER_ID'),
                    'tr36_product_details'  =>  $usercartdata,
                    'tr36_user_type'        =>  $user_typen,
                    'tr36_user_type'        =>  $user_typen,
                    'tr36_final_amount'     =>  $total,
                    'tr36_cart_type'        =>  1,
                    'tr36_delivery_fee'     =>  $deliveryprice,
                ];

                if(count($user_cart) > 0)
                {  
                    $this->orders_repo->create($array);
                }
            }

        }



        $cart = '<ul class="offcanvas-add-cart__menu">';

        foreach ($user_cart as $key => $value) 
        { 
           $img = explode(",",$value->image);
           if(count($img) > 0){ $images = $img[0]; }else{ $images = ''; }
           $cart .= '<li class="offcanvas-add-cart__list pos-relative d-flex align-items-center justify-content-between"><div class="offcanvas-add-cart__content d-flex align-items-start m-r-10"><div class="offcanvas-add-cart__img-box pos-relative"><a href="'.url('product/'.str_replace(' ', '_',"$value->name").'/'.$value->prod_id).'" class="offcanvas-add-cart__img-link img-responsive">';
           $cart .= '<img src="'.asset('images/prod_logo/'.$images).'" alt="image" class="add-cart__img"></a><span class="offcanvas-add-cart__item-count pos-absolute">'.$value->quantity.'</span></div><div class="offcanvas-add-cart__detail"><a href="'.url('/').'" class="offcanvas-add-cart__link">'.$value->name.'</a><span class="offcanvas-add-cart__price">&#x20B9;'.number_format($value->disc_price,2).'</span><span class="offcanvas-add-cart__info">'.$value->capacity.' : '.$value->unit_name.'</span><form class="modal-quantity-scale m-l-20"><div class="value-button" id="modal-decrease'.$value->prod_id.$value->is_variant.$value->varnt_id.'"  data-dcpro_id="'.$value->prod_id.'" data-dcprovar_id="'.$value->varnt_id.'" data-dcproisvar_id="'.$value->is_variant.'" data-dquantity_id="'.$value->quantity.'" onclick="decreaseValueModal(this.id)">-</div><input type="number" id="modal-number" value="'.$value->quantity.'" readonly/><div class="value-button" id="modal-increase'.$value->prod_id.$value->is_variant.$value->varnt_id.'"  data-rcpro_id="'.$value->prod_id.'" data-rcprovar_id="'.$value->varnt_id.'" data-rcproisvar_id="'.$value->is_variant.'" data-rquantity_id="'.$value->quantity.'" onclick="increaseValueModal(this.id)">+</div></form></div></div><button class="offcanvas-add-cart__item-dismiss" onclick="RemoveCartProd(this.id)" id="'.$value->prod_id.$value->is_variant.$value->varnt_id.'" data-cpro_id="'.$value->prod_id.'" data-cprovar_id="'.$value->varnt_id.'" data-cproisvar_id="'.$value->is_variant.'" ><i class="fal fa-times"></i></button></li>';
        }

        $cart .='</ul><div class="offcanvas-add-cart__checkout-box-bottom"><ul class="offcanvas-add-cart__checkout-info"><li class="offcanvas-add-cart__checkout-list"><span class="offcanvas-add-cart__checkout-left-info">Subtotal</span><span class="offcanvas-add-cart__checkout-right-info">&#x20B9;'.number_format($total,2).'</span></li><li class="offcanvas-add-cart__checkout-list"><span class="offcanvas-add-cart__checkout-left-info">Shipping</span><span class="offcanvas-add-cart__checkout-right-info">&#x20B9;'.number_format($deliveryprice,2).'</span></li><li class="offcanvas-add-cart__checkout-list"><span class="offcanvas-add-cart__checkout-left-info">Total Discount</span><span class="offcanvas-add-cart__checkout-right-info">&#x20B9;'.number_format($ditotal-$total,2).'</span></li><li class="offcanvas-add-cart__checkout-list"><span class="offcanvas-add-cart__checkout-left-info">Total</span><span class="offcanvas-add-cart__checkout-right-info">&#x20B9;'.number_format($total+$deliveryprice,2).'</span></li></ul><div class="offcanvas-add-cart__btn-checkout"><a href="'.url('checkout').'" class="btn btn--block btn--radius btn--box btn--black btn--black-hover-green btn--large btn--uppercase font--bold">Checkout</a></div></div>';
        
        $data['count'] = $totalquantity;
        $data['cart'] = $cart; 
        return $data;     

    }

    public function remove_cart_pro(request $request)
    {
        $user_cart = json_decode(Cookie::get('cart'));

        $prod_id_list = array_column($user_cart, 'prod_id');
        $varnt_id_list = array_column($user_cart, 'varnt_id');
        $is_variant_list = array_column($user_cart, 'is_variant');
        $count = count($user_cart);

        if(in_array($request->prod_id, $prod_id_list) && in_array($request->provar_id, $varnt_id_list) && in_array($request->proisvar, $is_variant_list))
        {
            for($i=0;$i<$count;$i++)
            {         
                if(($user_cart[$i]->prod_id == $request->prod_id) && ($user_cart[$i]->varnt_id == $request->provar_id) && ($user_cart[$i]->is_variant == $request->proisvar))
                {  
                    $index = $i;
                    array_splice($user_cart, $index, 1);
                    Cookie::queue('cart', json_encode($user_cart), 100);
                    if(Session::get('USER_ID'))
                    {
                        $cartinfocheck = $this->orders_repo->getByOrderCodeWish(Session::get('USER_ID'), 'WISHLIST');

                        if(count($cartinfocheck) > 0)
                        {   
                            $usercartdata = json_encode($user_cart);
                            if(count($user_cart) > 0)
                            {
                                $this->orders_repo->update($cartinfocheck[0]->ORDER_ID, ['tr36_product_details' => $usercartdata]);
                            }
                            else
                            {
                                $this->orders_repo->delete($cartinfocheck[0]->ORDER_ID);
                            }
                        }
                    }
                }

            }
        }
           
        return 1;
    }



    public function decrease_value_cart_pro(request $request)
    {
       
        $user_cart = json_decode(Cookie::get('cart'));

        $prod_id_list = array_column($user_cart, 'prod_id');
        $varnt_id_list = array_column($user_cart, 'varnt_id');
        $is_variant_list = array_column($user_cart, 'is_variant');
        $quantity = array_column($user_cart, 'quantity');
        $count = count($user_cart);



        if(in_array($request->prod_id, $prod_id_list) && in_array($request->provar_id, $varnt_id_list) && in_array($request->proisvar, $is_variant_list))
        { 

            if($request->quantity-1 > 0)
            {
                for($i=0;$i<$count;$i++)
                {         
                    if(($user_cart[$i]->prod_id == $request->prod_id) && ($user_cart[$i]->varnt_id == $request->provar_id) && ($user_cart[$i]->is_variant == $request->proisvar))
                    {  
                        $index = $i;
                        $user_cart[$index]->quantity--;
                        $user_cart[$index]->new_quantity--;
                        Cookie::queue('cart', json_encode($user_cart), 100);

                        if(Session::get('USER_ID'))
                        {
                            $cartinfocheck = $this->orders_repo->getByOrderCodeWish(Session::get('USER_ID'), 'WISHLIST');

                            if(count($cartinfocheck) > 0)
                            {   
                                $usercartdata = json_encode($user_cart);
                                if(count($user_cart) > 0)
                                {

                                    $total = 0;
                                    foreach ($user_cart as $value) {
                                       $total += $value->new_quantity*$value->disc_price;
                                    }

                                    $this->orders_repo->update($cartinfocheck[0]->ORDER_ID, ['tr36_product_details' => $usercartdata,
                                       'tr36_final_amount' => $total]);
                                }
                                else
                                {
                                    $this->orders_repo->delete($cartinfocheck[0]->ORDER_ID);
                                }
                            }
                        }
                    }
                }
            }
            else
            {
                for($i=0;$i<$count;$i++)
                {         
                    if(($user_cart[$i]->prod_id == $request->prod_id) && ($user_cart[$i]->varnt_id == $request->provar_id) && ($user_cart[$i]->is_variant == $request->proisvar))
                    {  
                        $index = $i;
                        array_splice($user_cart, $index, 1);
                        Cookie::queue('cart', json_encode($user_cart), 100);
                        if(Session::get('USER_ID'))
                        {
                            $cartinfocheck = $this->orders_repo->getByOrderCodeWish(Session::get('USER_ID'), 'WISHLIST');

                            if(count($cartinfocheck) > 0)
                            {   
                                $usercartdata = json_encode($user_cart);
                                if(count($user_cart) > 0)
                                {
                                    $total = 0;
                                    foreach ($user_cart as $value) {
                                       $total += $value->new_quantity*$value->disc_price;
                                    }

                                    $this->orders_repo->update($cartinfocheck[0]->ORDER_ID, ['tr36_product_details' => $usercartdata,
                                      'tr36_final_amount' => $total]);
                                }
                                else
                                {
                                    $this->orders_repo->delete($cartinfocheck[0]->ORDER_ID);
                                }
                            }
                        }
                    }
                }
            }

        }
           
        return 1;
    }



    public function increase_value_cart_pro(request $request)
    {
       
        $user_cart = json_decode(Cookie::get('cart'));

        $prod_id_list = array_column($user_cart, 'prod_id');
        $varnt_id_list = array_column($user_cart, 'varnt_id');
        $is_variant_list = array_column($user_cart, 'is_variant');
        $quantity = array_column($user_cart, 'quantity');
        $count = count($user_cart);

        if(in_array($request->prod_id, $prod_id_list) && in_array($request->provar_id, $varnt_id_list) && in_array($request->proisvar, $is_variant_list))
        {
            for($i=0;$i<$count;$i++)
            {         
                if(($user_cart[$i]->prod_id == $request->prod_id) && ($user_cart[$i]->varnt_id == $request->provar_id) && ($user_cart[$i]->is_variant == $request->proisvar))
                {  
                    $index = $i;
                    $user_cart[$index]->quantity++;
                    $user_cart[$index]->new_quantity++;
                              
                    Cookie::queue('cart', json_encode($user_cart), 100);

                    if(Session::get('USER_ID'))
                    {
                        $cartinfocheck = $this->orders_repo->getByOrderCodeWish(Session::get('USER_ID'), 'WISHLIST');

                        if(count($cartinfocheck) > 0)
                        {   
                            $usercartdata = json_encode($user_cart);
                            if(count($user_cart) > 0)
                            {
                                $total = 0;
                                foreach ($user_cart as $value) {
                                   $total += $value->new_quantity*$value->disc_price;
                                }

                                $this->orders_repo->update($cartinfocheck[0]->ORDER_ID, ['tr36_product_details' => $usercartdata,
                                      'tr36_final_amount' => $total]);
                            }
                            else
                            {
                                $this->orders_repo->delete($cartinfocheck[0]->ORDER_ID);
                            }
                        }
                    }
                }
            }
        }
           
        return 1;
    }



    public function get_coupan_amount()
    {   
        $USERCOUPAN = 0;
        if(Session::get('USER_ID'))
        {   
            $user = Helper::get_userdetail(Session::get('USER_ID'));
            $topup = DB::select("SELECT * FROM tr19_user_topup WHERE m11_user_id =".Session::get('USER_ID')." ORDER BY tr19_user_tpid LIMIT 1");

            if(count($topup) > 0 && count($user) > 0)
            {
                $coupanamt = DB::table('m27_package')->where('m27_pack_id', $topup[0]->m27_pack_id)->first();
                
                if($coupanamt != '')
                {

                    $topupusethisamt=(float)$coupanamt->m27_coupan_amt/(float)config('TOPUP_DIVIDE_INMONTH');

                    $to = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', $topup[0]->tr19_topup_createdat);
                    $from = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', date('Y-m-d h:i:s'));
                    $diff_in_months = $to->diffInMonths($from);

                    if(config('TOPUP_AMO_DED') == 'YES')
                    {
                        $diff_in_months = 1;
                        if($diff_in_months > $topup[0]->tr19_coupan_noofuse)
                        {
                            $dedamt = ($diff_in_months-$topup[0]->tr19_coupan_noofuse)*$topupusethisamt;
                            $useamt = $topup[0]->tr19_coupan_useamt+$dedamt;
                            $noofuse = $topup[0]->tr19_coupan_noofuse+($diff_in_months-$topup[0]->tr19_coupan_noofuse);

                            DB::update("UPDATE `tr19_user_topup` SET `tr19_coupan_useamt` = ".$useamt.", `tr19_coupan_noofuse` = ".$noofuse." WHERE `tr19_user_tpid` = ".$topup[0]->tr19_user_tpid);
                        }
                    }

                    if(config('TOPUP_AMO_USER_INDAY') >=  date('d'))
                    {   

                        $user = Helper::get_userdetail(Session::get('USER_ID'));
                  /*      $usercoupanamt = DB::select("SELECT COALESCE(SUM(tr03_dramount),0) AS AMT FROM `tr03_manage_ledger` WHERE m11_user_id = ".Session::get('USER_ID')." AND tr03_bal_type = 'COUPAN' AND tr03_ledger_type = 'COUPAN REDEEM' AND DATE_FORMAT(tr03_trans_onadd,'%Y-%m') = DATE_FORMAT(NOW(),'%Y-%m')"); 

                        $total_usercoupanamt = DB::select("SELECT COALESCE(SUM(tr03_dramount),0) AS AMT FROM `tr03_manage_ledger` WHERE m11_user_id = ".Session::get('USER_ID')." AND tr03_bal_type = 'COUPAN' AND tr03_ledger_type = 'COUPAN REDEEM'"); */


                        $usercoupanamt = DB::select("SELECT COALESCE(SUM(tr03_cramount)-SUM(tr03_dramount),0) AS AMT FROM `tr03_manage_ledger` WHERE m11_user_id = ".Session::get('USER_ID')." AND tr03_bal_type = 'COUPAN' AND tr03_ledger_type IN(25,23) AND DATE_FORMAT(tr03_trans_onadd,'%Y-%m') = DATE_FORMAT(NOW(),'%Y-%m')"); 

                        $total_usercoupanamt = DB::select("SELECT COALESCE(SUM(tr03_cramount)-SUM(tr03_dramount),0) AS AMT FROM `tr03_manage_ledger` WHERE m11_user_id = ".Session::get('USER_ID')." AND tr03_bal_type = 'COUPAN' AND tr03_ledger_type IN(25,23)"); 

 
                        if((float)$total_usercoupanamt[0]->AMT > (float)$coupanamt->m27_coupan_amt)
                        {
                            $USERCOUPAN = 0;
                        }
                        else 
                        {
                            $USERCOUPAN = $topupusethisamt-(float)$usercoupanamt[0]->AMT;
                        }
                    }
                    else
                    {
                        $USERCOUPAN = 0;
                    } 
                }
            }
        }
      
        return $USERCOUPAN;
    }

    public function change_cart_type(Request $request)
    {   
        $user ='';
        $cart = $this->orders_repo->getById($request->text_cart_id);
        $carddata = json_decode($cart[0]->PRODUCT_DETAILS);
        $del = (float)$cart[0]->DELIVERY_FEE;
        $coupan = $this->get_coupan_amount();
        $total =0;
        $coupans = 0;
        foreach($carddata as $value)
        {
            $total += $value->disc_price*$value->new_quantity;
        }
          
        if($coupan >= $del+$total)
        {
            $coupans = $del+$total;
            $toamt = 0.00;
        }
        else
        {
          $coupans = $coupan;
          $toamt = ($del+$total)-$coupan;  
        }

                                    
        $address = $this->address_repo->getById($request->select);
        if(count($address) > 0)
        {
            $address = json_encode($address[0]);
        }
        else
        {
            return back();
        }

        $wallet_type = 1;

        if($request->wallet_type == 1)
        { 
            $wallet_type = $request->wallet_type; 
        }
        elseif($request->wallet_type == 2)
        {
            $wallet_type = $request->wallet_type; 
        }

            $shoppingwallet=array(
                'proc'=>9,
                'to_user_id'=>Session::get('USER_ID'),
                'from_user_id'=>0,
                'amount'=>floatval($del+$total), // total maount
                'collected_amount'=>floatval($toamt), // if coupan amt avlable - total maount
                'requesttype'=>1,
                'balfor'=> $wallet_type,
                'transtype'=>1,
                'timelimit'=>3000,
                'defaultstatus'=>1,
                'remark'=>"Shoping Payment",
                'collected_remark'=>"Shoping Payment"
            );

            $shopping_wallet = DB::SELECT('CALL wallettransfer(
                :proc, 
                :to_user_id,
                :from_user_id,
                :amount, 
                :collected_amount,
                :requesttype,
                :balfor,
                :transtype,
                :timelimit,
                :defaultstatus,
                :remark,
                :collected_remark,
                @status_code,
                @status_msg)'
            ,$shoppingwallet);

            $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
            $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');


        if($ERRCODE[0]->ERR_CODE == 'success')
        {
            $array = [
                        'tr36_cart_type' => 2, 
                        'tr36_order_datetime' => date('Y-m-d H:i:s'),
                        'tr36_payment_method' => $request->payment_type,
                        'tr36_payment_status'=> 2, 
                        'tr36_order_status'=> 1,
                        'tr36_address_id'=> $request->select,
                        'tr36_address_details'=> $address,
                        'tr03_manage_ledger_id'=> $ERRMSG[0]->ERR_MSG
                    ];

            $data = $this->orders_repo->update($request->text_cart_id, $array);

            if($data)
            {   
                Cookie::queue(
                    Cookie::forget('cart')
                );
                Cookie::forget('cart');
                //Cookie::queue('cart', '1', 100);
                //dd(Cookie::get('cart'));
                
                $categories = $this->cat_repo->getAllCategoryActive(); //category
                $cart = $this->orders_repo->getById($request->text_cart_id);

                if(count($cart) > 0)
                {
                    $cart = $cart[0];
                    $user = Helper::get_userdetail(Session::get('USER_ID'));
                    $address = $this->address_repo->getById($cart->ADDRESS_ID);
                }
                else
                {
                    return back();
                }
                return view('Front.order-confirm',compact('categories','cart','address','user'));
            }
            else
            {
                return back();
            }
        }
        else
        {
           return back()->with('add_warning', $ERRMSG[0]->ERR_MSG); 
        }

    }




    public function order_confirm($cart_id)
    {
        Cookie::queue(
            Cookie::forget('cart')
        );
        Cookie::forget('cart');
        //Cookie::queue('cart', '1', 100);
        //dd(Cookie::get('cart'));
        $categories = $this->cat_repo->getAllCategoryActive(); //category
        $cart = $this->orders_repo->getById(base64_decode($cart_id));
        $cart = $cart[0];
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        $address = $this->address_repo->getById($cart->ADDRESS_ID);
        return view('Front.order-confirm',compact('categories','cart','address','user'));
    }










}
