<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\Master\Location\LocationRepository;

use App\Repositories\LeadSource\LeadSourceRepository;
use App\Repositories\Industry\IndustryRepository;
use App\Repositories\LeadStatus\LeadStatusRepository;
use App\Repositories\AccRelService\AccRelServiceRepository;
use App\Repositories\LeadProduct\LeadProductRepository;

use DB;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;

class CRMController extends Controller
{ 

	private $loc_repo;
	private $LeadSource_repo;
	private $Industry_repo;
	private $LeadStatus_repo;
	private $AccRelService_repo;
	private $LeadProduct_repo;

	public function __construct(LocationRepository $loc_repo, LeadSourceRepository $LeadSource_repo, IndustryRepository $Industry_repo, LeadStatusRepository $LeadStatus_repo, AccRelServiceRepository $AccRelService_repo, LeadProductRepository $LeadProduct_repo)
    {
    	$this->loc_repo = $loc_repo;

    	$this->LeadSource_repo = $LeadSource_repo;
    	$this->Industry_repo = $Industry_repo;
    	$this->LeadStatus_repo = $LeadStatus_repo;
    	$this->AccRelService_repo = $AccRelService_repo;
    	$this->LeadProduct_repo = $LeadProduct_repo;
    }
   
 public function view_crm_account()
 {
 	$data['country'] = $this->loc_repo->getAllCountries();
 	$data['Indus'] = $this->Industry_repo->getAll();

 	return view('CRM.account',compact('data'));
 }

   
 public function view_crm_lead()
 {
 	$data['country'] = $this->loc_repo->getAllCountries();
 	$data['Source'] = $this->LeadSource_repo->getAll();
 	$data['Indus'] = $this->Industry_repo->getAll();
 	$data['Status'] = $this->LeadStatus_repo->getAll();
 	$data['Pro'] = $this->LeadProduct_repo->getAll();
 	return view('CRM.lead',compact('data'));
 }

   
 public function view_crm_opportunity()
 {
 	return view('CRM.opportunity');
 }

   
 public function view_crm_contact()
 {
 	$data['country'] = $this->loc_repo->getAllCountries();
 	return view('CRM.contact',compact('data'));
 }

   
 public function view_crm_task()
 {
 	return view('CRM.task');
 }


   
 public function view_crm_event()
 {
 	return view('CRM.event');
 }








     public function get_state(Request $Request)
    {
    	if($Request->id != null)
    	{
    		$data['state'] = $this->loc_repo->getByPId($Request->id);

    		if(count($data['state']) != 0)
    		{
    			return $data['state'];
    		}
    		else
    		{
    			return 'DATA NOT FOUND';
    		}
    	}
    	else
    	{
    		return 'DATA NOT FOUND';
    	}
	}




     public function get_city(Request $Request)
    {
    	if($Request->id != null)
    	{
    		$data['city'] = $this->loc_repo->getByPId($Request->id);

    		if(count($data['city']) != 0)
    		{
    			return $data['city'];
    		}
    		else
    		{
    			return 'DATA NOT FOUND';
    		}
    	}
    	else
    	{
    		return 'DATA NOT FOUND';
    	}
	}



}