<?php

namespace App\Http\Controllers;
use DB;
use Session;
use Helper;
use BillAvenue;

use Illuminate\Http\Request;
use App\Repositories\Master\Service\ServiceRepository;

class BBPSController extends Controller
{

    private $service_repo;


    public function __construct(ServiceRepository $service_repo)
        {
            $this->service_repo = $service_repo;
        }

   public function bbps_testing($type)
    {
        if($type == 1)
        {
            $data = BillAvenue::billerINFO('UCPGPL000MAH01');
            return $data;
        }
        elseif($type == 2)
        {
            $data = BillAvenue::trxnSTATUS('JIO000000NAT01');
            return $data;
        }
        elseif($type == 3)
        {
			$trans_id ="4546479879797897";
			$custNUMBER ="5654465654";
			$billerID ="NDMC00000DEL01";
			$amount ="10";
			$location ="8998779";
			$mobileNo ="9914654640";
            $data = BillAvenue::billFetch($trans_id,$custNUMBER,$billerID,$amount,$location,$mobileNo);
            return $data;
        }
        else
        {
            return 'use in url /id';
        }

    }

    public function bbps_services()
    {
        $services = $this->service_repo->getbbpsservice();
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('User.bbps_services_page',compact('user','services'));
    }

    public function bbps_bill_payment()
    {
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('User.bbps_bill_payment_page',compact('user'));
    }

    public function search_biller()
    {
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('User.search_biller_page',compact('user'));
    }
    public function bill_fetch()
    {
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('User.bill_fetch_page',compact('user'));
    }


    public function bbps_receipt()
    {
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('User.bbps_receipt',compact('user'));
    }



    public function bbps_quickpay_receipt()
    {
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('User.bbps_quickpay_receipt',compact('user'));
    }


    public function bbps_recharge_report()
    {
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('User.bbps_recharge_report',compact('user'));
    }

    public function bbps_service_based_complaint()
    {
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('User.bbps_service_based_complaint',compact('user'));
    }

    public function bbps_transaction_based_complaint()
    {
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('User.bbps_transaction_based_complaint',compact('user'));
    }

    public function bbps_complaint_tracking()
    {
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('User.bbps_complaint_tracking',compact('user'));
    }


    public function bbps_quick_pay_bill()
    {
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('User.bbps_quick_pay_bill',compact('user'));
    }


    public function quick_bill_payment()
    {
        $user = Helper::get_userdetail(Session::get('USER_ID'));
        return view('User.quick_bill_payment_page',compact('user'));
    }



}