<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use App\Repositories\Log\LogRepository;
use App\Repositories\Enroll\EnrollRepository;
use App\Repositories\Fund\FundRepository;
use App\Repositories\Master\Location\LocationRepository;
use App\Repositories\Recharge\Rechargereport\RechargereportRepository;
use App\Repositories\Recharge\Rechargeprocess\RechargeprocessRepository;
use Session;
use Image;
use DB;
use Helper;
use MahagramDMT;
use Illuminate\Support\Str;
use Mtownsend\XmlToArray\XmlToArray;
use Razorpay\Api\Api;
use Hash;
use Crypt;

class B2CController extends Controller
{
    
	private $enroll_repo;
	private $location_repo;
	private $log_repo;
	private $rech_reprt_repo;
	private $fund_repo;
	private $rech_proc_repo;


	public function __construct(EnrollRepository $enroll_repo , LocationRepository $location_repo, LogRepository $log_repo, RechargereportRepository $rech_reprt_repo, FundRepository $fund_repo, RechargeprocessRepository $rech_proc_repo)
    {
        $this->enroll_repo = $enroll_repo;
        $this->location_repo = $location_repo;
        $this->log_repo = $log_repo;
    	$this->rech_reprt_repo = $rech_reprt_repo;
        $this->fund_repo = $fund_repo;
    	$this->rech_proc_repo = $rech_proc_repo;

    }


	

	/**
		* Method name	: match values
		* @description 	: Used for matching old and new inserted values
		* @param		: Request data  
		* @return		: return updated values with old values before updation
	*/
    public function match_values($old_values,$new_values)
	{
		$old_value=$old_values[0];
		$new_arr = array();
		foreach($old_value as $key=>$value){ $new_arr[$key] = $value; }
		$count=count($new_arr);
		$arr_key = array_keys($new_values);
		$arr_val = array_values($new_arr);
		$new_old_array = array();
		for($i=0;$i<$count;$i++){ $new_old_array[$arr_key[$i]] = $arr_val[$i]; }
		$result = array_diff($new_values, $new_old_array);
		$new_values1 = json_encode(array_intersect_key($new_values,$result));
		$old_values1 = json_encode(array_intersect_key($new_old_array,$result));

		return [$new_values1,$old_values1];
	}




		
	public function dapp_login(Request $request)
	{
		$queery ="";$queery1 ="";
		if($_SERVER['REQUEST_METHOD']=="GET")
		{
				$apitoken="";$userid="";$url="";
				$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
				$format="json";$param1="";$param2="";
				$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="MESSAGE";
				$res_status="";$res_opid="";$res_rbid="";$res_msg="";
				$status1="PENDING";$status2=2;
				if($request->input('usercode')=='')
				{
					$ERRMSG = "User code should be fvalid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
					return response()->json([
					'ERROR_CODE'=>'000',
					'ERROR'=>$ERRCODE,
					'MSG' =>$ERRMSG 
					]);
				}
				
		
				else
				{
						$login_data = array(
                            'login_id'=>$request->usercode,
                            'login_ip'=>$request->server('REMOTE_ADDR'),
                            'user_agent'=>$request->server('HTTP_USER_AGENT'),
                            'user_type'=>2
                        );
						
                    $result =  DB::select('CALL dapp_login(:login_id,:login_ip,:user_agent, :user_type, @status_code,@status_msg)',$login_data);
			$count = count($result);

			$DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
			$DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');

			$userData = DB::select("SELECT * FROM `tr04_login` WHERE `tr04_login`.`m11_bsc_address`='".$request->usercode."' LIMIT 1"); //OR `tr04_login`.`m11_user_email`='".$request->usercode."'
								

                    if($count == 1)
                    {

                        foreach($result as $row)
                        {
                            break;
                        }	

						$sessiondata=array(
							'USER_ID'	      =>	$result[0]->USER_ID,
							'EMAIL'  		  =>	$result[0]->EMAIL,
							'NAME'     		  => 	$result[0]->FIRST_NAME.$result[0]->LAST_NAME,
							'USER_CODE' 	  =>	$result[0]->USER_CODE,
							'USER_ROLE' 	  =>	$result[0]->USER_ROLE,
							'USER_ROLE_ID'    => 	$result[0]->USER_ROLE_ID,
							'USER_TYPE'    	  =>    $result[0]->USER_TYPE,
							'CONTACTNO' 	  =>	$result[0]->CONTACTNO,
							'USER_IMG'        =>	$result[0]->USER_IMG,
							'AFFILIATE_CODE'  => 	$result[0]->AFFILIATE_CODE,
							'IS_LOGIN' 	      => 	$result[0]->IS_LOGIN,
							'GROUP_ID'        =>	$result[0]->USER_GROUPID
						);
						$last_package ='N/A';
						//Session::put($sessiondata);
						$last_package_ID = DB::select("SELECT `m27_pack_id` AS PACK_ID FROM `tr19_user_topup` WHERE `m11_user_id`=".$result[0]->USER_ID." LIMIT 1");
							if($last_package_ID){
								$last_package = DB::select("SELECT IFNULL(`m27_pack_name`,'N/A') AS PACKAGE_NAME FROM `m27_package` WHERE `m27_pack_id` =".	$last_package_ID[0]->PACK_ID)[0]->PACKAGE_NAME;
						
							}
						 DB::select("CALL get_intro_downline(".$result[0]->USER_ID.")");
	                    $teamcount = DB::select("SELECT count(member_id) as tc FROM tmp_downline");
						$alloted_coin =DB::select("SELECT IFNULL(SUM(tr19_total_coin),00.00) as ToTal_allotaed FROM `tr19_user_topup` WHERE `m11_user_id`=".$result[0]->USER_ID);
						$directcount =DB::select("SELECT count(*) AS dc FROM m11_user WHERE `m11_user`.`m11_user_referral_code`=".$result[0]->USER_ID);
						$direct_income= DB::select("SELECT IFNULL(get_balby_income(".$result[0]->USER_ID.",12),00.00) AS BAL");
						$DIRECT_INCOME=$direct_income[0]->BAL;
						$level_income= DB::select("SELECT IFNULL(get_balby_income(".$result[0]->USER_ID.",13),00.00) AS BAL");
						$LEVEL_INCOME=$level_income[0]->BAL;
						$avail_bal=DB::select("SELECT GET_AVAILABLE_BAL(".$result[0]->USER_ID.",5) AS BAL");
						$CB_AMT=$avail_bal[0]->BAL;
						$avail_bal11=DB::select("SELECT GET_AVAILABLE_BAL(".$result[0]->USER_ID.",8) AS BAL");
						$TRADE_AMT=$avail_bal11[0]->BAL;

        $queery = $queery."`USER_ID` = ".$result[0]->USER_ID ." AND ";
		$queery = $queery." CASHBACK_STATUS=2 LIMIT 1000";
		$queery1 = $queery1."`USER_ID` = ".$result[0]->USER_ID ." AND CASHBACK_APPROVEDATE='".date('Y-m-d')."' AND";
		$queery1 = $queery1." CASHBACK_STATUS=2 LIMIT 1000";
		//dd($queery1);
		$salary_report =  DB::select("SELECT IFNULL(SUM(CASHBACK_AMOUNT),00.00) AS CASHBACK_AMOUNT FROM cashback_dates WHERE ".$queery);
		$salary_report_today =  DB::select("SELECT IFNULL(SUM(CASHBACK_AMOUNT),00.00) AS CASHBACK_AMOUNT FROM cashback_dates WHERE ".$queery1);

						return response()->json([
								'REFFERAL'=> $result[0]->USER_CODE,
								'ERROR_CODE'=>$request->usercode,
								'ERROR'=>'SUCCESS',
								'ALLOTED_COIN'=>$alloted_coin[0]->ToTal_allotaed,
								'TODAY_COIN'=>$salary_report_today[0]->CASHBACK_AMOUNT,
								'TOTAL_COIN'=>$salary_report[0]->CASHBACK_AMOUNT,
								'PAYOUT_AMT'=> $CB_AMT,
								'TRADE_AMT'=> $TRADE_AMT,
								'DIRECT_COUNT'=> $directcount[0]->dc,
								'DIRECT_AMT'=> $DIRECT_INCOME,
								'LEVEL_AMT'=>$LEVEL_INCOME,
								'PKY'=> 'fd1430ad8b42f41f860fe4415516a558851879c652b757ab33053f9c63ba6e84',
								'SPK'=> '',
								'MSG' =>$DB_ERRMSG[0]->ERR_MSG ,
								'LAST_PACKAGE'=>$last_package,
								'TOTAL_TEAM' => $teamcount[0]->tc,
								'TODAY_COINRATE' => 1.30
								]);
                    }
                    else 
                    {
                    	
						$ERRMSG = $DB_ERRMSG[0]->ERR_MSG;
						$ERROR_CODE = '000';
                    	if($ERRMSG == 'Your are not registered with us')
                    	{
                    		$ERROR_CODE = '301';
                    	}

						$ERRCODE="error";	
						return response()->json([
								'ERROR_CODE'=>$ERROR_CODE,
								'ERROR'=>$ERRCODE,
								'MSG' =>$ERRMSG 
								]);
                    }	
			}	
				
		}
		else
		{
			$ERRMSG="THIS METHOD IS NOT ALLOWED";
			$ERRCODE="error";
			return response()->json([
			'ERROR_CODE'=>'000',
			'ERROR'=>$ERRCODE,
			'MSG' =>$ERRMSG 
			]);
		}
	}



		
	public function dapp_logins(Request $request)
	{
		if($_SERVER['REQUEST_METHOD']=="GET")
		{
				$apitoken="";$userid="";$url="";
				$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
				$format="json";$param1="";$param2="";
				$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="MESSAGE";
				$res_status="";$res_opid="";$res_rbid="";$res_msg="";
				$status1="PENDING";$status2=2;
				if($request->input('usercode')=='')
				{
					$ERRMSG = "User code should be fvalid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
					Session::flash('type',$ERRCODE);
					Session::flash('message',$ERRMSG);
					return redirect('/login');

				}
				
				/*else if($request->input('device_type')=='')
				{
					$ERRMSG = "Device Type should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else if($request->input('device_type')!='android')
				{
					$ERRMSG = "Device Type should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}
				else if($request->input('imei_no')=='')
				{
					$ERRMSG = "Device IMEI NO should be valid.";
					$this->isError= TRUE;
					$ERRCODE="error";
					$userData ='';
				}*/
				else
				{
						$login_data = array(
                            'login_id'=>$request->usercode,
                            'login_ip'=>$request->server('REMOTE_ADDR'),
                            'user_agent'=>$request->server('HTTP_USER_AGENT'),
                            'user_type'=>2
                        );
						
                $result =  DB::select('CALL dapp_login(:login_id,:login_ip,:user_agent, :user_type, @status_code,@status_msg)',$login_data);
				$count = count($result);

				$DB_ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
				$DB_ERRCODE=DB::select('SELECT @status_code as ERR_CODE');

				$userData = DB::select("SELECT * FROM `tr04_login` WHERE `tr04_login`.`m11_bsc_address`='".$request->usercode."' LIMIT 1"); //OR `tr04_login`.`m11_user_email`='".$request->usercode."'
								

                    if($count == 1)
                    {

                        foreach($result as $row)
                        {
                            break;
                        }	

						$sessiondata=array(
							'USER_ID'	      =>	$result[0]->USER_ID,
							'EMAIL'  		  =>	$result[0]->EMAIL,
							'NAME'     		  => 	$result[0]->FIRST_NAME.$result[0]->LAST_NAME,
							'USER_CODE' 	  =>	$result[0]->USER_CODE,
							'USER_ROLE' 	  =>	$result[0]->USER_ROLE,
							'USER_ROLE_ID'    => 	$result[0]->USER_ROLE_ID,
							'USER_TYPE'    	  =>    $result[0]->USER_TYPE,
							'CONTACTNO' 	  =>	$result[0]->CONTACTNO,
							'USER_IMG'        =>	$result[0]->USER_IMG,
							'AFFILIATE_CODE'  => 	$result[0]->AFFILIATE_CODE,
							'IS_LOGIN' 	      => 	$result[0]->IS_LOGIN,
							'GROUP_ID'        =>	$result[0]->USER_GROUPID
						);

						Session::put($sessiondata);
						//Session::flash('type','success' );
						//Session::flash('message','Success "Login' );
						return redirect('/user_dashboard');


						// return response()->json([
						// 		'ERROR_CODE'=>$request->usercode,
						// 		'ERROR'=>'SUCCESS',
						// 		'MSG' =>$DB_ERRMSG[0]->ERR_MSG 
						// 		]);
                    }
                    else 
                    {
                    	$ERRMSG = $DB_ERRMSG[0]->ERR_MSG;
                    	$ERRCODE="error";	
                    	Session::flash('type',$ERRCODE);
						Session::flash('message',$ERRMSG);
                    	return redirect('/login');
                    	
						
						$ERROR_CODE = '000';
                    	if($ERRMSG == 'Your are not registered with us')
                    	{
                    		$ERROR_CODE = '301';
                    	}

						
						return response()->json([
								'ERROR_CODE'=>$ERROR_CODE,
								'ERROR'=>$ERRCODE,
								'MSG' =>$ERRMSG 
								]);
                    }	
			}	
				
		}
		else
		{
			return redirect('/login');

			$ERRMSG="THIS METHOD IS NOT ALLOWED";
			$ERRCODE="error";
			Session::flash('type',$ERRCODE);
			Session::flash('message',$ERRMSG);
			return response()->json([
			'ERROR_CODE'=>'000',
			'ERROR'=>$ERRCODE,
			'MSG' =>$ERRMSG 
			]);
		}
	}




	/**
			* Method name	: Signin
			* @description 	: Used to Signin 
			* @param		: Request data  
			* @return		: Get Login data array with response message
		*/
	public function signin()
	{
		Session::flash('type','info' );
		Session::flash('message','LOGIN HERE!');
		$request = request();
		$OTP_STATUS ="NONE";
		if(request()->method() == 'POST')
		{
		
			$this->validate($request, [
            'txt_username'=> 'required',
            'txt_password'=> 'required|min:3'
			],
			[
            'txt_password.required' => 'User name is required',
            'txt_password.required' => 'Password is required',
            'txt_password.min' => 'Password must be at least 6 characters'
			]);
			
			$login_id = addcslashes(trim($request->input('txt_username')),'=;-"');
			$user_pwd = addcslashes(trim($request->input('txt_password')),'=;-"');
			$user_type=$request->input('ddtype');


			$userData = DB::select("SELECT * FROM `tr04_login` WHERE `tr04_login`.`m11_user_contactno`='".$login_id."' OR `tr04_login`.`m11_user_email`='".$login_id."' LIMIT 1");
			
			if(count($userData) >0)
			{
				$login_data = array(
				'login_id'=>$request->input('txt_username'),
				'user_pwd'=>$request->input('txt_password'),
				'login_ip'=>$request->server('REMOTE_ADDR'),
				'user_agent'=>$request->server('HTTP_USER_AGENT'),
				'user_type'=>$request->input('ddtype')
				);
				
				$userPass = $userData[0]->tr04_login_pwd;

				if(Hash::check($user_pwd, $userPass))
				{
					$result = $this->enroll_repo->userLogin($login_data);
					$count = count($result);
					$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
					$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
				}
				else
				{
					$ERRMSG[0]=["ERR_MSG" => "Please Check Your Login Password "];
					$ERRCODE[0]=["ERR_CODE" => "201"];
					$j = json_encode($ERRMSG);
					$ERRMSG = json_decode($j);
					$count = 0;
				}

			}
			else
			{
				$login_data = array(
				'login_id'=>$request->input('txt_username'),
				'user_pwd'=>$request->input('txt_password'),
				'login_ip'=>$request->server('REMOTE_ADDR'),
				'user_agent'=>$request->server('HTTP_USER_AGENT'),
				'user_type'=>$request->input('ddtype')
				);

				//$count = count($result);
				$count = 0;
				$ERRMSG[0]=["ERR_MSG" => "Please Check Your Login id "];
				$ERRCODE[0]=["ERR_CODE" => "201"];
					$j = json_encode($ERRMSG);
					$ERRMSG = json_decode($j);
			}
			
		
			if($count == 1)
			{
				Session::flash('type','success' );
				Session::flash ( 'message', 'Please check your E-mail account OR Mobile No to verify OTP.');
				Session::put('result',$result);
				//$otp = rand(100000,999999);
				$mob = $result[0]->CONTACTNO;
				$OTP_STATUS=$result[0]->OTP_STATUS;
				$otp =$result[0]->OTP_CODE;
				$msg="Please submit this code ".$otp." to verify your account.";
		
				if($request->input('ddtype')==4)
				{
								
						$template_type = 1;
						$smsdata = array(
							'msg_title' => 'loginotp',
							'name' => $result[0]->FIRST_NAME.' '.$result[0]->LAST_NAME,
							'useremail' => $result[0]->EMAIL,
							'link' => url('/verification'),
							'template_name' => 'otp',
							'code' => $otp
						);
						if($OTP_STATUS=="NONE")
						{

						$sessiondata=array(
								'B2C_USER_ID'	      =>	$result[0]->USER_ID,
								'B2C_EMAIL'  		  =>	$result[0]->EMAIL,
								'B2C_NAME'     		  => 	$result[0]->FIRST_NAME.$result[0]->LAST_NAME,
								'B2C_F_NAME'     	  => 	$result[0]->FIRST_NAME,
								'B2C_USER_CODE' 	  =>	$result[0]->USER_CODE,
								'B2C_USER_ROLE' 	  =>	$result[0]->USER_ROLE,
								'B2C_USER_ROLE_ID'    =>    $result[0]->USER_ROLE_ID,
								'B2C_USER_TYPE'       =>    $result[0]->USER_TYPE,
								'B2C_CONTACTNO' 	  =>	$result[0]->CONTACTNO,
								'B2C_USER_IMG'        =>	$result[0]->USER_IMG,
								'B2C_AFFILIATE_CODE'  =>    $result[0]->AFFILIATE_CODE,
								'B2C_IS_LOGIN' 	      => 	$result[0]->IS_LOGIN,
								'B2C_GROUP_ID'        =>	$result[0]->USER_GROUPID
							);

								Session::put($sessiondata);
								Session::flash('type','success' );
								Session::flash('message','Success Login' );
								return redirect('/');
						}
						elseif($OTP_STATUS=="BOTH")
						{ 
							$msg_config = DB::select('select * from config_msg where MSG_TITLE = "'.$smsdata['msg_title'].'"');
							$smsdata['MSG_CONTENT'] = $msg_config[0]->MSG_CONTENT;
							$smsdata['MSG_SUBJECT'] = $msg_config[0]->MSG_SUB;
							$smsdata['USER_TYPE'] = $result[0]->USER_TYPE;
							$smsdata['USER_ID'] = $result[0]->USER_ID;
							$smsdata['MSG_CONTENT'] = strtr($smsdata['MSG_CONTENT'], array('{name}' => $smsdata['name'],
							'{useremail}'=>$smsdata['useremail'],'{code}'=>$smsdata['code'],'{link}'=>$smsdata['link']));
							$smsdata['pdf'] ='';
							$template_data = $smsdata;
							$msg="Please submit this code ".$otp." to verify your  account.";
							$data = DB::table('tr04_login')->where('m11_user_id',$result[0]->USER_ID)->update(['tr04_otp' =>$otp]);
							if($data)
							{
								Mail::to($smsdata['useremail'])->send(new SendMail($template_data, $template_type));
					
								// SMS SEND OR INSERT
								$sms_data['MOBILE_NO'] = $result[0]->CONTACTNO;
								$sms_data['SUBJECT'] = 'USER Login';
								$sms_data['MESSAGE'] = $msg;
								$sms_data['TYPE'] = 5;
								$sms_data['SEND_BY'] = 2;
								$sms_data['SEND_BY_ID'] = $result[0]->USER_ID;
								Helper::send_sms_or_log($sms_data);
								//SMS SEND END 

								return redirect('user-verification');
							}
							else
							{
								Session::flash('type','warning');
								Session::flash ( 'message', 'Please check your E-mail account OR Mobile No to verify OTP.');
								return back();
							}
						}
						elseif($OTP_STATUS=="MAIL")
						{
							$msg_config = DB::select('select * from config_msg where MSG_TITLE = "'.$smsdata['msg_title'].'"');
							$smsdata['MSG_CONTENT'] = $msg_config[0]->MSG_CONTENT;
							$smsdata['MSG_SUBJECT'] = $msg_config[0]->MSG_SUB;
							$smsdata['USER_TYPE'] = $result[0]->USER_TYPE;
							$smsdata['USER_ID'] = $result[0]->USER_ID;
							$smsdata['MSG_CONTENT'] = strtr($smsdata['MSG_CONTENT'], array('{name}' => $smsdata['name'],
							'{useremail}'=>$smsdata['useremail'],'{code}'=>$smsdata['code'],'{link}'=>$smsdata['link']));
							$smsdata['pdf'] ='';
							$template_data = $smsdata;
							$data = DB::table('tr04_login')->where('m11_user_id',$result[0]->USER_ID)->update(['tr04_otp' =>$otp]);
							if($data)
							{
								Mail::to($smsdata['useremail'])->send(new SendMail($template_data, $template_type));
								return redirect('user-verification');
							}
							else
							{
								Session::flash('type','warning');
								Session::flash ( 'message', 'Please check your E-mail account OR Mobile No to verify OTP.');
								return back();
							}
						}
						elseif($OTP_STATUS=="SMS")
						{
							$msg="Please submit this code ".$otp." to verify your  account.";
							$data = DB::table('tr04_login')->where('m11_user_id',$result[0]->USER_ID)->update(['tr04_otp' =>$otp]);
							if($data)
							{
								// SMS SEND OR INSERT
								$sms_data['MOBILE_NO'] = $result[0]->CONTACTNO;
								$sms_data['SUBJECT'] = 'USER Login';
								$sms_data['MESSAGE'] = $msg;
								$sms_data['TYPE'] = 5;
								$sms_data['SEND_BY'] = 2;
								$sms_data['SEND_BY_ID'] = $result[0]->USER_ID;
								Helper::send_sms_or_log($sms_data);
								//SMS SEND END 

								return redirect('user-verification');
							}
							else
							{
								Session::flash('type','warning');
								Session::flash ( 'message', 'Please check your E-mail account OR Mobile No to verify OTP.');
								return back();
							}
						}
						else
						{
							Session::flash('type','warning');
							Session::flash ( 'message', 'Please check your E-mail account OR Mobile No to verify OTP.');
							return back();
						}

				}
				else
				{
					Session::flash('type','warning' );
		            Session::flash ( 'message','Please check your E-mail account OR Mobile No to verify OTP.');
		            return redirect()->to('/');	
				}
			}
			else 
			{
				Session::flash('type','warning' );
                Session::flash ( 'message', $ERRMSG[0]->ERR_MSG);
                if($request->input('ddtype')==3)
                return redirect()->to('/sign-in');
                else
                return redirect()->to('/');
				
			}
		}
		else 
		{
			Session::flash('type','warning' );
            Session::flash ( 'message', "Invalid Method , Please try again." );
            return redirect()->to('/');
		}
	}







	public function login_verification(request $request)
	{
	 	$otp = $request->input('txt_otp');

	 	$result = session::get('result');
	 	//dd($otp,$result);
	 	if($result[0]->USER_ID == -1){

	 		$userdata =	DB::select("SELECT m00_login_id,m00_username, m00_access_token FROM m00_admin_login where m00_username = '".$result[0]->EMAIL."' LIMIT 1");
	 		if(!empty($userdata)){
	 		$userotp = $userdata[0]->m00_access_token;
	 			 		}else{
	 			return back();
	 			}
	 	}
	 	else{
	 		$userdata =	DB::select("SELECT m11_user_id, m11_user_contactno, tr04_otp FROM tr04_login where m11_user_contactno = '".$result[0]->USER_CODE."' LIMIT 1");

	 		if(!empty($userdata)){
	 			$userotp = $userdata[0]->tr04_otp;
	 		}else{
	 			return back();
	 			}

	 	}
	 	//dd($userotp,$otp);
	 	if($userotp == $otp){

	 				Session::forget('count');
	 			 	$count = count($result);
	 			 	//dd($result);

	 		            if($count == 1)
			            {
		                    foreach($result as $row)
		                    {
		                        break;
		                    }

							$mainbal = Helper::get_userdetail($result[0]->USER_ID);
								
							$sessiondata=array(
								'B2C_USER_ID'	      =>	$result[0]->USER_ID,
								'B2C_EMAIL'  		  =>	$result[0]->EMAIL,
								'B2C_NAME'     		  => 	$result[0]->FIRST_NAME.$result[0]->LAST_NAME,
								'B2C_F_NAME'     	  => 	$result[0]->FIRST_NAME,
								'B2C_USER_CODE' 	  =>	$result[0]->USER_CODE,
								'B2C_USER_ROLE' 	  =>	$result[0]->USER_ROLE,
								'B2C_USER_ROLE_ID'    =>    $result[0]->USER_ROLE_ID,
								'B2C_USER_TYPE'       =>    $result[0]->USER_TYPE,
								'B2C_CONTACTNO' 	  =>	$result[0]->CONTACTNO,
								'B2C_USER_IMG'        =>	$result[0]->USER_IMG,
								'B2C_AFFILIATE_CODE'  =>    $result[0]->AFFILIATE_CODE,
								'B2C_IS_LOGIN' 	      => 	$result[0]->IS_LOGIN,
								'B2C_GROUP_ID'        =>	$result[0]->USER_GROUPID,
								'B2C_MAIN_BALANCE'    =>	$mainbal[0]->RECHARGE_BAL
							);


							Session::put($sessiondata);
							Session::flash('type','success' );
							Session::flash('message','Success "Login' );
							 //dd($ERRMSG[0]->ERR_MSG);
							return redirect('/');

		            }
		            else 
		            {
						Session::flash('type','warning' );
		                Session::flash ( 'message', 'Invalid Method , Please try again.');
		                if($result[0]->USER_ROLE == 'B2CUSER')
						return redirect('sign-in');
		                else
		                return redirect()->to('/');
		            }

	 	}else{
	 			if(Session::get('count')  != null){ $counts = Session::get('count'); }else{ $counts = 1; }

	 		if(Session::get('count') < 4)
	 		{
	 			$counts++;
		 		Session::put('count',$counts);
				Session::flash('type','warning' );
				Session::flash ( 'message', 'YOUR ARE NOT MEMMBER OF OUR PANEL');
				return back();
			}
			else
			{	
				Session::forget('count');
				Session::flash('type','warning' );
                Session::flash ( 'message', 'Invalid Method , Please try again.');
                if($result[0]->USER_ROLE == 'B2CUSER')
				return redirect('sign-in');
                else
                return redirect()->to('/');
			}

	 	}
	}







	/**
			* Method name	: Logout
			* @description 	: Used to Logout 
			* @param		: Session data  
			* @return		: Get back to login form
		*/
	public function logout()
	{
		auth()->logout();
		Session::forget('B2C_USER_ID');
		Session::forget('B2C_EMAIL');
		Session::forget('B2C_NAME');
		Session::forget('B2C_USER_ROLE');
		Session::forget('B2C_CONTACTNO');
		Session::forget('B2C_USER_IMG');
		Session::forget('B2C_IS_LOGIN');
		Session::forget('B2C_USER_CODE');
		Session::forget('B2C_USER_CODE');
		return redirect()->to('/');
	}






	public function profile()
    {
		if(Session::get('B2C_USER_ROLE') == 'B2CUSER') 
		{	
			$state = $this->location_repo->getByPId(1);

			$user =''; 
			if(Session::get('B2C_USER_ID'))
			{
				$user = Helper::get_userdetail(Session::get('B2C_USER_ID'));
			}
			return view('Front/FRONT10.profile',compact('user','state'));
		}
		else
		{
			return back();
		}
    }

	public function offers()
    {

		$user =''; 
		if(Session::get('B2C_USER_ID'))
		{
			$user = Helper::get_userdetail(Session::get('B2C_USER_ID'));
		}
    	return view('Front/FRONT10.offers',compact('user'));
    }


	    /**
				* Method name	: b2c user update profile
				* @description 	: b2c user update profile
				* @param		: Phone number ,name,email,etc
				* @return		: return profile
			*/    
		public function update_user_info(request $request)
		{

				$name=explode(" " ,$request->input('txt_txt_fullName'));
				if(isset($name[1]))
				{
					$l_name = $name[1];
				}
				else
				{
					$l_name = ''; 
				}


				$arr = array(
				'm11_first_name' => $name[0],
				'm11_last_name' => $l_name,
				'm11_user_name' => $request->input('txt_txt_fullName'),
				'm11_user_dob' => date('Y-m-d',strtotime($request->input('txt_birthDate'))),
				'm11_user_state' => $request->input('dd_state'),
				'm11_user_city' => $request->input('dd_city'),
				'm11_user_gender' => $request->input('txt_profile'),
				);


				$old_values=DB::select("SELECT FirstName, LastName, MemberName, MemberDOB, MemberStateID, MemberCityID,MemberGender FROM enroll WHERE RegId=".Session::get('B2C_USER_ID')."");

				$user_profile = $this->enroll_repo->update(Session::get('B2C_USER_CODE'), Session::get('B2C_USER_ID'), $arr);

				$data=$this->match_values($old_values,$arr);

				$arr = array(
					'tr11_ar_tblnm' => 'm11_user',
					'tr11_ar_old_value' => $data[1],
					'tr11_ar_new_value' => $data[0],
					'tr11_ar_uid' => Session::get('B2C_USER_ID'),
					'tr11_ar_description' => 'USERS PROFILE HAS BEEN CHANGED SUCCESSFULLY!',
					'tr11_updated_by' => 2,
					'tr11_updated_by_id' =>  Session::get('B2C_USER_ID')
					);

				$mobileno_actionrecord=$this->log_repo->create($arr);
				if($user_profile)
				{
					return redirect('profile')->with("success", "PROFILE UPDATE SUCCESSFULLY!");
				}
				else
				{
					return redirect('profile')->with("error", "PROFILE NOT UPDATE");
				}
		}		   


		 /**
				* Method name	: b2c user password change
				* @description 	: b2c user  password change
				* @param		: new pass , old pass
				* @return		: return profile
			*/    
		public function user_change_password(request $request)
		{
		
		$user = Helper::get_userdetail(Session::get('B2C_USER_ID'));
				
		    if($request->input('txt_oldpassword')=='')
			{
				$ERRMSG = "Old Password should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if($request->input('txt_newpassword')=='')
			{
				$ERRMSG = "New Password should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else if(strlen($request->input('txt_newpassword'))<6)
			{
				$ERRMSG = "New password length would be greater then 6 or equal 6";
				$this->isError= TRUE;
				$ERRCODE="warning";
				
			}
			else if($request->input('txt_newcpassword')=='')
			{
				$ERRMSG = "Confirm New Password should be valid or not blank.";
				$this->isError= TRUE;
				$ERRCODE="warning";
				
			}
			else if(strlen($request->input('txt_newcpassword'))<6)
			{
				$ERRMSG = "New Confirm password length would be greater then 6 or equal 6";
				$this->isError= TRUE;
				$ERRCODE="warning";
				
			}
			else if($request->input('txt_newpassword')!=$request->input('txt_newcpassword'))
			{
				$ERRMSG = "Password does not match with confirm password.";
				$this->isError= TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
				$this->isError=FALSE;
				$ERRCODE="success";
			}

			if($this->isError==FALSE)
			{
				$password=$request->input('txt_oldpassword');
				$new_password=$request->input('txt_newpassword');
            
				$user_logindetails=$this->enroll_repo->updateUserPassword($new_password, $password, Session::get('B2C_USER_ID'));

				if($user_logindetails==1)
				{
					$arr = array(
						'tr11_ar_tblnm' => 'tr04_login',
						'tr11_ar_old_value' => $password,
						'tr11_ar_new_value' => $new_password,
						'tr11_ar_uid' => Session::get('B2C_USER_ID'),
						'tr11_ar_description' => 'USER S LOGIN PASSWORD HAS BEEN CHANGED SUCCESSFULLY!',
						'tr11_updated_by' => 2,
						'tr11_updated_by_id' =>  Session::get('B2C_USER_ID')
						);
					$mobileno_actionrecord=$this->log_repo->create($arr);
					$ERRMSG="USER'S PASSWORD HAS BEEN CHANGED SUCCESSFULLY!";
					$ERRCODE='success';	
					return redirect('profile/password')->with("success", "PROFILE UPDATE SUCCESSFULLY!");
				}
				else
				{
					$ERRMSG="USER'S PASSWORD HAS NOT BEEN CHANGED!";
					return redirect('profile/password')->with("error", $ERRMSG);
				}
			}
			else
			{
				return redirect('profile/password')->with("error", $ERRMSG);
			}
		
		}	    




		/**
			* Method name   : user recharge report
			* @description  : Used for getting recharge report
			* @param        : Request data 
			* @return       : return with user recharge report
    	*/
		public function user_rechargereport()
		{
			$page = 'PROFILE PANEL';
			$form_name = 'ALL RECHARGE REPORT HERE';
			$user = Helper::get_userdetail(Session::get('B2C_USER_ID'));
			$request = request();
			$descrip="";
			$start = date('2021-01-01');
			$end = date('Y-m-d',strtotime(NOW()));
			$txt_account = '';
			$txt_memberid = Session::get('B2C_USER_ID');
			$txt_transid = '';
			$txt_noofrecords = '20';
			$dd_status='-1';
			$cond="";
			$cond1="1";
			$dd_operator ='-1';

            if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
				$end = date('Y-m-d',strtotime($request->input('txt_todate')));
				$dd_operator = $request->input('dd_operator');
				$dd_status = $request->input('dd_status');
				
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
				{
					$txt_transid=$request->input('txt_transid');
				}
				if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
					$txt_memberid=$request->input('txt_memberid');
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
				{
					$dd_status=$request->input('dd_status');
				}
				if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
				{
					$cond = $cond."`tr05_recharge_detail`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
				}
				
			}
			$cond=$cond.$cond1;
			$recereport=array
			(
			'proc'=>2,
			'account'=>$txt_account,
			'transid'=>$txt_transid,
			'userid'=>$txt_memberid,
			'fromdate'=>$start,
			'todate'=>$end,
			'noofrecords'=>$txt_noofrecords,
			'recstatus'=>$dd_status,
			'descrip'=>$cond
			);


			$rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
/*  			$hit_data=array(
				'proc'=>3,
				'user_id'=>$txt_memberid,
				'rec_fromdate'=>$start,
				'rec_todate'=>$end
            );

		    */$today_hit = '';//$this->rech_reprt_repo->todayHitStatus($hit_data);
			$OPERATOR = Helper::get_operator(-2,'ACTIVE');
			$user = Helper::get_userdetail(Session::get('B2C_USER_ID'));
			//dd($rec_report);
			return view('Front.FRONT10.recharge-history', compact('rec_report','user','OPERATOR','today_hit','user','start','end','dd_operator','txt_account','txt_noofrecords','dd_status'));
		}







	/**
        * Method name   : Bill Payment Report
        * @description  : Used for viewing recharge report
        * @param        : Request data 
        * @return       : return recharge report
    */
    public function billpay_report()
    {
        $request = request();
		$user = Helper::get_userdetail(Session::get('B2C_USER_ID'));
        $descrip="";
        $start = date('2021-01-01');
        $end = date('Y-m-d',strtotime(NOW()));
        $txt_account = '';
        $txt_memberid = Session()->get('B2C_USER_ID');
		 $txt_memberids='';
        $txt_transid = '';
        $txt_noofrecords = '100';
        $dd_status='-1';
		$dd_operator = '-1';
		$dd_api	=	'-1';
        $cond="";
        $cond1="`m07_service_id` NOT IN(1,2) AND 1";
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
            $end = date('Y-m-d',strtotime($request->input('txt_todate')));
			$dd_operator = $request->input('dd_operator');
						$dd_api	=	$request->input('dd_api');
			$txt_memberids = $request->input('txt_memberid');

            if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
            {
              $txt_account=$request->input('txt_account');
            }
            if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
            {
              $txt_transid=$request->input('txt_transid');
            }
            if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
            {
              $txt_memberid = Helper::get_userid($request->input('txt_memberid'));
            }
            if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
            {
              $txt_noofrecords =$request->input('txt_noofrecords');
            }
            if($request->input('dd_status')!="" && $request->input('dd_status')!=-1)
            {
              $dd_status=$request->input('dd_status');
            }
            if($request->input('dd_operator')!="" && $request->input('dd_operator')!=-1)
            {
              $cond = $cond."`tr36_bill_payment`.`m04_tc_brand_id`=".$request->input('dd_operator')." AND ";
            }
            if($request->input('dd_api')!="" && $request->input('dd_api')!=-1)
            {
              $cond=$cond."`tr36_bill_payment`.`m12_api_id`=".$request->input('dd_api')." AND ";
            }

        }
        $cond=$cond.$cond1;
        $recereport=array
         (
         'proc'=>2,
		  'mobile'=>'',
          'account'=>$txt_account,
          'transid'=>$txt_transid,
          'userid'=>$txt_memberid,
          'fromdate'=>$start,
          'todate'=>$end,
          'noofrecords'=>$txt_noofrecords,
          'recstatus'=>$dd_status,
          'descrip'=>$cond
        );
        $rec_report = $this->rech_reprt_repo->billpayReport($recereport);
		dd($rec_report, $recereport);

/*		$hit_data=array(
				'proc'=>3,
				'user_id'=>-1,
				'rec_fromdate'=>$start,
				'rec_todate'=>$end
            );*/
		$today_hit = '';//$this->rech_reprt_repo->todayHitStatus($hit_data);
        $OPERATOR = Helper::get_operator(-2,'ACTIVE');
        $API = Helper::get_api(1,'ACTIVE');

        Session::flash('message',"Billpay Report Fetch Succesfully");
        return view('Front.FRONT10.bill-pay-history', compact('user','rec_report','OPERATOR','API','today_hit','start','end','txt_account','txt_transid','dd_status','dd_operator','txt_noofrecords','dd_api','txt_memberids'));
    }




		/**
			* Method name   : user account statement
			* @description  : Used for getting account statement
			* @param        : Request data 
			* @return       : return with user account statement
    	*/
		public function user_account_statement()
		{

			$request = request();
			Session::flash('type','info' );
			Session::flash('message','ALL ACCOUNT STATEMENT HERE' );
			$user = Helper::get_userdetail(Session::get('B2C_USER_ID'));
			$descrip="";
			$start = date('2021-01-01');
			$end = date('Y-m-d',strtotime(NOW()));
			$txt_account = '';
			$txt_memberid = Session::get('B2C_USER_ID');
			$txt_transid = '';
			$txt_memberids = '';
			$txt_noofrecords = '20';
			$dd_ledgertype='-1';
			$cond="";
			$cond1="1";
			if($_SERVER['REQUEST_METHOD']=="POST")
            {
			    $start = date('Y-m-d',strtotime($request->input('txt_fromdate')));
				$end = date('Y-m-d',strtotime($request->input('txt_todate')));
				$txt_memberids = $request->input('txt_memberid');
				$dd_ledgertype = $request->input('dd_ledgertype');
				
				if($request->input('txt_account')!="" && $request->input('txt_account')!="0")
				{
					$txt_account=$request->input('txt_account');
				}
				if($request->input('txt_transid')!="" && $request->input('txt_transid')!="0")
				{
					$txt_transid=$request->input('txt_transid');
				}
				if($request->input('txt_memberid')!="" && $request->input('txt_memberid')!="0")
				{
					$txt_memberid = Helper::get_userid($request->input('txt_memberid'));
				}
				if($request->input('txt_noofrecords')!="" && $request->input('txt_noofrecords')!="0")
				{
					$txt_noofrecords =$request->input('txt_noofrecords');
				}
				if($request->input('dd_ledgertype')!="" && $request->input('dd_ledgertype')!=-1)
				{
					$dd_ledgertype=$request->input('dd_ledgertype');
				}
				
			}
			$cond=$cond.$cond1;
			$ledgerreport=array(
			'proc'=>2,
			'account'=>"",
			'transid'=>$txt_transid,
			'userid'=>$txt_memberid,
			'fromdate'=>$start,
			'todate'=>$end,
			'noofrecords'=>$txt_noofrecords,
			'ledegerstatus'=>$dd_ledgertype,
			'descrip'=>$cond
            );
           // dd($ledgerreport);
			$ledger_report = $this->fund_repo->ledgerReport($ledgerreport);

			return view('Front.FRONT10.account-statement', compact('ledger_report','user','start','end','txt_transid','dd_ledgertype','txt_memberids','txt_noofrecords'));
		}



		public function check_user_login()
		{
			if(Session::get('B2C_USER_ID') != '' && Session::get('B2C_USER_ROLE') == 'B2CUSER')
			{
				return 'ture';
			}
			else
			{
				return 'false';
			}
		}


	public function do_recharges(Request $request)
	{
		
		if(Session::get('B2C_USER_ID') != '' && Session::get('B2C_USER_ROLE') == 'B2CUSER')
		{
			$user = Helper::get_userdetail(Session::get('B2C_USER_ID'));
			Session::forget('txt_mobileno');
			Session::forget('dd_brand');
			Session::forget('txt_amount');

			if($request->payment_type == 1)
			{
				$data = $this->do_recharge($request);
				Session::flash('message', $data['message']);
				Session::flash('type', $data['type']);
				return redirect('/'); 

			}
			elseif($request->payment_type == 2)
			{
				$response =  Helper::razorpay($request, $user[0]);
				$form_data = $request->all();//dd($form_data);
				return view('PaymentGateway.index',compact('response','form_data'));

				Session::flash('message', $data['message']);
				Session::flash('type', $data['type']);
				return redirect('/'); 
			}
		}
		else
		{	
			Session::put('txt_mobileno', $request->txt_mobileno);	
			Session::put('dd_brand', $request->dd_brand);	
			Session::put('txt_amount', $request->txt_amount);		
			Session::flash('message','Please Login');
			Session::flash('type','Success');
			return redirect('sign-in'); 
		}
	}




    public function payment_complete(Request $request)
    {        
				// Now verify the signature is correct . We create the private function for verify the signature
			    $signatureStatus = Helper::SignatureVerify(
			        $request->all()['rzp_signature'],
			        $request->all()['rzp_paymentid'],
			        $request->all()['rzp_orderid']
			    );


			$dataarray = [
								  'm11_user_id' => Session::get('B2C_USER_ID'),
								  'm11_user_code' => Session::get('B2C_USER_CODE'),
								  'tr31_op_amount' => $request->txt_amount,
								  'tr31_op_currency' => 2,
								  'tr31_op_txnid' => $request->receiptId,
								  'tr31_op_paymentid' => $request->rzp_paymentid,
								  'tr31_op_gatewaytxn_id' => $request->rzp_orderid,
								  'tr31_op_gateway_res' => $request->rzp_signature,
								  'tr31_op_status' => 1,
								];

			DB::table('tr31_online_payment')->insert($dataarray);


			    // If Signature status is true We will save the payment response in our database
			    // In this tutorial we send the response to Success page if payment successfully made
			    if($signatureStatus)
			    {
					$fundtransfer_data=array(
					'proc'=>8,
					'to_user_id'=>Session::get('B2C_USER_ID'),
					'from_user_id'=>0,
					'amount'=>floatval($request->txt_amount),
					'collected_amount'=>floatval($request->txt_amount),
					'requesttype'=>1,
					'balfor'=>1,
					'transtype'=>1,
					'timelimit'=>(config('FUND_INTERVAL')*60),
					'defaultstatus'=>1,
					'remark'=>"ONLINE PAYMENT",
					'collected_remark'=>"ONLINE PAYMENT"
					);

					$fundtransfer = DB::SELECT('CALL wallettransfer(
					:proc, 
					:to_user_id,
					:from_user_id,
					:amount, 
					:collected_amount,
					:requesttype,
					:balfor,:transtype,
					:timelimit,
					:defaultstatus,
					:remark,
					:collected_remark,
					@status_code,
					@status_msg)'
					,$fundtransfer_data);
					$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
					$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
					$ERRCODE=$ERRCODE[0]->ERR_CODE;
					$ERRMSG=$ERRMSG[0]->ERR_MSG;
			
					if($ERRCODE=="success")
					{
						$data = $this->do_recharge($request);
						Session::flash('message', $data['message']);
						Session::flash('type', $data['type']);
						return redirect('/'); 
					}else
					{
							Session::flash('message', $ERRMSG);
							Session::flash('type', $ERRCODE);
							return redirect('/'); 
					}
				}
				else{
					$ERRMSG="PAYMENT FAILED";
                    $this->isError=FALSE;
                    $ERRCODE="warning";
				}
			
			Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
			return redirect('/'); 
		}



		/**
			* Method name   : do recharge
			* @description  : Used for recharge
			* @param        : Request data 
			* @return       : return with recharge response
    	*/
		public function do_recharge($request)
		{
			if(Session::get('B2C_USER_ID') != '' && Session::get('B2C_USER_ROLE') == 'B2CUSER')
			{
			//$request = request();
			$apitoken="";$userid="";$url="";
			$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";$operatorcircle="";
			$format="json";$param1="";$param2="";$api_operatorcode="";
			$res_format="json";$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="remark";
			$res_status="";$res_opid="";$res_rbid="";$res_msg="";$xmlarray ="";$mbal=0.00;$auto_switch='false';$hit_count=1;$auto_status='1';$next_api='';
			$SUCCESS_VALUE='';$PENDING_VALUE='';$FAILED_VALUE='';
			$status1="PENDING";
			$status2=2;
			$ERRCODE="warning";

			// RETAILER FEE
/*			$Controller = new Controller();
			$CountryInfo = $Controller->RETAILER_FEE();*/

			if($request->method() == 'POST')
			{
				if($request->input('txt_mobileno')=='')
				{
					$ERRMSG = "Consumner number should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('dd_brand')=='')
				{
					$ERRMSG = "Telecom Operator should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))<0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be negative.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}

				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$account=$request->input('txt_mobileno');
					$operatorcode=$request->input('dd_brand');
					$operatorcircle=$request->input('txt_circleid');
					$amount=$request->input('txt_amount');
					$rechreq=array(
					'proc'=>'1',
					'user_id'=>Session::get('B2C_USER_ID'),
					'mobile'=>$account,
					'operator'=>$operatorcode,
					'amount'=>$amount,
					'requesttype'=>1,
					'servicetype'=>1,
					'agentid'=>'',
					'format'=>$operatorcircle,
					'timelimit'=>(config('INTERVAL_RECHARGE')*60),
					'defaultstatus'=>2
					);	

					$rechreq_report = $this->rech_proc_repo->doRecharge($rechreq);
					$ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$ERROR=DB::select('SELECT @msg2 as ERROR');
//dd(	$ERRMSG, $ERROR);
					if($ERROR[0]->ERROR!="Error")
					{
						$transid=$ERRMSG[0]->ERR_MSG;
						foreach($rechreq_report as $row)
						{						
							break;
						}
						$next_api=$row->next_api;
						$url=$row->url_address;	
						$api_operatorcode=$row->oper_code;
						$apiid=$row->apiid;
						$param1=1;
						$res_format=$row->RES_FORMAT;$status=$row->RES_PARAM;$opid=$row->LIVEID;$rbid=$row->APITXNID;
						$SUCCESS_VALUE=$row->SUCCESS_VALUE;$PENDING_VALUE=$row->PENDING_VALUE;$FAILED_VALUE=$row->FAILED_VALUE;
						if($apitoken!="")
						$url=str_replace('@apitoken',$apitoken,$url);
						if($userid!="")
						$url=str_replace('@userid',$userid,$url);
						if($password!="")
						$url=str_replace('@password',$password,$url);
						if($account!="")
						$url=str_replace('@account',$account,$url);
						if($amount!="")
						$url=str_replace('@amount',$amount,$url);
						if($operatorcode!="")
						$url=str_replace('@operatorcode',$api_operatorcode,$url);
						if($ERROR[0]->ERROR!="Error")
						$url=str_replace('@refrence',$ERRMSG[0]->ERR_MSG,$url);
						if($format!="")
						$url=str_replace('@format',$format,$url);
						if($param1!="")
						$url=str_replace('@param1',$param1,$url);
						if($param2!="")
						$url=str_replace('@param2',$param2,$url);
						//echo $url.'</br>';
						///PRINT_R($ERRMSG[0]->ERR_MSG);
						
						$response=Helper::_curl_execute('GET',$url,'');
				$outgoinghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				VALUES ('','$transid','$operatorcode','$url','$response',2)");	
								if($res_format=="string")
								{
									$regex0 = '/[A-Z][^\\;]*(SUCCESS)[^\\;]*/';
									$regex1 = '/[A-Z][^\\;]*(Success)[^\\;]*/';
									$regexS1= '/[A-Z][^\\;]*(Succesful)[^\\;]*/';
									$regexS2= '/[A-Z][^\\;]*(SUCCESFUL)[^\\;]*/';
									$regex2 = '/[A-Z][^\\;]*(Failed)[^\\;]*/';
									$regex3 = '/[A-Z][^\\;]*(FAILED)[^\\;]*/';
									$regex4 = '/[A-Z][^\\;]*(FAIL)[^\\;]*/';
									$status1="PENDING";
									$status2=2;
									$ERRCODE="warning";
									if(preg_match_all($regex0, $response, $match) || preg_match_all($regex1, $response, $match)) 
									{
										$start1 = "TXID ";
										$end1 = " ";
										$operid=Helper::getBetween($response,$start1,$end1);
										$res_status="SUCCESS";
										$status2=1;
										$margin=$amt;
										$ERRCODE="success";
									}
									if (preg_match_all($regex2, $response, $match) || preg_match_all($regex3, $response, $match) || preg_match_all($regex4, $response, $match)) 
									{
										$res_status="FAILED";
										$status2=4;
										if(preg_match_all($regex2, $response, $match) || preg_match_all($regex3, $response, $match))
										{
											$start1 = "Failed";
											$end1 = "BAL";
											$operid=Helper::getBetween($response,$start1,$end1);
										}
										if(preg_match_all($regex2, $response, $match))
										{
											$start1 = "Reson=";
											$end1 = "Bal";
											$operid=Helper::getBetween($response,$start1,$end1);
										}
										$ERRCODE="danger";
									}
								}
						if($res_format=="JSON")
						{
							$json=json_decode($response,true);
							if($status!="")
							{
								if(!empty($json[$status]))
								$res_status=$json[$status];
								else
								{
								$is_error=$json['error'];
								if($is_error=='true')
								$res_status="FAILED";
								}
								if($res_status==$FAILED_VALUE || $res_status=="FAILED" || $res_status=="REFUND" || $res_status=="Failed" || $res_status=="LOGINFAILED" || $res_status=="Error")
        						$auto_switch='true';
							}
							if($opid!='')
							{
							    if(!empty($json[$opid]))
								$res_opid=$json[$opid];
							}
							if($rbid!='')
							{
							       if(!empty($json[$rbid]))
									$res_rbid=$json[$rbid];
							}
						}
						if($res_format=="xml" || $res_format=="XML" )
						{
							$array = XmlToArray::convert($response);
							$json = json_encode($array);
							$xmlarray = json_decode($json,TRUE);
							if($status!="")
							{
								 if(!empty($xmlarray[$status]))
								$res_status=$xmlarray[$status];
								
							}
							if($opid!='' && $res_status=="SUCCESS" )
							{
							    if(!empty($xmlarray[$opid]))
								$res_opid=$xmlarray[$opid];
							}
							if($rbid!='' && ($res_status!="FAILED" || $res_status!="REFUND") )
							{
							    if(!empty($xmlarray[$rbid]))
								$res_rbid=$xmlarray[$rbid];
						
							}
							if($msg!='' && ($res_status!="FAILED" || $res_status!="REFUND") )
							{
							    if(!empty($xmlarray[$msg]))
								$res_msg=$xmlarray[$msg];
								
							}
							if($res_status=="FAILED" || $res_status=="REFUND") 
							{
							    $auto_switch='true';
							}
						}

						 $arr = array(
						    'tr05_api_txnid'=>$res_rbid,
							'tr05_remarks' =>trim($response)
						);
						DB::table('tr05_recharge_detail')->where('tr05_trans_id',$transid)->update($arr);
						if($auto_switch=='true' && $next_api!=0)
						{
							do{ 
								$auto_response=$this->auto_switch_api(Session::get('USER_ID'),$transid,$operatorcode,$hit_count);
								if($auto_response=='')
								$hit_count=$hit_count+1;
								else
								break;
							}while (($status=='' || $hit_count<6));
							   
								
						}
						else
						{
						    $auto_switch='false';$auto_status='1';
						}
					
						if($auto_switch=='false' && $auto_status!='')
						{
        						if($res_status==$SUCCESS_VALUE || $res_status=="SUCCESS" || $res_status=="Success" )
        						{
        							$status1="SUCCESS";
        							$status2=1;
        						}
        						if($res_status==$PENDING_VALUE || $res_status=="PENDING" || $res_status=="Pending")
        						{
        							$status1="PENDING";
        							$status2=2;
        						}
        						if($res_status==$FAILED_VALUE || $res_status=="FAILED" || $res_status=="REFUND" || $res_status=="Failed" || $res_status=="LOGINFAILED" || $res_status=="Error")
        						{
        							$status1="FAILED";
        							$status2=4;
        						}
						$respreport=array(
						'proc'=>1,
						'userid'=>Session::get('B2C_USER_ID'),
						'account'=>$account,
						'transid'=>$transid,
						'liveid'=>$res_opid,
						'amt'=>$amount,
						'recstatus'=>$status2,
						'descrip'=>1							
						);
						$resquery = $this->rech_proc_repo->rechargeStatusUpdate($respreport);
						}
						$ERRCODE=$ERRCODE;
						$ERRMSG="RECHARGE HAS BEEN ".$status1;

					}
					else
					{
						$ERRCODE='warning';
						$ERRMSG=$ERRMSG[0]->ERR_MSG;
					}
				}
			}

				//Session::flash('message',$ERRMSG);
				//Session::flash('type',$ERRCODE);
				$data = ['message' => $ERRMSG, 'type' => $ERRCODE];
				return $data; 
			}
			else
			{
				//Session::flash('message','User Not Found');
				//Session::flash('type','warning');
				$data = ['message' => 'User Not Found', 'type' => 'warning'];
				return $data; 
			}

			}



		/**
			* Method name   : do dth recharge
			* @description  : Used for dth recharge
			* @param        : Request data 
			* @return       : return with dth recharge response
    	*/



	public function do_dthrecharges(Request $request)
	{
		
		
		if(Session::get('B2C_USER_ID') != '' && Session::get('B2C_USER_ROLE') == 'B2CUSER')
		{

			$user = Helper::get_userdetail(Session::get('B2C_USER_ID'));
			Session::forget('txt_cardno');
			Session::forget('dd_dthbrand');
			Session::forget('txt_amount');
			Session::forget('payment_type');

			if($request->payment_type == 1)
			{
				$data = $this->do_dthrecharge($request);
				Session::flash('message', $data['message']);
				Session::flash('type', $data['type']);
				return redirect('dth'); 
			}
			elseif($request->payment_type == 2)
			{
				$response =  Helper::razorpay($request, $user[0]);
				$form_data = $request->all();//dd($form_data);
				return view('PaymentGateway.dthpay',compact('response','form_data'));

				Session::flash('message', $data['message']);
				Session::flash('type', $data['type']);
				return redirect('dth'); 
			}
		}
		else
		{	
			Session::put('txt_cardno', $request->txt_cardno);	
			Session::put('dd_dthbrand', $request->dd_dthbrand);	
			Session::put('txt_amount', $request->txt_amount);
			Session::put('payment_type', $request->payment_type);		
			Session::flash('message','Please Login');
			Session::flash('type','Success');
			return redirect('sign-in'); 
		}
	}



    public function payment_complete_dth(Request $request)
    {        
				// Now verify the signature is correct . We create the private function for verify the signature
			    $signatureStatus = Helper::SignatureVerify(
			        $request->all()['rzp_signature'],
			        $request->all()['rzp_paymentid'],
			        $request->all()['rzp_orderid']
			    );

			$dataarray = [
								  'm11_user_id' => Session::get('B2C_USER_ID'),
								  'm11_user_code' => Session::get('B2C_USER_CODE'),
								  'tr31_op_amount' => $request->txt_amount,
								  'tr31_op_currency' => 2,
								  'tr31_op_txnid' => $request->receiptId,
								  'tr31_op_paymentid' => $request->rzp_paymentid,
								  'tr31_op_gatewaytxn_id' => $request->rzp_orderid,
								  'tr31_op_gateway_res' => $request->rzp_signature,
								  'tr31_op_status' => 1,
								];

			DB::table('tr31_online_payment')->insert($dataarray);


			    // If Signature status is true We will save the payment response in our database
			    // In this tutorial we send the response to Success page if payment successfully made
			    if($signatureStatus)
			    {
					$fundtransfer_data=array(
					'proc'=>8,
					'to_user_id'=>Session::get('B2C_USER_ID'),
					'from_user_id'=>0,
					'amount'=>floatval($request->txt_amount),
					'collected_amount'=>floatval($request->txt_amount),
					'requesttype'=>1,
					'balfor'=>1,
					'transtype'=>1,
					'timelimit'=>(config('FUND_INTERVAL')*60),
					'defaultstatus'=>1,
					'remark'=>"ONLINE PAYMENT",
					'collected_remark'=>"ONLINE PAYMENT"
					);

					$fundtransfer = DB::SELECT('CALL wallettransfer(
					:proc, 
					:to_user_id,
					:from_user_id,
					:amount, 
					:collected_amount,
					:requesttype,
					:balfor,:transtype,
					:timelimit,
					:defaultstatus,
					:remark,
					:collected_remark,
					@status_code,
					@status_msg)'
					,$fundtransfer_data);
					$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
					$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
					$ERRCODE=$ERRCODE[0]->ERR_CODE;
					$ERRMSG=$ERRMSG[0]->ERR_MSG;
			
					if($ERRCODE=="success")
					{
						$data = $this->do_dthrecharge($request);
						Session::flash('message', $data['message']);
						Session::flash('type', $data['type']);
						return redirect('dth'); 
					}else
					{
							Session::flash('message', $ERRMSG);
							Session::flash('type', $ERRCODE);
							return redirect('dth'); 
					}
				}
				else{
					$ERRMSG="PAYMENT FAILED";
                    $this->isError=FALSE;
                    $ERRCODE="warning";
				}
			
			Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
			return redirect('dth'); 
		}




		public function do_dthrecharge(request $request)
		{
			$apitoken="";$userid="";$url="";
			$password="";$account="9919111999";$amount="23.00";$operatorcode="2";$refrence="";
			$format="json";$param1="";$param2="";
			$res_format="json";$status="STATUS";$opid="OPTRANSID";$rbid="ORDERID";$msg="remark";
			$res_status="";$res_opid="";$res_rbid="";$res_msg="";$xmlarray ="";$mbal=0.00;$auto_switch='false';$hit_count=1;$auto_status='1';$next_api='';
			$SUCCESS_VALUE='';$PENDING_VALUE='';$FAILED_VALUE='';
			$status1="PENDING";
			$status2=2;
			$ERRCODE="warning";


				if($request->input('txt_cardno')=='')
				{
					$ERRMSG = "Consumner number should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('dd_dthbrand')=='')
				{
					$ERRMSG = "Telecom Operator should be valid or not blank.";
					$this->isError= TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))=='' || floatval($request->input('txt_amount'))==0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if(floatval($request->input('txt_amount'))<0.00)
				{
					$ERRMSG = "Amount should be greater than 0.00 or not be negative.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError=FALSE;
					$ERRCODE="success";
				}

				if(request()->method() == 'POST' && $this->isError==FALSE)
				{
					$account=$request->input('txt_cardno');
					$operatorcode=$request->input('dd_dthbrand');
					$amount=$request->input('txt_amount');
					$rechreq=array(
					'proc'=>'1',
					'user_id'=>Session::get('B2C_USER_ID'),
					'mobile'=>$account,
					'operator'=>$operatorcode,
					'amount'=>$amount,
					'requesttype'=>1,
					'servicetype'=>2,
					'agentid'=>'',
					'format'=>1,
					'timelimit'=>(config('INTERVAL_RECHARGE')*60),
					'defaultstatus'=>2
					);	

					$rechreq_report = $this->rech_proc_repo->doRecharge($rechreq);
					$ERRMSG=DB::select('SELECT @msg as ERR_MSG');
					$ERROR=DB::select('SELECT @msg2 as ERROR');
				//	dd($ERRMSG[0]->ERR_MSG);
					if($ERROR[0]->ERROR!="Error")
					{
						$transid=$ERRMSG[0]->ERR_MSG;
						foreach($rechreq_report as $row)
						{						
							break;
						}
						$next_api=$row->next_api;
						$url=$row->url_address;	
						$operatorcode=$row->oper_code;
						$apiid=$row->apiid;
						$param1=2;
						$res_format=$row->RES_FORMAT;$status=$row->RES_PARAM;$opid=$row->LIVEID;$rbid=$row->APITXNID;
						$SUCCESS_VALUE=$row->SUCCESS_VALUE;$PENDING_VALUE=$row->PENDING_VALUE;$FAILED_VALUE=$row->FAILED_VALUE;
						if($apitoken!="")
						$url=str_replace('@apitoken',$apitoken,$url);
						if($userid!="")
						$url=str_replace('@userid',$userid,$url);
						if($password!="")
						$url=str_replace('@password',$password,$url);
						if($account!="")
						$url=str_replace('@account',$account,$url);
						if($amount!="")
						$url=str_replace('@amount',$amount,$url);
						if($operatorcode!="")
						$url=str_replace('@operatorcode',$operatorcode,$url);
						if($ERROR[0]->ERROR!="Error")
						$url=str_replace('@refrence',$ERRMSG[0]->ERR_MSG,$url);
						if($format!="")
						$url=str_replace('@format',$format,$url);
						if($param1!="")
						$url=str_replace('@param1',$param1,$url);
						if($param2!="")
						$url=str_replace('@param2',$param2,$url);
						//echo $url.'</br>';
						//PRINT_R($ERRMSG[0]->ERR_MSG);
						$response=Helper::_curl_execute('GET',$url,'');
				$outgoinghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
				VALUES ('','$transid','$operatorcode','$url','$response',2)");	
                      $res_rbid="2598223";
								if($res_format=="string")
								{
									$regex0 = '/[A-Z][^\\;]*(SUCCESS)[^\\;]*/';
									$regex1 = '/[A-Z][^\\;]*(Success)[^\\;]*/';
									$regexS1= '/[A-Z][^\\;]*(Succesful)[^\\;]*/';
									$regexS2= '/[A-Z][^\\;]*(SUCCESFUL)[^\\;]*/';
									$regex2 = '/[A-Z][^\\;]*(Failed)[^\\;]*/';
									$regex3 = '/[A-Z][^\\;]*(FAILED)[^\\;]*/';
									$regex4 = '/[A-Z][^\\;]*(FAIL)[^\\;]*/';
									$status1="PENDING";
									$status2=2;
									$ERRCODE="warning";
									if(preg_match_all($regex0, $response, $match) || preg_match_all($regex1, $response, $match)) 
									{
										$start1 = "TXID ";
										$end1 = " ";
										$operid=Helper::getBetween($response,$start1,$end1);
										$res_status="SUCCESS";
										$status2=1;
										$margin=$amt;
										$ERRCODE="success";
									}
									if (preg_match_all($regex2, $response, $match) || preg_match_all($regex3, $response, $match) || preg_match_all($regex4, $response, $match)) 
									{
										$res_status="FAILED";
										$status2=4;
										if(preg_match_all($regex2, $response, $match) || preg_match_all($regex3, $response, $match))
										{
											$start1 = "Failed";
											$end1 = "BAL";
											$operid=Helper::getBetween($response,$start1,$end1);
										}
										if(preg_match_all($regex2, $response, $match))
										{
											$start1 = "Reson=";
											$end1 = "Bal";
											$operid=Helper::getBetween($response,$start1,$end1);
										}
										$ERRCODE="danger";
									}
								}
						if($res_format=="JSON")
						{
							$json=json_decode($response,true);
							if($status!="")
							{
									if(!empty($json[$status]))
								$res_status=$json[$status];
								else
								{
								$is_error=$json['error'];
								if($is_error=='true')
								$res_status="FAILED";
								}
								if($res_status==$FAILED_VALUE || $res_status=="FAILED" || $res_status=="REFUND" || $res_status=="Failed" || $res_status=="LOGINFAILED" || $res_status=="Error")
        						$auto_switch='true';
							}
						if($opid!='')
							{
							    if(!empty($json[$opid]))
								$res_opid=$json[$opid];
							}
							if($rbid!='')
							{
							       if(!empty($json[$rbid]))
									$res_rbid=$json[$rbid];
							}
						}
						if($res_format=="xml" || $res_format=="XML" )
						{
							$array = XmlToArray::convert($response);
							$json = json_encode($array);
							$xmlarray = json_decode($json,TRUE);
							if($status!="")
							{
								 if(!empty($xmlarray[$status]))
								$res_status=$xmlarray[$status];
								
							}
							if($opid!='' && $res_status=="SUCCESS" )
							{
							    if(!empty($xmlarray[$opid]))
								$res_opid=$xmlarray[$opid];
							}
							if($rbid!='' && ($res_status!="FAILED" || $res_status!="REFUND") )
							{
							    if(!empty($xmlarray[$rbid]))
								$res_rbid=$xmlarray[$rbid];
						
							}
							if($msg!='' && ($res_status!="FAILED" || $res_status!="REFUND") )
							{
							    if(!empty($xmlarray[$msg]))
								$res_msg=$xmlarray[$msg];
								
							}
							if($res_status=="FAILED" || $res_status=="REFUND") 
							{
							    $auto_switch='true';
							}
						}

						 $arr = array(
						    'tr05_api_txnid'=>$res_rbid,
							'tr05_remarks' =>trim($response)
						);
						DB::table('tr05_recharge_detail')->where('tr05_trans_id',$transid)->update($arr);
						if($auto_switch=='true' && $next_api!=0)
						{
							do{ 
								$auto_response=$this->auto_switch_api(Session::get('B2C_USER_ID'),$transid,$operatorcode,$hit_count);
								if($auto_response=='')
								$hit_count=$hit_count+1;
								else
								break;
							}while (($status=='' || $hit_count<6));		
						}
						else
						{
						    $auto_switch='false';$auto_status='1';
						}
					
						if($auto_switch=='false' && $auto_status!='')
						{
        						if($res_status==$SUCCESS_VALUE || $res_status=="SUCCESS" || $res_status=="Success" )
        						{
        							$status1="SUCCESS";
        							$status2=1;
        						}
        						if($res_status==$PENDING_VALUE || $res_status=="PENDING" || $res_status=="Pending")
        						{
        							$status1="PENDING";
        							$status2=2;
        						}
        						if($res_status==$FAILED_VALUE || $res_status=="FAILED" || $res_status=="REFUND" || $res_status=="Failed" || $res_status=="LOGINFAILED" || $res_status=="Error")
        						{
        							$status1="FAILED";
        							$status2=4;
        						}
						$respreport=array(
						'proc'=>1,
						'userid'=>Session::get('B2C_USER_ID'),
						'account'=>$account,
						'transid'=>$transid,
						'liveid'=>$res_opid,
						'amt'=>$amount,
						'recstatus'=>$status2,
						'descrip'=>1							
						);

						$resquery = $this->rech_proc_repo->rechargeStatusUpdate($respreport);
								}
						$ERRCODE=$ERRCODE;
						$ERRMSG="RECHARGE HAS BEEN ".$status1." TRANSACTION ID- ".$ERRMSG[0]->ERR_MSG;
					}
					else
					{
						$ERRCODE='warning';
						$ERRMSG=$ERRMSG[0]->ERR_MSG;
					}
				}

				$data = ['message' => $ERRMSG, 'type' => $ERRCODE];
				return $data; 	
		}









		/**
				* Method name	: Add money in wallet
				* @description 	: Add money in wallet
				* @param		: user info and amount 
				* @return		: return user dash 
			*/    


	public function btoc_add_money_wallet(Request $request)
	{
		$user = Helper::get_userdetail(Session::get('B2C_USER_ID'));
		
		if(Session::get('B2C_USER_ID') != '' && Session::get('B2C_USER_ROLE') == 'B2CUSER' && count($user) > 0)
		{		
				$user = Helper::get_userdetail(Session::get('B2C_USER_ID'));
				$response =  Helper::razorpay($request, $user[0]);
				$form_data = $request->all();
				return view('PaymentGateway.addwallet',compact('response','form_data'));
		}
		else
		{		
			Session::flash('message','Please Login');
			Session::flash('type','Success');
			return redirect('sign-in'); 
		}
	}



    public function AddMoneyWallet(Request $request)
    {        
				// Now verify the signature is correct . We create the private function for verify the signature
			    $signatureStatus = Helper::SignatureVerify(
			        $request->all()['rzp_signature'],
			        $request->all()['rzp_paymentid'],
			        $request->all()['rzp_orderid']
			    );


			$dataarray = [
								  'm11_user_id' => Session::get('B2C_USER_ID'),
								  'm11_user_code' => Session::get('B2C_USER_CODE'),
								  'tr31_op_amount' => $request->txt_amounts,
								  'tr31_op_currency' => 2,
								  'tr31_op_txnid' => $request->receiptId,
								  'tr31_op_paymentid' => $request->rzp_paymentid,
								  'tr31_op_gatewaytxn_id' => $request->rzp_orderid,
								  'tr31_op_gateway_res' => $request->rzp_signature,
								  'tr31_op_status' => 1,
								];

			DB::table('tr31_online_payment')->insert($dataarray);


			    // If Signature status is true We will save the payment response in our database
			    // In this tutorial we send the response to Success page if payment successfully made
			    if($signatureStatus)
			    {
					$fundtransfer_data=array(
					'proc'=>8,
					'to_user_id'=>Session::get('B2C_USER_ID'),
					'from_user_id'=>0,
					'amount'=>floatval($request->txt_amounts),
					'collected_amount'=>floatval($request->txt_amount),
					'requesttype'=>1,
					'balfor'=>1,
					'transtype'=>1,
					'timelimit'=>(config('FUND_INTERVAL')*60),
					'defaultstatus'=>1,
					'remark'=>"ONLINE PAYMENT",
					'collected_remark'=>"ONLINE PAYMENT"
					);

					$fundtransfer = DB::SELECT('CALL wallettransfer(
					:proc, 
					:to_user_id,
					:from_user_id,
					:amount, 
					:collected_amount,
					:requesttype,
					:balfor,:transtype,
					:timelimit,
					:defaultstatus,
					:remark,
					:collected_remark,
					@status_code,
					@status_msg)'
					,$fundtransfer_data);
					$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
					$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
					$ERRCODE=$ERRCODE[0]->ERR_CODE;
					$ERRMSG=$ERRMSG[0]->ERR_MSG;
					$msg =  $request->txt_amounts.' RS Add Money Wallet Successfully';
					if($ERRCODE=="success")
					{
						Session::flash('message', $msg);
						Session::flash('type', $ERRCODE);
						return back()->with('success', $msg);
					}else
					{
							Session::flash('message', $ERRMSG);
							Session::flash('type', $ERRCODE);
							return back()->with('success', $ERRMSG);
					}
				}
				else{
					$ERRMSG="PAYMENT FAILED";
                    $this->isError=FALSE;
                    $ERRCODE="error";
				}
			
			Session::flash('type',$ERRCODE );
			Session::flash('message',$ERRMSG );
			return back()->with('success', $ERRMSG);
		}




   public function failedbtoc(Request $request)
    {        

				$dataarray = [
								  'm11_user_id' => Session::get('B2C_USER_ID'),
								  'm11_user_code' => Session::get('B2C_USER_CODE'),
								  'tr31_op_amount' => $request->txt_amount,
								  'tr31_op_currency' => 2,
								  'tr31_op_txnid' => $request->receiptId,
								  'tr31_op_paymentid' => $request->rzp_paymentid,
								  'tr31_op_gatewaytxn_id' => $request->rzp_orderid,
								  'tr31_op_gateway_res' => $request->rzp_signature,
								  'tr31_op_status' => 1,
								];

					DB::table('tr31_online_payment')->insert($dataarray);

					$ERRMSG="PAYMENT FAILED";
                    $ERRCODE="error";
					Session::flash('type',$ERRCODE );
					Session::flash('message',$ERRMSG );
					return back()->with('error', $ERRMSG);
		}






		
		/**
				* Method name	: Send Sms
				* @description 	: Used for sending sms 
				* @param		: Phone number and sending message 
				* @return		: return message to user
			*/    
		public function send_sms($mob,$msg)
		{
			$url = Config('SMS_SEND_URL');
			$params = array(
	        'user'=>Config('SMS_AUTH'),
	        'password'=>Config('SMS_PWD'),
	        'msisdn'=>$mob,
	        'sid'=>Config('SMS_SENDERID'),
	        'msg'=>$msg,         
	        'fl'=>0,             
	        'gwid'=>2    
			);
			Helper::_curl_execute('GET',$url,$params);
		}


}