<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use App\Repositories\Enroll\EnrollRepository;
use App\Repositories\Master\Location\LocationRepository;
use App\Repositories\Master\Package\PackageRepository;
use App\Repositories\Master\Bank\BankRepository;
use App\Repositories\Fund\FundRepository;
use DB;
use Helper;
use Session;
use Hash;
use Illuminate\Support\Facades\Crypt;

class AuthController extends Controller
{
	private $enroll_repo;
	private $location_repo;
	private $package_repo;
	private $bank_repo;
	private $fund_repo;

	public function __construct(BankRepository $bank_repo, LocationRepository $location_repo, PackageRepository $package_repo, EnrollRepository $enroll_repo, FundRepository $fund_repo)
    {
        	$this->location_repo = $location_repo;
        	$this->package_repo = $package_repo;
    		$this->bank_repo = $bank_repo;
        	$this->enroll_repo = $enroll_repo;
    	    $this->fund_repo = $fund_repo;
    }

    public function index()
	{
		return view('Auth.login');
	}
	
	public function register()
	{
		return view('Auth.register');
	}

	public function autocomplete()  
	{
		$request = request();
		
		if(Session::get('USER_ID')==-1)
		{
			$result=$this->enroll_repo->getAutocomplete($request->input('term'));
		}
		else
		{
			$result=$this->enroll_repo->getAcWithReferral($request->input('term'), Session::get('USER_ID'));
		}
		$dataModified = array();
		foreach ($result as $data)
		{
			$dataModified[] = ['phone' => $data->MemberContactNo, 'MemberName' => '['.$data->FirstName.' '.$data->LastName.'] ' , 'Code' => $data->RegCode , 'MemberId' => $data->RegId];

	//$dataModified[] = $data->MemberContactNo . $data->FirstName . $data->LastName . $data->RegCode, 'Id' => $data->RegId;
		}
		
		return response()->json($dataModified);
		//return response()->json($result);
	}


	public function get_details()   
	{
		$request = request();
		$result=$this->enroll_repo->getUserByContact($request->input('txt_contactno'));
		return json_encode($result);
	}
	


	public function get_mem_details()   
	{
		$request = request();
		$result=$this->enroll_repo->getUserByUserCode($request->input('txt_contactno'));
		return json_encode($result);
	}





	public function get_roles_name(request $request)   
	{

	if(Session::get('USER_ID') == -1)
	{
		$role = "SUPER ADMIN";
	}
	else
	{
		$user = Helper::get_userdetail(Session::get('USER_ID'));
		$role = $user[0]->MemberRole;
	}
	
	$users = Helper::get_userid($request->id);
	if($users == '')
	{ 
		return 'USER NOT FOUND';
	}
	else
	{
		$user = Helper::get_userdetail($users);

		if($user)
		{
			$user_role = $user[0]->MemberRole;
				$data = '<option value="8" {{ old("dd_role") == 8? "selected":""}}>B2CUSER</option>';
				if($role == 'SUPER ADMIN' && $user_role == 'BRANCH')
				{
						$data = '<option value="1" {{ old("dd_role") == 1? "selected":""}}>BRANCH</option>
									 <option value="2" {{ old("dd_role") == 2? "selected":""}}>WHITE LABEL</option>
									 <option value="3" {{ old("dd_role") == 3? "selected":""}}>API USER</option>
									 <option value="4" {{ old("dd_role") == 4? "selected":""}}>SUPER DISTRIBUTOR</option>
									 <option value="5" {{ old("dd_role") == 5? "selected":""}}>DISTRIBUTOR</option>
									 <option value="6" {{ old("dd_role") == 6? "selected":""}}>FOS</option>
									 <option value="7" {{ old("dd_role") == 7? "selected":""}}>AGENT</option>
									 <option value="8" {{ old("dd_role") == 8? "selected":""}}>B2CUSER</option>';
				}
				if($role == 'BRANCH' && $user_role == 'BRANCH')
				{
						$data = '<option value="4" {{ old("dd_role") == 4? "selected":""}}>SUPER DISTRIBUTOR</option>
									 <option value="5" {{ old("dd_role") == 5? "selected":""}}>DISTRIBUTOR</option>
									 <option value="6" {{ old("dd_role") == 6? "selected":""}}>FOS</option>
									 <option value="7" {{ old("dd_role") == 7? "selected":""}}>AGENT</option>
									 <option value="8" {{ old("dd_role") == 8? "selected":""}}>B2CUSER</option>';
				}
				if($role == 'SUPER ADMIN' && $user_role == 'WHITE LABEL' || $role == 'BRANCH' && $user_role == 'WHITE LABEL' ||  $role == 'WHITE LABEL' && $user_role == 'BRANCH' ||  $role == 'WHITE LABEL' && $user_role == 'WHITE LABEL')
				{
						$data = '<option value="4" {{ old("dd_role") == 4? "selected":""}}>SUPER DISTRIBUTOR</option>
									 <option value="5" {{ old("dd_role") == 5? "selected":""}}>DISTRIBUTOR</option>
									 <option value="6" {{ old("dd_role") == 6? "selected":""}}>FOS</option>
									 <option value="7" {{ old("dd_role") == 7? "selected":""}}>AGENT</option>
									 <option value="8" {{ old("dd_role") == 8? "selected":""}}>B2CUSER</option>';
				}
				if($role == 'SUPER ADMIN' && $user_role == 'API USER' || $role == 'BRANCH' && $user_role == 'API USER' || $role == 'WHITE LABEL' && $user_role == 'API USER' || $role == 'API USER' && $user_role == 'API USER' || $role == 'API USER' && $user_role == 'BRANCH' || $role == 'API USER' && $user_role == 'WHITE LABEL')
				{
						$data = '';
				}
				if($role == 'SUPER ADMIN' && $user_role == 'SUPER DISTRIBUTOR' || $role == 'BRANCH' && $user_role == 'SUPER DISTRIBUTOR'  || $role == 'WHITE LABEL' && $user_role == 'SUPER DISTRIBUTOR' || $role == 'API USER' && $user_role == 'SUPER DISTRIBUTOR' || $role == 'SUPER DISTRIBUTOR' && $user_role == 'SUPER DISTRIBUTOR' || $role == 'SUPER DISTRIBUTOR' && $user_role == 'BRANCH' || $role == 'SUPER DISTRIBUTOR' && $user_role == 'WHITE LABEL' || $role == 'SUPER DISTRIBUTOR' && $user_role == 'API USER')
				{
						$data = '<option value="5" {{ old("dd_role") == 5? "selected":""}}>DISTRIBUTOR</option>
									 <option value="6" {{ old("dd_role") == 6? "selected":""}}>FOS</option>
									 <option value="7" {{ old("dd_role") == 7? "selected":""}}>AGENT</option>
									 <option value="8" {{ old("dd_role") == 8? "selected":""}}>B2CUSER</option>';
				}
				if($role == 'SUPER ADMIN' && $user_role == 'DISTRIBUTOR' || $role == 'BRANCH' && $user_role == 'DISTRIBUTOR' || $role == 'WHITE LABEL' && $user_role == 'DISTRIBUTOR' || $role == 'API USER' && $user_role == 'DISTRIBUTOR'  || $role == 'SUPER DISTRIBUTOR' && $user_role == 'DISTRIBUTOR' || $role == 'DISTRIBUTOR' && $user_role == 'DISTRIBUTOR' || $role == 'DISTRIBUTOR' && $user_role == 'BRANCH' || $role == 'DISTRIBUTOR' && $user_role == 'WHITE LABEL' || $role == 'DISTRIBUTOR' && $user_role == 'API USER' || $role == 'DISTRIBUTOR' && $user_role == 'SUPER DISTRIBUTOR')
				{
						$data = '<option value="6" {{ old("dd_role") == 6? "selected":""}}>FOS</option>
									 <option value="7" {{ old("dd_role") == 7? "selected":""}}>AGENT</option>
									 <option value="8" {{ old("dd_role") == 8? "selected":""}}>B2CUSER</option>';
				}
				if($role == 'SUPER ADMIN' && $user_role == 'FOS' || $role == 'BRANCH' && $user_role == 'FOS' || $role == 'WHITE LABEL' && $user_role == 'FOS' || $role == 'API USER' && $user_role == 'FOS' || $role == 'SUPER DISTRIBUTOR' && $user_role == 'FOS' || $role == 'FOS' && $user_role == 'FOS' || $role == 'FOS' && $user_role == 'BRANCH' || $role == 'FOS' && $user_role == 'WHITE LABEL' || $role == 'FOS' && $user_role == 'API USER' || $role == 'FOS' && $user_role == 'SUPER DISTRIBUTOR'  || $role == 'FOS' && $user_role == 'DISTRIBUTOR') 
				{
						$data = '<option value="7" {{ old("dd_role") == 7? "selected":""}}>AGENT</option>
									 <option value="8" {{ old("dd_role") == 8? "selected":""}}>B2CUSER</option>';
				}
				if($role == 'SUPER ADMIN' && $user_role == 'AGENT' || $role == 'SUPER ADMIN' && $user_role == 'B2CUSER' || $role == 'BRANCH' && $user_role == 'AGENT' || $role == 'WHITE LABEL' && $user_role == 'AGENT' || $role == 'API USER' && $user_role == 'AGENT' || $role == 'SUPER DISTRIBUTOR' && $user_role == 'AGENT' || $role == 'BRANCH' && $user_role == 'B2CUSER' || $role == 'WHITE LABEL' && $user_role == 'B2CUSER' || $role == 'API USER' && $user_role == 'B2CUSER' || $role == 'SUPER DISTRIBUTOR' && $user_role == 'B2CUSER'  || $role == 'FOS' && $user_role == 'AGENT'  || $role == 'AGENT' && $user_role == 'AGENT' || $role == 'AGENT' && $user_role == 'BRANCH' || $role == 'AGENT' && $user_role == 'WHITE LABEL' || $role == 'AGENT' && $user_role == 'API USER' || $role == 'AGENT' && $user_role == 'SUPER DISTRIBUTOR' || $role == 'AGENT' && $user_role == 'DISTRIBUTOR' || $role == 'AGENT' && $user_role == 'FOS' || $role == 'AGENT' && $user_role == 'B2CUSER'  || $role == 'B2CUSER' && $user_role == 'B2CUSER') 
				{
						$data = '<option value="8" {{ old("dd_role") == 8? "selected":""}}>B2CUSER</option>';
				}

			
			return $data;
		}
		else
		{
			$user_role ='';
			return 'USER NOT FOUND';
		}

	}
	}



	/**
			* Method name	: Signin
			* @description 	: Used to Signin 
			* @param		: Request data  
			* @return		: Get Login data array with response message
		*/
	public function signin()
	{
		$request = request();
		$OTP_STATUS ="NONE";
		if(request()->method() == 'POST')
		{
			$this->validate($request, [
            'txt_username'=> 'required',
            'txt_password'=> 'required|min:3'
			],
			[
            'txt_password.required' => 'User name is required',
            'txt_password.required' => 'Password is required',
            'txt_password.min' => 'Password must be at least 6 characters'
			]);
			
			
			$login_id = addcslashes(trim($request->input('txt_username')),'=;-"');
			$user_pwd = addcslashes(trim($request->input('txt_password')),'=;-"');
			$user_type=$request->input('ddtype');
	
			if($user_type == 1)
			{
				$userData = DB::select("SELECT * FROM `m00_admin_login` WHERE `m00_admin_login`.`m00_username`='".$login_id."' LIMIT 1");
			}
			else
			{
				$userData = DB::select("SELECT * FROM `tr04_login` WHERE `tr04_login`.`m11_user_contactno`='".$login_id."' OR `tr04_login`.`m11_user_email`='".$login_id."' LIMIT 1");
			}

			if(count($userData) >0)
			{
				$login_data = array(
				'login_id'=>$request->input('txt_username'),
				'user_pwd'=>$request->input('txt_password'),
				'login_ip'=>$request->server('REMOTE_ADDR'),
				'user_agent'=>$request->server('HTTP_USER_AGENT'),
				'user_type'=>$request->input('ddtype')
				);
				
				if($user_type == 1){ $userPass = $userData[0]->m00_password; }else{ $userPass = $userData[0]->tr04_login_pwd; }

				if(Hash::check($user_pwd, $userPass))
				{
					$result = $this->enroll_repo->userLogin($login_data);
					$count = count($result);
					$ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
					$ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
				}
				else
				{
					$ERRMSG[0]=["ERR_MSG" => "Please Check Your Login Password "];
					$ERRCODE[0]=["ERR_CODE" => "201"];
					$j = json_encode($ERRMSG);
					$ERRMSG = json_decode($j);
					$count = 0;
				}

			}
			else
			{
				$login_data = array(
				'login_id'=>$request->input('txt_username'),
				'user_pwd'=>$request->input('txt_password'),
				'login_ip'=>$request->server('REMOTE_ADDR'),
				'user_agent'=>$request->server('HTTP_USER_AGENT'),
				'user_type'=>$request->input('ddtype')
				);

				//$count = count($result);
				$count = 0;
				$ERRMSG[0]=["ERR_MSG" => "Please Check Your Login id "];
				$ERRCODE[0]=["ERR_CODE" => "201"];
					$j = json_encode($ERRMSG);
					$ERRMSG = json_decode($j);
			}
			
			
			if($count == 1)
			{
				Session::flash('type','success' );
				Session::flash ( 'message', 'Please check your E-mail account OR Mobile No to verify OTP.');
				Session::put('result',$result);
				//$otp = rand(100000,999999);
				$mob = $result[0]->CONTACTNO;
				$OTP_STATUS=$result[0]->OTP_STATUS;
				$otp = substr($result[0]->CONTACTNO, 4);//$result[0]->OTP_CODE;
				$msg="Please submit this code ".$otp." to verify your account.";
				//dd($login_data, $result , $count, $ERRMSG[0]->ERR_MSG, $ERRCODE);
				if($request->input('ddtype')==1){

						if($OTP_STATUS=="NONE")
						{
								$sessiondata=array(
								'USER_ID'	      =>	$result[0]->USER_ID,
								'EMAIL'  		  =>	$result[0]->EMAIL,
								'NAME'     		  => 	$result[0]->FIRST_NAME.' '.$result[0]->LAST_NAME,
								'USER_CODE' 	  =>	$result[0]->USER_CODE,
								'USER_ROLE' 	  =>	$result[0]->USER_ROLE,
								'USER_ROLE_ID'    =>    $result[0]->USER_ROLE_ID,
								'USER_TYPE'       =>    $result[0]->USER_TYPE,
								'CONTACTNO' 	  =>	$result[0]->CONTACTNO,
								'USER_IMG'        =>	$result[0]->USER_IMG,
								'AFFILIATE_CODE'  =>	$result[0]->AFFILIATE_CODE,
								'IS_LOGIN' 	      => 	$result[0]->IS_LOGIN,
								'GROUP_ID'        =>	$result[0]->USER_GROUPID
							);
							Session::put($sessiondata);
							Session::flash('type','success' );
							Session::flash('message','Success "Login' );
							if(Session::get('USER_ID') == -1) 
							{
								return redirect('/admin_dashboard');
							}
						}
					elseif($OTP_STATUS=="BOTH")
					{
						$template_type = 1;
						$smsdata = array(
							'msg_title' => 'loginotp',
							'name' => $result[0]->FIRST_NAME.' '.$result[0]->LAST_NAME,
							'useremail' => $result[0]->EMAIL,
							'link' => url('/verification'),
							'template_name' => 'otp',
							'code' => $otp
						);
						$msg_config = DB::select('select * from config_msg where MSG_TITLE = "'.$smsdata['msg_title'].'"');
						$smsdata['MSG_CONTENT'] = $msg_config[0]->MSG_CONTENT;
						$smsdata['MSG_SUBJECT'] = $msg_config[0]->MSG_SUB;
						$smsdata['USER_TYPE'] = $result[0]->USER_TYPE;
						$smsdata['USER_ID'] = $result[0]->USER_ID;
						$smsdata['MSG_CONTENT'] = strtr($smsdata['MSG_CONTENT'], array('{name}' => $smsdata['name'],
						'{useremail}'=>$smsdata['useremail'],'{code}'=>$smsdata['code'],'{link}'=>$smsdata['link']));
						$smsdata['pdf'] ='';
						$template_data = $smsdata;
						$msg="Please submit this code ".$otp." to verify your admin account.";
						$data = DB::table('m00_admin_login')->where('m00_login_id','1')->update(['m00_access_token' =>$otp]);
						if($data){
							//Mail::to(config('OTP_MAIL'))->send(new SendMail($template_data, $template_type));
							
						// SMS SEND OR INSERT
						$sms_data['MOBILE_NO'] = config('OTP_MSG');
						$sms_data['SUBJECT'] = 'Admin Login';
						$sms_data['MESSAGE'] = $msg;
						$sms_data['TYPE'] = 5;
						$sms_data['SEND_BY'] = 1;
						$sms_data['SEND_BY_ID'] = -1;
						Helper::send_sms_or_log($sms_data);
						//SMS SEND END 

							return redirect('verification');
							}else{
								Session::flash('type','warning');
								Session::flash ( 'message', 'Please check your E-mail account OR Mobile No to verify OTP.');
								return back();
							}
						}
					elseif($OTP_STATUS=="MAIL")
					{
						$template_type = 1;
						$smsdata = array(
							'msg_title' => 'loginotp',
							'name' => $result[0]->FIRST_NAME.' '.$result[0]->LAST_NAME,
							'useremail' => $result[0]->EMAIL,
							'link' => url('/verification'),
							'template_name' => 'otp',
							'code' => $otp
						);
						$msg_config = DB::select('select * from config_msg where MSG_TITLE = "'.$smsdata['msg_title'].'"');
						$smsdata['MSG_CONTENT'] = $msg_config[0]->MSG_CONTENT;
						$smsdata['MSG_SUBJECT'] = $msg_config[0]->MSG_SUB;
						$smsdata['USER_TYPE'] = $result[0]->USER_TYPE;
						$smsdata['USER_ID'] = $result[0]->USER_ID;
						$smsdata['MSG_CONTENT'] = strtr($smsdata['MSG_CONTENT'], array('{name}' => $smsdata['name'],
						'{useremail}'=>$smsdata['useremail'],'{code}'=>$smsdata['code'],'{link}'=>$smsdata['link']));
						$smsdata['pdf'] ='';
						$template_data = $smsdata;
						$data = DB::table('m00_admin_login')->where('m00_login_id','1')->update(['m00_access_token' =>$otp]);
						if($data)
						{
							//Mail::to(config('OTP_MAIL'))->send(new SendMail($template_data, $template_type));
							return redirect('verification');
						}
						else
						{
								Session::flash('type','warning');
								Session::flash ( 'message', 'Please check your E-mail account OR Mobile No to verify OTP.');
								return back();
						}
				}
				elseif($OTP_STATUS=="SMS")
				{
						$msg="Please submit this code ".$otp." to verify your admin account.";
						$data = DB::table('m00_admin_login')->where('m00_login_id','1')->update(['m00_access_token' =>$otp]);
						if($data)
						{

							// SMS SEND OR INSERT
							$sms_data['MOBILE_NO'] = config('OTP_MSG');
							$sms_data['SUBJECT'] = 'Admin Login';
							$sms_data['MESSAGE'] = $msg;
							$sms_data['TYPE'] = 5;
							$sms_data['SEND_BY'] = 1;
							$sms_data['SEND_BY_ID'] = -1;
							Helper::send_sms_or_log($sms_data);
							//SMS SEND END 

							return redirect('verification');
						}
						else
						{
								Session::flash('type','warning');
								Session::flash ( 'message', 'Please check your E-mail account OR Mobile No to verify OTP.');
								return back();
						}
				}
				else{
						Session::flash('type','warning');
						Session::flash ( 'message', 'Please check your E-mail account OR Mobile No to verify OTP.');
						return back();
					}

				}
				else{
				
						$template_type = 1;
						$smsdata = array(
							'msg_title' => 'email_verify',
							'name' => $result[0]->FIRST_NAME.' '.$result[0]->LAST_NAME,
							'useremail' => $result[0]->EMAIL,
							'link' => url('/verification'),
							'template_name' => 'otp',
							'code' => $otp
						);

						if($userData[0]->tr04_user_email_verify_at == "" && $user_type == "2")
						{
							$msg_config = DB::select('select * from config_msg where MSG_TITLE = "'.$smsdata['msg_title'].'"');
							$smsdata['MSG_CONTENT'] = $msg_config[0]->MSG_CONTENT;
							$smsdata['MSG_SUBJECT'] = $msg_config[0]->MSG_SUB;
							$smsdata['USER_TYPE'] = $result[0]->USER_TYPE;
							$smsdata['USER_ID'] = $result[0]->USER_ID;
							$smsdata['MSG_CONTENT'] = strtr($smsdata['MSG_CONTENT'], array('{name}' => $smsdata['name'],
							'{useremail}'=>$smsdata['useremail'],'{code}'=>$smsdata['code'],'{link}'=>$smsdata['link']));
							$smsdata['pdf'] ='';
							$template_data = $smsdata;
							$data = DB::table('tr04_login')->where('m11_user_id',$result[0]->USER_ID)->update(['tr04_otp' =>$otp]);
							//dd($otp);
							if($data)
							{
								Session::flash ( 'message', 'Please check your E-mail account to verify OTP.');
								//Mail::to($smsdata['useremail'])->send(new SendMail($template_data, $template_type));
								return redirect('verification');
							}
							else
							{
								Session::flash('type','warning');
								Session::flash ( 'message', 'Please check your E-mail account OR Mobile No to verify OTP-1.');
								return back();
							}
						}	

						if($OTP_STATUS=="NONE")
						{

						$sessiondata=array(
								'USER_ID'	      =>	$result[0]->USER_ID,
								'EMAIL'  		  =>	$result[0]->EMAIL,
								'NAME'     		  => 	$result[0]->FIRST_NAME.$result[0]->LAST_NAME,
								'USER_CODE' 	  =>	$result[0]->USER_CODE,
								'USER_ROLE' 	  =>	$result[0]->USER_ROLE,
								'USER_ROLE_ID'    => $result[0]->USER_ROLE_ID,
								'USER_TYPE'    =>   $result[0]->USER_TYPE,
								'CONTACTNO' 	  =>	$result[0]->CONTACTNO,
								'USER_IMG'        =>	$result[0]->USER_IMG,
								'AFFILIATE_CODE'  => $result[0]->AFFILIATE_CODE,
								'IS_LOGIN' 	      => 	$result[0]->IS_LOGIN,
								'GROUP_ID'        =>	$result[0]->USER_GROUPID
							);
							Session::put($sessiondata);
							Session::flash('type','success' );
							Session::flash('message','Success Login' );
							if(Session::get('USER_ID') == -1) 
							{
								return redirect('/admin_dashboard');
							}
							else
							{
								return redirect('/user_dashboard');
							}
						}
						elseif($OTP_STATUS=="BOTH")
						{ 
							$msg_config = DB::select('select * from config_msg where MSG_TITLE = "'.$smsdata['msg_title'].'"');
							$smsdata['MSG_CONTENT'] = $msg_config[0]->MSG_CONTENT;
							$smsdata['MSG_SUBJECT'] = $msg_config[0]->MSG_SUB;
							$smsdata['USER_TYPE'] = $result[0]->USER_TYPE;
							$smsdata['USER_ID'] = $result[0]->USER_ID;
							$smsdata['MSG_CONTENT'] = strtr($smsdata['MSG_CONTENT'], array('{name}' => $smsdata['name'],
							'{useremail}'=>$smsdata['useremail'],'{code}'=>$smsdata['code'],'{link}'=>$smsdata['link']));
							$smsdata['pdf'] ='';
							$template_data = $smsdata;
							$msg="Please submit this code ".$otp." to verify your  account.";
							$data = DB::table('tr04_login')->where('m11_user_id',$result[0]->USER_ID)->update(['tr04_otp' =>$otp]);
							if($data)
							{
								//Mail::to($smsdata['useremail'])->send(new SendMail($template_data, $template_type));
					
								// SMS SEND OR INSERT
								$sms_data['MOBILE_NO'] = $result[0]->CONTACTNO;
								$sms_data['SUBJECT'] = 'USER Login';
								$sms_data['MESSAGE'] = $msg;
								$sms_data['TYPE'] = 5;
								$sms_data['SEND_BY'] = 2;
								$sms_data['SEND_BY_ID'] = $result[0]->USER_ID;
								Helper::send_sms_or_log($sms_data);
								//SMS SEND END 

								return redirect('verification');
							}
							else
							{
								Session::flash('type','warning');
								Session::flash ( 'message', 'Please check your E-mail account OR Mobile No to verify OTP.');
								return back();
							}
						}
						elseif($OTP_STATUS=="MAIL")
						{
							$msg_config = DB::select('select * from config_msg where MSG_TITLE = "'.$smsdata['msg_title'].'"');
							$smsdata['MSG_CONTENT'] = $msg_config[0]->MSG_CONTENT;
							$smsdata['MSG_SUBJECT'] = $msg_config[0]->MSG_SUB;
							$smsdata['USER_TYPE'] = $result[0]->USER_TYPE;
							$smsdata['USER_ID'] = $result[0]->USER_ID;
							$smsdata['MSG_CONTENT'] = strtr($smsdata['MSG_CONTENT'], array('{name}' => $smsdata['name'],
							'{useremail}'=>$smsdata['useremail'],'{code}'=>$smsdata['code'],'{link}'=>$smsdata['link']));
							$smsdata['pdf'] ='';
							$template_data = $smsdata;
							$data = DB::table('tr04_login')->where('m11_user_id',$result[0]->USER_ID)->update(['tr04_otp' =>$otp]);
							if($data)
							{
								//Mail::to($smsdata['useremail'])->send(new SendMail($template_data, $template_type));
								return redirect('verification');
							}
							else
							{
								Session::flash('type','warning');
								Session::flash ( 'message', 'Please check your E-mail account OR Mobile No to verify OTP0.');
								return back();
							}
						}
						elseif($OTP_STATUS=="SMS")
						{
							$msg="Please submit this code ".$otp." to verify your  account.";
							$data = DB::table('tr04_login')->where('m11_user_id',$result[0]->USER_ID)->update(['tr04_otp' =>$otp]);
							if($data)
							{
								// SMS SEND OR INSERT
								$sms_data['MOBILE_NO'] = $result[0]->CONTACTNO;
								$sms_data['SUBJECT'] = 'USER Login';
								$sms_data['MESSAGE'] = $msg;
								$sms_data['TYPE'] = 5;
								$sms_data['SEND_BY'] = 2;
								$sms_data['SEND_BY_ID'] = $result[0]->USER_ID;
								Helper::send_sms_or_log($sms_data);
								//SMS SEND END 

								return redirect('verification');
							}
							else
							{
								Session::flash('type','warning');
								Session::flash ( 'message', 'Please check your E-mail account OR Mobile No to verify OTP1.');
								return back();
							}
						}
						else
						{
							Session::flash('type','warning');
							Session::flash ( 'message', 'Please check your E-mail account OR Mobile No to verify OTP2.');
							return back();
						}
			
				}
			}
			else 
			{
				Session::flash('type','warning' );
                Session::flash ( 'message', $ERRMSG[0]->ERR_MSG);
                if($request->input('ddtype')==1)
                return redirect()->to('/admin_login');
                else
                return redirect()->to('/login');
				
			}
		}
		else 
		{
			Session::flash('type','warning' );
            Session::flash ( 'message', "Invalid Method , Please try again." );
            return redirect()->to('/');
		}
	}

	public function login_verification(request $request)
	{
	 	$otp = $request->input('txt_otp');

	 	$result = session::get('result');
	 	//dd($otp,$result);
	 	if($result[0]->USER_ID == -1){

	 		$userdata =	DB::select("SELECT m00_login_id,m00_username, m00_access_token FROM m00_admin_login where m00_username = '".$result[0]->EMAIL."' LIMIT 1");
	 		if(!empty($userdata)){
	 		$userotp = $userdata[0]->m00_access_token;
	 			 		}else{
	 			return back();
	 			}
	 	}
	 	else{
	 		$userdata =	DB::select("SELECT * FROM tr04_login where m11_user_contactno = '".$result[0]->USER_CODE."' LIMIT 1");

	 		if(!empty($userdata)){
	 			$userotp = $userdata[0]->tr04_otp;
	 		}else{
	 			return back();
	 			}

	 	}
	 	//dd($userotp,$otp);
	 	if($userotp == $otp){

	 				Session::forget('count');
	 			 	$count = count($result);
	 			 	//dd($result);

	 		            if($count == 1)
			            {
			            	if(array_key_exists('tr04_user_email_verify_at', $userdata[0]))
			            	{
			            		if($userdata[0]->tr04_user_email_verify_at == "" && $result[0]->USER_ID != -1)
			            		{
			            			DB::table("tr04_login")->where("m11_user_id", $userdata[0]->m11_user_id)->update(["tr04_user_email_verify_at" => now()]);
			            		}
			            	}
			            	
		                    foreach($result as $row)
		                    {
		                        break;
		                    }

							$sessiondata=array(
								'USER_ID'	      =>	$row->USER_ID,
								'EMAIL'  		  =>	$row->EMAIL,
								'NAME'     		  => 	$row->FIRST_NAME.$row->LAST_NAME,
								'USER_CODE' 	  =>	$row->USER_CODE,
								'USER_ROLE' 	  =>	$row->USER_ROLE,
								'USER_ROLE_ID'    =>    $row->USER_ROLE_ID,
								'USER_TYPE'    =>    $row->USER_TYPE,
								'CONTACTNO' 	  =>	$row->CONTACTNO,
								'USER_IMG'        =>	$row->USER_IMG,
								'AFFILIATE_CODE'  =>	$row->AFFILIATE_CODE,
								'IS_LOGIN' 	      => 	$row->IS_LOGIN,
								'GROUP_ID'        =>	$row->USER_GROUPID
							);


							Session::put($sessiondata);
							Session::flash('type','success' );
							Session::flash('message','Success "Login' );
							 //dd($ERRMSG[0]->ERR_MSG);
							if(Session::get('USER_ID') == -1) 
							{
								return redirect('/admin_dashboard');
							}
							else
							{
								return redirect('/user_dashboard');
							}

		            }
		            else 
		            {
						Session::flash('type','warning' );
		                Session::flash ( 'message', 'Invalid Method , Please try again.');
		                if($result[0]->USER_ID == -1)
		                return redirect()->to('/admin_login');
		                else
		                return redirect()->to('/login');
		            }

	 	}else{
	 			if(Session::get('count')  != null){ $counts = Session::get('count'); }else{ $counts = 1; }

	 		if(Session::get('count') < 4)
	 		{
	 			$counts++;
		 		Session::put('count',$counts);
				Session::flash('type','warning' );
				Session::flash ( 'message', 'YOUR ARE NOT MEMMBER OF OUR PANEL');
				return back();
			}
			else
			{	
				Session::forget('count');
				Session::flash('type','warning' );
                Session::flash ( 'message', 'Invalid Method , Please try again.');
                if($result[0]->USER_ID == -1)
                return redirect()->to('/admin_login');
                else
                return redirect()->to('/login');
			}

	 	}
	}




	/**
        * Method name   : Registration
        * @description  : Used for registration
        * @param        : Request data 
        * @return       : return with user registration
    */
	public function registration($memberID, $pos='',$bnb_address='')
	{
		//$memberID = Crypt::decrypt($memberID);
		$memberid = Helper::get_userid($memberID);

		if($pos != 'DIRECT' && $pos != 'RIGHT'){ return 'Refferal link not found.';}

		if($memberid == false)
		{
			return 'Refferal link not found';
		}

		$emailaddress = 'User'.rand(000000,999999).'@sbitico.com';

		$user = Helper::get_userdetail($memberid);
		$state = $this->location_repo->getAllStates();
		$SPONSOR = $user[0]->RegCode;
		$name = $user[0]->MemberName;
		$package = $this->package_repo->getAllPackage();
		$banks = $this->bank_repo->getAll();
		$data['country'] = $this->location_repo->getAllCountries();
		//$service = DB::select("SELECT * FROM `admin_service_charges` WHERE USER_ROLE_ID = 7 AND STATUS = 'ACTIVE'");
		$service =[];
		return view('Auth.register', compact('state','user','package','banks','data','service','SPONSOR','name','pos','bnb_address','emailaddress'));
	}


	/**
        * Method name   : Registration
        * @description  : Used for registration
        * @param        : Request data 
        * @return       : return with user registration
    */
	public function registrations()
	{
		// $ref = DB::table("enroll")->first();
		$SPONSOR=''; 
		$name =""; 
		// if($ref) {
		// 	$SPONSOR = $ref->RegCode; 
		// 	$name = $ref->MemberName; 
		// }

		if(old('txt_referralcode')) {
			$SPONSOR=old('txt_referralcode'); 
		}

		if(old('txt_referralname')) {
			$name=old('txt_referralname'); 
		}
	    
	    $bnb_address =""; 
	    $emailaddress =""; 

		$package = $this->package_repo->getAllPackage();
		$banks = $this->bank_repo->getAll();
		$data['country'] = $this->location_repo->getAllCountries();
		//$service = DB::select("SELECT * FROM `admin_service_charges` WHERE USER_ROLE_ID = 7 AND STATUS = 'ACTIVE'");
		$service =[];
		return view('Auth.register', compact('package','banks','data','service','SPONSOR','name','bnb_address','emailaddress'));
	}




	public function registrations_verify(Request $request)
	{
		$user_data = json_decode(Session::get('user_reg_data'));
	
		// $ref = DB::table("enroll")->first();
		$SPONSOR=''; 
		$name =""; 

		if(old('txt_referralcode')) {
			$SPONSOR=old('txt_referralcode'); 
		}

		if(old('txt_referralname')) {
			$name=old('txt_referralname'); 
		}
	    
	    $bnb_address =""; 
	    $emailaddress =""; 

		$package = $this->package_repo->getAllPackage();
		$banks = $this->bank_repo->getAll();
		$data['country'] = $this->location_repo->getAllCountries();
		//$service = DB::select("SELECT * FROM `admin_service_charges` WHERE USER_ROLE_ID = 7 AND STATUS = 'ACTIVE'");
		$service =[];
		return view('Auth.register-verification', compact('user_data','package','banks','data','service','SPONSOR','name','bnb_address','emailaddress'));
	}

    /**
        * Method name   : Registration Retailor
        * @description  : Used for registration
        * @param        : Request data 
        * @return       : return with user registration
    */
	public function registration_retail($memberID)
	{
		$memberID = Crypt::decrypt($memberID);
		$memberid = Helper::get_userid($memberID);
		if($memberid == false)
		{
			return 'Refferal link not found';
		}
		$user = Helper::get_userdetail($memberid);
		$state = $this->location_repo->getAllStates();
		$SPONSOR = $user[0]->RegCode;
		$name = $user[0]->MemberName;
		$package = $this->package_repo->getAllPackage();
		$banks = $this->bank_repo->getAll();
		$data['country'] = $this->location_repo->getAllCountries();
		//$service = DB::select("SELECT * FROM `admin_service_charges` WHERE USER_ROLE_ID = 7 AND STATUS = 'ACTIVE'");
		$service =[];
		return view('Auth.register_retailor', compact('state','user','package','banks','data','service','SPONSOR','name'));
	}


	public function add_user_verification(Request $request)
	{
		$this->validate($request, [
            'txt_mobileno'=> 'required|numeric|digits:10|regex:/^[5-9]\d{9}$/',//|unique:enroll,MemberContactNo
            'txt_email'=> 'required|email',//|unique:enroll,MemberEmail
			'txt_password' => 'required|string|min:6|required_with:txt_password_confirmation|same:txt_password_confirmation',
			'dd_country' => 'required',
			'dd_state' => 'required',
			'dd_city' => 'required',
			'txt_username' => 'required',
			'txt_referralcode' => 'nullable|exists:enroll,RegCode',
        ],[
            'txt_mobileno.required'=> 'Mobile Number is required',
            'txt_mobileno.numeric'=> 'Enter is valid Mobile Number',
			'txt_mobileno.unique'=> 'Mobile Number already registered',
            'txt_mobileno.digits'=> 'Enter is valid Mobile Number',
			'txt_mobileno.regex'=> 'Enter is valid Mobile Number',
			'txt_email.unique'=> 'E-mail ID already registered',
            'txt_email.required'=> 'E-mail ID is required',
            'txt_email.email'=> 'Enter Valid E-mail ID',
			'dd_country.required'=> 'Country is required',
			'dd_state.required'=> 'State is required',
			'dd_city.required'=> 'City is required',
			//'txt_referralcode.required'=> 'Referral code is required',
			'txt_referralcode.exists'=> 'Referral code Not Valid',
			'txt_password.required'=> 'Password is required',
        ]);


        $ref = DB::table("enroll")->first();
        $old_referralcode = $request->txt_referralcode;
		if($request->txt_referralcode == '' && $ref) {
			$request->merge(["txt_referralcode"=> $ref->RegCode, "txt_referralname"=> $ref->MemberName]);
		}


				// $otp =123456;
				// $otp = substr($request->txt_mobileno, 4);
				$otp = rand(100000,999999);
				$template_type = 1;
				$smsdata = array(
					'msg_title' => 'email_verify',
					'name' => $request->txt_username,
					'useremail' => $request->txt_email,
					'link' => url('/verification'),
					'template_name' => 'otp',
					'code' => $otp
				);

						
				$msg_config = DB::select('select * from config_msg where MSG_TITLE = "'.$smsdata['msg_title'].'"');
				$smsdata['MSG_CONTENT'] = $msg_config[0]->MSG_CONTENT;
				$smsdata['MSG_SUBJECT'] = $msg_config[0]->MSG_SUB;
				$smsdata['USER_TYPE'] = 'USER';
				$smsdata['USER_ID'] = 0;
				$smsdata['MSG_CONTENT'] = strtr($smsdata['MSG_CONTENT'], array('{name}' => $smsdata['name'],
				'{useremail}'=>$smsdata['useremail'],'{code}'=>$smsdata['code'],'{link}'=>$smsdata['link']));
				$smsdata['pdf'] ='';
				$template_data = $smsdata;

				try {
					Mail::to($smsdata['useremail'])->send(new SendMail($template_data, $template_type));
				} catch (Exception $e) {
					
				}
				
				Session::put('user_reg_data', json_encode($request->all()));
 				Session::put('user_login_otp', $otp);
				Session::flash( 'message', 'OTP sent successfully to '.$request->txt_email);
				Session::flash( 'type', 'success');
				return redirect('register-verify')->withInput();
						
	}


	/**
        * Method name   : Registration
        * @description  : Used for registration
        * @param        : Request data 
        * @return       : return with user registration
    */
	public function add_user(Request $request)
	{
		//dd( session()->get('user_login_otp'));

		$this->validate($request, [
            'txt_mobileno'=> 'required|numeric|digits:10|regex:/^[5-9]\d{9}$/',//|unique:enroll,MemberContactNo
            'txt_email'=> 'required|email', //|unique:enroll,MemberEmail
			'txt_password' => 'required|string|min:6|required_with:txt_password_confirmation|same:txt_password_confirmation',
			'dd_country' => 'required',
			'dd_state' => 'required',
			'dd_city' => 'required',
			'txt_username' => 'required',
			'txt_referralcode' => 'nullable|exists:enroll,RegCode',
			'txt_otp' => 'required',
        ],[
            'txt_mobileno.required'=> 'Mobile Number is required',
            'txt_mobileno.numeric'=> 'Enter is valid Mobile Number',
			'txt_mobileno.unique'=> 'Mobile Number already registered',
            'txt_mobileno.digits'=> 'Enter is valid Mobile Number',
			'txt_mobileno.regex'=> 'Enter is valid Mobile Number',
			'txt_email.unique'=> 'E-mail ID already registered',
            'txt_email.required'=> 'E-mail ID is required',
            'txt_email.email'=> 'Enter Valid E-mail ID',
			'dd_country.required'=> 'Country is required',
			'dd_state.required'=> 'State is required',
			'dd_city.required'=> 'City is required',
			//'txt_referralcode.required'=> 'Referral code is required',
			'txt_referralcode.exists'=> 'Referral code Not Valid',
			'txt_password.required'=> 'Password is required',
			'txt_otp.required'=> 'OTP is required',
        ]);



		if($request->txt_otp != session()->get('user_login_otp'))
		{
			$num = 1;

			if(session()->has('user_login_otp_count')){  

				$num = (int)session()->get('user_login_otp_count');
				++$num;
				if($num > 4)
				{
					Session::forget('user_reg_data');
					Session::forget('user_login_otp');
					Session::forget('user_login_otp_count');

					Session::flash( 'message', 'You’ve reached the maximum verify attempts');
					Session::flash( 'type', 'danger');
					return redirect('register');
				}
				
				Session::put('user_login_otp_count', $num);

			} else {
				Session::put('user_login_otp_count', 1);
			}

			Session::flash('message', 'INCORRECT OTP. You Have '.(5-($num)).' attempts remaining');
			Session::flash('type', 'danger');
			return back()->withInput();
		}

      

	        $ref = DB::table("enroll")->first();
	        $old_referralcode = $request->txt_referralcode;
			if($request->txt_referralcode == '' && $ref) {
				$request->merge(["txt_referralcode"=> $ref->RegCode, "txt_referralname"=> $ref->MemberName]);
			}


		if($request->method() == 'POST')
		{
			$txt_cancelchq ="";
			$txt_gstcrt ="";
		 	if($request->input('txt_password')=='')
            {
                $pass=rand(100000,999999);
                $pinpass=rand(100000,999999);
			}
            else
            {
                $pass=$request->input('txt_password');
                $pinpass=$request->input('txt_password');
			}  
 
			if($request->input('txt_bscaddress')=='')
            {
               $ERRMSG = "BSC Address should be valid";
                $this->isError= TRUE;
                $ERRCODE="warning";
			}
            else if($request->input('txt_referralcode')=="")
            {
                $ERRMSG = "Member Code should be valid";
                $this->isError= TRUE;
                $ERRCODE="warning";
			}
			else if($request->input('dd_wallet')=="" || $request->input('dd_wallet')=="-1")
            {
                $ERRMSG = "Wallet Type should be valid";
                $this->isError= TRUE;
                $ERRCODE="warning";
			}
			$contactno=explode(' ',$request->input('txt_referralcode'));
			$user = Helper::get_userid($contactno[0]);
			if(empty($user))
			{
				$ERRMSG = "Member should be valid";
				$isError = TRUE;
				$ERRCODE="warning";
			}
			else
			{
				$ERRMSG = "";
                $this->isError= FALSE;
                $ERRCODE="success";
			}
			if(request()->method() == 'POST' && $this->isError==FALSE)
			{
				$txt_gstcrt=$request->input('txt_bscaddress');
				$signup_data=Helper::reg_data($request,$pass,$pinpass,'','','',$txt_gstcrt,$txt_cancelchq);  

				$response= $this->enroll_repo->create($signup_data); 

				if($response['err_code']=="success")
				{
	                
						$userData = DB::select("SELECT m11_user_referral_code AS referral_id, m11_user_id AS user_id  FROM `m11_user` WHERE `m11_user_id` = ".$response['ID']."");

						if(count($userData) > 0)
						{	
							$rf_amount = 0.00;
						}
	                

					$template_type = 1;
					$data = array(
						'msg_title' => 'account_creation',
						'name' => $request->input('txt_username'),
						'useremail' => $request->input('txt_email'),
						'usercode' => $response['CODE'],
						'password' => $pass,
						'link' => url('/home'),
						'trans_id' => url('/home'),
						'template_name' => 'registration'
					);

					$msg_config = DB::select('select * from m09_message_config where m09_msg_title = "'.$data['msg_title'].'"');
					$data['MSG_CONTENT'] = $msg_config[0]->m09_msg_content;
					$data['MSG_SUBJECT'] = $msg_config[0]->m09_msg_subject;
					$data['USER_TYPE'] = '1';
					if(session()->get('USER_ID') == ''){ $data['USER_ID'] = $response['ID']; }else{ $data['USER_ID'] = session()->get('USER_ID'); }

					$data['MSG_CONTENT'] = strtr($data['MSG_CONTENT'], array('{name}' => $data['name'],
					'{useremail}'=>$data['useremail'],'{password}'=>$data['password'],'{link}'=>$data['link'],'{trans_id}'=>$data['trans_id']));
					$data['pdf'] ='';
					$template_data = $data;
					try {
						Mail::to($request->input('txt_email'))->send(new SendMail($template_data, $template_type));
					} catch (Exception $e) {
						
					}
					$msg="Welcome to ".config('SITE_NAME')." Please click on ".config('WEBSITE_NAME')." to activate your account User id :".$response['CODE']." Password : ".$pass.".";
					//$msg= $response['err_msg'];
						// SMS SEND OR INSERT
						$sms_data['MOBILE_NO'] = $request->input('txt_mobileno');
						$sms_data['SUBJECT'] = 'User REGISTRATION';
						$sms_data['MESSAGE'] = $msg;
						$sms_data['TYPE'] = 1;
						$sms_data['SEND_BY'] = 2;
						$sms_data['SEND_BY_ID'] = $data['USER_ID'];
						// Helper::send_sms_or_log($sms_data);	
					
						//SMS SEND END 
			
					$signup_data1=Helper::notify_data($request,1,"NEW USER INSERT SUCCESSFULLY",$response['err_msg'],$data['USER_ID'],'2');
					Session::flash( 'message', $msg);
					Session::flash( 'type', $response['err_code'] );
				}
				else
				{
					Session::flash( 'message', $response['err_msg'] );
					Session::flash( 'type', $response['err_code'] );
				}
			}
			}
				//$user = Helper::get_userdetail(Session::get('USER_ID'));
				return redirect('register'); 
	}



	/**
			* Method name	: Signup
			* @description 	: Used to Signup 
			* @param		: Request data  
			* @return		: Get Signup data array with response message
		*/
    public function signup()
	{
		$request = request();
		if($request->method() == 'POST')
		{
			
            $this->validate($request, [
			'txt_referralcode'=> 'required',
			'position'=> 'required',
			'txt_username'=> 'required',
			'txt_email'=> 'required|email',
			'txt_mobileno'=> 'required',
			'txt_password'=> 'required|min:3'
            ],
            [
			'txt_referralcode.required' => 'Referral code is required!',
			'position.required' => 'Position is required!',
			'txt_username.required' => 'Username is required!',
			'txt_email.required' => 'Email is required!',
			'txt_mobileno.required' => 'Mobile No. is required!',
			'txt_password.min' => 'Password must be at least 6 characters!'
            ]);
			
            $txt_cancelchq="";
            $txt_gstcrt ="";
            if($request->input('txt_password')=='')
            {
                $pass=rand(100000,999999);
                $pinpass=rand(100000,999999);
			}
            else
            {
                $pass=$request->input('txt_password');
                $pinpass=$request->input('txt_password');
			}   
            $signup_data=Helper::reg_data($request,$pass,$pinpass,'','','',$txt_gstcrt,$txt_cancelchq); 
            $response= $this->enroll_repo->create($signup_data); 

			if($response['err_code']=="success")
			{
                $this->send_sms($request->input('txt_mobileno'),$ERRMSG[0]->ERR_MSG);
				$template_type = 1;
				$data = array(
					'msg_title' => 'account_creation',
					'name' => $request->input('txt_username'),
					'useremail' => $request->input('txt_email'),
					'password' => $request->input('txt_password'),
					'link' => url('/home'),
					'trans_id' => url('/home'),
					'template_name' => 'registration'
				);

				$msg_config = DB::select('select * from m09_message_config where m09_msg_title = "'.$data['msg_title'].'"');
				$data['msg_content'] = $msg_config[0]->m09_msg_content;
				$data['msg_subject'] = $msg_config[0]->m09_msg_subject;
				$data['msg_content'] = strtr($data['msg_content'], array('{name}' => $data['name'],
				'{useremail}'=>$data['useremail'],'{password}'=>$data['password'],'{link}'=>$data['link'],'{trans_id}'=>$data['trans_id']));
				$data['pdf'] ='';
				$template_data = $data;
				try {
					Mail::to($data['useremail'])->send(new SendMail($template_data, $template_type));
				} catch (Exception $e) {
					
				}
			}
			Session::flash( 'message', $response['err_msg'] );
			Session::flash( 'type', $response['err_code'] );
			return redirect('/login');  
		}
	}

	/**
			* Method name	: Logout
			* @description 	: Used to Logout 
			* @param		: Session data  
			* @return		: Get back to login form
		*/
	public function logout()
	{
		$type=Session::get('USER_ROLE');
		auth()->logout();
		Session::forget('USER_ID');
		Session::forget('EMAIL');
		Session::forget('NAME');
		Session::forget('USER_ROLE');
		Session::forget('CONTACTNO');
		Session::forget('USER_IMG');
		Session::forget('IS_LOGIN');
		Session::forget('USER_CODE');
		Session::forget('USER_CODE');

		if($type == 'SUPER ADMIN')
		return redirect()->to('/admin_login');
		else if($type == 'BACK_ADMIN' || $type == 'SALES' || $type == 'SUPPORT'  || $type == 'ACCOUNT'  || $type == 'TECHNICAL'  || $type == 'EMPLOYEE'  || $type == 'BACKOFFICE')
		return redirect()->to('/employee_login');
		else
		return redirect()->to('https://etglive.com');
	}
		
	/**
			* Method name	: Validate Phone Number
			* @description 	: Used to Validate Phone Number 
			* @param		: Phone number  
			* @return		: return true if valid phone number
		*/
	public function valid_phone_number($str)
	{
		$regex = "/^[0-9]+$/";
		if(preg_match($regex,$str))
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}

	/**
			* Method name	: Forget Password
			* @description 	: Used for Forget Password 
			* @param		: Request data  
			* @return		: return to verify otp with response message
		*/
	public function forget_password()
	{
		Session::flash('type','info' );
		Session::flash('message','FORGET PASSWORD HERE!');
		$request = request();
		if(request()->method() == 'POST')
		{
			if(trim($request->input('txt_username')) == '')
			{
				$ERRMSG = "Mobile no should be valid.";
				$this->isError= TRUE;
				$ERRCODE="error";
				$userData ='';
			}
			else
			{
				$userid = addcslashes(trim($request->input('txt_username')),'=.;-"');


				$login_detail = DB::select("SELECT * FROM `tr04_login` WHERE `tr04_login`.`m11_user_contactno`='".$userid."' OR `tr04_login`.`m11_user_email`='".$userid."' LIMIT 1");
				$user = Helper::get_userdetail($login_detail[0]->m11_user_id);

				if(count($login_detail) > 0 && count($user) > 0)
				{
					$ERRMSG = "USER DETAILS GET SUCCESSFULLY";
					$ERRCODE="success";
					$this->isError= FALSE;
				}
				else
				{
					$ERRMSG = "USER DETAILS NOT FIND.";
					$ERRCODE="error";
					$this->isError= TRUE;
				}
			}
			if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
			{

				$message=rand(10000,999999);
				$msg="Please submit this code ".$message." to verify your account.";
				$user_logindetails=DB::update("UPDATE `tr04_login` SET `tr04_otp` =".$message." WHERE `m11_user_id`='".$login_detail[0]->m11_user_id."'");
				if($user_logindetails==1)
				{
			
								// SMS SEND OR INSERT
								$sms_data['MOBILE_NO'] = $user[0]->MemberContactNo;
								$sms_data['SUBJECT'] = 'User Forget Password';
								$sms_data['MESSAGE'] = $msg;
								$sms_data['TYPE'] = 2;
								$sms_data['SEND_BY'] = 2;
								$sms_data['SEND_BY_ID'] = $user[0]->RegId;
								//Helper::send_sms_or_log($sms_data);
								//SMS SEND END 

					$template_type = 1;
					$data = array(
						'msg_title' => 'forgot_password',
						'name' => $user[0]->MemberName,
						'useremail' => $user[0]->MemberEmail,
						'password' => $user[0]->MemberEmail,
						'link' => url('/verify_otp'),
						'trans_id' => url('/verify_otp'),
						'template_name' => 'otp'
					);


					$msg_config = DB::select('select * from m09_message_config where m09_msg_title = "'.$data['msg_title'].'"');
					$data['MSG_CONTENT'] = $msg_config[0]->m09_msg_content;
					$data['MSG_SUBJECT'] = $msg_config[0]->m09_msg_subject;
					$data['USER_TYPE'] = '1';
					$data['code'] = $message;
					$data['USER_ID'] = $user[0]->RegId;
					$data['MSG_CONTENT'] = strtr($data['MSG_CONTENT'], array('{name}' => $data['name'],
					'{useremail}'=>$data['useremail'],'{password}'=>$data['password'],'{link}'=>$data['link'],'{trans_id}'=>$data['trans_id']));
					$data['pdf'] ='';
					$template_data = $data;

					//Mail::to($data['useremail'])->send(new SendMail($template_data, $template_type));

					$ERRMSG = "Please check your E-mail account OR Member ID to verify OTP.";
					$ERRCODE = "success";
					Session::flash('message',$ERRMSG);
					Session::flash('type',$ERRCODE);
					Session::flash('mobileno',$user[0]->RegCode);
					return view('Auth.verify_otp');
				}
				else
				{
					$ERRMSG = "USER DETAILS NOT FIND.";
					$ERRCODE="error";
					Session::flash('message',$ERRMSG);
					Session::flash('type',$ERRCODE);
					return redirect('forget_password');
				}
			}
			else
			{
				Session::flash('message',$ERRMSG);
				Session::flash('type',$ERRCODE);
				return redirect('forget_password');
			}
		}
		else 
		{   
			
			Session::flash('type',$ERRCODE);
			Session::flash ('message', "Invalid Method , Please try again." );
			return redirect('forget_password');
		}
	}

	/**
			* Method name	: Verify OTP
			* @description 	: Used for verifying otp 
			* @param		: Request data  
			* @return		: return to login from if otp validated
		*/
	public function verify_otp()
    {
        Session::flash('type','info' );
        Session::flash('message','FORGET PASSWORD HERE!');
        $request = request();
        if(request()->method() == 'POST')
        {
            if(trim($request->input('txt_username')) == '')
            {
                $ERRMSG = "Mobile no should be valid.";
                $this->isError= TRUE;
                $ERRCODE="error";
                $userData ='';
			}
            else if($request->input('txt_otp')=='')
            {
                $ERRMSG = "OTP should be valid.";
                $this->isError= TRUE;
                $ERRCODE="error";
			}
            else
            {
                $login_detail = $this->enroll_repo->getActiveUserByRegCode($request->input('txt_username'));

                if($login_detail)
                {
                    $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                    $ERRCODE="success";
                    $this->isError= FALSE;
				}
                else
                {
                    $ERRMSG = "USER DETAILS NOT FIND.";
                    $ERRCODE="error";
                    $this->isError= TRUE;
				}
                
			}

            if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
            {
                $otp_detail = DB::select("SELECT `tr04_otp` as Token FROM `tr04_login` WHERE `m11_user_contactno` ='".$request->input('txt_username')."'");
                
                if(count($otp_detail) > 0)
                {
                    if($request->input('txt_otp')==$otp_detail[0]->Token)
                    {
                        $message=rand(100000,999999);
                        $msg="Your account password has been reset successfully. Please login to your account with Member Id :".$request->input('txt_username')." Password : ".$message ." .";
                        $user_logindetails=DB::update("UPDATE `tr04_login` SET `tr04_login_pwd` ='".Hash::make($message)."' WHERE `m11_user_contactno`='".$request->input('txt_username')."'");

                        if($user_logindetails==1)
                        {
								// SMS SEND OR INSERT
								$sms_data['MOBILE_NO'] = $login_detail[0]->MemberContactNo;
								$sms_data['SUBJECT'] = 'User Forget Password';
								$sms_data['MESSAGE'] = $msg;
								$sms_data['TYPE'] = 2;
								$sms_data['SEND_BY'] = 2;
								$sms_data['SEND_BY_ID'] = $login_detail[0]->RegId;
								//Helper::send_sms_or_log($sms_data);
								//SMS SEND END 


							$template_type = 1;
							$data = array(
								'msg_title' => 'PASSWORD_FORGET_MSG',
								'name' => $login_detail[0]->MemberName,
								'useremail' => $login_detail[0]->MemberEmail,
								'password' => $login_detail[0]->MemberEmail,
								'link' =>  url('/verify_otp'),
								'trans_id' =>  url('/verify_otp'),
								'template_name' => 'password_changed',
								'new_pass' => $message
							);

							$msg_config = DB::select('select * from m09_message_config where m09_msg_title = "'.$data['msg_title'].'"');
							$data['MSG_CONTENT'] = $msg_config[0]->m09_msg_content;
							$data['MSG_SUBJECT'] = $msg_config[0]->m09_msg_subject;
							$data['USER_TYPE'] = '1';
							$data['USER_ID'] = $login_detail[0]->RegId;
							$data['MSG_CONTENT'] = strtr($data['MSG_CONTENT'], array('{name}' => $data['name'],
							'{useremail}'=>$data['useremail'],'{password}'=>$data['password'],'{link}'=>$data['link'],'{trans_id}'=>$data['trans_id']));
							$data['pdf'] ='';
							$template_data = $data;

							//Mail::to($data['useremail'])->send(new SendMail($template_data, $template_type));


                            $ERRMSG = "Password Reset Successfully .Please login you account..";
                            $ERRCODE = "success";
                            Session::flash('message',$ERRMSG);
                            Session::flash('type',$ERRCODE);
                            return redirect('login');
						}
                        else
                        {
                            $ERRMSG = "USER DETAILS NOT FIND.";
                            $ERRCODE="error";
                            Session::flash('message',$ERRMSG);
                            Session::flash('type',$ERRCODE);
                            return redirect('forget_password');
						}
					}
                    else
                    {
                        $ERRMSG = "OTP NOT VALID.";
                        $ERRCODE="error";
                        $this->isError= TRUE;
                        Session::flash('message',$ERRMSG);
                        Session::flash('type',$ERRCODE);
                        Session::flash('mobileno',$request->input('txt_username'));
                        return view('Auth.verify_otp');
					}
				}
                else
                {
					$ERRMSG = "OTP HAS NOT BEEN GENERATES FOR THIS USER.PLEASE TRY AGAIN";
					$ERRCODE="error";
					$this->isError= TRUE;
					Session::flash('message',$ERRMSG);
					Session::flash('type',$ERRCODE);
					return redirect('forget_password');
				}
                
			}
            else
            {
                Session::flash('message',$ERRMSG);
                Session::flash('type',$ERRCODE);
                return redirect('forget_password');
			}
		}
        else 
        {   
            Session::flash('type',$ERRCODE);
            Session::flash('message', "Invalid Method , Please try again." );
            return redirect('forget_password');
		}
	}
        
    /**
			* Method name	: Send Sms
			* @description 	: Used for sending sms 
			* @param		: Phone number and sending message 
			* @return		: return message to user
		*/    
	public function send_sms($mob,$msg)
	{
		$url = Config('SMS_SEND_URL');
		$params = array(
        'user'=>Config('SMS_AUTH'),
        'password'=>Config('SMS_PWD'),
        'senderid'=>Config('SMS_SENDERID'),    
        'channel'=>Config('SMS_CHANNEL'),             
        'DCS'=>0,
		'flashsms'=>0,
        'number'=>$mob,
        'text'=>$msg,     
		'route'=>Config('SMS_ROUTE')
		);

		echo Helper::_curl_execute('GET',$url,$params);
	}
		
	/**
			* Method name	: Sms Test
			* @description 	: Used for sms test 
			* @param		: Phone number and sending message 
			* @return		: return message to user
		*/  		
	public function sms_test()
	{
 $msg="Please submit this code 9919111099 to verify your device. Mzalert";
											$sms_data['MOBILE_NO'] ='9919111099';
											$sms_data['SUBJECT'] = 'User App Login';
											$sms_data['MESSAGE'] = $msg;
											$sms_data['TYPE'] = 4;
											$sms_data['SEND_BY'] = 2;
											$sms_data['SEND_BY_ID'] =110;
											echo Helper::send_sms_or_log($sms_data);
		$this->send_sms('9919111099','Please submit this code 123456 to verify your device. Mzalert');
	}

	/**
		* Method name	: Logout
		* @description 	: Used to Logout 
		* @param		: Session data  
		* @return		: Get back to login form
	*/
	public function view_error_page()
	{
		auth()->logout();
		Session::forget('USER_ID');
		Session::forget('EMAIL');
		Session::forget('NAME');
		Session::forget('USER_ROLE');
		Session::forget('CONTACTNO');
		Session::forget('USER_IMG');
		Session::forget('IS_LOGIN');
		Session::forget('USER_CODE');
		Session::forget('USER_CODE');

		return view('error-page');
	}



	public function check_mobile_id(request $request)
	{
	    $user = DB::select("SELECT `m11_user_contactno` FROM `m11_user` WHERE `m11_user_contactno` = ".$request->mobileno." LIMIT 1");
	  
	    if (count($user) > 0) {
	        return 'This Mobile No. already taken';
	    } else {
	        return 'success';
	    }
	}

	public function check_email_id(request $request)
	{
	    $user = DB::select("SELECT `m11_user_email` FROM `m11_user` WHERE `m11_user_email` = '".$request->email."' LIMIT 1");
	  
	    if (count($user) > 0) {
	        return 'This Email Id already taken';
	    } else {
	        return 'success';
	    }
	}


}