<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\Api\ApiRepository;
use DB;
use Image;
use Session;
use Helper;


class ApiController extends Controller
{
	private $api_repo;

	public function __construct(ApiRepository $api_repo)
	{
		$this->api_repo = $api_repo;
	}

	/**
        * Method name   : Add Api
        * @description  : Used for adding api
        * @param        : Request data 
        * @return       : return view for adding api
    */
	public function add_api()
	{
		$api = $this->api_repo->getAll();
		return view('Api.add_api', compact('api'));
	}

	/**
        * Method name   : Create Api
        * @description  : Used for adding api
        * @param        : Request data 
        * @return       : return with adding api
    */
	public function create_api()
	{

		$request = request();

        // $this->validate($request, [
        //     'rb_api_method'=> 'required',
        //     'rb_api_type' => 'required',
        //     'rb_data_send' => 'required',
        //     'txt_api_name' => 'required',
        //     'txt_trans_url'=> 'required',
        //     'txt_trans_param' => 'required',
        //     'txt_bal_url' => 'required',
        //     'txt_bal_param' => 'required',
        //     'txt_status_url'=> 'required',
        //     'txt_status_param' => 'required',
        //     'txt_allow_qty' => 'required',
        //     'txt_allow_hlr' => 'required',
        //     'dd_status' => 'required',
        //     'dd_response' => 'required',
        //     'dd_type'=> 'required',
        //     'txt_status_name' => 'required',
        //     'txt_res_opr_idname' => 'required',
        //     'txt_success_st' => 'required',
        //     'txt_pending_st' => 'required',
        //     'txt_failed_st' => 'required',
        //     'txt_res_api_idname' => 'required'
        // ],[
        //     'rb_api_method.required'=> 'Service name is required',
        //     'rb_api_type.required' => 'Service description is required',
        //     'rb_data_send.required'=> 'Service surcharge is required',
        //     'txt_api_name.required' => 'Status is required', 
        //     'txt_trans_url.required'=> 'Service name is required',
        //     'txt_trans_param.required' => 'Service description is required',
        //     'txt_bal_url.required'=> 'Service surcharge is required',
        //     'txt_bal_param.required' => 'Status is required',     
        //     'txt_status_url.required'=> 'Service name is required',
        //     'txt_status_param.required' => 'Service description is required',
        //     'txt_allow_qty.required'=> 'Service surcharge is required',
        //     'txt_allow_hlr.required' => 'Status is required',
        //     'dd_status.required' => 'Status is required',     
        //     'dd_response.required'=> 'Service name is required',
        //     'dd_type.required' => 'Service description is required',
        //     'txt_status_name.required'=> 'Service surcharge is required',
        //     'txt_res_opr_idname.required' => 'Status is required',
        //     'txt_success_st.required' => 'Status is required',
        //     'txt_pending_st.required' => 'Status is required',     
        //     'txt_failed_st.required'=> 'Service name is required',
        //     'txt_res_api_idname.required' => 'Service description is required'
        // ]);

		$arr = array(
			'proc'=>1,
			'api_method_type' => $request->input('rb_api_method'),
			'api_for' => $request->input('rb_api_type'),
			'api_datasend_via' => $request->input('rb_data_send'),
			'api_name' => $request->input('txt_api_name'),
			'api_for_transaction' => $request->input('txt_trans_url'),
			'transaction_parameter' => $request->input('txt_bal_param'),
			'api_for_status' => $request->input('txt_status_url'),
			'status_parameter' => $request->input('txt_status_param'),
			'api_for_bal' => $request->input('txt_bal_url'),
			'bal_parameter' => $request->input('txt_bal_param'),
			'api_allow_qty' => $request->input('txt_allow_qty'),
			'api_hlr' => $request->input('txt_allow_hlr'),
			'api_status' => $request->input('dd_status'),
			'resp_occur' => $request->input('dd_response'),
			'resp_type' => $request->input('dd_type'),
			'respfor_status' => $request->input('txt_status_name'),
			'valueof_success' => $request->input('txt_success_st'),
			'valueof_pending' => $request->input('txt_pending_st'),
			'valueof_failed' => $request->input('txt_failed_st'),
			'respfor_liveid' => $request->input('txt_res_opr_idname'),
			'respfor_apitxnid' => $request->input('txt_res_api_idname'),
			'apiresp_status' => $request->input('dd_status'),
			'cb_resp_type' => $request->input('dd_callback_type'),
			'cb_respfor_status' => $request->input('txt_callback_status_name'),
			'cb_valueof_success' => $request->input('txt_callback_success_st'),
			'cb_valueof_pending' => $request->input('txt_callback_pending_st'),
			'cb_valueof_failed' => $request->input('txt_callback_failed_st'),
			'cb_respfor_liveid' => $request->input('txt_res_opr_idname'),
			'cb_respfor_apitxnid' => $request->input('txt_callback_res_api_idname'),
			'cb_apiresp_status' => $request->input('dd_callback_response'),
			'user_role' =>'1',
			'user_id' => SESSION::get('USER_ID'),
			'api_id' => 0
		);

		$this->api_repo->create($arr);
		Session::flash('api_msg','API ADDED SUCCESSFULLY' );
        Session::flash('type','success' );
		return redirect('/add_api');
		
	}


	/**
        * Method name   : View Api
        * @description  : Used for viewing api
        * @param        : Request data 
        * @return       : return view for viewing api
    */
	public function view_api($id)
	{
		$api = $this->api_repo->getById($id);
		return view('Api.edit_api', compact('api'));
	}


	/**
        * Method name   : Update Api
        * @description  : Used for updating api
        * @param        : Request data 
        * @return       : return with updating api
    */
	public function update_api($id)
	{

		$request = request();
		$api = $this->api_repo->getById($id);

		$arr = array(
			'proc'=>2,
			'api_method_type' => $request->input('rb_api_method'),
			'api_for' => $request->input('rb_api_type'),
			'api_datasend_via' => $request->input('rb_data_send'),
			'api_name' => $request->input('txt_api_name'),
			'api_for_transaction' => $request->input('txt_trans_url'),
			'transaction_parameter' => $request->input('txt_bal_param'),
			'api_for_status' => $request->input('txt_status_url'),
			'status_parameter' => $request->input('txt_status_param'),
			'api_for_bal' => $request->input('txt_bal_url'),
			'bal_parameter' => $request->input('txt_bal_param'),
			'api_allow_qty' => $request->input('txt_allow_qty'),
			'api_hlr' => $request->input('txt_allow_hlr'),
			'api_status' => $request->input('dd_status'),
			'resp_occur' => $request->input('dd_response'),
			'resp_type' => $request->input('dd_type'),
			'respfor_status' => $request->input('txt_status_name'),
			'valueof_success' => $request->input('txt_success_st'),
			'valueof_pending' => $request->input('txt_pending_st'),
			'valueof_failed' => $request->input('txt_failed_st'),
			'respfor_liveid' => $request->input('txt_res_opr_idname'),
			'respfor_apitxnid' => $request->input('txt_res_api_idname'),
			'apiresp_status' => $request->input('dd_status'),
			'cb_resp_type' => $request->input('dd_callback_type'),
			'cb_respfor_status' => $request->input('txt_callback_status_name'),
			'cb_valueof_success' => $request->input('txt_callback_success_st'),
			'cb_valueof_pending' => $request->input('txt_callback_pending_st'),
			'cb_valueof_failed' => $request->input('txt_callback_failed_st'),
			'cb_respfor_liveid' => $request->input('txt_callback_res_opr_idname'),
			'cb_respfor_apitxnid' => $request->input('txt_callback_res_api_idname'),
			'cb_apiresp_status' => $request->input('dd_callback_response'),
			'user_role' => '1',
			'user_id' => SESSION::get('USER_ID'),
			'api_id' => $id
		);
		$this->api_repo->create($arr);
		Session::flash('api_msg','API UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );
		return redirect('/add_api');
		
	}

	/**
        * Method name   : Api operator
        * @description  : Used for getting api operator
        * @param        : Request data 
        * @return       : return api operator
    */
	public function api_operator()
	{
		$request = request();
		$apiid=$request->input('dd_api_provider');
		if($_SERVER['REQUEST_METHOD']=="POST")
	        {
				if($request->input('dd_api_provider')!="" && $request->input('dd_api_provider')!="0")
				{
					$apiid=$request->input('dd_api_provider');
				}
		    }
	        $API_OPERATOR=array(
				'proc'=>15,
				'userid'=>$apiid,
				'telecombrandid'=>1,
				'desig'=>1,
                'apiid'=>1 ,
                'msg'=>@msg
            );
            $OPERATOR=DB::select('CALL slab_margin(				
                :proc,
                :userid,
                :telecombrandid,
                :desig,
                :apiid,
                :msg
                )',$API_OPERATOR);
		$API = Helper::get_api(1,'ACTIVE');
		return view('Api.api_operator', compact('OPERATOR','API','apiid'));
	}

	public function update_apioperator($id)
    {
		$page = 'API PANEL';
        $form_name = 'APP API OPERATOR HERE';
		$request = request();
		$apiid=$request->input('dd_api');
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
				if($request->input('dd_api')!="" && $request->input('dd_api')!="0")
				{
					$apiid=$request->input('dd_api');
				}
				$api_margin = array(
				'm15_sp_code'      => $request->input('txt_apiopcode'.$id),
				'm15_sp_commision' => $request->input('txt_apicomm'.$id),
				'm15_sp_allowqty'  => $request->input('txt_apiallow_qty'.$id)
				);
				DB::table('m15_service_provider')->where('m15_sp_id',$id)->update($api_margin);
	    }
	        $API_OPERATOR=array(
				'proc'=>15,
				'userid'=>$apiid,
				'telecombrandid'=>1,
				'desig'=>1,
                'apiid'=>1 ,
                'msg'=>@msg
            );
            $OPERATOR=DB::select('CALL slab_margin(				
                :proc,
                :userid,
                :telecombrandid,
                :desig,
                :apiid,
                :msg
                )',$API_OPERATOR);
       			$API = Helper::get_api(1,'ACTIVE');
       	Session::flash('apiopt_msg','API OPERATOR UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );
    	 return view('Api.api_operator', compact('page', 'form_name','OPERATOR','API','apiid'));
    }

	public function update_all_api()
    {
		$page = 'API PANEL';
        $form_name = 'UPDATE API OPERATOR HERE';
		$request = request();
//dd($request);
		$apiid=$request->input('dd_api');
		$txtuserid = $request->input('regid');
		$api_ids = $request->input('ids');
		$api_codes = $request->input('apiCodes');
		$api_comms = $request->input('comms');
		$api_qtys = $request->input('qtys');
		$count = count($api_ids);
		if($_SERVER['REQUEST_METHOD']=="POST")
        {
				if($request->input('dd_api')!="" && $request->input('dd_api')!="0")
				{
					$apiid=$request->input('dd_api');
				}
				for($i=0;$i<$count;$i++){
					$api_margin = array(
					'm15_sp_code'      => $api_codes[$i],
					'm15_sp_commision' => $api_comms[$i],
					'm15_sp_allowqty'  => $api_qtys[$i],
					);
					DB::table('m15_service_provider')->where('m15_sp_id',$api_ids[$i])->update($api_margin);
				}
			return 1;
	    }
	        $API_OPERATOR=array(
				'proc'=>15,
				'userid'=>$apiid,
				'telecombrandid'=>1,
				'desig'=>1,
                'apiid'=>1 ,
                'msg'=>@msg
            );
            $OPERATOR=DB::select('CALL slab_margin(				
                :proc,
                :userid,
                :telecombrandid,
                :desig,
                :apiid,
                :msg
                )',$API_OPERATOR);
       			$API = Helper::get_api(1,'ACTIVE');
       	Session::flash('apiopt_msg','API OPERATOR UPDATED SUCCESSFULLY' );
        Session::flash('type','success' );
    	return view('Api.api_operator', compact('page', 'form_name','OPERATOR','API','apiid'));
    }
}