<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\Recharge\Rechargeprocess\RechargeprocessRepository;
use App\Repositories\Recharge\Rechargereport\RechargereportRepository;
use App\Repositories\Dmt\Dmtprocess\DmtprocessRepository;
use App\Repositories\Dmt\Dmtreport\DmtreportRepository;
use DB;
use Session;
use Helper;

class ActionController extends Controller
{
    //
    private $rech_proc_repo;
    private $rech_reprt_repo;
    private $dmt_proc_repo;
    private $dmt_reprt_repo;private $STATUS = "failed";
		private $ERRMSG = "Invalid Operation";
		private $ERRCODE = 0;
		private $isError = FALSE;
		private $record_per_page =10;
        private $userDisbled = 0;
		var $excelrec_report=array();
  

	public function __construct(
        RechargeProcessRepository $rech_proc_repo, RechargereportRepository $rech_reprt_repo, 
      DmtprocessRepository $dmt_proc_repo, DmtreportRepository $dmt_reprt_repo
       )
	{
		
        $this->rech_proc_repo = $rech_proc_repo;
        $this->rech_reprt_repo = $rech_reprt_repo;
        $this->dmt_proc_repo = $dmt_proc_repo;
        $this->dmt_reprt_repo = $dmt_reprt_repo;

	}


	 public function update_rechargetid()
     {
			$request = request();
			$descrip="";$start = '1970-01-01';$end ='1970-01-01';$txt_account = '';$txt_memberid = '';$txt_transid = '';$txt_noofrecords = '100';$dd_status='-1';$cond="1";$cond1="1";
            if($_SERVER['REQUEST_METHOD']=="POST")
            {			
				if($request->input('txt_transid')=="")
				{
					$ERRMSG = "Recharge transaction id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_rechid')=="")
				{
					$ERRMSG = "Recharge id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_rechopid')=="")
				{
					$ERRMSG = "Live Id should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError = FALSE;
					$ERRCODE="";
				}
					if($this->isError==FALSE)
					{
						$TRANSID=$request->input('txt_transid');
						$txt_status=-1;
							$recereport=array
								 (
								 'proc'=>2,
									'account'=>$txt_account,
									'transid'=>$TRANSID,
									'userid'=>$txt_memberid,
									'fromdate'=>$start,
									'todate'=>$end,
									'noofrecords'=>$txt_noofrecords,
									'recstatus'=>$txt_status,
									'descrip'=>$cond
								);
						     $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
							 $m=$rec_report[0]->MemberID;
							 $id=$rec_report[0]->UserID;
							 $rqd=$rec_report[0]->Transactionid;
							 $account=$rec_report[0]->Account;
							 $op=$rec_report[0]->ServiceProvider;
							 $mode=$rec_report[0]->Mode;
							 $amt=$rec_report[0]->Amount;
							 $agentid=$rec_report[0]->APITransactionid;
							 $operid=$request->input('txt_rechopid');
							 $status1="SUCCESS";
							 $status2=1;
							$respreport=array(
										'proc'=>2,
										'userid'=>$id,
										'account'=>$account,
										'transid'=>$rqd,
										'liveid'=>$operid,
										'amt'=>$amt,
										'recstatus'=>$status2,
										'descrip'=>'1'
									);
							$resquery = $this->rech_proc_repo->rechargeStatusUpdate($respreport);
							$ERRMSG=DB::select('SELECT @msg as ERR_MSG');
							//dd($ERRMSG);
							 //return($resp_report);
					}
			}
			 return 1;
    }

	public function refund_recharge()
    {
			$request = request();
			$descrip="";$start = '1970-01-01';$end ='1970-01-01';$txt_account = '';$txt_memberid = '';$txt_transid = '';$txt_noofrecords = '100';$dd_status='-1';$cond="1";$cond1="1";
            if($_SERVER['REQUEST_METHOD']=="POST")
            {			

				if($request->input('txt_pendingtxnid')=="")
				{
					$ERRMSG = "Recharge transaction id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_pendingoperaterid')=="")
				{
					$ERRMSG = "Live Id should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError = FALSE;
					$ERRCODE="";
				}
					if($this->isError==FALSE)
					{
						$TRANSID=$request->input('txt_pendingtxnid');
						$txt_status=$request->input('txt_pendingstatus');
							$recereport=array
								 (
							  	   'proc'=>2,
							     	'account'=>$txt_account,
								   'transid'=>$TRANSID,
								    'userid'=>$txt_memberid,
									'fromdate'=>$start,
									'todate'=>$end,
									'noofrecords'=>$txt_noofrecords,
									'recstatus'=>-1,
									'descrip'=>$cond
								);
							 $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
							 $m=$rec_report[0]->MemberID;
							 $id=$rec_report[0]->UserID;
							 $rqd=$rec_report[0]->Transactionid;
							 $account=$rec_report[0]->Account;
							 $op=$rec_report[0]->ServiceProvider;
							 $mode=$rec_report[0]->Mode;
							 $amt=$rec_report[0]->Amount;
							 $agentid=$rec_report[0]->APITransactionid;
							 $operid=$request->input('txt_pendingoperaterid');
							if($txt_status=="SUCCESS")
							{
								$status1="SUCCESS";
								$status2=1;
							}
							if($txt_status=="PENDING")
							{
								$status1="PENDING";
								$status2=2;
							}
							if($txt_status=="FOR REFUND")
							{
								$status1="FOR REFUND";
								$status2=3;
							}
							if($txt_status=="FAILURE")
							{
								$status1="FAILED";
								$status2=4;
							}
							if($txt_status=="REFUNDED")
							{
								$status1="REFUNDED";
								$status2=5;
							}
							if($txt_status=="REJECT")
							{
								$status1="REJECT";
								$status2=6;
							}
							if($txt_status=="RSUCCESS")
							{
								$status1="RSUCCESS";
								$status2=7;
							}
							$respreport=array(
										'proc'=>1,
										'userid'=>$id,
										'account'=>$account,
										'transid'=>$rqd,
										'liveid'=>$operid,
										'amt'=>$amt,
										'recstatus'=>$status2,
										'descrip'=>'1'
									);
							 $resquery = $this->rech_proc_repo->rechargeStatusUpdate($respreport);
							 $ERRMSG=DB::select('SELECT @msg as ERR_MSG');
						     //dd($ERRMSG[0]->ERR_MSG);
							 //Return($resquery);
					}
			}
			return 1;
    }
	
    public function complaint_recharge()
    {
			$page = 'REPORT PANEL';
			$form_name = 'RECHARGE FOR REFUND ID UPDATE HERE';
			$request = request();
			$descrip="";
			$ERRMSG1="";
			
            if($_SERVER['REQUEST_METHOD']=="POST")
            {			
				if($request->input('txt_forrefundtxnid')=="")
				{
					$ERRMSG = "Recharge transaction id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
			    else if($request->input('txt_rechid')=="")
				{
					$ERRMSG = "Recharge Id for complaint should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('dd_complaintreason')=="" || $request->input('dd_complaintreason')=="-1")
				{
					$ERRMSG = "Complaint reason should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError = FALSE;
					$ERRCODE="";
				}
					if($this->isError==FALSE)
					{
						$TRANSID=$request->input('txt_forrefundtxnid');
						$RECHID=$request->input('txt_rechid');
						$REASON=$request->input('dd_complaintreason');
							$respreport=array(
										'proc'=>1,
										'recharge_id'=>$RECHID,
										'descrip'=>$REASON,
										'defaultstatus'=>1
									);
							$resp_report = DB::select('CALL refund(
								 :proc,
								 :recharge_id,
								 :descrip, 
								 :defaultstatus,
								 @msg,
								 @msg1
							 )',$respreport);
							 
							 $ERRMSG=DB::select('SELECT @msg as ERR_MSG');
							 $ERRMSG1=DB::select('SELECT @msg1 as ERR_MSG1');
								return 1;
					}
					else
					{
							return $ERRMSG ;
					}
			}
				
    }
	

		public function hit_callback()
		{
			$page = 'REPORT PANEL';
			$form_name = 'HIT CALL BACK RECHARGE STATUS UPDATE HERE';
			$request = request();
			$descrip="";
			$start = '1970-01-01';
			$end ='1970-01-01';
			$txt_account = '';
			$txt_memberid = '';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="1";
			$cond1="1";
            if($_SERVER['REQUEST_METHOD']=="POST")
            {			
				if($request->input('txt_forrefundtxnid')=="")
				{
					$ERRMSG = "Recharge transaction id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}	
				if($this->isError==FALSE)
					{
						$txt_transid=$request->input('txt_forrefundtxnid');
						
							$TRANSID = $txt_transid;
							$recereport=array
								 (
								 'proc'=>2,
									'account'=>$txt_account,
									'transid'=>$TRANSID,
									'userid'=>$txt_memberid,
									'fromdate'=>$start,
									'todate'=>$end,
									'noofrecords'=>$txt_noofrecords,
									'recstatus'=>-1,
									'descrip'=>$cond
								);
							 $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
							 $DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
							 $m=$rec_report[0]->MemberID;
							 $id=$rec_report[0]->UserID;
							 $rqd=$rec_report[0]->Transactionid;
							 $account=$rec_report[0]->Account;
							 $op=$rec_report[0]->ServiceProvider;
							 $mode=$rec_report[0]->Mode;
							 $amt=$rec_report[0]->Amount;
							 $agentid=$rec_report[0]->APITransactionid;
							 $CLIENTID=$rec_report[0]->APITransactionid;
							 $operid=$request->input('txt_operid');
							 $url=$rec_report[0]->CallBackURL;
							 $txt_status=$rec_report[0]->Status;
							 $params=array
									(
										'status'=>trim( $txt_status),
										'mobile'=>trim($account),
										'amount'=>trim($amt),
										'agentid'=>trim($CLIENTID),
										'opid'=>trim($operid),
										'tid'=>trim($agentid),
										'bal'=>trim(floatval(0.00))
									);
						if($url!=''){
							$cb_response=Helper::_curl_execute('GET',$url,$params);	
							$incmghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
							VALUES ('','$txt_transid','$ip','$url',$cb_response,4)");	
							echo  $cb_response;
						}
						else
						{
						 return 'CallBack Not Updated Please Update.';
						}
					}
			}
			return 1;
		}


/*PENDING RECHARGE ALL SUCCESS AND FAILED */

	public function update_rechargestatus()
    {
			$page = 'REPORT PANEL';
			$form_name = 'RECHARGE STATUS UPDATE HERE';
			$request = request();
			$descrip="";
			$start = '1970-01-01';
			$end ='1970-01-01';
			$txt_account = '';
			$txt_memberid = '';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="1";
			$cond1="1";
            if($_SERVER['REQUEST_METHOD']=="POST")
            {			
				if($request->input('txt_transid')=="")
				{
					$ERRMSG = "Recharge transaction id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
					
				}
				if($request->input('status')=="")
				{
					$ERRMSG = "Recharge status should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
					if($this->isError===FALSE)
					{
						$txt_transid=$request->input('txt_transid');
						$txt_status=$request->input('status');
						foreach($txt_transid as $val)
						{
							$TRANSID = $val;
							$recereport=array
								 (
								 'proc'=>2,
									'account'=>$txt_account,
									'transid'=>$TRANSID,
									'userid'=>$txt_memberid,
									'fromdate'=>$start,
									'todate'=>$end,
									'noofrecords'=>$txt_noofrecords,
									'recstatus'=>2,
									'descrip'=>$cond
								);
							 $rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
							 $m=$rec_report[0]->MemberID;
							 $id=$rec_report[0]->UserID;
							 $rqd=$rec_report[0]->Transactionid;
							 $account=$rec_report[0]->Account;
							 $op=$rec_report[0]->ServiceProvider;
							 $mode=$rec_report[0]->Mode;
							 $amt=$rec_report[0]->Amount;
							 $agentid=$rec_report[0]->APITransactionid;
							 $operid=$request->input('txt_operid');
							if($txt_status=="SUCCESS")
							{
								$status1="SUCCESS";
								$status2=1;
							}
							if($txt_status=="PENDING")
							{
								$status1="PENDING";
								$status2=2;
							}
							if($txt_status=="REFUND")
							{
								$status1="REFUND";
								$status2=3;
							}
							if($txt_status=="FAILURE")
							{
								$status1="FAILED";
								$status2=4;
							}
							if($txt_status=="REFUNDED")
							{
								$status1="REFUNDED";
								$status2=5;
							}
							$respreport=array(
										'proc'=>1,
										'userid'=>$id,
										'account'=>$account,
										'transid'=>$rqd,
										'liveid'=>$operid,
										'amt'=>$amt,
										'recstatus'=>$status2,
										'descrip'=>'1'
									);
							 $resquery = $this->rech_proc_repo->rechargeStatusUpdate($respreport);
							 $ERRMSG=DB::select('SELECT @msg as ERR_MSG');
							 //dd($ERRMSG[0]->ERR_MSG);
						}
					}
			}
			 return 1;
    }


		public function bill_receipt($txn_id)
		{
			$request = request();
			$descrip="1";
			$start ='1970-01-01';$end ='1970-01-01';
			$txt_account = '';$txt_memberid = '';$txt_transid = '';$txt_noofrecords = '100';$dd_status='-1';
			$cond="";$cond1="1";$txt_transid=$txn_id;$cond=$cond.$cond1;
			$recereport=array
				 (
				   'proc'=>2,'account'=>$txt_account,'transid'=>$txt_transid,'userid'=>$txt_memberid,'fromdate'=>$start,'todate'=>$end,'noofrecords'=>$txt_noofrecords,'recstatus'=>$dd_status,'descrip'=>$cond
				);
			$rec_report = $this->rech_reprt_repo->rechargeReport($recereport);
	       return view('Report.recharge_receipt',compact('rec_report'));
		}


	
/////////////////////// MONEY TRANSFER /////////////////////////////

  public function update_dmttid()
    {
			$page = 'REPORT PANEL';
			$form_name = 'MONEY TARNSFER IMPS REFNO UPDATE HERE';
			$request = request();
			$descrip="";
			$start = '1970-01-01';
			$end ='1970-01-01';
			$txt_account = '';
			$txt_memberid = '';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="1";
			$cond1="1";
			
			
            if($_SERVER['REQUEST_METHOD']=="POST")
            {			
				if($request->input('txt_transid')=="")
				{
					$ERRMSG = "Money Trasnfer transaction id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_dmtid')=="")
				{
					$ERRMSG = "Money Trasnfer id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_impsrefno')=="")
				{
					$ERRMSG = "IMPS RefNo should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError = FALSE;
					$ERRCODE="";
				}
					if($this->isError==FALSE)
					{
						$TRANSID=$request->input('txt_transid');
						$txt_status=-1;
							$recereport=array
								 (
								    'proc'=>1,
									'account'=>$txt_account,
									'transid'=>$TRANSID,
									'userid'=>$txt_memberid,
									'fromdate'=>$start,
									'todate'=>$end,
									'noofrecords'=>$txt_noofrecords,
									'recstatus'=>$txt_status,
									'descrip'=>$cond,
									'msg'=>@msg
								);
							$rec_report = $this->dmt_reprt_repo->dmrReport($recereport);
							
							 $m=$rec_report[0]->MemberContactNo;
							 $id=$rec_report[0]->Memberid;
							 $rqd=$rec_report[0]->Transactionid;
							 $account=$rec_report[0]->Account_number;
							 $amt=$rec_report[0]->Amount;
							 $operid=$request->input('txt_impsrefno');
							 $status1="SUCCESS";
							 $status2=1;
							 $respreport=array(
										'proc'=>2,
										'userid'=>$id,
										'account'=>$account,
										'transid'=>$rqd,
										'liveid'=>$operid,
										'amt'=>$amt,
										'recstatus'=>$status2,
										'descrip'=>'1'
									);
							 $resquery = $this->dmt_proc_repo->dmrStatusUpdate($respreport);
							 $ERRMSG=DB::select('SELECT @msg as ERR_MSG');
							 //dd($ERRMSG);
							 //return($resp_report);
					}
			}
			 return 1;
    }
	public function refund_dmt()
    {
			$page = 'REPORT PANEL';
			$form_name = 'MONEY TARNSFER REFUND UPDATE HERE';
			$request = request();
			$descrip="";
			$start = '1970-01-01';
			$end ='1970-01-01';
			$txt_account = '';
			$txt_memberid = '';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="1";
			$cond1="1";
			
            if($_SERVER['REQUEST_METHOD']=="POST")
            {			
				if($request->input('txt_transid')=="")
				{
					$ERRMSG = "Money Trasnfer transaction id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_impsrefno')=="")
				{
					$ERRMSG = "IMPS RefNo should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError = FALSE;
					$ERRCODE="";
				}
				if($this->isError==FALSE)
				{
					$TRANSID=$request->input('txt_transid');
					$txt_status=$request->input('txt_status');
					$recereport=array
					( 
						'proc'=>1,
						'account'=>$txt_account,
						'transid'=>$TRANSID,
						'userid'=>$txt_memberid,
						'fromdate'=>$start,
						'todate'=>$end,
						'noofrecords'=>$txt_noofrecords,
						'recstatus'=>-1,
						'descrip'=>$cond
					);
						$rec_report = $this->dmt_reprt_repo->dmrReport($recereport);
							 $m=$rec_report[0]->MemberContactNo;
							 $id=$rec_report[0]->Memberid;
							 $rqd=$rec_report[0]->Transactionid;
							 $account=$rec_report[0]->Account_number;
							 $amt=$rec_report[0]->Amount;
							//echo $amt;
							
							 $operid=$request->input('txt_impsrefno');
							if($txt_status=="SUCCESS")
							{
								$status1="SUCCESS";
								$status2=1;
							}
							if($txt_status=="PENDING")
							{
								$status1="PENDING";
								$status2=2;
							}
							if($txt_status=="FOR REFUND")
							{
								$status1="FOR REFUND";
								$status2=3;
							}
							if($txt_status=="FAILURE")
							{
								$status1="FAILED";
								$status2=4;
							}
							if($txt_status=="REFUNDED")
							{
								$status1="REFUNDED";
								$status2=5;
							}
							if($txt_status=="RSUCCESS")
							{
								$status1="RSUCCESS";
								$status2=7;
							}
							$respreport=array(
										'proc'=>2,
										'userid'=>$id,
										'account'=>$account,
										'transid'=>$rqd,
										'liveid'=>$operid,
										'amt'=>$amt,
										'recstatus'=>$status2,
										'descrip'=>'1'
									);
							 $resquery = $this->dmt_proc_repo->dmrStatusUpdate($respreport);
							 
							 $ERRMSG=DB::select('SELECT @msg as ERR_MSG');
							//dd($ERRMSG);
							 //return($resp_report);
					}
			}
			return 1;
    }


public function complaint_dmt()
    {
			$page = 'REPORT PANEL';
			$form_name = 'MONEY TARNSFER FOR REFUND UPDATE HERE';
			$request = request();
			$descrip="";
			$ERRMSG1="";
			
            if($_SERVER['REQUEST_METHOD']=="POST")
            {			
				if($request->input('txt_transid')=="")
				{
					$ERRMSG = "Money Transfer transaction id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
			    else if($request->input('txt_dmrid')=="")
				{
					$ERRMSG = "Money Transfer Id for complaint should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('dd_complaintreason')=="" || $request->input('dd_complaintreason')=="-1")
				{
					$ERRMSG = "Complaint reason should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError = FALSE;
					$ERRCODE="";
				}
					if($this->isError==FALSE)
					{
						$TRANSID=$request->input('txt_transid');
						$DMRID=$request->input('txt_dmrid');
						$REASON=$request->input('dd_complaintreason');
							$respreport=array(
										'proc'=>4,
										'recharge_id'=>$DMRID,
										'descrip'=>$REASON,
										'defaultstatus'=>1
									);
							$resp_report = DB::select('CALL refund(
								 :proc,
								 :recharge_id,
								 :descrip, 
								 :defaultstatus,
								 @msg,
								 @msg1
							 )',$respreport);
							 
							 $ERRMSG=DB::select('SELECT @msg as ERR_MSG');
							 $ERRMSG1=DB::select('SELECT @msg1 as ERR_MSG1');
							//dd($ERRMSG);								
                             return 1;
					}
					else
					{
							return $ERRMSG ;
					}
			}
				
    }


		public function hitmt_callback()
		{
			$page = 'BILL PAY PANEL';
			$form_name = 'HIT  BILL PAY CALL BACK RECHARGE STATUS UPDATE HERE';
			$request = request();
			$descrip="";
			$start = '1970-01-01';
			$end ='1970-01-01';
			$txt_account = '';
			$txt_memberid = '';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="1";
			$cond1="1";
            if($_SERVER['REQUEST_METHOD']=="POST")
            {			
				if($request->input('txt_forrefundtxnid')=="")
				{
					$ERRMSG = "Recharge transaction id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}	
				if($this->isError==FALSE)
					{
						$txt_transid=$request->input('txt_forrefundtxnid');
						
							$TRANSID = $txt_transid;
							$recereport=array
								 (
								 'proc'=>2,
									 'mobile'=>'',
									'account'=>$txt_account,
									'transid'=>$TRANSID,
									'userid'=>$txt_memberid,
									'fromdate'=>$start,
									'todate'=>$end,
									'noofrecords'=>$txt_noofrecords,
									'recstatus'=>-1,
									'descrip'=>$cond
								);
							$rec_report = $this->dmt_reprt_repo->dmrReport($recereport);
							 $DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
							 $m=$rec_report[0]->MemberID;
							 $id=$rec_report[0]->UserID;
							 $rqd=$rec_report[0]->Transactionid;
							 $account=$rec_report[0]->Account;
							 $op=$rec_report[0]->ServiceProvider;
							 $mode=$rec_report[0]->Mode;
							 $amt=$rec_report[0]->Amount;
							 $agentid=$rec_report[0]->APITransactionid;
							 $CLIENTID=$rec_report[0]->APITransactionid;
							 $operid=$request->input('txt_operid');
							 $url=$rec_report[0]->CallBackURL;
							 $txt_status=$rec_report[0]->Status;
							 $params=array
									(
										'status'=>trim( $txt_status),
										'mobile'=>trim($account),
										'amount'=>trim($amt),
										'agentid'=>trim($CLIENTID),
										'opid'=>trim($operid),
										'tid'=>trim($agentid),
										'bal'=>trim(floatval(0.00))
									);
						if($url!=''){
							$cb_response=Helper::_curl_execute('GET',$url,$params);	
							$incmghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
							VALUES ('','$txt_transid','$ip','$url',$cb_response,4)");	
							echo  $cb_response;
						}
						else
						{
						 return 'CallBack Not Updated Please Update.';
						}
					}
			}
			return 1;
		}


/*PENDING MONEY TRANSFER ALL SUCCESS AND FAILED */

	public function update_mtstatus()
    {
			$page = 'REPORT PANEL';
			$form_name = 'MONEY TRANSFER STATUS UPDATE HERE';
			$request = request();
			$descrip="";
			$start = '1970-01-01';
			$end ='1970-01-01';
			$txt_account = '';
			$txt_memberid = '';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="1";
			$cond1="1";
            if($_SERVER['REQUEST_METHOD']=="POST")
            {			
				if($request->input('txt_transid')=="")
				{
					$ERRMSG = "Bill Pay transaction id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
					
				}
				if($request->input('status')=="")
				{
					$ERRMSG = "Bill Pay status should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
					if($this->isError===FALSE)
					{
						$txt_transid=$request->input('txt_transid');
						$txt_status=$request->input('status');
						foreach($txt_transid as $val)
						{
							$TRANSID = $val;
							$recereport=array
								 (
								 'proc'=>2,
								 'mobile'=>'',
									'account'=>$txt_account,
									'transid'=>$TRANSID,
									'userid'=>$txt_memberid,
									'fromdate'=>$start,
									'todate'=>$end,
									'noofrecords'=>$txt_noofrecords,
									'recstatus'=>2,
									'descrip'=>$cond
								);
							$rec_report = $this->dmt_reprt_repo->dmrReport($recereport);
							 $m=$rec_report[0]->MemberID;
							 $id=$rec_report[0]->UserID;
							 $rqd=$rec_report[0]->Transactionid;
							 $account=$rec_report[0]->Account;
							 $op=$rec_report[0]->ServiceProvider;
							 $mode=$rec_report[0]->Mode;
							 $amt=$rec_report[0]->Amount;
							 $agentid=$rec_report[0]->APITransactionid;
							 $operid=$request->input('txt_operid');
							if($txt_status=="SUCCESS")
							{
								$status1="SUCCESS";
								$status2=1;
							}
							if($txt_status=="PENDING")
							{
								$status1="PENDING";
								$status2=2;
							}
							if($txt_status=="REFUND")
							{
								$status1="REFUND";
								$status2=3;
							}
							if($txt_status=="FAILURE")
							{
								$status1="FAILED";
								$status2=4;
							}
							if($txt_status=="REFUNDED")
							{
								$status1="REFUNDED";
								$status2=5;
							}
							$respreport=array(
										'proc'=>1,
										'userid'=>$id,
										'account'=>$account,
										'transid'=>$rqd,
										'liveid'=>$operid,
										'amt'=>$amt,
										'recstatus'=>$status2,
										'descrip'=>'1'
									);
							 $resquery = $this->dmt_proc_repo->dmrStatusUpdate($respreport);
							 $ERRMSG=DB::select('SELECT @msg as ERR_MSG');
						}
					}
			}
			 return 1;
    }


public function mt_receipt($txn_id)
		{
			$page = 'PROFILE PANEL';
			$form_name = 'USER TRANSFER BENEFICIARY HERE';
			$request = request();
			if($txn_id!="")
			{
			$descrip="";
			$start ='1970-01-01';$end ='1970-01-01';
			$txt_account = '';
			$txt_memberid = '';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="";
			$cond1="1";
			$txt_transid=$txn_id;
            $cond=$cond.$cond1;
			
				$dmtreport=array
				 (
				    'proc'=>1,
					'account'=>$txt_account,
					'transid'=>$txt_transid,
					'userid'=>$txt_memberid,
					'fromdate'=>$start,
					'todate'=>$end,
					'noofrecords'=>$txt_noofrecords,
					'recstatus'=>$dd_status,
					'descrip'=>$cond,
					'msg'=>@msg
				);
				//print_r($dmtreport);
				$dmt_report = DB::select('CALL dmr_report(
                 :proc,
                 :account,
                 :transid, 
                 :userid,
                 :fromdate,
                 :todate,
                 :noofrecords,
                 :recstatus,
                 :descrip,
                 :msg
             )',$dmtreport);
			}
			//print_r($dmt_report);
			//dd();
			return view('Report.dmt-receipt',compact('form_name','dmt_report'));
		}


/*BILLPAY HERE*/
 public function update_billpaytid()
     {
			$request = request();
			$descrip="";$start = '1970-01-01';$end ='1970-01-01';$txt_account = '';$txt_memberid = '';$txt_transid = '';$txt_noofrecords = '100';$dd_status='-1';$cond="1";$cond1="1";
            if($_SERVER['REQUEST_METHOD']=="POST")
            {			
				if($request->input('txt_transid')=="")
				{
					$ERRMSG = "Bill Pay transaction id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_rechid')=="")
				{
					$ERRMSG = "Bill Pay id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_rechopid')=="")
				{
					$ERRMSG = "Live Id should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError = FALSE;
					$ERRCODE="";
				}
					if($this->isError==FALSE)
					{
						$TRANSID=$request->input('txt_transid');
						$txt_status=-1;
							$recereport=array
								 (
								 'proc'=>2,
									 'mobile'=>'',
									'account'=>$txt_account,
									'transid'=>$TRANSID,
									'userid'=>$txt_memberid,
									'fromdate'=>$start,
									'todate'=>$end,
									'noofrecords'=>$txt_noofrecords,
									'recstatus'=>$txt_status,
									'descrip'=>$cond
								);
						     $rec_report = $this->rech_reprt_repo->billpayReport($recereport);
							 $m=$rec_report[0]->MemberID;
							 $id=$rec_report[0]->UserID;
							 $rqd=$rec_report[0]->Transactionid;
							 $account=$rec_report[0]->Account;
							 $op=$rec_report[0]->ServiceProvider;
							 $mode=$rec_report[0]->Mode;
							 $amt=$rec_report[0]->Amount;
							 $agentid=$rec_report[0]->APITransactionid;
							 $operid=$request->input('txt_rechopid');
							 $status1="SUCCESS";
							 $status2=1;
							$respreport=array(
										'proc'=>2,
										'userid'=>$id,
										'account'=>$account,
										'transid'=>$rqd,
										'liveid'=>$operid,
										'amt'=>$amt,
										'recstatus'=>$status2,
										'descrip'=>'1'
									);
							$resquery = $this->rech_proc_repo->billpayStatusUpdate($respreport);
							$ERRMSG=DB::select('SELECT @msg as ERR_MSG');
							//dd($ERRMSG);
							 //return($resp_report);
					}
			}
			 return 1;
    }

	public function refund_billpay()
    {
			$request = request();
			$descrip="";$start = '1970-01-01';$end ='1970-01-01';$txt_account = '';$txt_memberid = '';$txt_transid = '';$txt_noofrecords = '100';$dd_status='-1';$cond="1";$cond1="1";
            if($_SERVER['REQUEST_METHOD']=="POST")
            {			

				if($request->input('txt_pendingtxnid')=="")
				{
					$ERRMSG = "Recharge transaction id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('txt_pendingoperaterid')=="")
				{
					$ERRMSG = "Live Id should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError = FALSE;
					$ERRCODE="";
				}
					if($this->isError==FALSE)
					{
						$TRANSID=$request->input('txt_pendingtxnid');
						$txt_status=$request->input('txt_pendingstatus');
							$recereport=array
								 (
							  	   'proc'=>2,
									 'mobile'=>'',
							     	'account'=>$txt_account,
								   'transid'=>$TRANSID,
								    'userid'=>$txt_memberid,
									'fromdate'=>$start,
									'todate'=>$end,
									'noofrecords'=>$txt_noofrecords,
									'recstatus'=>-1,
									'descrip'=>$cond
								);
							 $rec_report = $this->rech_reprt_repo->billpayReport($recereport);
							 $m=$rec_report[0]->MemberID;
							 $id=$rec_report[0]->UserID;
							 $rqd=$rec_report[0]->Transactionid;
							 $account=$rec_report[0]->Account;
							 $op=$rec_report[0]->ServiceProvider;
							 $mode=$rec_report[0]->Mode;
							 $amt=$rec_report[0]->Amount;
							 $agentid=$rec_report[0]->APITransactionid;
							 $operid=$request->input('txt_pendingoperaterid');
							if($txt_status=="SUCCESS")
							{
								$status1="SUCCESS";
								$status2=1;
							}
							if($txt_status=="PENDING")
							{
								$status1="PENDING";
								$status2=2;
							}
							if($txt_status=="FOR REFUND")
							{
								$status1="FOR REFUND";
								$status2=3;
							}
							if($txt_status=="FAILURE")
							{
								$status1="FAILED";
								$status2=4;
							}
							if($txt_status=="REFUNDED")
							{
								$status1="REFUNDED";
								$status2=5;
							}
							if($txt_status=="REJECT")
							{
								$status1="REJECT";
								$status2=6;
							}
							if($txt_status=="RSUCCESS")
							{
								$status1="RSUCCESS";
								$status2=7;
							}
							$respreport=array(
										'proc'=>1,
										'userid'=>$id,
										'account'=>$account,
										'transid'=>$rqd,
										'liveid'=>$operid,
										'amt'=>$amt,
										'recstatus'=>$status2,
										'descrip'=>'1'
									);
							 $resquery = $this->rech_proc_repo->billpayStatusUpdate($respreport);
							 $ERRMSG=DB::select('SELECT @msg as ERR_MSG');
						    //dd($ERRMSG[0]->ERR_MSG);
							 //Return($resquery);
					}
			}
			return 1;
    }
	
    public function complaint_billpay()
    {
			$page = 'REPORT PANEL';
			$form_name = 'BILL PAY FOR REFUND ID UPDATE HERE';
			$request = request();
			$descrip="";
			$ERRMSG1="";
			
            if($_SERVER['REQUEST_METHOD']=="POST")
            {			
				if($request->input('txt_forrefundtxnid')=="")
				{
					$ERRMSG = "Billpay transaction id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
			    else if($request->input('txt_rechid')=="")
				{
					$ERRMSG = "Billpay Id for complaint should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else if($request->input('dd_complaintreason')=="" || $request->input('dd_complaintreason')=="-1")
				{
					$ERRMSG = "Complaint reason should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
				else
				{
					$ERRMSG = "";
					$this->isError = FALSE;
					$ERRCODE="";
				}
					if($this->isError==FALSE)
					{
						$TRANSID=$request->input('txt_forrefundtxnid');
						$RECHID=$request->input('txt_rechid');
						$REASON=$request->input('dd_complaintreason');
							$respreport=array(
										'proc'=>1,
										'recharge_id'=>$RECHID,
										'descrip'=>$REASON,
										'defaultstatus'=>1
									);
							$resp_report = DB::select('CALL refund(
								 :proc,
								 :recharge_id,
								 :descrip, 
								 :defaultstatus,
								 @msg,
								 @msg1
							 )',$respreport);
							 
							 $ERRMSG=DB::select('SELECT @msg as ERR_MSG');
							 $ERRMSG1=DB::select('SELECT @msg1 as ERR_MSG1');
								return 1;
					}
					else
					{
							return $ERRMSG ;
					}
			}
				
    }
	

		public function hitbillpay_callback()
		{
			$page = 'BILL PAY PANEL';
			$form_name = 'HIT  BILL PAY CALL BACK RECHARGE STATUS UPDATE HERE';
			$request = request();
			$descrip="";
			$start = '1970-01-01';
			$end ='1970-01-01';
			$txt_account = '';
			$txt_memberid = '';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="1";
			$cond1="1";
            if($_SERVER['REQUEST_METHOD']=="POST")
            {			
				if($request->input('txt_forrefundtxnid')=="")
				{
					$ERRMSG = "Recharge transaction id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}	
				if($this->isError==FALSE)
					{
						$txt_transid=$request->input('txt_forrefundtxnid');
						
							$TRANSID = $txt_transid;
							$recereport=array
								 (
								 'proc'=>2,
									 'mobile'=>'',
									'account'=>$txt_account,
									'transid'=>$TRANSID,
									'userid'=>$txt_memberid,
									'fromdate'=>$start,
									'todate'=>$end,
									'noofrecords'=>$txt_noofrecords,
									'recstatus'=>-1,
									'descrip'=>$cond
								);
							 $rec_report = $this->rech_reprt_repo->billpayReport($recereport);
							 $DB_ERRMSG=DB::select('SELECT @msg as ERR_MSG');
							 $m=$rec_report[0]->MemberID;
							 $id=$rec_report[0]->UserID;
							 $rqd=$rec_report[0]->Transactionid;
							 $account=$rec_report[0]->Account;
							 $op=$rec_report[0]->ServiceProvider;
							 $mode=$rec_report[0]->Mode;
							 $amt=$rec_report[0]->Amount;
							 $agentid=$rec_report[0]->APITransactionid;
							 $CLIENTID=$rec_report[0]->APITransactionid;
							 $operid=$request->input('txt_operid');
							 $url=$rec_report[0]->CallBackURL;
							 $txt_status=$rec_report[0]->Status;
							 $params=array
									(
										'status'=>trim( $txt_status),
										'mobile'=>trim($account),
										'amount'=>trim($amt),
										'agentid'=>trim($CLIENTID),
										'opid'=>trim($operid),
										'tid'=>trim($agentid),
										'bal'=>trim(floatval(0.00))
									);
						if($url!=''){
							$cb_response=Helper::_curl_execute('GET',$url,$params);	
							$incmghit_record=DB::select("INSERT INTO tr09_smsvalue (m11_user_api_token,tr09_transid,tr09_apihit_fromip,tr09_apihit_fullurl,tr09_apihit_response,tr09_apihit_type) 
							VALUES ('','$txt_transid','$ip','$url',$cb_response,4)");	
							echo  $cb_response;
						}
						else
						{
						 return 'CallBack Not Updated Please Update.';
						}
					}
			}
			return 1;
		}


/*PENDING BILL PAY ALL SUCCESS AND FAILED */

	public function update_billpaystatus()
    {
			$page = 'REPORT PANEL';
			$form_name = 'BILL PAY STATUS UPDATE HERE';
			$request = request();
			$descrip="";
			$start = '1970-01-01';
			$end ='1970-01-01';
			$txt_account = '';
			$txt_memberid = '';
			$txt_transid = '';
			$txt_noofrecords = '100';
			$dd_status='-1';
			$cond="1";
			$cond1="1";
            if($_SERVER['REQUEST_METHOD']=="POST")
            {			
				if($request->input('txt_transid')=="")
				{
					$ERRMSG = "Bill Pay transaction id  should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
					
				}
				if($request->input('status')=="")
				{
					$ERRMSG = "Bill Pay status should be valid or not blank.";
					$this->isError = TRUE;
					$ERRCODE="warning";
				}
					if($this->isError===FALSE)
					{
						$txt_transid=$request->input('txt_transid');
						$txt_status=$request->input('status');
						foreach($txt_transid as $val)
						{
							$TRANSID = $val;
							$recereport=array
								 (
								 'proc'=>2,
								 'mobile'=>'',
									'account'=>$txt_account,
									'transid'=>$TRANSID,
									'userid'=>$txt_memberid,
									'fromdate'=>$start,
									'todate'=>$end,
									'noofrecords'=>$txt_noofrecords,
									'recstatus'=>2,
									'descrip'=>$cond
								);
							 $rec_report = $this->rech_reprt_repo->billpayReport($recereport);
							 $m=$rec_report[0]->MemberID;
							 $id=$rec_report[0]->UserID;
							 $rqd=$rec_report[0]->Transactionid;
							 $account=$rec_report[0]->Account;
							 $op=$rec_report[0]->ServiceProvider;
							 $mode=$rec_report[0]->Mode;
							 $amt=$rec_report[0]->Amount;
							 $agentid=$rec_report[0]->APITransactionid;
							 $operid=$request->input('txt_operid');
							if($txt_status=="SUCCESS")
							{
								$status1="SUCCESS";
								$status2=1;
							}
							if($txt_status=="PENDING")
							{
								$status1="PENDING";
								$status2=2;
							}
							if($txt_status=="REFUND")
							{
								$status1="REFUND";
								$status2=3;
							}
							if($txt_status=="FAILURE")
							{
								$status1="FAILED";
								$status2=4;
							}
							if($txt_status=="REFUNDED")
							{
								$status1="REFUNDED";
								$status2=5;
							}
							$respreport=array(
										'proc'=>1,
										'userid'=>$id,
										'account'=>$account,
										'transid'=>$rqd,
										'liveid'=>$operid,
										'amt'=>$amt,
										'recstatus'=>$status2,
										'descrip'=>'1'
									);
							 $resquery = $this->rech_proc_repo->billpayStatusUpdate($respreport);
							 $ERRMSG=DB::select('SELECT @msg as ERR_MSG');
						}
					}
			}
			 return 1;
    }




/// Bill pay
	public function billpay_receipt($txn_id)
		{
			$request = request();
			$descrip="1";
			$start ='1970-01-01';$end ='1970-01-01';
			$txt_account = '';$txt_memberid = '';$txt_transid = '';$txt_noofrecords = '100';$dd_status='-1';
			$cond="";$cond1="1";$txt_transid=$txn_id;$cond=$cond.$cond1;
			$recereport=array
				 (
				   'proc'=>2, 'mobile'=>'','account'=>$txt_account,'transid'=>$txt_transid,'userid'=>$txt_memberid,'fromdate'=>$start,'todate'=>$end,'noofrecords'=>$txt_noofrecords,'recstatus'=>$dd_status,'descrip'=>$cond
				);
			$rec_report = $this->rech_reprt_repo->billpayReport($recereport);
	       return view('Report.billpay_receipt',compact('rec_report'));
		}


///



	/**
        * Method name   : find api log and callback log
        * @description  : view  find api log and callback log
        * @param        : Request data 
        * @return       : return recharge report mobile
    */

	public function api_log(request $request)
		{
			$rec_report = DB::select("SELECT HitURL,Response,RequestType FROM apihit_reqres WHERE AgentID='".$request->trans_id."'");
			if(count($rec_report) > 0)
			{
				return $rec_report; 
			}
			else
			{
				return 'error';
			}
		}



}