<?php

namespace App\Http\Controllers\API;

use App\Repositories\ProductModule\Categories\CategoriesRepository;
use App\Repositories\ProductModule\ParentCategories\ParentCategoriesRepository;
use App\Repositories\ProductModule\Products\ProductsRepository;
use App\Repositories\ProductModule\UserOrders\UserOrdersRepository;
use App\Repositories\ProductModule\Favorites\FavoritesRepository;
use App\Repositories\ProductModule\Wishlist\WishlistRepository;
use App\Repositories\ProductModule\UserAddress\UserAddressRepository;
use App\Repositories\ProductModule\OnlinePayment\OnlinePaymentRepository;
use App\Repositories\ProductModule\ProductVariant\ProductVariantRepository;
use App\Repositories\ProductModule\OrdersSiping\OrdersSipingRepository;
use App\Repositories\Log\LogRepository;
use Illuminate\Http\Request; 
use App\Http\Requests;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use DB;
use Config;
use Helper;
use Cookie;
use App;
use File;

class ShoppingWebService extends Controller
{
    private $parent_catrepo;
    private $cat_repo;
    private $prod_repo;
    private $order_repo;
    private $fav_repo;
	private $wishlist_repo;
	private $address_repo;
	private $onlinepay_repo;
	private $prod_varnt;
    private $log_repo;
    private $ordersiping_repo;

    private $isError = FALSE;

    public function __construct(CategoriesRepository $cat_repo, ProductsRepository $prod_repo,
        ParentCategoriesRepository $parent_catrepo, UserOrdersRepository $order_repo, 
		FavoritesRepository $fav_repo, WishlistRepository $wishlist_repo, UserAddressRepository $address_repo, 
        OnlinePaymentRepository $onlinepay_repo, ProductVariantRepository $prod_varnt, LogRepository $log_repo, OrdersSipingRepository $ordersiping_repo)
    {
    	$this->cat_repo = $cat_repo;
        $this->prod_repo = $prod_repo;
        $this->parent_catrepo = $parent_catrepo;
        $this->order_repo = $order_repo;
        $this->fav_repo = $fav_repo;
		$this->wishlist_repo = $wishlist_repo;
		$this->address_repo = $address_repo;
		$this->onlinepay_repo = $onlinepay_repo;
		$this->prod_varnt = $prod_varnt;
        $this->log_repo = $log_repo;
        $this->ordersiping_repo = $ordersiping_repo;
    }

    /**
    * Method name   : parent cat
    * @description  : Used for viewing all parent categories
    * @param        : Request data  
    * @return       : return view with all parent categories
    */
    public function parent_cat()
    {
        $all_parent = $this->parent_catrepo->getAllActive();
        unset($new_arr);
        unset($new_arr1);
        $new_arr = array();
        $new_arr1 = array();
        
        foreach($all_parent as $values)
        {
            
            $parent_cat1 = $this->parent_catrepo->getById($values->CAT_ID);
            
            foreach($parent_cat1[0] as $key=>$value)
            {
                $new_arr[$key] = $value;
            }

            $sub_cat1 = $this->cat_repo->getByShoppingFor($parent_cat1[0]->CAT_ID);

            if(isset($sub_cat1[0])){
                if($parent_cat1[0]->CAT_ID == $sub_cat1[0]->SHOPPING_FOR){
                    $new_arr['CATEGORY'] = $sub_cat1;
                }          
            }
            array_push($new_arr1,$new_arr);
            $new_arr['CATEGORY'] = [];
        }

        if($new_arr1){
            $ERRMSG = "PARENT CATEGORIES FETCHED SUCCESSFULLY.";
            $ERRCODE="success";
        }
        else{
            $ERRMSG = "PARENT CATEGORIES NOT FETCHED.";
            $ERRCODE="error";
        }

        return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG,
            'SHOPPING'=>$new_arr1,
        ]);

    }

	 /**
    * Method name   : parent cat
    * @description  : Used for viewing all parent categories
    * @param        : Request data  
    * @return       : return view with all parent categories
    */
    public function get_cat($id)
    {

        $sub_cat1 = $this->cat_repo->getAllByShoppingFor($id);

        if($sub_cat1){
            $ERRMSG = "CATEGORIES FETCHED SUCCESSFULLY.";
            $ERRCODE="success";
        }
        else{
            $ERRMSG = "CATEGORIES NOT FETCHED.";
            $ERRCODE="error";
        }

        return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG,
            'CATEGORY'=>$sub_cat1,
        ]);

    }



    /**
    * Method name   : categories
    * @description  : Used for viewing all categories
    * @param        : Request data  
    * @return       : return view with all categories
    */
    public function categories()
    {

        $categories = $this->cat_repo->getAllCategory();
        if($categories){
            $ERRMSG = "CATEGORIES FETCHED SUCCESSFULLY.";
            $ERRCODE="success";
        }
        else{
            $ERRMSG = "CATEGORIES NOT FETCHED.";
            $ERRCODE="error";
        }
        return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG,
            'CATEGORIES'=>$categories
        ]);
    }


    /**
    * Method name   : sub_categories
    * @description  : Used for viewing all sub categories
    * @param        : Request data  
    * @return       : return view with all sub categories
    */
    public function sub_categories($id)
    {
        $parent_categories = $this->cat_repo->getById($id);
        $sub_categories = $this->cat_repo->getSubCategoryByParent($id);
        if($sub_categories){
            $ERRMSG = "SUB-CATEGORIES FETCHED SUCCESSFULLY.";
            $ERRCODE="success";
        }
        else{
            $ERRMSG = "SUB-CATEGORIES NOT FETCHED.";
            $ERRCODE="error";
        }
        return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG,
            'CATEGORIES'=>$parent_categories,
            'SUB_CATEGORIES'=>$sub_categories   
        ]);
    }


   /**
    * Method name   : get cat prods
    * @description  : Used for viewing all products by category
    * @param        : Request data  
    * @return       : return view with all products by category
    */
    public function get_cat_prods($id)
    {
        $products = $this->prod_repo->getByCatId($id);
		unset($new_arr);
        unset($new_arr1);
        $new_arr = array();
        $new_arr1 = array();

        foreach($products as $values)
        {
            
            $single_product = $this->prod_repo->getById($values->PROD_ID);
            
            foreach($single_product[0] as $key=>$value)
            {
                $new_arr[$key] = $value;
            }


            $product_variants = $this->prod_varnt->getByProductId($values->PROD_ID);

            if(isset($product_variants[0])){
                $new_arr['VARIANTS'] = $product_variants;
            }
            array_push($new_arr1,$new_arr);
			$new_arr['VARIANTS'] = [];
        }

        if($new_arr1){
            $ERRMSG = "PRODUCTS FETCHED SUCCESSFULLY.";
            $ERRCODE="success";
        }
        else{
            $ERRMSG = "PRODUCTS NOT FETCHED.";
            $ERRCODE="error";
        }
        return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG,
            'PRODUCTS'=>$new_arr1
        ]);
    }


    /**
    * Method name   : product detail
    * @description  : Used for viewing single product detail
    * @param        : Request data  
    * @return       : return view with single product detail
    */
    public function product_detail($id)
    {
        $single_product = $this->prod_repo->getById($id);
        $product_variants = $this->prod_varnt->getByProductId($id);

        $new_arr = array();
        foreach($single_product[0] as $key=>$value)
        {
            $new_arr[$key] = $value;
        }

        $new_arr['VARIANTS'] = $product_variants;

        if($new_arr){
            $ERRMSG = "PRODUCT DETAILS FETCHED SUCCESSFULLY.";
            $ERRCODE="success";
        }
        else{
            $ERRMSG = "PRODUCT DETAILS NOT FETCHED.";
            $ERRCODE="error";
        }
        return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG,
            'PRODUCT_DETAILS'=>$new_arr
        ]);
    }

    /**
    * Method name   : add favorites
    * @description  : Used for adding products to favorites
    * @param        : Request data  
    * @return       : return view with adding products to favorites
    */
    public function add_favorites()
    {
        $request = request();
        $isError = FALSE;
        $transfer="";
        $authorization = $request->header('Authorization');

		$token1=explode('_',$authorization); 
		if(count($token1)==2)
		{
		$token=$token1[0];
		$device_id=$token1[1];
		}

        $product_id = $request->input('txt_product_id');

        $already_added = $this->fav_repo->getByProdId($product_id);

        if($token=='')
        {
            $ERRMSG = "Api Token should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        else
        {
            $login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
            if($login_detail)
            {
                $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                $ERRCODE="success";
            }
            else
            {
                $ERRMSG = "USER DETAILS NOT FIND.";
                $ERRCODE="error";
                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);
            }

        }

        if($product_id=='')
        {
            $this->isError= TRUE;
            $ERRMSG = "PRODUCT ID CANT BE NULL";
            $ERRCODE="error";
        }

        if($already_added[0]->CON==1)
        {
            $this->isError= TRUE;
            $ERRMSG = "PRODUCT ALREADY ADDED TO FAVORITE";
            $ERRCODE="error";
        }

        if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
        {
            $user_id=$login_detail[0]->RegId;

            $arr = array(
                'm11_user_id' => $user_id,
                'm33_product_id' => $product_id
                );
            
            $add_fav = $this->fav_repo->create($arr);

            $ERRMSG="PRODUCT ADDED TO FAVORITE SUCCESSFULLY!";
            $ERRCODE='success'; 

            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG
            ]);
        }
        else
        {
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG 
            ]);
        }
    }


    /**
    * Method name   : user favorites
    * @description  : Used for getting user favorites
    * @param        : Request data  
    * @return       : return view with getting user favorites
    */
    public function user_favorites()
    {
        $request = request();
        $isError = FALSE;
        $transfer="";
        $authorization = $request->header('Authorization');

		$token1=explode('_',$authorization); 
		if(count($token1)==2)
		{
		$token=$token1[0];
		$device_id=$token1[1];
		}

        if($token=='')
        {
            $ERRMSG = "Api Token should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        else
        {
            $login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
            if($login_detail)
            {
                $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                $ERRCODE="success";
            }
            else
            {
                $ERRMSG = "USER DETAILS NOT FIND.";
                $ERRCODE="error";
                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);
            }

        }

        if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
        {
            $user_id=$login_detail[0]->RegId;
            
            $user_fav = $this->fav_repo->getByUserId($user_id);

            $ERRMSG="USER FAVORITES FETCHED SUCCESSFULLY!";
            $ERRCODE='success'; 

            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG,
            'FAVORITES' =>$user_fav
            ]);
        }
        else
        {
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG 
            ]);
        }
    }


    /**
    * Method name   : delete favorites
    * @description  : Used for deleting user favorites
    * @param        : Request data  
    * @return       : return view with deleting user favorites
    */
    public function delete_favorites()
    {
        $request = request();
        $isError = FALSE;
        $transfer="";
        $authorization = $request->header('Authorization');

		$token1=explode('_',$authorization); 
		if(count($token1)==2)
		{
		$token=$token1[0];
		$device_id=$token1[1];
		}

        $fav_id = $request->input('txt_fav_id');

        if($token=='')
        {
            $ERRMSG = "Api Token should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        else
        {
            $login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
            if($login_detail)
            {
                $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                $ERRCODE="success";
            }
            else
            {
                $ERRMSG = "USER DETAILS NOT FIND.";
                $ERRCODE="error";
                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);
            }

        }

        if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
        {
            $user_id=$login_detail[0]->RegId;
            
            $delete_fav = $this->fav_repo->delete($fav_id);

            $ERRMSG="PRODUCT DELETED FROM FAVORITE SUCCESSFULLY!";
            $ERRCODE='success'; 

            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG
            ]);
        }
        else
        {
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG 
            ]);
        }
    }

    /**
    * Method name   : add favorites
    * @description  : Used for adding products to favorites
    * @param        : Request data  
    * @return       : return view with adding products to favorites
    */
    public function add_wishlist()
    {
        $request = request();
        $isError = FALSE;
        $transfer="";
        $authorization = $request->header('Authorization');

		$token1=explode('_',$authorization); 
		if(count($token1)==2)
		{
		$token=$token1[0];
		$device_id=$token1[1];
		}

        $product_id = $request->input('txt_product_id');

        $already_added = $this->wishlist_repo->getByProdId($product_id);

        if($token=='')
        {
            $ERRMSG = "Api Token should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        else
        {
            $login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
            if($login_detail)
            {
                $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                $ERRCODE="success";
            }
            else
            {
                $ERRMSG = "USER DETAILS NOT FIND.";
                $ERRCODE="error";
                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);
            }

        }

        if($product_id=='')
        {
            $this->isError= TRUE;
            $ERRMSG = "PRODUCT ID CANT BE NULL";
            $ERRCODE="error";
        }

        if($already_added[0]->CON==1)
        {
            $this->isError= TRUE;
            $ERRMSG = "PRODUCT ALREADY ADDED TO WISHLIST";
            $ERRCODE="error";
        }

        if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
        {
            $user_id=$login_detail[0]->RegId;

            $arr = array(
                'm11_user_id' => $user_id,
                'm33_product_id' => $product_id
            );
            
            $add_wish = $this->wishlist_repo->create($arr);

            $ERRMSG="PRODUCT ADDED TO WISHLIST SUCCESSFULLY!";
            $ERRCODE='success'; 

            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG
            ]);
        }
        else
        {
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG 
            ]);
        }
    }


    /**
    * Method name   : user favorites
    * @description  : Used for getting user favorites
    * @param        : Request data  
    * @return       : return view with getting user favorites
    */
    public function user_wishlist()
    {
        $request = request();
        $isError = FALSE;
        $transfer="";
        $authorization = $request->header('Authorization');

		$token1=explode('_',$authorization); 
		if(count($token1)==2)
		{
		$token=$token1[0];
		$device_id=$token1[1];
		}

        if($token=='')
        {
            $ERRMSG = "Api Token should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        else
        {
            $login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
            if($login_detail)
            {
                $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                $ERRCODE="success";
            }
            else
            {
                $ERRMSG = "USER DETAILS NOT FIND.";
                $ERRCODE="error";
                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);
            }

        }

        if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
        {
            $user_id=$login_detail[0]->RegId;
            
            $user_wishlist = $this->wishlist_repo->getByUserId($user_id);

            $ERRMSG="USER WISHLIST FETCHED SUCCESSFULLY!";
            $ERRCODE='success'; 

            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG,
            'WISHLIST' =>$user_wishlist
            ]);
        }
        else
        {
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG 
            ]);
        }
    }


    /**
    * Method name   : delete favorites
    * @description  : Used for deleting user favorites
    * @param        : Request data  
    * @return       : return view with deleting user favorites
    */
    public function delete_wishlist()
    {
        $request = request();
        $isError = FALSE;
        $transfer="";
        $authorization = $request->header('Authorization');

		$token1=explode('_',$authorization); 
		if(count($token1)==2)
		{
		$token=$token1[0];
		$device_id=$token1[1];
		}

        $wish_id = $request->input('txt_wish_id');

        if($token=='')
        {
            $ERRMSG = "Api Token should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        else
        {
            $login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
            if($login_detail)
            {
                $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                $ERRCODE="success";
            }
            else
            {
                $ERRMSG = "USER DETAILS NOT FIND.";
                $ERRCODE="error";
                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);
            }

        }

        if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
        {
            $user_id=$login_detail[0]->RegId;
            
            $delete_wishlist = $this->wishlist_repo->delete($wish_id);

            $ERRMSG="PRODUCT DELETED FROM WISHLIST SUCCESSFULLY!";
            $ERRCODE='success'; 

            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG
            ]);
        }
        else
        {
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG 
            ]);
        }
    }

     /**
        * Method name   : placing order
        * @description  : Used for placing order
        * @param        : Request data  
        * @return       : return view with placing order
    */
    public function placing_orders()
    {
        $request = request();
        $isError = FALSE;
        $transfer="";
        $authorization = $request->header('Authorization');

        $token1=explode('_',$authorization); 
        if(count($token1)==2)
        {
        $token=$token1[0];
        $device_id=$token1[1];
        }

        $product_details = $request->input('txt_product');
        $address_id = $request->input('txt_addressid');
        $address_details = $request->input('txt_address');
        $order_tax = $request->input('txt_order_tax');
        $delivery_fee = $request->input('txt_delivery_fee');
        $final_amt = $request->input('txt_final_amt');
        $order_status = $request->input('txt_order_status');
        $payment_status = $request->input('txt_payment_status');
        $payment_method = $request->input('txt_payment_method');
        $trnx_id = $request->input('txt_trnx_id');
        $wallet_type = $request->input('txt_wallet_type');
        $collected_amount = $request->input('txt_collected_amount');

        if($final_amt <= config('DELIVERY_PRICE'))
        {
            $delivery_fee = (float)(config('DELIVERY_CHARGE'));
        }
        else
        {
            $delivery_fee = 0;
        }

        if($token=='')
        {
            $ERRMSG = "Api Token should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        else
        {
            $login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
            if($login_detail)
            {
                $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                $ERRCODE="success";
            }
            else
            {
                $ERRMSG = "USER DETAILS NOT FIND.";
                $ERRCODE="error";
                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);
            }

        }

        if($product_details=='')
        {
            $ERRMSG = "Product details should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        elseif($address_id=='')
        {
            $ERRMSG = "Address id should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        elseif($address_details=='')
        {
            $ERRMSG = "Address details should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        elseif($order_tax=='')
        {
            $ERRMSG = "Order tax should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        elseif($delivery_fee==='')
        {
            $ERRMSG = "Delivery fee should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        elseif($final_amt=='')
        {
            $ERRMSG = "Final amount should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        elseif($order_status=='')
        {
            $ERRMSG = "Order status should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        elseif($payment_status=='')
        {
            $ERRMSG = "Payment status should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        elseif($payment_method=='')
        {
            $ERRMSG = "Payment method should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        elseif($wallet_type=='')
        {
            $ERRMSG = "wallet type should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        elseif($collected_amount==null)
        {
            $ERRMSG = "Coupon Amount should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }

        if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
        {
            $user_id=$login_detail[0]->RegId;
            $user_code=$login_detail[0]->RegCode;

            if($payment_method==2){
                if($payment_status="SUCCESS" && $trnx_id!=''){

                    $fundtransfer_data=array(
                        'proc'=>2,
                        'to_user_id'=>$user_id,
                        'from_user_id'=>0,
                        'amount'=>floatval($final_amt),
                        'collected_amount'=>floatval($final_amt),
                        'requesttype'=>1,
                        'balfor'=>1,
                        'transtype'=>1,
                        'timelimit'=>900,
                        'defaultstatus'=>1,
                        'remark'=>"ONLINE PAYMENT",
                        'collected_remark'=>"ONLINE PAYMENT"
                    );

                    $fundtransfer = DB::SELECT('CALL wallettransfer(
                        :proc, 
                        :to_user_id,
                        :from_user_id,
                        :amount, 
                        :collected_amount,
                        :requesttype,
                        :balfor,
                        :transtype,
                        :timelimit,
                        :defaultstatus,
                        :remark,
                        :collected_remark,
                        @status_code,
                        @status_msg)'
                    ,$fundtransfer_data);
                    $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
                    $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');

                    $fundtransfer_data1=array(
                        'proc'=>4,
                        'to_user_id'=>$user_id,
                        'from_user_id'=>0,
                        'amount'=>floatval($final_amt),
                        'collected_amount'=>floatval($final_amt),
                        'requesttype'=>1,
                        'balfor'=>1,
                        'transtype'=>1,
                        'timelimit'=>900,
                        'defaultstatus'=>1,
                        'remark'=>"ONLINE PAYMENT",
                        'collected_remark'=>"ONLINE PAYMENT"
                    );

                    $fundtransfer1 = DB::SELECT('CALL wallettransfer(
                        :proc, 
                        :to_user_id,
                        :from_user_id,
                        :amount, 
                        :collected_amount,
                        :requesttype,
                        :balfor,
                        :transtype,
                        :timelimit,
                        :defaultstatus,
                        :remark,
                        :collected_remark,
                        @status_code,
                        @status_msg)'
                    ,$fundtransfer_data1);

                    $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
                    $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');

                    if($ERRCODE[0]->ERR_CODE == 'success'){

                        $arr1 = array(
                            'm11_user_id' => $user_id,
                            'm11_user_code' => $user_code,
                            'tr31_op_amount' => $final_amt,
                            'tr31_op_currency' => 2,
                            'tr31_op_txnid' => $trnx_id,
                            'tr31_op_status' => 1
                        );
                        
                        $this->onlinepay_repo->create($arr1);

						$order_code = 'MARTAD'.time().$user_id;
                        $arr = array(
							'tr36_order_id' => $order_code,
                            'm11_user_id' => $user_id,
                            'tr36_product_details' => $product_details,
                            'tr36_user_type' => 1,
                            'tr36_address_id' => $address_id,
                            'tr36_address_details' => $address_details,
                            'tr36_order_tax' => $order_tax,
                            'tr36_delivery_fee' => $delivery_fee,
                            'tr36_final_amount' => $final_amt-$delivery_fee,
                            'tr36_order_status' => $order_status,
                            'tr36_payment_status' => $payment_status,
                            'tr36_payment_method' => $payment_method,
                            'tr36_order_datetime' => NOW(),
                            'tr36_cart_type'=>2,
                            'tr03_manage_ledger_id'=> $ERRMSG[0]->ERR_MSG
                        );
                        
                        $order_created = $this->order_repo->create($arr);

                        $ERRMSG="USER ORDER PLACED SUCCESSFULLY!";
                        $ERRCODE='success'; 
                    }
                    

                }
            }
            elseif($payment_method==3){


                $shoppingwallet=array(
                    'proc'=>9,
                    'to_user_id'=>$user_id,
                    'from_user_id'=>0,
                    'amount'=>floatval($final_amt),
                    'collected_amount'=>floatval($collected_amount),
                    'requesttype'=>1,
                    'balfor'=>$wallet_type,
                    'transtype'=>1,
                    'timelimit'=>3000,
                    'defaultstatus'=>1,
                    'remark'=>"Shoping Payment",
                    'collected_remark'=>"Shoping Payment"
                );

                $shopping_wallet = DB::SELECT('CALL wallettransfer(
                    :proc, 
                    :to_user_id,
                    :from_user_id,
                    :amount, 
                    :collected_amount,
                    :requesttype,
                    :balfor,
                    :transtype,
                    :timelimit,
                    :defaultstatus,
                    :remark,
                    :collected_remark,
                    @status_code,
                    @status_msg)'
                ,$shoppingwallet);

                $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
                $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');

                if($ERRCODE[0]->ERR_CODE == 'success'){
                   $order_code = 'MARTAD'.time().$user_id;
                      $arr = array(
						'tr36_order_id' => $order_code,
                        'm11_user_id' => $user_id,
                        'tr36_product_details' => $product_details,
                        'tr36_user_type' => 1,
                        'tr36_address_id' => $address_id,
                        'tr36_address_details' => $address_details,
                        'tr36_order_tax' => $order_tax,
                        'tr36_delivery_fee' => $delivery_fee,
                        'tr36_final_amount' => $final_amt,
                        'tr36_order_status' => $order_status,
                        'tr36_payment_status' => 2,
                        'tr36_payment_method' => $payment_method,
                        'tr36_order_datetime' => NOW(),
                        'tr36_cart_type'=>2,
                        'tr03_manage_ledger_id'=> $ERRMSG[0]->ERR_MSG
                    );
                    
                    $order_created = $this->order_repo->create($arr);

                    $ERRMSG="USER ORDER PLACED SUCCESSFULLY!";
                    $ERRCODE='success'; 
                }
                else
                {
                    $ERRMSG=$ERRMSG[0]->ERR_MSG;
                    $ERRCODE=$ERRCODE[0]->ERR_CODE; 
                }
            }
            elseif($payment_method==1){

                $order_code = 'MARTAD'.time().$user_id;
                $arr = array(
					'tr36_order_id' => $order_code,
                    'm11_user_id' => $user_id,
                    'tr36_product_details' => $product_details,
                    'tr36_user_type' => 1,
                    'tr36_address_id' => $address_id,
                    'tr36_address_details' => $address_details,
                    'tr36_order_tax' => $order_tax,
                    'tr36_delivery_fee' => $delivery_fee,
                    'tr36_final_amount' => $final_amt,
                    'tr36_order_status' => 1,
                    'tr36_payment_status' => 1,
                    'tr36_payment_method' => $payment_method,
                    'tr36_order_datetime' => NOW(),
                    'tr36_cart_type'=>2
                );
               
                $order_created = $this->order_repo->create($arr);

                $ERRMSG="USER ORDER PLACED SUCCESSFULLY!";
                $ERRCODE='success'; 

            }

            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG
            ]);
        }
        else
        {
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG 
            ]);
        }
    }

    /**
    * Method name   : user orders
    * @description  : Used for viewing user order details
    * @param        : Request data  
    * @return       : return view with user order details
    */
    public function user_orders()
    {
        $request = request();
        $isError = FALSE;
        $transfer="";
        $authorization = $request->header('Authorization');

		$token1=explode('_',$authorization); 
		if(count($token1)==2)
		{
		$token=$token1[0];
		$device_id=$token1[1];
		}

        if($token=='')
        {
            $ERRMSG = "Api Token should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        else
        {
            $login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
            if($login_detail)
            {
                $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                $ERRCODE="success";
            }
            else
            {
                $ERRMSG = "USER DETAILS NOT FIND.";
                $ERRCODE="error";
                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);
            }

        }

        if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
        {
            $user_id=$login_detail[0]->RegId;
            
            $user_orders = $this->order_repo->getByUserIdFinal($user_id);

			$arr = array();
            foreach($user_orders as $values){
                $orders=array(
                    "ORDER_ID"=> $values->ORDER_ID,
					"ORDER_CODE"=> $values->ORDER_CODE,
                    "USER_ID"=> $values->USER_ID,
                    "USER_CODE"=> $values->USER_CODE,
                    "USER_NAME"=> $values->USER_NAME,
                    "PRODUCT_DETAILS"=> json_decode($values->PRODUCT_DETAILS, true, JSON_UNESCAPED_SLASHES),
                    "USER_TYPE"=> $values->USER_TYPE,
                    "ADDRESS_ID"=> $values->ADDRESS_ID,
                    "ADDRESS_DETAILS"=> json_decode($values->ADDRESS_DETAILS),
                    "ORDER_TAX"=> $values->ORDER_TAX,
                    "DELIVERY_FEE"=> $values->DELIVERY_FEE,
                    "FINAL_AMOUNT"=> $values->FINAL_AMOUNT,
                    "ORDER_STATUS"=> $values->ORDER_STATUS,
					"ORDER_DATE"=> $values->ORDER_TIME,
					"PICKUP_SCHEDULED_DATE"=> $values->PICKUP_SCHEDULED_DATE,
					"DELIVERY_SCHEDULED_DATE"=> $values->DELIVERY_SCHEDULED_DATE,
                    "PAYMENT_STATUS"=> $values->PAYMENT_STATUS,
                    "PAYMENT_METHOD"=> $values->PAYMENT_METHOD,
                    "CART_TYPE"=> $values->CART_TYPE,
                    "CREATED_AT"=> $values->CREATED_AT,
                    "UPDATED_AT"=> $values->UPDATED_AT
                );
                array_push($arr,$orders);
			}

            $ERRMSG="USER ORDERS FETCH SUCCESSFULLY!";
            $ERRCODE='success'; 

            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG,
            'ORDER_DATA'=>$arr
            ]);
        }
        else
        {
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG 
            ]);
        }
    }



        /**
    * Method name   : user cancel order
    * @description  : Used for cancel order
    * @param        : Request data  
    * @return       : return view with
    */
    public function user_cancel_order()
    {
        $request = request();
        $isError = FALSE;
        $transfer="";
        $authorization = $request->header('Authorization');

        $token1=explode('_',$authorization); 
        if(count($token1)==2)
        {
        $token=$token1[0];
        $device_id=$token1[1];
        }

        if($token=='')
        {
            $ERRMSG = "Api Token should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        else
        {
            $login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
            if($login_detail)
            {
                $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                $ERRCODE="success";
            }
            else
            {
                $ERRMSG = "USER DETAILS NOT FIND.";
                $ERRCODE="error";
                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);
            }

        }
        if($request->input('txt_orderid')=='')
        {
            $this->isError= TRUE;
            $ERRMSG = "Order id should be valid or not blank.";
            $ERRCODE="error";
        }
        else if($request->input('dd_orstatus')=='')
        {
            $this->isError= TRUE;
            $ERRMSG = "Order Status for cancel should be valid or not blank.";
            $ERRCODE="error";
        }
        else
        {
            $ERRMSG = "";
            $this->isError=FALSE;
            $ERRCODE="success";
        }

        if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
        {

                $id = $request->input('txt_orderid');
                $single_order = $this->order_repo->getById($id);


                if(count($single_order) == 0)
                {
                    $ERRCODE = 'warning';
                    $ERRMSG  = 'Order Not Found';

                    return response()->json([
                        'ERROR'=>$ERRCODE,
                        'MSG' =>$ERRMSG
                    ]);
                }


                $ship = $this->ordersiping_repo->getByCartId($single_order[0]->ORDER_ID);

                if(count($ship) > 0)
                {
                    $ERRCODE = 'warning';
                    $ERRMSG  = 'your order has already been shipped';

                    return response()->json([
                        'ERROR'=>$ERRCODE,
                        'MSG' =>$ERRMSG
                    ]);
                }

                $arrlog = array(
                    'tr11_ar_tblnm' => 'user_order',
                    'tr11_ar_old_value' => "ORDER_STATUS = ".$single_order[0]->ORDER_STATUS." PAYMENT_STATUS  =".$single_order[0]->PAYMENT_STATUS,
                    'tr11_ar_new_value' => "ORDER_STATUS = ".$request->dd_orstatus." PAYMENT_STATUS =".$request->dd_paystatus,
                    'tr11_ar_uid' => 1,
                    'tr11_ar_description' => 'USER ORDER CANCELLED SUCCESSFULLY!',
                    'tr11_updated_by' =>2,
                    'tr11_updated_by_id' =>  $login_detail[0]->RegId
                    );
                

                $mobileno_actionrecord=$this->log_repo->create($arrlog);


                if($request->input('dd_orstatus') == "3" && count($ship) == 0)
                {   
                    if($single_order[0]->PAYMENT_STATUS == 'SUCCESS' && $single_order[0]->ORDER_STATUS != 'CANCELLED' && $single_order[0]->ORDER_STATUS != 'DELIVERED' && $single_order[0]->LEDGER_ID != '')
                    {

                               $shoppingwallet=array(
                                        'proc'=>10,
                                        'to_user_id'=>$login_detail[0]->RegId,
                                        'from_user_id'=>0,
                                        'amount'=>floatval(0.00),
                                        'collected_amount'=>floatval(0.00),
                                        'requesttype'=>1,
                                        'balfor'=>1,
                                        'transtype'=>1,
                                        'timelimit'=>300,
                                        'defaultstatus'=>1,
                                        'remark'=>$single_order[0]->LEDGER_ID,
                                        'collected_remark'=>"Shoping Payment"
                                    );

                                    $shopping_wallet = DB::SELECT('CALL wallettransfer(
                                        :proc, 
                                        :to_user_id,
                                        :from_user_id,
                                        :amount, 
                                        :collected_amount,
                                        :requesttype,
                                        :balfor,
                                        :transtype,
                                        :timelimit,
                                        :defaultstatus,
                                        :remark,
                                        :collected_remark,
                                        @status_code,
                                        @status_msg)'
                                    ,$shoppingwallet);

                                    $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
                                    $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');

                        if($ERRCODE[0]->ERR_CODE == 'success')
                        {
                            $this->order_repo->update($id,['tr36_order_status' => 3]);
                        }
                    }
                }
                else
                {
                    $this->order_repo->update($id, ['tr36_order_status' => 3]);
                }
     
 
            $ERRCODE = 'success';
            $ERRMSG  = 'ORDER CANCELLED SUCCESSFULLY';
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG
            ]);
        }
        else
        {
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG 
            ]);
        }
    }




	/**
    * Method name   : add address
    * @description  : Used for adding user addresses
    * @param        : Request data  
    * @return       : return view with adding user addresses
    */
    public function add_address()
    {
        $request = request();
        $isError = FALSE;
        $transfer="";
        $authorization = $request->header('Authorization');

		$token1=explode('_',$authorization); 
		if(count($token1)==2)
		{
		$token=$token1[0];
		$device_id=$token1[1];
		}

        if($token=='')
        {
            $ERRMSG = "Api Token should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        else
        {
            $login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
            if($login_detail)
            {
                $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                $ERRCODE="success";
            }
            else
            {
                $ERRMSG = "USER DETAILS NOT FIND.";
                $ERRCODE="error";
                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);
            }

        }
        if($request->input('txt_flat')=='')
        {
            $this->isError= TRUE;
            $ERRMSG = "FLAT SHOULD BE VALID AND NOT NULL";
            $ERRCODE="error";
        }
        elseif($request->input('txt_area')=='')
        {
            $this->isError= TRUE;
            $ERRMSG = "AREA SHOULD BE VALID AND NOT NULL";
            $ERRCODE="error";
        }
        elseif($request->input('txt_pincode')=='')
        {
            $this->isError= TRUE;
            $ERRMSG = "PINCODE SHOULD BE VALID AND NOT NULL";
            $ERRCODE="error";
        }
        elseif($request->input('txt_address_type')=='')
        {
            $this->isError= TRUE;
            $ERRMSG = "ADDRESS SHOULD BE VALID AND NOT NULL";
            $ERRCODE="error";
        }

		if($request->input('txt_is_default') == 'YES'){
			$default = 1;
		}
		elseif($request->input('txt_is_default') == 'NO'){
			$default = 2;
		}

        if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
        {
            $user_id=$login_detail[0]->RegId;

			if($request->input('txt_is_default') == 'YES'){
                $arr = array(
                    'm73_isdefault' => 2
                );
                $this->address_repo->updateByUserId($user_id,$arr);
            }

            $arr = array(
                'm11_user_id' => $user_id,
                'm73_flat' => $request->input('txt_flat'),
                'm73_area' => $request->input('txt_area'),
                'm73_landmark' => $request->input('txt_landmark'),
                'm73_pincode' => $request->input('txt_pincode'),
                'm73_address_type' => $request->input('txt_address_type'),
				'm73_isdefault' => $default
            );
            
            $add_address = $this->address_repo->create($arr);

            $ERRMSG="USER ADDRESS ADDED SUCCESSFULLY!";
            $ERRCODE='success'; 

            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG
            ]);
        }
        else
        {
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG 
            ]);
        }
    }

    /**
    * Method name   : update address
    * @description  : Used for updating user addresses
    * @param        : Request data  
    * @return       : return view with updating user addresses
    */
    public function update_address()
    {
        $request = request();
        $isError = FALSE;
        $transfer="";
        $authorization = $request->header('Authorization');

		$token1=explode('_',$authorization); 
		if(count($token1)==2)
		{
		$token=$token1[0];
		$device_id=$token1[1];
		}

        if($token=='')
        {
            $ERRMSG = "Api Token should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        else
        {
            $login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
            if($login_detail)
            {
                $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                $ERRCODE="success";
            }
            else
            {
                $ERRMSG = "USER DETAILS NOT FIND.";
                $ERRCODE="error";
                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);
            }

        }

        if($request->input('txt_address_id')=='')
        {
            $this->isError= TRUE;
            $ERRMSG = "ADDRESS ID SHOULD BE VALID AND NOT NULL";
            $ERRCODE="error";
        }
        if($request->input('txt_flat')=='')
        {
            $this->isError= TRUE;
            $ERRMSG = "FLAT SHOULD BE VALID AND NOT NULL";
            $ERRCODE="error";
        }
        elseif($request->input('txt_area')=='')
        {
            $this->isError= TRUE;
            $ERRMSG = "AREA SHOULD BE VALID AND NOT NULL";
            $ERRCODE="error";
        }
        elseif($request->input('txt_pincode')=='')
        {
            $this->isError= TRUE;
            $ERRMSG = "PINCODE SHOULD BE VALID AND NOT NULL";
            $ERRCODE="error";
        }
        elseif($request->input('txt_address_type')=='')
        {
            $this->isError= TRUE;
            $ERRMSG = "ADDRESS TYPE SHOULD BE VALID AND NOT NULL";
            $ERRCODE="error";
        }

        if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
        {
            $user_id=$login_detail[0]->RegId;

            $arr = array(
                'm73_flat' => $request->input('txt_flat'),
                'm73_area' => $request->input('txt_area'),
                'm73_landmark' => $request->input('txt_landmark'),
                'm73_pincode' => $request->input('txt_pincode'),
                'm73_address_type' => $request->input('txt_address_type')
            );
            
            $add_address = $this->address_repo->update($request->input('txt_address_id'),$arr);

            $ERRMSG="USER ADDRESS UPDATED SUCCESSFULLY!";
            $ERRCODE='success'; 

            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG
            ]);
        }
        else
        {
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG 
            ]);
        }
    }

    /**
    * Method name   : user address
    * @description  : Used for getting user addresses
    * @param        : Request data  
    * @return       : return view with getting user addresses
    */
    public function user_address()
    {
        $request = request();
        $isError = FALSE;
        $transfer="";
		$token='';
        $authorization = $request->header('Authorization');

		$token1=explode('_',$authorization); 
		if(count($token1)==2)
		{
		$token=$token1[0];
		$device_id=$token1[1];
		}

        if($token=='')
        {
            $ERRMSG = "Api Token should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        else
        {
            $login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
            if($login_detail)
            {
                $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                $ERRCODE="success";
            }
            else
            {
                $ERRMSG = "USER DETAILS NOT FIND.";
                $ERRCODE="error";
                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);
            }

        }

        if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
        {
            $user_id=$login_detail[0]->RegId;
            
            $user_addresses = $this->address_repo->getByUserId($user_id);

            $ERRMSG="USER ADDRESSES FETCHED SUCCESSFULLY!";
            $ERRCODE='success'; 

            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG,
            'ADDRESS' =>$user_addresses
            ]);
        }
        else
        {
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG 
            ]);
        }
    }


    /**
    * Method name   : delete address
    * @description  : Used for deleting user address
    * @param        : Request data  
    * @return       : return view with deleting user address
    */
    public function delete_address()
    {
        $request = request();
        $isError = FALSE;
        $transfer="";
        $authorization = $request->header('Authorization');

		$token1=explode('_',$authorization); 
		if(count($token1)==2)
		{
		$token=$token1[0];
		$device_id=$token1[1];
		}

        $address_id = $request->input('txt_address_id');

        if($token=='')
        {
            $ERRMSG = "Api Token should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        else
        {
            $login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
            if($login_detail)
            {
                $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                $ERRCODE="success";
            }
            else
            {
                $ERRMSG = "USER DETAILS NOT FIND.";
                $ERRCODE="error";
                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);
            }

            if($request->input('txt_address_id')=='')
            {
                $this->isError= TRUE;
                $ERRMSG = "ADDRESS ID SHOULD BE VALID AND NOT NULL";
                $ERRCODE="error";
            }

        }

        if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
        {
            $user_id=$login_detail[0]->RegId;
            
            $delete_address = $this->address_repo->delete($address_id);

            $ERRMSG="USER ADDRESS DELETED SUCCESSFULLY!";
            $ERRCODE='success'; 

            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG
            ]);
        }
        else
        {
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG 
            ]);
        }
    }

	/**
    * Method name   : address default
    * @description  : Used for setting address to default
    * @param        : Request data  
    * @return       : return view with setting address to default
    */
    public function address_default()
    {
        $request = request();
        $isError = FALSE;
        $transfer="";
        $authorization = $request->header('Authorization');

		$token1=explode('_',$authorization); 
		if(count($token1)==2)
		{
		$token=$token1[0];
		$device_id=$token1[1];
		}

        $address_id = $request->input('txt_address_id');

        if($token=='')
        {
            $ERRMSG = "Api Token should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        else
        {
            $login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
            if($login_detail)
            {
                $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                $ERRCODE="success";
            }
            else
            {
                $ERRMSG = "USER DETAILS NOT FIND.";
                $ERRCODE="error";
                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);
            }

            if($request->input('txt_address_id')=='')
            {
                $this->isError= TRUE;
                $ERRMSG = "ADDRESS ID SHOULD BE VALID AND NOT NULL";
                $ERRCODE="error";
            }

        }

        if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
        {
            $user_id=$login_detail[0]->RegId;
            
            $all_user_address = $this->address_repo->getByUserId($user_id);

           $arr1 = array(
                    'm73_isdefault' => 2
                );
                $this->address_repo->updateByUserId($user_id,$arr1);

             $arr = array(
                    'm73_isdefault' => 1
                );
            $this->address_repo->update($request->input('txt_address_id'),$arr);

            $ERRMSG="USER ADDRESS SET TO DEFAULT SUCCESSFULLY!";
            $ERRCODE='success'; 

            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG
            ]);
        }
        else
        {
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG 
            ]);
        }
    }

	/**
    * Method name   : user default address
    * @description  : Used for getting user default address
    * @param        : Request data  
    * @return       : return view with getting user default address
    */
    public function user_default_address()
    {
        $request = request();
        $isError = FALSE;
        $transfer="";
        $authorization = $request->header('Authorization');

		$token1=explode('_',$authorization); 
		if(count($token1)==2)
		{
		$token=$token1[0];
		$device_id=$token1[1];
		}

        if($token=='')
        {
            $ERRMSG = "Api Token should be valid or not blank.";
            $this->isError= TRUE;
            $ERRCODE="error";
            $userData ='';
        }
        else
        {
            $login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");
            if($login_detail)
            {
                $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                $ERRCODE="success";
            }
            else
            {
                $ERRMSG = "USER DETAILS NOT FIND.";
                $ERRCODE="error";
                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);
            }

        }

        if($_SERVER['REQUEST_METHOD']=="POST" && $this->isError==FALSE)
        {
            $user_id=$login_detail[0]->RegId;
            
            $user_addresses = $this->address_repo->getUserDefault($user_id);

            $ERRMSG="USER DEFAULT ADDRESS FETCHED SUCCESSFULLY!";
            $ERRCODE='success'; 

            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG,
            'DEFAULT_ADDRESS' =>$user_addresses
            ]);
        }
        else
        {
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG 
            ]);
        }
    }

	/**
		* Method name	: date slot
		* @description 	: Used for date slot
		* @param		: Request data with date slot
		* @return		: Return response with date slot
	*/
    public function date_slot(){

	    $slot = array();
	    $slot1 = array(
	    	'id' => 1,
	    	"slot"=> "8:00 AM - 10:00 AM"
	    );
	    array_push($slot, $slot1);
	    $slot2 = array(
	    	'id' => 2,
	    	"slot"=> "10:00 AM - 12:00 PM"
	    );
	    array_push($slot, $slot2);
	    $slot3 = array(
	    	'id' => 3,
	    	"slot"=> "12:00 PM - 2:00 PM"
	    );
	    array_push($slot, $slot3);
	    $slot4 = array(
	    	'id' => 4,
	    	"slot"=> "2:00 PM - 4:00 PM"
	    );
	    array_push($slot, $slot4);
	    $slot5 = array(
	    	'id' => 5,
	    	"slot"=> "4:00 PM - 6:00 PM"
	    );
	    array_push($slot, $slot5);
	    $slot6 = array(
	    	'id' => 6,
	    	"slot"=> "6:00 PM - 8:00 PM"
	    );
	    array_push($slot, $slot6);

	    $today = date('d-m-Y');
	    $tomorrow = date('d F Y',strtotime("+1 days"));
	    $time=array();
	    $arr = array(
	    	'name'=> $tomorrow,
	    	'slots'=> $slot
	    );

	    array_push($time, $arr);
	 	for($i=2;$i<7;$i++){
		 	$date1 = date('d F Y',strtotime("+".$i." days"));
		 	$arr1 = array(
		    	'name'=> $date1,
		    	'slots'=> $slot
		    );
		 	array_push($time, $arr1);
		}
	 	
		$ERRMSG="DATE AND TIME SLOT FETCHED SUCCESSFULLY!";
        $ERRCODE='success'; 

	    return response()->json([
			'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG,
			'TIME'=>$time
		]);

    }



    public function get_cashfree_order(Request $request)
    {
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $authrization = $request->header('Authorization');
            $token='';
            $device_id='';
            $token1=explode('_',$authrization); 
            if(count($token1)==2)
            {
            $token=$token1[0];
            $device_id=$token1[1];
            }

            $txt_amount="";
            $txt_amount=$request->has('txt_amount')?'1':'0' ;
        
            if($token=='')
            {
                $ERRMSG = "Api Token should be valid or not blank.";
                $this->isError= TRUE;
                $ERRCODE="error";
                $userData ='';
            }
            elseif($request->input('txt_amount')=='')
            {
                $ERRMSG = "Amount should be valid or not blank.";
                $this->isError= TRUE;
                $ERRCODE="warning";
            }
            elseif($request->input('txt_amount') < 0)
            {
                $ERRMSG = "Amounts should be valid or not blank.";
                $this->isError= TRUE;
                $ERRCODE="warning";
            }
            else
            {
                $login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");

                if($login_detail)
                {
                    $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                    $ERRCODE="success";
                    $this->isError==FALSE;
                }
                else
                {
                    $ERRMSG = "USER DETAILS NOT FIND.";
                    $ERRCODE="error";
                    $this->isError= TRUE;
                    return response()->json([
                    'ERROR'=>$ERRCODE,
                    'MSG' =>$ERRMSG 
                    ]);
                }
            }
            
            if($this->isError==FALSE)
            {
                
                $url = 'https://api.cashfree.com/api/v2/cftoken/order';
                $amt = $request->input('txt_amount');
                $orderId = 'MAD-'.$login_detail[0]->RegId.time().rand(00,99).$amt;
                $data = [
                    'orderId' => $orderId, 
                    'orderAmount' => $amt, 
                    'orderCurrency' => 'INR',
                ];

                $response = Helper::cashfree_api_header($url, $data);

                $response = json_decode($response);
                $response->{'orderId'} = $orderId;
                $response->{'orderAmount'} = $amt;

                DB::table('tr31_online_payment_request')->insert(['request_rzp' =>json_encode($data),
                                                            'request_form' =>json_encode($request->all()),
                                                            'response' =>json_encode($response)
                                                                        ]);
                $responseData = [  
                            'm11_user_id' =>$login_detail[0]->RegId,
                            'm11_user_code' =>$login_detail[0]->RegCode,
                            'tr31_op_amount' =>$amt,
                            'tr31_op_currency' => 2,
                            'tr31_op_txnid' =>$orderId
                ];

                DB::table('tr31_online_payment')->insert($responseData);


                return response()->json($response);
            }
            else
            {
                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);
            }
        }
        else
        {
            $ERRMSG = "REQUEST IS NOT VALID";
            $ERRCODE="error";
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG 
            ]);
        }
    }


//for web
    public function payment_report(Request $request)
    { 
        $data = DB::table('online_payment')->where('op_txnid', $request->orderId)->first();
        if($data->op_paymentid == null && $data->op_gatewaytxn_id == null && $request->txStatus == 'SUCCESS')
        {
                    $fundtransfer_data=array(
                    'proc'=>8,
                    'to_user_id'=>$data->user_id,
                    'from_user_id'=>0,
                    'amount'=>floatval($request->orderAmount),
                    'collected_amount'=>floatval($request->orderAmount),
                    'requesttype'=>1,
                    'balfor'=>1,
                    'transtype'=>1,
                    'timelimit'=>60,
                    'defaultstatus'=>1,
                    'remark'=>"ONLINE PAYMENT",
                    'collected_remark'=>"ONLINE PAYMENT"
                    );

                    $fundtransfer = DB::SELECT('CALL wallettransfer(
                    :proc, 
                    :to_user_id,
                    :from_user_id,
                    :amount, 
                    :collected_amount,
                    :requesttype,
                    :balfor,:transtype,
                    :timelimit,
                    :defaultstatus,
                    :remark,
                    :collected_remark,
                    @status_code,
                    @status_msg)'
                    ,$fundtransfer_data);
                    $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
                    $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
                    $ERRCODE=$ERRCODE[0]->ERR_CODE;
                    $ERRMSG=$ERRMSG[0]->ERR_MSG;
                    $request['fundtransfer_error_code'] = $ERRCODE;
                    $request['fundtransfer_error_msg'] = $ERRMSG;
        }

        $responseData = [  
            'tr31_op_paymentid' =>$request->referenceId,
            'tr31_op_gatewaytxn_id' =>$request->signature,
            'tr31_op_gateway_res' =>json_encode($request->all()),
            'tr31_op_status' =>$request->txStatus,
        ];

        DB::table('tr31_online_payment')->where('tr31_op_txnid', $request->orderId)->update($responseData);

        $user_data = DB::table('online_payment')->where('op_txnid', $request->orderId)->first();

        $data = $request->all();

        return view('payment_success',compact('data','user_data'));
    }





    public function get_coupan_amounts($user_id)
    {   
        $USERCOUPAN = 0;
        if($user_id)
        {   
            $user = Helper::get_userdetail($user_id);
            $topup = DB::select("SELECT * FROM tr19_user_topup WHERE m11_user_id =".$user_id." ORDER BY tr19_user_tpid LIMIT 1");

            if(count($topup) > 0 && count($user) > 0)
            {
                $coupanamt = DB::table('m27_package')->where('m27_pack_id', $topup[0]->m27_pack_id)->first();
                
                if($coupanamt != '')
                {

                    $topupusethisamt=(float)$coupanamt->m27_coupan_amt/(float)config('TOPUP_DIVIDE_INMONTH');

                    $to = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', $topup[0]->tr19_topup_createdat);
                    $from = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', date('Y-m-d h:i:s'));
                    $diff_in_months = $to->diffInMonths($from);

                    if(config('TOPUP_AMO_DED') == 'YES')
                    {
                        $diff_in_months = 1;
                        if($diff_in_months > $topup[0]->tr19_coupan_noofuse)
                        {
                            $dedamt = ($diff_in_months-$topup[0]->tr19_coupan_noofuse)*$topupusethisamt;
                            $useamt = $topup[0]->tr19_coupan_useamt+$dedamt;
                            $noofuse = $topup[0]->tr19_coupan_noofuse+($diff_in_months-$topup[0]->tr19_coupan_noofuse);

                            DB::update("UPDATE `tr19_user_topup` SET `tr19_coupan_useamt` = ".$useamt.", `tr19_coupan_noofuse` = ".$noofuse." WHERE `tr19_user_tpid` = ".$topup[0]->tr19_user_tpid);
                        }
                    }

                    if(config('TOPUP_AMO_USER_INDAY') >=  date('d'))
                    {   

                        $user = Helper::get_userdetail($user_id);
                        $usercoupanamt = DB::select("SELECT COALESCE(SUM(tr03_cramount)-SUM(tr03_dramount),0) AS AMT FROM `tr03_manage_ledger` WHERE m11_user_id = ".$user_id." AND tr03_bal_type = 'COUPAN' AND tr03_ledger_type IN(25,23) AND DATE_FORMAT(tr03_trans_onadd,'%Y-%m') = DATE_FORMAT(NOW(),'%Y-%m')"); 

                        $total_usercoupanamt = DB::select("SELECT COALESCE(SUM(tr03_cramount)-SUM(tr03_dramount),0) AS AMT FROM `tr03_manage_ledger` WHERE m11_user_id = ".$user_id." AND tr03_bal_type = 'COUPAN' AND tr03_ledger_type IN(25,23)"); 

 
                        if((float)$total_usercoupanamt[0]->AMT > (float)$coupanamt->m27_coupan_amt)
                        {
                            $USERCOUPAN = 0;
                        }
                        else 
                        {
                            $USERCOUPAN = $topupusethisamt-(float)$usercoupanamt[0]->AMT;
                        }
                    }
                    else
                    {
                        $USERCOUPAN = 0;
                    } 
                }
            }
        }
        return $USERCOUPAN;
    }




//for web
    public function payment_reports($cartid, $addressid,Request $request)
    { 
        $data = DB::table('online_payment')->where('op_txnid',$request->orderId)->where('op_status','PENDING')->first();
        if($data)
        {
        if($data->op_paymentid == null && $data->op_gatewaytxn_id == null && $request->txStatus == 'SUCCESS')
        {

            $cart = $this->order_repo->getById(base64_decode($cartid));
            $carddata = json_decode($cart[0]->PRODUCT_DETAILS);
            $address = $this->address_repo->getById(base64_decode($addressid));
            $user = Helper::get_userdetail($cart[0]->USER_ID);

            $del = (float)$cart[0]->DELIVERY_FEE;
            $coupan = $this->get_coupan_amounts($cart[0]->USER_ID);
            $total =0;
            $coupans = 0;
            foreach($carddata as $value)
            {
                $total += $value->disc_price*$value->new_quantity;
            }
              
            if($coupan >= $del+$total)
            {
                $coupans = $del+$total;
                $toamt = 0.00;
            }
            else
            {
              $coupans = $coupan;
              $toamt = ($del+$total)-$coupan;  
            }

            $address = json_encode($address[0]);

            $fundtransfer_data=array(
                        'proc'=>2,
                        'to_user_id'=>$data->user_id,
                        'from_user_id'=>0,
                        'amount'=>floatval($toamt),
                        'collected_amount'=>floatval($toamt),
                        'requesttype'=>1,
                        'balfor'=>1,
                        'transtype'=>1,
                        'timelimit'=>900,
                        'defaultstatus'=>1,
                        'remark'=>"ONLINE PAYMENT FOR SOPING",
                        'collected_remark'=> str_replace("MAD-","", $request->orderId)
                    );

                    $fundtransfer = DB::SELECT('CALL wallettransfer(
                        :proc, 
                        :to_user_id,
                        :from_user_id,
                        :amount, 
                        :collected_amount,
                        :requesttype,
                        :balfor,
                        :transtype,
                        :timelimit,
                        :defaultstatus,
                        :remark,
                        :collected_remark,
                        @status_code,
                        @status_msg)'
                    ,$fundtransfer_data);

                    $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
                    $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');

                    $shoppingwallet=array(
                        'proc'=>9,
                        'to_user_id'=>$data->user_id,
                        'from_user_id'=>0,
                        'amount'=>floatval($del+$total), // total maount
                        'collected_amount'=>floatval($toamt), // if coupan amt avlable - total maount
                        'requesttype'=>1,
                        'balfor'=>1,
                        'transtype'=>1,
                        'timelimit'=>3000,
                        'defaultstatus'=>1,
                        'remark'=>"Shoping Payment",
                        'collected_remark'=>str_replace("MAD-","", $request->orderId)
                    );

                    $shopping_wallet = DB::SELECT('CALL wallettransfer(
                        :proc, 
                        :to_user_id,
                        :from_user_id,
                        :amount, 
                        :collected_amount,
                        :requesttype,
                        :balfor,
                        :transtype,
                        :timelimit,
                        :defaultstatus,
                        :remark,
                        :collected_remark,
                        @status_code,
                        @status_msg)'
                    ,$shoppingwallet);


                    $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
                    $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');

                    if($ERRCODE[0]->ERR_CODE == 'success')
                    {
                        $array = [
                            'tr36_cart_type' => 2, 
                            'tr36_order_datetime' => date('Y-m-d H:i:s'),
                            'tr36_payment_method' => 2,
                            'tr36_payment_status'=> 2, 
                            'tr36_order_status'=> 1,
                            'tr36_address_id'=> base64_decode($addressid),
                            'tr36_address_details'=> $address,
                            'tr03_manage_ledger_id'=> $ERRMSG[0]->ERR_MSG
                        ];

                        $data = $this->order_repo->update(base64_decode($cartid), $array);
                        $ERRMSG="USER ORDER PLACED SUCCESSFULLY!";
                        $ERRCODE='success'; 
                                       $responseData = [  
                            'tr31_op_paymentid' =>$request->referenceId,
                            'tr31_op_gatewaytxn_id' =>$request->signature,
                            'tr31_op_gateway_res' =>json_encode($request->all()),
                            'tr31_op_status' =>$request->txStatus,
                        ];

                        DB::table('tr31_online_payment')->where('tr31_op_txnid', $request->orderId)->update($responseData);

                        $categories = $this->cat_repo->getAllCategoryActive(); //category
                        $cart = $cart[0];
                        $user = Helper::get_userdetail($data->user_id);
                        $address = $this->address_repo->getById($cart->ADDRESS_ID);
                        return view('Front.order-confirm',compact('categories','cart','address','user'));
                        //return redirect('order_confirm/'.$cartid);
                    }
        }
        
        else{
        $responseData = [  
            'tr31_op_paymentid' =>$request->referenceId,
            'tr31_op_gatewaytxn_id' =>$request->signature,
            'tr31_op_gateway_res' =>json_encode($request->all()),
            'tr31_op_status' =>$request->txStatus,
        ];
        
        DB::table('tr31_online_payment')->where('tr31_op_txnid', $request->orderId)->update($responseData);
        }
        
}
        $user_data = DB::table('online_payment')->where('op_txnid', $request->orderId)->first();

        $data = $request->all();

        return view('payment_success',compact('data','user_data'));

    }





    //for app
    public function get_payment_info(Request $request)
    {   
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $authrization = $request->header('Authorization');
            $token='';
            $device_id='';
            $data = '';
            $token1=explode('_',$authrization); 
            if(count($token1)==2)
            {
            $token=$token1[0];
            $device_id=$token1[1];
            }

            $txt_amount="";
            $txt_amount=$request->has('orderId')?'1':'0' ;
        
            if($token=='')
            {
                $ERRMSG = "Api Token should be valid or not blank.";
                $this->isError= TRUE;
                $ERRCODE="error";
                $userData ='';
            }
            elseif($request->input('orderId')=='')
            {
                $ERRMSG = "orderId should be valid or not blank.";
                $this->isError= TRUE;
                $ERRCODE="warning";
            }
            elseif($request->input('orderId')!='')
            {
               $data = DB::table('online_payment')->where('op_txnid', $request->orderId)->first();
            }
            elseif($data == '')
            {

                $ERRMSG = "orderId info Not Found.";
                $this->isError= TRUE;
                $ERRCODE="warning";
            }
            else
            {
                $login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");

                if($login_detail)
                {
                    $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                    $ERRCODE="success";
                    $this->isError==FALSE;
                }
                else
                {
                    $ERRMSG = "USER DETAILS NOT FIND.";
                    $ERRCODE="error";
                    $this->isError= TRUE;
                    return response()->json([
                    'ERROR'=>$ERRCODE,
                    'MSG' =>$ERRMSG 
                    ]);
                }
            }
            
            if($this->isError==FALSE)
            {
                $ERRMSG = "Payment Not Transfer Successfully.";
                $ERRCODE=$request->txStatus;
                
                if($data->op_paymentid == null && $data->op_gatewaytxn_id == null && $request->txStatus == 'SUCCESS')
                {
                            $fundtransfer_data=array(
                            'proc'=>8,
                            'to_user_id'=>$data->user_id,
                            'from_user_id'=>0,
                            'amount'=>floatval($request->orderAmount),
                            'collected_amount'=>floatval($request->orderAmount),
                            'requesttype'=>1,
                            'balfor'=>1,
                            'transtype'=>1,
                            'timelimit'=>60,
                            'defaultstatus'=>1,
                            'remark'=>"ONLINE PAYMENT",
                            'collected_remark'=>"ONLINE PAYMENT"
                            );

                            $fundtransfer = DB::SELECT('CALL wallettransfer(
                            :proc, 
                            :to_user_id,
                            :from_user_id,
                            :amount, 
                            :collected_amount,
                            :requesttype,
                            :balfor,:transtype,
                            :timelimit,
                            :defaultstatus,
                            :remark,
                            :collected_remark,
                            @status_code,
                            @status_msg)'
                            ,$fundtransfer_data);
                            $ERRMSG=DB::select('SELECT @status_msg as ERR_MSG');
                            $ERRCODE=DB::select('SELECT @status_code as ERR_CODE');
                            $ERRCODE=$ERRCODE[0]->ERR_CODE;
                            $ERRMSG=$ERRMSG[0]->ERR_MSG;
                }

                $responseData = [  
                    'tr31_op_paymentid' =>$request->referenceId,
                    'tr31_op_gatewaytxn_id' =>$request->signature,
                    'tr31_op_gateway_res' =>json_encode($request->all()),
                    'tr31_op_status' =>$request->txStatus,
                ];

                DB::table('tr31_online_payment')->where('tr31_op_txnid', $request->orderId)->update($responseData);

                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);

            }
            else
            {
                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);
            }
        }
        else
        {
            $ERRMSG = "REQUEST IS NOT VALID";
            $ERRCODE="error";
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG 
            ]);
        }
    }


    public function get_coupan_amount()
    {
                $ERRMSG="CONFIG INFO FETCHED SUCCESSFULLY!";
                $ERRCODE='success'; 

                return response()->json([
                    'ERROR'=>$ERRCODE,
                    'MSG' =>$ERRMSG,
                    'TOPUP_DIVIDE_INMONTH'=> Config('TOPUP_DIVIDE_INMONTH'),
                    'TOPUP_AMO_USER_INDAY'=> Config('TOPUP_AMO_USER_INDAY'),
                    'DELIVERY_CHARGE'=> Config('DELIVERY_CHARGE'),
                    'DELIVERY_PRICE'=> Config('DELIVERY_PRICE'),
                    'APP_ID'=> config('APP_ID'),
                    'SECRETKEY'=> Config('SECRETKEY'),
                    'PAYOUT_APP_ID'=> config('PAYOUT_APP_ID'),
                    'PAYOUT_SECRETKEY'=> Config('PAYOUT_SECRETKEY')
                ]);
    }


    public function get_config_value(Request $request)
    {   
        if($_SERVER['REQUEST_METHOD']=="POST")
        {
            $authrization = $request->header('Authorization');
            $token='';
            $device_id='';
            $data = '';
            $token1=explode('_',$authrization); 
            if(count($token1)==2)
            {
            $token=$token1[0];
            $device_id=$token1[1];
            }

            if($token=='')
            {
                $ERRMSG = "Api Token should be valid or not blank.";
                $this->isError= TRUE;
                $ERRCODE="error";
                $userData ='';
            }
            else
            {
                $login_detail = DB::select("SELECT * FROM `api_enroll` WHERE `MemberApiToken`='".$token."' AND MemberStatus='Active'");

                if($login_detail)
                {
                    $ERRMSG = "USER DETAILS GET SUCCESSFULLY";
                    $ERRCODE="success";
                    $this->isError==FALSE;
                }
                else
                {
                    $ERRMSG = "USER DETAILS NOT FIND.";
                    $ERRCODE="error";
                    $this->isError= TRUE;
                    return response()->json([
                    'ERROR'=>$ERRCODE,
                    'MSG' =>$ERRMSG 
                    ]);
                }
            }
            
            if($this->isError==FALSE)
            {

                $USERCOUPAN = 0;
                if($login_detail[0]->RegId)
                {   
                    $user = Helper::get_userdetail($login_detail[0]->RegId);
                    $topup = DB::select("SELECT * FROM tr19_user_topup WHERE m11_user_id =".$login_detail[0]->RegId." ORDER BY tr19_user_tpid LIMIT 1");

                    if(count($topup) > 0 && count($user) > 0)
                    {
                        $coupanamt = DB::table('m27_package')->where('m27_pack_id', $topup[0]->m27_pack_id)->first();
                        
                        if($coupanamt != '')
                        {

                            $topupusethisamt=(float)$coupanamt->m27_coupan_amt/(float)config('TOPUP_DIVIDE_INMONTH');

                            $to = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', $topup[0]->tr19_topup_createdat);
                            $from = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', date('Y-m-d h:i:s'));
                            $diff_in_months = $to->diffInMonths($from);

                            if(config('TOPUP_AMO_DED') == 'YES')
                            {
                                $diff_in_months = 1;
                                if($diff_in_months > $topup[0]->tr19_coupan_noofuse)
                                {
                                    $dedamt = ($diff_in_months-$topup[0]->tr19_coupan_noofuse)*$topupusethisamt;
                                    $useamt = $topup[0]->tr19_coupan_useamt+$dedamt;
                                    $noofuse = $topup[0]->tr19_coupan_noofuse+($diff_in_months-$topup[0]->tr19_coupan_noofuse);

                                    DB::update("UPDATE `tr19_user_topup` SET `tr19_coupan_useamt` = ".$useamt.", `tr19_coupan_noofuse` = ".$noofuse." WHERE `tr19_user_tpid` = ".$topup[0]->tr19_user_tpid);
                                }
                            }

                            if(config('TOPUP_AMO_USER_INDAY') >=  date('d'))
                            {   

                                $user = Helper::get_userdetail($login_detail[0]->RegId);
                                $usercoupanamt = DB::select("SELECT COALESCE(SUM(tr03_dramount),0) AS AMT FROM `tr03_manage_ledger` WHERE m11_user_id = ".$login_detail[0]->RegId." AND tr03_bal_type = 'COUPAN' AND tr03_ledger_type = 'COUPAN REDEEM' AND DATE_FORMAT(tr03_trans_onadd,'%Y-%m') = DATE_FORMAT(NOW(),'%Y-%m')"); 

                                $total_usercoupanamt = DB::select("SELECT COALESCE(SUM(tr03_dramount),0) AS AMT FROM `tr03_manage_ledger` WHERE m11_user_id = ".$login_detail[0]->RegId." AND tr03_bal_type = 'COUPAN' AND tr03_ledger_type = 'COUPAN REDEEM'"); 

                                $USERCOUPAN = $topupusethisamt-(float)$usercoupanamt[0]->AMT;
                                if((float)$total_usercoupanamt[0]->AMT > (float)$coupanamt->m27_coupan_amt)
                                {
                                    $USERCOUPAN = 0;
                                }
                                else 
                                {
                                    $USERCOUPAN = $topupusethisamt-(float)$usercoupanamt[0]->AMT;
                                }

                            }
                            else
                            {
                                $USERCOUPAN = 0;
                            } 
                        }

                        $ERRMSG="CONFIG INFO FETCHED SUCCESSFULLY!";
                        $ERRCODE='success'; 

                        return response()->json([
                            'ERROR'=>$ERRCODE,
                            'MSG' =>$ERRMSG,
                            'TOPUP_DIVIDE_INMONTH'=> Config('TOPUP_DIVIDE_INMONTH'),
                            'TOPUP_AMO_USER_INDAY'=> Config('TOPUP_AMO_USER_INDAY'),
                            'DELIVERY_CHARGE'=> Config('DELIVERY_CHARGE'),
                            'DELIVERY_PRICE'=> Config('DELIVERY_PRICE'),
                            'APP_ID'=> config('APP_ID'),
                            'SECRETKEY'=> Config('SECRETKEY'),
                            'PAYOUT_APP_ID'=> config('PAYOUT_APP_ID'),
                            'PAYOUT_SECRETKEY'=> Config('PAYOUT_SECRETKEY'),
                            'USER_COUPAN_AMT'=> $USERCOUPAN,
                        ]);
                    }
                    else
                    {
                        $ERRMSG = 'user info not found';
                        $ERRCODE='warning';
                    }
                }
 

                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);

            }
            else
            {
                return response()->json([
                'ERROR'=>$ERRCODE,
                'MSG' =>$ERRMSG 
                ]);
            }
        }
        else
        {
            $ERRMSG = "REQUEST IS NOT VALID";
            $ERRCODE="error";
            return response()->json([
            'ERROR'=>$ERRCODE,
            'MSG' =>$ERRMSG 
            ]);
        }
    }



}